> /* The routines in this section solve for the mosfet device */C /* drain current and small signal parameters (e.g. the Jacobian) */  #include <stdio.h> #include <math.h>  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h" #include "ipstruct.h"  #include "mosdiode.h"    /*  ? * Compute Level 1 MOS currents and charges, but no derivatives.  */" rpm1(fptr, nvolt, current, charge)! double *current, *charge, *nvolt;  register struct fet1 *fptr;  { = double vgst, vds, vgs, vbs, vbd, id, ibs, ibd, qs, qd, dtemp;   register struct inm1model *mptr; register struct mosdiode *dptr;      mptr = fptr->mptr;  $ /* Compute the terminal voltages. */?   vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); C   if (vds < 0.0) { /* If vds < 0.0 swap drain and source  nodes. */      fet1swapds (fptr);A     vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);    } ?   vgs = mptr->type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); ?   vbs = mptr->type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);    vbd = vbs - vds;   /* First do the diodes. */   /* Junction diode Current. */    dptr = mptr->djunc; 2   mosrdiodei(ibd,vbd,fptr->isad,fptr->dvmax,dptr);2   mosrdiodei(ibs,vbs,fptr->isas,fptr->svmax,dptr);   /* Junction diode Charge. */   if(dcflag == FALSE) {    /* Junction diode. */ *     mosrdiodeq(qd, vbd, fptr->cjad, dptr);*     mosrdiodeq(qs, vbs, fptr->cjas, dptr);   /* Sidewall diode. */      dptr = mptr->dsw; ;     mosrdiodeq(dtemp, vbd, fptr->cjasd, dptr); qd += dtemp; ;     mosrdiodeq(dtemp, vbs, fptr->cjass, dptr); qs += dtemp; ?     if(fptr->dnode > 0) charge[fptr->dnode] -= mptr->type * qd; ?     if(fptr->snode > 0) charge[fptr->snode] -= mptr->type * qs; F     if(fptr->bnode > 0) charge[fptr->bnode] += mptr->type * (qs + qd);   }   $ /* Compute the Threshold voltage. */&   if(vbs==0.0) vgst = vgs - mptr->vto;   else {     vgst = mptr->phi - vbs; B     if(vgst < nrvabs) vgst = sqrt(nrvabs); else vgst = sqrt(vgst);7     vgst = vgs - (mptr->fixvto + (mptr->gamma * vgst));    }      /* Compute drain current. */1   if( ((fptr->dnode > 0) || (fptr->snode > 0)) && 7 			   (fptr->dnode != fptr->snode) && (vgst > 0.0 ) ) { N     if(vgst<vds) id= 0.5* fptr->beta * vgst * vgst * (1.0 + mptr->lambda*vds);G     else id = fptr->beta*vds*(vgst - 0.5*vds)*(1.0 + mptr->lambda*vds); H     if(fptr->dnode > 0) current[fptr->dnode] += mptr->type * (id - ibd);H     if(fptr->snode > 0) current[fptr->snode] -= mptr->type * (id + ibs);I     if(fptr->bnode > 0) current[fptr->bnode] += mptr->type * (ibd + ibs);    } %   else { /* Just stuff the diodes. */ I     if(fptr->bnode > 0) current[fptr->bnode] += mptr->type * (ibd + ibs); A     if(fptr->dnode > 0) current[fptr->dnode] -= mptr->type * ibd; A     if(fptr->snode > 0) current[fptr->snode] -= mptr->type * ibs;    }   6 /* Compute charges if oxide capacitance is nonzero. */5   if((dcflag == FALSE) && (mptr->nocharge == FALSE))  , 			justq(fptr, vgs, vbs, vds, vgst, charge);   }    /*? * Compute Level 1 Mosfet currents and charges with derivatives.  */+ putm1(fptr, nvolt, current, charge, alpha0) ) double *charge, *current, *nvolt, alpha0;  register struct fet1 *fptr;  { B double vds, vgs, vbs, vbd, vgst, ndvtdvbs, ids, gmgs, gmds, gmbs, 1 		gbs, gbd, ibs, ibd, temp1, temp2, temp3, temp4;   register struct inm1model *mptr; register struct mosdiode *dptr;   5 /* Stuff the pointer to the model into a register. */    mptr = fptr->mptr;  $ /* Compute the terminal voltages. */?   vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      fet1swapds(fptr);B      vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);   } ?   vgs = mptr->type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); ?   vbs = mptr->type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);    vbd = vbs - vds;   /* First do the diodes. */   dptr = mptr->djunc; 5   mosdiodei(gbs,ibs,vbs,fptr->isas,fptr->svmax,dptr); 5   mosdiodei(gbd,ibd,vbd,fptr->isad,fptr->dvmax,dptr);    /* Diode charges. */   if(dcflag == FALSE) { 2     if( (fptr->dnode > 0) || (fptr->bnode > 0) ) {I       dptr = mptr->djunc; mosdiodeq(temp1, temp2, vbd, fptr->cjad, dptr); H       dptr = mptr->dsw; mosdiodeq(temp3, temp4, vbd, fptr->cjasd, dptr);6       temp1 += temp3; temp1 *= alpha0; temp2 += temp4;       if(fptr->dnode > 0) { 2         charge[fptr->dnode] -= mptr->type * temp2;          *(fptr->matdd) += temp1;         if(fptr->bnode > 0) { 4           charge[fptr->bnode] += mptr->type * temp2;#           *(fptr->matbb) += temp1;  ;           *(fptr->matdb) -= temp1; *(fptr->matbd) -= temp1; 	         }        }        else {2         charge[fptr->bnode] += mptr->type * temp2;!         *(fptr->matbb) += temp1;         }      } 2     if( (fptr->snode > 0) || (fptr->bnode > 0) ) {I       dptr = mptr->djunc; mosdiodeq(temp1, temp2, vbs, fptr->cjas, dptr); I       dptr = mptr->djunc; mosdiodeq(temp3, temp4,vbs, fptr->cjass, dptr); 6       temp1 += temp3; temp1 *= alpha0; temp2 += temp4;       if(fptr->snode > 0) { 2         charge[fptr->snode] -= mptr->type * temp2;          *(fptr->matss) += temp1;         if(fptr->bnode > 0) { 4           charge[fptr->bnode] += mptr->type * temp2;#           *(fptr->matbb) += temp1;  ;           *(fptr->matsb) -= temp1; *(fptr->matbs) -= temp1; 	         }        } .       else { /* Must be just the bulk node. */2         charge[fptr->bnode] += mptr->type * temp2;!         *(fptr->matbb) += temp1;         }      }    }   $ /* Threshold voltage computation. */   if(vbs == 0.0) {     vgst = vgs - mptr->vto; =     ndvtdvbs = mptr->gamma / (mptr->sqrtphi + mptr->sqrtphi);    }    else {     ndvtdvbs = mptr->phi - vbs;      if(ndvtdvbs < nrvabs) { A       vgst = vgs - (mptr->fixvto + (mptr->gamma * sqrt(nrvabs)));        ndvtdvbs = 0.0;      } 
     else {!       ndvtdvbs =  sqrt(ndvtdvbs); =       vgst = vgs - (mptr->fixvto + (mptr->gamma * ndvtdvbs)); 5       ndvtdvbs = mptr->gamma / (ndvtdvbs + ndvtdvbs);      }    }     /* Compute the drain current. */2   if( ((fptr->dnode > 0) || (fptr->snode > 0)) && )       			(fptr->dnode != fptr->snode) &&         						(vgst > 0.0 )) {&     if(vgst < vds) { /* Saturation. */=       gmgs =  fptr->beta * (1 + (mptr->lambda * vds)) * vgst;        ids = 0.5 * gmgs * vgst;       gmbs = ndvtdvbs * gmgs; ;       gmds = 0.5 * fptr->beta * vgst * vgst * mptr->lambda;      }      else {  /* Linear region */ 4       gmgs =  fptr->beta * (1 + mptr->lambda * vds);-       ids = gmgs * vds * (vgst - 0.50 * vds); $       gmds = (gmgs * (vgst - vds)) +< 	    (fptr->beta * mptr->lambda * vds * (vgst - 0.5 * vds));       gmgs *= vds;       gmbs = ndvtdvbs * gmgs;      } ,   /* Stuff the currents and conductances. */     if(fptr->bnode > 0) { 7       current[fptr->bnode] += mptr->type * (ibd + ibs); #       *(fptr->matbb) += gbd + gbs;       } B     if(fptr->dnode > 0) { /* Put the drain row into the matrix. */%       *(fptr->matdd) += (gmds + gbd); 7       current[fptr->dnode] += mptr->type * (ids - ibd); N       if(fptr->bnode>0) { *(fptr->matdb) += gmbs - gbd; *(fptr->matbd) -=gbd;}/       if(fptr->gnode>0) *(fptr->matdg) += gmgs; ;       if(fptr->snode>0) *(fptr->matds) -= (gmgs+gmbs+gmds);      } C     if(fptr->snode > 0) { /* Put the source row into the matrix. */ 1       *(fptr->matss) += gmds + gmbs + gmgs + gbs; 7       current[fptr->snode] -= mptr->type * (ids + ibs); N       if(fptr->bnode>0) { *(fptr->matbs) -= gbs; *(fptr->matsb) -=(gbs+gmbs);}/       if(fptr->gnode>0) *(fptr->matsg) -= gmgs; /       if(fptr->dnode>0) *(fptr->matsd) -= gmds; 	     }        } -   else { /* Just stuff the diode currents. */      if(fptr->bnode > 0) { 7       current[fptr->bnode] += mptr->type * (ibd + ibs); #       *(fptr->matbb) += gbd + gbs;       } B     if(fptr->dnode > 0) { /* Put the drain row into the matrix. */       *(fptr->matdd) += gbd;/       current[fptr->dnode] -= mptr->type * ibd; I       if(fptr->bnode>0) { *(fptr->matdb) -= gbd; *(fptr->matbd) -= gbd; }      } C     if(fptr->snode > 0) { /* Put the source row into the matrix. */        *(fptr->matss) += gbs;/       current[fptr->snode] -= mptr->type * ibs; I       if(fptr->bnode>0) { *(fptr->matbs) -= gbs; *(fptr->matsb) -= gbs; } 	     }        }   $ /* Do the charge model if not dc. */5   if((dcflag == FALSE) && (mptr->nocharge == FALSE))  8   		compq(fptr,vgs,vbs,vds,vgst,ndvtdvbs,charge,alpha0); }    /*  D * Routine for swapping drain and source node when vds changes sign.  */ fet1swapds(fptr) register struct fet1 *fptr;  { 	 int temp;  double tempd, *ptempd;D   temp = fptr->dnode; fptr->dnode = fptr->snode; fptr->snode = temp;H   temp = fptr->dxnode; fptr->dxnode = fptr->sxnode; fptr->sxnode = temp;>   tempd = fptr->cgs; fptr->cgs = fptr->cgd; fptr->cgd = tempd;B   tempd = fptr->isas; fptr->isas = fptr->isad; fptr->isad = tempd;B   tempd = fptr->cjas; fptr->cjas = fptr->cjad; fptr->cjad = tempd;F   tempd = fptr->cjass; fptr->cjass = fptr->cjasd; fptr->cjasd = tempd;:   tempd = fptr->gs; fptr->gs = fptr->gd; fptr->gd = tempd;H   ptempd = fptr->matdd; fptr->matdd = fptr->matss; fptr->matss = ptempd;N   ptempd= fptr->matdxdx; fptr->matdxdx = fptr->matsxsx; fptr->matsxsx =ptempd;J   ptempd= fptr->matdxd; fptr->matdxd = fptr->matsxs; fptr->matsxs =ptempd;J   ptempd= fptr->matddx; fptr->matddx = fptr->matssx; fptr->matssx =ptempd;H   ptempd = fptr->matds; fptr->matds = fptr->matsd; fptr->matsd = ptempd;H   ptempd = fptr->matdg; fptr->matdg = fptr->matsg; fptr->matsg = ptempd;H   ptempd = fptr->matdb; fptr->matdb = fptr->matsb; fptr->matsb = ptempd;H   ptempd = fptr->matgd; fptr->matgd = fptr->matgs; fptr->matgs = ptempd;I   ptempd = fptr->matbd; fptr->matbd = fptr->matbs; fptr->matbs = ptempd;   }     * /* Routine to compute just the charges. */( justq(fptr, vgs, vbs, vds, vgst, charge) register struct fet1 *fptr; $ double vgs, vbs, vds, vgst, *charge; {   double qg, temp1, temp2, sqrt();  register struct inm1model *mptr;     mptr = fptr->mptr;  ( /* Calculate the oxide cap charges. */     if(fptr->cgsub != 0.0) {-     if(vgst < 0.0) { /* Subthresh or Accum */ 4       if( (fptr->gnode > 0) || (fptr->bnode > 0) ) {         temp1 = vgs - vbs;L         if(((mptr->gamma>0.0)&&(temp1 >= mptr->vfb)) || (temp1<mptr->vfb)) {G           if(temp1 < mptr->vfb) qg = fptr->cgsub * (temp1 - mptr->vfb); 5           else qg = 0.5 * mptr->gamma * fptr->cgsub * G             ( sqrt(mptr->gamma * mptr->gamma + 4.0*(temp1 - mptr->vfb))  						        - mptr->gamma );	         }          else qg = 0.0;       } O       if(fptr->snode > 0) charge[fptr->snode] -= mptr->type *(fptr->cgs * vgs); =       if(fptr->gnode > 0) charge[fptr->gnode] += mptr->type * H 	(fptr->cgd * (vgs-vds) + fptr->cgs * vgs + fptr->cgb * (vgs-vbs) + qg);>       if(fptr->dnode > 0) charge[fptr->dnode] += mptr->type *  							fptr->cgd * (vds-vgs); =       if(fptr->bnode > 0) charge[fptr->bnode] += mptr->type * $ 	 					(fptr->cgb * (vbs-vgs) - qg);     } 2     else if(vgst < vds) { /* Saturation region. */=       if(fptr->snode > 0) charge[fptr->snode] -= mptr->type * / 			 (fptr->cgs * vgs + fptr->cgsub * vgst/1.5); =       if(fptr->gnode > 0) charge[fptr->gnode] += mptr->type * F 	  ( fptr->cgd * (vgs-vds) + fptr->cgs * vgs + fptr->cgb * (vgs-vbs) +3 			fptr->cgsub * (vgs - mptr->fixvto - vgst/3.0) ); >       if(fptr->dnode > 0) charge[fptr->dnode] += mptr->type *  							fptr->cgd * (vds-vgs); =       if(fptr->bnode > 0) charge[fptr->bnode] += mptr->type * H 	 ( fptr->cgb * (vbs-vgs) + fptr->cgsub * (vgst - vgs + mptr->fixvto) );     }      else { /* Linear Region. */ 8       temp1 = (vds * vds) / (vgst + vgst - vds + 1e-12);=       if(fptr->snode > 0) charge[fptr->snode] -= mptr->type *  	 ( fptr->cgs * vgs - 7 		fptr->cgsub * ((temp1/12.0)-(0.25*vds)-(0.5*vgst)) ); =       if(fptr->gnode > 0) charge[fptr->gnode] += mptr->type * F 	  ( fptr->cgd * (vgs-vds) + fptr->cgs * vgs + fptr->cgb * (vgs-vbs) +? 		fptr->cgsub * (vgs - mptr->fixvto - (0.5*vds)+(temp1/6.0)) ); >       if(fptr->dnode > 0) charge[fptr->dnode] += mptr->type *  	  ( (fptr->cgd * (vds-vgs)) +; 		fptr->cgsub * ((0.75*vds) - (0.5*vgst) - (0.25*temp1)) ); =       if(fptr->bnode > 0) charge[fptr->bnode] += mptr->type *  	  ( fptr->cgb * (vbs-vgs) +. 		fptr->cgsub * (vgst - vgs + mptr->fixvto) );     }    } /   else { /* Just stuff linear caps into rhs. */ ;     if(fptr->dnode > 0) charge[fptr->dnode] -= mptr->type *  						(fptr->cgd * (vgs-vds));;     if(fptr->gnode > 0) charge[fptr->gnode] += mptr->type * E 	  (fptr->cgd * (vgs-vds) + fptr->cgs * vgs + fptr->cgb * (vgs-vbs)); ;     if(fptr->snode > 0) charge[fptr->snode] -= mptr->type *        						 (fptr->cgs * vgs); <     if(fptr->bnode > 0) charge[fptr->bnode] -= mptr->type * %       						 (fptr->cgb * (vgs-vbs));    }  }    /*  / * Computes the gate charge and the derivatives.  */3 compq(fptr,vgs,vbs,vds,vgst,ndvtdvbs,charge,alpha0)  register struct fet1 *fptr; 6 double vgs, vbs, vds, vgst, ndvtdvbs, alpha0, *charge; { ? double qg, dqdvds, dqdvgst, temp1, temp2, temp3, temp4, sqrt();   register struct inm1model *mptr;     mptr = fptr->mptr;  % /* First the overlap capacitances. */    if(fptr->gnode > 0) { (     charge[fptr->gnode] += mptr->type * H       (fptr->cgd * (vgs-vds) + fptr->cgs * vgs + fptr->cgb * (vgs-vbs));C     *(fptr->matgg) += alpha0 * (fptr->cgs + fptr->cgd + fptr->cgb);      if(fptr->snode > 0) { !       temp1 = alpha0 * fptr->cgs; :       charge[fptr->snode] -= mptr->type * fptr->cgs * vgs;N       *(fptr->matss) += temp1; *(fptr->matsg) -=temp1; *(fptr->matgs) -=temp1;     }      if(fptr->bnode > 0) { !       temp1 = alpha0 * fptr->cgb; B       charge[fptr->bnode] -= mptr->type * fptr->cgb * (vgs - vbs);N       *(fptr->matbb) += temp1; *(fptr->matbg) -=temp1; *(fptr->matgb) -=temp1;     }      if(fptr->dnode > 0) { !       temp1 = alpha0 * fptr->cgd; B       charge[fptr->dnode] -= mptr->type * fptr->cgd * (vgs - vds);N       *(fptr->matdd) += temp1; *(fptr->matdg) -=temp1; *(fptr->matgd) -=temp1;     }    }    else {     if(fptr->snode > 0) { +       *(fptr->matss) += alpha0 * fptr->cgs; :       charge[fptr->snode] -= mptr->type * fptr->cgs * vgs;     }      if(fptr->bnode > 0) { +       *(fptr->matbb) += alpha0 * fptr->cgb; B       charge[fptr->bnode] -= mptr->type * fptr->cgb * (vgs - vbs);     }      if(fptr->dnode > 0) { +       *(fptr->matdd) += alpha0 * fptr->cgd; B       charge[fptr->dnode] -= mptr->type * fptr->cgd * (vgs - vds);     }    }   + /* Then the nonlinear oxide capacitance. */    if(fptr->cgsub != 0.0) {6     if(vgst < 0.0) { /* Subthresh or Accum region.  */4       if( (fptr->gnode > 0) || (fptr->bnode > 0) ) {-         temp1 = vgs - vbs; /* compute vgb. */ L         if(((mptr->gamma>0.0)&&(temp1 >= mptr->vfb)) || (temp1<mptr->vfb)) {9           if(temp1 <= mptr->vfb) {    /* Accumulation. */ @             qg = mptr->type * fptr->cgsub * (temp1 - mptr->vfb);)             temp1 = fptr->cgsub * alpha0;            } (           else {		      /* Subthresh. */N             temp1 = sqrt(mptr->gamma * mptr->gamma + 4.0*(temp1 - mptr->vfb));             qg = mptr->type * : 		0.5 * mptr->gamma * fptr->cgsub * (temp1 - mptr->gamma);A             temp1 = (alpha0 * mptr->gamma * fptr->cgsub) / temp1;            }            if(fptr->gnode > 0) { ?             charge[fptr->gnode] += qg; *(fptr->matgg) += temp1; !             if(fptr->bnode > 0) { B               charge[fptr->bnode] -= qg;  *(fptr->matbb) += temp1;?               *(fptr->matgb) -= temp1; *(fptr->matbg) -= temp1; 
             }            } F           else { charge[fptr->bnode] -= qg; *(fptr->matbb) += temp1; }	         }        }      }   2     else if(vgst < vds) { /* Saturation region. */       temp1 = fptr->cgsub/1.5;       temp2 = alpha0 * temp1; .       if(fptr->gnode > 0) { /* Gate charge. */+         charge[fptr->gnode] += mptr->type * 3   			fptr->cgsub*(vgs - mptr->fixvto - (vgst/3.0));           *(fptr->matgg) += temp2;A         if(fptr->bnode > 0) *(fptr->matgb) -= 0.5*temp2*ndvtdvbs; I         if(fptr->snode > 0) *(fptr->matgs) += 0.5*temp2*ndvtdvbs - temp2;        }        if(fptr->snode > 0) { ;         charge[fptr->snode] -= mptr->type * (temp1 * vgst); 5         *(fptr->matss) += (temp2 + temp2 * ndvtdvbs); 4         if(fptr->gnode > 0) *(fptr->matsg) -= temp2;A         if(fptr->bnode > 0) *(fptr->matsb) -= (temp2 * ndvtdvbs);        }        if(fptr->bnode > 0) { +         charge[fptr->bnode] += mptr->type * , 		fptr->cgsub * (vgst - vgs + mptr->fixvto);1         *(fptr->matbb) += 1.5 * temp2 * ndvtdvbs; E         if(fptr->snode > 0) *(fptr->matbs) -= 1.5 * temp2 * ndvtdvbs;        }	     }       else { /* Linear Region. */	0       temp1 = 1.0 / (vgst + vgst - vds + 1e-12);       temp2 = temp1*temp1*vds;       temp3 = vds*vds*temp1;#       temp1 = alpha0 * fptr->cgsub; .       if(fptr->gnode > 0) { /* Gate charge. */+         charge[fptr->gnode] += mptr->type * F   	     fptr->cgsub * (vgs - mptr->fixvto - (0.5*vds) + (temp3/6.0) );:         dqdvds = temp1*((temp2*(4.0*vgst-vds)/6.0) - 0.5);)         dqdvgst = -temp1*(vds*temp2/3.0); ,         *(fptr->matgg) += (temp1 + dqdvgst);5         if(fptr->dnode > 0) *(fptr->matgd) += dqdvds; A         if(fptr->bnode > 0) *(fptr->matgb) += dqdvgst * ndvtdvbs; -         if(fptr->snode > 0) *(fptr->matgs) -= / 			(temp1 + dqdvds + dqdvgst*(1.0 + ndvtdvbs));        } /       if(fptr->dnode > 0) { /* Drain charge. */ +         charge[fptr->dnode] += mptr->type * =   		fptr->cgsub * ( (0.75*vds) - (0.5*vgst) - (0.25*temp3) ); B         dqdvds = temp1 * ( 0.75 - 0.25 * (temp2*(4.0*vgst-vds)) );0         dqdvgst = temp1 * (0.5*vds*temp2 - 0.5);!         *(fptr->matdd) += dqdvds; L         if(fptr->snode > 0) *(fptr->matds) -= dqdvds+dqdvgst*(1.0+ndvtdvbs);6         if(fptr->gnode > 0) *(fptr->matdg) += dqdvgst;A         if(fptr->bnode > 0) *(fptr->matdb) += dqdvgst * ndvtdvbs;        } 0       if(fptr->snode > 0) { /* Source charge. */+         charge[fptr->snode] += mptr->type * B 	    fptr->cgsub * ( (temp3/12.0) - (0.25 * vds) - (0.5 * vgst) );@         dqdvds = temp1 * ( (temp2*(4.0*vgst-vds)/12.0) - 0.25 );7         dqdvgst = temp1 * ( (vds*temp2)/(-6.0) - 0.5 ); <         *(fptr->matss) -= dqdvgst*(1.0 + ndvtdvbs) + dqdvds;6         if(fptr->gnode > 0) *(fptr->matsg) += dqdvgst;5         if(fptr->dnode > 0) *(fptr->matsd) += dqdvds; A         if(fptr->bnode > 0) *(fptr->matsb) += dqdvgst * ndvtdvbs;        } .       if(fptr->bnode > 0) { /* Bulk charge. */+         charge[fptr->bnode] += mptr->type * .   		fptr->cgsub * (vgst - vgs + mptr->fixvto);,         *(fptr->matbb) +=  temp1 * ndvtdvbs;?         if(fptr->snode > 0) *(fptr->matbs) -= temp1 * ndvtdvbs;        }      }    }  }    stuffm1(devptr)  struct device *devptr; {  struct fet1 *fptr; double temp;  (   fptr = (struct fet1 *) devptr->devptr;  #   adddevarray(devptr, fptr->dnode);   B   if(fptr->gnode != fptr->dnode) adddevarray(devptr, fptr->gnode);  &   if( (fptr->snode != fptr->dnode) && G       (fptr->snode != fptr->gnode) )  adddevarray(devptr, fptr->snode);   &   if( (fptr->bnode != fptr->dnode) && %       (fptr->bnode != fptr->gnode) && G       (fptr->bnode != fptr->snode) )  adddevarray(devptr, fptr->bnode);    }   F /* Initialize the fet for simulation.  This includes converting the */F /* node numbers, deciding the evaluation function, and initializing */ /* the matrix pointers. */( struct device *fet1init(subptr, extfptr) struct fet1 *extfptr;  struct subcircuit *subptr; { # struct device *devptr, *m1getmat();  struct fet1 *fptr; int j, disfet1();   C /* Only copy the FET model if it has more than a gate in subckt. */ 4 /* or the oxide capacitance is not equal to zero. */7   if( ((extfptr->cgsub==0.0) && (extfptr->cgs==0.0) &&  1 			(extfptr->cgd==0.0) && (extfptr->cgb==0.0)) ||  							 (dcflag == TRUE) ) {/     if( (nomapchk(subptr,extfptr->snode) <= 0)  * 	&& (nomapchk(subptr,extfptr->dnode) <= 0)A         && (nomapchk(subptr,extfptr->bnode) <= 0) ) return(NULL);    }   ,   if( (nomapchk(subptr,extfptr->snode) > 0) ) 	|| (nomapchk(subptr,extfptr->dnode) > 0) 2         || (nomapchk(subptr,extfptr->bnode) > 0) ) 		subptr->nummosmodels++; > /* Allocate a device, copy the external fet, map the nodes. */>   devptr = (struct device *) ralloc(1, sizeof(struct device));   devptr->utype = FET1; ;   devptr->devptr = (char *) ralloc(1, sizeof(struct fet1)); (   fptr = (struct fet1 *) devptr->devptr;  - /* Copy the external fet to the local fet. */ -    bcopy(extfptr, fptr, sizeof(struct fet1));   L /* Do the node conversion from global node numbers to subcircuit numbers. *//   fptr->dnode = chksubnode(subptr,fptr->dnode); /   fptr->snode = chksubnode(subptr,fptr->snode); /   fptr->gnode = chksubnode(subptr,fptr->gnode); /   fptr->bnode = chksubnode(subptr,fptr->bnode);   ! /* Debugging Display function. */    devptr->display = disfet1;  ( /* Decide on the evaluation function. *//   devptr->eval = putm1; devptr->rhseval = rpm1;   3 /* Stuff in the matrix element grabbing routine. */    devptr->initdev = m1getmat;   J /* Turn off mosfet diodes not in this subcircuit or to connected nodes. */N   if( ((fptr->bnode<=0)&&(fptr->dnode<=0)) || (fptr->bnode == fptr->dnode) ) {:     fptr->isad = 0.0; fptr->cjad = 0.0; fptr->cjasd = 0.0;   } N   if( ((fptr->bnode<=0)&&(fptr->snode<=0)) || (fptr->bnode == fptr->snode) ) {:     fptr->isas = 0.0; fptr->cjas = 0.0; fptr->cjass = 0.0;   }      return(devptr);  }    /*? * Stuffs pointers to matrix elements into the device structure.  */% struct device *m1getmat(fptr, subptr)  struct subcircuit *subptr; struct fet1 *fptr; {  double *getmat(); 7   fptr->matdd = getmat(fptr->dnode,fptr->dnode,subptr); 7   fptr->matdg = getmat(fptr->dnode,fptr->gnode,subptr); 7   fptr->matds = getmat(fptr->dnode,fptr->snode,subptr); 7   fptr->matdb = getmat(fptr->dnode,fptr->bnode,subptr);   7   fptr->matss = getmat(fptr->snode,fptr->snode,subptr); 7   fptr->matsd = getmat(fptr->snode,fptr->dnode,subptr); 7   fptr->matsg = getmat(fptr->snode,fptr->gnode,subptr); 7   fptr->matsb = getmat(fptr->snode,fptr->bnode,subptr);   7   fptr->matbb = getmat(fptr->bnode,fptr->bnode,subptr); 7   fptr->matbg = getmat(fptr->bnode,fptr->gnode,subptr); 7   fptr->matbs = getmat(fptr->bnode,fptr->snode,subptr); 7   fptr->matbd = getmat(fptr->bnode,fptr->dnode,subptr);   H /* The following matrix terms are nonzero only in transient analysis. */   if(dcflag == FALSE) { 9     fptr->matgg = getmat(fptr->gnode,fptr->gnode,subptr); 9     fptr->matgs = getmat(fptr->gnode,fptr->snode,subptr); 9     fptr->matgd = getmat(fptr->gnode,fptr->dnode,subptr); 9     fptr->matgb = getmat(fptr->gnode,fptr->bnode,subptr);    }  }    finishmod1(mptr) struct inm1model *mptr;  {  double sqrt(); struct indmodel *pd;"   mptr->sqrtphi = sqrt(mptr->phi);,   if(mptr->type == PMOS) mptr->vto *= -1.0; ;   mptr->fixvto = mptr->vto - (mptr->gamma * mptr->sqrtphi); '   mptr->vfb = mptr->fixvto - mptr->phi; 1 /* Mosfet diode parameters. S is for sidewall. */ G   mptr->djunc = (struct mosdiode *) ralloc(1, sizeof(struct mosdiode)); F   finishmosd(mptr->pb, mptr->mj, mptr->fc, mptr->vtherm, mptr->djunc);E   mptr->dsw = (struct mosdiode *) ralloc(1, sizeof(struct mosdiode)); F   finishmosd(mptr->pb, mptr->mjsw, mptr->fc, mptr->vtherm, mptr->dsw);/   if((mptr->cgso == 0.0)&&(mptr->cgdo == 0.0)&& A 		(mptr->cgbo == 0.0)&&(mptr->tox == 0.0)) mptr->nocharge = TRUE;  }   > struct device *iprm1(nextdev,netlist,numparams,paramlist,mptr) struct device *nextdev;  int netlist[], numparams;  ip_param paramlist[];  struct inm1model *mptr;  { % struct device *fet1init(), *addcap();  struct fet1 *fptr; int i; double w,l,as,ad,ps,pd;    /* Allocate the device. */   nextdev->utype = FET1;   nextdev->flag = 0;   nextdev->initdev = fet1init;   nextdev->stuffdev = stuffm1;<   nextdev->devptr = (char *) ralloc(1, sizeof(struct fet1));)   fptr = (struct fet1 *) nextdev->devptr; E   nextdev->next = (struct device *) ralloc(1, sizeof(struct device));    nextdev = nextdev->next;   nextdev->next = NULL;    /* Get the node numbers. */    fptr->dnode = netlist[0];    fptr->gnode = netlist[1];    fptr->snode = netlist[2];    fptr->bnode = netlist[3];   ) /* Initialize the instance parameters. */    w = mptr->width;   l = mptr->length;    as = mptr->as;   ad = mptr->ad;   ps = mptr->ps;   pd = mptr->pd;  - /* Get the length, width params, if given. */     for(i=0; i < numparams; i++) {      switch(paramlist[i].id[0]) {3       case 'a'  : w = pareval(paramlist[i]); break; 3       case 'b'  : l = pareval(paramlist[i]); break; 4       case 'c'  : as = pareval(paramlist[i]); break;4       case 'd'  : ad = pareval(paramlist[i]); break;4       case 'e'  : ps = pareval(paramlist[i]); break;4       case 'f'  : pd = pareval(paramlist[i]); break;E       default   : printf("Nonexist param spec'ed for m1\n"); exit(0);      }    }   ( /* Adjust l due to lateral diffusion. */   l -= 2.0 * mptr->ld;   if(l <= 0.0) {C     printf("Mosfet length smaller than 2 * lateral diffusion!!\n");      exit(0);   }    /* Set the model field. */   fptr->mptr = mptr;    /* Precompute Beta, w/l * kp. */"   fptr->beta = mptr->kp * (w / l);   /* Charge model parameters. */I   if(mptr->tox != 0.0) fptr->cgsub = (w * l) * (EOX * 100.0) / mptr->tox;    else fptr->cgsub =0.0;   fptr->cgs = mptr->cgso * w;    fptr->cgd = mptr->cgdo * w;    fptr->cgb = mptr->cgbo * l;   ; /* Diode parameters. Make sure diodes have nonzero Is's. */    fptr->isad = mptr->js * ad;    fptr->isas = mptr->js * as; .   if(fptr->isas == 0.0) fptr->isas = mptr->is;%   if(fptr->isas!= 0.0) fptr->svmax =  6 		log(mptr->djunc->imax/fptr->isas) * mptr->djunc->vt;.   if(fptr->isad == 0.0) fptr->isad = mptr->is;%   if(fptr->isad !=0.0) fptr->dvmax =  6 		log(mptr->djunc->imax/fptr->isad) * mptr->djunc->vt;   fptr->cjas = as * mptr->cj;    fptr->cjad = ad * mptr->cj;     fptr->cjass = ps * mptr->cjsw;    fptr->cjasd = pd * mptr->cjsw;  : /* Return the pointer to the pointer to the next entry. */   return(nextdev); }    /* * Read the level 1 fet model.  */( char *ipm1rm(type, numparams, paramlist) double type; int numparams; ip_param *paramlist; {  struct allmod *modptr; struct inm1model *fptr;  struct device *iprm1(); 
 double tempd;  int i;  # /* Allocate space for the model. */ >   modptr = (struct allmod *) ralloc(1, sizeof(struct allmod));B   fptr = (struct inm1model *) ralloc(1, sizeof(struct inm1model));   modptr->type = FET1;   modptr->dev = (char *) fptr;   modptr->readdev = iprm1;  /* Put in the model defaults. */9   fptr->width = 1.0;  fptr->length = 1.0; fptr->ld = 0.0; B   fptr->as = 0.0; fptr->ad = 0.0; fptr->ps = 0.0; fptr->pd = 0.0; :   fptr->gamma = 0.0; fptr->phi = 0.6;  fptr->lambda = 0.0;&   fptr->vto = 0.0; fptr->kp = 20.0e-5;H   fptr->tox = 0.0; fptr->cgdo = 0.0; fptr->cgso = 0.0; fptr->cgbo = 0.0;E   fptr->cj = 0.0; fptr->cjsw = 0.0; fptr->mj = 0.5; fptr->mjsw = 0.5; A   fptr->pb = 0.8; fptr->fc = 0.5; fptr->js = 0.0; fptr->is = 0.0;    fptr->vtherm = VTHERM;+ /* Put in the passed type, nmos or pmos. */    fptr->type = (double) type;  /* Read in the model. */    for(i=0; i < numparams; i++) {I     switch(paramlist[i].id[0]) {  /* switch on first char in param id. */ 7 	case 'a' : fptr->width = pareval(paramlist[i]); break; 8 	case 'b' : fptr->length = pareval(paramlist[i]); break;4 	case 'c' : fptr->as = pareval(paramlist[i]); break;4 	case 'd' : fptr->ad = pareval(paramlist[i]); break;4 	case 'e' : fptr->ps = pareval(paramlist[i]); break;4 	case 'f' : fptr->pd = pareval(paramlist[i]); break;7 	case 'g' : fptr->gamma = pareval(paramlist[i]); break; 5 	case 'h' : fptr->phi = pareval(paramlist[i]); break; 8 	case 'i' : fptr->lambda = pareval(paramlist[i]); break;5 	case 'j' : fptr->vto = pareval(paramlist[i]); break; 4 	case 'k' : fptr->kp = pareval(paramlist[i]); break;5 	case 'l' : fptr->tox = pareval(paramlist[i]); break; 6 	case 'm' : fptr->cgso = pareval(paramlist[i]); break;6 	case 'n' : fptr->cgdo = pareval(paramlist[i]); break;6 	case 'o' : fptr->cgbo = pareval(paramlist[i]); break;4 	case 'p' : fptr->fc = pareval(paramlist[i]); break;4 	case 'q' : fptr->js = pareval(paramlist[i]); break;4 	case 'r' : fptr->mj = pareval(paramlist[i]); break;6 	case 's' : fptr->mjsw = pareval(paramlist[i]); break;4 	case 't' : fptr->cj = pareval(paramlist[i]); break;6 	case 'u' : fptr->cjsw = pareval(paramlist[i]); break;4 	case 'v' : fptr->pb = pareval(paramlist[i]); break;4 	case 'w' : fptr->is = pareval(paramlist[i]); break;4 	case 'x' : fptr->ld = pareval(paramlist[i]); break;     }    } # /* Check that phi is reasonable. */    if(fptr->phi <= 0.0) {J     printf("Fet model phi = %g must be positive, 0.6 used.\n", fptr->phi);     fptr->phi = 0.6;     ip_fatal_errors++;   }    finishmod1(fptr);    return((char *) modptr); }       
 disfet1(fptr)  struct fet1 *fptr; {  struct inm1model *mptr;    mptr = fptr->mptr;)   printf("type=%g,d=%d,g=%d,s=%d,b=%d ",  C 	     mptr->type,fptr->dnode,fptr->gnode, fptr->snode,fptr->bnode); L   printf("beta=%g, vto=%g fixvto=%g\n", fptr->beta, mptr->vto,mptr->fixvto);L   printf("gamma=%g phi=%g lambda=%g\n", mptr->gamma,mptr->phi,mptr->lambda);>   printf("sqrtphi=%g cgsub=%g\n", mptr->sqrtphi, fptr->cgsub);D   printf("cgs=%g cgd=%g cgb=%g\n", fptr->cgs, fptr->cgd, fptr->cgb);.   printf("isas=%g isad=%g cjas=%g cjad=%g\n", 3 			fptr->isas, fptr->isad, fptr->cjas, fptr->cjad); ;   printf("cjass=%g, cjasd=%g\n", fptr->cjass, fptr->cjasd); +   printf("svmax=%g dvmax=%g gs=%g gd=%g\n", 1 		 fptr->svmax, fptr->dvmax, fptr->gs, fptr->gd);  }      testm1(fptr) struct fet1 *fptr; { 7 double current[5], current2[5], nodevolt[5], charge[5]; & double dummy, vbs, vgs, vds, compgmgs;0 double gmgs, gds, gdb, gdd, gsd, gsb, gss, gmsg; double gmbg, gbs, gbd, gbb;  int dnode, snode, bnode, gnode; & double *temp1, *temp2, *temp3, *temp4;& double *temp5, *temp6, *temp7, *temp8;) double *temp9, *temp10, *temp11, *temp12; 	 int i, j;   '   dnode = fptr->dnode; fptr->dnode = 1; '   snode = fptr->snode; fptr->snode = 2; '   bnode = fptr->bnode; fptr->bnode = 3; '   gnode = fptr->gnode; fptr->gnode = 4;   +   temp1 = fptr->matdg; fptr->matdg = &gmgs; *   temp2 = fptr->matds; fptr->matds = &gds;*   temp3 = fptr->matdb; fptr->matdb = &gdb;*   temp4 = fptr->matdd; fptr->matdd = &gdd;  +   temp5 = fptr->matsg; fptr->matsg = &gmsg; *   temp6 = fptr->matsd; fptr->matsd = &gsd;*   temp7 = fptr->matsb; fptr->matsb = &gsb;*   temp8 = fptr->matss; fptr->matss = &gss;  +   temp9 = fptr->matbg; fptr->matbg = &gmbg; +   temp10 = fptr->matbd; fptr->matbd = &gbd; +   temp11 = fptr->matbs; fptr->matbs = &gbs; +   temp12 = fptr->matbb; fptr->matbb = &gbb;     !   for(i=0; i <= 10000; i += 20) {      nodevolt[4] = i * 0.001;     nodevolt[3] = 0.0;     nodevolt[2] = 0.0;     nodevolt[1] = 5.0;     nodevolt[0] = 0.0;     A     for(j=1; j < 5; j++) { current2[j] = 0.0; current[j] = 0.0; } 0     gmgs = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0;0     gmsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0;0     gmbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0;  9     putm1(fptr, nodevolt, current, charge, (double) 1.0);   0     gmgs = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0;0     gmsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0;0     gmbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0;     nodevolt[4] += 0.01;:     putm1(fptr, nodevolt, current2, charge, (double) 1.0);  /     compgmgs = (current2[1] - current[1])/0.01;   8     printf("vgs=%g oldid=%g id=%g is=%g ib=%g ig=%g\n", 7 		(nodevolt[4] - nodevolt[2]), current2[1], current[1], ) 				 current[2], current[3], current[4]); 4     printf("gmgs=%g compgmgs=%g\n", gmgs, compgmgs);   }      fptr->dnode = dnode;   fptr->snode = snode;   fptr->bnode = bnode;   fptr->gnode = gnode;     fptr->matdg = temp1;   fptr->matsg = temp2;   } 