 /* Mos Level 3 Mosfet Model. */  #include <stdio.h> #include <math.h>  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h" #include "ipstruct.h"  #include "mosdiode.h"     /* Mos level Three constants. */% #define TWOTHIRDS 0.66666666666666666    #define CKTTEMP 27.0  0 double SQRTof2 = 1.414213562;		/* sqrt of 2.0 */3 double	PIover2 = 1.570796327;  	/* value of PI/2 */ : double	BOLTZoverQ = 8.61708638e-5;	/* Boltzmann/charge  */5 double	CHARGE = 1.6021918e-19;		/* electron charge */ . double	CtoK = 273.15 ;			/* Cent. to Faren. */8 double	EPSSIL = 1.035943e-10;		/* permitt. of silicon */5 double	EPSOX = 3.453143e-11;		/* permitt. of oxide */    /* other needed constants */ double OMEGA = 8.15e-22;> double EXPLIMIT = -85.0;  		/* don't do exp(-85) or smaller */! double FET3_GMIN = 1.0e-12;         : /* plane to cylindrical coordinate conversion constants */ double D0 = 0.0631353; double D1 = 0.8013292; double D2 = -0.01110777;  ? /* Compute the MOS currents and charges, but no derivatives. */ " rpm3(fptr, nvolt, current, charge)! double *current, *charge, *nvolt;  register struct fet3 *fptr;  { < double vttmp, type, dvthdvbs, vds, vgs, vbs, ir, m3justid();     type = fptr->mptr->type;$ /* Compute the terminal voltages. */9   vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); C   if (vds < 0.0) { /* If vds < 0.0 swap drain and source  nodes. */      m3swapds (fptr);;     vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);    } 9   vgs = type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); 9   vbs = type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);   D /* Compute drain currents and gate, drain, src, and bulk charges. */1   vttmp = m3justid(fptr, vgs, vbs, vds, current); =   if(dcflag == FALSE) m3justq(fptr,vgs,vbs,vds,vttmp,charge);   * /* Finally, put in parasitic resistors. */#   if(fptr->sxnode != fptr->snode) { ?     ir = fptr->gs * (nvolt[fptr->sxnode] - nvolt[fptr->snode]); 5     if(fptr->sxnode > 0) current[fptr->sxnode] += ir; 3     if(fptr->snode > 0) current[fptr->snode] -= ir;    } #   if(fptr->dxnode != fptr->dnode) { ?     ir = fptr->gd * (nvolt[fptr->dxnode] - nvolt[fptr->dnode]); 5     if(fptr->dxnode > 0) current[fptr->dxnode] += ir; 3     if(fptr->dnode > 0) current[fptr->dnode] -= ir;    }  }    /*= * Compute the mos level three currents and charges, including  * the derivatives. */+ putm3(fptr, nvolt, current, charge, alpha0) ) double *charge, *current, *nvolt, alpha0;  register struct fet3 *fptr;  { < double vds, vgs, vbs, type, vttmp, dvthdvbs, ir, m3compid();   /*C   testmosd(fptr->isas, fptr->cjas, fptr->svmax, fptr->mptr->djunc); B   testmosd(fptr->isas, fptr->cjas, (double) 0.0, fptr->mptr->dsw);   testfet3(fptr); exit(0); */  $ /* Compute the terminal voltages. */   type = fptr->mptr->type;9   vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      m3swapds(fptr);<      vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);   } 9   vgs = type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); 9   vbs = type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);   ' /* Compute the currents and charges. */ <   vttmp = m3compid(fptr, vgs, vbs, vds, &dvthdvbs, current);M   if(dcflag == FALSE) m3compq(fptr,vgs,vbs,vds,vttmp,dvthdvbs,charge,alpha0);   % /* Now place in linear parasitics. */ #   if(fptr->sxnode != fptr->snode) { ?     ir = fptr->gs * (nvolt[fptr->sxnode] - nvolt[fptr->snode]);      if(fptr->sxnode > 0) {"       current[fptr->sxnode] += ir;#       *(fptr->matsxsx) += fptr->gs;        if(fptr->snode > 0) { $         current[fptr->snode] -= ir; $         *(fptr->matss) += fptr->gs; %         *(fptr->matsxs) -= fptr->gs;  $         *(fptr->matssx) -= fptr->gs;       }      }      else if(fptr->snode > 0) {"       current[fptr->snode] -= ir; "       *(fptr->matss) += fptr->gs;      }    } #   if(fptr->dxnode != fptr->dnode) { ?     ir = fptr->gd * (nvolt[fptr->dxnode] - nvolt[fptr->dnode]);      if(fptr->dxnode > 0) {"       current[fptr->dxnode] += ir;#       *(fptr->matdxdx) += fptr->gd;        if(fptr->dnode > 0) { $         current[fptr->dnode] -= ir; $         *(fptr->matdd) += fptr->gd; %         *(fptr->matdxd) -= fptr->gd;  $         *(fptr->matddx) -= fptr->gd;       }      }      else if(fptr->dnode > 0) {"       current[fptr->dnode] -= ir; "       *(fptr->matdd) += fptr->gd;      }    }  }    /*  ; * Compute just the gate charge and its derivative.  Used if $ * just a gate is in the subcircuit.  */- justgm3(fptr, nvolt, current, charge, alpha0) ) double *charge, *current, *nvolt, alpha0;  register struct fet3 *fptr;  { N double vds, vgs, vbs, cg, qg, phibs, vgst, vfbx, temp1, temp2, alphax, sqrt(); struct inm3model *mptr;      mptr = fptr->mptr;  ?   vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      m3swapds(fptr);B      vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);   } ?   vgs = mptr->type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); ?   vbs = mptr->type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);        phibs = mptr->phi - vbs;  /   if(phibs < nrvabs) vfbx = mptr->vbi - nrvabs;     else vfbx = mptr->vbi - phibs;  (   if(vgs <= vfbx) { /* Cutoff region. */#     qg = fptr->cgsub * (vgs-vfbx);       cg = fptr->cgsub;    } /   else { /* Either subthresh, linear or sat. */ *     if(vbs == 0.0) vgst = vgs - mptr->vto;     else if(phibs < nrvabs) : 	 vgst = vgs - (mptr->vbi + (mptr->gamma * sqrt(nrvabs)));B     else vgst = vgs - ( mptr->vbi + (mptr->gamma * sqrt(phibs)) );  B     if(vgst <= 0.0) { /* Weak inversion or subthreshold region. */I       temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); C       qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma); -       cg = (fptr->cgsub * mptr->gamma)/temp1;      }      else if(vds == 0.0) { +       qg = fptr->cgsub * (vgs - mptr->vbi);        cg = fptr->cgsub;      } 0     else {  /* Linear and Saturation Regions. */(       alphax = 1.0 + mptr->theta * vgst;9       if( vgst > (alphax * vds) ) {  /* Linear region. */ ,         temp2 = vgst - (alphax * vds * 0.5);7         temp1 = (alphax * vds * vds) / ( 12.0 * temp2); I         qg = fptr->cgsub*( ((vgs - mptr->vbi) - (0.5 * vds) ) +  temp1 );          cg = fptr->cgsub* 0 	  ( 1.0 - (vds * vds)/(12.0 * temp2 * temp2) );       } %       else { /* Saturation Region. */          qg = fptr->cgsub *4 	  ( (vgs - mptr->vbi) - ( vgst  / (alphax*3.0) ) );A         cg = fptr->cgsub * (1.0 - ( 1.0 / (3.0*alphax*alphax) ));        }      }    }      charge[fptr->gnode] +=B 	mptr->type * (qg  + (fptr->cgs * vgs) + (fptr->cgd * (vgs-vds)));:   *(fptr->matgg) += alpha0 * (cg + fptr->cgs + fptr->cgd); }   & rjustgm3(fptr, nvolt, current, charge)! double *charge, *current, *nvolt;  register struct fet3 *fptr;  { < double vds, vgs, vbs, qg, vgst, vfbx, temp1, alphax, sqrt(); struct inm3model *mptr;      mptr = fptr->mptr;  ?   vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      m3swapds(fptr);B      vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);   } ?   vgs = mptr->type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); ?   vbs = mptr->type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);      temp1 = mptr->phi - vbs;0   if(temp1 < nrvabs) { 	/* vbs > phi - nrvabs */<     vgst = vgs - (mptr->vbi + (mptr->gamma * sqrt(nrvabs)));     vfbx = mptr->vbi - nrvabs;   }   %   else {    /* vbs < phi - nrvabs. */ =     vgst = vgs - ( mptr->vbi + (mptr->gamma * sqrt(temp1)) ); '     vfbx = mptr->vbi - mptr->phi + vbs;    }   (   if(vgs <= vfbx) { /* Cutoff region. */#     qg = fptr->cgsub * (vgs-vfbx);     } E   else if(vgst <= 0.0) { /* Weak inversion or subthreshold region. */ G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma);    }    else if(vds == 0.0) { )     qg = fptr->cgsub * (vgs - mptr->vbi);    } .   else {  /* Linear and Saturation Regions. */&     alphax = 1.0 + mptr->theta * vgst;7     if( vgst > (alphax * vds) ) {  /* Linear region. */ J       temp1 = (alphax * vds * vds) / ( 12.0 * (vgst - (alphax*vds*0.5)) );G       qg = fptr->cgsub*( ((vgs - mptr->vbi) - (0.5 * vds) ) +  temp1 );      } #     else { /* Saturation Region. */        qg = fptr->cgsub *2 	( (vgs - mptr->vbi) - ( vgst  / (alphax*3.0) ) );     }    }    charge[fptr->gnode] +=B 	mptr->type * (qg  + (fptr->cgs * vgs) + (fptr->cgd * (vgs-vds))); }   ) /* Drain-source node swapping routine. */  m3swapds(fptr) register struct fet3 *fptr;  { 
 double tempd;  register double *ptempd;	 int temp; D   temp = fptr->dnode; fptr->dnode = fptr->snode; fptr->snode = temp;H   temp = fptr->dxnode; fptr->dxnode = fptr->sxnode; fptr->sxnode = temp;>   tempd = fptr->cgs; fptr->cgs = fptr->cgd; fptr->cgd = tempd;B   tempd = fptr->isas; fptr->isas = fptr->isad; fptr->isad = tempd;B   tempd = fptr->cjas; fptr->cjas = fptr->cjad; fptr->cjad = tempd;F   tempd = fptr->cjass; fptr->cjass = fptr->cjasd; fptr->cjasd = tempd;:   tempd = fptr->gs; fptr->gs = fptr->gd; fptr->gd = tempd;H   ptempd = fptr->matdd; fptr->matdd = fptr->matss; fptr->matss = ptempd;N   ptempd= fptr->matdxdx; fptr->matdxdx = fptr->matsxsx; fptr->matsxsx =ptempd;J   ptempd= fptr->matdxd; fptr->matdxd = fptr->matsxs; fptr->matsxs =ptempd;J   ptempd= fptr->matddx; fptr->matddx = fptr->matssx; fptr->matssx =ptempd;H   ptempd = fptr->matds; fptr->matds = fptr->matsd; fptr->matsd = ptempd;H   ptempd = fptr->matdg; fptr->matdg = fptr->matsg; fptr->matsg = ptempd;H   ptempd = fptr->matdb; fptr->matdb = fptr->matsb; fptr->matsb = ptempd;H   ptempd = fptr->matgd; fptr->matgd = fptr->matgs; fptr->matgs = ptempd;I   ptempd = fptr->matbd; fptr->matbd = fptr->matbs; fptr->matbs = ptempd;   }        /*  C * The Ping-Yang/Pallab Chatterjee Charge model with no derivatives,  * modified for MOS3.B * The change of variable from Yang-Chatterjee model is as follows: * Twophi -> phi  * gamma -> theta
 * be -> gamma  * alpha -> 1.0  I * Note that the passed in vth = vbi + gamma * (sqrt(phi-vbs) - sqrt(phi))  */+ m3justq(fptr, vgs, vbs, vds, vttmp, charge) % double vgs, vbs, vds, vttmp, *charge;  register struct fet3 *fptr;  { I double qg, qb, qd, qs, qbsj=0.0, qbdj=0.0, vbd, vfb0, vfbx, vgst, alphax, 8        temp1, temp2, temp3, temp4, exp(), log(), sqrt();  register struct inm3model *mptr; register struct mosdiode *dptr;      mptr = fptr->mptr;   vbd = vbs - vds;     dptr = mptr->djunc; *   mosrdiodeq(qbsj, vbs, fptr->cjas, dptr);)   mosrdiodeq(qbdj, vbd,fptr->cjad, dptr);    dptr = mptr->dsw; ;   mosrdiodeq(temp1, vbs, fptr->cjass, dptr); qbsj += temp1; ;   mosrdiodeq(temp1, vbd, fptr->cjasd, dptr); qbdj += temp1;    /* Back to the mosfet. */    vfb0 = mptr->vbi - mptr->phi; - /* Fix case where vbs is too close to phi. */ B   if((mptr->phi - vbs) < nrvabs) vfbx = vfb0 + mptr->phi - nrvabs;   else vfbx = vfb0 + vbs;  /* Cutoff region. */   if(vgs <= vfbx) { "     qg = fptr->cgsub * (vgs-vfbx);     qb = - (qg);     qd = 0.0; 
     qs = 0.0;    } , /* Weak inversion or subthreshold region. */   else if(vgs <= vttmp) { G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma);      qb = - ( qg );
     qd = 0.0; 
     qs = 0.0;    } ; /* Now handle as a special case when vds is precisely 0. */ H /* This was done to optimize runtime by pulling out this simple case. */   else if(vds == 0) { )     qg = fptr->cgsub * (vgs - mptr->vbi); +     qb = fptr->cgsub * (mptr->vbi - vttmp); 1     qd = - ( fptr->cgsub * 0.5 * (vgs - vttmp) );      qs = qd;   }   $ /* Linear and Saturation Regions. */   else {/   /* First precalculate a few useful things. */      vgst = vgs - vttmp; &     alphax = 1.0 + mptr->theta * vgst;  +  /* The linear region.  God what a mess! */ *     if( vgs > ((alphax * vds) + vttmp) ) {!       temp1 = alphax * vds * 0.5; ,       temp2 = 1.0 / (12.0 * (vgst - temp1));!       temp3 = alphax * vds * vds;        temp4 = 0.5 * vds;I       qg = fptr->cgsub*( ((vgs - mptr->vbi) - temp4) + (temp3 * temp2) ); 2       qb = fptr->cgsub * (  (mptr->vbi - vttmp) + > 		            ( (1.0 - alphax) * (temp4 - (temp3*temp2)) )  );N       qd = fptr->cgsub * ((1.5*temp1) - (0.5*vgst) - (temp1*temp1*6.0*temp2));       qs = - (qg + qb + qd);     } ( /* And finally the saturation region. */
     else {       temp1 = 1.0/alphax; @       qg = fptr->cgsub*( (vgs-mptr->vbi) - (vgst*temp1 / 3.0) );       qd = 0.0; J       qb = fptr->cgsub*( (mptr->vbi - vttmp) + (vgst * (temp1-1.0)/3.0) );       qs = - (qg + qb);      }    }   ( /* Add in the junction diode charges. */   qb += qbdj + qbsj;
   qs -= qbsj; 
   qd -= qbdj;   , /* And stuff the charges into the vector. */M   if(fptr->snode>0) charge[fptr->snode] += mptr->type * (qs-(fptr->cgs*vgs)); +   if(fptr->dnode>0) charge[fptr->dnode] +=  . 		mptr->type * (qd+(fptr->cgd * (vds - vgs)));+   if(fptr->gnode>0) charge[fptr->gnode] +=  ? 		mptr->type * (qg  + (fptr->cgs*vgs) + (fptr->cgd*(vgs-vds))); ;   if(fptr->bnode>0) charge[fptr->bnode] += mptr->type * qb;  }    /*; * Computes the Mos level 3 currents and their derivatives.   */8 double m3compid(fptr, vgs, vbs, vds, pdvthdvbs, current)+ double vgs, vbs, vds, *pdvthdvbs, *current;  register struct fet3 *fptr;  {   register struct inm3model *mptr; register struct mosdiode *dptr; F double vbd, ibs=0.0, ibd=0.0, gbs=0.0, gbd=0.0, gmgs, gmbs, gmds, ids,)        vttmp, vth, us, onxj, vdsat, beta, '        phvbs, dsqdvb,sqphbs,phibs,onxl,         dlonxl,xlfact, 0        fshort, dfsdvb, wps,xjonxl,wponxj,wconxj,        argc,dwpdvb,dadvb,dbdvb, '        cdo,dcodvg,dcodvd,dcodvb,cdnorm, $        vdsx, dvsdvg, dvsdvd, dvsdvb,,        vgsx,onfg,fgate,dfgdvg,dfgdvd,dfgdvb,2        von, csonco,cdonco,xn,dxndvb,dvodvd,dvodvb,B        dvtdvd, dvtdvb, djonxj, diddl,vdsc,onvdsc,arga,argb,dvsdga,C        vbix, gammas, fbodys, fbody, onfbdy, dfbdvb, qbonco, dqbdvb, .        delxl,dldvd,dldem,ddldvg,ddldvd,ddldvb,(        cdsat,gdsat,gdoncd,gdonfd,gdonfg,2        cd1,fdrain,fd2,dfddvg,dfddvd,dfddvb,dxmdvb,,        dgdvg,dgdvd,dgdvb,emax,emoncd,emongd,        demdvg, demdvd, demdvb,,        onxn, ondvt,efact,wfact,gmw,lsquared,        exp(), log(), sqrt();     mptr = fptr->mptr;   dptr = mptr->djunc;   !   ids = gmds = gmgs = gmbs = 0.0;   - /* Mosfet diode currents and conductances. */    dptr = mptr->djunc; 4   mosdiodei(gbs,ibs,vbs,fptr->isas,fptr->svmax,dptr)   vbd = vbs - vds;4   mosdiodei(gbd,ibd,vbd,fptr->isad,fptr->dvmax,dptr)   /* Back to the mosfet. */ E /* Reference Ids equations to source and charge equations to bulk. */      vdsat = 0.0;     onxl = 1.0 / fptr->l;   % /* sigma = eta after preprocessing */  /* Square-root term */     if(vbs == 0.0) {         phibs = mptr->phi;         sqphbs = mptr->sqphi;          dsqdvb = -0.5 / sqphbs;      } 
     else {       phibs = mptr->phi - vbs;       if(phibs > nrvabs) { 	sqphbs = sqrt( phibs ); 	dsqdvb = -0.5 / sqphbs;       } .       else { /* case: Vbs too close to phi. */         phibs = nrvabs;  	sqphbs = sqrt(nrvabs);  	dsqdvb = 0.0;       }      }   - /* Threshold voltage for the charge model. */ -     vttmp = mptr->vbi + mptr->gamma * sqphbs; )     *pdvthdvbs = -(mptr->gamma * dsqdvb);   J /* If the drain and source are not part of this sub, or if drain=source */! /* no need to process further. */ 6     if( ((fptr->dnode <= 0) && (fptr->snode <= 0)) || 5 			(fptr->dnode == fptr->snode) ) goto m3condstuffit;   " /* Short channel effect factor  */0     if((mptr->xj != 0.0) && (mptr->xd != 0.0)) { 	wps = mptr->xd * sqphbs;  	onxj = 1.0 / mptr->xj;  	xjonxl = mptr->xj * onxl; 	djonxj = mptr->ld * onxj; 	wponxj = wps * onxj; 2 	wconxj = D0 + D1 * wponxj + D2 * wponxj * wponxj; 	arga = wconxj + djonxj;  	argc = wponxj / (1.0 + wponxj);  	argb = sqrt(1.0 - argc * argc);0 	fshort = 1.0 - xjonxl * (arga * argb - djonxj); 	dwpdvb = mptr->xd * dsqdvb;7 	dadvb = (D1 + D2 * (wponxj + wponxj)) * dwpdvb * onxj; > 	dbdvb = - argc * argc * (1.0 - argc) * dwpdvb / (argb * wps);3 	dfsdvb = - xjonxl * (dadvb * argb + arga * dbdvb);      } '     else { /* case: xj=0.0 or xd=0.0 */  	fshort = 1.0; 	dfsdvb = 0.0;     }    /* Body effect */ "     gammas = mptr->gamma * fshort;.     fbodys = 0.5 * gammas / (sqphbs + sqphbs);"     fbody = fbodys + fptr->fnarrw;"     onfbdy = 1.0 / ( 1.0 + fbody);B     dfbdvb = -fbodys * dsqdvb / sqphbs + fbodys * dfsdvb / fshort;4     qbonco = gammas * sqphbs + fptr->fnarrw * phibs;L     dqbdvb = gammas * dsqdvb + mptr->gamma * dfsdvb * sqphbs - fptr->fnarrw;   /* Static feedback effect  */ )     vbix = mptr->vbi - fptr->sigma * vds;    /* Threshold Voltage  */     vth = vbix + qbonco;     dvtdvd = -fptr->sigma;     dvtdvb = dqbdvb;  / /* Joint weak inversion and strong inversion */      von = vth;     if (mptr->nfs != 0.0) { , 	csonco = mptr->csoncopp; /* preprocessed */# 	cdonco = qbonco / (phibs + phibs);  	xn = 1.0 + csonco + cdonco;  	von = vth + mptr->vtherm * xn; F 	dxndvb = dqbdvb / (phibs+phibs) - qbonco * dsqdvb / (phibs * sqphbs);F 	dxmdvb = mptr->vtherm * dxndvb;  /* doesn't appear to be different */ 	dvodvd = dvtdvd;  	dvodvb = dvtdvb + dxmdvb;     } J     else if (vgs <= von) { /*  C U T O F F    Region: and no subthresh. */         goto m3condstuffit;      }    /* Device is on */     vgsx = max(vgs,von);  % /* Mobility modulation by the gate */ ,     onfg = 1.0 + mptr->theta * (vgsx - vth);     fgate = 1.0 / onfg;      us = mptr->uo * fgate;       if ( vgs >= von ) { +     	dfgdvg = -mptr->theta * fgate * fgate;      	dfgdvd = -dfgdvg * dvtdvd;      	dfgdvb = -dfgdvg * dvtdvb;      } 
     else { 	dfgdvg = 0.0; 	dfgdvd = 0.0;1 	dfgdvb = - mptr->theta * fgate * fgate * dxmdvb;      }    /* Saturation voltage */     if (mptr->vmax <= 0.0) {&         vdsat = (vgsx - vth) * onfbdy; 	if ( vgs >= von ) { 	    dvsdvg = onfbdy;  	    dvsdvd = -dvsdvg * dvtdvd; 9 	    dvsdvb = -dvsdvg * dvtdvb - vdsat * dfbdvb * onfbdy;  	} 	else {  	    dvsdvg = 0.0; 	    dvsdvd = 0.0;1 	    dvsdvb = (dxmdvb - vdsat * dfbdvb) * onfbdy;  	}     } !     else { /* case: vmax > 0.0 */ " 	vdsc = fptr->l * mptr->vmax / us; 	onvdsc = 1.0 / vdsc;  	arga = (vgsx - vth) * onfbdy;( 	argb = sqrt(arga * arga + vdsc * vdsc); 	vdsat = arga + vdsc - argb;% 	dvsdga = (1.0 - arga/argb) * onfbdy;  	if ( vgs >= von ) {B 	    dvsdvg = dvsdga - (1.0 - vdsc / argb) * vdsc * dfgdvg * onfg;  	    dvsdvd = - dvsdvg * dvtdvd;9 	    dvsdvb = - dvsdvg * dvtdvb - arga * dvsdga * dfbdvb;  	}& 	else { /* vgs < von and vmax > 0.0 */ 	    dvsdvg = 0.0; 	    dvsdvd = 0.0;0 	    dvsdvb = dvsdga * (dxmdvb - arga * dfbdvb) 2 			    - (1.0 - vdsc/argb) * vdsc * onfg * dfgdvb; 	}     }   6 /* Current factors in the    L I N E A R    Region  */     vdsx = min(vds,vdsat);     beta = fptr->betap; 1     if(vdsx == 0.0) { /* Special case of Vds=0 */  	beta *= fgate;  	ids = 0.0;  	gmgs = 0.0; 	gmds = beta * (vgsx - vth); 	gmbs = 0.0;,     /* Weak inversion for vds = 0.0 case. */F 	if(mptr->nfs != 0.0 && vgs < von) { /* smoothing? looks expensive! */D 	   /* this is different from Spice2g.6 : check power on exponent */0 	   efact = ( vgs - von ) / (mptr->vtherm * xn);% 	   if(efact < EXPLIMIT)	wfact = 0.0;  	   else	wfact = exp( efact ); 	   gmds *= wfact; 	}     } 2     else { /* case: Vds != 0, most of the time. *// 	cdo = vgsx - vth - 0.5 * (1.0 + fbody) * vdsx;  	if (vgs >= von) { 	   if (vds > vdsat) {3 	      dcodvg = 1.0 - 0.5 * (1.0 + fbody) * dvsdvg; 7 	      dcodvd = -dvtdvd - 0.5 * (1.0 + fbody) * dvsdvd; / 	      dcodvb = -dvtdvb - 0.5 * dfbdvb * vdsat  " 			- 0.5 * (1.0 + fbody) * dvsdvb; 	   } ! 	   else {     /* vds <= vdsat */  	      dcodvg = 1.0;. 	      dcodvd = -dvtdvd - 0.5 * (1.0 + fbody);. 	      dcodvb = -dvtdvb - 0.5 * dfbdvb * vdsx; 	   }  	} 	else {    /* vgs < von */ 	   if (vds > vdsat) { 	      dcodvg = 0.0; 	      dcodvd = 0.0;. 	      dcodvb = dxmdvb - 0.5 * dfbdvb * vdsat # 				- 0.5 * (1.0 + fbody) * dvsdvb;  	   } ! 	   else {     /* vds <= vdsat */  	      dcodvg = 0.0;% 	      dcodvd = -0.5 * (1.0 + fbody); - 	      dcodvb = dxmdvb - 0.5 * dfbdvb * vdsx;  	   }  	}"     /* Normalized Drain Current */ 	cdnorm = cdo * vdsx;  	if (vds > vdsat) { ) 	   gmgs = dcodvg * vdsat + cdo * dvsdvg; ) 	   gmds = dcodvd * vdsat + cdo * dvsdvd; ) 	   gmbs = dcodvb * vdsat + cdo * dvsdvb;  	} 	else {  	   gmgs = dcodvg * vdsx;  	   gmds = dcodvd * vdsx + cdo;  	   gmbs = dcodvb * vdsx;  	}  3     /* Drain current without velocity saturation */  	cd1 = beta * cdnorm;  	beta = beta * fgate;  	ids = beta * cdnorm; # 	gmgs = beta * gmgs + dfgdvg * cd1; # 	gmds = beta * gmds + dfgdvd * cd1; # 	gmbs = beta * gmbs + dfgdvb * cd1;   $     /* Velocity Saturation Factor */ 	if(mptr->vmax != 0.0) {' 		fdrain = 1.0 / (1.0 + vdsx * onvdsc);  		fd2 = fdrain * fdrain;$ 		arga = fd2 * vdsx * onvdsc * onfg; 		if (vds > vdsat) {6 		   dfddvg = - dfgdvg * arga - fd2 * onvdsc * dvsdvg;6 		   dfddvd = - dfgdvd * arga - fd2 * onvdsc * dvsdvd;6 		   dfddvb = - dfgdvb * arga - fd2 * onvdsc * dvsdvb; 		}  		else { 		   dfddvg = - dfgdvg * arga;- 		   dfddvd = - dfgdvd * arga - fd2 * onvdsc;  		   dfddvb = - dfgdvb * arga; 		}  	/* Drain current */& 		gmgs = fdrain * gmgs + dfddvg * ids;& 		gmds = fdrain * gmds + dfddvd * ids;& 		gmbs = fdrain * gmbs + dfddvb * ids; 		ids = fdrain * ids;  		beta = beta * fdrain;  	}  #     /* Channel Length Modulation */  	if (vds > vdsat) { 2 	/*   S  A  T  U  R  A  T  I  O  N       Region */ 	     if(mptr->vmax != 0.0) { ( 		if (mptr->alpha == 0.0)	goto weak_inv; 		cdsat = ids;* 		gdsat = cdsat * (1.0 - fdrain) * onvdsc;   		if (gdsat < FET3_GMIN) {     		   gdsat = FET3_GMIN;  		   dgdvg = 0.0;  		   dgdvd = 0.0;  		   dgdvb = 0.0;  		}   		else { /* gdsat > FET3_GMIN */ 		   gdoncd = gdsat / cdsat;% 		   gdonfd = gdsat / (1.0 - fdrain);  		   gdonfg = gdsat * onfg; ? 		   dgdvg = gdoncd * gmgs - gdonfd * dfddvg + gdonfg * dfgdvg; / 		   dgdvd = gdoncd * gmds - gdonfd * dfddvd +   						   gdonfg * dfgdvd; / 		   dgdvb = gdoncd * gmbs - gdonfd * dfddvb +   						   gdonfg * dfgdvb;                  }    		emax = cdsat * onxl / gdsat; 		emoncd = emax / cdsat; 		emongd = emax / gdsat;* 		demdvg = emoncd * gmgs - emongd * dgdvg;* 		demdvd = emoncd * gmds - emongd * dgdvd;* 		demdvb = emoncd * gmbs - emongd * dgdvb;  " 		arga = 0.5 * emax * mptr->alpha;# 		argc = mptr->kappa * mptr->alpha; 2 		argb = sqrt(arga * arga + argc * (vds - vdsat)); 		delxl = argb - arga; 		dldvd = argc / (argb + argb); 2 		dldem = 0.5 * (arga / argb - 1.0) * mptr->alpha;+ 		ddldvg = dldem * demdvg - dldvd * dvsdvg; 3 		ddldvd = dldem * demdvd + dldvd * (1.0 - dvsdvd); + 		ddldvb = dldem * demdvb - dldvd * dvsdvb;  	     }  	     else { /* case: vmax=0 */ : 		delxl = sqrt(mptr->kappa * (vds - vdsat) * mptr->alpha);& 		dldvd = 0.5 * delxl / (vds - vdsat); 		ddldvg = -dldvd * dvsdvg; " 		ddldvd = dldvd * (1.0 - dvsdvd); 		ddldvb = -dldvd * dvsdvb;  	     }   *         /* Punch through approximation  */# 	     if( delxl > 0.5 * fptr->l ) {   		 lsquared = fptr->l * fptr->l;0 		 delxl = fptr->l - (lsquared / (4.0 * delxl));? 		 arga = 4.0 * (fptr->l - delxl) * (fptr->l -delxl) /lsquared;  		 ddldvg = ddldvg * arga; 		 ddldvd = ddldvd * arga; 		 ddldvb = ddldvb * arga; 		 dldvd  = dldvd  * arga; 	     }  	     dlonxl = delxl * onxl;$ 	     xlfact = 1.0 / (1.0 - dlonxl); 	     ids *= xlfact;& 	     diddl = ids / (fptr->l - delxl);, 	     gmgs = gmgs * xlfact + diddl * ddldvg;, 	     gmds = gmds * xlfact + diddl * ddldvd;, 	     gmbs = gmbs * xlfact + diddl * ddldvb; 	}  	 weak_inv:  	if (vgs < von) {  	 /* Weak inversion case  */ 	   onxn = 1.0 / xn;  	   ondvt = onxn / mptr->vtherm;D 	   /* this is different from Spice2g.6 : check power on exponent */" 	   efact = ( vgs - von ) * ondvt;% 	   if(efact < EXPLIMIT) wfact = 0.0;  	   else	wfact = exp( efact ); 	   ids *= wfact;  	   gmw = ids * ondvt; 	   gmgs = gmgs * wfact + gmw;' 	   gmds = gmds * wfact - gmw * dvodvd; < 	   gmbs = gmbs * wfact - gmw * ((vgs - von) * onxn * dxndvb 					+ dvodvb);  	}     }    m3condstuffit:   /*>   printf("vgs=%g vds=%g vbs=%g ids=%g\n", vgs, vds, vbs, ids); */* /* Stuff the currents and conductances. */   if(fptr->bnode > 0) { 5     current[fptr->bnode] += mptr->type * (ibd + ibs); !     *(fptr->matbb) += gbd + gbs;     } @   if(fptr->dnode > 0) { /* Put the drain row into the matrix. */#     *(fptr->matdd) += (gmds + gbd); 5     current[fptr->dnode] += mptr->type * (ids - ibd); N     if(fptr->bnode>0) { *(fptr->matdb) += gmbs - gbd; *(fptr->matbd) -= gbd; }-     if(fptr->gnode>0) *(fptr->matdg) += gmgs; 9     if(fptr->snode>0) *(fptr->matds) -= (gmgs+gmbs+gmds);    } A   if(fptr->snode > 0) { /* Put the source row into the matrix. */ /     *(fptr->matss) += gmds + gmbs + gmgs + gbs; 5     current[fptr->snode] -= mptr->type * (ids + ibs); N     if(fptr->bnode>0) { *(fptr->matbs) -= gbs; *(fptr->matsb) -= (gbs+gmbs); }-     if(fptr->gnode>0) *(fptr->matsg) -= gmgs; -     if(fptr->dnode>0) *(fptr->matsd) -= gmds;    }        return(vttmp); }    /*  A * The Ping-Yang/Pallab Chatterjee Charge model modified for MOS3. B * The change of variable from Yang-Chatterjee model is as follows: * Twophi -> phi  * gamma -> theta
 * be -> gamma  * alpha -> 1.0  I * Note that the passed in vth = vbi + gamma * (sqrt(phi-vbs) - sqrt(phi)) - * and dvthdvbs = 0.5 * gamma / sqrt(phi-vbs);  */: m3compq(fptr,vgs, vbs, vds, vth, dvthdvbs, charge, alpha0)5 double vds, vgs, vbs, vth, dvthdvbs, *charge, alpha0;  register struct fet3 *fptr;  {   register struct inm3model *mptr; double qd, qg, qs, qb,$        cdg, cds, cdb, cgd, cgs, cgb,$        csd, csg, csb, cbd, cbg, cbs,-        vbd, vfb0, vfbx, vgst, vgsat, alphax,  K        temp, temp1, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9, /        temp10, temp11, temp12, temp14, temp15,  .        qbdj=0.0, cbdj=0.0, qbsj=0.0, cbsj=0.0,        log(), exp(), sqrt(); register struct mosdiode *dptr;      mptr = fptr->mptr;   vbd = vbs - vds;  7 /* First compute the diode charges and capacitances. */    dptr = mptr->djunc; /   mosdiodeq(cbsj, qbsj, vbs, fptr->cjas, dptr); /   mosdiodeq(cbdj, qbdj, vbd, fptr->cjad, dptr);    dptr = mptr->dsw; L   mosdiodeq(temp1,temp2,vbs,fptr->cjass,dptr); cbsj += temp1; qbsj += temp2;L   mosdiodeq(temp1,temp2,vbd,fptr->cjasd,dptr); cbdj += temp1; qbdj += temp2;  B /* Temporary.  Blow off charge model except for gate grounded cox. #if (LINCAP)"    qg = fptr->cgsub * (vgs - vbs);    qb = - (qg); 
    qd = 0.0;      qs = 0.0;#    cdb = 0.0; cds = 0.0; cdg = 0.0; #    csd = 0.0; csb = 0.0; csg = 0.0; +    cbd = 0.0; cbs = 0.0; cbg = fptr->cgsub; +    cgd = 0.0; cgs = 0.0; cgb = fptr->cgsub;       goto m3chargstuff;  #endif */   /* Back to the Mosfet. */    vfb0 = mptr->vbi - mptr->phi;   + /* Fix case where vbs goes too positive. */ A   if( (mptr->phi-vbs) < nrvabs) vfbx = vfb0 + mptr->phi - nrvabs;    else vfbx = vfb0 + vbs;    /* Cutoff region. */   if(vgs <= vfbx) { $     qg = fptr->cgsub * (vgs - vfbx);     qb = - (qg);     qd = 0.0; 
     qs = 0.0; $     cdb = 0.0; cds = 0.0; cdg = 0.0;$     csd = 0.0; csb = 0.0; csg = 0.0;     cbd = 0.0; cgd = 0.0; B   /* Again deal oddly with the problem of vbs too close to phi. */&     if( (mptr->phi - vbs)  < nrvabs) {I       cbg = fptr->cgsub; cbs = -fptr->cgsub; cgb =0.0; cgs = fptr->cgsub;      } 
     else {?       cbg = fptr->cgsub; cgb = fptr->cgsub; cgs = 0.0; cbs=0.0;      }    }   , /* Weak inversion or subthreshold region. */   else if(vgs <= vth) { G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma);      qb = - ( qg );
     qd = 0.0; 
     qs = 0.0; %     cdb = 0.0; cds = 0.0; cdg = 0.0;  $     csb = 0.0; csd = 0.0; csg = 0.0;     cbd = 0.0; cgd = 0.0; D   /* Again deal oddly with the case where vbs too close to 2phif. */$     if((mptr->phi - vbs) < nrvabs) {9       cgb = 0.0; cgs = (fptr->cgsub * mptr->gamma)/temp1;        cbg = cgs; cbs = -cgs;     } 
     else {9       cgs = 0.0; cgb = (fptr->cgsub * mptr->gamma)/temp1;        cbg = cgb; cbs = 0.0;      }    }   $ /* Linear and Saturation Regions. */   else {/   /* First precalculate a few useful things. */      vgst = vgs - vth; &     alphax = 1.0 + mptr->theta * vgst;!     vgsat = (alphax * vds) + vth;      temp9 = vfb0 + mptr->phi;   =   /* Now handle as a special case when vds is precisely 0. */ J   /* This was done to optimize runtime by pulling out this simple case. */     if(vds == 0.0) {'       qg = fptr->cgsub * (vgs - temp9); '       qb = fptr->cgsub * (temp9 - vth);        cgb = 0.0;       cgs = fptr->cgsub * 0.5;       cgd = cgs;       qd = - ( cgs * vgst );       qs = - (qg + qb + qd);8       cds = cgs * ( ((1.5 * alphax) - 1.0) - dvthdvbs );       cdg = cgd;       cdb = cdg * dvthdvbs; /       cbd = fptr->cgsub * (alphax - 1.0) * 0.5;        cbg = 0.0;<       cbs = fptr->cgsub * (dvthdvbs + (1.0 - alphax) * 0.5);,       csb = ((cbg + cbd + cbs) - cdb) - cgb;,       csd = ((cdg + cds + cdb) - cbd) - cgd;,       csg = ((cgd + cgs + cgb) - cdg) - cbg;     }   +  /* The linear region.  God what a mess! */      else if(vgs > vgsat) {        temp = alphax * vds * 0.5;       temp2 = 1.0/alphax;        temp3 = alphax * alphax;+       temp4 = 1.0 / (12.0 * (vgst - temp)); "       temp5 = temp4/(vgst - temp);       temp6 = vds * vds;,       temp7 = 1.0 * temp6; /* Used alpha. */       temp8 = alphax * temp6;        temp10 = 0.5 * vds;        temp11 = 1.0 - alphax;       temp12 = temp * temp; !       temp14 = temp * 4.0 * vgst; $       temp15 = temp10 * mptr->theta;  H       qg = fptr->cgsub * ( ((vgs - temp9) - temp10) + (temp8 * temp4) );M       qb = fptr->cgsub * ( (temp9 - vth) + temp11*(temp10 - (temp8*temp4)) ); 3       cgb = fptr->cgsub * temp7 * dvthdvbs * temp5;        cgs = fptr->cgsub * J         (0.5 + (temp14 - ( temp7*(1.0+dvthdvbs)+temp12+temp12 )) * temp5);E       cgd = fptr->cgsub * ( 0.5 + ((temp12+temp12-temp14) * temp5) ); I       qd = fptr->cgsub * ( (1.5*temp) - (0.5*vgst) - (temp12*6.0*temp4));        qs = - (qg + qb + qd);       cds = fptr->cgsub * (  	      (0.75 * alphax) +  8         ( ((1.5 * temp15) - 0.5) * (1.0 + dvthdvbs) ) + M        (( (1.0-temp15)*(1.0+dvthdvbs)-(alphax*0.5) )* temp12 * 6.0 * temp5) - M         (  temp * ((alphax * 0.5) + temp15 * (1.0+dvthdvbs)) * 12.0 * temp4 )  			      );        cdg = fptr->cgsub * (	 		(0.5 - (1.5*temp15))0 			- ((temp5 - mptr->theta*temp4) * temp8 *1.5)  			      );        cdb = dvthdvbs * cdg; G       cbd = -fptr->cgsub * temp11 * (0.5+(temp12+temp12-temp14)*temp5);        cbs = fptr->cgsub * (  		 dvthdvbs + (temp11*0.5)) 		  - ( temp11*(temp14-(temp12+temp12)) +  		      (1.0+dvthdvbs)*temp6*(  			 (temp3*(1.0+temp15) - 1.0) -9 		  	         (2.0*mptr->theta*alphax*vgst) ) ) * temp5); !       cbg = fptr->cgsub * (temp15 9 	 - ( temp11 * temp5 + alphax*mptr->theta*temp4 )*temp6); ,       csb = (cbg + cbd + cbs) - (cdb + cgb);,       csd = (cdg + cds + cdb) - (cbd + cgd);,       csg = (cgd + cgs + cgb) - (cdg + cbg);     }      ( /* And finally the saturation region. */
     else {       temp2 = 1.0/alphax;        temp3 = alphax * alphax;>       qg = fptr->cgsub * ( (vgs-temp9) - (vgst*temp2 / 3.0) );       qd = 0.0; D       qb = fptr->cgsub * ( (temp9-vth) + (vgst * (temp2-1.0)/3.0) );       qs = - (qg + qb); 3       cgb = (fptr->cgsub * dvthdvbs) / (3.0*temp3); =       cgs = fptr->cgsub * (1.0 - (1.0+dvthdvbs)/(3.0*temp3));        cgd = 0.0;         cdb = 0.0;       cds = 0.0;       cdg = 0.0;$       csg = fptr->cgsub * TWOTHIRDS;       csd = 0.0;/       csb = fptr->cgsub * dvthdvbs * TWOTHIRDS;        cbd = 0.0;       cbs = csg + csb - cgs;       cbg = cgs + cgb - csg;     }    }   
 m3chargstuff:   0 /* Add in the diode charges and capacitances. */   qb += qbdj + qbsj;
   qs -= qbsj; 
   qd -= qbdj;    cbs += cbsj;   csb += cbsj;   cbd += cbdj;   cdb += cbdj;   /*2   printf("vgs=%g vbs=%g vds=%g\n", vgs, vbs, vds);6   printf("qb=%g qd=%g qs=%g qg=%g\n", qb, qd, qs, qg);2   printf("cgs=%g cgd=%g cgb=%g\n", cgs, cgd, cgb);2   printf("cds=%g cdg=%g cdb=%g\n", cds, cdg, cdb);2   printf("csd=%g csg=%g csb=%g\n", csd, csg, csb);2   printf("cbs=%g cbd=%g cbg=%g\n", cbs, cbd, cbg); */  H /* And stuff the charges and capacitances into the vector and matrix. */   if(fptr->dnode>0) { I     charge[fptr->dnode] += mptr->type * (qd + (fptr->cgd * (vds - vgs))); =     *(fptr->matdd) += alpha0 * (cds + cdg + cdb + fptr->cgd); 7     if(fptr->bnode>0) *(fptr->matdb) -= (alpha0 * cdb); E     if(fptr->gnode>0) *(fptr->matdg) -= (alpha0 * (fptr->cgd + cdg)); 8     if(fptr->snode>0) *(fptr->matds) -= (alpha0 * cds);    }    if(fptr->snode>0) { A     charge[fptr->snode] += mptr->type * (qs - (fptr->cgs * vgs)); 7     *(fptr->matss) += alpha0 * (csd+csg+csb+fptr->cgs); 8     if(fptr->bnode>0) *(fptr->matsb) -=  (alpha0 * csb);D     if(fptr->gnode>0) *(fptr->matsg) -=  (alpha0*(csg + fptr->cgs));8     if(fptr->dnode>0) *(fptr->matsd) -=  (alpha0 * csd);   }    if(fptr->gnode>0) {      charge[fptr->gnode] +=  > 	mptr->type * (qg  + (fptr->cgs*vgs) + (fptr->cgd*(vgs-vds)));I     *(fptr->matgg) += alpha0 * (cgs + cgd + cgb + fptr->cgs + fptr->cgd); 8     if(fptr->bnode>0) *(fptr->matgb) -=  (alpha0 * cgb);F     if(fptr->dnode>0) *(fptr->matgd) -=  (alpha0 * (cgd + fptr->cgd));F     if(fptr->snode>0) *(fptr->matgs) -=  (alpha0 * (cgs + fptr->cgs));   }    if(fptr->bnode>0) { +     charge[fptr->bnode] += mptr->type * qb; 1     *(fptr->matbb) += alpha0 * (cbg + cbd + cbs); 7     if(fptr->dnode>0) *(fptr->matbd) -= (alpha0 * cbd); 7     if(fptr->gnode>0) *(fptr->matbg) -= (alpha0 * cbg); 7     if(fptr->snode>0) *(fptr->matbs) -= (alpha0 * cbs);    }    }   - double m3justid(fptr, vgs, vbs, vds, current)  double vgs, vbs, vds, *current;  register struct fet3 *fptr;  {   register struct inm3model *mptr; register struct mosdiode *dptr; & double ibs=0.0, ibd=0.0, ids=0.0, vbd,(        vttmp, vth, vdsat, sqphbs, phibs,=        fshort, onxl, xjonxl, wponxj, argc, vdsx, vgsx, fgate, F        von, xn, djonxj,vdsc,arga, vbix, gammas, fbody, onfbdy, qbonco,2        delxl, fdrain, efact, exp(), log(), sqrt();     mptr = fptr->mptr;   dptr = mptr->djunc;  /* First do the diodes. */2   mosrdiodei(ibs,vbs,fptr->isas,fptr->svmax,dptr);   vbd = vbs - vds;2   mosrdiodei(ibd,vbd,fptr->isad,fptr->dvmax,dptr);   /* Back to the mosfet. */   % /* sigma = eta after preprocessing */  /* Square-root term */?     if(vbs == 0.0) { phibs = mptr->phi; sqphbs = mptr->sqphi; } 
     else {       phibs = mptr->phi - vbs;.       if(phibs > nrvabs) sqphbs = sqrt(phibs);.       else { /* case: Vbs too close to phi. */         phibs = nrvabs;          sqphbs = sqrt(nrvabs);       }      }   - /* Threshold voltage for the charge model. */ -     vttmp = mptr->vbi + mptr->gamma * sqphbs;   ! /* Precompute 1.0 over length. */      onxl = 1.0 / fptr->l;   F /* Short channel effect factor.  Some more precalc work to do here. */0     if((mptr->xj != 0.0) && (mptr->xd != 0.0)) { 	xjonxl = mptr->xj * onxl;  	djonxj = mptr->ld * mptr->onxj;) 	wponxj = mptr->xd * mptr->onxj * sqphbs; 2 	arga = D0 + wponxj * (D1 + D2 * wponxj) + djonxj;  	argc = wponxj / (1.0 + wponxj);C 	fshort = 1.0 - xjonxl * (arga * sqrt(1.0 - argc * argc) - djonxj);      } (     else { /* case: xj=0.0 or xd=0.0 */	       fshort = 1.0;      }    /* Body effect */ "     gammas = mptr->gamma * fshort;<     fbody = 0.5 * gammas / (sqphbs + sqphbs) + fptr->fnarrw;"     onfbdy = 1.0 / ( 1.0 + fbody);4     qbonco = gammas * sqphbs + fptr->fnarrw * phibs;   /* Static feedback effect  */ )     vbix = mptr->vbi - fptr->sigma * vds;    /* Threshold Voltage  */     vth = vbix + qbonco;  / /* Joint weak inversion and strong inversion */      von = vth;     if (mptr->nfs != 0.0) { G 	xn = mptr->vtherm * (1.0 + mptr->csoncopp + qbonco / (phibs + phibs));  	von += xn;      } J     else if (vgs <= von) { /*  C U T O F F    Region: and no subthresh. */         goto m3condstuffit;      }    /* Device is on */     vgsx = max(vgs,von);  % /* Mobility modulation by the gate */ 5     fgate = 1.0 / (1.0 + mptr->theta * (vgsx - vth));    /* Saturation voltage */     if(mptr->vmax > 0.0) {4 	vdsc = (fptr->l * mptr->vmax) / (mptr->uo * fgate); 	arga = (vgsx - vth) * onfbdy;7 	vdsat = arga + vdsc - sqrt(arga * arga + vdsc * vdsc);      } '     else vdsat = (vgsx - vth) * onfbdy;   6 /* Current factors in the    L I N E A R    Region  */     vdsx = min(vds,vdsat);     if(vdsx == 0.0) ids = 0.0;2     else { /* case: Vds != 0, most of the time. */3     /* Drain current without velocity saturation */ F 	ids = fptr->betap * fgate * vdsx * (vgsx-vth - 0.5*(1.0+fbody)*vdsx);  $     /* Velocity Saturation Factor */ 	if(mptr->vmax != 0.0) {	 ' 	     fdrain = 1.0/(1.0 + (vdsx/vdsc));  	     ids *= fdrain;	         }   #     /* Channel Length Modulation */ . 	if( (vds > vdsat) && (mptr->alpha != 0.0) ) {2 	/*   S  A  T  U  R  A  T  I  O  N       Region */ 	     if(mptr->vmax != 0.0) { : 		arga = 0.5 * onxl * mptr->alpha * vdsc / (1.0 - fdrain);# 		argc = mptr->kappa * mptr->alpha; : 		delxl = sqrt(arga * arga + argc * (vds - vdsat)) - arga;              }C 	     else delxl = sqrt(mptr->kappa * (vds - vdsat) * mptr->alpha);   D 	     if(delxl > 0.5 * fptr->l) { /* Punch through approximation  */6 		delxl = fptr->l * (1.0 - (fptr->l / (4.0 * delxl))); 	     }   " 	     ids /= (1.0 - delxl * onxl); 	}       /* Weak Inversion. */ , 	if (vgs < von) { /* Weak inversion case  */ 	   efact = ( vgs - von ) / xn; # 	   if(efact < EXPLIMIT) ids = 0.0;  	   else	ids *= exp(efact);  	}     }    m3condstuffit: /*>   printf("vgs=%g vds=%g vbs=%g ids=%g\n", vgs, vds, vbs, ids); */ /* Stuff the currents. */ G   if(fptr->bnode > 0) current[fptr->bnode] += mptr->type * (ibd + ibs); G   if(fptr->dnode > 0) current[fptr->dnode] += mptr->type * (ids - ibd); G   if(fptr->snode > 0) current[fptr->snode] -= mptr->type * (ids + ibs);    return(vttmp); }    /*H * Put the fet into the binned array of devices used by the partitioner.  * variables used: , * devptr - pointer to the fet to be stuffed. */ stuffm3(devptr)  struct device *devptr; {  struct fet3 *fptr;(   fptr = (struct fet3 *) devptr->devptr;#   adddevarray(devptr, fptr->dnode); B   if(fptr->gnode != fptr->dnode) adddevarray(devptr, fptr->gnode);  &   if( (fptr->snode != fptr->dnode) && F       (fptr->snode != fptr->gnode) ) adddevarray(devptr, fptr->snode);  %   if( (fptr->bnode != fptr->dnode) && %       (fptr->bnode != fptr->gnode) && F       (fptr->bnode != fptr->snode) ) adddevarray(devptr, fptr->bnode); }    /*  4 * Create and initialize the ti fet for simulation.  ; * This includes allocating space for the fet, replacing the ? * global node numbers with subcircuit numbers, initializing the A * matrix pointers, and deciding on the functions to evaluate the  	 * mosfet.  * variables used: 8 * subptr - pointer to the subcircuit containing the fet.> * extfptr - pointer to the fet created from input description. */# struct device *m3init(subptr, pext)  struct subcircuit *subptr; struct fet3 *pext; {  struct fet3 *fptr;# struct device *devptr, *m3getmat();  int temp, disfet3();  H /* Do not copy the MOS3 model if it has only a gate or bulk in subckt */C /* and cox, cgs, cgd, cgb are all zero or this is a dc solution. */    if( (dcflag == TRUE) || N   ((pext->cgsub==0.0)&&(pext->cgd ==0.0)&&(pext->cgs==0.0)&&(pext->cgb==0.0)))- 	    if( (nomapchk(subptr,pext->snode) <= 0)  8 		&& (nomapchk(subptr,pext->dnode) <= 0) ) return(NULL);  )   if( (nomapchk(subptr,pext->snode) > 0)  & 	|| (nomapchk(subptr,pext->dnode) > 0)/         || (nomapchk(subptr,pext->bnode) > 0) )  		subptr->nummosmodels++;  /* Allocate the device. */>   devptr = (struct device *) ralloc(1, sizeof(struct device));   devptr->utype = FET3; ;   devptr->devptr = (char *) ralloc(1, sizeof(struct fet3)); (   fptr = (struct fet3 *) devptr->devptr;  - /* Copy the external fet to the local fet. */ )   bcopy(pext, fptr, sizeof(struct fet3));   ! /* Debugging Display function. */    devptr->display = disfet3;  4 /* Stuff in the matrix element grabbing function. */   devptr->initdev = m3getmat;   < /* Actually replace the global nodes with the local ones. *//   fptr->gnode = chksubnode(subptr,fptr->gnode); /   fptr->bnode = chksubnode(subptr,fptr->bnode);   A /* If no source internal node, just replace the external node. */    if(fptr->gs == 0.0) { @     fptr->sxnode = fptr->snode = chksubnode(subptr,fptr->snode);   } L   else if(nomapchk(subptr, fptr->snode) <= 0) { /* Source outside subckt. */K     fptr->snode = fptr->sxnode = chksubnode(subptr,fptr->sxnode + maxnode);    } )   else { /* Allocate an internal node. */ 4     temp = allocnode(subptr,fptr->sxnode + maxnode);2     fptr->sxnode = chksubnode(subptr,fptr->snode);     fptr->snode = temp;    }  /* Same for the drain node. */   if(fptr->gd == 0.0) { @     fptr->dxnode = fptr->dnode = chksubnode(subptr,fptr->dnode);   } /   else if(nomapchk(subptr, fptr->dnode) <= 0) { K     fptr->dnode = fptr->dxnode = chksubnode(subptr,fptr->dxnode + maxnode);    }    else {4     temp = allocnode(subptr,fptr->dxnode + maxnode);2     fptr->dxnode = chksubnode(subptr,fptr->dnode);     fptr->dnode = temp;    }   J /* Turn off mosfet diodes not in this subcircuit or to connected nodes. */N   if( ((fptr->bnode<=0)&&(fptr->dnode<=0)) || (fptr->bnode == fptr->dnode) ) {:     fptr->isad = 0.0; fptr->cjad = 0.0; fptr->cjasd = 0.0;   } N   if( ((fptr->bnode<=0)&&(fptr->snode<=0)) || (fptr->bnode == fptr->snode) ) {:     fptr->isas = 0.0; fptr->cjas = 0.0; fptr->cjass = 0.0;   }   * /* Stuff in model evaluation functions. */H   if( (fptr->dnode <= 0) && (fptr->snode <= 0) && (fptr->bnode <= 0) ) {7     devptr->eval = justgm3; devptr->rhseval = rjustgm3;    }    else {1     devptr->eval = putm3; devptr->rhseval = rpm3;    } '   if(dcflag == TRUE) fptr->cgsub = 0.0;    /* And return the device. */   return(devptr);  }     /* Matrix element allocation. */$ struct device *m3getmat(fptr,subptr) struct fet3 *fptr; struct subcircuit *subptr; {  double *getmat(); <   fptr->matdxdx = getmat(fptr->dxnode, fptr->dxnode,subptr);:   fptr->matdxd = getmat(fptr->dxnode, fptr->dnode,subptr);:   fptr->matddx = getmat(fptr->dnode, fptr->dxnode,subptr);  <   fptr->matsxsx = getmat(fptr->sxnode, fptr->sxnode,subptr);:   fptr->matsxs = getmat(fptr->sxnode, fptr->snode,subptr);:   fptr->matssx = getmat(fptr->snode, fptr->sxnode,subptr);  7   fptr->matdd = getmat(fptr->dnode,fptr->dnode,subptr); 7   fptr->matdg = getmat(fptr->dnode,fptr->gnode,subptr); 7   fptr->matds = getmat(fptr->dnode,fptr->snode,subptr); 7   fptr->matdb = getmat(fptr->dnode,fptr->bnode,subptr);   7   fptr->matss = getmat(fptr->snode,fptr->snode,subptr); 7   fptr->matsd = getmat(fptr->snode,fptr->dnode,subptr); 7   fptr->matsg = getmat(fptr->snode,fptr->gnode,subptr); 7   fptr->matsb = getmat(fptr->snode,fptr->bnode,subptr);   7   fptr->matbb = getmat(fptr->bnode,fptr->bnode,subptr); 7   fptr->matbd = getmat(fptr->bnode,fptr->dnode,subptr); 7   fptr->matbs = getmat(fptr->bnode,fptr->snode,subptr);      if(dcflag == FALSE) { 9     fptr->matgg = getmat(fptr->gnode,fptr->gnode,subptr); 9     fptr->matgd = getmat(fptr->gnode,fptr->dnode,subptr); 9     fptr->matgs = getmat(fptr->gnode,fptr->snode,subptr); 9     fptr->matgb = getmat(fptr->gnode,fptr->bnode,subptr); 9     fptr->matbg = getmat(fptr->bnode,fptr->gnode,subptr);    }  }      /*9 * Initialize the MOS3 transistor by precalculating values  */ finishmod3(mptr)  register struct inm3model *mptr; {  double sqrt(), log(), exp();.   if(mptr->tox == 0.0) mptr->tox = 1000.0e-10;    mptr->cox = EPSOX / mptr->tox;   mptr->vtherm = VTHERM;2   mptr->csoncopp = CHARGE * mptr->nfs / mptr->cox;   mptr->nsub   *=  1.0e6;    mptr->nfs    *=  1.0e4;    mptr->nss    *=  1.0e4; @   if( (mptr->uo == 0.0) && (mptr->kp == 0.0) ) mptr->uo = 600.0;   mptr->uo *= 1.0e-4; 6   if(mptr->kp == 0.0) mptr->kp = mptr->uo * mptr->cox;;   if(mptr->nsub != 0.0) { /* coeff. of depl. layer width */ :     mptr->alpha = (EPSSIL + EPSSIL)/(CHARGE * mptr->nsub);!     mptr->xd = sqrt(mptr->alpha);    } F   if (mptr->vto == 0.0) {; } /* >>>>>>>>> calculate it if not given */M   if(mptr->type < 0.0) mptr->vto *= -1.0; /* Correct for neg vto on ptype. */    if (mptr->phi == 0.0)	A 	mptr->phi = 2.0 * mptr->vtherm * log(mptr->nsub/ (NI * 1.0e6));  !   mptr->sqphi  = sqrt(mptr->phi); '   if(mptr->gamma == 0.0) mptr->gamma =  9 	sqrt((2.0 * CHARGE) * EPSSIL * mptr->nsub) / mptr->cox ; ,   mptr->eta = mptr->eta * OMEGA / mptr->cox;6   mptr->vbi = mptr->vto - (mptr->gamma * mptr->sqphi);2   if(mptr->xj != 0.0) mptr->onxj = 1.0 / mptr->xj;  1 /* Mosfet diode parameters. S is for sidewall. */ G   mptr->djunc = (struct mosdiode *) ralloc(1, sizeof(struct mosdiode)); F   finishmosd(mptr->pb, mptr->mj, mptr->fc, mptr->vtherm, mptr->djunc);E   mptr->dsw = (struct mosdiode *) ralloc(1, sizeof(struct mosdiode)); F   finishmosd(mptr->pb, mptr->mjsw, mptr->fc, mptr->vtherm, mptr->dsw); }    /*G * This routine takes the m3 mosfet model parameters and moves them into D * the m3 mosfet element.  Element area dependent parameters are also * calculated here.   *  * Variables passed: # * fptr - m3 mosfet element pointer. ! * mptr - m3 mosfet model pointer.   * width - fet topological width." * length - fet topological length.L * as - area of the transistor source (used to scale diodes and resistances).K * ad - area of the transistor drain (used to scale diodes and resistances). ? * ass - area of the fet source sidewall (used to scale diodes). 5 * asd - area of the fet drain (used to scale diodes). < * nrs - number of squares for source resistance calculation.; * nrd - number of squares for drain resistance calculation.  */< m2im3(fptr, mptr, length, width, as, ad, ass, asd, nrs, nrd) struct inm3model *mptr;  struct fet3 *fptr;1 double width, length, as, ad, ass, asd, nrs, nrd;  { 
 double log();    fptr->mptr = mptr;  0 /***** W and L and area dependent parameters. */$   fptr->l = length - 2.0 * mptr->ld;   fptr->w = width;1   fptr->betap = ( fptr->w / fptr->l ) * mptr->kp;   " /* narrow channel effect factor */1   fptr->fnarrw = mptr->delta * PIover2 * EPSSIL /  					(mptr->cox * fptr->w);  /* static feedback coeff */ :   fptr->sigma = mptr->eta / (fptr->l * fptr->l * fptr->l);  . /* Source and drain resistance computation. */8   if(mptr->rs != 0.0) fptr->gs = 1.0 / (mptr->rs * nrs);   else fptr->gs = 0.0;8   if(mptr->rd != 0.0) fptr->gd = 1.0 / (mptr->rd * nrd);   else fptr->gd = 0.0;   /* Charge model parameters. */.   fptr->cgsub = mptr->cox * fptr->w * fptr->l;#   fptr->cgs = mptr->cgso * fptr->w; #   fptr->cgd = mptr->cgdo * fptr->w; #   fptr->cgb = mptr->cgbo * fptr->l;   ; /* Diode parameters. Make sure diodes have nonzero Is's. */    fptr->isad = mptr->js * ad;    fptr->isas = mptr->js * as; .   if(fptr->isas == 0.0) fptr->isas = mptr->is;N   if(fptr->isas!= 0.0) fptr->svmax = (log((MIMAX/fptr->isas) + 1.0)) * VTHERM;.   if(fptr->isad == 0.0) fptr->isad = mptr->is;N   if(fptr->isad !=0.0) fptr->dvmax = (log((MIMAX/fptr->isad) + 1.0)) * VTHERM;   fptr->cjas = as * mptr->cj;    fptr->cjad = ad * mptr->cj; !   fptr->cjass = ass * mptr->cjsw; !   fptr->cjasd = asd * mptr->cjsw;  }    /*G * This routine creates a ti fet element from read in parameters and the  * mosfet model.  */B struct device *iprm3(nextdev,netlist,numparams,paramlist,modelptr) struct device *nextdev;  int netlist[], numparams;  ip_param paramlist[];  struct inm3model *modelptr;  {  struct device *m3init(); struct fet3 *fptr; int i, stuffm3(); ! double as,ad,ass,asd,w,l,nrs,nrd;    /* Allocate the device. */   nextdev->utype = FET3;   nextdev->flag = 0;   nextdev->initdev = m3init;   nextdev->stuffdev = stuffm3;<   nextdev->devptr = (char *) ralloc(1, sizeof(struct fet3));)   fptr = (struct fet3 *) nextdev->devptr; E   nextdev->next = (struct device *) ralloc(1, sizeof(struct device));    nextdev = nextdev->next;   nextdev->next = NULL;      /* Get the node numbers. */    fptr->dnode = netlist[0];    fptr->gnode = netlist[1];    fptr->snode = netlist[2];    fptr->bnode = netlist[3];    w = modelptr->w;   l = modelptr->l;   as = modelptr->as;   ad = modelptr->ad;   ass = modelptr->ass;   asd = modelptr->asd;   nrs = modelptr->nrs;   nrd = modelptr->nrd;  > /* Get the length, width, as, ad, ass, pd params, if given. */    for(i=0; i < numparams; i++) {      switch(paramlist[i].id[0]) {3       case 'a'  : w = pareval(paramlist[i]); break; 3       case 'b'  : l = pareval(paramlist[i]); break; 4       case 'c'  : as = pareval(paramlist[i]); break;4       case 'd'  : ad = pareval(paramlist[i]); break;5       case 'e'  : ass = pareval(paramlist[i]); break; 5       case 'f'  : asd = pareval(paramlist[i]); break; 5       case 'g'  : nrs = pareval(paramlist[i]); break; 5       case 'h'  : nrd = pareval(paramlist[i]); break; E       default   : printf("Nonexist param spec'ed for m3\n"); exit(0);      }    } :   m2im3(fptr, modelptr, l, w, as, ad, ass, asd, nrs, nrd);C /* Reserve internal node numbers for source and drain resistors. */ 1   if(fptr->gs != 0.0) fptr->sxnode = ++internals; 1   if(fptr->gd != 0.0) fptr->dxnode = ++internals;    return(nextdev); }    /*. * Get the model parameters from the front end. */( char *ipm3rm(type, numparams, paramlist) double type; int numparams; ip_param *paramlist; {  struct allmod *modptr; struct inm3model *fptr;  struct device *iprm3(); 
 double tempd;  int i;  # /* Allocate space for the model. */ ?   modptr = (struct allmod *) ipalloc(1, sizeof(struct allmod)); B   fptr = (struct inm3model *) ralloc(1, sizeof(struct inm3model));   modptr->type = FET3;   modptr->dev = (char *) fptr;   modptr->readdev = iprm3;  /* Put in the model defaults. */   fptr->w=1.0; fptr->l=1.0;    fptr->vto=0.0; fptr->kp=0.0;  !   fptr->gamma=0.0; fptr->phi=0.0; 1   fptr->cgso=0.0; fptr->cgdo=0.0; fptr->cgbo=0.0; 2   fptr->tox=1.0e-7; fptr->nsub=0.0; fptr->nfs=0.0;-   fptr->xj=0.0; fptr->ld=0.0; fptr->uo=600.0; 3   fptr->vmax=0.0; fptr->delta=0.0; fptr->theta=0.0; !   fptr->eta=0.0; fptr->kappa=0.2; ) /* Bulk and sidewall diode parameters. */ 7   fptr->as=0.0; fptr->ad=0.0; fptr->ass=0; fptr->asd=0; 1   fptr->fc = 0.5; fptr->js=0.0; fptr->is=1.0e-14; $   fptr->mj = 0.5; fptr->mjsw = 0.5; #   fptr->cj = 0.0; fptr->cjsw = 0.0;    fptr->pb = 0.80;, /* Place in the passed type, nmos or pmos */   fptr->type = type; /* Read in the model. */    for(i=0; i < numparams; i++) {I     switch(paramlist[i].id[0]) {  /* switch on first char in param id. */ 8       case 'a' : fptr->w = pareval(paramlist[i]); break;8       case 'b' : fptr->l = pareval(paramlist[i]); break;9       case 'c' : fptr->as = pareval(paramlist[i]); break; 9       case 'd' : fptr->ad = pareval(paramlist[i]); break; :       case 'e' : fptr->ass = pareval(paramlist[i]); break;:       case 'f' : fptr->asd = pareval(paramlist[i]); break;:       case 'g' : fptr->nrs = pareval(paramlist[i]); break;:       case 'h' : fptr->nrd = pareval(paramlist[i]); break;:       case 'i' : fptr->vto = pareval(paramlist[i]); break;9       case 'j' : fptr->kp = pareval(paramlist[i]); break; <       case 'k' : fptr->gamma = pareval(paramlist[i]); break;:       case 'l' : fptr->phi = pareval(paramlist[i]); break;;       case 'm' : fptr->cgso = pareval(paramlist[i]); break; ;       case 'n' : fptr->cgdo = pareval(paramlist[i]); break; ;       case 'o' : fptr->cgbo = pareval(paramlist[i]); break; :       case 'p' : fptr->tox = pareval(paramlist[i]); break;;       case 'q' : fptr->nsub = pareval(paramlist[i]); break; :       case 'r' : fptr->nfs = pareval(paramlist[i]); break;9       case 's' : fptr->xj = pareval(paramlist[i]); break; 9       case 't' : fptr->ld = pareval(paramlist[i]); break; 9       case 'u' : fptr->uo = pareval(paramlist[i]); break; ;       case 'v' : fptr->vmax = pareval(paramlist[i]); break; <       case 'w' : fptr->delta = pareval(paramlist[i]); break;<       case 'x' : fptr->theta = pareval(paramlist[i]); break;:       case 'y' : fptr->eta = pareval(paramlist[i]); break;<       case 'z' : fptr->kappa = pareval(paramlist[i]); break;9       case 'A' : fptr->fc = pareval(paramlist[i]); break; 9       case 'B' : fptr->js = pareval(paramlist[i]); break; 9       case 'C' : fptr->mj = pareval(paramlist[i]); break; ;       case 'D' : fptr->mjsw = pareval(paramlist[i]); break; 9       case 'E' : fptr->cj = pareval(paramlist[i]); break; ;       case 'F' : fptr->cjsw = pareval(paramlist[i]); break; 9       case 'G' : fptr->pb = pareval(paramlist[i]); break; 9       case 'H' : fptr->rs = pareval(paramlist[i]); break; 9       case 'I' : fptr->rd = pareval(paramlist[i]); break; :       case 'J' : fptr->nss = pareval(paramlist[i]); break;9       case 'K' : fptr->is = pareval(paramlist[i]); break;      }    }    finishmod3(fptr);    return((char *) modptr); }   
 disfet3(fptr)  struct fet3 *fptr; {  struct inm3model *mptr; 1   printf("d=%d, g=%d, s=%d, b=%d dx=%d sx=%d\n",  N    fptr->dnode,fptr->gnode,fptr->snode,fptr->bnode,fptr->dxnode,fptr->sxnode);(   printf("type=%g betap=%g cgsub=%g\n", / 			fptr->mptr->type, fptr->betap, fptr->cgsub); +   printf("fnarrw=%g sigma=%g w=%g l=%g\n",  / 		fptr->fnarrw, fptr->sigma, fptr->w, fptr->l); D   printf("cgs=%g cgd=%g cgb=%g\n", fptr->cgs, fptr->cgd, fptr->cgb);.   printf("isas=%g isad=%g cjas=%g cjad=%g\n", 3 			fptr->isas, fptr->isad, fptr->cjas, fptr->cjad); ;   printf("cjass=%g, cjasd=%g\n", fptr->cjass, fptr->cjasd); +   printf("svmax=%g dvmax=%g gs=%g gd=%g\n", 1 		 fptr->svmax, fptr->dvmax, fptr->gs, fptr->gd);    printf("Model parameters\n");    dism3mod(fptr->mptr);  }    dism3mod(fptr) struct inm3model *fptr;  { 3   printf("type=%g vto=%g kp=%g gamma=%g phi=%g\n",  ; 		fptr->type, fptr->vto, fptr->kp, fptr->gamma, fptr->phi); )   printf("pb=%g tox=%g nsub=%g nfs=%g\n", . 		fptr->pb, fptr->tox, fptr->nsub, fptr->nfs);%   printf("xj=%g ld=%g uo=%g fc=%g\n", * 		fptr->xj, fptr->ld, fptr->uo, fptr->fc);,   printf("cox=%g cgso=%g cgdo=%g cgbo=%g\n",1 		fptr->cox, fptr->cgso, fptr->cgdo, fptr->cgbo); 7   printf("vmax=%g delta=%g theta=%g eta=%g kappa=%g\n", N                 fptr->vmax, fptr->delta, fptr->theta, fptr->eta, fptr->kappa);0   printf("js=%g mj=%g mjsw=%g cj=%g cjsw=%g\n", 8 		fptr->js, fptr->mj, fptr->mjsw, fptr->cj, fptr->cjsw);,   printf("alpha=%g sqphi=%g xd=%g vbi=%g\n",1 		fptr->alpha, fptr->sqphi, fptr->xd, fptr->vbi); B   printf("csoncopp=%g vtherm=%g\n", fptr->csoncopp, fptr->vtherm);.   printf("rs=%g rd=%g\n", fptr->rs, fptr->rd);7   printf("Junction diode\n"); dismosdiode(fptr->djunc); 5   printf("Sidewall diode\n"); dismosdiode(fptr->dsw);  }    /*  D * Routine to test the continuity of the device current calculations. */   #define testclearall \C     for(j=1; j < 5; j++) { current2[j] = 0.0; charge2[j] = 0.0; } \ 1     gdg = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0; \ 1     gsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0; \ 1     gbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0; \ /     ggb = 0.0; ggd = 0.0; ggs = 0.0; ggg = 0.0;    testfet3(fptr) struct fet3 *fptr; { 6 double current[5], current2[5], charge[5], charge2[5];7 double dummy, vbs, vgs, vds, compgdg, compgdd, compgdb; * double compcgs, compcgd, compcgb, compcgg;* double compcds, compcdd, compcdb, compcdg;* double compcss, compcsd, compcsb, compcsg;* double compcbs, compcbd, compcbb, compcbg;. double gdg, gds, gdb, gdd, gsd, gsb, gss, gsg;. double gbg, gbs, gbd, gbb, ggd, ggb, ggg, ggs;& double *temp1, *temp2, *temp3, *temp4;& double *temp5, *temp6, *temp7, *temp8;) double *temp9, *temp10, *temp11, *temp12; * double *temp13, *temp14, *temp15, *temp16;* double delta, vth, m3justid(), m3compid(); int i, j, k, l;  int dnode, snode, bnode, gnode;      printf("Testing a device\n");    disfet3(fptr);     FET3_GMIN = 1.0e-12;   delta = 1.0e-6;   '   dnode = fptr->dnode; fptr->dnode = 1; '   snode = fptr->snode; fptr->snode = 2; '   bnode = fptr->bnode; fptr->bnode = 3; '   gnode = fptr->gnode; fptr->gnode = 4;   *   temp1 = fptr->matdg; fptr->matdg = &gdg;*   temp2 = fptr->matds; fptr->matds = &gds;*   temp3 = fptr->matdb; fptr->matdb = &gdb;*   temp4 = fptr->matdd; fptr->matdd = &gdd;  *   temp5 = fptr->matsg; fptr->matsg = &gsg;*   temp6 = fptr->matsd; fptr->matsd = &gsd;*   temp7 = fptr->matsb; fptr->matsb = &gsb;*   temp8 = fptr->matss; fptr->matss = &gss;  *   temp9 = fptr->matbg; fptr->matbg = &gbg;+   temp10 = fptr->matbd; fptr->matbd = &gbd; +   temp11 = fptr->matbs; fptr->matbs = &gbs; +   temp12 = fptr->matbb; fptr->matbb = &gbb;   +   temp13 = fptr->matgg; fptr->matgg = &ggg; +   temp14 = fptr->matgd; fptr->matgd = &ggd; +   temp15 = fptr->matgs; fptr->matgs = &ggs; +   temp16 = fptr->matgb; fptr->matgb = &ggb;     &   for(k = -10000; k <= 1000; k += 500)% 	     for(i=0; i <= 10000; i += 200)  ' 		     for(l=0; l <= 10000; l += 200) {      vgs = i * 0.001;     vbs = k * 0.001;     vds = l * 0.001;          testclearall;   7 /* Compute the nominal values of current and charge. */ ?     for(j=1; j < 5; j++) { current[j] = 0.0; charge[j] = 0.0; } 9     vth = m3compid(fptr, vgs, vbs, vds, &dummy, current); :     m3compq(fptr, vgs, vbs, vds, vth, dummy, charge, 1.0);2     vth = m3justid(fptr, vgs, vbs, vds, current2);/     m3justq(fptr, vgs, vbs, vds, vth, charge2);        for(j=1; j < 5; j++) {  *       if(dabs(current2[j] - current[j]) > 3 			(0.01 * (nrcrel * dabs(current[j]) + nrcabs))) { 4         printf("Right hand side only error.!!!!\n");<         printf("rhs=%g full=%g\n", current2[j], current[j]);8         printf("vgs=%g vbs=%g vds=%g\n", vgs, vbs, vds);       } (       if(dabs(charge[j] - charge2[j]) > 2 		(0.01 * (nrcrel * dabs(charge[j]) + 1.0e-20))) {;         printf("Right hand side only charge error.!!!!\n"); :         printf("rhs=%g full=%g\n", charge2[j], charge[j]);8         printf("vgs=%g vbs=%g vds=%g\n", vgs, vbs, vds);       }      }        testclearall;   M     vth = m3compid(fptr, (double) (vgs + delta), vbs, vds, &dummy, current2); B     compgdg = fptr->mptr->type * (current2[1] - current[1])/delta;3     checkderiv(compgdg, gdg, vgs, vds, vbs, "gdg");        testclearall;   E     m3compq(fptr, (vgs + delta), vbs, vds, vth, dummy, charge2, 1.0); @     compcgg = fptr->mptr->type * (charge2[4] - charge[4])/delta;@     compcbg = fptr->mptr->type * (charge2[3] - charge[3])/delta;@     compcsg = fptr->mptr->type * (charge2[2] - charge[2])/delta;@     compcdg = fptr->mptr->type * (charge2[1] - charge[1])/delta;  3     checkderiv(compcgg, ggg, vgs, vds, vbs, "cgg"); 3     checkderiv(compcbg, gbg, vgs, vds, vbs, "cbg"); 3     checkderiv(compcsg, gsg, vgs, vds, vbs, "csg"); 3     checkderiv(compcdg, gdg, vgs, vds, vbs, "cdg");        testclearall; M     vth = m3compid(fptr, vgs, vbs, (double) (vds + delta), &dummy, current2); B     compgdd = fptr->mptr->type * (current2[1] - current[1])/delta;3     checkderiv(compgdd, gdd, vgs, vds, vbs, "gdd");        testclearall;   E     m3compq(fptr, vgs, vbs, (vds + delta), vth, dummy, charge2, 1.0); @     compcdd = fptr->mptr->type * (charge2[1] - charge[1])/delta;@     compcbd = fptr->mptr->type * (charge2[3] - charge[3])/delta;@     compcsd = fptr->mptr->type * (charge2[2] - charge[2])/delta;@     compcgd = fptr->mptr->type * (charge2[4] - charge[4])/delta;  3     checkderiv(compcdd, gdd, vgs, vds, vbs, "cdd"); 3     checkderiv(compcbd, gbd, vgs, vds, vbs, "cbd"); 3     checkderiv(compcsd, gsd, vgs, vds, vbs, "csd"); 3     checkderiv(compcgd, ggd, vgs, vds, vbs, "cgd");        testclearall; G     m3compid(fptr, vgs, (double) (vbs + delta), vds, &dummy, current2); B     compgdb = fptr->mptr->type * (current2[1] - current[1])/delta;3     checkderiv(compgdb, gdb, vgs, vds, vbs, "gdb");        testclearall;   E     m3compq(fptr, vgs, (vbs + delta), vds, vth, dummy, charge2, 1.0); @     compcbb = fptr->mptr->type * (charge2[3] - charge[3])/delta;@     compcdb = fptr->mptr->type * (charge2[1] - charge[1])/delta;@     compcsb = fptr->mptr->type * (charge2[2] - charge[2])/delta;@     compcgb = fptr->mptr->type * (charge2[4] - charge[4])/delta;  3     checkderiv(compcbb, gbb, vgs, vds, vbs, "cbb"); 3     checkderiv(compcdb, gdb, vgs, vds, vbs, "cdb"); 3     checkderiv(compcsb, gsb, vgs, vds, vbs, "csb"); 3     checkderiv(compcgb, ggb, vgs, vds, vbs, "cgb");    }      fptr->dnode = dnode;   fptr->snode = snode;   fptr->bnode = bnode;   fptr->gnode = gnode;     fptr->matdg = temp1;   fptr->matsg = temp2;  "   printf("done testing device\n"); }     6 checkderiv(compderiv, deriv, vgs, vds, vbs, derivtype)' double compderiv, deriv, vgs, vds, vbs;  char *derivtype; { T   if( dabs(compderiv-deriv) > (0.005*(FET3_GMIN + dabs(compderiv) + dabs(deriv)))) {'       printf("Derivative Error!!!!\n"); 6       printf("vds=%g vbs=%g vgs=%g\n",	vds, vbs, vgs);G       printf("deriv%s=%g compderiv=%g\n", derivtype, deriv, compderiv);    }  } 