 #include <stdio.h> #include <math.h>  #include "simconst.h"  #include "simmac.h"  #include "simstruct.h" #include "simglbdef.h"  8 /* Start a new window by extrapolating from the past. */, startwind(subptr, newtime, present, oldtime). struct timepoint *newtime, *present, *oldtime; struct subcircuit *subptr; {  struct waveform *pw; int i; long pickstep();  < /* Start the input waveforms pointing to the right place. */)   for(i = subptr->external; i < 0; i++) { D     subptr->inwavearray[i] = pw = subptr->waveptrarray[i]->previous;)     pw->lastloc = wavepos(pw, starttime);    }   1 /* Copy the timepoints to restart window with. */ J   copytimept(newtime, &(subptr->savenew), subptr->size, subptr->external);K   copytimept(present, &(subptr->savepres), subptr->size, subptr->external); J   copytimept(oldtime, &(subptr->saveold), subptr->size, subptr->external);*   subptr->savelteratio = subptr->lteratio;.   subptr->ltestep = pickstep(subptr->lteratio,9 		(newtime->time - present->time),newtime->time, subptr); ! /* Store the first two points. */ 9   subptr->offset = storewave(subptr->present, 0, subptr); F   subptr->offset = storewave(subptr->newtime, subptr->offset, subptr); }     G /* Restartwindow sets up a subcircuit for simulation.  It first checks  G * for partial waveform convergence.  It there is none (or very little)  E * simulation is begun from the beginning of the window.  If there is  G * partial waveform convergence then things get tricky.  The simulation  G * must be restarted, but in the middle of the window.  It is important    * to make absolutely sure that: 9 * 1: All the inputs have converged to at least that time. + * 2: The timestep information is preserved. F * 5/19/84 - This approach creates wierd false convergence behavior, soE * instead the partial waveform convergence is done up to the end of a 	 * window.  */+ restartw(subptr, newtime, present, oldtime) . struct timepoint *oldtime, *present, *newtime; struct subcircuit *subptr; {  struct waveform *pw1, *pw2;  int i, j, partflg=TRUE;  long pickstep();  ; /* See if all the inputs have all converged to stoptime. */ )   for(i = subptr->external; i < 0; i++) { E     subptr->inwavearray[i] = pw2 = subptr->waveptrarray[i]->previous; N     if((pw2->difftime < stoptime) && (pw2->wavetype !=USERSRC)) partflg=FALSE;+     pw2->lastloc = wavepos(pw2, starttime);    }      I /* If all converged, and the windowsize is unchanged, we have partial. */ :   if( (partflg == TRUE) && (newtime->time == stoptime) ) {4     subptr->ltestep = newtime->time - present->time;L     for(i = 1; i <= subptr->size; i++) { /* Copy previous iter waveforms. */.       pw1 = subptr->waveptrarray[i]->previous;-       pw2 = subptr->waveptrarray[i]->present; +       for(j=0; j <= pw1->wavesize; j++) {   I         pw2->voltage[j] = pw1->voltage[j]; pw2->time[j] = pw1->time[j]; } $       pw2->wavesize = pw1->wavesize;#       pw2->lastloc = pw1->wavesize;      }    }   1 /* Otherwise just restart from last iteration. */    else {,     subptr->lteratio = subptr->savelteratio;L     copytimept(&(subptr->savenew), newtime, subptr->size, subptr->external);M     copytimept(&(subptr->savepres), present, subptr->size, subptr->external); L     copytimept(&(subptr->saveold), oldtime, subptr->size, subptr->external);1     subptr->ltestep = pickstep(subptr->lteratio,  : 		(newtime->time - present->time), newtime->time, subptr);3     subptr->offset = storewave(present, 0, subptr); @     subptr->offset = storewave(newtime, subptr->offset, subptr);   }  }   K /* Copy on timepoint structure to another, with all the vectors as well. */ " copytimept(from, to, size, inputs) struct timepoint *to, *from; int size, inputs;  {  int i;   to->time = from->time;   for(i=1; i <= size; i++) {&     to->current[i] = from->current[i];$     to->charge[i] = from->charge[i];(     to->nodevolt[i] = from->nodevolt[i];   } @   for(i=inputs; i < 0; i++) to->nodevolt[i] = from->nodevolt[i]; }    /*  % * List of input source break points.   */ struct breakpoint {    struct breakpoint *next;   long time; };  / struct breakpoint *breakpoints=NULL, *mrubreak;    appendbreak(waveptr) struct waveform *waveptr;  {  struct breakpoint *newbreak; int i, haveit;   if(breakpoints == NULL) { M     breakpoints = (struct breakpoint *) ralloc(1, sizeof(struct breakpoint));      breakpoints->next = NULL; !     breakpoints->time = stoptime;    } )   for(i=0; i <= waveptr->wavesize; i++) {   0   /* First see if this point is already here. */1     for(haveit = FALSE , mrubreak = breakpoints;  1 			mrubreak != NULL; mrubreak = mrubreak->next) { =       if(( (mrubreak->time - minstep) < waveptr->time[i] ) && = 	      		( (mrubreak->time + minstep) > waveptr->time[i] )) {          haveit = TRUE;         break;       }      }      if(haveit == FALSE) { L       newbreak = (struct breakpoint *) ralloc(1, sizeof(struct breakpoint));       newbreak->next = NULL;(       newbreak->time = waveptr->time[i];       mrubreak = breakpoints; +       if(newbreak->time < mrubreak->time) { "         newbreak->next = mrubreak;         breakpoints = newbreak;        } ?       else for(; mrubreak != NULL; mrubreak = mrubreak->next) { $         if(mrubreak->next == NULL) {$           mrubreak->next = newbreak;$           mrubreak = mrubreak->next;            mrubreak->next = NULL;           break;	         } 8         else if(mrubreak->next->time > newbreak->time) {*           newbreak->next = mrubreak->next;$           mrubreak->next = newbreak;           break;	         }        }      }    }  }    /*  2 * Shrinks the window if too many points were used.H * Note that if this happens, and WR is being used, another WR iteration G * MUST be performed, to make sure every subcircuit waveform ends at the : * same point. If direct methods are used, doesn't matter. 7 * Otherwise, check if entire window converged and make  " * return the newwindow flag if so. * A * The global variables starttime and stoptime are affected here.  J * The value newwindow is returned, set true if a new window is to be used. */   #define MAGICITER 6   7 pickwindow(itercnt, endtime, convergtil, usedpts, hmin)  int itercnt, usedpts;  long endtime, convergtil, hmin;  {  long window, temp1, temp2;! static double savelter, saveltea;  int newwindow; struct breakpoint *nbreak;   /*   for(nbreak = breakpoints; + 	(nbreak != NULL); nbreak = nbreak->next) { =     printf("bt=%g %d\n", (nbreak->time * mrt), nbreak->time);    }  */@   newwindow = FALSE; /* Assume a new window will not be made. */6   if(usedpts >= (maxpts - 1) && (dodirect == FALSE) ) 9 		stoptime = starttime + (stoptime-starttime) * bufratio; M   else if(stoptime <= convergtil) { /* All has converged. Make new window. */      newwindow = TRUE; *   /* Select the size of the new window. *//     if(usedpts == 0) { /* Very first window. */ %       window = (0.5 * maxpts * hmin); &       window = min(window,maxwindow);      } +     else { /* Not the very first window. */ $       window = stoptime - starttime;3       temp1 = (maxpts * bufratio * window)/usedpts; :       if((itercnt < 4)&&(usedpts < (maxpts/2 * bufratio)))$ 					temp1 = min(2 * window, temp1);       else temp1 = window;&       window = min( temp1, maxwindow);     }      starttime = stoptime;      stoptime += window;    }   5 /* Else Shrink window if too many iters performed. */    else {      temp1 = itercnt / MAGICITER;$     if((itercnt % MAGICITER) == 0) {@       stoptime = (stoptime - starttime)/(1 + temp1) + starttime;+       stoptime = max(convergtil, stoptime);      }    }   H /* Make sure the window doesn't go beyond the end of the sim interval */+ /* and lands on input source boundaries. */ "   window = (stoptime - starttime);5   temp2 = (12 * window)/10;  /* Beef it up by 20%. */ N   for(nbreak = breakpoints; nbreak->time <= starttime; nbreak = nbreak->next);M   if( (temp2 + starttime) > nbreak->time ) window = nbreak->time - starttime; 3   else if( (2 * temp2 + starttime) > nbreak->time)  0 				window = 1 + (nbreak->time - starttime) / 2;    stoptime = starttime + window;  K /* Adjust local truncation error tolerances if too many iterations used. */  /*  B  if(itercnt < MAGICITER) { savelter = lterel; saveltea = lteabs; }  else {     if(newwindow == FALSE) {       if(itercnt > MAGICITER) {1        lterel = (savelter * MAGICITER) / itercnt; 1        lteabs = (saveltea * MAGICITER) / itercnt;       }    }1    else { lterel = savelter; lteabs = saveltea; }   } */   return(newwindow); }   