 #include <stdio.h> #include <math.h>  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h"  - /* A number used to uniqueify subcircuits. */  static int subnum = 0;  K /*Tempconarray is used as temporary space for subcircuit node conversion.*/  static int *tempconarray;    initmakesub(numnodes) 
 int numnodes;  { I /* Init the tempconarray which is used as temporary space for conarray.*/ J   tempconarray = /* Allow the subcircuit to be as big as whole circuit. */. 	(int *) ralloc((2*(numnodes+2)),sizeof(int));K   tempconarray = &(tempconarray[numnodes+1]); /* Offset for neg indices. */    tempconarray[0] = 0; }    struct subcircuit *wholesub()  {  struct subcircuit *subptr;4 struct nodedevlist *nextptr, *firstptr, *nodeentptr; struct deventry *nextdev; 
 int i, count;   5 /* Find the first node which is not a source node. */    for(i=1; i <= maxnode; i++) *     if(   (devarray[i].deventptr != NULL) 2        && (waves[i].present->wavetype != USERSRC) L        && ((dcflag == FALSE) || (waves[i].present->wavetype != ICGIVEN )) ){     firstptr = &(devarray[i]);     devarray[i].prev = NULL;     nextptr = firstptr; 
     break;   }    if(i > maxnode) { N     printf("Warning: No dc solution computed, inital conditions specified\n");/     printf("for every node in the circuit.\n");      return(NULL);    }   0 /* Tie all the nodes in the circuit together. */   for(i++; i <= maxnode; i++) *     if(   (devarray[i].deventptr != NULL) 2        && (waves[i].present->wavetype != USERSRC) L        && ((dcflag == FALSE) || (waves[i].present->wavetype != ICGIVEN )) ){#     nextptr->next = &(devarray[i]);      devarray[i].prev = nextptr;      nextptr = &(devarray[i]);    }    /* Make the subcircuit. */   makesub(firstptr);   subptr = firstptr->subptr;  6 /* Unconnect the nodes (to set up for partitioner). */   for(i=1; i <= maxnode; i++) { 5     devarray[i].prev = NULL; devarray[i].next = NULL;    }   5 /* And return a pointer to the created subcircuit. */    return(subptr);  }    /*< * Goes through the devarray, and builds all the subcircuits.@ * The process leaves pointers in each node entry in the devarray( * pointing to its associated subcircuit. */ buildsubs()  {  struct nodedevlist *pnode; int i;   for(i=1; i <= maxnode; i++) {      pnode = &(devarray[i]); #     if( (pnode->deventptr != NULL)  =                   && (waves[i].present->wavetype != USERSRC)  &        					&& (pnode->prev == NULL) ) 						      makesub(pnode);    }  }      /*6  * Makesub builds a subcircuits out of the information:  * in the devarray, starting from nodeentptr. The routines"  * side effects are that it leaves=  * a pointer in each node entry of the subcircuit pointing to   * the built subcircuit.  */  makesub(nodeentptr)  struct nodedevlist *nodeentptr;  {  double *getmat();  struct nodedevlist *nextptr; struct subcircuit *subptr; struct nodewave *wavealloc(); " struct device *devptr, *copymap(); int i,k; int numobj;   4 /* Unique number associated with this subcircuit. */   subnum++;  /* Map node zero to zero. */5   devarray[0].flag = subnum; devarray[0].newnode = 0;     /* Catch a programming error. */!   if(nodeentptr->prev != NULL) {  *     printf("Subcircuit building error.");      exit(0);   }   7 /* Allocate space for and initialize the subcircuit. */ F   subptr = (struct subcircuit *) ralloc(1, sizeof(struct subcircuit));   subptr->external = 0;    subptr->offset = 0;    subptr->next = NULL;   subptr->ltestep = maxstep;   subptr->lteratio = 1.0;    subptr->savelteratio = 1.0; L   subptr->size = 0; /* Get size, assign sequential internal node numbers. */   subptr->subnum = subnum;   subptr->rank = 0; 5   subptr->sparse = -1; /* No Matrix allocated yet. */    subptr->schednow = FALSE;    subptr->schednext = FALSE;   subptr->nummosmodels = 0;   F /* Get the number of internal nodes in the subcircuit and map them. */G   for(nextptr = nodeentptr; nextptr != NULL; nextptr = nextptr->next) {      (subptr->size)++;        nextptr->ltestep = 0;   2     tempconarray[subptr->size] = nextptr->nodenum;     nextptr->flag = subnum; $     nextptr->newnode = subptr->size;     nextptr->subptr = subptr;    }   L /* Get all the devices into the subcircuit. Note that subptr->size can be */: /* altered because the devices can have internal nodes. */4   subptr->subdevlist = copymap(nodeentptr, subptr);   . /* Get space for node map and set pointers. */)   subptr->node = (struct nodedevlist **)  = 		ralloc( (subptr->size + 1), sizeof(struct nodedevlist *) );    k = 0;G   for(nextptr = nodeentptr; nextptr != NULL; nextptr = nextptr->next) { #     k++; subptr->node[k] = nextptr;    }   A /* Now that size is known, Allocate a matrix and some vectors. */    allocmat(subptr); L   subptr->predictor = (double *) ralloc((subptr->size + 1), sizeof(double));F   subptr->rhs = (double *) ralloc((subptr->size + 1), sizeof(double));K   subptr->oldstuff = (double *) ralloc((subptr->size + 1), sizeof(double));   L /* Having allocated the matrix, map the matrix elements into the devices. */K   for(devptr = subptr->subdevlist; devptr != NULL; devptr = devptr->next) { /     (*devptr->initdev)(devptr->devptr, subptr);    }   < /* Create an array of pointers to the external waveforms  */-   subptr->waveptrarray = (struct nodewave **) L     ralloc((1 + subptr->size - subptr->external),sizeof(struct nodewave *));+   subptr->waveptrarray -= subptr->external; ,   subptr->inwavearray = (struct waveform **)> 	    ralloc((1 - subptr->external),sizeof(struct waveform *));*   subptr->inwavearray -= subptr->external;3   for(i=subptr->external; i <= subptr->size; i++) { @     subptr->waveptrarray[i] = wavealloc(tempconarray[i],NOCHNG);   }     /* Get the node capacitances. */K   subptr->sumcap = (double *) ralloc( (subptr->size + 1), sizeof(double) ); N   subptr->summatptr = (double **) ralloc((subptr->size + 1),sizeof(double *));$   for(i=1; i <= subptr->size; i++) {9     subptr->sumcap[i] = devarray[tempconarray[i]].sumcap; .     subptr->summatptr[i] = getmat(i,i,subptr);   }     /* Initialize the timepoints. */'   subptr->old2 = &(subptr->tpttemp1);   $   subptr->old = &(subptr->tpttemp2);(   subptr->present = &(subptr->tpttemp3);(   subptr->newtime = &(subptr->tpttemp4);?   inittimept(subptr->present,subptr->size, subptr->external);   :   inittimept(subptr->old2,subptr->size, subptr->external);9   inittimept(subptr->old,subptr->size, subptr->external); =   inittimept(subptr->newtime,subptr->size, subptr->external);   $ /* Initialize the save old times. */B   inittimept( &(subptr->saveold2),subptr->size, subptr->external);A   inittimept( &(subptr->saveold),subptr->size, subptr->external); B   inittimept( &(subptr->savepres),subptr->size, subptr->external);A   inittimept( &(subptr->savenew),subptr->size, subptr->external);  }      /*J * Checks whether a global node has been mapped to a local subcircuit node 6 * and if not, maps it. Returns the local node number.  */ chksubnode(subptr, nodenum)  int nodenum; struct subcircuit *subptr; {  int j; /* Check the range. */(   if(nodenum >= (maxnode + internals)) {4 		 printf("out of range in chksub = %d\n", nodenum);   } . /* First see if its an already mapped node. */I   if(devarray[nodenum].flag == subnum) return(devarray[nodenum].newnode);  /* Otherwise map the node. */    (subptr->external)--; +   tempconarray[subptr->external] = nodenum; "   devarray[nodenum].flag = subnum;/   devarray[nodenum].newnode = subptr->external;    return(subptr->external);  }    /*  4 * Same a chksubnode but does not map unknown nodes. 5 * Returns zero if node is not mapped to a local node.  */ nomapchk(subptr, nodenum)  int nodenum; struct subcircuit *subptr; {  int j;. /* First see if its an already mapped node. */&   if(nodenum >= (maxnode + internals))6 		 printf("out of range in nomapchk = %d\n", nodenum);"   if(nodenum > maxnode) return(0);I   if(devarray[nodenum].flag == subnum) return(devarray[nodenum].newnode);  /* Otherwise return 0. */    return(0); }    /*I * Allocnode allocates a new local node number.  This includes bumping the D * size of the subcircuit and using one of the waveforms reserved for * internal nodes.  */ allocnode(subptr,intnode)  struct subcircuit *subptr; int intnode; {    subptr->size++; '   tempconarray[subptr->size] = intnode; '   if(intnode > (maxnode + internals)) { J     printf("Program error: insufficient number of internals reserved.\n");     exit(0);   }    if(intnode <= maxnode) {?     printf("Program Error: internal node number too small.\n");    }    return(subptr->size);  }    /*A * Chase down device entry list, get the number of external nodes, * * and make a map of local to global nodes.) * This map is stored in the tempconarray.  */' struct device *copymap(firstptr,subptr)  struct nodedevlist *firstptr;  struct subcircuit *subptr; { 7 struct device *pdevlist, *pdev, **pnextdev, *initdev(); % struct deventry *entryptr,*pchkentry; ' struct nodedevlist *nextptr, *pchknext;   @ /* Get a pointer to the top of the to be created device list. */   pdevlist = NULL;     pnextdev = &(pdevlist);   D /* Chase down the list of devices, and copy, map nodes, and init. */C   for(nextptr = firstptr; nextptr != NULL; nextptr = nextptr->next) 8     for(entryptr = nextptr->deventptr; entryptr != NULL;" 					 entryptr = entryptr->next) {     pdev = entryptr->devptr;D   /* If the flag is not = to subnum this sub hasn't got this dev. */     if(pdev->flag != subnum) {         pdev->flag = subnum;9       *pnextdev = (*pdev->initdev)(subptr, pdev->devptr);        if(*pnextdev != NULL) { @ 		(*pnextdev)->next = NULL; pnextdev = &( (*pnextdev)->next ); }     }    }    return(pdevlist);  }    /** * Initialize the timepoint data structure.< * This mostly involves allocating vectors for node voltages, * charges and currents.  */& inittimept(timeptr, subsize, external) struct timepoint *timeptr; int subsize, external; {  int numobj; $   numobj = 1 + (subsize - external);A   timeptr->nodevolt = (double *) ralloc( numobj, sizeof(double));     timeptr->nodevolt -= external;>   timeptr->nodevolt[0] = 0.0;  /* Ground is zero is ground. */   numobj = 1 + subsize; @   timeptr->current = (double *) ralloc( numobj, sizeof(double));   timeptr->current[0] = 0.0;?   timeptr->charge = (double *) ralloc( numobj, sizeof(double));    timeptr->charge[0] = 0.0;    timeptr->time = 0; }    /* Does a byte copy. */  bcopy(from, to, size)  register char *to, *from;  register int size; { 7   for(size--; size >= 0; size--) to[size] = from[size];  } 