F /* This file is the driver for Ken Kundert's sparse Matrix Package. */  ' #include <math.h>    /* Math library */ = #include <errno.h>   /* Error definitions for math library */ % #include <stdio.h>   /* IO library */  #include "simconst.h" : #include "MtrxError.h"    /* Sparse matrix error macros */9 #include "MtrxPers.h"    /* Sparse matrix error macros */  #include "simglbdef.h" #include "simstruct.h"     /*  = * Decompose matrix. Decides whether matrix is sparse or full, = * decomposes appropriately, and returns TRUE unless matrix is , * singular, in which case FALSE is returned. */ ludecompose(subptr)  struct subcircuit *subptr; { * double Growth, Pseudo, elephant, **locmat; int i,j,k, Error;  register int lsize;   7   if(subptr->sparse == FALSE) { /* Full Matrix Case. */     /* Redecompose full matrix. */     lsize = subptr->size; (     locmat = (double **) subptr->matrix;     for(i=1; i <= lsize; i++) { =       if( (locmat[i][i] < FUZZ) && (locmat[i][i] > NFUZZ) ) { 0         printf("Close to singular locmat!!!\n");         return(FALSE);       } ?       for(j=i+1; j <= lsize; j++) locmat[j][i] /= locmat[i][i]; "       for(j=i+1; j <= lsize; j++)  	  for(k=i+1; k <= lsize; k++)  2 		  locmat[j][k] -= (locmat[j][i] * locmat[i][k]);     }    } "   else { /* Sparse Matrix Case. */B   /* Note - Matrix routines are complied to not calculate Growth, )     PseudoCondition or LargestElement. */ H     Error = DecomposeMatrix(subptr->matrix,&Growth, &Pseudo, &elephant);(     if(Error == SINGULAR) return(FALSE);   } * /* Still here? Everything must be okay. */   return(TRUE);  }    /*: * Same as ludecompose, but always uses numerical pivoting. */ dcludecompose(subptr)  struct subcircuit *subptr; { * double Growth, Pseudo, elephant, **locmat; int i,j,k, Error;  register int lsize;   7   if(subptr->sparse == FALSE) { /* Full Matrix Case. */     /* Redecompose full matrix. */     lsize = subptr->size; (     locmat = (double **) subptr->matrix;     for(i=1; i <= lsize; i++) { =       if( (locmat[i][i] < FUZZ) && (locmat[i][i] > NFUZZ) ) { 0         printf("Close to singular locmat!!!\n");         return(FALSE);       } ?       for(j=i+1; j <= lsize; j++) locmat[j][i] /= locmat[i][i]; "       for(j=i+1; j <= lsize; j++)  	  for(k=i+1; k <= lsize; k++)  2 		  locmat[j][k] -= (locmat[j][i] * locmat[i][k]);     }    } "   else { /* Sparse Matrix Case. */B   /* Note - Matrix routines are complied to not calculate Growth, )     PseudoCondition or LargestElement. */ 9     Error = OrderAndDecomposeMatrix(subptr->matrix, NULL, 4 			 DEFAULT_THRESHOLD, &Growth, &Pseudo, &elephant);(     if(Error == SINGULAR) return(FALSE);   } * /* Still here? Everything must be okay. */   return(TRUE);  }    /*  8 * Determines whether this is a sparse matrix or not, and * Solves Matrix.  4 * Right hand side is replace by the solution vector. */ lusol(rhs,subptr)  register double *rhs;  struct subcircuit *subptr; {  register double **locmat;  int i,j;   if(subptr->sparse == FALSE) { (     locmat = (double **) subptr->matrix;$     for(i=1; i <= subptr->size; i++)& 	  for(j=i+1; j <= subptr->size; j++) & 				rhs[j] -= (locmat[j][i] * rhs[i]);%     for(i=subptr->size; i > 0; i--) {        rhs[i] /= locmat[i][i]; @       for(j=1; j <= i-1; j++) rhs[j] -= (locmat[j][i] * rhs[i]);     }    }    else {.     SolveRealMatrix(subptr->matrix, rhs, rhs);   }  }    /* Zero out the matrix. */ szeromat(subptr) struct subcircuit *subptr; {    ClearMatrix(subptr->matrix); }     J /* Get the subcircuit just the right sized matrix and decide whether it */ /* should be sparse or not. */ allocmat(subptr) struct subcircuit *subptr; {  int i; char *AllocateMatrix();  double **locmat;
 int Error;N   if((subptr->size > sprsthrsh) || ((dcflag == TRUE) && (subptr->size > 1))) {N     subptr->matrix = AllocateMatrix(subptr->size, 0,(double) 1.0e-13, &Error);     subptr->sparse = TRUE;   }    else {     subptr->sparse = FALSE; F     locmat = (double **) ralloc((subptr->size + 1), sizeof(double *));1     for(i=1; i <= subptr->size; i++) locmat[i] =  > 		    ( double * ) ralloc((subptr->size + 1), sizeof(double));%     subptr->matrix = (char *) locmat;    }    }   . /* Matrix element pointers for full matrix. */ double *getmat(i,j,subptr)   int i,j; struct subcircuit *subptr; { ' double **locmat, *AddElementToMatrix();    if(subptr->sparse < 0) {B     printf("Attempt to allocate element in nonexistant matrix\n");     exit(0);   }    if( (i > 0) && (j > 0) ) {!     if(subptr->sparse == FALSE) { *       locmat = (double **) subptr->matrix;       return(&(locmat[i][j]));     } 
     else {<       return(AddElementToMatrix(subptr->matrix, i, j, 1.0));     }    }    else return(NULL); }    /* Print the Matrix. */  dismat(subptr) struct subcircuit *subptr; {  int i,j; double **locmat;   if(subptr->sparse == FALSE) { (     locmat = (double **) subptr->matrix;"     printf("displaying matrix\n");(     for(i = 1; i <= subptr->size; i++) {E       for(j = 1; j <= subptr->size; j++) printf("%g ", locmat[i][j]);        printf("\n");      }    }    else {3     printf("No sparse matrix printing routine.\n");    }  }   