 /*  *  MATRIX ALLOCATION MODULE  *  *  Author:   *     Kenneth S. Kundert   *     UC Berkeley  *  *  Advising professor: &  *     Alberto Sangiovanni-Vincentelli  *J  *  This module contains the allocation and deallocation routines for the   *  sparse matrix routines.     *;  *  >>> User accessable functions contained in this module:   *  AllocateMatrix  *  DeallocateMatrix  *+  *  >>> Functions contained in this module:   *  AllocateMatrix  *  GetElement  *  InitializeElementBlocks 
  *  GetFillIn   *  RecordAllocation  *  AllocateBlockAllocationList   *  ExpandMatrix  *  DeallocateMatrix  */            /*  *  IMPORTS   *  *  >>> Import decriptions:   *  stdio.h   *     Standard C IO library.   *  MtrxPers.hH  *     Macros that customize the sparse matrix routines. This file comes6  *     to us indirectly, it is imported by MtrxDefs.h.  *  MtrxExpt.h:  *     Macros and declarations to be imported by the user.  *  MtrxDefs.hH  *     Matrix type and macro definitions for the sparse matrix routines.  *  MtrxError.h &  *     Matrix error macro definitions.  */     #include <stdio.h> #include "MtrxExpt.h"  #include "MtrxDefs.h"  #include "MtrxError.h"             /*  *  MATRIX ALLOCATION   *K  *  Allocates and initializes the data structures associated with a matrix.   *  *  >>> Returned: J  *  A pointer to the matrix is returned cast into the form of a pointer toJ  *  a character.  This pointer is then passed and used by the other matrixK  *  routines to refer to a particular matrix.  If an error ocurrs, the NULL   *  pointer is returned.  *  *  >>> Arguments:  *  Size  <input>  (int)M  *     Size of matrix or estimate of size of matrix if matrix is EXPANDABLE.    *  Complex  <input>  (int) J  *     Type of matrix.  If Complex is 0 then the matrix is real, otherwiseL  *     the matrix will be complex.  Note that if the routines are not set upM  *     to handle the type of matrix requested, then a RANGE error will occur. (  *  AbsoluteThreshold  <input>  (double)I  *     The absolute magnitude an element must have to be considered as a  K  *     pivot candidate, except as a last resort.  This number should be set H  *     significantly smaller than the smallest diagonal element that is I  *     is expected to be placed in the matrix.  If there is no reasonable O  *     prediction for the lower bound on these elements, then AbsoluteThreshold G  *     should be set to zero.  AbsoluteThreshold is used to reduce the  K  *     possiblity of choosing as a pivot an element that has suffered heavy E  *     cancelation and as a result mainly consists of roundoff error.   *  lError  <output>  (int *) M  *     Returns error flag, needed because function MatrixError will not work  P  *     correctly if AllocateMatrix returns NULL. Local version of Matrix->Error,  *     as denoted by l prefix.    *  *  >>> Local variables:  *  AllocatedSize  (int).  *     The size of the matrix being allocated.  *  Matrix  (MatrixPointer) N  *     Local version of gMatrix.  A pointer to the matrix frame being created.  *  *  >>> Global variables:   *  gMatrix  <set>  *  *  >>> Possible errors:
  *  NO_MEMORY 	  *  RANGE %  *  Error is cleared in this routine.   */    char*   9 AllocateMatrix (Size, Complex, AbsoluteThreshold, lError)    int  Size, *lError;  BOOLEAN  Complex;  double  AbsoluteThreshold;   {   register  unsigned  SizePlusOne;  register  MatrixPointer  Matrix; register  int  I;  int  AllocatedSize;     /* Begin. */ /* Clear error flag. */      *lError = NO_ERROR;    /* Test for valid size. */7     if ((Size < 0) OR (Size >= MAX_MATRIX_SIZE - 1) OR  ( 		       (Size == 0 AND NOT EXPANDABLE))     {   *lError = RANGE;         return( NULL );      }         if (AbsoluteThreshold < 0.0)          AbsoluteThreshold = 0.0;   /* Test for valid type. */ #if (NOT COMPLEX)      if (Complex)       {   *lError = RANGE;         return( NULL );      }  #endif #if (NOT REAL)     if (NOT Complex)       {   *lError = RANGE;         return( NULL );      }  #endif   /* Create Matrix. */5     AllocatedSize = MAX(Size,MINIMUM_ALLOCATED_SIZE); 0     SizePlusOne = (unsigned)(AllocatedSize + 1);  8     if ((Matrix = MALLOC(struct MatrixFrame,1)) == NULL)     {   *lError = NO_MEMORY;         return( NULL );      }     /* Initialize matrix */      gMatrix = Matrix; 2     Matrix->AbsoluteThreshold = AbsoluteThreshold;     Matrix->Complex = Complex;     Matrix->Decomposed = FALSE;      Matrix->Error = *lError;     Matrix->FillIns = 0;     Matrix->FirstTime = TRUE;      Matrix->Growth = 0.0; )     Matrix->InitialDecompStarted = FALSE; .     Matrix->NumberOfInterchangesIsOdd = FALSE;     Matrix->RowsLinked = FALSE;      Matrix->Size = Size;*     Matrix->AllocatedSize = AllocatedSize;  '     Matrix->TopOfAllocationList = NULL; !     Matrix->RecordsRemaining = 0; "     Matrix->ElementsRemaining = 0;!     Matrix->FillInsRemaining = 0;   %     RecordAllocation((char *)Matrix); #     if (Matrix->Error == NO_MEMORY)          goto MemoryError;    /* Take out the trash. */      TrashCan.Real = 0.0; #if COMPLEX      TrashCan.Imag = 0.0; #endif  > /* Allocate space in memory for ColEliminationOrder vector. */J     if (( Matrix->ColEliminationOrder = MALLOC(int, SizePlusOne)) == NULL)         goto MemoryError;   7 /* Allocate space in memory for Diag pointer vector. */ F     if (( Matrix->Diag = CALLOC(ElementPointer, SizePlusOne)) == NULL)         goto MemoryError;      = /* Allocate space in memory for FirstInCol pointer vector. */ L     if (( Matrix->FirstInCol = CALLOC(ElementPointer, SizePlusOne)) == NULL)         goto MemoryError;   = /* Allocate space in memory for FirstInRow pointer vector. */ L     if (( Matrix->FirstInRow = CALLOC(ElementPointer, SizePlusOne)) == NULL)         goto MemoryError;   > /* Allocate space in memory for RowEliminationOrder vector. */J     if (( Matrix->RowEliminationOrder = MALLOC(int, SizePlusOne)) == NULL)         goto MemoryError;   * /* Initialize EliminationOrder vectors. */(     for (I = 1; I <= AllocatedSize; I++)+     {   Matrix->RowEliminationOrder[I] = I; +         Matrix->ColEliminationOrder[I] = I;      }   > /* Allocate space for fill-ins and initial set of elements. */>     InitializeElementBlocks( SPACE_FOR_ELEMENTS*AllocatedSize,@                              SPACE_FOR_FILL_INS*AllocatedSize );#     if (Matrix->Error == NO_MEMORY)          goto MemoryError;        return( (char*)Matrix );   MemoryError:  K /* Deallocate matrix and return no pointer to matrix if there is not enough 
    memory. */      Matrix->Error = NO_MEMORY;     *lError = NO_MEMORY;     DeallocateMatrix(Matrix);      return( NULL );  }                    /*  *  ELEMENT ALLOCATION    *N  *  This routine allocates space for matrix elements. It requests large blocksM  *  of storage from the system and doles out individual elements as required. L  *  This technique, as opposed to allocating elements indivdually, tends to !  *  speed the allocation process.   *  *  >>> Returned:   *  A pointer to an elemnt.   *  *  >>> Local variables:  *  pElement  (ElementPointer)O  *     A pointer to the first element in the group of elements being allocated.   *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:
  *  NO_MEMORY   */    ElementPointer GetElement()   {  ElementPointer  pElement;    /* Begin. */  (     if (gMatrix->ElementsRemaining == 0)  ' /* Allocate block of MatrixElements. */ N     {   if ((pElement = MALLOC(struct MatrixElement, ELEMENTS_PER_ALLOCATION))                       == NULL)'         {   gMatrix->Error = NO_MEMORY;              return(NULL); 	         }   +         RecordAllocation((char *)pElement); (         if (gMatrix->Error == NO_MEMORY)             return(NULL); =         gMatrix->ElementsRemaining = ELEMENTS_PER_ALLOCATION; -         gMatrix->NextAvailElement = pElement;      }   ; /* Update Element counter and return pointer to Element. */ !     gMatrix->ElementsRemaining--; *     return(gMatrix->NextAvailElement++);     }                  /*&  *  ELEMENT ALLOCATION INITIALIZATION   *K  *  This routine allocates space for matrix fill-ins and an initial set of  K  *  elements.  Besides being faster than allocating space for elements one  K  *  at a time, it tends to keep the fill-ins physically close to the other  N  *  matrix elements in the computer memory.  This keeps virtual memory paging   *  to a minimum.   *  *  >>> Arguments:"  *  InitialNumberOfElements  (int)B  *     This number is used as the size of the block of memory, in J  *     MatrixElements, reserved for elements. If more than this number of D  *     elements are generated, then more space is allocated later.  #  *  NumberOfFillInsExpected  (int)  B  *     This number is used as the size of the block of memory, in J  *     MatrixElements, reserved for fill-ins. If more than this number of I  *     fill-ins are generated, then more space is allocated, but they may 5  *     not be physically close in computer's memory.    *  *  >>> Local variables:  *  pElement  (ElementPointer)O  *     A pointer to the first element in the group of elements being allocated.   *  *  Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:  *  NO_MEMORY   */    static2 InitializeElementBlocks( InitialNumberOfElements, 3                          NumberOfFillInsExpected )    8 int  InitialNumberOfElements, NumberOfFillInsExpected;     {  ElementPointer  pElement;    /* Begin. */4 /* Allocate block of MatrixElements for elements. */J     if ((pElement = MALLOC(struct MatrixElement, InitialNumberOfElements)) 		  == NULL)#     {   gMatrix->Error = NO_MEMORY;          return;      }   9     gMatrix->ElementsRemaining = InitialNumberOfElements; '     RecordAllocation((char *)pElement); $     if (gMatrix->Error == NO_MEMORY)         return; )     gMatrix->NextAvailElement = pElement;   4 /* Allocate block of MatrixElements for fill-ins. */J     if ((pElement = MALLOC(struct MatrixElement, NumberOfFillInsExpected)) 		  == NULL)#     {   gMatrix->Error = NO_MEMORY;          return;      }   8     gMatrix->FillInsRemaining = NumberOfFillInsExpected;'     RecordAllocation((char *)pElement); $     if (gMatrix->Error == NO_MEMORY)         return; (     gMatrix->NextAvailFillIn = pElement;       return;  }                      /*  *  FILL-IN ALLOCATION    *N  *  This routine allocates space for matrix fill-ins. It requests large blocksM  *  of storage from the system and doles out individual elements as required. L  *  This technique, as opposed to allocating elements indivdually, tends to !  *  speed the allocation process.   *  *  >>> Returned:   *  A pointer to the fill-in.   *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:
  *  NO_MEMORY   */    ElementPointer   GetFillIn()    {  ElementPointer GetElement();   /* Begin. */'     if (gMatrix->FillInsRemaining == 0)           return ( GetElement() );     else  ; /* Update Fill-in counter and return pointer to Fill-in. */       gMatrix->FillInsRemaining--;)     return(gMatrix->NextAvailFillIn++);    }                    /*  *  RECORD A MEMORY ALLOCATION  *M  *  This routine is used to record all memory allocations so that the memory    *  can be freed later.   *  *  >>> Arguments:#  *  AllocatedPtr  <input>  (char *) M  *     The pointer returned by malloc or calloc.  These pointers are saved in /  *     a list so that they can be easily freed.   *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:
  *  NO_MEMORY   */    static  RecordAllocation( AllocatedPtr )   char  *AllocatedPtr; {    /* Begin. */'     if (gMatrix->RecordsRemaining == 0)   ' /* Allocate block of MatrixElements. */ (     {   AllocateBlockOfAllocationList();(         if (gMatrix->Error == NO_MEMORY)         {   free(AllocatedPtr);              return; 	         }      }   / /* Add Allocated pointer to Allocation List. */ B     (++gMatrix->TopOfAllocationList)->AllocatedPtr = AllocatedPtr;      gMatrix->RecordsRemaining--;     return;    }                  /*,  *  ADD A BLOCK OF SLOTS TO ALLOCATION LIST	  *;  *  This routine increases the size of the allocation list.   *  *  >>> Local variables:   *  ListPtr  (AllocationListPtr)K  *     Pointer to the list that contains the pointers to segments of memory L  *     that were allocated by the operating system for the current matrix.    *    *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:
  *  NO_MEMORY   */    static AllocateBlockOfAllocationList()    {  register  int  I; % register  AllocationListPtr  ListPtr;    /* Begin. */4 /* Allocate block of records for allocation list. */O     if ((ListPtr = MALLOC(struct AllocationRecord,(ELEMENTS_PER_ALLOCATION+1)))                   == NULL) #     {   gMatrix->Error = NO_MEMORY;          return;      }   M /* String entries of allocation list into singly linked list.  List is linked 7    such that any record points to the one before it. */   7     ListPtr->NextRecord = gMatrix->TopOfAllocationList; +     gMatrix->TopOfAllocationList = ListPtr; '     ListPtr += ELEMENTS_PER_ALLOCATION; 1     for (I = ELEMENTS_PER_ALLOCATION; I > 0; I--) +     {    ListPtr->NextRecord = ListPtr - 1;           ListPtr--;      }   H /* Record allocation of space for allocation list on allocation list. */A     gMatrix->TopOfAllocationList->AllocatedPtr = (char *)ListPtr; 8     gMatrix->RecordsRemaining = ELEMENTS_PER_ALLOCATION;       return;  }                    /*  *  EXPAND MATRIX   *%  *  Increases the size of the matrix.   *  *  >>> Arguments:  *  NewSize  <input>  (int) "  *     The new size of the matrix.  *  *  >>> Local veriables:  *  OldAllocatedSize  (int) >  *     The allocated size of the matrix before it is expanded.  */    ExpandMatrix (NewSize)   register int  NewSize; {  #if  EXPAND 7 register  I, OldAllocatedSize = gMatrix->AllocatedSize;    /* Begin `ExpandMatrix'. */      gMatrix->Size = NewSize;  $     if (NewSize <= OldAllocatedSize)         return;    /* Expand the matrix frame. */B     NewSize = MAX( NewSize, EXPANSION_FACTOR * OldAllocatedSize );%     gMatrix->AllocatedSize = NewSize;   I     if (( REALLOC(gMatrix->ColEliminationOrder, int, NewSize+1)) == NULL) #     {   gMatrix->Error = NO_MEMORY;  	return;     } I     if (( REALLOC(gMatrix->RowEliminationOrder, int, NewSize+1)) == NULL) #     {   gMatrix->Error = NO_MEMORY;  	return;     } E     if (( REALLOC(gMatrix->Diag, ElementPointer, NewSize+1)) == NULL) #     {   gMatrix->Error = NO_MEMORY;  	return;     } K     if (( REALLOC(gMatrix->FirstInCol, ElementPointer, NewSize+1)) == NULL) #     {   gMatrix->Error = NO_MEMORY;  	return;     } K     if (( REALLOC(gMatrix->FirstInRow, ElementPointer, NewSize+1)) == NULL) #     {   gMatrix->Error = NO_MEMORY;  	return;     }   0 /* Initialize the new portion of the vectors. */3     for (I = OldAllocatedSize+1; I <= NewSize; I++) ,     {   gMatrix->ColEliminationOrder[I] = I;% 	gMatrix->RowEliminationOrder[I] = I;  	gMatrix->Diag[I] = NULL;  	gMatrix->FirstInRow[I] = NULL;  	gMatrix->FirstInCol[I] = NULL;      }        return;  #else 0     printf("Expand Unsupported in Relax2.2.\n"); #endif }                    /*  *  MATRIX DE-ALLOCATION  *1  *  De-allocates pointers and elements of Matrix.   *  *  >>> Arguments:  *  Matrix  <input>  (char *) F  *     Pointer to the matrix frame which is to be removed from memory.  *  *  >>> Local veriables:   *  ListPtr  (AllocationListPtr)M  *     Pointer into the linked list of pointers to allocated data structures. 2  *     Points to pointer to structure to be freed.$  *  NextListPtr  (AllocationListPtr)M  *     Pointer into the linked list of pointers to allocated data structures. K  *     Points to the next pointer to structure to be freed.  This is needed L  *     because the data structure to be freed could include the current node  *     in the allocation list.  */    void DeallocateMatrix (Matrix)    register MatrixPointer  Matrix;  { 2 register  AllocationListPtr  ListPtr, NextListPtr;     /* Begin. */; /* Check to assure that there is a matrix to deallocate. */      if (Matrix == NULL)          return;   B /* Deallocate the vectors that are located in the matrix frame. */'     FREE( Matrix->ColEliminationOrder ) '     FREE( Matrix->RowEliminationOrder )      FREE( Matrix->Diag )     FREE( Matrix->FirstInRow )     FREE( Matrix->FirstInCol )  4 /* Deallocate Markowitz and Intermediate vectors. */-     if (Matrix->InitialDecompStarted == TRUE) $     {   FREE( Matrix->MarkowitzRow )$         FREE( Matrix->MarkowitzCol )%         FREE( Matrix->MarkowitzProd ) (         FREE( Matrix->IntermediateReal )         if (Matrix->Complex),             FREE( Matrix->IntermediateImag )     }   L /* Sequentially step through the list of allocated pointers freeing pointers  * along the way. */     *     ListPtr = Matrix->TopOfAllocationList;     while (ListPtr != NULL) *     {   NextListPtr = ListPtr->NextRecord;&         free( ListPtr->AllocatedPtr );         ListPtr = NextListPtr;     }      gMatrix = NULL;      return;    }   