 /*  *  MATRIX BUILD MODULE   *L  *  This module contains the routines associated with clearing, loading and <  *  preprocessing the matrix for the sparse matrix routines.  *  *  Author:   *     Kenneth S. Kundert   *     UC Berkeley  *  *  Advising professor: &  *     Alberto Sangiovanni-Vincentelli  *;  *  >>> User accessable functions contained in this module:   *  ClearMatrix   *  AddElementToMatrix  *  AddRealElementToMatrix  *  AddImagElementToMatrix  *  AddComplexElementToMatrix   *  AddAdmittanceToMatrix   *  AddRealQuadElementToMatrix  *  AddImagQuadElementToMatrix!  *  AddComplexQuadElementToMatrix   *+  *  >>> Functions contained in this module:   *  ClearMatrix   *  AddElementToMatrix  *  FindElementInCol  *  AddRealElementToMatrix  *  AddImagElementToMatrix  *  AddComplexElementToMatrix   *  AddAdmittanceToMatrix   *  AddRealQuadElementToMatrix  *  AddImagQuadElementToMatrix!  *  AddComplexQuadElementToMatrix   *  CreateElement   *  LinkRows  */                    /*  *  IMPORTS   *  *  >>> Import decriptions:   *  stdio.h   *     Standard C IO library.   *  MtrxPers.hH  *     Macros that customize the sparse matrix routines. This file comes6  *     to us indirectly, it is imported by MtrxDefs.h.  *  MtrxExpt.h:  *     Macros and declarations to be imported by the user.  *  MtrxDefs.hH  *     Matrix type and macro definitions for the sparse matrix routines.  *  MtrxError.h &  *     Matrix error macro definitions.  */     #include <stdio.h> #include "MtrxExpt.h"  #include "MtrxDefs.h"  #include "MtrxError.h"             /*  *  CLEAR MATRIX    *-  *  Sets every element of the matrix to zero.   *  *  >>> Arguments:  *  Matrix  <input>  (char *) /  *     Pointer to matrix that is to be cleared.   *  *  >>> Local variables:  *  Size  (int) J  *     The size of the matrix.  Local version of gMatrix->Size.  Placed in  *     register for speed.  *  pElement  (ElementPointer).  *     A pointer to the element being cleared.  */     void ClearMatrix( Matrix )     register  MatrixPointer  Matrix;   {  register  int  Size, I; # register  ElementPointer  pElement;    /* Begin `ClearMatrix'. */" /* Test for nonexistant matrix. */     if (Matrix == NULL)          return;    /* Empty the trash. */     TrashCan.Real = 0.0;
 #if (COMPLEX)      TrashCan.Imag = 0.0; #endif   /* Clear matrix. */      Size = Matrix->Size;     Matrix->Decomposed = FALSE;   
 #if (COMPLEX)      if (Matrix->Complex)     {   for (I=1; I<=Size; I++) -         {   pElement = Matrix->FirstInCol[I]; $             while (pElement != NULL)%             {   pElement->Real = 0.0; %                 pElement->Imag = 0.0; /                 pElement = pElement->NextInCol; 
             } 	         }      }      else #endif     {   for (I=1; I<=Size; I++) -         {   pElement = Matrix->FirstInCol[I]; $             while (pElement != NULL)%             {   pElement->Real = 0.0; /                 pElement = pElement->NextInCol; 
             } 	         }      }        return;  }                        /*/  *  SINGLE ELEMENT ADDITION TO MATRIX BY INDEX    *O  *  Finds element [Row,Col] and adds Data to it.  If element is not found then  L  *  it is created and spliced into matrix.  This routine is only to be used M  *  after AllocateMatrix and before PreorderForModifiedNodal, DecomposeMatrix L  *  or OrderAndDecomposeMatrix.  Returns a pointer to the Real portion of a J  *  MatrixElement. This pointer is later used by ADD_ELEMENT_TO_MATRIX to   *  directly access element.  *  *  >>> Returns:L  *  Returns a pointer to the element.  This pointer is then used to directly/  *  access the element during sucessive builds.   *  *  >>> Arguments:  *  Matrix  <input>  (char *) A  *     Pointer to the matrix that the element is to be added to.    *  Row  <input>  (int) A  *     Row index for element.  Must be in the range of [1..Size].   *  Col  <input>  (int) D  *     Column index for element.  Must be in the range of [1..Size].  *  Real  <input>  (double) )  *     Real data to be added to element.    *  Imag  <input>  (double) J  *     Imaginary data to be added to element.  If the matrix is real, then'  *     this parameter is not necessary.   *  *  >>> Local variables:  *  pElement  (double *)!  *     Pointer to the element.      *  *  >>>Global variables:  *  gMatrix  <set>  *  *  >>> Possible errors:
  *  NO_MEMORY 	  *  RANGE *  *  Error is not cleared in this routine.   */    double *2 AddElementToMatrix( Matrix, Row, Col, Real, Imag )     register  MatrixPointer  Matrix; int  Row, Col; double  Real, Imag;     {  register  double  *pElement;" ElementPointer FindElementInCol();  ! /* Begin `AddElementToMatrix'. */      gMatrix = Matrix;   !     if ((Row == 0) OR (Col == 0))          return(&TrashCan.Real);    #if (DEBUG)  /* Test for possible errors. */ :     if ((Row < 1) OR (Col < 1) OR (NOT Matrix->FirstTime))     {   gMatrix->Error = RANGE;          return(NULL);      }  #if (EXPANDABLE)=     if ((Row >= MAX_MATRIX_SIZE) OR (Col >= MAX_MATRIX_SIZE))      {   gMatrix->Error = RANGE;          return(NULL);      }  #else 5     if ((Row > Matrix->Size) OR (Col > Matrix->Size))      {   gMatrix->Error = RANGE;          return(NULL);      }  #endif #endif   #if (EXPANDABLE)" /* Re-size Matrix if necessary. */5     if ((Row > Matrix->Size) OR (Col > Matrix->Size))  	ExpandMatrix( MAX(Row, Col) );  #endif  O /* The condition part of the following if statement tests to see if the element M  * resides along the diagonal, if it does then it tests to see if the element K  * has been created yet (Diag pointer not NULL). The pointer to the element K  * is then assigned to Element after it is cast into a pointer to a double. L  * This casting makes the pointer into a pointer to the Real. This statementI  * depends on the fact that Real is the first record in the MatrixElement   * structure. */  K     if ((Row != Col) OR ((pElement = (double *)Matrix->Diag[Row]) == NULL))      {   ? /* Element does not exist or does not reside along diagonal. */     /* Search column for element. */M /* As in the if statement above, the pointer to the element which is returned C  * by FindElementInCol is cast into a pointer to Real, a double. */   V         pElement = (double*)FindElementInCol(&(Matrix->FirstInCol[Col]),Row,Col,TRUE);     }   ! /* Add Data to element. */             *pElement += Real;
 #if (COMPLEX)      if (Matrix->Complex)3         ADD_IMAG_ELEMENT_TO_MATRIX (pElement,Imag);  #endif       return(pElement);  }                        /*$  *  FIND ELEMENT BY SEARCHING COLUMN  *O  *  Searches column starting at element specified at PtrAddr and finds element  J  *  in Row. If Element does not exists, it is created. The pointer to the   *  element is returned.  *  *  >>> Returned: %  *  A pointer to the desired element:   *  *  >>> Arguments:0  *  LastAddr  <input-output>  (ElementPointer *)O  *     Address of pointer that initially points to the element in Col at which  N  *     the search is started.  The pointer in this location may be changed if K  *     a fill-in is required in and ajacent element. For this reason it is  L  *     important that LastAddr be the address of a FirstInCol or a NextInCol)  *     rather than a temporary variable.    *  Row  <input>  (int)   *     Row being searched for.    *  Col  (int)  *     Column being searched. '  *  CreateIfMissing  <input>  (BOOLEAN) L  *     Indicates what to do if element is not found, create one or return a   *     NULL pointer.    *  *  Local variables:  *  pElement  (ElementPointer)-  *     Pointer used to search through matrix.   */    ElementPointer  5 FindElementInCol(LastAddr, Row, Col, CreateIfMissing)   $ register ElementPointer *LastAddr;   register int  Row;	 int  Col;  BOOLEAN  CreateIfMissing;    { # register  ElementPointer  pElement;   ElementPointer  CreateElement();   /* Begin `FindElementInCol'. */      pElement = *LastAddr;    /* Search for element. */      while (pElement != NULL)      {   if (pElement->Row < Row)	         { # /* Have not reached element yet. */ .             LastAddr = &(pElement->NextInCol);+             pElement = pElement->NextInCol; 	         } &         else if (pElement->Row == Row)	         {  /* Reached element. */             return(pElement); 	         } %         else break;  /* while loop */      }   1 /* Element does not exist and must be created. */      if (CreateIfMissing)2        return (CreateElement(Row, Col, LastAddr));     else return(NULL); }                    /*-  *  ADD ELEMENT TO MATRIX BY POINTER ROUTINES   *H  *  These routines add elements to the matrix using pointers.  There useJ  *  is discouraged if the calling program is written in C.  If that is theH  *  case, then the equivalent macros should be used.  These routines are>  *  functionally equivalent to the macros, but will be slower.  *  *  >>> Arguments:   *  Element  <input>  (double *)>  *     Pointer to the element that the data is to be added to.  *  Real  <input>  (double) *  *     Real data to be added to elements.   *  Imag  <input>  (double) K  *     Imag data to be added to elements.  If matrix is real, this argument   *     may be deleted.    */    void' AddRealElementToMatrix( Element, Real )    register double *Element; 
 double  Real;    { % /* Begin `AddRealElementToMatrix'. */   /    ADD_REAL_ELEMENT_TO_MATRIX( Element, Real ); 
    return; }          void' AddImagElementToMatrix( Element, Imag )    register double *Element; 
 double  Imag;    { % /* Begin `AddImagElementToMatrix'. */   /    ADD_IMAG_ELEMENT_TO_MATRIX( Element, Imag ); 
    return; }          void0 AddComplexElementToMatrix( Element, Real, Imag )   register double *Element;  double  Real, Imag;    { ( /* Begin `AddComplexElementToMatrix'. */  8    ADD_COMPLEX_ELEMENT_TO_MATRIX( Element, Real, Imag );
    return; }                    #if (QUAD_ELEMENT) /*-  *  ADDITION OF ADMITTANCE TO MATRIX BY INDEX   *P  *  Performs same function as AddElementToMatrix except rather than one element,N  *  all four Matrix elements for a floating component are added.  This routineJ  *  also works if component is grounded.  Positive elements are placed at L  *  [Node1,Node2] and [Node2,Node1].  This routine is only to be used after J  *  AllocateMatrix and before PreorderForModifiedNodal, MatrixDecompose or  *  OrderAndDecomposeMatrix.  *  *  >>> Arguments:  *  Matrix  <input>  (char *) @  *     Pointer to the matrix that component is to be entered in.  *  Node1  <input>  (int) N  *     Row and column indices for elements. Must be in the range of [1..Size].  *  Node2  <input>  (int) N  *     Row and column indices for elements. Must be in the range of [1..Size].*  *  Template  <output>  (TemplateStruct *)O  *     Collection of pointers to four elements that are later used to directly  K  *     address elements.  User must supply the template, this routine will    *     fill it.   *  Real  <input>  (double) *  *     Real data to be added to elements.   *  Imag  <input>  (double) K  *     Imag data to be added to elements.  If matrix is real, this argument   *     may be deleted.    *  *  >>> Local variables:  *  Pointer  (double *) -  *     A pointer to an element in the matrix.   *  AnotherPointer  (double *)A  *     A pointer to an element in the matrix.  One is not enough.   *  *  Global variables:   *  gMatrix  <set>  *  *  Possible errors:
  *  NO_MEMORY 	  *  RANGE *  *  Error is not cleared in this routine.   */    voidC AddAdmittanceToMatrix( Matrix, Node1, Node2, Template, Real, Imag )      register  MatrixPointer  Matrix; int  Node1, Node2;, register  struct  TemplateStruct  *Template; double  Real, Imag;    {  register  double   *Pointer;# register  double   *AnotherPointer; " ElementPointer  GetElementInCol();  $ /* Begin `AddAdmittanceToMatrix'. */     gMatrix = Matrix; /     if (Node1 > Node2) SWAP(int, Node1, Node2);    #if (DEBUG)  /* Test for possible errors. */      if ((Node1 < 0) 2     OR (NOT EXPANDABLE AND (Node2 > Matrix->Size))2     OR (EXPANDABLE AND (Node2 >= MAX_MATRIX_SIZE))     OR (NOT Matrix->FirstTime))      {   gMatrix->Error = RANGE;          return;      }  #endif   #if (EXPANDABLE)" /* Re-size Matrix if necessary. */     if (Node2 > Matrix->Size)  	ExpandMatrix( Node2 );  #endif       if (Node1 == 0)      { , /* Addition of a non-floating component. */ >         if ((Pointer = (double *)Matrix->Diag[Node2]) == NULL)L             Pointer = (double *)FindElementInCol(&Matrix->FirstInCol[Node2],O                                                              Node2,Node2,TRUE);          *Pointer += Real; 
 #if (COMPLEX)          if (Matrix->Complex)6             ADD_IMAG_ELEMENT_TO_MATRIX (Pointer,Imag); #endif  %         Template->Element1 = Pointer; ,         Template->Element2 = &TrashCan.Real;3         Template->Element3Negated = &TrashCan.Real; 3         Template->Element4Negated = &TrashCan.Real;      }                         else     { ( /* Addition of a floating component. */ ! /* Left-most diagonal element. */ >         if ((Pointer = (double *)Matrix->Diag[Node1]) == NULL)L             Pointer = (double *)FindElementInCol(&Matrix->FirstInCol[Node1],O                                                              Node1,Node1,TRUE); %         Template->Element1 = Pointer;          *Pointer += Real;   / /* Element below left-most diagonal element. */ ,         Pointer = (double*)FindElementInCol(P                                         &(((ElementPointer)Pointer)->NextInCol),O                                                              Node2,Node1,TRUE); ,         Template->Element3Negated = Pointer;         *Pointer -= Real;   0 /* Element above right-most diagonal element. */H         Pointer = (double *)FindElementInCol(&Matrix->FirstInCol[Node2],O                                                              Node1,Node2,TRUE); ,         Template->Element4Negated = Pointer;         *Pointer -= Real;   " /* Right-most diagonal element. */E         if ((AnotherPointer = (double *)Matrix->Diag[Node2]) == NULL) 8             AnotherPointer = (double *)FindElementInCol(P                                         &(((ElementPointer)Pointer)->NextInCol),P                                                               Node2,Node2,TRUE);,         Template->Element2 = AnotherPointer;          *AnotherPointer += Real;  
 #if (COMPLEX)          if (Matrix->Complex)A         {   ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element1,Imag); =             ADD_IMAG_ELEMENT_TO_MATRIX (AnotherPointer,Imag); I             ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element3Negated,-Imag); I             ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element4Negated,-Imag); 	         }  #endif       }      return;  }  #endif   /* QUAD_ELEMENT */                        #if (QUAD_ELEMENT) /*9  *  QUADRUPLE REAL ELEMENT ADDITION TO MATRIX BY POINTER    *>  *  Adds Data to four real elements specified by the Template.  *  *  >>> Arguments:)  *  Template  <input>  (TemplateStruct *) ;  *     Pointer to the group of pointers to four elements.     *  Real  <input>  (double) *  *     Real data to be added to elements.   */    void- AddRealQuadElementToMatrix( Template, Real )    , register  struct  TemplateStruct  *Template;
 double  Real;    { ) /* Begin `AddRealQuadElementToMatrix'. */ 9     ADD_REAL_ELEMENT_TO_MATRIX (Template->Element1,Real); 9     ADD_REAL_ELEMENT_TO_MATRIX (Template->Element2,Real); A     ADD_REAL_ELEMENT_TO_MATRIX (Template->Element3Negated,-Real); A     ADD_REAL_ELEMENT_TO_MATRIX (Template->Element4Negated,-Real); 	                return;  }    #endif   /* QUAD_ELEMENT */                        #if (QUAD_ELEMENT AND COMPLEX) /*=  *  QUADRUPLE IMAGINARY ELEMENT ADDITION TO MATRIX BY POINTER   *C  *  Adds data to four imaginary elements specified by the Template.   *  *  >>> Arguments:)  *  Template  <input>  (TemplateStruct *) ;  *     Pointer to the group of pointers to four elements.     *  Imag  <input>  (double) /  *     Imaginary data to be added to elements.    */         void- AddImagQuadElementToMatrix( Template, Imag )    , register  struct  TemplateStruct  *Template;
 double  Imag;    { ) /* Begin `AddImagQuadElementToMatrix'. */ 9     ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element1,Imag); 9     ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element2,Imag); A     ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element3Negated,-Imag); A     ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element4Negated,-Imag); 	                return;    } ' #endif   /* QUAD_ELEMENT AND COMPLEX */                        #if (QUAD_ELEMENT AND COMPLEX) /*;  *  QUADRUPLE COMPLEX ELEMENT ADDITION TO MATRIX BY POINTER   *A  *  Adds Data to four complex elements specified by the Template.   *  *  >>> Arguments:)  *  Template  <input>  (TemplateStruct *) ;  *     Pointer to the group of pointers to four elements.     *  Real  <input>  (double) *  *     Real data to be added to elements.   *  Imag  <input>  (double) /  *     Imaginary data to be added to elements.    */    void6 AddComplexQuadElementToMatrix( Template, Real, Imag )   , register  struct  TemplateStruct  *Template; double  Real, Imag;    { , /* Begin `AddComplexQuadElementToMatrix'. */A     ADD_COMPLEX_ELEMENT_TO_MATRIX (Template->Element1,Real,Imag); A     ADD_COMPLEX_ELEMENT_TO_MATRIX (Template->Element2,Real,Imag); J     ADD_COMPLEX_ELEMENT_TO_MATRIX (Template->Element3Negated,-Real,-Imag);J     ADD_COMPLEX_ELEMENT_TO_MATRIX (Template->Element4Negated,-Real,-Imag);	                return;  } ' #endif   /* QUAD_ELEMENT AND COMPLEX */                  /*  *)  *  CREATE AND SPLICE ELEMENT INTO MATRIX   *O  *  This routine is used to create new matrix elements and splice them into the   *  matrix.   *  *  >>> Returned: :  *  A pointer to the element that was created is returned.  *  *  >>> Arguments:  *  Row  <input>  (int)   *      Row index for element.  *  Col  <input>  (int) "  *      Column index for element. 0  *  LastAddr  <input-output>  (ElementPointer *)O  *      This contains the address of the pointer to the element just above the  P  *      one being created. It is used to speed the search and it is updated with)  *      address of the created element.     *  *  >>> Local variables:  *  pElement  (ElementPointer)M  *      Pointer to an element in the matrix. It is used to refer to the newly N  *      created element and to restring the pointers of the element's row and   *      column.   "  *  pLastElement  (ElementPointer)N  *      Pointer to the element in the matrix that was just previously pointed M  *      to by pElement. It is used to restring the pointers of the element's    *      row and column.   %  *  pCreatedElement  (ElementPointer) F  *      Pointer to the desired element, the one that was just created.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:  *  NO_MEMORY   */    ElementPointer  $ CreateElement( Row, Col, LastAddr )    register int  Col;# register ElementPointer  *LastAddr; 	 int  Row;     { 1 register  ElementPointer  pElement, pLastElement;   ElementPointer  pCreatedElement; ElementPointer  GetElement();  ElementPointer  GetFillIn();      /* Begin `CreateElement'. */F /* If decomposition has started then a fill-in is needed, otherwise, a   * regular element is needed. */     if (gMatrix->RowsLinked)     { " /* Allocate memory for Fill-in. */         pElement = GetFillIn();          gMatrix->FillIns++; (         if (gMatrix->Error == NO_MEMORY)             return (NULL);  7 /* If element is on diagonal, store pointer in Diag. */      if (Row == Col) &         gMatrix->Diag[Row] = pElement;   /* Initialize Element. */ #         pCreatedElement = pElement;          pElement->Row = Row;         pElement->Col = Col;         pElement->Real = 0.0; 
 #if (COMPLEX)          pElement->Imag = 0.0;  #endif  " /* Splice element into column. */ (         pElement->NextInCol = *LastAddr;         *LastAddr = pElement;   /  /* Search row for proper element position. */  ,         pElement = gMatrix->FirstInRow[Row];         pLastElement = NULL;          while (pElement != NULL)	         { ' /* Search for element row position. */  $             if (pElement->Col < Col)
             { ( /* Have not reached desired element. */ (                 pLastElement = pElement;/                 pElement = pElement->NextInRow; 
             } !             else pElement = NULL; 	         }    /* Splice element into row. */  #         pElement = pCreatedElement; !         if (pLastElement == NULL) 	         {  /* Element is first in row. */  ;             pElement->NextInRow = gMatrix->FirstInRow[Row]; 0             gMatrix->FirstInRow[Row] = pElement;	         } 
         else  " /* Element is not first in row. */	         { :             pElement->NextInRow = pLastElement->NextInRow;/             pLastElement->NextInRow = pElement; 	         }        }      else     { M /* Matrix has not been decomposed yet.  Thus get element rather than fill-in. (  * Also, row pointers can be ignored. */  " /* Allocate memory for Element. */          pElement = GetElement();(         if (gMatrix->Error == NO_MEMORY)             return (NULL);  7 /* If element is on diagonal, store pointer in Diag. */      if (Row == Col) &         gMatrix->Diag[Row] = pElement;   /* Initialize Element. */ #         pCreatedElement = pElement;          pElement->Row = Row;         pElement->Real = 0.0; 
 #if (COMPLEX)          pElement->Imag = 0.0;  #endif  " /* Splice element into column. */ (         pElement->NextInCol = *LastAddr;         *LastAddr = pElement;      }        return(pCreatedElement); }                  /*  *  *  LINK ROWS   *J  *  This routine is used to generate the row links.  The Add_____ToMatrix N  *  routines do not create row links, which are needed by the DecomposeMatrix   *  routines.     *  *  >>> Local variables:   *  pElement  (ElementPointer)  ,  *      Pointer to an element in the matrix.)  *  FirstInRowEntry  (ElementPointer *)   L  *      A pointer into the FirstInRow array.  Points to the FirstInRow entry&  *      currently being operated upon.,  *  FirstInRowArray  (ElementPointerVector) K  *      A pointer to the FirstInRow array.  Same as gMatrix->FirstInRow but K  *      resides in a register and requires less indirection so is faster to   *      use.  *  Col  (int)-  *      Column currently being operated upon.   *  *  >>>  Global variables:  *  gMatrix  <used>   */    LinkRows()     { 5 register  ElementPointer  pElement, *FirstInRowEntry; 0 register  ElementPointerVector  FirstInRowArray; register  int  Col;    /* Begin `LinkRows'. */ *     FirstInRowArray = gMatrix->FirstInRow;.     for (Col = gMatrix->Size; Col >= 1; Col--)     { ? /* Generate row links for the elements in the Col'th column. */ ,         pElement = gMatrix->FirstInCol[Col];            while (pElement != NULL)          {   pElement->Col = Col;>             FirstInRowEntry = &FirstInRowArray[pElement->Row];3             pElement->NextInRow = *FirstInRowEntry; (             *FirstInRowEntry = pElement;+             pElement = pElement->NextInCol; 	         }      }      gMatrix->RowsLinked = TRUE;      return;  }                   