 /*5  *  GLOBAL DEFINITIONS for the sparse matrix routines   *  *  Author:   *      Kenneth S. Kundert  *      UC Berkeley   *  *  Advising professor: '  *      Alberto Sangiovanni-Vincentelli   *K  *  This module contains common type definitions and macros for the sparse  H  *  matrix routines.  These definitions are of no interest to the user.   */                  /*  *  IMPORTS   *  *  >>> Import decriptions:   *  MtrxPers.h8  *     Macros that customize the sparse matrix routines.  */     #include "MtrxPers.h"              /*  *   MACRO DEFINITIONS  *F  *   Macros are distinguished by using solely capital letters in theirP  *   identifiers.  This contrasts with C defined identifiers which are strickly O  *   lower case, and program variable and procedure names which use both upper    *   and lower case.  */    /* Begin macros. */  /* Boolean data type */  #define  BOOLEAN	int #define  FALSE		0  #define  TRUE		1 #define  NOT		!  #define  AND		&& #define  OR		||    /* Macro commands */M /* Macro functions that return the maximun or minimum independent of type. */ 3 #define  MAX(a,b)           ((a) > (b) ? (a) : (b)) 3 #define  MIN(a,b)           ((a) < (b) ? (a) : (b))   P /* Macro function that returns the absolute value of a floating point number. */4 #define  ABS(a)             ((a) < 0.0 ? -(a) : (a))  . /* Macro procedure that swaps two entities. */F #define  SWAP(type, a, b)   {type swapx; swapx = a; a = b; b = swapx;}  P /* Macro function that returns the approx absolute value of a complex number. */1 #define  ELEMENT_MAG_DECLARATIONS   double *p,c,d 
 #if (COMPLEX) I #define  ELEMENT_MAG(ptr)   (p = (double*)(ptr), (ABS(*p) + ABS(*(p+1))))  #else G #define  ELEMENT_MAG(ptr)   (c = (ptr)->Real, ((c) < 0.0 ? -(c) : (c)))  #endif  L /* Macro function that returns the approx magnitude (L-1 norm) of a complex 
  * number. */ - #define  CMPLX_ABS(a,b)     (ABS(a) + ABS(b))   K /* Macro function that returns the approx magnitude (L-infinity norm) of a    * complex number. */ @ #define  CMPLX_NORM(a,b)     (c = ABS(a), d = ABS(b), MAX (c,d))  K /* Macro function that is equivalent to += operator for complex numbers. */ 5 #define  CMPLX_ADD_ASSIGN(to_r,to_i,from_r,from_i)  \ #          {   (to_r) += (from_r);  \ #              (to_i) += (from_i);  \ 
          }  H /* Macro function that multiplies two complex numbers and then adds them    to another. */ 8 #define  CMPLX_MULT_ADD_ASSIGN(to_r,to_i,ar,ai,br,bi)  \4          {   (to_r) += (ar) * (br) - (ai) * (bi);  \4              (to_i) += (ar) * (bi) + (ai) * (br);  \
          }  M /* Macro function that multiplies two complex numbers and then subtracts them     from another. */ 9 #define  CMPLX_MULT_SUBT_ASSIGN(to_r,to_i,ar,ai,br,bi)  \ 4          {   (to_r) -= (ar) * (br) - (ai) * (bi);  \4              (to_i) -= (ar) * (bi) + (ai) * (br);  \
          }  6 /* Macro function that divides two complex numbers. */5 #define  CMPLX_DIVIDE_DECLARATIONS       double r,s,t / #define  CMPLX_DIVIDE(to_r,to_i,nr,ni,dr,di)  \ &          {   if (ABS(dr) > ABS(di))  \#              {  r = (di) / (dr);  \ %                 s = (dr) + r*(di);  \ ,                 to_r = ((nr) + r*(ni))/s;  \,                 to_i = ((ni) - r*(nr))/s;  \              }  \               else  \#              {  r = (dr) / (di);  \ %                 s = (di) + r*(dr);  \ ,                 to_r = (r*(nr) + (ni))/s;  \,                 to_i = (r*(ni) - (nr))/s;  \              }  \ 
          }, #define  CMPLX_DIVIDE_ASSIGN(nr,ni,dr,di)  \&          {   if (ABS(dr) > ABS(di))  \#              {  r = (di) / (dr);  \ %                 s = (dr) + r*(di);  \ %                 t = (nr + r*ni)/s;  \ &                 ni = (ni - r*nr)/s;  \                 nr = t;  \              }  \               else  \#              {  r = (dr) / (di);  \ %                 s = (di) + r*(dr);  \ %                 t = (r*nr + ni)/s;  \ &                 ni = (r*ni - nr)/s;  \                 nr = t;  \              }  \ 
          }  M /* Memory allocation and dealocation macros. Altered for Relax2.2 program. */  /*& char *malloc(), *calloc(), *realloc();N #define MALLOC(type,number)  (type *)malloc((unsigned)(sizeof(type)*(number)))B #define CALLOC(type,number)  (type *)calloc(sizeof(type),(number))# #define REALLOC(ptr,type,number)  \ O            ptr = (type *)realloc((char *)ptr,(unsigned)(sizeof(type)*(number))) H #define FREE(pointer)  { if ((pointer) != NULL) free((char *)pointer); } */  4 /* Relax2.2 memory Allocation, Allows no Freeing. */M /* Matrix Expansion Turned off because not used by Relax and uses realloc. */  char *ralloc();  #define EXPAND 0  F #define MALLOC(type,number)  (type *)ralloc(1,(sizeof(type)*(number)))B #define CALLOC(type,number)  (type *)ralloc(sizeof(type),(number))  & #define REALLOC(ptr,type,number)  NULL  #define FREE(pointer) {  NULL; }    I /* Macro function that checks for range errors on array indices. Used for <  * debuging, should be commented out in normal operation. */9 #define RANGE_CHECK(index,lowerbound,upperbound,message)  " /*  if ((index) < (lowerbound))  \N     {   printf("Error: Array lower bound fault at location %1s.\n",message); \0         printf("       index = %d.\n",index);  \     }  \"     if ((index) > (upperbound))  \N     {   printf("Error: Array upper bound fault at location %1s.\n",message); \0         printf("       index = %d.\n",index);  \     }  \     fflush(stdout)  */                        /*.  *  GLOBAL TYPE DEFINITIONS  --  MatrixElement  *L  *  Every nonzero element in the matrix is stored in a dynamically allocatedH  *  MatrixElement structure.  These structures are linked together in anJ  *  orthogonal linked list.  Two different MatrixElement structures exist.L  *  One is used when only real matrices are expected, it is missing an entryL  *  for imaginary data.  The other is used if complex matrices are expected.,  *  It contains an entry for imaginary data.  *  *  >>> Structure fields:   *  Real  (double)M  *      The real portion of the value of the element.  Real must be the first !  *      field in this structure.    *  Imag  (double)H  *      The imaginary portion of the value of the element. If the matrixG  *      routines are not compiled to handle complex matrices, then this M  *      field does not exist.  If it exists, it must follow imediately after    *      Real.   *  Row  (int)&  *      The row number of the element.  *  Col  (int))  *      The column number of the element. '  *  NextInRow  (struct MatrixElement *) J  *      NextInRow contains a pointer to the next element in the row to theJ  *      right of this element.  If this element is the last nonzero in the)  *      row then NextInRow contains NULL. '  *  NextInCol  (struct MatrixElement *) L  *      NextInCol contains a pointer to the next element in the column belowN  *      this element.  If this element is the last nonzero in the column then    *      NextInCol contains NULL.  */    /* Begin `MatrixElement'. */
 #if (COMPLEX) 8 /* Basic matrix element for real or complex matrices. */ struct  MatrixElement  {   double  Real;      double  Imag; 
     int  Row; 
     int  Col; &     struct  MatrixElement  *NextInRow;&     struct  MatrixElement  *NextInCol; };   #else - /* Basic matrix element for real matrices. */  struct  MatrixElement  {   double  Real; 
     int  Row; 
     int  Col; &     struct  MatrixElement  *NextInRow;&     struct  MatrixElement  *NextInCol; }; #endif                 /*,  *  GLOBAL TYPE DEFINITIONS  --  Allocations  *L  *  The sparse matrix routines keep track of all memory that is allocated byK  *  the operating system so the memory can later be freed.  This is done by K  *  saving the pointers to all the chunks of memory that are allocated to a I  *  particular matrix in an allocation list.  That list is organized as a ;  *  linked list so that it can grow without apriori bounds.   *  *  >>> Structure fields:   *  AllocatedPtr  (char *)J  *      Pointer to chunk of memory that has been allocated for the matrix.,  *  NextRecord  (struct  AllocationRecord *).  *      Pointer to the next allocation record.  */     /* Begin. */ struct AllocationRecord  {   char  *AllocatedPtr;*     struct  AllocationRecord  *NextRecord; };  6 typedef  struct  AllocationRecord  *AllocationListPtr;                   /*,  *  GLOBAL TYPE DEFINITIONS  --  MatrixFrame  *H  *  This structure contains all the pointers that support the orthogonalI  *  linked list that cantains the matrix elements.  Also included in this J  *  structure are other numbers and pointers that are used globally by theI  *  sparse matrix routines and are associated with one particular matrix.   *  *  >>> Type definitions:   *  ElementPointer%  *      A pointer to a MatrixElement.   *  ElementPointerVectorI  *      An array of ElementPointers.  Used for FirstInRow, FirstInCol and   *      Diag pointer arrays.  *  EliminationOrderVectorM  *      An array of integers.  These vectors indicate in which order the rows 2  *      and columns of the matrix were eliminated.  *  MatrixPointer H  *      A pointer to MatrixFrame.  Essentially, a pointer to the matrix.  *  *  >>> Structure fields:   *  AbsoluteThreshold  (double) I  *      The absolute magnitude an element must have to be considered as a 1  *      pivot candidate, except as a last resort.   *  AllocatedSize  (int)K  *      The currently allocated size of the matrix; the size the matrix can E  *      grow to when EXPANDABLE is set true and not require that the  $  *      matrix frame be reallocated.2  *  ColEliminationOrder  (EliminationOrderVector) G  *      An array that lists the step in which each original column was    *      eliminated.   *  Complex  (BOOLEAN)I  *      The flag which indicates whether the matrix is complex (true) or    *      real (false).   *  Decomposed  (BOOLEAN) 0  *      Indicates if matrix has been decomposed.   *  Diag  (ElementPointerVector)?  *      Array of pointers that points to the diagonal elements.   *  Error  (int)6  *      The error status of the sparse matrix package.  *  FillIns  (int)L  *      The number of fill-ins created during the decomposition the matrix.   *  FirstTime  (BOOLEAN)K  *      This is a flag that sigifies that an initial decomposition has not  L  *      been performed yet. FirstTime is set True in AllocateMatrix and set )  *      False in OrderAndDecomposeMatrix. &  *  FirstInCol  (ElementPointerVector)I  *      Array of pointers that point to the first nonzero element of the  *  *      column corresponding to the index.&  *  FirstInRow  (ElementPointerVector)M  *      Array of pointers that point to the first nonzero element of the row  #  *      corresponding to the index.   *  Growth  (double)N  *      The amount of growth that occurred in the most recent decompose of theL  *      matrix.  Growth is a measure of the amount of roundoff error that is<  *      present in L and U as a result of the decomposition.!  *  IntermediateImag  (double []) O  *      Temporary storage used in the SolveMatrix routines. Intermediate is an  C  *      array used during forward and backward substitution.  It is O  *      commonly called y when the forward and backward substitution process is J  *      denoted  Ax = b => Ly = b and Ux = y.  IntermediateImag holds the   *      imaginary portion of y. !  *  IntermediateReal  (double []) O  *      Temporary storage used in the SolveMatrix routines. Intermediate is an  C  *      array used during forward and backward substitution.  It is O  *      commonly called y when the forward and backward substitution process is J  *      denoted  Ax = b => Ly = b and Ux = y.  IntermediateReal holds the   *      real portion of y.  *  LargestElement  (double)*  *      The largest element in the matrix.  *  MarkowitzCol  (int [])L  *      An array that contains the count of the non-zero elements excluding N  *      the pivots for each column. Used to generate and update MarkowitzProd.  *  MarkowitzProd  (long *) N  *      The array of the products of the Markowitx row and column counts. The O  *      element with the smallest product is the best pivot to use to maintain    *      sparsity.   *  MarkowitzRow  (int [])L  *      An array that contains the count of the non-zero elements excluding K  *      the pivots for each row. Used to generate and update MarkowitzProd.   *  PseudoCondition  (double) H  *      The ratio of the largest pivot to the smallest pivot.  A measureK  *      of the ill-conditioning of the matrix, a crude measure.  The larger :  *      the ratio, the more ill-conditioned the matrix is.1  *  RowEliminationOrder  (EliminationOrderVector) O  *      An array that lists the step in which each original row was eliminated.   *  RowsLinked  (BOOLEAN) M  *      A flag that indicates whether the row pointers exist.  The AddByIndex K  *      routines do not generate the row pointers, which are needed by some O  *      of the other routines, such as OrderAndDecomposeMatrix and ScaleMatrix. @  *      The row pointers are generated in the function LinkRows.  *  Size  (int) M  *      Number of rows and columns in the matrix.  Does not change as matrix    *      is decomposed.  *  Threshold  (double) M  *      The minimum magnitude an element must have relative to other elements <  *      in its column to be considered as a pivot candidate.  *>  *  >>> The remaining fields are related to memory allocation.,  *  TopOfAllocationList  (AllocationListPtr)K  *      Pointer which points to the top entry in a list. The list contains  L  *      all the pointers to the segments of memory that have been allocated G  *      to this matrix. This is used when the memory is to be freed on  "  *      dallocation of the matrix.  *  RecordsRemaining  (int) 8  *      Number of slots left in the list of allocations.&  *  NextAvailElement  (ElementPointer)N  *      Pointer to the next availible element which has been allocated but as B  *      yet is unused. Matrix elements are allocated in groups of I  *      ELEMENTS_PER_ALLOCATION in order to speed element allocation and    *      freeing.  *  ElementsRemaining  (int)K  *      Number of unused elements left in last block of elements allocated. %  *  NextAvailFillIn  (ElementPointer) K  *      Pointer to the next availible fill-in which has been allocated but  N  *      as yet is unused.  Fill-ins are allocated in a group in order to keep B  *      them physically close in memory to the rest of the matrix.  *  FillInsRemaining  (int) E  *      Number of unused fill-ins left in the last block of fill-ins    *      allocated.#  *  InitialDecompStarted  (BOOLEAN) N  *      Boolean flag that is used to indicate that the building of the matrix M  *      has been completed. This indicated that any new elements created are    *      fill-ins.   */    /* Begin. */ /* Matrix frame */0 typedef  struct  MatrixElement  *ElementPointer;/ typedef  ElementPointer  *ElementPointerVector; & typedef  int  *EliminationOrderVector;   struct  MatrixFrame  {   double  AbsoluteThreshold;     int  AllocatedSize; 0     EliminationOrderVector  ColEliminationOrder;     BOOLEAN  Complex;      BOOLEAN  Decomposed;     ElementPointerVector  Diag;      int  Error;      int  FillIns;      BOOLEAN  FirstTime; %     ElementPointerVector  FirstInCol; %     ElementPointerVector  FirstInRow;      double  Growth;      double  *IntermediateReal;     double  *IntermediateImag;     double  LargestElement;      int  *MarkowitzRow;      int  *MarkowitzCol;      long  *MarkowitzProd; '     BOOLEAN  NumberOfInterchangesIsOdd;      double  PseudoCondition;0     EliminationOrderVector  RowEliminationOrder;     BOOLEAN  RowsLinked;     int  Size;     double  Threshold;  +     AllocationListPtr  TopOfAllocationList;      int  RecordsRemaining;%     ElementPointer  NextAvailElement;      int  ElementsRemaining; $     ElementPointer  NextAvailFillIn;     int  FillInsRemaining;     int  InitialDecompStarted; };- typedef  struct  MatrixFrame  *MatrixPointer;                /*   *  GLOBAL VARIABLE DECLARATION   *H  *  This variable is global to all matrix routines.  The small g prefix M  *  denotes this.  Making this variable global greatly reduces the amount of    *  parameter passing required.   *  *  >>> Global variable:  *  gMatrix  (MatrixPointer)<  *      A pointer to the matrix currently being operated on.  *  TrashCan  (MatrixElement) H  *      This is a dummy double that is used to by the user to stuff dataI  *      related to the zero row or column.  In other words, when the user K  *      adds an element in row zero or column zero, then the matrix returns K  *      a pointer to TrashCan.  In this way the user can have a uniform way L  *      data into the matrix independent of whether a component is connected  *      to ground.  */    /* Begin. */ extern  MatrixPointer  gMatrix; ( extern  struct  MatrixElement  TrashCan;  