 /*5  *  ERROR DEFINITIONS for the sparse matrix routines.   *  *  Author:   *      Kenneth S. Kundert  *      UC Berkeley   *  *  Advising professor: '  *      Alberto Sangiovanni-Vincentelli   *P  *  This module contains the macros definitions for the errors generated on the N  *  sparse matrix routines.  These macros are placed in their own file for theL  *  convienence of the user.  They may be imported into the users program to6  *  give readable names to the possible matrix errors.  */                /*  *  ERROR MACROS  *  *  >>> Error descriptions:   *  NO_ERROR  *      No error has occurred.
  *  UNDERFLOW I  *      Numeric underflow occurred.  Non-fatal error.  Code to detect and 7  *      handle this error has not yet been implemented.   *  OVERFLOWH  *      Numeric overflow occurred.  Non-fatal error.  Code to detect and7  *      handle this error has not yet been implemented.   *  ILL_CONDITIONED L  *      When reordering the matrix, no element was found which satisfies theI  *      threshold criteria.  The largest element in the matrix was chosen   *      as pivot.  Non-fatal. 	  *  RANGE K  *      Fatal error indicating that the routines are not prepared to handle L  *      the matrix that has been requested.  This may occur when the size ofJ  *      the matrix is larger than MAX_MATRIX_SIZE, when the matrix pointerK  *      passed to a matrix routine is NULL, when the matrix is specified to L  *      be real and the routines are not compiled for real matrices, or whenO  *      the matrix is specified to be complex and the routines are not compiled K  *      to handle complex matrices.  If the DEBUG option is set true then a L  *      RANGE error could also indicate that an index is out of range, that J  *      AddElementByIndex or AddAdmittanceByIndex are being used after theL  *      matrix has been reordered or that one of the SolveMatrix routines is9  *      being used before the matrix has been decomposed.   *  SINGULARM  *      Fatal error.  Matrix is singular, so no unique solution exists.  This M  *      error occurs if a pivot is zero.  Note that if this error is returned F  *      from DecomposeMatrix then the matrix should be reordered usingA  *      OrderAndDecomposeMatrix.  If this error is returned from  4  *      OrderAndDecomposeMatrix then you are doomed.
  *  NO_MEMORY M  *      Fatal error.  Indicates that not enough memory is available to handle   *      the matrix. 	  *  FATAL I  *      Not an error flag, but rather the dividing line between fatal and   *      non-fatal errors.   */    /* Begin. */ #define  NO_ERROR		0 #define  UNDERFLOW		1  #define  OVERFLOW		2 #define  ILL_CONDITIONED	3 #define  RANGE			4 #define  SINGULAR		5 #define  NO_MEMORY		6    #define  FATAL			4    