 /*  *(  *   EXPORTS for sparse matrix routines.  *  *   Author:  *       Kenneth S. Kundert   *  *   Advising professor:(  *       Alberto Sangiovanni-Vincentelli  *K  *   This file contains definitions that are useful to the calling program. L  *   In particular, this file contains some macro functions that are used toI  *   quickly enter data into the matrix and the type definition of a data I  *   structure that acts as a template for entering admittances into the  L  *   matrix. Also included is the type definitions for the various functions  *   availabel to the user.   */                  /*  *   MACRO FUNCTION DEFINITIONS   *  *   >>> Macro descriptions:  *   ADD_REAL_ELEMENT_TO_MATRIX L  *       Macro function that adds data to a real element in the matrix by a   *       pointer.   *   ADD_IMAG_ELEMENT_TO_MATRIX O  *       Macro function that adds data to a imaginary element in the matrix by    *       a pointer. "  *   ADD_COMPLEX_ELEMENT_TO_MATRIXO  *       Macro function that adds data to a complex element in the matrix by a    *       pointer. $  *   ADD_REAL_QUAD_ELEMENT_TO_MATRIXP  *       Macro function that adds data to each of the four real matrix elements *  *       specified by the given template. $  *   ADD_IMAG_QUAD_ELEMENT_TO_MATRIXK  *       Macro function that adds data to each of the four imaginary matrix 3  *       elements specified by the given template.  '  *   ADD_COMPLEX_QUAD_ELEMENT_TO_MATRIX I  *       Macro function that adds data to each of the four complex matrix 3  *       elements specified by the given template.    */    /* Begin Macros. */ : #define  ADD_REAL_ELEMENT_TO_MATRIX(Sp_element,Sp_real)  \!          *(Sp_element) += Sp_real   : #define  ADD_IMAG_ELEMENT_TO_MATRIX(Sp_element,Sp_imag)  \#          *(Sp_element+1) += Sp_imag   E #define  ADD_COMPLEX_ELEMENT_TO_MATRIX(Sp_element,Sp_real,Sp_imag)  \ )          {   *(Sp_element) += Sp_real;  \ +              *(Sp_element+1) += Sp_imag;  \ 
          }  @ #define  ADD_REAL_QUAD_ELEMENT_TO_MATRIX(Sp_template,Sp_real)  \+ 	{   *(Sp_template.Element1) += Sp_real;  \ + 	    *(Sp_template.Element2) += Sp_real;  \ 2 	    *(Sp_template.Element3Negated) -= Sp_real;  \2 	    *(Sp_template.Element4Negated) -= Sp_real;  \ 	}  @ #define  ADD_IMAG_QUAD_ELEMENT_TO_MATRIX(Sp_template,Sp_imag)  \- 	{   *(Sp_template.Element1+1) += Sp_imag;  \ - 	    *(Sp_template.Element2+1) += Sp_imag;  \ 4 	    *(Sp_template.Element3Negated+1) -= Sp_imag;  \4 	    *(Sp_template.Element4Negated+1) -= Sp_imag;  \ 	}  K #define  ADD_COMPLEX_QUAD_ELEMENT_TO_MATRIX(Sp_template,Sp_real,Sp_imag)  \ + 	{   *(Sp_template.Element1) += Sp_real;  \ + 	    *(Sp_template.Element2) += Sp_real;  \ 2 	    *(Sp_template.Element3Negated) -= Sp_real;  \2 	    *(Sp_template.Element4Negated) -= Sp_real;  \- 	    *(Sp_template.Element1+1) += Sp_imag;  \ - 	    *(Sp_template.Element2+1) += Sp_imag;  \ 4 	    *(Sp_template.Element3Negated+1) -= Sp_imag;  \4 	    *(Sp_template.Element4Negated+1) -= Sp_imag;  \ 	}                       /*+  *   TYPE DEFINITION FOR COMPONENT TEMPLATE   *N  *   This data structure is used to hold pointers to four related elements in :  *   matrix.  It is used in conjunction with the routines   *       AddAdmittanceToMatrix#  *       AddRealQuadElementToMatrix #  *       AddImagQuadElementToMatrix &  *       AddComplexQuadElementToMatrixK  *   AddAdmittanceToMatrix stuffs the structure which is later used by the  M  *   QuadElement routines.  It is also possible for the user to collect four  O  *   pointers returned by AddElementToMatrix and stuff them into the template.  O  *   The QuadElement routines stuff data into the matrix in locations specified N  *   by Element1 and Element2 without changing the data.  The data is negated 2  *   before being placed in Element3 and Element4.  */     /* Begin. */ struct  TemplateStruct {   double    *Element1       ;      double    *Element2       ;      double    *Element3Negated;      double    *Element4Negated;  };             /*  *   FUNCTION TYPE DEFINITIONS  *A  *   The type of every user accessable function is declared here.   */    char   *AllocateMatrix();  double *AddElementToMatrix(); ! void    AddRealElementToMatrix(); ! void    AddImagElementToMatrix(); $ void    AddComplexElementToMatrix();  void    AddAdmittanceToMatrix();% void    AddRealQuadElementToMatrix(); % void    AddImagQuadElementToMatrix(); ( void    AddComplexQuadElementToMatrix(); void    ClearMatrix(); int     ClearMatrixError();   void    ComplexMatrixMultiply(); void    DeallocateMatrix();  void    Determinant(); int     DecomposeMatrix(); double  MatrixRoundoffError ();  int     MatrixError(); void    PrintMatrix();" int     OrderAndDecomposeMatrix(); void    OutputMatrixToFile();  void    OutputVectorToFile(); ! void    OutputStatisticsToFile();  void    RealMatrixMultiply();  void    SolveRealMatrix(); void    SolveComplexMatrix(); $ void    SolveRealTransposedMatrix();' void    SolveComplexTransposedMatrix();  void    ScaleRealMatrix(); void    ScaleComplexMatrix();   