 /*=  *   PERSONALITY MACRO DEFINITIONS for sparse matrix routines   *  *   Author:  *       Kenneth S. Kundert   *       U.C. Berkeley  *  *   Advising professor:(  *       Alberto Sangiovanni-Vincentelli  *K  *   This file contains macros for the sparse matrix routines that are used I  *   to define the personality of the routines.  The user is expected to  F  *   modify this file to maximize the performance of the routines with  *   his/her matrices.  *  *G  *   Macros are distinguished by using solely capital letters in their  G  *   identifiers.  This contrasts with C defined identifiers which are  M  *   strickly lower case, and program variable and procedure names which use    *   both upper and lower case.   */                  /*  *   OPTIONS  *H  *   These are compiler options.  Set each option to one to compile thatE  *   section of the code.  If a feature is not desired, set the macro C  *   to zero. Recommendations are given in brackets, [ignore them]. L  *   They spring from experience systems of equations generated by RELAX2.2,C  *   a simulator for large digital MOS circuits where the dominant    *   consideration was speed.   *  *   >>> Option descriptions: 	  *   REAL M  *       This specifies that the routines are expected to handle real systems L  *       of equations.  The routines can be compiled to handle both real andK  *       complex systems at the same time, but there is a slight speed and  J  *       memory advantage if the routines are complied to handle only real"  *       systems of equations. [1]  *   COMPLEXL  *       This specifies that the routines will be complied to handle complex"  *       systems of equations. [0]  *   EXPANDABLE I  *       Setting this compiler flag true (1) makes the matrix expandable  H  *       before they have been decomposed.  If the matrix is expandable,K  *       then if an element is added that would be considered out of bounds K  *       in the current matrix, the size of the matrix is increased to hold M  *       that element.  As a result, the size of the matrix need not be known K  *       before the matrix is built.  The matrix can be allocated with size   *       zero and expanded.   *   ARRAY_OFFSET P  *       This determines whether arrays start at an index of zero or one.  This O  *       option is necessitated by the fact that standard C convention dictates L  *       that arrays begin with an index of zero but the standard mathematicI  *       convention states that arrays begin with an index of one.  So if J  *       you perfer to start your arrays with zero, or your calling SparseD  *       from FORTRAN, use an ARRAY_OFFSET of 0.  Otherwise, use an G  *       ARRAY_OFFSET of 1.  Note that if you use an offset of one, the M  *       arrays that you pass to Sparse must have an allocated length of one  I  *       plus the size of the matrix. ARRAY_OFFSET must be either 0 or 1, (  *       no other offsets are valid. [1]  *   SEPARATED_COMPLEX_VECTORSM  *       This specifies the format for complex vectors.  If this is set false O  *       then a complex vector is made up of one double sized array of doubles  N  *       in which the real and imaginary numbers are placed in the alternatelyF  *       array in the array.  In other words, the first entry would beL  *       Complex[1].Real, then comes Complex[1].Imag, then Complex[1].Real, J  *       etc.  If SEPARATED_COMPLEX_VECTORS is set true, then each complexJ  *       vector is represented by two arrays of doubles, one with the real-  *       terms, the other with the imaginary.   *   MODIFIED_MARKOWITZ M  *       This specifies that the Modified Markowitz method of pivot selection G  *       is to be used.  The Modified Markowitz method is used to break L  *       Markowitz ties.  When two or more elements are pivot candidates andL  *       they all have the same Markowitz product, then the tie is broken byM  *       choosing the element that is best numerically.  The numerically best J  *       element is the one with the largest ratio of its magnitude to theH  *       magnitude of the largest element in the same column, excluding J  *       itself.  The modified Markowitz method results in higher accuracyN  *       but results in more row and column exchanges, which slows the initialI  *       decomposition.  Thus, if only one matrix is to be solved, and if J  *       accuracy is not an issue, as with positive definite or diagonallyN  *       dominant matrices, Modified Markowitz should not be used.  Otherwize,2  *       it is probably a good idea to use it. [0]  *   MONITOR_GROWTH J  *       This specifies that estamates for the growth that has occurred inK  *       the matrix during the decomposition and the largest element in the H  *       matrix should be calculated.  This slows the routines some, butI  *       the growth is needed to decide if the matrix has been decomposed I  *       accurately.  If growth is very high during an initial decompose, L  *       then the pivot threshold should be raised.  If the growth increasesJ  *       greatly on subsequent decomposes, then the matrix should probably  *       be reordered. [0]  *   CALCULATE_PSEUDOCONDITION  K  *       This specifies that a very crude and easily fooled estimate of the H  *       amount ill-conditioning that is present in the matrix should be  *       calculated. [0]  *   MODIFIED_NODAL E  *       This specifies that the routine that preorders modified node I  *       admittance matrices should be compiled.  This routine results in E  *       greater speed and accuracy if used with this type of matrix.   *   QUAD_ELEMENT J  *       This specifies that the routines that allow four related elementsJ  *       to be entered into the matrix at once should be compiled.  These O  *       elements are usually related to an admittance.  The routines affected  K  *       by QUAD_ELEMENT ate the AddAdmittance and AddQuadElement routines.   *   TRANSPOSEH  *       This specifies that the routines that solve the matrix as if itK  *       was transposed should be compiled.  These routines are useful when B  *       performing sensitivity analysis using the adjoint method.  *   SCALINGL  *       This specifies that the routine that performs scaling on the matrixM  *       should be complied.  Scaling is not strongly supported.  The routine I  *       to scale the matrix is provided, but no routines are provided to L  *       scale and descale the Source and Solution vectors.  It is suggestedN  *       that if scaling is desired, it only be preformed when the pivot orderM  *       is being chosen (in OrderAndDecomposeMatrix).  This is the only time L  *       scaling has an effect.  The scaling may then either be removed fromN  *       the solution by the user or the scaled decompose may simply be thrown  *       away. [0]  *   DOCUMENTATIONK  *       This specifies that routines that are used to document the matrix, H  *       such as PrintMatrix and OutputMatrixToFile, should be compiled.  *   DETERMINANTH  *       This specifies that the routine Determinant should be complied.  *   MULTIPLICATION F  *       This specifies that the routines to multiply the undecomposed/  *       matrix by a vector should be compiled. 
  *   DEBUGH  *       This specifies that additional error checking will be compiled.E  *       The type of error checked are those that are common when the J  *       matrix routines are first integrated into a user's program.  OnceL  *       the routines have been integrated in and are running smoothly, this%  *       option should be turned off.   */    /* Begin. */ #define  REAL				1 #define  COMPLEX			0 #define  EXPANDABLE			0  #define  ARRAY_OFFSET			1 $ #define  SEPARATED_COMPLEX_VECTORS	0 #define  MODIFIED_MARKOWITZ		0 #define  MONITOR_GROWTH			0 $ #define  CALCULATE_PSEUDOCONDITION	0 #define  MODIFIED_NODAL			0  #define  QUAD_ELEMENT			0  #define  TRANSPOSE			0 #define  SCALING			0 #define  DOCUMENTATION			0 #define  MULTIPLICATION			0  #define  DETERMINANT			0 #define  DEBUG				0                  /*  *   MATRIX CONSTANTS   *J  *   These constants are used throughout the sparse matrix routines.  TheyK  *   should be set to suit the type of matrix being solved.  Recomendations   *   are given in brackets.   *O  *   Some terminology should be defined.  The Markowitz row count is the number O  *   of non-zero elements in a row excluding the one being considered as pivot. K  *   There is one Markowitz row count for every row.  The Markowitz column  L  *   is defined similarly for columns.  The Markowitz product for an elementM  *   is the product of its row and column counts. It is a measure of how much J  *   work would be required on the next step of the decomposition if that N  *   element were chosen to be pivot.  A small Markowitz product is desirable.  *  *   >>> Constants decriptions:   *   MAX_MATRIX_SIZEN  *       The largest matrix that can be handled by the sparse matrix routines.N  *       This constant must be representable by an int.  Note that nothing is >  *       gained by reducing the size of this constant. [32760]  *   DEFAULT_THRESHOLDJ  *       The threshold used if the user enters an invalid threshold.  Also<  *       the threshold used by DecomposeMatrix when calling L  *       OrderAndDecomposeMatrix.  The default threshold should not be less ;  *       than or equal to zero nor larger than one. [0.001]   *   SPACE_FOR_ELEMENTS K  *       This number multiplied by the size of the matrix equals the number @  *       of elements for which memory is initially allocated in   *       AllocateMatrix(). [6]  *   SPACE_FOR_FILL_INS K  *       This number multiplied by the size of the matrix equals the number M  *       of elements for which memory is initially allocated and specifically 7  *       reserved for fill-ins in AllocateMatrix(). [4]   *   ELEMENTS_PER_ALLOCATIONL  *       The number of matrix elements requested from the malloc utility on I  *       each call to it.  Setting this value greater than 1 reduces the  J  *       amount of overhead spent in this system call. On a virtual memoryJ  *       machine, its good to allocate slightly less than a page worth of 7  *       elements at a time (or some multiple thereof). >  *       [For the VAX, for real only use 41, otherwise use 31]  *   MINIMUM_ALLOCATED_SIZE I  *       The minimun allocated size of a matrix.  Note that this does not J  *       limit the minimun size of a matrix.  This just prevents having toJ  *       resize a matrix many times if the matrix is expandable, large andJ  *       allocated with an estimated size of zero.  This number should not  *       be less than one.  *   EXPANSION_FACTOR J  *       The amount the allocated size of the matrix is increased when it   *       is expanded.   *   MAX_MARKOWITZ_TIES M  *       This number is used for two slightly different things, both of which L  *       relate to the search for the best pivot.  First, it is the maximum H  *       number of elements that are Markowitz tied that will be sifted J  *       through when trying to find the one that is numerically the best.K  *       Second, it creates an upper bound on how large a Markowitz product H  *       can be before it eliminates the possiblity of early terminationM  *       of the pivot search.  In other words, if the product of the smallest H  *       Markowitz product yet found and TIES_MULTIPLIER is greater thanC  *       MAX_MARKOWITZ_TIES, then no early termination takes place. O  *       Set MAX_MARKOWITZ_TIES to some small value if no early termination of  O  *       the pivot search is desired. An array of doubles is allocated of size  N  *       MAX_MARKOWITZ_TIES so it must be positive and shouldn't be too large.;  *       Active when MODIFIED_MARKOWITZ is 1 (true).  [100]   *   TIES_MULTIPLIERJ  *       Specifies the number of Markowitz ties that are allowed to occur K  *       before the search for the pivot is terminated early.  Set to some  M  *       large value if no early termination of the pivot search is desired.  K  *       This number is multiplied times the Markowitz product to determine K  *       how many ties are required for early termination.  This means that K  *       more elements will be searched before early termination if a large K  *       number of fill-ins could be created by accepting what is currently @  *       considered the best choice for the pivot.  Active when F  *       MODIFIED_MARKOWITZ is 1 (true).  Setting this number to zero G  *       effectively eliminates all pivoting, which should be avoided.  I  *       This number must be positive.  TIES_MULTIPLIER is also used when +  *       diagonal pivoting breaks down. [5]   */    /* Begin. */ #define  MAX_MATRIX_SIZE		32760 " #define  DEFAULT_THRESHOLD		1.0e-3 #define  SPACE_FOR_ELEMENTS		6 #define  SPACE_FOR_FILL_INS		4# #define  ELEMENTS_PER_ALLOCATION	31 " #define  MINIMUM_ALLOCATED_SIZE		6 #define  EXPANSION_FACTOR		1.5  #define  MAX_MARKOWITZ_TIES		100 #define  TIES_MULTIPLIER		5              /*  *  PRINTER WIDTH   *G  *  These macros characterize the printer for the PrintMatrix routine.    *  *  >>> Macros:   *  NUMERIC_COLUMNS_PER_PAGEH  *      Sets the number of columns printed when PrintMatrix is executed.8  *      Set to 7 for terminal and 12 for line printer.    *  CHARACTER_COLUMNS_PER_PAGEK  *      Sets the number of columns printed when PrintMatrix is executed in  L  *      compressed mode.  In this mode, every nonzero entry in the matrix isH  *      printed simply as an `x'.  Set to 79 for terminal, 132 for line   *      printer.    */   
 /*  Begin. */ # #define  NUMERIC_COLUMNS_PER_PAGE	7 & #define  CHARACTER_COLUMNS_PER_PAGE	79             /*  *  MACHINE CONSTANTS   *N  *  These numbers must be updated when the program is ported to a new machine.  */    /* Begin. */" /* VAX 11/780 Machine Constants */, #define  MACHINE_RESOLUTION      6.93889e-18, #define  LARGEST_REAL            1.70141e+38. #define  SMALLEST_REAL           2.938743e-39 & #define  LARGEST_SHORT_INTEGER   32766+ #define  LARGEST_LONG_INTEGER    2147483646         /* HP9000 Machine Constants */, /*  #define  MACHINE_RESOLUTION      8.9e-15:  *  #define  LARGEST_REAL            1.79769313486231e+308;  *  #define  SMALLEST_REAL           2.22507385850721e-308  *  *  #define  LARGEST_SHORT_INTEGER   32767/  *  #define  LARGEST_LONG_INTEGER    2147483647   */                 /*  *  OUTPUT FILES  *:  *  These are the files used by the OutputToFile routines.  *  *  >>> Files:  *  MATRIX_FILE P  *      File to which OutputMatrixToFile and OutputVectorToFile sends a copy of &  *      the matrix and source vector.   *  STATISTICS_FILE ?  *      File to which OutputMatrixStatistics sends statistics.    *  ID_NUMBER_FILEM  *      File which contains an ID number for each matrix outputed to a file.  G  *      Used to tie together statistics to their coresponding matrix.     */    /* Begin. */  #define  MATRIX_FILE		"./matrix"" #define  STATISTICS_FILE	"./stats"# #define  ID_NUMBER_FILE		"./number"            /*  *  ANNOTATION  *G  *  This macro changes the amount of annotation produced by the matrix  L  *  routines.  The annotation is used as a debugging aid.  Change the numberK  *  associated with ANNOTATE to change the amount of annotation produced by   *  the program.  */    /* Begin. */ #define  ANNOTATE		0   #define  NONE			0  #define  ON_STRANGE_BEHAVIOR	1 #define  FULL			2   