 /*  *  MATRIX SOLVE MODULE   *  *  Author:   *      Kenneth S. Kundert  *      UC Berkeley   *  *  Advising professor: '  *      Alberto Sangiovanni-Vincentelli   *L  *  This module contains the forward and backward substitution routines for   *  the sparse matrix routines.   *;  *  >>> User accessable functions contained in this module:   *  SolveRealMatrix   *  SolveComplexMatrix  *  SolveRealTransposedMatrix    *  SolveComplexTransposedMatrix  *+  *  >>> Functions contained in this module:   *  SolveRealMatrix   *  SolveComplexMatrix  *  SolveRealTransposedMatrix    *  SolveComplexTransposedMatrix  */                  /*  *  IMPORTS   *  *  >>> Import decriptions:   *  stdio.h   *     Standard C IO library.   *  MtrxPers.hH  *     Macros that customize the sparse matrix routines. This file comes6  *     to us indirectly, it is imported by MtrxDefs.h.  *  MtrxExpt.h:  *     Macros and declarations to be imported by the user.  *  MtrxDefs.hH  *     Matrix type and macro definitions for the sparse matrix routines.  *  MtrxError.h &  *     Matrix error macro definitions.  */     #include <stdio.h> #include "MtrxExpt.h"  #include "MtrxDefs.h"  #include "MtrxError.h"            
 #if (REAL) /*  *  SOLVE REAL MATRIX EQUATION  *N  *  Performs forward elimination and back substitution to find unknown vector /  *  from source vector and decomposed matrix.     *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to matrix.     *  Source  <input>  (double [])J  *      Source is the input data array, the right hand side. This data is 8  *      undisturbed and may be reused for other solves. #  *  Solution  <output>  (double []) P  *      Solution is the output data array. This routine is constructed such that3  *      Source and Solution can be the same array.    *  *  >>> Local variables:  *  Intermediate  (double []) F  *      Temporary storage for use in forward elimination and backward L  *      substitution.  Commonly referred to as c, when the LU Decomposition H  *      equations are given as  Ax = b, Lc = b, Ux = c Local version of G  *      Matrix->IntermediateReal, which was created during the initial  F  *      decomposition in function CreateMarkowitzVectors in the Matrix  *      Decomposition module.     *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper triangle   *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.   *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.   *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  Temp  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:	  *  RANGE )  *  Error is not cleared in this routine.   */     void, SolveRealMatrix( Matrix, Source, Solution )                           MatrixPointer  Matrix; double  Source[], Solution[];    {   + register  int  I, Size, *pEliminationOrder;   register  double  *Intermediate;# register  ElementPointer  pElement;  ElementPointer  pPivot; 
 double  Temp;    /* Begin `SolveRealMatrix'. */ #if (DEBUG) 8     if ((NOT gMatrix->Decomposed) OR (gMatrix->Complex))     {   gMatrix->Error = RANGE;          return;      }  #endif       Size = Matrix->Size;,     Intermediate = Matrix->IntermediateReal;  . /* Correct array pointers for ARRAY_OFFSET. */ #if (NOT ARRAY_OFFSET)
     --Source;      --Solution;  #endif   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) 9         Intermediate[I] = Source[*(pEliminationOrder++)];    ( /* Forward elimination. Solves Lc = b.*/     for (I = 1; I <= Size; I++) !     {   pPivot = Matrix->Diag[I];          Temp = Intermediate[I];                  B /* This step of the elimination is skipped if Temp equals zero. */         if (Temp != 0.0)!         {   Temp /= pPivot->Real; #             Intermediate[I] = Temp; )             pElement = pPivot->NextInCol; $             while (pElement != NULL)E             {   Intermediate[pElement->Row] -= Temp * pElement->Real; /                 pElement = pElement->NextInCol; 
             }                  	         }      }                    * /* Backward Substitution. Solves Ux = c.*/     for (I = Size; I >= 1; I--)      {   Temp = Intermediate[I]; .         pElement = Matrix->Diag[I]->NextInRow;          while (pElement != NULL)B         {   Temp -= pElement->Real * Intermediate[pElement->Col]; +             pElement = pElement->NextInRow; 	         }          Intermediate[I] = Temp;      }   O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) ;         Solution[*(pEliminationOrder++)] = Intermediate[I];        return;  }  #endif  /* REAL */                      
 #if (COMPLEX)  /*!  *  SOLVE COMPLEX MATRIX EQUATION   *N  *  Performs forward elimination and back substitution to find unknown vector /  *  from source vector and decomposed matrix.     *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to matrix.     *  Source  <input>  (double [])K  *      Source is the real portion of the input data array, the right hand  K  *      side. This data is undisturbed and may be reused for other solves.  #  *  Solution  <output>  (double []) K  *      Solution is the real portion of the output data array. This routine E  *      is constructed such that Source and Solution can be the same  M  *      array.  If SEPARATED_COMPLEX_VECTOR is set false, there is no need to   *      supply this array.$  *  SourceImag  <input>  (double [])O  *      SourceImag is the imaginary portion of the input data array, the right  O  *      hand side. This data is undisturbed and may be reused for other solves. E  *      If SEPARATED_COMPLEX_VECTOR is set false, there is no need to   *      supply this array.'  *  SolutionImag  <output>  (double []) M  *      SolutionImag is the imaginary portion of the output data array. This  L  *      routine is constructed such that SourceImag and SolutionImag can be O  *      the same array.  If SEPARATED_COMPLEX_VECTOR is set false, there is no  "  *      need to supply this array.  *  *  >>> Local variables:!  *  IntermediateImag  (double []) F  *      Temporary storage for use in forward elimination and backward K  *      substitution.  Commonly referred to as the imaginary portion of c,  P  *      when the LU Decomposition equations are given as  Ax = b, Lc = b, Ux = cL  *      Local version of Matrix->IntermediateImag, which was created during L  *      the initial decomposition in function CreateMarkowitzVectors in the &  *      Matrix Decomposition module.  !  *  IntermediateReal  (double []) %  *      Real version of Intermediate.   *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper triangle   *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.   *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.   *  pSolution  (double *) 5  *      Pointer that points into the solution vector.   *  pSource  (double *) 3  *      Pointer that points into the source vector.   *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  TempImag  (double)0  *      Temporary storage for entries in arrays.  *  TempReal  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:	  *  RANGE )  *  Error is not cleared in this routine.   */     voidI SolveComplexMatrix( Matrix, Source, Solution, SourceImag, SolutionImag )                            MatrixPointer  Matrix;; double  Source[], SourceImag[], Solution[], SolutionImag[];    {   + register  int  I, Size, *pEliminationOrder; 7 register  double  *IntermediateReal, *IntermediateImag; # register  ElementPointer  pElement;  ElementPointer  pPivot; 1 double  TempReal, TempImag, *pSource, *pSolution;  CMPLX_DIVIDE_DECLARATIONS;  ! /* Begin `SolveComplexMatrix'. */  #if (DEBUG) <     if ((NOT gMatrix->Decomposed) OR (NOT gMatrix->Complex))     {   gMatrix->Error = RANGE;          return;      }  #endif       Size = Matrix->Size;0     IntermediateReal = Matrix->IntermediateReal;0     IntermediateImag = Matrix->IntermediateImag;  . /* Correct array pointers for ARRAY_OFFSET. */ #if (NOT ARRAY_OFFSET) #if (SEPARATED_COMPLEX_VECTORS) 
     --Source;      --Solution;      --SourceImag;      --SolutionImag;  #else      Source - 2;      Solution - 2;  #endif #endif   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;   #if (SEPARATED_COMPLEX_VECTORS)      for (I = 1; I <= Size; I++) ;     {   IntermediateReal[I] = Source[*(pEliminationOrder)]; A         IntermediateImag[I] = SourceImag[*(pEliminationOrder++)];      }  #else      for (I = 1; I <= Size; I++) 6     {   pSource = &Source[2 * *(pEliminationOrder++)];)         IntermediateReal[I] = *pSource++; '         IntermediateImag[I] = *pSource;      }  #endif   ) /* Forward substitution. Solves Lc = b.*/      for (I = 1; I <= Size; I++) !     {   pPivot = Matrix->Diag[I]; '         TempReal = IntermediateReal[I]; '         TempImag = IntermediateImag[I];                  C /* This step of the substitution is skipped if Temp equals zero. */ 3         if ((TempReal != 0.0) OR (TempImag != 0.0)) 	         { $ /* Complex divide : Temp /= Pivot */P             CMPLX_DIVIDE_ASSIGN(TempReal, TempImag, pPivot->Real, pPivot->Imag);+             IntermediateReal[I] = TempReal; +             IntermediateImag[I] = TempImag; )             pElement = pPivot->NextInCol; $             while (pElement != NULL)             {   H /* Complex expression : Intermediate[Element->Row] -= Temp * *Element */H                 CMPLX_MULT_SUBT_ASSIGN(IntermediateReal[pElement->Row], P                                       IntermediateImag[pElement->Row], TempReal,Q                                       TempImag, pElement->Real, pElement->Imag);  /                 pElement = pElement->NextInCol; 
             } 	         }      }   * /* Backward Substitution. Solves Ux = c.*/     for (I = Size; I >= 1; I--) '     {   TempReal = IntermediateReal[I]; '         TempImag = IntermediateImag[I]; .         pElement = Matrix->Diag[I]->NextInRow;            while (pElement != NULL)         {   H /* Complex expression : Temp -= *Element * Intermediate[Element->Col] */G             CMPLX_MULT_SUBT_ASSIGN(TempReal, TempImag, pElement->Real,  P                                 pElement->Imag, IntermediateReal[pElement->Col],A                                 IntermediateImag[pElement->Col]); +             pElement = pElement->NextInRow; 	         } '         IntermediateReal[I] = TempReal; '         IntermediateImag[I] = TempImag;      }   O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;   #if SEPARATED_COMPLEX_VECTORS      for (I = 1; I <= Size; I++) =     {   Solution[*(pEliminationOrder)] = IntermediateReal[I]; C         SolutionImag[*(pEliminationOrder++)] = IntermediateImag[I];      }  #else      for (I = 1; I <= Size; I++) :     {   pSolution = &Solution[2 * *(pEliminationOrder++)];+         *pSolution++ = IntermediateReal[I]; )         *pSolution = IntermediateImag[I];      }  #endif       return;  }  #endif  /* COMPLEX */                              #if (REAL AND TRANSPOSE) /*)  *  SOLVE REAL TRANSPOSED MATRIX EQUATION   *N  *  Performs forward elimination and back substitution to find unknown vector O  *  from source vector and transposed decomposed matrix. This routine is useful O  *  when performing sensitivity analysis on a circuit using the adjoint method.   *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to matrix.     *  Source  <input>  (double [])J  *      Source is the input data array, the right hand side. This data is 8  *      undisturbed and may be reused for other solves. #  *  Solution  <output>  (double []) P  *      Solution is the output data array. This routine is constructed such that3  *      Source and Solution can be the same array.    *  *  >>> Local variables:  *  Intermediate  (double []) F  *      Temporary storage for use in forward elimination and backward L  *      substitution.  Commonly referred to as c, when the LU Decomposition H  *      equations are given as  Ax = b, Lc = b, Ux = c Local version of G  *      Matrix->IntermediateReal, which was created during the initial  F  *      decomposition in function CreateMarkowitzVectors in the Matrix  *      Decomposition module.     *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper triangle   *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.   *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.   *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  Temp  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:	  *  RANGE )  *  Error is not cleared in this routine.   */     void6 SolveRealTransposedMatrix( Matrix, Source, Solution )                           MatrixPointer  Matrix; double  Source[], Solution[];    {   + register  int  I, Size, *pEliminationOrder;   register  double  *Intermediate;# register  ElementPointer  pElement;  ElementPointer  pPivot; 
 double  Temp;   ( /* Begin `SolveRealTransposedMatrix'. */ #if (DEBUG) 8     if ((NOT gMatrix->Decomposed) OR (gMatrix->Complex))     {   gMatrix->Error = RANGE;          return;      }  #endif       Size = Matrix->Size;,     Intermediate = Matrix->IntermediateReal;  . /* Correct array pointers for ARRAY_OFFSET. */ #if (NOT ARRAY_OFFSET)
     --Source;      --Solution;  #endif   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) 9         Intermediate[I] = Source[*(pEliminationOrder++)];     /* Forward elimination. */     for (I = 1; I <= Size; I++) !     {   pPivot = Matrix->Diag[I];          Temp = Intermediate[I];                  B /* This step of the elimination is skipped if Temp equals zero. */         if (Temp != 0.0))         {   pElement = pPivot->NextInRow; $             while (pElement != NULL)E             {   Intermediate[pElement->Col] -= Temp * pElement->Real; /                 pElement = pElement->NextInRow; 
             }                  	         }      }                     /* Backward Substitution. */     for (I = Size; I >= 1; I--) !     {   pPivot = Matrix->Diag[I];          Temp = Intermediate[I]; %         pElement = pPivot->NextInCol;           while (pElement != NULL)B         {   Temp -= pElement->Real * Intermediate[pElement->Row]; +             pElement = pElement->NextInCol; 	         } .         Intermediate[I] = Temp / pPivot->Real;     }   O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) ;         Solution[*(pEliminationOrder++)] = Intermediate[I];        return;  }   #endif  /* REAL AND TRANSPOSE */                     #if (TRANSPOSE AND COMPLEX)  /*,  *  SOLVE COMPLEX TRANSPOSED MATRIX EQUATION  *N  *  Performs forward elimination and back substitution to find unknown vector O  *  from source vector and transposed decomposed matrix. This routine is useful O  *  when performing sensitivity analysis on a circuit using the adjoint method.   *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to matrix.     *  Source  <input>  (double [])7  *      Source is the input data array, the right hand  K  *      side. This data is undisturbed and may be reused for other solves.  I  *      This vector is only the real portion if the matrix is complex and .  *      SEPARATED_COMPLEX_VECTORS is set true.#  *  Solution  <output>  (double []) K  *      Solution is the real portion of the output data array. This routine E  *      is constructed such that Source and Solution can be the same    *      array.  I  *      This vector is only the real portion if the matrix is complex and .  *      SEPARATED_COMPLEX_VECTORS is set true.$  *  SourceImag  <input>  (double [])O  *      SourceImag is the imaginary portion of the input data array, the right  O  *      hand side. This data is undisturbed and may be reused for other solves. E  *      If SEPARATED_COMPLEX_VECTOR is set false, there is no need to   *      supply this array.'  *  SolutionImag  <output>  (double []) M  *      SolutionImag is the imaginary portion of the output data array. This  L  *      routine is constructed such that SourceImag and SolutionImag can be O  *      the same array.  If SEPARATED_COMPLEX_VECTOR is set false, there is no  "  *      need to supply this array.  *  *  >>> Local variables:!  *  IntermediateImag  (double []) F  *      Temporary storage for use in forward elimination and backward K  *      substitution.  Commonly referred to as the imaginary portion of c,  P  *      when the LU Decomposition equations are given as  Ax = b, Lc = b, Ux = cL  *      Local version of Matrix->IntermediateImag, which was created during L  *      the initial decomposition in function CreateMarkowitzVectors in the &  *      Matrix Decomposition module.  !  *  IntermediateReal  (double []) %  *      Real version of Intermediate.   *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper triangle   *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.   *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.   *  pSolution  (double *) 5  *      Pointer that points into the solution vector.   *  pSource  (double *) 3  *      Pointer that points into the source vector.   *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  TempImag  (double)0  *      Temporary storage for entries in arrays.  *  TempReal  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:	  *  RANGE )  *  Error is not cleared in this routine.   */     void: SolveComplexTransposedMatrix( Matrix, Source, SourceImag, 7                               Solution, SolutionImag )                            MatrixPointer  Matrix;; double  Source[], SourceImag[], Solution[], SolutionImag[];    {   + register  int  I, Size, *pEliminationOrder; 7 register  double  *IntermediateReal, *IntermediateImag; # register  ElementPointer  pElement;  ElementPointer  pPivot; 1 double  TempReal, TempImag, *pSource, *pSolution;  CMPLX_DIVIDE_DECLARATIONS;  + /* Begin `SolveComplexTransposedMatrix'. */  #if (DEBUG) <     if ((NOT gMatrix->Decomposed) OR (NOT gMatrix->Complex))     {   gMatrix->Error = RANGE;          return;      }  #endif       Matrix->Error = NO_ERROR;      Size = Matrix->Size;0     IntermediateReal = Matrix->IntermediateReal;0     IntermediateImag = Matrix->IntermediateImag;  . /* Correct array pointers for ARRAY_OFFSET. */ #if (NOT ARRAY_OFFSET) #if (SEPARATED_COMPLEX_VECTORS) 
     --Source;      --Solution;      --SourceImag;      --SolutionImag;  #else      Source - 2;      Solution - 2;  #endif #endif   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;   #if (SEPARATED_COMPLEX_VECTORS)      for (I = 1; I <= Size; I++) ;     {   IntermediateReal[I] = Source[*(pEliminationOrder)]; A         IntermediateImag[I] = SourceImag[*(pEliminationOrder++)];      }  #else      for (I = 1; I <= Size; I++) 6     {   pSource = &Source[2 * *(pEliminationOrder++)];)         IntermediateReal[I] = *pSource++; '         IntermediateImag[I] = *pSource;      }  #endif    /* Forward elimination. */     for (I = 1; I <= Size; I++) !     {   pPivot = Matrix->Diag[I]; '         TempReal = IntermediateReal[I]; '         TempImag = IntermediateImag[I];                  B /* This step of the elimination is skipped if Temp equals zero. */3         if ((TempReal != 0.0) OR (TempImag != 0.0)) )         {   pElement = pPivot->NextInRow; $             while (pElement != NULL)             {   H /* Complex expression : Intermediate[Element->Col] -= Temp * *Element */H                 CMPLX_MULT_SUBT_ASSIGN( IntermediateReal[pElement->Col],I                                         IntermediateImag[pElement->Col],  <                                         TempReal, TempImag, H                                         pElement->Real, pElement->Imag);/                 pElement = pElement->NextInRow; 
             } 	         }      }                     /* Backward Substitution. */     for (I = Size; I >= 1; I--) !     {   pPivot = Matrix->Diag[I]; '         TempReal = IntermediateReal[I]; '         TempImag = IntermediateImag[I]; %         pElement = pPivot->NextInCol;             while (pElement != NULL)         {   H /* Complex expression : Temp -= Intermediate[Element->Row] * *Element */8             CMPLX_MULT_SUBT_ASSIGN( TempReal, TempImag, D                                     IntermediateReal[pElement->Row],E                                     IntermediateImag[pElement->Row],  D                                     pElement->Real, pElement->Imag);  +             pElement = pElement->NextInCol; 	         } 3 /* Complex divide : Intermediate = Temp / *Pivot */ H         CMPLX_DIVIDE(IntermediateReal[I], IntermediateImag[I], TempReal,;                      TempImag, pPivot->Real, pPivot->Imag);      }   O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;   #if (SEPARATED_COMPLEX_VECTORS)      for (I = 1; I <= Size; I++) =     {   Solution[*(pEliminationOrder)] = IntermediateReal[I]; C         SolutionImag[*(pEliminationOrder++)] = IntermediateImag[I];      }  #else      for (I = 1; I <= Size; I++) :     {   pSolution = &Solution[2 * *(pEliminationOrder++)];+         *pSolution++ = IntermediateReal[I]; )         *pSolution = IntermediateImag[I];      }  #endif       return;  } # #endif  /* TRANSPOSE AND COMPLEX */                         