 /* MULTIRATE ITA:   *D  * This routine implements, at the subcircuit level, a multirate ITAB  * algorithm.  Each subcircuit is examined to figure out if it is:  *     1) Latent.  *     2) Active and doing initial integration,  *     3) Active and doing final integration"  *     4) Going into rollback mode/  *     5) or just finishing off the simulation. C  * Based on which of the above situations it is in, the appropriate A  * action is taken.  Three things make this code more complicated   * looking than it should be: 1  *     1) the step selection strategy at any time C  *     2) anything associated with timept1, timept2 and newtimept2. B  *     3) the goto's and spaghetti code associated with rejections  */    /* Minor things left to do: 7  *      1) some really bad code in storewave(), fix it. 5  *	2) breakpoints screw up binary-weighted step sizes F  *      3) make sure all step sizes go through binary_weighted_steps()  */    #include <stdio.h> #include <math.h>    #include "simconst.h"  #include "simstruct.h" #include "mstruct.h" #include "simmac.h"  #include "simglbdef.h" #include "ipstruct.h"   6 char *modes[] = { "null","INIT_INTEGR","FINAL_INTEGR",3 		"FINISHED_INIT_INTEGR","FINISHED_FINAL_INTEGR" };    /*&  * Macro defines for simple functions.  */   , #define	MAX(x,y)	( ((x) > (y)) ? (x) : (y) ), #define	MIN(x,y)	( ((x) < (y)) ? (x) : (y) )+ #define	ABS(x)		( ((x) < 0)   ?-(x) : (x) )   5 extern	double		mindvsched; /* 1mv, should be param */ 9 extern	double		mindvnorm;  /* norm. to 1ns in RLXstart */ ? static  int		maxtraniter	= 10; /* no. of iter before cutting */ ; static  int		itertrancutfactor = 2;  /* factor to cut by */   " extern struct subcircuit *sublist; extern struct timeQ *timequeue; * extern long numnit, numberOfMosModelEvals;! extern struct plotnode *plotlist;  struct plotnode *nplot;   8 static	double		inputVlimit	= 0.5;  /* Should be param */ extern 	double 		cuberoot[];( extern  int		timept1,timept2,newtimept2;= extern  int numTimePoints,numLTERejections,numIterRejections; 4 int 	rejectedTimeStep, rejectionControlMode = FALSE; long ITAcalcstep();  int 	useBE; 2 extern  int ext_input_integr_mode, RollBackTimePt;   struct itapwlsrc {     struct itapwlsrc *next; !     struct subfanout *srcfanouts; &     int nodenum, size, lastloc, dcsrc;#     double *time, *voltage, period;  };  " struct itapwlsrc *sourcelist=NULL;" struct subfanout *getsrcfanouts();   /*=  * ITAstep takes a subcircuit over one integration time step. D  * The timestep used is based on the rate of change of the variables<  * associated with the subcircuit, not on the rate of change;  * of the fastest changing variable in the system, in this    * multirate scheme.  */  ITAstep(subptr) # register struct subcircuit *subptr;  { 2 double a0,a1,a2, alpha0, maxdv, vsum, isum, dtemp; double waveval();  struct timepoint *temp; 2 long ltestep,subtime1,subtime2,newstep,nextTimePt; long temptime, tempstep; long rejtime1,rejtime2;  double *oldq, *predictor, *rhs; 1 struct timepoint *newtime, *present, *old, *old2;  int lsize, i, converg; struct device *devptr;* int mode, isLatent=FALSE, wasLatent=FALSE;  
 if(timesteps) 5 	printf("\n*****SUBCKT #%d***** rank %d (node %s)\n", ) 	subptr->subnum, subptr->node[1]->status, ? 	ip_number_to_name(subptr->waveptrarray[1]->present->nodenum));    /* Assign to locals. */    lsize = subptr->size;    ltestep = subptr->ltestep;   newtime = subptr->newtime;   present = subptr->present;   old = subptr->old;   old2 = subptr->old2;   oldq = subptr->oldstuff;    predictor = subptr->predictor;   rhs = subptr->rhs;   /*  >  * Some definitions are in order here because of the number of(  * variables associated with time steps:  *F  *       subptr->nextALLOWEDstep = the unmodified LTE based step size.E  *       subptr->nextACTUALstep  = the binary-weighted step based on    *				   the above variable.A  *       subptr->ltestep = the step size used for the subcircuit. &  *       ltestep = the step size used.C  *       subptr->node[i]->ltestep = the step size node i is taking. G  *       subptr->node[i]->nextltestep = the step size node i will take. K  *       timept1,timept2 = defines the time slot actively being integrated. J  *       subtime1,subtime2 = defines the subcircuit present and new times.A  *       rejtime1,rejtime2 = internal timepoints during rejection   */   ? /* Make first two steps some fraction of the user plot step. */ G   if ((timept1 == 0 || timept1 == ltestep) && (variableStep == TRUE)) { B      ltestep = subptr->nextACTUALstep = subptr->nextALLOWEDstep =  							subptr->ltestep; O /* node[i]->(next)ltestep have to be loaded up here for use in ITAcalcstep() */ G      for(i=1; i <= lsize ; i++) subptr->node[i]->nextltestep = ltestep; C      for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;    } = /* first use Backward-Euler and then switch to Trapezoidal */ !   if( timept1 == 0) useBE = TRUE;    else useBE = FALSE;   ! /* get internal notion of time */ #   subtime1 = subptr->present->time; #   subtime2 = subptr->newtime->time;   4 /* what is the maximum we can expect to rollback? */1   RollBackTimePt = MIN(RollBackTimePt, subtime1);   
 if(timesteps) ? 	printf("tpt1=%g tpt2=%g ntpt2=%g subt1=%g subt2=%g step=%g\n", P   timept1*mrt,timept2*mrt,newtimept2*mrt,subtime1*mrt,subtime2*mrt,ltestep*mrt);  J /* case 0: LATENCY, if allowed time step is large, subcircuit is latent */+   if(subptr->nextALLOWEDstep == stoptime) { <       /* if schednow is 0, it is FALSE but if it is non-zero=        * it should be interpreted as the time that subcircuit @        * should roll back to. (What do you want, good grammar or        * good code?)	        */ F      if(subptr->schednow != FALSE) { /* wakeup call from some fanin */@ 	if(subptr->schednow < timept1) { /* Hmmm... It's BACKUP time */ 	   goto backup; 	} 	else { < 	   if(timesteps) printf(" Processing latent subcircuit\n"); 	   subptr->schednow = FALSE; E 	   /* base new time step on situation when subcircuit went latent */ < 	   if(timept2 == subtime2) { /* then it just went latent */ 		mode = FINAL_INTEGR; 		goto process;  	   } = 	   else if(timept1 == subtime1) { /* went latent recently */  		mode = INIT_INTEGR;  	        goto process;   	   } < 	   else if (subtime2 <= timept1) { /* latent for a while */ 	      mode = FINAL_INTEGR; = 	      /* new step size should be based on fanin step size */ ,   	      for(i=subptr->external; i<0; i++) {D     	         subptr->nextALLOWEDstep = MIN(subptr->nextALLOWEDstep,; 		  waveFaninStep(subptr->waveptrarray[i]->present,timept1,  			subptr->node[1]->status));  	      }= 	      subptr->nextALLOWEDstep = MIN(subptr->nextALLOWEDstep,  				   stoptime - timept1); $     	      subptr->nextACTUALstep = 1 			srcsteplimit(timept1,subptr->nextALLOWEDstep); B     	      for(i=1; i <= lsize ; i++) subptr->node[i]->nextltestep'     	      			= subptr->nextACTUALstep; ? 	      goto preprocess; /* first time processed in this slot */  	   } < 	   else if ((subtime1 < timept1) && (subtime2 > timept1)) {< 		if(subtime2 < timept2) { /* >>> this should not be true */7 			printf("assertion failed! newitastep.c latency.\n");  			exit(0); 9 			/* >>> in fact, the check should be against timept2 */  		}  		mode = INIT_INTEGR; 7 	        subptr->nextALLOWEDstep = subtime2 - subtime1;  	        goto process;   	   } 
 	   else {C 	      printf("FATAL, condition not handled in case 0: latency\n"); F     	      printf(" timept1=%g timept2=%g\n",timept1*mrt,timept2*mrt);J     	      printf(" subtime1=%g subtime2=%g\n",subtime1*mrt,subtime2*mrt);     	      exit(0);  	   }  	}       }        else {8 	 if(timesteps) printf(" Skipping latent subcircuit\n");I 	 if(newtime->time > timept2) newtimept2 = MIN(newtimept2,newtime->time);  	 return(TRUE);        }    }    backup: I /* Check to see if any fanin subcircuit wants to set this subcircuit into H  * rejection control mode by checking the time given in subptr->schednow  */ "  if((subptr->schednow != FALSE) &&< 	(subptr->schednow < timept1)) { /* Yup! It's BACKUP time */>    /* Steps: (1) roll back the solution to the suggested pointA     *        (2) set up present timepoint data structure with all A     *            required info and other two with nodevolt[] info A     *        (3) set rejtime1, and subptr->present->time, ltestep <     *        (4) figure out something about integration modeE     *        (5) compare new waveform piece to old one for scheduling      */C     if(timesteps) printf("backup time: %g\n",subptr->schednow*mrt);       rejectionControlMode = TRUE;      rejtime1 = subptr->schednow;.    /* Figure out how far back we need to go */F    /* If any of the existing time point info are useful, we don't need@     * to do an rhsload().  If the rejection point is beyond old2.     * then we'll have to regenerate timepoints     */A     mode = FINAL_INTEGR; /* set it up like a final integration */ #     if(newtime->time <= rejtime1) {        /* LATENCY CASE: */ , 	printf("Untested latency rollback code\n");$ 	ltestep = rejtime1 - newtime->time;4 	if(ltestep <= 0) ltestep = timept1 - newtime->time;4 	subptr->ltestep = subptr->nextACTUALstep = ltestep;? 	for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;  	temp = subptr->old2;  	subptr->old2 = subptr->old;  	subptr->old = subptr->present; # 	subptr->present = subptr->newtime;  	subptr->newtime = temp;9 	subptr->newtime->time = subptr->present->time + ltestep;  	/* Bump the offset. */  	(subptr->offset)++; #ifdef NODE_INFO! 	printf("Node %s pt. %d %g %g\n", B 	    ip_number_to_name(subptr->waveptrarray[1]->present->nodenum),D 	    subptr->offset,newtime->time*mrt,subptr->newtime->nodevolt[1]); #endif5 	/* if no. of pts. is close to window size, then dump 2 	 * plot values into output waveform buffer.  Then# 	 * reset offset location back to 0  	 */# 	if(subptr->offset == (maxpts-2)) {  	  saveplot();: 	  subptr->offset = storewave(subptr->present, 0, subptr);6 	  storewave(subptr->newtime, subptr->offset, subptr); 	}     } A     else if(present->time <= rejtime1) { /* Case 1: good shape */  	ltestep = stoptime;&   	for(i=subptr->external; i<0; i++) {F 	  tempstep = waveFaninStep(subptr->waveptrarray[i]->present,rejtime1, 			subptr->node[1]->status);$ 	  ltestep = MIN(tempstep, ltestep); 	}? 	subptr->ltestep = MIN(timept1-subptr->present->time, ltestep); ;         ltestep = subptr->nextACTUALstep = subptr->ltestep; F         for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;@         subptr->newtime->time = subptr->present->time + ltestep;     } N     else if(old->time <= rejtime1) { /* Case 2: must regenerate 1 timepoint */)       nextTimePt = subptr->present->time;        temp = subptr->present; $       subptr->present = subptr->old;!       subptr->old = subptr->old2;        subptr->old2 = temp;1       /* go off and set up nodevolt[] for old2 */ :       itatimept(subptr, subptr->old2, subptr->old->time );=       subptr->ltestep = (nextTimePt-subptr->present->time)/2; 9       ltestep = subptr->nextACTUALstep = subptr->ltestep; D       for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;>       subptr->newtime->time = subptr->present->time + ltestep;     } P     else if(old2->time <= rejtime1) { /* Case 3: must regenerate 2 timepoints */%       nextTimePt = subptr->old->time;        temp = subptr->present; %       subptr->present = subptr->old2;        subptr->old2 = temp;1       /* go off and set up nodevolt[] for old2 */ =       itatimept(subptr, subptr->old, subptr->present->time ); :       itatimept(subptr, subptr->old2, subptr->old->time );;       subptr->ltestep = nextTimePt - subptr->present->time; 9       ltestep = subptr->nextACTUALstep = subptr->ltestep; D       for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;>       subptr->newtime->time = subptr->present->time + ltestep;     } K     else { /* Case 4: regenerate all timepoints, rhsload subptr->present */ 1       printf("Untested rhsload rollback code\n"); 4       itatimept(subptr, subptr->present, rejtime1 );=       itatimept(subptr, subptr->old, subptr->present->time ); :       itatimept(subptr, subptr->old2, subptr->old->time );-       /* Evaluate the charge and currents. */ '       for(i=subptr->external; i<0; i++)          present->nodevolt[i] =  > 	    waveval(subptr->waveptrarray[i]->present, present->time);B       rhsload(subptr->present->nodevolt, subptr->present->charge, $ 		subptr->present->current, subptr);E       /* What step should be used? How about using waveFaninStep() */  	ltestep = stoptime;&   	for(i=subptr->external; i<0; i++) {F 	  tempstep = waveFaninStep(subptr->waveptrarray[i]->present,rejtime1, 			subptr->node[1]->status);$ 	  ltestep = MIN(tempstep, ltestep); 	}? 	subptr->ltestep = MIN(timept1-subptr->present->time, ltestep); 9       ltestep = subptr->nextACTUALstep = subptr->ltestep; D       for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;>       subptr->newtime->time = subptr->present->time + ltestep;     } %     rejtime1 = subptr->present->time; %     rejtime2 = subptr->newtime->time; -     waveSetupPrev(subptr,subptr->old2->time);      goto rejection_restart;     }  N /* check if all finished. >>> maybe I should enforce a final integ. for all */&   if((subptr->nextACTUALstep == 0) && 1 	(subptr->integmode == FINISHED_FINAL_INTEGR )) {        if (subtime2 == stoptime) {8 	if(timesteps) printf("All done for this simulation\n"); 	return(TRUE);      }      else { B 	printf("FATAL, nextACTUALstep = 0, probably due to checksrc!\n");	 	exit(0);       }   }   9 /* Compare subtimes with external timepoint edges timepts ,  *   case 1 : set up for initial integration5  *   case 2 : continue with initial/final integration :  *   case 3 : process for final integration (if necessary)'  *   case 4 : skip the integration step   *   case 5 : error condition   */ C   if ((subtime1 < timept1) && (subtime2 == timept1)) { /* case 1 */  	mode = INIT_INTEGR;D 	if(timesteps) printf(" Setting up for initial integration step\n");, 	goto preprocess; /* set up for next step */   } I   else if ((subtime1 == timept1) && (subtime2 >= timept2)) { /* case 2 */ < 	if((subptr->convergedAtT) && (subptr->schednow == FALSE)) {F 	   if(timesteps) printf(" Already converged to initial solution.\n");I 	 if(newtime->time > timept2) newtimept2 = MIN(newtimept2,newtime->time);  	   return(TRUE);  	}- 	if(subtime2 == timept2) mode = FINAL_INTEGR;  	else mode = INIT_INTEGR; E 	if(timesteps) printf(" Continuing with initial integration step\n"); A 	goto process; /* go and process for initial/final integration */    } H   else if ((subtime1 < timept1) && (subtime2 == timept2)) { /* case 3 */< 	if((subptr->convergedAtT) && (subptr->schednow == FALSE)) {D 	   if(timesteps) printf(" Already converged to final solution.\n");I 	 if(newtime->time > timept2) newtimept2 = MIN(newtimept2,newtime->time);  	   return(TRUE);  	}D 	/* only do final integr. if some extrap. is used in init. integr */2 	if(subptr->integmode == FINISHED_FINAL_INTEGR) {  	   subptr->schednow = FALSE;  	   if(timesteps) B 		printf(" Already generated final soln. skipping integration\n");I 	 if(newtime->time > timept2) newtimept2 = MIN(newtimept2,newtime->time);  	   return(TRUE);  	} 	else {  	   mode = FINAL_INTEGR;F 	   if(timesteps) printf(" Continuing with final integration step\n");A 	   goto process; /* go ahead an process for final integration */  	}   } G   else if ((subtime1 < timept1) && (subtime2 > timept2)) { /* case 4 */ ' 	newtimept2 = MIN(newtimept2,subtime2);  	if(timesteps) {I 	   printf(" Setting newtimept2 to %g (%d)\n",newtimept2*mrt,newtimept2); = 	   printf(" Skipping integration step in this time slot\n");  	}  	/* subptr->schednow = FALSE; */ 	return(TRUE);   }    else { /* case 5 */ / 	printf( "FATAL: Error in timepoint edges!\n"); % 	printf("subckt %d ",subptr->subnum); ?   	printf(" >>timept1=%g timept2=%g subtime1=%g subtime2=%g\n", 7 	   timept1*mrt,timept2*mrt,subtime1*mrt,subtime2*mrt); ?   	printf(" >>timept1=%d timept2=%d subtime1=%d subtime2=%d\n", ' 	   timept1,timept2,subtime1,subtime2); 	 	exit(0);    }    preprocess: I   /* Preprocess subcircuit so that it is ready for next integration step.     * This involves: B    *    case 1: rotating the 4 time points and setting newtime for,    *       previously active subcircuits, orE    *    case 2: rotating twice, throwing in a dummy point and setting 4    *       newtime for previously latent subcircuits    */    numTimePoints++;=   if(timept1 == 0 || timept1 == newtime->time) { /* case 1 */  #ifdef NODE_INFO$     printf("Node %s pt. %d %g %g\n",> 	ip_number_to_name(subptr->waveptrarray[1]->present->nodenum),@ 	subptr->offset,newtime->time*mrt,subptr->newtime->nodevolt[1]); #endif:     for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = " 					subptr->node[i]->nextltestep;7     ltestep = subptr->ltestep = subptr->nextACTUALstep;      temp = subptr->old2;     subptr->old2 = subptr->old; #     subptr->old = subptr->present;  &     subptr->present = subptr->newtime;     subptr->newtime = temp; <     subptr->newtime->time = subptr->present->time + ltestep;     /* Bump the offset. */     (subptr->offset)++; 8     /* if no. of pts. is close to window size, then dump5      * plot values into output waveform buffer.  Then &      * reset offset location back to 0      */ &     if(subptr->offset == (maxpts-2)) {       saveplot(); =       subptr->offset = storewave(subptr->present, 0, subptr); 9       storewave(subptr->newtime, subptr->offset, subptr);      }    } 3   else if (timept1 > newtime->time) {  /* case 2 */  #ifdef NODE_INFO$     printf("Node %s pt. %d %g %g\n",> 	ip_number_to_name(subptr->waveptrarray[1]->present->nodenum),@ 	subptr->offset,newtime->time*mrt,subptr->newtime->nodevolt[1]); #endifE 	if(timesteps) printf("timepoint rotation for latent subcircuit.\n"); 8     	ltestep = subptr->ltestep = subptr->nextACTUALstep;F         for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep; 	subptr->processedAtT = TRUE;  	subptr->iter = 0; 	wasLatent = TRUE;   	/* 1st rotation */          temp = subptr->old2;#         subptr->old2 = subptr->old; '         subptr->old = subptr->present;  *         subptr->present = subptr->newtime;         subptr->newtime = temp;    	/* 2nd rotation */          temp = subptr->old2;#         subptr->old2 = subptr->old; '         subptr->old = subptr->present;  *         subptr->present = subptr->newtime;         subptr->newtime = temp;   ; 	/* copy buffer and place extra point in waveform buffer */ H 	copytimept(subptr->old, subptr->present,subptr->size,subptr->external);7 	subptr->present->time = timept1; /* extra timepoint */ C 	subptr->newtime->time = timept1 + ltestep; /* current timepoint */          (subptr->offset)++; ;         storewave(subptr->present, subptr->offset, subptr);   2 	/* when plotting, set the time value then plot */         (subptr->offset)++; *         if(subptr->offset >= (maxpts-2)) {           saveplot(); A           subptr->offset = storewave(subptr->present, 0, subptr); =           storewave(subptr->newtime, subptr->offset, subptr); 	         }    }    else {6     printf( "FATAL, buffer rotation: internal error");H     printf(" time=%d ltestep=%d newtime=%d present=%d old=%d old2=%d\n",' 	newtime->time, ltestep, newtime->time, ? 	subptr->present->time, subptr->old->time, subptr->old2->time); H     printf(" time=%g ltestep=%g newtime=%g present=%g old=%g old2=%g\n",3 	newtime->time*mrt, ltestep*mrt, newtime->time*mrt, 3 	subptr->present->time*mrt, subptr->old->time*mrt,   	subptr->old2->time*mrt); ?     printf(" timept1=%g timept2=%g\n",timept1*mrt,timept2*mrt);      exit(0);   } K   /* after preprocessing, this integration may be classified as final... */ ;   if(subptr->newtime->time == timept2) mode = FINAL_INTEGR;    rejection_restart:B   /* if a rejection occurs, come back here and set up the variableA    * names and re-try integration step. For now, try to cover the 3    * same time slot that the original step covered.     */    subptr->convergedAtT = FALSE;    subptr->schednow = FALSE;    subptr->iter = 0;    newtime = subptr->newtime;   present = subptr->present;   old = subptr->old;   old2 = subptr->old2;   ltestep = subptr->ltestep;  4   /* if the subcircuit is in rejection control mode,6    * and if it catches up to the integration time slot+    * then get out of rejection control mode     */ <   if((rejectionControlMode) && (timept1 == present->time)) { 	rejectionControlMode = FALSE;   }    process:&   /* Steps in processing a subcircuit:%    *   1. Determine integration order C    *   2. Get external voltages (check to see if integmode changes) 3    *   3. Set up predictor value if first iteration &    *   4. Perform the Newton iteration    *   5. Check for convergence D    *   6. Check for solution accuracy; reject solution if necessary.    */    converg = TRUE;    subptr->iter++;    numnit++;    wasLatent = FALSE;<   if(timesteps) printf("Time %g iteration %d timestep %g\n",4      			newtime->time*mrt,subptr->iter,ltestep*mrt);  2   if((newtime->time - present->time) != ltestep) {A 	printf("Inconsistency check failed in newitastep.c\n"); exit(0);    }    /* Step 1 */M   if( useBE ) alpha0 = 1/(ltestep * mrt);   /* Compute the alpha0 for B.E. */ N   else alpha0 = 2/(ltestep * mrt);   /* Compute the alpha0 for trapezoidal. */  3 /* Step 2 : Get the input voltages at this time. */ N   ext_input_integr_mode = FINAL_INTEGR; /* assume and let waveval change it */%   for(i=subptr->external; i<0; i++) {      newtime->nodevolt[i] =  : 	waveval(subptr->waveptrarray[i]->present, newtime->time);     if(timesteps) { 0        printf(" External net %d has value %g\n",D 	  subptr->waveptrarray[i]->present->nodenum, newtime->nodevolt[i]);     }    }    /*  C    * If the external inputs are either sources or the waveforms are A    * interpolated then this is a final integration by definition  N    * (as long as the step size does not exceed the value of any of the inputs)    * This is done in waveval(). G    * External inputs can set an INIT_INTEGR mode to a FINAL_INTEGR mode     * but not vice-versa.    */ D   if(mode == INIT_INTEGR) subptr->integmode = ext_input_integr_mode;    else subptr->integmode = mode;K   if(timesteps) printf("integration_mode = %s\n",modes[subptr->integmode]);    /* Step 3 */K /* If this is iter 1, get predictor and evalute old stuff for trap rule. */    if(subptr->iter == 1) {      for(i=1; i <= lsize; i++) {        if ( useBE ) {3          oldq[i] = - (alpha0 * present->charge[i]); 8          if ( wasLatent == TRUE ) {  /* don't predict */. 		newtime->nodevolt[i] = present->nodevolt[i]; 	 }  	 else {I          	a0 = present->nodevolt[i];     /* Generate a poly predictor. */ C          	a1 = (a0 - old->nodevolt[i])/(present->time - old->time); 8          	newtime->nodevolt[i] = present->nodevolt[i] + ) 				a1 * (newtime->time - present->time);  	 } -          predictor[i] = newtime->nodevolt[i];        }        else {  /* trap */G          oldq[i] = present->current[i] - (alpha0 * present->charge[i]); 8          if ( wasLatent == TRUE ) {  /* don't predict */. 		newtime->nodevolt[i] = present->nodevolt[i]; 	 }  	 else {I          	a0 = present->nodevolt[i];     /* Generate a poly predictor. */ C          	a1 = (a0 - old->nodevolt[i])/(present->time - old->time);           	a2 = (   	     	(a1 -E           	(  (a0 - old2->nodevolt[i])/(present->time - old2->time) )                     	) +              	/ (old->time - old2->time) ); &          	newtime->nodevolt[i] = a0 + * 			( ((a2*(newtime->time - old->time))+a1)( 			* (newtime->time - present->time)  ); 	 } -          predictor[i] = newtime->nodevolt[i];        }       }   }   3 /* Recompute Jacobian every newjacobth iteration */ 0   numberOfMosModelEvals += subptr->nummosmodels; /* Step 4 */   if (subptr->iter == 1) {F       /* Compute the charge, crnt, and jacobian for the subcircuit. */P       loadall(alpha0,newtime->nodevolt,newtime->charge,newtime->current,subptr);!       /* Decompose the matrix. */        ludecompose(subptr);   }    else {-       if(((subptr->iter-1) % newjacob) != 0)  M          rhsload(newtime->nodevolt,newtime->charge,newtime->current,subptr);         else {:          loadall(alpha0,newtime->nodevolt,newtime->charge, 					newtime->current,subptr);          ludecompose(subptr);        }    }   ! /* Compute the newton residue. */ #   for(i=1; i<=lsize; i++) rhs[i] =  > 		(alpha0*newtime->charge[i]) + oldq[i] + newtime->current[i];- /* Perform Matrix solution to get delta v. */    lusol(rhs,subptr);   /* Compute max delta v. */K   for(maxdv = 0.0 , i=1; i <= lsize; i++) maxdv = max(maxdv, dabs(rhs[i])); L /* Limit newton delta v to nralpha,  BUT do not corrupt newton direction. */L   if(maxdv > nralpha) for(i=1; i <= lsize; i++) rhs[i] *= (nralpha / maxdv);I /* Get an average node voltage and add delta v to node voltage vector. */ (   for(vsum=0.0 , i=1; i <= lsize; i++) {E 	newtime->nodevolt[i] -= rhs[i]; vsum += dabs(newtime->nodevolt[i]);  + 	if(timesteps) printf(" nodevolt[%s]=%g\n", A 	   ip_number_to_name(subptr->waveptrarray[i]->present->nodenum),  	   newtime->nodevolt[i]);   }    vsum /= lsize;! /* Step 5 : Check convergence. */ ;   if( maxdv > (nrvabs + (nrvrel * vsum)) ) converg = FALSE; @   else { /* If voltage converged, evaluate and check current. */H     rhsload(newtime->nodevolt,newtime->charge,newtime->current,subptr);      for(i=1; i <= lsize; i++) { ,       dtemp = (alpha0 * newtime->charge[i]);5       rhs[i] = dtemp + oldq[i] + newtime->current[i]; E       isum = dabs(dtemp) + dabs(oldq[i]) + dabs(newtime->current[i]); D       if(dabs(rhs[i]) > ((nrcrel * isum) + nrcabs)) converg = FALSE;     }    } .   if (converg == TRUE) {  /* converged case */)     if(timesteps) printf(" CONVERGED\n"); %     subptr->integmode += INTEGR_DONE;      rejectedTimeStep = FALSE; D     if (!subptr->convergedAtT ) { /* converged for the first time */# 	scheduleSelf(subptr); /* at T */   & 	scheduleFanouts(subptr); /* at T */       }      subptr->schednow = FALSE;    /* Step 6 : Check accuracy */ %        newstep = ITAcalcstep(subptr); ;        if(rejectedTimeStep == FALSE)  /* limit last step */ =            newstep = MIN( newstep, stoptime - newtime->time);   )     /* Check and handle rejection here */ G     /* Algorithm: - when a rejection occurs, if it is on initial integ. D      *              then cut the step size based on the LTE and then,      *              redo with a smaller stepD      *            - for final integration, cut step based on LTE andK      *              take as many steps as necessary to catch up to timept2. N      *            - for all timepoints earlier than timept1, a comparison willE      *              be necessary to determine where the other fanouts 1      *              must rejected their solutions       */   E     /* Hit all breakpoints and reduce step size if at a breakpoint */   >     if (rejectedTimeStep) { /* solution not accurate enough */ 	if(timesteps) {: 	   printf("@%d %g %g\n",subptr->subnum,present->time*mrt, 							present->nodevolt[1]); ) 	   printf("*****LTE REJECTION******\n");  	} 	subptr->convergedAtT = FALSE;3     	/* newstep = srcsteplimit(timept1,newstep); */ 0 	/* >>> note that checksrc should only limit for2 	 * external nodes which are connected to sources. 	 */) 	newtime->time = present->time + newstep; F         for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = newstep;J         for(i=1; i <= lsize ; i++) subptr->node[i]->nextltestep = newstep; 	subptr->ltestep = newstep; " 	subptr->nextACTUALstep = newstep;# 	subptr->nextALLOWEDstep = newstep;  	numLTERejections++;     } ,     else {  /* accurate solution obtained */ 	subptr->convergedAtT = TRUE;  	if((rejectionControlMode) || F 	     (subptr->nextALLOWEDstep != stoptime))  /* i.e. if not latent */+         	subptr->nextALLOWEDstep = newstep;  	/* if not 1st or last time */5 	if(present->time != 0 && newtime->time != stoptime)  B 	   newstep = srcsteplimit(newtime->time,subptr->nextALLOWEDstep);)         subptr->nextACTUALstep = newstep; > 	/* if allowed not same as actual, then bp's caused small step+ 	 *   so make node ltestep same as newstep.  	 */8 	if(subptr->nextALLOWEDstep != subptr->nextACTUALstep) {D 	  if(subptr->nextALLOWEDstep != stoptime)  /* i.e. if not latent */C 	    for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = newstep;  	}     } C     if(timesteps) printf(" allowed step = %g , actual step = %g\n", : 	subptr->nextALLOWEDstep*mrt, subptr->nextACTUALstep*mrt);   } #   else {  /* nonconvergence case */ !     subptr->convergedAtT = FALSE; 0     if(timesteps) printf(" DID NOT CONVERGE\n");?       if (variableStep == TRUE && subptr->iter > maxtraniter) {  	if(timesteps) {- 	   printf("*****ITERCNT REJECTION******\n"); ( 	   printf("#%d %g %g\n",subptr->subnum,* 		present->time*mrt,present->nodevolt[1]); 	}*   	if(subptr->integmode == FINAL_INTEGR) {: 	   /* Note: on final integration rejection, it is best to9 	    * try to line up with timept1 so that this subsystem . 	    * can get back into sync. with the others 	    */ A   	   if((present->time < timept1) && (newtime->time == timept2)) 6   		ltestep = MIN(ltestep/2, timept1 - present->time);!   	   else ltestep = ltestep / 2;    	}   	else ltestep = ltestep / 2;*         subptr->nextALLOWEDstep = ltestep;F         for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = ltestep;3     	ltestep = srcsteplimit(present->time,ltestep); "         subptr->ltestep = ltestep;) 	newtime->time = present->time + ltestep;  	/* time = time + ltestep; */ ! 	if (ltestep == 1)  { /* oops! */ B 	   printf( "FATAL, Internal Timestep too small: %g at time %g\n",=     		 (double) ltestep * mrt, (double) newtime->time * mrt);  		 exit(0);  	} 	rejectedTimeStep = TRUE;  	numIterRejections++;  	subptr->iter = 1;       } '       subptr->nextACTUALstep = ltestep; O       /* if((!rejectionControlMode) && (((subptr->iter-1) % newjacob) != 0)) */        if(!rejectionControlMode)        	scheduleFanouts(subptr);    }    if (rejectedTimeStep) {  	rejectedTimeStep = FALSE;* 	if((subptr->integmode == FINAL_INTEGR) ||1 		(subptr->integmode == FINISHED_FINAL_INTEGR)) { ! 	  if (present->time < timept1) {  	    if(timesteps)D 	      printf(" Subckt %d Going in REJECTION CONTROL MODE at %g.\n", 		subptr->subnum,timept1*mrt);! 	    rejectionControlMode = TRUE; 2     	    waveSetupPrev(subptr,subptr->old2->time); 	    rejtime1 = present->time;= 	    newtime->time = rejtime2 = MIN(newtime->time, timept1);; + 	    subptr->ltestep = rejtime2 - rejtime1;  	  }8 	  else if (present->time > timept1) { /* gone to far */B 	     printf(" Leading edge of time step is inside time slot.\n");4 	     printf(" present->time =  %g, timept1 = %g\n"," 		present->time*mrt, timept1*mrt); 	     exit(0); 	  } 	} 	else ! 	   rejectionControlMode = FALSE;  	goto rejection_restart;   } !   else if(rejectionControlMode) { 2     if((rejtime1 == present->time) && (converg)) { #ifdef NODE_INFO$     printf("Node %s pt. %d %g %g\n",> 	ip_number_to_name(subptr->waveptrarray[1]->present->nodenum),@ 	subptr->offset,newtime->time*mrt,subptr->newtime->nodevolt[1]); #endifE 	subptr->offset = storewave(subptr->newtime, subptr->offset, subptr);  	if(rejtime2 < timept1) I 	  subptr->nextACTUALstep = MIN(timept1-rejtime2,subptr->nextACTUALstep); 4 	ltestep = subptr->ltestep = subptr->nextACTUALstep;>         for(i=1; i <= lsize ; i++) subptr->node[i]->ltestep = (         			subptr->node[i]->nextltestep; 	temp = subptr->old2;  	subptr->old2 = subptr->old;  	subptr->old = subptr->present; # 	subptr->present = subptr->newtime;  	subptr->newtime = temp;9 	subptr->newtime->time = subptr->present->time + ltestep; " 	rejtime1 = subptr->present->time;" 	rejtime2 = subptr->newtime->time;A 	if(timesteps) printf("rejtime1 = %g rejtime2=%g\n",rejtime1*mrt,  			rejtime2*mrt);  	/* Bump the offset. */ 5 	/* if no. of pts. is close to window size, then dump 2 	 * plot values into output waveform buffer.  Then# 	 * reset offset location back to 0  	 */# 	if(subptr->offset == (maxpts-2)) {  	  saveplot();: 	  subptr->offset = storewave(subptr->present, 0, subptr);6 	  storewave(subptr->newtime, subptr->offset, subptr); 	}         goto rejection_restart;      } 
     else { 	goto process;     }    } A   if(timept2 > newtime->time) {  /* 2nd timepoint edge too far */  	newtimept2 = timept2; 	timept2 = newtime->time;    } 8   /* update next timept2 edge if subcircuit converged */   if(converg) {      subptr->iter = 1;      if(timesteps) P     printf("Setting newtimept2 with integmode = %s\n",modes[subptr->integmode]);5      /* >>> other places where newtimept2 can be set: B       *  1) after rejection, some subcircuits may stop integrating=       *      and their subtime2 should be the next newtimept2 .       *  2) possibly when skipping integration       */*      if(subptr->integmode == INIT_INTEGR) , 	newtimept2 = MIN(newtimept2,newtime->time);      else { < 	/* could be final integration with step > time slot size */H 	if(newtime->time > timept2) newtimept2 = MIN(newtimept2,newtime->time);E 	newtimept2 = MIN(newtimept2,newtime->time + subptr->nextACTUALstep);       }   } J   if(timesteps) printf(" newtimept2=%g (%d)\n",newtimept2*mrt,newtimept2);5   storewave(subptr->newtime, subptr->offset, subptr);    return(converg); }   = /* This routine calculates the next step for all nodes in the C  * subcircuit and returns the smallest of the bunch as the required   * step for the subcircuit  */  long ITAcalcstep(subptr) struct subcircuit *subptr; {  int i; double maxvolt,verr, temp;1 struct timepoint *present, *newtime, *old, *old2;  double *predictor; double lteratio;4 long tempstep, smallestStep, binary_weighted_step();
 int lsize; long prevstep;     verr = 0.0; lteratio = 10.0;   lsize = subptr->size;    newtime = subptr->newtime;   present = subptr->present;   old = subptr->old;   old2 = subptr->old2;    predictor = subptr->predictor;2   smallestStep = stoptime; /* some large number */   maxvolt = 5.0;M   for(i=1; i <= lsize ; i++) { maxvolt = MAX(newtime->nodevolt[i],maxvolt); }    for(i=1; i <= lsize ; i++) {0     temp = 0.33 * ( (dabs(newtime->nodevolt[i]))A 	    + (dabs(present->nodevolt[i])) + (dabs(old->nodevolt[i])) ); 5     temp = dabs(newtime->nodevolt[i] - predictor[i]);      verr = max(temp, verr);      if(verr > FUZZ) { 9       if(useBE) { /* 1st order integration trunc error */ G     	temp = ((lterel*maxvolt + lteabs) * (newtime->time - old->time)) / . 	   	(verr * (newtime->time - present->time));       }        else {F   	/* 2nd order integration trunc error, with factor of 2 for trap. */L     	temp = ((lterel*maxvolt + lteabs) * (newtime->time - old2->time) * 2.0)7            	/ (verr * (newtime->time - present->time));        } #       temp = MIN(temp, step3ratio); *       temp = MAX(temp, 1.0/downstepratio);     }      else temp = step3ratio;      lteratio = temp;!     if( variableStep == FALSE ) { < 	subptr->node[i]->ltestep = maxstep;  /* just use maxstep */( 	subptr->node[i]->nextltestep = maxstep;     } .     else {  /* LTE and ITER controlled step */J        /* First check on the local truncation error predicted timestep. */+        if(useBE) lteratio = sqrt(lteratio); <        else lteratio = cuberoot[ (int) (100.0 * lteratio) ];+        prevstep = subptr->node[i]->ltestep; =        if(lteratio < 1.0) { /* Reduce timestep due to lte. */ 2 	    /* tempstep = (0.7 * lteratio) * prevstep; */' 	    /* Bound reduction of timestep. */  	    tempstep = prevstep/2; 6 	    tempstep = max(tempstep, prevstep/downstepratio); 	    rejectedTimeStep = TRUE;  	    if(timesteps)2 	    printf("Rejection: prevstep=%g newstep=%g\n", 		mrt*prevstep, mrt*tempstep);        }1        else { /* Increase timestep due to lte. */ = 	    tempstep = prevstep + 0.9 * prevstep * (lteratio - 1.1);         }3        /* Bound timestep by maxstep and minstep. */ )        tempstep = MAX(tempstep, minstep);         if(timesteps)6        printf("ITAcalclte: prevstep=%g tempstep=%g\n", 		prevstep*mrt, tempstep*mrt);1        smallestStep = MIN(tempstep,smallestStep); /        subptr->node[i]->nextltestep = tempstep;      }    } /   return(binary_weighted_step((smallestStep)));  }    long binary_weighted_step(Step) 
 long Step; {  int i;7   /* search for the correct binary weighted timestep */ I   /* check the equivalent of 1ns and then search up or down from there */ =   if(Step == timequeue[NUMOFSTEPS/2].timestep) /* found it */ 1 	return(Step = timequeue[NUMOFSTEPS/2].timestep); D   else if(Step > timequeue[NUMOFSTEPS/2].timestep) { /* search up */. 	for(i=NUMOFSTEPS/2+1; i<=NUMOFSTEPS-1; i++) {&   	   if(Step > timequeue[i].timestep) 		continue; + 	   return(Step = timequeue[i-1].timestep);  	} 	return(stoptime);     }    else { /* search down */" 	for(i=NUMOFSTEPS/2-1; i>0; i--) {&   	   if(Step < timequeue[i].timestep) 		continue; ) 	   return(Step = timequeue[i].timestep);  	}2 	printf( "FATAL: Internal timestep too small!\n");	 	exit(0);    }  }      scheduleSelf (subptr)  struct subcircuit *subptr; {  double oldval, newval, mindv;  int i;
 long step;      step = subptr->ltestep;-    /* mindv check if timestep large enough */ ,    /* if (step <= maxstep/10 )  mindv = 0.0;1    else if (step >= maxstep ) mindv = mindvsched; $    else mindv = mindvnorm * step; */,    if (step >= maxstep ) mindv = mindvsched;!    else mindv = mindvnorm * step;   =    for(i=1; i<=subptr->size ; i++) { /* each internal node */ ' 	oldval = subptr->present->nodevolt[i]; ' 	newval = subptr->newtime->nodevolt[i]; E 	if (dabs(newval - oldval) >= mindv) /* not always scheduling self */ : 		return;  /* only one node has to change to reschedule */    }7    /* if(subptr->integmode == FINISHED_FINAL_INTEGR) */ '    	subptr->nextALLOWEDstep = stoptime;  }    scheduleFanouts(subptr)  struct subcircuit *subptr; {  double oldval, newval, mindv;  struct subfanout *nextfan; long step, wavetime; int i;      step = subptr->ltestep;-    /* mindv check if timestep large enough */ -    /* if (step <= maxstep/100 )  mindv = 0.0; 1    else if (step >= maxstep ) mindv = mindvsched; $    else mindv = mindvnorm * step; */,    if (step >= maxstep ) mindv = mindvsched;!    else mindv = mindvnorm * step;   =    for(i=1; i<=subptr->size ; i++) { /* each internal node */ 2     if ( subptr->nodefanlist[i] == NULL) continue;
     else {D       if(rejectionControlMode) { /* check prev and pres waveforms */+           wavetime = subptr->newtime->time; F           oldval = waveval(subptr->waveptrarray[i]->present,wavetime);G           newval = waveval(subptr->waveptrarray[i]->previous,wavetime); F 	  /* Use waveform convergence criteria as the scheduling threshold */=           mindv = wavevabs + (wavevrel * MAX(oldval,newval)); *     	  /* printf("Node %s pt. %d %g %g  ",? 		ip_number_to_name(subptr->waveptrarray[i]->present->nodenum), , 		 subptr->offset,subptr->newtime->time*mrt,! 		 subptr->newtime->nodevolt[i]); <           if (dabs(newval - oldval) >= mindv) printf("*\n"); 	  else printf("\n"); */       }        else {, 	/* oldval = subptr->node[i]->lastschedV; */' 	oldval = subptr->present->nodevolt[i]; ' 	newval = subptr->newtime->nodevolt[i];        } +       if (dabs(newval - oldval) >= mindv) { ) 	   subptr->node[i]->lastschedV = newval; 0       	   for(nextfan = subptr->nodefanlist[i]; . 			nextfan != NULL; nextfan = nextfan->next) {, 	      if( nextfan->fansub->schednow != 0) {C     	        nextfan->fansub->schednow = MIN(subptr->newtime->time, )     	        	nextfan->fansub->schednow);  	      }
 	      else { ?     	        nextfan->fansub->schednow = subptr->newtime->time;  	      }G       if(timesteps) printf("schedfanouts: waking up subnum %d at %g\n", D     	      	nextfan->fansub->subnum, nextfan->fansub->schednow*mrt); 		 	   }        }      }    }  }    /*  <  * Check to see if a src breakpoint has been encountered and0  * schedule fanouts if it is a transition period  */   long checksrcs(lastTime,newstep) long lastTime,newstep; {  struct itapwlsrc *nextpwl; struct subfanout *nextfan; struct waveform  *pw;  double deltav; int pos; long instep, bpnm1, bpn, bpnp1;        instep = newstep; $     if(newstep == 0) return(instep);1     if(variableStep == FALSE) {  /* fixed step */ L        for(nextpwl = sourcelist; nextpwl != NULL; nextpwl = nextpwl->next) {,           for(nextfan = nextpwl->srcfanouts;, 			nextfan != NULL; nextfan = nextfan->next)+          	nextfan->fansub->schednow = TRUE;         }        return( instep );     } I     for(nextpwl = sourcelist; nextpwl != NULL; nextpwl = nextpwl->next) { <        if ( nextpwl->srcfanouts == NULL) {}  /* dc supply */
        else { 7        /* Step on the input breakpoint, if required. */ -         pw = waves[nextpwl->nodenum].present;  	pos = pw->lastloc;           bpnm1 = pw->time[pos-1];         bpn = pw->time[pos];          bpnp1 = pw->time[pos+1]; 	if(bpnm1 > lastTime) {  	   if(pos-2 < 0) continue; = 	   bpnp1 = bpn; bpn = bpnm1; bpnm1 = pw->time[pos-2]; pos--;  	} 	if(bpn <= lastTime) {& 	   if(pos+1 > pw->wavesize) continue;+            bpnm1 = bpn; bpn = bpnp1; pos++;  	}:         if((bpnm1 == lastTime) && (pos <= pw->wavesize)) {9 	  /* sitting on a breakpoint, ready to take next step */ 7           if (pw->voltage[pos] != pw->voltage[pos-1]) { >             deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]);@ 	    instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1)));+ 	    instep = binary_weighted_step(instep); ,          	for(nextfan = nextpwl->srcfanouts;. 			nextfan != NULL; nextfan = nextfan->next) {+ 		    nextfan->fansub->schednow = lastTime; I       if(timesteps) printf("checksrc1: waking up subnum %d at time %g\n", D     	      	nextfan->fansub->subnum, nextfan->fansub->schednow*mrt); 		}  	  }	         } B 	else if ((lastTime + newstep) == bpn) { /* hit next breakpoint */7           if (pw->voltage[pos] != pw->voltage[pos-1]) { < 	  /* during the transition region, limit change in input */>             deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]);H 	  /* >>> instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1))); */     	    if(instep <= 0) {  B 		printf("Checksrc1: stepsize <= 0, bpn=%d bpnm1=%g\n",bpn,bpnm1);
 		exit(0); 	    }.             for(nextfan = nextpwl->srcfanouts;. 			nextfan != NULL; nextfan = nextfan->next) {/ 	      /* if( nextfan->fansub->schednow != 0) { 6     	        nextfan->fansub->schednow = MIN(lastTime,)     	        	nextfan->fansub->schednow);  	      } 	      else { */2     	        nextfan->fansub->schednow = lastTime; 	      /* } */I       if(timesteps) printf("checksrc2: waking up subnum %d at time %g\n", D     	      	nextfan->fansub->subnum, nextfan->fansub->schednow*mrt); 	    } 	  }> 	  else /* no difference in voltage so take maxstep allowed */ 		instep = MIN(instep,newstep);  	}' 	else if ((lastTime + newstep) > bpn) { + 	/* stepping over a breakpoint? maybe... */ < 	  if (lastTime <= bpn) { /* already past the breakpoint? */H 	     instep = MIN(instep,bpn - lastTime);  /* yes, so hit breakpoint */:              if (pw->voltage[pos] != pw->voltage[pos-1]) {A                deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]); I 	       /* instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1))); */      	       if(instep <= 0) { = 		  printf("Checksrc2: stepsize <= 0, bpn=%d, lastTime=%d\n",  			bpn, lastTime);  
 		  exit(0);  	 	       } 1                for(nextfan = nextpwl->srcfanouts; . 			nextfan != NULL; nextfan = nextfan->next) {, 		  /* if( nextfan->fansub->schednow != 0) {/ 		    nextfan->fansub->schednow = MIN(lastTime, " 			    nextfan->fansub->schednow); 		  } 
 		  else { */ + 		    nextfan->fansub->schednow = lastTime;  		  /* } */ G     if(timesteps) printf("checksrc3: waking up subnum %d at time %g\n", D     	      	nextfan->fansub->subnum, nextfan->fansub->schednow*mrt);	 	       }  	    } 	  }	         } ' 	else if((lastTime + newstep) < bpn ) { ( 	/* somewhere between two breakpoints */7           if (pw->voltage[pos] != pw->voltage[pos-1]) { >             deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]);F 	    /* instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1))); */     	    if(instep <= 0) {  B 		printf("Checksrc3: stepsize <= 0, bpn=%d bpnm1=%d\n",bpn,bpnm1);
 		exit(0); 	    }.             for(nextfan = nextpwl->srcfanouts;. 			nextfan != NULL; nextfan = nextfan->next) {, 		  /* if( nextfan->fansub->schednow != 0) {/ 		    nextfan->fansub->schednow = MIN(lastTime, " 			    nextfan->fansub->schednow); 		  } 
 		  else { */ + 		    nextfan->fansub->schednow = lastTime;  		  /* } */ D 	if(timesteps) printf("checksrc4: waking up subnum %d at time %g\n",D     	      	nextfan->fansub->subnum, nextfan->fansub->schednow*mrt); 	    } 	  } 	} 	else { B 	   printf(" node %d Time %d Step %d bpn-1=%d bpn=%d bpn+1=%d\n", B 	     nextpwl->nodenum, lastTime, newstep,pw->time[pw->lastloc-1],6 	     pw->time[pw->lastloc], pw->time[pw->lastloc+1]);= 	   printf(" vn-1=%g vn=%g vn+1=%g lastloc=%d wavesize=%d\n", ; 	     pw->voltage[pw->lastloc-1], pw->voltage[pw->lastloc], < 	     pw->voltage[pw->lastloc+1],pw->lastloc,pw->wavesize); C 	   printf( "FATAL, In Checksrc: some time condition not handled"); 	         }         }     } E     if(instep <= 0) { printf("Checksrc: stepsize <= 0\n"); exit(0); }      return( instep );  }    /*  B  * Check to see if src breakpoints or stoptime limit the step size  */ # long srcsteplimit(lastTime,newstep)  long lastTime,newstep; {  struct itapwlsrc *nextpwl; struct subfanout *nextfan; struct waveform  *pw;  double deltav; int pos; long instep, bpnm1, bpn, bpnp1;   ,     instep = MIN(newstep,stoptime-lastTime);$     if(newstep == 0) return(instep);@     if(variableStep == FALSE) return( instep ); /* fixed step */  I     for(nextpwl = sourcelist; nextpwl != NULL; nextpwl = nextpwl->next) { <        if ( nextpwl->srcfanouts == NULL) {}  /* dc supply */
        else { 7        /* Step on the input breakpoint, if required. */ -         pw = waves[nextpwl->nodenum].present; " 	pos = wavePointTime(pw,lastTime);2 	/* pos = pw->lastloc; */ bpnm1 = pw->time[pos-1];5         bpn = pw->time[pos]; bpnp1 = pw->time[pos+1];  	if(bpn <= lastTime) {& 	   if(pos+1 > pw->wavesize) continue;+            bpnm1 = bpn; bpn = bpnp1; pos++;  	}:         if((bpnm1 == lastTime) && (pos <= pw->wavesize)) {9 	  /* sitting on a breakpoint, ready to take next step */ 5           if (pw->voltage[pos] != pw->voltage[pos-1]) " 		instep = MIN(instep,maxstep/10);	         } B 	else if ((lastTime + newstep) == bpn) { /* hit next breakpoint */7           if (pw->voltage[pos] != pw->voltage[pos-1]) { < 	  /* during the transition region, limit change in input */>             deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]);H 	  /* >>> instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1))); */     	    if(instep <= 0) {  I 	     printf("srcsteplimit1: stepsize <= 0 bpn=%d bpnm1=%g\n",bpn,bpnm1);  	     exit(0); 	    } 	  }> 	  else /* no difference in voltage so take maxstep allowed */ 		instep = MIN(instep,newstep);  	}' 	else if ((lastTime + newstep) > bpn) { + 	/* stepping over a breakpoint? maybe... */ < 	  if (lastTime <= bpn) { /* already past the breakpoint? */H 	     instep = MIN(instep,bpn - lastTime);  /* yes, so hit breakpoint */:              if (pw->voltage[pos] != pw->voltage[pos-1]) {A                deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]); I 	       /* instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1))); */      	       if(instep <= 0) { A 		  printf("srcsteplimit2: stepsize <= 0, bpn=%d, lastTime=%d\n",  			bpn, lastTime);  
 		  exit(0);  	 	       }  	    } 	  }	         } ) 	else if ((lastTime + 2*newstep) > bpn) { ; 	/* check case where two small steps would be better than 1   	 * huge step and one small step 	 */0 	  instep = MIN((bpn - lastTime)/2 + 3, instep);	         } ' 	else if((lastTime + newstep) < bpn ) { ( 	/* somewhere between two breakpoints */7           if (pw->voltage[pos] != pw->voltage[pos-1]) { >             deltav = ABS(pw->voltage[pos]-pw->voltage[pos-1]);F 	    /* instep = MIN(instep, ((inputVlimit/deltav)*(bpn - bpnm1))); */     	    if(instep <= 0) {  B 		printf("srcsteplimit3: instep<=0, bpn=%d bpnm1=%d\n",bpn,bpnm1);
 		exit(0); 	    } 	  } 	} 	else { B 	   printf(" node %d Time %d Step %d bpn-1=%d bpn=%d bpn+1=%d\n", B 	     nextpwl->nodenum, lastTime, newstep,pw->time[pw->lastloc-1],6 	     pw->time[pw->lastloc], pw->time[pw->lastloc+1]);= 	   printf(" vn-1=%g vn=%g vn+1=%g lastloc=%d wavesize=%d\n", ; 	     pw->voltage[pw->lastloc-1], pw->voltage[pw->lastloc], < 	     pw->voltage[pw->lastloc+1],pw->lastloc,pw->wavesize); G 	   printf( "FATAL, In srcsteplimit: some time condition not handled"); 	         }         }     } J     if(instep <= 0) { printf("srcsteplimit4: stepsize <= 0\n"); exit(0); }     return( instep );  }    getsrcfanoutlist() { ! struct itapwlsrc *nextpwl, *last;  struct subfanout *nextfan; int nodenum;  7     for (nodenum = 1; nodenum <= maxnode ; nodenum++) { 8      if((waves[nodenum].present)->wavetype == USERSRC) {        if(sourcelist == NULL) { P           sourcelist = (struct itapwlsrc *) ralloc(1, sizeof(struct itapwlsrc)); 	  last = sourcelist;  	  last->next = NULL;            nextpwl = sourcelist;         }
        else { I 	  last->next = (struct itapwlsrc *) ralloc(1, sizeof(struct itapwlsrc));  	  last = last->next;  	  last->next = NULL;            nextpwl = last;         }"        nextpwl->nodenum = nodenum;(        /* if (nextpwl->dcsrc == TRUE) */2        if((waves[nodenum].present)->wavesize == 1)&        	   nextpwl->srcfanouts = NULL;        else A        	   nextpwl->srcfanouts = getsrcfanouts(nextpwl->nodenum); ,        printf("\n;src node fanout lists\n");(        if ( nextpwl->srcfanouts == NULL)D     	printf("DC src at node %d has no fanouts\n", nextpwl->nodenum);
        else { A          printf("Fanout subnums of node %d : ",nextpwl->nodenum); +          for(nextfan = nextpwl->srcfanouts; , 			nextfan != NULL; nextfan = nextfan->next)0     	   printf(" %d ", nextfan->fansub->subnum);          printf("\n");        }     }    }  } 