 #include <stdio.h> #include <math.h>  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"   J /* Usual newton Method.  The intent is to find a voltage vector such that H *  a weighted sum of the charge, the current, the old charge and the oldN *  current is zero.  The weighting of the sum is a function of the integration *  method.  D *  To find this voltage, an initial guess is supplied in nvolt.  TheD *  Jacobian and the rhs are formed.  The Jacobian is decomposed, andF *  the voltage vector is updated by adding the Jacobian inverse * rhs.H *  Note the inverse is not computed, but a matrix solution is performed.G *  Convergence is achieved when BOTH the voltages converge and the rhs, 2 *  or the newton residue, is close enough to zero. */6 newton(alpha0, charge, crnt, oldq, nvolt, rhs, subptr)3 double *charge, *crnt, *nvolt, *oldq, *rhs, alpha0;  struct subcircuit *subptr; { ' double vsum, maxdq, maxdv, isum, dtemp;  int conflg;  static int itercnt;  register int i, lsize;   numtpts++;   lsize = subptr->size;   @ /* Compute the charge, crnt, and jacobian for the subcircuit. */+   loadall(alpha0,nvolt,charge,crnt,subptr); 1   if(ludecompose(subptr) == FALSE) return(FALSE); 3 /* Compute the newton residue for the trap rule. */ J   for(i=1; i<=lsize; i++) rhs[i] = (alpha0*charge[i]) + oldq[i] + crnt[i];- /* Perform Matrix solution to get delta v. */    lusol(rhs,subptr);    - /* Enter newton loop with delta v computed */ 0   for(itercnt = 1; itercnt < maxnr; itercnt++) {     numnriters++;    /* Compute max delta v. */M     for(maxdv = 0.0 , i=1; i <= lsize; i++) maxdv = max(maxdv, dabs(rhs[i])); N   /* Limit newton delta v to nralpha,  BUT do not corrupt newton direction. */N     if(maxdv > nralpha) for(i=1; i <= lsize; i++) rhs[i] *= (nralpha / maxdv);  J   /* Get a maximum node voltage and add delta v to node voltage vector. */,     for(vsum = 0.0 , i=1; i <= lsize; i++) {6 	nvolt[i] -= rhs[i]; vsum = max(vsum,dabs(nvolt[i]));      } N   /* If the voltage did not converge get a new voltage without chking crnt. */.     if( maxdv > (nrvabs + (nrvrel * vsum)) ) {D     /* If not the newjacobth newton iter, don't get new jacobian. */G       if((itercnt % newjacob) != 0) rhsload(nvolt,charge,crnt,subptr);         else {1         loadall(alpha0,nvolt,charge,crnt,subptr); 7         if(ludecompose(subptr) == FALSE) return(FALSE);        } !     /* Compute Newton Residue. */ N       for(i=1; i<=lsize; i++) rhs[i] = (alpha0*charge[i]) + oldq[i] + crnt[i];+     /* Solve to get vector of delta v's. */        lusol(rhs,subptr);     }   B   /* Else check the crnt, and return if crnt converged as well. */
     else {J     /* If not the newjacobth newton iteration don't recompute jacobian. */G       if((itercnt % newjacob) != 0) rhsload(nvolt,charge,crnt,subptr);  4       else loadall(alpha0,nvolt,charge,crnt,subptr);?     /* Compute newton residue and check residue convergence. */ 1       for(i=1 , conflg = TRUE; i <= lsize; i++) { %         dtemp = (alpha0 * charge[i]); $ 	rhs[i] = dtemp + oldq[i] + crnt[i];;         isum = dabs(dtemp) + dabs(oldq[i]) + dabs(crnt[i]); F         if(dabs(rhs[i]) > ((nrcrel * isum) + nrcabs) ) conflg = FALSE;       } &       if(conflg == TRUE) return(TRUE);  +     /* Solve to get vector of delta v's. */ $       if( (itercnt % newjacob) != 0)1 		if(ludecompose(subptr) == FALSE) return(FALSE);        lusol(rhs,subptr);     }    }    return(FALSE); } 