? /* The partitioner takes a flat description of a circuit and */ # /* breaks it up into subciruits. */  #include <math.h>  #include <stdio.h> #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h" #include "ipstruct.h"    #define ALREADY TRUE+5 #define MAXDEPTH 5  ( /* Stack globals for the partitioner. */ int *tstk, *bstk;   ( /* Stuff the devices in the devarray. */ stuffdev(pdev) struct device *pdev; { A   for(; pdev != NULL; pdev = pdev->next) (*pdev->stuffdev)(pdev);  }   E /* Adddevarray takes a pointer to a device and a node number, and  */ E /* adds that device to the list of devices connected to that node. */  adddevarray(devptr, node)  struct device *devptr;	 int node;  {  struct deventry *deventryptr; K /* Error exit on negative node number.  Just return if ground or source. */ )   if( (node < 0) || (node > maxnode) ) {  K      printf("adddevice error node = %d out of bounds\n", node); exit(0); };       if (node==0) return(OKAY);3 /* Then go to end of the dev list for this node. */ (   if(devarray[node].deventptr == NULL) {"     devarray[node].nodenum = node;     devarray[node].deventptr =  9 		(struct deventry *) ralloc(1, sizeof(struct deventry)); +     deventryptr = devarray[node].deventptr;    }    else {+     deventryptr = devarray[node].deventptr; E     while(deventryptr->next != NULL) deventryptr = deventryptr->next;      deventryptr->next = 8 	(struct deventry *) ralloc(1, sizeof(struct deventry));$     deventryptr = deventryptr->next;   }   6 /* And put the device ptr in the device entry list. */   deventryptr->next = NULL;    deventryptr->devptr = devptr;    deventryptr->eqnnode = node;   return(OKAY);  }      /* The partitioning algorithm:D * Step 1: For each node in the circuit, assess the effective sum of ? * 	  conductances and sum of capacitances incident at the node. E * Step 2: Tie together nodes connected by conductances that are large ? *	  compared to the total conductance incident at the node, and = *	  tie together nodes connected by capacitors that are large ; *	  compared to the total capacitance incident at the node. J * Step 3: Tie together tight feedback loops.  So far this involves looking *	  for cross-coupled mosfets.F * Step 4: Regroup small subcircuits that have inadvertently been split *	  across drain-source pairs. */ partition()  { + double capsum, condsum, hmin, estavgcond();  struct deventry *pentry; struct nodedevlist *pdevlist;  struct fet1 *pm1;  struct fetti *pmti;  struct fet3 *pm3;  struct lcap *cptr; struct lres *rptr; struct diode *dptr;  int conone, i, conflg;   /* Create space for a stack */1   bstk = (int *) ralloc(MAXDEPTH+2, sizeof(int));    for(i=0; i <= maxnode; i++) { :       devarray[i].nodenum = i; /* Just its node number. */J       devarray[i].flag = 0; /* Flag used to indicate subcircuit number. */N       devarray[i].newnode = i; /* Nothing tied together, or converted node. */5       devarray[i].botnode = i; /* Is last in list. */ J       devarray[i].nodecnt = 1; /* Number of nodes in subcircuit so far. */!       devarray[i].oldnodecnt = 0;    }   F /* First pass - tie nodes connected by large floating conductances. */B   for(i=1; i <= maxnode; i++) { /* Run through all the devices. *//     if(waves[i].present->wavetype != USERSRC) { L       for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next)   				    			     condtie(pentry);     }    } <   /* printf("After condtie substats\n"); earlysubstats(); */  K /* Compute the minimum resonable timestep to scale the conductances with */ " /* respect to the capacitances. */4   estmincap();   /* Node by node min capacitance. */:   for(capsum = 0 , condsum = 0 , i=1; i <= maxnode; i++) {+     if( (devarray[i].deventptr != NULL) &&  3         (waves[i].present->wavetype != USERSRC) ) { A       tstk = bstk; *tstk = i; devarray[i].maxcond = estavgcond(); #       capsum += devarray[i].mincap; %       condsum += devarray[i].maxcond;      }    } N   hmin = capsum/(condsum + gmin); /* Just make sure conductance isn't zero. */H   /* printf("capsum=%g condsum=%g hmin=%g\n", capsum, condsum, hmin); */  H /* The second step.  Go back through the circuit tying together nodes */& /* with large floating capacitors.  */B   for(i=1; i <= maxnode; i++) { /* Run through all the devices. *//     if(waves[i].present->wavetype != USERSRC) { L       for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next) 2 				if(captie(pentry,hmin) == TRUE) conone = TRUE;     }    } ;   /* printf("After captie substats\n"); earlysubstats(); */   > /* Third pass, Tie tight feedbacks together (gate to drain) */. /* Chase down all the collections of nodes. */   do {     conone = FALSE;      for(i=1; i < maxnode; i++)  2       if( (waves[i].present->wavetype != USERSRC) F 	  && (devarray[i].deventptr != NULL) && (devarray[i].prev == NULL) ) '       /* Chase down the device list. */ &         for(pdevlist = &(devarray[i]);D                       pdevlist != NULL; pdevlist = pdevlist->next) {;           for(pentry = pdevlist->deventptr; pentry != NULL;  	 					 pentry = pentry->next)I           /* Check if this device's gatenode, if its contained in this */ L           /* Node collection, is bidirectionally coupled to another node. */$ 	    switch(pentry->devptr->utype) {             case FET1 : 4 	      pm1 = (struct fet1 *) pentry->devptr->devptr;1               if(pm1->gnode == pentry->eqnnode) { 8 	        if(bicheck(pm1->dnode, &(devarray[i])) == TRUE)? 		  if(connodes(pm1->gnode, pm1->dnode) == TRUE) conone = TRUE; 8 	        if(bicheck(pm1->snode, &(devarray[i])) == TRUE)? 		  if(connodes(pm1->gnode, pm1->snode) == TRUE) conone = TRUE; 	 	      }	 
 	      break;              case FETTI :  6 	      pmti = (struct fetti *) pentry->devptr->devptr;2               if(pmti->gnode == pentry->eqnnode) {9 	        if(bicheck(pmti->dnode, &(devarray[i])) == TRUE) 2 		  if(connodes(pmti->gnode, pmti->dnode) == TRUE) 							  conone = TRUE; 9 	        if(bicheck(pmti->snode, &(devarray[i])) == TRUE) 2 		  if(connodes(pmti->gnode, pmti->snode) == TRUE) 							  conone = TRUE; 	 	      }	      	      break;              case FET3 : 4 	      pm3 = (struct fet3 *) pentry->devptr->devptr;1               if(pm3->gnode == pentry->eqnnode) { 8 	        if(bicheck(pm3->dnode, &(devarray[i])) == TRUE)0 		  if(connodes(pm3->gnode, pm3->dnode) == TRUE) 							  conone = TRUE; 8 	        if(bicheck(pm3->snode, &(devarray[i])) == TRUE)0 		  if(connodes(pm3->gnode, pm3->snode) == TRUE) 							  conone = TRUE; 	 	      }	      	      break;              case LCAP : break;             case DIODE : break;              case LRES : break;       	    case ISRC : break;  	    default :  = 		printf("Unknown device in partitioner phase 3\n"); exit(0); 
             }  	}   } while (conone == TRUE); =   /* printf("After bicheck substats\n");  earlysubstats(); */   J /* The final step.  Go back through the circuit tying small subcircuits */J /* connected by drain-sources or diodes. Also, tie the bulk node sub if */9 /* small to the d or s node sub, whichever is smaller. */ @   for(i=1; i <= maxnode; i++) /* Run through all the devices. */-     if(waves[i].present->wavetype != USERSRC) N        for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next) {(          switch(pentry->devptr->utype) {     	   case FET1:  3 	     pm1 = (struct fet1 *) pentry->devptr->devptr; B 	     fetlastgasp(pm1->snode, pm1->dnode, pm1->gnode, pm1->bnode); 	     break;     	   case FETTI: 5 	     pmti = (struct fetti *) pentry->devptr->devptr; F 	     fetlastgasp(pmti->snode, pmti->dnode, pmti->gnode, pmti->bnode); 	     break;     	   case FET3:  3 	     pm3 = (struct fet3 *) pentry->devptr->devptr; B 	     fetlastgasp(pm3->snode, pm3->dnode, pm3->gnode, pm3->bnode); 	     break;            case LRES:               break;             case DIODE:<              dptr = (struct diode *) pentry->devptr->devptr;2 	     fetlastgasp(dptr->anode, dptr->cnode, 0, 0);              break;             case LCAP: break;            case ISRC : break;             default :  A 	     printf("Unknown dev final step in partitioner\n"); exit(0); 
          }   } ?   /* printf("After final step substats\n"); earlysubstats(); */  }    bicheck(othernode, nodeentptr) int othernode; struct nodedevlist *nodeentptr;  {  struct deventry *pentry;3 struct nodedevlist *pdevlist, *firstptr, *chaseptr;  struct fet1 *fetptr; struct fetti *fettiptr;  struct fet3 *pm3;  struct bjt *bptr; H /* Chase down the node collection list, to see if othernode is in the */ /* gate node's collection. */ I   for(pdevlist = nodeentptr; pdevlist != NULL; pdevlist = pdevlist->next) 8 			    if(pdevlist->nodenum == othernode) return(FALSE);L /* Then see if the othernode's collection has a gatenode that has a dnode */1 /* or snode in the original gnode's collection.*/ 8 /* First get to the top of the othernodes collection. */(   for(firstptr = &(devarray[othernode]);5 		firstptr->prev != NULL; firstptr = firstptr->prev); 1 /* Then chase down the othernodes device list. */ G   for(pdevlist = firstptr; pdevlist != NULL; pdevlist = pdevlist->next) 5     for(pentry = pdevlist->deventptr; pentry != NULL;  	 					 pentry = pentry->next)%       switch(pentry->devptr->utype) { B       case FET1 : fetptr = (struct fet1 *) pentry->devptr->devptr;.         if(fetptr->gnode == pentry->eqnnode) {/ 	  for(chaseptr = nodeentptr; chaseptr != NULL; " 					 chaseptr = chaseptr->next) {9 	    if(chaseptr->nodenum == fetptr->dnode) return(TRUE); 9 	    if(chaseptr->nodenum == fetptr->snode) return(TRUE);  	  } 	}         break;F       case FETTI : fettiptr = (struct fetti *) pentry->devptr->devptr;0         if(fettiptr->gnode == pentry->eqnnode) {/ 	  for(chaseptr = nodeentptr; chaseptr != NULL; " 					 chaseptr = chaseptr->next) {; 	    if(chaseptr->nodenum == fettiptr->dnode) return(TRUE); ; 	    if(chaseptr->nodenum == fettiptr->snode) return(TRUE);  	  } 	}         break;?       case FET3 : pm3 = (struct fet3 *) pentry->devptr->devptr; +         if(pm3->gnode == pentry->eqnnode) { / 	  for(chaseptr = nodeentptr; chaseptr != NULL; " 					 chaseptr = chaseptr->next) {6 	    if(chaseptr->nodenum == pm3->dnode) return(TRUE);6 	    if(chaseptr->nodenum == pm3->snode) return(TRUE); 	  } 	}         break;>       case BJT : bptr = (struct bjt *) pentry->devptr->devptr;,         if(bptr->bnode == pentry->eqnnode) {/ 	  for(chaseptr = nodeentptr; chaseptr != NULL; " 					 chaseptr = chaseptr->next) {7 	    if(chaseptr->nodenum == bptr->cnode) return(TRUE); 7 	    if(chaseptr->nodenum == bptr->enode) return(TRUE);  	  } 	}         break;       case LCAP : break;       case DIODE : break;        case LRES : break;       case ISRC : break;@       default: printf("Unknown device in Bi-Check.\n"); exit(0);       }    return(FALSE); }    /*  ? * Ties together nodes connected by large floating conductances.  */ condtie(pentry)  struct deventry *pentry; {  int node1, node2, node2p; - double gfloat, gparallel, gground, estcond();  struct deventry *nent;  . /* The node this device is in reference to. */   node1 = pentry->eqnnode;  K /* Find the other node and conductance with which this element connects. */ %   node2 = condcouple(pentry,&gfloat);   ; /* Are these nodes already tied, or otherwise untieable. */ 2   if(chkthis(node1,node2) == FALSE) return(FALSE);  H /* Find any OTHER conductances in parallel across the same two nodes. */J   for(nent = devarray[node1].deventptr; nent != NULL; nent = nent->next) {8     if( (pentry != nent) && (nent->eqnnode == node1) ) {+       node2p = condcouple(nent,&gparallel); .       if(node2p == node2) gfloat += gparallel;     }    }   M /* Now estimate the grounded conductance and compare to the floating cond. */ E   tstk = bstk; *tstk = node2; *(++tstk) = node1; gground = estcond(); = /*  printf("gground = %g gfloat = %g\n", gground, gfloat); */ $   if(gfloat > (pfactor * gground)) {G     tstk = bstk; *tstk = node1; *(++tstk) = node2; gground = estcond(); + /*    printf("gground = %g\n", gground); */ '     if(gfloat > (cpfactor * gground)) { 6       if(connodes(node1, node2) == TRUE) return(TRUE);     }    }   3 /* Still here, must not have connected anything. */    return(FALSE); }        condcouple(pentry,pcond) struct deventry *pentry; double *pcond; {  struct fet1 *pm1;  struct fetti *pmti;  struct fet3 *pm3;  struct lres *rptr; struct diode *dptr;   !   switch(pentry->devptr->utype) {      case FET1:  3       pm1 = (struct fet1 *) pentry->devptr->devptr; *       if(pm1->dnode == pentry->eqnnode) { , 			*pcond = pm1->beta; return(pm1->snode); }*       if(pm1->snode == pentry->eqnnode) { , 			*pcond = pm1->beta; return(pm1->dnode); }       break;     case FETTI: 5       pmti = (struct fetti *) pentry->devptr->devptr; +       if(pmti->dnode == pentry->eqnnode) {  . 			*pcond = pmti->beta; return(pmti->snode); }+       if(pmti->snode == pentry->eqnnode) {  . 			*pcond = pmti->beta; return(pmti->dnode); }       break;     case FET3:3       pm3 = (struct fet3 *) pentry->devptr->devptr; *       if(pm3->dnode == pentry->eqnnode) { - 			*pcond = pm3->betap; return(pm3->snode); } *       if(pm3->snode == pentry->eqnnode) { - 			*pcond = pm3->betap; return(pm3->dnode); }        break;     case LRES:4       rptr = (struct lres *) pentry->devptr->devptr;*       if(rptr->node1 == pentry->eqnnode) {8 		        *pcond = rptr->condval; return(rptr->node2); }*       if(rptr->node2 == pentry->eqnnode) {8 		        *pcond = rptr->condval; return(rptr->node1); }       break;     case DIODE: 5       dptr = (struct diode *) pentry->devptr->devptr; *       if(dptr->anode == pentry->eqnnode) {A 	        *pcond = dptr->pmodel->imax/10.0; return(dptr->cnode); } *       if(dptr->cnode == pentry->eqnnode) {A 	        *pcond = dptr->pmodel->imax/10.0; return(dptr->anode); }        break;     case LCAP: break;      case ISRC : break;M     default : printf("Unknown dev in cond couple in partitioner\n"); exit(0);    }    *pcond = 0.0;    return(0); }      /*  @ * Ties together nodes connected by large floating capacitances.  */ captie(pentry,hmin)  struct deventry *pentry; double hmin; {  int node1, node2, node2p; , double cfloat, cparallel, cground, estcap(); struct deventry *nent;  . /* The node this device is in reference to. */   node1 = pentry->eqnnode;  K /* Find the other node and capacitance with which this element connects. */ $   node2 = capcouple(pentry,&cfloat);  ; /* Are these nodes already tied, or otherwise untieable. */ 2   if(chkthis(node1,node2) == FALSE) return(FALSE);  H /* Find any OTHER capacitances in parallel across the same two nodes. */J   for(nent = devarray[node1].deventptr; nent != NULL; nent = nent->next) {8     if( (pentry != nent) && (nent->eqnnode == node1) ) {*       node2p = capcouple(nent,&cparallel);.       if(node2p == node2) cfloat += cparallel;     }    }   L /* Now estimate the grounded capacitance and compare to the floating cap. */H   tstk = bstk; *tstk = node2; *(++tstk) = node1; cground = estcap(hmin);= /*  printf("cground = %g cfloat = %g\n", cground, cfloat); */ %   if(cfloat > (cpfactor * cground)) { J     tstk = bstk; *tstk = node1; *(++tstk) = node2; cground = estcap(hmin);- /*      printf("cground = %g\n", cground); */ '     if(cfloat > (cpfactor * cground)) { 6       if(connodes(node1, node2) == TRUE) return(TRUE);     }    }   3 /* Still here, must not have connected anything. */    return(FALSE); }      capcouple(pentry,pcfloat)  struct deventry *pentry; double *pcfloat; {  struct fet1 *pm1;  struct fet3 *pm3;  struct fetti *pmti;  struct lcap *cptr;  !   switch(pentry->devptr->utype) {      case FET1:  3       pm1 = (struct fet1 *) pentry->devptr->devptr; L       if((pm1->dnode == pentry->eqnnode)||(pm1->snode == pentry->eqnnode)) {         *pcfloat = pm1->cgsub;         return(pm1->gnode);        }        break;     case FETTI: 5       pmti = (struct fetti *) pentry->devptr->devptr; N       if((pmti->dnode == pentry->eqnnode)||(pmti->snode == pentry->eqnnode)) {         *pcfloat = pmti->cgsub;          return(pmti->gnode);       }        break;     case FET3:3       pm3 = (struct fet3 *) pentry->devptr->devptr; L       if((pm3->dnode == pentry->eqnnode)||(pm3->snode == pentry->eqnnode)) {         *pcfloat = pm3->cgsub;         return(pm3->gnode);        }        break;     case LCAP:4       cptr = (struct lcap *) pentry->devptr->devptr;*       if(cptr->node1 == pentry->eqnnode) {          *pcfloat = cptr->capval;         return(cptr->node2);       } /       else if(cptr->node2 == pentry->eqnnode) {           *pcfloat = cptr->capval;         return(cptr->node1);       }        break;     case DIODE: break;     case LRES: break;      case ISRC : break;K     default : printf("Unknown dev in capcouple in partitioner\n"); exit(0);    } / /* Still here? No coupling capacitance then. */    *pcfloat = 0;    return(0); }      double estcap(hmin)  double hmin; {  double cap, temp, estcap();  int node, match, *instk; struct deventry *pentry; struct lres *rptr; struct lcap *cptr; struct diode *dptr;  struct fet1 *pm1;  struct fetti *pmti;  struct fet3 *pm3;  /*   printf("estcap stack\n"); E   for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) { 1             printf("stack = %d ",  *(instk--)  );    }    printf("\n");  */4 /* If this nodeentry is the beginning chase away. */M   cap = devarray[*tstk].sumcap; /* Start with cap equal to sumcap at node. */ M   for(pentry= devarray[*tstk].deventptr; pentry!=NULL; pentry=pentry->next) { #     switch(pentry->devptr->utype) {        case FET1:  5         pm1 = (struct fet1 *) pentry->devptr->devptr; O         if(pm1->gnode == *tstk) cap += pm1->cgsub * min(pm1->mptr->gamma, 1.0); %         else if(pm1->bnode == *tstk)  3 				cap += pm1->cgsub * min(pm1->mptr->gamma, 1.0);          break;       case FETTI: 7         pmti = (struct fetti *) pentry->devptr->devptr; !         if(pmti->gnode == *tstk)  2 		cap += pmti->cgsub * min(pmti->mptr->gamma,1.0);&         else if(pmti->bnode == *tstk) 2 		cap += pmti->cgsub * min(pmti->mptr->gamma,1.0);       case FET3:  5         pm3 = (struct fet3 *) pentry->devptr->devptr; N         if(pm3->gnode == *tstk) cap += pm3->cgsub * min(pm3->mptr->gamma,1.0);%         else if(pm3->bnode == *tstk)  1 			cap += pm3->cgsub * min(pm3->mptr->gamma,1.0);        case DIODE: 7         dptr = (struct diode *) pentry->devptr->devptr; 8         if(chkconn(dptr->anode, dptr->cnode) == FALSE) {O           if(dptr->anode == *tstk) cap += 0.5 * dptr->area * dptr->pmodel->cjo; /           else if(dptr->cnode == *tstk) cap +=  * 					0.5 * dptr->area * dptr->pmodel->cjo;	         }          break;       case LCAP:  6         cptr = (struct lcap *) pentry->devptr->devptr;5       /* Find out which cap node is not this node. */ 4         if(cptr->node1 != *tstk) node = cptr->node1;          else node = cptr->node2;D       /* Recurse if not too deep and next node not a user source. */:         if( (waves[node].present->wavetype != USERSRC) && * 				(((int) (tstk - bstk)) < MAXDEPTH) ) {:         /* Subtract out this floating cap from sum cap. */           cap -= cptr->capval;  /         /* Avoid going back the way we came. */ M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) { 0             if(node == *(instk--)) match = TRUE;           }            if(match == FALSE) {  A             *(++tstk) = node; /* Place this node on the stack. */               temp = estcap(hmin);. 	  /* Sum the series into this capacitance. */?             cap += (cptr->capval * temp)/(cptr->capval + temp); 4             tstk--; /* Pop the node off the stack */           } 	         }          break;       case ISRC : break;       case LRES:  6         rptr = (struct lres *) pentry->devptr->devptr;:       /* Find out which resistor node is not this node. */4         if(rptr->node1 != *tstk) node = rptr->node1;          else node = rptr->node2;  :         if( (waves[node].present->wavetype != USERSRC) && * 				(((int) (tstk - bstk)) < MAXDEPTH) ) {/         /* Avoid going back the way we came. */ M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) { 0             if(node == *(instk--)) match = TRUE;           } ,         /* Time to recurse down the tree. */:           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */               temp = estcap(hmin);N             cap += (temp * hmin* rptr->condval)/(hmin * rptr->condval + temp);4             tstk--; /* Pop the node off the stack */           } 	         }          break;=       default: printf("Unknown device in estcap\n"); exit(0);      }    }    return(cap); }    double estcond() {  double cond, temp, estcond();  int node, match, *instk; struct deventry *pentry; struct lres *rptr;  4 /* If this nodeentry is the beginning chase away. */   cond = 0; M   for(pentry= devarray[*tstk].deventptr; pentry!=NULL; pentry=pentry->next) { #     switch(pentry->devptr->utype) {        case FET1: break;        case FETTI: break;       case FET3: break;        case DIODE: break;       case LCAP: break;        case ISRC : break;       case LRES:  6         rptr = (struct lres *) pentry->devptr->devptr;N       /* If the resistor is tied to voltage source, it adds to conductance. */@         if( (waves[rptr->node1].present->wavetype == USERSRC) ||@             (waves[rptr->node2].present->wavetype == USERSRC) )  							cond += rptr->condval; 5         else if( ((int) (tstk - bstk)) < MAXDEPTH)  { <         /* Find out which resistor node is not this node. */6           if(rptr->node1 != *tstk) node = rptr->node1;"           else node = rptr->node2;  /         /* Avoid going back the way we came. */ M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) { 0             if(node == *(instk--)) match = TRUE;           }   ,         /* Time to recurse down the tree. */:           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */ +             temp = estcond(); /* Recurse */ H             cond += ( (rptr->condval * temp) / (rptr->condval + temp) );4             tstk--; /* Pop the node off the stack */           } 	         }          break;>       default: printf("Unknown device in estcond\n"); exit(0);     }    }    return(cond);  }      double estavgcond()  {   double cond, temp, estavgcond(); int node, match, *instk; struct deventry *pentry; struct lres *rptr; struct fet1 *pm1;  struct fetti *pmti;  struct fet3 *pm3;   4 /* If this nodeentry is the beginning chase away. */( /* Always stop on transistors though. */   cond = 0; M   for(pentry= devarray[*tstk].deventptr; pentry!=NULL; pentry=pentry->next) { #     switch(pentry->devptr->utype) {        case FET1:  5         pm1 = (struct fet1 *) pentry->devptr->devptr;          cond += pm1->beta;         break;       case FETTI: 7         pmti = (struct fetti *) pentry->devptr->devptr;          cond += pmti->beta;          break;       case FET3:5         pm3 = (struct fet3 *) pentry->devptr->devptr;          cond += pm3->betap;          break;       case DIODE: break;       case LCAP: break;        case ISRC : break;       case LRES:  6         rptr = (struct lres *) pentry->devptr->devptr;L         if(chkconn(rptr->node1,rptr->node2) == FALSE) cond += rptr->condval;5         else if( ((int) (tstk - bstk)) < MAXDEPTH ) { 6           if(rptr->node1 != *tstk) node = rptr->node1;"           else node = rptr->node2;M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) { 0             if(node == *(instk--)) match = TRUE;           } :           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */ .             temp = estavgcond(); /* Recurse */H             cond += ( (rptr->condval * temp) / (rptr->condval + temp) );4             tstk--; /* Pop the node off the stack */           } 	         }          break;A       default: printf("Unknown device in estavgcond\n"); exit(0);      }    }    return(cond);  }   * /* Assume estcond has already been run. */ estmincap()  {  double temp, temp2;  struct deventry *pentry; struct fet1 *pm1;  struct fet3 *pm3;  struct fetti *pmti;  struct diode *dptr;  int i;     for(i=1; i <= maxnode; i++) { ,     devarray[i].mincap = devarray[i].sumcap;/     if(waves[i].present->wavetype != USERSRC) { M       for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next) { (          switch(pentry->devptr->utype) {           case FET1:  9             pm1 = (struct fet1 *) pentry->devptr->devptr; !             if(pm1->gnode == i) { ) 	      temp = min(pm1->mptr->gamma, 1.0); 8 	      devarray[pm1->gnode].mincap += temp * pm1->cgsub;
             } &             else if(pm1->bnode == i) {) 	      temp = min(pm1->mptr->gamma, 1.0); ?               devarray[pm1->bnode].mincap += temp * pm1->cgsub; 
             }              break;           case FETTI: ;             pmti = (struct fetti *) pentry->devptr->devptr; "             if(pmti->gnode == i) {* 	      temp = min(pmti->mptr->gamma, 1.0);: 	      devarray[pmti->gnode].mincap += temp * pmti->cgsub;: 	      devarray[pmti->bnode].mincap += temp * pmti->cgsub;
             } '             else if(pmti->bnode == i) { * 	      temp = min(pmti->mptr->gamma, 1.0);A               devarray[pmti->bnode].mincap += temp * pmti->cgsub; 
             }  	    break;            case FET3:  9             pm3 = (struct fet3 *) pentry->devptr->devptr; !             if(pm3->gnode == i) { ) 	      temp = min(pm3->mptr->gamma, 1.0); 8 	      devarray[pm3->gnode].mincap += temp * pm3->cgsub;8 	      devarray[pm3->bnode].mincap += temp * pm3->cgsub;
             } &             else if(pm3->bnode == i) {) 	      temp = min(pm3->mptr->gamma, 1.0); ?               devarray[pm3->bnode].mincap += temp * pm3->cgsub; 
             }  	    break;            case DIODE: ;             dptr = (struct diode *) pentry->devptr->devptr; A             if(dptr->anode == i) devarray[dptr->anode].mincap +=  * 					0.5 * dptr->area * dptr->pmodel->cjo;F             else if(dptr->cnode == i) devarray[dptr->cnode].mincap += * 					0.5 * dptr->area * dptr->pmodel->cjo;             break;           case LRES: break; ?           case LCAP: break; /* Linear caps already included. */            case ISRC : break;N           default : printf("Unknown dev in capacitance estimator\n"); exit(0);	         }        }      }    }  }        /*B * Fet last gasp ties together small subcircuits.  If the drain andF * source nodes are in different small subcircuits, they are connected.D * The bulk node is tied to the smallest of the drain and source node% * subcircuits if one is small enough.  */ #define SMALLSUB 10 ' fetlastgasp(snode, dnode, gnode, bnode)  int snode, dnode, gnode, bnode;  { ! int snodecnt, dnodecnt, bnodecnt;   1   if(waves[snode].present->wavetype != USERSRC) { ;     snodecnt = (devarray[devarray[snode].newnode]).nodecnt;    }    else snodecnt = 1 + SMALLSUB; 1   if(waves[dnode].present->wavetype != USERSRC) { ;     dnodecnt = (devarray[devarray[dnode].newnode]).nodecnt;    }    else dnodecnt = 1 + SMALLSUB;   > /* Looking to tie drain to source node if not tied already. */   if(chkthis(dnode,snode)) {@     if((snodecnt + dnodecnt) < SMALLSUB) connodes(dnode, snode);   }   E /* If either drain or source node in a single node subcircuit, tie */  /* the source to the drain. */D   if( ((dnodecnt == 1)||(snodecnt == 1)) && (chkthis(dnode,snode)) ) 							connodes(dnode,snode);     = /* Tie bulk to smallest of the drain and source node subs. */ 1   if(waves[bnode].present->wavetype != USERSRC) { ;     bnodecnt = (devarray[devarray[bnode].newnode]).nodecnt; 3     if(snodecnt < dnodecnt) connodes(snode, bnode);       else connodes(dnode, bnode);   }  }     > /* Connect the nodes by doubly linking the two node entries */ /* in the device array. */ connodes(node1, node2) int node1, node2;  { ; struct nodedevlist *last1ptr, *top2ptr, *top1ptr, *tempptr;   2 /* Don't con ground nodes or user source nodes. */3   if( (node1 <= 0) || (node2 <= 0) ) return(FALSE); 4   if( (waves[node1].present->wavetype == USERSRC) ||> 		(waves[node2].present->wavetype == USERSRC) ) return(FALSE);( /* Point to the top of the two lists. */2   top1ptr = &(devarray[devarray[node1].newnode]); 3   top2ptr = &(devarray[devarray[node2].newnode]);   * /* Make sure two aren't already linked. */9   if(top1ptr->newnode == top2ptr->newnode) return(FALSE); / /* Swap if node2 list has lower node number. */ ,   if(top1ptr->newnode > top2ptr->newnode) { <     tempptr = top1ptr; top1ptr = top2ptr; top2ptr = tempptr;   } - /* Mark higher with the lower node number. */ B   for(tempptr = top2ptr; tempptr != NULL; tempptr = tempptr->next), 				    tempptr->newnode = top1ptr->newnode; /* Bot of node1 list. */-   last1ptr = &(devarray[top1ptr->botnode]);    /* Link the two. */ G   top1ptr->nodecnt += top2ptr->nodecnt;  /* Keep a count of # nodes. */    last1ptr->next = top2ptr;    top2ptr->prev = last1ptr; &   top1ptr->botnode = top2ptr->botnode; /*1   for(; top1ptr != NULL; top1ptr = top1ptr->next) $     printf("n = %d b= %d on=%d \n", 8 		top1ptr->newnode, top1ptr->botnode, top1ptr->nodenum); */   return(TRUE);  }   8 /* Check whether node1 is already connected to node2. */8 /* Return false if either node is a source or ground. */ chkconn(node1, node2)  int node1, node2;  { 3   if( (node1 == 0) || (node2 == 0) ) return(FALSE); 4   if( (waves[node1].present->wavetype == USERSRC) ||> 		(waves[node2].present->wavetype == USERSRC) ) return(FALSE);F   if(devarray[node2].newnode == devarray[node1].newnode) return(TRUE);   return(FALSE); }    /*  B * Indicates whether to bother checking to connect this two nodes. J * Returns false if one is a voltage src or ground or if already connected. */ chkthis(node1, node2)  int node1, node2;  { 9   if( (node1 == node2) || (node1 == 0) || (node2 == 0) || =       (devarray[node2].newnode == devarray[node1].newnode) || 4       (waves[node1].present->wavetype == USERSRC) ||B       (waves[node2].present->wavetype == USERSRC) ) return(FALSE);   else return(TRUE); } 