 #include <math.h>  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"   F /* There are two types of checks for latency.  The first type of check@ *  is based on the predictor-corrector lte control estimate, andF *  uses the backward differences, and the worst case (inside a window)B *  latent step.  However, it does not guarantee that one is close H *  to an equilibruim point (dc solution point).  This can cause problemsE *  as one moves across window boundaries.  In those cases toughlat is 9 *  used, as it also checks the current and the charge to  A *  insure that no change larger than the relative lte will occur.  */( steplat(present,newtime,subptr,toughchk)$ struct timepoint *present, *newtime; struct subcircuit *subptr;
 int toughchk;  { 	 int i, j; 8 double maxq, maxc, vdiff, stepratio, nowvolt, waveval(); long chngtime, newstep;  struct waveform *presptr;  struct timepoint *temp;  /* Check for latency. */%   stepratio = (stoptime - starttime); /   stepratio /= (newtime->time - present->time); $   for(i=1; i <= subptr->size; i++) {F     vdiff = (newtime->nodevolt[i] - present->nodevolt[i]) * stepratio;     vdiff = dabs(vdiff);K     if( (latratio * vdiff) > ((lterel*dabs(newtime->nodevolt[i]))+lteabs))   								return(FALSE);   } B   if(toughchk == TRUE) { /* Check for latency, only check hard. */@     for(maxq = 0.0 , maxc = 0.0 , i=1; i <= subptr->size; i++) {1       maxq = max(maxq, dabs(newtime->charge[i])); 2       maxc = max(maxc, dabs(newtime->current[i]));     } N     if((latratio*mrt*(stoptime-starttime)*maxc) >(maxq*lterel)) return(FALSE);   }   ; /* Now check all the inputs for the first one to change. */ K   for(chngtime = stoptime , newstep = 0 , i=subptr->external; i < 0; i++) { %     presptr = subptr->inwavearray[i]; K   /* Waveval leaves lastloc pointing to the point after the passed time. */ .     nowvolt = waveval(presptr, newtime->time);<     for(j = presptr->lastloc; j <= presptr->wavesize; j++) {,       vdiff = presptr->voltage[j] - nowvolt;#       if(dabs(vdiff) > latthresh) { +         if(presptr->time[j-1] < chngtime) { *           chngtime = presptr->time[j - 1];:           newstep = presptr->time[j] - presptr->time[j-1];	         }        }      }    } M   chngtime = min(chngtime, stoptime - newstep); /* Insure reasonable step. */   F /* If more than one timestep is to be gained, take the latent step. */6   if( chngtime > (newtime->time + subptr->ltestep) ) {   /* Rotate the timepoints. */     temp = subptr->old2;     subptr->old2 = subptr->old; #     subptr->old = subptr->present;  &     subptr->present = subptr->newtime;     subptr->newtime = temp; *   /* Copy the present into the newtime. */N     copytimept(subptr->present,subptr->newtime,subptr->size,subptr->external);   /* Change the newtime. */ &     subptr->newtime->time = chngtime;    /* Use input source step. */?     for(i=subptr->external; i < 0; i++) newtime->nodevolt[i] =  7 	waveval(subptr->inwavearray[i],subptr->newtime->time);      subptr->ltestep = A 	pickstep( (double) 1.0, newstep, subptr->newtime->time, subptr); I     subptr->offset = storewave(subptr->newtime, subptr->offset, subptr);     }  }    /*A * Stepnonlat takes an integration timestep.  The timestep used is B * passed in as the ltestep. This is the first guess at a timestep,= * and then if it is unacceptable due to local trunc error, or B * newton nonconvergence, a new smaller step is computed and tried.? * The predicted likely acceptable timestep for the next step is  * returned.  */= long stepnonlat(old2,old,present,newtime,ltestep, predictor,   						oldstuff, rhs, subptr)1 struct timepoint *old2, *old, *present, *newtime; # double *predictor, *oldstuff, *rhs;  struct subcircuit *subptr;
 long ltestep;  { < double a0,a1,a2, alpha0, lteratio=0.0, waveval(), calclte(); int i,converg = FALSE; long pickstep(); struct device *devptr;   storedpts++;   for(;;) { K     newtime->time = ltestep + present->time;   /* Compute the next time. */ K     alpha0 = 2/(ltestep * mrt);   /* Compute the alpha0 for trapazoidal. */ ,   /* Get the input voltages at this time. */=     for(i=subptr->external; i<0; i++) newtime->nodevolt[i] =  1 		waveval(subptr->inwavearray[i], newtime->time); ?   /* Get the predictor and evalute old stuff for trap rule.. */ &     for(i=1; i <= subptr->size; i++) {H       oldstuff[i] = present->current[i] - (alpha0 * present->charge[i]);E       a0 = present->nodevolt[i];     /* Generate a poly predictor. */ ?       a1 = (a0 - old->nodevolt[i])/(present->time - old->time);        a2 = (
   	     (a1 - A        (  (a0 - old2->nodevolt[i])/(present->time - old2->time) )                     )*              / (old->time - old2->time) );I       newtime->nodevolt[i] = a0 + ( ((a2*(newtime->time - old->time))+a1) + 					 * (newtime->time - present->time)  ); *       predictor[i] = newtime->nodevolt[i];     } 2   /* Hand it all to the newton method to solve. */I     converg = newton(alpha0, newtime->charge, newtime->current, oldstuff, ) 					    newtime->nodevolt, rhs, subptr); 4   /* Compute the next try at an integration step. */M     if(ltestep <= minstep) { /* No smaller timestep left. Calc lte and go. */ I       lteratio = calclte(predictor, newtime, present, old, old2, subptr); 3       break; /* No smaller step to use so leave. */      }      else if(converg == FALSE) {        ltestep /= 4;        nonconverged++;      } 
     else {I       lteratio = calclte(predictor, newtime, present, old, old2, subptr); L       if(lteratio >= 1.0) break; /* Newton converged, lte fine, so leave. */H       else ltestep = pickstep(lteratio, ltestep, present->time, subptr);     }    }   E /* Make sure newton converged and if so return predicted timestep. */    if(converg == TRUE) { G     subptr->offset = storewave(subptr->newtime, subptr->offset,subptr);       subptr->lteratio = lteratio;?     return( pickstep(lteratio,ltestep,newtime->time, subptr) );    } +   else newterr(subptr, ltestep, predictor);  }   C /* Note lteratio is bounded above by upstepratio cubed, below by */  /* 1.0/downstepratio. */> double calclte(predictor, newtime, present, old, old2, subptr)1 struct timepoint *present, *newtime, *old, *old2;  double *predictor; struct subcircuit *subptr; {  int i; double maxvolt,verr, temp; /*   printf("pred ");E   for(i = 1; i <= subptr->size; i++) { printf("%g ", predictor[i]); }    printf("\n");    printf("new "); M   for(i = 1; i <= subptr->size; i++) { printf("%g ", newtime->nodevolt[i]); }    printf("\n"); !   printf("lteratio =%g\n", temp);  */C   for(i = 1 , maxvolt = 0.0 , verr = 0.0; i <= subptr->size; i++) { 0     temp = 0.33 * ( (dabs(newtime->nodevolt[i]))? 	 	+ (dabs(present->nodevolt[i])) + (dabs(old->nodevolt[i])) ); !     maxvolt = max(temp, maxvolt); 5     temp = dabs(newtime->nodevolt[i] - predictor[i]);      verr = max(temp, verr);    }    if(verr > FUZZ) { E   /* 2nd order integration trunc error, with factor of 2 for trap. */ K     temp = ((lterel*maxvolt + lteabs) * (newtime->time - old2->time) * 2.0)             /- 	   (verr * (newtime->time - present->time)); !     temp = min(temp, step3ratio); (     temp = max(temp, 1.0/downstepratio);   }    else temp = step3ratio;    return(temp);  }   D /* Pickstep takes the cube root of the lteratio, and uses that to */ /* predict the next step. */   extern double cuberoot[];   3 long pickstep(lteratio, prevstep, prestime, subptr)  double lteratio; long prevstep, prestime; struct subcircuit *subptr; { 4 double dtemp, vdiff, dvdt, indvdt, nowvolt, newvolt;1 long tempstep, chngtime, newinstep, instep, temp;  struct waveform *pw; int i,j,tindex;   C /* First check on the local truncation error predicted timestep. */ 2   lteratio = cuberoot[ (int) (100.0 * lteratio) ];8   if(lteratio < 1.0) { /* Reduce timestep due to lte. */+     tempstep = (0.7 * lteratio) * prevstep; " /* Bound reduction of timestep. */5     tempstep = max(tempstep, prevstep/downstepratio);    } ,   else { /* Increase timestep due to lte. */<     tempstep = prevstep + 0.9 * prevstep * (lteratio - 1.1);   }       M /* For predicted timesteps, get minimum of the input waveforms timesteps.  */ D /* Note that wavepos leaves last loc pointing to point just after */ /* prestime. */ A   if(prestime == subptr->newtime->time) { /* A predicted step. */ =     for(instep = tempstep , i=subptr->external; i < 0; i++) { "       pw = subptr->inwavearray[i];*       pw->lastloc = wavepos(pw, prestime);G       if(pw->wavetype == USERSRC) { /* Step on the input breakpoint. */ %         temp = pw->time[pw->lastloc]; @         if((temp == prestime) && (pw->lastloc < pw->wavesize)) {+           temp = pw->time[pw->lastloc + 1];            if(temp > prestime) { N             dtemp = dabs(pw->voltage[pw->lastloc+1]-pw->voltage[pw->lastloc]);              if(dtemp > nralpha) @ 		instep = min(instep, ((0.01* nralpha/dtemp)*(temp-prestime)));           } 	         }          if(temp > prestime) { F           if( (instep + prestime) >= temp) instep = (temp - prestime);N           else if((instep+instep+prestime)>temp)instep = (temp-prestime)/2 +1;	         }        } +       else { /* Not a user input source. */ 7         if(pw->lastloc < pw->wavesize) (pw->lastloc)++; 7         if(pw->lastloc < pw->wavesize) (pw->lastloc)++; 7         if(pw->lastloc < pw->wavesize) (pw->lastloc)++; 7         if(pw->lastloc < pw->wavesize) (pw->lastloc)++; O         if(prestime < pw->time[pw->lastloc]) { /* not a prev iteration wave. */ 2           temp = pw->time[pw->lastloc] - prestime;%           instep = min(instep, temp); 	         }        }      } %     tempstep = min(instep, tempstep);    }   C /* Adjust the timestep to match the previous iteration timestep. */  /*5   if(subptr->waveptrarray[1]->present->itercnt > 2) { +     pw = subptr->waveptrarray[1]->previous; <     pw->lastloc = tindex = wavepos(pw, prestime + tempstep);5     if( ((prestime + tempstep) < pw->time[tindex]) && 2 		((prestime + tempstep) > pw->time[tindex-1]) ) {C       if( (prestime + tempstep - tempstep/5) < pw->time[tindex-1] ) - 				tempstep = pw->time[tindex-1] - prestime; F       else if( (prestime + tempstep + tempstep/5) > pw->time[tindex] )+ 				tempstep = pw->time[tindex] - prestime;      }    }  */ /*(   printf("t=%g prev=%g lte=%g in=%g\n", @ 		prestime * mrt, prevstep * mrt,  tempstep * mrt,instep * mrt); */  , /* Bound timestep by maxstep and minstep. */$   tempstep = min(tempstep, maxstep);$   tempstep = max(minstep, tempstep);  7 /* Make sure to step carefully on window boundaries. */ *   if( (tempstep + prestime) >= stoptime ) $ 			tempstep = (stoptime - prestime);7   else if((tempstep + tempstep + prestime) > stoptime ) * 			tempstep = (stoptime - prestime)/2 + 1;  ) /*  printf("rt=%g\n", tempstep * mrt); */    return(tempstep);  }     # newterr(subptr, ltestep, predictor)  struct subcircuit *subptr;
 long ltestep;  double *predictor; {  int i;-    printf("ERROR. Newton nonconvergence.\n"); 1    printf("Simulation time =%g, Timestep= %g\n",  3 			(subptr->newtime->time * mrt), (ltestep * mrt)); #    printf("Computed waveforms.\n"); N    for(i=1; i <= subptr->size; i++) diswave(subptr->waveptrarray[i]->present);     printf("Input waveforms.\n");E    for(i=subptr->external; i<0; i++) diswave(subptr->inwavearray[i]); )    printf("offset=%d\n", subptr->offset); 5    printf("Offending subcircuit\n"); ldissub(subptr); C    printf("predicted nodevolt\n"); disvect(predictor,subptr->size); N    printf("New=\n"); distimept(subptr->newtime,subptr->size,subptr->external);N    printf("Pres=\n");distimept(subptr->present,subptr->size,subptr->external);K    printf("Old =\n"); distimept(subptr->old,subptr->size,subptr->external); M    printf("Old2 =\n"); distimept(subptr->old2,subptr->size,subptr->external);     exit(0);  }        /* Random Junk. */  E /* 2nd: check all the inputs, and bound timestep by input changes. */ F /* Waveval leaves lastloc pointing to the point after the passed time.:   if(prestime != subptr->newtime->time) instep = prevstep;	   else {  =     for(instep = tempstep , i=subptr->external; i < 0; i++) {        pw = subptr->inwave[i]; 1       nowvolt = waveval(pw, (prestime + instep)); -       newvolt = subptr->newtime->nodevolt[i]; 5       dvdt = (newvolt - subptr->present->nodevolt[i])                        / 7  	     (subptr->newtime->time - subptr->present->time); +       indvdt =  (nowvolt - newvolt)/instep;        if(TRUE) {  B 	/* dabs(indvdt) > dabs(dvdt)) { /* Mag of input dvdt increasing. )         vdiff = (indvdt - dvdt) * instep; ,         if(dabs(vdiff) > (0.5 * nralpha) ) {-           for(j = (pw->lastloc - 1); ; j--) { )             if(pw->time[j] <= prestime) { 4  	      indvdt = (pw->voltage[j+1] - pw->voltage[j]) 				/ 0  	       	        (pw->time[j+1] - pw->time[j]);:               dtemp = dabs(indvdt - dvdt)/(0.5 * nralpha);(               if(dtemp > (1.0/instep)) {(                 newinstep = 1.0 / dtemp;) 	        instep = min(instep, newinstep);  	      }               break;
             }              else {N        	      vdiff = pw->voltage[j] -(newvolt+ dvdt*(pw->time[j] -prestime));1               if(dabs(vdiff) < (0.5 * nralpha)) { 5                 newinstep = (pw->time[j] - prestime); ) 	        instep = min(instep, newinstep);                  break; 	      }
             }            } 	         }        }      }    }  */