> /* The routines in this section solve for the mosfet device */C /* drain current and small signal parameters (e.g. the Jacobian) */ / /* for Ping Yang / Pallab Chatterjee models. */      #include <stdio.h> #include <math.h>  #include "simconst.h"  #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h" #include "ipstruct.h"  #include "mosdiode.h"     ? /* Compute the MOS currents and charges, but no derivatives. */ # rpmti(fptr, nvolt, current, charge) ! double *current, *charge, *nvolt;  register struct fetti *fptr; { 2 double vttmp, vds, vgs, vbs, ir, type, tijustid();     type = fptr->mptr->type;  $ /* Compute the terminal voltages. */9   vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); C   if (vds < 0.0) { /* If vds < 0.0 swap drain and source  nodes. */      tiswapds (fptr);;     vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);    } 9   vgs = type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); 9   vbs = type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);   1   vttmp = tijustid(fptr, vgs, vbs, vds, current); C   if (dcflag == FALSE) tijustq(fptr, vgs, vbs, vds, vttmp, charge);   # /* Put in parasitic resistances. */ #   if(fptr->sxnode != fptr->snode) { ?     ir = fptr->gs * (nvolt[fptr->sxnode] - nvolt[fptr->snode]); 5     if(fptr->sxnode > 0) current[fptr->sxnode] += ir; 3     if(fptr->snode > 0) current[fptr->snode] -= ir;    } #   if(fptr->dxnode != fptr->dnode) { ?     ir = fptr->gd * (nvolt[fptr->dxnode] - nvolt[fptr->dnode]); 5     if(fptr->dxnode > 0) current[fptr->dxnode] += ir; 3     if(fptr->dnode > 0) current[fptr->dnode] -= ir;    }  }     , putmti(fptr, nvolt, current, charge, alpha0)) double *charge, *current, *nvolt, alpha0;  register struct fetti *fptr; { ; double vds, vgs, vbs, type, vttmp, dvtdvbs, ir, ticompid();      type = fptr->mptr->type;  9   vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); B   if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */      tiswapds(fptr);<      vds = type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);   } 9   vgs = type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); 9   vbs = type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);   ;   vttmp = ticompid(fptr, vgs, vbs, vds, &dvtdvbs, current); L   if(dcflag == FALSE) ticompq(fptr,vgs,vbs,vds,vttmp,dvtdvbs,charge,alpha0);  % /* Now place in linear parasitics. */ #   if(fptr->sxnode != fptr->snode) { ?     ir = fptr->gs * (nvolt[fptr->sxnode] - nvolt[fptr->snode]);      if(fptr->sxnode > 0) {"       current[fptr->sxnode] += ir;#       *(fptr->matsxsx) += fptr->gs;        if(fptr->snode > 0) { $         current[fptr->snode] -= ir; $         *(fptr->matss) += fptr->gs; %         *(fptr->matsxs) -= fptr->gs;  $         *(fptr->matssx) -= fptr->gs;       }      }      else if(fptr->snode > 0) {"       current[fptr->snode] -= ir; "       *(fptr->matss) += fptr->gs;      }    } #   if(fptr->dxnode != fptr->dnode) { ?     ir = fptr->gd * (nvolt[fptr->dxnode] - nvolt[fptr->dnode]);      if(fptr->dxnode > 0) {"       current[fptr->dxnode] += ir;#       *(fptr->matdxdx) += fptr->gd;        if(fptr->dnode > 0) { $         current[fptr->dnode] -= ir; $         *(fptr->matdd) += fptr->gd; %         *(fptr->matdxd) -= fptr->gd;  $         *(fptr->matddx) -= fptr->gd;       }      }      else if(fptr->dnode > 0) {"       current[fptr->dnode] -= ir; "       *(fptr->matdd) += fptr->gd;      }    }  }   ) /* Drain-source node swapping routine. */  tiswapds(fptr) register struct fetti *fptr; { 
 double tempd;  register double *ptempd;	 int temp; D   temp = fptr->dnode; fptr->dnode = fptr->snode; fptr->snode = temp;H   temp = fptr->dxnode; fptr->dxnode = fptr->sxnode; fptr->sxnode = temp;>   tempd = fptr->cgs; fptr->cgs = fptr->cgd; fptr->cgd = tempd;B   tempd = fptr->isas; fptr->isas = fptr->isad; fptr->isad = tempd;B   tempd = fptr->cjas; fptr->cjas = fptr->cjad; fptr->cjad = tempd;F   tempd = fptr->cjass; fptr->cjass = fptr->cjasd; fptr->cjasd = tempd;:   tempd = fptr->gs; fptr->gs = fptr->gd; fptr->gd = tempd;H   ptempd = fptr->matdd; fptr->matdd = fptr->matss; fptr->matss = ptempd;N   ptempd= fptr->matdxdx; fptr->matdxdx = fptr->matsxsx; fptr->matsxsx =ptempd;J   ptempd= fptr->matdxd; fptr->matdxd = fptr->matsxs; fptr->matsxs =ptempd;J   ptempd= fptr->matddx; fptr->matddx = fptr->matssx; fptr->matssx =ptempd;H   ptempd = fptr->matds; fptr->matds = fptr->matsd; fptr->matsd = ptempd;H   ptempd = fptr->matdg; fptr->matdg = fptr->matsg; fptr->matsg = ptempd;H   ptempd = fptr->matdb; fptr->matdb = fptr->matsb; fptr->matsb = ptempd;H   ptempd = fptr->matgd; fptr->matgd = fptr->matgs; fptr->matgs = ptempd;I   ptempd = fptr->matbd; fptr->matbd = fptr->matbs; fptr->matbs = ptempd;   }      E /* Solves the resistive nonlinearity but computes no conductances. */ - double tijustid(fptr, vgs, vbs, vds, current)   double vds, vgs, vbs, *current;  register struct fetti *fptr; { 7 double apg, sqdapg, vdsat, xmob, clmod, barid, sqdvgst, E        sqrtvbsphi, vgst, vttmp, vtprim, id, temp1, temp2, bet, vfb0,  &        sqrtvds, vbd, ibs=0.0, ibd=0.0,        sqrt(), exp(); ! register struct inmtimodel *mptr;  register struct mosdiode *dptr;      mptr = fptr->mptr;   dptr = mptr->djunc;  /* First do the diodes. */2   mosrdiodei(ibs,vbs,fptr->isas,fptr->svmax,dptr);   vbd = vbs - vds;2   mosrdiodei(ibd,vbd,fptr->isad,fptr->dvmax,dptr);   /* Now back to the mosfet. */ B /* Bound vds away from zero to fix noncont diff. model. Blecch. */   sqrtvds = max(vds, nrvabs);      sqrtvds = sqrt(sqrtvds);  #   sqrtvbsphi = mptr->twophif - vbs;   1 /* If vbs < 2phif - nrvabs, everything is okay */    if(sqrtvbsphi > nrvabs) { "     sqrtvbsphi = sqrt(sqrtvbsphi);  7     vttmp = mptr->fixvto + (mptr->gamma * sqrtvbsphi);    K /* No need to continue computing drain current if drain and source nodes */ 6 /* are not in this subcircuit, or if tied together. */N     if( ((fptr->dnode<=0)&&(fptr->snode<=0)) ||	(fptr->snode==fptr->dnode) ) {       id = 0.0;        goto stuffit;      }   ,     temp2 = sqrt(mptr->twophif + vds - vbs);&     temp1 = temp2 - mptr->sqrttwophif;,     vtprim = (vttmp - (mptr->de * sqrtvds)) & 				- (mptr->cf * temp1 * sqrtvbsphi);     vgst = (vgs - vtprim);   } 2 /* If vbs is too close to 2phif fix it. Blecch. */	   else {       temp1 = sqrt(nrvabs);   3     vttmp = (mptr->fixvto + (mptr->gamma * temp1));   K /* No need to continue computing drain current if drain and source nodes */ 6 /* are not in this subcircuit, or if tied together. */N     if( ((fptr->dnode<=0)&&(fptr->snode<=0)) ||	(fptr->snode==fptr->dnode) ) {       id = 0.0;        goto stuffit;      }        temp2 = sqrt(vds + nrvabs); -     vtprim = (vttmp - (mptr->de * sqrtvds)) - 4 			(mptr->cf * (temp2 - mptr->sqrttwophif) * temp1);     vgst = vgs - vtprim;   }   D /* If the drain and source nodes are not part of this subcircuit, */6 /* we left this routine just after computing vttmp. */     /* Cutoff region. */     if(vgst <= 0) {      /* No Subthresh. */ &       if(fptr->betas == 0.0) id = 0.0;     /* Subthresh. */       else {,         vfb0 = mptr->fixvto - mptr->twophif;-         if( (mptr->twophif - vbs) < nrvabs )  K           temp1 = ((vgs-vfb0) - mptr->twophif) + nrvabs + mptr->de*sqrtvds; ?         else temp1 = ((vgs - vfb0) - vbs) - mptr->de * sqrtvds;          if(temp1 >= 0) {C           bet = mptr->gamma - mptr->cf * (temp2-mptr->sqrttwophif); /           id = fptr->betas * exp(mptr->xng * (     			vgs - vfb0 - mptr->twophif  			+ (mptr->de * sqrtvds) 4 			+ (bet*0.5*( bet - sqrt(bet*bet + (4.0*temp1)) )) 			      		     )); "           temp1 = mptr->xng * vds;5           if(temp1 <= MAXEXP) id -= id * exp(-temp1); 	         } D         else { /* If vgs-vfb0-vbs-de*sqrt(vds) < 0 assume it = 0. */4           temp1 = mptr->xng * (vbs - mptr->twophif);<           if(temp1 > -MAXEXP) id = fptr->betas * exp(temp1);           else id = 0.0;"           temp1 = mptr->xng * vds;4           if(temp1 < MAXEXP) id -= id * exp(-temp1);	         }        }      } &   /* Saturation and linear Regions. */
     else {(     /* Calculate a few useful things. */,       apg = mptr->alpha + mptr->zeta * vgst;       vdsat = vgst / apg; F       xmob = 1.0/( 1.0 + (mptr->theta * vgst) );  /* Safe division. */     /* Linear Region. */       if(vds <= vdsat) {H         barid = fptr->beta * vds * apg * ( (2.0 * vgst) - (apg * vds) );         id = barid * xmob;       }      /* Saturation Region. */       else {         sqdapg = apg * apg;          sqdvgst = vgst * vgst;M         clmod = 1.0 + (mptr->a2lam * (vds - vdsat) / sqdapg); /* Safe div. */ %         barid = fptr->beta * sqdvgst; "         id = barid * xmob * clmod;       } E     /* Add in the subthresh component (to make current continous). */        if(fptr->betas != 0.0) {          temp1 = mptr->xng * vds;D         if(temp1 <= MAXEXP) id += fptr->betas * ( 1 - exp(-temp1) );         else id += fptr->betas;        }      }    stuffit:   /* Stuff the current. */H     if(fptr->dnode > 0) current[fptr->dnode] += mptr->type * (id - ibd);H     if(fptr->snode > 0) current[fptr->snode] -= mptr->type * (id + ibs);I     if(fptr->bnode > 0) current[fptr->bnode] += mptr->type * (ibd + ibs);      return(vttmp); }     8 /* The full Ping-Yang/Pallab Chatterjee Charge model. */+ tijustq(fptr, vgs, vbs, vds, vttmp, charge) % double vds, vgs, vbs, vttmp, *charge;  register struct fetti *fptr; { A double qg, qb, qd, qs, qbsj, qbdj, vbd, vfb0, vfbx, vgst, alphax, 8        temp1, temp2, temp3, temp4, exp(), log(), sqrt();! register struct inmtimodel *mptr;  register struct mosdiode *dptr;      mptr = fptr->mptr;   vbd = vbs - vds;     dptr = mptr->djunc; *   mosrdiodeq(qbsj, vbs, fptr->cjas, dptr);*   mosrdiodeq(qbdj, vbd, fptr->cjad, dptr);   dptr = mptr->dsw; ;   mosrdiodeq(temp1, vbs, fptr->cjass, dptr); qbsj += temp1; ;   mosrdiodeq(temp1, vbd, fptr->cjasd, dptr); qbdj += temp1;    /* Back to the mosfet. */ &   vfb0 = mptr->fixvto - mptr->twophif;/ /* Fix case where vbs is too close to 2phif. */ J   if((mptr->twophif - vbs) < nrvabs) vfbx = vfb0 + mptr->twophif - nrvabs;   else vfbx = vfb0 + vbs;  /* Cutoff region. */   if(vgs <= vfbx) { "     qg = fptr->cgsub * (vgs-vfbx);     qb = - (qg);     qd = 0.0; 
     qs = 0.0;    } , /* Weak inversion or subthreshold region. */   else if(vgs <= vttmp) { G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma);      qb = - ( qg );
     qd = 0.0; 
     qs = 0.0;    } ; /* Now handle as a special case when vds is precisely 0. */ H /* This was done to optimize runtime by pulling out this simple case. */   else if(vds == 0) { ,     qg = fptr->cgsub * (vgs - mptr->fixvto);.     qb = fptr->cgsub * (mptr->fixvto - vttmp);1     qd = - ( fptr->cgsub * 0.5 * (vgs - vttmp) );      qs = qd;   }   $ /* Linear and Saturation Regions. */   else {/   /* First precalculate a few useful things. */      vgst = vgs - vttmp; -     alphax = mptr->alpha + mptr->zeta * vgst;   +  /* The linear region.  God what a mess! */ *     if( vgs > ((alphax * vds) + vttmp) ) {!       temp1 = alphax * vds * 0.5; ,       temp2 = 1.0 / (12.0 * (vgst - temp1));!       temp3 = alphax * vds * vds;        temp4 = 0.5 * vds;L       qg = fptr->cgsub*( ((vgs - mptr->fixvto) - temp4) + (temp3 * temp2) );5       qb = fptr->cgsub * (  (mptr->fixvto - vttmp) +  > 		            ( (1.0 - alphax) * (temp4 - (temp3*temp2)) )  );N       qd = fptr->cgsub * ((1.5*temp1) - (0.5*vgst) - (temp1*temp1*6.0*temp2));       qs = - (qg + qb + qd);     } ( /* And finally the saturation region. */
     else {       temp1 = 1.0/alphax; C       qg = fptr->cgsub*( (vgs-mptr->fixvto) - (vgst*temp1 / 3.0) );        qd = 0.0; M       qb = fptr->cgsub*( (mptr->fixvto - vttmp) + (vgst * (temp1-1.0)/3.0) );        qs = - (qg + qb);      }    }   ( /* Add in the junction diode charges. */   qb += qbdj + qbsj;
   qs -= qbsj; 
   qd -= qbdj;   , /* And stuff the charges into the vector. */M   if(fptr->snode>0) charge[fptr->snode] += mptr->type * (qs-(fptr->cgs*vgs)); +   if(fptr->dnode>0) charge[fptr->dnode] +=  . 		mptr->type * (qd+(fptr->cgd * (vds - vgs)));+   if(fptr->gnode>0) charge[fptr->gnode] +=  ? 		mptr->type * (qg  + (fptr->cgs*vgs) + (fptr->cgd*(vgs-vds))); ;   if(fptr->bnode>0) charge[fptr->bnode] += mptr->type * qb;  }   B /* In order to make model changes a little easier, and the code *// /* a little more interpretable, I followed this C /* approach.  Basically, the threshold voltage is differentiated */ C /* with respect to vds, and vbs (stored in dvtdvds and dvtdvbs). */ K /* Then where appropriate, this is multplied by dIdrain/d(vgs-vt) = gmgs */  /* to get other derivatives. */ 6 double ticompid(fptr,vgs, vbs, vds, pdvtdvbs, current)* double vds, vgs, vbs, *pdvtdvbs, *current; register struct fetti *fptr; { E double apg, sqdapg, vtprim, vdsat, xmob, clmod, barid, sqdvgst,vttmp, !        sqrtvds, dvtdvbs, dvtdvds, 9        sqrtvbsphi, vgst, id, temp1, temp2, temp3, temp4,  2        bet, sqbet, betvbs, vfb0, gmgs, gmbs, gmds,/        vbd, ibd=0.0, gbd=0.0, ibs=0.0, gbs=0.0,         exp(), log(), sqrt();! register struct inmtimodel *mptr;  register struct mosdiode *dptr;      mptr = fptr->mptr;  - /* Mosfet diode currents and conductances. */    dptr = mptr->djunc; 4   mosdiodei(gbs,ibs,vbs,fptr->isas,fptr->svmax,dptr)   vbd = vbs - vds;4   mosdiodei(gbd,ibd,vbd,fptr->isad,fptr->dvmax,dptr)   /* Back to the mosfet. */ B /* Bound vds away from zero to fix noncont diff. model. Blecch. */   sqrtvds = max(vds, nrvabs);      sqrtvds = sqrt(sqrtvds);  #   sqrtvbsphi = mptr->twophif - vbs;     /* First region, vbs < 2phif. */   if(sqrtvbsphi > nrvabs) { "     sqrtvbsphi = sqrt(sqrtvbsphi);6     vttmp = mptr->fixvto + (mptr->gamma * sqrtvbsphi);1     *pdvtdvbs = mptr->gamma / (2.0 * sqrtvbsphi);   K /* No need to continue computing drain current if drain and source nodes */ 6 /* are not in this subcircuit, or if tied together. */N     if( ((fptr->dnode<=0)&&(fptr->snode<=0)) ||	(fptr->snode==fptr->dnode) ) {2       id = 0.0; gmbs =0.0; gmds = 0.0; gmgs = 0.0;       goto condstuffit;      }   ,     temp2 = sqrt(mptr->twophif + vds - vbs);&     temp1 = temp2 - mptr->sqrttwophif;,     vtprim = (vttmp - (mptr->de * sqrtvds)) & 				- (mptr->cf * temp1 * sqrtvbsphi);       vgst = (vgs - vtprim);H     if(vgst > 0) { /* Don't bother computing these if device cut off. */8       dvtdvbs = (mptr->gamma /(sqrtvbsphi + sqrtvbsphi)) 		  - (mptr->cf * C 	((temp1/(sqrtvbsphi + sqrtvbsphi)) + sqrtvbsphi/(temp2 + temp2))); 3       dvtdvds = (mptr->de / (sqrtvds + sqrtvds)) +  / 		   (mptr->cf * sqrtvbsphi / (temp2 + temp2));      }    }   2 /* If vbs is too close to 2phif fix it. Blecch. */	   else {       temp1 = sqrt(nrvabs); 3     vttmp = (mptr->fixvto + (mptr->gamma * temp1));      *pdvtdvbs = 0.0;  K /* No need to continue computing drain current if drain and source nodes */ 6 /* are not in this subcircuit, or if tied together. */N     if( ((fptr->dnode<=0)&&(fptr->snode<=0)) ||	(fptr->snode==fptr->dnode) ) {2       id = 0.0; gmbs =0.0; gmds = 0.0; gmgs = 0.0;       goto condstuffit;      }        temp2 = sqrt(vds + nrvabs); -     vtprim = (vttmp - (mptr->de * sqrtvds)) - 4 			(mptr->cf * (temp2 - mptr->sqrttwophif) * temp1);       vgst = vgs - vtprim;     dvtdvbs = 0.0;>     if(vgst > 0) dvtdvds = (mptr->de / (sqrtvds + sqrtvds)) + ) 				(mptr->cf * temp1 / (temp2 + temp2));    }   
 /* Cutoff. */    if(vgst <= 0) { 1     if(fptr->betas == 0.0) {  /* No subthresh. */ .       gmgs = 0.0; gmbs =0.0; gmds=0.0; id=0.0;     } "     else { /* Subthresh region. */*       vfb0 = mptr->fixvto - mptr->twophif;+       if( (mptr->twophif - vbs) < nrvabs )  B 	temp1 = ((vgs-vfb0) - mptr->twophif) + nrvabs + mptr->de*sqrtvds;=       else temp1 = ((vgs - vfb0) - vbs) - mptr->de * sqrtvds;        if(temp1 >= 0) {&         betvbs=mptr->cf/(temp2+temp2);A         bet = mptr->gamma - mptr->cf * (temp2-mptr->sqrttwophif);          sqbet = bet * bet;,         temp2 = sqrt( sqbet + (4 * temp1) );-         id = fptr->betas * exp(mptr->xng * (  ! 				vgs - vfb0 - mptr->twophif +  / 				(mptr->de * sqrtvds) + (bet*.5*(bet-temp2))  			      		     ));           temp1 = mptr->xng * vds;         if(temp1 <= MAXEXP) {  	  temp3 = id * exp(-temp1);  #           gmds = temp3 * mptr->xng;            id -= temp3; 	} else gmds = 0.0;          temp3 = mptr->xng * id; "         temp4 = temp3 * bet/temp2;         gmgs = temp3 - temp4; "         gmds += temp3 * betvbs * (1 			(1.0 - bet/temp2) * mptr->de/(sqrtvds+sqrtvds) 5 			        + (sqbet + temp1 + temp1)/temp2 - bet   ); -         if( (mptr->twophif - vbs) < nrvabs )  E 	  gmbs=temp4 + temp3 * betvbs * (bet - (sqbet + (2 * temp1))/temp2);          else gmbs = 0.0;       } B       else { /* If vgs-vfb0-vbs-de*sqrt(vds) < 0 assume it = 0. */         gmgs = 0.0; 2         temp1 = mptr->xng * (vbs - mptr->twophif);:         if(temp1 > -MAXEXP) id = fptr->betas * exp(temp1);         else id = 0.0;          temp1 = mptr->xng * vds;         if(temp1 < MAXEXP) { 	  temp2 = id * exp(-temp1); 	  gmds = temp2 * mptr->xng;           id -= temp2;	         }          else gmds = 0.0;7         if( (mptr->twophif - vbs) < nrvabs) gmbs = 0.0; #         else gmbs = mptr->xng * id;        }      }    } $ /* Saturation and linear Regions. */   else {&   /* Calculate a few useful things. */*     apg = mptr->alpha + mptr->zeta * vgst;     vdsat = vgst / apg; D     xmob = 1.0/( 1.0 + (mptr->theta * vgst) );  /* Safe division. */   /* Linear Region. */     if(vds <= vdsat) {F       barid = fptr->beta * vds * apg * ( (2.0 * vgst) - (apg * vds) );       id = barid * xmob;       gmgs = xmob * (  		(2.0 * fptr->beta * vds * ? 	 ( (apg * (1.0 - (mptr->zeta * vds))) + (mptr->zeta * vgst) ))  		 - mptr->theta * id);        gmds = (gmgs * dvtdvds) : 		 + ( 2.0 * fptr->beta * xmob * apg * (vgst - apg*vds) );       gmbs = gmgs * dvtdvbs;     }    /* Saturation Region. */
     else {       sqdapg = apg * apg;        sqdvgst = vgst * vgst;K       clmod = 1.0 + (mptr->a2lam * (vds - vdsat) / sqdapg); /* Safe div. */ #       barid = fptr->beta * sqdvgst;         id = barid * xmob * clmod;       gmgs = xmob * + 		( (  (2.0 * fptr->beta * vgst * clmod) -  5 		     (barid * ( (mptr->a3lam / (sqdapg * sqdapg)) + 6 			    ((vds-vdsat) * mptr->a2lamg / (apg * sqdapg)))) 		  )  - (mptr->theta * id) );F       gmds = (gmgs * dvtdvds) + ((xmob * barid * mptr->a2lam)/sqdapg);       gmbs = (gmgs * dvtdvbs);     } C   /* Add in the subthresh component (to make current continous). */      if(fptr->betas != 0.0) {       temp1 = mptr->xng * vds;       id += fptr->betas;       if(temp1 <= MAXEXP) { *         temp1 = fptr->betas * exp(-temp1);         id -= temp1;"         gmds += mptr->xng * temp1;       }      }    }  /*2   printf("vgs=%g vds=%g vbs=%g\n", vgs, vds, vbs);0   printf("id=%g ibd=%g ibs=%g\n", id, ibd, ibs); */   condstuffit:* /* Stuff the currents and conductances. */   if(fptr->bnode > 0) { 5     current[fptr->bnode] += mptr->type * (ibd + ibs); !     *(fptr->matbb) += gbd + gbs;     } @   if(fptr->dnode > 0) { /* Put the drain row into the matrix. */#     *(fptr->matdd) += (gmds + gbd); 4     current[fptr->dnode] += mptr->type * (id - ibd);N     if(fptr->bnode>0) { *(fptr->matdb) += gmbs - gbd; *(fptr->matbd) -= gbd; }-     if(fptr->gnode>0) *(fptr->matdg) += gmgs; 9     if(fptr->snode>0) *(fptr->matds) -= (gmgs+gmbs+gmds);    } A   if(fptr->snode > 0) { /* Put the source row into the matrix. */ /     *(fptr->matss) += gmds + gmbs + gmgs + gbs; 4     current[fptr->snode] -= mptr->type * (id + ibs);N     if(fptr->bnode>0) { *(fptr->matbs) -= gbs; *(fptr->matsb) -= (gbs+gmbs); }-     if(fptr->gnode>0) *(fptr->matsg) -= gmgs; -     if(fptr->dnode>0) *(fptr->matsd) -= gmds;    }        return(vttmp); }   8 /* The full Ping-Yang/Pallab Chatterjee Charge model. */: ticompq(fptr,vgs, vbs, vds, vth, dvthdvbs, charge, alpha0)5 double vds, vgs, vbs, vth, dvthdvbs, *charge, alpha0;  register struct fetti *fptr; {  double qd, qg, qs, qb,$        cdg, cds, cdb, cgd, cgs, cgb,$        csd, csg, csb, cbd, cbg, cbs,-        vbd, vfb0, vfbx, vgst, vgsat, alphax,  K        temp, temp1, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9, /        temp10, temp11, temp12, temp14, temp15,          qbdj, cbdj, qbsj, cbsj,        sqrt();! register struct inmtimodel *mptr;  register struct mosdiode *dptr;      mptr = fptr->mptr;   vbd = vbs - vds;7 /* First compute the diode charges and capacitances. */    dptr = mptr->djunc; /   mosdiodeq(cbsj, qbsj, vbs, fptr->cjas, dptr); /   mosdiodeq(cbdj, qbdj, vbd, fptr->cjad, dptr);    dptr = mptr->dsw; L   mosdiodeq(temp1,temp2,vbs,fptr->cjass,dptr); cbsj += temp1; qbsj += temp2;L   mosdiodeq(temp1,temp2,vbd,fptr->cjasd,dptr); cbdj += temp1; qbdj += temp2;   /* Back to the Mosfet. */ &   vfb0 = mptr->fixvto - mptr->twophif;  + /* Fix case where vbs goes too positive. */ I   if( (mptr->twophif-vbs) < nrvabs) vfbx = vfb0 + mptr->twophif - nrvabs;    else vfbx = vfb0 + vbs;    /* Cutoff region. */   if(vgs <= vfbx) { "     qg = fptr->cgsub * (vgs-vfbx);     qb = - (qg);     qd = 0.0; 
     qs = 0.0; /     cgd = 0.0; cdb = 0.0; cds = 0.0; cdg = 0.0; %     csd = 0.0; csb = 0.0; csg = 0.0;       cbd = 0.0; cbs = 0.0; D   /* Again deal oddly with the problem of vbs too close to 2phif. */*     if( (mptr->twophif - vbs)  < nrvabs) {-       cbg = 0.0; cgb =0.0; cgs = fptr->cgsub;      } else {6       cbg = fptr->cgsub; cgb = fptr->cgsub; cgs = 0.0;     }    }   , /* Weak inversion or subthreshold region. */   else if(vgs <= vth) { G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma);      qb = - ( qg );
     qd = 0.0; 
     qs = 0.0; 0     cgd = 0.0; cdb = 0.0; cds = 0.0; cdg = 0.0; /     csb = 0.0; csd = 0.0; cbd = 0.0; cbs = 0.0; D   /* Again deal oddly with the case where vbs too close to 2phif. */(     if((mptr->twophif - vbs) < nrvabs) {       cbg = 0.0; cgb = 0.0; .       cgs = (fptr->cgsub * mptr->gamma)/temp1;       csg = cgs;     } else {.       cgb = (fptr->cgsub * mptr->gamma)/temp1;       cbg = cgb;       cgs = 0.0; csg = 0.0;      }    }   $ /* Linear and Saturation Regions. */   else {/   /* First precalculate a few useful things. */      vgst = vgs - vth; -     alphax = mptr->alpha + mptr->zeta * vgst; !     vgsat = (alphax * vds) + vth; !     temp9 = vfb0 + mptr->twophif;   :   /* Compute dvthdvbs. Passed in from drain current calc. :     if( (mptr->twophif - vbs) < nrvabs)  dvthdvbs = 0.0;		H     else dvthdvbs = mptr->gamma / (2.0 * sqrt( (mptr->twophif - vbs) ));   */  =   /* Now handle as a special case when vds is precisely 0. */ J   /* This was done to optimize runtime by pulling out this simple case. */     if(vds == 0.0) {'       qg = fptr->cgsub * (vgs - temp9); '       qb = fptr->cgsub * (temp9 - vth);        cgb = 0.0;       cgs = fptr->cgsub * 0.5;       cgd = cgs;       qd = - ( cgs * vgst );       qs = - (qg + qb + qd);8       cds = cgs * ( ((1.5 * alphax) - 1.0) - dvthdvbs );       cdg = cgd;       cdb = cdg * dvthdvbs; /       cbd = fptr->cgsub * (alphax - 1.0) * 0.5;        cbg = 0.0;<       cbs = fptr->cgsub * (dvthdvbs + (1.0 - alphax) * 0.5);,       csb = ((cbg + cbd + cbs) - cdb) - cgb;,       csd = ((cdg + cds + cdb) - cbd) - cgd;,       csg = ((cgd + cgs + cgb) - cdg) - cbg;     }   +  /* The linear region.  God what a mess! */      else if(vgs > vgsat) {        temp = alphax * vds * 0.5;       temp2 = 1.0/alphax;        temp3 = alphax * alphax;+       temp4 = 1.0 / (12.0 * (vgst - temp)); "       temp5 = temp4/(vgst - temp);       temp6 = vds * vds;"       temp7 = mptr->alpha * temp6;       temp8 = alphax * temp6;        temp10 = 0.5 * vds;        temp11 = 1.0 - alphax;       temp12 = temp * temp; !       temp14 = temp * 4.0 * vgst; #       temp15 = temp10 * mptr->zeta;   H       qg = fptr->cgsub * ( ((vgs - temp9) - temp10) + (temp8 * temp4) );       qb =  C 	fptr->cgsub * ( (temp9 - vth) + temp11*(temp10 - (temp8*temp4)) ); -       cgb = fptr->cgsub*temp7*dvthdvbs*temp5;        cgs = fptr->cgsub * J         (0.5 + (temp14 - ( temp7*(1.0+dvthdvbs)+temp12+temp12 )) * temp5);E       cgd = fptr->cgsub * ( 0.5 + ((temp12+temp12-temp14) * temp5) ); I       qd = fptr->cgsub * ( (1.5*temp) - (0.5*vgst) - (temp12*6.0*temp4));        qs = - (qg + qb + qd);       cds = fptr->cgsub * (  	      (0.75 * alphax) +  8         ( ((1.5 * temp15) - 0.5) * (1.0 + dvthdvbs) ) + M        (( (1.0-temp15)*(1.0+dvthdvbs)-(alphax*0.5) )* temp12 * 6.0 * temp5) - M         (  temp * ((alphax * 0.5) + temp15 * (1.0+dvthdvbs)) * 12.0 * temp4 )  			      );        cdg = fptr->cgsub * (	 		(0.5 - (1.5*temp15))9 	- ((mptr->alpha*temp5 - mptr->zeta*temp4) * temp8 *1.5)   			      );        cdb = dvthdvbs * cdg; G       cbd = -fptr->cgsub * temp11 * (0.5+(temp12+temp12-temp14)*temp5);        cbs = fptr->cgsub * (  		 dvthdvbs + (temp11*0.5)) 		  - ( temp11*(temp14-(temp12+temp12)) +  		      (1.0+dvthdvbs)*temp6*(( 			 (temp3*(1.0+temp15) - mptr->alpha) -8 		  	         (2.0*mptr->zeta*alphax*vgst) ) ) * temp5);!       cbg = fptr->cgsub * (temp15 B 	 - ( temp11*mptr->alpha*temp5 + alphax*mptr->zeta*temp4 )*temp6);,       csb = (cbg + cbd + cbs) - (cdb + cgb);,       csd = (cdg + cds + cdb) - (cbd + cgd);,       csg = (cgd + cgs + cgb) - (cdg + cbg);     }      ( /* And finally the saturation region. */
     else {       temp2 = 1.0/alphax;        temp3 = alphax * alphax;<       qg = fptr->cgsub*( (vgs-temp9) - (vgst*temp2 / 3.0) );       qd = 0.0; B       qb = fptr->cgsub*( (temp9-vth) + (vgst * (temp2-1.0)/3.0) );       qs = - (qg + qb); @       cgb = (fptr->cgsub* mptr->alpha * dvthdvbs) / (3.0*temp3);G       cgs = fptr->cgsub*(1.0 - mptr->alpha*(1.0+dvthdvbs)/(3.0*temp3));        cgd = 0.0;         cdb = 0.0;       cds = 0.0;       cdg = 0.0;%       csg = fptr->cgsub * 0.66666666;        csd = 0.0;0       csb = fptr->cgsub * dvthdvbs * 0.66666666;       cbd = 0.0;       cbs = csg + csb - cgs;       cbg = cgs + cgb - csg;     }    }   0 /* Add in the diode charges and capacitances. */   qb += qbdj + qbsj;
   qs -= qbsj; 
   qd -= qbdj;    cbs += cbsj;   csb += cbsj;   cbd += cbdj;   cdb += cbdj;  H /* And stuff the charges and capacitances into the vector and matrix. */   if(fptr->dnode>0) { I     charge[fptr->dnode] += mptr->type * (qd + (fptr->cgd * (vds - vgs))); =     *(fptr->matdd) += alpha0 * (cds + cdg + cdb + fptr->cgd); 7     if(fptr->bnode>0) *(fptr->matdb) -= (alpha0 * cdb); E     if(fptr->gnode>0) *(fptr->matdg) -= (alpha0 * (fptr->cgd + cdg)); 8     if(fptr->snode>0) *(fptr->matds) -= (alpha0 * cds);    }    if(fptr->snode>0) { A     charge[fptr->snode] += mptr->type * (qs - (fptr->cgs * vgs)); 7     *(fptr->matss) += alpha0 * (csd+csg+csb+fptr->cgs); 8     if(fptr->bnode>0) *(fptr->matsb) -=  (alpha0 * csb);D     if(fptr->gnode>0) *(fptr->matsg) -=  (alpha0*(csg + fptr->cgs));8     if(fptr->dnode>0) *(fptr->matsd) -=  (alpha0 * csd);   }    if(fptr->gnode>0) {      charge[fptr->gnode] +=  > 	mptr->type * (qg  + (fptr->cgs*vgs) + (fptr->cgd*(vgs-vds)));I     *(fptr->matgg) += alpha0 * (cgs + cgd + cgb + fptr->cgs + fptr->cgd); 8     if(fptr->bnode>0) *(fptr->matgb) -=  (alpha0 * cgb);F     if(fptr->dnode>0) *(fptr->matgd) -=  (alpha0 * (cgd + fptr->cgd));F     if(fptr->snode>0) *(fptr->matgs) -=  (alpha0 * (cgs + fptr->cgs));   }    if(fptr->bnode>0) { +     charge[fptr->bnode] += mptr->type * qb; 1     *(fptr->matbb) += alpha0 * (cbg + cbd + cbs); 7     if(fptr->dnode>0) *(fptr->matbd) -= (alpha0 * cbd); 7     if(fptr->gnode>0) *(fptr->matbg) -= (alpha0 * cbg); 7     if(fptr->snode>0) *(fptr->matbs) -= (alpha0 * cbs);    }    }   D /* Optimized routines for the case where only gate in subcircuit. */& tijustrg(fptr, nvolt, current, charge)! double *nvolt, *current, *charge;  register struct fetti *fptr; { ! register struct inmtimodel *mptr;  double vttmp, vds, vgs, vbs; double temp1, vfbx, alphax, qg;  double sqrt();     mptr = fptr->mptr;  $ /* Compute the terminal voltages. */?   vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); C   if (vds < 0.0) { /* If vds < 0.0 swap drain and source  nodes. */      tiswapds (fptr);A     vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);    } ?   vgs = mptr->type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); ?   vbs = mptr->type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);      temp1 = mptr->twophif - vbs;5   if(temp1 > nrvabs) {    /* vbs < 2phif - nrvabs. */ 7     vttmp = mptr->fixvto + (mptr->gamma * sqrt(temp1)); .     vfbx = mptr->fixvto - mptr->twophif + vbs;&   } else {		/* vbs > 2phif - nrvabs */:     vttmp = (mptr->fixvto + (mptr->gamma * sqrt(nrvabs)));!     vfbx = mptr->fixvto - nrvabs;    } F   if(vgs <= vfbx) qg = fptr->cgsub * (vgs-vfbx);  /* Cutoff region. */F   else if(vgs <= vttmp) { /* Weak inversion or subthreshold region. */G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma);    } >   else if(vds == 0.0) qg = fptr->cgsub * (vgs - mptr->fixvto);.   else {  /* Linear and Saturation Regions. */6     alphax = mptr->alpha + mptr->zeta * (vgs - vttmp);@     if( vgs > ((alphax * vds) + vttmp) ) {  /* Linear region. */$       temp1 = (alphax * vds * vds) /5 		 ( 12.0 * ((vgs - vttmp) - (alphax * vds * 0.5)) ); I       qg = fptr->cgsub*( ((vgs - mptr->fixvto) - (0.5 * vds) ) + temp1 );      }   #     else { /* Saturation Region. */ M       qg = fptr->cgsub * ( (vgs-mptr->fixvto) - ((vgs-vttmp)/(alphax*3.0)) );      }    }    charge[fptr->gnode] +=  B 	mptr->type * (qg  + (fptr->cgs * vgs) + (fptr->cgd * (vgs-vds))); }     - tijustg(fptr, nvolt, current, charge, alpha0) ) double alpha0, *nvolt, *current, *charge;  register struct fetti *fptr; { ! register struct inmtimodel *mptr;  double vttmp, vds, vgs, vbs;0 double temp1, temp2, vgst, vfbx, alphax, qg, cg; double sqrt();     mptr = fptr->mptr;  $ /* Compute the terminal voltages. */?   vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]); C   if (vds < 0.0) { /* If vds < 0.0 swap drain and source  nodes. */      tiswapds (fptr);A     vds = mptr->type * (nvolt[fptr->dnode] - nvolt[fptr->snode]);    } ?   vgs = mptr->type * (nvolt[fptr->gnode] - nvolt[fptr->snode]); ?   vbs = mptr->type * (nvolt[fptr->bnode] - nvolt[fptr->snode]);      temp1 = mptr->twophif - vbs;2   if(temp1 < nrvabs) { 	/* vbs > 2phif - nrvabs */?     vgst = vgs - (mptr->fixvto + (mptr->gamma * sqrt(nrvabs))); !     vfbx = mptr->fixvto - nrvabs;    }   '   else {    /* vbs < 2phif - nrvabs. */ @     vgst = vgs - ( mptr->fixvto + (mptr->gamma * sqrt(temp1)) );.     vfbx = mptr->fixvto - mptr->twophif + vbs;   }   (   if(vgs <= vfbx) { /* Cutoff region. */#     qg = fptr->cgsub * (vgs-vfbx);       cg = fptr->cgsub;    } E   else if(vgst <= 0.0) { /* Weak inversion or subthreshold region. */ G     temp1 = sqrt( (mptr->gamma * mptr->gamma) + (4.0 * (vgs - vfbx)) ); A     qg = fptr->cgsub * mptr->gamma * 0.5 * (temp1 - mptr->gamma); +     cg = (fptr->cgsub * mptr->gamma)/temp1;    }    else if(vds == 0.0) { ,     qg = fptr->cgsub * (vgs - mptr->fixvto);     cg = fptr->cgsub;    } .   else {  /* Linear and Saturation Regions. */-     alphax = mptr->alpha + mptr->zeta * vgst; 7     if( vgst > (alphax * vds) ) {  /* Linear region. */ *       temp2 = vgst - (alphax * vds * 0.5);5       temp1 = (alphax * vds * vds) / ( 12.0 * temp2); J       qg = fptr->cgsub*( ((vgs - mptr->fixvto) - (0.5 * vds) ) +  temp1 );       cg = fptr->cgsub* < 	( 1.0 - (mptr->alpha * vds * vds)/(12.0 * temp2 * temp2) );     } #     else { /* Saturation Region. */        qg = fptr->cgsub *5 	( (vgs - mptr->fixvto) - ( vgst  / (alphax*3.0) ) ); G       cg = fptr->cgsub * (1.0 - ( mptr->alpha / (3.0*alphax*alphax) ));      }    }    charge[fptr->gnode] +=  B 	mptr->type * (qg  + (fptr->cgs * vgs) + (fptr->cgd * (vgs-vds)));:   *(fptr->matgg) += alpha0 * (cg + fptr->cgs + fptr->cgd); }      /*H * Put the fet into the binned array of devices used by the partitioner.  * variables used: , * devptr - pointer to the fet to be stuffed. */ stuffmti(devptr) struct device *devptr; {  struct fetti *fptr; )   fptr = (struct fetti *) devptr->devptr; #   adddevarray(devptr, fptr->dnode); B   if(fptr->gnode != fptr->dnode) adddevarray(devptr, fptr->gnode);  &   if( (fptr->snode != fptr->dnode) && F       (fptr->snode != fptr->gnode) ) adddevarray(devptr, fptr->snode);  %   if( (fptr->bnode != fptr->dnode) && %       (fptr->bnode != fptr->gnode) && F       (fptr->bnode != fptr->snode) ) adddevarray(devptr, fptr->bnode); }    /*  4 * Create and initialize the ti fet for simulation.  ; * This includes allocating space for the fet, replacing the ? * global node numbers with subcircuit numbers, initializing the A * matrix pointers, and deciding on the functions to evaluate the  	 * mosfet.  * variables used: 8 * subptr - pointer to the subcircuit containing the fet.> * extfptr - pointer to the fet created from input description. */' struct device *mtiinit(subptr, extfptr)  struct subcircuit *subptr; struct fetti *extfptr; {  struct fetti *fptr; $ struct device *devptr, *mtigetmat(); int temp, disfetti();   A /* Do not copy the TIFET model if it has only a gate in subckt */ > /* and cox, cgs, cgd are all zero or this is a dc solution. */   if( (dcflag == TRUE) || M       ((extfptr->cgsub ==0.0)&&(extfptr->cgd ==0.0)&&(extfptr->cgs == 0.0)) ) 0 	    if( (nomapchk(subptr,extfptr->snode) <= 0) + 		&& (nomapchk(subptr,extfptr->dnode) <= 0) ; 		&& (nomapchk(subptr,extfptr->bnode) <= 0) ) return(NULL);    /* Allocate the device. */>   devptr = (struct device *) ralloc(1, sizeof(struct device));   devptr->utype = FETTI;<   devptr->devptr = (char *) ralloc(1, sizeof(struct fetti));)   fptr = (struct fetti *) devptr->devptr;   - /* Copy the external fet to the local fet. */ -   bcopy(extfptr, fptr, sizeof(struct fetti));   ! /* Debugging Display function. */    devptr->display = disfetti;   4 /* Stuff in the matrix element grabbing function. */   devptr->initdev = mtigetmat;  < /* Actually replace the global nodes with the local ones. *//   fptr->gnode = chksubnode(subptr,fptr->gnode); /   fptr->bnode = chksubnode(subptr,fptr->bnode);   A /* If no source internal node, just replace the external node. */    if(fptr->gs == 0.0) { @     fptr->sxnode = fptr->snode = chksubnode(subptr,fptr->snode);   } 2   else if( (nomapchk(subptr, fptr->snode) <= 0) &&8 	   (waves[fptr->snode].present->wavetype != USERSRC)) {K     fptr->snode = fptr->sxnode = chksubnode(subptr,fptr->sxnode + maxnode);    } )   else { /* Allocate an internal node. */ 4     temp = allocnode(subptr,fptr->sxnode + maxnode);2     fptr->sxnode = chksubnode(subptr,fptr->snode);     fptr->snode = temp;    }  /* Same for the drain node. */   if(fptr->gd == 0.0) { @     fptr->dxnode = fptr->dnode = chksubnode(subptr,fptr->dnode);   } 2   else if( (nomapchk(subptr, fptr->dnode) <= 0) &&: 	   (waves[fptr->dnode].present->wavetype != USERSRC) ) { K     fptr->dnode = fptr->dxnode = chksubnode(subptr,fptr->dxnode + maxnode);    }    else {4     temp = allocnode(subptr,fptr->dxnode + maxnode);2     fptr->dxnode = chksubnode(subptr,fptr->dnode);     fptr->dnode = temp;    }   J /* Turn off mosfet diodes not in this subcircuit or to connected nodes. */N   if( ((fptr->bnode<=0)&&(fptr->dnode<=0)) || (fptr->bnode == fptr->dnode) ) {:     fptr->isad = 0.0; fptr->cjad = 0.0; fptr->cjasd = 0.0;   } N   if( ((fptr->bnode<=0)&&(fptr->snode<=0)) || (fptr->bnode == fptr->snode) ) {:     fptr->isas = 0.0; fptr->cjas = 0.0; fptr->cjass = 0.0;   }   * /* Stuff in model evaluation functions. */O   if((dcflag == FALSE)&&(fptr->dnode<=0)&&(fptr->snode<=0)&&(fptr->bnode<=0)) { 7     devptr->eval = tijustg; devptr->rhseval = tijustrg;    }    else {3     devptr->eval = putmti; devptr->rhseval = rpmti;    } '   if(dcflag == TRUE) fptr->cgsub = 0.0;    /* And return the device. */   return(devptr);  }     /* Matrix element allocation. */% struct device *mtigetmat(fptr,subptr)  struct fetti *fptr;  struct subcircuit *subptr; {  double *getmat(); <   fptr->matdxdx = getmat(fptr->dxnode, fptr->dxnode,subptr);:   fptr->matdxd = getmat(fptr->dxnode, fptr->dnode,subptr);:   fptr->matddx = getmat(fptr->dnode, fptr->dxnode,subptr);  <   fptr->matsxsx = getmat(fptr->sxnode, fptr->sxnode,subptr);:   fptr->matsxs = getmat(fptr->sxnode, fptr->snode,subptr);:   fptr->matssx = getmat(fptr->snode, fptr->sxnode,subptr);  7   fptr->matdd = getmat(fptr->dnode,fptr->dnode,subptr); 7   fptr->matdg = getmat(fptr->dnode,fptr->gnode,subptr); 7   fptr->matds = getmat(fptr->dnode,fptr->snode,subptr); 7   fptr->matdb = getmat(fptr->dnode,fptr->bnode,subptr);   7   fptr->matss = getmat(fptr->snode,fptr->snode,subptr); 7   fptr->matsd = getmat(fptr->snode,fptr->dnode,subptr); 7   fptr->matsg = getmat(fptr->snode,fptr->gnode,subptr); 7   fptr->matsb = getmat(fptr->snode,fptr->bnode,subptr);   7   fptr->matbb = getmat(fptr->bnode,fptr->bnode,subptr); 7   fptr->matbd = getmat(fptr->bnode,fptr->dnode,subptr); 7   fptr->matbs = getmat(fptr->bnode,fptr->snode,subptr);      if(dcflag == FALSE) { 9     fptr->matgg = getmat(fptr->gnode,fptr->gnode,subptr); 9     fptr->matgd = getmat(fptr->gnode,fptr->dnode,subptr); 9     fptr->matgs = getmat(fptr->gnode,fptr->snode,subptr); 9     fptr->matgb = getmat(fptr->gnode,fptr->bnode,subptr); 9     fptr->matbg = getmat(fptr->bnode,fptr->gnode,subptr);    }  }    /*L * This routine computes the internal model parameters that are functions of " * user-specified model parameters. */ finishmodti(mptr)  struct inmtimodel *mptr; { % double x, phis, sqrt(), exp(), log(); $ /* Size independent calculations. */(   mptr->phif = VTHERM * log(mptr->n/NI);#   phis = VTHERM * log(mptr->ns/NI); !   mptr->twophif = mptr->phif * 2;    mptr->twophis = phis * 2; *   mptr->sqrttwophif = sqrt(mptr->twophif);?   mptr->fixvto = mptr->vto - (mptr->gamma * mptr->sqrttwophif); 9   mptr->a2lam = mptr->lambda * mptr->alpha * mptr->alpha; *   mptr->a3lam = mptr->alpha * mptr->a2lam;0   mptr->a2lamg = 2.0 * mptr->zeta * mptr->a2lam;   mptr->xng = mptr->ng/VTHERM;   /* Mos diode parameters. */ G   mptr->djunc = (struct mosdiode *) ralloc(1, sizeof(struct mosdiode)); D   finishmosd(mptr->twophif, mptr->m, mptr->fc, VTHERM, mptr->djunc);E   mptr->dsw = (struct mosdiode *) ralloc(1, sizeof(struct mosdiode)); C   finishmosd(mptr->twophis, mptr->ms, mptr->fc, VTHERM, mptr->dsw);   N   mptr->sratio = sqrt((mptr->twophif * mptr->ns) / (mptr->twophis * mptr->n));  /   if(mptr->lgos == 0.0) mptr->lgos = mptr->lgo; /   if(mptr->lgod == 0.0) mptr->lgod = mptr->lgo; )   if(mptr->tpoly == 0.0) mptr->cfr = 0.0;    else {$     x = EOX / (1.0e4 *  mptr->cox); * 				/* Eox is in f/cm, make it microns. */     x /= (x + mptr->tpoly); 6     mptr->cfr = EOX/PI * (x + 1/x) * log((1+x)/(1-x)) " 		  + 2.0 * log(0.25 * (1/x - x));H     mptr->cfr = 0.0; /* I don't have the correct fring cap equations. */   }  }      /*G * This routine takes the ti mosfet model parameters and moves them into D * the ti mosfet element.  Element area dependent parameters are also * calculated here.   *  * Variables passed: # * fptr - ti mosfet element pointer. ! * mptr - ti mosfet model pointer.   * width - fet topological width." * length - fet topological length.L * as - area of the transistor source (used to scale diodes and resistances).K * ad - area of the transistor drain (used to scale diodes and resistances). ? * ass - area of the fet source sidewall (used to scale diodes). 5 * asd - area of the fet drain (used to scale diodes).  */7 modtofetti(fptr, mptr, length, width, as, ad, ass, asd)  struct inmtimodel *mptr; struct fetti *fptr; ' double width, length, as, ad, ass, asd;  {  double weff, leff, log();    fptr->mptr = mptr;, /* W and L and area dependent parameters. */   weff = width - mptr->wr;)   leff = (length - mptr->tld) - mptr->lr; - /* Thresholded source and drain resistors. */    if(mptr->rs != 0.0) { -     fptr->gs = weff * weff / (mptr->rs * as); &     if(fptr->gs < 1.0) fptr->gs = 0.0;   } else fptr->gs = 0.0;   if(mptr->rd != 0.0) { -     fptr->gd = weff * weff / (mptr->rd * ad); &     if(fptr->gd < 1.0) fptr->gd = 0.0;   } else fptr->gd = 0.0;(   fptr->beta = (mptr->kp * weff) / leff;*   fptr->betas = (mptr->kps * weff) / leff;(   fptr->cgsub = mptr->cox * weff * leff;N   fptr->cgs = weff * (mptr->cox * (mptr->lgos + mptr->tld * 0.5) + mptr->cfr);N   fptr->cgd = weff * (mptr->cox * (mptr->lgod + mptr->tld * 0.5) + mptr->cfr);   fptr->isas = as * mptr->is;    fptr->isad = ad * mptr->is;    if(fptr->isas != 0.0) 8 	fptr->svmax = (log((MIMAX/fptr->isas) + 1.0)) * VTHERM;   if(fptr->isad != 0.0) 8 	fptr->dvmax = (log((MIMAX/fptr->isad) + 1.0)) * VTHERM;   fptr->cjas = as * mptr->cjo;   fptr->cjad = ad * mptr->cjo; /* This may not be right. *//   fptr->cjass = ass * mptr->cjo * mptr->sratio; /   fptr->cjasd = asd * mptr->cjo * mptr->sratio;  }    /*G * This routine creates a ti fet element from read in parameters and the  * mosfet model.  */C struct device *iprmti(nextdev,netlist,numparams,paramlist,modelptr)  struct device *nextdev;  int netlist[], numparams;  ip_param paramlist[];  struct inmtimodel *modelptr; {  struct device *mtiinit();  struct fetti *fptr;  int i, stuffmti(); double as,ad,ass,asd,w,l;    /* Allocate the device. */   nextdev->utype = FETTI;    nextdev->flag = 0;   nextdev->initdev = mtiinit;    nextdev->stuffdev = stuffmti; =   nextdev->devptr = (char *) ralloc(1, sizeof(struct fetti)); *   fptr = (struct fetti *) nextdev->devptr;E   nextdev->next = (struct device *) ralloc(1, sizeof(struct device));    nextdev = nextdev->next;   nextdev->next = NULL;      /* Get the node numbers. */    fptr->dnode = netlist[0];    fptr->gnode = netlist[1];    fptr->snode = netlist[2];    fptr->bnode = netlist[3];    w = modelptr->width;   l = modelptr->length;    as = modelptr->as;   ad = modelptr->ad;   ass = modelptr->ass;   asd = modelptr->asd;  > /* Get the length, width, as, ad, ass, pd params, if given. */    for(i=0; i < numparams; i++) {      switch(paramlist[i].id[0]) {3       case 'a'  : w = pareval(paramlist[i]); break; 3       case 'b'  : l = pareval(paramlist[i]); break; 4       case 'c'  : as = pareval(paramlist[i]); break;4       case 'd'  : ad = pareval(paramlist[i]); break;5       case 'e'  : ass = pareval(paramlist[i]); break; 5       case 'f'  : asd = pareval(paramlist[i]); break; F       default   : printf("Nonexist param spec'ed for mti\n"); exit(0);     }    } 5   modtofetti(fptr, modelptr, l, w, as, ad, ass, asd); C /* Reserve internal node numbers for source and drain resistors. */ 1   if(fptr->gs == 0.0) fptr->sxnode = fptr->snode; "   else fptr->sxnode = ++internals;1   if(fptr->gd == 0.0) fptr->dxnode = fptr->dnode; "   else fptr->dxnode = ++internals;   return(nextdev); }    /*. * Get the model parameters from the front end.D * Note that "be" is herein called gamma, and "gamma" is called zeta.G * This is to maintain some consistancy between ti and other mos models.  */  ) char *ipmtirm(type, numparams, paramlist)  double type; int numparams; ip_param *paramlist; {  struct allmod *modptr; struct inmtimodel *fptr; struct device *iprmti();
 double tempd;  int i;  # /* Allocate space for the model. */ ?   modptr = (struct allmod *) ipalloc(1, sizeof(struct allmod)); 8 /* Will still need mosfet model when all is finished. */D   fptr = (struct inmtimodel *) ralloc(1, sizeof(struct inmtimodel));   modptr->type = FETTI;    modptr->dev = (char *) fptr;   modptr->readdev = iprmti;   /* Put in the model defaults. */!   fptr->width=1; fptr->length=1;  B   fptr->vto=0.0; fptr->kp=0.0; fptr->gamma=0.0; fptr->lambda=0.01;4   fptr->tld=0.0; fptr->theta=0.028; fptr->alpha=1.0;;   fptr->wr=0.0; fptr->lr=0.0; fptr->de=0.0; fptr->zeta=0.0; ,   fptr->n=1e15; fptr->cf=0.0; fptr->cox=0.0;   fptr->kps=0.0; fptr->ng=0.0;  0   fptr->lgo=0.0; fptr->lgod=0.0; fptr->lgos=0.0;& /* Fringing capacitance parameters. */(   fptr->x = 1.0;   fptr->tpoly = 0.0;   ) /* Bulk and sidewall diode parameters. */ 7   fptr->as=1.0; fptr->ad=1.0; fptr->ass=0; fptr->asd=0; #   fptr->fc = 0.5; fptr->is=1.0e-14; !   fptr->m = 0.5; fptr->ms = 0.5;     fptr->cjo = 1.02e-13;    fptr->ns = 1.0e15;) /* Default drain and source resistors. */ !   fptr->rs = 0.0; fptr->rd = 0.0; , /* Place in the passed type, nmos or pmos */   fptr->type = (double) type;  /* Read in the model. */    for(i=0; i < numparams; i++) {I     switch(paramlist[i].id[0]) {  /* switch on first char in param id. */ <       case 'a' : fptr->width = pareval(paramlist[i]); break;=       case 'b' : fptr->length = pareval(paramlist[i]); break; 9       case 'c' : fptr->as = pareval(paramlist[i]); break; 9       case 'd' : fptr->ad = pareval(paramlist[i]); break; :       case 'e' : fptr->ass = pareval(paramlist[i]); break;:       case 'f' : fptr->asd = pareval(paramlist[i]); break;:       case 'g' : fptr->vto = pareval(paramlist[i]); break;9       case 'h' : fptr->kp = pareval(paramlist[i]); break; <       case 'i' : fptr->gamma = pareval(paramlist[i]); break;=       case 'j' : fptr->lambda = pareval(paramlist[i]); break; :       case 'k' : fptr->tld = pareval(paramlist[i]); break;<       case 'l' : fptr->theta = pareval(paramlist[i]); break;<       case 'm' : fptr->alpha = pareval(paramlist[i]); break;9       case 'n' : fptr->wr = pareval(paramlist[i]); break; 9       case 'o' : fptr->lr = pareval(paramlist[i]); break; 9       case 'p' : fptr->de = pareval(paramlist[i]); break; ;       case 'q' : fptr->zeta = pareval(paramlist[i]); break; 8       case 'r' : fptr->n = pareval(paramlist[i]); break;9       case 's' : fptr->cf = pareval(paramlist[i]); break; :       case 't' : fptr->cox = pareval(paramlist[i]); break;:       case 'u' : fptr->kps = pareval(paramlist[i]); break;9       case 'v' : fptr->ng = pareval(paramlist[i]); break; :       case 'w' : fptr->lgo = pareval(paramlist[i]); break;;       case 'x' : fptr->lgod = pareval(paramlist[i]); break; ;       case 'y' : fptr->lgos = pareval(paramlist[i]); break; 8       case 'z' : fptr->x = pareval(paramlist[i]); break;<       case 'A' : fptr->tpoly = pareval(paramlist[i]); break;9       case 'B' : fptr->fc = pareval(paramlist[i]); break; 9       case 'C' : fptr->is = pareval(paramlist[i]); break; 8       case 'D' : fptr->m = pareval(paramlist[i]); break;9       case 'E' : fptr->ms = pareval(paramlist[i]); break; :       case 'F' : fptr->cjo = pareval(paramlist[i]); break;9       case 'G' : fptr->ns = pareval(paramlist[i]); break; 9       case 'H' : fptr->rs = pareval(paramlist[i]); break; 9       case 'I' : fptr->rd = pareval(paramlist[i]); break;      }    }    finishmodti(fptr);   return((char *) modptr); }      disfetti(fptr) struct fetti *fptr;  {  struct inmtimodel *mptr;1   printf("d=%d, g=%d, s=%d, b=%d dx=%d sx=%d\n",  N    fptr->dnode,fptr->gnode,fptr->snode,fptr->bnode,fptr->dxnode,fptr->sxnode);"   printf("beta=%g, ", fptr->beta);$   printf("cgsub=%g, ", fptr->cgsub);*   printf("type = %g\n", fptr->mptr->type);#   printf("betas=%g ", fptr->betas); 2   printf("cgs=%g cgd=%g\n", fptr->cgs, fptr->cgd);.   printf("isas=%g isad=%g cjas=%g cjad=%g\n", 3 			fptr->isas, fptr->isad, fptr->cjas, fptr->cjad); ;   printf("cjass=%g, cjasd=%g\n", fptr->cjass, fptr->cjasd); +   printf("svmax=%g dvmax=%g gs=%g gd=%g\n", 1 		 fptr->svmax, fptr->dvmax, fptr->gs, fptr->gd);    printf("Model parameters\n");    dismtimod(fptr->mptr); }    dismtimod(fptr)  struct inmtimodel *fptr; { 0   printf("type=%g vto=%g kp=%g zeta=%g n=%g\n", 8 		fptr->type, fptr->vto, fptr->kp, fptr->zeta, fptr->n);2   printf("lambda=%g gamma=%g theta=%g alpha=%g\n",7 		fptr->lambda, fptr->gamma, fptr->theta, fptr->alpha); 0   printf("tld=%g wr=%g lr=%g lgos=%g lgod=%g\n",9 		fptr->tld, fptr->wr, fptr->lr, fptr->lgos, fptr->lgod); -   printf("de=%g cf=%g ng=%g kps=%g xng=%g\n", 6 		fptr->de, fptr->cf, fptr->ng, fptr->kps, fptr->xng);9   printf("phif=%g fixvto=%g sqrttwophif=%g twophif=%g\n", L                 fptr->phif, fptr->fixvto, fptr->sqrttwophif, fptr->twophif);4   printf("twophis=%g a2lam=%g a3lam=%g a2lamg=%g\n",G                 fptr->twophis, fptr->a2lam, fptr->a3lam, fptr->a2lamg); <   printf("fc=%g is=%g ns=%g m=%g ms=%g cjo=%g sratio=%g\n", N      fptr->fc,fptr->is, fptr->ns, fptr->m, fptr->ms, fptr->cjo, fptr->sratio);.   printf("rs=%g rd=%g\n", fptr->rs, fptr->rd);7   printf("junction diode\n"); dismosdiode(fptr->djunc); 5   printf("sidewall diode\n"); dismosdiode(fptr->dsw);  }       
 testmti(fptr)  struct fetti *fptr;  {  double current[5], current2[5]; 8 double dummy, vbs, vgs, vds, compgmgs, compgdd, compgdb;0 double gmgs, gds, gdb, gdd, gsd, gsb, gss, gmsg; double gmbg, gbs, gbd, gbb;  int dnode, snode, bnode, gnode; & double *temp1, *temp2, *temp3, *temp4;& double *temp5, *temp6, *temp7, *temp8;) double *temp9, *temp10, *temp11, *temp12;  int i, j, k, l;  double GMIN;     GMIN = 1.0e-12;   '   dnode = fptr->dnode; fptr->dnode = 1; '   snode = fptr->snode; fptr->snode = 2; '   bnode = fptr->bnode; fptr->bnode = 3; '   gnode = fptr->gnode; fptr->gnode = 4;   +   temp1 = fptr->matdg; fptr->matdg = &gmgs; *   temp2 = fptr->matds; fptr->matds = &gds;*   temp3 = fptr->matdb; fptr->matdb = &gdb;*   temp4 = fptr->matdd; fptr->matdd = &gdd;  +   temp5 = fptr->matsg; fptr->matsg = &gmsg; *   temp6 = fptr->matsd; fptr->matsd = &gsd;*   temp7 = fptr->matsb; fptr->matsb = &gsb;*   temp8 = fptr->matss; fptr->matss = &gss;  +   temp9 = fptr->matbg; fptr->matbg = &gmbg; +   temp10 = fptr->matbd; fptr->matbd = &gbd; +   temp11 = fptr->matbs; fptr->matbs = &gbs; +   temp12 = fptr->matbb; fptr->matbb = &gbb;        for(l=0; l <= 5000; l += 500) &    for(k = -5000; k <= 1000; k += 500)$      for(i=0; i <= 5000; i += 500) {     vgs = i * 0.001;     vbs = k * 0.001;     vds = l * 0.001;     A     for(j=1; j < 5; j++) { current2[j] = 0.0; current[j] = 0.0; } 0     gmgs = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0;0     gmsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0;0     gmbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0;  3     ticompid(fptr, vgs, vbs, vds, &dummy, current); ,     for(j=1; j < 5; j++) current2[j] = 0.0; +     tijustid(fptr, vgs, vbs, vds, current);      for(j=1; j < 5; j++) {*       if(dabs(current2[j] - current[1]) > 2 			((dabs(current[1]) * nrcrel + nrcabs)/100.0)) {5         printf("rhs and full Current discrepency\n"); A         printf("vds=%g vbs=%g vgs=%g id=%g is=%g ib=%g ig=%g\n",  B 	  vds, vbs, vgs, current[1], current[2], current[3], current[4]);0         printf("id2=%g is2=%g ib2=%g ig2=%g\n", A 	            current2[1], current2[2], current2[3], current2[4]);        }      } /     for(j=1; j < 5; j++) { current2[j] = 0.0; }   0     gmgs = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0;0     gmsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0;0     gmbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0;  H     ticompid(fptr, (double) (vgs + 1.0e-4), vbs, vds, &dummy, current2);D     compgmgs = fptr->mptr->type * (current2[1] - current[1])/1.0e-4;  N     if( dabs(compgmgs-gmgs) > (0.005*(GMIN + dabs(compgmgs) + dabs(gmgs))) ) {'       printf("Derivative Error!!!!\n"); ?       printf("vds=%g vbs=%g vgs=%g id=%g is=%g ib=%g ig=%g\n",  @ 	vds, vbs, vgs, current[1], current[2], current[3], current[4]);6       printf("gmgs=%g compgmgs=%g\n", gmgs, compgmgs);     }   /     for(j=1; j < 5; j++) { current2[j] = 0.0; } 0     gmgs = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0;0     gmsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0;0     gmbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0;  H     ticompid(fptr, vgs, vbs, (double) (vds + 1.0e-4), &dummy, current2);C     compgdd = fptr->mptr->type * (current2[1] - current[1])/1.0e-4;   L     if( dabs(compgdd - gdd) > (0.005*(GMIN + dabs(compgdd) + dabs(gdd))) ) {'       printf("Derivative Error!!!!\n"); ?       printf("vds=%g vbs=%g vgs=%g id=%g is=%g ib=%g ig=%g\n",  @ 	vds, vbs, vgs, current[1], current[2], current[3], current[4]);2       printf("gdd=%g compgdd=%g\n", gdd, compgdd);     }   /     for(j=1; j < 5; j++) { current2[j] = 0.0; } 0     gmgs = 0.0; gds = 0.0; gdb = 0.0; gdd = 0.0;0     gmsg = 0.0; gsd = 0.0; gsb = 0.0; gss = 0.0;0     gmbg = 0.0; gbd = 0.0; gbs = 0.0; gbb = 0.0;  H     ticompid(fptr, vgs, (double) (vbs + 1.0e-4), vds, &dummy, current2);C     compgdb = fptr->mptr->type * (current2[1] - current[1])/1.0e-4;   L     if( dabs(compgdb - gdb) > (0.005*(GMIN + dabs(compgdb) + dabs(gdb))) ) {'       printf("Derivative Error!!!!\n"); ?       printf("vds=%g vbs=%g vgs=%g id=%g is=%g ib=%g ig=%g\n",  @ 	vds, vbs, vgs, current[1], current[2], current[3], current[4]);2       printf("gdb=%g compgdb=%g\n", gdb, compgdb);     }          }      fptr->dnode = dnode;   fptr->snode = snode;   fptr->bnode = bnode;   fptr->gnode = gnode;     fptr->matdg = temp1;   fptr->matsg = temp2;   } 