I {************************************************************************  *									*  *  J U M P								*  *									* F *  JUMP is a program which allows selected users (Operators, Systems	*C *  Programmers and other specifically authorised users) to either	* E *  change elements of their process to those of another user, or to	* E *  actually become a given user in a separate process attached to a	*  *  pseudo-terminal.							*  *									* C *  When not becoming exactly the target user, the items which are	* 0 *  changed to those of the target user are:				* *									* @ *    Username (Systems Programmers only, using the SETUSER or		* *	       ALL qualifier)						* *									* 9 *    UIC, Default Directory, Default Disk, LNM$GROUP.			*  *									* 5 *  Privileges and process rights are NOT changed.			*  *									* 3 *  The syntax of the JUMP command generally is				*  *									* + *      $ JUMP [username] [qualifiers]					*  *									* I *  If no username is supplied, JUMP returns the UIC, Default Directory, * B *  Default Disk and LNM$GROUP to those of the current username. 	*I *.......................................................................* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* D *  INSTALL with CMEXEC, CMKRNL, DETACH, SYSPRV, SYSNAM privileges.	* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *.......................................................................* D *  Note: Some ideas in this code have been drawn from Eric Wentz's	*> *	 program BECOME.  The code for pseudo-terminal creation is	*@ *	 derived from Anthony McCracken's GLOGIN program.  Thanks to	*C *	 Jeremy Begg for a minor code fix and Bob Beckerhof for testing.* I *.......................................................................* # *  Author:  Jonathan Ridler,						* + *	    Information Technology Services,				* ' *	    The University of Melbourne,				*   *	    Parkville, Victoria,					* *	    AUSTRALIA, 3052.						*  *									* , *	    Internet: jonathan@unimelb.edu.au				*I *.......................................................................*  *  History:								*, * v1.0	02-Mar-1993	JER	Original version.			*/ *	09-Mar-1993	JER	Audit security violations.		* 4 *	04-Mar-1994	JER	Add change username capability. 	*; *	14-Jul-1994	JER	Allow change of UIC, etc. AND username; * " *				Allow username NOT in UAF.		*3 *	21-Nov-1995	JER	Allow Sysprogs to avoid audit.		* ? * v1.4	11-Jan-1996	JER	Increase size of audit message buffer.	* : * v2.0	11-Jul-1996	JER	Add EXACT (pseudo-terminal) form.	*< * v2.1	26-Jul-1996	JER	Add general user restricted access.	*? * v2.2	07-Aug-1996	JER	Only Sysprogs and authorised users can	* - *				jump to privileged users. Also, modify	* * *				method of restoring terminal chars.	*I ************************************************************************}     [INHERIT ('SYS$LIBRARY:STARLET',% 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES', & 	  'SYS$LIBRARY:PASCAL$STR_ROUTINES')]   PROGRAM Jump (OUTPUT) ;    CONST    Lf = CHR (10) ; 		{ Linefeed }  B Io_Buflen = 1 * 512 ;		{ *WORDS* = 1 pair of 512 byte R/W blocks }< Rsts = 1 ;			{ Index to read status in pseudo-terminal buf }; Rcnt = 2 ;			{ Count of chars read in pseudo-terminal buf } - Rbuf = 3 ;			{ Actual read data area begins } L Wsts = Io_Buflen DIV 2 + 1 ;	{ Start of write buffer area and write status }A Wcnt = Wsts + 1 ;		{ Count of chars writ in pseudo-terminal buf } 3 Wbuf = Wsts + 2 ;		{ Actual read data area begins } E Ft_Buflen = Io_Buflen - 4 ;	{ *BYTES* Size of buffer for FTA device } B Py_Buflen = Io_Buflen ; 	{ *BYTES* Size of buffer for PYA device }  > Rightsize = 50 ;		{ Number of rightslist entries to retrieve }   Bad_Access_Data = N    '%JUMP-F-BADDATA, Format of Access List data record seems to be invalid.' ;   TYPE   $UBYTE = [BYTE] 0..255 ;   $UWORD = [WORD] 0..65535 ;  : $UQUAD = [QUAD,UNSAFE] RECORD  L0 , L1 : UNSIGNED ;  END ;  6 Privilege = (Cmkrnl,	{  0: May change Mode to Kernel }A 	     Cmexec,	{  1: May change Mode to Exec; MUST follow Cmkrnl } = 	     Sysnam,	{  2: May insert in system logical name table } E 	     Grpnam,	{  3: May insert in group l.n.tab; MUST follow Sysnam } 3 	     Allspool,	{  4: May allocate spooled device } 3 	     Detach,	{  5: May create detached processes } , 	     Diagnose,	{  6: May diagnose devices }( 	     Log_Io,	{  7: May do logical I/O }A 	     Group,	{  8: May affect other processes in same UIC group } + 	     Acnt,	{  9: May suppress accounting } @ 	     Prmceb,	{ 10: May create permanent common event clusters }3 	     Prmmbx,	{ 11: May create permanent mail box } - 	     Pswapm,	{ 12: May change process mode } 0 	     Altpri,	{ 13: May set any priority value }0 	     Setprv,	{ 14: May set any privilege bits }2 	     Tmpmbx,	{ 15: May create temporary mailbox }< 	     World,	{ 16: May affect other processes in the world }4 	     Mount,	{ 17: May execute mount ACP functions }& 	     Oper,	{ 18: Operator privilege }- 	     Exquota,	{ 19: May exceed disk quotas } / 	     Netmbx,	{ 20: May create network device } 4 	     Volpro,	{ 21: May override volume protection }) 	     Phy_Io,	{ 22: May do physical I/O } : 	     Bugchk,	{ 23: May make bug check error log entries }: 	     Prmgbl,	{ 24: May create permanent global sections }< 	     Sysgbl,	{ 25: May create system-wide global sections }/ 	     Pfnmap,	{ 26: May map to section by PFN } = 	     Shmem,	{ 27: May allocate structures in shared memory } : 	     Sysprv,	{ 28: Eligible for system protection field }5 	     Bypass,	{ 29: May bypass UIC-based protection } 2 	     Syslck,	{ 30: May create system-wide locks }< 	     Share,	{ 31: May assign channel to non-shared device }3 	     Upgrade,	{ 32: May upgrade object integrity } 5 	     Downgrade, { 33: May downgrade object secrecy } > 	     Grpprv,	{ 34: Group access via system protection field }* 	     Readall,	{ 35: May read any object }A 	     Import,	{ 36: May set classification for unlabeled object } B 	     Audit,	{ 37: May direct audit to system security audit log }6 	     Security,	{ 38: May perform security functions }= 	     Pbit39, Pbit40, Pbit41, Pbit42, Pbit43, Pbit44, Pbit45, = 	     Pbit46, Pbit47, Pbit48, Pbit49, Pbit50, Pbit51, Pbit52, = 	     Pbit53, Pbit54, Pbit55, Pbit56, Pbit57, Pbit58, Pbit59, F 	     Pbit60, Pbit61, Pbit62, Pbit63) ;	{ 39-63: dummy bits: 2 LONGs }  E Privset = PACKED SET OF Privilege ;	{ To allow easy bit union, etc. }   < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;   . Username_Type = PACKED ARRAY [1..12] OF CHAR ;  < Io_Buffer = [ALIGNED(9),STATIC,UNSAFE]			{ Pagelet aligned }- 		ARRAY [1..Io_Buflen] OF $UWORD	VALUE ZERO ;    Terminal_Chars = PACKED RECORD% 		   Tt_Class    : [POS(0)]  $UBYTE ; % 		   Tt_Type     : [POS(8)]  $UBYTE ; % 		   Tt_Width    : [POS(16)] $UWORD ; & 		   Tt_Devchar  : [POS(32)] TT$TYPE ;' 		   Tt_Devchar2 : [POS(64)] TT2$TYPE ;  		 END ;   VAR			{ ***  V A R  *** }   " Log ,				{ Log success messages? }" Alter_Ego ,			{ Change Username? }# Transmute ,			{ Change UIC, etc.? } ( Auditing ,			{ Audit successful jumps? }= Real_Mccoy ,			{ Use a pseudo-terminal and *really* do it!? } 8 Double_Check ,			{ Double check general user's access? }; Figment : BOOLEAN := FALSE ;	{ Allow username NOT in UAF? }   K Max_Sys_Group : INTEGER := 0 ;	{ Maximum UIC group with system privileges }   F User : VARYING [12] OF CHAR := PAD ('',' ',12) ;	{ Caller's username }  O New_User : [VOLATILE] VARYING [12] OF CHAR := PAD ('',' ',12) ; { Target user }   + Sanity_Ctl_User ,					{ For CMKRNL checks } H Sanity_Jib_User : [VOLATILE] Username_Type := '' ;	{ For CMKRNL checks }  ? Command : VARYING [80] OF CHAR := '' ;			{ Input command line }    Uic ,							{ UIC of caller } % New_Uic ,						{ UIC of target user } A Sanity_Uic : [VOLATILE] UIC$TYPE := ZERO ;		{ For CMKRNL checks }    Terminal ,						{ Audit this } Port ,							{ Audit this } E Def_Dev : [VOLATILE] VARYING  [32] OF CHAR := '' ;	{ Default device }    Access_List ,						{ Filespec } 9 Audit_Trail : VARYING [255] OF CHAR := '' ;		{ Filespec }   H Def_Dir : [VOLATILE] VARYING [255] OF CHAR := '' ;	{ Default directory }  9 Uic_Str : VARYING [15] OF CHAR := ZERO ;		{ String form }   ( Eq_Id_Str ,						{ UIC string handling }@ Id_Str	: VARYING [32] OF CHAR := ZERO ;		{ UIC string handling }  ' Def_Priv ,						{ Target's def  privs } H Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;	{ Target's auth privs }  @ Flags : [VOLATILE]  FLAGS$TYPE := ZERO ;		{ Target's UAF flags }  < Jib_User_Ptr : [VOLATILE] ^[VOLATILE] Username_Type := NIL ;  4 CTL$T_USERNAME : [EXTERNAL,VOLATILE] Username_Type ;  	 Jib_Ptr , 2 Uic_Ptr : [VOLATILE] ^[VOLATILE] UNSIGNED := NIL ;  G Pseudo_Ft : [VOLATILE] BOOLEAN := FALSE ;	{ Is pseudo-terminal FTA0:? } ( Pchan , 					{ Pseudo-terminal channel }& Rchan , 					{ Real terminal channel }5 Mchan : [VOLATILE] $UWORD := 0 ;		{ Mailbox channel } D Pdev : VARYING [12] OF CHAR := '' ;		{ Pseudo-terminal device name }O Pbuf_Range : ARRAY [1..2] OF UNSIGNED := ZERO ; { Quasi descriptor of I/O buf } L Mbbuf : ARRAY [1..ACC$K_TERMLEN] OF $UBYTE := ZERO ;	{ Termination MBX buf }O Piosb : [VOLATILE] Status_Block_Type := ZERO ;	{ IOSB for pseudo-terminal IOs } G Buffer : [VOLATILE] Io_Buffer := ZERO ; 	{ Pseudo-terminal I/O buffer }   @ Rchars : Terminal_Chars := ZERO ;		{ Device chars of real term }  & Exit_Rst ,					{ Exit Handler status }" Pid ,						{ Current process PID }/ Master_Pid ,					{ Current process master PID } E Proc_Cnt : [VOLATILE] UNSIGNED := 0 ;		{ Current proc subproc count }   , Proc_Def_Priv ,						{ Caller's def  privs }M Proc_Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;	{ Caller's auth privs }   J Rights : ARRAY [1..Rightsize] OF $UQUAD := ZERO ;	{ Caller's proc rights }   PAS$K_SUCCESS , - PAS$K_FILNOTFOU : [EXTERNAL,VALUE] UNSIGNED ;    PCB$L_JIB ,  PCB$L_UIC ,  JIB$T_USERNAME ," CTL$GL_PCB : [EXTERNAL] UNSIGNED ;    O { The following formal function declarations are present to allow compatability I   with OpenVMS v5.5-2 and lower where these declarations do not appear in N   environment files.  For OpenVMS v6.0 (I think) and onwards, $SETDDIR appearsC   in STARLET, and the CLI routines appear in PASCAL$CLI_ROUTINES. }   % [ASYNCHRONOUS] FUNCTION SYS$SETDDIR (  	New_Dir_Addr : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 2 	VAR Length_Addr : [VOLATILE] $UWORD := %IMMED 0 ; 	%STDESCR Cur_Dir_Addr :7 		PACKED ARRAY [$L3..$U3:INTEGER] OF CHAR := %IMMED 0 )  		: UNSIGNED ; EXTERNAL ;   ' [ASYNCHRONOUS] FUNCTION CLI$DCL_PARSE (  	Command_String : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 0 	%IMMED [ASYNCHRONOUS,UNBOUND] PROCEDURE Table ; 	%IMMED [ASYNCHRONOUS,UNBOUND]0 		FUNCTION Param_Routine	: INTEGER := %IMMED 0 ; 	%IMMED [ASYNCHRONOUS,UNBOUND]1 		FUNCTION Prompt_Routine : INTEGER := %IMMED 0 ;  	Prompt_String :A 		[CLASS_S] PACKED ARRAY [$L5..$U5:INTEGER] OF CHAR := %IMMED 0 )  		: UNSIGNED ; EXTERNAL ;   ' [ASYNCHRONOUS] FUNCTION CLI$GET_VALUE ( B 	Entity_Desc : [CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR ;) 	%DESCR Retdesc : VARYING [$L2] OF CHAR ; 0 	VAR Retlength : [VOLATILE] $UWORD := %IMMED 0 ) 		: UNSIGNED ; EXTERNAL ;   % [ASYNCHRONOUS] FUNCTION CLI$PRESENT ( B 	Entity_Desc : [CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR ) 		: UNSIGNED ; EXTERNAL ;     . PROCEDURE Exit (Msg : VARYING [Len] OF CHAR) ;  # { Just a dinky shorthand routine. }      BEGIN 	{ Exit }    WRITELN (Msg) ; 	   $EXIT ;    END ; 	{ of Exit }     PROCEDURE Get_Logical_Name (< 		Lognam	: [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;= 		Default : [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR ; % 		VAR Actual : VARYING [Sz] OF CHAR ; < 		Table	: [CLASS_S] PACKED ARRAY [L3..U3:INTEGER] OF CHAR := 				'LNM$FILE_DEV' ; 		Mode	: $UBYTE := PSL$C_USER  		) ;   K { Get the translation of the logical name specified.  If it does not exist,    use the default value. }     VAR Rst : UNSIGNED := 0 ; 2       Item_List : Item_List_Template (2) := ZERO ;  "   BEGIN       { Get_Logical_Name }4   Item_List[1].Buffer_Length := SIZE (Actual.BODY) ;-   Item_List[1].Item_Code     := LNM$_STRING ; 8   Item_List[1].Buffer_Addr   := IADDRESS (Actual.BODY) ;:   Item_List[1].Return_Addr   := IADDRESS (Actual.LENGTH) ;  A   Item_List[2].Terminator    := 0 ;   { Terminate the item list }   1   Rst := $TRNLNM (Attr	 := %REF LNM$M_CASE_BLIND,  		  Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := %REF Mode, 		  Itmlst := Item_List) ;   IF Rst = SS$_NOLOGNAM  THEN       Actual := Default    ELSE    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; %   END ;       { of Get_Logical_Name }     P FUNCTION  Str_Compress (Source : [CLASS_S] PACKED ARRAY [L..U:INTEGER] OF CHAR ;$ 			VAR  Dest : VARYING [D] OF CHAR ;, 			Collapse : BOOLEAN := FALSE) : UNSIGNED ;  L { Compress a string by removing leading and trailing white space (blanks andL   tabs), and replacing multiple consecutive white space with a single blank./   If collapse is set, remove ALL white space. }   %   CONST  Blanks = [' ',''(9),''(0)] ;  	 Maxsize = 1024 ;F 	 Warn_Inpstrtru = UAND (LIB$_INPSTRTRU,%Xfffffff8) ;	{ Warning only }  !   VAR  S , J , K : INTEGER := 0 ;          Done : BOOLEAN := FALSE ;,        Spacer : VARYING [1] OF CHAR := ' ' ;5        Dstr, Sstr : VARYING [Maxsize] OF CHAR := '' ;      BEGIN 	{ Str_Compress } .   Str_Compress := SS$_NORMAL ;		{ Presume so }   S := LENGTH (Source) ;  %   IF S = 0  THEN			{ Nothing passed }       Dest := ''     ELSE 
      BEGIN      IF S > Maxsize  THEN  	BEGIN$ 	Sstr := SUBSTR (Source,1,Maxsize) ;& 	Str_Compress := INT(Warn_Inpstrtru) ; 	END
       ELSE 	Sstr := Source ;   %      IF Collapse  THEN	Spacer := '' ;   D      IF FIND_MEMBER (Source,Blanks) = 0  THEN		{ Nothing to change }
 	Dstr := Sstr 
       ELSE 	WHILE NOT Done	DO 	  BEGIN& 	  J := FIND_NONMEMBER (Sstr,Blanks) ; 	  IF J = 0  THEN  	     Done := TRUE 	   ELSE 	     BEGIN / 	     Sstr := SUBSTR (Sstr,J,Sstr.LENGTH-J+1) ; & 	     K := FIND_MEMBER (Sstr,Blanks) ; 	     IF K = 0  THEN 		BEGIN  		Dstr := Dstr + Sstr ;  		Done := TRUE ; 		END  	      ELSE  		BEGIN / 		Dstr := Dstr + SUBSTR (Sstr,1,K-1) + Spacer ; + 		Sstr := SUBSTR (Sstr,K,Sstr.LENGTH-K+1) ;  		END ;  	     END ;  	  END ; 	{ of While }        IF Dstr <> ''  THEN! 	IF Dstr[Dstr.LENGTH] = ' '  THEN * 	   Dstr:= SUBSTR (Dstr,1,Dstr.LENGTH-1) ;        IF Dstr.LENGTH <= D  THEN
 	Dest := Dstr 
       ELSE 	BEGIN 	Dest := SUBSTR (Dstr,1,D) ;! 	Str_Compress := LIB$_OUTSTRTRU ;  	END ;
      END ;   END ; 	{ of Str_Compress }     PROCEDURE Get_Caller_Info ;   > { Get relevant information about the invoker of the program. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ; . 	Item_List : Item_List_Template (11) := ZERO ;     BEGIN 	{ Get_Caller_Info }#   Item_List[1].Buffer_Length := 4 ; 2   Item_List[1].Item_Code     := SYI$_MAXSYSGROUP ;:   Item_List[1].Buffer_Addr   := IADDRESS (Max_Sys_Group) ;#   Item_List[1].Return_Addr   := 0 ;   A   Item_List[2].Terminator    := 0 ;   { Terminate the item list }   '   Rst := $GETSYIW (Itmlst := Item_List,  		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE    IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;   #   Item_List[1].Buffer_Length := 8 ; /   Item_List[1].Item_Code     := JPI$_PROCPRIV ; :   Item_List[1].Buffer_Addr   := IADDRESS (Proc_Def_Priv) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ; /   Item_List[2].Item_Code     := JPI$_AUTHPRIV ; ;   Item_List[2].Buffer_Addr   := IADDRESS (Proc_Auth_Priv) ; #   Item_List[2].Return_Addr   := 0 ;   #   Item_List[3].Buffer_Length := 4 ; *   Item_List[3].Item_Code     := JPI$_UIC ;:   Item_List[3].Buffer_Addr   := IADDRESS (Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;	  -   Item_List[4].Buffer_Length := SIZE (User) ; /   Item_List[4].Item_Code     := JPI$_USERNAME ;p6   Item_List[4].Buffer_Addr   := IADDRESS (User.BODY) ;8   Item_List[4].Return_Addr   := IADDRESS (User.LENGTH) ;  #   Item_List[5].Buffer_Length := 4 ;r*   Item_List[5].Item_Code     := JPI$_PID ;0   Item_List[5].Buffer_Addr   := IADDRESS (Pid) ;#   Item_List[5].Return_Addr   := 0 ;   #   Item_List[6].Buffer_Length := 4 ;h1   Item_List[6].Item_Code     := JPI$_MASTER_PID ;r7   Item_List[6].Buffer_Addr   := IADDRESS (Master_Pid) ;P#   Item_List[6].Return_Addr   := 0 ;	  #   Item_List[7].Buffer_Length := 4 ;	-   Item_List[7].Item_Code     := JPI$_PRCCNT ;D5   Item_List[7].Buffer_Addr   := IADDRESS (Proc_Cnt) ;r#   Item_List[7].Return_Addr   := 0 ;	  2   Item_List[8].Buffer_Length := SIZE (Port.BODY) ;3   Item_List[8].Item_Code     := JPI$_TT_ACCPORNAM ;u6   Item_List[8].Buffer_Addr   := IADDRESS (Port.BODY) ;8   Item_List[8].Return_Addr   := IADDRESS (Port.LENGTH) ;  6   Item_List[9].Buffer_Length := SIZE (Terminal.BODY) ;/   Item_List[9].Item_Code     := JPI$_TERMINAL ;.:   Item_List[9].Buffer_Addr   := IADDRESS (Terminal.BODY) ;<   Item_List[9].Return_Addr   := IADDRESS (Terminal.LENGTH) ;  0   Item_List[10].Buffer_Length := SIZE (Rights) ;6   Item_List[10].Item_Code     := JPI$_PROCESS_RIGHTS ;4   Item_List[10].Buffer_Addr   := IADDRESS (Rights) ;$   Item_List[10].Return_Addr   := 0 ;  ?   Item_List[11].Terminator   := 0 ;	{ Terminate the item list }e  '   Rst := $GETJPIW (Itmlst := Item_List,. 		   Iosb   := Iosb) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)n    ELSEe   IF NOT ODD (Iosb[1])	THENn      LIB$SIGNAL (Iosb[1]) ;h  -   Rst := STR$TRIM (%DESCR User,%DESCR User) ;v   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Get_Caller_Info }c    * FUNCTION Get_And_Parse_Command : BOOLEAN ;  G { Get and parse the DCL command line.  Do some basic username checks. }t     VAR	Rst : UNSIGNED := 0 ; # 	Str : VARYING [20] OF CHAR := '' ;,  ?   [ASYNCHRONOUS] PROCEDURE Jump_Cld ; EXTERNAL ;	{ CLD module }V  "   BEGIN 	{ Get_And_Parse_Command }!   Get_And_Parse_Command := TRUE ;n  E   Rst := LIB$GET_FOREIGN (%DESCR Command) ;		{ Get the command line }.   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;	      Command := 'JUMP ' + Command ;>   Rst := CLI$DCL_PARSE (Command,Jump_Cld,%IMMED LIB$GET_INPUT,# 			%IMMED LIB$GET_INPUT,'JUMP> ') ;mM   IF (Rst = RMS$_EOF) OR (Rst = CLI$_NOCOMD) OR (NOT ODD (Rst)) THEN  $EXIT ;       Rst := CLI$PRESENT ('EXACT') ;@   Real_Mccoy := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;  "   Rst := CLI$PRESENT ('SETUSER') ;?   Alter_Ego := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;).   Transmute := NOT (Alter_Ego OR Real_Mccoy) ;     Rst := CLI$PRESENT ('ALL') ;L   Alter_Ego := Alter_Ego OR (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;  '   Rst := CLI$PRESENT ('OVERRIDE_UAF') ;s=   Figment := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;*     Rst := CLI$PRESENT ('LOG') ;9   Log := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;C      Rst := CLI$PRESENT ('AUDIT') ;>   Auditing := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;2   Get_Logical_Name (Lognam  := 'JUMP_AUDIT_TRAIL',B 		    Default := 'SYS_MANAGER:JUMP_AUDIT.DAT',   { SITE-specific } 		    Actual  := Audit_Trail,m 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;  2   Get_Logical_Name (Lognam  := 'JUMP_ACCESS_LIST',B 		    Default := 'SYS_MANAGER:JUMP_ACCESS.DAT',  { SITE-specific } 		    Actual  := Access_List,	 		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;  3   Get_Logical_Name (Lognam  := 'JUMP_DOUBLE_CHECK',B3 		    Default := 'TRUE',			       { SITE-specific }  		    Actual  := Str,  		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;&   Rst := STR$UPCASE (%DESCR Str,Str) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;F    Double_Check := Str = 'TRUE' ;  G   Rst := CLI$GET_VALUE ('USERNAME',New_User) ;	{ Assume will be there }D   IF Rst = CLI$_ABSENT	THEND8      New_User := User				{ Default to current username }    ELSE,   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)	    ELSE 
      BEGIN8      Rst := STR$TRIM (%DESCR New_User,%DESCR New_User) ;      IF NOT ODD (Rst)  THENa 	LIB$SIGNAL (Rst) ;	
      END ;  D   IF FIND_NONMEMBER (New_User,['A'..'Z','0'..'9','_','$']) <> 0 THEN
      BEGINI      WRITELN ('%JUMP-F-BADUSER, Username contains invalid characters.') ; %      Get_And_Parse_Command := FALSE ; 
      END ;$   END ; { of Get_And_Parse_Command }    $ FUNCTION Get_Target_Info : BOOLEAN ;  J { Get the required information for the particular new user from the UAF. }     VAR	Rst : INTEGER := 0 ;- 	Item_List : Item_List_Template (7) := ZERO ;r     BEGIN 	{ Get_Target_Info }#   Item_List[1].Buffer_Length := 8 ;d/   Item_List[1].Item_Code     := UAI$_DEF_PRIV ;l5   Item_List[1].Buffer_Addr   := IADDRESS (Def_Priv) ; #   Item_List[1].Return_Addr   := 0 ;a  #   Item_List[2].Buffer_Length := 8 ;f+   Item_List[2].Item_Code     := UAI$_PRIV ;n6   Item_List[2].Buffer_Addr   := IADDRESS (Auth_Priv) ;#   Item_List[2].Return_Addr   := 0 ;u  #   Item_List[3].Buffer_Length := 4 ; *   Item_List[3].Item_Code     := UAI$_UIC ;>   Item_List[3].Buffer_Addr   := IADDRESS (New_Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;   #   Item_List[4].Buffer_Length := 4 ;e,   Item_List[4].Item_Code     := UAI$_FLAGS ;2   Item_List[4].Buffer_Addr   := IADDRESS (Flags) ;#   Item_List[4].Return_Addr   := 0 ;o  0   Item_List[5].Buffer_Length := SIZE (Def_Dir) ;-   Item_List[5].Item_Code     := UAI$_DEFDIR ;i9   Item_List[5].Buffer_Addr   := IADDRESS (Def_Dir.BODY) ; #   Item_List[5].Return_Addr   := 0 ;9  0   Item_List[6].Buffer_Length := SIZE (Def_Dev) ;-   Item_List[6].Item_Code     := UAI$_DEFDEV ;r9   Item_List[6].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;p#   Item_List[6].Return_Addr   := 0 ;r  ?   Item_List[7].Terminator    := 0 ;	{ Terminate the item list }   I   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),3 		  Itmlst := Item_List) ;      Get_Target_Info := ODD (Rst) ;     IF NOT ODD (Rst)  THEN
      BEGIN      IF Rst <> RMS$_RNF  THENs 	LIB$SIGNAL (Rst) ;g      END    ELSE	
      BEGIN.      Def_Dir.LENGTH := INT (Def_Dir.BODY[1]) ;.      Def_Dev.LENGTH := INT (Def_Dev.BODY[1]) ;=      Def_Dir.BODY := SUBSTR (Def_Dir.BODY,2,Def_Dir.LENGTH) ; =      Def_Dev.BODY := SUBSTR (Def_Dev.BODY,2,Def_Dev.LENGTH) ; 
      END ;   END ; 	{ of Get_Target_Info }d    ( PROCEDURE Format_User (Uic : UIC$TYPE) ;  I { Create a string with the UIC in numeric and rights identifier formats }F     VAR  Rst : INTEGER := 0 ;D     BEGIN 	{ Format_User }G   Rst := $FAO ('!%U',Uic_Str.LENGTH,%STDESCR Uic_Str.BODY,%IMMED Uic) ;t   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;fE   Rst := $FAO ('!%I',Id_Str.LENGTH,%STDESCR Id_Str.BODY,%IMMED Uic) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;	   IF Uic_Str = Id_Str  THENe      Eq_Id_Str := ''    ELSE["      Eq_Id_Str := ' = ' + Id_Str ;   END ; 	{ of Format_User }.    % PROCEDURE Audit_Jump (Ok : BOOLEAN) ;T  < { Record who, when, where, how, etc. for auditing purposes }     VAR	Rst : UNSIGNED := 0 ;C( 	Imprint : VARYING [120] OF CHAR := '' ; 	Audit : TEXT ; - 	Stamp : PACKED ARRAY [1..23] OF CHAR := '' ;T     BEGIN 	{ Audit_Jump }RL   OPEN	 (Audit,FILE_NAME:=Audit_Trail,HISTORY:=Unknown,SHARING:=READWRITE) ;   EXTEND (Audit) ;  -   Rst := $ASCTIM (Timbuf := %STDESCR Stamp) ;c   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;},   IF Stamp[1] = ' '  THEN  Stamp[1] := '0' ;/   Imprint := SUBSTR (Stamp,1,20) + ' ' + User ;	
   IF Ok  THEN-
      BEGIN      Format_User (New_Uic) ;      IF New_User = User  THEN  	Imprint := Imprint + ' from '
       ELSE  	Imprint := Imprint + '  to  ' ;/      Imprint := Imprint + Uic_Str + Eq_Id_Str ;g      END    ELSEi9      Imprint := Imprint + ' PRIV violation: ' + Command ;)9   IF Real_Mccoy  THEN  Imprint := Imprint + ' *EXACT* ' ;18   IF Port <> ''  THEN  Imprint := Imprint + ' ' + Port ;@   IF Terminal <> ''  THEN  Imprint := Imprint + ' ' + Terminal ;     WRITELN (Audit,Imprint) ;C   CLOSE (Audit) ;o   END ; 	{ of Audit_Jump }    2 FUNCTION In_List (Hopeful : VARYING [L1] OF CHAR ;/ 		  Targets : VARYING [L2] OF CHAR) : BOOLEAN ;   L { Determine if a given string appears in a list of strings which may contain+   wildcarded values and "negated" values. }t     VAR	Spot : INTEGER := 0 ;V 	Rst : UNSIGNED := 0 ; 	Negated : BOOLEAN := FALSE ;e* 	Debutante : VARYING [120] OF CHAR := '' ;     BEGIN 	{ In-List }   In_List := FALSE ;   REPEAT!     Spot := INDEX (Targets,',') ;:     IF Spot = 0  THENo        Debutante := Targets]	      ELSE         BEGIN/        Debutante := SUBSTR (Targets,1,Spot-1) ;i@        Targets	 := SUBSTR (Targets,Spot+1,Targets.LENGTH-Spot) ;        END ;;     IF Debutante.LENGTH = 0  THEN  Exit (Bad_Access_Data) ;I     IF Debutante[1] = '!'  THEN         BEGIN=        Debutante := SUBSTR (Debutante,2,Debutante.LENGTH-1) ;s        Negated := TRUE ;
        END	      ELSEa        Negated := FALSE ;S/     Rst := STR$MATCH_WILD (Hopeful,Debutante) ;i     IF Rst = STR$_MATCH  THEN^        In_List := NOT Negated 	      ELSE 9     IF NOT ODD (Rst) AND_THEN (Rst <> STR$_NOMATCH)  THEN         LIB$SIGNAL (Rst) ;m   UNTIL (Spot = 0)   END ; 	{ of In-List }c     PROCEDURE Validate_Access ;R  F { For the type of user running the program, validate the user's access"   to the target user's UAF record.  D   Non-SysProgs can only jump (/NOEXACT) to users who do not have anyN   privileges other than those that are "OK".  (SITE-specific privilege list) }  @   CONST  Ok_Privs = [Group,Grpprv,Grpnam,Netmbx,Tmpmbx,Prmceb] ;     VAR	Rst , I : INTEGER := 0 ;* 	Chekov ,			{ User has JUMP's rights ID? }1 	Sysprog ,			{ SETPRV or group <= MAXSYSGROUP ? }v 	Operator ,			{ OPER ? }- 	Priv_Target ,			{ Target is "privileged" ? }	? 	Access_Ok : BOOLEAN := FALSE ;	{ All access list checks ok ? }m 	Jump_Id : $UQUAD := ZERO ;A  (   FUNCTION Check_Access_List : BOOLEAN ;  K   { Determine if the caller is specifically authorised to access the targetN(     user in the access list data file. }       VAR Spot : INTEGER := 0 ;Y 	Rst : UNSIGNED := 0 ; 	Valid : BOOLEAN := FALSE ;i0 	Src , Dst , Buf : VARYING [120] OF CHAR := '' ; 	Access : TEXT ;       BEGIN	{ Check_Access_List } G     OPEN (Access,FILE_NAME:=Access_List,HISTORY:=Old,SHARING:=READONLY,n 		 Error:=CONTINUE) ;r     Rst := STATUS (Access) ;      IF Rst = PAS$K_SUCCESS  THEN        BEGIN        RESET (Access) ; ,        WHILE NOT (EOF (Access) OR Valid)  DO 	 BEGIN( 	 READLN (Access,Buf) ;T2 	 Str_Compress (Buf,Buf,TRUE) ;			{ Squeeeeeeze! }& 	 Rst := STR$UPCASE (%DESCR Buf,Buf) ; 	 IF NOT ODD (Rst)  THEN 	    LIB$SIGNAL (Rst) ; I 	 IF (Buf.LENGTH > 0) AND_THEN (Buf[1] <> '#')  THEN    { Not a comment }n
 	    BEGIN 	    Spot := INDEX (Buf,':') ;0 	    IF Spot = 0  THEN  Exit (Bad_Access_Data) ;$ 	    Src  := SUBSTR (Buf,1,Spot-1) ;2 	    Dst  := SUBSTR (Buf,Spot+1,Buf.LENGTH-Spot) ;6 	    Spot := INDEX (Dst,'#') ;			{ Trailing comment? } 	    IF Spot > 0  THEN& 	       Dst := SUBSTR (Dst,1,Spot-1) ;@ 	    IF (Src = '') OR (Dst = '')  THEN  Exit (Bad_Access_Data) ;B 	    Valid := In_List (User,Src) AND_THEN In_List (New_User,Dst) ;
 	    END ; 	 END ;I        CLOSE (Access) ;E
        END	      ELSEp#     IF Rst <> PAS$K_FILNOTFOU  THEN[        BEGINL        WRITELN ('JUMP-F-BADACCFIL, Failed to open access list file; error ',
 		Rst:1) ;        $EXIT ;        END ;      Check_Access_List := Valid ;"     END ;	{ of Check_Access_List }     BEGIN 	{ Validate_Access }  G   { Check that the invoker has the required access to run this program.CH     This is independant of any installed privileges.  Identify SysProgs.C     If need be, check to see if process has JUMP_ACCESS rights ID }      IF Double_Check  THENF
      BEGIN.      Rst := $ASCTOID (Name   := 'JUMP_ACCESS', 		      Id     := Jump_Id.L0,  		      Attrib := Jump_Id.L1) ;       IF NOT ODD (Rst)  THENe 	LIB$SIGNAL (Rst) ;_
      I := 1 ;       REPEATE,        Chekov := Jump_Id.L0 = Rights[I].L0 ;        I := I + 1 ;F&      UNTIL Chekov OR (I > Rightsize) ;
      END ;     IF Proc_Cnt > 0  THENR
      BEGINN      WRITELN ('%JUMP-F-NOSUB, Cannot JUMP while process has sub-processes.') ;      $EXIT ;      END    ELSEl   IF Pid <> Master_Pid	THEN 
      BEGINC      WRITELN ('%JUMP-F-NOINSUB, Cannot JUMP from a sub-process.') ;       $EXIT ;      END    ELSE(
      BEGIN6      Sysprog  := (Uic.UIC$V_GROUP <= Max_Sys_Group) OR  		 (Setprv IN Proc_Auth_Priv) OR 		 (Setprv IN Proc_Def_Priv) ;  ,      Operator := (Oper IN Proc_Auth_Priv) OR 		 (Oper IN Proc_Def_Priv) ;
      END ;  $   Access_Ok := Check_Access_List AND% 	       ((Double_Check AND Chekov) OR: 		(NOT Double_Check)) ;t     IF NOT Get_Target_Info  THEN      IF Figment  THENBE 	WRITELN ('%JUMP-W-INVUSER, Invalid username - user does not exist.')F
       ELSE 	BEGING 	WRITELN ('%JUMP-F-INVUSER, Invalid username - user does not exist.') ;  	$EXIT (RMS$_RNF) ;( 	END ;  2   Priv_Target := ((Auth_Priv - Ok_Privs) <> []) OR$ 		 ((Def_Priv  - Ok_Privs) <> []) OR+ 		 (New_Uic.UIC$V_GROUP <= Max_Sys_Group) ;N     IF (NOT (Sysprog OR  	   Access_Ok OR% 	   (Operator AND NOT Priv_Target) ORL 	   (New_User = User))) OR&      (Alter_Ego AND NOT Sysprog)  THEN
      BEGIN      Audit_Jump (FALSE) ;a      $EXIT (SS$_NOPRIV) ;c
      END ;  '   IF NOT Auditing AND NOT Sysprog  THENs
      BEGIN$      WRITELN ('%JUMP-F-MUSTAUDIT, ',: 	      'Only Systems Programmers may disable auditing.') ;      $EXIT (SS$_NOPRIV) ;X
      END ;  *   IF Alter_Ego AND (New_User = User)  THEN
      BEGINB      WRITELN ('%JUMP-I-SAMEUSER, Same username as current (',User,  	      ') - no action taken.') ;      $EXIT ;
      END ;  -   IF Real_Mccoy AND Flags.UAI$V_DISACNT  THENs7      Exit ('%JUMP-F-DISABLED, Username is disabled.') ;;     IF Transmute	THEN{/      IF New_Uic.UIC$L_UIC = Uic.UIC$L_UIC  THEN  	BEGIN 	Format_User (Uic) ;; 	WRITELN ('%JUMP-I-SAMEUIC, Same UIC as current (',Uic_Str,m 		 ') - no action taken.') ; 	$EXIT ; 	END
       ELSE=      IF (Flags.UAI$V_RESTRICTED OR Flags.UAI$V_CAPTIVE)  THEN  	IF Sysprog  THEN,D 	   WRITELN ('%JUMP-W-RESTRICT, Username is Restricted or Captive.') 	 ELSE	 	   BEGIN F 	   WRITELN ('%JUMP-F-RESTRICT, Username is Restricted or Captive.') ; 	   $EXIT (SS$_NOPRIV) ; 	   ENDE
       ELSE!      IF Flags.UAI$V_DISACNT  THENJ 	IF Sysprog  THENF7 	   WRITELN ('%JUMP-W-DISABLED, Username is disabled.')  	 ELSE	 	   BEGINS9 	   WRITELN ('%JUMP-F-DISABLED, Username is disabled.') ;	 	   $EXIT (SS$_NOPRIV) ;	 	   END ;S   END ; 	{ of Validate_Access }K    - [ASYNCHRONOUS,Check(None)] PROCEDURE Getuic ;D  - { In EXEC MODE, peek at the UIC in the PCB. }      BEGINE$   Sanity_Uic.UIC$L_UIC := Uic_Ptr^ ;   END ;s    - [ASYNCHRONOUS,Check(None)] PROCEDURE Setuic ;D  0 { In KERNEL MODE, poke a new UIC into the PCB. }     BEGIN !   Uic_Ptr^ := New_Uic.UIC$L_UIC ;    END ;     7 [ASYNCHRONOUS,Check(None)] PROCEDURE Get_Jib_User_Ptr ;l  - { In EXEC MODE, peek at the JIB in the PCB. }e     BEGIN &   Jib_User_Ptr::UNSIGNED := Jib_Ptr^ ;   END ;s    . [ASYNCHRONOUS,Check(None)] PROCEDURE Getuser ;  L { In EXEC MODE, peek at the Username in the Control Region and in the PCB. }     BEGIN:%   Sanity_Ctl_User := CTL$T_USERNAME ; $   Sanity_Jib_User := Jib_User_Ptr^ ;   END ;     . [ASYNCHRONOUS,Check(None)] PROCEDURE Setuser ;  P { In KERNEL MODE, poke a new Username into the Control Region and into the PCB.}     BEGIN #   CTL$T_USERNAME := New_User.BODY ;	#   Jib_User_Ptr^  := New_User.BODY ;s   END ;     . PROCEDURE Poteroo (Faking : BOOLEAN := TRUE) ;  > { Change the UIC.  Do sanity checks except when reverting from   pseudo-terminal. }     BEGIN 	{ Poteroo }  J   { Check that the UIC as returned by GETJPI and as peeked at in EXEC MODE)     agree -- do this as a sanity check. }   :   Uic_Ptr::UNSIGNED := CTL$GL_PCB + IADDRESS (PCB$L_UIC) ;   $CMEXEC (Getuic,%IMMED 0) ;L  =   IF Faking AND (Sanity_Uic.UIC$L_UIC <> Uic.UIC$L_UIC)  THEN[
      BEGINB      WRITELN ('%JUMP-F-INSANEUIC, Sanity Check FAILED for UIC!') ;L      WRITELN ('%JUMP-F-UICVALUES, GetUAI =',HEX (Uic.UIC$L_UIC),' Kernel =',$ 	      HEX (Sanity_Uic.UIC$L_UIC)) ;      $EXIT (SS$_ABORT) ;      END    ELSE A      $CMKRNL (Setuic,%IMMED 0) ;	{ Change UIC to be target UIC. }    END ; 	{ of Poteroo }     . PROCEDURE Wallaby (Faking : BOOLEAN := TRUE) ;  B { Change the username.	Do sanity checks except when reverting from   pseudo-terminal }e     BEGIN 	{ Wallaby }  O   { Check that the username as returned by GETJPI and as peeked at in EXEC MODE )     agree -- do this as a sanity check. }h  :   Jib_Ptr::UNSIGNED := CTL$GL_PCB + IADDRESS (PCB$L_JIB) ;'   $CMEXEC (Get_Jib_User_Ptr,%IMMED 0) ;P  P   Jib_User_Ptr::UNSIGNED := Jib_User_Ptr::UNSIGNED + IADDRESS (JIB$T_USERNAME) ;   $CMEXEC (Getuser,%IMMED 0) ;  3   IF Faking AND ((Sanity_Ctl_User <> User.BODY)  ORE*      (Sanity_Jib_User <> User.BODY))  THEN
      BEGINH      WRITELN ('%JUMP-F-INSANEUSER, Sanity Check FAILED for Username!') ;A      WRITELN ('%JUMP-F-USERVALUES, GetJPI = ',User,' Control = ',A3 	      Sanity_Ctl_User,' JIB = ',Sanity_Jib_User) ;       $EXIT (SS$_ABORT) ;      END    ELSEf!      $CMKRNL (Setuser,%IMMED 0) ;;   END ; 	{ of Wallaby }e     PROCEDURE Kangaroo ;  H { Do all that is required to "jump" to the new user, or to return to the   original user. }  (   VAR	Rst , Attributes : UNSIGNED := 0 ;& 	Aclstr : VARYING [64] OF CHAR := '' ;. 	Aclent : PACKED ARRAY [1..32] OF CHAR := '' ;. 	Grptbl : PACKED ARRAY [1..16] OF CHAR := '' ;- 	Item_List : Item_List_Template (3) := ZERO ;      BEGIN 	{ Kangaroo }r     { Set new UIC. }     Poteroo ;e      { Set new default directory. }  ?   Rst := SYS$SETDDIR (SUBSTR (Def_Dir.BODY,1,Def_Dir.LENGTH)) ;L   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;T     { Set new default disk. }   0   Item_List[1].Buffer_Length := Def_Dev.LENGTH ;-   Item_List[1].Item_Code     := LNM$_STRING ;t9   Item_List[1].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;d#   Item_List[1].Return_Addr   := 0 ;n  #   Item_List[2].Terminator    := 0 ;b  3   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS', " 		  Lognam := %STDESCR 'SYS$DISK', 		  Acmode := PSL$C_SUPER, 		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;}  9   { Point LNM$GROUP logical to group table for new UIC. }I      Attributes := LNM$M_TERMINAL ;:   Grptbl := 'LNM$GROUP_' + OCT (New_Uic.UIC$V_GROUP,6,6) ;  #   Item_List[1].Buffer_Length := 4 ;;1   Item_List[1].Item_Code     := LNM$_ATTRIBUTES ;I7   Item_List[1].Buffer_Addr   := IADDRESS (Attributes) ;(#   Item_List[1].Return_Addr   := 0 ;)  /   Item_List[2].Buffer_Length := SIZE (Grptbl) ;P-   Item_List[2].Item_Code     := LNM$_STRING ;_3   Item_List[2].Buffer_Addr   := IADDRESS (Grptbl) ;P#   Item_List[2].Return_Addr   := 0 ;(  #   Item_List[3].Terminator    := 0 ;U  =   Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS_DIRECTORY', # 		  Lognam := %STDESCR 'LNM$GROUP',  		  Acmode := PSL$C_KERNEL,R 		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;   M   { If going to a different UIC, allow the current LNM$JOB logical name tableEM     to be accessed by the new UIC.  If returning to original user, remove the $     ACL access previously applied. }      Item_List[2].Terminator := 0 ;  8   IF New_User = User  THEN		{ Return to original user. }
      BEGIN&      Item_List[1].Buffer_Length := 0 ;3      Item_List[1].Item_Code	   := ACL$C_DELETEACL ;T$      Item_List[1].Buffer_Addr	:= 0 ;$      Item_List[1].Return_Addr	:= 0 ;      END    ELSEo
      BEGINB      Aclstr := '(IDENTIFIER=' + New_User + ',ACCESS=READ+WRITE)' ;G      Rst := $PARSE_ACL (Aclstr := SUBSTR (Aclstr.BODY,1,Aclstr.LENGTH),Y 			Aclent := %STDESCR Aclent) ;E      IF NOT ODD (Rst)  THENo 	LIB$SIGNAL (Rst) ;_  4      Item_List[1].Buffer_Length := INT (Aclent[1]) ;3      Item_List[1].Item_Code	   := ACL$C_ADDACLENT ;$4      Item_List[1].Buffer_Addr	:= IADDRESS (Aclent) ;$      Item_List[1].Return_Addr	:= 0 ;
      END ;  9   Rst := $CHANGE_ACL (Objtyp := ACL$C_LOGICAL_NAME_TABLE,; 		      Objnam := 'LNM$JOB', 		      Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;N   END ; 	{ of Kangaroo }     PROCEDURE Display_Jump ;  * { Display data about the requested jump. }     BEGIN 	{ Display_Jump }N   IF Transmute	THENM
      BEGIN4      WRITELN ('%JUMP-S-JUMPED, ',User,' jumped to ',- 	      New_User,' (',Uic_Str,Eq_Id_Str,')') ;_?      WRITELN ('%JUMP-I-DEFAULT, Default is ',Def_Dev,Def_Dir) ;B
      END ;     IF Alter_Ego	THENRO      WRITELN ('%JUMP-S-SETUSER, Changed username from ',User,' to ',New_User) ;    END ; 	{ of Display_Jump }    6 PROCEDURE Get_Channel (Device : VARYING [L1] OF CHAR ;+ 		       VAR Channel : [VOLATILE] $UWORD) ;e  ! { Assign a channel to a device. }      VAR Rst : UNSIGNED := 0 ;I     BEGIN 	{ Get_Channel }#   Rst := $ASSIGN (Devnam := Device,r 		  Chan	 := Channel) ;]   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Get_Channel }L    / PROCEDURE Exit_Handler (Condition : UNSIGNED) ;m  * { Clean up on exit from pseudo-terminal. }     VAR Rst  : UNSIGNED := 0 ;(       Iosb : Status_Block_Type := ZERO ;     BEGIN 	{ Exit_Handler }   #   $SETAST (0) ; 			{ Disable ASTs }R     IF Pseudo_Ft	THEN 
      BEGINB      Rst := PTD$CANCEL (Pchan) ;	{ Cancel I/O to pseudo-terminal }      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;.  ;      Rst := PTD$DELETE (Pchan) ;	{ Delete pseudo-terminal }s      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;e      END    ELSE;=      $DASSGN (Pchan) ;			{ Deassign pseudo-terminal channel }s  6   $CANCEL (Rchan) ;			{ Cancel I/Os on real terminal }  D   Rst := $QIOW (Chan := Rchan,		{ Restore original characteristics } 		Func := IO$_SETMODE, 		Iosb := Iosb,e 		P1   := Rchars,t 		P2   := 12) ;_   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE_   IF NOT ODD (Iosb[1])	THENo      LIB$SIGNAL (Iosb[1]) ;t  '   $DASSGN (Rchan) ;			{ Shut up shop. }e     END ; 	{ of Exit_Handler }    $ [ASYNCHRONOUS] PROCEDURE Rchan_Ast ;  J { Called when a keystroke occurs on the real keyboard - the keystrokes are:   passed to the pseudo-terminal and another read queued. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Rchan_Ast}T   IF Pseudo_Ft	THEN 
      BEGIN'      Rst := PTD$WRITE (Chan	  := Pchan,R" 		       Wrtbuf	  := Buffer[Wsts], 		       Wrtbuf_Len := 1) ;T      IF NOT ODD (Rst)  THENf 	LIB$SIGNAL (Rst) ;e  !      Rst := $QIO (Chan	 := Rchan,= 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wbuf], 		  P2	 := 1) ;E      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;       END    ELSEo
      BEGIN       Rst := $QIO (Chan := Pchan, 		  Func := IO$_WRITEVBLK, 		  P1   := Buffer[Wsts],t 		  P2   := 1) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;s  !      Rst := $QIO (Chan	 := Rchan,S 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wsts], 		  P2	 := 1) ;       IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;c
      END ;   END ; 	{ of Rchan_Ast }B    $ [ASYNCHRONOUS] PROCEDURE Pchan_Ast ;  M { Called when characters are received from the pseudo-terminal - the data are 6   passed to the real screen and another read queued. }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ Pchan_Ast }   IF Pseudo_Ft	THENA
      BEGIN#      Rst := $QIOW (Chan   := Rchan,] 		   Func   := IO$_WRITEVBLK,  		   P1	  := Buffer[Rbuf], 		   P2	  := Buffer[Rcnt]) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;i  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast," 		      Readbuf	  := Buffer[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;       IF NOT ODD (Rst)  THENa 	LIB$SIGNAL (Rst) ;a      END    ELSEm
      BEGIN!      Rst := $QIOW (Chan := Rchan,  		   Func := IO$_WRITEVBLK,  		   P1	:= Buffer[Rsts], 		   P2	:= Piosb[2]) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ;   !      Rst := $QIO (Chan	 := Pchan,  		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,  		  Astadr := Pchan_Ast, 		  P1	 := Buffer[Rsts], 		  P2	 := Py_Buflen) ;       IF NOT ODD (Rst)  THEN: 	LIB$SIGNAL (Rst) ; 
      END ;   END ; 	{ of Pchan_Ast }       [ASYNCHRONOUS] PROCEDURE Mbast ;  F { Invoked by the detached process termination mailbox AST - WAKE UP! }     VAR  Rst : UNSIGNED := 0 ;     BEGIN 	{ MBast }   Rst := $WAKE ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;t   END ; 	{ of MBast }R     PROCEDURE Transmography ;f  L { Create a pseudo-terminal connected to a detached process and actually *be*
   the user! }d     TYPE  8   Desc_Blk = PACKED RECORD			{ Exit handler descriptor } 	       Fwd_Link : UNSIGNED ; & 	       Exit_Handler_Addr : UNSIGNED ; 	       Argcnt : $UBYTE ; 5 	       Fill_Zero : [UNSAFE] ARRAY [1..3] OF $UBYTE ;e 	       Condition ,o0 	       P2 , P3 , P4 , P5 , P6 , P7 : UNSIGNED ; 	     END VALUE ZERO ;     VARn      Rst , Mbunit : UNSIGNED := 0 ;%   Newchars : Terminal_Chars := ZERO ;+)   Exit_Desc : [STATIC] Desc_Blk := ZERO ; $   Iosb : Status_Block_Type := ZERO ;.   Item_List : Item_List_Template (2) := ZERO ;  7   FUNCTION Find_Device (Device : VARYING [L1] OF CHAR ;,$ 			Chan   : $UWORD := 0) : BOOLEAN ;  7   { Determine if a device exists and return its name. }        VAR Rst : UNSIGNED := 0 ;p# 	Iosb : Status_Block_Type := ZERO ;_- 	Item_List : Item_List_Template (2) := ZERO ;        BEGIN	{ Find_Device })     Find_Device := TRUE ;T  4     Item_List[1].Buffer_Length := SIZE (Pdev.BODY) ;/     Item_List[1].Item_Code     := DVI$_DEVNAM ;a8     Item_List[1].Buffer_Addr   := IADDRESS (Pdev.BODY) ;:     Item_List[1].Return_Addr   := IADDRESS (Pdev.LENGTH) ;  B     Item_List[2].Terminator    := 0 ;		{ Terminate the item list }  C     IF (Chan = 0) AND (Device <> '')  THEN	{ Device name supplied }i,        Rst := $GETDVIW (Itmlst := Item_List, 			Devnam := Device, 			Iosb   := Iosb))      ELSE					{ Channel number supplied } ,        Rst := $GETDVIW (Itmlst := Item_List, 			Chan   := Chan, 			Iosb   := Iosb) ;        IF Rst = SS$_NOSUCHDEV  THEN        Find_Device := FALSE		      ELSEk     IF NOT ODD (Rst)  THEN        LIB$SIGNAL (Rst)m	      ELSE:     IF NOT ODD (Iosb[1])  THEN        LIB$SIGNAL (Iosb[1]) ;      END ;	{ of Find_Device }       BEGIN 	{ Transmography }  I   { Determine which pseudo-terminal type (if any) exists on the system. }I  &   Pseudo_Ft := Find_Device ('FTA0:') ;   IF NOT Pseudo_Ft  THEN'      IF NOT Find_Device ('PYA0:')  THENRB 	Exit ('%JUMP-F-NOPSEUDO, No pseudo-terminal driver on system.') ;     Get_Channel ('TT:',Rchan) ;s  I   { Get current (real) terminal process-specific device characteristics }      Rst := $QIOW (Chan := Rchan, 		Func := IO$_SENSEMODE, 		Iosb := Iosb,e 		P1   := Rchars,E 		P2   := 12) ;)     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSEp   IF NOT ODD (Iosb[1])	THENe      LIB$SIGNAL (Iosb[1]) ;S  )   { Set up and declare the exit handler }N  :   Exit_Desc.Exit_Handler_Addr := IADDRESS (Exit_Handler) ;   Exit_Desc.Argcnt := 1 ; .   Exit_Desc.Condition := IADDRESS (Exit_Rst) ;  (   Rst := $DCLEXH (Desblk := Exit_Desc) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;;  &   { Set new terminal characteristics }     Newchars := Rchars ;.   Newchars.Tt_Devchar.TT$V_NOECHO    := TRUE ;/   Newchars.Tt_Devchar.TT$V_WRAP      := FALSE ;o.   Newchars.Tt_Devchar2.TT2$V_PASTHRU := TRUE ;     Rst := $QIOW (Chan := Rchan, 		Func := IO$_SETMODE, 		Iosb := Iosb,  		P1   := Newchars,  		P2   := 12) ;      IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE<   IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;M  &   Wallaby ;	{ Change to new username }!   Poteroo ;	{ Change to new UIC }$      { Create the pseudo-terminal }  &   Pbuf_Range[1] := IADDRESS (Buffer) ;6   Pbuf_Range[2] := Pbuf_Range[1] + Io_Buflen * 2 - 1 ;     IF Pseudo_Ft	THENt
      BEGIN'      Rst := PTD$CREATE (Chan  := Pchan,  			Inadr := Pbuf_Range) ;d      IF NOT ODD (Rst)  THENg 	LIB$SIGNAL (Rst) ;h      END    ELSEs
      BEGIN"      Get_Channel ('PYA0:',Pchan) ;
      END ;  8   Find_Device ('',Pchan) ;		{ Sets Pdev to device name }  E   { Create a termination mailbox for the soon-to-be detached process,      and get its unit number }A  !   Rst := $CREMBX (Chan	 := Mchan,A 		  Maxmsg := ACC$K_TERMLEN) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;C  #   Item_List[1].Buffer_Length := 4 ; +   Item_List[1].Item_Code     := DVI$_UNIT ;W3   Item_List[1].Buffer_Addr   := IADDRESS (Mbunit) ; #   Item_List[1].Return_Addr   := 0 ;   ?   Item_List[2].Terminator    := 0 ;	{ Terminate the item list }E  '   Rst := $GETDVIW (Itmlst := Item_List,b 		   Chan   := Mchan,X 		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)=    ELSEG   IF NOT ODD (Iosb[1])	THENA      LIB$SIGNAL (Iosb[1]) ;r  /   { Queue an asynchronous read to the mailbox }t     Rst := $QIO (Chan   := Mchan,i 	       Func   := IO$_READVBLK,= 	       Astadr := Mbast, 	       P1     := Mbbuf," 	       P2     := ACC$K_TERMLEN) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;T  J   WRITELN ('%JUMP-S-TRANSFER, Control transferred to user ',New_User,Lf) ;  !   { Create the detached process }F  6   Rst := $CREPRC (Image  := 'SYS$SYSTEM:LOGINOUT.EXE', 		  INPUT  := Pdev,E 		  OUTPUT := Pdev,  		  Baspri := 4, 		  Mbxunt := Mbunit,(> 		  Stsflg := PRC$M_DETACH + PRC$M_INTER + PRC$M_NOPASSWORD) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;O     { Restore username and UIC }     New_User := User ;   New_Uic  := Uic ;(  3   Wallaby (FALSE) ;	{ Change to original username }t.   Poteroo (FALSE) ;	{ Change to original UIC }  O   { Queue the appropriate reads to both the real terminal and pseudo-terminal }U     IF Pseudo_Ft	THEN 
      BEGIN!      Rst := $QIO (Chan	 := Rchan,n 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wbuf], 		  P2	 := 1) ;       IF NOT ODD (Rst)  THENI 	LIB$SIGNAL (Rst) ;a  &      Rst := PTD$READ (Chan	  := Pchan, 		      Astadr	  := Pchan_Ast," 		      Readbuf	  := Buffer[Rsts],# 		      Readbuf_Len := Ft_Buflen) ;J      IF NOT ODD (Rst)  THENi 	LIB$SIGNAL (Rst) ;T      END    ELSE 
      BEGIN!      Rst := $QIO (Chan	 := Rchan,B 		  Func	 := IO$_READVBLK, 		  Astadr := Rchan_Ast, 		  P1	 := Buffer[Wsts], 		  P2	 := 1) ;       IF NOT ODD (Rst)  THEN; 	LIB$SIGNAL (Rst) ;   !      Rst := $QIO (Chan	 := Pchan,s 		  Func	 := IO$_READVBLK, 		  Iosb	 := Piosb,R 		  Astadr := Pchan_Ast, 		  P1	 := Buffer[Rsts], 		  P2	 := Py_Buflen) ;E      IF NOT ODD (Rst)  THENE 	LIB$SIGNAL (Rst) ;e
      END ;  >   { Hibernate until termination mailbox message wakes us up. }  
   $HIBER ;  D   WRITELN ('%JUMP-S-RETURN, Control returned to user ',User,Lf,Lf) ;   END ; 	{ of Transmography }     E { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * C   * * * * * * * * * *	M A I N   P R O G R A M   * * * * * * * * * * G   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }a     BEGIN	{ Jump }   Get_Caller_Info ;a   IF Get_And_Parse_Command  THEN    BEGIN)    Validate_Access ;			{ Stop intruders }t      IF Real_Mccoy  THEN       BEGINU6       IF Auditing  THEN 		{ Audit first in this case } 	 Audit_Jump (TRUE) ; "       Transmography ;			{ Clone! }	       ENDU     ELSE       BEGIN -       IF Alter_Ego  THEN		{ Change username }  	 Wallaby ;P(       IF Transmute  THEN		{ Long jump! } 	 BEGINN4 	 Kangaroo ;			{ Boing! Change miscellany of items } 	 IF Auditing  THENe 	    Audit_Jump (TRUE) 	  ELSE  	    Format_User (New_Uic) ; 	 END ;="       IF Log  THEN  Display_Jump ;       END ;_    END ;   END.	{ of it all }