/*
 * fileops.c -- file operations for UNIX versions of translators.
 *  12-MAR-1995, David Mathog - also for VMS, using the rule: if it has a "/"
 *     then it must be unix specific!
 */
/*
 * UnixOpenLibFile () - Open a library file.  Looks in the following
 * directories:
 * - Looks in current directory.
 * - if RTFLIBDIR environment variable is set, looks in directory named by it.
 * - Looks in executable program's directory, if UnixSetProgPath() has
 * been called.
 * - Looks in library directory, LIBDIR.
 *
 * Exception: if file is an absolute pathname, look only for file as named.
 *
 * Returns NULL if file cannot be found and opened.
 */
 
# include	<stdio.h>
#ifdef __VMS
#include <string.h>
#define REPSTRING "%s%s"
#else
#define REPSTRING "%s/%s"
#endif
 
# include	"rtf.h"
# include	"rtf-unix.h"
 
extern char	*getenv ();
 
static char	*progPath = (char *) NULL;
 
 
void
UnixSetProgPath (path)
char	*path;
{
int	i, j, n;

	n = strlen (path);
	for (j = -1, i = 0; i < n; i++)
	{
#ifdef __VMS  /*It should ALWAYS find one "]", and we need to KEEP it */
		if (path[i] == ']')
			j = i + 1;
#else
		if (path[i] == '/')
			j = i;
#endif /*__VMS*/
	}
	if (j < 0)		/* no slash found */
	{
		path = ".";
		j = 1;
	}
	if ((progPath = RTFAlloc (j + 1)) != (char *) NULL)
	{
		(void) strncpy (progPath, path, j);
		progPath[j] = '\0';
	}
}
 
 
FILE *
UnixOpenLibFile (file, mode)
char	*file;
char	*mode;
{
FILE	*f;
char	buf[rtfBufSiz];
char	*p;
 
	if ((f = fopen (file, mode)) != (FILE *) NULL)
	{
		return (f);
	}
#ifndef __VMS  /* Not so easy for VMS, skip this */
	/* if abolute pathname, give up, else look in library */
	if (file[0] == '/')
	{
		return ((FILE *) NULL);
	}
#endif
	if ((p = getenv ("RTFLIBDIR")) != (char *) NULL)
	{
		sprintf (buf, REPSTRING, p, file);
		if ((f = fopen (buf, mode)) != (FILE *) NULL)
			return (f);
	}
	if (progPath != (char *) NULL)
	{
		sprintf (buf, REPSTRING, progPath, file);
		if ((f = fopen (buf, mode)) != (FILE *) NULL)
			return (f);
	}
	sprintf (buf, REPSTRING, LIBDIR, file);
	f = fopen (buf, mode);	/* NULL if it fails */
	return (f);
}
