 #  /*  *			c h r t a b . h  */    #ifdef	DOCUMENTATION  9 title	chrtab	Header file for the character table chrtab[] 3 index		Header file for the character table chrtab[]    synopsis   	#include <chrtab.h>   description   E 	This file defines the compile-time constants used in chrtab[], which C 	it globalizes.  It is only needed if you want to refer to chrtab[] G 	directly; the various "is" functions that use the table will work with  	or without it.  	.s G 	The characteristics of characters are defined by bits turned on in the > 	array element corresponding to them.  Thus, chrtab['a'] givesF 	information about 'a'.  chrtab[] is 128 bytes long and should only be" 	refered to with 7-bit characters. 	.s C 	At present, no character has more than one bit turned on; this may C 	change.  Only 5 bits are defined; the first unused bit is FREEBIT. E 	You can modify the table by OR'ing in bits starting with FREEBIT (up  	through bit value 128). 	.s ! 	The bits are defined as follows:  	.s.nf 		LOWER		a-z 		UPPER		A-Z 		DIGIT		0-9% 		WHITE		<SPACE>, <TAB>, <LF> ('\n'),  				<VT>, <FF> ('\f')  		MARK		Any of !.,:;?  	.s.f 8 	The following useful bit combinations are also defined: 	.s.nf 		ALPHA		LOWER | UPPER 		ALFNUM		ALPHA | DIGIT  	.f  Bugs  D 	The definition of whitespace is not the same as the UNIX definitionF 	(which doesn't include <VT> or <FF>).  However, it seems more correct 	philosophically.  	.s D 	Perhaps <CR> ('\r') should also be whitespace, for the same reason.   Author   	Jerry Leichter  #endif    /*
 )EDITLEVEL=06   *  * Edit history   * 0.0 13-May-81 JSL	Invention@  * 0.1 21-May-81 JSL	Conversion to new documentation conventions  */   - #ifndef _CHRTAB_				/* Don't do this twice */  #define _CHRTAB_   extern char chrtab[128];  + #define LOWER		1			/* Lower case letters */ + #define UPPER		2			/* Upper case letters */  #define DIGIT		4			/* Digits */ # #define WHITE		8			/* Whitespace */ * #define MARK		16			/* Punctuation marks */1 #define ALPHA		(UPPER | LOWER)		/* Alphabetics */ ; #define ALFNUM		(UPPER | LOWER | DIGIT)	/* Alphanumerics */   * #define FREEBIT		32			/* First free bit */   #endif