 /*  *				i n i t i a . h   */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  1 title	initial	Specify Initializers and Finalizers * index		Specify initializers and finalizers   synopsis   	 #include <initia.h>   	 	 INITIAL  	 { initial-code-block };    	 FINAL  	 { final-code-block };    description   9 	The macros defined in this module provide a facility for @ 	module-specific initialization and finalization code.  The codeB 	in the initial-code-block is called as a normal C function beforeE 	main() is called; the final-code-block is called on exit, just after 
 	wrapup().  # 	Neither call passes any arguments.   < 	Any number of modules in an image may independently declareE 	initializers or finalizers; all of them will be called at startup or F 	exit.  However, it is impossible to predict what order the calls willE 	be made in, and programs should not rely on any particular ordering.   ? 	A typical use of initializers and finalizers is the following: E 	Suppose you have a package that supports access to some on-disk data G 	base; a user of the package will call a lookup and an update function. G 	The file containing the data base must be opened before any operations B 	on it can take place, and it should be closed when the program isD 	finished.  (Assume that the package maintains some sort of residentD 	buffer which it must flush.)  There are two conventional approachesE 	to solving this problem:  Have the lookup and update functions check G 	the file on each call, and open it if necessary - which could be quite E 	expensive if they are very small functions, and in any case does not B 	solve the problem of properly closing the file - or have the mainG 	program call an initialization and finalization function at the proper E 	time.  The problem with this latter approach is lack of modularity - A 	the main program ought not to have to know that the module needs   	initialization or finalization.  B 	The solution using these macros is straightforward.  The defining 	module includes the calls:   	 		INITIAL  		{ open-the-data-base };    		FINAL , 		{ flush-buffers-and-close-the-data-base };  E 	The wrapup() function is treated like a built-in finalizer; however, F 	it is guaranteed to execute before any other finalizers.  (The module@ 	defining wrapup() may declare an initializer or finalizer if it@ 	wishes; it will be treated just like all other initializers and
 	finalizers.)   ? 	If any finalizer (or wrapup()) calls exit(), the program exits 
 	immediately.   E 	Notes:  Using INITIAL will declare a static function named $init$(), D 	and a (char *) named $init_; similarly, FINAL will declare $finl$()C 	and $finl_.  Also, both INITIAL and FINAL generate dsect commands. E 	Since C provides no way to "remember" the current dsect, both macros E 	issue a dsect "" command when they are done, restoring the C default  	dsect.   C 	While it is a poor idea to write code that depends on the order in C 	which initializers and finalizers are executed, this can be useful E 	information to have for debugging.  Execution is always in the order G 	that the modules involved were examined by the task builder or linker. F 	When the modules are named explicitly, this will just be the order inA 	which they were named.  When the modules come from a library, it D 	will be extremely difficult to predict the order in which they will 	be extracted and linked in.  D 	Warning:  While initializers and finalizers provide some modularityD 	to package initialization and finalization, they are not a panacea.B 	For example, if package A calls routines in package B from within@ 	its initializers, and package B also declares initializers, theD 	correct functioning of a program that includes both - hence, of any1 	program using package A - will be problematical.    internal  F 	The macros operate by leaving a list of (pointers to) functions to beF 	called in psects $INIT$ and $FINL$.  In order to be able to determine@ 	the beginning and end of these psects, the psects $INIT, $FINL,G 	$INIT., and $FINL., are also reserved.  These psects must not actually F 	contain any data; they exist solely to provide well-defined endpoints< 	to the initialization and finalization list.  The names areE 	consecutive in alphabetical sequence, so the Task Builder will place D 	them in order. The RT11 Linker, however - and the Task Builder withA 	the /SQ switch - place psects in the order they are encountered. F 	Since it impossible to predict what order the various modules will beD 	seen by the linking program, it is essential that EVERY module thatE 	refers to any of these psects refer to the two related ones as well,  	and in the correct order.   bugs  C 	Requires the DECUS C dsect commands; hence, very non-portable.  It B 	may be possible to provide the same functionality using different; 	techniques; if not, what's wrong with your implementation?    author   	Jerry Leichter    #endif   /*
 )EDITLEVEL=05   * Edit history   * 0.0 19-Jul-82 JSL	InventionK  * 0.1 22-Nov-82 JSL	Documentation cleanups only; much of the documentation #  *			gets duplicated in initia.mac.   */   o #define INITIAL dsect"$init ";dsect"$init$";static char *$init_ = &$init$;dsect"$init.";dsect"";static $init$()  	 m #define FINAL dsect"$finl ";dsect"$finl$";static char *$finl_ = &$finl$;dsect"$finl.";dsect"";static $finl$()  	  /*J  * Sorry about the scrunched code; DECUS C has some size limits on #define:  * lines that are a pain.  Here's the code "in the clear":  *A  * #define INITIAL dsect "$init ";	\	-- Declare the dsects in the "  *	dsect"$init$";			\		right order>  *	static char *$init_ = &$init$;	\	-- Pointer to the function/  *	dsect"$init.";			\	-- Another dsect in order &  *	dsect"";			\	-- Back to the default-  *	static $init$()				-- Declare the function   *.  * The code for FINAL is essentially the same.  */ 