   /*4  *	ctype.h - character type definitions include file  */    #ifdef	DOCUMENTATION  8 title	ctype	Character test macros and global definitions3 index		Character test macros and global definitions    Synopsis   	#include <ctype.h>    Description   = 	This module defines a set of character test and manipulation = 	macros (or, on Decus C, functions) that allow classification B 	and modification of Ascii characters.  If the C compiler supports2 	macros with arguments, the following are defined:  ) 	  isupper(c)	/* Upper case alphabetic	*/i) 	  islower(c)	/* Lower case alphabetic	*/N* 	  isalpha(c)	/* Alphabetic in any case	*/" 	  isdigit(c)	/* Decimal digit		*/( 	  isalnum(c)	/* Alphabetic or digit		*/' 	  isxdigit(c)	/* Hexadecimal digit		*/c" 	  isspace(c)	/* Space or tab			*/! 	  ispunct(c)	/* Punctuation			*/o& 	  isgraph(c)	/* Visible character		*/( 	  isprint(c)	/* Printable character		*/& 	  iscntrl(c)	/* Control character		*/) 	  isascii(c)	/* 7-bit Ascii character	*/o0 	  _toupper(c)	/* Lower case convert to Upper	*/0 	  _tolower(c)	/* Upper case convert to Lower	*/. 	  toascii(c)	/* Remove eighth (parity) bit	*/  : 	Note that _toupper() and _tolower() must not be used with* 	arguments that have side effects, such as   		_toupper(*ptr++);   3 	Use the functions toupper() and tolower() instead.t 	i Bugs   #endif   /*  * )EDITLEVEL=01  * Edit historyi1  * 0.0 10-Mar-82 JB/MM	Extracted from vax libraryC  */l  ( #define _U	0001	/*			Uppercase alpha		*/( #define _L	0002	/*			Lowercase alpha		*/1 #define _UL	0003	/* _U | _L		Alpha in any case	*/e #define _D	0004	/*			Digit			*/c3 #define _ULD	0007	/* _U | _L | _D		Alphanumeric		*/p# #define _S	0010	/*			Whitespace		*/ $ #define _P	0020	/*			Punctuation		*/< #define _PULD	0027	/* _P | _U | _L | _D	Textual character	*/) #define _C	0040	/*			Control character	*/e/ #define _X	0100	/*			Hexadecimal Alpha (A-F)	*/*' #define _B	0200	/*			Space ' ' only		*/i  
 #ifdef vax11cd globalvalue	c$v_ctypedefs; #endif   extern	char	_ctype_ [];w   #ifdef nomacargd /*2  * Decus C does not support macros with arguments.  */0 #define _toupper	toupper #define	_tolower	tolower #elsep /*)  * Define macros for the character tests.	  */ ) #define isupper(c)	(_ctype_[(c)&0177]&_U)n) #define islower(c)	(_ctype_[(c)&0177]&_L)h* #define isalpha(c)	(_ctype_[(c)&0177]&_UL)) #define isdigit(c)	(_ctype_[(c)&0177]&_D)l+ #define isalnum(c)	(_ctype_[(c)&0177]&_ULD)'* #define isxdigit(c)	(_ctype_[(c)&0177]&_X)) #define isspace(c)	(_ctype_[(c)&0177]&_S)e) #define ispunct(c)	(_ctype_[(c)&0177]&_P)d, #define isgraph(c)	(_ctype_[(c)&0177]&_PULD)1 #define isprint(c)	(_ctype_[(c)&0177]&(_PULD|_B)) ) #define iscntrl(c)	(_ctype_[(c)&0177]&_C)t( #define isascii(c)	((unsigned)(c)<=0177)5 #define _toupper(c)	((c)>='a'&&(c)<='z'?(c)&0137:(c))74 #define _tolower(c)	((c)>='A'&&(c)<='Z'?(c)|040:(c)) #define toascii(c)	((c)&0177)1 #endif  