 /*  *			c o p y . c  */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  ' title	copy	Copy a Given Number of Bytes # index		Copy a given number of bytes    synopsis 	.s.nf 	char *  	copy(out, in, nbytes)  	char		*out;	/* Output vector	*/ 	char		*in;	/* Input vector		*/ ( 	unsigned int	count;	/* Bytes to copy	*/ 	.s.f  Description   7 	Copy the indicated number of bytes from the input area 8 	to the output area.  Return a pointer to the first free/ 	byte in the output area.  (I.e., &out[count]).   9 	The copying will be faster if out and in are either both  	even or both odd addresses.   Bugs  @ 	Warning, this routine "understands" pdp-11 address conventions. #endif   #ifdef	pdp11 #define	SHIFT	1  #define	LOWBIT	01  #else 
 #ifdef	vax #define	SHIFT	2  #define	LOWBIT	03  #else  #ifdef	mc68000 #define	SHIFT	2  #define	LOWBIT	03  #else  #endif #endif #endif   char * copy(out, in, count) register char		*out; register char		*in;  register unsigned int	count; /*  * Copy a given number of bytes   */  {  	if (count != 0) { #ifdef	SHIFT 	    if (count > 10) { 		/* 		 * Try to optimize 		 */ , 		if ((((unsigned int) in) & LOWBIT) != 0) { 		    *out++ = *in++;  		    count--; 		} - 		if ((((unsigned int) out) & LOWBIT) == 0) { . 		    count >>= SHIFT;	/* Get a word count		*/
 		    do {$ 			*((int *)out)++ = *((int *)in)++; 		    } while (--count != 0);  		    goto exit; 		}  	    }	  #endif 	    /* A 	     * Here for small copies, strange machines, and copies where D 	     * the output buffer isn't the same parity as the input buffer. 	     */	 	    do {  		*out++ = *in++;  	    } while (--count != 0); 	} exit:	return (out);  } 