 /* #define	TESTING  */  /*  *			d o p r n t . c  *  */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION   title		Output Formatter  index		Output formatter    internal   synopsis 	.s.nf 	c_doprnt(format, argvec, iov) 	char		*format;  	int		*argvec[]; 	FILE		*iov; 	.s.f  Description   < 	c_doprnt() performs all formatting operations for printf(),@ 	sprintf(), and fprintf().  The formatting options are described" 	in the documentation of printf().   Bugs  = 	c_doprnt() is functionally identical to the _doprnt() module @ 	in Unix and Vax-11 C libraries.  Unfortunately, the initial '_', 	conflicts with RSX FCS library conventions.   	Integer conversions only.   Internal  . 	A test routine may be conditionally compiled.   #endif   #include		<stdio.h>  #include		<ctype.h>  #define	EOS		('\0')  #define	FALSE		0 #define	TRUE		1  #ifdef	PDP10 #define	BITS_PER_CHAR	36 #else  #define	BITS_PER_CHAR	8  #endif   /*H  * WORKSIZE is the dimension of work[] which must hold enough charactersG  * to store a long integer (expanded using the %b format) + '-' and EOS   */ 8 #define	WORKSIZE	(((sizeof (long)) * BITS_PER_CHAR) + 2)   struct	fmtbuf { - 	char	f_type;		/* Format type ('d', etc.)		*/ 2 	char	f_width;	/* Argument width (INT or LONG)		*/2 	char	f_radix;	/* Argument radix (8, 10, etc.)		*/ };  
 #define	INT	0  #define	LONG	1. #define	NEG	2		/* Signal for output of '-'		*/  
 #ifdef	M68000  ROM_SECT(rom00); #endif /*<  * formatinfo[] stores information about the "value" formats  */ % static struct fmtbuf formatinfo[] = {l 	{ 'b',	INT,	 2 }, 	{ 'd',	INT,	10 }, 	{ 'o',	INT,	 8 }, 	{ 'u',	INT,	10 }, 	{ 'x',	INT,	16 }, 	{ 'B',	LONG,	 2 },  	{ 'D',	LONG,	10 },8 	{ 'O',	LONG,	 8 },i 	{ 'U',	LONG,	10 },* 	{ 'X',	LONG,	16 },K 	{ EOS,	0,	 0 }, };     c_doprnt(format, argp, fildes)$ char		*format;		/* Format string		*/3 register int	*argp;			/* Argument vector pointer	*/ & FILE		*fildes;		/* File descriptor		*/ {T 	register int		c;t 	register union {e 	    struct fmtbuf	*fmt; 	    char		*result;h 	} p;			0 	char		ljust;		/* TRUE for left-justification	*/+ 	char		work[WORKSIZE];	/* Number buffer		*/ ( 	char		fill;		/* '0' or ' ' for fill		*/ 	int		prec;		/* Precision			*/! 	int		slen;		/* Field length			*/T# 	int		width;		/* Argument width		*/i #ifdef	decus. 	unsigned	value;		/* Current argument value	*/ #elses 	unsigned long	value;R #endif& 	int		temp;		/* Set if '-' needed.		*/' 	short		radix;		/* Conversion radix		*/	  ! 	while ((c = *format++) != EOS) {m 	    /*o, 	     * Check for conversion specifications. 	     */ 	    if (c == '%') { 		/* 		 * Check for various options.b 		 */  		c = *format++;' 		ljust = 0;			/* No left adjustment	*/d& 		fill = ' ';			/* Fill with spaces	*/) 		if (c == '-') {			/* %-	left justify	*/e 		    ljust++; 		    c = *format++; 		}L, 		if (c == '0') {			/* %0d	zero fill arg.	*/ 		    fill = c;t 		    c = *format++; 		}a5 		if (c == '?' || c == '*') {	/* %*	width from arg	*/  		    width = *argp++; 		    c = *format++; 		}   		else {				/* %n	field width	*/ 		    width = 0; 		    while (isdigit(c)) { 			width *= 10;t 			width += (c - '0'); 			c = *format++;r 		    }e 		}e( 		if (c == '.') {			/* %n.n	precision	*/+ 		    c = *format++;		/* %n.* (from arg)	*/k! 		    if (c == '?' || c == '*') {e 			prec = *argp++; 			c = *format++;Z 		    }i 		    else { 			prec = 0; 			while (isdigit(c)) {g 			    prec *= 10; 			    prec += (c - '0');" 			    c = *format++;c 			} 		    }; 		}  		else {- 		    prec = 32767;		/* No prec. specified	*/- 		}. 		/*3 		 * Process conversion chars, understanding longs.d 		 */t 		if (c == 'l' || c == 'L') {e 		    switch (c = *format++) { 		    case 'b':m 		    case 'd':e 		    case 'o':  		    case 'u':1 		    case 'x':I% 			c = toupper(c);	/* Make %lb %B		*/2 		    case 'B':  		    case 'D':y 		    case 'O':E 		    case 'U':e 		    case 'X':e	 			break;2- 		    default:		/* Here on %Lfoo ==> %Ufoo	*/  			c = 'U';  			format--;	 			break;  		    }  		}W 		/*= 		 * Search the numeric format structure for this conversion.  		 */d 		for (p.fmt = formatinfo;0 			(p.fmt->f_type != c && p.fmt->f_type != EOS); 			p.fmt++)	 		    ;  		if (p.fmt->f_type != EOS) {" 		    /*( 		     * A numeric conversion was found.8 		     * Get the value and expand it into the work area.	 		     */V 		    radix = p.fmt->f_radix;k 		    temp = p.fmt->f_width;! 		    p.result = &work[WORKSIZE];y0 		    *--p.result = EOS;		/* Terminate result	*/ 		    if (temp == INT) { 			if (c == 'd' && *argp < 0) {r 			    value = -*argp++;) 			    temp = NEG;		/* Remember signal	*/I 			} 			elsee" 			    value = (unsigned) *argp++; 		    }c 		    else { 			value = *((long *) argp)++; 		    }N #ifdef	TESTING 		    fprintf(stderr,l: 			"radix %d, value = %d (signed), %u (unsigned), 0x%x\n", 			radix, value, value, value);c #endif 		    if (value == 0)c 			*--p.result = '0';l 		    else { 			/* * 			 * Convert an unsigned non-zero number. 			 */ 			do {  			    c = value % radix; 7 			    *--p.result = c + ((c < 10) ? '0' : ('a' - 10));l# 			} while ((value /= radix) != 0);d 			if (temp == NEG)k 			    *--p.result = '-';! 		    }t #ifdef	TESTING3 		    fprintf(stderr, "result \"%s\"\n", p.result);e #endif 		} 	 		else { E 		    /* 		     * String or something 		     */		  		    switch (c) {' 		    case 'q':			/* Funny int value	*/l 			/*H. 			 * Convert a word as a pair of octal bytes. 			 */
 			c = 16384;l 			p.result = work;L 			temp = *argp++; 			while (c > 0) {& 			    *p.result++ = (temp / c) + '0'; 			    temp %= c;  			    if (c == 256) { 				c = 64;H 				*p.result++ = '.'; 			    } 			    elsea 				c >>= 3; 			} 			*p.result = EOS;  			p.result = work;l	 			break;   % 		    case 'r':			/* Remote format	*/  			argp = (int *) *argp; 			format = (char *) *argp++;%! 			continue;		/* No print here	*/    		    case 's':			/* String		*/E- 			if ((p.result = (char *) *argp++) == NULL)l* 			    p.result = "{NULL}";	/* Bug hack	*/	 			break;   " 		    case 'c':			/* Character		*/ 			c = *argp++;s 			/*s 			 * Fall through 			 */% 		    default:			/* %% or whatever	*/i 		    	p.result = work;	 			*p.result = c;e 			work[1] = EOS; 	 			break;e 		    }i 		}  		/*0 		 * p.result -> first byte of string to output.  		 * Reuse c as a register temp. 		 */s1 		c = strlen(p.result);		/* True result length	*/	3 		slen = (c > prec) ? prec : c;	/* Field length		*/  #ifdef	TESTING> 		fprintf(stderr, "width %d, field length %d, precision %d\n", 		    width, slen, prec);s #endif& 		if (!ljust) {			/* Right justify?	*/ 		    while (--width >= slen) {l 			putc(fill, fildes); 		    }e 		}	 		/*+ 		 * Output the string (up to "prec" bytes)d 		 */S1 		for (c = prec; *p.result != EOS && --c >= 0;) {   		    putc(*p.result++, fildes); 		} $ 		if (ljust) {			/* Left justify?	*/ 		    while (--width >= slen) {  			putc(' ', fildes);  		    }  		}  	    } 	    else {  		/*, 		 * Not in a % thing, just output the byte. 		 */  		putc(c, fildes); 	    } 	}$ 	if ((fildes->_flag & _IOSTRG) != 0) 	    putc(EOS, fildes);s 	return; }i   #ifdef	TESTING   char	format[133];a char	inputline[133];	 int	v[3];e   main() { 	extern char	*prompt();    	for (;;) { " 	    if (prompt("Format") == NULL) 		break; 	    strcpy(format, inputline); ! 	    v[0] = rdint("v1", 1, 0, 0);r! 	    v[1] = rdint("v2", 1, 0, 0);f! 	    v[2] = rdint("v3", 1, 0, 0);o 	    printf("\"");! 	    c_doprnt(format, v, stdout);b 	    printf("\"\n"); 	} }u   char * prompt(info) char		*info; /*0  * Prompt, read text from console to input line.#  * Return inputline or NULL at eof.   */  {  	register char	*result;  	extern char	*gets();    	clearerr(stdin);  	if (info != NULL)$ 	    fprintf(stderr, "%s:  ", info); 	fflush(stderr); 	inputline[0] = EOS; 	result = gets(inputline); 	return (result);  }    int ! rdint(info, low, high, def_value) " char		*info;			/* Prompt text			*/* int		low;			/* Minimum acceptable value	*/+ int		high;			/* Maximum acceptable value	*/ % int		def_value;		/* Default value		*/  /*%  * Prompt and read an integer.  Note:   *	info		must be present"  *	low > high	any value acceptable  */  {  	register int		value;  	register char		*lp;   	for (;;) {  	    if (low <= high) { ( 		fprintf(stderr, "%s <%d..%d> [%d]?  "," 		    info, low, high, def_value); 	    } 	    else { 1 		fprintf(stderr, "%s [%d]?  ", info, def_value);  	    }5 	    if (prompt(NULL) == NULL || inputline[0] == EOS) & 		sprintf(inputline, "%d", def_value); 	    value = atoi(inputline); 7 	    if (low > high || (value >= low && value <= high))  		break; 	    fprintf(stderr,; 		"Illegal value %d, range is %d..%d, please try again.\n",  		value, low, high); 	} 	return (value); }    #endif