 /*  *			p r i n t f . c  *-  * Formatted output to the "standard" device.x  */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  ( title	printf	Formatted Output Conversion" index		Formatted output conversion   synopsis 	.s.nf 	printf(format, arg1, ...)	  	char		*format;   # 	fprintf(stream, format, arg1, ...)2 	FILE		*stream;  	char		*format;    	char *D$ 	sprintf(buffer, format, arg1, ...); 	char		*buffer;  	char		*format;R   	c_doprnt(format, argvec, iov) 	char		*format;, 	int		*argvec[]; 	FILE		*stream;L 	.s.f   Description  D 	printf() converts, formats, and prints its arguments, under control; 	of the first argument, writing output to stdout. fprintf() ? 	writes its output to the indicated file.  sprintf() writes its C 	output to the indicated string buffer.  c_doprnt() is the internal 2 	print formatter which is called by printf, etc.    @ 	sprintf() returns a pointer to the EOS at the end of the output0 	buffer.  This is not necessarily transportable.  = 	The format argument is a character string which contains two < 	types of objects: plain characters, which are simply copied= 	to the output stream, and conversion specifications, each of < 	which causes conversion and printing of the next successive 	argument to printf.  @ 	Each conversion specification is introduced by the character %. 	Following the %, there may be 	.lm +4 B 	.s.i -4;-###an  optional  minus  sign  "-"  which  specifies left6 	adjustment of the converted argument in the indicated 	field. B 	.s.i -4;-###an optional digit string specifying field  width.  If6 	the  converted argument has fewer characters than the6 	field width, it will be blank-padded on the left  (or6 	right, if  the  left-adjustment  indicator  has  been6 	given) to make up the  field  width.   If  the  field6 	width  is  specified as '*' or '?', the next argument6 	is used.  (Note: '?' is  obsolete.)  If the  width is6 	specified  with a leading  zero,  zeros are  used for6 	padding instead of blanks.  This zero  does NOT imply6 	an octal field width.  For example, assume the  value 	123 is to be printed: 	 
 		%d	"123"
 		%5d	"  123"  		%-5d	"123  " 		%05d	"00123"B 	.s.i -4;-###an  optional  period "." which serves to separate the) 	field width from the precision argument. B 	.s.i -4;-###an optional digit string (precision) which  specifies< 	the number of digits  to be printed from a string.   If the6 	precision is  specified  as  '*'  or  '?',  the  next= 	argument is used.  If the precision is zero, no bytes in the  	string will be printed.B 	.s.i -4;-###a character which indicates the  type  of  conversion 	   to be applied. 	.lm -4 1 	The conversion characters and their meanings are 	 	.lm +4.s  	.i -4;b###Binary (bits) 	.i -4;d###Signed-decimal  	.i -4;u###Unsigned-decimal  	.i -4;o###Octal4 	.i -4;x###Hexadecimal, 10-15 are represented by a-f	 	.lm -4.s 1 	The  integer  argument  is converted to decimal, 1 	octal, or hexadecimal   notation   respectively. 1 	Any   of   the   conversion  characters  may  be @ 	capitalized or preceeded  by  'l'  to  signal  "long"   integer
 	argument. 	.lm +4 @ 	.s.i -4;c###The argument character is printed.  If the argument# 	is zero (EOS), it will be ignored. 9 	.s.i -4;q###The (16-bit) integer is printed as a pair of 6 	octal bytes in the format "123.456"  The bytes follow7 	the PDP-11 order (high order byte first).  This format ' 	is not transportable to other systems. = 	.s.i -4;r###Remote format.  The next  printf()  argument  is 1 	the format.  Note that this is not a subroutine. 1 	The current format is not processed further. For 	 	example:    	    bug(args) 	    { 		error("Error at %r", &args); 	    }  ) 	This routine might be called as follows:   ( 	    bug("Error %d at %s\n", val, name);  1 	%r is not transportable to  all  implementations 1 	of  the  standard  library.  It does not word on 1 	Vax-11 C, for example.  c_doprnt() may  be  used * 	as shown below for similar functionality.= 	.s.i -4;s###The  argument is taken to be a string (character 1 	pointer) and  characters  from  the  string  are 1 	printed  until  a  null  character  or until the 1 	number of characters indicated by the  precision 1 	specification  is   reached;   however   if  the 1 	precision   specification  is  0  or missing all # 	characters up to null are printed. 	 	.s.lm -4 A 	If no recognizable character appears after the %, that character ? 	is printed; thus % may be printed by the use of the string %%. E 	In no case does a non-existant or small field width cause truncation < 	of a field; padding takes place only if the specified fieldB 	width exceeds the actual width.  Characters generated by printf()" 	are printed by calling putchar().  9 	c_doprnt() is the internal print formatter called by all ; 	"top-level" print functions.  It is functionally identical D 	to the Unix and Vax-11 C _doprnt() library routine.  Unfortunately,= 	the leading '_' conflicts with RSX-11M file services library < 	routine conventions, requiring the use of an unique prefix.( 	If your programs wish to call c_doprnt,0 	a potentially transportable procedure would be:   	    #ifdef decus  		c_doprnt(format, args, iov);
 	    #else 		_doprnt(format, args, iov);  	    #endif   > 	You should assume, however, that _doprnt() is not necessarily: 	present on all implementations of the "standard library."   Bugs   #endif   #include	<stdio.h>: #define	EOS	'\0'			/* native stdio.h doesn't define EOS */    printf(fmt, args)G {* 	c_doprnt(fmt, &args, stdout); }    #ifdef	TESTING /*)BUILD 	$(FILES)	= { printf doprnt }p */   char	buffer[80]; char	format[80];   main() { 	printf("just text\n");t0 	printf("one number (one-two-three) %d\n", 123);* 	printf("string \"%s\"\n", "Hello there"); 	printf("char '%c'\n", 'x'); 	for (;;) {f 		clearerror(stdin); 		fputs("format: ", stdout); 		fflush(stdout);  		if (gets(format) == NULL)R	 			break;" 		for (;;) {4 			printf("Arg for \"%s\", <CR> to exit: ", format); 			fflush(stdout);0 			if (gets(buffer) == NULL || buffer[0] == EOS)
 				break;: 			printf("buffer = \"%s\" (%d): ", buffer, atoi(buffer));  			printf(format, atoi(buffer)); 			printf("\n[");	  			printf(format, atoi(buffer)); 			printf("]\n");  		}  	} }    #endif