 /*  *				s c a n f . c   */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  & title	scanf	Formatted input conversion! index		Formatted input conversion    synopsis 	.s.nf 	scanf(fmt, pointer(s))   	char		*fmt;	/* Format string	*/   	fscanf(fd, fmt, pointer(s))$ 	FILE		*fd;	/* Input file pointer	*/  	char		*fmt;	/* Format string	*/   	sscanf(buf, fmt, pointer(s)) $ 	char		*buf;	/* Input text buffer	*/  	char		*fmt;	/* Format string	*/   	c_doscan(fmt, argp, iov)   	char		*fmt;	/* Format string	*/" 	int		*ptr[];	/* Pointer vector	*/" 	FILE		*iov;	/* Input file des.	*/ 	.s.f  Description   > 	Using the format string, these functions parse the input file9 	(or given text file), storing the results in the pointer @ 	arguments.  The three user-callable routines differ as follows:  - 	  scanf		Reads from the standard input file.   ( 	  fscanf	Reads from the indicated file.  % 	  sscanf	Reads from the text buffer.   B 	c_doscan() is an internal routine called by the above to actually@ 	parse the input text.  It is functionally identical to the Unix< 	and Vax-11 C _doscan() routine.  Unfortunately, the leading; 	'_' conflicts with RSX file control service routine naming 
 	conventions.   ; 	The format string may contain control characters to direct * 	the conversion of the input textual data: 	.lm +4 = 	.s.i -4;' ' Blanks, tabs, or newlines are ignored in  format / 	strings.  To match whitespace, use "%[ \t\n]". = 	.s.i -4;#x##An  ordinary  character  (not  %) must match the  	next input character.= 	.s.i -4;#%##Conversion specifications consist of a  '%',  an 1 	optional   '*'  (to   supress   assignment),  an 1 	optional  maximum  numeric  field  width,  and a  	conversion specifier.	 	.s.lm -4 B 	Unless value assignment was supressed by the '*' format modifier,B 	the next field is converted and stored in the variable pointed to? 	by the corresponding argument.  An input field is defined as a E 	string of non-space characters, extending to the first inappropriate < 	character or until the field width (if given) is exhausted.  3 	The following conversion characters are specified:  	.lm +4 = 	.s.i -4;#%##A single  '%'  is  expected  in  the  input,  no  	assignment is done.= 	.s.i -4;dox#An integer  of  the  specified  class  (decimal, 1 	octal,  or  hexadecimal)   is   expected.    The 1 	corresponding  argument  should  be  an  integer 1 	pointer.   If   the  format specifer is given in 1 	upper-case, or preceeded by 'l', a long  integer 1 	will be stored.  For example, "%ld" is identical 1 	to "%D".   Leading  whitespace  will be ignored. 1 	A null field is not converted.  Scanf()  returns 1 	a  count  of the number of fields converted, but - 	does not indicate which fields were ignored. = 	.s.i -4;#s##A character string is expected.  The input field 1 	will be terminated by a space, tab, or  newline. 1 	The corresponding argument  should  point  to  a 1 	buffer large enough to contain the  text  and  a 1 	terminating  NULL.   Leading  whitespace will be 	 	ignored. = 	.s.i -4;#c##A single character is read. Leading white  space 1 	is not supressed  --  to read the next non-blank 1 	character, use "%1s".  If a field width is given 1 	the  corresponding  argument  is  a pointer to a 1 	vector of characters and the indicated number of  	characters are read. 	 	.s.lm -4 7 	Scanf() returns the number of successfully matched and 8 	assigned input items.  If the end of input was reached,$ 	EOF (-1) is returned.  For example:   	    main()  	    { 		register int	c; 	 		int		i;  		char		text[10];     		c = scanf("%d%9s", &i, &text);) 		printf("i = %d, text = %s\n", i, text);  	   }   = 	If the input line is "150   foobar", the program will print:    	    i = 150, text = foobar    Diagnostics   ? 	Scanf() returns -1 if an end of file (end of string) condition < 	exists and no data was stored.  It returns -2 if a palpably. 	incorrect format, such as "%" is encountered.   Bugs  6 	This version of scanf does not support floating point  	and [] character class formats.   #endif   #include	<stdio.h>   int  scanf(format, args)  char		*format; /*  * Formatted input conversion   */  { ) 	return (c_doscan(stdin, format, &args));  } 