 /*  *			R S T S . H  *6  * Header file for calling RSTS/E I/O services from C.  *  * The following are defined:   *  *	struct rsts_xrb { .. } xrb;  *)  *		Load/access values by xrb.xrlen, etc.b  *"  *	struct rsts_firqb { .. } firqb;  *%  *		Load/access values by firqb.fqjobi  *9  *	RSTS/E EMT codes (CALFIP, _READ, etc.)  The '.' in thei)  *	true definition is represented by '_'.d  *<  *	FIRQB function codes, PLAS (firqb.fqerno) function codes,>  *	_UUO or UUOFQ subfunction codes, handler indexes, open file8  *	flag bits, low-core layouts, and keyword status bits.  *?  *	Also, the "get monitor tables" values are defined as offsetsx<  *	into the firqb.  Note that firqb/xrb values are volatile.  *C  * The RSTS/E i/o library contains the following (macro) functions:   *8  *	rstsys(emt)		Execute a RSTS/E emt, return error code.9  *	clrxrb()		Clear the XRB (before loading it with stuff)/  *	clrfqb()		Clear the FIRQB6  *	getxrb(myxrb)		Copy the system xrb   to   your area8  *	getfqb(myfirqb)		Copy the system firqb to   your area6  *	putxrb(myxrb)		Load the system xrb   from your area6  *	putfqb(myfqb)		Load the system firqb from your area  *?  * For example, to check for a logical device name, you should:u  *	clrxrb();  *	clrfqb();*  *	xrb.xrlen		= (first  word of radix-50);)  *	xrb.xrbc		= (second word of radix-50);o=  *	firqb.fqdev		= (two bytes of ascii for device name check);+$  *	firqb.fqdevn[0]		= (unit number);7  *	firqb.fqdevn[1]		= (non-zero if a real unit number);i  *	rstsys(_LOGS);   */(   /*  * Define XRB structurej  */    struct rsts_xrb { 4 	int	xrlen;		/*   0 Length of i/o buffer in bytes	*/. 	int	xrbc;		/*   2 Byte count for transfer		*// 	char *	xrloc;		/*   4 Buffer start address		*/	6 	char	xrci;		/*   6 Channel number * 2 for transfer	*/8 	char	xrblkm;		/*   7 Random-access block number, MSB	*/6 	int	xrblk;		/* 010 Random-access block number, LSB	*/4 	int	xrtime;		/* 012 Wait time for terminal input	*/) 	int	xrmod;		/* 014 Transfer modifier		*/  };( #define	xrbsiz	14		/* Length of xrb			*/   /*5  * Define FIRQB structure (twice to get all the bits);  */    struct rsts_firqb { ? 	char	firqb_errcode;	/*   0 Reserved for returned error code	*/ / 	char	firqb_reserved;	/*   1 Reserved byte			*/a1 	char	fqjob;		/*   2 Holds your job number * 2	*/=+ 	char	fqfun;		/*   3 Function requested		*/s6 	char	fqerno[1];	/*   4 Error message code and text	*/2 	char	fqsizm;		/*   5 File size in blocks, MSB		*/0 	int	fqppn;		/*   6 Project-programmer number	*/5 	int	fqnam1[2];	/* 010 2-word filename in radix-50	*/c) 	int	fqext;		/* 014 .ext in radix-50			*/ 5 	int	fqsiz;		/* 016 File size in blocks, low-order	*/): 	int	fqnam2[3];	/* 020 3-word new radix-50 filename.ext */9 	char	fqpflg;		/* 026 "Protection code real" indicator	*/ - 	char	fqprot;		/* 027 New protection code		*/s0 	int	fqdev;		/* 030 2-byte Ascii device name		*/8 	char	fqdevn[2];	/* 032 1-byte unit, 1-byte real flag	*/5 	int	fqclus;		/* 034 File cluster size for creates	*/ 8 	int	fqnent;		/* 036 Number of entries on dir. lookup	*/ };   #define fqfil	fqerno[0]  #define fqbufl	fqnam2[0] #define fqmode	fqnam2[1] #define fqflag	fqnam2[2]  . #define	fqbsiz	32		/* Firqb size in bytes			*/   /*  * Define emt codes,  */,  , #define	EMT	0104000		/* EMT instruction			*/8 #define	CALFIP	EMT+0		/* Call FIP, with firqb loaded		*/# #define	_READ	EMT+2		/* Read					*/ $ #define	_WRITE	EMT+4		/* Write				*/> #define	_CORE	EMT+6		/* Change user memory size (see below)	*/4 #define	_SLEEP	EMT+8		/* Sleep job for N seconds		*/, #define	_PEEK	EMT+10		/* Peek at memory			*/2 #define	_SPEC	EMT+12		/* Special i/o function			*/. #define	_TTAPE	EMT+14		/* Enter tape mode			*/+ #define	_TTECH	EMT+16		/* Enable echo				*/ , #define	_TTNCH	EMT+18		/* Disable echo				*/+ #define	_TTDDT	EMT+20		/* DDT submode				*/f3 #define	_TTRST	EMT+22		/* Cancel CTRL/O effect			*/3 #define	_TIME	EMT+24		/* Get timing information		*/r; #define	_POSTN	EMT+26		/* Get device horizontal position	*/o6 #define	_DATE	EMT+28		/* Get current date and time		*// #define	_SET	EMT+30		/* Set keyword bit(s)			*/o/ #define	_STAT	EMT+32		/* Get my statistics			*/r. #define	_RUN	EMT+34		/* Run a new program			*/7 #define	_NAME	EMT+36		/* Install a new program name		*/ ; #define	_EXIT	EMT+38		/* Exit to default run-time system	*/ : #define	_RTS	EMT+40		/* Change to a new run-time system	*/@ #define	_ERLOG	EMT+42		/* Log an error from the run-time sys.	*/9 #define	_LOGS	EMT+44		/* Check for logical device name	*/ 1 #define	_CLEAR	EMT+46		/* Clear keyword bits			*/ 3 #define	_MESAG	EMT+48		/* Message send/receive			*/ ) #define	_CCL	EMT+50		/* CCL checker				*/ - #define	_FSS	EMT+52		/* File string scan			*/ & #define	_UUO	EMT+54		/* UUO hook				*/4 #define	_CHAIN	EMT+56		/* Chain to a new program		*/5 #define	_PLAS	EMT+58		/* Resident library control		*/ 0 #define	_RSX	EMT+60		/* Enter RSX emulation			*/; #define	_ULOG	EMT+62		/* Assign/reassign/deassign device	*/    /*I  * Note: do not use the _CORE directive when running under RT11 emulation   */    /*;  * File processor function codes (loaded into firqb->fqfun)   */   - #define	CLSFQ	0		/* Close an open channel		*/ ' #define	OPNFQ	2		/* Open a channel			*/ 4 #define	CREFQ	4		/* Create/extend/open a channel		*/, #define	DLNFQ	6		/* Delete a named file			*/& #define	RENFQ	8		/* Rename a file			*/. #define	DIRFQ	10		/* Directory information		*/& #define	UUOFQ	12		/* Process UUO				*// #define	ERRFQ	14		/* Get error message text		*/ 5 #define	RSTFQ	16		/* Reset (close) [all] channels		*/ ' #define	LOKFQ	18		/* Lookup a file			*/ ) #define	ASSFQ	20		/* Assign a device			*/ + #define	DEAFQ	22		/* Deassign a device			*/ . #define	DALFQ	24		/* Deassign all devices			*/< #define	CRTFQ	26		/* Create/extend/open .tmp file on disk	*/8 #define	CRBFQ	28		/* Create/extend/open compiled file	*/     /*3  * _PLAS function codes (loaded into firqb->fqerno)   */   7 #define	ATRFQ	0		/* Attach region (resident library)	*/ 7 #define	DTRFQ	2		/* Detach region (resident library)	*/ - #define	CRAFQ	4		/* Create address window		*/ 0 #define	ELAFQ	6		/* Eliminate address window		*/+ #define	MAPFQ	8		/* Map address window			*/ . #define	UMPFQ	10		/* Unmap address window			*/   /*H  * _UUO/UUOFQ subfunction codes (UU_??? for Basic-Plus runtime requests)  */   4 #define	UU_SPL	-28		/* One-shot spooling request		*/3 #define	UU_DMP	-27		/* On-line monitor snapshot		*/ ) #define	UU_FIL	-26		/* File utility				*/ 5 #define	UU_ATR	-25		/* Read/write file attributes		*/ 1 #define	UU_CCL	-24		/* CCL command add/delete		*/ 0 #define	UU_???	-23		/* Reserved (Basic-Plus)		*/0 #define	UU_???	-22		/* Reserved (Basic-Plus)		*/0 #define	UU_???	-21		/* Reserved (Basic-Plus)		*/0 #define	UU_???	-20		/* Reserved (Basic-Plus)		*/7 #define	UU_LOG	-19		/* Set number of allowed logins		*/ = #define	UU_RTS	-18		/* Run-time system & res. lib. control	*/ 9 #define	UU_NAM	-17		/* Set file's run-time system name	*/ 0 #define	UU_DIE	-16		/* Special shutup logout		*/6 #define	UU_ACT	-15		/* Accounting information dump		*/- #define	UU_DAT	-14		/* Date/time changer			*/ 5 #define	UU_PRI	-13		/* Priority, runburst changer		*/ 5 #define	UU_TB2	-12		/* 2nd part of monitor tables		*/ 4 #define	UU_BCK	-11		/* Backup accounting changer		*/0 #define	UU_???	-10		/* Reserved (Basic-Plus)		*/1 #define	UU_HNG	-9		/* Hangup/enable a dataset		*/ 1 #define	UU_FCB	-8		/* Get fcb/ddb information		*/ / #define	UU_???	-7		/* Reserved (Basic-Plus)		*/ . #define	UU_POK	-6		/* Poke monitor memory			*// #define	UU_???	-5		/* Reserved (Basic-Plus)		*/ / #define	UU_???	-4		/* Reserved (Basic-Plus)		*/ 4 #define	UU_TB1	-3		/* 1st part of monitor tables		*/( #define	UU_NLG	-2		/* Set no logins			*/8 #define	UU_YLG	-1		/* Set number of logins to maximum	*/+ #define	UU_PAS	0		/* Create an account			*/ + #define	UU_DLU	1		/* Delete an account			*/ + #define	UU_CLN	2		/* Clean a disk pack			*/ 1 #define	UU_MNT	3		/* Disk pack mount/dismount		*/   #define	UU_LIN	4		/* Login				*/! #define	UU_BYE	5		/* Logout				*/ ! #define	UU_ATT	6		/* Attach				*/ ! #define	UU_DET	7		/* Detach				*/ . #define	UU_CHU	8		/* Change password/quota		*// #define	UU_ERR	9		/* Get error message text		*/i" #define	UU_ASS	10		/* Assign				*/$ #define	UU_DEA	11		/* Deassign				*// #define	UU_DAL	12		/* Deassign all devices			*/ / #define	UU_ZER	13		/* Zero device/directory		*/r5 #define	UU_RAD	14		/* Read accounting information		*/q3 #define	UU_DIR	15		/* Get directory information		*/T6 #define	UU_TRM	16		/* Set terminal characteristics		*/3 #define	UU_LOK	17		/* Wildcard directory lookup		*/f/ #define	UU_???	18		/* Reserved (Basic-Plus)		*/s/ #define	UU_CHE	19		/* Cache enable/disable			*/o4 #define	UU_CNV	20		/* Convert date/time to ascii		*/< #define	UU_SLN	21		/* Set/clear system-wide logical names	*// #define	UU_???	22		/* Reserved (Basic-Plus)		*/l6 #define	UU_SWP	23		/* Add/remove swap/err/ovr files	*// #define	UU_JOB	24		/* Job creation (spawn)			*/ / #define	UU_PPN	25		/* Wildcard P,PN lookup			*/e6 #define	UU_SYS	26		/* Return job status information	*/9 #define	UU_KMC	27		/* Connect KMC-11 to another device	*/o   /*  * Device handler indexes	  */t  " #define	DSKHND	0		/* Disk(s)				*/& #define	TTYHND	2		/* Terminal(s)				*/" #define	DTAHND	4		/* DECtape				*/) #define	LPTHND	6		/* Line printer(s)			*/a+ #define	PTRHND	8		/* Paper tape reader			*/ + #define	PTPHND	10		/* Paper tape punch			*/x' #define	CDRHND	12		/* Card reader				*/b& #define	MTAHND	14		/* Magtape(s)				*/+ #define	PKBHND	16		/* Pseudo-keyboards			*/e' #define	RXDHND	18		/* Floppy disk				*/i/ #define	RJEHND	20		/* 2780 Remote Job Entry		*/r' #define	NULHND	22		/* Null device				*/*( #define	DMCHND	24		/* DMC-11 device			*/1 #define	AUDHND	26		/* Autodial device (DN-11)		*/ ' #define	PLTHND	28		/* X-Y plotter				*/2- #define	DT2HND	30		/* DECtape II (TU-58)			*/*/ #define	KMCHND	32		/* KMC-11 Microprocessor		*/ + #define	IBMHND	34		/* IBM interconnect			*/r6 #define	MBXHND	36		/* Mailbox (reserved for VAX-11)	*/   /*  * Flag bits for an open fileb  */S  < #define	DDNFS	256		/* File(device) is non-file structured	*/5 #define	DDRLO	512		/* File(device) is read-locked		*/s7 #define	DDWLO	1024		/* File(device) is write-locked		*/t? #define	FLGPOS	2048		/* File(device) keeps it's own position	*/c9 #define	FLGMOD	4096		/* File(device) accepts modifiers	*/*8 #define	FLGFRC	8192		/* File(device) is byte-oriented	*/7 #define	FLGKB	16384		/* File(device) is interactive		*/u; #define	FLGRND	0100000		/* File(device) is random-access	*/r     /*'  * Define job-unique low memory layout.   */e  3 #define	KEY			0400	/* Loc. of Job status keyword	*/r) #define	FIRQB			0402	/* Loc. of firqb		*/2& #define	XRB			0442	/* Loc. of xrb			*/0 #define	CORCMN			0460	/* Loc. of core common		*/ #define key	(*((int *) KEY)). #define firqb	(*((struct rsts_firqb *) FIRQB))( #define xrb	(*((struct rsts_xrb *) XRB))  #define corcmn	((char *) CORCMN)  B #define	usrppn	(*((int *) 0734))	/* User-assignable p,pn number	*/A #define	usrprt	(*((int *) 0736))	/* User-assignable prot. code	*/uC #define	usrlog	(*((int *) 0740))	/* User logical dev. name table	*/c /*  * Define keyword status bitsm  */f  ; #define	JFSPRI	000400		/* Job is at special run priority	*/f= #define	JFFPP	001000		/* Job uses floating-point processor	*/f: #define	JFPRIV	002000		/* Job has permanent privileges		*/? #define	JFSYS	004000		/* Job has temporary privileges active	*/n6 #define	JFNOPR	010000		/* Job is not yet logged in		*/@ #define	JFBIG	020000		/* Job can exceed its private mem. max.	*/6 #define	JFLOCK	040000		/* Job is not to be swapped		*/   /*1  * Define the error codes (used to by in RSERR.H)	  */e   #define	BADDIR	1 #define	BADNAM	2 #define	INUSE 	3 #define	NOROOM	4 #define	NOSUCH	5 #define	NODEVC	6 #define	NOTCLS	7 #define	NOTAVL	8 #define	NOTOPN	9 #define	PRVIOL	10E #define	EOFERR 	11 #define	ABORT 	12n #define	DATERR	13  #define	HNGDEV	14  #define	HNGTTY	152 #define	FIEXST	16	 #define	DTOOOF	17T #define	BADFUO	18C #define	INTLCK	19  #define	WRGPAK	204 #define	NOTMNT	21o #define	PAKLCK	22n #define	BADCLU	23  #define	PRIVAT	24a #define	INTPAK	25f #define	BADPAK	26* #define	DETKEY	27n #define	CTRLCE	28	 #define	SATTBD	29  #define	DEVNFS	30o #define	BADCNT	31+ #define	NOBUFS	32s #define	B.4   	33	 #define	B.10  	34  #define	B.250 	35  #define	B.STAK	366 #define	B.SWAP	37p #define	B.PRTY	38d #define	MAGSEL	39	 #define	MAGRLE	40r #define	NRRTS 	41  #define	VCSERR	42	 #define	VCAERR	43  #define	SIZERR	44  #define	VCOERR	454 #define	BSERR 	46f #define	LINERR	47s #define	FLTERR	48	 #define	EXPERR	49r #define	FMTERR	50e #define	FIXERR	51R #define	BDNERR	52e #define	LOGERR	53d #define	SQRERR	54	 #define	SUBERR	55c #define	MINVER	56	 #define	ODD   	57  #define	ONBAD 	58f #define	NEDERR	59  #define	IOLERR	60* #define	DIVBY0	61T #define	NORTS 	62	 #define	FIELDE	63E #define	NORACS	64a #define	NOTMTA	65d #define	ERRERR	66	 #define	BADSWT	67  #define	STMERR	71n #define	EXITTM	72n #define	EXITNR	73	 #define	UNDFNI	74M #define	COSERR	75s #define	TLOPNV	76e #define	TLNZSP	77: #define	TLNOIT	78R #define	TLIFFE	79n #define	TLCONI	80l #define	TLNOTF	81  #define	TLQDUM	82u #define	TLMFND	83d #define	TLRNNM	84  #define	MODERR	85L #define	OUTOAS	87o #define	FUNERR	88d #define	TLTMAF	89p #define	TLINCD	90  #define	CPNSDF	91  #define	CPUPFR	92a #define	CPUFNX	93n #define	CPUPDF	94e #define	CPUPED	95  #define	TLJNKY	96  #define	TLNOFN	97  #define	SASYNE	98* #define	SAFNOS	99i #define	SASNOI	100 #define	TLURTP	101 #define	TLXDIM	102 #define	FUCORE	103 #define	RESERR	104 #define	DIMED2	105 #define	TLIDIM	106 #define	NOGOTO	107 #define	EOSERR	108 #define	TLCNTD	109 #define	TLPRNM	110 #define	EDBMCE	111 #define	EDEXON	112 #define	NRNERR	113 #define	EDCONE	114 #define	EDARSV	115 #define	PRERRS	116 #define	UDMERR	117 #define	PRNER1	118 #define	NONOIM	119 #define	PRNER2	120 #define	BADERR	121 #define	DISERR	122 #define	STPERR	123 #define	DIMERR	124 #define	NOMATH	125 #define	XCDCOR	126 #define	SCAERR	127