 /*  *				e s c . c	  */T  
 /*)LIBRARY */   #ifdef	DOCUMENTATION  $ title	esc	Process Escaped Characters! index		Process escaped characters    synopsis   	 char esc(ppc) 
 	 char **ppc;    	 int esc_msk;   description   G 	esc(ppc) recognizes and processes the escaped characters recognized by G 	the C compiler.  If *ppc points to any character other than '\', esc() > 	just returns that character.  Otherwise, it examines the next= 	character.  If it finds a member of the set {b,f,n,r,t}, the G 	appropriate character is returned, e.g., a <TAB> for '\t'. Also, \ddd, E 	ddd being up to three octal digits, returns the character with value E 	ddd.  Only the bottom 8 bits are retained, so the result is always a @ 	"proper" character.  This can be changed by changing the globalE 	esc_msk to contain whatever mask you prefer.  (The default is 0377.)   D 	The special characters b, f, and so on are recognized in lower case 	only.  ; 	If '\' is the last character in s, '\' itself is returned.   C 	If '\' is followed by any other character x, x itself is returned.   E 	In all cases, *ppc is left pointing at the last character that esc() C 	has "eaten", e.g., at the 't' if it is returning a <TAB> for '\t'.    bugs   author   	Jerry Leichter    #endif   /*  * )EDITLEVEL=17  * Edit history   * 0.0  1-May-81 JSL	Invention9  * 0.1 28-May-81 JSL	Conversion to new comment convention '  * 0.2 23-Jun-81 JSL	escmsk ==> esc_msk $  * 0.3 29-Dec-81 MM	Redone for vax cE  * 0.4 13-Jul-82 JSL	Change esc_msk default to 0377 to support XASCII   */    #define ESCAPE '\\'  #define EOS '\0'   int esc_msk = 0377;    char esc(ppc) char **ppc;  {  	register char c,c1; 	register char	*pc;    	pc = *ppc; + 	if ((c = pc[0]) != ESCAPE || pc[1] == EOS)  		return(c); 	else  		c = *++pc; 		*ppc = pc; 		switch(c)  	{
 	case 'b': 		return('\b'); 
 	case 'f': 		return('\f'); 
 	case 'n': 		return('\n'); 
 	case 'r': 		return('\r'); 
 	case 't': 		return('\t'); 
 	case '0':
 	case '1':
 	case '2':
 	case '3':
 	case '4':
 	case '5':
 	case '6':
 	case '7': 		c -= '0'; ( 		if ((c1 = pc[1]) >= '0' && c1 <= '7' ) 		{	c = (c << 3) | (c1 - '0'); 			pc++;) 			if ((c1 = pc[1]) >= '0' && c1 <= '7' )  			{	c = (c << 3) | (c1 - '0'); 	 				pc++;  			} 		}  		*ppc = pc; 		return(c & esc_msk);	 	default:  		return(c); 	} } 