 /*  *				f l e x . c   */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION   title	flex	Create a New Flex index		Create a new flex   synopsis   	 #ifdef	vms 	 #include "c:flex.h"  	 #else  	 #include <flex.h>  	 #endif   	 FLEX * 	 flex(dim,isz,ext) * 	 unsigned dim;		/* Initial size, items	*/' 	 unsigned isz;		/* Item size, bytes	*/ ) 	 unsigned ext;		/* Items to extend by	*/    description   D 	Flexes are dynamically expandable arrays.  If an attempt is made toD 	add an item to a flex that is already full, the flex's core area is  	re-allocated to make more room.  E 	All the items in a flex must be the same size; all references are by G 	item numbers, which, like array indices, run from 0 to (# items in the F 	flex minus 1).  When a flex must expand, it expands some whole numberE 	of items; the particular number to expand by is stored in the flex's 9 	header.  If this number is zero, the flex cannot expand.   F 	If a flex cannot expand, either because its header sets a growth sizeE 	of 0 or because there is insufficient core, but a request is made to G 	add an item while it is full, the flex is marked damaged.  The core it @ 	used for its data is lost (realloc() free's it) and any furtherC 	attempts to use the flex are ignored.  In general, any time a flex @ 	becomes damaged, or a damaged flex is passed to one of the flexB 	handling routines, the routine returns NULL.  (Usually, they just 	return the flex passed.)   A 	A flex actually consists of a header, which contains information D 	describing it, and a separate block of data.  The first item in theD 	header is a pointer to the data.  While the header never moves, theD 	data may move any time items are added to or removed from the flex.  F 	It is occassionally necessary to recover the information in a damagedE 	flex (in most cases, there is no reasonable way to continue once the @ 	program runs out of memory).  This can be done by making use ofC 	realloc()'s ability to reallocate the most recently freed block of E 	core.  Before making the potentially damaging call, save the current B 	values of the fxdata and fxused elements of the flex.  Should theA 	flex become damaged, the fxdata value can be passed to realloc() F 	safely.  Note that this recovers the data, but not the flex's header;A 	you still cannot apply any of the flex-handling functions to it.   D 	The various flex handling functions in the Utility Library all haveF 	names beginning "fx".  They form a fairly complete set of primitives.F 	You may wish to restrict yourself to doing all accesses through theseC 	routines since this would, in principle, allow you to replace them G 	with a set of routines that, for example, page items to disk if a flex  	gets too large.  G 	The file flex.h contains some definitions that are useful when dealing 
 	with flexes.   E 	The function flex(dim,isz,ext) creates a new flex.  The data area of E 	the flex will initially contain sufficient space for dim items, each F 	isz bytes in length.  If the flex fills, it will be extended in units 	of ext items.   bugs   author   	Jerry Leichter    #endif   /*  * )EDITLEVEL=10  * Edit history   * 0.0  4-May-81 JSL	Invention(  * 0.1  5-May-81 JSL	Cleanup; add fxneedB  * 0.2  7-May-81 JSL	Split flex.c into separate files; this is one?  * 0.3 23-Jun-81 JSL	Conversion to new documentation convention   */   
 #ifdef	vms #include "c:flex.h"  #else  #include <flex.h>  #endif #define NULL 0   extern char *malloc();   FLEX * flex(dim,isz,ext) + unsigned dim;		/* initial size, in items */ - unsigned isz;		/* size of an item in bytes */ E unsigned ext;		/* number of items to extend by; 0 means no extends */  {	register FLEX *fx;1 	if ((fx = (FLEX *)malloc(sizeof(FLEX))) == NULL)  		return(NULL); , 	if ((fx->fxdata = malloc(dim*isz)) == NULL) 	{	free(fx); 		return(NULL);  	} 	fx->fxdim = dim;  	fx->fxisz = isz;  	fx->fxext = ext;  	fx->fxused = 0; 	return(fx); }	