 /*  *				r e p l a c . c   */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  + title	replace		Simple Character Translationv$ index			Simple character translation   synopsis   	 char * 	 replace(s,from,to) 	 char s[];p 	 char from[]; 	 char to[];   	 extern char rep_tab[256];t   description   G 	replace() provides a simple interface to translate() and the functionsnG 	associated with it; see transl.c for details.  Briefly, each charactereD 	character in s that occurs in from is replaced by the correspondingC 	character in to.  If there are more characters in from than in to, G 	the "excess" characters are deleted from the output string.  replace()aF 	returns the output string in space allocated from malloc(); the inputD 	string is unchanged.  If replace() can't get the space it needs, it 	returns NULL.  G 	rep_tab is a global character table that is used in the internal calls B 	to the translation routines.  It is large enough to translate any? 	8-bit byte.  rep_tab is cleared and the set up on each call to/E 	replace().  If you intend to call replace() many times with the samehG 	second and third arguments, you can call it once to set up rep_tab and G 	then call translate() directly - change subsequent s1 = replace(s,t,f)r- 	calls to translate(rep_tab,s1 = savestr(s)).a  G 	Note: The power of a function like replace() is often not appreciated.sE 	If s is any 5-character string, then replace("abcde","edcba",s) is s[D 	reversed - i.e., this call maps "words" to "sdrow".  In general, ifB 	P is any permutation of n-character strings, n<256, then the callD 	replace(b,P(b),s) returns P(s), where b is any (constant) string ofG 	length n containing n different characters.  (s, of course, is also ofg@ 	length n).  Thus, replace() implements character substitutions,G 	deletions, and permutations, all in one small, simple to use function.    bugs   author   	Jerry Leichterr   #endif   /*  * )EDITLEVEL=03  * Edit historyv  * 0.0 30-Jun-81 JSL	Invention  */+   #define NULL 0   char rep_tab[256];   char * replace(s,from,to) register char s[]; register char from[];  register char to[]; & {	clrttab(rep_tab,sizeof rep_tab - 1); 	setttab(rep_tab,from,to); 	if ((s = savestr(s)) != NULL) 	{	translate(rep_tab,s); 		realloc(s,strlen(s) + 1);i 	} 	return(s);  }	