 -h- nl:&A This is a set of string functions distributed on the Unix USENET. D Unpack using archx.  Not tested on Decus C.  Note that some filename7 changes will have to be made for Dec operating systems. + The manual (xstring.3c) is in nroff format. 0 -h- _c2type.c	Thu Jun 21 23:07:38 1984	_c2type.c /*  File   : _c2type.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984)     Purpose: Map character codes to types   C     The mapping used here is such that we can use it for converting F     numbers expressed in a variety of radices to binary as well as for     classifying characters.  */   char _c2type[129] =      {	37,			/* EOF == -1 */R@ 	37, 37, 37, 37, 37, 37, 37, 37, 37, 38, 39, 39, 39, 39, 37, 37,@ 	37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,@ 	38, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,@ 	00, 01, 02, 03, 04, 05, 06, 07,  8,  9, 36, 36, 36, 36, 36, 36,@ 	36, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,@ 	25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36,@ 	36, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,? 	25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36o     };  2 -h- _str2map.c	Thu Jun 21 23:07:38 1984	_str2map.c /*  File   : _str2map.c	      Author : Richard A. O'Keefe.     Updated: 20 April 1984$     Defines: _map_vec[], _str2map().  H     _str2map(option, from, to) constructs a translation table.  If  fromH     or to is NullS, the same string is used as last time, so if you wantH     to translate a whole lot of strings using the same mapping you don't6     have to reconstruct it each time.  The options are  0 	0: initialise the map to the identity function,5 	   then map each from[i] to the corresponding to[i].k9 	   If to[] is shorter than from[], its last character is   	   repeated as often as needed.  ' 	1: as 0, but don't initialise the map.r  8 	2: initialise the map to send every character to to[0],$ 	   then map each from[i] to itself.  F     For example, to build a map which forces letters to lower case but(     sends everything else to blank, call  0 	_str2map(2, "abcdefghijklmnopqrstuvwxyz", " ");I 	_str2map(1, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz");   H     Only strtrans() and strntrans() in this package  call  _str2map;  ifH     you  want  to  build your own maps this way you can "fool" them intoH     using it, as when the two strings are NullS they  don't  change  theH     map.   As an extra-special dubious *hack*, _map_vec has an extra NULH     character at the end, so after calling _str2map(0, "", ""), you  canH     use  _map_vec+1 as a string of the 127 non-NUL characters (or if the9     _AlphabetSize is 256, of the 255 non-NUL characters)." */   #include "strings.h" #include "_str2map.h"	   static	_char_	*oldFrom = "?";e static	char	*oldTo   = "?";.   char	_map_vec[_AlphabetSize+1];n   void _str2map(option, from, to)      int option;i     register _char_ *from;     register char *to;     {n 	register int i, c;!  * 	if (from == NullS && to == NullS) return;8 	if (from == NullS) from = oldFrom; else oldFrom = from;6 	if (to   == NullS) to   = oldTo;   else oldTo   = to; 	switch (option) { 	    case 0:6 		for (i = _AlphabetSize; --i >= 0; _map_vec[i] = i) ; 	    case 1: 		while (i = *from++) {g 		    _map_vec[i] = *to++; 		    if (!*to) { 
 			c = *--to;y' 			while (i = *from++) _map_vec[i] = c;e
 			return; 		    }  		}R	 		return;u 	    case 2:
 		c = *to;6 		for (i = _AlphabetSize; --i >= 0; _map_vec[i] = c) ;& 		while (c = *from++) _map_vec[c] = c;	 		return;e 	}     }l  2 -h- _str2map.h	Thu Jun 21 23:07:38 1984	_str2map.h /*  File   : _str2map.hB      Author : Richard A. O'Keefe.     Updated: 11 April 1984(     Purpose: Definitions from _str2map.c */  & extern	char	_map_vec[_AlphabetSize+1];, extern	void	_str2map(/*int,_char_^,char^*/);  2 -h- _str2pat.c	Thu Jun 21 23:07:38 1984	_str2pat.c /*  File   : _str2pat.cr      Author : Richard A. O'Keefe.     Updated: 2 June 1984-     Defines: _pat_lim, _pat_vec[], _str2pat()t  H     Searching in this package is done by an algorithm due  to  R.  NigelH     Hospool,  described  in  Software  Practice & Experience 1980, p505.H     Elsewhere I have a version of it which does  exact  case  or  eitherH     case  match,  word  more or literal mode, forwards or backwards, andH     will look for the Nth instance.  For most applications that  is  tooH     much  and  a  simple  exact  case forward search will do.  Hospool'sH     algorithm is a simplification of  the  Boyer-Moore  algorithm  whichH     doesn't  guarantee linear time, but in practice is very good indeed.  H     _str2pat(pat) builds a search table for the string pat.  As usual inH     this pacakge, if pat == NullS, the table is not changed and the lastH     search string is re-used.  To support  this,  _str2pat  returns  the     actual search string.e */   #include "strings.h" #include "_str2pat.h"'  
 int	_pat_lim;  int	_pat_vec[_AlphabetSize]; static	_char_	*oldPat = "";e     _char_ *_str2pat(pat)F     register _char_ *pat;e     {l 	register int L, i;F  3 	if (pat == NullS) pat = oldPat; else oldPat = pat;s 	for (L = 0; *pat++; L++) ;o5 	for (i = _AlphabetSize; --i >= 0; _pat_vec[i] = L) ;L; 	for (pat = oldPat, i = L; --i > 0; _pat_vec[*pat++] = i) ;  	_pat_lim = --L; 	return oldPat;      }   2 -h- _str2pat.h	Thu Jun 21 23:07:38 1984	_str2pat.h /*  File   : _str2pat.h       Author : Richard A. O'Keefe.     Updated: 20 April 1984(     Purpose: Definitions from _str2pat.c */   extern	int	_pat_lim; extern	int	_pat_vec[];% extern	_char_	*_str2pat(/*_char_^*/);v  2 -h- _str2set.c	Thu Jun 21 23:07:38 1984	_str2set.c /*  File   : _str2set.cs      Author : Richard A. O'Keefe.     Updated: 20 April 1984.     Defines: _set_ctr, _set_vec[], _str2set().1     Purpose: Convert a character string to a set.T */  B /*  The obvious way of representing a set of characters  is  as  aB     vector  of 0s and 1s.  The snag with that is that to convert aB     string to such a vector, we have to clear all the elements  toB     0,  and  then  set the elements corresponding to characters inB     the string to 1, so the cost is  O(|alphabet|+|string|).  ThisB     package  uses another method, where there is a vector of smallB     numbers and a counter.  A character is in the current  set  ifB     and  only  if the corresponding element of the vector is equalB     to the current value of  the  counter.   Every  so  often  theB     vector  elements  would  overflow  and  we  have  to clear the5     vector, but the cost is reduced to O(|string|+1).   C     Note that NUL ('\0') will never be in any set built by str2set.   B     While this method reduces the cost of building a set, it wouldB     be useful to avoid it entirely.  So when the "set" argument isB     NullS the set is not changed.  Use NullS to mean "the same setB     as before."  MaxPosChar is the largest integer value which canB     be stored in a "char".  Although we might get a slightly widerB     range by using "unsigned char", "char" may be cheaper (as on aB     PDP-11).  By all means change the number from 127 if your C isB     one of those that treats char as unsigned, but don't change itB     just because _AlphabetSize is 256, the two are unrelated.  AndA     don't dare change it on a VAX: it is built into the asm code!  */   #include "strings.h" #include "_str2set.h"    #if	CharsAreSigned #define	MaxPosChar	127 #else  ~CharsAreSigned #define MaxPosChar	255 #endif	CharsAreSigned    int  _set_ctr = MaxPosChar;  char _set_vec[_AlphabetSize];      void _str2set(set)     register char *set;      {  	if (set == NullS) return;" 	if (++_set_ctr == MaxPosChar+1) {
 #if	VaxAsm- 	    asm("movc5 $0,4(ap),$0,$128,__set_vec");  #else  ~VaxAsm1 	    register char *w = &_set_vec[_AlphabetSize]; . 	    do *--w = NUL; while (w != &_set_vec[0]);
 #endif	VaxAsm  	    _set_ctr = 1; 	}* 	while (*set) _set_vec[*set++] = _set_ctr;     }   2 -h- _str2set.h	Thu Jun 21 23:07:38 1984	_str2set.h /*  File   : _str2set.h      Updated: 10 April 1984B     Purpose: External declarations for strprbk, strspn, strcspn &c*     Copyright (C) 1984 Richard A. O'Keefe. */   extern	int	_set_ctr; extern	char	_set_vec[];   extern	void	_str2set(/*char^*/);  , -h- ascii.h	Thu Jun 21 23:07:38 1984	ascii.h /*  File   : strings.d/ascii.h     Author : Richard A. O'Keefe      Updated: 28 April 1984$     Purpose: Define Ascii mnemonics.  D     This file defines the ASCII control characters.  Note that theseD     names refer to their use in communication; it is an ERROR to useE     these names to talk about keyboard commands.  For example, DO NOTnE     use EOT when you mean "end of file", as many people prefer ^Z (iftB     the Ascii code were taken seriously, EOT would log you off andB     hang up the line as well).  Similarly, DO NOT use DEL when youC     mean "interrupt", many people prefer ^C.  When writing a screeneE     editor, you should speak of tocntrl('C') rather than ETX (see the      header file "ctypes.h"). */  ' #define NUL	'\000'	/* null character */ ; #define SOH	'\001'	/* Start Of Heading, start of message */ 6 #define STX	'\002'	/* Start Of Text, end of address */4 #define	ETX	'\003'	/* End of TeXt, end of message */, #define EOT	'\004'	/* End Of Transmission */. #define	ENQ	'\005'	/* ENQuiry "who are you" *// #define ACK	'\006'	/* (positive) ACKnowledge */c& #define	BEL	'\007'	/* ring the BELl */! #define	BS	'\010'	/* BackSpace */f& #define	HT	'\011'	/* Horizontal Tab */2 #define	TAB	'\011'	/* an unofficial name for HT */5 #define	LF	'\012'	/* Line Feed (does not imply cr) */(= #define	NL	'\012'	/* unix unofficial name for LF: new line */ $ #define	VT	'\013'	/* Vertical Tab */> #define	FF	'\014'	/* Form Feed (new page starts AFTER this) */' #define	CR	'\015'	/* Carriage Return */,A #define	SO	'\016'	/* Shift Out; select alternate character set */B4 #define	SI	'\017'	/* Shift In; select ASCII again */) #define	DLE	'\020'	/* Data Link Escape */ ) #define	DC1	'\021'	/* Device Control 1 */\6 #define XON	'\021'	/* transmitter on, resume output */8 #define	DC2	'\022'	/* Device Control 2 (auxiliary on) */) #define	DC3	'\023'	/* Device Control 3 */B9 #define	XOFF	'\023'	/* transmitter off, suspend output */ 9 #define	DC4	'\024'	/* Device Control 4 (auxiliary off) */e< #define	NAK	'\025'	/* Negative AcKnowledge (signal error) */) #define	SYN	'\026'	/* SYNchronous idle */)I #define	ETB	'\027'	/* End of Transmission Block, logical end of medium */p #define	CAN	'\030'	/* CANcel */m% #define	EM	'\031'	/* End of Medium */e# #define	SUB	'\032'	/* SUBstitute */I #define	ESC	'\033'	/* ESCape */ & #define	FS	'\034'	/* File Separator */' #define	GS	'\035'	/* Group Separator */n( #define	RS	'\036'	/* Record Separator */& #define	US	'\037'	/* Unit Separator */ #define	SP	'\040'	/* SPace */v' #define	DEL	'\177'	/* DELete, rubout */n  * -h- bcmp.c	Thu Jun 21 23:07:38 1984	bcmp.c /*  File   : bcmp.cm      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: bcmp()d  G     bcmp(s1, s2, len) returns 0 if the "len" bytes starting at "s1" aretG     identical to the "len" bytes starting at "s2", non-zero if they areiG     different.   The 4.2bsd manual page doesn't say what non-zero valueaG     is returned, though the BUGS note says that it takes its parametersdC     backwards from strcmp.  This suggests that it is something liken 	for (; --len >= 0; s1++, s2++)r$ 	    if (*s1 != *s2) return *s2-*s1;
 	return 0;G     There, I've told you how to do it.  As the manual page doesn't comeeG     out and *say* that this is the result, I tried to figure out what a G     useful result might be.   (I'd forgotten than strncmp stops when it.G     hits a NUL, which the above does not do.)  What I came up with was:aG     the result is the number of bytes in the differing tails.  That is,hG     after you've skipped the equal parts, how many characters are left? G     To put it another way, N-bcmp(s1,s2,N) is the number of equal bytes G     (the size of the common prefix).  After deciding on this definition G     I discovered that the CMPC3 instruction does exactly what I wanted.y,     The code assumes that N is non-negative.  H     Note: the "b" routines are there to exploit certain VAX order codes,H     but the CMPC3 instruction will only test 65535 characters.   The asm6     code is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   int bcmp(s1, s2, len)(     char *s1, *s2;     int len;     { # 	asm("cmpc3 12(ap),*4(ap),*8(ap)");      }    #else  ~VaxAsm   int bcmp(s1, s2, len)	     register char *s1, *s2;r     register int len;c     { ' 	while (--len >= 0 && *s1++ == *s2++) ;e 	return len+1;     }   
 #endif	VaxAsmr  , -h- bcopy.c	Thu Jun 21 23:07:38 1984	bcopy.c /*  File   : bcopy.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: bcopy()  H     bcopy(src, dst, len) moves exactly "len" bytes from the source "src"F     to the destination "dst".  It does not check for NUL characters asH     strncpy() and strnmov() do.  Thus if your C compiler doesn't support2     structure assignment, you can simulate it with  	bcopy(&from, &to, sizeof from);H     BEWARE: the first two arguments are the other way around from almostH     everything else.   I'm sorry about that, but that's the way it is inH     the 4.2bsd manual, though they list it as a bug.  For a version with4     the arguments the right way around, use bmove().     No value is returned.r  H     Note: the "b" routines are there to exploit certain VAX order codes,H     but the MOVC3 instruction will only move 65535 characters.   The asm6     code is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   void bcopy(src, dst, len)r     char *src, *dst;     int len;     {r# 	asm("movc3 12(ap),*4(ap),*8(ap)");t     }r   #else  ~VaxAsm   void bcopy(src, dst, len)      register char *src, *dst;e     register int len;c     { $ 	while (--len >= 0) *dst++ = *src++;     }   
 #endif	VaxAsm9  , -h- bfill.c	Thu Jun 21 23:07:38 1984	bfill.c /*  File   : bfill.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: bfill()  ?     bfill(dst, len, fill) moves "len" fill characters to "dst".t?     Thus to set a buffer to 80 spaces, do bfill(buff, 80, ' ').   H     Note: the "b" routines are there to exploit certain VAX order codes,H     but the MOVC5 instruction will only move 65535 characters.   The asm6     code is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   void bfill(dst, len, fill)     char *dst;     int len;!     int fill;	/* actually char */i     {", 	asm("movc5 $0,*4(ap),12(ap),8(ap),*4(ap)");     }s   #else  ~VaxAsm   void bfill(dst, len, fill)     register char *dst;n     register int len;2!     register int fill;	/* char */      {(" 	while (--len >= 0) *dst++ = fill;       }e  
 #endif	VaxAsm   , -h- bmove.c	Thu Jun 21 23:07:38 1984	bmove.c /*  File   : bmove.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: bmove()  H     bmove(dst, src, len) moves exactly "len" bytes from the source "src"F     to the destination "dst".  It does not check for NUL characters asH     strncpy() and strnmov() do.  Thus if your C compiler doesn't support2     structure assignment, you can simulate it with  	bmove(&to, &from, sizeof from);H     The standard 4.2bsd routine for this purpose is bcopy.  But as bcopyH     has its first two arguments the other way around you may find this a     bit easier to get right.     No value is returned.m  H     Note: the "b" routines are there to exploit certain VAX order codes,H     but the MOVC3 instruction will only move 65535 characters.   The asm6     code is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   void bmove(dst, src, len)      char *dst, *src;     int len;     {o# 	asm("movc3 12(ap),*8(ap),*4(ap)");      }    #else  ~VaxAsm   void bmove(dst, src, len)>     register char *dst, *src;(     register int len;      { $ 	while (--len >= 0) *dst++ = *src++;     }c  
 #endif	VaxAsmv  , -h- bzero.c	Thu Jun 21 23:07:38 1984	bzero.c /*  File   : bzero.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: bzero()  1     bzero(dst, len) moves "len" 0 bytes to "dst".r?     Thus to clear a disc buffer to 0s do bzero(buffer, BUFSIZ).1  H     Note: the "b" routines are there to exploit certain VAX order codes,H     but the MOVC5 instruction will only move 65535 characters.   The asm6     code is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   void bzero(dst, len)     char *dst;     int len;     {.( 	asm("movc5 $0,*4(ap),$0,8(ap),*4(ap)");     }t   #else  ~VaxAsm   void bzero(dst, len)     register char *dst;r     register int len;c     {  	while (--len >= 0) *dst++ = 0;	     }*  
 #endif	VaxAsm3  2 -h- ctypes.dem	Thu Jun 21 23:07:38 1984	ctypes.dem1 EOF .   .   .   .   .   .   .   .   .   #   .   .3  3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL?,1 ^@  .   .   .   .   .   .   .   .   .   #   .   .01 ^A  .   .   .   .   .   .   .   .   .   #   .   .,1 ^B  .   .   .   .   .   .   .   .   .   #   .   .,1 ^C  .   .   .   .   .   .   .   .   .   #   .   .31 ^D  .   .   .   .   .   .   .   .   .   #   .   .,1 ^E  .   .   .   .   .   .   .   .   .   #   .   .21 ^F  .   .   .   .   .   .   .   .   .   #   .   . 1 ^G  .   .   .   .   .   .   .   .   .   #   .   .s1 ^H  .   .   .   .   .   .   .   .   .   #   .   .c1 ^I  .   .   .   .   .   .   .   .   .   #   #   .e1 ^J  .   .   .   .   .   .   .   .   .   #   #   #o1 ^K  .   .   .   .   .   .   .   .   .   #   #   #r1 ^L  .   .   .   .   .   .   .   .   .   #   #   #l1 ^M  .   .   .   .   .   .   .   .   .   #   #   #l1 ^N  .   .   .   .   .   .   .   .   .   #   .   . 1 ^O  .   .   .   .   .   .   .   .   .   #   .   .   3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL? 1 ^P  .   .   .   .   .   .   .   .   .   #   .   . 1 ^Q  .   .   .   .   .   .   .   .   .   #   .   .t1 ^R  .   .   .   .   .   .   .   .   .   #   .   .01 ^S  .   .   .   .   .   .   .   .   .   #   .   .t1 ^T  .   .   .   .   .   .   .   .   .   #   .   .m1 ^U  .   .   .   .   .   .   .   .   .   #   .   .u1 ^V  .   .   .   .   .   .   .   .   .   #   .   . 1 ^W  .   .   .   .   .   .   .   .   .   #   .   .(1 ^X  .   .   .   .   .   .   .   .   .   #   .   .,1 ^Y  .   .   .   .   .   .   .   .   .   #   .   .t1 ^Z  .   .   .   .   .   .   .   .   .   #   .   .n1 ^[  .   .   .   .   .   .   .   .   .   #   .   .t1 ^\  .   .   .   .   .   .   .   .   .   #   .   . 1 ^]  .   .   .   .   .   .   .   .   .   #   .   .l1 ^^  .   .   .   .   .   .   .   .   .   #   .   .s1 ^_  .   .   .   .   .   .   .   .   .   #   .   .   3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL?,1     .   .   .   .   .   .   .   .   #   .   #   .t1 !   .   .   .   .   .   .   .   #   #   .   .   .S1 "   .   .   .   .   .   .   .   #   #   .   .   . 1 #   .   .   .   .   .   .   .   #   #   .   .   .t1 $   .   .   .   .   .   .   .   #   #   .   .   ."1 %   .   .   .   .   .   .   .   #   #   .   .   .t1 &   .   .   .   .   .   .   .   #   #   .   .   .i1 '   .   .   .   .   .   .   .   #   #   .   .   . 1 (   .   .   .   .   .   .   .   #   #   .   .   . 1 )   .   .   .   .   .   .   .   #   #   .   .   . 1 *   .   .   .   .   .   .   .   #   #   .   .   .d1 +   .   .   .   .   .   .   .   #   #   .   .   .c1 ,   .   .   .   .   .   .   .   #   #   .   .   .c2 --   .   .   .   .   .   .   .   #   #   .   .   .1 .   .   .   .   .   .   .   .   #   #   .   .   .c1 /   .   .   .   .   .   .   .   #   #   .   .   .e  3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL? 1 0   #   #   #   #   .   .   .   .   #   .   .   .p1 1   #   #   #   #   .   .   .   .   #   .   .   . 1 2   #   #   #   #   .   .   .   .   #   .   .   .n1 3   #   #   #   #   .   .   .   .   #   .   .   ..1 4   #   #   #   #   .   .   .   .   #   .   .   .11 5   #   #   #   #   .   .   .   .   #   .   .   .p1 6   #   #   #   #   .   .   .   .   #   .   .   .x1 7   #   #   #   #   .   .   .   .   #   .   .   .s1 8   #   .   #   #   .   .   .   .   #   .   .   .i1 9   #   .   #   #   .   .   .   .   #   .   .   ..1 :   .   .   .   .   .   .   .   #   #   .   .   ._1 ;   .   .   .   .   .   .   .   #   #   .   .   .k1 <   .   .   .   .   .   .   .   #   #   .   .   . 1 =   .   .   .   .   .   .   .   #   #   .   .   .i1 >   .   .   .   .   .   .   .   #   #   .   .   . 1 ?   .   .   .   .   .   .   .   #   #   .   .   .a  3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL?,1 @   .   .   .   .   .   .   .   #   #   .   .   . 1 A   .   .   #   #   #   .   #   .   #   .   .   .e1 B   .   .   #   #   #   .   #   .   #   .   .   . 1 C   .   .   #   #   #   .   #   .   #   .   .   .e1 D   .   .   #   #   #   .   #   .   #   .   .   .i1 E   .   .   #   #   #   .   #   .   #   .   .   .r1 F   .   .   #   #   #   .   #   .   #   .   .   . 1 G   .   .   .   #   #   .   #   .   #   .   .   .e1 H   .   .   .   #   #   .   #   .   #   .   .   .n1 I   .   .   .   #   #   .   #   .   #   .   .   . 1 J   .   .   .   #   #   .   #   .   #   .   .   .t1 K   .   .   .   #   #   .   #   .   #   .   .   . 1 L   .   .   .   #   #   .   #   .   #   .   .   . 1 M   .   .   .   #   #   .   #   .   #   .   .   .h1 N   .   .   .   #   #   .   #   .   #   .   .   .t1 O   .   .   .   #   #   .   #   .   #   .   .   .(  3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL? 1 P   .   .   .   #   #   .   #   .   #   .   .   .-1 Q   .   .   .   #   #   .   #   .   #   .   .   . 1 R   .   .   .   #   #   .   #   .   #   .   .   .21 S   .   .   .   #   #   .   #   .   #   .   .   . 1 T   .   .   .   #   #   .   #   .   #   .   .   . 1 U   .   .   .   #   #   .   #   .   #   .   .   .c1 V   .   .   .   #   #   .   #   .   #   .   .   .;1 W   .   .   .   #   #   .   #   .   #   .   .   .r1 X   .   .   .   #   #   .   #   .   #   .   .   .e1 Y   .   .   .   #   #   .   #   .   #   .   .   . 1 Z   .   .   .   #   #   .   #   .   #   .   .   ._1 [   .   .   .   .   .   .   .   #   #   .   .   .a1 \   .   .   .   .   .   .   .   #   #   .   .   .f1 ]   .   .   .   .   .   .   .   #   #   .   .   .e1 ^   .   .   .   .   .   .   .   #   #   .   .   .c1 _   .   .   .   .   .   .   .   #   #   .   .   .l  3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL?e1 `   .   .   .   .   .   .   .   #   #   .   .   .g1 a   .   .   #   #   #   #   .   .   #   .   .   .s1 b   .   .   #   #   #   #   .   .   #   .   .   .a1 c   .   .   #   #   #   #   .   .   #   .   .   .r1 d   .   .   #   #   #   #   .   .   #   .   .   . 1 e   .   .   #   #   #   #   .   .   #   .   .   . 1 f   .   .   #   #   #   #   .   .   #   .   .   .o1 g   .   .   .   #   #   #   .   .   #   .   .   . 1 h   .   .   .   #   #   #   .   .   #   .   .   .o1 i   .   .   .   #   #   #   .   .   #   .   .   .U1 j   .   .   .   #   #   #   .   .   #   .   .   . 1 k   .   .   .   #   #   #   .   .   #   .   .   .i1 l   .   .   .   #   #   #   .   .   #   .   .   .e1 m   .   .   .   #   #   #   .   .   #   .   .   .e1 n   .   .   .   #   #   #   .   .   #   .   .   . 1 o   .   .   .   #   #   #   .   .   #   .   .   .v  3 ch  DD? OD? XD? AN? AF? LC? UC? PT? PR? CT? SP? EL? 1 p   .   .   .   #   #   #   .   .   #   .   .   .i1 q   .   .   .   #   #   #   .   .   #   .   .   .-1 r   .   .   .   #   #   #   .   .   #   .   .   .u1 s   .   .   .   #   #   #   .   .   #   .   .   .e1 t   .   .   .   #   #   #   .   .   #   .   .   .i1 u   .   .   .   #   #   #   .   .   #   .   .   .a1 v   .   .   .   #   #   #   .   .   #   .   .   .e1 w   .   .   .   #   #   #   .   .   #   .   .   .h1 x   .   .   .   #   #   #   .   .   #   .   .   .e1 y   .   .   .   #   #   #   .   .   #   .   .   .f1 z   .   .   .   #   #   #   .   .   #   .   .   .h1 {   .   .   .   .   .   .   .   #   #   .   .   .)1 |   .   .   .   .   .   .   .   #   #   .   .   .l1 }   .   .   .   .   .   .   .   #   #   .   .   .	1 DEL .   .   .   .   .   .   .   #   .   #   .   .). -h- ctypes.h	Thu Jun 21 23:07:38 1984	ctypes.h /*  File   : ctypes.h       Author : Richard A. O'Keefe.     Updated: 26 April 19843     Purpose: Reimplement the UNIX ctype(3) library.+  <     isaneol(c) means that c is a line terminating character.=     isalnum, ispunct, isspace, and isaneol are defined on the9=     range -1..127, i.e. on ASCII U {EOF}, while all the otherc'     macros are defined for any integer.   (     isodigit(c) checks for Octal digits..     isxdigit(c) checkx for heXadecimal digits. */  - #define isdigit(c)	((unsigned)((c)-'0') < 10) - #define islower(c)	((unsigned)((c)-'a') < 26)c- #define isupper(c)	((unsigned)((c)-'A') < 26) - #define isprint(c)	((unsigned)((c)-' ') < 95)f. #define iscntrl(c)	((unsigned)((c)-' ') >= 95)( #define isascii(c)	((unsigned)(c) < 128)2 #define isalpha(c)	((unsigned)(((c)|32)-'a') < 26)   extern	char	_c2type[];  ( #define isalnum(c)	(_c2type[(c)+1] < 36)) #define ispunct(c)	(_c2type[(c)+1] == 36)l( #define isspace(c)	(_c2type[(c)+1] > 37)( #define isaneol(c)	(_c2type[(c)+1] > 38)  ) #define	isxdigit(c)	(_c2type[(c)+1] < 16)D- #define isodigit(c)	((unsigned)((c)-'0') < 8)a  H /*  The following "conversion" macros have been in some versions of UNIXH     but are not in all.  tocntrl is new.  The original motivation for ^?G     being a name for DEL was that (x)^64 mapped A..Z to ^A..^Z and also I     ? to DEL.  The trouble is that this trick doesn't work for lower caseoI     letters.  The version given here is not mine.  I wish it was.  It has A     the nice property that DEL is mapped to itself (so does EOF). ?     tolower(c) and toupper(c) are only defined when isalpha(c).c */ #define	tolower(c)	((c)|32)B #define toupper(c)	((c)&~32)* #define tocntrl(c)	(((((c)+1)&~96)-1)&127) #define	toascii(c)	((c)&127)  ( -h- ffs.c	Thu Jun 21 23:07:38 1984	ffs.c /*  File   : ffs.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: ffs(), ffc()d  A     ffs(i) returns the index of the least significant 1 bit in i,e< 	   where 1 means the least significant bit and 32 means the2 	   most significant bit, or returns -1 if i is 0.  A     ffc(i) returns the index of the least significant 0 bit in i, < 	   where 1 means the least significant bit and 32 means the3 	   most significant bit, or returns -1 if i is ~0.'  G     These functions mimic the VAX FFS and FFC instructions, except that2G     the latter return much more sensible values.  This file only existsOE     to make it easier to move 4.2bsd programs to System III (which is G     rather like moving up from a Rolls Royce to a model T Ford), and soo1     I haven't bother with assembly code versions.c */   #include "strings.h"  
 int ffs(i)     register int i;c     {c 	register int N;  + 	for (N = 8*sizeof(int); --N >= 0; i >>= 1)M% 	    if (i&1) return 8*sizeof(int)-N;U 	return -1;U     }e  
 int ffc(i)     register int i;*     {f 	register int N;  + 	for (N = 8*sizeof(int); --N >= 0; i >>= 1)p( 	    if (!(i&1)) return 8*sizeof(int)-N; 	return -1;d     }S    . -h- getopt.3	Thu Jun 21 23:07:38 1984	getopt.3 .TH GETOPT 3 local .DA 25 March 1982  .SH NAME% getopt \- get option letter from argv	 .SH SYNOPSIS .ft Bb! int getopt(argc, argv, optstring)e .br 	 int argc;: .brp char **argv; .bre char *optstring; .sps extern char *optarg; .bre extern int optind; .ft" .SH DESCRIPTIONn	 .I Getopte! returns the next option letter inz .I argve that matches a letter in .IR optstring .p .I Optstring) is a string of recognized option letters;oB if a letter is followed by a colon, the option is expected to haveD an argument that may or may not be separated from it by white space.	 .I Optarg B is set to point to the start of the option argument on return from .IR getopt . .PPt	 .I Getopts	 places in 	 .I optindt thee .I argv + index of the next argument to be processed.  Becauset	 .I optind = is external, it is normally initialized to zero automaticallyh before the first call to c .IR getopt . .PPt; When all options have been processed (i.e., up to the firstr non-option argument),i	 .I getoptT returns 	 .BR EOF .o The special option .B \-\- . may be used to delimit the end of the options; .B EOF will be returned, andh .B \-\-o will be skipped. .SH SEE ALSO	 getopt(1)  .SH DIAGNOSTICSe	 .I Getopth prints an error message on	 .I stderrh and returns a question markt	 .RB ( ? )a3 when it encounters an option letter not included in  .IR optstring .b .SH EXAMPLEeE The following code fragment shows how one might process the argumentso: for a command that can take the mutually exclusive options .B a and  .BR b ,r and the options. .B f andc .BR o ,i  both of which require arguments: .PP, .RS( .nf  main(argc, argv)
     int argc;      char **argv;     {(         int c;         extern int optind;         extern char *optarg;         \&.s         \&.          \&.l;         while ((c = getopt(argc, argv, "abf:o:")) != EOF) {r             switch (c) {                 case 'a': 4                     if (bflg) errflg++; else aflg++;                     break;                 case 'b':94                     if (aflg) errflg++; else bflg++;                     break;                 case 'f':t#                     ifile = optarg;e                     break;                 case 'o':o#                     ofile = optarg;p                     break;                 case '?':h                 default:                     errflg++;                      break;
             } 	         }          if (errflg) {s*             fprintf(stderr, "Usage: ...");             exit(2);	         }h)         for (; optind < argc; optind++) {              \&.h             \&.d             \&. 	         }i         \&.          \&.h         \&.s     }e .RE  .PPi* A template similar to this can be found in .IR /usr/pub/template.c .e .SH HISTORYt? Written by Henry Spencer, working from a Bell Labs manual page.m0 Behavior believed identical to the Bell version. .SH BUGS It is not obvious howh `\-'; standing alone should be treated; this version treats it asa1 a non-option argument, which is not always right.  .PPl0 Option arguments are allowed to begin with `\-';E this is reasonable but reduces the amount of error checking possible.d .PPx	 .I Getopt C is quite flexible but the obvious price must be paid: there is muchu! it could do that it doesn't, likea5 checking mutually exclusive options, checking type ofs option arguments, etc.. -h- getopt.c	Thu Jun 21 23:07:38 1984	getopt.c /*  File   : getopt.c 1     Author : Henry Spencer, University of Torontos     Updated: 28 April 1984)     Purpose: get option letter from argv.u */   #include <stdio.h> #include "strings.h"  , char	*optarg;	/* Global argument pointer. */( int	optind = 0;	/* Global argv index. */  ! int getopt(argc, argv, optstring))
     int argc;;     char *argv[];      char *optstring;     {i 	register int c; 	register char *place;7 	static char *scan = NullS;	/* Private scan pointer. */    	optarg = NullS;  & 	if (scan == NullS || *scan == '\0') { 	    if (optind == 0) optind++; $ 	    if (optind >= argc) return EOF; 	    place = argv[optind];9 	    if (place[0] != '-' || place[1] == '\0') return EOF;  	    optind++;9 	    if (place[1] == '-' && place[2] == '\0') return EOF;9 	    scan = place+1; 	}  
 	c = *scan++;s 	place = index(optstring, c);t" 	if (place == NullS || c == ':') {< 	    fprintf(stderr, "%s: unknown option %c\n", argv[0], c); 	    return '?'; 	} 	if (*++place == ':') {  	    if (*scan != '\0') {  		optarg = scan, scan = NullS;
 	    } else {h" 		optarg = argv[optind], optind++; 	    } 	}
 	return c;     }   0 -h- int2str.c	Thu Jun 21 23:07:38 1984	int2str.c /*  File   : int2str.c     Author : Richard A. O'Keefeh     Updated: 30 April 1984&     Defines: int2str(), itoa(), ltoa()       int2str(dst, radix, val)G     converts the (long) integer "val" to character form and moves it tolD     the destination string "dst" followed by a terminating NUL.  TheH     result is normally a pointer to this NUL character, but if the radix@     is dud the result will be NullS and nothing will be changed.  3     If radix is -2..-36, val is taken to be SIGNED. 5     If radix is  2.. 36, val is taken to be UNSIGNED.aF     That is, val is signed if and only if radix is.  You will normallyC     use radix -10 only through itoa and ltoa, for radix 2, 8, or 167(     unsigned is what you generally want.  =     _dig_vec is public just in case someone has a use for it.eF     The definitions of itoa and ltoa are actually macros in strings.h,"     but this is where the code is. */   #include "strings.h"   char _dig_vec[] =o+     "0123456789abcdefghijklmnopqrstuvwxyz";      char *int2str(dst, radix, val)     register char *dst;a     register int radix;o     register long val;     {s 	char buffer[33];/ 	register char *p;   	if (radix < 0) { 1 	    if (radix < -36 || radix > -2) return NullS;  	    if (val < 0) {0 		*dst++ = '-';*
 		val = -val;t 	    } 	    radix = -radix;	 	} else {)/ 	    if (radix > 36 || radix < 2) return NullS;c 	}< 	/*  The slightly contorted code which follows is due to theC 	    fact that few machines directly support unsigned long / and %. B 	    Certainly the VAX C compiler generates a subroutine call.  InA 	    the interests of efficiency (hollow laugh) I let this happen C 	    for the first digit only; after that "val" will be in range so = 	    that signed integer division will do.  Sorry 'bout that. C 	    CHECK THE CODE PRODUCED BY YOUR C COMPILER.  The first % and / C 	    should be unsigned, the second % and / signed, but C compilersFD 	    tend to be extraordinarily sensitive to minor details of style.4 	    This works on a VAX, that's all I claim for it. 	*/  	p = &buffer[32];  	*p = '\0'; : 	*--p = _dig_vec[(unsigned long)val%(unsigned long)radix];/ 	val = (unsigned long)val/(unsigned long)radix; ; 	while (val != 0) *--p = _dig_vec[val%radix], val /= radix;  	while (*dst++ = *p++) ; 	return dst-1;     }   0 -h- memccpy.c	Thu Jun 21 23:07:38 1984	memccpy.c /*  File   : memccpy.c      Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memccpy()       memccpy(dst, src, chr, len) G     copies bytes from src to dst until either len bytes have been moved G     or a byte equal to chr has been moved.  In the former case it gives G     NullS as the value, in the latter a pointer to just after the place G     where "chr" was moved to in dst.  Note that copying stops after the G     first instance of "chr", and that remaining characters in "dst" are >     not changed in any way, no NUL being inserted or anything.  ?     See the "Character Comparison" section in the READ-ME file.  */   #include "strings.h"  ! char *memccpy(dst, src, chr, len)      register char *dst, *src; +     register int chr;		/* should be char */      register int len;]     {  	while (--len >= 0) . 	    if ((*dst++ = *src++) == chr) return dst; 	return NullS;     }   . -h- memchr.c	Thu Jun 21 23:07:38 1984	memchr.c /*  File   : memchr.c       Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memchr()t       memchr(src, chr, len) G     searches the memory area pointed to by src extending for len bytes, F     looking for an occurrence of the byte value chr.  It returns NullSF     if there is no such occurrence.  Otherwise it returns a pointer to     the FIRST such occurrence.  ?     See the "Character Comparison" section in the READ-ME file.  */   #include "strings.h"  
 #if	VaxAsm   char *memchr(src, chr, len)      char *src;
     char chr;      int len;     { ! 	asm("locc 8(ap),12(ap),*4(ap)");  	asm("bneq L1"); 	asm("movl r1,r0");  	asm("L1: ret");     }    #else  ~VaxAsm   char *memchr(src, chr, len)-     register char *src; +     register int chr;		/* should be char */      register int len;      {  	while (--len >= 0) % 	    if (*src++ == chr) return src-1;D 	return NullS;     }T  
 #endif	VaxAsm   . -h- memcmp.c	Thu Jun 21 23:07:38 1984	memcmp.c /*  File   : memcmp.c       Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memcmp()        memcmp(lhs, rhs, len) H     compares the two memory areas lhs[0..len-1]  ??  rhs[0..len-1].   ItH     returns  an integer less than, equal to, or greater than 0 accordingH     as lhs[-] is lexicographically less than, equal to, or greater  thanH     rhs[-].  Note  that this is not at all the same as bcmp, which tells/     you *where* the difference is but not what.   H     Note:  suppose we have int x, y;  then memcmp(&x, &y, sizeof x) needH     not bear any relation to x-y.  This is because byte order is machineH     dependent, and also, some machines have integer representations thatH     are shorter than a machine word and two equal  integers  might  haveH     different  values  in the spare bits.  On a ones complement machine,0     -0 == 0, but the bit patterns are different.  H     This could have a Vax assembly code version, but as the return valueH     is not the value left behind by  the  cmpc3  instruction  I  haven't
     bothered.  */   int memcmp(lhs, rhs, len)      register char *lhs, *rhs;      register int len;      {  	while (--len >= 0) 2 	    if (*lhs++ != *rhs++) return lhs[-1]-rhs[-1];
 	return 0;     }   . -h- memcpy.c	Thu Jun 21 23:07:38 1984	memcpy.c /*  File   : memcpy.c       Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memcpy()        memcpy(dst, src, len) E     moves len bytes from src to dst.  The result is dst.  This is not E     the same as strncpy or strnmov, while move a maximum of len bytes E     and stop early if they hit a NUL character.  This moves len bytes E     exactly, no more, no less.  See also bcopy() and bmove() which do 5     not return a value but otherwise do the same job.   H     Note: the VAX assembly code version can only handle 0 <= len < 2^16.4     It is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   char *memcpy(dst, src, len)      char *dst, *src;     int len;     { # 	asm("movc3 12(ap),*8(ap),*4(ap)");  	return dst;     }    #else  ~VaxAsm   char *memcpy(dst, src, len)      char *dst;     register char *src;      register int len;      {  	register char *d;  + 	for (d = dst; --len >= 0; *d++ = *src++) ;  	return dst;     }   
 #endif	VaxAsm   . -h- memmov.c	Thu Jun 21 23:07:38 1984	memmov.c /*  File   : memmov.c       Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memmov()        memmov(dst, src, len) <     moves len bytes from src to dst.  The result is dst+len.E     This is to memcpy as str[n]mov is to str[n]cpy, that is, it moves B     exactly the same bytes but returns a pointer to just after theA     the last changed byte.  You can concatenate blocks pa for la, .     pb for lb, pc for lc into area pd by doing4 	memmov(memmov(memmov(pd, pa, la), pb, lb), pc, lc);A     Unlike strnmov, memmov does not stop when it hits a NUL byte.   H     Note: the VAX assembly code version can only handle 0 <= len < 2^16.4     It is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   char *memmov(dst, src, len)      char *dst, *src;     int len;     { # 	asm("movc3 12(ap),*8(ap),*4(ap)");  	return dst+len;     }    #else  ~VaxAsm   char *memmov(dst, src, len)      register char *dst, *src;      register int len;      { $ 	while (--len >= 0) *dst++ = *src++; 	return dst;     }   
 #endif	VaxAsmN  . -h- memory.h	Thu Jun 21 23:07:38 1984	memory.h /*  File   : memory.h       Author : Richard A. O'Keefe.     Updated: 1 June 1984?     Purpose: Header file for the System V "memory(3C)" package.   H     All the functions in this package are the original work  of  RichardH     A. O'Keefe.   Any resemblance between them and any functions in AT&TH     or other licensed software is due entirely to my use of the System VH     memory(3C) manual page as a specification.  See the READ-ME to  findD     the conditions under which this material may be used and copied.  H     The System V manual says that the mem* functions are declared in theI     <memory.h> file.  This file is also included in the <strings.h> file, 9     but it does no harm to #include both in either order.  */   #ifndef	memeql   #define memeql	!memcmp' extern	int	memcmp(/*char^,char^,int*/);i) extern	char	*memcpy(/*char^,char^,int*/);'/ extern	char	*memccpy(/*char^,char^,char,int*/);R( extern	char	*memset(/*char^,char,int*/);( extern	char	*memchr(/*char^,char,int*/);) extern	char	*memrchr(/*char^,char,int*/);s) extern	char	*memmov(/*char^,char^,int*/); ( extern	void	memrev(/*char^,char^,int*/);  
 #endif	memeql   0 -h- memrchr.c	Thu Jun 21 23:07:38 1984	memrchr.c /*  File   : memrchr.c      Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memrchr()       memrchr(src, chr, len)G     searches the memory area pointed to by src extending for len bytes,eF     looking for an occurrence of the byte value chr.  It returns NullSF     if there is no such occurrence.  Otherwise it returns a pointer to     the LAST such occurrence.)  ?     See the "Character Comparison" section in the READ-ME file.n */   #include "strings.h"   char *memrchr(src, chr, len)     register char *src;n+     register int chr;		/* should be char */s     register int len;]     {  	register char *ans;% 	for (ans = NullS; --len >= 0; src++)t  	    if (*src == chr) ans = src; 	return ans;     }n  . -h- memrev.c	Thu Jun 21 23:07:38 1984	memrev.c /*  File   : memrev.cl      Author : Richard A. O'Keefe.     Updated: 1 June 1984     Defines: memrev()a       memrev(dst, src, len)ZF     moves len bytes from src to dst, in REVERSE order.  NUL charactersF     receive no special treatment, they are moved like the rest.  It is%     to strrev as memcpy is to strcpy.t  F     Note: this function is perfectly happy to reverse a block into the*     same place, memrev(x, x, L) will work.F     It will not work for partially overlapping source and destination. */   #include "strings.h"   void memrev(dsta, srca, len)     register char *dsta, *srca;      int len;     {  	register char *dstz, *srcz; 	register int t;   	if (len <= 0) return; 	srcz = srca+len;f 	dstz = dsta+len;r 	while (srcz > srca) { 	    t = *--srcz;  	    *--dstz = *srca++;e 	    *dsta++ = t;f 	}     }n  . -h- memset.c	Thu Jun 21 23:07:38 1984	memset.c /*  File   : memset.c       Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: memset()h       memset(dst, chr, len)2H     fills the memory area dst[0..len-1] with len bytes all equal to chr.G     The result is dst.  See also bfill(), which has no return value andh5     puts the last two arguments the other way around.n  H     Note: the VAX assembly code version can only handle 0 <= len < 2^16.4     It is presented for your interest and amusement. */   #include "strings.h"  
 #if	VaxAsm   char *memset(dst, chr, len)o     char *dst;#     int chr;			/* should be char */e     int len;     {c, 	asm("movc5 $0,*4(ap),8(ap),12(ap),*4(ap)"); 	return dst;     }    #else  ~VaxAsm   char *memset(dst, chr, len)1     char *dst;+     register int chr;		/* should be char */s     register int len;      {f 	register char *d;  ( 	for (d = dst; --len >= 0; *d++ = chr) ; 	return dst;     }   
 #endif	VaxAsmo  2 -h- memtrans.c	Thu Jun 21 23:07:38 1984	memtrans.c /*  File   : memtrans.c       Author : Richard A. O'Keefe.     Updated: 2 June 1984     Defines: memtrans()g  %     memtrans(dst, src, from, to, len)bH     copies exactly len characters from src[] to dst[], translating charsH     in from[] to corresponding characters in to[].   From[] and to[] areH     handled by _str2map. BEWARE: _str2map normally expects characters inH     the range 0..127.  The Vax MOVTC instruction thinks its table is 256H     bytes long; if you want to translate arbitrary bytes you'd better beH     sure that the _map_vec array is 256 bytes long.  As distributed, theE     memtrans function is only for translating ASCII (to 8-bit codes).t  H     The VaxAsm code can only handle 0 <= len < 2^16, and is presented asH     usual for your interest and amusement.  Why *do* designers of 32-bitG     machines put 16-bit limits on strings?  (Dec aren't the only ones.)t */   #include "strings.h" #include "_str2map.h".  
 #if	VaxAsm  & void memtrans(dst, src, from, to, len)"     _char_ *dst, *src, *from, *to;     int len;     {e 	_str2map(0, from, to);o7 	asm("movtc 20(ap),*8(ap),$0,__map_vec,20(ap),*4(ap)");      }    #else  ~VaxAsm  & void memtrans(dst, src, from, to, len)     register _char_ *dst, *src;      _char_ *from, *to;     register int len;      {h 	_str2map(0, from, to);n. 	while (--len >= 0) *dst++ = _map_vec[*src++];     }e  
 #endif	VaxAsmo  2 -h- readme.txt	Thu Jun 21 23:07:38 1984	readme.txt File   : READ-ME Author : Richard A. O'Keefe. Updated: 1 June 1984. ) Purpose: Explain the new strings package.B  F     The UNIX string libraries (described in the string(3) manual page)F differ from UNIX to UNIX (e.g. strtok is not in V7 or 4.1bsd).  Worse,F the sources are not in the public domain, so that if there is a stringF routine which is nearly what you want but not quite you can't  take  aF copy  and  modify it.  And of course C programmers on non-UNIX systems# are at the mercy of their supplier.l  F     This package was designed to let me do reasonable things with  C'sF strings  whatever UNIX (V7, PaNiX, UX63, 4.1bsd) I happen to be using.F Everything in the System III manual is here and does just what the  S3F manual  says  it does.  There are also lots of new goodies.  I'm sorryF about the names, but the routines do have to work  on  asphyxiated-at-F birth  systems  which  truncate identifiers.  The convention is that a routine is called  	str [n] [c] <operation>F If there is an "n", it means that the function takes an (int) "length"F argument, which bounds the number of characters to be moved or  lookedF at.  If the function has a "set" argument, a "c" in the name indicatesF that  the complement of the set is used.  Functions or variables whoseF names start with _ are support routines which aren't really meant  forF general  use.  I don't know what the "p" is doing in "strpbrk", but itF is there in the S3 manual so it's here too.  "istrtok" does not follow. this rule, but with 7 letters what can you do?  F     I have included new versions of atoi(3) and atol(3) as well.  TheyF use a new primitive str2int, which takes a pair of bounds and a radix,F and does much more thorough checking than the normal atoi and atol do.F The result returned by atoi & atol is valid if and only if errno == 0.F There is also an output conversion routine int2str, with itoa and ltoaF as interface macros.  Only after writing int2str did I notice that theF str2int routine has no provision for unsigned numbers.  On reflection,F I don't greatly care.   I'm afraid that int2str may depend on your "C"8 compiler in unexpected ways.  Do check the code with -S.  F     Several of these routines have "asm" inclusions conditional on theF VaxAsm option.  These insertions can make the routines which have themF quite a bit faster, but there is a snag.  The VAX architects, for someF reason best known to themselves and their therapists, decided that allF "strings" were shorter than 2^16 bytes.  Even when the length operandsF are in 32-bit registers, only 16 bits count.  So the "asm" versions doF not work for long strings.  If you can guarantee that all your stringsF will be short, define VaxAsm in the makefile, but in general, and when' using other machines, do not define it.c  F     Thanks to someone on the net who saw the first posting of strings,F and sent me a formatted copy of the System V memory(3C) manual page, IF have been able to include versions of these routines.   The convention is that they are called=! 	mem{operation}([dst,] ... , len)hF where operation is cpy, cmp, chr, and so on, and len is how many bytesF to move or test.  Note that this is different from the strn functions,5 	str{operation}	-- stop when you find a NUL characteri> 	strn{operation}	-- stop when len is exhausted or you find NUL- 	mem{operation}	-- stop when len is exhausted + 	b{operation}	-- stop when len is exhausted F but the b family has different argument orders or different results orF both.  In particular, note that my implementation of bcmp does conformF to the letter of the 4.2bsd manual page, but I decided to make it giveF a value I have often wanted, which is not like the value of strcmp. AsF the System V manual page is more explicit about the return code memcmpF DOES return a value like strcmp, so you may prefer to use it.  BEWARE:F the "c" in the name mem-c-cpy doesn't mean what it does in the System3" names, it's more like mem-chr-cpy.  F     To use this library, you need the "strings.a" library file and theF "strings.h" header file.  The other header files are for compiling theF library itself, though if you are hacking extensions you may find themF useful.  General users really shouldn't see them.  I've defined a  fewF macros  I find useful in "strings.h"; if you have no need for "index",F "rindex", "streql", and "beql", just edit them  out.   On  the  4.1bsdF system  I  am using, having all these functions 'extern' does not meanF that they will all be loaded; only the ones you call are.  When  usingF lesser  systems you may find it necessary to break strings.h up or youF could get by with just adding "extern" declarations for  functions  asF you  need  them.   Note  that  as  many  of these functions have namesF matching "standard C library" names (by design, this is  after  all  aF replacement/reimplementation  of part of that library) you may have toF talk the loader into loading this library first.  Again, I've found no problems on 4.1bsd.T  F     A note on character comparison.  The various UNIX manuals come outE and say explicitly that the *cmp and *chr routines use the computer'sxF "native" character comparison.  That is, on a PDP-11, VAX-11, and someF other machines, signed character comparison is used, and the byte 0377F will never be located (use -1).   On IBM 370s and many other machines,F unsigned character comparison is used, and the byte -1 can't be found.F (Use 0377.)  If you have occasion to use 8-bit byte values in calls toF *chr functions, it would be nice if the package looked after making itF work portably.  I thought about that, and decided not to do it, as youF might *want* to write VAX code that didn't find 128, and might rely onF the current effect. However, you should be able to use 8-bit values inD a portable fashion if you ask, and that the package DOES do for you. There is a macro 	int2char(c)G which takes the bottom 8 bits of c on a machine with unsigned character G comparison or sign-extends them on a machine with signed comparison. It G is up to you to use this macro in appropriate places.  It is up to who-iG ever installs the package to make sure that the right definition is put # in and the wrong one commented out.t  H     You may wonder at my failure to provide manual pages for this  code.H For  the things in V7, 4.?, or SIII, you should be able to use whicheverH manual page came with that system, and anything I might write  would  beH so  like it as to raise suspicions of violating AT&T copyrights.  In theH sources you will find comments which provide far more documentation  forH these  routines  than AT&T ever provided for their strings stuff, I justH don't happen to have put it in nroff -man form.   Had I done so, the *.3( files would have outbulked the .c files!  H     There is a manual page for the strx family of routines.   It was theH work of Tony Hansen, of AT&T Information Systems Lincroft NJ.  It is notH clear whether I should distribute this manual page or not,  but as theseF functions are not likely to documented anywhere else I decided to riskH it.  There is no risk in the *code* however.  His posting to net.sourcesG arrived at Edinburgh with just the reason for reposting, and the manual G page.  The code is my own work based on his manual page.  Indeed, I hadt2 already written strx[n]mov, using different names.  H     These files are in the public domain.  This includes getopt.c, whichH is the work of Henry Spencer, University of Toronto Zoology, who says ofH it "None of this software is derived from Bell software. I had no accessH to the source for Bell's versions at the time I wrote it.  This softwareH is hereby explicitly placed in the public domain.  It may  be  used  forH any purpose on any machine by anyone." I would greatly prefer it if *my*" material received no military use.  0 -h- str2int.c	Thu Jun 21 23:07:38 1984	str2int.c /*  File   : str2int.c     Author : Richard A. O'Keefet     Updated: 27 April 1984&     Defines: str2int(), atoi(), atol()  +     str2int(src, radix, lower, upper, &val) H     converts the string pointed to by src to an integer and stores it inH     val.  It skips leading spaces and tabs (but not newlines, formfeeds,J     backspaces), then it accepts an optional sign and a sequence of digitsN     in the specified radix.  The result should satisfy lower <= *val <= upper.D     The result is a pointer to the first character after the number;(     trailing spaces will NOT be skipped.  D     If an error is detected, the result will be NullS, the value put.     in val will be 0, and errno will be set to 	EDOM	if there are no digits= 	ERANGE	if the result would overflow or otherwise fail to liei 		within the specified bounds.5     Check that the bounds are right for your machine. I     This looks amazingly complicated for what you probably thought was an H     easy task.  Coping with integer overflow and the asymmetric range of2     twos complement machines is anything but easy.  F     So that users of atoi and atol can check whether an error occured,F     I have taken a wholly unprecedented step: errno is CLEARED if this     call has no problems.a */   #include "strings.h" #include "ctypes.h"e #include <errno.h> extern int errno;)  / /*	CHECK THESE CONSTANTS FOR YOUR MACHINE!!!	*/   	 #if	pdp11 3 #   define	MaxInt      0x7fffL	/* int  = 16 bits */h #   define	MinInt      0x8000L3 #   define	MaxLong 0x7fffffffL	/* long = 32 bits */i #   define	MinLong 0x80000000L
 #else  !pdp11y3 #   define	MaxInt  0x7fffffffL	/* int  = 32 bits */  #   define	MinInt  0x80000000L3 #   define	MaxLong 0x7fffffffL	/* long = 32 bits */  #   define	MinLong 0x80000000L #endif	pdp11    , char *str2int(src, radix, lower, upper, val)     register char *src;*     register int radix;n     long lower, upper, *val;     {;: 	int sign;		/* is number negative (+1) or positive (-1) */4 	int n;			/* number of digits yet to be converted */2 	long limit;		/* "largest" possible valid input */8 	long scale;		/* the amount to multiply next digit by */% 	long sofar;		/* the running value */t0 	register int d;		/* (negative of) next digit */ 	char *answer;		  4 	/*  Make sure *val is sensible in case of error  */  
 	*val = 0;  3 	/*  Check that the radix is in the range 2..36  */c   	if (radix < 2 || radix > 36) {f 	    errno = EDOM; 	    return NullS; 	}  = 	/*  The basic problem is: how do we handle the conversion ofm; 	    a number without resorting to machine-specific code toe; 	    check for overflow?  Obviously, we have to ensure that1= 	    no calculation can overflow.  We are guaranteed that the > 	    "lower" and "upper" arguments are valid machine integers.@ 	    On sign-and-magnitude, twos-complement, and ones-complement? 	    machines all, if +|n| is representable, so is -|n|, but on ? 	    twos complement machines the converse is not true.  So the B 	    "maximum" representable number has a negative representative.B 	    Limit is set to min(-|lower|,-|upper|); this is the "largest"% 	    number we are concerned with.	*/.  : 	/*  Calculate Limit using Scale as a scratch variable  */  ) 	if ((limit = lower) > 0) limit = -limit;m) 	if ((scale = upper) > 0) scale = -scale;n" 	if (scale < limit) limit = scale;  . 	/*  Skip leading spaces and check for a sign.@ 	    Note: because on a 2s complement machine MinLong is a valid> 	    integer but |MinLong| is not, we have to keep the current< 	    converted value (and the scale!) as *negative* numbers,: 	    so the sign is the opposite of what you might expect.2 	    Should the test in the loop be isspace(*src)? 	*/t+ 	while (*src == ' ' || *src == '\t') src++;. 	sign = -1;s 	if (*src == '+') src++; elseh" 	if (*src == '-') src++, sign = 1;  / 	/*  Check that there is at least one digit  */e  ! 	if (_c2type[1+ *src] >= radix) {i 	    errno = EDOM; 	    return NullS; 	}  A 	/*  Skip leading zeros so that we never compute a power of radixc@ 	    in scale that we won't have a need for.  Otherwise stickingB 	    enough 0s in front of a number could cause the multiplication# 	    to overflow when it neededn't.h 	*/n 	while (*src == '0') src++;c  B 	/*  Move over the remaining digits.  We have to convert from leftE 	    to left in order to avoid overflow.  Answer is after last digit.e 	*/ / 	for (n = 0; _c2type[1+ *src++] < radix; n++) ;  	answer = --src;  : 	/*  The invariant we want to maintain is that src is just: 	    to the right of n digits, we've converted k digits to: 	    sofar, scale = -radix**k, and scale < sofar < 0.  Now5 	    if the final number is to be within the original < 	    Limit, we must have (to the left)*scale+sofar >= Limit,; 	    or (to the left)*scale >= Limit-sofar, i.e. the digitshF 	    to the left of src must form an integer <= (Limit-sofar)/(scale).; 	    In particular, this is true of the next digit.  In ourr& 	    incremental calculation of Limit,  * 		IT IS VITAL that (-|N|)/(-|D|) = |N|/|D| 	*/; 	r* 	for (sofar = 0, scale = -1; --n >= 0; ) { 	    d = _c2type[1+ *--src]; 	    if (-d < limit) { 		errno = ERANGE;  		return NullS;a 	    }/ 	    limit = (limit+d)/radix, sofar += d*scale;t@ 	    if (n != 0) scale *= radix;	/* watch out for overflow!!! */ 	}    E 	/*  Now it might still happen that sofar = -32768 or its equivalent,eD 	    so we can't just multiply by the sign and check that the resultB 	    is in the range lower..upper.  All of this caution is a rightC 	    pain in the neck.  If only there were a standard routine whiche@ 	    says generate thus and such a signal on integer overflow.... 	    But not enough machines can do it *SIGH*. 	*/*? 	if (sign < 0 && sofar < -MaxLong /* twos-complement problem */s. 	||  (sofar*=sign) < lower || sofar > upper) { 	    errno = ERANGE; 	    return NullS; 	} 	*val = sofar;. 	errno = 0;		/* indicate that all went well */ 	return answer;      }h    
 int atoi(src)2     char *src;     {c
 	long val;( 	str2int(src, 10, MinInt, MaxInt, &val); 	return (int)val;2     }9     long atol(src)     char *src;     {t
 	long val;* 	str2int(src, 10, MinLong, MaxLong, &val); 	return val;     }l  . -h- strcat.c	Thu Jun 21 23:07:38 1984	strcat.c /*  File   : strcat.ca      Author : Richard A. O'Keefe.     Updated: 10 April 1984     Defines: strcat()   H     strcat(s, t) concatenates t on the end of s.  There  had  better  beH     enough  room  in  the  space s points to; strcat has no way to tell.H     Note that strcat has to search for the end of s, so if you are doing?     a lot of concatenating it may be better to use strmov, e.g.2* 	strmov(strmov(strmov(strmov(s,a),b),c),d)     rather thanr+ 	strcat(strcat(strcat(strcpy(s,a),b),c),d). &     strcat returns the old value of s. */   #include "strings.h"   char *strcat(s, t)     register char *s, *t;>     {+ 	char *save;   	for (save = s; *s++; ) ;V 	for (--s; *s++ = *t++; ) ;J
 	return save;1     }t  . -h- strchr.c	Thu Jun 21 23:07:38 1984	strchr.c /*  File   : strchr.cp      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strchr(), index()  H     strchr(s, c) returns a pointer to the  first  place  in  s  where  cH     occurs,  or  NullS if c does not occur in s. This function is calledH     index in V7 and 4.?bsd systems; while not ideal the name is  clearerH     than  strchr,  so index remains in strings.h as a macro.  NB: strchrH     looks for single characters,  not for sets or strings.   To find theH     NUL character which closes s, use strchr(s, '\0') or strend(s).  TheH     parameter 'c' is declared 'int' so it will go in a register; if your?     C compiler is happy with register _char_ change it to that.  */   #include "strings.h"   char *strchr(s, c)     register _char_ *s;      register int c;      {o 	for (;;) {D 	    if (*s == c) return s;/ 	    if (!*s++) return NullS;u 	}     }p  . -h- strcmp.c	Thu Jun 21 23:07:38 1984	strcmp.c /*  File   : strcmp.c*      Author : Richard A. O'Keefe.     Updated: 10 April 1984     Defines: strcmp()0  H     strcmp(s, t) returns > 0, = 0,  or < 0  when s > t, s = t,  or s < tH     according  to  the  ordinary  lexicographical  order.   To  test forH     equality, the macro streql(s,t) is clearer than  !strcmp(s,t).  NoteH     that  if the string contains characters outside the range 0..127 theH     result is machine-dependent; PDP-11s and  VAXen  use  signed  bytes,+     some other machines use unsigned bytes.n */   #include "strings.h"   int strcmp(s, t)     register char *s, *t;      {e( 	while (*s == *t++) if (!*s++) return 0; 	return s[0]-t[-1];      }.  2 -h- strcpack.c	Thu Jun 21 23:07:38 1984	strcpack.c /*  File   : strcpack.co      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strcpack()        strcpack(dst, src, set, c)H     copies characters from src to dst, stopping when it finds a NUL.  IfH     c is NUL, characters not in the set are not copied to dst.  If c  isH     not  NUL,  sequences  of  characters  not in the set are copied as aH     single c. strcpack is to strpack as strcspn is to strspn.  If your CH     compiler is happy with register _char_, change the declaration of c.H     The result is the address of the NUL byte that now terminates "dst".0     Note that dst may safely be the same as src. */   #include "strings.h" #include "_str2set.h"e    char *strcpack(dst, src, set, c)     register _char_ *dst, *src;u     char *set;     register int c;e     {c 	register int chr;   	_str2set(set);  	while (chr = *src++) { % 	    if (_set_vec[chr] != _set_ctr) {"7 		while ((chr = *src++) && _set_vec[chr] != _set_ctr) ;s8 		if (c) *dst++ = c;	/* 1. If you don't want trailing */8 		if (!chr) break;	/* 2. things turned into "c", swap */ 	    }				/* lines 1 and 2. */ 	    *dst++ = chr; 	}
 	*dst = 0; 	return dst;     }a  2 -h- strcpbrk.c	Thu Jun 21 23:07:38 1984	strcpbrk.c /*  File   : strcpbrk.ch      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strcpbrk()y  I     strcpbrk(s1, s2) returns a pointer to the first character of s1 which I     does not occur in s2.  It is to strpbrk as strcspn is to strspn.   Itu'     relies on NUL never being in a set.d */   #include "strings.h" #include "_str2set.h"r   char *strcpbrk(str, set)     register _char_ *str;m     char *set;     {i 	_str2set(set);n& 	while (_set_vec[*str++] == _set_ctr); 	return *--str ? str : NullS;      }e  . -h- strcpy.c	Thu Jun 21 23:07:38 1984	strcpy.c /*  File   : strcpy.cr      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strcpy()e  H     strcpy(dst, src) copies all the characters  of  src  (including  theH     closing  NUL)  to dst, and returns the old value of dst.  Maybe thisH     is useful for doing i = strlen(strcpy(dst, src)); I've always  found     strmov handier.s */   #include "strings.h"   char *strcpy(dst, src)     register char *dst, *src;p     {  	char *save;  & 	for (save = dst; *dst++ = *src++; ) ;
 	return save;      }k  0 -h- strcspn.c	Thu Jun 21 23:07:38 1984	strcspn.c /*  File   : strcspn.c      Author : Richard A. O'Keefe.     Updated: 11 April 1984     Defines: strspn()n  H     strcspn(s1, s2) returns the length  of  the  longest  prefix  of  s1H     consisting  entirely  of  characters  which  are  NOT  in s2 ("c" isH     "complement").  NUL is considered to be part  of  s2.   As  _str2setH     will never include NUL in a set, we have to check for it explicitly. */   #include "strings.h" #include "_str2set.h"i   int strcspn(str, set)      register _char_ *str;      char *set;     {  	register int L;   	_str2set(set);h9 	for (L = 0; *str && _set_vec[*str++] != _set_ctr; L++) ; 
 	return L;     }   2 -h- strctrim.c	Thu Jun 21 23:07:38 1984	strctrim.c /*  File   : strctrim.cs      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strctrim()   !     strctrim(dst, src, set, ends)eE     copies src to dst, but will skip leading characters not in set ifsH     ends <= 0 and will skip trailing characters not in set if ends >= 0.     Thus there are three cases:t 	ends < 0 :	trim a prefixa+ 	ends = 0 :	trim a prefix and a suffix both  	ends > 0 :	trim a suffix /     This is to strtrim as strcspn is to strspn.: */   #include "strings.h" #include "_str2set.h"t  # char *strctrim(dst, src, set, ends)l     register char *dst, *src;t     char *set;
     int ends;n     {i 	_str2set(set);e 	if (ends <= 0) {r 	    register int chr;: 	    while ((chr = *src++) && _set_vec[chr] != _set_ctr) ; 	    --src;x 	} 	if (ends >= 0) {h 	    register int chr; 	    register char *save = dst;v 	    while (chr = *src++) {i 		*dst++ = chr;i, 		if (_set_vec[chr] == _set_ctr) save = dst; 	    } 	    dst = save, *dst = NUL;	 	} else {  	    while (*dst++ = *src++) ; 	    --dst;  	} 	return dst;     }r  . -h- strend.c	Thu Jun 21 23:07:38 1984	strend.c /*  File   : strend.ce      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: strend()u  H     strend(s) returns a character pointer to the NUL which ends s.  ThatH     is,  strend(s)-s  ==  strlen(s). This is useful for adding things atH     the end of strings.  It is redundant, because  strchr(s,'\0')  could4     be used instead, but this is clearer and faster.<     Beware: the asm version works only if strlen(s) < 65535. */   #include "strings.h"  
 #if	VaxAsm   char *strend(s)h     char *s;     {T 	asm("locc $0,$65535,*4(ap)"); 	asm("movl r1,r0");t     }    #else  ~VaxAsm n   char *strend(s)'     register char *s;c     {o 	while (*s++); 	return s-1;     }   
 #endif	VaxAsmn  2 -h- strfield.c	Thu Jun 21 23:07:38 1984	strfield.c /*  File   : strfield.ce      Author : Richard A. O'Keefe.     Updated: 21 April 1984     Defines: strfield()e  /     strfield(src, fields, chars, blanks, tabch) ; 	is based on the key specifications of the sort(1) command.f  : 	tabch corresponds to 'x' in -t'x'.  If it is NUL, a field9 	is leading layout (spaces, tabs &c) followed by at leasto8 	one non-layout character, and is terminated by the next7 	layout character or NUL.  If it is not NUL, a field is, 	terminated by tabch or NUL.  = 	fields is the number of fields to skip over.  It corresponds 9 	to m in -m.n or +m.n .  There must be at least this manye4 	fields, and only the last may be terminated by NUL.  ; 	chars is the number of characters to skip after the fieldsn: 	have been skipped.  At least this many non-NUL characters; 	must remain after the fields have been skipped.  Note thato; 	it is entirely possible for this skip to cross one or moreg; 	field boundaries.  This corresponds to n in +m.n or -m.n .r  ; 	Finally, if blanks is not 0, any layout characters will be : 	skipped.  There need not be any.  This corresponds to the 	letter b in +2.0b or -0.4b .n  ; 	The result is NullS if the source ran out of fields or rano6 	out of chars.  Otherwise it is a pointer to the first> 	character of src which was not skipped.  It is quite possible. 	for this character to be the terminating NUL.       Example:- 	to skip to the user-id field of /etc/passwd:m, 	    user_id = strfield(line, 2, 0, 0, ':');  8 	to check whether "line" is at least 27 characters long:1 	    if (strfield(line, 0, 27, 0, 0)) then-it-is;y  5 	to select the third blank-delimited field in a line:n' 	    head = strfield(line, 2, 0, 1, 0);s' 	    tail = strfield(head, 1, 0, 0, 0);iA 	    (* the field is the tail-head characters starting at head *)t  F     It's not a bug, it's a feature: "layout" means any ASCII character: 	in the range '\1' .. ' ', including '\n', '\f' and so on. */   #include "strings.h"  1 char *strfield(src, fields, chars, blanks, tabch)a     register char *src;n%     int fields, chars, blanks, tabch;s     {  	if (tabch <= 0) { 	    while (--fields >= 0) {0 		while (*src <= ' ') if (!*src++) return NullS; 		while (*++src > ' ') ; 	    } 	} else  	if (fields > 0) {  	    do if (!*src) return NullS;- 	    while (*src++ != tabch || --fields > 0);e 	}0 	while (--chars >= 0) if (!*src++) return NullS;, 	if (blanks) while (*src && *src++ <= ' ') ; 	return src;     }n0 -h- strfind.c	Thu Jun 21 23:07:38 1984	strfind.c /*  File   : strfind.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: strfind()  H     strfind(src, pat) looks for an instance of pat in src.  pat is not aK     regex(3) pattern, it is a literal string which must be matched exactly. I     As a special hack to prevent infinite loops, the empty string will beiJ     found just once, at the far end of src.  This is hard to justify.  TheJ     result is a pointer to the first character AFTER the located instance,H     or NullS if pat does not occur in src.  The reason for returning theM     place after the instance is so that you can count the number of instances      by writing 	_str2pat(ToBeFound);.3 	for (p = src, n = 0; p = strfind(p, NullS); n++) ;uJ     If you want a pointer to the first character of the instance, it is up#     to you to subtract strlen(pat).r  K     If there were a strnfind it wouldn't have to look at all the characters F     of src, this version does otherwise it could miss the closing NUL. */   #include "strings.h" #include "_str2pat.h"w   char *strfind(src, pat)i     char *src, *pat;     {t 	register char *s, *p; 	register int c, lastch;   	pat = _str2pat(pat);  	if (_pat_lim < 0) { 	    for (s = src; *s++; ) ; 	    return s-1; 	}! 	/*  The pattern is non-empty  */n9 	for (c = _pat_lim, lastch = pat[c]; ; c = _pat_vec[c]) {s 	    for (s = src; --c >= 0; ) 		if (!*s++) return NullS; 	    c = *s, src = s;t 	    if (c == lastch) {E$ 		for (s -= _pat_lim, p = pat; *p; )% 		    if (*s++ != *p++) goto not_yet;f 		return s;1
 not_yet:;   }  	}     }n  0 -h- strings.h	Thu Jun 21 23:07:38 1984	strings.h /*  File   : strings.h      Author : Richard A. O'Keefe.     Updated: 1 June 19846     Purpose: Header file for the "string(3C)" package.  H     All  the  routines  in  this  package  are  the  original  work   ofH     R.A.O'Keefe.   Any  resemblance  between  them  and  any routines inH     licensed software is due entirely  to  these  routines  having  beenH     written  using the "man 3 string" UNIX manual page, or in some casesH     the "man 1 sort" manual page as a specification.  See the READ-ME toH     find the conditions under which these routines may be used & copied. */  
 #ifndef	NullSt #define	NullS	(char*)0 #define NUL	'\0'  H /*  MAKE SURE THE RIGHT VERSION OF THE FOLLOWING MACRO IS INSTALLED!  */   #if	vax | pdp11 | m68000 | perqc4 #define CharsAreSigned 1			/* default is unsigned */" #endif	vax | pdp11 | m68000 | perq   #if	CharsAreSignedI #define	int2char(i)	(((i)<<((sizeof (int) -1)*8))>>((sizeof (int) -1)*8))o #else  !CharsAreSigned #define	int2char(i)	((i)&255)m #endif	CharsAreSignedo9 /*  If characters are signed, but the above doesn't work,u!     try	((127-(255&~(i)))^(-128))n */   #ifndef	_AlphabetSizeW #define	_AlphabetSize	128  #endif   #if	_AlphabetSize == 128 typedef	char _char_; #endif #if	_AlphabetSize == 256 typedef	unsigned char _char_;e #endif  H /*  NullS is the "nil" character  pointer.   NULL  would  work  in  mostH     cases,  but  in  some  C  compilers  pointers and integers may be ofH     different sizes, so it is handy to have a nil pointer that  one  can;     pass to a function as well as compare pointers against.c  H     NUL is the ASCII name for the character with code 0.  Its use to endH     strings is a convention of the C programming language.  There are inH     fact three different end of string conventions supported by routines     in this package:* 	str<opn>	: end at the first NUL character8 	strn<opn>	: end at the first NUL character, or when the$ 			  extra "len" parameter runs out.? 	mem<opn>,b<opn>	: length determined solely by "len" parameter. H     Unfortunately, the VAX hardware only supports the last convention, aH     pity really.  Fortran 77 users BEWARE: Fortran 77's convention is anH     entirely different one, and there are NO routines in this package asF     yet which support it.  (But see section 3F of the 4.2 BSD manual.)  H     The routines which move characters around don't  care  whether  theyH     are  signed or unsigned.  But the routines which compare a characterH     in a string with an argument, or use a character from a string as an6     index into an array, do care.  I have assumed that5 	_AlphabetSize = 128 => only 0..127 appear in stringsi5 	_AlphabetSize = 256 => only 0..255 appear in stringsgH     The files _str2set.c and _str2map.c declare character vectors  usingH     this  size.  If you don't have unsigned char, your machine may treat     char as unsigned anyway.  I     Some string operations (*cmp, *chr) are explicitly defined in various I     UNIX manuals to use "native" comparison, so I have not used _char_ ind@     them.  This package is meant to be compatible, not rational! */  % extern	char	*strcat(/*char^,char^*/); * extern	char	*strncat(/*char^,char^,int*/);  # extern	int	strcmp(/*char^,char^*/);r( extern	int	strncmp(/*char^,char^,int*/);   #define streql	!strcmp; #define strneql	!strncmp	/* (str-N)-eql not str-(neq-l)! */h  % extern	char	*strcpy(/*char^,char^*/);c* extern	char	*strncpy(/*char^,char^,int*/);   extern	int	strlen(/*char^*/); " extern	int	strnlen(/*char^,int*/);  & extern	char	*strchr(/*char^,_char_*/);' extern	char	*strrchr(/*char^,_char_*/);	 #define	index	strchr #define	rindex	strrchr  % extern	char	*strmov(/*char^,char^*/); * extern	char	*strnmov(/*char^,char^,int*/);  $ extern	void	strrev(/*char^,char^*/);) extern	void	strnrev(/*char^,char^,int*/);t   extern	char	*strend(/*char^*/);b  extern	char	*strnend(/*char^*/);  & extern	char	*strpbrk(/*char^,char^*/);' extern	char	*strcpbrk(/*char^,char^*/);n  # extern	int	strspn(/*char^,char^*/);r$ extern	int	strcspn(/*char^,char^*/);  % extern	char	*strtok(/*char^,char^*/);.% extern	void	istrtok(/*char^,char^*/);   4 extern	char	*strpack(/*_char_^,_char_^,char^,int*/);5 extern	char	*strcpack(/*_char_^,_char_^,char^,int*/);|  ' extern	int	strrpt(/*char^,char^,int*/); , extern	int	strnrpt(/*char^,int,char^,int*/);  : extern	void	strtrans(/*_char_^,_char_^,_char_^,_char_^*/);? extern	void	strntrans(/*_char_^,_char_^,int,_char_^,_char_^*/);i  0 extern	char	*strtrim(/*char^,char^,char^,int*/);1 extern	char	*strctrim(/*char^,char^,char^,int*/);   1 extern	char	*strfield(/*char^,int,int,int,int*/);v1 extern	char	*strkey(/*char^,char^,char^,char^*/);2  & extern	char	*strfind(/*char^,char^*/);2 extern	char	*strrepl(/*char^,char^,char^,char^*/);  ' extern	void	bcopy(/*char^,char^,int*/); ' extern	void	bmove(/*char^,char^,int*/);d  & extern	void	bfill(/*char^,int,char*/);! extern	void	bzero(/*char^,int*/);   % extern	int	bcmp(/*char^,char^,int*/);  #define	beql	!bcmp   extern	int	ffs(/*int*/); extern	int	ffc(/*int*/);  - extern	char	*substr(/*char^,char^,int,int*/);2  " extern	char	*strxcat(/*VARARGS*/);" extern	char	*strxcpy(/*VARARGS*/);" extern	char	*strxmov(/*VARARGS*/);  # extern	char	*strxncat(/*VARARGS*/); # extern	char	*strxncpy(/*VARARGS*/);t# extern	char	*strxnmov(/*VARARGS*/);>   #endif	NullS   #ifndef	memeql #include "memory.h"f
 #endif	memeql   . -h- strkey.c	Thu Jun 21 23:07:38 1984	strkey.c /*  File   : strkey.c8      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strkey()   $     strkey(dst, head, tail, options)> 	copies tail-head characters from head to dst according to the< 	options.  If tail is NullS, it copies up to the terminating> 	NUL of head.  This function is meant for doing comparisons as9 	by sort(1).  The options are thus a string of characters = 	taken from "bdfin".  In case the options came from somewhereo  	else other letters are ignored.  . 	-b: leading layout characters are not copied.  1 	-d: only letters, digits, and blanks are copied. 2 	-i: only graphic characters (32..126) are copied.  	-n: a numeric string is copied.; 	    These options are incompatible, and the last is taken.c  1 	-f: upper case letters are copied as lower case._  H     The question of what to do with a numeric string is  an  interestingH     one,  and  I  don't claim that this is a brilliant answer.  However,H     the solution used here does mean that the  caller  can  compare  twoH     strings as strings without needing to know that they are numeric.  AH     number  is  copied  as  <sign><9  digits>.<remaining  digits>, whereH     <sign> is '-' for a negative number and '0' for a  positive  number.3     The magic number 9 is defined to be DigitMagic.p  8     The idea is that to compare two lines using the keys 	-tx +m1.n1<flags> -m2.n2 
     you do& 	h1 = strfield(line1, m1, n1, 0, 'x');! 	t1 = strfield(h1, 1, 0, 0, 'x');r  	strkey(buff1, h1, t1, "flags");& 	h2 = strfield(line2, m2, n2, 0, 'x');! 	t2 = strfield(h2, 1, 0, 0, 'x');   	strkey(buff2, h2, t2, "flags"); 	... strcmp(buff1, buff2) ...]  G     The point of all this, of course, is to make it easier to write new H     utilities which are compatible with sort(1) than ones which are not. */   #include "strings.h"   #define	DigitMagic 9  $ char *strkey(dst, head, tail, flags)%     register char *dst, *head, *tail;.     char *flags;     {c 	register int c; 	int b = 0;	/* b option? */c 	int f = 0;	/* f option? */s3 	int k = 0;	/* 3->n, 2->d, 1->i, 0->none of them */   & 	while (*flags) switch (*flags++|32) { 	    case 'b':	b++;	break; 	    case 'f':	f++;	break; 	    case 'i':	k = 1;	break; 	    case 'd':	k = 2;	break; 	    case 'n':	k = 3;	break; 	    default : /*ignore*/break;  	}% 	flags = dst;	/* save return value */.  6 	if (tail == NullS) for (tail = head; *tail; tail++) ;  4 	if (b) while (head != tail && *head <= ' ') head++;  
 	switch (k) {r 	    case 0:
 		if (f) { 		    while (head != tail) { 			c = *head++;)% 			if (c >= 'A' && c <= 'Z') c |= 32;_ 			*dst++ = c; 		    } 
 		} else {, 		    while (head != tail) *dst++ = *head++; 		}	 		break; 	    case 1:
 		if (f) { 		    while (head != tail) { 			c = *head++;i 			if (c >= 32 && c <= 126) { ) 			    if (c >= 'A' && c <= 'Z') c |= 32;  			    *dst++ = c; 			} 		    } 
 		} else { 		    while (head != tail) { 			c = *head++;c' 			if (c >= 32 && c <= 126) *dst++ = c;R 		    }  		}f 		break; 	    case 2: 		if (f) f = 32; 		while (head != tail) { 		    c = *head++;G 		    if (c >= '0' && c <= '9' ||  c >= 'a' && c <= 'z' || c == ' ') {   			*dst++ = c; 		    } else! 		    if (c >= 'A' && c <= 'Z') {U 			*dst++ = c|f; 		    }/ 		}i 		break; 	    case 3:% 		if (*head == '-' && head != tail) {r 		    *dst++ = *head++;r
 		    head++;h
 		} else { 		    *dst++ = '0';n 		}i 		b = 0; 		while (head != tail) { 		    c = *head;$ 		    if (c < '0' || c > '9') break; 		    b++, head++; 		}t 		f = DigitMagic-b;s  		while (--f >= 0) *dst++ = '0'; 		head -= b;$ 		while (--b >= 0) *dst++ = *head++;% 		if (*head == '.' && head != tail) {  		    *dst++ = *head++;r 		    while (head != tail) { 			c = *head++;a! 			if (c < '0' || c > '9') break;a 			*dst++ = c; 		    }o? 		    /* now remove trailing 0s and possibly the '.' as well */m 		    while (*--dst == '0') ;t 		    if (*dst != '.') dst++;r 		}  		break; 	} 	*dst = NUL;/ 	return flags;	/* saved initial value of dst */+     }+  . -h- strlen.c	Thu Jun 21 23:07:38 1984	strlen.c /*  File   : strlen.cs      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: strlen()p  H     strlen(s) returns the number of characters in s, that is, the numberH     of non-NUL characters found before the closing NULEosCh.  Note: someH     non-standard C compilers for 32-bit machines take int to be 16 bits,H     either put up with short strings or change int  to  long  throughout=     this package.  Better yet, BOYCOTT such shoddy compilers.i<     Beware: the asm version works only if strlen(s) < 65536. */   #include "strings.h"  
 #if	VaxAsm  
 int strlen(s)_     char *s;     {( 	asm("locc  $0,$65535,*4(ap)");= 	asm("subl3 r0,$65535,r0");;     }    #else  ~VaxAsm  
 int strlen(s):     register char *s;      {: 	register int L; 	h 	for (L = 0; *s++; L++) ; 
 	return L;     }   
 #endif	VaxAsm:  . -h- strmov.c	Thu Jun 21 23:07:38 1984	strmov.c /*  File   : strmov.c,      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strmov()g  H     strmov(dst, src) moves all the  characters  of  src  (including  theH     closing NUL) to dst, and returns a pointer to the new closing NUL inH     dst.   The similar UNIX routine strcpy returns the old value of dst,H     which I have never found useful.  strmov(strmov(dst,a),b) moves a//b!     into dst, which seems useful.  */   #include "strings.h"   char *strmov(dst, src)     register char *dst, *src;0     {  	while (*dst++ = *src++) ; 	return dst-1;     }   0 -h- strncat.c	Thu Jun 21 23:07:38 1984	strncat.c /*  File   : strncat.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strncat()  H     strncat(dst, src, n)  copies up to n characters of src to the end ofH     dst.   As with strcat, it has to search for the end of dst.  Even ifH     it abandons src early because n runs out it  will  still  close  dst"     with a NUL.  See also strnmov. */   #include "strings.h"   char *strncat(dst, src, n)     register char *dst, *src;e     register int n;c     {n 	char *save;   	for (save = dst; *dst++; ) ;r 	for (--dst; --n >= 0; )) 	    if (!(*dst++ = *src++)) return save;  	*dst = NUL;
 	return save;a     }a  0 -h- strncmp.c	Thu Jun 21 23:07:38 1984	strncmp.c /*  File   : strncmp.c      Author : Richard A. O'Keefe.     Updated: 10 April 1984     Defines: strncmp()  @     strncmp(s, t, n) compares the first n characters of s and t.@     If they are the same in the first n characters it returns 0,>     otherwise it returns the same value as strcmp(s, t) would. */   #include "strings.h"   int strncmp(s, t, n)     register char *s, *t;J     register int n;t     {c 	while (--n >= 0) {l' 	    if (*s != *t++) return s[0]-t[-1];  	    if (!*s++) return 0;  	}
 	return 0;      }  0 -h- strncpy.c	Thu Jun 21 23:07:38 1984	strncpy.c /*  File   : strncpy.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strncpy()  H     strncpy(dst, src, n) copies up to n characters of src  to  dst.   ItH     will  pad  dst  on the right with NUL or truncate it as necessary toH     ensure that n characters exactly are transferred.   It  returns  the$     old value of dst as strcpy does. */   #include "strings.h"   char *strncpy(dst, src, n)     register char *dst, *src;d     register int n;m     {e 	char *save;    	for (save = dst;  --n >= 0; ) { 	    if (!(*dst++ = *src++)) {  		while (--n >= 0) *dst++ = NUL; 		return save; 	    } 	}
 	return save;r     }e  0 -h- strnend.c	Thu Jun 21 23:07:38 1984	strnend.c /*  File   : strnend.c      Author : Richard A. O'Keefe.     Updated: 1 June 1984     Defines: strnend()       strnend(src, len)nG     returns a pointer to just after the end of the string src, which isTG     terminated by a NUL character, or by exhaustion of the length boundNG     len.  That is, strnend(s,L)-s = strnlen(s,L).  s+strnlen(s,L) couldt=     of course be used instead, but this is sometimes clearer.p;     Beware: the asm version works only if 0 <= len < 65535.m */   #include "strings.h"  
 #if	VaxAsm   char *strnend(src, len)a     char *src;     int len;     {  	asm("locc $0,8(ap),*4(ap)");t 	asm("movl r1,r0");t     }r   #else  ~VaxAsm i   char *strnend(src, len)      register char *src;e     register int len;l     {f" 	while (--len >= 0 && *src) src++; 	return src;     }s  
 #endif	VaxAsmf  0 -h- strnlen.c	Thu Jun 21 23:07:38 1984	strnlen.c /*  File   : strnlen.c      Author : Richard A. O'Keefe.     Updated: 10 April 1984     Defines: strnlen()       strnlen(src, len).H     returns the number of characters up to the first NUL in src, or len,D     whichever is smaller.  This is the same as strnend(src,len)-src.  ?     Beware: the VaxAsm version only works for 0 <= len < 65535.) */   #include "strings.h"  
 #if	VaxAsm   int strnlen(src, len))     char *src;     int len;     {) 	asm("locc $0,8(ap),*4(ap)");d 	asm("subl3 4(ap),r1,r0");     }    #else  ~VaxAsm   int strnlen(s, n)-     register char *s;i     register int n;(     {) 	register int L; 	b% 	for (L = 0; --n >= 0 && *s++; L++) ; 
 	return L;     }n  
 #endif	VaxAsmh  0 -h- strnmov.c	Thu Jun 21 23:07:38 1984	strnmov.c /*  File   : strnmov.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strnmov()  H     strnmov(dst, src, n) moves up to n characters of  src  to  dst.   ItH     always  moves  exactly n characters to dst; if src is shorter than nH     characters dst will be extended on the right with NULs, while if srcH     is longer than n characters dst will be a truncated version  of  srcH     and  will  not  have  a closing NUL.  The result is a pointer to the7     first NUL in dst, or is dst+n if dst was truncated.i */   #include "strings.h"   char *strnmov(dst, src, n)     register char *dst, *src;      register int n;a     {o 	while (--n >= 0) {, 	    if (!(*dst++ = *src++)) { 		src = dst-1;  		while (--n >= 0) *dst++ = NUL;
 		return src;n 	    } 	} 	return dst;     }u  0 -h- strnrev.c	Thu Jun 21 23:07:38 1984	strnrev.c /*  File   : strnrev.c      Author : Richard A. O'Keefe.     Updated: 1 June 1984     Defines: strnrev()       strnrev(dst, src, len)F     copies all the characters of src to dst, in REVERSE order.  If srcF     was terminated by a NUL character, so will dst be, otherwise dst &F     src are both exactly len non-NUL characters long.  This returns no5     result.  It is to strrev as strncpy is to strcpy.t  G     Note: this function is perfectly happy to reverse a string into ther+     same place, strnrev(x, x, L) will work.uF     It will not work for partially overlapping source and destination. */   #include "strings.h"   void strnrev(dsta, srca, len)      register char *dsta, *srca;      register int len;	     {  	register char *dstz, *srcz; 	register int t;< 	/*  On a machine which doesn't supply 6 register variables,A 	    you could #define t len, as the two variables don't overlap.  	*/   1 	for (srcz = srca; --len >= 0 && *srcz; srcz++) ;  	dstz = dsta+(srcz-srca);yA 	/*  If srcz was stopped by len running out, it points just afterfA 	    the last character of the source string, and it and dstz areeB 	    just right.  Otherwise, it was stopped by hitting NUL, and is; 	    in the right place, but dstz should get a NUL as well.D 	*/o 	if (len >= 0) *dstz = NUL;e* 	/*  That was the very last use of len  */ 	while (srcz > srca) { 	    t = *--srcz;* 	    *--dstz = *srca++;* 	    *dsta++ = t;H 	}     }F  0 -h- strnrpt.c	Thu Jun 21 23:07:38 1984	strnrpt.c /*  File   : strnrpt.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strnrpt()  H     strnrpt(dst, n, src, k) "RePeaTs" the string src into dst  k  times,H     but  will  truncate  the  result at n characters if necessary.  E.g.H     strnrpt(dst, 7, "hack ", 2) will move "hack ha" to dst  WITHOUT  theH     closing  NUL.   The  result  is  the number of characters moved, notH     counting the closing NUL.  Equivalent to strrpt-ing into an infinite+     buffer and then strnmov-ing the result.z */   #include "strings.h"   int strnrpt(dst, n, src, k)l     register char *dst;      register int n;d     char *src;
     int k;     {i 	char *save;  $ 	for (save = dst; --k >= 0; dst--) { 	    register char *p; 	    for (p = src; ; ) { 		if (--n < 0) return dst-save;s 		if (!(*dst++ = *p++)) break; 	    } 	} 	return dst-save;      }A  4 -h- strntrans.c	Thu Jun 21 23:07:38 1984	strntrans.c /*  File   : strntrans.c      Author : Richard A. O'Keefe.     Updated: 2 June 1984     Defines: strntrans()  &     strntrans(dst, src, len, from, to)F     Moves characters from src to dst, translating characters in from[]H     to the corresponding characters in to[], until either len charactersJ     have been moved or a NUL has been moved.  If fewer than len charactersG     are moved, the remainder of dst will be filled with NULs, much likea.     strncpy and family.  No value is returned.  H     Apology: in the previous distribution of this package, strntrans wasJ     defined the way memtrans is now defined.  This is more consistent with#     the general naming conventions.n */   #include "strings.h" #include "_str2map.h"r  
 #if	VaxAsm  ' void strntrans(dst, src, len, from, to)i"     _char_ *dst, *src, *from, *to;     int len;     {  	_str2map(0, from, to); 8 	asm("movtuc 20(ap),*8(ap),$0,__map_vec,20(ap),*4(ap)");6 	/* now pad the destination out with NUL characters */# 	asm("movc5 $0,*8(ap),$0,r4,(r5)");n     }5   #else  ~VaxAsm  ' void strntrans(dst, src, len, from, to)      register _char_ *dst, *src;      register int len;      _char_ *from, *to;     {m 	_str2map(0, from, to);r4 	while (--len >= 0 && (*dst++ = _map_vec[*src++])) ;! 	while (--len >= 0) *dst++ = NUL;      }   
 #endif	VaxAsms  0 -h- strpack.c	Thu Jun 21 23:07:38 1984	strpack.c /*  File   : strpack.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strpack()       strpack(dst, src, set, c)cH     copies characters from src to dst, stopping when it finds a NUL.  IfH     c is NUL, characters in set are not copied to dst.  If c is not NUL,>     sequences of characters from set are copied as a single c.B     strpack(d, s, " \t", ' ') can be used to compress white space,H     strpack(d, s, " \t", NUL) to eliminate it.  To translate  charactersH     in  set to c without compressing runs, see strtrans(). The result isH     the address of the NUL byte now terminating dst.  Note that dst  may     safely be the same as src. */   #include "strings.h" #include "_str2set.h"c   char *strpack(dst, src, set, c)(     register _char_ *dst, *src;c     char *set;     register int c;	     {d 	register int chr;   	_str2set(set);c 	while (chr = *src++) {a% 	    if (_set_vec[chr] == _set_ctr) {n7 		while ((chr = *src++) && _set_vec[chr] == _set_ctr) ;^8 		if (c) *dst++ = c;	/* 1. If you don't want trailing */8 		if (!chr) break;	/* 2. things turned into "c", swap */ 	    }				/* lines 1 and 2. */ 	    *dst++ = chr; 	}
 	*dst = 0; 	return dst;     }   0 -h- strpbrk.c	Thu Jun 21 23:07:38 1984	strpbrk.c /*  File   : strpbrk.c      Author : Richard A. O'Keefe.     Updated: 11 April 1984     Defines: strpbrk()  H     strpbrk(s1, s2) returns NullS if no character of s2 occurs in s1, orH     a pointer to the first character of s1 which occurs in s2  if  thereH     is one.  It generalises strchr (v7=index).  It wouldn't be useful to@     consider NUL as part of s2, as that would occur in every s1. */   #include "strings.h" #include "_str2set.h"^   char *strpbrk(str, set)v     register _char_ *str;*     char *set;     {( 	_str2set(set);*# 	while (_set_vec[*str] != _set_ctr), 	    if (!*str++) return NullS;r 	return str;     }i  0 -h- strpref.c	Thu Jun 21 23:07:38 1984	strpref.c /*  File   : strpref.c      Author : Richard A. O'Keefe.     Updated: 11 April 1984     Defines: strpref()       strpref(src, prefix)H     checks whether prefix is a prefix of src.  If it is not, the  resultH     is  NullS.  If it is, the result is a pointer to the first characterH     of src after the prefix (src+strlen(prefix)).  You can use this in aH     conditional as a test: if (strpref(....)), but this is only portableH     provided you remember to declare strpref() properly or use strings.hG     as if (...) tests numbers against 0 and pointers against a suitableeH     cast of 0; there is no guarantee that (char*)0 is represented by the     same bit pattern as (int)0.u */   #include "strings.h"   char *strpref(src, prefix)      register char *src, *prefix;     {s7 	while (*prefix) if (*src++ != *prefix++) return NullS;r 	return src;     }n  0 -h- strrchr.c	Thu Jun 21 23:07:38 1984	strrchr.c /*  File   : strrchr.c      Author : Richard A. O'Keefe.     Updated: 10 April 1984      Defines: strrchr(), rindex()  H     strrchr(s, c) returns a pointer to the  last  place  in  s  where  cH     occurs,  or  NullS if c does not occur in s. This function is calledH     rindex in V7 and 4.?bsd systems; while not ideal the name is clearerH     than strrchr, so rindex  remains  in  strings.h  as  a  macro.   NB:H     strrchr  looks  for single characters, not for sets or strings.  TheH     parameter 'c' is declared 'int' so it will go in a register; if your=     C compiler is happy with register char change it to that.A */   #include "strings.h"   char *strrchr(s, c)m     register _char_ *s;      register int c;      {e 	register char *t;   	t = NullS;m% 	do if (*s == c) t = s; while (*s++); 
 	return t;     }   0 -h- strrepl.c	Thu Jun 21 23:07:38 1984	strrepl.c /*  File   : strrepl.c      Author : Richard A. O'Keefe.     Updated: 23 April 1984     Defines: strrepl()  H     strrepl(dst, src, pat, rep, times) copies src to dst, replacing  theH     first "times" non-overlapping instances of pat by rep.  pat is not aH     regex(3) pattern, it is a  literal  string  which  must  be  matchedH     exactly.   As  a  special hack, since strfind claims to find "" justH     once at the end of the src string, strrepl does a strcat when pat is:     an empty string "".  If times <= 0, it is just strmov.  @     The result is a pointer to the NUL which now terminates dst.  H     BEWARE: even when rep is shorter than pat it is NOT necessarily safeH     for dst to be the same as src.  ALWAYS make sure dst and src do not/,     will not overlap.  You have been warned.  H     There really ought to be a strnrepl with a bound for the size of the(     destination string, but there isn't. */   #include "strings.h" #include "_str2pat.h"d  ( char *strrepl(dst, src, pat, rep, times)      char *dst, *src, *pat, *rep;     int times;     {l 	register char *s, *p; 	register int c, lastch;   	pat = _str2pat(pat);	 	if (times <= 0) {, 	    for (p = dst, s = src; *p++ = *s++; ) ; 	    return p-1; 	} 	if (_pat_lim < 0) {, 	    for (p = dst, s = src; *p++ = *s++; ) ;( 	    for (--p, s = rep; *p++ = *s++; ) ; 	    return p-1;  	}{7 	/*  The pattern is non-empty and times is positive  */c 	c = _pat_lim, lastch = pat[c];  	for (;;) {c' 	    for (s = src, p = dst; --c >= 0; )	! 		if (!(*p++ = *s++)) return p-1;l 	    c = *s, src = s, dst = p; 	    if (c == lastch) { $ 		for (s -= _pat_lim, p = pat; *p; )% 		    if (*s++ != *p++) goto not_yet;;2 		for (p = dst-_pat_lim, s = rep; *p++ = *s++; ) ; 		--p; 		if (--times == 0) {c$ 		    for (s = src; *p++ = *++s; ) ; 		    return p-1;  		}l 		dst = p, src++, c = _pat_lim;'
 	    } else {  not_yet:	c = _pat_vec[c];r 	    } 	}     } . -h- strrev.c	Thu Jun 21 23:07:38 1984	strrev.c /*  File   : strrev.c       Author : Richard A. O'Keefe.     Updated: 1 June 1984     Defines: strrev(){       strrev(dst, src)G     copies all the characters of src to dst, in REVERSE order.   Dst isgB     properly terminated with a NUL character.  There is no result.C     Example: strrev(x, "able was I er") moves "re I saw elba" to x.   G     Note: this function is perfectly happy to reverse a string into the G     same place, strrev(x, x) will work.  That is why it looks so hairy.vF     It will not work for partially overlapping source and destination. */   #include "strings.h"   void strrev(dsta, srca)      register char *dsta, *srca;/     {  	register char *dstz, *srcz;' 	register int t;			/* should be char */8   	for (srcz = srca; *srcz++; ) ;  	srcz--; 	dstz = dsta+(srcz-srca); 0 	/*  Now srcz points to the NUL terminating src,B 	    and dstz points to where the terminating NUL for dst belongs. 	*/ 
 	*dstz = NUL;c 	while (srcz > srca) {< 	    /*  This is guaranteed safe by K&R, since srcz and srca 		point "into the same array". 	    */t 	    t = *--srcz;u 	    *--dstz = *srca++;h 	    *dsta++ = t;  	}     }   . -h- strrpt.c	Thu Jun 21 23:07:38 1984	strrpt.c /*  File   : strrpt.ce      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strrpt()	  H     strrpt(dst, src, k) "RePeaTs" the string src into dst k times.  E.g.G     strrpt(dst, "hack ", 2) will move "hack hack" to dst.  If k <= 0 itnG     does nothing.  The result is the number of characters moved, except*G     for the closing NUL.  src may be "" but may not of course be NullS.n */   #include "strings.h"   int strrpt(dst, src, k)      register char *dst;f     char *src;
     int k;     {  	char *save;  $ 	for (save = dst; --k >= 0; --dst) { 	    register char *p;% 	    for (p = src; *dst++ = *p++; ) ;s 	} 	return dst-save;r     }   . -h- strspn.c	Thu Jun 21 23:07:38 1984	strspn.c /*  File   : strspn.ce      Author : Richard A. O'Keefe.     Updated: 11 April 1984     Defines: strspn()e  H     strspn(s1, s2) returns the  length  of  the  longest  prefix  of  s1H     consisting  entirely  of characters in s2.  NUL is not considered to:     be in s2, and _str2set will not include it in the set. */   #include "strings.h" #include "_str2set.h"t   int strspn(str, set)     register _char_ *str;2     char *set;     {e 	register int L;   	_str2set(set); 1 	for (L = 0; _set_vec[*str++] == _set_ctr; L++) ; 
 	return L;     }s  0 -h- strsuff.c	Thu Jun 21 23:07:38 1984	strsuff.c /*  File   : strsuff.c      Author : Richard A. O'Keefe.     Updated: 11 April 1984     Defines: strsuff()       strsuff(src, suffix)H     checks whether suffix is a suffix of src.  If it is not, the  resultH     is NullS.  If it is, the result is a pointer to the character of srcO     where suffix starts (which is the same as src+strlen(src)-strlen(prefix) ).tC     See strpref.c for a comment about using if (strsuff(...)) in C.c */   #include "strings.h"   char *strsuff(src, suffix)      register char *src, *suffix;     {:' 	register int L;	/* length of suffix */e   	for (L = 0; *suffix++; L++) 	    if (!*src++) return NullS;  	while (*src++) ;e" 	for (--src, --suffix; --L >= 0; )+ 	    if (*--src != *--suffix) return NullS;  	return src;     }g  . -h- strtok.c	Thu Jun 21 23:07:38 1984	strtok.c /*  File   : strtok.ct      Author : Richard A. O'Keefe.     Updated: 11 April 1984      Defines: istrtok(), strtok()       strtok(src, set)= 	skips over initial characters of src[] which occur in set[].*8 	The result is a pointer to the first character of src[]= 	which does not occur in set[].  It then skips until it finds(> 	a character which does occur in set[], and changes it to NUL.9 	If src is NullS, it is as if you had specified the placee; 	just after the last NUL was written.  If src[] contains nor: 	characters which are not in set[] (e.g. if src == "") the 	result is NullS.t  @ 	To read a sequence of words separated by spaces you might write 	p = strtok(sequence, " "); 5 	while (p) {process_word(p); p = strtok(NullS, " ");} 0 	This is unpleasant, so there is also a function       istrtok(src, set)v< 	which builds the set and notes the source string for future. 	reference.  With this function, you can write  ; 	for (istrtok(wordlist, " \t"); p = strtok(NullS, NullS); )4 	    process_word(p);) */   #include "strings.h" #include "_str2set.h"o   static	char	*oldSrc = "";r   void istrtok(src, set)     char *src, *set;     {o 	_str2set(set);f  	if (src != NullS) oldSrc = src;     }r     char *strtok(src, set)     register char *src;      char *set;     {t 	char *save;   	_str2set(set);r  	if (src == NullS) src = oldSrc;* 	while (_set_vec[*src] == _set_ctr) src++; 	if (!*src) return NullS;m 	save = src;' 	while (_set_vec[*++src] != _set_ctr) ;e 	*src++ = NUL; 	oldSrc = src;
 	return save;m     }r  2 -h- strtrans.c	Thu Jun 21 23:07:38 1984	strtrans.c /*  File   : strtrans.cc      Author : Richard A. O'Keefe.     Updated: 2 June 1984     Defines: strtrans()r        strtrans(dst, src, from, to)H     copies characters from src[] to dst[], stopping when dst gets a  NULH     character,  translating  characters  in  from[] to the correspondingH     characters in to[]. Courtesy of _str2map, if from or to is null  itsH     previous  value  will be used, and if both are NullS the table won'tH     be rebuilt.  Note that copying stops when a NUL is put  into  dst[],H     which  can  normally  happen  only  when a NUL has been fetched fromH     src[], but if you have built your own translation table  it  may  beH     earlier  (if  some  character  is mapped to NUL) or later (if NUL is5     mapped to something else).  No value is returned.r  :     The VaxAsm version only works from strlen(src) < 2^16. */   #include "strings.h" #include "_str2map.h"s  
 #if	VaxAsm  ! void strtrans(dst, src, from, to)v"     _char_ *dst, *src, *from, *to;     {c 	_str2map(0, from, to);a8 	asm("movtuc $65535,*8(ap),$0,__map_vec,$65535,*4(ap)");E 	/*  That stops when the "escape" is found, and we want to move it */s 	asm("movb $0,(r5)");a     }o   #else  ~VaxAsm  ! void strtrans(dst, src, from, to)      register _char_ *dst, *src;s     _char_ *from, *to;     {h 	_str2map(0, from, to);b$ 	while (*dst++ = _map_vec[*src++]) ;     }   
 #endif	VaxAsms  0 -h- strtrim.c	Thu Jun 21 23:07:38 1984	strtrim.c /*  File   : strtrim.c      Author : Richard A. O'Keefe.     Updated: 20 April 1984     Defines: strtrim()        strtrim(dst, src, set, ends)H     copies src to dst, but will skip leading characters in set if "ends"F     is <= 0, and will skip trailing characters in set if ends is >= 0.     Thus there are three cases:h 	ends < 0 :	trim a prefix7+ 	ends = 0 :	trim a prefix and a suffix both  	ends > 0 :	trim a suffixfF     To compress internal runs, see strpack.  The normal use of this isH     strtrim(buffer, buffer, " \t", 0);  The result is the address of the!     NUL which now terminates dst.U */   #include "strings.h" #include "_str2set.h"r  " char *strtrim(dst, src, set, ends)     register char *dst, *src;      char *set;
     int ends;n     {t 	_str2set(set);  	if (ends <= 0) { . 	    while (_set_vec[*src] == _set_ctr) src++; 	} 	if (ends >= 0) {e 	    register int chr; 	    register char *save = dst;y 	    while (chr = *src++) {n 		*dst++ = chr;c, 		if (_set_vec[chr] != _set_ctr) save = dst; 	    } 	    dst = save, *dst = NUL;	 	} else {t 	    while (*dst++ = *src++) ; 	    --dst;s 	} 	return dst;     }/  0 -h- strxcat.c	Thu Jun 21 23:07:38 1984	strxcat.c /*  File   : strxcat.c      Author : Richard A. O'Keefe.     Updated: 25 may 1984     Defines: strxcat()  (     strxcat(dst, src1, ..., srcn, NullS)F     moves the concatenation of dst,src1,...,srcn to dst, terminates it@     with a NUL character, and returns the original value of dst.H     It is just like strcat except that it concatenates multiple sources.H     Equivalence: strxcat(d, s1, ..., sn) <=> strxcpy(d, d, s1, ..., sn).C     Beware: the last argument should be the null character pointer./F     Take VERY great care not to omit it!  Also be careful to use NullSE     and NOT to use 0, as on some machines 0 is not the same size as a4<     character pointer, or not the same bit pattern as NullS. */   #include "strings.h" #include <varargs.h>   /*VARARGS*/  char *strxcat(va_alist)R
     va_dcl     {s 	va_list pvar; 	register char *dst, *src;
 	char *bogus;t   	va_start(pvar); 	dst = va_arg(pvar, char *);
 	bogus = dst;, 	while (*dst) dst++; 	src = va_arg(pvar, char *); 	while (src != NullS) {  	    while (*dst++ = *src++) ; 	    dst--;   	    src = va_arg(pvar, char *); 	} 	return bogus;     }n  0 -h- strxcpy.c	Thu Jun 21 23:07:38 1984	strxcpy.c /*  File   : strxcpy.c      Author : Richard A. O'Keefe.     Updated: 25 may 1984     Defines: strxcpy()  (     strxcpy(dst, src1, ..., srcn, NullS)B     moves the concatenation of src1,...,srcn to dst, terminates it@     with a NUL character, and returns the original value of dst.H     It is just like strcpy except that it concatenates multiple sources.C     Beware: the last argument should be the null character pointer.tF     Take VERY great care not to omit it!  Also be careful to use NullSE     and NOT to use 0, as on some machines 0 is not the same size as ae<     character pointer, or not the same bit pattern as NullS. */   #include "strings.h" #include <varargs.h>   /*VARARGS*/h char *strxcpy(va_alist)o
     va_dcl     {e 	va_list pvar; 	register char *dst, *src;
 	char *bogus;r   	va_start(pvar); 	dst = va_arg(pvar, char *);
 	bogus = dst;  	src = va_arg(pvar, char *); 	while (src != NullS) {h 	    while (*dst++ = *src++) ; 	    dst--;t  	    src = va_arg(pvar, char *); 	}4 	*dst = NUL;	/* there might have been no sources! */ 	return bogus;     }t  0 -h- strxmov.c	Thu Jun 21 23:07:38 1984	strxmov.c /*  File   : strxmov.c      Author : Richard A. O'Keefe.     Updated: 25 may 1984     Defines: strxmov()  (     strxmov(dst, src1, ..., srcn, NullS)B     moves the concatenation of src1,...,srcn to dst, terminates itG     with a NUL character, and returns a pointer to the terminating NUL.rH     It is just like strmov except that it concatenates multiple sources.C     Beware: the last argument should be the null character pointer.aF     Take VERY great care not to omit it!  Also be careful to use NullSE     and NOT to use 0, as on some machines 0 is not the same size as a <     character pointer, or not the same bit pattern as NullS. */   #include "strings.h" #include <varargs.h>   /*VARARGS*/f char *strxmov(va_alist) 
     va_dcl     {s 	va_list pvar; 	register char *dst, *src;   	va_start(pvar); 	dst = va_arg(pvar, char *); 	src = va_arg(pvar, char *); 	while (src != NullS) {  	    while (*dst++ = *src++) ; 	    dst--;   	    src = va_arg(pvar, char *); 	}4 	*dst = NUL;	/* there might have been no sources! */ 	return dst;     }   2 -h- strxncat.c	Thu Jun 21 23:07:38 1984	strxncat.c /*  File   : strxncat.cr      Author : Richard A. O'Keefe.     Updated: 2 June 1984     Defines: strxncat()   .     strxncat(dst, len, src1, ..., srcn, NullS)G     moves the first len bytes of the concatenation of dst,src1,...,srcngH     to dst, terminating it with a NUL character unless len runs out, and&     returns the original value of dst.H     It is just like strcat except that it concatenates multiple sources.L     Roughly, strxncat(d, L, s1, ..., sn) <=> strxncpy(d, L, d, s1, ..., sn).C     Beware: the last argument should be the null character pointer..F     Take VERY great care not to omit it!  Also be careful to use NullSE     and NOT to use 0, as on some machines 0 is not the same size as a}<     character pointer, or not the same bit pattern as NullS.  G     Note: strxncat is like strncat in that it will add at most one NUL,'E     and may in consequence move fewer than len characters.  No so therG     strxncpy and strxnmov routines, which resemble strncpy and strnmov.n */   #include "strings.h" #include <varargs.h>   /*VARARGS*/  char *strxncat(va_alist)
     va_dcl     {  	va_list pvar; 	register char *dst, *src; 	register int len;
 	char *bogus;n   	va_start(pvar); 	dst = va_arg(pvar, char *);
 	bogus = dst;  	len = va_arg(pvar, int); 
 	while (*dst)r! 	    if (--len < 0) return bogus;_ 	    else dst++; 	src = va_arg(pvar, char *); 	while (src != NullS) {e$ 	    do if (--len < 0) return bogus; 	    while (*dst++ = *src++);3 	    dst--;f  	    src = va_arg(pvar, char *); 	} 	return bogus;     }   2 -h- strxncpy.c	Thu Jun 21 23:07:38 1984	strxncpy.c /*  File   : strxncpy.c       Author : Richard A. O'Keefe.     Updated: 25 may 1984     Defines: strxncpy()l  .     strxncpy(dst, len, src1, ..., srcn, NullS)H     moves the first len characters of the concatenation of src1,...,srcnG     to dst.  If there aren't that many characters, a NUL character willlH     be added to the end of dst to terminate it properly.  This gives theG     same effect as calling strxcpy(buff, src1, ..., srcn, NullS) with aaB     large enough buffer, and then calling strncpy(dst, buff, len).I     It is just like strncpy except that it concatenates multiple sources..C     Beware: the last argument should be the null character pointer. F     Take VERY great care not to omit it!  Also be careful to use NullSE     and NOT to use 0, as on some machines 0 is not the same size as ai<     character pointer, or not the same bit pattern as NullS.  F     Note: strxncpy is like strncpy in that it always moves EXACTLY lenF     characters; dst will be padded on the right with NUL characters asG     needed.  strxnmov does the same.  strxncat, like strncat, does NOT.a */   #include "strings.h" #include <varargs.h>   /*VARARGS*/s char *strxncpy(va_alist)
     va_dcl     {  	va_list pvar; 	register char *dst, *src; 	register int len;
 	char *bogus;r   	va_start(pvar); 	dst = va_arg(pvar, char *);
 	bogus = dst;a 	len = va_arg(pvar, int);o 	src = va_arg(pvar, char *); 	while (src != NullS) { $ 	    do if (--len < 0) return bogus; 	    while (*dst++ = *src++);r 	    dst--;e  	    src = va_arg(pvar, char *); 	}, 	for (src = dst; --len >= 0; *dst++ = NUL) ; 	return bogus;     }   2 -h- strxnmov.c	Thu Jun 21 23:07:38 1984	strxnmov.c /*  File   : strxnmov.cr      Author : Richard A. O'Keefe.     Updated: 2 June 1984     Defines: strxnmov()r  .     strxnmov(dst, len, src1, ..., srcn, NullS)H     moves the first len characters of the concatenation of src1,...,srcnG     to dst.  If there aren't that many characters, a NUL character will H     be added to the end of dst to terminate it properly.  This gives theG     same effect as calling strxcpy(buff, src1, ..., srcn, NullS) with asB     large enough buffer, and then calling strnmov(dst, buff, len).I     It is just like strnmov except that it concatenates multiple sources.wC     Beware: the last argument should be the null character pointer.iF     Take VERY great care not to omit it!  Also be careful to use NullSE     and NOT to use 0, as on some machines 0 is not the same size as a <     character pointer, or not the same bit pattern as NullS.  F     Note: strxnmov is like strnmov in that it always moves EXACTLY lenF     characters; dst will be padded on the right with NUL characters asG     needed.  strxncpy does the same.  strxncat, like strncat, does NOT.  */   #include "strings.h" #include <varargs.h>   /*VARARGS*/  char *strxnmov(va_alist)
     va_dcl     {c 	va_list pvar; 	register char *dst, *src; 	register int len;   	va_start(pvar); 	dst = va_arg(pvar, char *); 	len = va_arg(pvar, int);* 	src = va_arg(pvar, char *); 	while (src != NullS) {o" 	    do if (--len < 0) return dst; 	    while (*dst++ = *src++);  	    dst--;c  	    src = va_arg(pvar, char *); 	}, 	for (src = dst; --len >= 0; *dst++ = NUL) ; 	return src;     }   . -h- substr.c	Thu Jun 21 23:07:38 1984	substr.c /*  File   : substr.c       Author : Richard A. O'Keefe.     Updated: 25 May 1984     Defines: substr())  /     substr(destination, source, offset, length)sC     copies length bytes from source+offset to destination, stopping C     early if a NUL is encountered.  The difference between this and /     strncpy(destination, source+offset, length)vC     is that if the offset is negative, it has the same effect as 0,a?     and if it exceeds strlen(source), it has the same effect as @     strlen(source).  If either of these boundaries is hit, or ifA     a NUL is encountered before length bytes have been moved, therD     value of errno will be EDOM, otherwise it is guaranteed to be 0.     That is:. 	errno == 0 <=> (0 <= offset <= strlen(source). 			&& 0 <= length && <= strlen(source)-offset)C     You may accept the sensible result produced when these boundaryfD     conditions are violated, or you may treat it as an error, as youC     will.  There is an algebra of sequences in which this treatment '     of boundary conditions makes sense.g  E     After the substring of source is moved to destination, a NUL byte D     is moved to terminate the string, and the result is a pointer to<     this NUL byte, ready to have new stuff stuck on the end.  A     I suppose this should be called strsub, but I can't stick it.  */   #include "strings.h" #include <errno.h>  5 extern	int	errno;			/* why isn't this in errno.h?? */       char *substr(dst, src, off, len)     register char *dst, *src;      register int off, len;     {0' 	errno = off < 0 || len < 0 ? EDOM : 0;e   	while (--off >= 0)A, 	    if (!*src++) {		/* We've hit the end */0 		errno = EDOM;		/* report boundary violation */( 		*dst = NUL;		/* return empty string */
 		return dst;t 	    } 	while (--len >= 0) 6 	    if (!(*dst++ = *src++)) {	/* We've hit the end */ 		errno = EDOM; 0 		return dst-1;		/* dst is already terminated */ 	    }+ 	*dst = NUL;			/* terminate dst with NUL */  	return dst;     }g  2 -h- xstring.3c	Thu Jun 21 23:07:38 1984	xstring.3c .TH XSTRING 3C local .SH NAMEn strxcat, strxncat, strxcpy, strxncpy, strxmov, strxnmov \- string operations with variable number of arguments .SH SYNOPSIS .nf  .PPr .B "#include <strings.h>"  .PPn2 .B "char \(**strxcat(dst, src1, src2, ..., NullS)"/ .B "    char \(**dst, \(**src1, \(**src2, ...;"p .PP:8 .B "char \(**strxncat(dst, len, src1, src2, ..., NullS)"/ .B "    char \(**dst, \(**src1, \(**src2, ...;"  .B "    int len;"i .PPn2 .B "char \(**strxcpy(dst, src1, src2, ..., NullS)"/ .B "    char \(**dst, \(**src1, \(**src2, ...;"t .PPh8 .B "char \(**strxncpy(dst, len, src1, src2, ..., NullS)"/ .B "    char \(**dst, \(**src1, \(**src2, ...;"r .B "    int len;"  .PPe2 .B "char \(**strxmov(dst, src1, src2, ..., NullS)"/ .B "    char \(**dst, \(**src1, \(**src2, ...;"; .PP 8 .B "char \(**strxnmov(dst, len, src1, src2, ..., NullS)"/ .B "    char \(**dst, \(**src1, \(**src2, ...;"e .B "    int len;"1 .SH DESCRIPTION 3 These functions operate on null-terminated strings.h2 They are equivalent to the corresponding functions .IR strcat (3c), .IR strncat (3c),i .IR strmov (3c), .IR strnmov (3c),r .IR strcpy (3c), and  .IR strncpy (3c),hB except that they allow more than one source string to be supplied.
 .IR Strxcat ,  .IR strxncat ,
 .IR strxcpy ,n and  .I strxncpye6 return their first argument (the destination pointer).
 .I Strxmov andi .I strxnmovr9 return a pointer to just after the last non-NUL characterf; moved to the destination.  This is the same convention that ' is used throughout the strings package. ) Except as implied by the length parameter 	 .IR len ,;7 they do not check for overflow of any receiving string.c .PP 
 .I Strxcat appends a copy of the strings 
 .IR src1 ,
 .IR src2 ,
 and so on, to 	 .IR dst .i3 The resulting string will always be NUL-terminated.e .I Strxncatr copies at most .I len characters.*9 The resulting string will be NUL-terminated if fewer than  .I len1 characters were moved.  At most one NUL is added.d .PPa
 .I Strxcpy copies the strings
 .IR src1 ,
 .IR src2 , and so on, intoN	 .IR dst .  .I Strxncpy  copies at most .I len characters. 3 The resulting string will not be null-terminated ift .I len. or more characters were in the source strings. By analogy with 
 .IR strncpy ,e .I dst: will be padded on the right with NUL characters to exactly .I len bytes. .PP) Apart from their return value,
 .I strxmov andi .I strxnmovn have the same effect asc
 .I strxcpy ando .IR strxncpy . .SH CAVEATSh The placement for ther .I len9 variable is different from the placement in the functionse .IR strncat (3c),o .IR strncpy (3c),  andk .IR strnmov (3c). 