 /*  *				t r a n s l . c   */   
 /*)LIBRARY */   #ifdef	DOCUMENTATION  / title	translate	Character Translation Functions   index			Do character translation) index			Clear character translation table ' index			Set character translation table    synopsis   	 clrttab(t,max) 	 char t[]; 
 	 int max;   	 setttab(t,from,to) 	 char t[]; 
 	 char *from;  	 char *to;    	 translate(t,s) 	 char t[]; 
 	 char *s;   description   G 	These functions provide a character translation facility.  translate() D 	does the actual translation; clrttab() and setttab() set up a table 	for use with translate().  E 	A translation table t[] is simple a byte array; translate() will map B 	character c into t[c].  However, if t[c] is 0, it does not appearB 	in the output - i.e., translating a character to null deletes it.B 	t can be from 1 to 256 bytes in length.  Only clrttab(), however,C 	accepts the length of t as an argument; the other functions assume D 	that any character they try to translate can be safely looked up inB 	t.  Usually, t is 128 bytes long and only legal ASCII characters,> 	without parity, are passed, or 256 to support extended ASCII.  E 	clrttab(t,max) clears a table to the null translation - i.e., t will G 	translate every character into itself.  t is assumed to be max+1 bytes F 	long (so that it can translate characters with values from 0 to max).  D 	setttab(t,from,to) modifies t so that characters in from are mappedE 	into corresponding characters in to.  If from is longer than to, any F 	"excess" characters will map to 0, i.e., be deleted.  Thus, the calls   		clrttab(t,127); ! 		setttab(t,"abcdewxyz","ABCDE");   = 	create a table that maps a,b,c,d and e into their upper-case % 	equivalents and deletes w,x,y and z.   A 	Note:  It is meaningless to set up a translation for the 0 byte;  	t[0] is never used.  ? 	translate(t,s) translates string s using table t.  s itself is D 	modified.  s will be properly null-trailed, but may be shorter than9 	it was as passed (if any of its characters are deleted).   < 	See also replace() for a simple way to use these functions.   bugs   author   	Jerry Leichter    #endif   /*  *)EDITLEVEL=02   * Edit history   * 0.0 30-Jun-81 JSL	Invention  */    #define EOS '\0'   clrttab(t,max) register char t[]; register int max;  {	register int i;    	for (i = 0; i <= max; i++)  		t[i] = i;  }    setttab(t,from,to) register char t[]; register char *from; register char *to; {  	while (*from) 	{	t[*from++] = *to;
 		if (*to) 			to++; 	} }    translate(t,s) register char t[]; register char *s; 5 {	register char *r;		/* Where translated char goes */    	r = s;  	while (*s) 5 		if (*r = t[*s++])	/* Non-null - real translation */  			r++; 
 	*r = EOS; } 