 /*$  * Taken from a curses distribution.  */  /*  * _tracef(format, args)  *?  * Writes tracing information to file "trace.out" if tracing is <  * enabled.  Formatting follows printf conventions with some  * minor differences:   *	%b		unsigned binary integer  *	%c		character, output as 'x'   *	%d		signed decimal integer   *	%o		unsigned octal integer 2  *	%s		string (terminated by EOS), output as "xxx"8  *	%*s		counted string (takes two args), output as "xxx"  *	%x		unsigned hex integer >  * Field and width parameters (as in printf) aren't permitted.  * traceon()		turns on tracing   * traceoff()		turns off tracing  */  * Note: #ifdef decus stuff hasn't been tested.   */    #include	<stdio.h> #define	FALSE	0  #define	TRUE	1 #define	EOS	'\0'   #ifdef	decus static FILE	tracefd; #else  static int	tracefd;  #endif  
 #ifdef vms #include		<ssdef.h>  #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)  #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */  #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   static int	tracing = FALSE;  static int	file_opened = FALSE;   	 traceon()  /*8  * Turn on tracing, opening the trace file if necessary.  */  {  	if (!file_opened) { 	    file_opened = TRUE; #ifdef	decus7 	    if ((tracefd = fopen("trace.out", "w")) == NULL) {  		perror("trace.out");+ 		error("trace: can't create trace.out\n");  	    } #else 4 	    if ((tracefd = creat("trace.out", 0644)) < 0) { 		perror("trace.out"); 		exit(IO_ERROR);d 	    } #endif 	} 	_tracef("traceon() called");      	tracing = TRUE; }	  
 traceoff() {	 	_tracef("traceoff() called");     	tracing = FALSE;e }n c /*E  * XBUFSIZE is the length of a printed line in the trace output file.   */  #define	XBUFSIZE	80 " static char	xbuffer[XBUFSIZE + 2]; static char	*xbufp;    _tracef(fmt, args)
 char	*fmt;	 int	args; {      	int		*parm; 	char		buffer[512];  	auto char	*bufp; 
 	char		*bufe; 8 	char		bytebuff[512];	/* Bytes stored here for output	*/- 	char		*bytep;		/* Pointer into bytebuff[]	*/ . 	int		stringcount;	/* Count for %*s format		*/- 	char		*stringp;	/* String pointer for %*s	*/    	parm = &args; 	bufp = buffer;  	if (!tracing) 	    return; 	while (*fmt) {  	    if (*fmt == '%') {  		fmt++; 		switch (*fmt) {. 		case 'b':f" 		    addnum(&bufp, *(parm++), 2); 		    break;   		case 'd': # 		    addnum(&bufp, *(parm++), 10);1 		    break;   		case 'o':" 		    addnum(&bufp, *(parm++), 8); 		    break;   		case 'x':	# 		    addnum(&bufp, *(parm++), 16);n 		    break;   		case 'c':	 		    *(bufp++) = '\'';d 		    *(bufp++) = *(parm++); 		    *(bufp++) = '\'';0 		    break;  " 		case '*':			/* Counted string	*/ 		    if (fmt[1] != 's')	 			break;P 		    fmt++; 		    stringcount = *(parm++); 		    *(bufp++) = '"'; 		    stringp = *(parm++); 		    if (stringp == NULL) { 			strcpy(bufp, "?NULL?");
 			bufp += 6;	 		    }f" 		    else while (--stringcount) { 			*bufp++ = *stringp++; 		    }C 		    *bufp++ = '"'; 		    break;   		case 's':_ 		    if (*parm) { 			*(bufp++) = '"';T 			strcpy(bufp, *parm);  			bufp += strlen(*parm);_ 			*(bufp++) = '"';p 		    }  		    else { 			 strcpy(bufp, "NULL");a 			 bufp += 4; 		    }G
 		    parm++;/ 		    break; 		}6 	    } 	    else {	 		*(bufp++) = *fmt;/ 	    } 	    fmt++;P 	} 	*(bufp++) = '\n'; 	/*((  	 * Write the buffer in datascope mode. 	 */
 	bufe = bufp;E 	xbufp = xbuffer;r+ 	for (bufp = buffer; bufp < bufe; bufp++) {r 	    bytep = bytebuff; 	    *bufp &= 0377;+ 	    if (*bufp == '\n')	 		_traceout("\n"); 	    else if (*bufp == '\033') 		_traceout("<ESC>");	 	    else {o 		if (*bufp >= 0177) { 		    *bytep++ = '~';  		    *bufp -= 0200; 		} % 		if (*bufp < ' ' && *bufp != '\t') {  		    *bytep++ = '^';t 		    *bytep++ = (*bufp + '@');	 		}O 		else *bytep++ = *bufp; 		*bytep = '\0'; 		_traceout(bytebuff); 	    } 	} 	_traceout(NULL);l }e   #define	GUARD	4f   static _traceout(string)  char		*string; /*"  * Output routine for _tracef() --  *	"\n"	End of line from user.6  *	NULL	end of text.  Dump current buffer if non-empty8  *	string	Stuff it if there's room, else get a new line.  */	 {4 	if (string == NULL) { 	    if (xbufp > xbuffer) {	 #ifdef decus5 		fprintf(tracefd, "%.*s", xbufp - xbuffer, xbuffer);_ #else6+ 		write(tracefd, xbuffer, xbufp - xbuffer);o #endif 		xbufp = xbuffer; 	    } 	}3 	else if (string[0] == '\n' && string[1] == '\0') {* 	    *xbufp++ = '\n';  #ifdef decus5 		fprintf(tracefd, "%.*s", xbufp - xbuffer, xbuffer);y #elset+ 		write(tracefd, xbuffer, xbufp - xbuffer);t #endif 	    xbufp = xbuffer;e 	}@ 	else if (xbufp + strlen(string) < &xbuffer[XBUFSIZE - GUARD]) { 	    while (*string != '\0') { 		*xbufp++ = *string++;i 	    } 	} 	else {F/ 	    while (xbufp < &xbuffer[XBUFSIZE - GUARD])a 		*xbufp++ = ' ';e 	    strcpy(xbufp, "|<--\n");d #ifdef decus% 	    fprintf(tracefd, "%s", xbuffer);	 #elsef. 	    write(tracefd, xbuffer, strlen(xbuffer)); #endif 	    strcpy(xbuffer, string);u& 	    xbufp = &xbuffer[strlen(string)]; 	} }c   static addnum(bufp, num, base)/% char		**bufp;			/* Output pointer		*/o" int		num;			/* To be converted		*/  int		base;			/* Output base			*/ /*D  * Convert the number to ascii.  Note: base 10 is signed, others are  * unsigned.  */s {t 	register unsigned int	temp;  !     	if (base == 10 && num < 0) {  	    num = -num; 	    *((*bufp)++) = '-'; 	    if (num < 0) {* 		/*5 		 * The dreaded 32768 -- the following will not worki% 		 * everywhere, but will do for now.* 		 */r #if (0x8000 < 0)2 		*((*bufp)++) = '3';	/* 16 bit twos-complement	*/
 		num = 2768;	 #else 2 		*((*bufp)++) = '2';	/* 32 bit twos-complement	*/ 		num = 147483648; #endif 	    } 	}+ 	if ((temp = ((unsigned) num) / base) != 0)) 	    addnum(bufp, temp, base);< 	*((*bufp)++) = "0123456789abcdef"[((unsigned) num) % base]; }\