 /* #define	COMPILE_MAIN */ /*$  * Library I/O routines for Vax-11 C  *  * Martin Minow   *)  * This software is in the public-domain.   *  * Restrictions:%  *	We only know about text libraries. 2  *	Only one library may be manipulated at at time.,  *	Little attention was paid to performance.  */    #ifdef	COMPILE_MAIN  #define	TESTING  #endif   #include	<stdio.h> #include	<ctype.h>
 #define	EOS	0    /*2  * Define vms specific structures and definitions:  *	descrip		String descriptors  *	rms		File systemC  *	ssdef		Return status codesI  */u #include	rms #include	descrip #include	ssdef   /*   * Home made library definitions  */  #include	"lbrdef.h"W   /*  * Library status values  */*. globalvalue	LBR$_NORMAL;		/* Normal return		*/   /*+  * The following functions are defined/used   *  *	int?  *	lbr_update(filename)		-- initialize existing file for updatec(  *	char	*filename;		-- file name to openD  *	    Opens an existing file for update.  Returns SS$_NORMAL if ok,  *	    else the error code.C  *  *	int)  *	lbr_create(filename, keylen, nindexes)i  *	char	*filename;&  *	int	keylen;			-- maximum key length-  *	int	nindex;			-- number of library indexes*B  *	    Open the library for update.  Create it if it wasn't found.6  *	    Return SS$_NORMAL if ok, else a vms error code.  *  *	int2  *	lbr_open(filename)		-- initialize for read only  *	char	*filename;=  *	    Open an existing library for input.  Return SS$_NORMALi+  *	    if opened ok, else a vms error code.,  *  *	int  *	lbr_close()6  *	    Close the library.  Returns the VMS error code.  *  *	int  *	lbr_lookup(key)
  *	char	*key;i4  *	    Setup to read the data associated with a key.6  *	    Return SS$_NORMAL if ok, else a vms error code.  *  *	int  *	lbr_read(buffer, bufferlen)  *	char	*buffer;  *	int	bufferlen; B  *	    Read a record from the library -- after calling lbr_lookup.?  *	    Returns the number of bytes read for each record, or EOF$  *	    when at "end of data".e  *  *	int(  *	lbr_write(buffer, bufferlen, command)(  *	char	*buffer;		-- Data buffer or key.,  *	int	bufferlen;		-- Length if data buffer.!  *	int	command;		-- Request type:t&  *	  0  New entry, buffer has the key.-  *	  1  A record to be stored under this key. %  *	  2  Terminate input for this key.e6  *	  3  An additional key for the record just entered.?  *	    Returns SS$_NORMAL if ok.  Exits to the operating systemr,  *	    if your calls are in the wrong order.  */$ * typedef struct	rfa {
 	long	rfa[2];i } RFA;   /*(  * Static database for library interface  */;  3 static	int	lbr_index;		/* VMS routines need this	*/i; static	struct lbr$credef lbr_options;	/* Create options		*/e  C typedef struct dsc$descriptor_s STRING;	/* VMS string descriptor	*/k   int  lbr_update(filename) char	*filename;  /**  * Initialize an existing file for update.  */* {  	register int	errorcode; 	int		function;e 	int		type_text; 	STRING		string;    	descrip(filename, -1, &string); 	function = LBR$C_UPDATE;	 	type_text = LBR$C_TYP_TXT;a# 	if (((errorcode = lbr$ini_control(** 		&lbr_index,			/* For other references	*/& 		&function,			/* Assume it's there	*/# 		&type_text,			/* Text library		*/  		NULL))				/* No name block	*/  	  		== LBR$_NORMAL) 	  && ((errorcode = lbr$open(p$  		&lbr_index,			/* Library index	*/' 		&string,			/* File name descriptor	*/.% 		&lbr_options,			/* Options array	*/i$ 		NULL,				/* No default filename	*/ 		NULL,				/* No NAM block		*/$ 		NULL,				/* No result file name	*/$ 		NULL))				/* No result file len	*/ 			== LBR$_NORMAL)) {i% 		return (SS$_NORMAL);		/* Gotcha		*/h 	} #ifdef	TESTING* 	message(errorcode, "Opening for update"); #endif 	return (errorcode); }	 L int	$ lbr_create(filename, keylen, nindex) char	*filename;o int	keylen;p int	nindex;_ {e   	register int	errorcode; 	int		function;e 	int		type_text; 	STRING		string;  ( 	if (lbr_update(filename) == SS$_NORMAL) 	    return (SS$_NORMAL);	 	/* 9 	 * Couldn't open the file for update.  Try to create it.U 	 */  	descrip(filename, -1, &string);( 	lbr_options.cre$l_type = LBR$C_TYP_TXT;8 	lbr_options.cre$l_keylen = keylen;	/* max key length	*/9 	lbr_options.cre$l_alloc = 100;		/* initial allocation	*/ ; 	lbr_options.cre$l_idxmax = nindex;	/* number of indices	*/ 9 	lbr_options.cre$l_uhdmax = 0;		/* extra module header	*/ : 	lbr_options.cre$l_entall = 0;		/* Index to preallocate	*/ 	function = LBR$C_CREATE;$ 	type_text = LBR$C_TYP_TXT;R# 	if (((errorcode = lbr$ini_control(i* 		&lbr_index,			/* For other references	*/) 		&function,			/* Create a new library	*/s# 		&type_text,			/* Text library		*/t 		NULL))				/* No name block	*/x 	  		== LBR$_NORMAL) 	  && ((errorcode = lbr$open(n' 		    &lbr_index,			/* Library index	*/i+ 		    &string,			/* File name descriptor	*/r/ 		    &lbr_options,		/* Create options array	*/r' 		    NULL,			/* No default filename	*/I! 		    NULL,			/* No NAM block		*/ ' 		    NULL,			/* No result file name	*/T' 		    NULL))			/* No result file len	*/  			== LBR$_NORMAL)- 	  && (errorcode = lbr_close()) == SS$_NORMALe9 	  && (errorcode = lbr_update(filename)) == SS$_NORMAL) {	% 		return (SS$_NORMAL);		/* Gotcha		*/  	} #ifdef	TESTING9 	message(errorcode, "Can't create library %s", filename);d #endif 	return (errorcode); }n   inti lbr_open(filename) char		*filename; /*  * Open an existing library	  */N {e 	register int	errorcode; 	int		function;  	int		type_text; 	STRING		string;    	descrip(filename, -1, &string); 	function = LBR$C_READ;	 	type_text = LBR$C_TYP_TXT;r# 	if (((errorcode = lbr$ini_control( * 		&lbr_index,			/* For other references	*/& 		&function,			/* Assume it's there	*/# 		&type_text,			/* Text library		*/s 		NULL))				/* No name block	*/r 	  		== LBR$_NORMAL) 	  && ((errorcode = lbr$open(n# 		&lbr_index,			/* Library index	*/	' 		&string,			/* File name descriptor	*/r! 		NULL,				/* No options array	*/d$ 		NULL,				/* No default filename	*/ 		NULL,				/* No NAM block		*/$ 		NULL,				/* No result file name	*/$ 		NULL))				/* No result file len	*/ 			== LBR$_NORMAL)) {l% 		return (SS$_NORMAL);		/* Gotcha		*/r 	} #ifdef	TESTING4 	message(errorcode, "Opening library %s", filename); #endif 	return (errorcode); }) 	 int  lbr_close()r /*  * Close the library  */( {o 	register int	errorcode;  8 	if ((errorcode = lbr$close(&lbr_index)) == LBR$_NORMAL) 	    return (SS$_NORMAL);  	else {s #ifdef	TESTING1 	    message(errorcode, "Closing library", NULL);N #endif 	    return (errorcode); 	} }e m int  lbr_lookup(key)  char		*key;e /*,  * Setup to read data associated with a key.  */* {t 	register int	errorcode;% 	RFA		textrfa;		/* Actaully unused	*/y 	STRING		string;   	descrip(key, -1, &string);)- 	if (((errorcode = lbr$lookup_key(&lbr_index,a! 		&string,			/* Key descriptor	*/d# 		&textrfa))			/* Store rfa here	*/r 			& 01) != 0) { 	    return (SS$_NORMAL);R 	} 	else {  #ifdef	TESTING6 	    message(errorcode, "Looking up key \"%s\"", key); #endif 	    return (errorcode); 	} }    	  int_ lbr_read(buffer, bufflen)  char		*buffer;
 int		bufflen;i /*5  * Read a record. return actual record length or EOF.	  */f {	 	register int	errorcode;# 	struct dsc$descriptor_s bufdes = {s1 	    bufflen,			/* dsc$w_length = strlen(text)	*/d& 	    DSC$K_DTYPE_T,		/* Text type			*/# 	    DSC$K_CLASS_S,		/* String			*/r* 	    buffer,			/* dsc$a_pointer -> text	*/ 	};}& 	struct dsc$descriptor_s outbufdes = {, 	    0,				/* dsc$w_length = strlen(text)	*/& 	    DSC$K_DTYPE_T,		/* Text type			*/# 	    DSC$K_CLASS_S,		/* String			*/n( 	    NULL,			/* dsc$a_pointer -> text	*/ 	};   - 	if (((errorcode = lbr$get_record(&lbr_index,*& 		&bufdes,		/* Where to store data		*/. 		&outbufdes))		/* Gets actual datum length	*/ 			& 01) != 0) {% 	    return (outbufdes.dsc$w_length);/ 	}  	else if (errorcode == RMS$_EOF) 	    return (EOF); 	else {, #ifdef	TESTING? 	    message(errorcode, "unexpected error reading text", NULL);  #endif 	    return (EOF); 	} }t / int # lbr_write(buffer, bufflen, command)  char		*buffer;
 int		bufflen;*
 int		command;	 /*%  * Manage update/replace of a module.(  * Calling sequence:9  *	lbr_write("module", 0, 0);		-- setup to enter "module" (  *	while (more_data)			-- write all data*  *	    lbr_write(datum, strlen(datum), 1);)  *	lbr_write(NULL, 0, 2);			-- terminate. &  *	while (more_alises_for_this_module)4  *	    lbr_write(alies, 0, 3);		-- write other names  */o {e 	register int	errorcode;# 	struct dsc$descriptor_s bufdes = {n) 	    bufflen,			/* Actual data length		*/h& 	    DSC$K_DTYPE_T,		/* Text type			*/) 	    DSC$K_CLASS_S,		/* String datum			*/u$ 	    buffer,			/* Datum location		*/ 	};o 	/*,A 	 * The following static database maintains communication betweent 	 * calls of lbr_write.i  	 */m #define	INIT_STATE	0 #define	ENTER_STATE	1) #define	END_STATE	2*  	static int		state = INIT_STATE; 	int			replacing;e
 	int			first;	 	static RFA		old_module_rfa; 	static RFA		new_module_rfa; 	static RFA		first_record_rfa;/ 	static struct dsc$descriptor_s module_name = { $ 	    0,				/* Actual data length		*/& 	    DSC$K_DTYPE_T,		/* Text type			*/) 	    DSC$K_CLASS_S,		/* String datum			*/}" 	    NULL,			/* Datum location		*/ 	};s   	switch (command) {o 	case 0:				/* Initialize			*/  	    if (state == ENTER_STATE) {, 		fprintf(stderr, "Bug calling lbr_write:");3 		fprintf(stderr, "  you must terminate previous");e; 		fprintf(stderr, " entry before entering a new module\n");n/ 		fprintf(stderr, "old library key is \"%s\",",s! 		    module_name.dsc$a_pointer);e2 		fprintf(stderr, " new key is \"%s\"\n", buffer); 		exit(SS$_BADPARAM);e 	    }< 	    module_name.dsc$a_pointer = malloc(strlen(buffer) + 1);/ 	    strcpy(module_name.dsc$a_pointer, buffer); / 	    module_name.dsc$w_length = strlen(buffer);e+ 	    replacing = lbr$lookup_key(&lbr_index,l) 		&module_name,		/* Key to search for		*/u1 		&old_module_rfa);	/* Old module for deletion	*/n 	    state = ENTER_STATE;o 	    first = TRUE;2 	    return (SS$_NORMAL);	/* Always successful		*/    	case 1:				/* Put a record			*/  	    if (state != ENTER_STATE) {; 		fprintf(stderr, "Bug -- lbr_write calls out of order\n");a 		exit(SS$_BADPARAM);n 	    }0 	    if ((errorcode = lbr$put_record(&lbr_index, 		    &bufdes, 		    &new_module_rfa)) & 01) {f 		if (first) {( 		    first_record_rfa = new_module_rfa; 		    first = FALSE; 		}c 		return (SS$_NORMAL); 	    } 	    else {  #ifdef	TESTING6 		message(errorcode, "putting a module record", NULL); #endif 		return (errorcode);u 	    }   	case 2:  	    if (state != ENTER_STATE) {: 		fprintf(stderr, "Bug: lbr_write calls out of order.\n"); 		exit(SS$_BADPARAM);r 	    }: 	    if (((errorcode = lbr$put_end(&lbr_index)) & 01) != 02 	     && ((errorcode = lbr$replace_key(&lbr_index, 			&module_name, 			&old_module_rfa,  			&new_module_rfa)) & 01) != 0f 	     && ((replacing & 01) == 0	3 	      || ((errorcode = lbr$delete_data(&lbr_index,S# 			&old_module_rfa)) & 01) != 0)) { " 		free(module_name.dsc$a_pointer);# 		module_name.dsc$a_pointer = NULL;: 		state = END_STATE; 		return (SS$_NORMAL); 	    } 	    else {t #ifdef	TESTING5 		message(errorcode, "cleanup after write of \"%s\"",e! 		    module_name.dsc$a_pointer);  #endif 		return (errorcode);e 	    }   	case 3: 	    if (state != END_STATE) {9 		fprintf(stderr, "Bug: lbr_write calls out of order\n");  		exit(SS$_BADPARAM);  	    }" 	    descrip(buffer, -1, &bufdes);F 	    replacing = lbr$lookup_key(&lbr_index, &bufdes, &old_module_rfa); 	    if (replacing & 01) {/ 		if (((errorcode = lbr$delete_data(&lbr_index,	# 				&old_module_rfa)) & 01) == 0) {s #ifdef	TESTING; 		    message(errorcode, "delete_data for \"%s\"", buffer);  #endif5 message(errorcode, "delete_data for \"%s\"", buffer);) 		    return (errorcode);  		}s8 		if (((errorcode = lbr$delete_key(&lbr_index, &bufdes)) 			& 01) == 0) { #ifdef	TESTING: 		    message(errorcode, "delete_key for \"%s\"", buffer); #endif4 message(errorcode, "delete_key for \"%s\"", buffer); 		    return (errorcode);& 		}{ 	    }1 	    if (((errorcode = lbr$insert_key(&lbr_index,d- 			&bufdes, &first_record_rfa)) & 01) == 0) {	 #ifdef	TESTING7 		message(errorcode, "alternate key \"%s\"\n", buffer);g #endif5 message(errorcode, "alternate key \"%s\"\n", buffer);( 		return (errorcode);f 	    } 	    return (SS$_NORMAL);_ 	} }& d static descrip(text, len, stringp)G char		*text;	 int		len;, STRING		*stringp;% /*  * Load string descriptor(  */c {, 	if (len == -1)\ 	    len = strlen(text); 	stringp->dsc$a_pointer = text;  	stringp->dsc$w_length = len;r& 	stringp->dsc$b_dtype = DSC$K_DTYPE_T;& 	stringp->dsc$b_class = DSC$K_CLASS_S; }  e9 static char	etext_text[257];	/* Error text stored here	*/f  J static $DESCRIPTOR(etext_err, etext_text); /* descriptor for error text	*/   char * vms_etext(errorcode) int		errorcode;d {t 	char		*bp;(* 	short		errlen;		/* Actual text length		*/  6 	lib$sys_getmsg(&errorcode, &errlen, &etext_err, &15); 	/*, 	 * Trim trailing junk.l 	 */6 	for (bp = &etext_text[errlen]; --bp >= etext_text;) {$ 	    if (isgraph(*bp) && *bp != ' ') 		break; 	}
 	bp[1] = EOS;r 	return(&etext_text[0]); }S   static message(errorcode, why, arg) int		errorcode;s char		*why;f char		*arg;E /*  * Print error message  *// {e 	extern char	*vms_etext();   	if (why == NULL) {o5 	    fprintf(stderr, "\n%s\n", vms_etext(errorcode));l 	} 	else if (arg == NULL) {> 	    fprintf(stderr, "\n%s: %s\n", why, vms_etext(errorcode)); 	} 	else {a 	    fprintf(stderr, "\n");= 	    fprintf(stderr, why, arg);x5 	    fprintf(stderr, ": %s\n", vms_etext(errorcode));a 	} }    #ifdef	COMPILE_MAIN(   char	line[514];S char	filename[514];r   main() {  	register int	readcount;  & 	while (prompt("Library file name")) { 	    strcpy(filename, line); 	    read_module();  	    enter_module(); 	} }r  
 read_module()s {, 	register int	readcount;   	lbr_open(filename);2 	fprintf(stderr, "open, index = %d\n", lbr_index);  	while (prompt("Module name")) {* 	    if (lbr_lookup(line) == SS$_NORMAL) {: 		while ((readcount = lbr_read(line, sizeof line)) >= 0) { 		    line[readcount] = EOS;4 		    fprintf(stderr, "%6d\t%s\n", readcount, line); 		}  	    }: 	    else fprintf(stderr, "Couldn't find \"%s\"\n", line); 	}
 	lbr_close();r }(   enter_module() {  	lbr_create(filename, 32, 1);d= 	fprintf(stderr, "open for update, index = %d\n", lbr_index); ) 	while (prompt("Module name to enter")) {p( 	    if (lbr_lookup(line) == SS$_NORMAL)8 		fprintf(stderr, "Warning, \"%s\" in library\n", line);- 	    if (lbr_write(line, 0, 0) != SS$_NORMAL)s$ 		fprintf(stderr, "Entry failed\n"); 	    else {  		while (prompt("data")) {9 		    if (lbr_write(line, strlen(line), 1) != SS$_NORMAL)t, 			fprintf(stderr, "Error entering data\n"); 		}o* 		if (lbr_write(NULL, 0, 2) != SS$_NORMAL)/ 		    fprintf(stderr, "Error closing entry\n");u- 		while (prompt("Additional module names")) {m. 		    if (lbr_write(line, 0, 3) != SS$_NORMAL)7 			fprintf(stderr, "Error entering additional name\n");s 		}  	    } 	}
 	lbr_close();  }r   prompt(text) char		*text; {s 	clearerr(stdin);  	fprintf(stderr, "%s: ", text);  	fflush(stdin);d* 	if (gets(line) == NULL || line[0] == EOS) 	    return (FALSE); 	return (TRUE);d }, #endif  