 /*	setuid.c   *	V1.0			6-Aug-1995		IfN/Mey   *.  *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>  *+ #  * Setting the UID in VMS involves:   *.  *	- setting process and job UIC to that value7  *	- setting process username to the corresponding user   *	- setting user's privileges&  *	- setting user's rights identifiers  *-   */  #define EXTERN extern  #include "priv.h"   E static struct uai *current_uai = NULL;	/* changed only by setuid() */   1 static void grant_identifiers(struct id *id_list)  {  	unsigned long sts;    	if (id_list == NULL) return;  	while(id_list->uic != -1) {6 		DEBUG(6,("  grant identifier %08X\n",id_list->uic));% 		sts = sys$grantid(0,0,id_list,0,0);  		id_list++; 	} }   2 static void revoke_identifiers(struct id *id_list) {  	unsigned long sts;    	if (id_list == NULL) return;  	while(id_list->uic != -1) {7 		DEBUG(6,("  revoke identifier %08X\n",id_list->uic)); % 		sts = sys$revokid(0,0,id_list,0,0);  		id_list++; 	} }        int vms_setuid(uid_t uid)  { 	   int st; 
   struct {      int size;      char *ptr; 
   } userdesc;     long sys_set_username(void *);#   long sys_set_uic(unsigned int *);    struct passwd *pw;   struct uai *puai;    unsigned long tmpprv[2]; /*B  * Check if current use is already known (from a previous setuid).4  * If not, obtain current username and setup things.  */    if (current_uai == NULL) { 	vms_getlogin();* 	if (setup_pw() != SS$_NORMAL) return(-1); 	current_uai = login_uai;    }  /*9  * Find UID in table. If not found, we become a new user. ;  * UICs [0,0], [1,0] and [1,4] are considered to be SYSTEM.   */ G   if (uid == 0x00000000L || uid == 0x00010000L || uid == 0x00010004L) {  	strcpy(login_name,"SYSTEM"); ,   	if (setup_pw() != SS$_NORMAL) return(-1); 	password_struct.pw_uid = uid;$ 	password_struct.pw_gid = uid >> 16;   }    else { 	puai = find_uai_by_uic(uid);  	if (puai == NULL) return(-1); 	strcpy(login_name,puai->name); ,   	if (setup_pw() != SS$_NORMAL) return(-1);   }   D DEBUG (2,("vms_setuid: uid = %08X, username = \"%s\", uic = %08X\n",( uid,login_name,password_struct.pw_uid)); /*-  * Set new use user name, UIC and privileges.   *=  *	- clear all privs and set CMKRNL for setting username/uic.   */    tmpprv[0] = 0xFFFFFFFF;    tmpprv[1] = 0xFFFFFFFF; ;   st = sys$setprv(0,tmpprv,1,0);	/* clear all privileges */ #   if (st != SS$_NORMAL) return(-1);      tmpprv[0] = PRV$M_CMKRNL;    tmpprv[1] = 0;A   st = sys$setprv(1,tmpprv,1,0);	/* enable to set USERNAME/UIC */ #   if (st != SS$_NORMAL) return(-1);  /*4  *	- set username/uic - this is kernel mode hacking!  */ %   userdesc.size = strlen(login_name);    userdesc.ptr  = login_name; #   st = sys_set_username(&userdesc); #   if (st != SS$_NORMAL) return(-1); 3   st = sys_set_uic(&(password_struct.pw_uid)); /**/ #   if (st != SS$_NORMAL) return(-1);  /*4  *	- revoke current user's identifiers and setup new  */ +   revoke_identifiers(current_uai->id_list); (   grant_identifiers(login_uai->id_list);   current_uai = login_uai; /*-  *	- clear privileges required for hacking...   */ 8   st = sys$setprv(0,tmpprv,1,0);	/* reset those privs */#   if (st != SS$_NORMAL) return(-1);  /*   *	- finally set new users privs  */ K DEBUG (3,("vms_setuid: privs = %08X %08X\n",login_priv[0], login_priv[1])); ?   st = sys$setprv(1,login_priv,1,0);	/* set new user's privs */ #   if (st != SS$_NORMAL) return(-1);    sys$setprv(0,0,1,tmpprv); C DEBUG (8,("            privs = %08X %08X\n",tmpprv[0], tmpprv[1]));    return(0); } 