/*
**  FILE:   Posix.1 Header <utime.h>
**  IDENT:  X-7
**
*****************************************************************************
**									    *
**  Copyright  Digital Equipment Corporation, 1991, 1992, 1993		    *
**  All Rights Reserved.  Unpublished rights reserved under  the  copyright *
**  laws of the United States.						    *
**									    *
**  The software contained on this media is proprietary to and embodies the *
**  confidential  technology of Digital Equipment Corporation.  Possession, *
**  use,  duplication  or  dissemination  of  the  software  and  media  is *
**  authorized  only  pursuant  to  a  valid  written  license from Digital *
**  Equipment Corporation.						    *
**									    *
**  RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the  U.S. *
**  Government  is  subject  to  restrictions  as set forth in Subparagraph *
**  (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.   *
**									    *
*****************************************************************************
*/
 
# ifndef __UTIME_LOADED
# define __UTIME_LOADED 1

# ifdef __cplusplus
extern "C" {
# endif

# if __DECC || __DECCXX
#   pragma __nostandard
#   pragma __member_alignment __save
#   pragma __nomember_alignment
# elif VAXC
#   pragma nostandard
# endif

# ifndef __CLOCK_T
# define __CLOCK_T 1
typedef long		clock_t;
# endif
# ifndef __SIZE_T
# define __SIZE_T 1
typedef unsigned long	size_t;
# endif
# ifndef __TIME_T
# define __TIME_T 1
typedef long		time_t;
# endif
# if !defined __SIGSET_T && !defined _SIGSET_T_
# define __SIGSET_T 1
# define _SIGSET_T_ 1
typedef struct {unsigned long	_set[2]; }	sigset_t;
# endif
# ifndef CADDR_T
# define CADDR_T 1
typedef char *		caddr_t;
# endif

#if 0	/* Don't define IfN/Mey */
# ifndef __POSIX_TYPES_DEFINED
# define __POSIX_TYPES_DEFINED 1
typedef long		pid_t;
typedef long		off_t;
typedef long		ssize_t;
typedef unsigned long	uid_t;
typedef unsigned long	gid_t;
typedef unsigned long	dev_t;
typedef unsigned long	ino_t;
typedef unsigned long	mode_t;
typedef unsigned long	nlink_t;
typedef unsigned long	key_t;
typedef unsigned long	evtset_t;
# endif
#endif

struct utimbuf
{
    time_t	actime;
    time_t	modtime;
} ;

int utime (const char * __path, const struct utimbuf * __times);

# if __DECC || __DECCXX
#   pragma __member_alignment __restore
#   pragma __standard
# elif VAXC
#   pragma standard
# endif

# ifdef __cplusplus
}
# endif

# endif		/* __UTIME_LOADED  */

