 /*	vms-sup.c  *	V1.1			4-Jun-1996	IfN/Mey  *.  *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>  *+   * Samba VMS support. %  * Misc. routines not present on VMS.   *'  * NOTE: includes.h *IS* included here.   *-   */    #define __FCNTL_LOADED 1 #include "includes.h"  #include <starlet.h> #include <iodef.h> #include <lib$routines.h>  #include <descrip.h> #include <dvidef.h>  #include <quidef.h>  #include <jpidef.h>    /* SAMBA debugging */  extern int DEBUGLEVEL;   struct itm_list_2 {  	unsigned short len; 	unsigned short code;  	void *bufadr; };   struct itm_list_3 {  	unsigned short len; 	unsigned short code;  	void *bufadr; 	short int *retadr;  };   struct vms_timbuf { $ 	short int year;		/* year since 0 */$ 	short int mon;		/* month of year */$ 	short int mday;		/* day of month */ 	short int hour; 	short int min;  	short int sec;  	short int hundred;  };   /*  * vms_set_process_name   */   % void vms_set_process_name(char *name)  { 
 	int lgth;& 	char buf[16];	/* max 15 characters */ 	struct dsc$descriptor prcnam;   	lgth = strlen(name);  	if (lgth > 15) lgth = 15; 	strncpy(buf,name,lgth); 	prcnam.dsc$a_pointer = buf; 	prcnam.dsc$w_length = lgth; 	sys$setprn(&prcnam);  }      /*  * vms_process_exists   */  int vms_process_exists(int pid)  {  	unsigned long result; 	unsigned long sts;  	long item;    	item = JPI$_PID; , 	sts = lib$getjpi(&item,&pid,0,&result,0,0); 	return(sts&1);  }      /*K  * Make a suitable VMS file name from a DOS long filename (in UNIX syntax). J  * Characters not possible for a VMS filename are replaced by '__NN' where(  * 'NN' is the two-digit hex ASCII code.  *7  * The resultant string is returned in a static buffer.   */  static char buffer[256];  char *vms_make_name(char *fname) {  	char escbuf[5]; 	char *p,*q; 	int dotcnt = 0; 	int ulcnt = 0;  	int i;   + 	for (p=fname, q=buffer; *p != '\0'; p++) {  /*G  * If we find a colon in the name, we assume the filename is already in 4  * VMS format. Copy original string over and return.  */  		if (*p == ':') { 			strcpy(buffer,fname); 			return(buffer); 		}  		if ((*p < 'a' || *p > 'z') 		&& (*p < 'A' || *p > 'Z')  		&& (*p < '0' || *p > '9') ( 		&& *p != '$' && *p != '-' && *p != '/'( 		&& *p != '*' && *p != '?' && *p != '%' 		&& (*p != '.' || dotcnt >= 1) ! 		&& (*p != '_' || ulcnt >= 1)) {  			if (*p == '_') { ' 				sprintf(escbuf,"_%02X_",*p & 0xFF);  				strcpy(q, escbuf); 			}	 			else {  				ulcnt = 0;' 				sprintf(escbuf,"__%02X",*p & 0xFF);  				strcpy(q, escbuf); 			}
 			q += 4; 		}  		else {
 			*q++ = *p;  			if (*p == '.') dotcnt++;  			if (*p == '/') dotcnt = 0;  			if (*p == '_') {  				ulcnt++; 			}	 			else {  				ulcnt = 0; 			} 		}  	} 	*q = '\0';  	return(buffer); }    /*%  * Make DOS filename from a VMS name.   */  char *vms_get_name(char *fname)  {  	char escbuf[5]; 	char *p,*q; 	int dotcnt = 0; 	int ulcnt = 0;  	int i;   + 	for (p=fname, q=buffer; *p != '\0'; p++) {  		if (*p == '_') {- 			if (ulcnt == 0) {	/* if first underline */  				ulcnt++; 			}	 			else {  				p++; 				if (*p == '\0') break; 				sscanf(p,"%02X",q++);  				p++; 				ulcnt = 0; 				if (*p == '\0') break; 			} 		}  		else {- 			if (ulcnt > 0) {	/* if single underline */  				*q++ = '_';  				ulcnt = 0; 			}
 			*q++ = *p;  		}  	} 	if (ulcnt > 0) *q++ = '_';  	*q = '\0';  	return(buffer); }     L #define QUI_OK	(QUI$M_QUEUE_AVAILABLE | QUI$M_QUEUE_BUSY | QUI$M_QUEUE_IDLE)B #define QUI_ERROR  (QUI$M_QUEUE_STALLED | QUI$M_QUEUE_UNAVAILABLE)   /*  * vms_getqui_init  *5  * Establish a $GETQUI context for a specified queue.   */ C BOOL vms_getqui_init(char *queue_name, print_status_struct *status)  {  	unsigned long sts;  	unsigned long search_flags; 	unsigned long queue_status;! 	struct itm_list_3 queue_list[4];  	unsigned long iosb[2];  /*  * Cancel any previous context.   */ 6 	sts = sys$getquiw(0,QUI$_CANCEL_OPERATION,0,0,0,0,0); 	if (!(sts&1)) return(False);  /*  * Establish queue context.   */ ( 	queue_list[0].code = QUI$_QUEUE_STATUS;& 	queue_list[0].bufadr = &queue_status;* 	queue_list[0].len = sizeof(queue_status); 	queue_list[0].retadr = NULL;   ' 	queue_list[1].code = QUI$_SEARCH_NAME; # 	queue_list[1].bufadr = queue_name; ( 	queue_list[1].len = strlen(queue_name); 	queue_list[1].retadr = NULL;   ( 	queue_list[2].code = QUI$_SEARCH_FLAGS;& 	queue_list[2].bufadr = &search_flags;* 	queue_list[2].len = sizeof(search_flags); 	queue_list[2].retadr = NULL;    	queue_list[3].code = 0; 	queue_list[3].len = 0;   & 	search_flags = QUI$M_SEARCH_WILDCARD;  ? 	sts = sys$getquiw(0,QUI$_DISPLAY_QUEUE,0,queue_list,iosb,0,0); B 	DEBUG(5,("getqui_init:  sts = %08X, iosb = %08X\n",sts,iosb[0]));4 	if ( (!(sts&1)) ||  (!(iosb[0]&1)) ) return(False);  ? 	DEBUG(5,("              queue_status = %08X\n",queue_status));    	if (status) { 		if (queue_status & QUI_OK) {0 			strcpy(status->message,"Queue status is OK"); 			status->status=LPSTAT_OK; 		} & 		else if (queue_status & QUI_ERROR) {3 			strcpy(status->message,"Queue status is ERROR");  			status->status=LPSTAT_ERROR;  		}  		else {5 			strcpy(status->message,"Queue status is STOPPED"); # 			status->status = LPSTAT_STOPPED;  		}  	}   	return(True); }    /*  * vms_getqui_entry   *$  * Get job information for next job.  */ : BOOL vms_getqui_entry(print_queue_struct *buf, BOOL first) {  	unsigned long sts;  	unsigned long search_flags; 	struct itm_list_3 job_list[8];  	unsigned long iosb[2];  	char job_name[40];  	char username[13];  	long job_size;  	long entry_number;  	unsigned long job_status;" 	unsigned long submission_time[2]; 	short int job_name_len; 	short int username_len; 	struct vms_timbuf timbuf;  " 	job_list[0].code = QUI$_JOB_NAME; 	job_list[0].bufadr = job_name;  	job_list[0].len = 39;$ 	job_list[0].retadr = &job_name_len;  " 	job_list[1].code = QUI$_USERNAME; 	job_list[1].bufadr = username;  	job_list[1].len = 12;$ 	job_list[1].retadr = &username_len;  " 	job_list[2].code = QUI$_JOB_SIZE;  	job_list[2].bufadr = &job_size;$ 	job_list[2].len = sizeof(job_size); 	job_list[2].retadr = NULL;   & 	job_list[3].code = QUI$_ENTRY_NUMBER;$ 	job_list[3].bufadr = &entry_number;( 	job_list[3].len = sizeof(entry_number); 	job_list[3].retadr = NULL;   $ 	job_list[4].code = QUI$_JOB_STATUS;" 	job_list[4].bufadr = &job_status;& 	job_list[4].len = sizeof(job_status); 	job_list[4].retadr = NULL;   ) 	job_list[5].code = QUI$_SUBMISSION_TIME; & 	job_list[5].bufadr = submission_time;+ 	job_list[5].len = sizeof(submission_time);  	job_list[5].retadr = NULL;   & 	job_list[6].code = QUI$_SEARCH_FLAGS;$ 	job_list[6].bufadr = &search_flags;( 	job_list[6].len = sizeof(search_flags); 	job_list[6].retadr = NULL;    	job_list[7].code = 0; 	job_list[7].len = 0;   & 	search_flags = QUI$M_SEARCH_ALL_JOBS;  ; 	sts = sys$getquiw(0,QUI$_DISPLAY_JOB,0,job_list,iosb,0,0); B 	DEBUG(5,("getqui_entry: sts = %08X, iosb = %08X\n",sts,iosb[0]));4 	if ( (!(sts&1)) ||  (!(iosb[0]&1)) ) return(False);   	job_name[job_name_len] = '\0';  	username[username_len] = '\0';   = 	DEBUG(5,("              entry_number = %d\n",entry_number)); 9 	DEBUG(5,("              job_size     = %d\n",job_size)); = 	DEBUG(5,("              job_status   = %08X\n",job_status)); ; 	DEBUG(5,("              job_name     = {%s}\n",job_name)); ; 	DEBUG(5,("              username     = {%s}\n",username));    	buf->job = entry_number;  	buf->size = job_size * 512;J 	buf->status = (job_status & QUI$M_JOB_EXECUTING)?LPQ_PRINTING:LPQ_QUEUED; 	buf->time = time(NULL);1 	StrnCpy(buf->user,username,sizeof(buf->user)-1); 1 	StrnCpy(buf->file,job_name,sizeof(buf->file)-1);   + 	sts = sys$numtim(&timbuf,submission_time); 
 	if (sts&1) {  		struct tm tm;  		int i; 		 		i = timbuf.year / 100; 		i = timbuf.year - (i * 100); 		tm.tm_year = i;  		tm.tm_mon = timbuf.mon;  		tm.tm_mday = timbuf.mday;  		tm.tm_hour = timbuf.hour;  		tm.tm_min = timbuf.min;  		tm.tm_sec = timbuf.sec;  		buf->time = mktime(&tm);I /*		buf->time += GMT_TO_LOCAL*TimeDiff(buf->time); /* have to fix this */  	}   	return(True); }    /*+  * statfs - return mounted file system info   */    #include <sys/vfs.h>  : int VMSMakeFilename(char * __vms_buf, char * __file_spec);  . int vms_statfs(char *path, struct statfs *buf) {  	unsigned long iosb[2];  	struct itm_list_3 dvi_itm[4]; 	unsigned long sts;  	char name[256]; 	struct dsc$descriptor dev;   " 	sts = VMSMakeFilename(name,path);G DEBUG (3,("vms_statfs: path = \"%s\", vms_file = \"%s\"\n",path,name));  	if (sts < 0) { 4 		DEBUG (0,("vms_statfs: VMSMakeFilename ERROR\n"));
 		return(-1);  	}  ! 	dvi_itm[0].code = DVI$_MAXBLOCK;  	dvi_itm[0].len = 4;7 	dvi_itm[0].bufadr = &buf->f_blocks;	/* total blocks */  	dvi_itm[0].retadr = NULL;  # 	dvi_itm[1].code = DVI$_FREEBLOCKS;  	dvi_itm[1].len = 4;5 	dvi_itm[1].bufadr = &buf->f_bfree;	/* free blocks */  	dvi_itm[1].retadr = NULL;  ! 	dvi_itm[2].code = DVI$_MAXFILES;  	dvi_itm[2].len = 4;D 	dvi_itm[2].bufadr = &buf->f_files;	/* total files in file system */ 	dvi_itm[2].retadr = NULL;   	dvi_itm[3].code = 0;  	dvi_itm[3].len = 0;   	dev.dsc$a_pointer = name;. 	dev.dsc$w_length = strlen(dev.dsc$a_pointer);! 	dev.dsc$b_class = DSC$K_CLASS_S; ! 	dev.dsc$b_dtype = DSC$K_DTYPE_T;   0 	sts = sys$getdvi(0,0,&dev,&dvi_itm,iosb,0,0,0);& 	if ( (!(sts&1)) || (!(iosb[0]&1)) ) {C 		DEBUG (0,("vms_statfs: $GETDVI ERROR: sts = %08X, iosb = %08X\n",  			sts,iosb[0])); 
 		return(-1);  	} 	  	buf->f_type = 0; ' 	buf->f_bsize = 512;		/* unsupported */ F 	buf->f_bavail = buf->f_bfree;	/* avaiable blocks to non-super-user */2 	buf->f_ffree = -1;		/* free files, unsupported *// DEBUG (4,("   f_blocks = %d\n",buf->f_blocks)); - DEBUG (4,("   f_bfree = %d\n",buf->f_bfree)); - DEBUG (4,("   f_files = %d\n",buf->f_files));  	return(0);  }    /*  * setgroups - dummy  */   . int vms_setgroups(int ngroups, gid_t gidset[]) {  	return(0);  }      /*  * waitpid (T.B.S.)   */ 4 pid_t vms_waitpid(pid_t pid, int *stat, int options) {  	return(0);  }    /*  * rmdir  *C  * Get the VMS directory filespec and delete the <path>.DIR;1 file.   */  int vms_rmdir (char *path) {  	char buf[256]; 	 	int sts;   " 	sts = VMSMakeFilename(buf, path); 	if (sts <= 0) { 		errno = ENOTDIR;
 		return(-1);  	} 	strcat(buf,";1");, 	DEBUG(3,("Deleting directory {%s}\n",buf)); 	sts = delete(buf);  	if (sts < 0) { I 		DEBUG(3,("rmdir: errno = %d, vaxc$errno = %08X\n",errno,vaxc$errno));		  		if (errno == EVMSERR) { 3 			if (vaxc$errno == 0x0001C032) errno = ENOTEMPTY;  		} 
 		return(-1);  	} 	return(0);  }    /*  * ftruncateG  * (SAMBA only !? does it ever really shorten a file? - we only support   * extension for now...)  */     int vms_ftruncate(int f,off_t l) {  /*3  * I believe that lseek does extension correctly...   */  	if(lseek(f, l, SEEK_SET) != l) 
 		return(-1);  	return(0);  }    #ifndef __DECC  #define decc$to_vms shell$to_vms #endif  " int decc$to_vms(char * __unixfile,: 		void (* __action_routine)(char * __vmsfile, int __type),% 		int __wild_flag,int __no_dir_flag);    static char vms_file[256]; static int vms_file_type;   1 static void vms_action_routine(char *s, int type)  {  	vms_file_type = type; 	strcpy(vms_file,s); }   % char *cvt_file_to_vms(char *unixfile)  { $ 	if (unixfile == NULL) return(NULL); 	strcpy(vms_file, unixfile);1 	decc$to_vms(unixfile, vms_action_routine, 0, 1);  	return(vms_file); }    /*	  * system   *J  * This version of the system() call tries to detect an output redirectionE  * in the UNIX compatible command and if found, spawns the subprocess 2  * with SYS$OUTPUT assigned to the specified path.  *A  * Input redirection is not supported - SYS$INPUT is set to NLA0:   */ # int vms_system(const char *cmdline)  {  	char buf[256];  	$DESCRIPTOR(in,"NLA0:");  	$DESCRIPTOR(out,"SYS$OUTPUT");  	$DESCRIPTOR(cmd,"");  	unsigned long sts;  	unsigned long compl; 
 	char *p, *q;    	strcpy(buf,cmdline);  	cmd.dsc$a_pointer = buf; ) 	if (buf[0] == '\"') cmd.dsc$a_pointer++; ? 	if (buf[strlen(buf) - 1] == '\"') buf[strlen(buf) - 1] = '\0'; $ 	p = strrchr(cmd.dsc$a_pointer,'>'); 	if (p != NULL) { 0 		for (q = p + 1; *q == ' ' && *q != '\0'; q++);) 		out.dsc$a_pointer = cvt_file_to_vms(q); 3 		if (strcmp(out.dsc$a_pointer,"/dev/null") == 0) { ( 			out.dsc$a_pointer = in.dsc$a_pointer; 		} 3 		if (p != cmd.dsc$a_pointer && *(p-1) == '>') p--;  		*p = '\0'; 	}. 	cmd.dsc$w_length = strlen(cmd.dsc$a_pointer);. 	out.dsc$w_length = strlen(out.dsc$a_pointer);9 	sts = lib$spawn(&cmd,&in,&out,0,0,0,&compl,0,0,0,0,0,0); N DEBUG(5,("system: {%s}, output: {%s}\n",cmd.dsc$a_pointer,out.dsc$a_pointer));: DEBUG(5,("        sts = %08X, compl = %08X\n",sts,compl)); 	if (!(sts&1)) return(127);  	return((int)compl); }     ! /* ===== TCP/IP routines ===== */  /*%  * We support UCX and SOCKETSHR here.   */    /*  * get_tcpip_package  *9  * Since the SOCKETSHR V0.9 does not support setsockopt() H  * and connection to a server socket, we have to implement the differentE  * code here. The how-to is from NETLIB V2. When SOCKETSHR eventually C  * supports NETLIB V2, the following routines will become obsolete.   *E  * We support 3 different interfaces here: UCX, CMUIP and the SRI qio *  * interface (MultiNet, Pathway, TCPware).  */  #define TCPIP_UCX 1  #define TCPIP_CMU 2 1 #define TCPIP_SRI 3	/* if not one of the above */    int get_tcpip_package()  { 	 	char *p;    	p = getenv("SOCKETSHR");  	if (strstr(p,"NETLIB")) { 		p = getenv("NETLIB_SHR");  	} 	if (p == NULL) return(-1); & 	DEBUG(3,("Package logical: %s\n",p));( 	if (strstr(p,"UCX")) return(TCPIP_UCX);- 	else if (strstr(p,"CMU")) return(TCPIP_CMU);  	else return(TCPIP_SRI); }    #ifndef SOCKETSHR 
 #ifdef __DECC  #define get_sdc decc$get_sdc #else  #define get_sdc vaxc$get_sdc #endif #endif   /*  * UCX definitions  */  #include <ucx$inetdef.h>   /*  * CMU definitions  */  #define IO__OPEN IO$_CREATE  #define CMU_K_PROTO_TCP	0 7 #define word_swap(x) ((((x)>>8)&0xff)|(((x)&0xff)<<8 ))    /*3  * SRI qio definitions (MultiNet, Pathway, TCPware)   */  #define IO$S_FCODE	67 #define IO$_SETSOCKOPT	(IO$_ACCESS | (5 << IO$S_FCODE))    /*
  * setsockopt   */ S int vms_setsockopt (int sd, int level, int optname, const char *optval, int optlen)  { 
 	int package; " 	int ef;			/* Event flag number */' 	int sdc;			/* Socket device channel */ / 	unsigned short fun; 	/* Qiow function code  */ . 	unsigned short iosb[4];	/* Io status block */ 	struct itm_list_2 sockopt; F 	struct itm_list_2 opt_list; /* Qiow setsockopt commands descriptor */ 	int status; 	int get_sdc(int __fd);    	if (optval == NULL) { 		errno = EFAULT; 
 		return(-1);  	} /*  (  * Get the socket device channel number.  */  	sdc = get_sdc(sd);  	if (sdc == 0) {% 	/* Not an open socket descriptor. */  		errno = EBADF; 		return (-1); 	} /*    * Get an event flag for qio  */  	status = lib$get_ef(&ef); 	if (!(status&1)) { ' 		ef = 0;		/* No ef available. Use 0 */  	}   	package = get_tcpip_package(); 0 	DEBUG(3,("Used TCP/IP package: %d\n",package));   	switch(package) {   /*  7  * UCX	- Fill in opt descriptor and sockopt descriptor.   */  	case TCPIP_UCX:@ 		opt_list.code = (level == SOL_SOCKET) ? UCX$C_SOCKOPT : level;! 		opt_list.len = sizeof(sockopt);  		opt_list.bufadr = &sockopt;  		sockopt.code = optname;  		sockopt.len = optlen;  		sockopt.bufadr = optval;5 		status = sys$qiow(ef, sdc, IO$_SETMODE, iosb, 0, 0, " 		      0, 0, 0, 0, &opt_list, 0); 		break;   /*'  * CMU	- does not support any settings.   */  	case TCPIP_CMU:
 		status = 1;  		iosb[0] = 1; 		break;   /*4  * SRI	- the qio interface is more straight forward.  */  	case TCPIP_SRI:8 		status = sys$qiow(ef, sdc, IO$_SETSOCKOPT, iosb, 0, 0,. 		      level, optname, optval, optlen, 0, 0); 		break;  	 	default:  		errno = ENOTSOCK;  		status = lib$free_ef(&ef);
 		return(-1);  	} 	lib$free_ef(&ef); 	if (!(status&1)) { 3 		DEBUG(0,("setsockopt qio error: %08X\n",status));  		errno = EVMSERR; 		vaxc$errno = status;
 		return(-1);  	} 	if (!(iosb[0]&1)) {4 		DEBUG(0,("setsockopt I/O error: %08X\n",iosb[0])); 		errno = EVMSERR; 		vaxc$errno = iosb[0]; 
 		return(-1);  	} 	return(0);  }    /*	  * socket*  *B  * Here is the server support not included currently in SOCKETSHR.  */> #define TCPSRV 1275 int vms_socket (int af, int mess_type, int prot_type)  {N
 	int package; " 	int ef;			/* Event flag number */" 	int sd;			/* socket descriptor */ 	short int sdc1, sdc2;. 	unsigned short iosb[4];	/* Io status block */ 	int status;	 	struct {c 		unsigned short protocol; 		unsigned char  type; 		unsigned char  domain; 	} sockdef;i+ 	static $DESCRIPTOR(ucx_device, "SYS$NET");l- 	static $DESCRIPTOR(sri_device, "SYS$INPUT");  	int get_sdc(int __fd);;   	if (af != TCPSRV) {+ 		return(socket(af, mess_type, prot_type));  	} /* b  * Get an event flag for qio  */  	status = lib$get_ef(&ef); 	if (!(status&1)) {i' 		ef = 0;		/* No ef available. Use 0 */a 	} /*  * Allocate a socket.o  */t& 	sd = socket(AF_INET, SOCK_STREAM, 0); printf("sd = %d\n",sd);t 	if (sd < 0) return(-1); /* s(  * Get the socket device channel number.  */s 	sdc1 = get_sdc(sd); printf("sdc1 = %04X\n",sdc1);  	if (sdc1 == 0) {/% 	/* Not an open socket descriptor. */t 		close(sd); 		errno = EBADF; 		return (-1); 	}
 	sdc2 = 0;     	package = get_tcpip_package();; 	switch(package) { /* l0  * UCX	- connect to auxilliary server UCX$C_AUXS  */s 	case TCPIP_UCX:1 		sys$dassgn(sdc1);	/* replace channel connect */r0 		status = sys$assign(&ucx_device, &sdc2, 0, 0);3 printf("sdc2 = %04X, status = %08X\n",sdc2,status);t 		if (!(status&1)) break;  		sockdef.protocol = UCX$C_TCP;f& 		sockdef.type = INET_PROTYP$C_STREAM; 		sockdef.domain = UCX$C_AUXS;6 		status = sys$qiow(ef, sdc2, IO$_SETMODE, iosb, 0, 0, 			&sockdef, 0, 0, 0, 0, 0); printf("sts = %08X\n",status);  printf("iosb = %08X\n",iosb[0]); 		break;   /*  * CMU	- open port  */  	case TCPIP_CMU: 		sdc2 = sdc1;3 		status = sys$qiow(ef, sdc2, IO__OPEN, iosb, 0, 0, 6 /*    	    	    	0, 0, word_swap(sa->sin_w_port), /**/ 			0, 0, 0,+&     	    	    	0, CMU_K_PROTO_TCP, 0); 		break;   /*$  * SRI	- assign channel to SYS$INPUT  */C 	case TCPIP_SRI:1 		sys$dassgn(sdc1);	/* replace channel connect */r0 		status = sys$assign(&sri_device, &sdc2, 0, 0); 		break; /*  * Others not supported'  */p	 	default:	 		close(sd); 		errno = ENOTSOCK;  		lib$free_ef(&ef);&
 		return(-1);& 	} /*  * common exit handling'  */	 	lib$free_ef(&ef); 	if (sdc1 != sdc2) {> 		DEBUG(0,("socket not opened on same channel: %04X - %04X\n", 			sdc1, sdc2));
 		status = 2;c 	} 	if (!(status&1)) {e/ 		DEBUG(0,("socket qio error: %08X\n",status));X 		close(sd); 		errno = ENOTSOCK;f 		vaxc$errno = status;
 		return(-1);	 	} 	if (!(iosb[0]&1)) {0 		DEBUG(0,("socket I/O error: %08X\n",iosb[0])); 		close(sd); 		errno = ENOTSOCK;  		vaxc$errno = iosb[0];n
 		return(-1);	 	} 	return(sd); }      #ifdef SOCKETSHR   #if 0M #undef setsockopto /*
  * setsockopt   */rS int vms_setsockopt (int sd, int level, int optname, const char *optval, int optlen)i {u 	int i; 9 	i = setsockopt(get_sdc(sd),level,optname,optval,optlen); L DEBUG (2, ("setsockopt: errno = %d, vaxc$errno = %08X\n",errno,vaxc$errno)); 	return(i);e }  #endif   #else	/* means UCX */    #define F_GETFL 3" #define VMSOK(s) (s & 1)   /*  * fcntl  */  * Standard C RTL or UCX does not have fcntl().   *>  * This one is good for setting blocking state (FIONBIO) only.  */;* int vms_fcntl   (int fd, int cmd, int val) {0
     int argp; %     int ef;			/* Event flag number */ *     int sdc;			/* Socket device channel */2     unsigned short fun; 	/* Qiow function code  */1     unsigned short iosb[4];	/* Io status block */ /     char *p5, *p6;			/* Args p5 & p6 of qiow */I     struct comme     {q
 	int command;O 	char *addr;-     } ioctl_comm;		/* Qiow ioctl commands. */t     struct it2 e     {s 	unsigned short len; 	unsigned short opt; 	struct comm *addr; 7     } ioctl_desc;		/* Qiow ioctl commands descriptor */]     int status;      int get_sdc(int __fd);          /* t!      * Gets an event flag for qio0      */      status = lib$get_ef(&ef);      if (!VMSOK(status))t     {  	/* No ef available. Use 0 */E 	ef = 0;     }e       /* f,      * Get the socket device channel number.      */_     sdc = get_sdc(fd);     if (sdc == 0)      {l% 	/* Not an open socket descriptor. */e 	errno = EBADF;  	status = lib$free_ef(&ef);l
 	return (-1);u     };          /* ]       * Fill in ioctl descriptor.      */U!     ioctl_desc.opt = UCX$C_IOCTL;f)     ioctl_desc.len = sizeof(struct comm);s"     ioctl_desc.addr = &ioctl_comm;          /*  5      * Decide qio function code and in/out parameter.       */_     if (cmd == F_GETFL)C     {  /* 	fun = IO$_SENSEMODE;I 	p5 = 0; 	p6 = (char *) &ioctl_desc;D */ 	return(0);n     }s     else     {0 	fun = IO$_SETMODE;  	p5 = (char *) &ioctl_desc;0 	p6 = 0;     }l       /* B      * Fill in ioctl command.u      */nA     ioctl_comm.command = FIONBIO;	/* we only support this call */{$     ioctl_comm.addr = (char *)&argp;     if (val == 0) {u
 	argp = 0;     } else {
 	argp = 1;     }s          /* O      * Do ioctl.      */s/     status = sys$qiow(ef, sdc, fun, iosb, 0, 0,=+ 		      0, 0, 0, 0,		/* p1 - p4: not used*/t 		      p5, p6);          if (!VMSOK(status))u     {u2 DEBUG (0,("ioctl failed: status = %d\n", status)); 	errno = status; 	status = lib$free_ef(&ef);f
 	return (-1);x     }           if (!VMSOK(iosb[0]))     {_D DEBUG (0,("ioctl failed: status = %x, %x, %x%x\n", iosb[0], iosb[1], iosb[3], iosb[2]));t 	errno = iosb[0];]     	status = lib$free_ef(&ef);a
 	return (-1);      }           status = lib$free_ef(&ef);     return (0);  }s #endif	/* not SOCKETSHR */   /* TESTESTESTEST */iA int vms_getpeername (int sd, struct sockaddr *name, int *namelen)  {_
 	int package; " 	int ef;			/* Event flag number */' 	int sdc;			/* Socket device channel */l/ 	unsigned short fun; 	/* Qiow function code  */_. 	unsigned short iosb[4];	/* Io status block */ 	struct itm_list_3 rem_list; 	int status; 	int get_sdc(int __fd);t   /* u(  * Get the socket device channel number.  */Z 	sdc = get_sdc(sd);d 	if (sdc == 0) {% 	/* Not an open socket descriptor. */b 		errno = EBADF; 		return (-1); 	} /* d  * Get an event flag for qio  */] 	status = lib$get_ef(&ef); 	if (!(status&1)) {o' 		ef = 0;		/* No ef available. Use 0 */U 	}   	package = get_tcpip_package();A0 	DEBUG(3,("Used TCP/IP package: %d\n",package));4 Debug1("getpeername: sd = %d, sdc = %04X\n",sd,sdc);   	switch(package) {   /*  7  * UCX	- Fill in opt descriptor and sockopt descriptor.t  */  	case TCPIP_UCX: 		rem_list.code = 0;) 		rem_list.len = sizeof(struct sockaddr);l 		rem_list.bufadr = name;L) 		rem_list.retadr = (short int *)namelen; 7 		status = sys$qiow(ef, sdc, IO$_SENSEMODE, iosb, 0, 0,t" 		      0, 0, 0, &rem_list, 0, 0); 		break;   /*  * CMU  */  	case TCPIP_CMU:
 		status = 1;J 		iosb[0] = 1; 		break;   /*  * SRI  */, 	case TCPIP_SRI:
 		status = 1;( 		iosb[0] = 1;  	 	default:s 		errno = ENOTSOCK;0 		status = lib$free_ef(&ef);
 		return(-1);e 	} 	lib$free_ef(&ef);3 Debug1("sts = %08X, iosb = %08X\n",status,iosb[0]);\ 	if (!(status&1)) { 4 		DEBUG(0,("getpeername qio error: %08X\n",status)); 		errno = EVMSERR; 		vaxc$errno = status;
 		return(-1);B 	} 	if (!(iosb[0]&1)) {5 		DEBUG(0,("getpeername I/O error: %08X\n",iosb[0]));  		errno = EVMSERR; 		vaxc$errno = iosb[0];G
 		return(-1);  	}I Debug1("Addr: %08X\n",*(int *)&(((struct sockaddr_in *)name)->sin_addr));e 	return(0);  };      A /* ======= keyboard ========================================== */E   /*  * vms_read_keyboard  *E  * This routine has to read from keyboard and to check the socket forb1  * incoming data (see wait_keyboard in client.c).t  *F  * As we can't use select() for the keyboard we call the keyboard readB  * routine synchroneously. Before, a cyclic timer is started whichB  * checks the network. Note that the checking routine is called at@  * AST level. The only drawback is that there is a delay until a=  * network action is noticed, but this seems no problem here.G  *F  * To enable command line editing we use the SMG routines to read from  * keyboard.  *C  * I tried to strictly separate the VMS specific code from the base>H  * samba code. So this routine is in a common VMS support module but hasM  * a callback into the client.c. To avoid unresolved symbols with executablestH  * other than smbclient, the callback address is included as a parameter  * to vms_read_keyboard.  */a #include <smgdef.h>; #include <ssdef.h> #include <smg$routines.h>e  $ static unsigned long smg_kb_id = -1; static long time_bin[2];% char time_string[] = "0 00:00:01.01";u" $DESCRIPTOR(time_dsc,time_string); static char *smbbuffer;0% static void (* client_chk_routine)();f   void timer_ast(int reqid)  {i 	unsigned long sts;;1 	void vms_check_net(char * __buffer, int __flag);1  ( /*	DEBUG (3,("== timer AST ==\n")); /**/> 	(* client_chk_routine)(smbbuffer);	/* Callback to client.c */> 	sts = sys$setimr(0,time_bin,timer_ast,reqid,0);	/* restart */ }=  G int vms_read_keyboard(char *prompt, char *line, int size, char *buffer,; 		void (* chk_routine)() ) {i 	unsigned long sts;d 	int retlen;. 	struct dsc$descriptor_s dsc_line, dsc_prompt; 	struct dsc$descriptor_s *prm; 	void vms_exit_handler();d   	smbbuffer = buffer;" 	client_chk_routine = chk_routine; 	dsc_line.dsc$a_pointer = line;|" 	dsc_line.dsc$w_length = size - 1;& 	dsc_line.dsc$b_class = DSC$K_CLASS_S;& 	dsc_line.dsc$b_dtype = DSC$K_DTYPE_T; 	if (prompt == NULL) {
 		prm = NULL;  	} 	else { $ 		dsc_prompt.dsc$a_pointer = prompt;+ 		dsc_prompt.dsc$w_length = strlen(prompt);n) 		dsc_prompt.dsc$b_class = DSC$K_CLASS_S;e) 		dsc_prompt.dsc$b_dtype = DSC$K_DTYPE_T;c 		prm = &dsc_prompt; 	}   	if (smg_kb_id == -1) { 8 		sts = smg$create_virtual_keyboard(&smg_kb_id,0,0,0,0); 		if (!(sts&1)) {r> 			DEBUG (0,("can't create SMG keyboard - sts = %08X\n",sts)); 			return(-1); 		}g' 		sts = sys$bintim(&time_dsc,time_bin);* 		if (!(sts&1)) { 2 			DEBUG (0,("$BINTIM error - sts = %08X\n",sts)); 			return(-1); 		}) 	} /*  * Start cyclic timer.  */e, 	sts = sys$setimr(0,time_bin,timer_ast,1,0); 	if (!(sts&1)) {1 		DEBUG (0,("$SETIMR error - sts = %08X\n",sts)); 
 		return(-1);s 	} /*  * Read from keyboard.  */  	retlen = 0;2 	sts = smg$read_string(&smg_kb_id, &dsc_line, prm,& 				0, 0, 0, 0, &retlen, 0,0,0,0,0,0);+ 	*(dsc_line.dsc$a_pointer + retlen) = '\0';< /*2  * We got a command line. Cancel timer and return.  */r 	sys$cantim(1,0); " 	if (sts == SS$_NORMAL) return(0);! 	if (sts == SMG$_EOF) return(-1);E5 	DEBUG (0,("keyboard read error: sts = %08X\n",sts));  	return(-1); }e  