$!
$!      Makefile.com -- Command file to compile and link Xephem
$!
$!       Parameters:
$!          P1 = nothing, do a complete build and install
$!          P1 = INSTALL, just copy files to location pointed to by the
$!                        XEphem_Dir logical name.
$!
$!      A simple-minded command file to compile and link Xephem under
$!      OpenVMS VAX or Alpha and DECwindows MOTIF v1.1 or v1.2.
$!
$!      NOTE: You will need to choose one version of Motif to link with
$!      below by uncommenting the appropriate section of lines.
$!
$!      *** The default is for DEC C and Motif v1.2 ***
$!
$!      when            who                     what
$!
$!      2-feb-1992      Ethan VanMatre          original from unix makefile
$!      13-mar-1993     Max Calvani             updated for xephem v2.4.
$!      9-sep-1993      Elwood Downey           updated for xephem v2.5.
$!      9-jan-95        Bob Drucker             updated for new VMS compilers
$!      21-aug-95       Bob Drucker             updated for xephem 2.7.
$!      11-sep-95       Elwood Downey           updated for xephem 2.8.
$!      31-DEC-1995     Rick Dyson              added install options like MMS files
$!
$ On Control_Y Then GoTo FINISHED
$ On Error     Then GoTo FINISHED
$
$ If P1 .nes. "" Then GoTo 'P1'
$
$ Set Verify
$
$ CC /Optimize /NoDebug /NoList /Object aa_hadec
$ CC /Optimize /NoDebug /NoList /Object anomaly
$ CC /Optimize /NoDebug /NoList /Object calmenu
$ CC /Optimize /NoDebug /NoList /Object circum
$ CC /Optimize /NoDebug /NoList /Object closemenu
$ CC /Optimize /NoDebug /NoList /Object comet
$ CC /Optimize /NoDebug /NoList /Object compiler
$ CC /Optimize /NoDebug /NoList /Object constel
$ CC /Optimize /NoDebug /NoList /Object datamenu
$ CC /Optimize /NoDebug /NoList /Object db
$ CC /Optimize /NoDebug /NoList /Object dbmenu
$ CC /Optimize /NoDebug /NoList /Object earthmap
$ CC /Optimize /NoDebug /NoList /Object earthmenu
$ CC /Optimize /NoDebug /NoList /Object earthsat
$ CC /Optimize /NoDebug /NoList /Object eq_ecl
$ CC /Optimize /NoDebug /NoList /Object fits
$ CC /Optimize /NoDebug /NoList /Object formats
$ CC /Optimize /NoDebug /NoList /Object helpmenu
$ CC /Optimize /NoDebug /NoList /Object jupgrs
$ CC /Optimize /NoDebug /NoList /Object jupmenu
$ CC /Optimize /NoDebug /NoList /Object libration
$ CC /Optimize /NoDebug /NoList /Object listmenu
$ CC /Optimize /NoDebug /NoList /Object mainmenu
$ CC /Optimize /NoDebug /NoList /Object marsmenu
$ CC /Optimize /NoDebug /NoList /Object marsmap
$ CC /Optimize /NoDebug /NoList /Object misc
$ CC /Optimize /NoDebug /NoList /Object mjd
$ CC /Optimize /NoDebug /NoList /Object moon
$ CC /Optimize /NoDebug /NoList /Object mooncolong
$ CC /Optimize /NoDebug /NoList /Object moonmenu
$ CC /Optimize /NoDebug /NoList /Object moonnf
$ CC /Optimize /NoDebug /NoList /Object msgmenu
$ CC /Optimize /NoDebug /NoList /Object nutation
$ CC /Optimize /NoDebug /NoList /Object objmenu
$ CC /Optimize /NoDebug /NoList /Object obliq
$ CC /Optimize /NoDebug /NoList /Object parallax
$ CC /Optimize /NoDebug /NoList /Object pelement
$ CC /Optimize /NoDebug /NoList /Object plans
$ CC /Optimize /NoDebug /NoList /Object plot_aux
$ CC /Optimize /NoDebug /NoList /Object plotmenu
$ CC /Optimize /NoDebug /NoList /Object precess
$ CC /Optimize /NoDebug /NoList /Object preferences
$ CC /Optimize /NoDebug /NoList /Object progress
$ CC /Optimize /NoDebug /NoList /Object ps
$ CC /Optimize /NoDebug /NoList /Object query
$ CC /Optimize /NoDebug /NoList /Object reduce
$ CC /Optimize /NoDebug /NoList /Object refract
$ CC /Optimize /NoDebug /NoList /Object riset
$ CC /Optimize /NoDebug /NoList /Object riset_cir
$ CC /Optimize /NoDebug /NoList /Object satmenu
$ CC /Optimize /NoDebug /NoList /Object sites
$ CC /Optimize /NoDebug /NoList /Object skyhist
$ CC /Optimize /NoDebug /NoList /Object skylist
$ CC /Optimize /NoDebug /NoList /Object skyfiltmenu
$ CC /Optimize /NoDebug /NoList /Object skyviewmenu
$ CC /Optimize /NoDebug /NoList /Object solsysmenu
$ CC /Optimize /NoDebug /NoList /Object srchmenu
$ CC /Optimize /NoDebug /NoList /Object sun
$ CC /Optimize /NoDebug /NoList /Object time
$ CC /Optimize /NoDebug /NoList /Object trails
$ CC /Optimize /NoDebug /NoList /Object utc_gst
$ CC /Optimize /NoDebug /NoList /Object versionmenu
$ CC /Optimize /NoDebug /NoList /Object xephem
$ CC /Optimize /NoDebug /NoList /Object xmisc
$
$LINK:
$   Link /NoMap /NoDebug xephem,   -
                aa_hadec,   -
                anomaly,    -
                calmenu,    -
                circum,     -
                closemenu,  -
                comet,      -
                compiler,   -
                constel,    -
                datamenu,   -
                db,         -
                dbmenu,     -
                earthmap,   -
                earthmenu,  -
                earthsat,   -
                eq_ecl,     -
                fits,       -
                formats,    -
                helpmenu,   -
                jupgrs,     -
                jupmenu,    -
                libration,  -
                listmenu,   -
                mainmenu,   -
                marsmenu,   -
                marsmap,    -
                misc,       -
                mjd,        -
                moon,       -
                mooncolong, -
                moonmenu,   -
                moonnf,     -
                msgmenu,    -
                nutation,   -
                objmenu,    -
                obliq,      -
                parallax,   -
                pelement,   -
                plans,      -
                plot_aux,   -
                plotmenu,   -
                precess,    -
                preferences,-
                progress,   -
                ps,         -
                query,      -
                reduce,     -
                refract,    -
                riset,      -
                riset_cir,  -
                satmenu,    -
                sites,      -
                skyhist,    -
                skylist,    -
                skyfiltmenu,-
                skyviewmenu,-
                solsysmenu, -
                srchmenu,   -
                sun,        -
                time,       -
                trails,     -
                utc_gst,    -
                versionmenu,-
                xmisc,      -
$!  Choose only ONE of the two sections below to uncomment.
$!
$!  Libraries for Motif version 1.1
$!
Sys$Input/Option
Sys$Share:DECW$DXMLibShr/Share
Sys$Share:DECW$XMLibShr/Share
Sys$Share:DECW$XLibShr/Share
$!
$!  Libraries for Motif version 1.2
$!
$!Sys$Input/Option
$!Sys$Share:DECW$DXMLibShr12.exe /Share
$!Sys$Share:DECW$XMLibShr12.exe /Share
$!Sys$Share:DECW$XTLibShrr5.exe /Share
$!Sys$Share:DECW$XLibShr.exe /Share
$!  Wait! Even DEC C needs the next line...
$!Sys$Library:VAXCRTL.olb /Library
$
$ Library /Help /Create XEphem.hlb XEphem.vms-hlp
$
$ Set NoVerify
$
$ Purge /NoLog /NoConfirm
$
$INSTALL:
$   Set NoOn
$   If F$TrnLnm ("XEphem_Dir") .nes. ""
$       Then
$           Copy XEphem.exe,XEphem.hlb XEphem_Dir:
$           Copy [.edb]*.edb XEphem_Dir:
$           Copy [.edb]readme. XEphem_Dir:readme.edb
$           Copy [.auxil]readme. XEphem_Dir:readme.auxil
$           Copy [.auxil]* XEphem_Dir:
$           Delete /NoConfirm /NoLog XEphem_Dir:readme.;*
$           Set Protection = World:RE XEphem_Dir:*.*
$           Copy XEphem.vms-ad DECW$System_Defaults:xephem.dat
$       Else
$           Write Sys$Output "You need to define XEphem_Dir and re-run with the INSTALL parameter!"
$   EndIf
$
$FINISHED:
$   Set NoVerify
$   Exit
