# A MMS (or the FreeWare MMS clone by Matt Madison, MMK) Description for xephem
#
# For an Alpha or a VAX using DEC C, use the following command line execution:
#
#   MMS /Description = Makefile.mms /Macro = ("DECC=1")
#
#   This assumes you are using Motif v1.2.
#
# For a VAX with VAX C, use the following command line execution (the default):
#
#       MMS /Description = Makefile.mms
#
#       This assumes you are using Motif v1.1.  Change the OPTS file to the
#       DECC version below if you have Motif v1.2 with VAX C.  Don't use the
#       Macro method to select the XEphem_DECC.opt file.
#
#   Rick Dyson  (dyson@iowasp.physics.uiowa.edu)
#   Created: 25-MAY-1995
#   Last Modified: 13-AUG-1995 for XEphem v2.7
#                  31-DEC-1995 for XEphem v2.8

# Modify the destination directory to your local tastes...
Install_Dir = XEphem_Dir:

LINKFLAGS = $(LINKFLAGS) /NoDebug
.ifdef DECC
OPTS = Sys$Disk:[]XEphem_DECC.opt
.else
OPTS = Sys$Disk:[]XEphem_VAXC.opt
.endif
CFLAGS = $(CFLAGS) /Optimize /NoDebug

OBJS =	aa_hadec.obj anomaly.obj calmenu.obj circum.obj closemenu.obj \
	comet.obj compiler.obj constel.obj datamenu.obj db.obj dbmenu.obj \
	earthmap.obj earthmenu.obj earthsat.obj eq_ecl.obj fits.obj \
	formats.obj helpmenu.obj jupgrs.obj jupmenu.obj libration.obj \
	listmenu.obj mainmenu.obj marsmap.obj marsmenu.obj misc.obj mjd.obj \
	moon.obj mooncolong.obj moonmenu.obj moonnf.obj msgmenu.obj \
	nutation.obj objmenu.obj obliq.obj parallax.obj pelement.obj plans.obj \
	plot_aux.obj plotmenu.obj precess.obj preferences.obj progress.obj \
	ps.obj query.obj reduce.obj refract.obj riset.obj riset_cir.obj \
	satmenu.obj sites.obj skyhist.obj skylist.obj skyfiltmenu.obj \
	skyviewmenu.obj solsysmenu.obj srchmenu.obj sun.obj time.obj \
	trails.obj utc_gst.obj versionmenu.obj xephem.obj xmisc.obj

OLST =	aa_hadec.obj,anomaly.obj,calmenu.obj,circum.obj,closemenu.obj,\
	comet.obj,compiler.obj,constel.obj,datamenu.obj,db.obj,dbmenu.obj,\
	earthmap.obj,earthmenu.obj,earthsat.obj,eq_ecl.obj,fits.obj,\
	formats.obj,helpmenu.obj,jupgrs.obj,jupmenu.obj,libration.obj,\
	listmenu.obj,mainmenu.obj,marsmap.obj,marsmenu.obj,misc.obj,mjd.obj,\
	moon.obj,mooncolong.obj,moonmenu.obj,moonnf.obj,msgmenu.obj,\
	nutation.obj,objmenu.obj,obliq.obj,parallax.obj,pelement.obj,plans.obj,\
	plot_aux.obj,plotmenu.obj,precess.obj,preferences.obj,progress.obj,\
	ps.obj,query.obj,reduce.obj,refract.obj,riset.obj,riset_cir.obj,\
	satmenu.obj,sites.obj,skyhist.obj,skylist.obj,skyfiltmenu.obj,\
	skyviewmenu.obj,solsysmenu.obj,srchmenu.obj,sun.obj,time.obj,\
	trails.obj,utc_gst.obj,versionmenu.obj,xephem.obj,xmisc.obj

.first
.ifdef DECC
	@- Define /NoLog Sys DECC$Library_Include
.else
	@- Define /NoLog Sys Sys$Library
.endif

all :   xephem help
        @ Write Sys$Output "Finished Building XEphem!!!"

xephem.exe : $(OBJS) $(OPTS)
	$(LINK) $(LINKFLAGS) $(OLST),$(OPTS)/Option

xephem :	xephem.exe
        @ Continue

help :
	@ If F$Search ("xephem.hlb") .eqs. "" Then Library /Help /Create xephem.hlb xephem.vms-hlp

clean :
	@- Purge /NoConfirm
	@- Delete /NoConfirm *.obj;*,*.hlb;,*.exe;

install :	all
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Copy xephem.exe $(Install_Dir)
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Copy xephem.hlb $(Install_Dir)
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Copy xephem.VMS-ad DECW$System_Defaults:xephem.dat
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Copy [.edb]*.edb $(Install_Dir)
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Rename $(Install_Dir)Readme. $(Install_Dir)Readme.edb
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Copy [.auxil]*.* $(Install_Dir)
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Rename $(Install_Dir)Readme. $(Install_Dir)Readme.auxil
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Set Protection = (Owner:RWE, World:RE) $(Install_Dir)*.*
        @- Write Sys$Output ""
	@- If (F$TrnLnm ("$(Install_Dir)") .eqs. "") Then Write Sys$Output \
        "You need to define XEphem_Dir to somewhere before trying to install it!!!"
	@- If (F$TrnLnm ("$(Install_Dir)") .nes. "") Then Write Sys$Output \
	"Finished installing XEphem in $(Install_Dir)"

.ifdef DECC
ps.obj :	ps.c
	$(CC) $(CFLAGS) /Standard = VAXC ps.c
#.else
#	$(CC) $(CFLAGS) ps.c
.endif

#  especially worth having this dependency so the version stays current.
versionmenu.obj :	patchlevel.h
#
#  Build the linker options file for OpenVMS DEC C or VAX C.
#
Sys$Disk:[]XEphem_DECC.opt :
        @ Open /Write TMP XEphem_DECC.opt
        @ Write TMP "! XEphem (v2.8) Linker Options list for VMS DEC C"
        @ Write TMP "! This assumes Motif v1.2"
        @ Write TMP "Sys$Library:DECW$DXMLibShr12.exe /Share"
        @ Write TMP "Sys$Library:DECW$XMLibShr12.exe /Share"
        @ Write TMP "Sys$Library:DECW$XTLibShrR5.exe /Share"
        @ Write TMP "Sys$Library:DECW$XLibShr.exe /Share"
        @ Write TMP "Sys$Library:VAXCRTL.OLB /Library"
        @ Close TMP

Sys$Disk:[]XEphem_VAXC.opt :
        @ Open /Write TMP XEphem_VAXC.opt
        @ Write TMP "! XEphem (v2.8) Linker Options list for VMS VAX C"
        @ Write TMP "! This assumes Motif v1.1"
        @ Write TMP "Sys$Library:DECW$DXMLibShr.exe /Share"
        @ Write TMP "Sys$Library:DECW$XMLibShr.exe /Share"
        @ Write TMP "Sys$Library:DECW$XLibShr.exe /Share"
        @ Write TMP "Sys$Library:VAXCRTL.exe /Share"
        @ Close TMP
