/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : april 1995
 *
 *  Purpose    : query HTTP-server for access to VMS filename
 *
 *  Modified   : may 1995
 *               Parameterized userdir string.
 *
 *  Modified   : january 1996
 *               Add check_url_access which use URL syntax and
 *               cgi_translate_path.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <socket.h>
#include <netdb.h>

#include <unixio.h>
#include <errno.h>

#include "cgilib.h"

#define userdir1 "/WWW/"
#define userdir2 "/www/"

int test_head(char *hostname,int port,char *fnm)
{
   int sd,status,len,tmp,ok;
   char cmd[512],resp[512];
   struct sockaddr local,remote;
   struct hostent *hostinfo;
   ok=0;
   /* create socket */
   sd=socket(AF_INET,SOCK_STREAM,0);
   if(sd<0) {
      printf("Error creating socket: %s\n",strerror(errno));
      goto fin;
   }
   /* bind socket */
   local.sa_family=AF_INET;
   memset(local.sa_data,0,sizeof(local.sa_data));
   status=bind(sd,&local,sizeof(local));
   if(status<0) {
      printf("Error binding socket: %s\n",strerror(errno));
      goto fin;
   }
   /* lookup host */
   hostinfo=gethostbyname(hostname);
   if(!hostinfo) {
      printf("Error looking up host: %s\n",hostname);
      goto fin;
   }
   /* connect to host */
   remote.sa_family=hostinfo->h_addrtype;
   memcpy(remote.sa_data+2,hostinfo->h_addr_list[0],hostinfo->h_length);
   *((short *)remote.sa_data)=port;
   tmp=remote.sa_data[0];
   remote.sa_data[0]=remote.sa_data[1];
   remote.sa_data[1]=tmp;
   status=connect(sd,&remote,sizeof(remote));
   if(status!=0) {
      printf("Error connecting to host: %s port: %d\n",hostname,port);
      goto fin;
   }
   /* send HEAD request */
   sprintf(cmd,"HEAD %s HTTP/1.0\r\n\r\n",fnm);
   status=send(sd,cmd,strlen(cmd),0);
   if(status<0) {
      printf("Error sending HEAD request\n");
      goto fin;
   }
   /* read response */
   while ((len=recv(sd,resp,sizeof(resp)-1,0))>0) {
      resp[len-1]='\0';
      if(strstr(resp,"HTTP/1.0 200")!=NULL) ok=1;
   }
fin:
   close(sd);
   return ok;
}

int ok;
char servername[81];
int serverport;

int doit(char *unixfnm)
{
   char userdir[256],*p1,*p2;
   ok=0;
   /* test normal form */
   if(test_head(servername,serverport,unixfnm)) ok=1;
   if(ok) return 1;
   /* test user dir */
   strcpy(userdir,"/~");
   p2=userdir+2;
   p1=unixfnm+1;
   while(*p1!='/') p1++;
   p1++;
   while(*p1!='/') { *p2=(*p1); p1++; p2++; }
   if((strstr(p1,userdir1)==p1)||(strstr(p1,userdir2)==p1)) {
      p1=p1+4;
      strcpy(p2,p1);
      if(test_head(servername,serverport,userdir)) ok=1;
   }
   return 1;
}

#ifdef VAXC
int shell$from_vms();
#else
int decc$from_vms();
#endif

int check_access(char *vmsfnm)
{
   /* get server name and port */
   strcpy(servername,cgi_info("SERVER_NAME"));
   serverport=atoi(cgi_info("SERVER_PORT"));
   ok=0;
   /* call action routine with translated names */
#ifdef VAXC
   shell$from_vms(vmsfnm,doit,0);
#else
   decc$from_vms(vmsfnm,doit,0);
#endif
   return ok;
}

int check_url_access(char *url)
{
   FILE *fp;
   int ok,stat,l;
   char tmp[1024];
   stat=cgi_translate_path(url,1,tmp,sizeof(tmp)-1,&l);
   tmp[l]=0;
   if(stat&&(l>0)) {
      fp=fopen(tmp,"rb","ctx=stm");
      if(fp!=NULL) {
         ok=1;
         fclose(fp);
      } else {
         ok=0;
      }
   } else {
      ok=0;
   }
   return ok;
}
