/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : april 1995
 *
 *  Purpose    : Q & A test
 *
 *  Modified   : april 1995
 *               Added a SECURE option (which is default on), that will
 *               only use files in a WWW-subdirectory.
 *
 *               april 1995
 *               Changed check to use generic check_access function.
 *
 *               september 1995
 *               Test for REQUEST_METHOD HEAD.
 *
 *               february 1996
 *               Include stdlib.h to compile with DEC C.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "cgilib.h"

int check_access();

main(int argc,char *argv[])
{
   FILE *fp;
   int n;
   char *fnm,q[51],*p;
   cgi_init(argc,argv);
   fnm=cgi_info("PATH_INFO");
   fnm++;
   cgi_printf("content-type: text/html\n\n");
   if(strcmp(cgi_info("REQUEST_METHOD"),"HEAD")==0) exit(1);
   cgi_printf("<HTML>\n");
   cgi_printf("<HEAD>\n");
   cgi_printf("<TITLE>%s</TITLE>\n",fnm);
   cgi_printf("</HEAD>\n");
   cgi_printf("<BODY>\n");
   /* open file */
   if(!check_access(fnm)) {
      cgi_printf("No access to file: %s\n",fnm);
      goto fin;
   }
   fp=fopen(fnm,"r");
   if(fp==NULL) {
       cgi_printf("Can not open file: %s\n",fnm);
       goto fin;
   }
   /* create form */
   cgi_printf("<FORM METHOD=\"POST\" ACTION=\"/htbin/qa2.exe/%s\">\n",fnm);
   cgi_printf("<PRE>\n");
   n=0;
   while(!feof(fp)) {
      fgets(q,sizeof(q),fp);
      p=strstr(q,"#");
      if(p!=NULL) {
         *p='\0';
         n++;
         cgi_printf("%s: <INPUT TYPE=\"TEXT\" SIZE=20 NAME=\"q%d\">\n",q,n);
      }
   }
   cgi_printf("</PRE>\n");
   cgi_printf("<INPUT TYPE=\"SUBMIT\" VALUE=\"Press return to submit\">\n");
   cgi_printf("</FORM>\n");
   fclose(fp);
fin:
   cgi_printf("</BODY>\n");
   cgi_printf("</HTML>\n");
}
