 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %              AAA   N   N  IIIII  M   M   AAA   TTTTT  EEEEE                 % O %             A   A  NN  N    I    MM MM  A   A    T    E                     % O %             AAAAA  N N N    I    M M M  AAAAA    T    EEE                   % O %             A   A  N  NN    I    M   M  A   A    T    E                     % O %             A   A  N   N  IIIII  M   M  A   A    T    EEEEE                 % O %                                                                             % O %                                                                             % O %          Animate Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Animate displays a sequence of images in the MIFF format on anyI %  workstation display running an X server.  Animate first determines the E %  hardware capabilities of the workstation.  If the number of unique I %  colors in an image is less than or equal to the number the workstation E %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Animate program command syntax is:  % > %  Usage: animate [options ...] file [ [options ...] file ...] %  %  Where options include: > %    -backdrop            display image centered on a backdrop+ %    -colormap type       Shared or Private A %    -colors value        preferred number of colors in the image I %    -colorspace type     GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV J %    -crop geometry       preferred size and location of the cropped image> %    -delay milliseconds  display the next image after pausingF %    -density geometry    vertical and horizontal density of the image8 %    -display server      display image to this X serverH %    -dither              apply Floyd/Steinberg error diffusion to image3 %    -gamma value         level of gamma correction I %    -geometry geometry   preferred size and location of the Image window . %    -interlace type      NONE, LINE, or PLANED %    -map type            display image using this Standard ColormapB %    -matte               store matte channel if the image has one< %    -monochrome          transform image to black and white, %    -scene value         image scene number3 %    -size geometry       width and height of image @ %    -treedepth value     depth of the color classification treeD %    -verbose             print detailed information about the image> %    -visual type         display image using this visual typeD %    -window id           display image to background of this window % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, C %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -name, * %  -mattecolor, -shared_memory, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForA %  example, specify +compress to store the image as uncompressed.  % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 9 %    Press any button to map or unmap the Command widget.  %  %  Keyboard accelerators: 1 %    p    press to animate the sequence of images 9 %    s    press to display the next image in the sequence = %    .    press to continually display the sequence of images ? %    a    press to automatically reverse the sequence of images 1 %    <    press to slow the display of the images 5 %    >    press to speed-up the display of the images 3 %    f    press to animate in the forward direction 3 %    r    press to animate in the reverse direction 6 %    i    press to display information about the image6 %    q    press to discard all images and exit program %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "animate.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % A %    o terminate: The program will exit if the value is not zero.  %  %  */ static void Usage(terminate) unsigned int   terminate; {    char     **p;  
   static char      *buttons[]=      { <       "Press any button to map or unmap the Command widget",       (char *) NULL      },     *keys[]=     { 0       "0-9  press to change the level of delay",5       "p    press to animate the sequence of images", =       "s    press to display the next image in the sequence", A       ".    press to continually display the sequence of images", C       "a    press to automatically reverse the sequence of images", 5       "<    press to slow the display of the images", 5       ">    press to speed-up the display of images", 7       "f    press to animate in the forward direction", 7       "r    press to animate in the reverse direction", :       "i    press to display information about the image",:       "q    press to discard all images and exit program",       (char *) NULL      },     *options[]=      { B       "-backdrop            display image centered on a backdrop",/       "-colormap type       Shared or Private", E       "-colors value        preferred number of colors in the image", M       "-colorspace type     GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", N       "-crop geometry       preferred size and location of the cropped image",B       "-delay milliseconds  display the next image after pausing",J       "-density geometry    vertical and horizontal density of the image",<       "-display server      display image to this X server",L       "-dither              apply Floyd/Steinberg error diffusion to image",7       "-gamma value         level of gamma correction", M       "-geometry geometry   preferred size and location of the Image window", 2       "-interlace type      NONE, LINE, or PLANE",F       "-matte               store matte channel if the image has one",H       "-map type            display image using this Standard Colormap",@       "-monochrome          transform image to black and white",0       "-scene value         image scene number",7       "-size geometry       width and height of image", D       "-treedepth value     depth of the color classification tree",H       "-verbose             print detailed information about the image",B       "-visual type         display image using this visual type",G       "-window id          display image to background of this window",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(J     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -name,\n");=   (void) printf("-mattecolor, -shared_memory, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(H     "example, specify +compress to store the image as uncompressed.\n");   (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p); /   (void) printf("\nKeyboard accelerators: \n"); (   for (p=keys; *p != (char *) NULL; p++)     (void) printf("  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n i m a t e B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XAnimateBackgroundImage animates an image sequence in the  %  background of a window. % 8 %  The format of the XAnimateBackgroundImage routine is: % ; %      XAnimateBackgroundImage(display,resource_info,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */ static int SceneCompare(x,y)
 const void   *x,    *y;  {    Image      **image_1,     **image_2;     image_1=(Image **) x;    image_2=(Image **) y; :   return((int) (*image_1)->scene-(int) (*image_2)->scene); }   O static void XAnimateBackgroundImage(display,resource_info,images,number_scenes)  Display    *display;   
 XResourceInfo    *resource_info;    Image    **images;    unsigned int   number_scenes; {    char     visual_type[MaxTextLength];      int      i,
     scene;     unsigned int     height,      status, 
     width;     Window     root_window;     XEvent
     event;     XGCValues      context_values;      XPixelInfo     pixel_info,      scene_info;      XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      XWindowAttributes      window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL; %   window_info.ximage=(XImage *) NULL; *   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL; "   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display)); :   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;    else     { -       if (isdigit(*resource_info->window_id)) 7         window_info.id=XWindowByID(display,root_window, O           (Window) strtol((char *) resource_info->window_id,(char **) NULL,0)); *       if (window_info.id == (Window) NULL)         window_info.id= F           XWindowByName(display,root_window,resource_info->window_id);*       if (window_info.id == (Window) NULL)M         Error("No window with specified id exists",resource_info->window_id);      }    /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)'     (void) sprintf(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual));    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) K     Error("Unable to create standard colormap","Memory allocation failed"); %   map_info->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL;    /*     Initialize visual info.    */(   resource_info->map_type=(char *) NULL;)   resource_info->visual_type=visual_type; >   visual_info=XBestVisualInfo(display,map_info,resource_info);*   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);    /*+     Sort images by increasing scene number.    */   i=0;/   for (scene=0; scene < number_scenes; scene++)      i+=images[scene]->scene;   if (i > 0)8     qsort((void *) images,number_scenes,sizeof(Image *),E       (int (*) _Declare((const void *, const void *))) SceneCompare); /   if (resource_info->map_type == (char *) NULL) ,     if ((visual_info->class != TrueColor) &&,         (visual_info->class != DirectColor))       {          unsigned int           identical_colormap;   
         /*I           Determine if the sequence of images has the identical colormap. 
         */          identical_colormap=True;5         for (scene=0; scene < number_scenes; scene++) 	         { 6           if ((images[scene]->class == DirectClass) ||C               (images[scene]->colors > visual_info->colormap_size)) 6             QuantizeImage(images[scene],(unsigned int)C               visual_info->colormap_size,resource_info->tree_depth, ?               resource_info->dither,resource_info->colorspace); 8           if (images[scene]->signature == (char *) NULL)-             ColormapSignature(images[scene]); G           status=strcmp(images[scene]->signature,images[0]->signature);            if (status != 0)%             identical_colormap=False; 	         }           if (!identical_colormap)<           QuantizeImages(images,number_scenes,(unsigned int)A             visual_info->colormap_size,resource_info->tree_depth, =             resource_info->dither,resource_info->colorspace);        }    /*!     Initialize Standard Colormap.    */)   resource_info->colormap=SharedColormap; M   XMakeStandardColormap(display,visual_info,resource_info,images[0],map_info,      &pixel_info);    /*     Graphic context superclass.    */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.    */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,       resource_info,&window_info);   /*     Create the X image.    */'   window_info.width=images[0]->columns; 3   if (window_info.width >= window_attributes.width) .     window_info.width=window_attributes.width;%   window_info.height=images[0]->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;A   status=XMakeImage(display,resource_info,&window_info,images[0], (     images[0]->columns,images[0]->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   window_info.x=0;   window_info.y=0;   if (resource_info->debug)      { G       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",images[0]->filename, =         images[0]->scene,images[0]->columns,images[0]->rows); !       if (images[0]->colors != 0) 8         (void) fprintf(stderr,"%uc ",images[0]->colors);6       (void) fprintf(stderr,"%s\n",images[0]->magick);     }    /*I     Adjust image dimensions as specified by backdrop or geometry options.    */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {        /*         Center image on window.        */3       window_info.x=(window_attributes.width >> 1)- )         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 5   if (resource_info->image_geometry != (char *) NULL)      { 
       char(         default_geometry[MaxTextLength];  	       int          flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints(); ,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry, J         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity); $       if (flags & (XValue | YValue))	         { (           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);      }    /*     Create the X pixmap.   */   window_info.pixmap= I     XCreatePixmap(display,window_info.id,width,height,window_info.depth); *   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);    /*!     Display pixmap on the window.    */C   if ((width > window_info.width) || (height > window_info.height)) K     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,        0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,      window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);    /*'     Initialize image pixmaps structure.    */F   window_info.pixmaps=(Pixmap *) malloc(number_scenes*sizeof(Pixmap));-   if (window_info.pixmaps == (Pixmap *) NULL) A     Error("Unable to animate images","Memory allocation failed"); ,   window_info.pixmaps[0]=window_info.pixmap;+   scene_info.pixels=(unsigned long *) NULL; '   scene_info.gamma_map=(XColor *) NULL; /   for (scene=1; scene < number_scenes; scene++)    {      /*       Create X image.      */%     window_info.pixmap=(Pixmap) NULL; 5     if ((resource_info->map_type != (char *) NULL) || ,         (visual_info->class == TrueColor) ||,         (visual_info->class == DirectColor)).       if (images[scene]->class == PseudoClass)	         {            /**             Get pixel info for this scene.           */C           XGetPixelInfo(display,visual_info,map_info,resource_info, '             images[scene],&scene_info); /           window_info.pixel_info=(&scene_info); 	         } G     status=XMakeImage(display,resource_info,&window_info,images[scene], 2       images[scene]->columns,images[scene]->rows);     /*       Create the X pixmap.     */     window_info.pixmap= K       XCreatePixmap(display,window_info.id,width,height,window_info.depth); ,     if (window_info.pixmap == (Pixmap) NULL)7       Error("Unable to create X pixmap",(char *) NULL);      /*       Create the X pixmap.     */E     if ((width > window_info.width) || (height > window_info.height)) M       XFillRectangle(display,window_info.pixmap,window_info.annotate_context,          0,0,width,height);F     XPutImage(display,window_info.pixmap,window_info.annotate_context,K       window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,        window_info.height);J     XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);)     XClearWindow(display,window_info.id);      if (resource_info->debug)        { K         (void) fprintf(stderr,"Image: [%u] %s %ux%u ",images[scene]->scene, N           images[scene]->filename,images[scene]->columns,images[scene]->rows);'         if (images[scene]->colors != 0) >           (void) fprintf(stderr,"%uc ",images[scene]->colors);<         (void) fprintf(stderr,"%s\n",images[scene]->magick);       } 2     window_info.pixmaps[scene]=window_info.pixmap;     /*       Free image pixels.     */)     free((char *) images[scene]->pixels); 3     images[scene]->pixels=(RunlengthPacket *) NULL;    }    /*!     Display pixmap on the window.    */;   XSelectInput(display,window_info.id,StructureNotifyMask);    event.type=Expose;   do   { 1     for (scene=0; scene < number_scenes; scene++)      { 6       if (XEventsQueued(display,QueuedAfterFlush) > 0)	         { %           XNextEvent(display,&event); *           if (event.type == DestroyNotify)             break;	         } 4       window_info.pixmap=window_info.pixmaps[scene];L       XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);+       XClearWindow(display,window_info.id);        XSync(display,False); $       if (resource_info->delay != 0)=         XDelay(display,(unsigned long) resource_info->delay);      } (   } while (event.type != DestroyNotify);   /*     Free resources.    *//   for (scene=0; scene < number_scenes; scene++)    { 4     XFreePixmap(display,window_info.pixmaps[scene]);      DestroyImage(images[scene]);   } %   free((char *) window_info.pixmaps); $   XDestroyImage(window_info.ximage);B   XFreeStandardColormap(display,visual_info,map_info,&pixel_info);.   XFreeGC(display,window_info.widget_context);1   XFreeGC(display,window_info.highlight_context); 0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor);    XFree((void *) map_info);    XFree((void *) visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n i m a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 4 %  Function XAnimateImage displays an image via X11. % . %  The format of the XAnimateImage routine is: % I %      XAnimateImage(display,resource_info,argv,argc,image,number_scenes)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % 7 %    o argv: Specifies the application's argument list.  % / %    o argc: Specifies the number of arguments.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  % @ %    o number_scenes: Specifies the number of scenes to animate. %  %  */O static void XAnimateImage(display,resource_info,argv,argc,images,number_scenes)  Display    *display;   
 XResourceInfo    *resource_info;    char	   **argv;    int    argc;    Image    **images;    unsigned int   number_scenes; {  #define MaxWindows  9  #define MenuTitle  "Commands"  #define NumberMenus  3  
   static char      *CommandMenu[]=      {        "Animate",       "Speed",       "Direction",       "Image Info", 
       "Help", 
       "Quit",        (char *) NULL      },     *AnimateMenu[]=      { 
       "Play", 
       "Step",        "Repeat",        "AutoReverse",       (char *) NULL      },     *SpeedMenu[]=      {        "Faster",        "Slower",        (char *) NULL      },     *DirectionMenu[]=      {        "Forward",       "Reverse",       (char *) NULL      };  
   static char      **Menus[NumberMenus]=      {        AnimateMenu,       SpeedMenu,       DirectionMenu      };     static KeySym      CommandKeys[]=     {        XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_i,        XK_h, 
       XK_q     },     AnimateKeys[]=     {        XK_p,        XK_s,        XK_period,
       XK_a     },     SpeedKeys[]=     {        XK_greater, 
       XK_less      },     DirectionKeys[]=     {        XK_f, 
       XK_r     };     static KeySym      *Keys[NumberMenus]=      {        AnimateKeys,       SpeedKeys,       DirectionKeys      };     static unsigned charB     HighlightBitmap[] = {0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55},?     ShadowBitmap[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};      char     command[MaxTextLength], !     resource_name[MaxTextLength];      Image      *image;      int      i,
     scene;     KeySym     key_symbol;      register char      *p;      unsigned int     number_windows, 
     state,     status;      Window     root_window;     XClassHint     *class_hints;      XEvent
     event;  
   XFontStruct      *font_info;      XGCValues      context_values;      XPixelInfo     icon_pixel,      pixel_info,      scene_info;      XResourceInfo      icon_resources;      XStandardColormap      *icon_map,     *map_info;     XTextProperty      window_name;  
   XVisualInfo      *icon_visual,      *visual_info;   
   XWindowInfo       *magick_windows[MaxWindows];  
   XWindows
     *windows;   
   XWMHints     *manager_hints;      /*     Allocate standard colormap.    */   if (resource_info->debug)      { !       XSynchronize(display,True); 5       (void) fprintf(stderr,"Version: %s\n",Version);      } $   map_info=XAllocStandardColormap();$   icon_map=XAllocStandardColormap();1   if ((map_info == (XStandardColormap *) NULL) || /       (icon_map == (XStandardColormap *) NULL)) K     Error("Unable to create standard colormap","Memory allocation failed"); %   map_info->colormap=(Colormap) NULL; %   icon_map->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL; +   icon_pixel.pixels=(unsigned long *) NULL; '   icon_pixel.gamma_map=(XColor *) NULL;    /*-     Get the best visual this server supports.    */"   icon_resources=(*resource_info);(   icon_resources.map_type=(char *) NULL;'   icon_resources.visual_type="default"; )   icon_resources.colormap=SharedColormap; >   visual_info=XBestVisualInfo(display,map_info,resource_info);@   icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);.   if ((visual_info == (XVisualInfo *) NULL) ||,       (icon_visual == (XVisualInfo *) NULL))=     Error("Unable to get visual",resource_info->visual_type);    if (resource_info->debug)      { )       (void) fprintf(stderr,"Visual:\n"); J       (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);,       (void) fprintf(stderr,"  class: %s\n",/          XVisualClassName(visual_info->class)); G       (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth); ?       (void) fprintf(stderr,"  size of colormap: %d entries\n", $         visual_info->colormap_size);L       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",N         visual_info->red_mask,visual_info->green_mask,visual_info->blue_mask);E       (void) fprintf(stderr,"  significant bits in color: %d bits\n", #         visual_info->bits_per_rgb);      }    /*     Initialize atoms.    */0   windows=(XWindows *) malloc(sizeof(XWindows));#   if (windows == (XWindows *) NULL) C     Error("Unable to create X windows","Memory allocation failed"); B   windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);J   windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);D   windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);   if (resource_info->debug)      { ,       (void) fprintf(stderr,"Protocols:\n");O       (void) fprintf(stderr,"  Window Manager: 0x%lx\n",windows->wm_protocols); 9       (void) fprintf(stderr,"    delete window: 0x%lx\n", #         windows->wm_delete_window); N       (void) fprintf(stderr,"    take focus: 0x%lx\n",windows->wm_take_focus);     }    /*%     Allocate class and manager hints.    */    class_hints=XAllocClassHint();    manager_hints=XAllocWMHints();-   if ((class_hints == (XClassHint *) NULL) || +       (manager_hints == (XWMHints *) NULL)) 6     Error("Unable to allocate X hints",(char *) NULL);   /*     Initialize window id's.    */7   root_window=XRootWindow(display,visual_info->screen);    number_windows=0; 8   magick_windows[number_windows++]=(&windows->backdrop);4   magick_windows[number_windows++]=(&windows->icon);5   magick_windows[number_windows++]=(&windows->image); 4   magick_windows[number_windows++]=(&windows->info);7   magick_windows[number_windows++]=(&windows->command); 6   magick_windows[number_windows++]=(&windows->widget);$   for (i=0; i < number_windows; i++)(     magick_windows[i]->id=(Window) NULL;   /*+     Sort images by increasing scene number.    */   i=0;/   for (scene=0; scene < number_scenes; scene++)      i+=images[scene]->scene;   if (i > 0)8     qsort((void *) images,number_scenes,sizeof(Image *),E       (int (*) _Declare((const void *, const void *))) SceneCompare); /   if (resource_info->map_type == (char *) NULL) ,     if ((visual_info->class != TrueColor) &&,         (visual_info->class != DirectColor))       {          unsigned int           identical_colormap;   
         /*I           Determine if the sequence of images has the identical colormap. 
         */          identical_colormap=True;5         for (scene=0; scene < number_scenes; scene++) 	         { 6           if ((images[scene]->class == DirectClass) ||C               (images[scene]->colors > visual_info->colormap_size)) 6             QuantizeImage(images[scene],(unsigned int)C               visual_info->colormap_size,resource_info->tree_depth, ?               resource_info->dither,resource_info->colorspace); 8           if (images[scene]->signature == (char *) NULL)-             ColormapSignature(images[scene]); G           status=strcmp(images[scene]->signature,images[0]->signature);            if (status != 0)%             identical_colormap=False; 	         }           if (!identical_colormap)<           QuantizeImages(images,number_scenes,(unsigned int)A             visual_info->colormap_size,resource_info->tree_depth, =             resource_info->dither,resource_info->colorspace);        }    /*!     Initialize Standard Colormap.    */M   XMakeStandardColormap(display,visual_info,resource_info,images[0],map_info,      &pixel_info);    /*     Initialize font info.    */3   font_info=XBestFont(display,resource_info,False); (   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);    /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context); %   class_hints->res_name="superclass"; #   class_hints->res_class="Animate"; -   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; .   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);    if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid; >   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;D   pixel_info.annotate_context=XCreateGC(display,windows->context.id,P     GCBackground | GCFont | GCForeground | GCGraphicsExposures,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel; B   pixel_info.widget_context=XCreateGC(display,windows->context.id,P     GCBackground | GCFont | GCForeground | GCGraphicsExposures,&context_values);-   if (pixel_info.widget_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;E   pixel_info.highlight_context=XCreateGC(display,windows->context.id, P     GCBackground | GCFont | GCForeground | GCGraphicsExposures,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.    */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL, $     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;2   XBestIconSize(display,&windows->icon,images[0]);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);:   windows->icon.attributes.event_mask=StructureNotifyMask;   class_hints->res_name="icon"; -   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; +   manager_hints->initial_state=IconicState; F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug) H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.    */>   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id, 1     GCBackground | GCForeground,&context_values); /   if (icon_pixel.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;    /*     Initialize Image window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image); B   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char)); J   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");,   if (resource_info->title != (char *) NULL)     {        /*#         User specified window name.        */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);      }    else     {        register char          *p;          /*0         Window name is the base of the filename.       */:       p=images[0]->filename+strlen(images[0]->filename)-1;I       while ((p > images[0]->filename) && (*(p-1) != *BasenameSeparator))          p--;9       (void) strcpy(windows->image.name,"ImageMagick: "); +       (void) strcat(windows->image.name,p); 0       (void) strcpy(windows->image.icon_name,p);     } 8   windows->image.geometry=resource_info->image_geometry;*   windows->image.width=images[0]->columns;I   if (windows->image.width >= XDisplayWidth(display,visual_info->screen)) D     windows->image.width=XDisplayWidth(display,visual_info->screen);(   windows->image.height=images[0]->rows;K   if (windows->image.height >= XDisplayHeight(display,visual_info->screen)) F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | @     LeaveWindowMask | OwnerGrabButtonMask | StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);   if (resource_info->backdrop)     {        /*#         Initialize backdrop window.        */       windows->backdrop.x=0;       windows->backdrop.y=0;6       windows->backdrop.name="ImageMagick Background";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen); K       windows->backdrop.height=XDisplayHeight(display,visual_info->screen); '       windows->backdrop.border_width=0; '       windows->backdrop.immutable=True; 9       windows->backdrop.attributes.do_not_propagate_mask= ,         ButtonPressMask | ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop"; B       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state= :         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug) >         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id);        /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition; I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)- $         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);      } +   if (resource_info->name == (char *) NULL) &     class_hints->res_name=client_name;   else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state= 6     resource_info->iconic ? IconicState : NormalState;G   XMakeWindow(display,(resource_info->backdrop ? windows->backdrop.id : F     root_window),argv,argc,class_hints,manager_hints,&windows->image);   if (resource_info->debug) J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*'     Initialize image X image structure.    */   windows->image.x=0;    windows->image.y=0; D   status=XMakeImage(display,resource_info,&windows->image,images[0],(     images[0]->columns,images[0]->rows);=   status|=XMakePixmap(display,resource_info,&windows->image);    if (status == False)4     Error("Unable to create X image",(char *) NULL);   if (resource_info->debug)      { E       (void) fprintf(stderr,"Image: [%u] %s %ux%u ",images[0]->scene, @         images[0]->filename,images[0]->columns,images[0]->rows);!       if (images[0]->colors != 0) 8         (void) fprintf(stderr,"%uc ",images[0]->colors);6       (void) fprintf(stderr,"%s\n",images[0]->magick);     }    /*     Initialize info window.    */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";   windows->info.border_width=1;    windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition; 4   windows->info.attributes.win_gravity=UnmapGravity;L   windows->info.attributes.event_mask=ButtonPressMask | StructureNotifyMask;   class_hints->res_name="info"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False; +   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);C   XSetTransientForHint(display,windows->info.id,windows->image.id);    if (resource_info->debug) H     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize command window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command); 9   (void) sprintf(resource_name,"%s.command",client_name); O   windows->command.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);"   windows->command.name="Command";"   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped; .   windows->command.attributes.save_under=True;;   windows->command.attributes.event_mask=ButtonMotionMask | J     ButtonPressMask | ButtonReleaseMask | EnterWindowMask | ExposureMask |@     LeaveWindowMask | OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False; +   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command); C   windows->command.highlight_stipple=XCreateBitmapFromData(display, 6     windows->command.id,(char *) HighlightBitmap,8,8);@   windows->command.shadow_stipple=XCreateBitmapFromData(display,3     windows->command.id,(char *) ShadowBitmap,8,8); F   XSetTransientForHint(display,windows->command.id,windows->image.id);$   windows->command.data=NumberMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);    if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize widget window.    */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);C   windows->widget.name=(char *) malloc(MaxTextLength*sizeof(char)); #   if (windows->widget.name == NULL) G     Error("Unable to create widget window","Memory allocation failed");    *windows->widget.name='\0'; !   windows->widget.border_width=0; #   windows->widget.flags|=PPosition; 6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True; L   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | ;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask; !   class_hints->res_name="widget"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False; +   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);G   windows->widget.highlight_stipple=windows->command.highlight_stipple; A   windows->widget.shadow_stipple=windows->command.shadow_stipple; E   XSetTransientForHint(display,windows->widget.id,windows->image.id);    if (resource_info->debug) L     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);"   windows->popup.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup);     windows->pan.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan); $   windows->magnify.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify);    /*'     Initialize image pixmaps structure.    */(   XMapWindow(display,windows->image.id);I   windows->image.pixmaps=(Pixmap *) malloc(number_scenes*sizeof(Pixmap)); 0   if (windows->image.pixmaps == (Pixmap *) NULL)A     Error("Unable to animate images","Memory allocation failed"); 2   windows->image.pixmaps[0]=windows->image.pixmap;+   scene_info.pixels=(unsigned long *) NULL; '   scene_info.gamma_map=(XColor *) NULL; /   for (scene=1; scene < number_scenes; scene++)    {      /*       Create X image.      */(     windows->image.pixmap=(Pixmap) NULL;5     if ((resource_info->map_type != (char *) NULL) || ,         (visual_info->class == TrueColor) ||,         (visual_info->class == DirectColor)).       if (images[scene]->class == PseudoClass)	         {            /**             Get pixel info for this scene.           */C           XGetPixelInfo(display,visual_info,map_info,resource_info, '             images[scene],&scene_info); 2           windows->image.pixel_info=(&scene_info);	         } J     status=XMakeImage(display,resource_info,&windows->image,images[scene],2       images[scene]->columns,images[scene]->rows);?     status|=XMakePixmap(display,resource_info,&windows->image);      if (status == False)6       Error("Unable to create X image",(char *) NULL);     if (resource_info->debug)        { K         (void) fprintf(stderr,"Image: [%u] %s %ux%u ",images[scene]->scene, N           images[scene]->filename,images[scene]->columns,images[scene]->rows);'         if (images[scene]->colors != 0) >           (void) fprintf(stderr,"%uc ",images[scene]->colors);<         (void) fprintf(stderr,"%s\n",images[scene]->magick);       }      /*.       Window name is the base of the filename.     */@     p=images[scene]->filename+strlen(images[scene]->filename)-1;<     while ((p > images[scene]->filename) && (*(p-1) != '/'))
       p--;7     (void) strcpy(windows->image.name,"ImageMagick: "); )     (void) strcat(windows->image.name,p); J     status=XStringListToTextProperty(&windows->image.name,1,&window_name);     if (status != 0)       { ;         XSetWMName(display,windows->image.id,&window_name); *         XFree((void *) window_name.value);       } 8     windows->image.pixmaps[scene]=windows->image.pixmap;     if (images[scene]->matte) .       XClearWindow(display,windows->image.id);<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);     XSync(display,False);      /*       Free image pixels.     */)     free((char *) images[scene]->pixels); 3     images[scene]->pixels=(RunlengthPacket *) NULL;    } *   windows->image.pixel_info=(&pixel_info);,   if (resource_info->title != (char *) NULL)     { >       (void) strcpy(windows->image.name,resource_info->title);L       status=XStringListToTextProperty(&windows->image.name,1,&window_name);       if (status != 0)	         { =           XSetWMName(display,windows->image.id,&window_name); ,           XFree((void *) window_name.value);	         }      }    /*     Respond to events.   */
   scene=0;   image=images[0];J   state=ForwardAnimationState | PlayAnimationState | RepeatAnimationState;   do   { 5     if (XEventsQueued(display,QueuedAfterFlush) == 0) G       if ((state & PlayAnimationState) || (state & StepAnimationState)) 	         { #           if (windows->info.mapped) K             XWithdrawWindow(display,windows->info.id,windows->info.screen); 4           if (resource_info->title == (char *) NULL)
             {                /*8                 Window name is the base of the filename.               */J               p=images[scene]->filename+strlen(images[scene]->filename)-1;F               while ((p > images[scene]->filename) && (*(p-1) != '/'))                 p--;A               (void) strcpy(windows->image.name,"ImageMagick: "); 3               (void) strcat(windows->image.name,p);                status= O                 XStringListToTextProperty(&windows->image.name,1,&window_name);                if (status != 0)                 { E                   XSetWMName(display,windows->image.id,&window_name); 4                   XFree((void *) window_name.value);                 } 
             }            /**             Copy X pixmap to Image window.           */           image=images[scene];>           windows->image.pixmap=windows->image.pixmaps[scene];#           if (images[scene]->matte) 4             XClearWindow(display,windows->image.id);B           XRefreshWindow(display,&windows->image,(XEvent *) NULL);           XSync(display,False); )           if (state & StepAnimationState) 
             {                char$                 text[MaxTextLength];  J               p=images[scene]->filename+strlen(images[scene]->filename)-1;F               while ((p > images[scene]->filename) && (*(p-1) != '/'))                 p--;4               (void) sprintf(text,"%s[%d]",p,scene);0               XInfoWidget(display,windows,text);+               state&=(~StepAnimationState); 
             } (           if (resource_info->delay != 0)A             XDelay(display,(unsigned long) resource_info->delay); ,           if (state & ForwardAnimationState)
             {                /*;                 Forward animation:  increment scene number.                */               scene++;)               if (scene == number_scenes) 6                 if (state & AutoReverseAnimationState)                   { 4                     state&=(~ForwardAnimationState);                     scene--;                   }                  else                   { 8                     if (!(state & RepeatAnimationState))3                       state&=(~PlayAnimationState);                      scene=0;                   } 
             }            else
             {                /*;                 Reverse animation:  decrement scene number.                */               scene--;               if (scene < 0)6                 if (state & AutoReverseAnimationState)                   { 1                     state|=ForwardAnimationState;                      scene=0;                   }                  else                   { 8                     if (!(state & RepeatAnimationState))3                       state&=(~PlayAnimationState); *                     scene=number_scenes-1;                   } 
             }            continue; 	         }      /*       Handle a window event.     */     XNextEvent(display,&event); 1     if (event.xany.window == windows->command.id)        {          int 
           id;   
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)            continue; /         (void) strcpy(command,CommandMenu[id]); #         key_symbol=CommandKeys[id];          if (id < NumberMenus)            {              int                entry;               /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);              if (entry < 0)               continue; 4             (void) strcpy(command,Menus[id][entry]);'             key_symbol=Keys[id][entry];            } (         if (key_symbol != XK_VoidSymbol)I           XMagickCommand(display,resource_info,windows,key_symbol,&image,              &state);         continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 9         if (event.xbutton.window == windows->backdrop.id)            { G             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           } 6         if (event.xbutton.window == windows->image.id)           {              /*'               Map/unmap Command widget.              */(             if (windows->command.mapped):               XWithdrawWindow(display,windows->command.id,)                 windows->command.screen);              else               { B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL); 8                 XMapRaised(display,windows->command.id);               }            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { !         if (resource_info->debug) K           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width, J             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event); 9         if (event.xconfigure.window == windows->image.id)            { 1             if (event.xconfigure.send_event != 0) =               if (windows->command.geometry == (char *) NULL) -                 if (!windows->command.mapped)                    { "                     XWindowChanges%                       window_changes;                        /*O                       Position the Command widget relative of the Image window.                      */'                     windows->command.x= C                       event.xconfigure.x-windows->command.width-25; :                     windows->command.y=event.xconfigure.y;8                     window_changes.x=windows->command.x;8                     window_changes.y=windows->command.y;E                     XReconfigureWMWindow(display,windows->command.id, I                       windows->command.screen,CWX | CWY,&window_changes);                    }              /*3               Image window has a new configuration.              */8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             break;           } 8         if (event.xconfigure.window == windows->icon.id)           {              /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width; 9             windows->icon.height=event.xconfigure.height;              break;           }        }        case EnterNotify:        { 
         /*'           Selectively install colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) 8             XInductColormap(display,map_info->colormap);         break;       }        case Expose:       { !         if (resource_info->debug) >           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y); 
         /*/           Repaint windows that are now exposed. 
         */6         if (event.xexpose.window == windows->image.id)           { @             windows->image.pixmap=windows->image.pixmaps[scene];;             XRefreshWindow(display,&windows->image,&event);              break;           }          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) O           (void) fprintf(stderr,"Key press: 0x%lx (%c)\n",key_symbol,*command); "         if (key_symbol == XK_Help)           Usage(False);          else'           if (!IsCursorKey(key_symbol)) K             XMagickCommand(display,resource_info,windows,key_symbol,&image,                &state);         break;       }        case LeaveNotify:        { 
         /*)           Selectively uninstall colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) :             XUninductColormap(display,map_info->colormap);         break;       }        case MapNotify:        { !         if (resource_info->debug) I           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window); 6         if (event.xmap.window == windows->backdrop.id)           { D             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime); *             windows->backdrop.mapped=True;             break;           } 3         if (event.xmap.window == windows->image.id)            { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap); '             windows->image.mapped=True;              break;           } 2         if (event.xmap.window == windows->info.id)           { &             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {              /*#               Create an icon image.              */P             XMakeStandardColormap(display,icon_visual,&icon_resources,images[0],$               icon_map,&icon_pixel);O             (void) XMakeImage(display,&icon_resources,&windows->icon,images[0], 8               windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon); @             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id); &             windows->icon.mapped=True;             break;           }          break;       }        case MappingNotify:        { 1         XRefreshKeyboardMapping(&event.xmapping);          break;       }        case ReparentNotify:       { !         if (resource_info->debug) B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }        case UnmapNotify:        { !         if (resource_info->debug) M           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window); 5         if (event.xunmap.window == windows->image.id)            { (             windows->image.mapped=False;             break;           } 4         if (event.xunmap.window == windows->info.id)           { '             windows->info.mapped=False;              break;           } 4         if (event.xunmap.window == windows->icon.id)           { '             windows->icon.mapped=False;              break;           } 5         if (event.xunmap.window == windows->popup.id)            { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); (             windows->popup.mapped=False;             break;           } 6         if (event.xunmap.window == windows->widget.id)           { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); )             windows->widget.mapped=False;              break;           }          break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      }    }    while (!(state & ExitState));    /*     Free X resources.    */&   free((char *) windows->widget.name);%   free((char *) windows->image.name); *   free((char *) windows->image.icon_name);   if (resource_info->backdrop)2     XFreeCursor(display,windows->backdrop.cursor);9   if (windows->widget.highlight_stipple != (Pixmap) NULL) ;     XFreePixmap(display,windows->widget.highlight_stipple); 9   if (windows->widget.highlight_stipple != (Pixmap) NULL) 8     XFreePixmap(display,windows->widget.shadow_stipple);-   XFreeGC(display,pixel_info.widget_context); 0   XFreeGC(display,pixel_info.highlight_context);/   XFreeGC(display,pixel_info.annotate_context); /   XFreeGC(display,icon_pixel.annotate_context);    XFreeFont(display,font_info);    /*     Destroy X windows.   */$   for (i=0; i < number_windows; i++)   { /     if (magick_windows[i]->id != (Window) NULL) 4       XDestroyWindow(display,magick_windows[i]->id);5     if (magick_windows[i]->ximage != (XImage *) NULL) /       XDestroyImage(magick_windows[i]->ximage); 3     if (magick_windows[i]->pixmap != (Pixmap) NULL) 5       XFreePixmap(display,magick_windows[i]->pixmap);    } /   for (scene=0; scene < number_scenes; scene++)    { 7     XFreePixmap(display,windows->image.pixmaps[scene]);       DestroyImage(images[scene]);   } (   free((char *) windows->image.pixmaps);   /*     Free Standard Colormap.    */B   XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);/   if (resource_info->map_type == (char *) NULL) D     XFreeStandardColormap(display,visual_info,map_info,&pixel_info);   free((char *) windows);     XFree((void *) manager_hints);   XFree((void *) class_hints);   XFree((void *) icon_visual);   XFree((void *) visual_info);   XFree((void *) icon_map);    XFree((void *) map_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a g i c k C o m m a n d                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XMagickCommand makes a transform to the image or Image window as7 %  specified by a user menu button or keyboard command.  % / %  The format of the XMagickCommand routine is:  % J %    XMagickCommand(display,resource_info,windows,image,key_symbol,state); % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % G %    o image: Specifies a pointer to a Image structure;  XMagickCommand > %      may transform the image and return a new image pointer. % E %    o state: Specifies an unsigned int;  XMagickCommand may return a  %      modified state. %  %  */P static void XMagickCommand(display,resource_info,windows,key_symbol,image,state) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    KeySym
   key_symbol;    Image 
   **image;   unsigned int	   *state;  {    /*     Process user command.    */   if (windows->info.mapped) C     XWithdrawWindow(display,windows->info.id,windows->info.screen);    switch (key_symbol)    {      case XK_KP_Space:        break;     case XK_less:      {        resource_info->delay<<=1; $       if (resource_info->delay == 0)         resource_info->delay=1;        break;     }      case XK_greater:     {        resource_info->delay>>=1;        break;     }      case XK_period:      { #       *state|=RepeatAnimationState; +       *state&=(~AutoReverseAnimationState); !       *state|=PlayAnimationState;        break;     }      case XK_a:     { (       *state|=AutoReverseAnimationState;&       *state&=(~RepeatAnimationState);!       *state|=PlayAnimationState;        break;     }      case XK_f:     { #       *state=ForwardAnimationState; +       *state&=(~AutoReverseAnimationState);        break;     }      case XK_i:     { M       XDisplayImageInfo(display,resource_info,windows,(Image *) NULL,*image);        break;     }      case XK_p:     { !       *state|=PlayAnimationState; +       *state&=(~AutoReverseAnimationState);        break;     }      case XK_s:     case XK_Return:      case XK_KP_Enter:      { !       *state|=StepAnimationState; $       *state&=(~PlayAnimationState);       break;     }      case XK_h:     case XK_F1:      case XK_Help:      { :       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Animate",ImageMagickHelp);        break;     }      case XK_q:     {        /*         Exit program       */'       if (!resource_info->confirm_exit)          *state|=ExitState;
       else	         { 
           int              status;              /*!             Confirm program exit.            */M           status=XConfirmWidget(display,windows,"Do you really want to exit",              client_name);            if (status == True)              *state|=ExitState;	         }        break;     }      case XK_r:     case XK_BackSpace:     { '       *state&=(~ForwardAnimationState); +       *state&=(~AutoReverseAnimationState);        break;     }      default:     { %       if (!IsModifierKey(key_symbol))          XBell(display,0);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(argc,argv)  int    argc;    char	   **argv;  {    char     *option,     *resource_value,     *server_name;   	   Display 
     *display;      Image 
     **images;      ImageInfo      image_info;      int      i,     x;     unsigned int     first_scene,     image_number,      last_scene,      maximum_images, 
     scene;     XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*A     Display usage profile if there are no command line arguments.    */    client_name=ClientName(*argv);   if (argc < 2)      Usage(True);   /*     Set defaults.    */   display=(Display *) NULL;    first_scene=0;   GetImageInfo(&image_info);   last_scene=0;    server_name=(char *) NULL;   maximum_images=MaxTextLength; ;   images=(Image **) malloc(maximum_images*sizeof(Image *));     if (images == (Image **) NULL)A     Error("Unable to animate images","Memory allocation failed");    /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);    for (i=1; i < argc; i++)   {      /*)       Check command line for server name.      */     option=argv[i]; N     if (((int) strlen(option) == 1) || ((*option != '-') && (*option != '+')))       continue; +     if (strncmp("display",option+1,3) == 0)        { 
         /*%           User specified server name. 
         */         i++;         if (i == argc)A           Error("Missing server name on -display",(char *) NULL);          server_name=argv[i];         break;       } (     if (strncmp("help",option+1,2) == 0)       Usage(True);   }    /*     Open X server connection.    */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); P   resource_value=XGetResourceClass(resource_database,client_name,"delay","100");+   resource_info.delay=atoi(resource_value);    image_info.density= D     XGetResourceClass(resource_database,client_name,"density","85");   resource_value= H     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace; 0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace; 1   if (Latin1Compare("plane",resource_value) == 0) (     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace) :     Warning("Unrecognized interlace type",resource_value);   resource_value= G     XGetResourceClass(resource_database,client_name,"verbose","False"); ,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.    */   image_number=0;    for (i=1; i < argc; i++)   {      option=argv[i]; M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'b': 	         { 2           if (strncmp("backdrop",option+1,5) == 0)
             { 6               resource_info.backdrop=(*option == '-');               break;
             } 4           if (strncmp("background",option+1,5) == 0)
             { ;               resource_info.background_color=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { 7               resource_info.border_color=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL); 5                   resource_info.border_color=argv[i];                  }                break;
             } 5           if (strncmp("borderwidth",option+1,7) == 0) 
             { +               resource_info.border_width=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL); ;                   resource_info.border_width=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'c': 	         { 2           if (strncmp("colormap",option+1,6) == 0)
             { 5               resource_info.colormap=PrivateColormap; !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL); !                   option=argv[i]; ;                   resource_info.colormap=UndefinedColormap; ;                   if (Latin1Compare("private",option) == 0) ;                     resource_info.colormap=PrivateColormap; :                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);                  }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { ,               resource_info.number_colors=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 5               resource_info.colorspace=RGBColorspace; !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; ?                   resource_info.colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { >                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      } 8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) ;                     resource_info.colorspace=RGBColorspace; 7                   if (Latin1Compare("xyz",option) == 0) ;                     resource_info.colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0) =                     resource_info.colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) ;                     resource_info.colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0) =                     resource_info.colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0) ;                     resource_info.colorspace=YUVColorspace; F                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  }                break;
             } .           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');                break;
             } /           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL); 4                   resource_info.delay=atoi(argv[i]);                 }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } 1           if (strncmp("display",option+1,3) == 0) 
             { (               server_name=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); &                   server_name=argv[i];                 }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 4               resource_info.dither=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { .           if (strncmp("font",option+1,3) == 0)
             { /               resource_info.font=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];                  }                break;
             } 4           if (strncmp("foreground",option+1,3) == 0)
             { ;               resource_info.foreground_color=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)M                     Error("Missing foreground on -foreground",(char *) NULL); 9                   resource_info.foreground_color=argv[i];                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);                  }                break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL); 7                   resource_info.image_geometry=argv[i];                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             {                Usage(True);               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'i': 	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             { 8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))M                     Error("Missing geometry on -iconGeometry",(char *) NULL); 6                   resource_info.icon_geometry=argv[i];                 }                break;
             } 0           if (strncmp("iconic",option+1,5) == 0)
             { 4               resource_info.iconic=(*option == '-');               break;
             } 3           if (strncmp("interlace",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm': 	         { -           if (strncmp("map",option+1,3) == 0) 
             { 3               resource_info.map_type=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];                  }                break;
             } ,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { 6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 }                break;
             } 4           if (strncmp("monochrome",option+1,2) == 0)
             { 8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)                  { 0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8; :                   resource_info.colorspace=GRAYColorspace;                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'n': 	         { +           resource_info.name=(char *) NULL;            if (*option == '-') 
             {                i++;               if (i == argc)=                 Error("Missing name on -name",(char *) NULL); )               resource_info.name=argv[i]; 
             }            break;	         }          case 's': 	         { /           if (strncmp("scene",option+1,3) == 0) 
             {                first_scene=0;               last_scene=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene; J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }                break;
             } 7           if (strncmp("shared_memory",option+1,4) == 0) 
             { ?               resource_info.use_shared_memory=(*option == '-');                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't': 	         { 3           if (strncmp("text_font",option+1,3) == 0) 
             { 4               resource_info.text_font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL); 2                   resource_info.text_font=argv[i];                 }                break;
             } /           if (strncmp("title",option+1,2) == 0) 
             { 0               resource_info.title=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL); .                   resource_info.title=argv[i];                 }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { )               resource_info.tree_depth=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL); 9                   resource_info.tree_depth=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } 0           if (strncmp("visual",option+1,2) == 0)
             { 6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL); 4                   resource_info.visual_type=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'w': 	         { 0           if (strncmp("window",option+1,2) == 0)
             { 4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window", %                       (char *) NULL); 2                   resource_info.window_id=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(True);           break;	         }          default:	         { .           Error("Unrecognized option",option);           break;	         }        }      else<       for (scene=first_scene; scene <= last_scene ; scene++)       { 
         Image            *image,            *next_image;  
         /*L           Option is a file name: begin by reading image from specified file.
         */3         (void) strcpy(image_info.filename,argv[i]); &         if (first_scene != last_scene)           {              char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene); :             if (strcmp(filename,image_info.filename) == 0)J               (void) sprintf(filename,"%s[%u]",image_info.filename,scene);8             (void) strcpy(image_info.filename,filename);           } 9         image_info.server_name=resource_info.server_name; +         image_info.font=resource_info.font; /         image_info.dither=resource_info.dither; 7         image_info.monochrome=resource_info.monochrome; %         image=ReadImage(&image_info); $         if (image == (Image *) NULL)           if (*option == '-')              break;           else             continue; 
         do	         {             if (image->scene == 0)&             image->scene=image_number;           /*J             Transmogrify image as defined by the image processing options.           */2           MogrifyImage(&image_info,i,argv,&image);!           if (image_info.verbose) .             DescribeImage(image,stderr,False);-           if (image_number == maximum_images) 
             {                /*.                 Increase size of images array.               */!               maximum_images<<=1;                images=(Image **) H                 realloc((char *) images,maximum_images*sizeof(Image *));,               if (images == (Image **) NULL)M                 Error("Unable to animate images","Memory allocation failed"); 
             } '           images[image_number++]=image; !           next_image=image->next; +           if (next_image != (Image *) NULL)              image=next_image; /         } while (next_image != (Image *) NULL);        }    }    if (image_number == 0)6     Error("Missing an image file name",(char *) NULL);/   if (resource_info.window_id != (char *) NULL) H     XAnimateBackgroundImage(display,&resource_info,images,image_number);   elseH     XAnimateImage(display,&resource_info,argv,argc,images,image_number);   free((char *) images);%   free((char *) image_info.filename);    XCloseDisplay(display); 
   exit(0);   return(False); } 