 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop= %    -border geometry   surround image with a border of color 9 %    -box color         color for annotation bounding box ) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image G %    -colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string    annotate image with comment", 0 %    -compress type     RunlengthEncoded or Zlib< %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay seconds     display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X serverF %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge factor       apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image B %    -equalize          perform histogram equalization to an image< %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction@ %    -frame geometry    surround image with an ornamental border1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window : %    -immutable         displayed image cannot be modified, %    -interlace type    NONE, LINE, or PLANE2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one@ %    -modulate value    vary the brightness, saturation, and hue: %    -monochrome        transform image to black and white6 %    -negate            apply color inversion to imageI %    -noise             reduce noise with a noise peak elimination filter L %    -normalize         transform image to span the full the range of colors: %    -opaque color      change this color to the pen color@ %    -page geometry     size and location of the Postscript pageE %    -pen color         color for annotating or changing opaque color , %    -quality value     JPEG quality settingI %    -raise value       lighten/darken image edges to create a 3-D effect @ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number( %    -segment value     segment an image; %    -sharpen factor    apply a filter to sharpen the image I %    -shear geometry    slide one edge of the image along the X or Y axis 1 %    -size geometry     width and height of image B %    -spread amount       displace image pixels by a random amountI %    -texture filename  name of texture to tile onto the image background > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this windowE %    -window_group id   exit program when this window id is destroyed - %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "display.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % J %    o terminate: A value other than zero is returned if the program is to %      terminate immediately.  %  */ static void Usage(terminate) unsigned int   terminate; {    char     **p;  
   static char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",A       "-border geometry   surround image with a border of color", =       "-box color         color for annotation bounding box", -       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", K       "-colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 7       "-comment string    annotate image with comment", 4       "-compress type     RunlengthEncoded or Zlib",@       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay seconds     display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge factor       apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", F       "-equalize          perform histogram equalization to an image",@       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",D       "-frame geometry    surround image with an ornamental border",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", >       "-immutable         displayed image cannot be modified",0       "-interlace type    NONE, LINE, or PLANE",6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",D       "-modulate value    vary the brightness, saturation, and hue",>       "-monochrome        transform image to black and white",:       "-negate            apply color inversion to image",M       "-noise             reduce noise with a noise peak elimination filter", L       "-normalize         transform image to span the full range of colors",>       "-opaque color      change this color to the pen color",D       "-page geometry     size and location of the Postscript page",I       "-pen color         color for annotating or changing opaque color", 0       "-quality value     JPEG quality setting",M       "-raise value       lighten/darken image edges to create a 3-D effect", D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",,       "-segment value     segment an image",;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", M       "-shear geometry    slide one edge of the image along the X or Y axis", 5       "-size geometry     width and height of image", D       "-spread amount     displace image pixels by a random amount",M       "-texture filename  name of texture to tile onto the image background", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",I       "-window_group id   exit program when this window id is destroyed", 1       "-write filename    write image to a file",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) printf(7     "-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(M     "example, specify +matte to store the image without a matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e E d i t I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XAnnotateEditImage annotates the image with text.  % 3 %  The format of the XAnnotateEditImage routine is:  % < %    XAnnotateEditImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */K static unsigned int XAnnotateEditImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {  #define AnnotateModeNameOp  0 " #define AnnotateModeFontColorOp  1( #define AnnotateModeBackgroundColorOp  2 #define AnnotateModeRotateOp  3  #define AnnotateModeHelpOp  4   #define AnnotateModeDismissOp  5 #define TextModeHelpOp  0  #define TextModeDismissOp  1  
   static char      *AnnotateModeMenu[]=     {        "Font Name",       "Font Color",        "Box Color",       "Rotate Text",
       "Help",        "Dismiss",       (char *) NULL      },     *TextModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      };     char      *ColorMenu[MaxNumberPens+1],     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      GC     annotate_context;      int      id,      pen_number,      x,     y;     KeySym     key_symbol;      register char      *p;      register int     i;     static double      degrees = 0.0;     static unsigned int      box_id = MaxNumberPens-2,      font_id = 0,     pen_id = 0,      transparent_box = True,      transparent_pen = False;     unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XAnnotateInfo      *annotate_info,      *previous_info;      XColor
     color;  
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=4;J   (void) XCommandWidget(display,windows,AnnotateModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { "           case AnnotateModeNameOp:           {              char(               *FontMenu[MaxNumberFonts];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-2]="Browser...";5             FontMenu[MaxNumberFonts-1]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */I             font_number=XMenuWidget(display,windows,AnnotateModeMenu[id],                 FontMenu,command);              if (font_number < 0)               break;2             if (font_number == (MaxNumberFonts-2))               {                  static char 3                   font_name[MaxTextLength]="fixed";                    /*4                   Select a font name from a browser.                 */@                 resource_info->font_name[font_number]=font_name;G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               }              /*#               Initialize font info.              */             font_info=L               XLoadQueryFont(display,resource_info->font_name[font_number]);2             if (font_info == (XFontStruct *) NULL)               { E                 XNoticeWidget(display,windows,"Unable to load font:", 9                   resource_info->font_name[font_number]);                  break;               }               font_id=font_number;)             XFreeFont(display,font_info);              break;           } '           case AnnotateModeFontColorOp:            {              /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_pen=pen_number == (MaxNumberPens-2);              if (transparent_pen)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } -           case AnnotateModeBackgroundColorOp:            {              /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_box=pen_number == (MaxNumberPens-2);              if (transparent_box)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             box_id=pen_number;             break;           } $           case AnnotateModeRotateOp:           {              int                entry;               static char ,               angle[MaxTextLength] = "30.0",               *RotateMenu[]=               {                  "0",                 "45",                  "90",                  "135",                 "180",                 "225",                 "270",                 "315",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[8]="Dialog...";N             entry=XMenuWidget(display,windows,AnnotateModeMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 8)                { 0                 degrees=atof(RotateMenu[entry]);                 break;               } N             (void) XDialogWidget(display,windows,"OK","Enter rotation angle:",               angle);              if (*angle == '\0')                break;              degrees=atof(angle);             break;           } "           case AnnotateModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } %           case AnnotateModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; +   if (!transparent_box && !transparent_pen) )     annotate_info->stencil=OpaqueStencil;    else     if (!transparent_box) /       annotate_info->stencil=BackgroundStencil;      else/       annotate_info->stencil=ForegroundStencil; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetBackground(display,annotate_context,9     windows->image.pixel_info->pen_colors[box_id].pixel); *   XSetForeground(display,annotate_context,9     windows->image.pixel_info->pen_colors[pen_id].pixel);    /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;F   (void) XCommandWidget(display,windows,TextModeMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */0         XSetBackground(display,annotate_context,=           windows->image.pixel_info->background_color.pixel); 0         XSetForeground(display,annotate_context,=           windows->image.pixel_info->foreground_color.pixel); C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event); 0         XSetBackground(display,annotate_context,?           windows->image.pixel_info->pen_colors[box_id].pixel); 0         XSetForeground(display,annotate_context,?           windows->image.pixel_info->pen_colors[pen_id].pixel);          if (id < 0)            continue;          switch (id) 	         {            case TextModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           } !           case TextModeDismissOp:            {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           } ,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { >               if (annotate_info->stencil == ForegroundStencil)G                 XDrawString(display,windows->image.id,annotate_context, <                   text_info->x,text_info->y,text_info->text,+                   strlen(text_info->text));                elseL                 XDrawImageString(display,windows->image.id,annotate_context,<                   text_info->x,text_info->y,text_info->text,+                   strlen(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { #               key_symbol=XK_Delete;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=strlen(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_Delete:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);<             if (annotate_info->stencil == ForegroundStencil)N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);             elseJ               XDrawImageString(display,windows->image.id,annotate_context,                 x,y,p,1); )             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             strlen(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } N           annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;+         free((char *) annotate_info->text); %         free((char *) annotate_info); $         annotate_info=previous_info;         continue;        }      /*2       Determine pixel index for box and pen color.     */)     windows->image.pixel_info->box_color= 4       windows->image.pixel_info->pen_colors[box_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[box_id].pixel)           { 3             windows->image.pixel_info->box_index=i;              break;           } )     windows->image.pixel_info->pen_color= 4       windows->image.pixel_info->pen_colors[pen_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[pen_id].pixel)           { 3             windows->image.pixel_info->pen_index=i;              break;           }      /**       Define the annotate geometry string.     */9     x_factor=UpShift(width)/windows->image.ximage->width; '     annotate_info->x+=windows->image.x; :     annotate_info->x=DownShift(annotate_info->x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; ;     annotate_info->y+=(windows->image.y-font_info->ascent); :     annotate_info->y=DownShift(annotate_info->y*y_factor);9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       (unsigned int) DownShift(annotate_info->width*x_factor),?       (unsigned int) DownShift(annotate_info->height*y_factor), -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */J     status=XAnnotateImage(display,windows->image.pixel_info,annotate_info,       False,image);      if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;'     free((char *) annotate_info->text); !     free((char *) annotate_info);       annotate_info=previous_info;   } *   XSetForeground(display,annotate_context,7     windows->image.pixel_info->foreground_color.pixel); *   XSetBackground(display,annotate_context,7     windows->image.pixel_info->background_color.pixel); C   XSetFont(display,annotate_context,windows->image.font_info->fid); )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B a c k g r o u n d I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBackgroundImage displays the image in the background of a window. % 1 %  The format of the XBackgroundImage routine is:  % A %    status=XBackgroundImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o status: Function XBackgroundImage return True if the image isJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */I static unsigned int XBackgroundImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { = #define BackgroundImageText  "  Backgrounding the image...  "   
   static char &     window_id[MaxTextLength] = "root";     XResourceInfo      background_resources;      unsigned int     status;      /*     Put image in background.   */4   status=XDialogWidget(display,windows,"Background",H     "Enter window id (id 0x00 selects window with pointer):",window_id);   if (*window_id == '\0')      return(False);M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); 3   XInfoWidget(display,windows,BackgroundImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);(   background_resources=(*resource_info);+   background_resources.window_id=window_id; '   background_resources.backdrop=status; G   status=XDisplayBackgroundImage(display,&background_resources,*image); 
   if (status) C     XClientMessage(display,windows->image.id,windows->im_protocols, -       windows->im_retain_colors,CurrentTime); )   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ) %  Function XChopImage chops the X image.  % + %  The format of the XChopImage routine is:  % ; %    status=XChopImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */C static unsigned int XChopImage(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; {  #define ChopModeDirectionOp  0 #define ChopModeHelpOp  1  #define ChopModeDismissOp  2 #define HorizontalChopOp  0  #define VerticalChopOp  1   
   static char      *ChopModeMenu[]=     {        "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     static unsigned int !     direction = HorizontalChopOp;      unsigned int
     distance,      height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;F   (void) XCommandWidget(display,windows,ChopModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,ChopModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { #           case ChopModeDirectionOp:            {              char%               command[MaxTextLength];                static char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             direction=O               XMenuWidget(display,windows,ChopModeMenu[id],Directions,command);              break;           }            case ChopModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           } !           case ChopModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           User has committed to start point of chopting line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); L         (void) sprintf(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */&     if (direction == HorizontalChopOp)       { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;.         if (segment_info.x1 > segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    chop_info.x+=x; 2   chop_info.x=DownShift(chop_info.x*scale_factor);:   chop_info.width=DownShift(chop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    chop_info.y+=y; 2   chop_info.y=DownShift(chop_info.y*scale_factor);<   chop_info.height=DownShift(chop_info.height*scale_factor);   /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);)   XSetCursorState(display,windows,False); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for G %  a PseudoClass image.  The floodfill algorithm is strongly based on a : %  similiar algorithm in "Graphics Gems" by Paul Heckbert. % 0 %  The format of the XColorEditImage routine is: % 9 %    XColorEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */  2 static void ColorFloodfill(image,x,y,xcolor,delta) Image 	   *image;    int    x,   y;   XColor	   xcolor;    int    delta; {    int      offset, 	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket 
     color,     target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; #   color.red=XDownScale(xcolor.red); '   color.green=XDownScale(xcolor.green); %   color.blue=XDownScale(xcolor.blue); %   if (ColorMatch(color,target,delta))      return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      offset=p->y2;      y=p->y1+offset;      /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); +       if (!ColorMatch(*pixel,target,delta))          break;       pixel->red=color.red;        pixel->green=color.green;        pixel->blue=color.blue;      }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); 1             if (!ColorMatch(*pixel,target,delta))                break;!             pixel->red=color.red; %             pixel->green=color.green; #             pixel->blue=color.blue;            } #           Push(y,start,x-1,offset);            if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); ,         if (ColorMatch(*pixel,target,delta))           break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }   H static unsigned int XColorEditImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; {  #define ColorEditColorOp  0  #define ColorEditMethodOp  1 #define ColorEditDeltaOp  2  #define ColorEditUndoOp  3 #define ColorEditHelpOp  4 #define ColorEditDismissOp  5   
   static char      *ColorEditMenu[]=      {        "Pixel Color",       "Method",        "Delta",
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int 
     entry,     id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;      static unsigned int      delta = 0,     method = PointMethodOp,      pen_id = 0;      unsigned int     height, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=3;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            { <             XDefineCursor(display,windows->image.id,cursor);             continue;            }          switch (id) 	         {             case ColorEditColorOp:           {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;                /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */O             pen_number=XMenuWidget(display,windows,ColorEditMenu[id],ColorMenu,                command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } !           case ColorEditMethodOp:            {              static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);             if (entry >= 0)                method=entry;              break;           }             case ColorEditDeltaOp:           {              static char                *DeltaMenu[]=                {                  "0",                 "1",                 "2",                 "4",                 "8",                 "16",                  "32",                  (char *) NULL,                 (char *) NULL,               },)               value[MaxTextLength] = "3";                /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog..."; J             entry=XMenuWidget(display,windows,ColorEditMenu[id],DeltaMenu,               command);              if (entry < 0)               break;             if (entry != 7)                { -                 delta=atoi(DeltaMenu[entry]);                  break;               } K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",                value);              if (*value == '\0')                break;             delta=atoi(value);             break;           }            case ColorEditUndoOp:            { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case ColorEditHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } "           case ColorEditDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); =         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x; ?         y_factor=UpShift(height)/windows->image.ximage->height; C         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; <         color=windows->image.pixel_info->pen_colors[pen_id];-         if ((x_offset < 0) || (y_offset < 0))            continue; L         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue; G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);          switch (method) 	         {            case PointMethodOp:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); )             p->red=XDownScale(color.red); -             p->green=XDownScale(color.green); +             p->blue=XDownScale(color.blue);              break;           }            case ReplaceMethodOp:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); <               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             } '             target=(*image)->pixels[i]; /             if ((*image)->class == DirectClass)                { #                 p=(*image)->pixels; 5                 for (i=0; i < (*image)->packets; i++)                  { 2                   if (ColorMatch(*p,target,delta))                     { 3                       p->red=XDownScale(color.red); 7                       p->green=XDownScale(color.green); 5                       p->blue=XDownScale(color.blue);                      }                    p++;                 }                }              else               { 4                 for (i=0; i < (*image)->colors; i++)E                   if (ColorMatch((*image)->colormap[i],target,delta))                      { F                       (*image)->colormap[i].red=XDownScale(color.red);J                       (*image)->colormap[i].green=XDownScale(color.green);H                       (*image)->colormap[i].blue=XDownScale(color.blue);                     } "                 SyncImage(*image);               }              break;           } !           case FloodfillMethodOp:            {              /*A               Update color information using floodfill algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;A             ColorFloodfill(*image,x_offset,y_offset,color,delta);              break;           }            case ResetMethodOp:            {              /*=               Update color information using reset algorithm.              */(             (*image)->class=DirectClass;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             { +               p->red=XDownScale(color.red); /               p->green=XDownScale(color.green); -               p->blue=XDownScale(color.blue);                p++;
             }              break;           } 	         } +         state&=(~UpdateConfigurationState);        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 0 %  The format of the XCompositeImage routine is: % @ %    status=XCompositeImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % D %    o status: Function XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */H static unsigned int XCompositeImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { # #define CompositeModeOperatorsOp  0  #define CompositeModeBlendOp  1  #define CompositeModeHelpOp  2! #define CompositeModeDismissOp  3   
   static char      *CompositeModeMenu[]=      {        "Operators",       "Blend",
       "Help",        "Dismiss",       (char *) NULL      },#     filename[MaxTextLength] = "\0";      char     text[MaxTextLength];     Cursor     cursor;      double
     blend;     Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      static unsigned int "     operator = ReplaceCompositeOp;     unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*&     Request image file name from user.   */;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;K   (void) XCommandWidget(display,windows,CompositeModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);&   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   blend=0.0;   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */J         (void) sprintf(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */D         id=XCommandWidget(display,windows,CompositeModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         { (           case CompositeModeOperatorsOp:           {              char%               command[MaxTextLength];                static char                *OperatorMenu[]=               {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */G             operator=XMenuWidget(display,windows,CompositeModeMenu[id], &               OperatorMenu,command)+1;             break;           } $           case CompositeModeBlendOp:           {              static char -               factor[MaxTextLength] = "20.0";                /*3               Blend the two images a given percent.              */J             XSetFunction(display,windows->image.highlight_context,GXcopy);9             (void) XDialogWidget(display,windows,"Blend", >               "Enter the blend factor (0.0 - 99.9%):",factor);L             XSetFunction(display,windows->image.highlight_context,GXinvert);              if (*factor == '\0')               break;             blend=atof(factor);              break;           } #           case CompositeModeHelpOp:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } &           case CompositeModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    composite_info.x+=x;<   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    composite_info.y+=y;<   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *zoomed_image;         /*         Scale composite image.       */B       zoomed_image=ZoomImage(composite_image,composite_info.width,.         composite_info.height,MitchellFilter);$       DestroyImage(composite_image);)       if (zoomed_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=zoomed_image;      }    if (blend != 0.0)      {        register int
         i;         register RunlengthPacket         *p;          unsigned short         index;         /*#         Create mattes for blending.        */0       index=((int) DownScale(MaxRGB)*blend)/100;)       composite_image->class=DirectClass; "       composite_image->matte=True;        p=composite_image->pixels;2       for (i=0; i < composite_image->packets; i++)       {          p->index=index;          p++;       } H       index=(int) DownScale(MaxRGB)-((int) DownScale(MaxRGB)*blend)/100;       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=index;          p++;       }         operator=BlendCompositeOp;     }    /*(     Composite image with X Image window.   */A   CompositeImage(image,operator,composite_image,composite_info.x,      composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static void XConfigureImageColormap(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { 
   Colormap
     colormap;      /*     Make standard colormap.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);5   if (image->packets == (image->columns*image->rows))      CompressImage(image); I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 0 %  The format of the XConfigureImage routine is: % @ %    status=XConfigureImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o status: Function XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static unsigned int XConfigureImage(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {    unsigned int     height, 	     mask,      status, 
     width,
     x_factor, 
     y_factor;      XSizeHints     *size_hints;     XWindowChanges     window_changes;      /**     Dismiss if window dimensions are zero.   */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */(   XSetCursorState(display,windows,True);   XFlush(display);7   x_factor=UpShift(width)/windows->image.ximage->width; 9   y_factor=UpShift(height)/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */;   if (width > XDisplayWidth(display,windows->image.screen)) 7     width=XDisplayWidth(display,windows->image.screen);    window_changes.width=width; =   if (height > XDisplayHeight(display,windows->image.screen)) 9     height=XDisplayHeight(display,windows->image.screen);    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);;   if ((x_factor == UpShift(1)) || (y_factor == UpShift(1))) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */<   windows->magnify.x=DownShift(x_factor*windows->magnify.x);<   windows->magnify.y=DownShift(y_factor*windows->magnify.y);   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */8   windows->image.x=DownShift(x_factor*windows->image.x);8   windows->image.y=DownShift(y_factor*windows->image.y);:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } -   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)7     XMakePanImage(display,resource_info,windows,image);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);)   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XCropImage allows the user to select a region of the image andI %  crop, copy, or cut it.  For copy or cut, the image can subsequently be . %  composited onto the image with XPasteImage. % + %  The format of the XCropImage routine is:  % @ %    status=XCropImage(display,resource_info,windows,image,mode) % + %  A description of each parameter follows:  % ? %    o status: Function XCropImage returns True if the image is J %      copyped.  False is returned is there is a memory shortage or if the! %      image fails to be copyped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  % F %    o mode: This unsigned value specified whether the image should be %      cropped, copied, or cut.  %  %  */H static unsigned int XCropImage(display,resource_info,windows,image,mode) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;    unsigned int   mode;  {  #define CropModeHelpOp  0  #define CropModeDismissOp  1 #define RectifyModeCopyOp  0 #define RectifyModeHelpOp  1 #define RectifyModeDismissOp  2   
   static char      *CropModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      Image      *crop_image;     RectangleInfo      crop_info,     highlight_info;      register RunlengthPacket     *p;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   switch (mode)    {      case CopyMode:     { #       windows->command.name="Copy";        break;     }      case CropMode:     { #       windows->command.name="Crop";        break;     }      case CutMode:      { "       windows->command.name="Cut";       break;     }    } +   RectifyModeMenu[0]=windows->command.name;    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CropModeHelpOp:           {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           } !           case CropModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of cropping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             crop_info.x=windows->image.x+event.xbutton.x; 9             crop_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /**         User want to exit without croping.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*4             User has committed to croping rectangle.           */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False);            state|=ExitState; ;           if (strcmp(windows->command.name,"Rectify") == 0)              break;*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } L       if (((crop_info.x != x) && (crop_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;            if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             { =               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }            if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);	         }        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);           if (id >= 0)             switch (id) 
             { %               case RectifyModeCopyOp:                { !                 state|=ExitState;                  break;               } %               case RectifyModeHelpOp:                { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);                 switch (mode)                  {                     case CopyMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,C                       "Help Viewer - Image Copying",ImageCopyHelp);                      break;                   }                     case CropMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,D                       "Help Viewer - Image Cropping",ImageCropHelp);                     break;                   }                    case CutMode:                    { H                     XTextViewWidget(display,resource_info,windows,False,B                       "Help Viewer - Image Cutting",ImageCutHelp);                     break;                   }                  } P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               } (               case RectifyModeDismissOp:               {                  /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;                  break;               }                default:                 break;
             }            continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);               switch (mode)                {                  case CopyMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,A                     "Help Viewer - Image Copying",ImageCopyHelp);                    break;                 }                  case CropMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,B                     "Help Viewer - Image Cropping",ImageCropHelp);                   break;                 }                  case CutMode:                  { F                   XTextViewWidget(display,resource_info,windows,False,@                     "Help Viewer - Image Cutting",ImageCutHelp);                   break;                 }                } N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    if (mode == CropMode) <     if ((crop_info.width != windows->image.ximage->width) ||<         (crop_info.height != windows->image.ximage->height))       { 
         /*D           Reconfigure Image window as defined by cropping rectangle.
         */;         XSetCropGeometry(display,windows,&crop_info,image); <         windows->image.window_changes.width=crop_info.width;>         windows->image.window_changes.height=crop_info.height;D         (void) XConfigureImage(display,resource_info,windows,image);         return(True);        }    /*0     Copy image before applying image transforms.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    crop_info.x+=x; 2   crop_info.x=DownShift(crop_info.x*scale_factor);:   crop_info.width=DownShift(crop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    crop_info.y+=y; 2   crop_info.y=DownShift(crop_info.y*scale_factor);<   crop_info.height=DownShift(crop_info.height*scale_factor);)   crop_image=CropImage(image,&crop_info); )   XSetCursorState(display,windows,False); #   if (crop_image == (Image *) NULL)      return(False);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image);    copy_image=crop_image;   if (mode == CopyMode)      { B       (void) XConfigureImage(display,resource_info,windows,image);       return(True);      }    /*     Cut image.   */   image->class=DirectClass;    if (!image->matte)     {        /*         Initialize matte data.       */       p=image->pixels;(       for (x=0; x < image->packets; x++)       {          p->index=Opaque;         p++;       }        image->matte=True;     }    if (UncompressImage(image)) (     for (y=0; y < crop_info.height; y++)     { A       p=image->pixels+(crop_info.y+y)*image->columns+crop_info.x; )       for (x=0; x < crop_info.width; x++)        {          p->index=Transparent;          p++;       }      }    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. % 8 %  The format of the XDisplayBackgroundImage routine is: % B %      status=XDisplayBackgroundImage(display,resource_info,image) % + %  A description of each parameter follows:  % C %    o status: Function XDisplayBackgroundImage returns True if the , %      designated window is the root window. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */H static unsigned int XDisplayBackgroundImage(display,resource_info,image) Display    *display;   
 XResourceInfo    *resource_info;    Image 	   *image;  {    char     visual_type[MaxTextLength];      unsigned int     height,      status, 
     width;     Window     root_window;     XGCValues      context_values;      XPixelInfo     pixel_info;      XResourceInfo      resources;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      XWindowAttributes      window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL; %   window_info.ximage=(XImage *) NULL; *   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL; "   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display)); :   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;    else     { -       if (isdigit(*resource_info->window_id)) ?         window_info.id=XWindowByID(display,root_window,(Window) F           strtol((char *) resource_info->window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id= F           XWindowByName(display,root_window,resource_info->window_id);     } &   if (window_info.id == (Window) NULL)I     Error("No window with specified id exists",resource_info->window_id);    /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)'     (void) sprintf(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual));    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) K     Error("Unable to create standard colormap","Memory allocation failed"); %   map_info->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL;    /*     Initialize visual info.    */   resources=(*resource_info); #   resources.map_type=(char *) NULL; $   resources.visual_type=visual_type;;   visual_info=XBestVisualInfo(display,map_info,&resources); *   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);    /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.    */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground |P"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.    */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,       resource_info,&window_info);   /*     Create the X image.    */#   window_info.width=image->columns;c3   if (window_info.width >= window_attributes.width) .     window_info.width=window_attributes.width;!   window_info.height=image->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;O   status=XMakeImage(display,resource_info,&window_info,image,window_info.width,      window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   window_info.x=0;   window_info.y=0;   if (resource_info->debug)      {9C       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",image->filename, 1         image->scene,image->columns,image->rows);        if (image->colors != 0) 4         (void) fprintf(stderr,"%uc ",image->colors);2       (void) fprintf(stderr,"%s\n",image->magick);     }    /*I     Adjust image dimensions as specified by backdrop or geometry options.    */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {        /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)-p)         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     }a5   if (resource_info->image_geometry != (char *) NULL)o     { 
       char(         default_geometry[MaxTextLength];  	       into         flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints();r,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry,yJ         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity); $       if (flags & (XValue | YValue))	         {d(           width=window_attributes.width;*           height=window_attributes.height;	         }c!       XFree((void *) size_hints);u     }n   /*     Create the X pixmap.   */   window_info.pixmap=pI     XCreatePixmap(display,window_info.id,width,height,window_info.depth); *   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);%   /*!     Display pixmap on the window.i   */C   if ((width > window_info.width) || (height > window_info.height))rK     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,l       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,u     window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);e   /*     Free resources.s   */*   XFreePixmap(display,window_info.pixmap);$   XDestroyImage(window_info.ximage);0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor);a$   if (window_info.id != root_window)D     XFreeStandardColormap(display,visual_info,map_info,&pixel_info);   else     {26       if (pixel_info.pixels != (unsigned long *) NULL))         free((char *) pixel_info.pixels);a2       if (pixel_info.gamma_map != (XColor *) NULL),         free((char *) pixel_info.gamma_map);     }i   XFree((void *) map_info);k   XFree((void *) visual_info);(   return(window_info.id == root_window); }o o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%vO %                                                                             %oO %                                                                             %iO %                                                                             % O %   X D i s p l a y I m a g e                                                 %oO %                                                                             % O %                                                                             %zO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.i %a. %  The format of the XDisplayImage routine is: % N %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) %a+ %  A description of each parameter follows:  % F %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Load Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.f %eE %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %-7 %    o argv: Specifies the application's argument list.m % / %    o argc: Specifies the number of arguments.e %aG %    o image: Specifies an address to an address of an Image structure;h %      returned from ReadImage.f %  %g */H static Image *XDisplayImage(display,resource_info,argv,argc,image,state) Displays   *display;   
 XResourceInfo    *resource_info;a   char	   **argv;-   intz   argc;    Image 
   **image;  
 unsigned longn	   *state;s { 4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  9 #define MaxWindows  10 #define MagickTitle  "Commands"o  
   static char      *CommandMenu[]=n     {a
       "File", 
       "Edit", 
       "View",y       "Transform",       "Enhance",       "Effects",       "Image Edit",e       "Miscellany",o
       "Help",a       (char *) NULL      },     *FileMenu[]=     {s       "Load...",
       "Next",m       "Former",e       "Select...",       "Save...",       "Print...",        "Delete...",       "Canvas...",       "Visual Directory...",
       "Quit",e       (char *) NULLi     },     *EditMenu[]=     {-
       "Undo", 
       "Redo",e       "Cut",
       "Copy",Y       "Paste",       (char *) NULL      },     *ViewMenu[]=     {d       "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Apply",       "Refresh",       "Restore",       (char *) NULLt     },     *TransformMenu[]=r     { 
       "Crop",s
       "Chop", 
       "Flop",o
       "Flip",s       "Rotate Right",        "Rotate Left",       "Rotate...",       "Shear...",l       "Trim Edges",m       (char *) NULL      },     *EnhanceMenu[]=      {        "Hue...",n       "Saturation...",       "Brightness...",       "Gamma...",n       "Spiff",
       "Dull",t       "Equalize",        "Normalize",       "Negate",t       "Grayscale",       "Quantize...",       (char *) NULLu     },     *EffectsMenu[]=      {r       "Despeckle",       "Peak Noise",o       "Sharpen...",n       "Blur...",       "Edge Detect",       "Emboss",y       "Spread",-       "Oil Painting",-       "Raise...",i       "Segment...",t       (char *) NULLa     },     *ImageEditMenu[]=h     {        "Annotate...",       "Draw...",       "Color...",r       "Matte...",t       "Composite...",        "Add Border...",       "Add Frame...",        "Comment...",        "Region of Interest...",       (char *) NULLg     },     *MiscellanyMenu[]=     {e       "Image Info",.       "Zoom Image",'       "Show Histogram",d       "Background...",       "Slide Show...",       "Preferences...",h       (char *) NULL      },     *HelpMenu[]=     {        "Overview",        "Browse Documentation",e       "About Display",       (char *) NULL      },     *ShortCutsMenu[]=      {c
       "Next",        "Load...",       "Save...",
       "Undo",%       "Restore",
       "Crop",%       "Gamma...",%       "Image Info", 
       "Quit",        (char *) NULL      },     *ImmutableMenu[]=      {        "Image Info", 
       "Quit",        (char *) NULL      };  
   static char      **Menus[MagickMenus]=      {        FileMenu,        EditMenu,        ViewMenu,        TransformMenu,       EnhanceMenu,       EffectsMenu,       ImageEditMenu,       MiscellanyMenu,        HelpMenu     };     static KeySym      CommandKeys[]=     {        XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,     },     FileKeys[]=      {i       XK_l,o       XK_n,s       XK_f,        XK_F2,       XK_s,u       XK_p,        XK_Delete,       XK_C,        XK_V,n
       XK_q     },     EditKeys[]=      {i       XK_u,        XK_Redo,       XK_F3,       XK_F4,       XK_F5t     },     ViewKeys[]=      {t       XK_less,       XK_o,n       XK_greater,n       XK_percent,        XK_A,t       XK_at,
       XK_r     },     TransformKeys[]=     {o       XK_bracketleft,g       XK_bracketright,
       XK_bar,n       XK_minus,n       XK_slash,3       XK_backslash,i       XK_asterisk,       XK_F6,
       XK_t     },     EnhanceKeys[]=     {]       XK_F7,       XK_F8,       XK_F9,       XK_g,t
       XK_F10,r
       XK_F11,o       XK_equal,u       XK_N,w       XK_asciitilde,       XK_G,o       XK_numbersign      },     EffectsKeys[]=     {        XK_D,t       XK_P,d       XK_S,        XK_B,o       XK_E,        XK_M,b
       XK_F13,        XK_O,        XK_asciicircum, 
       XK_Z     },     ImageEditKeys[]=     {"       XK_a,o       XK_d,        XK_c,a       XK_m,n       XK_x,-       XK_b,        XK_F,E       XK_exclam,
       XK_R     },     MiscellanyKeys[]=      {g       XK_i,        XK_z,g       XK_H,r       XK_ampersand,t       XK_comma,d       XK_F12     },     HelpKeys[]=p     {        XK_h,t       XK_Find,
       XK_v     },     ShortCutsKeys[]=     {e       XK_n,i       XK_l,        XK_s,        XK_u,t       XK_r,i       XK_bracketleft,        XK_g,v       XK_i, 
       XK_q     },     ImmutableKeys[]=     {        XK_i,/
       XK_q     };     static KeySym      *Keys[MagickMenus]=p     {i       FileKeys,g       EditKeys,        ViewKeys,        TransformKeys,       EnhanceKeys,       EffectsKeys,       ImageEditKeys,       MiscellanyKeys,q       HelpKeys     };     char     command[MaxTextLength],i!     resource_name[MaxTextLength];-     Image      *displayed_image,      *loaded_image;     int 
     entry,     id,u     status;w     KeySym     key_symbol;      register int     i;  
   static chare%     working_directory[MaxTextLength];f     static Windowt     root_window;     static XClassHinta     *class_hints;e     static XFontStruct     *font_info;e     static XPixelInfoE     icon_pixel,      pixel_info;      static XPointt
     vid_info;      static XResourceInfo     icon_resources;s     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual,a(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHints      *manager_hints;      static unsigned into     number_windows;s  
   struct statu     file_info;     time_t
     timer,     time_stamp,-     update_time;     unsigned int     context_mask;e     XEvent
     event;     XGCValues      context_values;t     XWindowChanges     window_changes;   *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {i       /*#         Allocate standard colormap.P       */       if (resource_info->debug) 	         {/%           XSynchronize(display,True);c9           (void) fprintf(stderr,"Version: %s\n",Version); 	         }y(       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) || 3           (icon_map == (XStandardColormap *) NULL)) O         Error("Unable to create standard colormap","Memory allocation failed"); )       map_info->colormap=(Colormap) NULL;d)       icon_map->colormap=(Colormap) NULL;i/       pixel_info.pixels=(unsigned long *) NULL;o+       pixel_info.gamma_map=(XColor *) NULL;e,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL;e*       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL;r,       icon_pixel.annotate_context=(GC) NULL;/       icon_pixel.pixels=(unsigned long *) NULL;b+       icon_pixel.gamma_map=(XColor *) NULL;t       /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default"; -       icon_resources.colormap=SharedColormap; B       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);a       if (resource_info->debug)t	         {*-           (void) fprintf(stderr,"Visual:\n");hN           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth);pC           (void) fprintf(stderr,"  size of colormap: %d entries\n",v(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",)'             visual_info->bits_per_rgb);i	         }        /*         Allocate atoms.        */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL))G         Error("Unable to create X windows","Memory allocation failed");yF       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);N       windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);N       windows->im_retain_colors=XInternAtom(display,"IM_RETAIN_COLORS",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);       if (resource_info->debug) 	         { 0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols);%=           (void) fprintf(stderr,"    delete window: 0x%lx\n",a'             windows->wm_delete_window);X:           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n",o#             windows->im_protocols);n=           (void) fprintf(stderr,"    update widget: 0x%lx\n",s'             windows->im_update_widget);X?           (void) fprintf(stderr,"    update colormap: 0x%lx\n", )             windows->im_update_colormap); <           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);=           (void) fprintf(stderr,"    retain colors: 0x%lx\n", '             windows->im_retain_colors); F           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);	         }d       /*)         Allocate class and manager hints.e       */$       class_hints=XAllocClassHint();$       manager_hints=XAllocWMHints();1       if ((class_hints == (XClassHint *) NULL) ||M/           (manager_hints == (XWMHints *) NULL))o:         Error("Unable to allocate X hints",(char *) NULL);       /*.         Determine group leader if we have one.       */;       root_window=XRootWindow(display,visual_info->screen); -       windows->group_leader.id=(Window) NULL;u7       if (resource_info->window_group != (char *) NULL)e	         { 4           if (isdigit(*resource_info->window_group))M             windows->group_leader.id=XWindowByID(display,root_window,(Window)yM               strtol((char *) resource_info->window_group,(char **) NULL,0));l8           if (windows->group_leader.id == (Window) NULL)%             windows->group_leader.id=,M               XWindowByName(display,root_window,resource_info->window_group); 	         }d       /*         Initialize window id's.;       */       number_windows=0; 8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image); 8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command);;:       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup);;;       magick_windows[number_windows++]=(&windows->magnify);o7       magick_windows[number_windows++]=(&windows->pan);*(       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;S       vid_info.y=0;n     }m   /*!     Initialize Standard Colormap.s   */   loaded_image=(Image *) NULL;   displayed_image=(*image);    if (resource_info->debug)      { M       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename,)O         displayed_image->scene,displayed_image->columns,displayed_image->rows);d'       if (displayed_image->colors != 0) >         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     }nJ   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.p   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); 3   font_info=XBestFont(display,resource_info,False);t(   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);    /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);e%   class_hints->res_name="superclass"; #   class_hints->res_class="Display";.-   manager_hints->flags=InputHint | StateHint;r   manager_hints->input=False; .   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);    if (resource_info->debug);N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid;m>   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;/   if (pixel_info.annotate_context != (GC) NULL)w1     XFreeGC(display,pixel_info.annotate_context);f   pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)=<     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel; -   if (pixel_info.widget_context != (GC) NULL)t/     XFreeGC(display,pixel_info.widget_context);    pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)F<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id,(0     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.    */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL, $     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;    class_hints->res_name="icon";u-   manager_hints->flags=InputHint | StateHint;e   manager_hints->input=False;"+   manager_hints->initial_state=IconicState;mF   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug) H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.;   *//   if (icon_pixel.annotate_context != (GC) NULL)o1     XFreeGC(display,icon_pixel.annotate_context);e>   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id,g1     GCBackground | GCForeground,&context_values); /   if (icon_pixel.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;    /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)r     {.)       free((char *) windows->image.name);h.       free((char *) windows->image.icon_name);     }nD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image);dB   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char));rJ   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))"     {        /*#         User specified window name.n       */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);d     }p   else     {l
       char         *p;          /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+strlen(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator))          p--;A       (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p,l          displayed_image->scene);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);0       (void) strcpy(windows->image.icon_name,p);     }    if (resource_info->immutable)t"     windows->image.immutable=True;8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;H   if (windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;J   if (windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask |oG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))      {f       /*#         Initialize backdrop window.        */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen); K       windows->backdrop.height=XDisplayHeight(display,visual_info->screen); '       windows->backdrop.border_width=0;r'       windows->backdrop.immutable=True;tJ       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop"; B       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state=;:         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug)a>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id);e-       if (windows->image.id != (Window) NULL)p	         {y4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }t       /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition; I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)-a$         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);V     }e+   if (resource_info->name == (char *) NULL) &     class_hints->res_name=client_name;   else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state= 6     resource_info->iconic ? IconicState : NormalState;0   if (windows->group_leader.id != (Window) NULL)     {i       /*         Follow the leader.       */,       manager_hints->flags|=WindowGroupHint;;       manager_hints->window_group=windows->group_leader.id;nI       XSelectInput(display,windows->group_leader.id,StructureNotifyMask);        if (resource_info->debug)+B         (void) fprintf(stderr,"Window id: 0x%lx (group leader)\n",$           windows->group_leader.id);     }W   XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image);y0   if (windows->group_leader.id != (Window) NULL)M     XSetTransientForHint(display,windows->image.id,windows->group_leader.id);    if (resource_info->debug) J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.)   */   windows->image.x=0;,   windows->image.y=0;sJ   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*     Initialize Info widget.o   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";!   windows->info.icon_name="Info";-   windows->info.border_width=1;t   windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition;a+   windows->info.attributes.save_under=True;t4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;f   class_hints->res_name="info";&?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;x+   manager_hints->initial_state=NormalState;e0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);C   XSetTransientForHint(display,windows->info.id,windows->image.id);i   if (windows->image.mapped)C     XWithdrawWindow(display,windows->info.id,windows->info.screen);c   if (resource_info->debug)tH     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command);>$   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);t9   (void) sprintf(resource_name,"%s.command",client_name);_O   windows->command.geometry=XGetResourceClass(resource_info->resource_database,l,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped;*.   windows->command.attributes.save_under=True;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask |dJ     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;i+   manager_hints->initial_state=NormalState;"0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command);oC   windows->command.highlight_stipple=XCreateBitmapFromData(display,o@     windows->command.id,(char *) HighlightBitmap,HighlightWidth,     HighlightHeight); @   windows->command.shadow_stipple=XCreateBitmapFromData(display,H     windows->command.id,(char *) ShadowBitmap,ShadowWidth,ShadowHeight);F   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);   if (resource_info->debug)pN     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize Widget window.x   */*   if (windows->widget.id != (Window) NULL)(     free((char *) windows->widget.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);8   (void) sprintf(resource_name,"%s.widget",client_name);N   windows->widget.geometry=XGetResourceClass(resource_info->resource_database,,     resource_name,"geometry",(char *) NULL);C   windows->widget.name=(char *) malloc(MaxTextLength*sizeof(char)); #   if (windows->widget.name == NULL).F     Error("Unable to create Image window","Memory allocation failed");   *windows->widget.name='\0'; !   windows->widget.border_width=0; #   windows->widget.flags|=PPosition;i6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True; L   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |t;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;r!   class_hints->res_name="widget";_?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;s   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);G   windows->widget.highlight_stipple=windows->command.highlight_stipple; A   windows->widget.shadow_stipple=windows->command.shadow_stipple; E   XSetTransientForHint(display,windows->widget.id,windows->image.id);    if (resource_info->debug)aL     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL) '     free((char *) windows->popup.name); D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup); B   windows->popup.name=(char *) malloc(MaxTextLength*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create Image window","Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped;-,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask |nG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |y;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;i    class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;e   manager_hints->input=True;+   manager_hints->initial_state=NormalState;a0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup); F   windows->popup.highlight_stipple=windows->command.highlight_stipple;@   windows->popup.shadow_stipple=windows->command.shadow_stipple;D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug) K     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);    /*)     Initialize Magnify window and cursor.e   */+   if (windows->magnify.id != (Window) NULL)e)     free((char *) windows->magnify.name);)D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify); 9   (void) sprintf(resource_name,"%s.magnify",client_name);;O   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);D   windows->magnify.name=(char *) malloc(MaxTextLength*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create Magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify); @   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color, %     resource_info->foreground_color);e/   if (windows->magnify.cursor == (Cursor) NULL)f3     Error("Unable to create cursor",(char *) NULL);t%   windows->magnify.width=MagnifySize;o&   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize; *   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize;(*   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify;n.   windows->magnify.attributes.save_under=True;=   windows->magnify.attributes.cursor=windows->magnify.cursor;;N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;"   class_hints->res_name="magnify";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;t   manager_hints->input=True;+   manager_hints->initial_state=NormalState;&0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->magnify);    if (resource_info->debug)nN     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);o   windows->pan.name="Pan Icon";f7   XBestIconSize(display,&windows->pan,displayed_image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {e     windows->pan.width<<=1;t     windows->pan.height<<=1;   }i5   (void) sprintf(resource_name,"%s.pan",client_name); K   windows->pan.geometry=XGetResourceClass(resource_info->resource_database,t,     resource_name,"geometry",(char *) NULL);-   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,i       &windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;*   windows->pan.attributes.save_under=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask | F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hints->res_name="pan";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState;y0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->pan);a   if (resource_info->debug) F     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Respond to events.   */-   (void) SetMonitorHandler(XProgressMonitor);x%   (void) SetWarningHandler(XWarning);/3   timer=time((time_t *) NULL)+resource_info->delay;*   update_time=0;   if (resource_info->update)     {(       /*3         Determine when file data was last modified.a       */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;t     }>   *state&=(~FormerImageState);   *state&=(~MontageImageState);    *state&=(~NextImageState);   do   {      /*       Handle a window event.     */"     if (resource_info->delay != 0)       { *         if (timer < time((time_t *) NULL))%           if (!resource_info->update) /             *state|=NextImageState | ExitState;            else
             {p               /*5                 Determine if image file was modified.y               */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {                      /*&                       Redisplay image.                     */F                     (void) strcpy(resource_info->image_info->filename,1                       displayed_image->filename);nF                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL) 9                       *state|=NextImageState | ExitState;,                   } ?               timer=time((time_t *) NULL)+resource_info->delay;y
             })9         if (XEventsQueued(display,QueuedAfterFlush) == 0)            {              /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);              continue;i           }        } %     time_stamp=time((time_t *) NULL);r     XNextEvent(display,&event);e     if (!windows->image.stasis) C       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0;e1     if (event.xany.window == windows->command.id)e       {o
         /*3           Select a command from the Command widget.o
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)            continue;a/         (void) strcpy(command,CommandMenu[id]); #         key_symbol=CommandKeys[id];f         if (id < MagickMenus)n           {t             /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);e             if (entry < 0)               continue;=4             (void) strcpy(command,Menus[id][entry]);'             key_symbol=Keys[id][entry];            }=(         if (key_symbol != XK_VoidSymbol)F           loaded_image=XMagickCommand(display,resource_info,windows,0,)             key_symbol,&displayed_image);(         continue;        }t     switch (event.type)      {u       case ButtonPress:n       {o!         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))r           {              /*-               Convert Alt-Button3 to Button2.i             */)             event.xbutton.button=Button2;g-             event.xbutton.state&=(~Mod1Mask);t           }t9         if (event.xbutton.window == windows->backdrop.id)            {nG             XSetInputFocus(display,event.xbutton.window,RevertToParent,f"               event.xbutton.time);             break;           } 6         if (event.xbutton.window == windows->image.id)           {&)             switch (event.xbutton.button)r
             {n               case Button1:                { -                 if (resource_info->immutable)                    {                      /*?                       Select a command from the Immutable menu.i                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,t                       command);k#                     if (entry >= 0)hH                       loaded_image=XMagickCommand(display,resource_info,I                         windows,0,ImmutableKeys[entry],&displayed_image);t                     break;                   }v                 /*+                   Map/unmap Command widget.e                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);o                 else                   {-F                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL);0<                     XMapRaised(display,windows->command.id);                   }w                 break;               }                case Button2:f               {_                 /*8                   User pressed the image magnify button.                 */F                 (void) XMagickCommand(display,resource_info,windows,0,2                   (KeySym) XK_z,&displayed_image);6                 XMagnifyImage(display,windows,&event);                 break;               }+               case Button3:e               {l>                 if (displayed_image->montage != (char *) NULL)                   {                      /*J                       Load or delete a tile from a visual image directory.                     */J                     loaded_image=XTileImage(display,resource_info,windows,.                       displayed_image,&event);7                     if (loaded_image != (Image *) NULL)aM                       *state|=MontageImageState | NextImageState | ExitState;a0                     vid_info.x=windows->image.x;0                     vid_info.y=windows->image.y;                     break;                   }m-                 if (resource_info->immutable)S                   {i                     /*?                       Select a command from the Immutable menu.n                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,o                       command);p#                     if (entry >= 0),H                       loaded_image=XMagickCommand(display,resource_info,I                         windows,0,ImmutableKeys[entry],&displayed_image);h                     break;                   }n                 /*<                   Select a command from the Short Cuts menu.                 */M                 entry=XMenuWidget(display,windows,"Short Cuts",ShortCutsMenu,y                   command);w                 if (entry >= 0)oN                   loaded_image=XMagickCommand(display,resource_info,windows,0,;                     ShortCutsKeys[entry],&displayed_image);i                 break;               }e               default:                 break;
             }r             break;           })8         if (event.xbutton.window == windows->magnify.id)           {              char%               command[MaxTextLength];%               int%               factor;                static char                *MagnifyMenu[]=                {                  "2",                 "3",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 (char *) NULL,               };               static KeySym                MagnifyKeys[]=               {                  XK_2,                  XK_4,                  XK_5,                  XK_6,                  XK_7,                  XK_8,                  XK_9,                  XK_3               };               /*;               Select a magnify factor from the pop-up menu.c             */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)K               XMagnifyWindowCommand(display,windows,0,MagnifyKeys[factor]);s             break;           }s4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           }t9         timer=time((time_t *) NULL)+resource_info->delay;f         break;       }s       case ButtonRelease:          break;       case ClientMessage:p       { !         if (resource_info->debug)cI           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n", <             event.xclient.window,event.xclient.message_type,J             event.xclient.format,(unsigned long) event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           {IC             if (*event.xclient.data.l == windows->im_update_widget)g               {a2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);m                 break;               }gE             if (*event.xclient.data.l == windows->im_update_colormap)e               {o                 /*=                   Update graphic context and window colormap.i                 */2                 for (i=0; i < number_windows; i++)                 {d@                   if (magick_windows[i]->id == windows->icon.id)                     continue;lN                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context, @                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel= 6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel= 2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 }m(                 if (windows->pan.mapped)                   {nG                     XSetWindowBackgroundPixmap(display,windows->pan.id, +                       windows->pan.pixmap);e:                     XClearWindow(display,windows->pan.id);7                     XDrawPanRectangle(display,windows);                    }p:                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);X                 break;               }wB             if (*event.xclient.data.l == windows->im_former_image)               {o5                 *state|=FormerImageState | ExitState;I                 break;               }C@             if (*event.xclient.data.l == windows->im_next_image)               {I3                 *state|=NextImageState | ExitState;                  break;               }iC             if (*event.xclient.data.l == windows->im_retain_colors)2               {t*                 *state|=RetainColorsState;                 break;               } :             if (*event.xclient.data.l == windows->im_exit)               { "                 *state|=ExitState;                 break;               }              break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)            break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {W             *state|=ExitState;             break;           }d4         if (event.xclient.window == windows->pan.id)           {m             /*E               Restore original image size when pan window is deleted.              */M             windows->image.window_changes.width=windows->image.ximage->width;yO             windows->image.window_changes.height=windows->image.ximage->height; A             (void) XConfigureImage(display,resource_info,windows,                displayed_image);            }          break;       }n       case ConfigureNotify:        {i!         if (resource_info->debug)sK           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width,eJ             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event); 9         if (event.xconfigure.window == windows->image.id)            {              /*3               Image window has a new configuration.              */1             if (event.xconfigure.send_event != 0)                {e                 XWindowChanges!                   window_changes;                    /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL) /                   if (!windows->command.mapped)                      {a)                       windows->command.x= E                         event.xconfigure.x-windows->command.width-25;e<                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id, K                         windows->command.screen,CWX | CWY,&window_changes);E                     } ?                 if (windows->magnify.geometry == (char *) NULL) /                   if (!windows->magnify.mapped)                      { )                       windows->magnify.x=BE                         event.xconfigure.x+event.xconfigure.width+25;n<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id,eK                         windows->magnify.screen,CWX | CWY,&window_changes);                      } ;                 if (windows->pan.geometry == (char *) NULL) +                   if (!windows->pan.mapped)                      { %                       windows->pan.x=aE                         event.xconfigure.x+event.xconfigure.width+25;(%                       windows->pan.y= F                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id, G                         windows->pan.screen,CWX | CWY,&window_changes);                      }                }|C             if ((event.xconfigure.width == windows->image.width) && C                 (event.xconfigure.height == windows->image.height))s               {gC                 if (windows->image.mapped && windows->image.stasis)oJ                   XRefreshWindow(display,&windows->image,(XEvent *) NULL);                 break;               }l8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;              windows->image.y=0; :             if (displayed_image->montage != (char *) NULL)               { ,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               }t?             if (windows->image.mapped && windows->image.stasis)n               {                  /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;dM                 windows->image.window_changes.height=event.xconfigure.height;dE                 (void) XConfigureImage(display,resource_info,windows,f#                   displayed_image);                }eJ             if ((event.xconfigure.width < windows->image.ximage->width) ||J                 (event.xconfigure.height < windows->image.ximage->height))               {o4                 XMapRaised(display,windows->pan.id);3                 XDrawPanRectangle(display,windows);o               }t             else&               if (windows->pan.mapped)M                 XWithdrawWindow(display,windows->pan.id,windows->pan.screen);*             break;           }u;         if (event.xconfigure.window == windows->magnify.id);           {.             MonitorHandler               handler;               unsigned int               magnify;               /*5               Magnify window has a new configuration.i             */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)                break;             magnify=1;5             while (magnify <= event.xconfigure.width)h               magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))i               {f-                 window_changes.width=magnify;t.                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id, N                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               }.=             handler=SetMonitorHandler((MonitorHandler) NULL);mF             status=XMakeImage(display,resource_info,&windows->magnify,N               displayed_image,windows->magnify.width,windows->magnify.height);I             status|=XMakePixmap(display,resource_info,&windows->magnify);o              if (status == False)D               Error("Unable to create magnify image",(char *) NULL);/             XMakeMagnifyImage(display,windows); .             (void) SetMonitorHandler(handler);             break;           }m7         if (event.xconfigure.window == windows->pan.id)t           {o             /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0)                { 2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               } 6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           }e8         if (event.xconfigure.window == windows->icon.id)           {x             /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width;o9             windows->icon.height=event.xconfigure.height;o             break;           }o         break;       }p       case DestroyNotify:        {f
         /*"           Group leader has exited.
         */D         if (event.xdestroywindow.window == windows->group_leader.id)           {g             *state|=ExitState;             break;           }=         break;       }n       case EnterNotify:        { 
         /*'           Selectively install colormap.n
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) 8             XInductColormap(display,map_info->colormap);         break;       }        case Expose:       {i!         if (resource_info->debug)f>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y); 
         /*/           Refresh windows that are now exposed.i
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             { =               XRefreshWindow(display,&windows->image,&event);i?               timer=time((time_t *) NULL)+resource_info->delay;m               break;
             }K8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)o(             if (windows->magnify.mapped)               {i3                 XMakeMagnifyImage(display,windows);e                 break;               }a4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0)a
             {f1               XDrawPanRectangle(display,windows);                break;
             }e5         if (event.xexpose.window == windows->icon.id)U'           if (event.xexpose.count == 0)h
             {.<               XRefreshWindow(display,&windows->icon,&event);               break;
             }i         break;       }l       case KeyPress:       {s         inte           length;i  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);;         *(command+length)='\0';w!         if (resource_info->debug)aN           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);%         if (resource_info->immutable)            {n=             if ((key_symbol != XK_q) && (key_symbol != XK_i))v               XBell(display,0);u             elseO               (void) XMagickCommand(display,resource_info,windows,0,key_symbol,%"                 &displayed_image);             break;           } 3         if (event.xkey.window == windows->image.id) D           loaded_image=XMagickCommand(display,resource_info,windows,:             event.xkey.state,key_symbol,&displayed_image);5         if (event.xkey.window == windows->magnify.id) M           XMagnifyWindowCommand(display,windows,event.xkey.state,key_symbol); 1         if (event.xkey.window == windows->pan.id) !           if (key_symbol == XK_q) I             XWithdrawWindow(display,windows->pan.id,windows->pan.screen);            elseA             if ((key_symbol == XK_F1) || (key_symbol == XK_Help))%B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);             elseA               XTranslateImage(display,windows,*image,key_symbol);P9         timer=time((time_t *) NULL)+resource_info->delay;d         break;       }i       case KeyRelease:       {c
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),o/           &key_symbol,(XComposeStatus *) NULL);p!         if (resource_info->debug);G           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,e             *command);         break;       }        case LeaveNotify:e       {e
         /*)           Selectively uninstall colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) :             XUninductColormap(display,map_info->colormap);         break;       }        case MapNotify:,       { !         if (resource_info->debug)aI           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window); 6         if (event.xmap.window == windows->backdrop.id)           { D             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime);<*             windows->backdrop.mapped=True;             break;           }>3         if (event.xmap.window == windows->image.id)            {D6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap); <             if (strcmp(displayed_image->magick,"LOGO") == 0)K               loaded_image=XLoadImage(display,resource_info,windows,False);SH             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;              break;           } 5         if (event.xmap.window == windows->magnify.id)            { /             XMakeMagnifyImage(display,windows);+)             windows->magnify.mapped=True; K             XWithdrawWindow(display,windows->info.id,windows->info.screen);x             break;           } 1         if (event.xmap.window == windows->pan.id)a           {eI             XMakePanImage(display,resource_info,windows,displayed_image);o%             windows->pan.mapped=True;              break;           }t2         if (event.xmap.window == windows->info.id)           {o&             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {              /*#               Create an icon image.)             */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon, H               displayed_image,windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon); @             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id);t&             windows->icon.mapped=True;             break;           } 5         if (event.xmap.window == windows->command.id)e           {,)             windows->command.mapped=True;I             break;           }o3         if (event.xmap.window == windows->popup.id)o           {p'             windows->popup.mapped=True;n             break;           }o4         if (event.xmap.window == windows->widget.id)           {i(             windows->widget.mapped=True;             break;           }l         break;       }        case MappingNotify:        {H1         XRefreshKeyboardMapping(&event.xmapping);          break;       }[       case NoExpose:         break;       case ReparentNotify:       {n!         if (resource_info->debug) B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }d       case UnmapNotify:e       { !         if (resource_info->debug) M           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);C8         if (event.xunmap.window == windows->backdrop.id)           {t+             windows->backdrop.mapped=False;"             break;           } 5         if (event.xunmap.window == windows->image.id)v           { (             windows->image.mapped=False;             break;           }o7         if (event.xunmap.window == windows->magnify.id)a           {r*             windows->magnify.mapped=False;             break;           }s3         if (event.xunmap.window == windows->pan.id)e           {b&             windows->pan.mapped=False;             break;           }(4         if (event.xunmap.window == windows->info.id)           {u'             windows->info.mapped=False;n             break;           };4         if (event.xunmap.window == windows->icon.id)           {s9             if (map_info->colormap == icon_map->colormap)aD               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image);nL             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;p             break;           } 7         if (event.xunmap.window == windows->command.id)l           {r*             windows->command.mapped=False;             break;           }d5         if (event.xunmap.window == windows->popup.id)o           { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);i(             windows->popup.mapped=False;             break;           }t6         if (event.xunmap.window == windows->widget.id)           { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);e)             windows->widget.mapped=False;i             break;           }          break;       }]       default:       {s!         if (resource_info->debug)e?           (void) fprintf(stderr,"Event type: %d\n",event.type);h         break;       }      }    }     while (!(*state & ExitState));?   if ((*state & FormerImageState) || (*state & NextImageState))s     *state&=(~ExitState);i   /*$     Withdraw pan and Magnify window.   */   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);)   if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);    if (windows->command.mapped)I     XWithdrawWindow(display,windows->command.id,windows->command.screen);    if (!resource_info->backdrop)u!     if (windows->backdrop.mapped)        {wO         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen); 5         XDestroyWindow(display,windows->backdrop.id); +         windows->backdrop.id=(Window) NULL; I         XWithdrawWindow(display,windows->image.id,windows->image.screen);o2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       }l(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (!(*state & ExitState))     {dN       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Break,         &displayed_image);9       if (resource_info->write_filename != (char *) NULL) L         (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,           &displayed_image);     }    else     {        /*         Destroy X windows.       */(       for (i=0; i < number_windows; i++)       { 3         if (magick_windows[i]->id != (Window) NULL)r8           XDestroyWindow(display,magick_windows[i]->id);9         if (magick_windows[i]->ximage != (XImage *) NULL),3           XDestroyImage(magick_windows[i]->ximage); 7         if (magick_windows[i]->pixmap != (Pixmap) NULL) 9           XFreePixmap(display,magick_windows[i]->pixmap);        }c       /*         Free Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) H         XFreeStandardColormap(display,visual_info,map_info,&pixel_info);"       XFree((void *) class_hints);$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);        XFree((void *) map_info);o)       free((char *) windows->popup.name); *       free((char *) windows->widget.name);+       free((char *) windows->magnify.name);n.       free((char *) windows->image.icon_name);)       free((char *) windows->image.name);;       free((char *) windows); '       visual_info=(XVisualInfo *) NULL;t'       if (copy_image != (Image *) NULL)r!         DestroyImage(copy_image);      }X   /*     Change to home directory.t   */3   (void) getcwd(working_directory,MaxTextLength-1);(.   (void) chdir(resource_info->home_directory);   *image=displayed_image;    return(loaded_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,O %                                                                             %;O %                                                                             %VO %                                                                             %eO %   X D r a w I m a g e                                                       %aO %                                                                             %xO %                                                                             %aO %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XDrawEditImage draws a graphic primitive (point, line, rectangle,i %  etc.) on the image. % / %  The format of the XDrawEditImage routine is:  % G %    status=XDrawEditImage(display,resource_info,windows,degrees,image)  % + %  A description of each parameter follows:  % H %    o status: Function XDrawEditImage return True if the image is drawnG %      upon.  False is returned is there is a memory shortage or if thea  %      image cannot be drawn on. %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %v< %    o windows: Specifies a pointer to a XWindows structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */G static unsigned int XDrawEditImage(display,resource_info,windows,image)i Displayu   *display;   
 XResourceInfoC   *resource_info;    XWindows   *windows;    Imagea
   **image; {  #define DrawModePrimitiveOp  0 #define DrawModeColorOp  1 #define DrawModeStippleOp  2 #define DrawModeWidthOp  3 #define DrawModeUndoOp  4  #define DrawModeHelpOp  5n #define DrawModeDismissOp  60 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))  
   static char/     *DrawModeMenu[]=     {g       "Primitive",       "Color",       "Stipple",       "Width",
       "Undo",S
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],X     text[MaxTextLength];     Cursor     cursor;      double     degrees;     int 
     entry,     id,i     number_coordinates,a     x,     y;     RectangleInfo_     rectangle_info;X     register int     i;     static PixmapW     stipple = (Pixmap) NULL;     static unsigned int      pen_id = 0,I     primitive = PointPrimitive,l     line_width = 1;a     unsigned int
     distance,l     height,      max_coordinates,     status, 
     width;     unsigned long 
     state,
     x_factor,;
     y_factor;      Window     root_window;     XDrawInfo      draw_info;     XEvent
     event;     XPoint     *coordinate_info;X  
   XSegment     line_info;     /*     Allocate polygon info.   */   max_coordinates=2048;mD   coordinate_info=(XPoint *) malloc(max_coordinates*sizeof(XPoint));)   if (coordinate_info == (XPoint *) NULL)      {dD       Warning("Unable to draw on image","Memory allocation failed");       return(False);     }    /*     Map Command widget.f   */   windows->command.name="Draw";    windows->command.data=4;F   (void) XCommandWidget(display,windows,DrawModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,e+     windows->im_update_widget,CurrentTime);o   /*      Wait for first button press.   */;   root_window=XRootWindow(display,XDefaultScreen(display));f"   draw_info.stencil=OpaqueStencil;   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )    { 4     XQueryPosition(display,windows->image.id,&x,&y);4     XDefineCursor(display,windows->image.id,cursor);+     XSelectInput(display,windows->image.id,=@       windows->image.attributes.event_mask | PointerMotionMask);     state=DefaultState;      do     {a       if (windows->info.mapped))	         {            /*%             Display pointer position.,           */P           (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);,           XInfoWidget(display,windows,text);	         })       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);d3       if (event.xany.window == windows->command.id)i	         {e           /*5             Select a command from the Command widget.f           */A           id=XCommandWidget(display,windows,DrawModeMenu,&event);(           if (id < 0)o             continue;e           switch (id)i           {x%             case DrawModePrimitiveOp: 
             {(               static char                  *Primitives[]=                 {                    "point",                   "line",r                   "rectangle",#                   "fill rectangle",>                   "ellipse",!                   "fill ellipse",                    "polygon",!                   "fill polygon",a                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */P               primitive=XMenuWidget(display,windows,DrawModeMenu[id],Primitives,                 command)+1;u               break;
             } !             case DrawModeColorOp:p
             {r               char,                 *ColorMenu[MaxNumberPens+1];                 intg                 pen_number;                  unsigned int                 transparent;                 XColor                 color;                 /*+                 Initialize menu selections.                */3               for (i=0; i < (MaxNumberPens-2); i++)]:                 ColorMenu[i]=resource_info->pen_colors[i];7               ColorMenu[MaxNumberPens-2]="transparent"; 6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;d               /*8                 Select a pen color from the pop-up menu.               */P               pen_number=XMenuWidget(display,windows,DrawModeMenu[id],ColorMenu,                 command); !               if (pen_number < 0)                  break;:               transparent=pen_number == (MaxNumberPens-2);               if (transparent)                 { 7                   draw_info.stencil=TransparentStencil;r                   break;                 } 2               if (pen_number == (MaxNumberPens-1))                 {                    static charp7                     color_name[MaxTextLength] = "gray";                      /*5                     Select a pen color from a dialog.                    */C                   resource_info->pen_colors[pen_number]=color_name; K                   XColorBrowserWidget(display,windows,"Select",color_name);e*                   if (*color_name == '\0')                     break;                 }=               /*                 Set pen color.               */K               (void) XParseColor(display,windows->image.map_info->colormap, >                 resource_info->pen_colors[pen_number],&color);C               XBestPixel(display,windows->image.map_info->colormap,iA                 (XColor *) NULL,(unsigned int) MaxColors,&color);lF               windows->image.pixel_info->pen_colors[pen_number]=color;                pen_id=pen_number;.               draw_info.stencil=OpaqueStencil;               break;
             }o#             case DrawModeStippleOp: 
             {a               static char /                 filename[MaxTextLength] = "\0",                   *StipplesMenu[]=                 {a                   "Brick",                   "Diagonal",                    "Scales",s                   "Vertical",b                   "Wavy",u                    "Translucent",                   "Opaque",r                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               StipplesMenu[7]="Load...";N               entry=XMenuWidget(display,windows,DrawModeMenu[id],StipplesMenu,                 command);                if (entry < 0)                 break;+               if (stipple != (Pixmap) NULL) -                 XFreePixmap(display,stipple); $               stipple=(Pixmap) NULL;               if (entry == 6)                  break;               if (entry != 7)                  {                     switch (entry)                   {                      case 0:%                     {%H                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) BricksBitmap,BricksWidth,BricksHeight);                       break;                     }s                     case 1:T                     {sH                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) DiagonalBitmap,DiagonalWidth,DiagonalHeight);                       break;                     }m                     case 2:a                     {eH                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) ScalesBitmap,ScalesWidth,ScalesHeight);                       break;                     }f                     case 3:r                     { H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) VerticalBitmap,VerticalWidth,VerticalHeight);                       break;                     }a                     case 4:)                     { H                       stipple=XCreateBitmapFromData(display,root_window,B                         (char *) WavyBitmap,WavyWidth,WavyHeight);                       break;                     }                      case 5:p                     default:                     { H                       stipple=XCreateBitmapFromData(display,root_window,@                         (char *) HighlightBitmap,HighlightWidth,)                         HighlightHeight);                        break;                     }g                   }a                   break;                 } E               XFileBrowserWidget(display,windows,"Stipple",filename);u$               if (*filename == '\0')                 break;I               status=XReadBitmapFile(display,root_window,filename,&width, (                 &height,&stipple,&x,&y);*               if (status != BitmapSuccess)O                 XNoticeWidget(display,windows,"Unable to read X bitmap image:",'                   filename);               break;
             }r!             case DrawModeWidthOp:e
             {s               static char)+                 width[MaxTextLength] = "3",i                 *WidthsMenu[]=                 {-                   "1",                   "2",                   "4",                   "8",                   "16",c                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";L               entry=XMenuWidget(display,windows,DrawModeMenu[id],WidthsMenu,                 command);a               if (entry < 0)                 break;               if (entry != 5)u                 { 5                   line_width=atoi(WidthsMenu[entry]);Q                   break;                 };L               (void) XDialogWidget(display,windows,"Ok","Enter line width:",                 width);h!               if (*width == '\0')                  break;%               line_width=atoi(width);s               break;
             })              case DrawModeUndoOp:
             {eD               (void) XMagickCommand(display,resource_info,windows,0,%                 (KeySym) XK_u,image);                break;
             }p              case DrawModeHelpOp:
             {nB               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             }i#             case DrawModeDismissOp:y
             {.               /*!                 Prematurely exit.,               */!               state|=EscapeState;n               state|=ExitState;                break;
             }              default:               break;           } :           XDefineCursor(display,windows->image.id,cursor);           continue;t	         }i       switch (event.type)n       {n         case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }d           /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;            break;	         }          case ButtonRelease:            break;         case Expose:           break;         case KeyPress:	         {            char#             command[MaxTextLength];p             KeySym             key_symbol;   5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,pA             sizeof(command),&key_symbol,(XComposeStatus *) NULL);n           switch (key_symbol)            {p             case XK_Escape:              case XK_F20:
             {e               /*!                 Prematurely exit.t               */!               state|=EscapeState;"               state|=ExitState;                break;
             }t             case XK_F1:              case XK_Help:w
             {iB               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             }c             default:
             {_               XBell(display,0);f               break;
             }a           }            break;	         }          case MotionNotify:	         {a           /*2             Discard pending pointer motion events.           */D           while (XCheckMaskEvent(display,PointerMotionMask,&event));           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))|O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }l           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);s           break;	         }        },#     } while (!(state & ExitState));e+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);p     if (state & EscapeState)       break;     /*C       Draw primitive as pointer moves until the button is released.      */     distance=0;      degrees=0.0;     line_info.x1=x;o     line_info.y1=y;      line_info.x2=x;o     line_info.y2=y;g     rectangle_info.x=x;C     rectangle_info.y=y;a     rectangle_info.width=0;s     rectangle_info.height=0;     number_coordinates=1;p     coordinate_info->x=x;.     coordinate_info->y=y; D     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;      do     {r       switch (primitive)       {%         case PointPrimitive:         default:	         {n%           if (number_coordinates > 1)v
             { 3               XDrawLines(display,windows->image.id,tA                 windows->image.highlight_context,coordinate_info,s4                 number_coordinates,CoordModeOrigin);,               (void) sprintf(text," %+d%+d",8                 coordinate_info[number_coordinates-1].x,9                 coordinate_info[number_coordinates-1].y);E0               XInfoWidget(display,windows,text);
             }p           break;	         }a         case LinePrimitive: 	         {            if (distance > 9) 
             {S               /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2- E                 line_info.y1),(double) (line_info.x2-line_info.x1)));p3               (void) sprintf(text," %.2f",degrees);n0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,r=                 windows->image.highlight_context,&line_info);x
             }_           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }l          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {tH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {                /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);o0               XInfoWidget(display,windows,text);<               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }i           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }          case EllipsePrimitive:"         case FillEllipsePrimitive:	         {nH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {                /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);-0               XInfoWidget(display,windows,text);:               XHighlightEllipse(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }            else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);n           break;	         }p         case PolygonPrimitive:"         case FillPolygonPrimitive:	         { %           if (number_coordinates > 1) 1             XDrawLines(display,windows->image.id,"?               windows->image.highlight_context,coordinate_info,a2               number_coordinates,CoordModeOrigin);           if (distance > 9)y
             {p               /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-(E                 line_info.y1),(double) (line_info.x2-line_info.x1)));s3               (void) sprintf(text," %.2f",degrees);r0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,m=                 windows->image.highlight_context,&line_info);y
             }L           else%             if (windows->info.mapped)tM               XWithdrawWindow(display,windows->info.id,windows->info.screen);-           break;	         }=       }p       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);l       switch (primitive)       {h         case PointPrimitive:         default:	         {=%           if (number_coordinates > 1)i1             XDrawLines(display,windows->image.id,o?               windows->image.highlight_context,coordinate_info,f2               number_coordinates,CoordModeOrigin);           break;	         }t         case LinePrimitive: 	         {            if (distance > 9) 5             XHighlightLine(display,windows->image.id,m;               windows->image.highlight_context,&line_info);            break;	         }c          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {eH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3)):             XHighlightRectangle(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case EllipsePrimitive:"         case FillEllipsePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))8             XHighlightEllipse(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case PolygonPrimitive:"         case FillPolygonPrimitive:	         {x%           if (number_coordinates > 1)=1             XDrawLines(display,windows->image.id,e?               windows->image.highlight_context,coordinate_info,u2               number_coordinates,CoordModeOrigin);           if (distance > 9) 5             XHighlightLine(display,windows->image.id,p;               windows->image.highlight_context,&line_info);i           break;	         }o       }a       switch (event.type)_       {p         case ButtonPress:t           break;         case ButtonRelease: 	         {t           /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;r'           line_info.y2=event.xbutton.y;g+           rectangle_info.x=event.xbutton.x;;+           rectangle_info.y=event.xbutton.y;%@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;1           if (((primitive != PolygonPrimitive) && G                (primitive != FillPolygonPrimitive)) || (distance <= 9)) 
             {                state|=ExitState;                break;
             }            number_coordinates++; 3           if (number_coordinates < max_coordinates) 
             { +               line_info.x1=event.xbutton.x; +               line_info.y1=event.xbutton.y;                break;
             }            max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL) J             Warning("Unable to draw on image","Memory allocation failed");           break;	         }e         case Expose:           break;         case MotionNotify:	         {r           /*1             Discard pending button motion events.n           */8           if (event.xmotion.window != windows->image.id)             break;*           if (primitive != PointPrimitive)
             {pG               while (XCheckMaskEvent(display,ButtonMotionMask,&event)); +               line_info.x2=event.xmotion.x; +               line_info.y2=event.xmotion.y;C/               rectangle_info.x=event.xmotion.x;w/               rectangle_info.y=event.xmotion.y;                break;
             }w@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;           number_coordinates++;W3           if (number_coordinates < max_coordinates)a             break;           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL)oJ             Warning("Unable to draw on image","Memory allocation failed");           break;	         }o         default:           break;       }        /*"         Check boundary conditions.       */       if (line_info.x2 < 0)m         line_info.x2=0;o
       else0         if (line_info.x2 > windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)S         line_info.y2=0;d
       else1         if (line_info.y2 > windows->image.height)s-           line_info.y2=windows->image.height;a       distance= F         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));A       if (((rectangle_info.x != x) && (rectangle_info.y != y)) ||            (state & ExitState))	         { #           if (rectangle_info.x < 0)              rectangle_info.x=0;            else8             if (rectangle_info.x > windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x) E             rectangle_info.width=(unsigned int) (x-rectangle_info.x);            else
             { G               rectangle_info.width=(unsigned int) (rectangle_info.x-x);%!               rectangle_info.x=x;%
             }%#           if (rectangle_info.y < 0)t             rectangle_info.y=0;            else9             if (rectangle_info.y > windows->image.height) 5               rectangle_info.y=windows->image.height;t#           if (rectangle_info.y < y) F             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             {fH               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y;i
             }h	         }m#     } while (!(state & ExitState)); B     XSetFunction(display,windows->image.highlight_context,GXcopy);K     if ((primitive == PointPrimitive) || (primitive == PolygonPrimitive) ||f,         (primitive == FillPolygonPrimitive))       { 
         /*)           Determine polygon bounding box.r
         */,         rectangle_info.x=coordinate_info->x;,         rectangle_info.y=coordinate_info->y;         x=coordinate_info->x;n         y=coordinate_info->y;f.         for (i=1; i < number_coordinates; i++)	         { '           if (coordinate_info[i].x > x)s#             x=coordinate_info[i].x;n'           if (coordinate_info[i].y > y)t#             y=coordinate_info[i].y; 6           if (coordinate_info[i].x < rectangle_info.x)9             rectangle_info.x=Max(coordinate_info[i].x,0);o6           if (coordinate_info[i].y < rectangle_info.y)9             rectangle_info.y=Max(coordinate_info[i].y,0);h	         }f0         rectangle_info.width=x-rectangle_info.x;1         rectangle_info.height=y-rectangle_info.y;-.         for (i=0; i < number_coordinates; i++)	         {i1           coordinate_info[i].x-=rectangle_info.x;)1           coordinate_info[i].y-=rectangle_info.y;n	         }/       }u     else       if (distance <= 9)         continue; 
       else0         if ((primitive == RectanglePrimitive) ||,             (primitive == EllipsePrimitive))           {t#             rectangle_info.width--;w$             rectangle_info.height--;           }i     /*1       Drawing is relative to image configuration.n     */!     draw_info.x=rectangle_info.x;)!     draw_info.y=rectangle_info.y;,M     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Select,y
       image);      x=0;     y=0;     width=(*image)->columns;     height=(*image)->rows;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);(9     x_factor=UpShift(width)/windows->image.ximage->width;(4     draw_info.x+=windows->image.x-(line_width >> 1);     if (draw_info.x < 0)       draw_info.x=0;0     draw_info.x=DownShift(draw_info.x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height;l4     draw_info.y+=windows->image.y-(line_width >> 1);     if (draw_info.y < 0)       draw_info.y=0;0     draw_info.y=DownShift(draw_info.y*y_factor);;     draw_info.width=rectangle_info.width+(line_width << 1);o,     if (draw_info.width > (*image)->columns)(       draw_info.width=(*image)->columns;=     draw_info.height=rectangle_info.height+(line_width << 1);y*     if (draw_info.height > (*image)->rows)&       draw_info.height=(*image)->rows;4     (void) sprintf(draw_info.geometry,"%ux%u%+d%+d",9       (unsigned int) DownShift(draw_info.width*x_factor),y:       (unsigned int) DownShift(draw_info.height*y_factor),#       draw_info.x+x,draw_info.y+y);)     /*$       Initialize drawing attributes.     */     draw_info.degrees=0.0;"     draw_info.primitive=primitive;     draw_info.stipple=stipple;$     draw_info.line_width=line_width;"     draw_info.line_info=line_info;)     if (line_info.x1 > (line_width >> 1));-       draw_info.line_info.x1=line_width >> 1; )     if (line_info.y1 > (line_width >> 1)))-       draw_info.line_info.y1=line_width >> 1;eG     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width >> 1); G     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width >> 1);wE     if ((draw_info.line_info.x2 < 0) && (draw_info.line_info.y2 < 0));       {w9         draw_info.line_info.x2=(-draw_info.line_info.x2);=9         draw_info.line_info.y2=(-draw_info.line_info.y2);f       }n#     if (draw_info.line_info.x2 < 0)        { 9         draw_info.line_info.x2=(-draw_info.line_info.x2);g<         Swap(draw_info.line_info.x1,draw_info.line_info.x2);       }w#     if (draw_info.line_info.y2 < 0)o       {.9         draw_info.line_info.y2=(-draw_info.line_info.y2); <         Swap(draw_info.line_info.y1,draw_info.line_info.y2);       }i,     draw_info.rectangle_info=rectangle_info;7     if (draw_info.rectangle_info.x > (line_width >> 1)),1       draw_info.rectangle_info.x=line_width >> 1;s7     if (draw_info.rectangle_info.y > (line_width >> 1))o1       draw_info.rectangle_info.y=line_width >> 1;g4     draw_info.number_coordinates=number_coordinates;.     draw_info.coordinate_info=coordinate_info;)     windows->image.pixel_info->pen_color=a4       windows->image.pixel_info->pen_colors[pen_id];     /*       Draw primitive on image.     */*     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);K     status=XDrawImage(display,windows->image.pixel_info,&draw_info,*image);i+     XSetCursorState(display,windows,False);&     /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);    } )   XSetCursorState(display,windows,False); !   free((char *) coordinate_info);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w P a n R e c t a n g l e                                         % O %                                                                             %%O %                                                                             %iO %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %gK %  Function XDrawPanRectangle draws a rectangle in the pan window.  The paneJ %  window displays a zoomed image and the rectangle shows which portion of. %  the image is displayed in the Image window. % 2 %  The format of the XDrawPanRectangle routine is: % ' %    XDrawPanRectangle(display,windows)  %c+ %  A description of each parameter follows:n %iE %    o display: Specifies a connection to an X server;  returned fromu %      XOpenDisplay. %n< %    o windows: Specifies a pointer to a XWindows structure. %f %  */. static void XDrawPanRectangle(display,windows) Displaye   *display;o   XWindows   *windows;n {f   unsigned longI     scale_factor;m     RectangleInfov     highlight_info;r     /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width); <   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height); <   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);L   XHighlightRectangle(display,windows->pan.id,windows->pan.annotate_context,     &highlight_info);h }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %_O %                                                                             % O %                                                                             %nO %   X L o a d I m a g e                                                       %MO %                                                                             %eO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %v2 %  Function XLoadImage loads an image from a file. %t+ %  The format of the XLoadImage routine is:m %.C %    loaded_image=XLoadImage(display,resource_info,windows,command)s % + %  A description of each parameter follows:  %*J %    o loaded_image: Function XLoadImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.x % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %rK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.w %o< %    o windows: Specifies a pointer to a XWindows structure. %tK %    o command: A value other than zero indicates that the file is selected + %      from the command line argument list.  %  %  */? static Image *XLoadImage(display,resource_info,windows,command)  DisplayI   *display;p  
 XResourceInfo;   *resource_info;    XWindows   *windows;.   unsigned int
   command; {&   Imager     *loaded_image;     ImageInfof     image_info;o  
   static charm#     filename[MaxTextLength] = "\0";      /*      Request file name from user.   */   if (!command) 8     XFileBrowserWidget(display,windows,"Load",filename);   else     {d
       char         **filelist,          **files;  	       int          count,         status;          register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         {gA           Warning("Unable to select image","XGetCommand failed"); !           return((Image *) NULL); 	         } 6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL)-	         {pG           Warning("Unable to select image","Memory allocation failed"); !           XFreeStringList(files); !           return((Image *) NULL);i	         }r
       j=0;       for (i=1; i < count; i++)l         if (*files[i] != '-')C!           filelist[j++]=files[i];         filelist[j]=(char *) NULL;J       XListBrowserWidget(display,windows,&windows->widget,filelist,"Load",*         "Select Image to Load:",filename);       free((char *) filelist);       XFreeStringList(files);      }    if (*filename == '\0')     return((Image *) NULL);    GetImageInfo(&image_info);.   (void) strcpy(image_info.filename,filename);   SetImageInfo(&image_info);)   if (strcmp(image_info.magick,"X") == 0)      { 
       char         seconds[MaxTextLength];          /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0"); P       (void) XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",         seconds);*)       XDelay(display,1000*atoi(seconds));n     }n   /*     Load the image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);4   loaded_image=ReadImage(resource_info->image_info);)   XSetCursorState(display,windows,False); %   if (loaded_image != (Image *) NULL)EC     XClientMessage(display,windows->image.id,windows->im_protocols,v*       windows->im_next_image,CurrentTime);   else     { 
       char         *text,         **textlist;   
       FILE         *file;  	       intK
         c;         register charo         *p;          unsigned int         length;)         /*         Unknown image format.        */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);t       length=MaxTextLength; 0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)        {1         c=fgetc(file);         if (c == EOF)            break;!         if ((p-text+1) >= length)            {:             *p='\0';             length<<=1;dE             text=(char *) realloc((char *) text,length*sizeof(char));r&             if (text == (char *) NULL)               break;              p=text+strlen(text);           }          *p=(unsigned char) c;        }W       (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);a       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL) 	         {            char!             title[MaxTextLength];f             register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);a6           for (i=0; textlist[i] != (char *) NULL; i++)'             free((char *) textlist[i]); "           free((char *) textlist);	         }f       free((char *) text);     }    return(loaded_image);o }n e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %iO %   X M a g i c k C o m m a n d                                               %tO %                                                                             %)O %                                                                             %.O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x % I %  Function XMagickCommand makes a transform to the image or Image windowe: %  as specified by a user menu button or keyboard command. %)/ %  The format of the XMagickCommand routine is:o %>E %    loaded_image=XMagickCommand(display,resource_info,windows,state,  %      key_symbol,image) %i+ %  A description of each parameter follows:W %oG %    o loaded_image:  Function XMagickCommand returns an image when thepI %      user chooses 'Load Image' from the command menu.  Otherwise a null> %      image is returned.n %tD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %dK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %r< %    o windows: Specifies a pointer to a XWindows structure. %s %    o state: key mask.  % 2 %    o key_symbol: Specifies a command to perform. %aG %    o image: Specifies a pointer to a Image structure;  XMagickCommandn> %      may transform the image and return a new image pointer. %o %w */L static Image *XMagickCommand(display,resource_info,windows,state,key_symbol,   image) Display    *display;   
 XResourceInfo    *resource_info;i   XWindows   *windows;    unsigned int   state;   KeySym
   key_symbol;    Imaged
   **image; {o   char
     *argv[5],      geometry[MaxTextLength],$     modulate_factors[MaxTextLength];     Image      *cache_image,p     *loaded_image;     ImageInfoi     image_info;t     int      x,     y;  
   static chari"     color[MaxTextLength] = "gray",     delta[MaxTextLength] = "",     Digits[]="01234567890";      static KeySym(     last_symbol = XK_0;      static Image!     *redo_image = (Image *) NULL,o!     *undo_image = (Image *) NULL;      unsigned int     height,/     status,e
     width;  (   XCheckRefreshWindows(display,windows);3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))e     {3<       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))	         {d           *delta='\0';#           resource_info->quantum=1;(	         }        last_symbol=key_symbol;P"       delta[strlen(delta)+1]='\0';3       delta[strlen(delta)]=Digits[key_symbol-XK_0]; )       resource_info->quantum=atoi(delta);e       return((Image *) NULL);e     }a   last_symbol=key_symbol;    switch (key_symbol)    {      case XK_Break:     {-       /*1         Free memory from the undo and redo cache.a       */*       while (undo_image != (Image *) NULL)       {a         cache_image=undo_image; (         undo_image=undo_image->previous;(         DestroyImage(cache_image->list);"         DestroyImage(cache_image);       }t        undo_image=(Image *) NULL;'       if (redo_image != (Image *) NULL) !         DestroyImage(redo_image);s        redo_image=(Image *) NULL;       return((Image *) NULL);>     }.     case XK_u:     case XK_Undo:      {        /*+         Undo the last image transformation.i       */'       if (undo_image == (Image *) NULL)d	         {,           XBell(display,0); !           return((Image *) NULL); 	         }        cache_image=undo_image; &       undo_image=undo_image->previous;?       windows->image.window_changes.width=cache_image->columns;n=       windows->image.window_changes.height=cache_image->rows;t8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);9       windows->image.crop_geometry=cache_image->geometry; '       if (redo_image != (Image *) NULL) !         DestroyImage(redo_image);p       redo_image=(*image);       *image=cache_image->list;         DestroyImage(cache_image);        if (windows->image.orphan)         return((Image *) NULL); D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);g       return((Image *) NULL);i     }      case XK_Up:r     case XK_KP_Up:     case XK_Down:f     case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:      {        if (!(state & Mod1Mask))         break;     }f     case XK_F3:      case XK_F5:;     case XK_A:     case XK_less:r     case XK_o:     case XK_greater:     case XK_percent:     case XK_t:     case XK_bracketleft:     case XK_bracketright:      case XK_minus:     case XK_bar:     case XK_slash:     case XK_backslash:     case XK_asterisk:      case XK_F6:e     case XK_asciitilde:_     case XK_equal:     case XK_N:     case XK_F7:      case XK_F8:      case XK_F9:e     case XK_g:     case XK_F10:     case XK_F11:     case XK_D:     case XK_P:     case XK_S:     case XK_B:     case XK_E:     case XK_M:     case XK_F13:     case XK_O:     case XK_asciicircum:     case XK_Z:     case XK_G:     case XK_numbersign:a     case XK_R:     case XK_a:     case XK_b:     case XK_F:     case XK_x:     case XK_exclam:i     case XK_Select:%     case XK_Redo:w     {o       Image,         *previous_image;         unsigned int         bytes;         /*:         Ensure the undo cache has enough memory available.       */       if (state & Mod5Mask)s         break;6       bytes=(*image)->packets*sizeof(RunlengthPacket);4       if ((bytes >> 20) > resource_info->undo_cache)         break;        previous_image=undo_image;.       while (previous_image != (Image *) NULL)       { E         bytes+=previous_image->list->packets*sizeof(RunlengthPacket);i#         cache_image=previous_image;i0         previous_image=previous_image->previous;6         if (bytes > (resource_info->undo_cache << 20))           {m4             if (cache_image->next != (Image *) NULL)9               cache_image->next->previous=(Image *) NULL; ,             DestroyImage(cache_image->list);&             DestroyImage(cache_image);           }a       },       /*6         Save image before transformations are applied.       */4       cache_image=AllocateImage((ImageInfo *) NULL);(       if (cache_image == (Image *) NULL)         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       (*image)->orphan=True;       cache_image->list=@         CopyImage(*image,(*image)->columns,(*image)->rows,True);       (*image)->orphan=False; -       XSetCursorState(display,windows,False); .       if (cache_image->list == (Image *) NULL)	         {i$           DestroyImage(cache_image);           break;	         } 8       cache_image->columns=windows->image.ximage->width;6       cache_image->rows=windows->image.ximage->height;9       cache_image->geometry=windows->image.crop_geometry;I8       if (windows->image.crop_geometry != (char *) NULL)	         { L           cache_image->geometry=(char *) malloc(MaxTextLength*sizeof(char));5           if (cache_image->geometry != (char *) NULL),N             (void) strcpy(cache_image->geometry,windows->image.crop_geometry);	         } '       if (undo_image == (Image *) NULL) 	         { !           undo_image=cache_image;            break;	         }e#       undo_image->next=cache_image;,,       undo_image->next->previous=undo_image;"       undo_image=undo_image->next;       break;     }      default:       break;   }    if (key_symbol ==  XK_Redo)c     {s       /*+         Redo the last image transformation.        */'       if (redo_image == (Image *) NULL)a	         {o           XBell(display,0); !           return((Image *) NULL); 	         }r>       windows->image.window_changes.width=redo_image->columns;<       windows->image.window_changes.height=redo_image->rows;8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);8       windows->image.crop_geometry=redo_image->geometry;       DestroyImage(*image);g       *image=redo_image;        redo_image=(Image *) NULL;        if (windows->image.orphan)         return((Image *) NULL);vD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);,       return((Image *) NULL);r     }    /*     Process user command..   */   argv[0]=client_name;   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width;eE   windows->image.window_changes.height=windows->image.ximage->height;>   switch (key_symbol))   {      case XK_l:     {p       /*         Load image.p       */C       loaded_image=XLoadImage(display,resource_info,windows,False);p       break;     }      case XK_n:     case XK_space:     {g       /*         Display next image.u       */E       XClientMessage(display,windows->image.id,windows->im_protocols,.,         windows->im_next_image,CurrentTime);       break;     }<     case XK_f:     case XK_KP_Prior:)     case XK_BackSpace:     {i       /*         Display former image.        */E       XClientMessage(display,windows->image.id,windows->im_protocols,t.         windows->im_former_image,CurrentTime);       break;     }      case XK_F2:<     {i       /*         Select image.&       */2       (void) chdir(resource_info->home_directory);B       loaded_image=XLoadImage(display,resource_info,windows,True);       break;     }      case XK_s:     {        /*         Save image.f       */=       status=XSaveImage(display,resource_info,windows,image);        if (status == False)	         {xC           XNoticeWidget(display,windows,"Unable to write X image:",r              (*image)->filename);           break;	         }r       break;     }e     case XK_p:     {        /*         Print image.       */>       status=XPrintImage(display,resource_info,windows,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to print X image:",a              (*image)->filename);           break;	         }s       break;     }i     case XK_Delete:      {n       static char0'         filename[MaxTextLength] = "\0";n         /*         Delete image file.       */<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=unlink(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);        break;     }d     case XK_C:     {        static charv&         color[MaxTextLength] = "gray",,         geometry[MaxTextLength] = "640x480";         /*'         Query user for canvas geometry.        */M       (void) XDialogWidget(display,windows,"Canvas","Enter canvas geometry:",*         geometry);       if (*geometry == '\0')         break;:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0'),         break;       /*         Create canvas.       */        GetImageInfo(&image_info);8       (void) sprintf(image_info.filename,"xc:%s",color);       image_info.size=geometry; *       loaded_image=ReadImage(&image_info);)       free((char *) image_info.filename);rE       XClientMessage(display,windows->image.id,windows->im_protocols,p,         windows->im_next_image,CurrentTime);       break;     }g     case XK_comma:     {;       static chart#         delay[MaxTextLength] = "5";          /*)         Display next image after pausing.        */       resource_info->delay=0;f8       (void) XDialogWidget(display,windows,"Slide Show",8         "Pause how many seconds between images:",delay);       if (*delay == '\0')          break;'       resource_info->delay=atoi(delay); E       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     }      case XK_V:     {        /*         Visual Image directory.        */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }H     case XK_F3:e     {g       /*         Cut image.       */F       (void) XCropImage(display,resource_info,windows,*image,CutMode);       break;     }i     case XK_F4:X     {;       /*         Copy image.        */G       (void) XCropImage(display,resource_info,windows,*image,CopyMode);        break;     }      case XK_F5:      {        /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);        if (status == False)	         { B           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         }n       break;     }      case XK_at:.     { C       (void) XConfigureImage(display,resource_info,windows,*image);s       break;     }      case XK_F12:     {i       /*         Set user preferences.        */?       status=XPreferencesWidget(display,resource_info,windows);        if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);        (*image)->orphan=False;x)       if (loaded_image != (Image *) NULL)|G         XClientMessage(display,windows->image.id,windows->im_protocols, .           windows->im_next_image,CurrentTime);       break;     }      case XK_A:     { 
       char&         image_geometry[MaxTextLength];  <       if ((windows->image.crop_geometry == (char *) NULL) &&@           ((*image)->columns == windows->image.ximage->width) &&>           ((*image)->rows == windows->image.ximage->height) &&.           (resource_info->number_colors == 0))         break;       /*'         Apply size transforms to image.S       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);mH       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         {w6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;v	         }g       windows->image.x=0;n       windows->image.y=0; ,       if (resource_info->number_colors != 0)	         {l           /*5             Reduce the number of colors in the image.;           */1           if (((*image)->class == DirectClass) ||tB               ((*image)->colors > resource_info->number_colors) ||<               (resource_info->colorspace == GRAYColorspace))>             QuantizeImage(*image,resource_info->number_colors,>               resource_info->tree_depth,resource_info->dither,)               resource_info->colorspace);_           SyncImage(*image);	         }pD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);p       break;     };     case XK_less:t     {i       /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;C       (void) XConfigureImage(display,resource_info,windows,*image);g       break;     }y     case XK_o:     {v       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);g       break;     }      case XK_greater:     {)       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }      case XK_percent:     {        unsigned int         height,          width;         /*         Resize image.e       */)       width=windows->image.ximage->width; +       height=windows->image.ximage->height;o4       (void) sprintf(geometry,"%ux%u",width,height);4       status=XDialogWidget(display,windows,"Resize",@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;       if (!status)$         (void) strcat(geometry,"!");2       ParseImageGeometry(geometry,&width,&height);0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_r:     {        /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {s           XBell(display,0);a           break;	         }a<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {o6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;            windows->image.x=0;y           windows->image.y=0;X	         }eD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);c       break;     }I     case XK_bracketleft:     {        /*         Crop image.t       */G       (void) XCropImage(display,resource_info,windows,*image,CropMode);        break;     }c     case XK_bracketright:      {        /*         Chop image.i       */=       status=XChopImage(display,resource_info,windows,image);        if (status == False)	         {;@           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }a       break;     }      case XK_bar:     {a       /*         Flop image scanlines.d       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flop";;       MogrifyImage(resource_info->image_info,2,argv,image);t-       XSetCursorState(display,windows,False);(8       if (windows->image.crop_geometry != (char *) NULL)	         {i           /*             Flop crop geometry.n           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);fJ           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,<             height,(int) (*image)->columns-(int) width-x,y);	         }         if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_minus:     {p       /*         Flip image scanlines.;       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flip";;       MogrifyImage(resource_info->image_info,2,argv,image);u-       XSetCursorState(display,windows,False);d8       if (windows->image.crop_geometry != (char *) NULL)	         {t           /*             Flip crop geometry.,           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); J           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,:             height,x,(int) (*image)->rows-(int) height-y);	         }a        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);c       break;     }c     case XK_slash:     {o       /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         {*C           XNoticeWidget(display,windows,"Unable to rotate X image",i              (*image)->filename);           break;	         }a       break;     }      case XK_backslash:     {f       /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);        if (status == False)	         {dC           XNoticeWidget(display,windows,"Unable to rotate X image",e              (*image)->filename);           break;	         }u       break;     }a     case XK_asterisk:l     {        /*         Rotate image.c       */C       status=XRotateImage(display,resource_info,windows,0.0,image);        if (status == False)	         {rC           XNoticeWidget(display,windows,"Unable to rotate X image",,              (*image)->filename);           break;	         }s       break;     }a     case XK_F6:=     {U       static chara.         geometry[MaxTextLength] = "45.0x45.0";         /*0         Query user for shear color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')o         break;K       (void) XDialogWidget(display,windows,"Shear","Enter shear geometry:",i         geometry);       if (*geometry == '\0')         break;       /*         Shear image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);.,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";d       argv[2]=color;       argv[3]="-shear";r       argv[4]=geometry;m;       MogrifyImage(resource_info->image_info,5,argv,image); -       XSetCursorState(display,windows,False);i<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);*       break;     }m     case XK_t:     {        /*         Trim image.        */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         { A           XNoticeWidget(display,windows,"Unable to trim X image",=              (*image)->filename);           break;	         }w       break;     }i     case XK_F7:o     {b       static char )         hue_percent[MaxTextLength] = "3";          /**         Query user for percent hue change.       */3       (void) XDialogWidget(display,windows,"Apply",r:         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')n         break;       /*         Vary the image hue.s       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);1       (void) strcpy(modulate_factors,"0.0,0.0,"); 2       (void) strcat(modulate_factors,hue_percent);       argv[1]="-modulate";       argv[2]=modulate_factors;);       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);r       break;     }l     case XK_F8:V     {        static char 1         saturation_percent[MaxTextLength] = "10";w         /*1         Query user for percent saturation change._       */3       (void) XDialogWidget(display,windows,"Apply",wH         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;       /*         Vary color saturation.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       (void) strcpy(modulate_factors,"0.0,");c9       (void) strcat(modulate_factors,saturation_percent);e       argv[1]="-modulate";       argv[2]=modulate_factors;f;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);d        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);P       break;     }i     case XK_F9:D     {m       static chara0         brightness_percent[MaxTextLength] = "3";         /*1         Query user for percent brightness change.(       */3       (void) XDialogWidget(display,windows,"Apply",tH         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;       /*"         Vary the color brightness.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);9       (void) strcpy(modulate_factors,brightness_percent);e       argv[1]="-modulate";       argv[2]=modulate_factors;d;       MogrifyImage(resource_info->image_info,3,argv,image);%-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_g:     {        static char &         factor[MaxTextLength] = "1.6";         /*#         Query user for gamma value.        */P       (void) XDialogWidget(display,windows,"Gamma","Enter gamma value:",factor);       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-gamma";        argv[2]=factor;g;       MogrifyImage(resource_info->image_info,3,argv,image);r-       XSetCursorState(display,windows,False);e        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);m       break;     }      case XK_F10:     {i       /*#         Sharpen the image contrast.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);s-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }e     case XK_F11:     {        /*          Dull the image contrast.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);--       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);m       break;     }      case XK_equal:     {"       /*4         Perform histogram equalization on the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-equalize";;       MogrifyImage(resource_info->image_info,2,argv,image);c-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }s     case XK_N:     {L       /*5         Perform histogram normalization on the image.O       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-normalize"; ;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }B     case XK_asciitilde:m     {n       /*         Negate colors in image.u       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-negate";;       MogrifyImage(resource_info->image_info,2,argv,image);o-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }a     case XK_G:     {"       /*#         Convert image to grayscale.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colorspace";       argv[2] = "gray"; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);L       break;     }t     case XK_numbersign:      {"       static char,&         colors[MaxTextLength] = "256";         /*0         Query user for maximum number of colors.       */6       status=XDialogWidget(display,windows,"Quantize",,         "Maximum number of colors:",colors);       if (*colors == '\0')         break;       /*         Color reduce the image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colors";       argv[2]=colors; -       argv[3]=status ? "-dither" : "+dither"; ;       MogrifyImage(resource_info->image_info,4,argv,image);o-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }      case XK_D:     {        /*         Despeckle image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-despeckle"; ;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);t        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);K       break;     }K     case XK_P:     {,       /*"         Reduce noise in the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-noise"; ;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);K       break;     }      case XK_S:     {-       static char '         factor[MaxTextLength] = "60.0";          /*&         Query user for sharpen factor.       */5       (void) XDialogWidget(display,windows,"Sharpen",d=         "Enter the sharpening factor (0.0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*          Sharpen image scanlines.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-sharpen";a       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);a-       XSetCursorState(display,windows,False);d        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);L       break;     }e     case XK_B:     {        static chars'         factor[MaxTextLength] = "60.0";n         /*#         Query user for blur factor.m       */2       (void) XDialogWidget(display,windows,"Blur",;         "Enter the blurring factor (0.0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*         Blur an image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-blur";       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);a-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_E:     {i       static char '         factor[MaxTextLength] = "50.0";m         /*#         Query user for edge factor.e       */:       (void) XDialogWidget(display,windows,"Detect Edges",>         "Enter the edge detect factor (0.0 - 99.9%):",factor);       if (*factor == '\0')         break;       /*         Detect edge in image.a       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-edge";       argv[2]=factor;r;       MogrifyImage(resource_info->image_info,3,argv,image);o-       XSetCursorState(display,windows,False);d        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);c       break;     }      case XK_M:     {o       /*         Emboss image scanlines.o       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-emboss";;       MogrifyImage(resource_info->image_info,2,argv,image);e-       XSetCursorState(display,windows,False);=        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);L       break;     }      case XK_F13:     {/       static charc$         amount[MaxTextLength] = "2";         /*%         Query user for spread amount.v       */4       (void) XDialogWidget(display,windows,"Spread",1         "Enter the displacement amount:",amount);a       if (*amount == '\0')         break;       /*1         Displace image pixels by a random amount.v       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-spread";       argv[2]=amount;p;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);f       break;     }h     case XK_O:     {n       /*!         OilPaint image scanlines.,       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-paint";b;       MogrifyImage(resource_info->image_info,2,argv,image);d-       XSetCursorState(display,windows,False);u        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }=     case XK_asciicircum:     {w       static chard*         bevel_width[MaxTextLength] = "10";         /*#         Query user for bevel width.l       */O       (void) XDialogWidget(display,windows,"Raise","Bevel width:",bevel_width);w       if (*bevel_width == '\0')i         break;       /*         Raise an image._       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-raise";        argv[2]=bevel_width;;       MogrifyImage(resource_info->image_info,3,argv,image);d-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }n     case XK_Z:     {p       static charR)         threshold[MaxTextLength] = "1.5";t         /*+         Query user for smoothing threshold.b       */L       (void) XDialogWidget(display,windows,"Segment","Smoothing threshold:",         threshold);        if (*threshold == '\0')          break;       /*         Segment an image.d       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-segment";%       argv[2]=threshold;;       MogrifyImage(resource_info->image_info,3,argv,image);a-       XSetCursorState(display,windows,False);c        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }c     case XK_R:     {v       /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }_     case XK_a:     {        /*%         Annotate the image with text."       */F       status=XAnnotateEditImage(display,resource_info,windows,*image);       if (status == False)	         { E           XNoticeWidget(display,windows,"Unable to annotate X image",               (*image)->filename);           break;	         }c       break;     }(     case XK_d:     {H       /*         Draw image.n       */A       status=XDrawEditImage(display,resource_info,windows,image);"       if (status == False)	         {eH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }d       break;     }      case XK_b:     {n       static char*(         geometry[MaxTextLength] = "6x6";         /*1         Query user for border color and geometry.a       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')n         break;8       (void) XDialogWidget(display,windows,"Add Border",+         "Enter border geometry:",geometry);a       if (*geometry == '\0')         break;       /*"         Add a border to the image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);w,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";o       argv[2]=color;       argv[3]="-border";       argv[4]=geometry;d;       MogrifyImage(resource_info->image_info,5,argv,image);+-       XSetCursorState(display,windows,False);n<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }i     case XK_F:     {        static char (         geometry[MaxTextLength] = "6x6";         /*0         Query user for frame color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')d         break;O       (void) XDialogWidget(display,windows,"Add Frame","Enter frame geometry:",i         geometry);       if (*geometry == '\0')         break;       /*1         Surround image with an ornamental border.d       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);C,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-mattecolor";       argv[2]=color;       argv[3]="-frame";        argv[4]=geometry;t;       MogrifyImage(resource_info->image_info,5,argv,image);t-       XSetCursorState(display,windows,False); <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);r       break;     }      case XK_x:     {a       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);i       if (status == False)	         {oF           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }s       break;     }l     case XK_c:     {>       /*         Color edit.b       */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         {eG           XNoticeWidget(display,windows,"Unable to pixel edit X image",;              (*image)->filename);           break;	         }i       break;     }i     case XK_m:     {x       /*         Matte edit.i       */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         {xG           XNoticeWidget(display,windows,"Unable to matte edit X image",=              (*image)->filename);           break;	         }        break;     }g     case XK_exclam:h     {p
       char         command[MaxTextLength],C          filename[MaxTextLength];  
       FILE         *file;         /*         Edit image comment.i       */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {            register chart             *p;"  #           file=fopen(filename,"w");g$           if (file == (FILE *) NULL)
             {aK               XNoticeWidget(display,windows,"Unable to edit image comment",s                 filename);               break;
             } 5           for (p=(*image)->comments; *p != '\0'; p++)e'             (void) putc((int) *p,file);;!           (void) putc('\n',file);r           (void) fclose(file);	         }o5       (void) sprintf(command,EditorCommand,filename);_9       if (resource_info->editor_command != (char *) NULL)cG         (void) sprintf(command,resource_info->editor_command,filename);>,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status)eN         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         {a1           (void) sprintf(command,"@%s",filename);.'           CommentImage(*image,command);p	         }o       (void) unlink(filename);-       XSetCursorState(display,windows,False);u       break;     }s     case XK_i:     {"       /*         Display image info.S       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);I       XDisplayImageInfo(display,resource_info,windows,undo_image,*image);c-       XSetCursorState(display,windows,False);f       break;     }      case XK_ampersand:     {o       /*         Background image.c       */C       status=XBackgroundImage(display,resource_info,windows,image);o       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);p       (*image)->orphan=False; )       if (loaded_image != (Image *) NULL)aG         XClientMessage(display,windows->image.id,windows->im_protocols, .           windows->im_next_image,CurrentTime);       break;     }o     case XK_z:     {"       /*         Zoom image.o       */"       if (windows->magnify.mapped)2         XRaiseWindow(display,windows->magnify.id);
       else	         {i           /*             Make magnify image.w           */0           XSetCursorState(display,windows,True);K           status=XMakeImage(display,resource_info,&windows->magnify,*image,,<             windows->magnify.width,windows->magnify.height);G           status|=XMakePixmap(display,resource_info,&windows->magnify);(           if (status == False)B             Error("Unable to create magnify image",(char *) NULL);2           XMapRaised(display,windows->magnify.id);1           XSetCursorState(display,windows,False);s	         }>       break;     }L     case XK_H:     {I
       char         command[MaxTextLength],s          filename[MaxTextLength];         /*         Show image histogram.o       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       TemporaryFilename(filename);@       (void) sprintf(command,HistogramCommand,windows->image.id,%         (*image)->filename,filename);mA       (void) sprintf((*image)->filename,"histogram:%s",filename);_        GetImageInfo(&image_info);,       status=WriteImage(&image_info,*image);       if (status)m'         status=!SystemCommand(command);        if (!status)	         { I           XNoticeWidget(display,windows,"Unable to show image histogram",d             command);*"           (void) unlink(filename);	         }=       XDelay(display,1500);w-       XSetCursorState(display,windows,False);        break;     }-     case XK_h:     case XK_F1:f     case XK_Help:m     {t       /*         User requested help.       */:       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Display",ImageMagickHelp);i       break;     }W     case XK_Find:_     {c
       char         command[MaxTextLength];h         /*/         Browse the entire ImageMagick document.a       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);2       (void) strcpy(command,DocumentationBrowser);$       status=SystemCommand(command);       if (status)MP         XNoticeWidget(display,windows,"Unable to browse documentation",command);       XDelay(display,1500);e-       XSetCursorState(display,windows,False);n       break;     }N     case XK_v:     {w,       XNoticeWidget(display,windows,Version,?         "Copyright 1996 E. I. du Pont de Nemours and Company");c       break;     }(     case XK_q:     {        /*         Exit program.*       */'       if (!resource_info->confirm_exit) G         XClientMessage(display,windows->image.id,windows->im_protocols,b(           windows->im_exit,CurrentTime);
       else	         {g           /*!             Confirm program exit.i           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",h             client_name);e           if (status == True)oK             XClientMessage(display,windows->image.id,windows->im_protocols,d,               windows->im_exit,CurrentTime);	         }        break;     }s     case XK_Next:b     case XK_Prior:     case XK_Home:s     case XK_KP_Home:     { 9       XTranslateImage(display,windows,*image,key_symbol);o       break;     };     case XK_Up:t     case XK_KP_Up:     case XK_Down:_     case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:      {a       if (state & Mod1Mask) 	         {t           RectangleInfo              crop_info;             /*.             Trim one pixel from edge of image.           */           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width;r9           crop_info.height=windows->image.ximage->height;d@           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             {r=               if (resource_info->quantum >= crop_info.height)e:                 resource_info->quantum=crop_info.height-1;7               crop_info.height-=resource_info->quantum;=
             } D           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             { K               if (resource_info->quantum >= (crop_info.height-crop_info.y))(F                 resource_info->quantum=crop_info.height-crop_info.y-1;2               crop_info.y+=resource_info->quantum;7               crop_info.height-=resource_info->quantum;t
             }eD           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             {;<               if (resource_info->quantum >= crop_info.width)9                 resource_info->quantum=crop_info.width-1; 6               crop_info.width-=resource_info->quantum;
             }TF           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {lJ               if (resource_info->quantum >= (crop_info.width-crop_info.x))E                 resource_info->quantum=crop_info.width-crop_info.x-1;w2               crop_info.x+=resource_info->quantum;6               crop_info.width-=resource_info->quantum;
             }iH           if ((windows->image.x+windows->image.width) > crop_info.width)B             windows->image.x=crop_info.width-windows->image.width;J           if ((windows->image.y+windows->image.height) > crop_info.height)D             windows->image.y=crop_info.height-windows->image.height;>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None);nG           (void) XConfigureImage(display,resource_info,windows,*image);w           break;	         }a9       XTranslateImage(display,windows,*image,key_symbol);s       break;     }g     case XK_Return:g     case XK_KP_Enter:a     case XK_Select:t       break;     default:     {c%       if (!IsModifierKey(key_symbol))e         XBell(display,0);        break;     }d   }y   return(loaded_image);i }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %dO %                                                                             %/O %                                                                             %rO %   X M a g n i f y I m a g e                                                 %=O %                                                                             %.O %                                                                             %rO %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %_F %  Function XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. %e. %  The format of the XMagnifyImage routine is: %w) %    XMagnifyImage(display,windows,event)- %a+ %  A description of each parameter follows:  %wE %    o display: Specifies a connection to an X server;  returned from- %      XOpenDisplay. %w< %    o windows: Specifies a pointer to a XWindows structure. %nH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.- %f %d */0 static void XMagnifyImage(display,windows,event) Displayo   *display;a   XWindows   *windows;f   XEvent	   *event;o {e   char     text[MaxTextLength];     register int     x,     y;     unsigned longe
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);o   state=DefaultState;a   x=event->xbutton.x;m   y=event->xbutton.y;U(   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {a     /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)r       { :         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height))) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);M       }l     else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))e-         XMapWindow(display,windows->info.id);"     if (windows->info.mapped)=       {i
         /*#           Display pointer position.a
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       }a     /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {        case ButtonPress:c         break;       case ButtonRelease:t       {t
         /*-           User has finished magnifying image..
         */         x=event->xbutton.x;          y=event->xbutton.y;o         state|=ExitState;i         break;       }f       case Expose:         break;       case MotionNotify:       {*
         /*/           Discard pending button motion events..
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));         x=event->xmotion.x;f         y=event->xmotion.y;          break;       }i       default:         break;     }"     /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;-     if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1;a!   } while (!(state & ExitState));    /*     Display magnified image.   */)   XSetCursorState(display,windows,False);0 }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %eO %                                                                             %oO %                                                                             %rO %   X M a g n i f y W i n d o w C o m m a n d                                 %pO %                                                                             %iO %                                                                             %;O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eM %  Function XMagnifyWindowCommand moves the image within an Magnify window byr, %  one pixel as specified by the key symbol. %-6 %  The format of the XMagnifyWindowCommand routine is: %n< %    XMagnifyWindowCommand(display,windows,state,key_symbol) %*+ %  A description of each parameter follows:i %wD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %l< %    o windows: Specifies a pointer to a XWindows structure. %, %    o state: key mask.d %-M %    o key_symbol: Specifies a KeySym which indicates which side of the imagen %      to trim.  %o %U */C static void XMagnifyWindowCommand(display,windows,state,key_symbol)o Display'   *display;w   XWindows   *windows;    unsigned int   state;   KeySym
   key_symbol;p {t   unsigned int     quantum;     /*0     User specified a magnify factor or position.   */   quantum=1;   if (state & Mod1Mask)M     quantum=10;M   switch (key_symbol)s   {      case XK_q:     {oK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);o       break;     }i     case XK_Home:p     case XK_KP_Home:     {p3       windows->magnify.x=windows->image.width >> 1;t4       windows->magnify.y=windows->image.height >> 1;       break;     }t     case XK_Left:d     case XK_KP_Left:     {(!       if (windows->magnify.x > 0)_$         windows->magnify.x-=quantum;       break;     }p     case XK_Up:p     case XK_KP_Up:     {h!       if (windows->magnify.y > 0)_$         windows->magnify.y-=quantum;       break;     }r     case XK_Right:     case XK_KP_Right:g     { 8       if (windows->magnify.x < (windows->image.width-1))$         windows->magnify.x+=quantum;       break;     }      case XK_Down:w     case XK_KP_Down:     {f9       if (windows->magnify.y < (windows->image.height-1)) $         windows->magnify.y+=quantum;       break;     }n     case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     {t,       windows->magnify.data=key_symbol-XK_0;       break;     },     case XK_KP_0:      case XK_KP_1:m     case XK_KP_2:)     case XK_KP_3:t     case XK_KP_4:      case XK_KP_5:y     case XK_KP_6:      case XK_KP_7:e     case XK_KP_8:,     case XK_KP_9:f     {;/       windows->magnify.data=key_symbol-XK_KP_0;        break;     }a     default:       break;   }o%   XMakeMagnifyImage(display,windows);, }  a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %tO %                                                                             %gO %                                                                             %yO %   X M a k e P a n I m a g e                                                 %mO %                                                                             %dO %                                                                             %dO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u %aM %  Function XMakePanImage creates a thumbnail of the image and displays it inM %  the Pan icon window.n %=. %  The format of the XMakePanImage routine is: %e9 %      XMakePanImage(display,resource_info,windows,image)a %e+ %  A description of each parameter follows:e %iE %    o display: Specifies a connection to an X server;  returned from, %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.) %r< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.i %m %e */> static void XMakePanImage(display,resource_info,windows,image) Displayg   *display;/  
 XResourceInfoo   *resource_info;o   XWindows   *windows;t   Image 	   *image;i {,   unsigned int     status;p     /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);;   status|=XMakePixmap(display,resource_info,&windows->pan);r   if (status == False);     Error("Unable to create Pan icon image",(char *) NULL); J   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);u)   XSetCursorState(display,windows,False);u }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %;O %                                                                             %WO %                                                                             %rO %   X M a t t a E d i t I m a g e                                             %aO %                                                                             %eO %                                                                             %sO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %dC %  Function XMatteEditImage allows the user to interactively changetM %  the Matte channel of an image.  If the image is PseudoClass it is promoted H %  to DirectClass before the matte information is stored.  The floodfillL %  algorithm is strongly based on a similiar algorithm in "Graphics Gems" by %  Paul Heckbert.e %r0 %  The format of the XMatteEditImage routine is: % 9 %    XMatteEditImage(display,resource_info,windows,image)s %(+ %  A description of each parameter follows:  %(E %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %yE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.> %a */  1 static void MatteFloodfill(image,x,y,matte,delta)  Image 	   *image;    intp   x,   y,   matte,   delta; {    intn     offset,l	     skip,i
     start,     x1,/     x2;      register RunlengthPacket     *pixel;,     register XSegment      *p;t     RunlengthPacket      target;a  
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))(     return;-+   target=image->pixels[y*image->columns+x]; -   if (target.index == (unsigned short) matte)      return;e   /*     Allocate segment stack.o   */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL),     { @       Warning("Unable to floodfill","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);b   while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      offset=p->y2;a     y=p->y1+offset;L     /*5       Update matte information in neighboring pixels..     */     for (x=x1; x >= 0 ; x--)     {t/       pixel=image->pixels+(y*image->columns+x);a+       if (!MatteMatch(*pixel,target,delta))          break;*       pixel->index=(unsigned short) matte;     }      skip=x >= x1;d     if (!skip)       {i         start=x+1;         if (start < x1)0%           Push(y,start,x1-1,-offset);)         x=x1+1;o       }[     do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); 1             if (!MatteMatch(*pixel,target,delta))a               break;0             pixel->index=(unsigned short) matte;           } #           Push(y,start,x-1,offset);            if (x > (x2+1)),%             Push(y,x2+1,x-1,-offset);b	         }[       skip=False;        for (x++; x <= x2 ; x++)       {o1         pixel=image->pixels+(y*image->columns+x);e,         if (MatteMatch(*pixel,target,delta))           break;       }        start=x;     } while (x <= x2);   }e   free((char *) segment_stack);s }   H static unsigned int XMatteEditImage(display,resource_info,windows,image) Display    *display;%  
 XResourceInfo    *resource_info;o   XWindows   *windows;t   Image.
   **image; {  #define MatteEditMethodOp  0 #define MatteEditDeltaOp  1o #define MatteEditValueOp  2  #define MatteEditUndoOp  3 #define MatteEditHelpOp  4 #define MatteEditDismissOp  5   
   static chart     *MatteEditMenu[]=      {        "Method",.       "Delta",       "Matte Value",
       "Undo",M
       "Help",        "Dismiss",       (char *) NULLd     };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;,     inta
     entry,     id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;   
   static char      matte[MaxTextLength] = "0";n     static unsigned int      delta = 0,     method = PointMethodOp;      unsigned int     height,i
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Matte Edit";W   windows->command.data=2;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);e   /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id,*F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color);)2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);0   state=DefaultState;M   do   {s     if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);d1     if (event.xany.window == windows->command.id)p       {w
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0)            { <             XDefineCursor(display,windows->image.id,cursor);             continue;s           }e         switch (id) 	         { !           case MatteEditMethodOp:e           {,             static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu..             */             entry=P               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);             if (entry >= 0)                method=entry;a             break;           }n            case MatteEditDeltaOp:           {n             static chari               *DeltaMenu[]=u               {                  "0",                 "1",                 "2",                 "4",                 "8",                 "16",                  "32",i                 (char *) NULL,                 (char *) NULL,               },)               value[MaxTextLength] = "3";                /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog...";tJ             entry=XMenuWidget(display,windows,MatteEditMenu[id],DeltaMenu,               command);              if (entry < 0)               break;             if (entry != 7)                {y-                 delta=atoi(DeltaMenu[entry]);r                 break;               }aK             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",)               value);t             if (*value == '\0'))               break;             delta=atoi(value);             break;           }             case MatteEditValueOp:           {t             /*0               Request matte value from the user.             */N             (void) XDialogWidget(display,windows,"Matte","Enter matte value:",               matte);              break;           }            case MatteEditUndoOp:c           { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }4           case MatteEditHelpOp:            {6@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);              break;           }y"           case MatteEditDismissOp:           {              /*               Prematurely exit.n             */             state|=EscapeState;r             state|=ExitState;i             break;           }n           default:             break;	         }s8         XDefineCursor(display,windows->image.id,cursor);         continue;        }m     switch (event.type)t     {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           {;.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:f       {x
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image);)*         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),r/           &key_symbol,(XComposeStatus *) NULL);(         switch (key_symbol)n	         {x           case XK_Escape:t           case XK_F20:           {              /*               Prematurely exit.e             */             state|=ExitState;o             break;           }            case XK_F1:n           case XK_Help:o           { @             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);              break;           }g           default:           {;             XBell(display,0);i             break;           }t	         }          break;       }x       case MotionNotify:       {s
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries.a
         */!         if (windows->info.mapped)            {a>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)));M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))r1             XMapWindow(display,windows->info.id);          break;       }a       default:         break;     }      x_offset=x;i     y_offset=y;d)     if (state & UpdateConfigurationState)a       {p         inti          x,)          y;   
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True);|         x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);=         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x;a?         y_factor=UpShift(height)/windows->image.ximage->height;nC         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; -         if ((x_offset < 0) || (y_offset < 0))            continue; L         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;c:         XPutPixel(windows->image.ximage,x_offset,y_offset,=           windows->image.pixel_info->background_color.pixel);d$         (*image)->class=DirectClass;         if (!(*image)->matte).           {_             /*$               Initialize matte data.             */             p=(*image)->pixels;e1             for (i=0; i < (*image)->packets; i++) 
             {c               p->index=Opaque;               p++;
             } !             (*image)->matte=True;z           }n         switch (method) 	         {            case PointMethodOp:h           default:           {-             /*=               Update matte information using point algorithm.e             */)             if (!UncompressImage(*image))u               break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); (             p->index=atoi(matte) & 0xff;             break;           }            case ReplaceMethodOp:C           {f             RunlengthPacket                target;i               /*?               Update matte information using replace algorithm.n             */             x=0;             p=(*image)->pixels;n1             for (i=0; i < (*image)->packets; i++)s
             {                x+=(p->length+1); <               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             } '             target=(*image)->pixels[i];s             p=(*image)->pixels;s1             for (i=0; i < (*image)->packets; i++)n
             {w.               if (ColorMatch(*p,target,delta)),                 p->index=atoi(matte) & 0xff;               p++;
             }              break;           }.!           case FloodfillMethodOp:            {              /*A               Update matte information using floodfill algorithm.m             */)             if (!UncompressImage(*image))e               break;N             MatteFloodfill(*image,x_offset,y_offset,atoi(matte) & 0xff,delta);             break;           }n           case ResetMethodOp:            {w             /*=               Update matte information using reset algorithm.l             */             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++)E
             { *               p->index=atoi(matte) & 0xff;               p++;
             } /             if ((atoi(matte) & 0xff) == Opaque) $               (*image)->matte=False;             break;           } 	         } +         state&=(~UpdateConfigurationState);+       } !   } while (!(state & ExitState));yO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);d)   XSetCursorState(display,windows,False);w   XFreeCursor(display,cursor);   return(True);  }  d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%wO %                                                                             %wO %                                                                             %rO %                                                                             % O %   X P a n I m a g e                                                         %cO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %.H %  Function XPanImage pans the image until the mouse button is released. % * %  The format of the XPanImage routine is: %W% %    XPanImage(display,windows,event)  % + %  A description of each parameter follows:o %gE %    o display: Specifies a connection to an X server;  returned fromr %      XOpenDisplay. %e< %    o windows: Specifies a pointer to a XWindows structure. %mH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %  */, static void XPanImage(display,windows,event) Displaye   *display;x   XWindows   *windows;    XEvent	   *event;i {=   char     text[MaxTextLength];     Cursor     cursor;      RectangleInfo-
     pan_info;      unsigned longa
     state,
     x_factor, 
     y_factor;      /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);    else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);.     else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow);g
       else3         cursor=XCreateFontCursor(display,XC_arrow);a0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;p   y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height; I   pan_info.width=(unsigned int) (UpShift(windows->image.width)/x_factor); K   pan_info.height=(unsigned int) (UpShift(windows->image.height)/y_factor); !   state=UpdateConfigurationState;    do   {.     switch (event->type)     {n       case ButtonPress:        { 
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       }h       case ButtonRelease:        { 
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }        case MotionNotify:       {n
         /*/           Discard pending button motion events.f
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));$         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }d       default:         break;     } )     if (state & UpdateConfigurationState)a       { 
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)t           pan_info.x=0;          elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width),I             pan_info.x=windows->image.ximage->width-windows->image.width;PK         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);a         if (pan_info.y < 0)a           pan_info.y=0;g         else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height)rK             pan_info.y=windows->image.ximage->height-windows->image.height;w/         if ((windows->image.x != pan_info.x) || -             (windows->image.y != pan_info.y))t           {              /*'               Display image pan offset.              */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,hG               windows->image.height,windows->image.x,windows->image.y);e.             XInfoWidget(display,windows,text);             /*#               Refresh Image window.              *//             XDrawPanRectangle(display,windows); D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           }d+         state&=(~UpdateConfigurationState);x       }.     /*       Wait for next event.     */     if (!(state & ExitState)) <       XIfEvent(display,event,XScreenEvent,(char *) windows);!   } while (!(state & ExitState));    /*     Restore cursor.w   */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);=   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %.O %                                                                             %oO %                                                                             %oO %   X P a s t e I m a g e                                                     %,O %                                                                             % O %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %hH %  Function XPasteImage pastes an image previously saved with XCropImageI %  in the X window image at a location the user chooses with the pointer.  % , %  The format of the XPasteImage routine is: % < %    status=XPasteImage(display,resource_info,windows,image) %-+ %  A description of each parameter follows:  % @ %    o status: Function XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if the   %      image fails to be pasted. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.v %.< %    o windows: Specifies a pointer to a XWindows structure. %wE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %l */D static unsigned int XPasteImage(display,resource_info,windows,image) Display    *display;n  
 XResourceInfor   *resource_info;    XWindows   *windows;g   Imagen	   *image;. {y #define PasteModeOperatorsOp  0  #define PasteModeHelpOp  1 #define PasteModeDismissOp  2n  
   static char      *PasteModeMenu[]=f     {g       "Operator",)
       "Help",,       "Dismiss",       (char *) NULLm     };     char     text[MaxTextLength];     Cursor     cursor;      Imagey     *paste_image;      into     id,)     x,     y;     RectangleInfou     highlight_info,      paste_info;)     static unsigned inte"     operator = ReplaceCompositeOp;     unsigned int     height,e
     width;     unsigned long      scale_factor,v
     state;     XEvent
     event;     /*     Copy image.e   */#   if (copy_image == (Image *) NULL)w     return(False);   copy_image->orphan=True;N   paste_image=CopyImage(copy_image,copy_image->columns,copy_image->rows,True);   copy_image->orphan=False;a   /*     Map Command widget.s   */    windows->command.name="Paste";   windows->command.data=1;G   (void) XCommandWidget(display,windows,PasteModeMenu,(XEvent *) NULL);-*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,)+     windows->im_update_widget,CurrentTime);o   /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);l2   XQueryPosition(display,windows->image.id,&x,&y);"   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;    paste_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);p0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;g   do   {      if (windows->info.mapped)l       {l
         /*#           Display pointer position. 
         */B         (void) sprintf(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }      highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x; 3     highlight_info.y=paste_info.y-windows->image.y; 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);o2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)u       {)
         /*3           Select a command from the Command widget.;
         */@         id=XCommandWidget(display,windows,PasteModeMenu,&event);         if (id < 0)(           continue;!         switch (id) 	         {I$           case PasteModeOperatorsOp:           {              char%               command[MaxTextLength];                static charo               *OperatorMenu[]=               {                  "over",m                 "in",a                 "out",                 "atop",m                 "xor",                 "plus",                  "minus",                 "add",                 "subtract",e                 "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */C             operator=XMenuWidget(display,windows,PasteModeMenu[id],s&               OperatorMenu,command)+1;             break;           }p           case PasteModeHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }m"           case PasteModeDismissOp:           {              /*               Prematurely exit.r             */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;a       },     switch (event.type)e     {        case ButtonPress:,       {&!         if (resource_info->debug)aB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);s4         if (event.xbutton.window == windows->pan.id)           {s.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }i
         /*=           Paste rectangle is relative to image configuration.n
         */         x=0;         y=0;         width=image->columns;w         height=image->rows; :         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,e             &width,&height);A         scale_factor=UpShift(width)/windows->image.ximage->width; F         paste_info.width=DownShift(paste_image->columns*scale_factor);C         scale_factor=UpShift(height)/windows->image.ximage->height; D         paste_info.height=DownShift(paste_image->rows*scale_factor);8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }n       case ButtonRelease:r       {t!         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); @         if ((paste_info.width != 0) && (paste_info.height != 0))           {              /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;w           }f         break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];>           KeySym           key_symbol;w           inta           length;r  3         if (event.xkey.window != windows->image.id)w           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug)eN           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol)a	         {&           case XK_Escape:i           case XK_F20:           {              /*               Prematurely exit.w             */&             DestroyImage(paste_image);             state|=EscapeState;              state|=ExitState;d             break;           }            case XK_F1:            case XK_Help:            {bJ             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {t             XBell(display,0);g             break;           } 	         }T         break;       }w       case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)x           { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))-M               XWithdrawWindow(display,windows->info.id,windows->info.screen);d           }i         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);b(         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }        default:       {s!         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);i         break;       }i     }i!   } while (!(state & ExitState));d@   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);s)   XSetCursorState(display,windows,False);a   XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);y   /*5     Image pasting is relative to image configuration.i   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;s   height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);k;   scale_factor=UpShift(width)/windows->image.ximage->width;d   paste_info.x+=x;4   paste_info.x=DownShift(paste_info.x*scale_factor);<   paste_info.width=DownShift(paste_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;L   paste_info.y+=y;4   paste_info.y=DownShift(paste_info.y*scale_factor);>   paste_info.height=DownShift(paste_info.height*scale_factor);   /*$     Paste image with X Image window.   */G   CompositeImage(image,operator,paste_image,paste_info.x,paste_info.y);    DestroyImage(paste_image);)   XSetCursorState(display,windows,False);    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);e }h * /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             % O %                                                                             %oO %                                                                             % O %   X P r i n t I m a g e                                                     %tO %                                                                             % O %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Function XPrintImage prints an image to a Postscript printer. % , %  The format of the XPrintImage routine is: % < %    status=XPrintImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % ? %    o status: Function XPrintImage return True if the image is J %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %%K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.( %n< %    o windows: Specifies a pointer to a XWindows structure. %fF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.o %d %e */D static unsigned int XPrintImage(display,resource_info,windows,image) Displayn   *display;i  
 XResourceInfoe   *resource_info;a   XWindows   *windows;s   Image 
   **image; {e   char     command[MaxTextLength],e     filename[MaxTextLength],     geometry[MaxTextLength];     ImageInfor     *image_info;     intX     status;      /*/     Request Postscript page geometry from user.e   */'   image_info=resource_info->image_info;c*   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page);eI   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",n1     "Select Postscript Page Geometry:",geometry);f   if (*geometry == '\0')     return(True);s0   image_info->page=PostscriptGeometry(geometry);   /*      Request file name from user.   */(   XCheckRefreshWindows(display,windows);   TemporaryFilename(filename);@   (void) sprintf(command,resource_info->print_command,filename);I   (void) XDialogWidget(display,windows,"Print","Print command:",command);M   if (*command == '\0')      return(True);    /*     Print image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);N(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);6   (void) sprintf((*image)->filename,"ps:%s",filename);'   status=WriteImage(image_info,*image);n"   status&=!SystemCommand(command);)   XSetCursorState(display,windows,False);iM   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);e   return(status);= }I   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             %DO %                                                                             %oO %   X P r o g r e s s M o n i t o r                                           %_O %                                                                             %oO %                                                                             % O %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %dF %  Function XProgressMonitor displays the progress a task is making in %  completing a task.d %l1 %  The format of the XProgressMonitor routine is:w %o* %      XProgressMonitor(task,quantum,span) %w+ %  A description of each parameter follows:  %t- %    o task: Identifies the task in progress.R %WO %    o quantum: Specifies the quantum position within the span which representst< %      how much progress has been made in completing a task. % > %    o span: Specifies the span relative to completing a task. %; %  *// static void XProgressMonitor(task,quantum,span)  char   *task;   unsigned int
   quantum,   span;d {-4   XMonitorWidget(display,windows,task,quantum,span); }t = /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             %(O %                                                                             % O %   X R O I I m a g e                                                         %nO %                                                                             %eO %                                                                             %(O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XROIImage applies an image processing technique to a region  %  of interest.  % * %  The format of the XROIImage routine is: %n: %    status=XROIImage(display,resource_info,windows,image) %e+ %  A description of each parameter follows:  % > %    o status: Function XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %pE %    o image: Specifies a pointer to a Image structure; returned fromu %      ReadImage.  %  %  */B static unsigned int XROIImage(display,resource_info,windows,image) Display    *display;;  
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; {t #define ApplyModeMenus  5  #define ApplyModeFileOp  0 #define ApplyModeEditOp  1 #define ApplyModeTransformOp  2o #define ApplyModeEnhanceOp  3o #define ApplyModeEffectsOp  4[ #define ApplyModeHelpOp  5 #define ApplyModeDismissOp  6a #define ROIModeHelpOp  0 #define ROIModeDismissOp  1a  
   static charr     *ROIModeMenu[]=      { 
       "Help",        "Dismiss",       (char *) NULL.     },     *ApplyModeMenu[]=      {u
       "File",t
       "Edit",s       "Transform",       "Enhance",       "Effects",
       "Help",        "Dismiss",       (char *) NULLr     },     *FileMenu[]=     {e       "Image Info",r       (char *) NULL      },     *EditMenu[]=     { 
       "Undo", 
       "Redo",f       (char *) NULLS     },     *TransformMenu[]=a     { 
       "Flop", 
       "Flip",f       "Rotate Right",b       "Rotate Left",       (char *) NULL      },     *EnhanceMenu[]=      {        "Hue...",e       "Saturation...",       "Brightness...",       "Gamma...",e       "Spiff",
       "Dull",        "Equalize",        "Normalize",       "Negate",p       "Grayscale",       "Quantize...",       (char *) NULLw     },     *EffectsMenu[]=l     {l       "Despeckle",       "Peak Noise",n       "Sharpen...",        "Blur...",       "Edge Detect",       "Emboss",        "Spread",e       "Oil Painting",        "Raise...",        "Segment...",d       (char *) NULL.     };  
   static char      **Menus[ApplyModeMenus]=     {[       FileMenu,r       EditMenu,        TransformMenu,       EnhanceMenu,       EffectsMenu      };     static KeySymu     ApplyModeKeys[]=     {)       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h, 
       XK_q     },     FileKeys[]=      { 
       XK_i     },     EditKeys[]=      {a       XK_u,p
       XK_Redo      },     TransformKeys[]=     { 
       XK_bar,a       XK_minus,        XK_slash,        XK_backslash     },     EnhanceKeys[]=     {        XK_F7,       XK_F8,       XK_F9,       XK_g, 
       XK_F10,a
       XK_F11,        XK_equal,a       XK_N,        XK_asciitilde,       XK_G,        XK_numbersign      },     EffectsKeys[]=     {        XK_D,        XK_P,        XK_S,        XK_B,,       XK_E,        XK_M, 
       XK_F13,        XK_O,        XK_asciicircum,h
       XK_Z     };     static KeySym      *Keys[ApplyModeMenus]=     {        FileKeys,r       EditKeys,p       TransformKeys,       EnhanceKeys,       EffectsKeys,     };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;p     int 
     entry,     id,P     x,     y;     KeySym     key_symbol;l     MonitorHandler     handler;     RectangleInfo      highlight_info, 
     roi_info;(     unsigned int     height, 
     width;     unsigned longr     scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="ROI";   windows->command.data=0;E   (void) XCommandWidget(display,windows,ROIModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);t   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;    roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);aO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |e     PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position.B
         */>         (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)t       { 
         /*3           Select a command from the Command widget.;
         */>         id=XCommandWidget(display,windows,ROIModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         {            case ROIModeHelpOp:o           {,@             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }             case ROIModeDismissOp:           {              /*               Prematurely exit.l             */             state|=EscapeState;)             state|=ExitState;              break;           }            default:             break;	         }i         continue;h       }      switch (event.type)e     {;       case ButtonPress:s       {p4         if (event.xbutton.window == windows->pan.id)           {r.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {i             /*L               Note first corner of region of interest rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);8             roi_info.x=windows->image.x+event.xbutton.x;8             roi_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;              break;           }o         break;       }        case Expose:         break;       case KeyPress:       {M3         if (event.xkey.window != windows->image.id),           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),h/           &key_symbol,(XComposeStatus *) NULL);a         switch (key_symbol) 	         {i           case XK_Escape:n           case XK_F20:           {              /*               Prematurely exit.\             */             state|=EscapeState;w             state|=ExitState;              break;           }            case XK_F1::           case XK_Help:            {X@             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }            default:           {W             XBell(display,0);d             break;           } 	         }a         break;       }p       case MotionNotify:       {p
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))).M               XWithdrawWindow(display,windows->info.id,windows->info.screen);b           }=         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); &         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }        default:         break;     } !   } while (!(state & ExitState));eO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);s   if (state & EscapeState)     {        /*5         User want to exit without region of interest.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {p     /*I       Size rectangle as pointer moves until the mouse button is released.t     */     x=roi_info.x;      y=roi_info.y;e     roi_info.width=0;      roi_info.height=0;     state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;w3       highlight_info.y=roi_info.y-windows->image.y;aD       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {a           /*?             Display info and draw region of interest rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);i,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped)sI           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);fD       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {y         case ButtonPress:-	         {t6           if (event.xbutton.window == windows->pan.id)
             {r0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }i6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }          case ButtonRelease:e	         {i           /*?             User has committed to region of interest rectangle.e           */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);n           state|=ExitState;d9           if (strcmp(windows->command.name,"Apply") == 0)-             break;(           windows->command.name="Apply";/           windows->command.data=ApplyModeMenus; O           (void) XCommandWidget(display,windows,ApplyModeMenu,(XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         {y           /*1             Discard pending button motion events.n           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }e         default:           break;       } J       if (((roi_info.x != x) && (roi_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (roi_info.x < 0)*             roi_info.x=0;n           else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x)n9             roi_info.width=(unsigned int) (x-roi_info.x);e           else
             {d;               roi_info.width=(unsigned int) (roi_info.x-x);l               roi_info.x=x; 
             }w           if (roi_info.y < 0)e             roi_info.y=0;            else;             if (roi_info.y > windows->image.ximage->height)W7               roi_info.y=windows->image.ximage->height;            if (roi_info.y < y) :             roi_info.height=(unsigned int) (y-roi_info.y);           else
             {f<               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y; 
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id,x,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;e     do     {        if (windows->info.mapped)i	         {e           /*%             Display pointer position.t           */L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);,,           XInfoWidget(display,windows,text);	         };       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x; 3       highlight_info.y=roi_info.y-windows->image.y;rF       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {a           state|=EscapeState;l           state|=ExitState;            break;	         }u$       if (state & UpdateRegionState)	         { H           XSetFunction(display,windows->image.highlight_context,GXcopy);           switch (key_symbol)t           {              case XK_i:             case XK_u:             case XK_Undo:i             case XK_Redo:t
             { O               (void) XMagickCommand(display,resource_info,windows,0,key_symbol,                  image);,               break;
             })             default:
             {                Imaget                 *roi_image;n                 RectangleInfo                  crop_info;                 /*F                 Region of interest is relative to image configuration.               */?               handler=SetMonitorHandler((MonitorHandler) NULL); !               crop_info=roi_info;                x=0;               y=0;&               width=(*image)->columns;$               height=(*image)->rows;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y,f"                   &width,&height);G               scale_factor=UpShift(width)/windows->image.ximage->width;l               crop_info.x+=x; >               crop_info.x=DownShift(crop_info.x*scale_factor);F               crop_info.width=DownShift(crop_info.width*scale_factor);I               scale_factor=UpShift(height)/windows->image.ximage->height;                crop_info.y+=y; >               crop_info.y=DownShift(crop_info.y*scale_factor);H               crop_info.height=DownShift(crop_info.height*scale_factor);5               roi_image=CropImage(*image,&crop_info);e0               (void) SetMonitorHandler(handler);.               if (roi_image == (Image *) NULL)                 continue;                /*K                 Apply image processing technique to the region of interest.r               */)               windows->image.orphan=True;iK               (void) XMagickCommand(display,resource_info,windows,Mod5Mask,s'                 key_symbol,&roi_image);i?               handler=SetMonitorHandler((MonitorHandler) NULL); D               (void) XMagickCommand(display,resource_info,windows,0,*                 (KeySym) XK_Select,image);*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image,,)                 crop_info.x,crop_info.y);n&               DestroyImage(roi_image);0               (void) SetMonitorHandler(handler);               break;
             }            } !           if (key_symbol != XK_i) 
             {.L               XConfigureImageColormap(display,resource_info,windows,*image);K               (void) XConfigureImage(display,resource_info,windows,*image); 
             } 0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         }t4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);h3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.t           */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           key_symbol=XK_VoidSymbol; B           id=XCommandWidget(display,windows,ApplyModeMenu,&event);           if (id >= 0)
             {t7               (void) strcpy(command,ApplyModeMenu[id]);y+               key_symbol=ApplyModeKeys[id];[&               if (id < ApplyModeMenus)                 {e                   /*8                     Select a command from a pop-up menu.                   */P                   entry=XMenuWidget(display,windows,ApplyModeMenu[id],Menus[id],                     command);a!                   if (entry >= 0)                      {r>                       (void) strcpy(command,Menus[id][entry]);1                       key_symbol=Keys[id][entry];e                     }                  }1
             }yJ           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);!           if (key_symbol == XK_h) 
             {nL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);uN               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue; 
             } !           if (key_symbol == XK_q) 
             {                /*                 Exit.l               */!               state|=EscapeState;f               state|=ExitState;                continue;o
             } *           if (key_symbol != XK_VoidSymbol)%             state|=UpdateRegionState;o           continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type).       {          case ButtonPress: 	         {f6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) && I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {23               roi_info.x=roi_info.x+roi_info.width;o4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) &&e<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {f3               roi_info.x=roi_info.x+roi_info.width;).               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) && ;               (x > (roi_info.x+roi_info.width-RoiDelta)) && I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {e4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) && ;               (x > (roi_info.x+roi_info.width-RoiDelta)) && <               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {s.               state|=UpdateConfigurationState;               break;
             }i	         }e         case ButtonRelease:            break;         case Expose:	         {n8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x;n1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width;g;                 event.xexpose.height=highlight_info.height;)?                 XRefreshWindow(display,&windows->image,&event);r               } 7           if (event.xexpose.window == windows->info.id)l)             if (event.xexpose.count == 0)r0               XInfoWidget(display,windows,text);           break;	         }c         case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)i             break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);f/           for (id=0; id < ApplyModeMenus; id++)            {lE             for (entry=0; Menus[id][entry] != (char *) NULL; entry++)n0               if (key_symbol == Keys[id][entry])                 {l+                   state|=UpdateRegionState;d                   break;                 }e*             if (state & UpdateRegionState)               break;           }y(           if (state & UpdateRegionState)             break;           switch (key_symbol)            {p             case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:t             case XK_F20:!               state|=EscapeState;              case XK_Return:w
             {                state|=ExitState;                break;
             }              case XK_F1:n             case XK_Help:o
             {eL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);GN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }h             default:
             {-               XBell(display,0);i               break;
             }            }o           break;	         };         case KeyRelease:           break;         case MotionNotify:	         {n           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));t           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)(
             {t@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))nO                 XWithdrawWindow(display,windows->info.id,windows->info.screen);o
             }r           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height)))t3               XMapWindow(display,windows->info.id);r           break;	         };         default:           break;       }(+       if (state & UpdateConfigurationState)w	         {i(           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }.#     } while (!(state & ExitState));1!   } while (!(state & ExitState));.@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);o   if (state & EscapeState)     return(True);f   return(True);d }_ o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %(O %                                                                             %fO %                                                                             %fO %   X R o t a t e I m a g e                                                   %rO %                                                                             % O %                                                                             %_O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %sG %  Function XRotateImage rotates the X image.  If the degrees parameter L %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. % - %  The format of the XRotateImage routine is:  %SE %    status=XRotateImage(display,resource_info,windows,degrees,image)w %o+ %  A description of each parameter follows:i %e@ %    o status: Function XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.C %rD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r % < %    o windows: Specifies a pointer to a XWindows structure. %%D %    o degrees: Specifies the number of degrees to rotate the image. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */G static unsigned int XRotateImage(display,resource_info,windows,degrees,    image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    double
   degrees;   Image 
   **image; {  #define RotateModeColorOp  0  #define RotateModeDirectionOp  1 #define RotateModeCropOp  2  #define RotateModeSharpenOp  3 #define RotateModeHelpOp  4  #define RotateModeDismissOp  5 #define HorizontalRotateOp  0  #define VerticalRotateOp  1%  
   static char%     *RotateModeMenu[]=     {%       "Pixel Color",       "Direction",
       "Crop",l       "Sharpen",
       "Help",n       "Dismiss",       (char *) NULLo     };     char     command[MaxTextLength],      text[MaxTextLength];  
   ColorPacketw     background;e     double     normalized_degrees;i     Image      *rotated_image;e     intw     id,      x,     y;     register int     i;     static unsigned inty     crop = False,c#     direction = HorizontalRotateOp,      pen_id = 0,a     sharpen = True;s     unsigned int     height,d     rotations,
     width;     if (degrees == 0.0)n     {p       unsigned int         distance;          unsigned long          state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget.n       */%       windows->command.name="Rotate";)       windows->command.data=4;L       (void) XCommandWidget(display,windows,RotateModeMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,)/         windows->im_update_widget,CurrentTime);e       /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);-       XSelectInput(display,windows->image.id,aB         windows->image.attributes.event_mask | PointerMotionMask);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;h       rotate_info.y1=y;        rotate_info.x2=x;%       rotate_info.y2=y;%       state=DefaultState;%       do       { 1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info); 
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows); 1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info); 5         if (event.xany.window == windows->command.id)            {              /*7               Select a command from the Command widget.              */E             id=XCommandWidget(display,windows,RotateModeMenu,&event);%             if (id < 0)%               continue;%J             XSetFunction(display,windows->image.highlight_context,GXcopy);             switch (id)g
             { %               case RotateModeColorOp:y               {n                 char,                   *ColorMenu[MaxNumberPens];                   intF                   pen_number;m                   XColor                   color;                   /*-                   Initialize menu selections.i                 */5                 for (i=0; i < (MaxNumberPens-2); i++)_<                   ColorMenu[i]=resource_info->pen_colors[i];8                 ColorMenu[MaxNumberPens-2]="Browser...";9                 ColorMenu[MaxNumberPens-1]=(char *) NULL;e                 /*:                   Select a pen color from the pop-up menu.                 */J                 pen_number=XMenuWidget(display,windows,RotateModeMenu[id],%                   ColorMenu,command); #                 if (pen_number < 0)i                   break;4                 if (pen_number == (MaxNumberPens-2))                   {                      static char"9                       color_name[MaxTextLength] = "gray";c                       /*7                       Select a pen color from a dialog.                      */E                     resource_info->pen_colors[pen_number]=color_name;sM                     XColorBrowserWidget(display,windows,"Select",color_name);x,                     if (*color_name == '\0')                       break;                   }e                 /*                    Set pen color.                 */M                 (void) XParseColor(display,windows->image.map_info->colormap, @                   resource_info->pen_colors[pen_number],&color);E                 XBestPixel(display,windows->image.map_info->colormap,lC                   (XColor *) NULL,(unsigned int) MaxColors,&color);nH                 windows->image.pixel_info->pen_colors[pen_number]=color;"                 pen_id=pen_number;                 break;               } )               case RotateModeDirectionOp:=               {                  static chary                    *Directions[]=                   {l!                     "horizontal",                      "vertical", "                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */I                 direction=XMenuWidget(display,windows,RotateModeMenu[id], &                   Directions,command);                 break;               } $               case RotateModeCropOp:               {                  static chard                   *Options[]=i                   {"                     "false",                     "true", "                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */D                 crop=XMenuWidget(display,windows,RotateModeMenu[id],#                   Options,command);_                 break;               }p'               case RotateModeSharpenOp:!               {E                 static charw                   *Options[]=o                   {w                     "false",                     "true", "                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */G                 sharpen=XMenuWidget(display,windows,RotateModeMenu[id], #                   Options,command);                  break;               }e$               case RotateModeHelpOp:               { D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               } '               case RotateModeDismissOp::               {'                 /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;                  break;               }e               default:                 break;
             } L             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;p           }          switch (event.type) 	         {e           case ButtonPress:            { 8             if (event.xbutton.window == windows->pan.id)               { 2                 XPanImage(display,windows,&event);2                 XInfoWidget(display,windows,text);                 break;               }eJ             XSetFunction(display,windows->image.highlight_context,GXcopy);             /*               Exit loop.             */+             rotate_info.x1=event.xbutton.x; +             rotate_info.y1=event.xbutton.y;              state|=ExitState;%             break;           }%           case ButtonRelease:              break;           case Expose:             break;           case KeyPress:           {              char%               command[MaxTextLength];                KeySym               key_symbol;   7             if (event.xkey.window != windows->image.id)                break;             /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command, C               sizeof(command),&key_symbol,(XComposeStatus *) NULL);              switch (key_symbol) 
             {                case XK_Escape:%               case XK_F20:               {%                 /*#                   Prematurely exit.m                 */#                 state|=EscapeState; !                 state|=ExitState;)                 break;               }t               case XK_F1:m               case XK_Help:s               {sN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }                default:               {_!                 XBell(display,0);X                 break;               }o
             }              break;           }            case MotionNotify:           {y             /*4               Discard pending pointer motion events.             */F             while (XCheckMaskEvent(display,PointerMotionMask,&event));+             rotate_info.x1=event.xmotion.x;I+             rotate_info.y1=event.xmotion.y;n           }y	         } &         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;,         if (direction == HorizontalRotateOp)           rotate_info.x2+=32;          else           rotate_info.y2-=32;e%       } while (!(state & ExitState));c-       XSelectInput(display,windows->image.id,a.         windows->image.attributes.event_mask);D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);3       if (state & EscapeState)         return(True);        /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0; F       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;        do       {m         if (distance > 9)            {_             /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id);l(             (void) sprintf(text," %.2f",F               direction == VerticalRotateOp ? degrees-90.0 : degrees);.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id, =               windows->image.highlight_context,&rotate_info);e           }o         else#           if (windows->info.mapped)gK             XWithdrawWindow(display,windows->info.id,windows->info.screen);d
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);a         if (distance > 9)f3           XHighlightLine(display,windows->image.id,e;             windows->image.highlight_context,&rotate_info);n         switch (event.type) 	         {:           case ButtonPress:              break;           case ButtonRelease:n           {              /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x; +             rotate_info.y2=event.xbutton.y;i             state|=ExitState;              break;           }i           case Expose:             break;           case MotionNotify:           {s             /*3               Discard pending button motion events.              */E             while (XCheckMaskEvent(display,ButtonMotionMask,&event));i+             rotate_info.x2=event.xmotion.x;a+             rotate_info.y2=event.xmotion.y;)           }o           default:             break;	         } 
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)L           rotate_info.x2=0;l         else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)            rotate_info.y2=0;e         else5           if (rotate_info.y2 > windows->image.height)t1             rotate_info.y2=windows->image.height;a
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=XP           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9):C           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2- G             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1)));X%       } while (!(state & ExitState)); D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);a       if (distance <= 9)         return(True);a     }:$   if (direction == VerticalRotateOp)     degrees-=90.0;   if (degrees == 0.0)n     return(True);    /*     Rotate image.X   */   normalized_degrees=degrees; $   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)t     normalized_degrees-=90.0;     if (normalized_degrees != 0.0)O     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);O   background.red=XDownScale(windows->image.pixel_info->pen_colors[pen_id].red);h   background.green==D     XDownScale(windows->image.pixel_info->pen_colors[pen_id].green);   background.blue=C     XDownScale(windows->image.pixel_info->pen_colors[pen_id].blue);e   background.index=0;uE   rotated_image=RotateImage(*image,degrees,&background,crop,sharpen);m)   XSetCursorState(display,windows,False);g&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);e   *image=rotated_image;i4   if (windows->image.crop_geometry != (char *) NULL)     {        /*         Rotate crop geometry.r       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);L       switch (rotations % 4)       {N         default:         case 0:s           break;         case 1: 	         {r           /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);r           break;	         }          case 2:_	         {            /*             Rotate 180 degrees.o           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);-           break;	         }          case 3:e	         {-           /*             Rotate 270 degrees.e           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);-           break;	         }        }      })   if (windows->image.orphan)     return(True);_    if (normalized_degrees != 0.0)     {a       /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {            /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,a             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         }iD       XConfigureImageColormap(display,resource_info,windows,*image);     }g   else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))        {rJ         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }    /*     Update image configuration.(   */?   (void) XConfigureImage(display,resource_info,windows,*image);u   return(True);i }a e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %aO %                                                                             %aO %                                                                             %hO %   X S a v e I m a g e                                                       %aO %                                                                             %oO %                                                                             %_O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %w0 %  Function XSaveImage saves an image to a file. % + %  The format of the XSaveImage routine is:a %X; %    status=XSaveImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:> %g> %    o status: Function XSaveImage return True if the image isJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %eF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.p %, %d */C static unsigned int XSaveImage(display,resource_info,windows,image)  Display;   *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Imageg
   **image; {    char     filename[MaxTextLength];     ImageInfoi     *image_info;     int      status;      register chart     *p;(     /*      Request file name from user.   */4   p=(*image)->filename+strlen((*image)->filename)-1;D   while ((p > (*image)->filename) && (*(p-1) != *BasenameSeparator))     p--;   (void) strcpy(filename,p);5   if (resource_info->write_filename != (char *) NULL) :     (void) strcpy(filename,resource_info->write_filename);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     return(True);s   if (access(filename,0) == 0)     {a       /*@         File exists-- seek user's permission before overwriting.       */B       status=XConfirmWidget(display,windows,"Overwrite",filename);       if (status == False)         return(True);      } '   image_info=resource_info->image_info;y/   (void) strcpy(image_info->filename,filename);w*   SetImageInfo(resource_info->image_info);1   if ((strcmp(image_info->magick,"JPEG") == 0) || .       (strcmp(image_info->magick,"JPG") == 0))     {,
       char         quality[MaxTextLength];          /*'         Request JPEG quality from user.        */7       (void) sprintf(quality,"%u",image_info->quality);iH       status=XDialogWidget(display,windows,"Save","Enter JPEG quality:",         quality);&       if (*quality == '\0')r         return(True);)(       image_info->quality=atoi(quality);D       image_info->interlace=status ? PlaneInterlace : NoneInterlace;     };0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) ||].       (strcmp(image_info->magick,"PS2") == 0))     {p
       char          geometry[MaxTextLength];         /*3         Request Postscript page geometry from user.        */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);MM       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",e5         "Select Postscript Page Geometry:",geometry);X       if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }l   /*     Write image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);-   (void) strcpy((*image)->filename,filename);_'   status=WriteImage(image_info,*image);e)   XSetCursorState(display,windows,False);aM   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);5   return(status);* }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %dO %                                                                             %;O %                                                                             %gO %   X S c r e e n E v e n t                                                   %XO %                                                                             %XO %                                                                             % O %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %dK %  Function XScreenEvent returns True if the certain events on the X serverd8 %  queue is associated with the image or Magnify window. %r. %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)M %e+ %  A description of each parameter follows:g %eL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %(< %    o event: Specifies a pointer to a X11 XEvent structure. %s9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */+ static int XScreenEvent(display,event,data)  Displayr   *display;,   XEvent	   *event;    char   *data; {d   register int     x,     y;     register XWindowsi
     *windows;      windows=(XWindows *) data;0   if (event->xany.window == windows->command.id)     return(True);-   switch (event->type)   {      case ButtonPress:w     case ButtonRelease:r     {_/       if ((event->xbutton.button == Button3) &&y,           (event->xbutton.state & Mod1Mask))	         {i           /*+             Convert Alt-Button3 to Button2._           */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }i8       if (event->xbutton.window == windows->backdrop.id)D         XSetInputFocus(display,event->xbutton.window,RevertToParent,           event->xbutton.time);t5       if (event->xbutton.window == windows->image.id)i$         if (windows->magnify.mapped)           {o             /*%               Update magnified image.m             */             x=event->xbutton.x;              y=event->xbutton.y;e             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;r2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;w2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);.           }s       return(True);t     }      case ClientMessage:a     {l       /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)          break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id)l	         {_O           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);            return(True);a	         }        break;     }-     case Expose:     {t5       if (event->xexpose.window == windows->image.id)a	         {h8           XRefreshWindow(display,&windows->image,event);           return(True);l	         }_3       if (event->xexpose.window == windows->pan.id)e&         if (event->xexpose.count == 0)           {g/             XDrawPanRectangle(display,windows);i             return(True);t           }a       break;     }      case KeyPress:     {i
       char         command[MaxTextLength];,         KeySym         key_symbol;X         /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);s4       if (event->xkey.window == windows->magnify.id)L         XMagnifyWindowCommand(display,windows,event->xkey.state,key_symbol);       return(True);h     }e     case MapNotify:v     {o4       if (event->xmap.window == windows->magnify.id)	         {;-           XMakeMagnifyImage(display,windows); '           windows->magnify.mapped=True;s           return(True);(	         }m1       if (event->xmap.window == windows->info.id)o	         {e$           windows->info.mapped=True;           return(True);e	         }r       break;     }s     case MotionNotify:     { 5       if (event->xmotion.window == windows->image.id)o$         if (windows->magnify.mapped)           {i             /*%               Update magnified image.i             */             x=event->xmotion.x;              y=event->xmotion.y;i             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1; 2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1; 2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);a           }        return(True);c     }a     case UnmapNotify:      { 6       if (event->xunmap.window == windows->magnify.id)	         {p(           windows->magnify.mapped=False;           return(True); 	         } 3       if (event->xunmap.window == windows->info.id)i	         { %           windows->info.mapped=False;            return(True); 	         }        break;     }      case KeyRelease:     case SelectionNotify:        return(True);u     default:       break;   }    return(False); }n s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %dO %                                                                             % O %                                                                             %eO %   X S e t C r o p G e o m e t r y                                           %nO %                                                                             %-O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %;H %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image.o %m1 %  The format of the XSetCropGeometry routine is:p %,6 %    XSetCropGeometry(display,windows,crop_info,image) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %m< %    o windows: Specifies a pointer to a XWindows structure. %nL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. %;7 %    o image: Specifies a pointer to a Image structure.r %; %  */= static void XSetCropGeometry(display,windows,crop_info,image)  Displaya   *display;    XWindows   *windows;   
 RectangleInfo 
   *crop_info;    Imagel	   *image;  {    char     text[MaxTextLength];     intr     x,     y;     unsigned int     height,=
     width;     unsigned long      scale_factor;a     if (windows->info.mapped)m     {        /*+         Display info on cropping rectangle.        */L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y); (       XInfoWidget(display,windows,text);     }e   /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;o   height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);o   else     {        /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));(8       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }    /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;c   if (crop_info->x > 0) ,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);    if (width == 0)i     width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;e   if (crop_info->y > 0)e,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);(   if (height == 0)
     height=1;yN   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }C k /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %_O %                                                                             % O %                                                                             %eO %   X T i l e I m a g e                                                       %oO %                                                                             %nO %                                                                             %rO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%w %UE %  Function XTileImage loads or deletes a selected tile from a visualrG %  image directory.  The load or delete command is choosen from a menu.t %c+ %  The format of the XTileImage routine is:" % F %    tiled_image=XTileImage(display,resource_info,windows,image,event) %v+ %  A description of each parameter follows:  % @ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %hE %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. %wK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %(< %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned fromo %      ReadImage.  % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.C %r %( */C static Image *XTileImage(display,resource_info,windows,image,event)l Displayc   *display;s  
 XResourceInfo    *resource_info;    XWindows   *windows;    Imagec	   *image;    XEvent	   *event;M {e #define LoadVerbOp  0  #define NextVerbOp  1s #define FormerVerbOp  2  #define DeleteVerbOp  3  #define UpdateVerbOp  4l     char     command[MaxTextLength],r     filename[MaxTextLength];     Imagei     *tiled_image;      intr     status, 	     tile, 	     verb,;     x,     y;     register charr     *p,      *q;      register int     i;  
   static char      *VerbMenu[]=     {s
       "Load",s
       "Next",)       "Former",f       "Delete",        "Update",a       (char *) NULL,     };     unsigned int     height,u
     width;     unsigned longf     scale_factor;r     /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;w   height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);n;   scale_factor=UpShift(width)/windows->image.ximage->width;m%   event->xbutton.x+=windows->image.x;s>   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height;i%   event->xbutton.y+=windows->image.y; >   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*K     Determine size and location of each tile in the visual image directory.e   */   x=0;   y=0;   width=image->columns;t   height=image->rows;e=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);s@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;c   if (tile < 0)r     {e       /*)         Button press is outside any tile.t       */       XBell(display,0);        return((Image *) NULL);a     }    /*0     Determine file name from the tile directory.   */   p=image->directory; *   for (i=tile; (i != 0) && (*p != '\0'); )   {n     if (*p == '\n') 
       i--;     p++;   }_   if (*p == '\0')t     {a       /*)         Button press is outside any tile.*       */       XBell(display,0);e       return((Image *) NULL);l     }t   /**     Select a command from the pop-up menu.   */A   verb=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);    if (verb < 0)      return((Image *) NULL);(   q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);    filename[q-p]='\0';g   /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;n   switch (verb)a   {p     case LoadVerbOp:     {a       /*         Load tile image.       */,       XCheckRefreshWindows(display,windows);>       (void) strcpy(resource_info->image_info->magick,"MIFF");B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info);rE       XWithdrawWindow(display,windows->info.id,windows->info.screen);,       break;     }u     case NextVerbOp:     {s       /*         Display next image.        */E       XClientMessage(display,windows->image.id,windows->im_protocols,e,         windows->im_next_image,CurrentTime);       break;     }g     case FormerVerbOp:     {        /*         Display former image.u       */E       XClientMessage(display,windows->image.id,windows->im_protocols, .         windows->im_former_image,CurrentTime);       break;     };     case DeleteVerbOp:     {n       /*         Delete tile image.       */"       if (access(filename,0) != 0)	         {wO           XNoticeWidget(display,windows,"Image file does not exist:",filename);i           break;	         }vK       status=XConfirmWidget(display,windows,"Really delete tile",filename);        if (status == False)         break;       status=unlink(filename);       if (status != False)	         {SG           XNoticeWidget(display,windows,"Unable to delete image file:",w             filename);           break;	         }a     }u     case UpdateVerbOp:     {g	       int          x_offset,p         y_offset;          register int
         j;         register RunlengthPacket         *r;(         /*$         Ensure all the images exist.       */"       if (!UncompressImage(image))         return((Image *) NULL);s
       tile=0;:/       for (p=image->directory; *p != '\0'; p++)m       {          q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;'         (void) strncpy(filename,p,q-p);          filename[q-p]='\0';          p=q;$         if (access(filename,0) == 0)           {              tile++;p             continue;            }w
         /*/           Overwrite tile with background color.a
         */=         x_offset=width*(tile % ((image->columns-x)/width))+x;l<         y_offset=height*(tile/((image->columns-x)/width))+y;"         for (i=0; i < height; i++)	         { A           r=image->pixels+((y_offset+i)*image->columns+x_offset);i#           for (j=0; j < width; j++)o"             *r++=(*image->pixels);	         }          tile++;e       }_9       windows->image.window_changes.width=image->columns;p7       windows->image.window_changes.height=image->rows; C       XConfigureImageColormap(display,resource_info,windows,image);dB       (void) XConfigureImage(display,resource_info,windows,image);       break;     }      default:       break;   } )   XSetCursorState(display,windows,False);a   return(tiled_image); }S u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             % O %                                                                             %aO %   X T r a n s l a t e I m a g e                                             %nO %                                                                             % O %                                                                             % O %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %=G %  Function XTranslateImage translates the image within an Image window M %  by one pixel as specified by the key symbol.  If the image has a `montage'sM %  string the translation is respect to the width and height contained within= %  the string. %:0 %  The format of the XTranslateImage routine is: %_6 %    XTranslateImage(display,windows,image,key_symbol) %,+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %o< %    o windows: Specifies a pointer to a XWindows structure. %;F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.u %rM %    o key_symbol: Specifies a KeySym which indicates which side of the image  %      to trim.c %" %  */= static void XTranslateImage(display,windows,image,key_symbol)  Displayr   *display;,   XWindows   *windows;f   Image-	   *image;a   KeySym
   key_symbol;  {n   char     text[MaxTextLength];     inti     x,     y;     unsigned int
     x_offset,l
     y_offset;o     /*)     User specified a pan position offset.X   */    x_offset=windows->image.width;!   y_offset=windows->image.height; &   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)s   {_     case XK_Home:a     case XK_KP_Home:     {r1       windows->image.x=windows->image.width >> 1;i2       windows->image.y=windows->image.height >> 1;       break;     }r     case XK_Left:a     case XK_KP_Left:     {I!       windows->image.x-=x_offset;*       break;     };     case XK_Next:X     case XK_Up:      case XK_KP_Up:     {t!       windows->image.y-=y_offset;        break;     }s     case XK_Right:     case XK_KP_Right:i     {l!       windows->image.x+=x_offset;d       break;     }s     case XK_Prior:     case XK_Down:)     case XK_KP_Down:     {)!       windows->image.y+=y_offset;        break;     }e     default:
       return;r   }(   /*     Check boundary conditions.   */   if (windows->image.x < 0)      windows->image.x=0;    elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width) I       windows->image.x=windows->image.ximage->width-windows->image.width;    if (windows->image.y < 0)u     windows->image.y=0;e   else2     if ((windows->image.y+windows->image.height) >'          windows->image.ximage->height) K       windows->image.y=windows->image.ximage->height-windows->image.height;r   /*     Refresh Image window.    */;   (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,X=     windows->image.height,windows->image.x,windows->image.y);n$   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows); :   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);r }2 a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             %)O %                                                                             % O %   X T r i m I m a g e                                                       %mO %                                                                             %gO %                                                                             %0O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XTrimImage trims the edges from the Image window.; % + %  The format of the XTrimImage routine is:u %_; %    status=XTrimImage(display,resource_info,windows,image)a %i+ %  A description of each parameter follows:a % ? %    o status: Function XTrimImage returns True if the image isfJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %(K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %1< %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. % 7 %    o image: Specifies a pointer to a Image structure.i %e %g */C static unsigned int XTrimImage(display,resource_info,windows,image)I Displayl   *display;n  
 XResourceInfo)   *resource_info;    XWindows   *windows;    Image 	   *image;a {    RectangleInfox     trim_info;     register int     x,     y;     unsigned longv     background, 
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   /*     Crop the left edge.e   */2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;r2   for (x=0; x < windows->image.ximage->width; x++)   { 5     for (y=0; y < windows->image.ximage->height; y++)>     {n1       pixel=XGetPixel(windows->image.ximage,x,y);i       if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   }i   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {m-       XSetCursorState(display,windows,False);        return(False);     }i   /*     Crop the right edge.   */O   background=XGetPixel(windows->image.ximage,windows->image.ximage->width-1,0);s4   for (x=windows->image.ximage->width-1; x > 0; x--)   {n5     for (y=0; y < windows->image.ximage->height; y++)i     {i1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }o*     if (y < windows->image.ximage->height)       break;   }y"   trim_info.width=x-trim_info.x+1;   /*     Crop the top edge.   */2   background=XGetPixel(windows->image.ximage,0,0);1   trim_info.height=windows->image.ximage->height;u3   for (y=0; y < windows->image.ximage->height; y++)i   {i4     for (x=0; x < windows->image.ximage->width; x++)     { 1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }s)     if (x < windows->image.ximage->width)k       break;   }l   trim_info.y=y;   /*     Crop the bottom edge.2   */P   background=XGetPixel(windows->image.ximage,0,windows->image.ximage->height-1);5   for (y=windows->image.ximage->height-1; y > 0; y--)-   {e4     for (x=0; x < windows->image.ximage->width; x++)     {a1       pixel=XGetPixel(windows->image.ximage,x,y);f       if (pixel != background)         break;     } )     if (x < windows->image.ximage->width)        break;   } #   trim_info.height=y-trim_info.y+1;"2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {o       /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image); :       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     }a)   XSetCursorState(display,windows,False);,   return(True);  }  f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %oO %                                                                             %lO %                                                                             %XO %   X V i s u a l D i r e c t o r y I m a g e                                 %_O %                                                                             %tO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %;C %  Function XVisualDirectoryImage creates a Visual Image Directory.  %/6 %  The format of the XVisualDirectoryImage routine is: %,F %    loaded_image=XVisualDirectoryImage(display,resource_info,windows) %i+ %  A description of each parameter follows:, % J %    o loaded_image: Function XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null imagee %      is returned.  %*D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %i< %    o windows: Specifies a pointer to a XWindows structure. %r %  */B static Image *XVisualDirectoryImage(display,resource_info,windows) Display    *display;o  
 XResourceInfo.   *resource_info;v   XWindows   *windows;a {e. #define LoadImageText  "  Loading images...  " #define XClientName  "montage"     char     **filelist,      *resource_value,     window_id[MaxTextLength];=     Imageo     *image,r
     **images,      *scaled_image;     ImageInfo4     local_info;      intI     number_files;>     MonitorHandler     handler;     register int     i,     j;  
   static chard#     filename[MaxTextLength] = "\0",g#     filenames[MaxTextLength] = "*";n     unsigned int
     backdrop,;     height,i     status,r
     width;     XMontageInfo
     vid_info;      XResourceInfor     background_resources,o     vid_resources;  
   XrmDatabase      resource_database;     /*      Request file name from user.   */<   XFileBrowserWidget(display,windows,"Directory",filenames);   if (*filenames == '\0')      return((Image *) NULL);p   /*     Expand the filenames.    */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)      {"7       Warning("Memory allocation error",(char *) NULL);g       return((Image *) NULL);;     }    number_files=1;d   filelist[0]=filenames;+   ExpandFilenames(&number_files,&filelist);n   if (number_files == 0)     {,5       Warning("No image files were found",filenames);(       return((Image *) NULL);C     }r   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));r    if (images == (Image **) NULL)     {o7       Warning("Memory allocation error",(char *) NULL); &       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);e       free((char *) filelist);       return((Image *) NULL);.     }(   /*/     Get any Visual Image Directory X resources.e   */5   resource_database=resource_info->resource_database;s!   vid_resources=(*resource_info);rH   vid_resources.background_color=XGetResourceInstance(resource_database,4     XClientName,"background",DefaultTileBackground);O   resource_value=XGetResourceClass(resource_database,XClientName,"borderWidth",      DefaultTileBorderwidth);2   vid_resources.border_width=atoi(resource_value);5   vid_resources.font=resource_info->image_info->font;rH   vid_resources.foreground_color=XGetResourceInstance(resource_database,4     XClientName,"foreground",DefaultTileForeground);F   vid_resources.image_geometry=XGetResourceInstance(resource_database,5     XClientName,"imageGeometry",DefaultTileGeometry);gC   vid_resources.matte_color=XGetResourceInstance(resource_database, /     XClientName,"mattecolor",DefaultTileMatte);    /*#     Set image background resources.    */(   background_resources=(*resource_info);+   background_resources.window_id=window_id; K   (void) sprintf(background_resources.window_id,"0x%lx",windows->image.id);"%   background_resources.backdrop=True;    /*/     Read each image and convert them to a tile.a   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   backdrop=(windows->image.visual_info->class == TrueColor) ||6    (windows->image.visual_info->class == DirectColor);   j=0;"   for (i=0; i < number_files; i++)   { 5     handler=SetMonitorHandler((MonitorHandler) NULL); ,     local_info=(*resource_info->image_info);$     local_info.filename=filelist[i];     *local_info.magick='\0';)     if (local_info.size == (char *) NULL)o3       local_info.size=vid_resources.image_geometry; !     image=ReadImage(&local_info); !     if (filelist[i] != filenames);!       free((char *) filelist[i]);i      if (image == (Image *) NULL)       continue;'     image->scene=j;v     image->matte=False;      LabelImage(image,"%f");m     /*       Scale image.     */     width=image->columns;_     height=image->rows;cD     ParseImageGeometry(vid_resources.image_geometry,&width,&height);0     scaled_image=ScaleImage(image,width,height);     DestroyImage(image);'     if (scaled_image == (Image *) NULL)C       continue;      image=scaled_image;      if (backdrop)p       {wL         (void) XDisplayBackgroundImage(display,&background_resources,image);.         XSetCursorState(display,windows,True);       }n     images[j]=image;     j++;&     (void) SetMonitorHandler(handler);2     ProgressMonitor(LoadImageText,i,number_files);   };$   (void) SetMonitorHandler(handler);   free((char *) filelist);
   if (j == 0)/     { -       XSetCursorState(display,windows,False);C1       Warning("No images were loaded",filenames);y       free((char *) images);       return((Image *) NULL);      }S   /*>     Request the Visual Image Directory filename from the user.   */A   XClientMessage(display,windows->image.id,windows->im_protocols, (     windows->im_next_image,CurrentTime);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     {h       free((char *) images);       return((Image *) NULL);n     }g   /*&     Create the Visual Image Directory.   */:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);   XGetMontageInfo(&vid_info);w   vid_info.number_tiles=j;@   image=XMontageImage(images,&vid_resources,&vid_info,filename);)   XSetCursorState(display,windows,False);o   free((char *) images);   if (image == (Image *) NULL)     return(image);   /*$     Save the Visual Image Directory.   */*   local_info=(*resource_info->image_info);   local_info.filename=filename;    local_info.adjoin=True;d   SetImageInfo(&local_info);,   if (strcmp(local_info.magick,"MIFF") != 0)"     XNoticeWidget(display,windows,N       "Visual Image Directory is non-conforming (not MIFF format):",filename);'   status=WriteImage(&local_info,image);    if (status == False)L     XNoticeWidget(display,windows,"Unable to write Visual Image Directory:",       filename);   return(image); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             %SO %                                                                             %;O %   X W a r n i n g                                                           %nO %                                                                             %fO %                                                                             % O %                                                                             %!O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %pC %  Function XWarning displays a warning message in a Notice widget.* % ) %  The format of the XWarning routine is:= % " %      XWarning(message,qualifier) %u+ %  A description of each parameter follows:a % G %    o message: Specifies the message to display before terminating the  %      program.r %q9 %    o qualifier: Specifies any qualifier to the message.r %i %, */' static void XWarning(message,qualifier)y char   *message,i
   *qualifier;  {    char     text[MaxTextLength];     if (message == (char *) NULL)n     return;    (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %dO %                                                                             %lO %                                                                             % O %    M a i n                                                                  %pO %                                                                             %aO %                                                                             %_O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(argc,argv)r int    argc;    char	   **argv;  {t+ #define NotInitialized  (unsigned int) (~0)e     char     density[MaxTextLength],t     *option,     *resource_value,     *server_name;C     floate     x_density,     y_density;     Imageo     *image,      *next_image;     ImageInfoi     image_info;      inta     x,     y;     register int     i,     j;     unsigned int     first_scene,     height,      *image_marker,     image_number,,     last_scene,)
     scene,
     width;     unsigned long 
     state;     XResourceInfo_     resource_info;  
   XrmDatabasee     resource_database;     /*     Set defaults.:   */    client_name=ClientName(*argv);   display=(Display *) NULL;    first_scene=0;F   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)g     image_marker[i]=argc;i   image_number=0;>   GetImageInfo(&image_info);   last_scene=0;o'   resource_database=(XrmDatabase) NULL;    server_name=(char *) NULL;   state=DefaultState;t   /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);p   for (i=1; i < argc; i++)   {t     /*)       Check command line for server name.X     */     option=argv[i];KN     if (((int) strlen(option) == 1) || ((*option != '-') && (*option != '+')))       continue;.+     if (strncmp("display",option+1,3) == 0)c       {h
         /*%           User specified server name.s
         */         i++;         if (i == argc)A           Error("Missing server name on -display",(char *) NULL);m         server_name=argv[i];         break;       } (     if (strncmp("help",option+1,2) == 0)       Usage(True);   })   /*     Open X server connection.t   */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));=   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);o   /*/     Get user defaults from X resource database.f   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);nA   (void) sscanf(PSDensityGeometry,"%fx%f",&x_density,&y_density);w=   (void) XParseGeometry(PSPageGeometry,&x,&y,&width,&height);x7   (void) sprintf(density,"%f",Min(x_density,y_density)*nJ     (XDisplayHeight(display,XDefaultScreen(display))-40)/(double) height);   image_info.density=iG     XGetResourceClass(resource_database,client_name,"density",density);r   resource_value= H     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace; 0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace;a1   if (Latin1Compare("plane",resource_value) == 0)s(     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace)e:     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value=%D     XGetResourceClass(resource_database,client_name,"quality","75");*   image_info.quality=atoi(resource_value);   resource_value= G     XGetResourceClass(resource_database,client_name,"verbose","False"); ,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.    */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)    {      if (i < argc)        option=argv[i];=     else       if (image_number != 0)         break;
       else!         if (isatty(STDIN_FILENO))            option="logo:";          else           option="-"; M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))%       switch (*(option+1))       {%         case 'b':%	         {%2           if (strncmp("backdrop",option+1,5) == 0)
             {m6               resource_info.backdrop=(*option == '-');               break;
             }.8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             {n;               resource_info.background_color=(char *) NULL; !               if (*option == '-')d                 {n                   i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];-                 }c               break;
             }v-           if (strcmp("border",option+1) == 0)n
             {t!               if (*option == '-')M                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -border",(char *) NULL);a                 },               break;
             }e5           if (strncmp("bordercolor",option+1,7) == 0)n
             {-7               resource_info.border_color=(char *) NULL;o!               if (*option == '-')                  {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);.5                   resource_info.border_color=argv[i];i                 }.               break;
             }(5           if (strncmp("borderwidth",option+1,7) == 0) 
             { +               resource_info.border_width=0;i!               if (*option == '-')i                 {.                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL); ;                   resource_info.border_width=atoi(argv[i]);d                 }                break;
             }t/             if (strncmp("box",option+1,3) == 0)                {e#                 if (*option == '-'))                   {h                     i++;"                     if (i == argc)C                       Error("Missing color on -box",(char *) NULL);h                   }g                 break;               }u.           Error("Unrecognized option",option);           break;	         }r         case 'c': 	         {s2           if (strncmp("colormap",option+1,6) == 0)
             { 5               resource_info.colormap=PrivateColormap; !               if (*option == '-')t                 {o                   i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL);a!                   option=argv[i];n;                   resource_info.colormap=UndefinedColormap;e;                   if (Latin1Compare("private",option) == 0)a;                     resource_info.colormap=PrivateColormap;y:                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);%                 }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { ,               resource_info.number_colors=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 5               resource_info.colorspace=RGBColorspace;%!               if (*option == '-')%                 {o                   i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL);a!                   option=argv[i];i?                   resource_info.colorspace=UndefinedColorspace;s8                   if (Latin1Compare("gray",option) == 0)                     {c>                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      }i8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0)w;                     resource_info.colorspace=RGBColorspace;m7                   if (Latin1Compare("xyz",option) == 0)*;                     resource_info.colorspace=XYZColorspace;u9                   if (Latin1Compare("ycbcr",option) == 0)t=                     resource_info.colorspace=YCbCrColorspace;W7                   if (Latin1Compare("yiq",option) == 0));                     resource_info.colorspace=YIQColorspace;H9                   if (Latin1Compare("ypbpr",option) == 0) =                     resource_info.colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0)f;                     resource_info.colorspace=YUVColorspace;wF                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);i                 }                break;
             } 1           if (strncmp("comment",option+1,4) == 0)m
             {d!               if (*option == '-')w                 {u                   i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);)                 }-               break;
             } 2           if (strncmp("compress",option+1,3) == 0)
             {:!               if (*option == '-')                  {a                   i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL);_!                   option=argv[i];eD                   if (Latin1Compare("runlengthencoded",option) == 0)                     break;                   else:                     if (Latin1Compare("zlib",option) == 0)                       break;                     elseL                       Error("Invalid compression type on -compress",option);                 }%               break;
             }%2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);m                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');%               break;
             }%/           if (strncmp("delay",option+1,3) == 0)n
             {e$               resource_info.delay=0;!               if (*option == '-')X                 {e                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL);i4                   resource_info.delay=atoi(argv[i]);                 }u               break;
             }11           if (strncmp("density",option+1,3) == 0)c
             { /               image_info.density=(char *) NULL;f!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];n                 }t               break;
             }i3           if (strncmp("despeckle",option+1,3) == 0)a             break;1           if (strncmp("display",option+1,3) == 0)p
             {m(               server_name=(char *) NULL;!               if (*option == '-')r                 {a                   i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL);a&                   server_name=argv[i];                 }N4               resource_info.server_name=server_name;               break;
             }r0           if (strncmp("dither",option+1,3) == 0)
             {d4               resource_info.dither=(*option == '-');               break;
             }%.           Error("Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -edge",(char *) NULL);                  }                break;
             } 1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }%         case 'f':%	         { .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             {n/               resource_info.font=(char *) NULL;g!               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];f                 }o               break;
             }n8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;e                  if (i == argc)eL                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }/           if (strncmp("frame",option+1,2) == 0) 
             {e!               if (*option == '-')e                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing geometry on -frame",(char *) NULL);                 }e               break;
             }e.           Error("Unrecognized option",option);           break;	         }          case 'g':s	         {k/           if (strncmp("gamma",option+1,2) == 0)S
             {(!               if (*option == '-')=                 {,                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);m                 }y               break;
             }l2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL;t!               if (*option == '-')                  {t                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL);l7                   resource_info.image_geometry=argv[i];i                 }                break;
             }s.           Error("Unrecognized option",option);           break;	         }y         case 'h':)	         { .           if (strncmp("help",option+1,2) == 0)             Usage(True);.           Error("Unrecognized option",option);           break;	         }x         case 'i':n	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             { 8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')e                 {(                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))M                     Error("Missing geometry on -iconGeometry",(char *) NULL);o6                   resource_info.icon_geometry=argv[i];                 }                break;
             } 0           if (strncmp("iconic",option+1,5) == 0)
             {u4               resource_info.iconic=(*option == '-');               break;
             } 3           if (strncmp("immutable",option+1,5) == 0)n
             {.7               resource_info.immutable=(*option == '-');a               break;
             }V3           if (strncmp("interlace",option+1,3) == 0)E
             {d1               image_info.interlace=NoneInterlace; !               if (*option == '-')M                 {l                   i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i];e:                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace;p8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace;t9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);X                 }a               break;
             }L.           Error("Unrecognized option",option);           break;	         }n         case 'l':o	         {o/           if (strncmp("label",option+1,2) == 0))
             {a!               if (*option == '-')s                 {>                   i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }d               break;
             }c.           Error("Unrecognized option",option);           break;	         }>         case 'm': 	         {t1           if (strncmp("magnify",option+1,3) == 0)s
             { &               resource_info.magnify=2;!               if (*option == '-')w                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL);I6                   resource_info.magnify=atoi(argv[i]);                 }n               break;
             }n-           if (strncmp("map",option+1,3) == 0)n
             {=3               resource_info.map_type=(char *) NULL; !               if (*option == '-')                  {/                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];o                 }                break;
             } ,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { 6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')s                 {                    i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 }e               break;
             }n2           if (strncmp("modulate",option+1,3) == 0)
             { !               if (*option == '-')t                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }                break;
             }"4           if (strncmp("monochrome",option+1,3) == 0)
             { 8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)l                 {o0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8;(:                   resource_info.colorspace=GRAYColorspace;                 }                break;
             }a.           Error("Unrecognized option",option);           break;	         }i         case 'n':r	         { .           if (strncmp("name",option+1,2) == 0)
             {t/               resource_info.name=(char *) NULL; !               if (*option == '-')(                 {                    i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL); -                   resource_info.name=argv[i];a                 }u               break;
             }i0           if (strncmp("negate",option+1,2) == 0)             break;/           if (strncmp("noise",option+1,3) == 0)              break;3           if (strncmp("normalize",option+1,3) == 0)i             break;.           Error("Unrecognized option",option);           break;	         }a         case 'o': 	         {e0           if (strncmp("opaque",option+1,2) == 0)
             {p!               if (*option == '-')                  {i                   i++;                    if (i == argc)D                     Error("Missing color on -opaque",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             {C,               image_info.page=(char *) NULL;!               if (*option == '-')h                 {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }r               break;
             } -           if (strncmp("pen",option+1,2) == 0)v
             { !               if (*option == '-')                  {n                   i++;                    if (i == argc)A                     Error("Missing color on -pen",(char *) NULL);r                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }b         case 'q':=	         {o1           if (strncmp("quality",option+1,2) == 0)r
             {,#               image_info.quality=0;a!               if (*option == '-')m                 {f                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing quality on -quality",(char *) NULL); 3                   image_info.quality=atoi(argv[i]);s                 }                break;
             }t.           Error("Unrecognized option",option);           break;	         }o         case 'r':.	         { /           if (strncmp("raise",option+1,2) == 0)e
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);w               break;
             } .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')l                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -roll",(char *) NULL);d                 }e               break;
             }H0           if (strncmp("rotate",option+1,3) == 0)
             {;!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }e               break;
             }c.           Error("Unrecognized option",option);           break;	         }          case 's':o	         { 0           if (strncmp("sample",option+1,2) == 0)
             {o!               if (*option == '-')(                 {d                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -sample",(char *) NULL);W                 }a               break;
             }e/           if (strncmp("scene",option+1,3) == 0)x
             {f               first_scene=0;               last_scene=0;i!               if (*option == '-')                  {d                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene;tJ                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }g               break;
             } 1           if (strncmp("segment",option+1,3) == 0)o
             { !               if (*option == '-')(                 {_                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))I                     Error("Missing threshold on -segment",(char *) NULL);e                 }                break;
             }a1           if (strncmp("sharpen",option+1,3) == 0)i
             {o!               if (*option == '-')                  {(                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }                break;
             }e/           if (strncmp("shear",option+1,3) == 0) 
             {a!               if (*option == '-')e                 {g                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 }                break;
             } 7           if (strncmp("shared_memory",option+1,4) == 0);
             { ?               resource_info.use_shared_memory=(*option == '-');h               break;
             }e.           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')/                 {U                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL);;*                   image_info.size=argv[i];                 }d               break;
             }n0           if (strncmp("spread",option+1,2) == 0)
             { !               if (*option == '-')p                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing amount on -spread",(char *) NULL);t                 }                break;
             }+.           Error("Unrecognized option",option);           break;	         }          case 't':e	         {]3           if (strncmp("text_font",option+1,3) == 0) 
             {g4               resource_info.text_font=(char *) NULL;!               if (*option == '-')                  {a                   i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL); 2                   resource_info.text_font=argv[i];                 }i               break;
             } 1           if (strncmp("texture",option+1,5) == 0) 
             { /               image_info.texture=(char *) NULL;m!               if (*option == '-')r                 {                    i++;                    if (i == argc)H                     Error("Missing filename on -texture",(char *) NULL);-                   image_info.texture=argv[i];                  }                break;
             } /           if (strncmp("title",option+1,2) == 0) 
             {+0               resource_info.title=(char *) NULL;!               if (*option == '-')*                 {;                   i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL);i.                   resource_info.title=argv[i];                 }.               break;
             }r5           if (strncmp("transparent",option+1,3) == 0)u
             {n!               if (*option == '-')%                 {%                   i++;                    if (i == argc)I                     Error("Missing color on -transparent",(char *) NULL);                  }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { )               resource_info.tree_depth=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL); 9                   resource_info.tree_depth=atoi(argv[i]);                  }                break;
             }%.           Error("Unrecognized option",option);           break;	         }          case 'u':i	         {t0           if (strncmp("update",option+1,2) == 0)
             {r4               resource_info.update=(*option == '-');!               if (*option == '-')m                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }L               break;
             }h4           if (strncmp("use_pixmap",option+1,2) == 0)
             { 8               resource_info.use_pixmap=(*option == '-');               break;
             }h.           Error("Unrecognized option",option);           break;	         }d         case 'v': 	         {r1           if (strncmp("verbose",option+1,2) == 0)/
             {s2               image_info.verbose=(*option == '-');               break;
             }w0           if (strncmp("visual",option+1,2) == 0)
             {l6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')X                 {s                   i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL);s4                   resource_info.visual_type=argv[i];                 }t               break;
             }C.           Error("Unrecognized option",option);           break;	         }u         case 'w':o	         {e-           if (strcmp("window",option+1) == 0)f
             {e4               resource_info.window_id=(char *) NULL;!               if (*option == '-')a                 {w                   i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window",n%                       (char *) NULL);c2                   resource_info.window_id=argv[i];                 }n               break;
             }e6           if (strncmp("window_group",option+1,7) == 0)
             {o7               resource_info.window_group=(char *) NULL; !               if (*option == '-')                  {C                   i++;                    if (i == argc)I                     Error("Missing id, name, or 'root' on -window_group",h%                       (char *) NULL);x5                   resource_info.window_group=argv[i];;                 }d               break;
             } /           if (strncmp("write",option+1,2) == 0) 
             { 9               resource_info.write_filename=(char *) NULL; !               if (*option == '-')e                 {t                   i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL);t7                   resource_info.write_filename=argv[i]; B                   if (access(resource_info.write_filename,0) == 0)                     {i                       char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ", 6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }h                 }a               break;
             } .           Error("Unrecognized option",option);           break;	         }i         case '?': 	         {>           Usage(True);           break;	         }s         default:	         {s.           Error("Unrecognized option",option);           break;	         }        }s     else<       for (scene=first_scene; scene <= last_scene ; scene++)       {m
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {d             char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene);a:             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene);t8             (void) strcpy(image_info.filename,filename);           }(0         (void) strcpy(image_info.magick,"MIFF");9         image_info.server_name=resource_info.server_name;S+         image_info.font=resource_info.font; /         image_info.dither=resource_info.dither;n7         image_info.monochrome=resource_info.monochrome;n/         resource_info.image_info=(&image_info);)%         image=ReadImage(&image_info);%$         if (image == (Image *) NULL)5           if ((i < (argc-1)) || (scene < last_scene))              continue;            else
             {                state|=ExitState;                break;
             } 
         do	         {            /*J             Transmogrify image as defined by the image processing options.           */"           resource_info.quantum=1;2           MogrifyImage(&image_info,i,argv,&image);(           if (first_scene != last_scene)             image->scene=scene;            /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL)%
             {%               unsigned int                 status;%                 /*6                 Display image to a specified X window.               */K               status=XDisplayBackgroundImage(display,&resource_info,image);r               if (status)i)                 state|=RetainColorsState;,+               if (resource_info.delay == 0)p!                 state|=ExitState; 
             }:           else             do
             {                Imagea                 *loaded_image;                 /**                 Display image to X server.               */               loaded_image=sN                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)                  break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               {e;                 if (loaded_image->montage != (char *) NULL)                    {e                     /*G                       User selected a visual directory image (montage).o                     */)                     DestroyImages(image);o'                     image=loaded_image;f                     break;                   } ?                 MogrifyImage(&image_info,i,argv,&loaded_image); .                 if (first_scene != last_scene)%                   image->scene=scene;uJ                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image).                   DestroyImages(loaded_image);(                 loaded_image=next_image;               }n+             } while (!(state & ExitState));t<           if (resource_info.write_filename != (char *) NULL)
             {U               /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image); 
             }-!           if (image_info.verbose)c.             DescribeImage(image,stderr,False);           /*+             Proceed to next/previous image.l           */           next_image=image;d'           if (state & FormerImageState)o5             for (j=0; j < resource_info.quantum; j++) 
             {o.               next_image=next_image->previous;/               if (next_image == (Image *) NULL)i                 break;
             }            else5             for (j=0; j < resource_info.quantum; j++) 
             {h*               next_image=next_image->next;/               if (next_image == (Image *) NULL)t                 break;
             })+           if (next_image != (Image *) NULL)a             image=next_image;wI         } while ((next_image != (Image *) NULL) && !(state & ExitState)); 
         /*           Free image resources. 
         */         DestroyImages(image);i(         if (!(state & FormerImageState)))           image_marker[i]=image_number++;          else           {,             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--) 6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;&           }o         if (state & ExitState)           break;       }t     /*8       Determine if we should proceed to the first image.     */     if (i == (argc-1))A       if (resource_info.confirm_exit && (state & NextImageState))f	         {y           unsigned int             status;              /*!             Confirm program exit.n           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",              client_name);            if (status == False)
             {                i=0;               image_number=0; 
             } 	         }    }m    if (state & RetainColorsState)N     XRetainWindowColors(display,XRootWindow(display,XDefaultScreen(display)));   free((char *) image_marker);%   free((char *) image_info.filename);    XCloseDisplay(display); 
   exit(0);   return(False); } 