 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "XWDFile.h"   /*   Define declarations. */- #define LoadImageText  "  Loading image...  " & #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    DestroyImages(image); \    return((Image *) NULL); \  }    /*   Function prototypes. */ Image %   *ReadImage _Declare((ImageInfo *));    static Image>   *OverviewImage _Declare((ImageInfo *,Image *,unsigned int)),(   *ReadAVSImage _Declare((ImageInfo *)),(   *ReadBMPImage _Declare((ImageInfo *)),)   *ReadCMYKImage _Declare((ImageInfo *)), (   *ReadDPSImage _Declare((ImageInfo *)),(   *ReadFAXImage _Declare((ImageInfo *)),)   *ReadFITSImage _Declare((ImageInfo *)), (   *ReadGIFImage _Declare((ImageInfo *)),)   *ReadGRAYImage _Declare((ImageInfo *)), (   *ReadHDFImage _Declare((ImageInfo *)),.   *ReadHISTOGRAMImage _Declare((ImageInfo *)),)   *ReadHTMLImage _Declare((ImageInfo *)), )   *ReadJBIGImage _Declare((ImageInfo *)), )   *ReadJPEGImage _Declare((ImageInfo *)), )   *ReadLOGOImage _Declare((ImageInfo *)), (   *ReadMAPImage _Declare((ImageInfo *)),*   *ReadMATTEImage _Declare((ImageInfo *)),)   *ReadMIFFImage _Declare((ImageInfo *)), )   *ReadMPEGImage _Declare((ImageInfo *)), (   *ReadMTVImage _Declare((ImageInfo *)),)   *ReadNULLImage _Declare((ImageInfo *)), (   *ReadPCDImage _Declare((ImageInfo *)),(   *ReadPCXImage _Declare((ImageInfo *)),(   *ReadPDFImage _Declare((ImageInfo *)),)   *ReadPICTImage _Declare((ImageInfo *)), (   *ReadPNGImage _Declare((ImageInfo *)),(   *ReadPNMImage _Declare((ImageInfo *)),'   *ReadPSImage _Declare((ImageInfo *)), -   *ReadRADIANCEImage _Declare((ImageInfo *)), (   *ReadRGBImage _Declare((ImageInfo *)),(   *ReadRLEImage _Declare((ImageInfo *)),(   *ReadSGIImage _Declare((ImageInfo *)),(   *ReadSUNImage _Declare((ImageInfo *)),(   *ReadTGAImage _Declare((ImageInfo *)),)   *ReadTEXTImage _Declare((ImageInfo *)), )   *ReadTIFFImage _Declare((ImageInfo *)), )   *ReadTILEImage _Declare((ImageInfo *)), )   *ReadUYVYImage _Declare((ImageInfo *)), *   *ReadVICARImage _Declare((ImageInfo *)),(   *ReadVIDImage _Declare((ImageInfo *)),)   *ReadVIFFImage _Declare((ImageInfo *)), (   *ReadXBMImage _Declare((ImageInfo *)),'   *ReadXCImage _Declare((ImageInfo *)), (   *ReadXPMImage _Declare((ImageInfo *)),(   *ReadXWDImage _Declare((ImageInfo *)),(   *ReadYUVImage _Declare((ImageInfo *)),)   *ReadYUV3Image _Declare((ImageInfo *));   
 static int,   XBMInteger _Declare((FILE *,short int *));   static unsigned int .   PNMInteger _Declare((Image *,unsigned int));   static void 8   SGIDecode _Declare((unsigned char *,unsigned char *)),P   Upsample _Declare((unsigned int, unsigned int, unsigned int,unsigned char *));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadAVSImage(image_info)	 ImageInfo    *image_info; {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;   	   Quantum 	     blue, 
     green,     red;     register int     x,     y;     register RunlengthPacket     *q;      unsigned int     packets,     status;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read AVS image.    */J   status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),     image->file);    if (status == False)0     PrematureExit("Not a AVS image file",image);   do   {      /*!       Initialize image structure.      */     image->matte=True;$     image->columns=avs_header.width;"     image->rows=avs_header.height;     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert AVS raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       { (         index=Opaque-fgetc(image->file);(         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;                }              q->red=red;              q->green=green;              q->blue=blue;              q->index=index;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); L     status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),       image->file);      if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadBMPImage(image_info)	 ImageInfo    *image_info; {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      start_position,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */(     start_position=ftell(image->file)-2;D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))2       PrematureExit("Not a BMP image file",image);7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; /         image->colors=bmp_header.number_colors;          if (image->colors == 0) 2           image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image);          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;H         (void) ReadData((char *) bmp_colormap,packet_size,image->colors,           image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 0           image->colormap[i].blue=UpScale(*p++);1           image->colormap[i].green=UpScale(*p++); /           image->colormap[i].red=UpScale(*p++); $           if (bmp_header.size != 12)             p++;	         } $         free((char *) bmp_colormap);       }      /*       Read image data.     */H     while (ftell(image->file) < (start_position+bmp_header.offset_bits))        (void) fgetc(image->file);#     if (bmp_header.image_size == 0)        bmp_header.image_size=L         ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;     bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); M     (void) ReadData((char *) bmp_data,1,(unsigned int) bmp_header.image_size,        image->file);      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=N           ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1;           free((char *) bmp_data);       }      /*!       Initialize image structure.      */$     image->columns=bmp_header.width;"     image->rows=bmp_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);         break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */(         if (bmp_header.compression == 1)(           bytes_per_line=image->columns;*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);         break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);"             q->blue=UpScale(*p++);#             q->green=UpScale(*p++); !             q->red=UpScale(*p++);              q->length=0;             q++;           } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          break;       }        default:4         PrematureExit("Not a BMP image file",image);     }      free((char *) bmp_pixels);     CompressImage(image);      /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadCMYKImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *cmyk_pixels;      unsigned int black, 	     cyan,      height,      magenta,     yellow, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;O   cmyk_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((cmyk_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */E   (void) ReadData((char *) cmyk_pixels,4,image->packets,image->file);    p=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       q=image->pixels;%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);"           ReadQuantum(q->green,p);!           ReadQuantum(q->blue,p); "           ReadQuantum(q->index,p);           q->length=0;           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case LineInterlace:      {        /*K         Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK...        */%       for (y=0; y < image->rows; y++)        { )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);           q->length=0;           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->green,p);           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { !           ReadQuantum(q->blue,p);            q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->index,p);           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          ReadQuantum(q->red,p);         q->length=0;         q++;       } -       ProgressMonitor(LoadImageText,100,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {           ReadQuantum(q->green,p);         q++;       } -       ProgressMonitor(LoadImageText,200,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          ReadQuantum(q->blue,p);          q++;       } -       ProgressMonitor(LoadImageText,300,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {           ReadQuantum(q->index,p);         q++;       } -       ProgressMonitor(LoadImageText,400,400);        break;     }    }    /*%     Transform image from CMYK to RGB.    */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        cyan=q->red;       magenta=q->green;        yellow=q->blue;        black=q->index;         if ((cyan+black) > MaxRGB)         q->red=0; 
       else#         q->red=MaxRGB-(cyan+black); #       if ((magenta+black) > MaxRGB)          q->green=0; 
       else(         q->green=MaxRGB-(magenta+black);"       if ((yellow+black) > MaxRGB)         q->blue=0;
       else&         q->blue=MaxRGB-(yellow+black);       q->index=0;        q->length=0;
       q++;     }    }    free((char *) cmyk_pixels);    CompressImage(image);    CloseImage(image);   return(image); }  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d D P S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % P %  Function ReadDPSImage reads a Adobe Postscript image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadDPSImage routine is:  % % %      image=ReadDPSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadDPSImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasDPS & static Image *ReadDPSImage(image_info)	 ImageInfo    *image_info; {  #include <DPS/dpsXclient.h>  #include <DPS/dpsXpreview.h>  	   Display 
     *display;      float      pixels_per_point;      Image      *image;      int 	     sans,      status,      x,     y;     Pixmap     pixmap;      register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     Screen     *screen;     XColor     *colors;     XImage     *dps_image;      XRectangle     bounding_box,      pixel_size;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     return((Image *) NULL);    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)      return((Image *) NULL);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */*       resource_info.visual_type="default";C       visual_info=XBestVisualInfo(display,map_info,&resource_info); )       map_info->colormap=(Colormap) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*7     Create a pixmap the appropriate size for the image.    */6   screen=ScreenOfDisplay(display,visual_info->screen);.   pixels_per_point=XDPSPixelsPerPoint(screen);+   if (image_info->density != (char *) NULL)      {        float          x_resolution,          y_resolution;   	       int          count;  3       x_resolution=72.0*XDPSPixelsPerPoint(screen); L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;;       pixels_per_point=Min(x_resolution,y_resolution)/72.0;      } F   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,K     visual_info->depth,pixels_per_point,&pixmap,&pixel_size,&bounding_box); L   if ((status == dps_status_failure) || (status == dps_status_no_extension))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*'     Rasterize the file into the pixmap.    */O   status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap,image->file, G     pixel_size.height,visual_info->depth,&bounding_box,-bounding_box.x, <     -bounding_box.y,pixels_per_point,True,False,True,&sans);#   if (status != dps_status_success)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Initialize DPS X image.    */L   dps_image=XGetImage(display,pixmap,0,0,pixel_size.width,pixel_size.height,     AllPlanes,ZPixmap);    XFreePixmap(display,pixmap);#   if (dps_image == (XImage *) NULL)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {        DestroyImage(image);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor)) 2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }    else     {        unsigned long 
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       { +         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit; (         if (red > visual_info->red_mask)           red=0;         green+=green_bit; ,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit; *         if (blue > visual_info->blue_mask)           blue=0;        }      } L   XQueryColors(display,XDefaultColormap(display,visual_info->screen),colors,      visual_info->colormap_size);   /*#     Convert X image to MIFF format.    */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor))      image->class=PseudoClass; "   image->columns=dps_image->width;    image->rows=dps_image->height;,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {        DestroyImage(image);       free((char *) colors);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } )       green_mask=visual_info->green_mask;        green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } '       blue_mask=visual_info->blue_mask;        blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) && .           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        break;     }      case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {            DestroyImage(image);            free((char *) colors);#           XDestroyImage(dps_image); J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { =           p->index=(unsigned short) XGetPixel(dps_image,x,y);            p->length=0;           p++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);        break;     }    } "   if (image->class == PseudoClass)     CompressColormap(image);   free((char *) colors);   XDestroyImage(dps_image);    /*     Rasterize matte image.   */H   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,1,8     pixels_per_point,&pixmap,&pixel_size,&bounding_box);L   if ((status != dps_status_failure) && (status != dps_status_no_extension))     { G       status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap, F         image->file,pixel_size.height,1,&bounding_box,-bounding_box.x,?         -bounding_box.y,pixels_per_point,True,True,True,&sans); '       if (status == dps_status_success) 	         {            XImage             *matte_image;              /*#             Initialize image matte.            */D           matte_image=XGetImage(display,pixmap,0,0,pixel_size.width,1             pixel_size.height,AllPlanes,ZPixmap); &           XFreePixmap(display,pixmap);-           if (matte_image != (XImage *) NULL) 
             { '               image->class=DirectClass;                 image->matte=True;               p=image->pixels;-               for (y=0; y < image->rows; y++) 2                 for (x=0; x < image->columns; x++)                 { "                   p->index=Opaque;2                   if (!XGetPixel(matte_image,x,y)))                     p->index=Transparent;                    p++;                 } )               XDestroyImage(matte_image); 
             } 	         }      }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);    CloseImage(image);   return(image); }  #else & static Image *ReadDPSImage(image_info)	 ImageInfo    *image_info; {    return((Image *) NULL);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadFAXImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=1728;   image->rows=2156; <   image->packets=Max((image->columns*image->rows+8) >> 4,1);#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)5     PrematureExit("Unable to read image data",image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */' static Image *ReadFITSImage(image_info) 	 ImageInfo    *image_info; {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     keyword[MaxTextLength],      value[MaxTextLength];      double
     pixel,
     scale,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      j,     packet_size,     y;     long
     count,     quantum;     register int     c,     i,     x;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      } 
   for ( ; ; )    {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    while (count > 2880)     count-=2880;    for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 3) || 2       (fits_header.columns*fits_header.rows) == 0)4     PrematureExit("image type not supported",image);   /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)/     PrematureExit("Unable to open file",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*5     Convert FITS pixels to runlength-encoded packets.    */B   status=ReadData((char *) fits_pixels,(unsigned int) packet_size,      image->packets,image->file);   if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) *           quantum=(quantum << 8) | (*p++);         pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); >         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   scale=1.0;3   if (fits_header.min_data != fits_header.max_data) A     scale=(MaxRGB+1)/(fits_header.max_data-fits_header.min_data);    p=fits_pixels;   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum));        scaled_pixel=scale* H         (pixel*fits_header.scale+fits_header.zero-fits_header.min_data);       while (scaled_pixel < 0)!         scaled_pixel+=(MaxRGB+1); #       while (scaled_pixel > MaxRGB) !         scaled_pixel-=(MaxRGB+1); -       q->index=(unsigned short) scaled_pixel;        q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) fits_pixels);    SyncImage(image);    CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadGIFImage(image_info)	 ImageInfo    *image_info; { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int      status,      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      c,     *global_colormap,      header[MaxTextLength],     magick[12];      unsigned int     global_colors,     image_count,     local_colormap;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); 4   status|=ReadData((char *) header,1,7,image->file);H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0))) 0     PrematureExit("Not a GIF image file",image);   global_colors=0;)   global_colormap=(unsigned char *) NULL;    if (BitSet(header[4],0x80))      {        /*         Read global colormap.        */0       global_colors=1 << ((header[4] & 0x07)+1);'       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)B         PrematureExit("Unable to read image colormap file",image);L       (void) ReadData((char *) global_colormap,3,global_colors,image->file);     }    transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)@           PrematureExit("Unable to read extention block",image);         switch (c)	         {            case 0xf9:           {              /*+               Transparency extension block.              */C             while (ReadDataBlock((char *) header,image->file) > 0); (             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*&               Comment extension block.             */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL) J                 image->comments=(char *) realloc((char *) image->comments,C                   (strlen(image->comments)+length+1)*sizeof(char));                else                 { K                   image->comments=(char *) malloc((length+1)*sizeof(char)); 7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL) A                 PrematureExit("Unable to allocate memory",image); "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            default:           { C             while (ReadDataBlock((char *) header,image->file) > 0);              break;           } 	         }        }      if (c != ',')        continue;      /*       Read image attributes.     */     if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;5     status=ReadData((char *) header,1,9,image->file);      if (status == False)B       PrematureExit("Unable to read left/top/width/height",image);,     image->interlace=BitSet(header[8],0x40);*     local_colormap=BitSet(header[8],0x80);     /*       Allocate image.      */6     image->columns=LSBFirstOrder(header[4],header[5]);3     image->rows=LSBFirstOrder(header[6],header[7]); .     image->packets=image->columns*image->rows;     if (image->packets == 0)-       PrematureExit("image size is 0",image); 2     if (image->pixels != (RunlengthPacket *) NULL)#       free((char *) image->pixels); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*       Inititialize colormap.     */     image->class=PseudoClass; P     image->colors=!local_colormap ? global_colors : 1 << ((header[8] & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      if (!local_colormap)       { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); G         (void) ReadData((char *) colormap,3,image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }           free((char *) colormap);       }      /*       Decode image.      */!     status=GIFDecodeImage(image);      if (image->interlace)        { 
         Image            *interlaced_image;           int            pass;             register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */,         image_info->interlace=LineInterlace;         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image); #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }       if (transparency_index >= 0)       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }      CompressImage(image);    } 0   if (global_colormap != (unsigned char *) NULL)#     free((char *) global_colormap); 0   if (image->pixels == (RunlengthPacket *) NULL)-     PrematureExit("Corrupt GIF image",image); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadGRAYImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      unsigned int     height,      packets,
     width;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Create linear colormap.    */   image->class=PseudoClass; "   image->colors=1 << QuantumDepth;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)    { '     image->colormap[i].red=(Quantum) i; )     image->colormap[i].green=(Quantum) i; (     image->colormap[i].blue=(Quantum) i;   }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->columns=width;    image->rows=height;    image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        ReadQuantumFile(index); B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)A                 PrematureExit("Unable to allocate memory",image); /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    SyncImage(image);    CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H D F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadHDFImage reads a Hierarchical Data Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadHDFImage routine is:  % % %      image=ReadHDFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadHDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasHDF & static Image *ReadHDFImage(image_info)	 ImageInfo    *image_info; {  #include "hdf.h"     Image      *image;      int      interlace,     is_palette,      status,      y;     int32      height,      length, 
     width;     register int     i,     x;     register unsigned char     *p;      register RunlengthPacket     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int
     class,     packet_size;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*     Read HDF image.    */   class=DirectClass;@   status=DF24getdims(image->filename,&width,&height,&interlace);   if (status == -1)      {        class=PseudoClass;E       status=DFR8getdims(image->filename,&width,&height,&is_palette);      }    if (status == -1) I     PrematureExit("Image file or does not contain any image data",image);    do   {      /*!       Initialize image structure.      */     image->class=class;      image->columns=width;      image->rows=height; .     image->packets=image->columns*image->rows;     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)?       malloc(packet_size*image->packets*sizeof(unsigned char)); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((hdf_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;$     if (image->class == PseudoClass)       {          unsigned char            *hdf_palette;   
         /*           Create colormap.
         */H         hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));         image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));6         if ((hdf_palette == (unsigned char *) NULL) ||6             (image->colormap == (ColorPacket *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) DFR8getimage(image->filename,hdf_pixels,(int) image->columns,)           (int) image->rows,hdf_palette);           reference=DFR8lastref();
         /*L           Convert HDF raster image to PseudoClass runlength-encoded packets.
         */         p=hdf_palette;         if (is_palette) !           for (i=0; i < 256; i++)            { 1             image->colormap[i].red=UpScale(*p++); 3             image->colormap[i].green=UpScale(*p++); 2             image->colormap[i].blue=UpScale(*p++);           }          else+           for (i=0; i < image->colors; i++)            { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);            } #         free((char *) hdf_palette);          p=hdf_pixels; '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          SyncImage(image);        }      else       {          int            x,           y;  
         /*L           Convert HDF raster image to DirectClass runlength-encoded packets.
         */O         (void) DF24getimage(image->filename,(void *) hdf_pixels,image->columns,            image->rows);           reference=DF24lastref();         p=hdf_pixels; *         image_info->interlace=interlace+1;&         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */             q=image->pixels;+             for (y=0; y < image->rows; y++) 
             { 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++); '                 q->green=UpScale(*p++); &                 q->blue=UpScale(*p++);                 q->index=0;                  q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }              break;           }            case LineInterlace:            {              /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */+             for (y=0; y < image->rows; y++) 
             { /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++);                  q->index=0;                  q->length=0;                 q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { '                 q->green=UpScale(*p++);                  q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { &                 q->blue=UpScale(*p++);                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */3             ProgressMonitor(LoadImageText,100,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { #               q->red=UpScale(*p++);                q->index=0;                q->length=0;               q++;
             } 3             ProgressMonitor(LoadImageText,200,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { %               q->green=UpScale(*p++);                q++;
             } 3             ProgressMonitor(LoadImageText,300,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { $               q->blue=UpScale(*p++);               q++;
             } 3             ProgressMonitor(LoadImageText,400,400);              break;           } 	         }        } >     length=DFANgetlablen(image->filename,DFTAG_RIG,reference);     if (length > 0)        { 
         /*           Read the image label. 
         */         length+=MaxTextLength;1         image->label=malloc(length*sizeof(char)); *         if (image->label != (char *) NULL)P           DFANgetlabel(image->filename,DFTAG_RIG,reference,image->label,length);       } ?     length=DFANgetdesclen(image->filename,DFTAG_RIG,reference);      if (length > 0)        { 
         /*"           Read the image comments.
         */         length+=MaxTextLength;4         image->comments=malloc(length*sizeof(char));-         if (image->comments != (char *) NULL) J           DFANgetdesc(image->filename,DFTAG_RIG,reference,image->comments,             length);       }      free((char *) hdf_pixels);     CompressImage(image);      class=DirectClass;B     status=DF24getdims(image->filename,&width,&height,&interlace);     if (status == -1)        {          class=PseudoClass;G         status=DFR8getdims(image->filename,&width,&height,&is_palette);        }      if (status != -1)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status != -1); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else & static Image *ReadHDFImage(image_info)	 ImageInfo    *image_info; { ?   Warning("HDF library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */, static Image *ReadHISTOGRAMImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   "   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H T M L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadHTMLImage reads a HTML image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadHTMLImage routine is: % & %      image=ReadHTMLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadHTMLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadHTMLImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;   :   Warning("Cannot read HTML images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    #ifdef HasJBIG #include "jbig.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J B I G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadJBIGImage reads a JBIG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadJBIGImage routine is: % & %      image=ReadJBIGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJBIGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadJBIGImage(image_info) 	 ImageInfo    *image_info; {  #define MaxBufferSize  8192      Image      *image;      int      length,      status,      x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      register unsigned short 
     index;     size_t
     count;     struct jbg_dec_state     jbig_info;     unsigned char      bit,     buffer[MaxBufferSize];     unsigned int	     byte,      height,      packets,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*5     Determine maximum width and height, e.g. 640x512.    */   width=65535L;    height=65535L;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read JBIG file.    */   jbg_dec_init(&jbig_info); K   jbg_dec_maxsize(&jbig_info,(unsigned long) width,(unsigned long) height);    status=JBG_EAGAIN;   do   { 5     length=fread(buffer,1,MaxBufferSize,image->file);      if (length == 0)       break;
     p=buffer;      count=0;K     while ((length > 0) && ((status == JBG_EAGAIN) || (status == JBG_EOK)))      { 4       status=jbg_dec_in(&jbig_info,p,length,&count);       p+=count;        length-=count;     } :   } while ((status == JBG_EAGAIN) || (status == JBG_EOK));   /*     Initialize image structure.    */.   image->columns=jbg_dec_getwidth(&jbig_info);,   image->rows=jbg_dec_getheight(&jbig_info);   image->packets=0; 5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*8     Convert X bitmap image to runlength-encoded packets.   */#   p=jbg_dec_getimage(&jbig_info,0);    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 
     bit=0;&     for (x=0; x < image->columns; x++)     {        if (bit == 0)          byte=(*p++);"       index=(byte & 0x80) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;O               image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 1                 packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)                 { +                   jbg_dec_free(&jbig_info); C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        bit++;       byte<<=1;        if (bit == 8)          bit=0;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    jbg_dec_free(&jbig_info);    SyncImage(image); #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    CloseImage(image);   return(image); }  #else ' static Image *ReadJBIGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("JBIG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   #ifdef HasJPEG #include <setjmp.h>  #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */
 static int.   CommentHandler _Declare((j_decompress_ptr));   static unsigned int ,   GetCharacter _Declare((j_decompress_ptr));   static void +   EmitMessage _Declare((j_common_ptr,int));   + static unsigned int GetCharacter(jpeg_info)  j_decompress_ptr   jpeg_info; {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   $ static int CommentHandler(jpeg_info) j_decompress_ptr   jpeg_info; { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (strlen(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+strlen(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }     static void ErrorExit(jpeg_info) j_common_ptr   jpeg_info; {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; {    int      y;  	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];  	   Quantum 	     blue, 
     green,     red;     register int     i,     x;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    jpeg_pixels=(JSAMPLE *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       if (jpeg_pixels != (JSAMPLE *) NULL)	         { %           free((char *) jpeg_pixels); .           jpeg_destroy_decompress(&jpeg_info);	         }        DestroyImage(image);       return((Image *) NULL);      } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True); (   if (image_info->size != (char *) NULL)     {        unsigned int         height,          width;         unsigned long          scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; #       width=jpeg_info.output_width; %       height=jpeg_info.output_height; :       ParseImageGeometry(image_info->size,&width,&height);       if (width == 0)          width=1;9       scale_factor=UpShift(jpeg_info.output_width)/width;        if (height == 0)         height=1; C       if (scale_factor > (UpShift(jpeg_info.output_height)/height)) =         scale_factor=UpShift(jpeg_info.output_height)/height; 4       jpeg_info.scale_denom=DownShift(scale_factor);.       jpeg_calc_output_dimensions(&jpeg_info);     }  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;   image->packets=0; 5   packets=Max((image->columns*image->rows+2) >> 2,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   jpeg_pixels=(JSAMPLE *) G     malloc(jpeg_info.output_components*image->columns*sizeof(JSAMPLE)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||(       (jpeg_pixels == (JSAMPLE *) NULL))5     PrematureExit("Unable to allocate memory",image); 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        { *         image->colormap[i].red=UpScale(i);,         image->colormap[i].green=UpScale(i);+         image->colormap[i].blue=UpScale(i);        }      }    /*5     Convert JPEG pixels to runlength-encoded packets.    */   red=0;
   green=0;	   blue=0; 
   index=0;%   scanline[0]=(JSAMPROW) jpeg_pixels;    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 6     (void) jpeg_read_scanlines(&jpeg_info,scanline,1);     p=jpeg_pixels;&     for (x=0; x < image->columns; x++)     { 2       if (jpeg_info.data_precision > QuantumDepth)	         { 9           if (jpeg_info.out_color_space == JCS_GRAYSCALE) (             index=GETJSAMPLE(*p++) >> 4;           else
             { 4               red=(Quantum) (GETJSAMPLE(*p++) >> 4);6               green=(Quantum) (GETJSAMPLE(*p++) >> 4);5               blue=(Quantum) (GETJSAMPLE(*p++) >> 4); 8               if (jpeg_info.out_color_space == JCS_CMYK)8                 index=(Quantum) (GETJSAMPLE(*p++) >> 4);
             } 
          }        else 8          if (jpeg_info.out_color_space == JCS_GRAYSCALE)"            index=GETJSAMPLE(*p++);
          else             {5              red=(Quantum) UpScale(GETJSAMPLE(*p++)); 7              green=(Quantum) UpScale(GETJSAMPLE(*p++)); 6              blue=(Quantum) UpScale(GETJSAMPLE(*p++));7              if (jpeg_info.out_color_space == JCS_CMYK) 9                index=(Quantum) UpScale(GETJSAMPLE(*p++));             }0       if (jpeg_info.out_color_space == JCS_CMYK)	         { !           index=MAXJSAMPLE-index; $           if ((int) (red-index) < 0)             red=0;           else             red-=index; &           if ((int) (green-index) < 0)             green=0;           else             green-=index; %           if ((int) (blue-index) < 0)              blue=0;            else             blue-=index;           index=0;	         } H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)                 { -                   free((char *) jpeg_pixels); 6                   jpeg_destroy_decompress(&jpeg_info);C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); "   if (image->class == PseudoClass)     {        SyncImage(image);        CompressColormap(image);     }    /*     Free memory.   */   free((char *) jpeg_pixels); ,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d L O G O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadLOGOImage reads a LOGO image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLOGOImage routine is: % & %      image=ReadLOGOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadLOGOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadLOGOImage(image_info) 	 ImageInfo    *image_info; {  #include "logo.h"      char     *filename,!     logo_filename[MaxTextLength];      FILE
     *file;     Image      *image;      register int     i;     register unsigned char     *p;      /*     Open temporary output file.    */#   TemporaryFilename(logo_filename);     file=fopen(logo_filename,"w");   if (file == (FILE *) NULL)     { 4       Warning("Unable to write file",logo_filename);&       return(ReadXCImage(image_info));     }    p=LogoImage;%   for (i=0; i < LogoImageLength; i++)    { !     (void) fputc((char) *p,file);      p++;   }    if (ferror(file))      { E       Warning("An error has occurred writing to file",logo_filename);        (void) fclose(file);#       (void) unlink(logo_filename); &       return(ReadXCImage(image_info));     }    (void) fclose(file);    filename=image_info->filename;%   image_info->filename=logo_filename; "   image=ReadMIFFImage(image_info);    image_info->filename=filename;   if (image != (Image *) NULL)8     (void) strcpy(image->filename,image_info->filename);   (void) unlink(logo_filename);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMAPImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;$   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *);     malloc(image->packets*packet_size*(image->depth >> 3)); -   if ((colormap == (unsigned char *) NULL) || 0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Read image colormap.   */M   (void) ReadData((char *) colormap,1,image->colors*packet_size,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { *     ReadQuantum(image->colormap[i].red,p);,     ReadQuantum(image->colormap[i].green,p);+     ReadQuantum(image->colormap[i].blue,p);    }    free((char *) colormap);   /*6     Convert raster image to runlength-encoded packets.   */   packet_size=1;   if (image->colors > 256)     packet_size++;5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);(   image->packed_pixels=(unsigned char *)'     malloc(image->packets*packet_size); 5   if (image->packed_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); K   (void) ReadData((char *) image->packed_pixels,packet_size,image->packets,      image->file); %   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */( static Image *ReadMATTEImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *matte_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->matte=True;   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;N   matte_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 1   if ((matte_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */F   (void) ReadData((char *) matte_pixels,1,image->packets,image->file);   p=matte_pixels;    q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        index=(*p++);        q->red=0;        q->green=0;        q->blue=0;&       q->index=(unsigned short) index;       q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) matte_pixels);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasPNG  #include "zlib.h"  #endif  ' static Image *ReadMIFFImage(image_info) 	 ImageInfo    *image_info; {    char     keyword[MaxTextLength],      value[MaxTextLength];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    image->depth=8;    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=strlen(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextLength; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+strlen(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) =             PrematureExit("Unable to allocate memory",image);            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;-             while (!isspace(c) && (c != EOF)) 
             { 0               if ((p-value) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); 
             }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) ,               if (strcmp(value,"Zlib") == 0)3                 image->compression=ZlibCompression;                else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);-             if (strcmp(keyword,"depth") == 0) 5               image->depth=atoi(value) <= 8 ? 8 : 16; -             if (strcmp(keyword,"gamma") == 0) '               image->gamma=atof(value); *             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(strlen(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((strlen(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0)) <       PrematureExit("Incorrect image header in file",image);(     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextLength*sizeof(char)); .         if (image->directory == (char *) NULL);           PrematureExit("Unable to read image data",image);          p=image->directory; 
         do	         {            *p='\0';H           if ((((int) strlen(image->directory)+1) % MaxTextLength) == 0)
             {                /*=                 Allocate more memory for the image directory.                */J               image->directory=(char *) realloc((char *) image->directory,I                 (strlen(image->directory)+MaxTextLength+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)A                 PrematureExit("Unable to read image data",image); :               p=image->directory+strlen(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;          } while (c != '\0');       } $     if (image->class == PseudoClass)       {          unsigned int           colors;            unsigned short           value;  
         /*3           PseudoClass image cannot have matte data. 
         */         if (image->matte) B           PrematureExit("Matte images must be DirectClass",image);
         /*            Create image colormap.
         */         colors=image->colors;          if (colors == 0)           colors=256; K         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket)); 4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          if (image->colors == 0) $           for (i=0; i < colors; i++)           { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);              image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */.             packet_size=3*(image->depth >> 3);&             colormap=(unsigned char *)F               malloc(packet_size*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image); J             (void) ReadData((char *) colormap,1,packet_size*image->colors,               image->file);              p=colormap; -             for (i=0; i < image->colors; i++) 
             { 4               ReadQuantum(image->colormap[i].red,p);6               ReadQuantum(image->colormap[i].green,p);5               ReadQuantum(image->colormap[i].blue,p); 
             } $             free((char *) colormap);           }        }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {          image->packet_size=1;           if (image->colors > 256)           image->packet_size++;        }      else       { 1         image->packet_size=3*(image->depth >> 3);          if (image->matte)            image->packet_size++;        } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++; #     packet_size=image->packet_size; .     if (image->compression == ZlibCompression)       packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char)); 7     if (image->packed_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))D       (void) ReadData((char *) image->packed_pixels,1,(unsigned int))         packets*packet_size,image->file);      else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels; 
         do	         { @           (void) ReadData((char *) p,1,packet_size,image->file);           image->packets++;            p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } /     if (image->compression ==  ZlibCompression)        {          int            status;            unsigned char            *compressed_pixels;   
         /*5           Uncompress image pixels with Zlib encoding. 
         */2         image->packets=image->columns*image->rows;/         compressed_pixels=image->packed_pixels; 2         packets=image->packets*image->packet_size;.         image->packed_pixels=(unsigned char *)0           malloc(packets*sizeof(unsigned char));;         if (image->packed_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          status=True;
 #ifdef HasPNG J         status=uncompress(image->packed_pixels,&packets,compressed_pixels,           image->packets); #endif)         free((char *) compressed_pixels);          if (status) A           PrematureExit("Unable to Zlib uncompress image",image);        }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */     do     {        c=fgetc(image->file); (     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #ifdef HasMPEG #undef BitmapPad #include "mpeg.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMPEGImage reads a MPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      ImageDesc      mpeg_info;     int      y;     register int     i,     x;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *mpeg_pixels;      unsigned int     number_frames,     status;      unsigned long      lsb_first;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);C   number_frames=8*image->filesize/mpeg_info.Width/mpeg_info.Height; M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char)); ,   if (mpeg_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)      {         image->scene++;1        status=GetMPEGFrame((char *) mpeg_pixels);         if (status == False)           break; A        ProgressMonitor(LoadImageText,image->scene,number_frames);      }    if (status == False)     { !       free((char *) mpeg_pixels); 0       PrematureExit("Corrupt MPEG image",image);     }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;     lsb_first=1;     if (*(char *) &lsb_first) %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {            q->red=UpScale(*p++); !           q->green=UpScale(*p++);             q->blue=UpScale(*p++);           q->length=0;           p++;           q++;	         }        }      else%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {            p++;            q->blue=UpScale(*p++);!           q->green=UpScale(*p++);            q->red=UpScale(*p++);            q->length=0;           q++;	         }        }      if (image_info->verbose)(       DescribeImage(image,stderr,False);     CompressImage(image); "     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;.     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } =     if ((status == False) || (image->scene == number_frames)) #       number_frames=image->scene+1; >     ProgressMonitor(LoadImageText,image->scene,number_frames);   }    free((char *) mpeg_pixels); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #else ' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M T V I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadMTVImage routine is:  % % %      image=ReadMTVImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMTVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMTVImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int 
     count,     y;  	   Quantum 	     blue, 
     green,     red;     register int     x;     register RunlengthPacket     *q;      unsigned int     columns,     packets,	     rows;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read MTV image.    */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);    if (count == 0) 0     PrematureExit("Not a MTV image file",image);   do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows;      image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert MTV raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       { (         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&-             ((int) q->length < MaxRunlength))            q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;                }              q->red=red;              q->green=green;E             q->blue=blue;E             q->index=0;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      }E%     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));      /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);      if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }t   } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %.O %                                                                             % O %  R e a d N U L L I m a g e                                                  %eO %                                                                             %nO %                                                                             %eO %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %tE %  Function ReadNULLImage reads a NULL image file and returns it.  ItyK %  allocates the memory necessary for the new Image structure and returns ab %  pointer to the new image. %c. %  The format of the ReadNULLImage routine is: %.& %      image=ReadNULLImage(image_info) %s+ %  A description of each parameter follows:i %oJ %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.c %m %l */' static Image *ReadNULLImage(image_info)w	 ImageInfoi   *image_info; {a   Imagem     *image;y  :   Warning("Cannot read NULL images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }i r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %eO %                                                                             % O %                                                                             % O %  R e a d P C D I m a g e                                                    %%O %                                                                             %nO %                                                                             %/O %                                                                             %"O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a F %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. %I- %  The format of the ReadPCDImage routine is:m % % %      image=ReadPCDImage(image_info)g %D+ %  A description of each parameter follows:l %(I %    o image:  Function ReadPCDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.R %GA %    o image_info: Specifies a pointer to an ImageInfo structure.I %  %, */  6 static void Upsample(width,height,scaled_width,pixels) unsigned int   width,	   height,R   scaled_width;l  
 unsigned char)
   *pixels; {I   register int     x,     y;     register unsigned char     *p,*     *q,R     *r;g     /*L     Create a new image that is a integral size greater than an existing one.   */   for (y=0; y < height; y++)   {I1     p=pixels+(height-1-y)*scaled_width+(width-1);c?     q=pixels+((height-1-y) << 1)*scaled_width+((width-1) << 1);      *q=(*p);     *(q+1)=(*(p));     for (x=1; x < width; x++)e     {I
       p--;       q-=2;        *q=(*p);0       *(q+1)=(((int) *p)+((int) *(p+1))+1) >> 1;     }R   }G    for (y=0; y < (height-1); y++)   {P#     p=pixels+(y << 1)*scaled_width;R     q=p+scaled_width;a     r=q+scaled_width;D!     for (x=0; x < (width-1); x++)      {a(       *q=(((int) *p)+((int) *r)+1) >> 1;J       *(q+1)=(((int) *p)+((int) *(p+2))+((int) *r)+((int) *(r+2))+2) >> 2;       q+=2;m       p+=2;(       r+=2;,     }a,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;   }_%   p=pixels+(2*height-2)*scaled_width;a%   q=pixels+(2*height-1)*scaled_width;V   for (x=0; x < width; x++))   {      *q++=(*p++);     *q++=(*p++);   }  }R  ; static Image *OverviewImage(image_info,image,number_images)(	 ImageInfo*   *image_info;   Imagec	   *image;I   unsigned int   number_images; {a #define ClientName  "montage"D     char     *resource_value;  	   Displaya
     *display;)     ImageY
     **images;e     register int     i,     j;     XMontageInfo     montage_info;i     XResourceInfoe     resource_info;  
   XrmDatabasec     resource_database;     /*     Allocate images array.   */:   images=(Image **) malloc(number_images*sizeof(Image *));    if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);*       return((Image *) NULL);%     }%   /*     Open X server connection.%   */7   resource_info.background_color=DefaultTileBackground; *   resource_info.border_color=BorderColor;;:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground; &   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry; -   resource_info.matte_color=DefaultTileMatte; $   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {        /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);%       /*3         Get user defaults from X resource database.        */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground); D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground);iJ       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);R     }h   /*/     Read each image and convert them to a tile.t   */   j=0;#   for (i=0; i < number_images; i++)    {a     LabelImage(image,"%f"); F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)(       DescribeImage(image,stderr,False);     images[j]=image;     image=image->next;     j++;   }*   /*"     Create the PCD Overview image.   */!   XGetMontageInfo(&montage_info);e   montage_info.number_tiles=j;%   if (montage_info.number_tiles != 0)f
     image=N       XMontageImage(images,&resource_info,&montage_info,image_info->filename);   free((char *) images);   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);-   CompressImage(image);;   return(image); }_  & static Image *ReadPCDImage(image_info)	 ImageInfoa   *image_info; {m   Image+     *image;   
   long int     offset;h     register int     i;     register RunlengthPacket     *p;-     register unsigned char     *c1,     *c2,     *y;(     unsigned char 
     *chroma1, 
     *chroma2,      *header,
     *luma;     unsigned int     height,      number_images,
     overview,l     rotate,e     status,o
     subimage,g
     width;     /*     Allocate image structure.c   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);>#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char)); '   if (header == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); 9   status=ReadData((char *) header,1,3*0x800,image->file); 5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;=   if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview))k0     PrematureExit("Not a PCD image file",image);   rotate=header[0x0e02] & 0x03; /   number_images=(header[10] << 8) | header[11];m   free((char *) header);
   subimage=3;m    if (image_info->subimage != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     { 	       int 
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512; C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);i1       for (subimage=1; subimage <= 6; subimage++)        {a.         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;e       }      }    if (overview)      subimage=1;r   /*     Initialize image structure.x   */   width=192;
   height=128; %   for (i=1; i < Min(subimage,3); i++)    {      width<<=1;     height<<=1;m   }    image->columns=width;g   image->rows=height;    for ( ; i < subimage; i++)   {x     image->columns<<=1;i     image->rows<<=1;   }x   /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;M   chroma1=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));hM   chroma2=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));aJ   luma=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Advance to image data.   */   offset=93;   if (overview) 
     offset=2;    else     if (subimage == 2)       offset=20;     else       if (subimage == 1)         offset=1; $   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)      {        Image          *overview_image;         register int
         j;         /*,         Read thumbnails from overview image.       */(       for (j=1; j <= number_images; j++)       {%8         (void) sprintf(image->filename,"img%04d.pcd",j);         image->scene=j;t         image->columns=width;          image->rows=height;t2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) 9           malloc(image->packets*sizeof(RunlengthPacket)); 6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image);M         y=luma;p         c1=chroma1;f         c2=chroma2; #         for (i=0; i < height; i+=2) 	         {s:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns;;@           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns; 	         }tN         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;          c1=chroma1;i         c2=chroma2; *         for (i=0; i < image->packets; i++)	         {            p->red=UpScale(*y++); "           p->green=UpScale(*c1++);!           p->blue=UpScale(*c2++);i           p->index=0;i           p->length=0;           p++;	         } /         TransformRGBImage(image,YCCColorspace);          CompressImage(image);g          if (image_info->verbose),           DescribeImage(image,stderr,False);         if (j < number_images)           {n             /*'               Allocate image structure.              */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               {)%                 DestroyImages(image); '                 return((Image *) NULL);                }i*             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           }a9         ProgressMonitor(LoadImageText,j-1,number_images);(       }l       free(chroma2);       free(chroma1);       free(luma);;/       while (image->previous != (Image *) NULL)a         image=image->previous;       CloseImage(image);C       overview_image=OverviewImage(image_info,image,number_images);        return(overview_image);      }    /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *)h3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);t   /*     Read interleaved image.m   */	   y=luma;t
   c1=chroma1;o
   c2=chroma2;;   for (i=0; i < height; i+=2)o   { 4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns;_:     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;h   }m   if (subimage >= 4)     {d       /*5         Recover luminance deltas for 1536x1024 image.c       */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1); /       Upsample(384,256,image->columns,chroma2);e       image->rows=1024;d#       for (i=0; i < (4*0x800); i++)i"         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {            /*9             Recover luminance deltas for 3072x2048 image.c           */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1);;3           Upsample(768,512,image->columns,chroma2);            image->rows=2048;r-           offset=ftell(image->file)/0x800+12;a3           (void) fseek(image->file,offset*0x800,0);m<           status=PCDDecodeImage(image,luma,chroma1,chroma2);(           if ((subimage >= 6) && status)
             {r               /*I                 Recover luminance deltas for 6144x4096 image (vaporware).m               */6               Upsample(3072,2048,image->columns,luma);9               Upsample(1536,1024,image->columns,chroma1); 9               Upsample(1536,1024,image->columns,chroma2);                image->rows=4096;o
             }y	         }      } H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma;i
   c1=chroma1; 
   c2=chroma2;g$   for (i=0; i < image->packets; i++)   {      p->red=UpScale(*y++);U     p->green=UpScale(*c1++);     p->blue=UpScale(*c2++);+     p->index=0;f     p->length=0;     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(LoadImageText,i,image->packets);   }d   free(chroma2);   free(chroma1);
   free(luma); )   TransformRGBImage(image,YCCColorspace); %   if ((rotate == 1) || (rotate == 3))f     {e       double         degrees;         Images         *rotated_image;r         /*         Rotate image.*       */)       degrees=rotate == 1 ? -90.0 : 90.0;        image->orphan=True;gO       rotated_image=RotateImage(image,degrees,(ColorPacket *) NULL,False,True);        image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {b           DestroyImage(image);           image=rotated_image;	         }      }e   CompressImage(image);_   CloseImage(image);   return(image); }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %.O %                                                                             % O %                                                                             %fO %  R e a d P C X I m a g e                                                    % O %                                                                             %(O %                                                                             %nO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%h %*M %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %w- %  The format of the ReadPCXImage routine is:  %a% %      image=ReadPCXImage(image_info)k %)+ %  A description of each parameter follows:  %NI %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.t %uA %    o image_info: Specifies a pointer to an ImageInfo structure.a %1 %  */& static Image *ReadPCXImage(image_info)	 ImageInfo    *image_info; {d   typedef struct _PCXHeader    {      unsigned chars       identifier,        version,       encoding,(       bits_per_pixel;p  
     short int        left,x
       top,       right,
       bottom,x       horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int(       bytes_per_line,0       palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;f     Imageo     *image;      int 
     count,     packets;     register int     i,     x,     y;     register RunlengthPacket     *q;-     register unsigned char     *p;      unsigned char      packet,=     *pcx_colormap,     *pcx_pixels;     unsigned int     status;      /*     Allocate image structure.d   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);)   /*$     Determine if this is a PCX file.   */C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);    do   {o     /*       Verify PCX identifier.     */=     if ((status == False) || (pcx_header.identifier != 0x0a))l2       PrematureExit("Not a PCX image file",image);B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file); I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file); 3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file); D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.      */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;m     image->class=PseudoClass;      image->colors=16;lD     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); 4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL)) 7       PrematureExit("Unable to allocate memory",image);iG     (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);      p=pcx_colormap;t%     for (i=0; i < image->colors; i++)o     {t+       image->colormap[i].red=UpScale(*p++); -       image->colormap[i].green=UpScale(*p++);s,       image->colormap[i].blue=UpScale(*p++);     }-C     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file); A     (void) ReadData((char *) &pcx_header.planes,1,1,image->file);a=     pcx_header.bytes_per_line=LSBFirstReadShort(image->file); ;     pcx_header.palette_info=LSBFirstReadShort(image->file);)     for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */D     packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;G     pcx_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); -     if (pcx_pixels == (unsigned char *) NULL)m7       PrematureExit("Unable to allocate memory",image);/     /*       Uncompress image data.     */     p=pcx_pixels;(     while (packets > 0)c     {r        packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {u           *p++=packet;           packets--;           continue; 	         }m       count=packet & 0x3f;9       for (packet=fgetc(image->file); count > 0; count--)        {n         *p++=packet;         packets--;         if (packets == 0)f           break;       }e     } E     image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes);c     if (image->colors > 256)>       PrematureExit("PCX colormap exceeded 256 colors",image);     if (image->colors > 16)(       {m
         /*G           256 color images have their color map at the end of the file.-
         */D         (void) ReadData((char *) &pcx_header.colormap_signature,1,1,           image->file);%K         (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);          p=pcx_colormap; )         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }        }      else       if (image->colors == 2) K         if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))            {              /*"               Monochrome colormap.             */*             image->colormap[0].red=MaxRGB;,             image->colormap[0].green=MaxRGB;+             image->colormap[0].blue=MaxRGB;%%             image->colormap[1].red=0;e'             image->colormap[1].green=0;a&             image->colormap[1].blue=0;           }t      free((char *) pcx_colormap);     /*<       Convert PCX raster image to runlength-encoded packets.     */     if (pcx_header.planes > 1)       {i         register int           bits,e           mask;d  
         /*%           Initialize image structure.a
         */2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) J           malloc((image->packets+image->columns)*sizeof(RunlengthPacket));6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image);n
         /*C           Convert multi-plane format into runlength-encoded pixels. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         {            q->index=0;i           q->length=0;           q++;	         }a'         for (y=0; y < image->rows; y++)t	         {lG           p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes);a5           for (i=0; i < (int) pcx_header.planes; i++);           { -             q=image->pixels+y*image->columns; 9             for (x=0; x < pcx_header.bytes_per_line; x++)i
             {T               bits=(*p++);2               for (mask=0x80; mask != 0; mask>>=1)               {                   if (bits & mask)#                   q->index|=1 << i;                  q++;               }o
             }            } 7           ProgressMonitor(LoadImageText,y,image->rows);h	         }          SyncImage(image);i          CompressColormap(image);         CompressImage(image);        }g     else       {          register unsigned char
           *r;>           unsigned charm           *scanline;           unsigned short           index;  
         /*%           Initialize image structure. 
         */         image->packets=0;a;         packets=Max((image->columns*image->rows+4) >> 3,1); +         if (pcx_header.bits_per_pixel == 1)L=           packets=Max((image->columns*image->rows+8) >> 4,1);*)         image->pixels=(RunlengthPacket *)o2           malloc(packets*sizeof(RunlengthPacket));"         scanline=(unsigned char *)7           malloc(image->columns*sizeof(unsigned char)); :         if ((image->pixels == (RunlengthPacket *) NULL) ||1             (scanline == (unsigned char *) NULL)).;           PrematureExit("Unable to allocate memory",image);g         q=image->pixels;         q->length=MaxRunlength;m'         for (y=0; y < image->rows; y++)u	         {;3           p=pcx_pixels+y*pcx_header.bytes_per_line;u           r=scanline; ,           switch (pcx_header.bits_per_pixel)           {              case 1: 
             {e               register int                 bit;  5               for (x=0; x < (image->columns-7); x+=8)                { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }p,               if ((image->columns % 8) != 0)                 {+E                   for (bit=7; bit >= (8-(image->columns % 8)); bit--);>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }m               break;
             }u             case 2: 
             { 5               for (x=0; x < (image->columns-3); x+=4)                { %                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;x                  *r++=(*p) & 0x3;                 p++;               } ,               if ((image->columns % 4) != 0)                 { ?                   for (i=3; i >= (4-(image->columns % 4)); i--) .                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }c               break;
             }K             case 4: 
             {;5               for (x=0; x < (image->columns-1); x+=2)                {(%                 *r++=(*p >> 4) & 0xf;                   *r++=(*p) & 0xf;                 p++;               }=,               if ((image->columns % 2) != 0)'                 *r++=(*p++ >> 4) & 0xf;(               break;
             }              case 8:(
             {00               for (x=0; x < image->columns; x++)                 *r++=(*p++);               break;
             }              default:               break;           }T           /*$             Transfer image scanline.           */           r=scanline; ,           for (x=0; x < image->columns; x++)           {              index=(*r++);mH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {m(                 if (image->packets != 0)                   q++;!                 image->packets++;e.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       { 0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);r                       }p5                     q=image->pixels+image->packets-1;e                   }%                 q->index=index;%                 q->length=0;               }            } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);I         image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 2           image->packets*sizeof(RunlengthPacket));          free((char *) scanline);       }      free((char *) pcx_pixels);     /*       Proceed to next image.     */E     status=ReadData((char *) &pcx_header.identifier,1,1,image->file); <     if ((status == True) && (pcx_header.identifier == 0x0a))       { 
         /*#           Allocate image structure.%
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {i!             DestroyImages(image);s#             return((Image *) NULL);g           }nB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }a@   } while ((status == True) && (pcx_header.identifier == 0x0a));+   while (image->previous != (Image *) NULL)t     image=image->previous;   CloseImage(image);   return(image); }e i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %hO %                                                                             %iO %                                                                             % O %  R e a d P D F I m a g e                                                    %nO %                                                                             %sO %                                                                             % O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%V %aH %  Function ReadPDFImage reads a Portable Document Format image file andM %  returns it.  It allocates the memory necessary for the new Image structureN* %  and returns a pointer to the new image. %e- %  The format of the ReadPDFImage routine is:o %n% %      image=ReadPDFImage(image_info)e %r+ %  A description of each parameter follows:n %;I %    o image:  Function ReadPDFImage returns a pointer to the image afterpL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.u %(A %    o image_info: Specifies a pointer to an ImageInfo structure.a %  %  */& static Image *ReadPDFImage(image_info)	 ImageInfoi   *image_info; {e #define MediaBox  "/MediaBox ["n     char     command[MaxTextLength],o     *device,     filename[MaxTextLength],     options[MaxTextLength],f'     postscript_filename[MaxTextLength];      FILE
     *file;     floatt     dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,/     y_resolution;f     Imagep     *image,      *next_image;     inta
     count,     status,e     x,     y;  
   long int
     filesize;o     register char      *p;m     register int     c,     i;     unsigned int     height, 
     width;     /*     Allocate image structure.i   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)p/     PrematureExit("Unable to open file",image);O   /*     Open temporary output file.    */)   TemporaryFilename(postscript_filename); &   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);   /*     Set the page geometry.   */   *options='\0';(   if (image_info->page != (char *) NULL)     {f#       (void) strcat(options," -g");e.       (void) strcat(options,image_info->page);     }n   else     for (p=command; ; )p     {n       c=fgetc(image->file);2       if (c == EOF)s         break;       (void) fputc(c,file);r
       *p++=c;,J       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextLength-1)))         continue;=       *p='\0';       p=command;       /*5         Continue unless this is a MediaBox statement.        */:       if (strncmp(MediaBox,command,strlen(MediaBox)) != 0)         continue;tG       count=sscanf(command,"/MediaBox [ %f %f %f %f",&lower_x,&lower_y,L         &upper_x,&upper_y);r       if (count != 4)i         continue;t5       if ((lower_x > upper_x) || (lower_y > upper_y))i         continue;        /*         Determine bounding box.o       */       dx_resolution=72.0;u       dy_resolution=72.0;t       x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL)XN         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2)m"         y_resolution=x_resolution;,       if (image_info->page != (char *) NULL)         continue;p       /*'         Set Postscript render geometry.a       */       width=upper_x-lower_x;-       if ((float) ((int) upper_x) != upper_x)          width++;       height=upper_y-lower_y;u-       if ((float) ((int) upper_y) != upper_y))         height++;o'       (void) sprintf(options,"-g%ux%u",nB         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }o
   for ( ; ; )o   {=     c=fgetc(image->file);      if (c == EOF)i       break;     (void) fputc(c,file);    }    if (ferror(file))y     {_K       Warning("An error has occurred writing to file",postscript_filename);f       (void) fclose(file);       return((Image *) NULL);      }    (void) fclose(file);   CloseImage(image);   filesize=image->filesize;)   DestroyImage(image);   /*2     Determine if the density options is specified.   */   (void) strcat(options," -r"); +   if (image_info->density == (char *) NULL) -     (void) strcat(options,PSDensityGeometry);    else/     (void) strcat(options,image_info->density);*    if (image_info->subimage != 0)     {.O       (void) sprintf(options,"%s -dFirstPage=%u",options,image_info->subimage);fM       (void) sprintf(options,"%s -dLastPage=%u",options,image_info->subimage+n          image_info->subrange-1);     }    /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;u   if (image_info->monochrome)       device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);    for (i=0; i < 50; i++)   {(     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }(O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,o     postscript_filename);(    status=SystemCommand(command);
   if (status)i     {l       /*7         Pre GS 3.51 does not support the pnmraw device.f       */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     }i
   if (status)p     {iK       Warning("Portable Document translation failed",image_info->filename);i)       (void) unlink(postscript_filename);        return((Image *) NULL);P     })!   image=ReadPNMImage(image_info);i%   (void) unlink(postscript_filename); &   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     {fK       Warning("Portable Document translation failed",image_info->filename);n       return((Image *) NULL);g     }L   do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;      next_image=image->next;e%     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             %_O %                                                                             % O %  R e a d P I C T I m a g e                                                  %mO %                                                                             %1O %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % . %  The format of the ReadPICTImage routine is: % & %      image=ReadPICTImage(image_info) %n+ %  A description of each parameter follows:s %dJ %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadPICTImage(image_info)r	 ImageInfo    *image_info; {    char     filename[MaxTextLength];     Image      *image,      *next_image,     *proxy_image;      /*     Allocate image structure.d   */(   proxy_image=AllocateImage(image_info);$   if (proxy_image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image file.   */3   OpenImage(image_info,proxy_image,ReadBinaryType);p)   if (proxy_image->file == (FILE *) NULL) 5     PrematureExit("Unable to open file",proxy_image);    CloseImage(proxy_image);   DestroyImage(proxy_image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename); N   (void) sprintf(image_info->filename,"|imconv %s -outformat pnm -",filename);!   image=ReadPNMImage(image_info);a   if (image == (Image *) NULL)     {aD       (void) sprintf(image_info->filename,"|picttoppm %s",filename);%       image=ReadPNMImage(image_info);      }    if (image == (Image *) NULL)     { >       Warning("PICT translation failed",image_info->filename);       return((Image *) NULL);v     }n   /*     Assign proper filename.    */   do   {t,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL);.+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }l o
 #ifdef HasPNG  #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             % O %                                                                             %;O %  R e a d P N G I m a g e                                                    %)O %                                                                             %cO %                                                                             %DO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %pI %  Function ReadPNGImage reads a Portable Network Graphics image file anduM %  returns it.  It allocates the memory necessary for the new Image structure(* %  and returns a pointer to the new image. %-- %  The format of the ReadPNGImage routine is:n %o% %      image=ReadPNGImage(image_info)r %i+ %  A description of each parameter follows:= %pI %    o image:  Function ReadPNGImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.p %0A %    o image_info: Specifies a pointer to an ImageInfo structure.) %  %  */& static Image *ReadPNGImage(image_info)	 ImageInfo_   *image_info; {    Image      *image;      register int     i,     x,     y;     register unsigned char     *p;      register RunlengthPacket     *q;   
   png_info     *ping_info;+     png_struct
     *ping;     unsigned chars     *png_pixels,     **scanlines;     unsigned int     bytes_per_line,      packets;     unsigned short
     index,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);i#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);;   /*     Allocate the PNG structurese   */1   ping=(png_struct *) malloc(sizeof(png_struct));d2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image); )   image->pixels=(RunlengthPacket *) NULL; $   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))      {        /*         PNG image is corrupt.        */9       png_read_destroy(ping,ping_info,(png_info *) NULL);a/       if (scanlines != (unsigned char **) NULL) !         free((char *) scanlines); /       if (png_pixels != (unsigned char *) NULL) "         free((char *) png_pixels);       free((char *) ping);       free((char *) ping_info);        CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {%           DestroyImage(image);!           return((Image *) NULL);F	         }d       return(image);     }i   /*     Prepare PNG for reading.   */   png_info_init(ping_info);h   png_read_init(ping);    png_init_io(ping,image->file);    png_read_info(ping,ping_info);*   if (ping_info->bit_depth > QuantumDepth)     {X       png_set_strip_16(ping);s       ping_info->bit_depth=8;o     }     if (ping_info->bit_depth < 16)     image->depth=8;r   /*     Initialize image structure.A   */"   image->columns=ping_info->width;    image->rows=ping_info->height;   image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1);n    if (ping_info->bit_depth == 1)7     packets=Max((image->columns*image->rows+8) >> 4,1);fL   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   bytes_per_line=uN     Max((int) ping_info->bit_depth >> 3,1)*ping_info->channels*image->columns;   png_pixels=(unsigned char *)7     malloc(bytes_per_line*image->rows*sizeof(Quantum));aK   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *));(4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (png_pixels == (unsigned char *) NULL) ||s-       (scanlines == (unsigned char **) NULL)) 5     PrematureExit("Unable to allocate memory",image);>:   if ((ping_info->color_type == PNG_COLOR_TYPE_PALETTE) ||5       (ping_info->color_type == PNG_COLOR_TYPE_GRAY))=     {m       /*"         Initialize image colormap.       */       image->class=PseudoClass;i.       image->colors=1 << ping_info->bit_depth;:       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE)-         image->colors=ping_info->num_palette;oP       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); :       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE))         for (i=0; i < image->colors; i++)r	         {lD           image->colormap[i].red=UpScale(ping_info->palette[i].red);H           image->colormap[i].green=UpScale(ping_info->palette[i].green);F           image->colormap[i].blue=UpScale(ping_info->palette[i].blue);	         } 
       else)         for (i=0; i < image->colors; i++) 	         { >           image->colormap[i].red=(MaxRGB*i)/(image->colors-1);@           image->colormap[i].green=(MaxRGB*i)/(image->colors-1);?           image->colormap[i].blue=(MaxRGB*i)/(image->colors-1); 	         }      }    /*     Read image scanlines.    */"   if (image->class == DirectClass)!     if (ping_info->bit_depth < 8)        png_set_packing(ping);!   for (i=0; i < image->rows; i++) /     scanlines[i]=png_pixels+(bytes_per_line*i); !   png_read_image(ping,scanlines);%   png_read_end(ping,ping_info);%   /*4     Convert PNG pixels to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength;e"   if (image->class == DirectClass)     {u
       Quantumt
         blue,m         green,         red;         /*?         Convert image to DirectClass runlength-encoded packets.        */@       if ((ping_info->color_type == PNG_COLOR_TYPE_RGB_ALPHA) ||?           (ping_info->color_type == PNG_COLOR_TYPE_GRAY_ALPHA))A         image->matte=True;%       for (y=0; y < image->rows; y++)        {a         p=scanlines[y]; *         for (x=0; x < image->columns; x++)	         {            ReadQuantum(red,p);d           green=red;           blue=red;eA           if (ping_info->color_type != PNG_COLOR_TYPE_GRAY_ALPHA) 
             { #               ReadQuantum(green,p); "               ReadQuantum(blue,p);
             }n           index=0;           if (image->matte) !             ReadQuantum(index,p); L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&F               (index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {g&               if (image->packets != 0)                 q++;               image->packets++;;,               if (image->packets == packets)                 {h                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));i@                   if (image->pixels == (RunlengthPacket *) NULL)                     {)0                       free((char *) png_pixels);G                       PrematureExit("Unable to allocate memory",image);g                     }L3                   q=image->pixels+image->packets-1;                  }e               q->red=red;s               q->green=green;h               q->blue=blue;i               q->index=index;a               q->length=0;
             }s	         }_5         ProgressMonitor(LoadImageText,y,image->rows);.       }      }s   else     {.
       Quantume         *quantum_scanline;         register Quantum         *r;f         /*?         Convert image to PseudoClass runlength-encoded packets.)       */J       quantum_scanline=(Quantum *) malloc(image->columns*sizeof(Quantum));/       if (quantum_scanline == (Quantum *) NULL) 9         PrematureExit("Unable to allocate memory",image); %       for (y=0; y < image->rows; y++)t       {          p=scanlines[y];w         r=quantum_scanline; %         switch (ping_info->bit_depth)g	         {            case 1:            {              register int               bit;  9             for (x=0; x < ((int) image->columns-7); x+=8) 
             {c*               for (bit=7; bit >= 0; bit--):                 *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);               p++;
             } *             if ((image->columns % 8) != 0)               {=C                 for (bit=7; bit >= (8-(image->columns % 8)); bit--)u<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }              break;           }            case 2:f           { 9             for (x=0; x < ((int) image->columns-3); x+=4)=
             {l#               *r++=(*p >> 6) & 0x3; #               *r++=(*p >> 4) & 0x3; #               *r++=(*p >> 2) & 0x3;w               *r++=(*p) & 0x3;               p++;
             } *             if ((image->columns % 4) != 0)               { =                 for (i=3; i >= (4-(image->columns % 4)); i--).,                   *r++=(*p >> (i*2)) & 0x03;                 p++;               }              break;           }_           case 4:            { 9             for (x=0; x < ((int) image->columns-1); x+=2)h
             {u#               *r++=(*p >> 4) & 0xf;f               *r++=(*p) & 0xf;               p++;
             }n*             if ((image->columns % 2) != 0)%               *r++=(*p++ >> 4) & 0xf;a             break;           }u           case 8:t           {".             for (x=0; x < image->columns; x++)               *r++=(*p++);             break;           }            case 16:           {o.             for (x=0; x < image->columns; x++)
             {                 ReadQuantum(*r,p);               r++;
             })             break;           }l           default:             break;	         } 
         /*"           Transfer image scanline.
         */         r=quantum_scanline; *         for (x=0; x < image->columns; x++)	         {            index=(*r++);;F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {<&               if (image->packets != 0)                 q++;               image->packets++;),               if (image->packets == packets)                 {*                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)                     {c6                       free((char *) quantum_scanline);G                       PrematureExit("Unable to allocate memory",image);                      }d3                   q=image->pixels+image->packets-1;(                 };               q->index=index;Q               q->length=0;
             }a	         }s5         ProgressMonitor(LoadImageText,y,image->rows);-       } &       if (image->class == PseudoClass)         SyncImage(image);f&       free((char *) quantum_scanline);+       if (ping_info->valid & PNG_INFO_tRNS) 	         {a           /*/             Image has a transparent background.            */#           image->class=DirectClass;            image->matte=True;           q=image->pixels;,           for (i=0; i < image->packets; i++)           {r             index=q->index;t             q->index=Opaque;@             if (ping_info->color_type != PNG_COLOR_TYPE_PALETTE)               {):                 if (index == ping_info->trans_values.gray)'                   q->index=Transparent;                }i             else/               if (index < ping_info->num_trans)n1                 q->index=ping_info->trans[index];              q++;           }n	         }n&       if (image->class == PseudoClass)          CompressColormap(image);     } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); '   if (ping_info->valid & PNG_INFO_gAMA))"     image->gamma=ping_info->gamma;   if (ping_info->num_text > 0)     {a       unsigned int         length;r         /*!         Initialize image comment.e       */       length=1;;-       for (i=0; i < ping_info->num_text; i++) P         length+=strlen(ping_info->text[i].key)+ping_info->text[i].text_length+4;%       image->comments=malloc(length); +       if (image->comments == (char *) NULL)(9         PrematureExit("Unable to allocate memory",image);)       *image->comments='\0';-       for (i=0; i < ping_info->num_text; i++)_       {r>         (void) strcat(image->comments,ping_info->text[i].key);,         (void) strcat(image->comments,": ");D         p=(unsigned char *) image->comments+strlen(image->comments);?         (void) strncat(image->comments,ping_info->text[i].text,o*           ping_info->text[i].text_length);*         p+=ping_info->text[i].text_length;(         if (i < (ping_info->num_text-1))           *p++='\n';         *p='\0';       }s     };   /*     Free memory.   */5   png_read_destroy(ping,ping_info,(png_info *) NULL);g   free((char *) png_pixels);   free((char *) ping);   free((char *) ping_info);1   CloseImage(image);   return(image); }( #else & static Image *ReadPNGImage(image_info)	 ImageInfoe   *image_info; { ?   Warning("PNG library is not available",image_info->filename);l$   return(ReadMIFFImage(image_info)); }d #endif t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %MO %                                                                             % O %                                                                             %eO %  R e a d P N M I m a g e                                                    %pO %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadPNMImage reads a Portable Anymap image file and returns it.dL %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % - %  The format of the ReadPNMImage routine is:  % % %      image=ReadPNMImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPNMImage returns a pointer to the image after%L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.p %sA %    o image_info: Specifies a pointer to an ImageInfo structure.f %t %n */  * static unsigned int PNMInteger(image,base) Imagem	   *image;    unsigned int   base;F {g #define MaxRawValue  255     inta     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {t     c=fgetc(image->file);p     if (c == EOF)        return(0);     if (c == '#')        {e         register chary
           *p;            unsigned int           length;f  
         /*           Read comment.s
         */-         if (image->comments != (char *) NULL)f           { +             length=strlen(image->comments);)%             p=image->comments+length;            }(         else           { !             length=MaxTextLength; A             image->comments=(char *) malloc(length*sizeof(char));R             p=image->comments;           }e6         for ( ; image->comments != (char *) NULL; p++)	         {i.           if ((p-image->comments+2) >= length)
             {e               *p='\0';               length<<=1;b&               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)                  break;8               p=image->comments+strlen(image->comments);
             }B           c=fgetc(image->file);=(           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c; 	         }l-         if (image->comments == (char *) NULL),           { =             Warning("Memory allocation error",(char *) NULL);s             return(0);           }          *p++='\n';         *p='\0';       }r   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {u     value*=10;     value+=c-'0';t     c=fgetc(image->file);      if (c == EOF)e       return(0);   }    while (isdigit(c));l   return(value); }&  & static Image *ReadPNMImage(image_info)	 ImageInfo    *image_info; {o   char     format;i     Image;     *image;l     intr     y;  	   Quantum 	     blue, 
     green,     red,     *scale;      register int     i,     x;     register RunlengthPacket     *q;m     unsigned int     max_value,     packets,     status;x     unsigned short
     index;     /*     Allocate image structure.a   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);*   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read PNM image.)   */4   status=ReadData((char *) &format,1,1,image->file);   do   {      /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P')) 2       PrematureExit("Not a PNM image file",image);     /*!       Initialize image structure.r     */     format=fgetc(image->file);     if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10); *     if ((image->columns*image->rows) == 0)M       PrematureExit("Unable to read image: image dimensions are zero",image);      image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1);r+     if ((format == '1') || (format == '4')))9       packets=Max((image->columns*image->rows+8) >> 4,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image); +     if ((format == '1') || (format == '4'))e        max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10);t     scale=(Quantum *) NULL; +     if ((format != '3') && (format != '6'))        { 
         /*           Create colormap.
         */!         image->class=PseudoClass;a.         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *))4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          if (format != '7')+           for (i=0; i < image->colors; i++)            { @             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);l           }m         else           {g             /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++) /               for (green=0; green < 8; green++)n.                 for (blue=0; blue < 4; blue++)                 {gB                   image->colormap[i].red=(Quantum) (red*MaxRGB)/7;F                   image->colormap[i].green=(Quantum) (green*MaxRGB)/7;D                   image->colormap[i].blue=(Quantum) (blue*MaxRGB)/3;                   i++;                 }p           }"       }      if (max_value != MaxRGB)       {x
         /*&           Compute pixel scaling table.
         */@         scale=(Quantum *) malloc((max_value+1)*sizeof(Quantum));&         if (scale == (Quantum *) NULL);           PrematureExit("Unable to allocate memory",image);n&         for (i=0; i <= max_value; i++)E           scale[i]=(Quantum) ((i*MaxRGB+(max_value >> 1))/max_value);x       }u     /*;       Convert PNM pixels to runlength-encoded MIFF packets.g     */     q=image->pixels;     q->length=MaxRunlength;*     switch (format)t     {        case '1':l       {l
         /*9           Convert PBM image to runlength-encoded packets.m
         */'         for (y=0; y < image->rows; y++) 	         {c,           for (x=0; x < image->columns; x++)           {b'             index=!PNMInteger(image,2); H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {r(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));rB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);e5                     q=image->pixels+image->packets-1;n                   }                  q->index=index;i                 q->length=0;               }            } 7           ProgressMonitor(LoadImageText,y,image->rows);g	         }          break;       })       case '2':-       {m
         /*9           Convert PGM image to runlength-encoded packets.;
         */'         for (y=0; y < image->rows; y++)U	         {),           for (x=0; x < image->columns; x++)           { '             index=PNMInteger(image,10);+*             if (scale != (Quantum *) NULL)!               index=scale[index];eH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;c.                 if (image->packets == packets)                   {l                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));cB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;)                   }c                 q->index=index;g                 q->length=0;               }+           } 7           ProgressMonitor(LoadImageText,y,image->rows);<	         }s         break;       }        case '3':l       {e
         /*9           Convert PNM image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         {+,           for (x=0; x < image->columns; x++)           { %             red=PNMInteger(image,10);I'             green=PNMInteger(image,10);f&             blue=PNMInteger(image,10);*             if (scale != (Quantum *) NULL)               {                  red=scale[red];i#                 green=scale[green]; !                 blue=scale[blue];g               }aN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;i.                 if (image->packets == packets)                   {(                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));uB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;%                   }%                 q->red=red;                  q->green=green;                  q->blue=blue;                  q->index=0;                  q->length=0;
             }            } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         } !         if (IsPseudoClass(image)) >           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }        case '4':        {          unsigned char            bit,           byte;            unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets.%
         */'         for (y=0; y < image->rows; y++)%	         {%           bit=0;           byte=0;d,           for (x=0; x < image->columns; x++)           {l             if (bit == 0)y&               byte=fgetc(image->file);(             index=(byte & 0x80) ? 0 : 1;H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;l.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;                    }                  q->index=index;/                 q->length=0;               }g             bit++;             if (bit == 8))               bit=0;             byte<<=1;m           }o7           ProgressMonitor(LoadImageText,y,image->rows);U	         }r         break;       }e       case '5':        case '7':l       {o
         /*=           Convert PGM raw image to runlength-encoded packets.t
         */'         for (y=0; y < image->rows; y++)o	         {(,           for (x=0; x < image->columns; x++)           {L)             if (max_value <= MaxRawValue)e'               index=fgetc(image->file);l             else3               index=LSBFirstReadShort(image->file);cH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {/(                 if (image->packets != 0)                   q++;!                 image->packets++;o.                 if (image->packets == packets)                   {+                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));oB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);t5                     q=image->pixels+image->packets-1;                    }*                 q->index=index;l                 q->length=0;               };           }=7           ProgressMonitor(LoadImageText,y,image->rows); 	         }0         break;       })       case '6':e       {F
         /*@           Convert PNM raster image to runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++) 	         {m,           for (x=0; x < image->columns; x++)           {e)             if (max_value <= MaxRawValue)k               { '                 red=fgetc(image->file); )                 green=fgetc(image->file); (                 blue=fgetc(image->file);               }u             else               {(3                 red=LSBFirstReadShort(image->file); 5                 green=LSBFirstReadShort(image->file); 4                 blue=LSBFirstReadShort(image->file);               } *             if (scale != (Quantum *) NULL)               {                  red=scale[red];m#                 green=scale[green];g!                 blue=scale[blue];                }iN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))e               q->length++;             else               {%(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 7                       q=image->pixels+image->packets-1;                    }                  q->red=red;                  q->green=green;%                 q->blue=blue;%                 q->index=0;                  q->length=0;               }i           }a7           ProgressMonitor(LoadImageText,y,image->rows); 	         }o!         if (IsPseudoClass(image))r>           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }        default:4         PrematureExit("Not a PNM image file",image);     }t"     if (scale != (Quantum *) NULL)       free((char *) scale);p$     if (image->class == PseudoClass)       {n         SyncImage(image);e          CompressColormap(image);       } %     image->pixels=(RunlengthPacket *)eM       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));D     /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       { 
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);          if (status == False)           break;       } while (format != '\n');t6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       {t
         /*#           Allocate image structure.a
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {N!             DestroyImages(image); #             return((Image *) NULL);a           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }a0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)i     image=image->previous;   CloseImage(image);   return(image); }  m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*O %                                                                             %-O %                                                                             %gO %                                                                             %sO %  R e a d P S I m a g e                                                      %*O %                                                                             %aO %                                                                             %NO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s % O %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns ah %  pointer to the new image. %c, %  The format of the ReadPSImage routine is: %-$ %      image=ReadPSImage(image_info) %l+ %  A description of each parameter follows:  %fH %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.g %mA %    o image_info: Specifies a pointer to an ImageInfo structure.g %r %, */% static Image *ReadPSImage(image_info)e	 ImageInfo    *image_info; {v% #define BoundingBox  "%%BoundingBox:"l) #define DocumentMedia  "%%DocumentMedia:" - #define PageBoundingBox  "%%PageBoundingBox:"      char     command[MaxTextLength],      *device,     filename[MaxTextLength],     options[MaxTextLength],-'     postscript_filename[MaxTextLength], &     translate_geometry[MaxTextLength];     FILE
     *file;     float      dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,;     y_resolution;-     Image]     *image,u     *next_image;     int      c,
     count,     status,      x,     y;  
   long int
     filesize;r     register char      *p;=     register int     i;     unsigned int     height, 
     width;     /*     Allocate image structure.+   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);y#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);;   /*     Open temporary output file.a   */)   TemporaryFilename(postscript_filename);t&   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);O   (void) sprintf(translate_geometry,"%f %f translate\n              ",0.0,0.0);>(   (void) fputs(translate_geometry,file);   /*     Set the page geometry.   */   lower_x=0;   lower_y=0;   *options='\0';(   if (image_info->page != (char *) NULL)     {t#       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     }o   else     for (p=command; ; )      {        c=fgetc(image->file);        if (c == EOF)+         break;       (void) fputc(c,file);U
       *p++=c; J       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextLength-1)))         continue;        *p='\0';       p=command;       /*'         Parse a bounding box statement.        */       count=0;@       if (strncmp(BoundingBox,command,strlen(BoundingBox)) == 0)N         count=sscanf(command,"%%%%BoundingBox: %f %f %f %f",&lower_x,&lower_y,           &upper_x,&upper_y);gD       if (strncmp(DocumentMedia,command,strlen(DocumentMedia)) == 0)         count=M           sscanf(command,"%%%%DocumentMedia: %*s %f %f",&upper_x,&upper_y)+2;sH       if (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0)@         count=sscanf(command,"%%%%PageBoundingBox: %f %f %f %f",/           &lower_x,&lower_y,&upper_x,&upper_y);+       if (count != 4)          continue;-5       if ((lower_x > upper_x) || (lower_y > upper_y))          continue;)       /*         Determine bounding box.n       */       dx_resolution=72.0;;       dy_resolution=72.0;        x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL) N         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;       /*'         Set Postscript render geometry.        */O       (void) sprintf(translate_geometry,"%f %f translate\n",-lower_x,-lower_y);        width=upper_x-lower_x;-       if ((float) ((int) upper_x) != upper_x)m         width++;       height=upper_y-lower_y;c-       if ((float) ((int) upper_y) != upper_y)d         height++; '       (void) sprintf(options,"-g%ux%u",-B         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }m
   for ( ; ; )+   {      c=fgetc(image->file);      if (c == EOF)+       break;     (void) fputc(c,file);    }    if (ferror(file))(     {gK       Warning("An error has occurred writing to file",postscript_filename);g       (void) fclose(file);       return((Image *) NULL);c     }+   (void) fseek(file,0,0); (   (void) fputs(translate_geometry,file);   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;    DestroyImage(image);   /*.     Determine if density options is specified.   */   (void) strcat(options," -r"); +   if (image_info->density == (char *) NULL) -     (void) strcat(options,PSDensityGeometry);m   else/     (void) strcat(options,image_info->density);    /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;;   if (image_info->monochrome)e      device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);    for (i=0; i < 50; i++)   {c     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }mO   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,      postscript_filename);e    status=SystemCommand(command);
   if (status)t     {        /*7         Pre GS 3.51 does not support the pnmraw device.        */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     } *   if (access(image_info->filename,0) != 0)     {e       /*1         Ghostscript requires a showpage operator.;       */*       file=fopen(postscript_filename,"a");        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);&       (void) fputs("showpage\n",file);       (void) fclose(file);$       status=SystemCommand(command);     } %   (void) unlink(postscript_filename);+
   if (status)g     {-       /*F         Ghostscript has failed-- try the Display Postscript Extension.       */3       (void) strcpy(image_info->filename,filename);-%       image=ReadDPSImage(image_info); "       if (image != (Image *) NULL)         return(image);D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);e     }i!   image=ReadPNMImage(image_info);%&   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     { D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);      }    do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;      next_image=image->next; %     if (next_image != (Image *) NULL)I       image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %sO %                                                                             %oO %  R e a d R A D I A N C E I m a g e                                          %eO %                                                                             %gO %                                                                             %eO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m % I %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it.oL %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % 2 %  The format of the ReadRADIANCEImage routine is: %e* %      image=ReadRADIANCEImage(image_info) %%+ %  A description of each parameter follows:% %%N %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.H %M %I */+ static Image *ReadRADIANCEImage(image_info) 	 ImageInfo    *image_info; {    char     command[MaxTextLength],      filename[MaxTextLength];     Image      *image,      *next_image;     int      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);%   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)e/     PrematureExit("Unable to open file",image);    CloseImage(image);   /*)     Use ra_ppm to convert RADIANCE image.H   *//   (void) strcpy(filename,image_info->filename);a*   TemporaryFilename(image_info->filename);G   (void) sprintf(command,"ra_ppm %s %s",filename,image_info->filename);e    status=SystemCommand(command);
   if (status)g7     PrematureExit("RADIANCE translation failed",image);i   DestroyImage(image);!   image=ReadPNMImage(image_info);i&   (void) unlink(image_info->filename);   if (image == (Image *) NULL)7     PrematureExit("RADIANCE translation failed",image);    /*     Assign proper filename.C   */   do   {m,     (void) strcpy(image->filename,filename);     next_image=image->next;i%     if (next_image != (Image *) NULL)e       image=next_image;%)   } while (next_image != (Image *) NULL);%+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d R G B I m a g e                                                    % O %                                                                             % O %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %tM %  Function ReadRGBImage reads an image of raw red, green, and blue bytes and M %  returns it.  It allocates the memory necessary for the new Image structurel* %  and returns a pointer to the new image. %g- %  The format of the ReadRGBImage routine is:r %i% %      image=ReadRGBImage(image_info)i % + %  A description of each parameter follows:n %bI %    o image:  Function ReadRGBImage returns a pointer to the image afteruL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.8 % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %, %  */& static Image *ReadRGBImage(image_info)	 ImageInfot   *image_info; {    Image      *image;s     intr     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;f     unsigned char      *rgb_pixels;     unsigned int     height,a     packet_size,
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)m/     PrematureExit("Unable to open file",image);g   /*-     Determine width and height, e.g. 640x512.6   */   width=512;
   height=512;c   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.i   */   packet_size=3;-   if (strcmp(image_info->magick,"RGBA") == 0)B     {z       image->matte=True;       packet_size=4;     }    image->columns=width;;   image->rows=height;0,   image->packets=image->columns*image->rows;   rgb_pixels=(unsigned char *)=     malloc(packet_size*image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *)t3     malloc(image->packets*sizeof(RunlengthPacket)); /   if ((rgb_pixels == (unsigned char *) NULL) ||l2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);a   /*6     Convert raster image to runlength-encoded packets.   */D   (void) ReadData((char *) rgb_pixels,3,image->packets,image->file);   p=rgb_pixels;u    switch (image_info->interlace)   {i     case NoneInterlace:o     default:     {        /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       q=image->pixels;%       for (y=0; y < image->rows; y++)s       {o*         for (x=0; x < image->columns; x++)	         {L            ReadQuantum(q->red,p);"           ReadQuantum(q->green,p);!           ReadQuantum(q->blue,p);a           q->index=0;-           if (image->matte)-             q->index=(*p++);           q->length=0;           q++;	         }]5         ProgressMonitor(LoadImageText,y,image->rows);l       }o       break;     }      case LineInterlace:i     {        /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...w       */%       for (y=0; y < image->rows; y++)g       {s)         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);           q->index=0;g           q->length=0;           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {m"           ReadQuantum(q->green,p);           q++;	         }<)         q=image->pixels+y*image->columns;h*         for (x=0; x < image->columns; x++)	         { !           ReadQuantum(q->blue,p);)           q++;	         }-)         q=image->pixels+y*image->columns;          if (image->matte) ,           for (x=0; x < image->columns; x++)           {E$             ReadQuantum(q->index,p);             q++;           } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {        /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...;       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {b         ReadQuantum(q->red,p);         q->index=0;n         q->length=0;         q++;       }>-       ProgressMonitor(LoadImageText,100,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {G          ReadQuantum(q->green,p);         q++;       }n-       ProgressMonitor(LoadImageText,200,400);>       q=image->pixels;(       for (i=0; i < image->packets; i++)       {s         ReadQuantum(q->blue,p);u         q++;       }e-       ProgressMonitor(LoadImageText,300,400);t       q=image->pixels;       if (image->matte)%*         for (i=0; i < image->packets; i++)	         {%"           ReadQuantum(q->index,p);           q++;	         } -       ProgressMonitor(LoadImageText,400,400);        break;     }    }    free((char *) rgb_pixels);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d R L E I m a g e                                                    %%O %                                                                             %tO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %rG %  Function ReadRLEImage reads a run-length encoded Utah Raster ToolkitoL %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % - %  The format of the ReadRLEImage routine is:a %t% %      image=ReadRLEImage(image_info)m %H+ %  A description of each parameter follows:c %sI %    o image:  Function ReadRLEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.g %fA %    o image_info: Specifies a pointer to an ImageInfo structure.r %  %f */& static Image *ReadRLEImage(image_info)	 ImageInfob   *image_info; {  #define SkipLinesOp  0x01; #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06s #define EOFOp  0x07      char     magick[12];      Imager     *image;p     int*     opcode,n     operand,     status,      x,     y;     register int     i,     j;     register RunlengthPacket     *q;      register unsigned char     *p;L     unsigned chare     background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel,e
     flags,     map_length,t     number_colormaps,l     number_planes;     /*     Allocate image structure.g   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);*   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)d/     PrematureExit("Unable to open file",image);e   /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file); ?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0)) 0     PrematureExit("Not a RLE image file",image);   do   {N     /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file);c.     image->packets=image->columns*image->rows;     flags=fgetc(image->file);e     image->matte=flags & 0x04;%     number_planes=fgetc(image->file); &     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file);iP     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))8       PrematureExit("Unsupported RLE image file",image);     if (flags & 0x02)s       {S
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++)J0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }      else       {t
         /*&           Initialize background color.
         */         p=background_color; )         for (i=0; i < number_planes; i++)u2           *p++=(unsigned char) fgetc(image->file);       }=$     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       {(
         /*           Read image colormaps.o
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL).;           PrematureExit("Unable to allocate memory",image);*         p=colormap;l,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=XDownScale(LSBFirstReadShort(image->file));       }      if (flags & 0x08)e       {          unsigned int           length;c  
         /*           Read image comment.o
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char));(-         if (image->comments == (char *) NULL)d;           PrematureExit("Unable to allocate memory",image);jI         (void) ReadData((char *) image->comments,1,length-1,image->file);n'         image->comments[length-1]='\0';t!         if ((length & 0x01) == 0) $           (void) fgetc(image->file);       }G     /*       Allocate RLE pixels.     */     if (image->matte)i       number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char)); -     if (rle_pixels == (unsigned char *) NULL)t7       PrematureExit("Unable to allocate memory",image);e*     if ((flags & 0x01) && !(flags & 0x02))       { 
         /*           Set background color.j
         */         p=rle_pixels; *         for (i=0; i < image->packets; i++)	         {_           if (!image->matte)-             for (j=0; j < number_planes; j++)S'               *p++=background_color[j];            else
             {h3               for (j=0; j < (number_planes-1); j++)()                 *p++=background_color[j];O5               *p++=0;  /* initialize matte channel */g
             }s	         }o       }g     /*#       Read runlength-encoded image.r     */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {r       switch (opcode & 0x3f)       {e         case SkipLinesOp:s	         {l%           operand=fgetc(image->file);*           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);(           x=0;           y+=operand;U           break;	         }          case SetColorOp:	         {(%           operand=fgetc(image->file);            plane=operand;           if (plane == 255) "             plane=number_planes-1;           x=0;           break;	         }P         case SkipPixelsOp:	         { %           operand=fgetc(image->file);a           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);            x+=operand;t           break;	         }e         case ByteDataOp:	         {m%           operand=fgetc(image->file);m           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++);           {0%             pixel=fgetc(image->file);p>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;j             p+=number_planes;c           }            if (operand & 0x01) &             (void) fgetc(image->file);           x+=operand;i           break;	         }          case RunDataOp:f	         {_%           operand=fgetc(image->file);n           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);t#           pixel=fgetc(image->file); $           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)+           { >             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;C             p+=number_planes;L           }            x+=operand;{           break;	         }U         default:           break;       }n        opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {e         unsigned int           mask;u  
         /*1           Apply colormap transformation to image.i
         */         mask=(map_length-1);         p=rle_pixels;J"         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           { 3             *p=(unsigned char) colormap[*p & mask];              p++;           }          else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)                { F                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }R       })     /*!       Initialize image structure.      */%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));m2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);a     q=image->pixels;     if (number_planes >= 3)i       {e
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels; '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {r!             q->red=UpScale(*p++);o#             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);B             q->index=(unsigned short) (image->matte ? (*p++) : 0);             q->length=0;             q++;           }d7           ProgressMonitor(LoadImageText,y,image->rows);g	         }(       }T     else       { 
         /*           Create colormap.
         */!         image->class=PseudoClass;>"         if (number_colormaps == 0)           map_length=256;o!         image->colors=map_length;g'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);e         p=colormap; "         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)            {(             /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }          else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++) 
             {                /*                 Pseudocolor.               */:               image->colormap[i].red=(Quantum) UpScale(i);<               image->colormap[i].green=(Quantum) UpScale(i);;               image->colormap[i].blue=(Quantum) UpScale(i); 
             }            else-             for (i=0; i < image->colors; i++) 
             { 1               image->colormap[i].red=UpScale(*p);%@               image->colormap[i].green=UpScale(*(p+map_length));A               image->colormap[i].blue=UpScale(*(p+map_length*2));                p++;
             }s         p=rle_pixels;t         if (!image->matte)           {              /*L               Convert raster image to PseudoClass runlength-encoded packets.             */+             for (y=0; y < image->rows; y++) 
             {a0               for (x=0; x < image->columns; x++)               { 1                 q->index=(unsigned short) (*p++);                  q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }t             SyncImage(image);_           }I         else           {i             /*A               Image has a matte channel-- promote to DirectClass.              */+             for (y=0; y < image->rows; y++) 
             {i0               for (x=0; x < image->columns; x++)               {e/                 q->red=image->colormap[*p].red; 3                 q->green=image->colormap[*p].green;)3                 q->blue=image->colormap[*p++].blue;l1                 q->index=(unsigned short) (*p++);)                 q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows);(
             } "             free(image->colormap);1             image->colormap=(ColorPacket *) NULL;v%             image->class=DirectClass;(             image->colors=0;           }i       })     if (number_colormaps != 0)       free((char *) colormap);     free((char *) rle_pixels);     CompressImage(image);I     /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file);>@     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } D   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %pO %                                                                             % O %  R e a d S G I I m a g e                                                    %lO %                                                                             %fO %                                                                             %rO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gG %  Function ReadSGIImage reads a SGI RGB image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns ad %  pointer to the new image. %n- %  The format of the ReadSGIImage routine is:t % % %      image=ReadSGIImage(image_info)a %;+ %  A description of each parameter follows:/ % I %    o image:  Function ReadSGIImage returns a pointer to the image afternL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.f % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  % static void SGIDecode(packets,pixels)l
 unsigned char1   *packets, 
   *pixels; {    unsigned charo
     count,
     pixel;     for ( ; ;)   {)     pixel=(*packets++);G     count=pixel & 0x7f;&     if (count == 0),       break;     if (pixel & 0x80)e"       for ( ; count != 0; count--)       {s         *pixels=(*packets++);r         pixels+=4;       }d     else       {=         pixel=(*packets++);o$         for ( ; count != 0; count--)	         {;           *pixels=pixel;           pixels+=4;	         }d       }    }a }c  & static Image *ReadSGIImage(image_info)	 ImageInfo    *image_info; {l   typedef struct _SGIHeadero   {z     unsigned short       magic;       unsigned chara       storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,)       depth;       unsigned longl       minimum_value,       maximum_value;       unsigned char,       filler[492];   } SGIHeader;     Image      *image;D     SGIHeaderl     iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;      register unsigned char     *p;r     unsigned charn     *iris_pixels;[     /*     Allocate image structure.l   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);;#   if (image->file == (FILE *) NULL)g/     PrematureExit("Unable to open file",image);e   /*     Read SGI raster header.(   */3   iris_header.magic=MSBFirstReadShort(image->file);    do   {-     /*       Verify SGI identifier.     */$     if (iris_header.magic != 0x01DA)1       PrematureExit("Not a SGI RGB image",image);a+     iris_header.storage=fgetc(image->file); 3     iris_header.bytes_per_pixel=fgetc(image->file); )     if (iris_header.bytes_per_pixel != 1)tF       PrematureExit("Image must have 1 byte per pixel channel",image);9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file);%4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file); <     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);2     (void) ReadData((char *) iris_header.filler,1,=       (unsigned int) sizeof(iris_header.filler),image->file);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *) K       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);%$     if (iris_header.storage != 0x01)       {%         unsigned char            *scanline;  
         /*%           Read standard image format.s
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL)t;           PrematureExit("Unable to allocate memory",image); 3         for (z=0; z < (int) iris_header.depth; z++)o	         {n           p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {tD             (void) ReadData((char *) scanline,1,iris_header.columns,               image->file);f9             for (x=0; x < (int) iris_header.columns; x++) 
             {e               *p=scanline[x];m               p+=4;f
             }            } 	         }           free((char *) scanline);       }      else       {h         unsigned chare           *packets;            unsigned int           data_order;m           unsigned longd           offset,            *offsets,            *runlength;u  
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));)!         packets=(unsigned char *)UH           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));N2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image);wF         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file);pF         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file);f
         /*           Check data order.)
         */         offset=0;R         data_order=0;)E         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++)vH           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           {p7             if (offsets[y+z*iris_header.rows] < offset)                data_order=1;01             offset=offsets[y+z*iris_header.rows];m           } A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);n         if (data_order == 1)           {i7             for (z=0; z < (int) iris_header.depth; z++) 
             {o               p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               {l<                 if (offset != offsets[y+z*iris_header.rows])                   {%9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z); +                 p+=(iris_header.columns*4);                } 
             }            }          else           {              p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             { 9               for (z=0; z < (int) iris_header.depth; z++)%               {%<                 if (offset != offsets[y+z*iris_header.rows])                   {u9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    }e3                 (void) ReadData((char *) packets,1,IN                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z);r               }i)               p+=(iris_header.columns*4);g
             }d           }o         free(runlength);         free(packets);         free(offsets);       }s     /*!       Initialize image structure.I     */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns;x!     image->rows=iris_header.rows;].     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)h5       malloc(image->packets*sizeof(RunlengthPacket));t2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SGI raster image to runlength-encoded packets.     */     q=image->pixels;     if (iris_header.depth >= 3)/       {m
         /*E           Convert SGI image to DirectClass runlength-encoded packets.r
         */'         for (y=0; y < image->rows; y++)d	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);o,           for (x=0; x < image->columns; x++)           {              q->red=UpScale(*p);e%             q->green=UpScale(*(p+1)); $             q->blue=UpScale(*(p+2));             q->index=(*(p+3));             q->length=0;             p+=4;g             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);t	         }        }      else       {'         unsigned short           index;  
         /*           Create grayscale map. 
         */!         image->class=PseudoClass;          image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);m)         for (i=0; i < image->colors; i++) 	         {m6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i);)	         } 
         /*E           Convert SGI image to PseudoClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);i,           for (x=0; x < image->columns; x++)           {m(             index=(unsigned short) (*p);             q->index=index;              q->length=0;             p+=4;;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);-	         }=         SyncImage(image);        }r     free((char *) iris_pixels);,     CompressImage(image);;     /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file); $     if (iris_header.magic == 0x01DA)       { 
         /*#           Allocate image structure.w
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);l#             return((Image *) NULL);)           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }1(   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %PO %                                                                             % O %                                                                             % O %  R e a d S U N I m a g e                                                    %)O %                                                                             %(O %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %sM %  Function ReadSUNImage reads a SUN image file and returns it.  It allocatesgL %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadSUNImage routine is:  % % %      image=ReadSUNImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadSUNImage returns a pointer to the image afteraL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %g */& static Image *ReadSUNImage(image_info)	 ImageInfot   *image_info; {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2) #define RT_FORMAT_RGB  3     typedef struct _SUNHeader    {e     unsigned longm       magic,       width,
       height,k       depth,
       length,        type,        maptype,       maplength;   } SUNHeader;     Image1     *image;)     register int     bit,     i,     x,     y;     register RunlengthPacket     *q;U     register unsigned char     *p;      SUNHeaderv     sun_header;-     unsigned char      *sun_data,     *sun_pixels;     unsigned int     status;      /*     Allocate image structure.i   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);g#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read SUN raster header.    */1   sun_header.magic=MSBFirstReadLong(image->file);l   do   {)     /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95) 4       PrematureExit("Not a SUN raster image",image);3     sun_header.width=MSBFirstReadLong(image->file);e4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file);)4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file);e7     sun_header.maplength=MSBFirstReadLong(image->file);|     switch (sun_header.maptype)=     {n       case RMT_NONE:       {n"         if (sun_header.depth < 24)           {r             /*'               Create linear color ramp.              */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image); -             for (i=0; i < image->colors; i++)d
             { B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);y
             }            }          break;       }h       case RMT_EQUAL_RGB:e       {r         unsigned charr           *sun_colormap;  
         /*#           Read SUN raster colormap.g
         */-         image->colors=sun_header.maplength/3;i'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image); K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++)i:           image->colormap[i].red=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++)6<           image->colormap[i].green=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++)o;           image->colormap[i].blue=UpScale(sun_colormap[i]); $         free((char *) sun_colormap);         break;       }a       case RMT_RAW:S       {          unsigned charr           *sun_colormap;  
         /*#           Read SUN raster colormap.t
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); >         (void) ReadData((char *) sun_colormap,1,(unsigned int),           sun_header.maplength,image->file);$         free((char *) sun_colormap);         break;       }m       default:>         PrematureExit("Colormap type is not supported",image);     },O     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char));r+     if (sun_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);+I     status=ReadData((char *) sun_data,1,(unsigned int) sun_header.length,        image->file);u=     if ((status == False) && (sun_header.type != RT_ENCODED))-7       PrematureExit("Unable to read image data",image);(     sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {p         unsigned int           width,           height;   
         /*0           Read run-length encoded raster pixels.
         */?         width=sun_header.width*(((sun_header.depth-1) >> 3)+1); !         height=sun_header.height;dP         sun_pixels=(unsigned char *) malloc(width*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL)o;           PrematureExit("Unable to allocate memory",image);g@         (void) SUNDecodeImage(sun_data,sun_pixels,width,height);          free((char *) sun_data);       }e     /*!       Initialize image structure.r     */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass);c$     image->columns=sun_header.width;"     image->rows=sun_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)e5       malloc(image->packets*sizeof(RunlengthPacket));h2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);f     /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;k     q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++)k       {t
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */1         for (x=0; x < (image->columns >> 3); x++) 	         {c&           for (bit=7; bit >= 0; bit--)           {):             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }            p++;	         } &         if ((image->columns % 8) != 0)           {l?             for (bit=7; bit >= (8-(image->columns % 8)); bit--)i
             { <               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             }              p++;           }iI         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0);           p++;5         ProgressMonitor(LoadImageText,y,image->rows);g       }s     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)e	         {n           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {d             q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;7           ProgressMonitor(LoadImageText,y,image->rows);t	         }a
       else'         for (y=0; y < image->rows; y++) 	         {n           /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {tB             q->index=(unsigned short) (image->matte ? (*p++) : 0);/             if (sun_header.type == RT_STANDARD)                {g&                 q->blue=UpScale(*p++);'                 q->green=UpScale(*p++); %                 q->red=UpScale(*p++);e               }              else               {l%                 q->red=UpScale(*p++);m'                 q->green=UpScale(*p++); &                 q->blue=UpScale(*p++);               }(#             if (image->colors != 0)                {m3                 q->red=image->colormap[q->red].red;m9                 q->green=image->colormap[q->green].green;a6                 q->blue=image->colormap[q->blue].blue;               }n             q->length=0;             q++;           }rE           if (((image->columns % 2) != 0) && (image->matte == False))a             p++;7           ProgressMonitor(LoadImageText,y,image->rows);g	         }*     free((char *) sun_pixels);$     if (image->class == PseudoClass)       {%         SyncImage(image);           CompressColormap(image);       }      CompressImage(image);      /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file); '     if (sun_header.magic == 0x59a66a95)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } +   } while (sun_header.magic == 0x59a66a95); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %aO %  R e a d T G A I m a g e                                                    %fO %                                                                             % O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %iJ %  Function ReadTGAImage reads a Truevision TGA image file and returns it.L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %n- %  The format of the ReadTGAImage routine is:( %g% %      image=ReadTGAImage(image_info)r %i+ %  A description of each parameter follows:l %aI %    o image:  Function ReadTGAImage returns a pointer to the image afterrL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.* %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %m */& static Image *ReadTGAImage(image_info)	 ImageInfo    *image_info; {  #define TGAColormap 1r #define TGARGB 2 #define TGAMonochrome 3o #define TGARLEColormap  9  #define TGARLERGB  10n #define TGARLEMonochrome  11     typedef struct _TGAHeader=   {E     unsigned charg       id_length,       colormap_type,       image_type;        unsigned short       colormap_index,c       colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,m       y_origin,t       width,
       height;        unsigned charu       pixel_size,        attributes;e   } TGAHeader;     Imagem     *image;m  	   Quantumh	     blue,g
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;g     TGAHeader      tga_header;>     unsigned chare     j,     k,     runlength;     unsigned int	     base,N	     flag, 	     real,i	     skip,o     status,o	     true;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);m#   if (image->file == (FILE *) NULL)d/     PrematureExit("Unable to open file",image);)   /*      Read TGA header information.   */B   status=ReadData((char *) &tga_header.id_length,1,1,image->file);.   tga_header.colormap_type=fgetc(image->file);+   tga_header.image_type=fgetc(image->file);l   do   { <     if ((status == False) || (tga_header.image_type == 0) ||%         (tga_header.image_type > 11)) 2       PrematureExit("Not a TGA image file",image);=     tga_header.colormap_index=LSBFirstReadShort(image->file);b>     tga_header.colormap_length=LSBFirstReadShort(image->file);0     tga_header.colormap_size=fgetc(image->file);7     tga_header.x_origin=LSBFirstReadShort(image->file);>7     tga_header.y_origin=LSBFirstReadShort(image->file);a4     tga_header.width=LSBFirstReadShort(image->file);5     tga_header.height=LSBFirstReadShort(image->file); -     tga_header.pixel_size=fgetc(image->file);_-     tga_header.attributes=fgetc(image->file);L     /*!       Initialize image structure.(     */-     image->matte=tga_header.pixel_size == 32; $     image->columns=tga_header.width;"     image->rows=tga_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));n2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);e"     if (tga_header.id_length != 0)       {g
         /*           TGA image comment.
         */          image->comments=(char *)8           malloc((tga_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)t;           PrematureExit("Unable to allocate memory",image);fL         (void) ReadData(image->comments,1,tga_header.id_length,image->file);3         image->comments[tga_header.id_length]='\0';        }%&     if (tga_header.colormap_type != 0)       {%
         /*#           Read TGA raster colormap. 
         */8         if ((tga_header.image_type == TGARLEColormap) ||1             (tga_header.image_type == TGARLERGB)) #           image->class=PseudoClass; 1         image->colors=tga_header.colormap_length; '         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++) 	         { +           switch (tga_header.colormap_size)            {              case 8:%             default:
             {%               /*                 Gray scale.d               */.               red=UpScale(fgetc(image->file));               green=red;               blue=red;n               break;
             }a             case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);T#               k=fgetc(image->file); B               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum) P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }m             case 32:             case 24:
             {u               /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file)); 0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));               break;
             })           }(%           image->colormap[i].red=red;f)           image->colormap[i].green=green;a'           image->colormap[i].blue=blue;E	         }        }t     /*6       Convert TGA pixels to runlength-encoded packets.     */     base=0;a     flag=0;e     index=0;     skip=False;      real=0;0     runlength=0;     true=0;V#     for (y=0; y < image->rows; y++)      {        real=true;E       if (((unsigned char) (tga_header.attributes & 0x20) >> 5) == 0)s          real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       {p8         if ((tga_header.image_type == TGARLEColormap) ||3             (tga_header.image_type == TGARLERGB) ||l8             (tga_header.image_type == TGARLEMonochrome))           if (runlength != 0)e
             {                runlength--;               skip=flag != 0; 
             }m           else
             { C               status=ReadData((char *) &runlength,1,1,image->file);t"               if (status == False)A                 PrematureExit("Unable to read image data",image); $               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;e               skip=False; 
             }+         if (!skip)(           switch (tga_header.pixel_size)           {              case 8:              default:
             {f               /*                 Gray scale.                */'               index=fgetc(image->file);=0               if (tga_header.colormap_type == 0)                 {,/                   red=(Quantum) UpScale(index); 1                   green=(Quantum) UpScale(index); 0                   blue=(Quantum) UpScale(index);                 }                else                 {c1                   red=image->colormap[index].red; 5                   green=image->colormap[index].green;e3                   blue=image->colormap[index].blue;;                 }                break;
             }T             case 15:             case 16:
             {a               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);.#               k=fgetc(image->file);eB               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)gP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);0               index=((unsigned short) k << 8)+j;               break;
             })             case 24:             case 32:
             {                /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file));n0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));.               if (tga_header.pixel_size == 32))                 index=fgetc(image->file);%               break;
             }%           }%         if (status == False);           PrematureExit("Unable to read image data",image);          q->red=red;          q->green=green;          q->blue=blue;          q->index=index;          q->length=0;         q++;       } E       if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 4)          true+=4;
       elseG         if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 2)            true+=2;         else           true++;        if (true >= image->rows)	         {            base++;            true=base;	         } 3       ProgressMonitor(LoadImageText,y,image->rows);%     }%     (void) IsGrayImage(image);$     if (image->class == PseudoClass)       SyncImage(image);e     CompressImage(image);s     /*       Proceed to next image.     */D     status=ReadData((char *) &tga_header.id_length,1,1,image->file);0     tga_header.colormap_type=fgetc(image->file);-     tga_header.image_type=fgetc(image->file);oL     status&=((tga_header.image_type != 0) && (tga_header.image_type <= 11));     if (status == True)t       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {o!             DestroyImages(image);a#             return((Image *) NULL);I           }eB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }%   } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d T E X T I m a g e                                                  % O %                                                                             %%O %                                                                             %eO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %rK %  Function ReadTEXTImage reads a text file and returns it as an image.  ItRK %  allocates the memory necessary for the new Image structure and returns aA %  pointer to the new image. %l. %  The format of the ReadTEXTImage routine is: %t& %      image=ReadTEXTImage(image_info) %r+ %  A description of each parameter follows:  % J %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. %xA %    o image_info: Specifies a pointer to an ImageInfo structure.n %c %) */' static Image *ReadTEXTImage(image_info) 	 ImageInfoi   *image_info; {    AnnotateInfo     annotate_info;     char     geometry[MaxTextLength],     text[MaxTextLength],     *text_status;   	   Display 
     *display;      Image=     *image;t     intl     offset,t     x,     y;     register int     i;     register RunlengthPacket     *p;(     RunlengthPacket)     background_color;i     unsigned int     height, 
     width;     XColor
     color;     XResourceInfo(     resource_info;     /*     Allocate image structure.h   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)*/     PrematureExit("Unable to open file",image);    /*     Initialize Image structure.+   */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height);((   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);d   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)i3     malloc(image->packets*sizeof(RunlengthPacket));m0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);s   /*%     Initialize image annotation info.    */"   GetAnnotateInfo(&annotate_info);4   annotate_info.server_name=image_info->server_name;&   annotate_info.font=image_info->font;   annotate_info.text=text;"   annotate_info.geometry=geometry;$   annotate_info.pen=ForegroundColor;5   (void) XQueryColorDatabase(BackgroundColor,&color);s0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {        XrmDatabaseL         resource_database;         /*%         Set background and pen color.r       */       XSetErrorHandler(XError);rB       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);H       (void) XQueryColorDatabase(resource_info.background_color,&color);7       annotate_info.pen=resource_info.foreground_color;_       XCloseDisplay(display);o     }f   /*.     Initialize text image to background color.   */-   background_color.red=XDownScale(color.red);)1   background_color.green=XDownScale(color.green); /   background_color.blue=XDownScale(color.blue);)   background_color.index=0;r   p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background_color;+   if (image_info->texture != (char *) NULL)r,     TextureImage(image,image_info->texture);   /*     Annotate the text image.   */   offset=0;c
   for ( ; ; )r   {t     /*       Annotate image with text.e     */F     ProgressMonitor(LoadImageText,ftell(image->file),image->filesize);8     text_status=fgets(text,MaxTextLength-1,image->file);%     if (text_status == (char *) NULL)o       break;-     if ((int) strlen(annotate_info.text) > 0);<       annotate_info.text[strlen(annotate_info.text)-1]='\0';?     (void) sprintf(annotate_info.geometry,"+%d%+d",x,y+offset);g(     AnnotateImage(image,&annotate_info);$     offset+=annotate_info.pointsize;@     if (((y << 1)+offset+annotate_info.pointsize) < image->rows)       continue;.     /*3       Page is full-- allocate next image structure.      */     CompressImage(image);M-     if (image_info->texture == (char *) NULL) 3       QuantizeImage(image,2,8,False,RGBColorspace);t     image->orphan=True;0B     image->next=CopyImage(image,image->columns,image->rows,False);     image->orphan=False;&     if (image->next == (Image *) NULL)       {(F         Warning("Unable to annotate image","Memory allocation error");         break;       }m>     (void) strcpy(image->next->filename,image_info->filename);"     image->next->file=image->file;*     image->next->filesize=image->filesize;&     image->next->scene=image->scene+1;      image->next->previous=image;     image=image->next;     /*0       Initialize text image to background color.     */     p=image->pixels;&     for (i=0; i < image->packets; i++)       *p++=background_color;-     if (image_info->texture != (char *) NULL)I.       TextureImage(image,image_info->texture);
     offset=0;    }g   CompressImage(image);g+   if (image_info->texture == (char *) NULL) 1     QuantizeImage(image,2,8,False,RGBColorspace);r+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }l ; #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>  #elsee #include <varargs.h> #endif #endif #include "tiffio.h"/   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %rO %                                                                             % O %                                                                             %nO %  R e a d T I F F I m a g e                                                  %rO %                                                                             %DO %                                                                             %"O %                                                                             %xO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % G %  Function ReadTIFFImage reads a Tagged image file and returns it.  ItdK %  allocates the memory necessary for the new Image structure and returns ae %  pointer to the new image. %s. %  The format of the ReadTIFFImage routine is: % & %      image=ReadTIFFImage(image_info) % + %  A description of each parameter follows:e % J %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %t %= */  5 static void TIFFWarningMessage(module,format,warning) 
 const char
   *module,
   *format;   va_listr
   warning; {    char     message[MaxTextLength];i     register chare     *p;      p=message;   if (module != (char *) NULL)     {-&       (void) sprintf(p,"%s: ",module);       p+=strlen(message);+     }x   vsprintf(p,format,warning);    strcat(p,".");!   Warning(message,(char *) NULL);h }a  ' static Image *ReadTIFFImage(image_info)u	 ImageInfor   *image_info; {s   char
     *comment;m     Images     *image;s     intr
     range;  	   Quantum 	     blue,l
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;o     register unsigned char     *p;      TIFF
     *tiff;     uint16     extra_samples,     *sample_info;(     unsigned charh     *scanline;     unsigned int     height,c     method,m     packets,     status,o
     width;     unsigned short     bits_per_sample,
     index,     max_sample_value,a     min_sample_value,2     photometric,     samples_per_pixel,
     value;     /*     Allocate image structure.+   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image.    */-   OpenImage(image_info,image,ReadBinaryType);v#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);),   if ((image->file == stdin) || image->pipe)     {m
       FILE         *file;  	       intd
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);7       file=fopen(image_info->filename,WriteBinaryType);         if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);       c=fgetc(image->file);        while (c != EOF)       {f         (void) putc(c,file);         c=fgetc(image->file);        }s       (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     })   CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);0   tiff=TIFFOpen(image->filename,ReadBinaryType);   if (tiff == (TIFF *) NULL)/     PrematureExit("Unable to open file",image);c    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)c     {c        image->scene++;&        status=TIFFReadDirectory(tiff);        if (status == False) 8          PrematureExit("Unable to read subimage",image);     }    do   {      if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width);)3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height); G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value); A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric);rK     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel); E     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&image->units);nI     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&image->x_resolution);LI     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&image->y_resolution);      /*5       Allocate memory for the image and pixel buffer.-     */     image->columns=width;      image->rows=height;m     image->depth=QuantumDepth;     if (bits_per_sample <= 8)g       image->depth=8;x     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1);      if (bits_per_sample == 1)a9       packets=Max((image->columns*image->rows+8) >> 4,1);iN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)       {          TIFFClose(tiff);9         PrematureExit("Unable to allocate memory",image);l       }>     comment=(char *) NULL;9     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&comment); !     if (comment != (char *) NULL) $       if ((int) strlen(comment) > 4)	         {e"           image->comments=(char *)D             malloc((unsigned int) (strlen(comment)+1)*sizeof(char));/           if (image->comments == (char *) NULL)a
             {                TIFFClose(tiff);?               PrematureExit("Unable to allocate memory",image);c
             }t1           (void) strcpy(image->comments,comment); 	         }D,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;      q=image->pixels;     q->length=MaxRunlength;f
     method=0;a5     if ((samples_per_pixel > 1) || TIFFIsTiled(tiff))u       {          method=2;iI         if ((samples_per_pixel >= 3) && (photometric == PHOTOMETRIC_RGB))            method=1;4       }      switch (method)0     {i
       case 0:)       {a         Quantum            *quantum_scanline;           register Quantum
           *r;=  
         /*7           Convert TIFF image to PseudoClass MIFF image. 
         */!         image->class=PseudoClass;          image->colors=range+1;'         image->colormap=(ColorPacket *)24           malloc(image->colors*sizeof(ColorPacket));C         quantum_scanline=(Quantum *) malloc(width*sizeof(Quantum));fD         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff)+1);8         if ((image->colormap == (ColorPacket *) NULL) ||5             (quantum_scanline == (Quantum *) NULL) ||&1             (scanline == (unsigned char *) NULL))            {e             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);e           }a
         /*           Create colormap.
         */         switch (photometric)	         { &           case PHOTOMETRIC_MINISBLACK:           { -             for (i=0; i < image->colors; i++) 
             { 6               image->colormap[i].red=(MaxRGB*i)/range;8               image->colormap[i].green=(MaxRGB*i)/range;7               image->colormap[i].blue=(MaxRGB*i)/range;n
             }n             break;           }x&           case PHOTOMETRIC_MINISWHITE:           {o-             for (i=0; i < image->colors; i++)r
             {)>               image->colormap[i].red=((range-i)*MaxRGB)/range;@               image->colormap[i].green=((range-i)*MaxRGB)/range;?               image->colormap[i].blue=((range-i)*MaxRGB)/range;;
             }c             break;           }e#           case PHOTOMETRIC_PALETTE:C           {              unsigned short               *blue_colormap,b               *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,                &blue_colormap);-             for (i=0; i < image->colors; i++)r
             {t3               image->colormap[i].red=(unsigned int) 0                 (red_colormap[i]*MaxRGB)/65535L;5               image->colormap[i].green=(unsigned int)a2                 (green_colormap[i]*MaxRGB)/65535L;4               image->colormap[i].blue=(unsigned int)1                 (blue_colormap[i]*MaxRGB)/65535L;%
             }%             break;           }            default:             break;	         } 
         /*A           Convert image to PseudoClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         { 7           TIFFReadScanline(tiff,(char *) scanline,y,0);e           p=scanline;            r=quantum_scanline; "           switch (bits_per_sample)           {              case 1: 
             {                register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }r#               if ((width % 8) != 0)n                 {I<                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }i               break;
             }              case 2:h
             {o2               for (x=0; x < ((int) width-3); x+=4)               {h%                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3;y%                 *r++=(*p >> 2) & 0x3;t                  *r++=(*p) & 0x3;                 p++;               }r#               if ((width % 4) != 0)e                 {f6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }              case 4: 
             {h2               for (x=0; x < ((int) width-1); x+=2)               {l%                 *r++=(*p >> 4) & 0xf;e                  *r++=(*p) & 0xf;                 p++;               }a#               if ((width % 2) != 0) '                 *r++=(*p++ >> 4) & 0xf;                break;
             }              case 8: 
             {o'               for (x=0; x < width; x++)                  *r++=(*p++);               break;
             }i             case 16:
             {i0               for (x=0; x < image->columns; x++)               { "                 ReadQuantum(*r,p);                 r++;               }                break;
             }f             default:               break;           }            /*$             Transfer image scanline.           */           r=quantum_scanline;l,           for (x=0; x < image->columns; x++)           {e             index=(*r++);mH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {P(                 if (image->packets != 0)                   q++;!                 image->packets++;r.                 if (image->packets == packets)                   {c                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));)B                     if (image->pixels == (RunlengthPacket *) NULL)                       {t0                         free((char *) scanline);8                         free((char *) quantum_scanline);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);u                       }a5                     q=image->pixels+image->packets-1;                    }m                 q->index=index;e                 q->length=0;               }h           }m7           ProgressMonitor(LoadImageText,y,image->rows); 	         }c          free((char *) scanline);(         free((char *) quantum_scanline);(         if (image->class == PseudoClass)           {              SyncImage(image);l$             CompressColormap(image);           }i         break;       } 
       case 1:(       {o
         /*7           Convert TIFF image to DirectClass MIFF image.,
         */K         scanline=(unsigned char *) malloc((TIFFScanlineSize(tiff) << 1)+1);+/         if (scanline == (unsigned char *) NULL)*           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);-           }RG         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,D           &sample_info);         image->matte=aO           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));p'         for (y=0; y < image->rows; y++))	         { 7           TIFFReadScanline(tiff,(char *) scanline,y,0); #           if (bits_per_sample == 4) 
             {-$               register unsigned char                 *r;_  +               width=TIFFScanlineSize(tiff);u!               p=scanline+width-1;s(               r=scanline+(width << 1)-1;-               for (x=0; x < (int) width; x++)                {p'                 *r--=((*p) & 0xf) << 4;s,                 *r--=((*p >> 4) & 0xf) << 4;                 p--;               }c
             }0           p=scanline; ,           for (x=0; x < image->columns; x++)           {              ReadQuantum(red,p);&!             ReadQuantum(green,p);g              ReadQuantum(blue,p);             index=0;             if (image->matte) #               ReadQuantum(index,p);aN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {,                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       {g(                         TIFFClose(tiff);0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);l                       }a5                     q=image->pixels+image->packets-1;                    }l                 q->red=red;                  q->green=green;G                 q->blue=blue;[                 q->index=index;g                 q->length=0;               }-           }r7           ProgressMonitor(LoadImageText,y,image->rows); 	         }c          free((char *) scanline);         break;       }o
       case 2:        default:       {i         register uint32 
           *p,/           *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,m           &sample_info);         image->matte= O           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));n         pixels=(uint32 *);M           malloc((image->columns*image->rows+image->columns)*sizeof(uint32));i&         if (pixels == (uint32 *) NULL)           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);g           } K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);          if (status == False)           { "             free((char *) pixels);             TIFFClose(tiff);8             PrematureExit("Unable to read image",image);           } 
         /*A           Convert image to DirectClass runlength-encoded packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         {e$           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           {x&             red=UpScale(TIFFGetR(*p));(             green=UpScale(TIFFGetG(*p));'             blue=UpScale(TIFFGetB(*p)); E             index=(unsigned short) (image->matte ? TIFFGetA(*p) : 0); N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;e.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));gB                     if (image->pixels == (RunlengthPacket *) NULL)                       {z.                         free((char *) pixels);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);*                       }s5                     q=image->pixels+image->packets-1;r                   }c                 q->red=red;                  q->green=green;t                 q->blue=blue;y                 q->index=index;                  q->length=0;               }_             p++;           }eC           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }1         free((char *) pixels);!         if (IsPseudoClass(image));J           QuantizeImage(image,(unsigned int) range,8,False,RGBColorspace);         break;       }t     } %     image->pixels=(RunlengthPacket *)*M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));      /*       Proceed to next image.     */"     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;#     status=TIFFReadDirectory(tiff);      if (status == True)        { 
         /*#           Allocate image structure.e
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {(!             DestroyImages(image);r#             return((Image *) NULL);            })B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True);0   TIFFClose(tiff);   if (image->temporary) (     (void) unlink(image_info->filename);+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else ' static Image *ReadTIFFImage(image_info)0	 ImageInfo    *image_info; { @   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif + /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %+O %                                                                             %aO %                                                                             %/O %  R e a d T I L E I m a g e                                                  % O %                                                                             %lO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadTILEImage tiles a texture on an image.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.R %e. %  The format of the ReadTILEImage routine is: %l& %      image=ReadTILEImage(image_info) % + %  A description of each parameter follows:h %*J %    o image:  Function ReadTILEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.% % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadTILEImage(image_info)o	 ImageInfo,   *image_info; {    Image      *image,m     *tiled_image;      ints     x,     y;     unsigned int     height,g
     width;  $   tiled_image=ReadImage(image_info);$   if (tiled_image == (Image *) NULL)     return((Image *) NULL);    /*     Allocate image structure.*   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);i   /*-     Determine width and height, e.g. 640x512.)   */   width=512;
   height=512;)(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);m   /*     Initialize Image structure.(   */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;m   image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)m3     malloc(image->packets*sizeof(RunlengthPacket));e0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Tile texture onto image.   */)   ProgressMonitor(LoadImageText,200,400);I2   for (y=0; y < image->rows; y+=tiled_image->rows):     for (x=0; x < image->columns; x+=tiled_image->columns)?       CompositeImage(image,ReplaceCompositeOp,tiled_image,x,y); )   ProgressMonitor(LoadImageText,400,400);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d U Y V Y I m a g e                                                  % O %                                                                             % O %                                                                             %%O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%N % I %  Function ReadUYVYImage reads an image in the UYVY (16bit/pixel) formatmG %  and returns it.  It allocates the memory necessary for the new Images4 %  structure and returns a pointer to the new image. %F- %  The format of the ReadYUVImage routine is:m % & %      image=ReadUYVYImage(image_info) %t+ %  A description of each parameter follows:  %iI %    o image:  Function ReadYUVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.n %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %v %, */' static Image *ReadUYVYImage(image_info)a	 ImageInfo]   *image_info; {f   Imagea     *image;      intE     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;,     unsigned char/     *uyvy_pixels;f     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */6   (void) strcpy(image->filename,image_info->filename);-   OpenImage(image_info,image,ReadBinaryType);m#   if (image->file == (FILE *) NULL)m.     PrematureExit("Unable to open file",image)   /*-     Determine width and height, e.g. 640x512.f   */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);t   for (i=0; i < x; i++)e     (void) fgetc(image->file);   /*     Read data.   */   image->columns=width;a   image->rows=height;e,   image->packets=image->columns*image->rows;   uyvy_pixels=(unsigned char *)>3     malloc((2*width*height)*sizeof(unsigned char));p#   image->pixels=(RunlengthPacket *)p3     malloc(image->packets*sizeof(RunlengthPacket));c0   if ((uyvy_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image); E   (void) ReadData((char *) uyvy_pixels,1,2*width*height,image->file);=   /*0     Accumulate UYVY, then upack into two pixels.   */   p=uyvy_pixels;   q=image->pixels;+   for (i=0; i < (image->packets >> 1); i++)d   {e     q->red=UpScale(p[1]);      q->green=UpScale(p[0]);f     q->blue=UpScale(p[2]);     q->index=0;l     q->length=0;     q++;     q->red=UpScale(p[3]);      q->green=UpScale(p[0]);      q->blue=UpScale(p[2]);     q->index=0;e     q->length=0;     q++;	     p+=4;      if (QuantumTick(i,image)) ;       ProgressMonitor(LoadImageText,i,image->packets >> 1);0   }    free((char *) uyvy_pixels);o+   TransformRGBImage(image,YCbCrColorspace);u   CompressImage(image);    return(image); }s   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %fO %                                                                             %oO %                                                                             %oO %   R e a d V I C A R I m a g e                                               %uO %                                                                             %)O %                                                                             %sO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f % G %  Function ReadVICARImage reads a VICAR image file and returns it.  ItlK %  allocates the memory necessary for the new Image structure and returns at %  pointer to the new image. %(/ %  The format of the ReadVICARImage routine is:  %i' %      image=ReadVICARImage(image_info)  %e+ %  A description of each parameter follows:; % J %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or ifa  %      the image cannot be read. %e9 %    o filename: Specifies the name of the image to read.m %_ %o */( static Image *ReadVICARImage(image_info)	 ImageInfos   *image_info; {t   char     keyword[MaxTextLength],v     value[MaxTextLength];L     Image,     *image;_     inti     c,     y;     long
     count;     register int     i,     x;     register RunlengthPacket     *q;      register unsigned char     *p;f     unsigned charh     *vicar_pixels;     unsigned int     header_length,     status,e     value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);r   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);f#   if (image->file == (FILE *) NULL)i/     PrematureExit("Unable to open file",image);m   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {t       DestroyImage(image);       return((Image *) NULL);f     }d   header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))e   {;     if (!isalnum(c))       {m         c=fgetc(image->file);          count++;       }a     else       {a         register char-
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         {i.           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);L           count++;+         } while (isalnum(c) || (c == '_'));i         *p='\0';         value_expected=False;L(         while (isspace(c) || (c == '='))	         {l           if (c == '=')g              value_expected=True;           c=fgetc(image->file);i           count++;	         } $         if (value_expected == False)           continue;)         p=value;         while (isalnum(c))	         {g,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);%           count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0) 3           header_length=(unsigned int) atoi(value); +         if (strcmp(keyword,"LBLSIZE") == 0)a3           header_length=(unsigned int) atoi(value); 0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0) 1           image->rows=(unsigned int) atoi(value);%&         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);n       }c     while (isspace(c))     {e       c=fgetc(image->file);c       count++;     }r   }    /*      Read the rest of the header.   */   while (count < header_length)e   {a     c=fgetc(image->file);i     count++;   }i   /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0).     PrematureExit("image size is zero",image);   /*     Create linear colormap.s   */   image->class=PseudoClass;o   image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++);   { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);(   }_   /*     Initialize image structure.m   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)B3     malloc(image->packets*sizeof(RunlengthPacket));LN   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL)) 5     PrematureExit("Unable to read image data",image);)   /*6     Convert VICAR pixels to runlength-encoded packets.   */F   status=ReadData((char *) vicar_pixels,1,image->packets,image->file);   if (status == False);     PrematureExit("Insufficient image data in file",image);m   /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;a   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {i#       q->index=(unsigned short) *p;t       q->length=0;
       p++;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);a   }    free((char *) vicar_pixels);   SyncImage(image);g   CompressColormap(image);   CompressImage(image);I   CloseImage(image);   return(image); }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d V I D I m a g e                                                    %eO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%L %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Imagea4 %  structure and returns a pointer to the new image. %(- %  The format of the ReadVIDImage routine is:- % % %      image=ReadVIDImage(image_info)  %n+ %  A description of each parameter follows:  % I %    o image:  Function ReadVIDImage returns a pointer to the image aftereL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.s %tA %    o image_info: Specifies a pointer to an ImageInfo structure.: %e %i */& static Image *ReadVIDImage(image_info)	 ImageInfot   *image_info; {I #define ClientName  "montage"      char     **filelist,      **list,      *resource_value;  	   Display 
     *display;t     Image      *image, 
     **images;R     ImageInfo      local_info;_     int      number_files;n     register int     i,     j;     XMontageInfo     montage_info;i     XResourceInfoi     resource_info;  
   XrmDatabase;     resource_database;     /*     Expand the filename.   */(   list=(char **) malloc(sizeof(char *));   if (list == (char **) NULL)g     {m7       Warning("Memory allocation error",(char *) NULL);n       return((Image *) NULL);(     }n:   list[0]=(char *) malloc(strlen(image_info->filename)+1);   if (list[0] == (char *) NULL)o     {i7       Warning("Memory allocation error",(char *) NULL);/       return((Image *) NULL);s     }n.   (void) strcpy(list[0],image_info->filename);   number_files=1;    filelist=list;+   ExpandFilenames(&number_files,&filelist);    if (number_files == 0)     { =       Warning("VID translation failed",image_info->filename);*       return((Image *) NULL);d     })   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));     if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL); &       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);)       free((char *) filelist);       return((Image *) NULL);r     }r   /*     Open X server connection.    */7   resource_info.background_color=DefaultTileBackground;e/   resource_info.border_color=DefaultTileBorder;w:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground;a&   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry;e-   resource_info.matte_color=DefaultTileMatte;;$   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {i       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);n       /*3         Get user defaults from X resource database.i       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground);)D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground);nJ       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database,o2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);a     }    /*/     Read each image and convert them to a tile.l   */   j=0;"   for (i=0; i < number_files; i++)   {l     local_info=(*image_info);T)     if (local_info.size == (char *) NULL)l3       local_info.size=resource_info.image_geometry;i$     local_info.filename=filelist[i];     *local_info.magick='\0';!     image=ReadImage(&local_info);r     free((char *) filelist[i]);,      if (image == (Image *) NULL)       continue;L     image->scene=j;      LabelImage(image,"%f");rF     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)(       DescribeImage(image,stderr,False);     images[j]=image;     j++;2     ProgressMonitor(LoadImageText,i,number_files);   }e   free((char *) filelist);   /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);d   montage_info.number_tiles=j;   image=(Image *) NULL;[%   if (montage_info.number_tiles != 0) 
     image=N       XMontageImage(images,&resource_info,&montage_info,image_info->filename);   free((char *) images);   if (image == (Image *) NULL)     {s=       Warning("VID translation failed",image_info->filename);i       return((Image *) NULL);w     }    free((char *) list[0]);l   free((char *) list);   return(image); }, n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %gO %                                                                             % O %                                                                             %pO %   R e a d V I F F I m a g e                                                 % O %                                                                             %gO %                                                                             %iO %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %cM %  Function ReadVIFFImage reads a Khoros Visualization image file and returnsnI %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. % . %  The format of the ReadVIFFImage routine is: %d& %      image=ReadVIFFImage(image_info) % + %  A description of each parameter follows:d % I %    o image: Function ReadVIFFImage returns a pointer to the image afterlO %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.h %  %  */' static Image *ReadVIFFImage(image_info)m	 ImageInfo=   *image_info; {  #define VFF_CM_genericRGB  15  #define VFF_CM_ntscRGB  1* #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4- #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1  #define VFF_TYP_2_BYTE  2r #define VFF_TYP_4_BYTE  4g     typedef struct _ViffHeader   {l     unsigned char        identifier,        file_type,       release,       version,       machine_dependency,(       reserve[3];g       char       comment[512];l       unsigned longn       rows,        columns,       subrows;       long       x_offset,        y_offset;   	     float        x_pixel_size,g       y_pixel_size;        unsigned longu       location_type,       location_dimension,o       number_of_images,u       number_data_bands,       data_storage_type,       data_encode_scheme,        map_scheme,        map_storage_type,r       map_rows,        map_columns,       map_subrows,       map_enable,        maps_per_cycle,f       color_space_model;   } ViffHeader;1     Image      *image;      register int     bit,     i,     x,     y;     register Quantum     *p;u     register RunlengthPacket     *q;      unsigned chari     buffer[7],     *viff_pixels;+     unsigned int     bytes_per_pixel,     status;      unsigned long      packets;     ViffHeader     viff_header;     /*     Allocate image structure.t   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);0   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);=   /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {w     /*       Verify VIFF identifier.      */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))/       PrematureExit("Not a VIFF raster",image);u     /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file); $     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3]; D     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';.     if ((int) strlen(viff_header.comment) > 4)       {>          image->comments=(char *)N           malloc((unsigned int) (strlen(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL) ;           PrematureExit("Unable to allocate memory",image);o;         (void) strcpy(image->comments,viff_header.comment);        } ?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || <         (viff_header.machine_dependency == VFF_DEP_NSORDER))       { 7         viff_header.rows=LSBFirstReadLong(image->file);.:         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);;         viff_header.x_offset=LSBFirstReadLong(image->file); ;         viff_header.y_offset=LSBFirstReadLong(image->file); G         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file);k@         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file); C         viff_header.number_of_images=LSBFirstReadLong(image->file); D         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file); =         viff_header.map_scheme=LSBFirstReadLong(image->file);pC         viff_header.map_storage_type=LSBFirstReadLong(image->file); ;         viff_header.map_rows=LSBFirstReadLong(image->file);g>         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file);PA         viff_header.maps_per_cycle=LSBFirstReadLong(image->file);rD         viff_header.color_space_model=LSBFirstReadLong(image->file);       }      else       {T7         viff_header.rows=MSBFirstReadLong(image->file); :         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);;         viff_header.x_offset=MSBFirstReadLong(image->file); ;         viff_header.y_offset=MSBFirstReadLong(image->file); G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file);x@         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file);iC         viff_header.number_of_images=MSBFirstReadLong(image->file);aD         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file);g=         viff_header.map_scheme=MSBFirstReadLong(image->file); C         viff_header.map_storage_type=MSBFirstReadLong(image->file); ;         viff_header.map_rows=MSBFirstReadLong(image->file);.>         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=MSBFirstReadLong(image->file);vD         viff_header.color_space_model=MSBFirstReadLong(image->file);       }g     for (i=0; i < 420; i++)=        (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)G       PrematureExit("Image column or row size is not supported",image);(9     if ((viff_header.data_storage_type != VFF_TYP_BIT) && <         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))@       PrematureExit("Data storage type is not supported",image);6     if (viff_header.data_encode_scheme != VFF_DES_RAW)C       PrematureExit("Data encoding scheme is not supported",image);f<     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))?       PrematureExit("Map storage type is not supported",image); 9     if ((viff_header.color_space_model != VFF_CM_NONE) && <         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB)) ?       PrematureExit("Colorspace model is not supported",image); 6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       { B         Warning("Location type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);        } *     if (viff_header.number_of_images != 1)?       PrematureExit("Number of images is not supported",image);%#     switch (viff_header.map_scheme)%     {        case VFF_MS_NONE:a       {a.         if (viff_header.number_data_bands < 3)           {              /*'               Create linear color ramp.r             */=             if (viff_header.data_storage_type == VFF_TYP_BIT)n               image->colors=2;             elseN               image->colors=1 << (viff_header.number_data_bands*QuantumDepth);+             image->colormap=(ColorPacket *)f8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image);s-             for (i=0; i < image->colors; i++)N
             {bB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);-
             }f           }          break;       }(       case VFF_MS_ONEPERBAND:e       case VFF_MS_SHARED:        {          unsigned char            *viff_colormap;   
         /*$           Read VIFF raster colormap.
         */.         image->colors=viff_header.map_columns;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *)e6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL));           PrematureExit("Unable to allocate memory",image);=L         (void) ReadData((char *) viff_colormap,1,image->colors,image->file);)         for (i=0; i < image->colors; i++) 	         { ;           image->colormap[i].red=UpScale(viff_colormap[i]); =           image->colormap[i].green=UpScale(viff_colormap[i]); <           image->colormap[i].blue=UpScale(viff_colormap[i]);	         } %         if (viff_header.map_rows > 1)=           {fP             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)hA               image->colormap[i].green=UpScale(viff_colormap[i]);e           })%         if (viff_header.map_rows > 2)            { P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)e@               image->colormap[i].blue=UpScale(viff_colormap[i]);           }t%         free((char *) viff_colormap);          break;       }h       default:>         PrematureExit("Colormap type is not supported",image);     }g     /*       Allocate VIFF pixels.      */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT) >       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands;L!     viff_pixels=(unsigned char *) 6       malloc(bytes_per_pixel*packets*sizeof(Quantum));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image); P     (void) ReadData((char *) viff_pixels,bytes_per_pixel,(unsigned int) packets,       image->file); *     switch (viff_header.data_storage_type)     {)	       intr         max_value,         min_value,         value;         register Quantum         *q;          unsigned long>         scale_factor;=         case VFF_TYP_1_BYTE:       {0         register unsigned char
           *p;            if (QuantumDepth == 8)           break;
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=viff_pixels;"         q=(Quantum *) viff_pixels;         p+=packets-1;e         q+=packets-1;)#         for (i=0; i < packets; i++)|	         {            value=UpScale(*p);           *q=(Quantum) value;,           p--;           q--;	         }          break;       }l       case VFF_TYP_2_BYTE:       {          register short int
           *p;r  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||1@             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header,e6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor.+
         */$         p=(short int *) viff_pixels;         max_value=(*p);s         min_value=(*p); #         for (i=0; i < packets; i++)c	         {)           if (*p > max_value)l             max_value=(*p);            else             if (*p < min_value)                min_value=(*p);            p++;	         }c1         if ((min_value == 0) && (max_value == 0))            scale_factor=0;e         else%           if (min_value == max_value)c
             {=5               scale_factor=UpShift(MaxRGB)/min_value;l               min_value=0;
             }            else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);r
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)(	         {e7           value=DownShift((*p-min_value)*scale_factor);(           if (value > MaxRGB)              value=MaxRGB;a           else             if (value < 0)               value=0;           *q=(Quantum) value;            p++;           q++;	         }x         break;       }o       case VFF_TYP_4_BYTE:       {/         register int
           *p;a  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||+@             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor.w
         */         p=(int *) viff_pixels;         max_value=(*p);          min_value=(*p);r#         for (i=0; i < packets; i++)/	         {o           if (*p > max_value)              max_value=(*p);0           else             if (*p < min_value)                min_value=(*p);            p++;	         } 1         if ((min_value == 0) && (max_value == 0))            scale_factor=0;          else%           if (min_value == max_value)m
             { 5               scale_factor=UpShift(MaxRGB)/min_value;e               min_value=0;
             }=           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value); 
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)n	         {)7           value=DownShift((*p-min_value)*scale_factor);l           if (value > MaxRGB)              value=MaxRGB;+           else             if (value < 0)               value=0;#           *q=(unsigned char) value;            p++;           q++;	         }r         break;       }x     }g     /*!       Initialize image structure.      */6     image->matte=(viff_header.number_data_bands == 4);     image->class=gF       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);$     image->columns=viff_header.rows;$     image->rows=viff_header.columns;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));x2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert VIFF raster image to runlength-encoded packets.      */     p=(Quantum *) viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)        {a         unsigned int           polarity;l  
         /*E           Convert bitmap scanline to runlength-encoded color packets.i
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++)m	         {+           /*G             Convert bitmap scanline to runlength-encoded color packets.            */3           for (x=0; x < (image->columns >> 3); x++)s           {m'             for (bit=0; bit < 8; bit++) 
             { E               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);g               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               {eG                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);(                 q->length=0;                 q++;               }                p++;
             } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }f       }      else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)M	         {)           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {+             q->index=(*p++);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);n	         }t
       else	         {            unsigned long-             offset;f             /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++)l           {e.             for (x=0; x < image->columns; x++)
             {                q->red=(*p);%               q->green=(*(p+offset)); &               q->blue=(*(p+offset*2));%               if (image->colors != 0)                  {e5                   q->red=image->colormap[q->red].red; ;                   q->green=image->colormap[q->green].green;g8                   q->blue=image->colormap[q->blue].blue;                 } M               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);                q->length=0;               p++;               q++;
             }m9             ProgressMonitor(LoadImageText,y,image->rows);            }g	         }+     free((char *) viff_pixels); $     if (image->class == PseudoClass)       {g         SyncImage(image);           CompressColormap(image);       }      CompressImage(image);      /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))        { 
         /*#           Allocate image structure.+
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);k           }(B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } A   } while ((status == True) && (viff_header.identifier == 0xab)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %eO %                                                                             % O %                                                                             %-O %   R e a d X I m a g e                                                       % O %                                                                             %fO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %e8 %  Procedure ReadXImage reads an image from an X window. %e+ %  The format of the ReadXImage routine is:  %k@ %      image=ReadXImage(image_info,frame,borders,screen,descend) % + %  A description of each parameter follows:  %lA %    o image_info: Specifies a pointer to an ImageInfo structure.n %gL %    o frame: Specifies whether to include the window manager frame with the
 %      image.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.l %mN %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specified( %      window. %gO %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWS J %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the window = %      hierarchy and reading each subwindow and its colormap.f %a %a */: Image *ReadXImage(image_info,frame,borders,screen,descend)	 ImageInfol   *image_info;   unsigned int   frame,
   borders,	   screen, 
   descend; {e
   Colormap     *colormaps;   	   Displaye
     *display;      Image      *image;S     intd     status,f     x;     RectangleInfoe     crop_info;     Window     *children,     client,L     prior_target,a	     root,      target;      XTextProperty(     window_name;     /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return((Image *) NULL);M     }n   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Select target window.    */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0;p4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL; 0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       {n
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename)) O           target=XWindowByID(display,root,(Window) strtol(image_info->filename,-             (char **) NULL,0));e$         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);u       }m     /*>     If target window is not defined, interactively select one.   */   prior_target=target;   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);f!   client=target;   /* obsolete */    if (target != root)      {(       unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {g           for ( ; ; )l           {i             Window               parent;h               /*(               Find window manager frame.             */I             status=XQueryTree(display,target,&root,&parent,&children,&d);*8             if (status && (children != (Window *) NULL))'               XFree((char *) children); I             if (!status || (parent == (Window) NULL) || (parent == root)))               break;             target=parent;           }            /*             Get client window.           *//           client=XClientWindow(display,target);            if (!frame)=             target=client;%           if (!frame && prior_target)L              target=prior_target;	         }m     } 
   if (screen)u     {g	       inta
         y;         Window         child;         XWindowAttributes>         window_attributes;         /*1         Obtain window image directly from screen.+       */E       status=XGetWindowAttributes(display,target,&window_attributes);        if (status == False)	         { M           Warning("Unable to read X window attributes",image_info->filename);;!           XCloseDisplay(display);a!           return((Image *) NULL);%	         }%B       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {            /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1; @           crop_info.height+=window_attributes.border_width << 1;	         }        target=root;     }    if (descend)     { 	       int%         number_colormaps,%         number_windows;%         /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0; M       status=XGetWMColormapWindows(display,target,&children,&number_windows);e3       if ((status == True) && (number_windows > 0))a	         {a           descend=True;d$           XFree ((char *) children);	         }oJ       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0) 	         { #           if (number_colormaps > 1)              descend=True; $           XFree((char *) colormaps);	         }e     }r   /*+     Alert the user not to alter the screen.g   */   XBell(display,0);a   /*     Get image by window id."   */   XGrabServer(display);e8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display);r   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     {c:       (void) strcpy(image->filename,image_info->filename);<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {r           Imageo             *cropped_image;e             /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {a"               DestroyImage(image);"               image=cropped_image;
             } 	         }o5       status=XGetWMName(display,target,&window_name);g       if (status == True)m	         {)8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {m               /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0';i
             }i,           XFree((void *) window_name.value);	         }      }s   /*     Alert the user we're done.   */   XBell(display,0);r   XBell(display,0);e   CompressImage(image);/   XCloseDisplay(display);;   return(image); }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %&O %  R e a d X B M I m a g e                                                    %=O %                                                                             %nO %                                                                             %oO %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % K %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  ItuK %  allocates the memory necessary for the new Image structure and returns au %  pointer to the new image. %s- %  The format of the ReadXBMImage routine is:, % % %      image=ReadXBMImage(image_info)e %)+ %  A description of each parameter follows:- % I %    o image:  Function ReadXBMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read._ %oA %    o image_info: Specifies a pointer to an ImageInfo structure.u %n %_ */& static int XBMInteger(file,hex_digits) FILE   *file;  	 short into   *hex_digits; {f   inti     c,	     flag,u
     value;  
   value=0;	   flag=0; 
   for ( ; ; )    {o     c=getc(file);;     if (c == EOF)        {c         value=(-1);          break;       }s     c&=0xff;"     if (isascii(c) && isxdigit(c))       {e)         value=(value << 4)+hex_digits[c];          flag++;)         continue;x       } $     if ((hex_digits[c]) < 0 && flag)       break;   }o   return(value); }=  & static Image *ReadXBMImage(image_info)	 ImageInfoo   *image_info; {    char     buffer[MaxTextLength],     name[MaxTextLength];     Image      *image;n     register int     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;-     register unsigned short 
     index;     short intu     hex_digits[256];     unsigned char      bit,
     *data;     unsigned int	     byte,g     bytes_per_line,f     packets,     padding,
     value,     version;     /*     Allocate image structure.k   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);y#   if (image->file == (FILE *) NULL))/     PrematureExit("Unable to open file",image);t   /*     Read X bitmap header.s   */D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)?     if (sscanf(buffer,"#define %*32s %u",&image->columns) == 1)        break;D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)<     if (sscanf(buffer,"#define %*32s %u",&image->rows) == 1)       break;   /*     Scan until hex digits.   */
   version=11;sD   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)   {e7     if (sscanf(buffer,"static short %s = {",name) == 1)N       version=10;      elseA       if (sscanf(buffer,"static unsigned char %s = {",name) == 1)i         version=11;i
       else:         if (sscanf(buffer,"static char %s = {",name) == 1)           version=11;          else           continue; *     p=(unsigned char *) strrchr(name,'_');$     if (p == (unsigned char *) NULL)       p=(unsigned char *) name;p     else
       p++;)     if (strcmp("bits[]",(char *) p) == 0)        break;   }eG   if ((image->columns == 0) || (image->rows == 0) || feof(image->file))aA     PrematureExit("XBM file is not in the correct format",image);e   /*     Initialize image structure.)   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)i3     malloc(image->packets*sizeof(RunlengthPacket));C   padding=0;O   if ((image->columns % 16) && ((image->columns % 16) < 9)  && (version == 10))      padding=1;.   bytes_per_line=(image->columns+7)/8+padding;%   packets=bytes_per_line*image->rows;pA   data=(unsigned char *) malloc(packets*sizeof(unsigned char *));i4   if ((image->pixels == (RunlengthPacket *) NULL) ||'       (data == (unsigned char *) NULL))r5     PrematureExit("Unable to allocate memory",image);(   /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    image->colormap[0].red=0;m   image->colormap[0].green=0;z   image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;(   /*     Initialize hex values.   */   hex_digits['0']=0;   hex_digits['1']=1;   hex_digits['2']=2;   hex_digits['3']=3;   hex_digits['4']=4;   hex_digits['5']=5;   hex_digits['6']=6;   hex_digits['7']=7;   hex_digits['8']=8;   hex_digits['9']=9;   hex_digits['A']=10;%   hex_digits['B']=11;    hex_digits['C']=12;    hex_digits['D']=13;    hex_digits['E']=14;    hex_digits['F']=15;    hex_digits['a']=10;    hex_digits['b']=11;    hex_digits['c']=12;E   hex_digits['d']=13;    hex_digits['e']=14;    hex_digits['f']=15;    hex_digits[' ']=(-1);    hex_digits[',']=(-1);    hex_digits['}']=(-1);    hex_digits['\n']=(-1);   hex_digits['\t']=(-1);   /*     Read hex image data.   */	   p=data;    if (version == 10)"     for (x=0; x < packets; (x+=2))     {%/       value=XBMInteger(image->file,hex_digits);%       *p++=value; /       if (!padding || ((x+2) % bytes_per_line))a         *p++=value >> 8;     }l   else     for (x=0; x < packets; x++)I     {r/       value=XBMInteger(image->file,hex_digits);.       *p++=value;      }R   /*8     Convert X bitmap image to runlength-encoded packets.   */	   p=data;    q=image->pixels;!   for (y=0; y < image->rows; y++)o   {e
     bit=0;&     for (x=0; x < image->columns; x++)     {e       if (bit == 0)g         byte=(*p++);"       index=(byte & 0x01) ? 0 : 1;       q->index=index;g       q->length=0;
       q++;       bit++;       byte>>=1;t       if (bit == 8)u         bit=0;     }c1     ProgressMonitor(LoadImageText,y,image->rows);    }a   SyncImage(image);    CompressImage(image);]   CloseImage(image);   free((char *) data);   return(image); }x m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %LO %                                                                             %pO %                                                                             %eO %  R e a d X C I m a g e                                                      %HO %                                                                             %gO %                                                                             %fO %                                                                             %RO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %aG %  Function ReadXCImage creates a constant image and initializes to the H %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the newl	 %  image.a %;, %  The format of the ReadXCImage routine is: %e$ %      image=ReadXCImage(image_info) %a+ %  A description of each parameter follows:) % H %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */% static Image *ReadXCImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      unsigned int     height, 
     width;     XColor
     color;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);%   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;%(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);s   /*     Initialize Image structure.y   */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;l   image->rows=height;tE   image->packets=((image->columns*image->rows-1)/(MaxRunlength+1))+1;r#   image->pixels=(RunlengthPacket *)_3     malloc(image->packets*sizeof(RunlengthPacket));s   image->class=PseudoClass;o   image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);t   /*     Initialize colormap.   */:   (void) XQueryColorDatabase(image_info->filename,&color);/   image->colormap[0].red=XDownScale(color.red); 3   image->colormap[0].green=XDownScale(color.green);g1   image->colormap[0].blue=XDownScale(color.blue);x   q=image->pixels;$   for (i=0; i < image->packets; i++)   {t     q->index=0;s     q->length=MaxRunlength;      q++;     if (QuantumTick(i,image))=6       ProgressMonitor(LoadImageText,i,image->packets);   }    q--;M   q->length=image->columns*image->rows-(MaxRunlength+1)*(image->packets-1)-1;a   SyncImage(image);    return(image); }( E /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %mO %                                                                             %yO %                                                                             %*O %  R e a d X P M I m a g e                                                    %fO %                                                                             % O %                                                                             %>O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %iK %  Function ReadXBMImage reads an X11 pixmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns ar %  pointer to the new image. %,- %  The format of the ReadXPMImage routine is:l %t% %      image=ReadXPMImage(image_info)D %(+ %  A description of each parameter follows:i %;I %    o image:  Function ReadXPMImage returns a pointer to the image aftertL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %;A %    o image_info: Specifies a pointer to an ImageInfo structure.0 %  %m */
 #ifdef HasXPM  #include "xpm.h"& static Image *ReadXPMImage(image_info)	 ImageInfo-   *image_info; {    char     *xpm_buffer;  	   Display-
     *display;      Imagem     *image;      int      length,p     status,      x,     y;     register char      *q;      register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     XColor     *colors;     XImage     *matte_image,G     *ximage;     XpmAttributes      xpm_attributes;0     XResourceInfoy     resource_info;  
   XrmDatabasel     resource_database;     XStandardColormapg     *map_info;  
   XVisualInfo      *visual_info;-     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);x   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read XPM file.   */   length=MaxTextLength; 2   xpm_buffer=(char *) malloc(length*sizeof(char));"   if (xpm_buffer != (char *) NULL)     {        q=xpm_buffer;mC       while (fgets(q,MaxTextLength-1,image->file) != (char *) NULL)        {          q+=strlen(q);;2         if ((q-xpm_buffer+MaxTextLength) > length)           {g             *q='\0';             length<<=1;              xpm_buffer=(char *) ?               realloc((char *) xpm_buffer,length*sizeof(char));B,             if (xpm_buffer == (char *) NULL)               break;,             q=xpm_buffer+strlen(xpm_buffer);           }        }-     }0"   if (xpm_buffer == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);0   CloseImage(image);   /*     Open X server connection.c   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {o.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name)); 8       PrematureExit("Unable to create XPM image",image);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);(   /*/     Get user defaults from X resource database.+   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);a   /*     Allocate standard colormap.i   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)%M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }%   /*     Initialize X colormap.   */-   map_info->colormap=XCreateColormap(display, A     XRootWindow(display,visual_info->screen),visual_info->visual,h>     visual_info->class == DirectColor ? AllocAll : AllocNone);,   if (map_info->colormap == (Colormap) NULL)     {RF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);7       PrematureExit("Unable to create colormap",image);      }    /*     Initialize XPM attributes.   */L   xpm_attributes.valuemask=XpmColorKey | XpmColormap | XpmDepth | XpmVisual;,   xpm_attributes.visual=visual_info->visual;-   xpm_attributes.colormap=map_info->colormap;I*   xpm_attributes.depth=visual_info->depth;%   xpm_attributes.color_key=XPM_COLOR;n   /*>     Read in a file in the XPM format into a X image structure.   */J   status=XpmCreateImageFromBuffer(display,xpm_buffer,&ximage,&matte_image,     &xpm_attributes);    if (status != XpmSuccess)p     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }    free((char *) xpm_buffer);%   XpmFreeAttributes(&xpm_attributes);p   /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {mF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to read X colormap",image);      }mO   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor)) 2     for (i=0; i < visual_info->colormap_size; i++)     {t       colors[i].pixel=i;       colors[i].pad=0;     }t   else     {l       unsigned longN
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0;hC       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1);aF       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       {m+         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit; (         if (red > visual_info->red_mask)           red=0;         green+=green_bit;;,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit;t*         if (blue > visual_info->blue_mask)           blue=0;J       }      }rM   XQueryColors(display,map_info->colormap,colors,visual_info->colormap_size);    /*#     Convert X image to MIFF format.n   */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor))      image->class=PseudoClass;    image->columns=ximage->width;a   image->rows=ximage->height;n,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)d3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {        free((char *) colors);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to allocate memory",image);i     }    p=image->pixels;   switch (image->class)    {_     case DirectClass:      {X       register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,c         green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;h       red_shift=0;$       while ((red_mask & 0x01) == 0)       {m         red_mask>>=1;R         red_shift++;       }s)       green_mask=visual_info->green_mask;c       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;;         green_shift++;       }e'       blue_mask=visual_info->blue_mask;e       blue_shift=0;e%       while ((blue_mask & 0x01) == 0)        {l         blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.t       */-       if ((visual_info->colormap_size > 0) &&a.           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green);o4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;e             p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);t	         }&
       else'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {)(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);              p->index=0;g             p->length=0;             p++;           }r7           ProgressMonitor(LoadImageText,y,image->rows);d	         }        break;     }      case PseudoClass::     {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size;=P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             free((char *) colors);J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);            XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         }v'       for (i=0; i < image->colors; i++)e       { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green);rI         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)m       {s*         for (x=0; x < image->columns; x++)	         {i:           p->index=(unsigned short) XGetPixel(ximage,x,y);           p->length=0;           p++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);        break;     }U   } %   if (matte_image != (XImage *) NULL)n     {        /*         Initialize image matte.o       */       image->class=DirectClass;;       image->matte=True;       p=image->pixels;%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         {e           p->index=Opaque;*           if (!XGetPixel(matte_image,x,y))!             p->index=Transparent;            p++;	         }-!       XDestroyImage(matte_image);      }p"   if (image->class == PseudoClass)     CompressColormap(image);   /*     Free resources.    */   free((char *) colors);   XDestroyImage(ximage);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);[   return(image); }s #else & static Image *ReadXPMImage(image_info)	 ImageInfo    *image_info; {e?   Warning("XPM library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }e #endif ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             %eO %                                                                             %;O %  R e a d X W D I m a g e                                                    % O %                                                                             % O %                                                                             %*O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. %c- %  The format of the ReadXWDImage routine is:e %o% %      image=ReadXWDImage(image_info)( %g+ %  A description of each parameter follows:  %rI %    o image:  Function ReadXWDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.a %B %/ */& static Image *ReadXWDImage(image_info)	 ImageInfon   *image_info; {>   Image;     *image;      intl     status,=     x,     y;     register int     i;     register RunlengthPacket     *q;c     register unsigned long
     pixel;     unsigned long+     lsb_first;     unsigned int     packets;     unsigned short
     index;     XColor     *colors;     XImage     *ximage;     XWDFileHeader      header;-     /*     Allocate image structure.;   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);r#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);)   /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);    if (status == False);     PrematureExit("Unable to read dump file header",image);    /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first);5     MSBFirstOrderLong((char *) &header,sz_XWDheader);g   /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)<     PrematureExit("XWD file format version mismatch",image);(   if (header.header_size < sz_XWDheader)8     PrematureExit("XWD header size is too small",image);,   packets=(header.header_size-sz_XWDheader);<   image->comments=(char *) malloc((packets+1)*sizeof(char));'   if (image->comments == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image);oB   status=ReadData((char *) image->comments,1,packets,image->file);    image->comments[packets]='\0';   if (status == False)F     PrematureExit("Unable to  read window name from dump file",image);   /*     Initialize the X image.x   */+   ximage=(XImage *) malloc(sizeof(XImage));t    if (ximage == (XImage *) NULL)5     PrematureExit("Unable to allocate memory",image);,$   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;    ximage->data=(char *) NULL;s$   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad;*/   ximage->bytes_per_line=header.bytes_per_line; '   ximage->byte_order=header.byte_order;c)   ximage->bitmap_unit=header.bitmap_unit;c3   ximage->bitmap_bit_order=header.bitmap_bit_order;,/   ximage->bits_per_pixel=header.bits_per_pixel;r#   ximage->red_mask=header.red_mask; '   ximage->green_mask=header.green_mask; %   ximage->blue_mask=header.blue_mask;m   status=XInitImage(ximage);   if (status == False).     PrematureExit("Invalid XWD header",image);   /*     Read colormap.   */   colors=(XColor *) NULL;N   if (header.ncolors != 0)     {)       XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor));-$       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image); (       for (i=0; i < header.ncolors; i++)       {1C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);          if (status == False)I           PrematureExit("Unable to read color map from dump file",image);%$         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first) *         for (i=0; i < header.ncolors; i++)	         { M           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long)); O           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short)); 	         }      }    /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);n6   status=ReadData(ximage->data,1,packets,image->file);   if (status == False)6     PrematureExit("Unable to read dump pixmap",image);   /*!     Convert image to MIFF format.e   */   image->columns=ximage->width;t   image->rows=ximage->height;o?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) ||i<       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;k   else     image->class=PseudoClass;s   image->colors=header.ncolors;a   image->packets=0;i5   packets=Max((image->columns*image->rows+4) >> 3,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    q=image->pixels;   q->length=MaxRunlength;k   switch (image->class)    {      case DirectClass:      {        register unsigned long         color;         unsigned int
         blue,c         green,         red;         unsigned longe         blue_mask,         blue_shift,          green_mask,o         green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {c         red_mask>>=1;;         red_shift++;       } $       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {R         green_mask>>=1;          green_shift++;       }p"       blue_mask=ximage->blue_mask;       blue_shift=0;l%       while ((blue_mask & 0x01) == 0)=       {m         blue_mask>>=1;         blue_shift++;)       }u       /*/         Convert X image to DirectClass packets.p       */       if (image->colors != 0);'         for (y=0; y < image->rows; y++) 	         {E,           for (x=0; x < image->columns; x++)           {e(             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask);t.             red=XDownScale(colors[index].red);I             index=(unsigned short) ((pixel >> green_shift) & green_mask);t2             green=XDownScale(colors[index].green);G             index=(unsigned short) ((pixel >> blue_shift) & blue_mask); 0             blue=XDownScale(colors[index].blue);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))f               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;i.                 if (image->packets == packets)                   {i                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));xB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);)5                     q=image->pixels+image->packets-1;,                   }s                 q->red=red;                  q->green=green;                  q->blue=blue;                  q->index=0;                  q->length=0;               }d           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }(
       else'         for (y=0; y < image->rows; y++)t	         {a,           for (x=0; x < image->columns; x++)           {t(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;4             red=XDownScale((color*65535L)/red_mask);6             color=(pixel >> green_shift) & green_mask;8             green=XDownScale((color*65535L)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;6             blue=XDownScale((color*65535L)/blue_mask);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;*.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));mB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);e5                     q=image->pixels+image->packets-1;U                   }p                 q->red=red;U                 q->green=green;                  q->blue=blue;                  q->index=0;a                 q->length=0;               }            }e7           ProgressMonitor(LoadImageText,y,image->rows);M	         }L       break;     }      case PseudoClass:t     {_       /*/         Convert X image to PseudoClass packets.]       */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)e       {&9         image->colormap[i].red=XDownScale(colors[i].red);[=         image->colormap[i].green=XDownScale(colors[i].green); ;         image->colormap[i].blue=XDownScale(colors[i].blue);        } %       for (y=0; y < image->rows; y++)h       {t*         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);           index=pixel;F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++;t,               if (image->packets == packets)                 {k                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));]@                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);r3                   q=image->pixels+image->packets-1;                  }                q->index=index;                q->length=0;
             } 	         }r5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);z       CompressColormap(image);       break;     }    }t#   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*     Free image and colormap.   */   if (header.ncolors != 0)     free((char *) colors);   free(ximage->data);c   free(ximage);    CloseImage(image);   return(image); }_ d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             % O %                                                                             %sO %  R e a d Y U V I m a g e                                                    %iO %                                                                             %eO %                                                                             %eO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %rO %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytes G %  and returns it.  It allocates the memory necessary for the new ImageG4 %  structure and returns a pointer to the new image. % - %  The format of the ReadYUVImage routine is:  % % %      image=ReadYUVImage(image_info)- %w+ %  A description of each parameter follows:x % I %    o image:  Function ReadYUVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadYUVImage(image_info)	 ImageInfo    *image_info; {l   Image      *image,n     *zoomed_image;     int;     x,     y;     register int     i;     register RunlengthPacket     *q;s     register unsigned char     *p;=     unsigned char-     *yuv_pixels;     unsigned int     height,e
     width;     /*     Allocate image structure.c   */)   zoomed_image=AllocateImage(image_info);t%   if (zoomed_image == (Image *) NULL)g     return((Image *) NULL);m   /*     Open image file.   */=   (void) strcpy(zoomed_image->filename,image_info->filename); 4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)m   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;r   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);g   for (i=0; i < x; i++) %     (void) fgetc(zoomed_image->file);)   /*     Read Y channel.x   */#   zoomed_image->columns=width >> 1; !   zoomed_image->rows=height >> 1; A   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;    yuv_pixels=(unsigned char *)7     malloc((3*(width*height)/2)*sizeof(unsigned char));p*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));/   if ((yuv_pixels == (unsigned char *) NULL) ||09       (zoomed_image->pixels == (RunlengthPacket *) NULL))u<     PrematureExit("Unable to allocate memory",zoomed_image);O   (void) ReadData((char *) yuv_pixels,1,3*(width*height)/2,zoomed_image->file);I   /*     Initialize U channel.n   */   p=yuv_pixels+(width*height);   q=zoomed_image->pixels;x+   for (i=0; i < zoomed_image->packets; i++)m   {n     q->green=UpScale(*p);      q->index=0;s     q->length=0;     p++;     q++;   }p   /*     Initialize V channel.g   */)   ProgressMonitor(LoadImageText,100,400);=   q=zoomed_image->pixels;>+   for (i=0; i < zoomed_image->packets; i++)-   {i     q->blue=UpScale(*p);     p++;     q++;   }    /*     Scale image.   */)   ProgressMonitor(LoadImageText,250,400);%   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);    zoomed_image->orphan=False;    CloseImage(zoomed_image);    DestroyImage(zoomed_image);    if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=yuv_pixels;a   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {      q->red=UpScale(*p);      p++;     q++;   }    free((char *) yuv_pixels);+   TransformRGBImage(image,YCbCrColorspace);    CompressImage(image); )   ProgressMonitor(LoadImageText,400,400);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d Y U V 3 I m a g e                                                  %tO %                                                                             %mO %                                                                             %tO %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %)J %  Function ReadYUV3Image reads an image with digital YUV (CCIR 601 2:1:1)M %  bytes and returns it.  It allocates the memory necessary for the new ImagenK %  structure and returns a pointer to the new image.  This function differs J %  from ReadYUVImage in that it reads the Y, U, and V planes from separate) %  files (image.Y, image.U, and image.V).; % . %  The format of the ReadYUV3Image routine is: %r& %      image=ReadYUV3Image(image_info) % + %  A description of each parameter follows:t %uJ %    o image:  Function ReadYUV3Image returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %gA %    o image_info: Specifies a pointer to an ImageInfo structure.e %n %m */' static Image *ReadYUV3Image(image_info) 	 ImageInfom   *image_info; {e   char     filename[MaxTextLength];     Image      *image,r     *zoomed_image;     inti     x,     y;     register int     i;     register RunlengthPacket     *q;s     register unsigned char     *p;      unsigned chary     *uv_pixels,      *y_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.e   */)   zoomed_image=AllocateImage(image_info);f%   if (zoomed_image == (Image *) NULL)e     return((Image *) NULL);_   /*     Open image file.   *//   (void) strcpy(filename,image_info->filename);g1   (void) strcpy(zoomed_image->filename,filename);g.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".Y");M4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)r   /*-     Determine width and height, e.g. 640x512.a   */   width=512;
   height=512;m   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);s   for (i=0; i < x; i++) %     (void) fgetc(zoomed_image->file);c   /*     Read Y channel.    */#   zoomed_image->columns=width >> 1;m!   zoomed_image->rows=height >> 1;mA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;]   uv_pixels=(unsigned char *)18     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL)) <     PrematureExit("Unable to allocate memory",zoomed_image);P   (void) ReadData((char *) y_pixels,4,zoomed_image->packets,zoomed_image->file);   CloseImage(zoomed_image);d   /*     Read U channel.e   */)   ProgressMonitor(LoadImageText,100,400); 1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".U");r4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image))=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,      zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;[+   for (i=0; i < zoomed_image->packets; i++)v   {R     q->green=UpScale(*p);a     q->index=0;,     q->length=0;     p++;     q++;   }-   CloseImage(zoomed_image);g   /*     Read V channel.(   */)   ProgressMonitor(LoadImageText,200,400);o1   (void) strcpy(zoomed_image->filename,filename);W.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".V");r4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)o=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,l     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;c+   for (i=0; i < zoomed_image->packets; i++)r   {e     q->blue=UpScale(*p);     p++;     q++;   }m   CloseImage(zoomed_image);m   free((char *) uv_pixels);m   /*     Scale image.   */)   ProgressMonitor(LoadImageText,300,400);(   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);    zoomed_image->orphan=False;h   CloseImage(zoomed_image);E   DestroyImage(zoomed_image);,   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); 
   p=y_pixels;)   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {m     q->red=UpScale(*p);      p++;     q++;   }    free((char *) y_pixels);+   TransformRGBImage(image,YCbCrColorspace); *   (void) strcpy(image->filename,filename);   CompressImage(image);*)   ProgressMonitor(LoadImageText,400,400);p   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.O %                                                                             %dO %                                                                             %EO %                                                                             %sO %   R e a d I m a g e                                                         % O %                                                                             %;O %                                                                             %gO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %iB %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an)M %  explicit image format name and a colon (i.e.  ps:image) or as the filenamer %  suffix  (i.e. image.ps).h %c* %  The format of the ReadImage routine is: %x" %      image=ReadImage(image_info) % + %  A description of each parameter follows:- % E %    o image: Function ReadImage returns a pointer to the image after;L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %)A %    o image_info: Specifies a pointer to an ImageInfo structure.u %  %) */ Image *ReadImage(image_info)	 ImageInfoi   *image_info; {<   char      magic_number[MaxTextLength];     Image      decode_image,      *image;      ImageInfo;     decode_info;     register char>     *p;)     register int     i;     SetImageInfo(image_info);;   decode_info=(*image_info);?   decode_image.temporary=strcmp(decode_info.magick,"TMP") == 0;c3   if ((strncmp(decode_info.magick,"FTP",3) == 0) ||w4       (strncmp(decode_info.magick,"HTTP",4) == 0) ||4       (strncmp(decode_info.magick,"GOPHER",6) == 0))     { 
       char         command[MaxTextLength],l          filename[MaxTextLength];         /*H         Retrieve image as specified with a WWW uniform resource locator.       */"       decode_image.temporary=True;"       TemporaryFilename(filename);P       (void) sprintf(command,WWWCommand,decode_info.magick,decode_info.filename,         filename);$       (void) SystemCommand(command);!       SetImageInfo(&decode_info);-3       (void) strcpy(decode_info.filename,filename);x     } J   if (!decode_info.assert || (strncmp(decode_info.magick,"SGI",3) == 0) ||1       (strncmp(decode_info.magick,"PCD",3) == 0))d     {        /*/         Determine type from image magic number.=       *//       for (i=0 ; i < sizeof(magic_number); i++)          magic_number[i]='\0';+@       (void) strcpy(decode_image.filename,decode_info.filename);9       OpenImage(image_info,&decode_image,ReadBinaryType);U-       if (decode_image.file != (FILE *) NULL)(>         if ((decode_image.file == stdin) || decode_image.pipe)           {              FILE               *file;               int                c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename);-7             decode_info.filename=decode_image.filename; >             file=fopen(decode_image.filename,WriteBinaryType);&             if (file == (FILE *) NULL)               {mE                 Warning("Unable to write file",decode_info.filename); '                 return((Image *) NULL);                }g'             c=fgetc(decode_image.file);.             while (c != EOF)
             {n"               (void) putc(c,file);)               c=fgetc(decode_image.file);*
             }o              (void) fclose(file);&             CloseImage(&decode_image);?             OpenImage(image_info,&decode_image,ReadBinaryType);            } -       if (decode_image.file != (FILE *) NULL)g	         {            /*             Read magic number.           */C           (void) ReadData(magic_number,(unsigned int) sizeof(char), C             (unsigned int) sizeof(magic_number),decode_image.file);m:           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {                register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */D               for (i=0; i < (int) (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);G               (void) ReadData(magic_number,(unsigned int) sizeof(char), G                 (unsigned int) sizeof(magic_number),decode_image.file); 
             }A$           CloseImage(&decode_image);	         }        /*#         Determine the image format.        */)       magic_number[MaxTextLength-1]='\0'; ,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");-       if (strncmp(magic_number,"IT0",3) == 0) 1         (void) strcpy(decode_info.magick,"FITS");%0       if (strncmp(magic_number,"SIMPLE",6) == 0)1         (void) strcpy(decode_info.magick,"FITS");g.       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");:       if (strncmp(magic_number,"\016\003\023\001",4) == 0)0         (void) strcpy(decode_info.magick,"HDF");2       if (strncmp(magic_number,"\001\332",2) == 0)0         (void) strcpy(decode_info.magick,"SGI");:       if (strncmp(magic_number,"\377\330\377\340",4) == 0)1         (void) strcpy(decode_info.magick,"JPEG");o9       if (strncmp(magic_number,"id=ImageMagick",14) == 0) 1         (void) strcpy(decode_info.magick,"MIFF");o.       if (strncmp(magic_number,"PCD_",4) == 0)0         (void) strcpy(decode_info.magick,"PCD");0       if ((unsigned char) *magic_number == 0x0a)0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"%!PDF",5) == 0) 0         (void) strcpy(decode_info.magick,"PDF");=       if ((*magic_number == 'P') && isdigit(magic_number[1]))e0         (void) strcpy(decode_info.magick,"PNM");;       if (strncmp(magic_number,"\211PNG\r\n\032\n",8) == 0)s0         (void) strcpy(decode_info.magick,"PNG");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS");r5       if (strncmp(magic_number,"#?RADIANCE",10) == 0) 0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");>       if ((strncmp(magic_number,"\115\115\000\052",4) == 0) ||<           (strncmp(magic_number,"\111\111\052\000",4) == 0))1         (void) strcpy(decode_info.magick,"TIFF"); 5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) ||i2           (strncmp(magic_number,"NJPL1I",6) == 0))2         (void) strcpy(decode_info.magick,"VICAR");0       if ((unsigned char) *magic_number == 0xab)1         (void) strcpy(decode_info.magick,"VIFF");t!       p=strchr(magic_number,'#');_       if (p != (char *) NULL)_(         if (strncmp(p,"#define",7) == 0)2           (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0)t0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00))dC         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00))lE           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07))i4             (void) strcpy(decode_info.magick,"XWD");     }h   /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   {s
     case 'A':e     {;0       if (strcmp(decode_info.magick,"AVS") == 0)	         { +           image=ReadAVSImage(&decode_info);            break;	         }((       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'B':m     {a0       if (strcmp(decode_info.magick,"BIE") == 0)	         {t,           image=ReadJBIGImage(&decode_info);           break;	         }m0       if (strcmp(decode_info.magick,"BMP") == 0)	         {l+           image=ReadBMPImage(&decode_info);            break;	         }l(       image=ReadMIFFImage(&decode_info);       break;     }e
     case 'C':      {(1       if (strcmp(decode_info.magick,"CMYK") == 0) 	         { ,           image=ReadCMYKImage(&decode_info);           break;	         }l(       image=ReadMIFFImage(&decode_info);       break;     }c
     case 'E':r     {L3       if (strncmp(decode_info.magick,"EPS",3) == 0)y	         { *           image=ReadPSImage(&decode_info);           break;	         }e(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'F':_     {c0       if (strcmp(decode_info.magick,"FAX") == 0)	         {r+           image=ReadFAXImage(&decode_info);a           break;	         }o1       if (strcmp(decode_info.magick,"FITS") == 0)G	         { ,           image=ReadFITSImage(&decode_info);           break;	         }r(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'G':>     {s3       if (strncmp(decode_info.magick,"GIF",3) == 0)(	         { +           image=ReadGIFImage(&decode_info);a           break;	         } 1       if (strcmp(decode_info.magick,"GRAY") == 0) 	         {w,           image=ReadGRAYImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'H':      { 0       if (strcmp(decode_info.magick,"HDF") == 0)	         { +           image=ReadHDFImage(&decode_info);n           break;	         } 9       if (strncmp(decode_info.magick,"HISTOGRAM",4) == 0) 	         { 1           image=ReadHISTOGRAMImage(&decode_info);g           break;	         } 1       if (strcmp(decode_info.magick,"HTML") == 0) 	         {(,           image=ReadHTMLImage(&decode_info);           break;	         })(       image=ReadMIFFImage(&decode_info);       break;     }B
     case 'J':x     {31       if (strcmp(decode_info.magick,"JBIG") == 0)e	         {(,           image=ReadJBIGImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"JPEG") == 0) 	         { ,           image=ReadJPEGImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'L':l     {(1       if (strcmp(decode_info.magick,"LOGO") == 0)g	         { ,           image=ReadLOGOImage(&decode_info);           break;	         }a(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'M':l     {]0       if (strcmp(decode_info.magick,"MAP") == 0)	         { +           image=ReadMAPImage(&decode_info);            break;	         } 2       if (strcmp(decode_info.magick,"MATTE") == 0)	         { -           image=ReadMATTEImage(&decode_info);            break;	         } 5       if ((strcmp(decode_info.magick,"MPEG") == 0) || 2           (strcmp(decode_info.magick,"MPG") == 0))	         {p,           image=ReadMPEGImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"MTV") == 0)	         {|+           image=ReadMTVImage(&decode_info);E           break;	         }a(       image=ReadMIFFImage(&decode_info);       break;     }=
     case 'N':      { 1       if (strcmp(decode_info.magick,"NULL") == 0)=	         { ,           image=ReadNULLImage(&decode_info);           break;	         }a(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'P':      { 4       if ((strcmp(decode_info.magick,"PBM") == 0) ||4           (strcmp(decode_info.magick,"PGM") == 0) ||4           (strcmp(decode_info.magick,"PNM") == 0) ||2           (strcmp(decode_info.magick,"PPM") == 0))	         { +           image=ReadPNMImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"PCD") == 0)	         { +           image=ReadPCDImage(&decode_info);            break;	         }=0       if (strcmp(decode_info.magick,"PCX") == 0)	         { +           image=ReadPCXImage(&decode_info);c           break;	         } 0       if (strcmp(decode_info.magick,"PDF") == 0)	         {u+           image=ReadPDFImage(&decode_info);            break;	         } 1       if (strcmp(decode_info.magick,"PICT") == 0)]	         { ,           image=ReadPICTImage(&decode_info);           break;	         }i0       if (strcmp(decode_info.magick,"PCD") == 0)	         { +           image=ReadPCDImage(&decode_info);:           break;	         } /       if (strcmp(decode_info.magick,"PM") == 0)s	         {d+           image=ReadXPMImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"PNG") == 0)	         {m+           image=ReadPNGImage(&decode_info);            break;	         } 2       if (strncmp(decode_info.magick,"PS",2) == 0)	         {0*           image=ReadPSImage(&decode_info);           break;	         }/(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'R':      { 0       if (strcmp(decode_info.magick,"RAD") == 0)	         { 0           image=ReadRADIANCEImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"RAS") == 0)	         { +           image=ReadSUNImage(&decode_info);)           break;	         }(3       if (strncmp(decode_info.magick,"RGB",3) == 0)x	         {3+           image=ReadRGBImage(&decode_info);%           break;	         } 0       if (strcmp(decode_info.magick,"RLE") == 0)	         { +           image=ReadRLEImage(&decode_info);m           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }d
     case 'S':      {l0       if (strcmp(decode_info.magick,"SGI") == 0)	         {(+           image=ReadSGIImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"SUN") == 0)	         {6+           image=ReadSUNImage(&decode_info);            break;	         }r(       image=ReadMIFFImage(&decode_info);       break;     }r
     case 'T':      { 1       if (strcmp(decode_info.magick,"TEXT") == 0) 	         { ,           image=ReadTEXTImage(&decode_info);           break;	         }c0       if (strcmp(decode_info.magick,"TGA") == 0)	         {c+           image=ReadTGAImage(&decode_info);t           break;	         }g3       if (strncmp(decode_info.magick,"TIF",3) == 0)e	         {i,           image=ReadTIFFImage(&decode_info);           break;	         }d1       if (strcmp(decode_info.magick,"TILE") == 0))	         {(,           image=ReadTILEImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'U':-     {=1       if (strcmp(decode_info.magick,"UYVY") == 0)I	         {),           image=ReadUYVYImage(&decode_info);           break;	         }p(       image=ReadMIFFImage(&decode_info);       break;     }n
     case 'V':-     { 2       if (strcmp(decode_info.magick,"VICAR") == 0)	         {--           image=ReadVICARImage(&decode_info);            break;	         }T0       if (strcmp(decode_info.magick,"VID") == 0)	         {g!           if (decode_info.assert)a-             image=ReadVIDImage(&decode_info);%           else.             image=ReadMIFFImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"VIFF") == 0) 	         { ,           image=ReadVIFFImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'X':      {e.       if (strcmp(decode_info.magick,"X") == 0)	         { A           image=ReadXImage(&decode_info,False,False,False,False);            break;	         } /       if (strcmp(decode_info.magick,"XC") == 0) 	         { *           image=ReadXCImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"XBM") == 0)	         {%+           image=ReadXBMImage(&decode_info);e           break;	         }g0       if (strcmp(decode_info.magick,"XPM") == 0)	         {c+           image=ReadXPMImage(&decode_info);t           break;	         }i/       if (strcmp(decode_info.magick,"XV") == 0)R	         {e,           image=ReadVIFFImage(&decode_info);           break;	         }i0       if (strcmp(decode_info.magick,"XWD") == 0)	         {e+           image=ReadXWDImage(&decode_info);t           break;	         }a(       image=ReadMIFFImage(&decode_info);       break;     }e
     case 'Y':e     { 0       if (strcmp(decode_info.magick,"YUV") == 0)	         {r+           image=ReadYUVImage(&decode_info);m           break;	         } 1       if (strcmp(decode_info.magick,"YUV3") == 0)f	         {r,           image=ReadYUV3Image(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }n     default:     { /       (void) strcpy(decode_info.magick,"MIFF");r(       image=ReadMIFFImage(&decode_info);     }    }a   if (decode_image.temporary)i(     (void) unlink(decode_info.filename);   if (image != (Image *) NULL)     {o       if (image->status)K         Warning("An error has occurred reading from file",image->filename);g!       if (decode_image.temporary)m<         (void) strcpy(image->filename,image_info->filename);+       if (image->comments == (char *) NULL)(;         CommentImage(image,"  Imported from %m image: %f");)A       (void) strcpy(image->magick_filename,image_info->filename);o%       if (image->magick_columns == 0)i-         image->magick_columns=image->columns;)"       if (image->magick_rows == 0)'         image->magick_rows=image->rows;-2       image_info->interlace=decode_info.interlace;     }i   return(image); }r