 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                   E      NN  N  C      O   O  D   D  E                      % O %                   EEE    N N N  C      O   O  D   D  EEE                    % O %                   E      N  NN  C      O   O  D   D  E                      % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Write Image Formats                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "XWDFile.h"   /*   Define declarations. */, #define SaveImageText  "  Saving image...  "& #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    return(False); \ }    /*   Function prototypes. */
 static int<   SGIEncode _Declare((unsigned char *,int,unsigned char *));   static unsigned int 0   WriteAVSImage _Declare((ImageInfo *,Image *)),0   WriteBMPImage _Declare((ImageInfo *,Image *)),1   WriteCMYKImage _Declare((ImageInfo *,Image *)), 0   WriteFAXImage _Declare((ImageInfo *,Image *)),1   WriteFITSImage _Declare((ImageInfo *,Image *)), 0   WriteGIFImage _Declare((ImageInfo *,Image *)),1   WriteGRAYImage _Declare((ImageInfo *,Image *)), 0   WriteHDFImage _Declare((ImageInfo *,Image *)),6   WriteHISTOGRAMImage _Declare((ImageInfo *,Image *)),1   WriteHTMLImage _Declare((ImageInfo *,Image *)), 1   WriteJBIGImage _Declare((ImageInfo *,Image *)), 1   WriteJPEGImage _Declare((ImageInfo *,Image *)), 1   WriteLOGOImage _Declare((ImageInfo *,Image *)), 0   WriteMAPImage _Declare((ImageInfo *,Image *)),2   WriteMATTEImage _Declare((ImageInfo *,Image *)),1   WriteMIFFImage _Declare((ImageInfo *,Image *)), 1   WriteMPEGImage _Declare((ImageInfo *,Image *)), 0   WriteMTVImage _Declare((ImageInfo *,Image *)),0   WritePCDImage _Declare((ImageInfo *,Image *)),0   WritePCXImage _Declare((ImageInfo *,Image *)),0   WritePDFImage _Declare((ImageInfo *,Image *)),1   WritePICTImage _Declare((ImageInfo *,Image *)), 0   WritePNGImage _Declare((ImageInfo *,Image *)),0   WritePNMImage _Declare((ImageInfo *,Image *)),/   WritePSImage _Declare((ImageInfo *,Image *)), 0   WritePS2Image _Declare((ImageInfo *,Image *)),5   WriteRADIANCEImage _Declare((ImageInfo *,Image *)), 0   WriteRGBImage _Declare((ImageInfo *,Image *)),0   WriteRLEImage _Declare((ImageInfo *,Image *)),0   WriteSGIImage _Declare((ImageInfo *,Image *)),0   WriteSUNImage _Declare((ImageInfo *,Image *)),2   WriteTARGAImage _Declare((ImageInfo *,Image *)),1   WriteTEXTImage _Declare((ImageInfo *,Image *)), 1   WriteTIFFImage _Declare((ImageInfo *,Image *)), 1   WriteTILEImage _Declare((ImageInfo *,Image *)), 1   WriteUYVYImage _Declare((ImageInfo *,Image *)), 2   WriteVICARImage _Declare((ImageInfo *,Image *)),1   WriteVIFFImage _Declare((ImageInfo *,Image *)), .   WriteXImage _Declare((ImageInfo *,Image *)),0   WriteXBMImage _Declare((ImageInfo *,Image *)),/   WriteXCImage _Declare((ImageInfo *,Image *)), 0   WriteXPMImage _Declare((ImageInfo *,Image *)),0   WriteXWDImage _Declare((ImageInfo *,Image *)),0   WriteYUVImage _Declare((ImageInfo *,Image *)),1   WriteYUV3Image _Declare((ImageInfo *,Image *));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e A V S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteAVSImage writes an image to a file in AVS X image format. % . %  The format of the WriteAVSImage routine is: % - %      status=WriteAVSImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteAVSImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteAVSImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*"     Initialize raster file header.   */"   avs_header.width=image->columns;    avs_header.height=image->rows;F   (void) fwrite((char *) &avs_header,sizeof(AVSHeader),1,image->file);   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     { A       (void) fputc(image->matte ? p->index : Opaque,image->file); 2       (void) fputc(DownScale(p->red),image->file);4       (void) fputc(DownScale(p->green),image->file);3       (void) fputc(DownScale(p->blue),image->file);      }      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % . %  The format of the WriteBMPImage routine is: % - %      status=WriteBMPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteBMPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Initialize BMP raster file header.     */     bmp_header.file_size=14+40; !     bmp_header.offset_bits=14+40; 5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*            Full color BMP raster.
         */          bmp_header.bit_count=24;#         bmp_header.number_colors=0;        }      else       { 
         /*!           Colormapped BMP raster. 
         */         bmp_header.bit_count=8; 7         if (IsGrayImage(image) && (image->colors == 2)) !           bmp_header.bit_count=1; <         bmp_header.file_size+=4*(1 << bmp_header.bit_count);>         bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);;         bmp_header.number_colors=1 << bmp_header.bit_count;        }      bmp_header.reserved[0]=0;      bmp_header.reserved[1]=0;      bmp_header.size=40; $     bmp_header.width=image->columns;"     bmp_header.height=image->rows;     bmp_header.planes=1;     bmp_header.compression=0; C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; 5     bmp_header.image_size=bytes_per_line*image->rows; 0     bmp_header.file_size+=bmp_header.image_size;     bmp_header.x_pixels=75*39;     bmp_header.y_pixels=75*39;9     bmp_header.colors_important=bmp_header.number_colors;      /*(       Convert MIFF to BMP raster pixels.     */      bmp_pixels=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));-     if (bmp_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      x=0;     y=image->rows-1;!     switch (bmp_header.bit_count)      { 
       case 1:        {          register unsigned char           bit,           byte,            polarity;   
         /*>           Convert PseudoClass image to a BMP monochrome image.
         */         p=image->pixels;         polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[1]) < Intensity(image->colormap[0]);         bit=0;         byte=0; &         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              byte<<=1; %             if (p->index == polarity)                byte|=0x01;              bit++;             if (bit == 8)                {                  *q++=byte;                 bit=0;                 byte=0;                }              x++;$             if (x == image->columns)               {                  /*/                   Advance to the next scanline.                  */                 if (bit != 0) '                   *q++=byte << (8-bit);                  bit=0;                 byte=0;                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;              }           }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       } 
       case 8:        { 
         /*2           Convert PseudoClass packet to BMP pixel.
         */>         if (image->compression == RunlengthEncodedCompression)           CompressImage(image); >         if (image->compression == RunlengthEncodedCompression)(           bytes_per_line=image->columns;         p=image->pixels;&         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              *q++=p->index;             x++;$             if (x == image->columns)               {                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }        case 24:       { 
         /*6           Convert DirectClass packet to BMP RGB pixel.
         */         p=image->pixels;&         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { $             *q++=DownScale(p->blue);%             *q++=DownScale(p->green); #             *q++=DownScale(p->red);              x++;$             if (x == image->columns)               {                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }      } "     if (bmp_header.bit_count == 8)<       if (image->compression == RunlengthEncodedCompression)	         {            unsigned int             packets;             /*5             Convert run-length encoded raster pixels.            */@           packets=(bytes_per_line*(bmp_header.height+2)+1) << 1;K           bmp_data=(unsigned char *) malloc(packets*sizeof(unsigned char)); 3           if (bmp_pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL); (               free((char *) bmp_pixels);               return(False);
             }             bmp_header.image_size=K             BMPEncodeImage(bmp_pixels,bmp_data,image->columns,image->rows); $           free((char *) bmp_pixels);           bmp_pixels=bmp_data;#           bmp_header.compression=1; 	         }      /*       Write BMP header.      */(     (void) fwrite("BM",1,2,image->file);8     LSBFirstWriteLong(bmp_header.file_size,image->file);;     LSBFirstWriteShort(bmp_header.reserved[0],image->file); ;     LSBFirstWriteShort(bmp_header.reserved[1],image->file); :     LSBFirstWriteLong(bmp_header.offset_bits,image->file);3     LSBFirstWriteLong(bmp_header.size,image->file); 4     LSBFirstWriteLong(bmp_header.width,image->file);5     LSBFirstWriteLong(bmp_header.height,image->file); 6     LSBFirstWriteShort(bmp_header.planes,image->file);9     LSBFirstWriteShort(bmp_header.bit_count,image->file); :     LSBFirstWriteLong(bmp_header.compression,image->file);9     LSBFirstWriteLong(bmp_header.image_size,image->file); 7     LSBFirstWriteLong(bmp_header.x_pixels,image->file); 7     LSBFirstWriteLong(bmp_header.y_pixels,image->file); <     LSBFirstWriteLong(bmp_header.number_colors,image->file);?     LSBFirstWriteLong(bmp_header.colors_important,image->file); $     if (image->class == PseudoClass)       {          unsigned char            *bmp_colormap;  
         /*            Dump colormap to file.
         */&         bmp_colormap=(unsigned char *)F           malloc(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));3         if (bmp_colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          q=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 2           *q++=DownScale(image->colormap[i].blue);3           *q++=DownScale(image->colormap[i].green); 1           *q++=DownScale(image->colormap[i].red);            q++;	         } ;         for ( ; i < (int) (1 << bmp_header.bit_count); i++) 	         {            *q++=0;            *q++=0;            *q++=0;            q++;	         } H         (void) fwrite((char *) bmp_colormap,4,1 << bmp_header.bit_count,           image->file); $         free((char *) bmp_colormap);       } D     (void) fwrite((char *) bmp_pixels,1,(int) bmp_header.image_size,       image->file);      free((char *) bmp_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C M Y K I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteCMYKImage writes an image to a file in cyan, magenta,' %  yellow, and black rasterfile format.  % / %  The format of the WriteCMYKImage routine is:  % . %      status=WriteCMYKImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteCMYKImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteCMYKImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    float      black_generation,      undercolor;      int 
     black,	     cyan,      magenta,     yellow;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*'     Convert MIFF to CMYK raster pixels.    */   undercolor=1.0;    black_generation=1.0; .   if (image_info->undercolor != (char *) NULL)     { ?       (void) sscanf(image_info->undercolor,"%fx%f",&undercolor,          &black_generation); "       if (black_generation == 1.0)$         black_generation=undercolor;     }     switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; C           WriteQuantumFile((unsigned int) (cyan-undercolor*black)); F           WriteQuantumFile((unsigned int) (magenta-undercolor*black));E           WriteQuantumFile((unsigned int) (yellow-undercolor*black)); D           WriteQuantumFile((unsigned int) (black_generation*black));	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }        break;     }      case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  CCC...MMM...YYY...CCC...MMM...YYY...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        { +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; C           WriteQuantumFile((unsigned int) (cyan-undercolor*black));            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; F           WriteQuantumFile((unsigned int) (magenta-undercolor*black));           p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; E           WriteQuantumFile((unsigned int) (yellow-undercolor*black));            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; D           WriteQuantumFile((unsigned int) (black_generation*black));           p++;	         } 5         ProgressMonitor(SaveImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; C           WriteQuantumFile((unsigned int) (cyan-undercolor*black)); 	         }          p++;       } -       ProgressMonitor(SaveImageText,100,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; F           WriteQuantumFile((unsigned int) (magenta-undercolor*black));	         }          p++;       } -       ProgressMonitor(SaveImageText,200,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {             cyan=MaxRGB-p->red;#            magenta=MaxRGB-p->green; !            yellow=MaxRGB-p->blue;             black=cyan;            if (magenta < black)               black=magenta;             if (yellow < black)              black=yellow;E           WriteQuantumFile((unsigned int) (yellow-undercolor*black)); 	         }          p++;       } -       ProgressMonitor(SaveImageText,300,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; D           WriteQuantumFile((unsigned int) (black_generation*black));	         }          p++;       } -       ProgressMonitor(SaveImageText,400,400);        break;     }    }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F A X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteFAXImage writes an image to a file in 1 dimensional Huffman  %  encoded format. % . %  The format of the WriteFAXImage routine is: % - %      status=WriteFAXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteFAXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteFAXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*!       Convert MIFF to monochrome.      */4     if (!IsGrayImage(image) || (image->colors != 2))       { C         QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);          SyncImage(image);        } %     status=HuffmanEncodeImage(image); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F I T S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteFITSImage writes a Flexible Image Transport System image to a+ %  file as gray scale intensities [0..255].  % / %  The format of the WriteFITSImage routine is:  % . %      status=WriteFITSImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteFITSImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteFITSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    char     buffer[81],      *fits_header;      register int     i,     j;     register RunlengthPacket     *p;        /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate image header.   */:   fits_header=(char *) malloc(2880*sizeof(unsigned char));#   if (fits_header == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image header.   */   for (i=0; i < 2880; i++)     fits_header[i]=' '; 9   (void) strcpy(buffer,"SIMPLE  =                    T"); 6   (void) strncpy(fits_header+0,buffer,strlen(buffer));9   (void) strcpy(buffer,"BITPIX  =                    8"); 7   (void) strncpy(fits_header+80,buffer,strlen(buffer)); 9   (void) strcpy(buffer,"NAXIS   =                    2"); 8   (void) strncpy(fits_header+160,buffer,strlen(buffer));C   (void) sprintf(buffer,"NAXIS1  =           %10u",image->columns); 8   (void) strncpy(fits_header+240,buffer,strlen(buffer));@   (void) sprintf(buffer,"NAXIS2  =           %10u",image->rows);8   (void) strncpy(fits_header+320,buffer,strlen(buffer));:   (void) strcpy(buffer,"HISTORY Created by ImageMagick.");8   (void) strncpy(fits_header+400,buffer,strlen(buffer));   (void) strcpy(buffer,"END");8   (void) strncpy(fits_header+480,buffer,strlen(buffer));9   (void) fwrite((char *) fits_header,1,2880,image->file);    free((char *) fits_header);    /*2     Convert image to fits scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)9       (void) fputc(DownScale(Intensity(*p)),image->file);      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % . %  The format of the WriteGIFImage routine is: % - %      status=WriteGIFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteGIFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    Image      *q;      register int     i,     x;     register RunlengthPacket     *p;      unsigned char      bits_per_pixel,      c,     *matte_image;      unsigned int     colors,      height,      status, 
     width;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Write GIF header.    */B   if ((image->comments == (char *) NULL) && !image_info->adjoin &&       !image->matte),     (void) fwrite("GIF87a",1,6,image->file);   else0     if (strcmp(image_info->magick,"GIF87") == 0).       (void) fwrite("GIF87a",1,6,image->file);     else.       (void) fwrite("GIF89a",1,6,image->file);   width=image->columns;    height=image->rows;    if (image_info->adjoin) 7     for (q=image->next; q != (Image *) NULL; q=q->next)      {        if (q->columns > width)          width=q->columns;        if (q->rows > height)          height=q->rows;      } (   LSBFirstWriteShort(width,image->file);)   LSBFirstWriteShort(height,image->file); #   c=0x00;  /* no global colormap */ (   c|=(8-1) << 4;  /* color resolution */%   (void) fputc((char) c,image->file); 8   (void) fputc(0x0,image->file);  /* background color */0   (void) fputc(0x0,image->file);  /* reserved */F   if ((strcmp(image_info->magick,"GIF87") != 0) && image_info->adjoin)     {        /*-         Netscape Application Extension Block.        */%       (void) fputc(0x21,image->file); %       (void) fputc(0xff,image->file); %       (void) fputc(0x0b,image->file); 4       (void) fwrite("NETSCAPE2.0",1,11,image->file);%       (void) fputc(0x03,image->file); %       (void) fputc(0x01,image->file); @       (void) fputc(0x0A,image->file); /* number of iterations */%       (void) fputc(0x00,image->file); %       (void) fputc(0x00,image->file);      }    do   {      colors=256; '     matte_image=(unsigned char *) NULL;      if (image->matte)        { 
         /*.           Allocate and initialize matte image.
         */$         if (!UncompressImage(image))           return(False);         p=image->pixels;%         matte_image=(unsigned char *) C           malloc(image->columns*image->rows*sizeof(unsigned char)); 2         if (matte_image == (unsigned char *) NULL):           PrematureExit("Unable to allocate memory",image)         else:           for (x=0; x < (image->columns*image->rows); x++)           { =             matte_image[x]=(unsigned char) (p->index & 0xff);              p++;           }          colors--;        } B     if ((image->class == DirectClass) || (image->colors > colors))       { 
         /*,           Demote DirectClass to PseudoClass.
         */G         QuantizeImage(image,colors,8,image_info->dither,RGBColorspace);          SyncImage(image); $         if (!UncompressImage(image))           return(False);       }      colors=image->colors; .     if (matte_image != (unsigned char *) NULL)       {           CompressColormap(image);         colors++;        } @     for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)*       if ((1 << bits_per_pixel) >= colors)         break;0     if (strcmp(image_info->magick,"GIF87") != 0)       { -         if (image->comments != (char *) NULL)            {              register char                *p;    !             register unsigned int                count;                /*,               Write comment extension block.             */+             (void) fputc(0x21,image->file); +             (void) fputc(0xfe,image->file);              p=image->comments;'             while ((int) strlen(p) > 0) 
             { -               count=Min((int) strlen(p),255); .               (void) fputc(count,image->file);'               for (i=0; i < count; i++) /                 (void) fputc(*p++,image->file); 
             } *             (void) fputc(0x0,image->file);           } 2         if (matte_image != (unsigned char *) NULL)           {              /*>               Write out extension for transparent color index.             */+             (void) fputc(0x21,image->file); +             (void) fputc(0xf9,image->file); *             (void) fputc(0x4,image->file);*             (void) fputc(0x1,image->file);*             (void) fputc(0x0,image->file);*             (void) fputc(0x0,image->file);;             (void) fputc((char) image->colors,image->file); *             (void) fputc(0x0,image->file);             /*D               Set transparent pixels to the transparent color index.             */             p=image->pixels;<             for (x=0; x < (image->columns*image->rows); x++)
             { 0               if (matte_image[x] == Transparent)'                 p->index=image->colors;                p++;
             } '             free((char *) matte_image);            }        } 9     (void) fputc(',',image->file);  /* image separator */      /*       Write the image header.      */&     LSBFirstWriteShort(0,image->file);&     LSBFirstWriteShort(0,image->file);3     LSBFirstWriteShort(image->columns,image->file); 0     LSBFirstWriteShort(image->rows,image->file);     c=0x80; /     if (image_info->interlace != NoneInterlace) .       c|=0x40;  /* pixel data is interlaced */9     c|=(bits_per_pixel-1);   /* size of local colormap */ '     (void) fputc((char) c,image->file);      /*       Write colormap.      */%     for (i=0; i < image->colors; i++)      { B       (void) fputc(DownScale(image->colormap[i].red),image->file);D       (void) fputc(DownScale(image->colormap[i].green),image->file);C       (void) fputc(DownScale(image->colormap[i].blue),image->file);      } .     if (matte_image != (unsigned char *) NULL)       { 
         /*+           Write color of transparent pixel. 
         */         p=image->pixels;8         for (x=0; x < (image->columns*image->rows); x++)	         { ,           if (matte_image[x] == Transparent)             break;           p++;	         } K         (void) fputc(DownScale(image->colormap[p->index].red),image->file); M         (void) fputc(DownScale(image->colormap[p->index].green),image->file); L         (void) fputc(DownScale(image->colormap[p->index].blue),image->file);         i++;       } 1     for ( ; i < (int) (1 << bits_per_pixel); i++)      { $       (void) fputc(0x0,image->file);$       (void) fputc(0x0,image->file);$       (void) fputc(0x0,image->file);     }      c=Max(bits_per_pixel,2);'     (void) fputc((char) c,image->file); /     if (image_info->interlace == NoneInterlace) ;       status=GIFEncodeImage(image,Max(bits_per_pixel,2)+1);      else       { 
         Image            *interlaced_image;            int            pass,            y;             register RunlengthPacket
           *q;             static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };   
         /*           Interlace image.
         */$         if (!UncompressImage(image))           return(False);         image->orphan=True; K         interlaced_image=CopyImage(image,image->columns,image->rows,False);          image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image);          p=image->pixels;#         q=interlaced_image->pixels; &         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             p=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } +         interlaced_image->file=image->file; H         status=GIFEncodeImage(interlaced_image,Max(bits_per_pixel,2)+1);-         interlaced_image->file=(FILE *) NULL; '         DestroyImage(interlaced_image);        }      if (status == False)7       PrematureExit("Unable to allocate memory",image); "     (void) fputc(0x0,image->file);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin); 1   (void) fputc(';',image->file); /* terminator */    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteGRAYImage writes an image to a file as gray scale intensity
 %  values. % / %  The format of the WriteGRAYImage routine is:  % . %      status=WriteGRAYImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteGRAYImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*2     Convert image to gray scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)&       WriteQuantumFile(Intensity(*p));     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHDFImage writes an image in the Hierarchial Data Format image
 %  format. % . %  The format of the WriteHDFImage routine is: % - %      status=WriteHDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteHDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */
 #ifdef HasHDF 3 static unsigned int WriteHDFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {  #include "hdf.h"     int      status;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int
     scene,     packet_size;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);
   scene=0;   do   {      /*$       Initialize raster file header.     */     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)K       malloc(packet_size*image->columns*image->rows*sizeof(unsigned char)); -     if (hdf_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*3           Convert DirectClass packet to HDF pixels. 
         */         q=hdf_pixels; &         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */"             DF24setil(DFIL_PIXEL);.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }              break;           }            case LineInterlace:            {              register int               x,               y;                /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */(             if (!UncompressImage(image))               return(False);!             DF24setil(DFIL_LINE); +             for (y=0; y < image->rows; y++) 
             { 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { '                 *q++=DownScale(p->red);                  p++;               } 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { )                 *q++=DownScale(p->green);                  p++;               } 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { (                 *q++=DownScale(p->blue);                 p++;               } ;               ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */"             DF24setil(DFIL_PLANE);.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)'                 *q++=DownScale(p->red);                p++;
             } 3             ProgressMonitor(SaveImageText,100,400);              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++))                 *q++=DownScale(p->green);                p++;
             } 3             ProgressMonitor(SaveImageText,250,400);              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)(                 *q++=DownScale(p->blue);               p++;
             } 3             ProgressMonitor(SaveImageText,400,400);              break;           } 	         }          if (scene == 0) B           status=DF24putimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);         elseB           status=DF24addimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);          reference=DF24lastref();       }      else       { 
         /*3           Convert PseudoClass packet to HDF pixels. 
         */         q=hdf_pixels;          if (IsGrayImage(image)) ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)%               *q++=DownScale(p->red);              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }          else           {              unsigned char                *hdf_palette;    L             hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));6             if (hdf_palette == (unsigned char *) NULL)?               PrematureExit("Unable to allocate memory",image);              q=hdf_palette;-             for (i=0; i < image->colors; i++) 
             { 5               *q++=DownScale(image->colormap[i].red); 7               *q++=DownScale(image->colormap[i].green); 6               *q++=DownScale(image->colormap[i].blue);
             } /             (void) DFR8setpalette(hdf_palette);              free(hdf_palette);             q=hdf_pixels; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)                 *q++=p->index;               p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }            }          if (scene == 0) B           status=DFR8putimage(image->filename,(void *) hdf_pixels,L             image->columns,image->rows,image->compression == NoCompression ?             0 : DFTAG_RLE);          elseB           status=DFR8addimage(image->filename,(void *) hdf_pixels,L             image->columns,image->rows,image->compression == NoCompression ?             0 : DFTAG_RLE);           reference=DFR8lastref();       } &     if (image->label != (char *) NULL)L       (void) DFANputlabel(image->filename,DFTAG_RIG,reference,image->label);)     if (image->comments != (char *) NULL) M       (void) DFANputdesc(image->filename,DFTAG_RIG,reference,image->comments, #         strlen(image->comments)+1);      free(hdf_pixels);      scene++;&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    return(status != -1);  }  #else 3 static unsigned int WriteHDFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("HDF library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H I S T O G R A M I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHISTOGRAMImage writes an image to a file in HISTOGRAM format.O %  The image shows a histogram of the color (or gray) values in the image.  The O %  image consists of three overlaid histograms:  a red one for the red channel, O %  a green one for the green channel, and a blue one for the blue channel.  The O %  image comment contains a list of unique pixel values and the number of times  %  each occurs in the image. % > %  This routine is strongly based on a similiar one written byI %  muquit@warm.semcor.com which in turn is based on ppmhistmap of netpbm.  % 4 %  The format of the WriteHISTOGRAMImage routine is: % 3 %      status=WriteHISTOGRAMImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteHISTOGRAMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */9 static unsigned int WriteHISTOGRAMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { # #define HistogramDensity  "256x200"      char     filename[MaxTextLength];     double
     scale;     FILE
     *file;     Image      *histogram_image;      int 
     *blue,     *green,      maximum,	     *red,      sans_offset;     register RunlengthPacket     *p,      *q;      register int     i,     j;     unsigned int     height,      status, 
     width;     /*     Allocate histogram image.    */C   (void) XParseGeometry(HistogramDensity,&sans_offset,&sans_offset,      &width,&height);+   if (image_info->density != (char *) NULL) H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,       &width,&height);   image->orphan=True; 6   histogram_image=CopyImage(image,width,height,False);   image->orphan=False;(   if (histogram_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); %   histogram_image->class=DirectClass;    /*$     Allocate histogram count arrays.   */<   red=(int *) malloc (histogram_image->columns*sizeof(int));>   green=(int *) malloc (histogram_image->columns*sizeof(int));=   blue=(int *) malloc (histogram_image->columns*sizeof(int)); 9   if ((red == (int *) NULL) || (green == (int *) NULL) ||        (blue == (int *) NULL))      { $       DestroyImage(histogram_image);7       PrematureExit("Unable to allocate memory",image);      }    /*&     Initialize histogram count arrays.   */.   for (i=0; i < histogram_image->columns; i++)   { 
     red[i]=0;      green[i]=0;      blue[i]=0;   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     red[DownScale(p->red)]+=(p->length+1);.     green[DownScale(p->green)]+=(p->length+1);,     blue[DownScale(p->blue)]+=(p->length+1);     p++;   }    maximum=0;.   for (i=0; i < histogram_image->columns; i++)   {      if (maximum < red[i])        maximum=red[i];      if (maximum < green[i])        maximum=green[i];      if (maximum < blue[i])       maximum=blue[i];   } .   for (i=0; i < histogram_image->columns; i++)   {      if (red[i] > maximum)        red[i]=maximum;      if (green[i] > maximum)        green[i]=maximum;      if (blue[i] > maximum)       blue[i]=maximum;   }    /*     Initialize histogram image.    */   q=histogram_image->pixels;.   for (i=0; i < histogram_image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   } /   scale=(double) histogram_image->rows/maximum;    q=histogram_image->pixels;.   for (i=0; i < histogram_image->columns; i++)   { 1     j=histogram_image->rows-(int) (scale*red[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->red=MaxRGB;
       j++;     } 3     j=histogram_image->rows-(int) (scale*green[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->green=MaxRGB;
       j++;     } 2     j=histogram_image->rows-(int) (scale*blue[i]);%     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->blue=MaxRGB; 
       j++;     } >     ProgressMonitor(SaveImageText,i,histogram_image->columns);   }    free ((char *) blue);    free ((char *) green);   free ((char *) red);   TemporaryFilename(filename);   file=fopen(filename,"w");    if (file != (FILE *) NULL)     { 
       char         command[MaxTextLength];          /*,         Add a histogram as an image comment.       */2       (void) fprintf(file,"%s\n",image->comments);       NumberColors(image,file);        (void) fclose(file);-       (void) sprintf(command,"@%s",filename); ,       CommentImage(histogram_image,command);       (void) unlink(filename);     }    /*"     Write HISTOGRAM image as MIFF.   */4   status=WriteMIFFImage(image_info,histogram_image);    DestroyImage(histogram_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H T M L I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteHTMLImage writes an image in the HTML encoded image format. % / %  The format of the WriteHTMLImage routine is:  % . %      status=WriteHTMLImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteHTMLImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteHTMLImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    char     color[MaxTextLength],      filename[MaxTextLength];     int      x,     y;     register char      *p;      unsigned int     height,      status, 
     width;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); *   (void) strcpy(filename,image->filename);&   if (*image->magick_filename != '\0'):     (void) strcpy(image->filename,image->magick_filename);9   (void) fprintf(image->file,"<html version=\"2.0\">\n"); )   (void) fprintf(image->file,"<head>\n"); D   (void) fprintf(image->file,"<title>%s</title>\n",image->filename);*   (void) fprintf(image->file,"</head>\n");)   (void) fprintf(image->file,"<body>\n"); +   (void) fprintf(image->file,"<center>\n"); >   (void) fprintf(image->file,"<h1>%s</h1>\n",image->filename);+   (void) fprintf(image->file,"<br><br>\n"); *   (void) strcpy(filename,image->filename);$   AppendImageFormat("gif",filename);I   (void) fprintf(image->file,"<img src=\"%s\" border=none >\n",filename); ,   (void) fprintf(image->file,"</center>\n");0   (void) fprintf(image->file,"<br><br><pre>\n");(   DescribeImage(image,image->file,True);)   (void) fprintf(image->file,"</pre>\n"); *   (void) fprintf(image->file,"</body>\n");*   status=fprintf(image->file,"</html>\n");   CloseImage(image);&   if (image->montage != (char *) NULL)     {        /*         Open image map.        */.       (void) strcpy(image->filename,filename);/       AppendImageFormat("map",image->filename); 2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);        /*;         Determine the size and location of each image tile.        */
       x=0;
       y=0;       width=image->columns;        height=image->rows; A       (void) XParseGeometry(image->montage,&x,&y,&width,&height);        /*         Write an image map.        */;       (void) fprintf(image->file,"default default.html\n"); *       (void) fprintf(image->file,"rect ");/       for (p=image->directory; *p != '\0'; p++)          if (*p != '\n') '           (void) fputc(*p,image->file);          else           { <             (void) fprintf(image->file," %d,%d %d,%d\n",x,y,0               x+(int) width-1,y+(int) height-1);             if (*(p+1) != '\0') 2               (void) fprintf(image->file,"rect ");             x+=width; $             if (x >= image->columns)               {                  x=0;                 y+=height;               }            } O       (void) sprintf(color,"#%02x%02x%02x",(unsigned int) image->pixels[0].red, <         (unsigned int) image->pixels[0].green,(unsigned int)         image->pixels[0].blue); $       TransparentImage(image,color);       CloseImage(image);     } ,   if (strcmp(image_info->magick,"GIF") != 0)     {        /*+         Write the image as transparent GIF.        *//       AppendImageFormat("gif",image->filename); .       status|=WriteGIFImage(image_info,image);     } *   (void) strcpy(image->filename,filename);   return(status);  }    #ifdef HasJBIG #include "jbig.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e J B I G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteJBIGImage writes an image in the JBIG encoded image format. % / %  The format of the WriteJBIGImage routine is:  % . %      status=WriteJBIGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteJBIGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  " void JBIGEncode(start,length,file)
 unsigned char 
    *start;   size_t	   length;    void	    *file;  { .   (void) fwrite(start,length,1,(FILE *) file);	   return;  }   4 static unsigned int WriteJBIGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    int      sans_offset;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     bit,     *q;      struct jbg_enc_state     jbig_info;     unsigned char      *pixels,
     polarity;      unsigned int	     byte,      number_packets,      x,     x_resolution,      y_resolution;      /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*       Allocate pixel data.     */9     number_packets=((image->columns+7) >> 3)*image->rows; J     pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));)     if (pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*3       Convert Runlength encoded pixels to a bitmap.      */4     if (!IsGrayImage(image) || (image->colors != 2))       { C         QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);          SyncImage(image);        }      polarity=0;      if (image->colors == 2) M       polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]); 
     bit=0;     byte=0;      x=0;     p=image->pixels;
     q=pixels; &     for (i=0; i < image->packets; i++)     { *       for (j=0; j <= (int) p->length; j++)       {          byte<<=1; !         if (p->index == polarity)            byte|=0x01;          bit++;         if (bit == 8)            {              *q++=byte;             bit=0;             byte=0;            }          x++;          if (x == image->columns)           {              /*+               Advance to the next scanline.              */             if (bit != 0) #               *q++=byte << (8-bit);              bit=0;             byte=0;              x=0;
          }       } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     }      /*%       Initialize JBIG info structure.      */A     jbg_enc_init(&jbig_info,image->columns,image->rows,1,&pixels, F       (void (*) _Declare((unsigned char *,size_t,void *))) JBIGEncode,       image->file);      x_resolution=640;      y_resolution=480; H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,#       &x_resolution,&y_resolution); "     if (image_info->subimage != 0)6       jbg_enc_layers(&jbig_info,image_info->subimage);     else;       jbg_enc_lrlmax(&jbig_info,x_resolution,y_resolution); %     jbg_enc_lrange(&jbig_info,-1,-1); L     jbg_enc_options(&jbig_info,JBG_ILEAVE | JBG_SMID,JBG_TPDON | JBG_TPBON |       JBG_DPON,-1,-1,-1);      /*       Write JBIG image.      */     jbg_enc_out(&jbig_info);     jbg_enc_free(&jbig_info);      free((char *) pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }  #else 4 static unsigned int WriteJBIGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   ;   Warning("JBIG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   #ifdef HasJPEG #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the WriteJPEGImage routine is:  % . %      status=WriteJPEGImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { H       if (jpeg_error->num_warnings == 0 || jpeg_error->trace_level >= 3)2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];     register int     i,     j,     x;     register JSAMPLE     *q;      register RunlengthPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;#   jpeg_create_compress(&jpeg_info); *   jpeg_stdio_dest(&jpeg_info,image->file);'   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB;    if (IsGrayImage(image))      { #       jpeg_info.input_components=1; -       jpeg_info.in_color_space=JCS_GRAYSCALE;      }     jpeg_set_defaults(&jpeg_info);$   for (i=0; i < MAX_COMPONENTS; i++)   { +     jpeg_info.comp_info[i].h_samp_factor=1; +     jpeg_info.comp_info[i].v_samp_factor=1;    } 8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True;  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif #ifdef C_PROGRESSIVE_SUPPORTED-   if (image_info->interlace != NoneInterlace) (     jpeg_simple_progression(&jpeg_info); #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) :     for (i=0; i < (int) strlen(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,C         (unsigned int) Min((int) strlen(image->comments+i),65533));    /*'     Convert MIFF to JPEG raster pixels.    */4   packets=jpeg_info.input_components*image->columns;:   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));&   if (jpeg_pixels == (JSAMPLE *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   q=jpeg_pixels;   x=0;%   scanline[0]=(JSAMPROW) jpeg_pixels; ;   if ((jpeg_info.data_precision > 8) && (QuantumDepth > 8))      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { 0             *q++=(JSAMPLE) (Intensity(*p) >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         } 
       else*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { )             *q++=(JSAMPLE) (p->red >> 4); +             *q++=(JSAMPLE) (p->green >> 4); *             *q++=(JSAMPLE) (p->blue >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { 2           *q++=(JSAMPLE) DownScale(Intensity(*p));           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }      else(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { +           *q++=(JSAMPLE) DownScale(p->red); -           *q++=(JSAMPLE) DownScale(p->green); ,           *q++=(JSAMPLE) DownScale(p->blue);           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */$   jpeg_destroy_compress(&jpeg_info);   free((char *) jpeg_pixels);    CloseImage(image);   return(True);  }  #else 4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   ;   Warning("JPEG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e L O G O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteLOGOImage writes an image in the LOGO encoded image format. % / %  The format of the WriteLOGOImage routine is:  % . %      status=WriteLOGOImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteLOGOImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteLOGOImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   6   Warning("Cannot write LOGO images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMAPImage writes an image to a file as red, green, and blue 3 %  colormap bytes followed by the colormap indexes.  % . %  The format of the WriteMAPImage routine is: % - %      status=WriteMAPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMAPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMAPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     register unsigned char     *q;      unsigned char      *colormap;     unsigned int     packet_size;     unsigned short
     value;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate colormap.   */"   if (image->class == DirectClass)     {        /**         Demote DirectClass to PseudoClass.       */N       QuantizeImage(image,MaxColormapSize,8,image_info->dither,RGBColorspace);       SyncImage(image);      } $   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));)   if (colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Write colormap to file.    */
   q=colormap; #   for (i=0; i < image->colors; i++)    { +     WriteQuantum(image->colormap[i].red,q); -     WriteQuantum(image->colormap[i].green,q); ,     WriteQuantum(image->colormap[i].blue,q);   } D   (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,     image->file);    free((char *) colormap);   /*     Write image pixels to file.    */#   image->compression=NoCompression; %   (void) RunlengthEncodeImage(image); G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, &     (int) image->packets,image->file);&   free((char *) image->packed_pixels);.   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteMATTEImage writes an mage of matte bytes to a file.  ItC %  consists of data from the matte component of the image [0..255].  % 0 %  The format of the WriteMATTEImage routine is: % / %      status=WriteMATTEImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */5 static unsigned int WriteMATTEImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      if (!image->matte)?     PrematureExit("Image does not have a matte channel",image);    /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate matte pixels.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)4       (void) fputc(DownScale(p->index),image->file);     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Function WriteMIFFImage writes an image to a file.  % / %  The format of the WriteMIFFImage routine is:  % . %      status=WriteMIFFImage(image_info,image) % + %  A description of each parameter follows:  % K %    o status: Function WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */
 #ifdef HasPNG  #include "zlib.h"  #endif  4 static unsigned int WriteMIFFImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     unsigned int     compression;     unsigned long      packets;  E   if ((image->class != DirectClass) && (image->class != PseudoClass)) /     PrematureExit("Unknown image class",image); <   if ((image->compression != RunlengthEncodedCompression) &&0       (image->compression != ZlibCompression) &&,       (image->compression != NoCompression))5     PrematureExit("Unknown image compression",image);    /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); +   (void) strcpy(image_info->magick,"MIFF");    do   {      /*       Pack image pixels.     */#     compression=image->compression; '     (void) RunlengthEncodeImage(image);      packets=image->packets; '     if (compression == ZlibCompression)        {          int            status;            unsigned char            *compressed_pixels;            unsigned int           compressed_packets;   
         /*3           Compress image pixels with Zlib encoding. 
         */E         compressed_packets=((packets*image->packet_size*110)/100)+12; +         compressed_pixels=(unsigned char *) ;           malloc(compressed_packets*sizeof(unsigned char)); 8         if (compressed_pixels == (unsigned char *) NULL);           PrematureExit("Unable to allocate memory",image);          status=True; #ifdef   HasPNG H         status=compress(compressed_pixels,&packets,image->packed_pixels,-           image->packets*image->packet_size);  #endif         if (status)            { E             Warning("Unable to Zlib compress image",image->filename); -             image->compression=NoCompression;            }          else           { 0             free((char *) image->packed_pixels);3             image->packed_pixels=compressed_pixels; !             image->packet_size=1;            }        } $     if (image->class == PseudoClass)       ColormapSignature(image);      /*       Write header to file.      */3     (void) fprintf(image->file,"id=ImageMagick\n"); $     if (image->class == PseudoClass)P       (void) fprintf(image->file,"class=PseudoClass  colors=%u  signature=%s\n",(         image->colors,image->signature);     else       if (image->matte) F         (void) fprintf(image->file,"class=DirectClass  matte=True\n");
       else:         (void) fprintf(image->file,"class=DirectClass\n");:     if (image->compression == RunlengthEncodedCompression)O       (void) fprintf(image->file,"compression=RunlengthEncoded  packets=%lu\n",          packets);      else0       if (image->compression == ZlibCompression)N         (void) fprintf(image->file,"compression=Zlib  packets=%lu\n",packets);P     (void) fprintf(image->file,"columns=%u  rows=%u  depth=%u\n",image->columns,        image->rows,image->depth);     if (image->scene != 0)<       (void) fprintf(image->file,"scene=%u\n",image->scene);     if (image->gamma != 0.0)<       (void) fprintf(image->file,"gamma=%f\n",image->gamma);(     if (image->montage != (char *) NULL)@       (void) fprintf(image->file,"montage=%s\n",image->montage);)     if (image->comments != (char *) NULL) ?       (void) fprintf(image->file,"{\n%s\n}\n",image->comments); *     (void) fprintf(image->file,"\f\n:\n");(     if (image->montage != (char *) NULL)       { 
         /*'           Write montage tile directory. 
         */.         if (image->directory != (char *) NULL)<           (void) fprintf(image->file,"%s",image->directory);'         (void) fputc('\0',image->file);        } $     if (image->class == PseudoClass)       {          register unsigned char
           *q;            unsigned char            *colormap;           unsigned int           packet_size;           unsigned short           value;  
         /*           Allocate colormap.
         */*         packet_size=3*(image->depth >> 3);"         colormap=(unsigned char *)B           malloc(packet_size*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          q=colormap; )         for (i=0; i < image->colors; i++) 	         { 1           WriteQuantum(image->colormap[i].red,q); 3           WriteQuantum(image->colormap[i].green,q); 2           WriteQuantum(image->colormap[i].blue,q);	         } 
         /*!           Write colormap to file. 
         */J         (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,           image->file);           free((char *) colormap);       }      /*!       Write image pixels to file.      */I     (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, !       (int) packets,image->file); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M P E G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteMPEGImage writes an image in the MPEG encoded image format. % / %  The format of the WriteMPEGImage routine is:  % . %      status=WriteMPEGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteMPEGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteMPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    char     basename[MaxTextLength],     command[MaxTextLength],      filename[MaxTextLength];     Image      component_image;     MonitorHandler     handler;     register int     i;     unsigned int     number_images,
     scene,     status;      /*     Write component images.    */   scene=image->scene; G   for (number_images=0; image->next != (Image *) NULL; number_images++)      image=image->next;   number_images++;+   while (image->previous != (Image *) NULL)      image=image->previous;   TemporaryFilename(basename);#   (void) strcpy(filename,basename);    (void) strcat(filename,"%d"); #   for (i=0; i < number_images; i++)    { 5     handler=SetMonitorHandler((MonitorHandler) NULL);      component_image=(*image); ,     component_image.previous=(Image *) NULL;(     component_image.next=(Image *) NULL;8     (void) sprintf(component_image.filename,filename,i);7     (void) WriteYUV3Image(image_info,&component_image); &     if (image->next != (Image *) NULL)       image=image->next;&     (void) SetMonitorHandler(handler);3     ProgressMonitor(SaveImageText,i,number_images);    }    /*     Write MPEG image.    */K   (void) sprintf(command,"mpeg -a %d -b %d -h %d -v %d -PF %s -s %s",scene, F     image->scene,image->columns,image->rows,basename,image->filename);    status=SystemCommand(command);   /*     Remove component files.    */#   for (i=0; i < number_images; i++)    { 8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".Y"); ,     (void) unlink(component_image.filename);8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".U"); ,     (void) unlink(component_image.filename);8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".V"); ,     (void) unlink(component_image.filename);   }    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % . %  The format of the WriteMTVImage routine is: % - %      status=WriteMTVImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMTVImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Convert MIFF to MTV raster pixels.     */E     (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);      p=image->pixels;&     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)       { 4         (void) fputc(DownScale(p->red),image->file);6         (void) fputc(DownScale(p->green),image->file);5         (void) fputc(DownScale(p->blue),image->file);        } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePCDImage writes an image in the Photo CD encoded image 
 %  format. % . %  The format of the WritePCDImage routine is: % - %      status=WritePCDImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCDImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   5   Warning("Cannot write PCD images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WritePCXImage writes an image in the ZSoft IBM PC Paintbrush file 
 %  format. % . %  The format of the WritePCXImage routine is: % - %      status=WritePCXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     count,     packet,      *pcx_colormap,     *pcx_pixels,
     previous;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Initialize PCX raster file header.     */?     if ((image->class == DirectClass) || (image->colors > 256))        { 
         /*,           Demote DirectClass to PseudoClass.
         */D         QuantizeImage(image,256,8,image_info->dither,RGBColorspace);         SyncImage(image);        }      pcx_header.identifier=0x0a;      pcx_header.version=5;      pcx_header.encoding=1;      pcx_header.bits_per_pixel=8;3     if (IsGrayImage(image) && (image->colors == 2)) "       pcx_header.bits_per_pixel=1;     pcx_header.left=0;     pcx_header.top=0; &     pcx_header.right=image->columns-1;$     pcx_header.bottom=image->rows-1;4     pcx_header.horizontal_resolution=image->columns;/     pcx_header.vertical_resolution=image->rows;      pcx_header.reserved=0;     pcx_header.planes=1;M     pcx_header.bytes_per_line=(image->columns*pcx_header.bits_per_pixel+7)/8;      pcx_header.palette_info=1;'     pcx_header.colormap_signature=0x0c;      /*       Write PCX header.      */:     (void) fwrite(&pcx_header.identifier,1,1,image->file);7     (void) fwrite(&pcx_header.version,1,1,image->file); 8     (void) fwrite(&pcx_header.encoding,1,1,image->file);>     (void) fwrite(&pcx_header.bits_per_pixel,1,1,image->file);C     LSBFirstWriteShort((unsigned int) pcx_header.left,image->file); B     LSBFirstWriteShort((unsigned int) pcx_header.top,image->file);D     LSBFirstWriteShort((unsigned int) pcx_header.right,image->file);E     LSBFirstWriteShort((unsigned int) pcx_header.bottom,image->file); G     LSBFirstWriteShort((unsigned int) pcx_header.horizontal_resolution,        image->file); E     LSBFirstWriteShort((unsigned int) pcx_header.vertical_resolution,        image->file);      /*       Dump colormap to file.     */G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); /     if (pcx_colormap == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      q=pcx_colormap; %     for (i=0; i < image->colors; i++)      { -       *q++=DownScale(image->colormap[i].red); /       *q++=DownScale(image->colormap[i].green); .       *q++=DownScale(image->colormap[i].blue);     } :     (void) fwrite((char *) pcx_colormap,3,16,image->file);8     (void) fwrite(&pcx_header.reserved,1,1,image->file);6     (void) fwrite(&pcx_header.planes,1,1,image->file);M     LSBFirstWriteShort((unsigned int) pcx_header.bytes_per_line,image->file); K     LSBFirstWriteShort((unsigned int) pcx_header.palette_info,image->file);      for (i=0; i < 58; i++)*       (void) fwrite("\0",1,1,image->file);     /*(       Convert MIFF to PCX raster pixels.     */      pcx_pixels=(unsigned char *)J       malloc(pcx_header.bytes_per_line*image->rows*sizeof(unsigned char));-     if (pcx_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      x=0;     y=0;     p=image->pixels;     q=pcx_pixels; &     if (pcx_header.bits_per_pixel > 1)(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y++;7               q=pcx_pixels+y*pcx_header.bytes_per_line; 
             } 	         }          p++;       }      else       {          register unsigned char           bit,           byte,            polarity;   
         /*>           Convert PseudoClass image to a PCX monochrome image.
         */         polarity=0;          if (image->colors == 2) 2           polarity=Intensity(image->colormap[0]) <*             Intensity(image->colormap[1]);         bit=0;         byte=0; *         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              byte<<=1; %             if (p->index == polarity)                byte|=0x01;              bit++;             if (bit == 8)                {                  *q++=byte;                 bit=0;                 byte=0;                }              x++;$             if (x == image->columns)               {                  /*/                   Advance to the next scanline.                  */                 if (bit != 0) '                   *q++=byte << (8-bit);                  bit=0;                 byte=0;                  x=0;                 y++;9                 q=pcx_pixels+y*pcx_header.bytes_per_line;               }           }            p++;	         }        }      /*#       Runlength-encoded PCX pixels.      */#     for (y=0; y < image->rows; y++)      { /       q=pcx_pixels+y*pcx_header.bytes_per_line;        previous=(*q++);       count=1;7       for (x=0; x < (pcx_header.bytes_per_line-1); x++)        {          packet=(*q++);1         if ((packet == previous) && (count < 63))            {              count++;             continue;            } 7         if ((count > 1) || ((previous & 0xc0) == 0xc0))            {              count|=0xc0;2             (void) fwrite(&count,1,1,image->file);           } 1         (void) fwrite(&previous,1,1,image->file);          previous=packet;         count=1;       } 5       if ((count > 1) || ((previous & 0xc0) == 0xc0)) 	         {            count|=0xc0;0           (void) fwrite(&count,1,1,image->file);	         } /       (void) fwrite(&previous,1,1,image->file); 3       ProgressMonitor(SaveImageText,y,image->rows);      } B     (void) fwrite(&pcx_header.colormap_signature,1,1,image->file);;     (void) fwrite((char *) pcx_colormap,3,256,image->file);      free((char *) pcx_pixels);      free((char *) pcx_colormap);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePDFImage writes an image in the Portable Document image
 %  format. % . %  The format of the WritePDFImage routine is: % - %      status=WritePDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePDFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { + #define DefaultThumbnailGeometry  "106x106"      char     date[MaxTextLength];     float      dx_resolution,     dy_resolution,     x_resolution,      y_resolution;      int 
     count,     delta_x,     delta_y,
     flags,     x,
     xref[15],      y;     Image      encode_image,      *tile_image;     register RunlengthPacket     *p;      register unsigned char     *q;      register int     i,     j;     time_t
     timer;     unsigned char      *pixels;     unsigned int     height,      length,      number_objects,      number_packets,      page_height,     page_width,      text_size,
     width;     /*     Open output image file.    */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); -   if ((image->file == stdout) || image->pipe)      {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);        image->temporary=True;&       OpenImage(image_info,image,"w");'       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);      }    /*+     Scale image to size of Postscript page.    */3   text_size=image->label == (char *) NULL ? 0 : 36;    x=0;   y=0;   width=image->columns;    height=image->rows;    /*+     Center image on Portable Document page.    */G   (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height); H   flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);(   if (((page_width-(x << 1)) < width) ||2       ((page_height-(y << 1)-text_size) < height))     {        unsigned long          scale_factor;          /*7         Scale image relative to Portable Document page.        */6       scale_factor=UpShift(page_width-(x << 1))/width;J       if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))D         scale_factor=UpShift(page_height-(y << 1)-text_size)/height;*       width=DownShift(width*scale_factor);,       height=DownShift(height*scale_factor);     }    if ((flags & XValue) == 0)     {        /*(         Center image in the X direction.       */*       delta_x=page_width-(width+(x << 1));       if (delta_x >= 0)          x=(delta_x >> 1)+x;      }    if ((flags & YValue) == 0)     {        /*(         Center image in the X direction.       */6       delta_y=page_height-(height+(y << 1))-text_size;       if (delta_y >= 0)          y=(delta_y >> 1)+y;      }    /*$     Scale relative to dots-per-inch.   */   dx_resolution=72.0;    dy_resolution=72.0;    x_resolution=72.0;F   count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);+   if (image_info->density != (char *) NULL) J     count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);   if (count != 2)      y_resolution=x_resolution;B   width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);D   height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);   /*     Write Info object.   */-   (void) fprintf(image->file,"%%PDF-1.1 \n");    xref[0]=ftell(image->file); *   (void) fprintf(image->file,"1 0 obj\n");%   (void) fprintf(image->file,"<<\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); $   (void) strcpy(date,ctime(&timer));   date[strlen(date)-1]='\0';:   (void) fprintf(image->file,"/CreationDate (%s)\n",date);8   (void) fprintf(image->file,"/Producer ImageMagick\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Catalog object.    */   xref[1]=ftell(image->file); *   (void) fprintf(image->file,"2 0 obj\n");%   (void) fprintf(image->file,"<<\n"); 1   (void) fprintf(image->file,"/Type /Catalog\n"); /   (void) fprintf(image->file,"/Pages 3 0 R\n"); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Pages object.    */   xref[2]=ftell(image->file); *   (void) fprintf(image->file,"3 0 obj\n");%   (void) fprintf(image->file,"<<\n"); /   (void) fprintf(image->file,"/Type /Pages\n"); +   (void) fprintf(image->file,"/Count 1\n"); 2   (void) fprintf(image->file,"/Kids [ 4 0 R ]\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Page object.   */   xref[3]=ftell(image->file); *   (void) fprintf(image->file,"4 0 obj\n");%   (void) fprintf(image->file,"<<\n"); .   (void) fprintf(image->file,"/Type /Page\n");0   (void) fprintf(image->file,"/Parent 3 0 R\n");0   (void) fprintf(image->file,"/Resources <<\n");8   (void) fprintf(image->file,"/Font << /F0 8 0 R >>\n");<   (void) fprintf(image->file,"/XObject << /Im0 9 0 R >>\n");4   (void) fprintf(image->file,"/ProcSet 7 0 R >>\n");9   (void) fprintf(image->file,"/MediaBox [ 0 0 %u %u ]\n",      page_width,page_height);2   (void) fprintf(image->file,"/Contents 5 0 R\n");0   (void) fprintf(image->file,"/Thumb 12 0 R\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Contents object.   */   xref[4]=ftell(image->file); *   (void) fprintf(image->file,"5 0 obj\n");%   (void) fprintf(image->file,"<<\n"); 0   (void) fprintf(image->file,"/Length 6 0 R\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"stream\n");    length=ftell(image->file);$   (void) fprintf(image->file,"q\n");%   (void) fprintf(image->file,"BT\n"); ,   (void) fprintf(image->file,"/F0 24 Tf\n");M   (void) fprintf(image->file,"%d %d Td\n",x >> 1,y+(int) height+(y >> 1)+12); $   if (image->label == (char *) NULL)*     (void) fprintf(image->file,"() Tj\n");   else9     (void) fprintf(image->file,"(%s) Tj\n",image->label); %   (void) fprintf(image->file,"ET\n"); B   (void) fprintf(image->file,"%d 0 0 %d %d %d cm\n",x+(int) width,"     y+(int) height,x >> 1,y >> 1);*   (void) fprintf(image->file,"/Im0 Do\n");$   (void) fprintf(image->file,"Q\n");#   length=ftell(image->file)-length; ,   (void) fprintf(image->file,"endstream\n");)   (void) fprintf(image->file,"endobj\n");    /*     Write Length object.   */   xref[5]=ftell(image->file); *   (void) fprintf(image->file,"6 0 obj\n");,   (void) fprintf(image->file,"%u\n",length);)   (void) fprintf(image->file,"endobj\n");    /*     Write Procset object.    */   xref[6]=ftell(image->file); *   (void) fprintf(image->file,"7 0 obj\n");3   if (!IsPseudoClass(image) && !IsGrayImage(image)) 7     (void) fprintf(image->file,"[ /PDF /Text /ImageC");    else3     if (IsGrayImage(image) && (image->colors == 2)) 9       (void) fprintf(image->file,"[ /PDF /Text /ImageB");      else9       (void) fprintf(image->file,"[ /PDF /Text /ImageI"); %   (void) fprintf(image->file," ]\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Font object.   */   xref[7]=ftell(image->file); *   (void) fprintf(image->file,"8 0 obj\n");%   (void) fprintf(image->file,"<<\n"); .   (void) fprintf(image->file,"/Type /Font\n");2   (void) fprintf(image->file,"/Subtype /Type1\n");,   (void) fprintf(image->file,"/Name /F0\n");7   (void) fprintf(image->file,"/BaseFont /Helvetica\n"); >   (void) fprintf(image->file,"/Encoding /MacRomanEncoding\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write XObject object.    */   xref[8]=ftell(image->file); *   (void) fprintf(image->file,"9 0 obj\n");%   (void) fprintf(image->file,"<<\n"); 1   (void) fprintf(image->file,"/Type /XObject\n"); 2   (void) fprintf(image->file,"/Subtype /Image\n");-   (void) fprintf(image->file,"/Name /Im0\n"); *   if (image->compression == NoCompression);     (void) fprintf(image->file,"/Filter /ASCII85Decode\n");    elseP     (void) fprintf(image->file,"/Filter [ /ASCII85Decode /RunLengthDecode ]\n");;   (void) fprintf(image->file,"/Width %u\n",image->columns); 9   (void) fprintf(image->file,"/Height %u\n",image->rows); 5   (void) fprintf(image->file,"/ColorSpace 11 0 R\n"); 6   (void) fprintf(image->file,"/BitsPerComponent %d\n",8     IsGrayImage(image) && (image->colors == 2) ? 1 : 8);1   (void) fprintf(image->file,"/Length 10 0 R\n"); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"stream\n");    length=ftell(image->file);   p=image->pixels;3   if (!IsPseudoClass(image) && !IsGrayImage(image))      switch (image->compression)      { '       case RunlengthEncodedCompression:        default:       { 
         /*           Allocate pixel array. 
         */4         number_packets=3*image->columns*image->rows;N         pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 
         /*(           Dump runlength encoded pixels.
         */         q=pixels; *         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { :             if (image->matte && (p->index == Transparent))               { '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB);                }              else               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         } F         (void) PackbitsEncodeImage(image->file,pixels,number_packets);         free((char *) pixels);         break;       }        case NoCompression:        { 
         /*0           Dump uncompressed DirectColor packets.
         */         Ascii85Initialize();*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { :             if (image->matte && (p->index == Transparent))               { =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file);                }              else               { =                 Ascii85Encode(DownScale(p->red),image->file); ?                 Ascii85Encode(DownScale(p->green),image->file); >                 Ascii85Encode(DownScale(p->blue),image->file);               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         } "         Ascii85Flush(image->file);         break;       }      }    else3     if (IsGrayImage(image) && (image->colors == 2))        {          register unsigned char           bit,           byte,            polarity;   O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);          bit=0;         byte=0;          x=0;#         switch (image->compression) 	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */A             number_packets=((image->columns+7) >> 3)*image->rows; $             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image);              /*,               Dump Runlength encoded pixels.             */             q=pixels; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;                    }                  x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte << (8-bit);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             } J             (void) PackbitsEncodeImage(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();.             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    { 4                     Ascii85Encode(byte,image->file);                     bit=0;                     byte=0;                    }                  x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) A                       Ascii85Encode(byte << (8-bit),image->file);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             } &             Ascii85Flush(image->file);             break;           } 	         }        }      else       { 
         /*-           Dump number of colors and colormap. 
         */#         switch (image->compression) 	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */6             number_packets=image->columns*image->rows;$             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image);              /*&               Dump GIF encoded pixels.             */             q=pixels; .             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++).                 *q++=(unsigned char) p->index;               p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             } J             (void) PackbitsEncodeImage(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)D                 Ascii85Encode((unsigned char) p->index,image->file);               p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             } &             Ascii85Flush(image->file);             break;           } 	         }        } #   length=ftell(image->file)-length; .   (void) fprintf(image->file,"\nendstream\n");)   (void) fprintf(image->file,"endobj\n");    /*     Write Length object.   */   xref[9]=ftell(image->file); +   (void) fprintf(image->file,"10 0 obj\n"); ,   (void) fprintf(image->file,"%u\n",length);)   (void) fprintf(image->file,"endobj\n");    /*     Write Colorspace object.   */   xref[10]=ftell(image->file);+   (void) fprintf(image->file,"11 0 obj\n"); 3   if (!IsPseudoClass(image) && !IsGrayImage(image)) /     (void) fprintf(image->file,"/DeviceRGB\n");    else3     if (IsGrayImage(image) && (image->colors == 2)) 2       (void) fprintf(image->file,"/DeviceGray\n");     elseG       (void) fprintf(image->file,"[ /Indexed /DeviceRGB %u 14 0 R ]\n",          image->colors-1); )   (void) fprintf(image->file,"endobj\n");    /*     Write Thumb object.    */   image->orphan=True; >   ParseImageGeometry(DefaultThumbnailGeometry,&width,&height);"   if (image->class == PseudoClass)/     tile_image=SampleImage(image,width,height);    else<     tile_image=ZoomImage(image,width,height,MitchellFilter);   image->orphan=False;#   if (tile_image == (Image *) NULL) 5     PrematureExit("Unable to allocate memory",image);    xref[11]=ftell(image->file);+   (void) fprintf(image->file,"12 0 obj\n"); %   (void) fprintf(image->file,"<<\n"); *   if (image->compression == NoCompression);     (void) fprintf(image->file,"/Filter /ASCII85Decode\n");    elseP     (void) fprintf(image->file,"/Filter [ /ASCII85Decode /RunLengthDecode ]\n");@   (void) fprintf(image->file,"/Width %u\n",tile_image->columns);>   (void) fprintf(image->file,"/Height %u\n",tile_image->rows);5   (void) fprintf(image->file,"/ColorSpace 11 0 R\n"); 6   (void) fprintf(image->file,"/BitsPerComponent %d\n",B     IsGrayImage(tile_image) && (tile_image->colors == 2) ? 1 : 8);1   (void) fprintf(image->file,"/Length 13 0 R\n"); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"stream\n");    length=ftell(image->file);   p=tile_image->pixels; !   if (!IsPseudoClass(tile_image)) $     switch (tile_image->compression)     { '       case RunlengthEncodedCompression:        default:       { 
         /*           Allocate pixel array. 
         */>         number_packets=3*tile_image->columns*tile_image->rows;N         pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)            { %             DestroyImage(tile_image); =             PrematureExit("Unable to allocate memory",image);            } 
         /*(           Dump runlength encoded pixels.
         */         q=pixels; /         for (i=0; i < tile_image->packets; i++) 	         { .           for (j=0; j <= (int) p->length; j++)           { ?             if (tile_image->matte && (p->index == Transparent))                { '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB); '                 *q++=DownScale(MaxRGB);                }              else               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }            }            p++;	         } F         (void) PackbitsEncodeImage(image->file,pixels,number_packets);         free((char *) pixels);         break;       }        case NoCompression:        { 
         /*0           Dump uncompressed DirectColor packets.
         */         Ascii85Initialize();/         for (i=0; i < tile_image->packets; i++) 	         { 0           for (j=0; j <= ((int) p->length); j++)           { ?             if (tile_image->matte && (p->index == Transparent))                { =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file); =                 Ascii85Encode(DownScale(MaxRGB),image->file);                }              else               { =                 Ascii85Encode(DownScale(p->red),image->file); ?                 Ascii85Encode(DownScale(p->green),image->file); >                 Ascii85Encode(DownScale(p->blue),image->file);               }            }            p++;	         } "         Ascii85Flush(image->file);         break;       }      }    else=     if (IsGrayImage(tile_image) && (tile_image->colors == 2))        {          register unsigned char           bit,           byte,            polarity;   5         polarity=Intensity(tile_image->colormap[0]) < -           Intensity(tile_image->colormap[1]);          bit=0;         byte=0;          x=0;(         switch (tile_image->compression)	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */K             number_packets=((tile_image->columns+7) >> 3)*tile_image->rows; $             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL)                { )                 DestroyImage(tile_image); A                 PrematureExit("Unable to allocate memory",image);                }              /*&               Dump GIF encoded pixels.             */             q=pixels; 3             for (i=0; i < tile_image->packets; i++) 
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;                    }                  x++;-                 if (x == tile_image->columns)                    {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte << (8-bit);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;
             } J             (void) PackbitsEncodeImage(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();3             for (i=0; i < tile_image->packets; i++) 
             { 2               for (j=0; j <= (int) p->length; j++)               {                  byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;                  bit++;                 if (bit == 8)                    { 4                     Ascii85Encode(byte,image->file);                     bit=0;                     byte=0;                    }                  x++;-                 if (x == tile_image->columns)                    {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) A                       Ascii85Encode(byte << (8-bit),image->file);                      bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }        }      else       { 
         /*-           Dump number of colors and colormap. 
         */(         switch (tile_image->compression)	         { +           case RunlengthEncodedCompression:            default:           {              /*#               Allocate pixel array.              */@             number_packets=tile_image->columns*tile_image->rows;$             pixels=(unsigned char *);               malloc(number_packets*sizeof(unsigned char)); 1             if (pixels == (unsigned char *) NULL)                { )                 DestroyImage(tile_image); A                 PrematureExit("Unable to allocate memory",image);                }              /*&               Dump GIF encoded pixels.             */             q=pixels; 3             for (i=0; i < tile_image->packets; i++) 
             { 2               for (j=0; j <= (int) p->length; j++).                 *q++=(unsigned char) p->index;               p++;
             } J             (void) PackbitsEncodeImage(image->file,pixels,number_packets);"             free((char *) pixels);             break;           }            case NoCompression:            {              /*4               Dump uncompressed PseudoColor packets.             */              Ascii85Initialize();3             for (i=0; i < tile_image->packets; i++) 
             { 4               for (j=0; j <= ((int) p->length); j++)D                 Ascii85Encode((unsigned char) p->index,image->file);               p++;
             } &             Ascii85Flush(image->file);             break;           } 	         }        }    DestroyImage(tile_image); #   length=ftell(image->file)-length; .   (void) fprintf(image->file,"\nendstream\n");)   (void) fprintf(image->file,"endobj\n");    /*     Write Length object.   */   xref[12]=ftell(image->file);+   (void) fprintf(image->file,"13 0 obj\n"); ,   (void) fprintf(image->file,"%u\n",length);)   (void) fprintf(image->file,"endobj\n");    number_objects=13;"   if (image->class == PseudoClass)4     if (!IsGrayImage(image) || (image->colors != 2))       { 
         /*            Write Colormap object.
         */         number_objects+=2;$         xref[13]=ftell(image->file);1         (void) fprintf(image->file,"14 0 obj\n"); +         (void) fprintf(image->file,"<<\n"); @         (void) fprintf(image->file,"/Filter /ASCII85Decode \n");7         (void) fprintf(image->file,"/Length 15 0 R\n"); +         (void) fprintf(image->file,">>\n"); /         (void) fprintf(image->file,"stream\n"); "         length=ftell(image->file);         Ascii85Initialize();)         for (i=0; i < image->colors; i++) 	         { G           Ascii85Encode(DownScale(image->colormap[i].red),image->file); I           Ascii85Encode(DownScale(image->colormap[i].green),image->file); H           Ascii85Encode(DownScale(image->colormap[i].blue),image->file);	         } "         Ascii85Flush(image->file);)         length=ftell(image->file)-length; 4         (void) fprintf(image->file,"\nendstream\n");/         (void) fprintf(image->file,"endobj\n"); 
         /*           Write Length object.
         */$         xref[14]=ftell(image->file);1         (void) fprintf(image->file,"15 0 obj\n"); 2         (void) fprintf(image->file,"%u\n",length);/         (void) fprintf(image->file,"endobj\n");        }    /*     Write Xref object.   */'   length=ftell(image->file)-xref[0]+10; '   (void) fprintf(image->file,"xref\n");%8   (void) fprintf(image->file,"0 %u\n",number_objects+1);6   (void) fprintf(image->file,"0000000000 65535 f \n");$   for (i=0; i < number_objects; i++);     (void) fprintf(image->file,"%010d 00000 n \n",xref[i]); *   (void) fprintf(image->file,"trailer\n");%   (void) fprintf(image->file,"<<\n"); <   (void) fprintf(image->file,"/Size %u\n",number_objects+1);.   (void) fprintf(image->file,"/Info 1 0 R\n");.   (void) fprintf(image->file,"/Root 2 0 R\n");%   (void) fprintf(image->file,">>\n"); ,   (void) fprintf(image->file,"startxref\n");,   (void) fprintf(image->file,"%u\n",length);*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   if (image->temporary)      { 
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);         if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);        c=fgetc(file);       while (c != EOF)       { )         (void) putc(c,encode_image.file);          c=fgetc(file);       }        (void) fclose(file);%       (void) unlink(image->filename);a        CloseImage(&encode_image);     }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %uO %   W r i t e P I C T I m a g e                                               % O %                                                                             %yO %                                                                             %aO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t % K %  Function WritePICTImage writes an image to a file in the Apple Macintosho %  QuickDraw/PICT image format.P % / %  The format of the WritePICTImage routine is:d %t. %      status=WritePICTImage(image_info,image) %s+ %  A description of each parameter follows.r %eK %    o status: Function WritePICTImage return True if the image is written.yK %      False is returned is there is a memory shortage or if the image filen %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WritePICTImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;w {  #define MaxCount  128s #define PictCropRegionOp  0x01  #define PictEndOfPictureOp  0xff #define PictHeaderOp  0x0C00 #define PictHeaderSize  512u #define PictPixmapOp  0x9A #define PictPICTOp  0x98 #define PictVersion  0x11m     typedef struct _PICTRectangles   {s     unsigned short
       top,       left,f
       bottom,        right;   } PICTRectangle;     typedef struct _PICTPixmap   {r     unsigned short       base_address,w       row_bytes;       PICTRectanglew
       bounds;        unsigned short       version,       pack_type;       unsigned long        pack_size,       horizontal_resolution,       vertical_resolution;       unsigned short       pixel_type,c       pixel_size,`       component_count,       component_size;m       unsigned short       plane_bytes,       table,       reserved;h   } PICTPixmap;F     int 
     count;     PICTPixmap     pixmap;      PICTRectanglea     crop_rectangle,f     destination_rectangle,     frame_rectangle,     size_rectangle,n     source_rectangle;e     register int     i,     j,     x;     register RunlengthPacket     *p;n     unsigned charn     *buffer,     *packed_scanline,n     *scanline;     unsigned int     bytes_per_line;      unsigned short     transfer_mode;     unsigned longI     horizontal_resolution,     vertical_resolution;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)g/     PrematureExit("Unable to open file",image);a   /*     Allocate memory.   */    bytes_per_line=image->columns;"   if (image->class == DirectClass)     bytes_per_line*=3;H   buffer=(unsigned char *) malloc(PictHeaderSize*sizeof(unsigned char));#   packed_scanline=(unsigned char *)eM     malloc((bytes_per_line+bytes_per_line/MaxCount+1)*sizeof(unsigned char));)J   scanline=(unsigned char *) malloc(bytes_per_line*sizeof(unsigned char));+   if ((buffer == (unsigned char *) NULL) ||e4       (packed_scanline == (unsigned char *) NULL) ||+       (scanline == (unsigned char *) NULL))m5     PrematureExit("Unable to allocate memory",image);D   /*     Initialize image info.   */   size_rectangle.top=0;f   size_rectangle.left=0;#   size_rectangle.right=image->rows;,'   size_rectangle.bottom=image->columns;I!   frame_rectangle=size_rectangle;e    crop_rectangle=size_rectangle;"   source_rectangle=size_rectangle;'   destination_rectangle=size_rectangle;*#   horizontal_resolution=0x00480000;e!   vertical_resolution=0x00480000;D   pixmap.base_address=0xff;o   pixmap.row_bytes=tD     ((image->class == DirectClass ? 4 : 1)*image->columns) | 0x8000;   pixmap.version=0;,   pixmap.bounds.top=0;   pixmap.bounds.left=0;,"   pixmap.bounds.right=image->rows;&   pixmap.bounds.bottom=image->columns;=   pixmap.pack_type=(image->class == DirectClass ? 0x4 : 0x0);o   pixmap.pack_size=0;T5   pixmap.horizontal_resolution=horizontal_resolution;I1   pixmap.vertical_resolution=vertical_resolution;I;   pixmap.pixel_type=(image->class == DirectClass ? 16 : 0);c;   pixmap.pixel_size=(image->class == DirectClass ? 32 : 8);e?   pixmap.component_count=(image->class == DirectClass ? 3 : 1);,   pixmap.component_size=8;   pixmap.plane_bytes=0;    pixmap.table=0;r   pixmap.reserved=0;9   transfer_mode=(image->class == DirectClass ? 0x40 : 0);r   /*H     Write header, header size, size bounding box, version, and reserved.   */$   for (i=0; i < PictHeaderSize; i++)     buffer[i]=0;>   (void) fwrite((char *) buffer,1,PictHeaderSize,image->file);$   MSBFirstWriteShort(0,image->file);5   MSBFirstWriteShort(size_rectangle.top,image->file); 6   MSBFirstWriteShort(size_rectangle.left,image->file);7   MSBFirstWriteShort(size_rectangle.right,image->file); 8   MSBFirstWriteShort(size_rectangle.bottom,image->file);.   MSBFirstWriteShort(PictVersion,image->file);)   MSBFirstWriteShort(0x02FF,image->file); /   MSBFirstWriteShort(PictHeaderOp,image->file);    /*N     Write full size of the file, resolution, frame bounding box, and reserved.   */-   MSBFirstWriteLong(0xFFFE0000L,image->file); 7   MSBFirstWriteLong(horizontal_resolution,image->file); 5   MSBFirstWriteLong(vertical_resolution,image->file);%6   MSBFirstWriteShort(frame_rectangle.top,image->file);7   MSBFirstWriteShort(frame_rectangle.left,image->file);T8   MSBFirstWriteShort(frame_rectangle.right,image->file);9   MSBFirstWriteShort(frame_rectangle.bottom,image->file);o$   MSBFirstWriteLong(0L,image->file);   /*3     Write crop region opcode and crop bounding box.    */3   MSBFirstWriteShort(PictCropRegionOp,image->file);r&   MSBFirstWriteShort(0xA,image->file);5   MSBFirstWriteShort(crop_rectangle.top,image->file);t6   MSBFirstWriteShort(crop_rectangle.left,image->file);7   MSBFirstWriteShort(crop_rectangle.right,image->file);r8   MSBFirstWriteShort(crop_rectangle.bottom,image->file);   /*K     Write picture opcode, row bytes, and picture bounding box, and version.t   */"   if (image->class == PseudoClass)/     MSBFirstWriteShort(PictPICTOp,image->file);    else     { 3       MSBFirstWriteShort(PictPixmapOp,image->file);oI       MSBFirstWriteLong((unsigned long) pixmap.base_address,image->file);      }g<   MSBFirstWriteShort(pixmap.row_bytes | 0x8000,image->file);4   MSBFirstWriteShort(pixmap.bounds.top,image->file);5   MSBFirstWriteShort(pixmap.bounds.left,image->file);d6   MSBFirstWriteShort(pixmap.bounds.right,image->file);7   MSBFirstWriteShort(pixmap.bounds.bottom,image->file);;1   MSBFirstWriteShort(pixmap.version,image->file);o   /*G     Write pack type, pack size, resolution, pixel type, and pixel size.-   */3   MSBFirstWriteShort(pixmap.pack_type,image->file);e2   MSBFirstWriteLong(pixmap.pack_size,image->file);>   MSBFirstWriteLong(pixmap.horizontal_resolution,image->file);<   MSBFirstWriteLong(pixmap.vertical_resolution,image->file);4   MSBFirstWriteShort(pixmap.pixel_type,image->file);4   MSBFirstWriteShort(pixmap.pixel_size,image->file);   /*G     Write component count, size, plane bytes, table size, and reserved.%   */9   MSBFirstWriteShort(pixmap.component_count,image->file); 8   MSBFirstWriteShort(pixmap.component_size,image->file);D   MSBFirstWriteLong((unsigned long) pixmap.plane_bytes,image->file);>   MSBFirstWriteLong((unsigned long) pixmap.table,image->file);A   MSBFirstWriteLong((unsigned long) pixmap.reserved,image->file); "   if (image->class == PseudoClass)     {        unsigned short         red,         green,
         blue;          /*         Write image colormap.        */:       MSBFirstWriteLong(0L,image->file);  /* color seed */<       MSBFirstWriteShort(0L,image->file);  /* color flags */I       MSBFirstWriteShort((unsigned short) (image->colors-1),image->file);B'       for (i=0; i < image->colors; i++)o       { B         red=(unsigned int) (image->colormap[i].red*65535L)/MaxRGB;F         green=(unsigned int) (image->colormap[i].green*65535L)/MaxRGB;D         blue=(unsigned int) (image->colormap[i].blue*65535L)/MaxRGB;9         MSBFirstWriteShort((unsigned int) i,image->file);F,         MSBFirstWriteShort(red,image->file);.         MSBFirstWriteShort(green,image->file);-         MSBFirstWriteShort(blue,image->file);n       }o     }u   /*+     Write source and destination rectangle.t   */7   MSBFirstWriteShort(source_rectangle.top,image->file);i8   MSBFirstWriteShort(source_rectangle.left,image->file);9   MSBFirstWriteShort(source_rectangle.right,image->file); :   MSBFirstWriteShort(source_rectangle.bottom,image->file);<   MSBFirstWriteShort(destination_rectangle.top,image->file);=   MSBFirstWriteShort(destination_rectangle.left,image->file); >   MSBFirstWriteShort(destination_rectangle.right,image->file);?   MSBFirstWriteShort(destination_rectangle.bottom,image->file);l0   MSBFirstWriteShort(transfer_mode,image->file);   /*     Write picture data.    */
   count=0;   x=0;   p=image->pixels;"   if (image->class == PseudoClass)     {        register unsigned char         *index;n         index=scanline; (       for (i=0; i < image->packets; i++)       {i,         for (j=0; j <= (int) p->length; j++)	         {m,           *index++=(unsigned char) p->index;           x++;"           if (x == image->columns)
             {iE               count+=PICTEncodeImage(image,scanline,packed_scanline);e               index=scanline;_               x=0;
             }_	         }          p++;!         if (QuantumTick(i,image))m:           ProgressMonitor(SaveImageText,i,image->packets);       }      }    else     {r       register unsigned char         *blue,
         *red,          *green;          red=scanline; $       green=scanline+image->columns;*       blue=scanline+(image->columns << 1);(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {_#           *red++=DownScale(p->red); '           *green++=DownScale(p->green);m%           *blue++=DownScale(p->blue);r           x++;"           if (x == image->columns)
             {r               red=scanline;d,               green=scanline+image->columns;2               blue=scanline+(image->columns << 1);@               count+=PICTEncodeImage(image,red,packed_scanline);               x=0;
             }i	         }n         p++;!         if (QuantumTick(i,image))r:           ProgressMonitor(SaveImageText,i,image->packets);       }m     }r   if (count & 0x1)#     (void) fputc('\0',image->file);d5   MSBFirstWriteShort(PictEndOfPictureOp,image->file);_   free((char *) scanline);!   free((char *) packed_scanline);r   free((char *) buffer);   CloseImage(image);   return(True);b }h e
 #ifdef HasPNGz #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %tO %                                                                             % O %                                                                             % O %   W r i t e P N G I m a g e                                                 %;O %                                                                             % O %                                                                             % O %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %)J %  Function WritePNGImage writes an image in the Portable Network Graphics %  encoded image format. % . %  The format of the WritePNGImage routine is: % - %      status=WritePNGImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePNGImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePNGImage(image_info,image)e	 ImageInfop   *image_info;   Image 	   *image;  {    int      length;      register int     i,     j;     register RunlengthPacket     *p;,     register unsigned char     *q;   
   png_info     *ping_info;      png_struct
     *ping;     unsigned charo     *png_pixels,     **scanlines;     unsigned int     bytes_per_line,u     x,     y;     unsigned short
     value;     /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);t   /*     Allocate the PNG structuresg   */1   ping=(png_struct *) malloc(sizeof(png_struct));n2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Prepare PNG for writing.   */   png_info_init(ping_info);    png_write_init(ping);     png_init_io(ping,image->file);"   ping_info->width=image->columns;    ping_info->height=image->rows;   ping_info->bit_depth=8; <   if ((image->class == DirectClass) && (image->depth == 16))     ping_info->bit_depth=16;+   ping_info->color_type=PNG_COLOR_TYPE_RGB;    if (image->matte)t3     ping_info->color_type=PNG_COLOR_TYPE_RGB_ALPHA;+$   ping_info->bit_depth=image->depth;   ping_info->num_palette=0;    if (IsGrayImage(image))D.     ping_info->color_type=PNG_COLOR_TYPE_GRAY;   else@     if ((image->class == PseudoClass) && (image->colors <= 256))       {(
         /*           Set image palette.
         */5         ping_info->color_type=PNG_COLOR_TYPE_PALETTE;e-         ping_info->num_palette=image->colors; (         ping_info->valid|=PNG_INFO_PLTE;(         ping_info->palette=(png_color *)3           malloc(image->columns*sizeof(png_color)); 5         if (ping_info->palette == (png_color *) NULL)u;           PrematureExit("Unable to allocate memory",image);p)         for (i=0; i < image->colors; i++)t	         { F           ping_info->palette[i].red=DownScale(image->colormap[i].red);J           ping_info->palette[i].green=DownScale(image->colormap[i].green);H           ping_info->palette[i].blue=DownScale(image->colormap[i].blue);	         }h         ping_info->bit_depth=1;=;         while ((1 << ping_info->bit_depth) < image->colors)n#           ping_info->bit_depth<<=1;)       }    if (image->gamma != 0.0)     {e       /*         Note image gamma.        */&       ping_info->valid|=PNG_INFO_gAMA;$       ping_info->gamma=image->gamma;     }iC   ping_info->interlace_type=image_info->interlace != NoneInterlace; !   png_write_info(ping,ping_info);    png_set_packing(ping);   /*     Allocate memory.   */   bytes_per_line= I     Max((int) ping_info->bit_depth >> 3,1)*ping->channels*image->columns;e   png_pixels=(unsigned char *)=     malloc(bytes_per_line*image->rows*sizeof(unsigned char)); K   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *));n/   if ((png_pixels == (unsigned char *) NULL) ||r-       (scanlines == (unsigned char **) NULL)) 5     PrematureExit("Unable to allocate memory",image);S   /*     Initialize image scanlines.-   */!   for (i=0; i < image->rows; i++)e/     scanlines[i]=png_pixels+(bytes_per_line*i);p   x=0;   y=0;   p=image->pixels;   q=scanlines[y];(   if (IsGrayImage(image))e&     for (i=0; i < image->packets; i++)     {e,       for (j=0; j <= ((int) p->length); j++)       {x&         WriteQuantum(Intensity(*p),q);         x++;          if (x == image->columns)           {n             x=0;             y++;             q=scanlines[y];m           }r       }n
       p++;       if (QuantumTick(i,image))u8         ProgressMonitor(SaveImageText,i,image->packets);     }a   else?     if ((image->class == DirectClass) || (image->colors > 256))m(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {f!           WriteQuantum(p->red,q); #           WriteQuantum(p->green,q);l"           WriteQuantum(p->blue,q);           if (image->matte) %             WriteQuantum(p->index,q);            x++;"           if (x == image->columns)
             {                x=0;               y++;               q=scanlines[y];i
             }i	         }          p++;!         if (QuantumTick(i,image))t:           ProgressMonitor(SaveImageText,i,image->packets);       }      else(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {p           *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y++;               q=scanlines[y]; 
             })	         }e         p++;!         if (QuantumTick(i,image))m:           ProgressMonitor(SaveImageText,i,image->packets);       }m   /*     Write image scanlines.   */"   png_write_image(ping,scanlines);'   if (image->comments != (char *) NULL)%     {%       /*         Write image comment.       */%       length=strlen(image->comments); !       if (length < MaxTextLength) E         (void) png_write_tEXt(ping,"Comment",image->comments,length); 
       elseG         (void) png_write_zTXt(ping,"Comment",image->comments,length,0);      }     png_write_end(ping,ping_info);   /*     Free memory.   */   png_write_destroy(ping);   if (ping->palette)     free(ping->palette);
   free(ping);    free(ping_info);   CloseImage(image);   return(True);  }  #else 3 static unsigned int WritePNGImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;%  :   Warning("PNG library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);a }t #endif o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %hO %                                                                             %hO %                                                                             %fO %   W r i t e P N M I m a g e                                                 %tO %                                                                             %.O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %iJ %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. %i. %  The format of the WritePNMImage routine is: %y- %      status=WritePNMImage(image_info,image)  %r+ %  A description of each parameter follows.  % J %    o status: Function WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %>A %    o image_info: Specifies a pointer to an ImageInfo structure.  %f. %    o image:  A pointer to a Image structure. %n %d */3 static unsigned int WritePNMImage(image_info,image) 	 ImageInfon   *image_info;   Image:	   *image;  {  #define MaxRawValue  255     register int     i,     j;     register RunlengthPacket     *p;o     unsigned charp     format;      /*     Open output image file.t   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)>/     PrematureExit("Unable to open file",image);    do   {n     /*/       Promote/Demote image based on image type.e     */.     if (strcmp(image_info->magick,"PPM") == 0)       image->class=DirectClass;i     else0       if (strcmp(image_info->magick,"PGM") == 0)0         RGBTransformImage(image,GRAYColorspace);
       else2         if (strcmp(image_info->magick,"PBM") == 0):           if (!IsGrayImage(image) || (image->colors != 2))
             {*I               QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);                SyncImage(image);x
             }e     /*       Write PNM file header.     */5     if (!IsPseudoClass(image) && !IsGrayImage(image)),       { 
         /*           Full color PNM image.C
         */         format='6'; !         if (MaxRGB > MaxRawValue)a           format='3';u       };     else       { 
         /*            Colormapped PNM image.
         */         format='6'; !         if (MaxRGB > MaxRawValue)            format='3'; J         if (IsGrayImage(image) && (strcmp(image_info->magick,"PPM") != 0))           {b             /*"               Grayscale PNM image.             */             format='5'; %             if (MaxRGB > MaxRawValue)                format='2';r6             if (strcmp(image_info->magick,"PGM") != 0)%               if (image->colors == 2)=                 format='4';n           }        } /     (void) fprintf(image->file,"P%c\n",format);y)     if (image->comments != (char *) NULL)B       {;         register charG
           *p;    
         /*!           Write comments to file. 
         */)         (void) fprintf(image->file,"# ");k0         for (p=image->comments; *p != '\0'; p++)	         {n'           (void) fputc(*p,image->file);            if (*p == '\n') -             (void) fprintf(image->file,"# "); 	         }x'         (void) fputc('\n',image->file);        } E     (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);l     /*5       Convert runlength encoded to PNM raster pixels.t     */     p=image->pixels;     switch (format)f     {w       case '2':        {c         register int           x;   
         /*'           Convert image to a PGM image. 
         */2         (void) fprintf(image->file,"%d\n",MaxRGB);         x=0;*         for (i=0; i < image->packets; i++)	         {n0           for (j=0; j <= ((int) p->length); j++)           { 6             (void) fprintf(image->file,"%5d ",p->red);             x++;             if (x == 12)               { 1                 (void) fprintf(image->file,"\n");                  x=0;               }            }t           p++;#           if (QuantumTick(i,image))g<             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }:       case '3':*       {          register int           x;   
         /*'           Convert image to a PNM image. 
         */2         (void) fprintf(image->file,"%d\n",MaxRGB);         x=0;*         for (i=0; i < image->packets; i++)	         {-0           for (j=0; j <= ((int) p->length); j++)           {xO             (void) fprintf(image->file,"%5d %5d %5d ",p->red,p->green,p->blue);              x++;             if (x == 4)k               {l1                 (void) fprintf(image->file,"\n");i                 x=0;               }            }+           p++;#           if (QuantumTick(i,image)),<             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }0       case '4':l       {+         register unsigned char           bit,           byte,=           polarity;             unsigned int           x;   
         /*'           Convert image to a PBM image. 
         */         polarity=0;l         if (image->colors == 2)e           polarity=tJ             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);         bit=0;         byte=0;o         x=0;*         for (i=0; i < image->packets; i++)	         {0.           for (j=0; j <= (int) p->length; j++)           {(             byte<<=1; %             if (p->index == polarity)e               byte|=0x01;G             bit++;             if (bit == 8)                {k/                 (void) fputc(byte,image->file);                  bit=0;                 byte=0;c               }b             x++;$             if (x == image->columns)               {r                 /*/                   Advance to the next scanline.(                 */                 if (bit != 0) <                   (void) fputc(byte << (8-bit),image->file);                 bit=0;                 byte=0;                  x=0;              }           }R           p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }t         break;       }<       case '5':        {=
         /*'           Convert image to a PGM image.b
         */=         (void) fprintf(image->file,"%u\n",DownScale(MaxRGB));s*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)8             (void) fputc(DownScale(p->red),image->file);           p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }        case '6':        { 
         /*'           Convert image to a PNM image. 
         */=         (void) fprintf(image->file,"%u\n",DownScale(MaxRGB)); *         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { 8             (void) fputc(DownScale(p->red),image->file);:             (void) fputc(DownScale(p->green),image->file);9             (void) fputc(DownScale(p->blue),image->file);%           }%           p++;#           if (QuantumTick(i,image))%<             ProgressMonitor(SaveImageText,i,image->packets);	         }i         break;       }c     }r&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);r   CloseImage(image);   return(True);  }t X /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %:O %                                                                             % O %                                                                             %eO %   W r i t e P S I m a g e                                                   %tO %                                                                             %iO %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %mG %  Function WritePSImage translates an image to encapsulated PostscriptgH %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.i %e- %  The format of the WritePSImage routine is:n %a, %      status=WritePSImage(image_info,image) %%+ %  A description of each parameter follows:% % I %    o status: Function WritePSImage return True if the image is printed. I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */2 static unsigned int WritePSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 
   static char      *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",%G       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",s       "/byte 1 string def",5#       "/color_packet 3 string def",I       "/pixels 768 string def",s	       "",F       "/DirectClassPacket", 
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters:",       "  %   red.",        "  %   green.",n       "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",f       "  %",9       "  currentfile color_packet readhexstring pop pop",p       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",a       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",u0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse",e"       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",o       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def",l	       "",i       "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",n       "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",,       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",        "    %",       "    columns rows 8",t       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",v       "} bind def",N	       "",        "/GrayDirectClassPacket", 
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",=       "  %",       "  % Parameters:",       "  %   red",       "  %   green",       "  %   blue",pK       "  %   length: number of pixels minus one of this color (optional).",0       "  %",9       "  currentfile color_packet readhexstring pop pop",y'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add",m+       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",l       "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",)*       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",%       "} bind def",%	       "",        "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",        "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",%       "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",o       "  {",!       "    /number_pixels 1 def",C       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",e*       "    /number_pixels exch 1 add def",       "  } ifelse",A"       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",s       "} bind def", 	       "",e       "/PseudoClassPacket",.
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def",p:       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",t       "  {",!       "    /number_pixels 3 def",i       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",e0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse",U"       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",N       "  } for",-       "  pixels 0 number_pixels getinterval",f       "} bind def",a	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",>       "  %",       "  % Parameters:",3       "  %   class: 0-PseudoClass or 1-Grayscale.",        "  %",*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",       "  class 0 gt",f       "  {",,       "    currentfile buffer readline pop",*       "    token pop /depth exch def pop",&       "    /grays columns string def",       "    columns rows depth",t       "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",:       "    { currentfile grays readhexstring pop } image",       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colors: number of colors in the colormap.",:       "    %   colormap: red, green, blue color packets.",       "    %",,       "    currentfile buffer readline pop",+       "    token pop /colors exch def pop",)%       "    /colors colors 3 mul def",)(       "    /colormap colors string def",7       "    currentfile colormap readhexstring pop pop",c)       "    systemdict /colorimage known",0       "    {",       "      columns rows 8",-       "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",7       "      { PseudoClassPacket } false 3 colorimage",        "    }",       "    {",       "      %",?       "      % No colorimage operator;  convert to grayscale.",z       "      %",       "      columns rows 8",s       "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",.       "      { GrayPseudoClassPacket } image",       "    } ifelse",r       "  } ifelse",t       "} bind def",c	       "",)       "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",n       "  %   x & y scale.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.",oM       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",o       "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        (char *) NULLr     };     char     date[MaxTextLength],     *label,t     **q;     float      dx_resolution,     dy_resolution,     x_resolution,      y_resolution;;     int      length,      x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned int     bit,	     byte,N
     count,     height, 
     polarity,      text_size,
     width;     /*     Open output image file.    */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL)0/     PrematureExit("Unable to open file",image);i   do   {;     /*-       Scale image to size of Postscript page.      */5     text_size=image->label == (char *) NULL ? 0 : 36;i     x=0;     y=0;     width=image->columns;m     height=image->rows; -     if (strcmp(image_info->magick,"PS") == 0)        {          int            delta_x,           delta_y,           flags;           unsigned int           page_height,           page_width;   
         /**           Center image on Postscript page.
         */M         (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);          flags=NoValue;.         if (image_info->page != (char *) NULL)P           flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);.         if (((page_width-(x << 1)) < width) ||8             ((page_height-(y << 1)-text_size) < height))           {a             unsigned longt               scale_factor;f               /*6               Scale image relative to Postscript page.             */<             scale_factor=UpShift(page_width-(x << 1))/width;P             if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))J               scale_factor=UpShift(page_height-(y << 1)-text_size)/height;0             width=DownShift(width*scale_factor);2             height=DownShift(height*scale_factor);           };"         if ((flags & XValue) == 0)           {.             /*.               Center image in the X direction.             */0             delta_x=page_width-(width+(x << 1));             if (delta_x >= 0) !               x=(delta_x >> 1)+x;a           }l"         if ((flags & YValue) == 0)           {              /*.               Center image in the X direction.             */<             delta_y=page_height-(height+(y << 1))-text_size;             if (delta_y >= 0)u!               y=(delta_y >> 1)+y;e           }-       }      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;a     x_resolution=72.0;H     count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL))L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2);        y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     /*       Output Postscript header.      */-     if (strcmp(image_info->magick,"PS") == 0)n6       (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");     else?       (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n");c?     (void) fprintf(image->file,"%%%%Creator: (ImageMagick)\n"); D     (void) fprintf(image->file,"%%%%Title: (%s)\n",image->filename);      timer=time((time_t *) NULL);     (void) localtime(&timer); &     (void) strcpy(date,ctime(&timer));     date[strlen(date)-1]='\0';@     (void) fprintf(image->file,"%%%%CreationDate: (%s)\n",date);D     (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);&     if (image->label != (char *) NULL)!       (void) fprintf(image->file, F         "%%%%DocumentNeededResources: font NewCenturySchlbk-Roman\n");@     (void) fprintf(image->file,"%%%%DocumentData: Clean7Bit\n");9     (void) fprintf(image->file,"%%%%LanguageLevel: 1\n");m-     if (strcmp(image_info->magick,"PS") == 0);       { B         (void) fprintf(image->file,"%%%%Orientation: Portrait\n");>         (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");       }e1     (void) fprintf(image->file,"%%%%Pages: %d\n",l,       strcmp(image_info->magick,"PS") == 0);4     (void) fprintf(image->file,"%%%%EndComments\n");8     (void) fprintf(image->file,"\n%%%%BeginDefaults\n");B     (void) fprintf(image->file,"%%%%PageOrientation: Portrait\n");6     (void) fprintf(image->file,"%%%%EndDefaults\n\n");/     if (strcmp(image_info->magick,"EPSI") == 0)l       {f
         Image=           *preview_image;a  
         /*           Create preview image.i
         */         image->orphan=True;eG         preview_image=CopyImage(image,image->columns,image->rows,True);%         image->orphan=False;,         if (preview_image == (Image *) NULL);           PrematureExit("Unable to allocate memory",image); 
         /*           Dump image as bitmap. 
         */8         if (!IsGrayImage(image) || (image->colors != 2))           { O             QuantizeImage(preview_image,2,8,image_info->dither,GRAYColorspace); %             SyncImage(preview_image);            }          polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);         bit=0;         byte=0;          count=0;         x=0;          p=preview_image->pixels;I         (void) fprintf(image->file,"%%%%BeginPreview: %u %u %u %u\n%%  ",eF           preview_image->columns,preview_image->rows,(unsigned int) 1,I           (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36);a2         for (i=0; i < preview_image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              byte<<=1; %             if (p->index == polarity)r               byte|=0x01;f             bit++;             if (bit == 8)i               {p?                 (void) fprintf(image->file,"%02x",byte & 0xff);t                 count++;                  if (count == 36)                   {m9                     (void) fprintf(image->file,"\n%%  ");                      count=0;                   };                 bit=0;                 byte=0;                }p             x++;,             if (x == preview_image->columns)               {                  if (bit != 0)e                   {*#                     byte<<=(8-bit);uC                     (void) fprintf(image->file,"%02x",byte & 0xff);e                     count++;$                     if (count == 36)                       {*=                         (void) fprintf(image->file,"\n%%  ");o                          count=0;                       };                     bit=0;                     byte=0;%                   };                 x=0;               } 
             }              p++;           } ;           (void) fprintf(image->file,"\n%%%%EndPreview\n"); &           DestroyImage(preview_image);	         }      /*!       Output Postscript commands.      */     for (q=Postscript; *q; q++) ,       (void) fprintf(image->file,"%s\n",*q);-     if (strcmp(image_info->magick,"PS") == 0) 1       (void) fprintf(image->file,"  showpage\n"); /     (void) fprintf(image->file,"} bind def\n"); 2     (void) fprintf(image->file,"%%%%EndProlog\n");3     (void) fprintf(image->file,"%%%%Page:  1 1\n"); H     (void) fprintf(image->file,"%%%%PageBoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);&     if (image->label != (char *) NULL)!       (void) fprintf(image->file, <         "%%%%PageResources: font NewCenturySchlbk-Roman\n");-     if (strcmp(image_info->magick,"PS") != 0)A5       (void) fprintf(image->file,"userdict begin\n");a3     (void) fprintf(image->file,"%%%%BeginData:\n");i1     (void) fprintf(image->file,"DisplayImage\n");m     /*       Output image data.     */:     if (image->compression == RunlengthEncodedCompression)       CompressImage(image);      label=image->label;i     if (label == (char *) NULL)        label=" ";     p=image->pixels;     switch (image->class)i     {        case DirectClass:;       { #         (void) fprintf(image->file, J           "%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",x,y,width,height,G           label,image->columns,image->rows,image->class == PseudoClass, /           image->compression == NoCompression); #         switch (image->compression)k	         { +           case RunlengthEncodedCompression:p           default:           {a             /*9               Dump runlength-encoded DirectColor packets.o             */             x=0;.             for (i=0; i < image->packets; i++)
             {e>               for (length=p->length; length >= 0; length-=256)               { >                 if (image->matte && (p->index == Transparent))H                   (void) fprintf(image->file,"ffffff%02x",(unsigned int)&                     Min(length,0xff));                 else@                   (void) fprintf(image->file,"%02x%02x%02x%02x",M                     DownScale(p->red),DownScale(p->green),DownScale(p->blue), 5                     (unsigned int) Min(length,0xff));                  x++;                 if (x == 9)n                   {                      x=0;5                     (void) fprintf(image->file,"\n");                    }o               }B               p++;'               if (QuantumTick(i,image))L@                 ProgressMonitor(SaveImageText,i,image->packets);
             }              break;           }n           case NoCompression:            {              /*4               Dump uncompressed DirectColor packets.             */             x=0;.             for (i=0; i < image->packets; i++)
             {(4               for (j=0; j <= ((int) p->length); j++)               {,>                 if (image->matte && (p->index == Transparent))7                   (void) fprintf(image->file,"ffffff");                  elseN                   (void) fprintf(image->file,"%02x%02x%02x",DownScale(p->red),<                     DownScale(p->green),DownScale(p->blue));                 x++;                 if (x == 12)                   {                      x=0;5                     (void) fprintf(image->file,"\n");                    }                }l               p++;'               if (QuantumTick(i,image))l@                 ProgressMonitor(SaveImageText,i,image->packets);
             }              break;           } 	         }=         break;       }o       case PseudoClass:o       {          unsigned int           grayscale;  #         (void) fprintf(image->file, J           "%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",x,y,width,height,G           label,image->columns,image->rows,image->class == PseudoClass, /           image->compression == NoCompression);eN         grayscale=IsGrayImage(image) && (image->compression == NoCompression);5         (void) fprintf(image->file,"%u\n",grayscale);r         if (grayscale)H           (void) fprintf(image->file,"%d\n",image->colors == 2 ? 1 : 8);         else           {G             /*1               Dump number of colors and colormap.E             */=             (void) fprintf(image->file,"%u\n",image->colors); -             for (i=0; i < image->colors; i++) :               (void) fprintf(image->file,"%02x%02x%02x\n",2                 DownScale(image->colormap[i].red),4                 DownScale(image->colormap[i].green),4                 DownScale(image->colormap[i].blue));           } #         switch (image->compression))	         { +           case RunlengthEncodedCompression:            default:           {              /*9               Dump runlength-encoded PseudoColor packets.              */             x=0;.             for (i=0; i < image->packets; i++)
             { >               for (length=p->length; length >= 0; length-=256)               { N                 (void) fprintf(image->file,"%02x%02x",(unsigned int) p->index,3                   (unsigned int) Min(length,0xff));=                 x++;                 if (x == 18)                   {                      x=0;5                     (void) fprintf(image->file,"\n");m                   }v               },               p++;'               if (QuantumTick(i,image))=@                 ProgressMonitor(SaveImageText,i,image->packets);
             }o             break;           }            case NoCompression:            {s             /*4               Dump uncompressed PseudoColor packets.             */             x=0;             if (!grayscale) 0               for (i=0; i < image->packets; i++)               {f6                 for (j=0; j <= ((int) p->length); j++)                 {gM                   (void) fprintf(image->file,"%02x",(unsigned int) p->index);a                   x++;                   if (x == 36)                     {                        x=0;7                       (void) fprintf(image->file,"\n");N                     }m                 }o                 p++;)                 if (QuantumTick(i,image)) B                   ProgressMonitor(SaveImageText,i,image->packets);               }a             else%               if (image->colors != 2)e2                 for (i=0; i < image->packets; i++)                 {.8                   for (j=0; j <= ((int) p->length); j++)                   { I                     (void) fprintf(image->file,"%02x",DownScale(p->red));                      x++;                      if (x == 36)                       {h                         x=0;9                         (void) fprintf(image->file,"\n");(                       }                    }e                   p++;+                   if (QuantumTick(i,image))fD                     ProgressMonitor(SaveImageText,i,image->packets);                 }                else                 {>                   /*)                     Dump image as bitmap.                    */:                   polarity=Intensity(image->colormap[1]) >2                     Intensity(image->colormap[0]);                   bit=0;                   byte=0;                    count=0;                   x=0;"                   p=image->pixels;4                   for (i=0; i < image->packets; i++)                   { :                     for (j=0; j <= ((int) p->length); j++)                     {T                       byte<<=1; /                       if (p->index == polarity)h#                         byte|=0x01;m                       bit++;#                       if (bit == 8)m                         {-I                           (void) fprintf(image->file,"%02x",byte & 0xff);s"                           count++;*                           if (count == 36)                             { ?                               (void) fprintf(image->file,"\n");i&                               count=0;                             };                            bit=0;!                           byte=0;%                         }%                       x++;.                       if (x == image->columns)                         { '                           if (bit != 0)                              { -                               byte<<=(8-bit); M                               (void) fprintf(image->file,"%02x",byte & 0xff); &                               count++;.                               if (count == 36)!                                 { C                                   (void) fprintf(image->file,"\n"); *                                   count=0;"                                 };$                               bit=0;%                               byte=0;%                             };                           x=0;                         }R                       }s                       p++;/                       if (QuantumTick(i,image))cH                         ProgressMonitor(SaveImageText,i,image->packets);                     }e                   }e             break;           } 	         }m       }a     }i%     (void) fprintf(image->file,"\n");r0     (void) fprintf(image->file,"%%%%EndData\n");-     if (strcmp(image_info->magick,"PS") != 0) *       (void) fprintf(image->file,"end\n");4     (void) fprintf(image->file,"%%%%PageTrailer\n");0     (void) fprintf(image->file,"%%%%Trailer\n");,     (void) fprintf(image->file,"%%%%EOF\n");&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);m }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %uO %                                                                             %mO %                                                                             %6O %   W r i t e P S 2 I m a g e                                                 % O %                                                                             % O %                                                                             %pO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %GH %  Function WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image ismJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.m %=. %  The format of the WritePS2Image routine is: %a- %      status=WritePS2Image(image_info,image)L % + %  A description of each parameter follows:, %gJ %    o status: Function WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.n %;A %    o image_info: Specifies a pointer to an ImageInfo structure.  %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.r %  %( */3 static unsigned int WritePS2Image(image_info,image) 	 ImageInfoo   *image_info;   Image 	   *image;t {E
   static chara     *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on", G       "% Postscript viewers or printers that support color, otherwise",x(       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",h	       "",r       "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",#       "  /DeviceRGB setcolorspace",-
       "  <<",        "    /ImageType 1",[       "    /Interpolate true",       "    /Width columns",        "    /Height rows",         "    /BitsPerComponent 8","       "    /Decode [0 1 0 1 0 1]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",x       "    compression 0 gt",        "    {",<       "      /DataSource currentfile /ASCII85Decode filter",       "    }",       "    {",T       "      /DataSource currentfile /ASCII85Decode filter /RunLengthDecode filter",       "    } ifelse",g       "  >> image",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",i       "  %",       "  % Parameters:",8       "  %   colors: number of colors in the colormap.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop",        "  colors 0 eq",       "  {",       "    %","       "    % Image is grayscale.",       "    %",&       "    /DeviceGray setcolorspace",       "    <<",)       "      /ImageType 1",i        "      /Interpolate true",       "      /Width columns",m       "      /Height rows",-"       "      /BitsPerComponent 1",       "      /Decode [0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt",-       "      {",>       "        /DataSource currentfile /ASCII85Decode filter",       "      }",       "      {",V       "        /DataSource currentfile /ASCII85Decode filter /RunLengthDecode filter",       "      } ifelse",        "    >> image",e       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colormap: red, green, blue color packets.",       "    %",.       "    /colormap colors 3 mul string def",7       "    currentfile colormap readhexstring pop pop",rH       "    [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",       "    <<",m       "      /ImageType 1",o        "      /Interpolate true",       "      /Width columns",*       "      /Height rows",s"       "      /BitsPerComponent 8",       "      /Decode [0 255]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt",%       "      {",>       "        /DataSource currentfile /ASCII85Decode filter",       "      }",       "      {",V       "        /DataSource currentfile /ASCII85Decode filter /RunLengthDecode filter",       "      } ifelse",        "    >> image",        "  } ifelse",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",        "  %   x & y scale.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.",%M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.",t!       "  %   hex color packets.",T       "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",i       "  showpage",(       "} bind def",*       "%%EndProlog",       "%%Page:  1 1",i
       NULL     };     char     date[MaxTextLength],     *label,e     **q;     float'     dx_resolution,     dy_resolution,     x_resolution,a     y_resolution;n     int>
     count,     delta_x,     delta_y,
     flags,     sans_offset,     x,     y;     register RunlengthPacket     *p;e     register int     i,     j;     time_t
     timer;     unsigned charf     *pixels;     unsigned int     height,r     number_packets,n     page_height,     page_width,>     text_size,
     width;     /*     Open output image file.i   */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);e   do   {\     /*-       Scale image to size of Postscript page.a     */5     text_size=image->label == (char *) NULL ? 0 : 36;>     x=0;     y=0;     width=image->columns;r     height=image->rows;a     /*&       Center image on Postscript page.     */I     (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);;     flags=NoValue;*     if (image_info->page != (char *) NULL)L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);*     if (((page_width-(x << 1)) < width) ||4         ((page_height-(y << 1)-text_size) < height))       {          unsigned longI           scale_factor;m  
         /*2           Scale image relative to Postscript page.
         */8         scale_factor=UpShift(page_width-(x << 1))/width;L         if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))F           scale_factor=UpShift(page_height-(y << 1)-text_size)/height;,         width=DownShift(width*scale_factor);.         height=DownShift(height*scale_factor);       }      if ((flags & XValue) == 0)       { 
         /**           Center image in the X direction.
         */,         delta_x=page_width-(width+(x << 1));         if (delta_x >= 0)            x=(delta_x >> 1)+x;a       }"     if ((flags & YValue) == 0)       {t
         /**           Center image in the X direction.
         */8         delta_y=page_height-(height+(y << 1))-text_size;         if (delta_y >= 0)f           y=(delta_y >> 1)+y;        }      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;r     x_resolution=72.0;H     count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL)uL       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)f        y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     /*       Output Postscript header.p     */-     if (strcmp(image_info->magick,"PS") == 0) 6       (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");     else?       (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); ?     (void) fprintf(image->file,"%%%%Creator: (ImageMagick)\n"); D     (void) fprintf(image->file,"%%%%Title: (%s)\n",image->filename);      timer=time((time_t *) NULL);     (void) localtime(&timer); &     (void) strcpy(date,ctime(&timer));     date[strlen(date)-1]='\0';@     (void) fprintf(image->file,"%%%%CreationDate: (%s)\n",date);D     (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);&     if (image->label != (char *) NULL)!       (void) fprintf(image->file, F         "%%%%DocumentNeededResources: font NewCenturySchlbk-Roman\n");9     (void) fprintf(image->file,"%%%%LanguageLevel: 2\n");J-     if (strcmp(image_info->magick,"PS") == 0)a       {.B         (void) fprintf(image->file,"%%%%Orientation: Portrait\n");>         (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");       }m1     (void) fprintf(image->file,"%%%%Pages: %d\n",I,       strcmp(image_info->magick,"PS") == 0);4     (void) fprintf(image->file,"%%%%EndComments\n");8     (void) fprintf(image->file,"\n%%%%BeginDefaults\n");B     (void) fprintf(image->file,"%%%%PageOrientation: Portrait\n");6     (void) fprintf(image->file,"%%%%EndDefaults\n\n");     /*!       Output Postscript commands.i     */     for (q=Postscript; *q; q++)h,       (void) fprintf(image->file,"%s\n",*q);H     (void) fprintf(image->file,"%%%%PageBoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);&     if (image->label != (char *) NULL)!       (void) fprintf(image->file, <         "%%%%PageResources: font NewCenturySchlbk-Roman\n");-     if (strcmp(image_info->magick,"PS") != 0)t5       (void) fprintf(image->file,"userdict begin\n"); 3     (void) fprintf(image->file,"%%%%BeginData:\n"); 1     (void) fprintf(image->file,"DisplayImage\n");      /*       Output image data.     */     label=image->label;(     if (label == (char *) NULL);       label=" ";N     (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",8       x,y,width,height,label,image->columns,image->rows,G       image->class == PseudoClass,image->compression == NoCompression);a     p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))e!       switch (image->compression)i       { )         case RunlengthEncodedCompression:          default:	         {e            register unsigned char             *q;e             /*!             Allocate pixel array.i           */6           number_packets=3*image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL)a=             PrematureExit("Unable to allocate memory",image);m           /*(             Dump Packbit encoded pixels.           */           q=pixels;0,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)
             { <               if (image->matte && (p->index == Transparent))                 { )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);u)                   *q++=DownScale(MaxRGB);                  }e               else                 { )                   *q++=DownScale(p->red);t+                   *q++=DownScale(p->green); *                   *q++=DownScale(p->blue);                 } 
             }u             p++;%             if (QuantumTick(i,image)),>               ProgressMonitor(SaveImageText,i,image->packets);           } H           (void) PackbitsEncodeImage(image->file,pixels,number_packets);            free((char *) pixels);           break;	         }c         case NoCompression: 	         {i           /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();,           for (i=0; i < image->packets; i++)           {a2             for (j=0; j <= ((int) p->length); j++)
             { <               if (image->matte && (p->index == Transparent))                 {_?                   Ascii85Encode(DownScale(MaxRGB),image->file);E?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file);_                 }_               else                 {i?                   Ascii85Encode(DownScale(p->red),image->file); A                   Ascii85Encode(DownScale(p->green),image->file);i@                   Ascii85Encode(DownScale(p->blue),image->file);                 }g
             }I             p++;%             if (QuantumTick(i,image))m>               ProgressMonitor(SaveImageText,i,image->packets);           } $           Ascii85Flush(image->file);           break;	         }_       }e     else5       if (IsGrayImage(image) && (image->colors == 2))"	         {             register unsigned char             bit,             byte,%             polarity;%             polarity=%J             Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0; ,           (void) fprintf(image->file,"0\n");%           switch (image->compression)            { -             case RunlengthEncodedCompression:              default:
             { $               register unsigned char                 *q;                  /*%                 Allocate pixel array.                */C               number_packets=((image->columns+7) >> 3)*image->rows; &               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char));%3               if (pixels == (unsigned char *) NULL)%A                 PrematureExit("Unable to allocate memory",image);                /*(                 Dump GIF encoded pixels.               */               q=pixels;t0               for (i=0; i < image->packets; i++)               {n4                 for (j=0; j <= (int) p->length; j++)                 {r                   byte<<=1;o+                   if (p->index == polarity)m                     byte|=0x01;r                   bit++;                   if (bit == 8)o                     {                         *q++=byte;                       bit=0;                       byte=0;a                     }                    x++;*                   if (x == image->columns)                     {(                       /*5                         Advance to the next scanline.e                       */#                       if (bit != 0)_-                         *q++=byte << (8-bit);_                       bit=0;                       byte=0;)                       x=0;                       y++;                    }                 }n                 p++;)                 if (QuantumTick(i,image))nB                   ProgressMonitor(SaveImageText,i,image->packets);               }aL               (void) PackbitsEncodeImage(image->file,pixels,number_packets);$               free((char *) pixels);               break;
             }L             case NoCompression:R
             {e               /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 4                 for (j=0; j <= (int) p->length; j++)                 {e                   byte<<=1;g+                   if (p->index == polarity)f                     byte|=0x01;t                   bit++;                   if (bit == 8)e                     {/6                       Ascii85Encode(byte,image->file);                       bit=0;                       byte=0;p                     }o                   x++;*                   if (x == image->columns)                     {_                       /*5                         Advance to the next scanline.e                       */#                       if (bit != 0).C                         Ascii85Encode(byte << (8-bit),image->file);                        bit=0;                       byte=0;_                       x=0;                       y++;                    }                 }v                 p++;)                 if (QuantumTick(i,image))>B                   ProgressMonitor(SaveImageText,i,image->packets);               }g(               Ascii85Flush(image->file);               break;
             }g           }l	         }I
       else	         {m           /*/             Dump number of colors and colormap.e           */;           (void) fprintf(image->file,"%u\n",image->colors); +           for (i=0; i < image->colors; i++) 8             (void) fprintf(image->file,"%02x%02x%02x\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));%           switch (image->compression)n           {x-             case RunlengthEncodedCompression:;             default:
             {L$               register unsigned char                 *q;                  /*%                 Allocate pixel array.=               */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char));p3               if (pixels == (unsigned char *) NULL)nA                 PrematureExit("Unable to allocate memory",image);s               /*.                 Dump Runlength encoded pixels.               */               q=pixels;i0               for (i=0; i < image->packets; i++)               {=4                 for (j=0; j <= (int) p->length; j++)0                   *q++=(unsigned char) p->index;                 p++;)                 if (QuantumTick(i,image))gB                   ProgressMonitor(SaveImageText,i,image->packets);               } L               (void) PackbitsEncodeImage(image->file,pixels,number_packets);$               free((char *) pixels);               break;
             }              case NoCompression:(
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               {;6                 for (j=0; j <= ((int) p->length); j++)F                   Ascii85Encode((unsigned char) p->index,image->file);                 p++;)                 if (QuantumTick(i,image))fB                   ProgressMonitor(SaveImageText,i,image->packets);               } (               Ascii85Flush(image->file);               break;
             }M           }e	         }*%     (void) fprintf(image->file,"\n");=0     (void) fprintf(image->file,"%%%%EndData\n");-     if (strcmp(image_info->magick,"PS") != 0))*       (void) fprintf(image->file,"end\n");4     (void) fprintf(image->file,"%%%%PageTrailer\n");0     (void) fprintf(image->file,"%%%%Trailer\n");,     (void) fprintf(image->file,"%%%%EOF\n");&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);M   CloseImage(image);   return(True);+ }S L /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %rO %                                                                             % O %                                                                             %)O %   W r i t e R A D I A N C E I m a g e                                       %fO %                                                                             %sO %                                                                             %uO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %(L %  Function WriteRADIANCEImage writes an image in the RADIANCE encoded image
 %  format. %;3 %  The format of the WriteRADIANCEImage routine is:% %%2 %      status=WriteRADIANCEImage(image_info,image) %%+ %  A description of each parameter follows.  % O %    o status: Function WriteRADIANCEImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */8 static unsigned int WriteRADIANCEImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("Cannot write RADIANCE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);% }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             %sO %                                                                             %lO %                                                                             %iO %   W r i t e R G B I m a g e                                                 %lO %                                                                             %eO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %OF %  Function WriteRGBImage writes an image to a file in red, green, and %  blue rasterfile format. % . %  The format of the WriteRGBImage routine is: %%- %      status=WriteRGBImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteRGBImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.%   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);r   /*&     Convert MIFF to RGB raster pixels.   */,   if (strcmp(image_info->magick,"RGB") == 0)     image->matte=False;P    switch (image_info->interlace)   {r     case NoneInterlace:f     default:     {s       /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {a#           WriteQuantumFile(p->red); %           WriteQuantumFile(p->green); $           WriteQuantumFile(p->blue);           if (image->matte)o'             WriteQuantumFile(p->index);m	         }a         p++;!         if (QuantumTick(i,image))s:           ProgressMonitor(SaveImageText,i,image->packets);       }d       break;     };     case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)a       {e+         p=image->pixels+(y*image->columns);r*         for (x=0; x < image->columns; x++)	         {(#           WriteQuantumFile(p->red);i           p++;	         } +         p=image->pixels+(y*image->columns);i*         for (x=0; x < image->columns; x++)	         {a%           WriteQuantumFile(p->green);n           p++;	         }m+         p=image->pixels+(y*image->columns);E*         for (x=0; x < image->columns; x++)	         {t$           WriteQuantumFile(p->blue);           p++;	         }-+         p=image->pixels+(y*image->columns);>         if (image->matte)r,           for (x=0; x < image->columns; x++)           {i'             WriteQuantumFile(p->index);)             p++;           }t5         ProgressMonitor(SaveImageText,y,image->rows);e       }        break;     }      case PlaneInterlace:     {/       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...g       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)#           WriteQuantumFile(p->red);g         p++;       }n-       ProgressMonitor(SaveImageText,100,400);n       p=image->pixels;(       for (i=0; i < image->packets; i++)       {%.         for (j=0; j <= ((int) p->length); j++)%           WriteQuantumFile(p->green);          p++;       } -       ProgressMonitor(SaveImageText,200,400);        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)$           WriteQuantumFile(p->blue);         p++;       } -       ProgressMonitor(SaveImageText,300,400);        p=image->pixels;       if (image->matte) *         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)'             WriteQuantumFile(p->index);            p++;	         }%-       ProgressMonitor(SaveImageText,400,400);%       break;     }    }t   CloseImage(image);   return(True);a }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %TO %                                                                             % O %                                                                             % O %   W r i t e R L E I m a g e                                                 %fO %                                                                             %uO %                                                                             %gO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteRLEImage writes an image in the Utah Run length encoded image
 %  format. %*. %  The format of the WriteRLEImage routine is: %m- %      status=WriteRLEImage(image_info,image)f % + %  A description of each parameter follows.  %oJ %    o status: Function WriteRLEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filel %      fails to write. %fA %    o image_info: Specifies a pointer to an ImageInfo structure.c %,. %    o image:  A pointer to a Image structure. %g %p */3 static unsigned int WriteRLEImage(image_info,image) 	 ImageInfo%   *image_info;   Image%	   *image;% {%   char     command[MaxTextLength];      Image      *flipped_image;      ImageInfo 
     rle_info;      unsigned int     packet_size,     status;      /*     Flip image.    */   image->orphan=True; !   flipped_image=FlipImage(image);    image->orphan=False;&   if (flipped_image == (Image *) NULL)0     PrematureExit("Unable to flip image",image);   rle_info=(*image_info); #   rle_info.interlace=NoneInterlace; -   TemporaryFilename(flipped_image->filename); 0   status=WriteRGBImage(&rle_info,flipped_image);
   if (status)      {        packet_size=3;       if (image->matte)          packet_size=4;E       (void) sprintf(command,"rawtorle -w %u -h %u -n %u -o %s %s\n", D         image->columns,image->rows,packet_size,image_info->filename,!         flipped_image->filename);t$       status=SystemCommand(command);-       (void) unlink(flipped_image->filename); .       if (access(image_info->filename,0) != 0)2         Warning("RLE translation failed",command);     }    DestroyImage(flipped_image);   return(status);a }o f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %MO %                                                                             % O %   W r i t e S G I I m a g e                                                 % O %                                                                             %)O %                                                                             %=O %                                                                             %&O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %rJ %  Function WriteSGIImage writes an image in SGI RGB encoded image format. %n. %  The format of the WriteSGIImage routine is: %I- %      status=WriteSGIImage(image_info,image)  %e+ %  A description of each parameter follows.k %IJ %    o status: Function WriteSGIImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file= %      fails to write. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.t %s. %    o image:  A pointer to a Image structure. %_ %e */  * static int SGIEncode(pixels,count,packets)
 unsigned char 
   *pixels;   int    count;  
 unsigned charZ   *packets;  {    short      runlength;     unsigned chars     *limit,t
     *mark,     *p,      *q;o     p=pixels;=   limit=p+count*4;   q=packets;   while (p < limit)*   {f     mark=p;r	     p+=8; A     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))t       p+=4;l	     p-=8;t     count=((p-mark) >> 2);     while (count)f     {N*       runlength=count > 126 ? 126 : count;       count-=runlength;p       *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)f       {          *q++=(*mark);          mark+=4;       }      }s     mark=p;-	     p+=4; (     while ((p < limit) && (*p == *mark))       p+=4;      count=((p-mark) >> 2);     while (count)      {h*       runlength=count > 126 ? 126 : count;       count-=runlength;s       *q++=runlength;        *q++=(*mark);1     }    } 	   *q++=0;    return(q-packets); }   3 static unsigned int WriteSGIImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;f {n   typedef struct _SGIHeaderk   {      unsigned short       magic;       unsigned charr       storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char"       filler[492];   } SGIHeader;     SGIHeader"     iris_header;     register int     i,     j,     x,     y,     z;     register RunlengthPacket     *p;e     register unsigned char     *q;t     unsigned char      *iris_pixels,e
     *packets;g     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);"   do   {u     /*(       Initialize SGI raster file header.     */     iris_header.magic=0x01DA;i,     if (image->compression == NoCompression)       iris_header.storage=0x00;i     else       iris_header.storage=0x01;g<     iris_header.bytes_per_pixel=1;  /* one byte per pixel */     iris_header.dimension=3;'     iris_header.columns=image->columns;m!     iris_header.rows=image->rows;i+     iris_header.depth=image->matte ? 4 : 3;m     if (IsGrayImage(image))i       {e          iris_header.dimension=2;         iris_header.depth=1;       }       iris_header.minimum_value=0;%     iris_header.maximum_value=MaxRGB;g2     for (i=0; i < sizeof(iris_header.filler); i++)       iris_header.filler[i]=0;     /*       Write SGI header.0     */6     MSBFirstWriteShort(iris_header.magic,image->file);2     (void) fputc(iris_header.storage,image->file);:     (void) fputc(iris_header.bytes_per_pixel,image->file);:     MSBFirstWriteShort(iris_header.dimension,image->file);8     MSBFirstWriteShort(iris_header.columns,image->file);5     MSBFirstWriteShort(iris_header.rows,image->file);>6     MSBFirstWriteShort(iris_header.depth,image->file);=     MSBFirstWriteLong(iris_header.minimum_value,image->file); =     MSBFirstWriteLong(iris_header.maximum_value,image->file);tO     (void) fwrite(iris_header.filler,1,sizeof(iris_header.filler),image->file);i     /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *)pA       malloc(4*image->columns*image->rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);i     /*C       Convert runlength-encoded packets to uncompressed SGI pixels.r     */     x=0;     y=0;     p=image->pixels;?     q=iris_pixels+(iris_header.rows-1)*(iris_header.columns*4);e&     for (i=0; i < image->packets; i++)     {),       for (j=0; j <= ((int) p->length); j++)       {          *q++=DownScale(p->red); !         *q++=DownScale(p->green);           *q++=DownScale(p->blue);&         *q++=(unsigned char) p->index;         x++;          if (x == image->columns)           {u             y++;K             q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4);%             x=0;           }        } 
       p++;     } ,     if (image->compression == NoCompression)       {          unsigned char            *scanline;  
         /*(           Write uncompressed SGI pixels.
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 3         for (z=0; z < (int) iris_header.depth; z++) 	         {            q=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {%9             for (x=0; x < (int) iris_header.columns; x++) 
             {o               scanline[x]=(*q);i               q+=4;a
             } M             (void) fwrite(scanline,sizeof(unsigned char),iris_header.columns,a               image->file);A           }o=           ProgressMonitor(SaveImageText,z,iris_header.depth);E	         }r         free(scanline);i       }      else       {n         unsigned long            length,i           number_packets,            offset,i           *offsets,a           *runlength;o  
         /*F           Convert SGI uncompressed pixels to runlength-encoded pixels.
         */!         offsets=(unsigned long *)mK           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));eK         packets=(unsigned char *) malloc(4*((iris_header.columns << 1)+10)*m-           image->rows*sizeof(unsigned char)); #         runlength=(unsigned long *);K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image); A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);i         number_packets=0;)         q=iris_pixels;2         for (y=0; y < (int) iris_header.rows; y++)	         {a5           for (z=0; z < (int) iris_header.depth; z++)o           {=             length=nN               SGIEncode(q+z,(int) iris_header.columns,packets+number_packets);#             number_packets+=length;n1             offsets[y+z*iris_header.rows]=offset;n3             runlength[y+z*iris_header.rows]=length;              offset+=length;n           }i%           q+=(iris_header.columns*4);g<           ProgressMonitor(SaveImageText,y,iris_header.rows);	         }i
         /*N           Write out line start and length tables and runlength-encoded pixels.
         */F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)4           MSBFirstWriteLong(offsets[i],image->file);F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)6           MSBFirstWriteLong(runlength[i],image->file);P         (void) fwrite(packets,sizeof(unsigned char),number_packets,image->file);
         /*           Free memory.
         */         free(runlength);         free(packets);         free(offsets);       }p     free(iris_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);e   CloseImage(image);   return(True);  }* % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e S U N I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nG %  Function WriteSUNImage writes an image in the SUN rasterfile format.  %V. %  The format of the WriteSUNImage routine is: %e- %      status=WriteSUNImage(image_info,image)V %g+ %  A description of each parameter follows.  %hJ %    o status: Function WriteSUNImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filea %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %I. %    o image:  A pointer to a Image structure. %t %  */3 static unsigned int WriteSUNImage(image_info,image)V	 ImageInfo_   *image_info;   Image 	   *image;f {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0, #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_FORMAT_RGB  3     typedef struct _SUNHeaderm   {m     unsigned longe       magic,       width,
       height,        depth,
       length,a       type,i       maptype,       maplength;   } SUNHeader;     register int     i,     j,     x;     register RunlengthPacket     *p;>     SUNHeaderr     sun_header;g     /*     Open output image file.p   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL))/     PrematureExit("Unable to open file",image);v   do   {D     /*(       Initialize SUN raster file header.     */      sun_header.magic=0x59a66a95;$     sun_header.width=image->columns;"     sun_header.height=image->rows;P     sun_header.type=(image->class == DirectClass ? RT_FORMAT_RGB : RT_STANDARD);      sun_header.maptype=RMT_NONE;     sun_header.maplength=0;=5     if (!IsPseudoClass(image) && !IsGrayImage(image))I       {e
         /*            Full color SUN raster.
         */2         sun_header.depth=(image->matte ? 32 : 24);L         sun_header.length=image->columns*image->rows*(image->matte ? 4 : 3);@         sun_header.length+=image->columns % 2 ? image->rows : 0;       }      else5       if (IsGrayImage(image) && (image->colors == 2)) 	         {            /*"             Monochrome SUN raster.           */           sun_header.depth=1; B           sun_header.length=((image->columns+7) >> 3)*image->rows;P           sun_header.length+=((image->columns/8)+(image->columns % 8 ? 1 : 0)) %              2 ? image->rows : 0;	         } 
       else	         {            /*#             Colormapped SUN raster.%           */           sun_header.depth=8;%7           sun_header.length=image->columns*image->rows;mB           sun_header.length+=image->columns % 2 ? image->rows : 0;+           sun_header.maptype=RMT_EQUAL_RGB;a/           sun_header.maplength=image->colors*3;s	         }      /*       Write SUN header.      */4     MSBFirstWriteLong(sun_header.magic,image->file);4     MSBFirstWriteLong(sun_header.width,image->file);5     MSBFirstWriteLong(sun_header.height,image->file);.4     MSBFirstWriteLong(sun_header.depth,image->file);5     MSBFirstWriteLong(sun_header.length,image->file);m3     MSBFirstWriteLong(sun_header.type,image->file);P6     MSBFirstWriteLong(sun_header.maptype,image->file);8     MSBFirstWriteLong(sun_header.maplength,image->file);     /*(       Convert MIFF to SUN raster pixels.     */     p=image->pixels;     x=0;5     if (!IsPseudoClass(image) && !IsGrayImage(image))%       {%
         /*6           Convert DirectClass packet to SUN RGB pixel.
         */*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              if (image->matte) 1               (void) fputc(p->index,image->file); 8             (void) fputc(DownScale(p->red),image->file);:             (void) fputc(DownScale(p->green),image->file);9             (void) fputc(DownScale(p->blue),image->file);              x++;$             if (x == image->columns)               { .                 if ((image->columns % 2) != 0)A                   (void) fputc(0,image->file); /* pad scanline */%                 x=0;               }%           }%           p++;#           if (QuantumTick(i,image))g<             ProgressMonitor(SaveImageText,i,image->packets);	         }t       }C     else5       if (IsGrayImage(image) && (image->colors == 2))a	         {             register unsigned char             bit,             byte,              polarity;u             /*@             Convert PseudoClass image to a SUN monochrome image.           */           polarity=sJ             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);           bit=0;           byte=0;t,           for (i=0; i < image->packets; i++)           {P0             for (j=0; j <= (int) p->length; j++)
             {                byte<<=1; '               if (p->index == polarity)a                 byte|=0x01;                bit++;               if (bit == 8)                  { 1                   (void) fputc(byte,image->file);                    bit=0;                   byte=0;t                 }d               x++;&               if (x == image->columns)                 {e                   /*1                     Advance to the next scanline.                    */                   if (bit != 0) >                     (void) fputc(byte << (8-bit),image->file);+                   if ((((image->columns/8)+h>                       (image->columns % 8 ? 1 : 0)) % 2) != 0)D                     (void) fputc(0,image->file);  /* pad scanline */                   bit=0;                   byte=0;W                   x=0;                }
             }              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }l	         }c
       else	         {r           /*"             Dump colormap to file.           */+           for (i=0; i < image->colors; i++)mH             (void) fputc(DownScale(image->colormap[i].red),image->file);+           for (i=0; i < image->colors; i++)aJ             (void) fputc(DownScale(image->colormap[i].green),image->file);+           for (i=0; i < image->colors; i++)&I             (void) fputc(DownScale(image->colormap[i].blue),image->file);r           /*@             Convert PseudoClass packet to SUN colormapped pixel.           */,           for (i=0; i < image->packets; i++)           {e0             for (j=0; j <= (int) p->length; j++)
             { 1               (void) fputc(p->index,image->file);                x++;&               if (x == image->columns)                 { 0                   if ((image->columns % 2) != 0)D                     (void) fputc(0,image->file);  /* pad scanline */                   x=0;                 }e
             }v             p++;%             if (QuantumTick(i,image))v>               ProgressMonitor(SaveImageText,i,image->packets);           }a	         }r&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);p   CloseImage(image);   return(True);( }i d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %aO %                                                                             %eO %                                                                             %fO %   W r i t e T A R G A I m a g e                                             %rO %                                                                             %lO %                                                                             %lO %                                                                             %wO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % M %  Function WriteTARGAImage writes a image in the Truevision Targa rasterfiler
 %  format. %.0 %  The format of the WriteTARGAImage routine is: %a/ %      status=WriteTARGAImage(image_info,image)o %(+ %  A description of each parameter follows.- %lL %    o status: Function WriteTARGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %tA %    o image_info: Specifies a pointer to an ImageInfo structure.  %a. %    o image:  A pointer to a Image structure. %n %n */5 static unsigned int WriteTARGAImage(image_info,image) 	 ImageInfot   *image_info;   Imaget	   *image;m {) #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3( #define TargaRLEColormap  9) #define TargaRLERGB  10g #define TargaRLEMonochrome  11     typedef struct _TargaHeaderh   {)     unsigned char        id_length,       colormap_type,       image_type;e       unsigned short       colormap_index,;       colormap_length;       unsigned chare       colormap_size;       unsigned short       x_origin,        y_origin,        width,
       height;        unsigned char        pixel_size,,       attributes;    } TargaHeader;     Image      *flopped_image;r     intl
     count,     runlength;     register int     i,     j;     register RunlengthPacket     *p;2     register unsigned char     *q,e     *r;p  
   TargaHeader      targa_header;c     unsigned char      *targa_pixels;     /*     Open output image file.p   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);o   do   {      /*       Flop image.      */     image->orphan=True;(#     flopped_image=FlopImage(image);      image->orphan=False;(     if (flopped_image == (Image *) NULL)2       PrematureExit("Unable to flop image",image);B     if (flopped_image->compression == RunlengthEncodedCompression)#       CompressImage(flopped_image);i     /**       Initialize TARGA raster file header.     */     targa_header.id_length=0;-1     if (flopped_image->comments != (char *) NULL)eL       targa_header.id_length=Min((int) strlen(flopped_image->comments),255);!     targa_header.colormap_type=0; "     targa_header.colormap_index=0;#     targa_header.colormap_length=0; !     targa_header.colormap_size=0;      targa_header.x_origin=0;     targa_header.y_origin=0;.     targa_header.width=flopped_image->columns;,     targa_header.height=flopped_image->rows;     targa_header.pixel_size=8;     targa_header.attributes=0;&     if (!IsPseudoClass(flopped_image))       {)
         /*"           Full color TARGA raster.
         */)         targa_header.image_type=TargaRGB;fF         if (flopped_image->compression == RunlengthEncodedCompression).           targa_header.image_type=TargaRLERGB;?         targa_header.pixel_size=flopped_image->matte ? 32 : 24;,       }-     else       {r
         /*#           Colormapped TARGA raster. 
         */.         targa_header.image_type=TargaColormap;F         if (flopped_image->compression == RunlengthEncodedCompression)3           targa_header.image_type=TargaRLEColormap;gH         if (!IsGrayImage(flopped_image) || (flopped_image->colors != 2))           {r)             targa_header.colormap_type=1;e*             targa_header.colormap_index=0;?             targa_header.colormap_length=flopped_image->colors;r*             targa_header.colormap_size=24;           }          else           {              /*&               Monochrome TARGA raster.             */4             targa_header.image_type=TargaMonochrome;J             if (flopped_image->compression == RunlengthEncodedCompression)9               targa_header.image_type=TargaRLEMonochrome;            }        }      /*       Write TARGA header.      */<     (void) fputc((char) targa_header.id_length,image->file);@     (void) fputc((char) targa_header.colormap_type,image->file);=     (void) fputc((char) targa_header.image_type,image->file); @     LSBFirstWriteShort(targa_header.colormap_index,image->file);A     LSBFirstWriteShort(targa_header.colormap_length,image->file); @     (void) fputc((char) targa_header.colormap_size,image->file);:     LSBFirstWriteShort(targa_header.x_origin,image->file);:     LSBFirstWriteShort(targa_header.y_origin,image->file);7     LSBFirstWriteShort(targa_header.width,image->file);t8     LSBFirstWriteShort(targa_header.height,image->file);=     (void) fputc((char) targa_header.pixel_size,image->file); =     (void) fputc((char) targa_header.attributes,image->file);s$     if (targa_header.id_length != 0)N       (void) fwrite((char *) flopped_image->comments,1,targa_header.id_length,         image->file);d     /**       Convert MIFF to TARGA raster pixels.     */     count=(unsigned int)L       (targa_header.pixel_size*targa_header.width*targa_header.height) >> 3;B     if (flopped_image->compression == RunlengthEncodedCompression)       count+=(count/128)+1;aG     targa_pixels=(unsigned char *) malloc(count*sizeof(unsigned char));l/     if (targa_pixels == (unsigned char *) NULL)e?       PrematureExit("Unable to allocate memory",flopped_image);o7     p=flopped_image->pixels+(flopped_image->packets-1);      q=targa_pixels; &     if (!IsPseudoClass(flopped_image))       { 
         /*8           Convert DirectClass packet to TARGA RGB pixel.
         */F         if (flopped_image->compression != RunlengthEncodedCompression)4           for (i=0; i < flopped_image->packets; i++)           {x0             for (j=0; j <= (int) p->length; j++)
             {j&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green); %               *q++=DownScale(p->red);g'               if (flopped_image->matte)a                 *q++=p->index;
             }              p--;-             if (QuantumTick(i,flopped_image))iF               ProgressMonitor(SaveImageText,i,flopped_image->packets);           }p         else4           for (i=0; i < flopped_image->packets; i++)           {nH             for (runlength=p->length+1; runlength > 128; runlength-=128)
             {"               *q++=0xff;&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green); %               *q++=DownScale(p->red);r'               if (flopped_image->matte)l                 *q++=p->index;
             }              r=q;$             *q++=0x80+(runlength-1);$             *q++=DownScale(p->blue);%             *q++=DownScale(p->green);a#             *q++=DownScale(p->red);i%             if (flopped_image->matte)f               *q++=p->index;             if (runlength != 1)                p--;             else               {i8                 for ( ; i < flopped_image->packets; i++)                 {                    p--;=                   if ((p->length != 0) || (runlength == 128))t                     break;*                   *q++=DownScale(p->blue);+                   *q++=DownScale(p->green); )                   *q++=DownScale(p->red);<+                   if (flopped_image->matte)("                     *q++=p->index;                   runlength++;                 }s                 *r=runlength-1;*               }i-             if (QuantumTick(i,flopped_image))_F               ProgressMonitor(SaveImageText,i,flopped_image->packets);           }        }      elseF       if (!IsGrayImage(flopped_image) || (flopped_image->colors != 2))	         {            unsigned charh             *targa_colormap;             /*@             Dump colormap to file (blue, green, red byte order).           */*           if (flopped_image->colors > 256)P             QuantizeImage(flopped_image,256,8,image_info->dither,RGBColorspace);*           targa_colormap=(unsigned char *)I             malloc(3*targa_header.colormap_length*sizeof(unsigned char));i7           if (targa_colormap == (unsigned char *) NULL)2E             PrematureExit("Unable to allocate memory",flopped_image);r           q=targa_colormap;;3           for (i=0; i < flopped_image->colors; i++)r           {5<             *q++=DownScale(flopped_image->colormap[i].blue);=             *q++=DownScale(flopped_image->colormap[i].green);i;             *q++=DownScale(flopped_image->colormap[i].red);>           } 2           (void) fwrite((char *) targa_colormap,1,>             (int) 3*targa_header.colormap_length,image->file);(           free((char *) targa_colormap);           /*B             Convert PseudoClass packet to TARGA colormapped pixel.           */           q=targa_pixels;>H           if (flopped_image->compression != RunlengthEncodedCompression)6             for (i=0; i < flopped_image->packets; i++)
             {e2               for (j=0; j <= (int) p->length; j++)                 *q++=p->index;               p--;/               if (QuantumTick(i,flopped_image))0H                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             })           else6             for (i=0; i < flopped_image->packets; i++)
             {nJ               for (runlength=p->length+1; runlength > 128; runlength-=128)               {>                 *q++=0xff;                 *q++=p->index;               }i               r=q;&               *q++=0x80+(runlength-1);               *q++=p->index;!               if (runlength != 1))                 p--;               else                 {-:                   for ( ; i < flopped_image->packets; i++)                   {e                     p--;?                     if ((p->length != 0) || (runlength == 128))P                       break;"                     *q++=p->index;                      runlength++;                   }"!                   *r=runlength-1;X                 }R/               if (QuantumTick(i,flopped_image))7H                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }p	         };
       else	         {e           unsigned int             polarity;i             /*B             Convert PseudoClass image to a TARGA monochrome image.           */           polarity=0; )           if (flopped_image->colors == 2)=<             polarity=Intensity(flopped_image->colormap[0]) >4               Intensity(flopped_image->colormap[1]);H           if (flopped_image->compression != RunlengthEncodedCompression)6             for (i=0; i < flopped_image->packets; i++)
             {>2               for (j=0; j <= (int) p->length; j++)B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);               p--;/               if (QuantumTick(i,flopped_image))hH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }e           else6             for (i=0; i < flopped_image->packets; i++)
             {iJ               for (runlength=p->length+1; runlength > 128; runlength-=128)               {                  *q++=0xff;B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);               }i               r=q;&               *q++=0x80+(runlength-1);@               *q++=p->index == polarity ? 0 : DownScale(MaxRGB);!               if (runlength != 1)h                 p--;               else                 {n:                   for ( ; i < flopped_image->packets; i++)                   {i                     p--;?                     if ((p->length != 0) || (runlength == 128))l                       break;F                     *q++=p->index == polarity ? 0 : DownScale(MaxRGB);                      runlength++;                   }e!                   *r=runlength-1;r                 }i/               if (QuantumTick(i,flopped_image))>H                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }/	         } N     (void) fwrite((char *) targa_pixels,1,(int) (q-targa_pixels),image->file);      DestroyImage(flopped_image);      free((char *) targa_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);r   CloseImage(image);   return(True);  }v ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %)O %                                                                             % O %                                                                             %fO %   W r i t e T E X T I m a g e                                               %nO %                                                                             %gO %                                                                             %=O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\ %;C %  Function WriteTEXTImage writes an image in the TEXT image forma.i %f/ %  The format of the WriteTEXTImage routine is:  %v. %      status=WriteTEXTImage(image_info,image) % + %  A description of each parameter follows.n %dK %    o status: Function WriteTEXTImage return True if the image is written.nK %      False is returned is there is a memory shortage or if the image file  %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %(. %    o image:  A pointer to a Image structure. %  %t */4 static unsigned int WriteTEXTImage(image_info,image)	 ImageInfoi   *image_info;   Image 	   *image;  {*   unsigned int     status;r  6   Warning("Cannot write TEXT images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);c }s z #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>  #elsec #include <varargs.h> #endif #endif #include "tiffio.h"e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e T I F F I m a g e                                               % O %                                                                             %eO %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I %eK %  Function WriteTIFFImage writes an image in the Tagged image file format.  %a/ %  The format of the WriteTIFFImage routine is:  % . %      status=WriteTIFFImage(image_info,image) %a+ %  A description of each parameter follows:( % L %    o status:  Function WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the imagep) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {  #ifndef TIFFDefaultStripSizeM #define TIFFDefaultStripSize(tiff,request)  ((8*1024)/TIFFScanlineSize(tiff))g #endif     Image      encode_image;s     intd
     flags,     sans_offset;     register RunlengthPacket     *p;      register int     i,     j,     x,     y;     register unsigned char     *q;g     TIFF
     *tiff;     uint16     compression,     photometric;     unsigned char      *scanline;     unsigned int     x_resolution,&     y_resolution;      unsigned short
     value;     /*     Open TIFF file.,   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)</     PrematureExit("Unable to open file",image); .   if ((image->file != stdout) && !image->pipe)#     (void) unlink(image->filename);    else     {e       /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);c       image->temporary=True;     }>   CloseImage(image);1   tiff=TIFFOpen(image->filename,WriteBinaryType);_   if (tiff == (TIFF *) NULL)     return(False);   do   {u     /*       Initialize TIFF fields.r     */<     TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);6     TIFFSetField(tiff,TIFFTAG_SOFTWARE,"ImageMagick");)     if (image->comments != (char *) NULL)iB       TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);/     TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);      if (image->depth == 16) 2       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);5     if (!IsPseudoClass(image) && !IsGrayImage(image))        {i
         /*!           Full color TIFF raster. 
         */$         photometric=PHOTOMETRIC_RGB;J         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));         if (image->matte)u           {              uint16               extra_samples,               sample_info[1];c                /*'               TIFF has a matte channel.              */             extra_samples=1;2             sample_info[0]=EXTRASAMPLE_ASSOCALPHA;O             TIFFSetField(tiff,TIFFTAG_EXTRASAMPLES,extra_samples,&sample_info);            }        }      else       { 
         /*"           Colormapped TIFF raster.
         */(         photometric=PHOTOMETRIC_PALETTE;5         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1);a         if (IsGrayImage(image))e           {              /*$               Grayscale TIFF raster.             *//             photometric=PHOTOMETRIC_MINISBLACK; #             if (image->colors == 2)s9               TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);i           }        }o7     TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric); @     TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,(uint32) image->rows);B     TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,(uint32) image->columns);;     TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB); ?     TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT); @     TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);D     TIFFSetField(tiff,TIFFTAG_RESOLUTIONUNIT,(uint16) image->units);     flags=NoValue;-     if (image_info->density != (char *) NULL) I       flags=XParseGeometry(image_info->density,&sans_offset,&sans_offset, %         &x_resolution,&y_resolution);      if (flags & WidthValue) '       image->x_resolution=x_resolution;,     if (flags & HeightValue)'       image->y_resolution=y_resolution; ?     TIFFSetField(tiff,TIFFTAG_XRESOLUTION,image->x_resolution); ?     TIFFSetField(tiff,TIFFTAG_YRESOLUTION,image->y_resolution);u      compression=COMPRESSION_LZW;     if (!image->matte)5       if (IsGrayImage(image) && (image->colors == 2)) *         compression=COMPRESSION_CCITTFAX4;,     if (image->compression == NoCompression)#       compression=COMPRESSION_NONE; 7     TIFFSetField(tiff,TIFFTAG_COMPRESSION,compression); +     TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP, 0       TIFFDefaultStripSize(tiff,(uint32) (-1)));>     scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));+     if (scanline == (unsigned char *) NULL)u7       PrematureExit("Unable to allocate memory",image);e     p=image->pixels;     q=scanline;l     x=0;     y=0;'     if (photometric == PHOTOMETRIC_RGB)i(       for (i=0; i < image->packets; i++)       {m,         for (j=0; j <= (int) p->length; j++)	         {            /*D             Convert DirectClass packets to contiguous RGB scanlines.           */!           WriteQuantum(p->red,q); #           WriteQuantum(p->green,q);0"           WriteQuantum(p->blue,q);           if (image->matte))%             WriteQuantum(p->index,q);            x++;"           if (x == image->columns)
             {aD               if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                 break;               q=scanline;;               x=0;               y++;
             };	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }      else-       if (photometric == PHOTOMETRIC_PALETTE) 	         {0           unsigned short             *blue,             *green,              *red;t              /*#             Allocate TIFF colormap.            */O           blue=(unsigned short *) malloc(image->colors*sizeof(unsigned short)); P           green=(unsigned short *) malloc(image->colors*sizeof(unsigned short));N           red=(unsigned short *) malloc(image->colors*sizeof(unsigned short));2           if ((blue == (unsigned short *) NULL) ||3               (green == (unsigned short *) NULL) ||n/               (red == (unsigned short *) NULL))g=             PrematureExit("Unable to allocate memory",image);n           /*%             Initialize TIFF colormap.e           */+           for (i=0; i < image->colors; i++)j           { I             red[i]=(unsigned int) (image->colormap[i].red*65535L)/MaxRGB;)M             green[i]=(unsigned int) (image->colormap[i].green*65535L)/MaxRGB;gK             blue[i]=(unsigned int) (image->colormap[i].blue*65535L)/MaxRGB;(           }m=           TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);e           /*H             Convert PseudoClass packets to contiguous indexed scanlines.           */,           for (i=0; i < image->packets; i++)           {"0             for (j=0; j <= (int) p->length; j++)
             {a'               WriteQuantum(p->index,q);m               x++;&               if (x == image->columns)                 {aH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 }l
             }m             p++;%             if (QuantumTick(i,image))i>               ProgressMonitor(SaveImageText,i,image->packets);           }g           free((char *) red);)           free((char *) green);"           free((char *) blue);	         }v
       else         if (image->colors > 2),           for (i=0; i < image->packets; i++)           {e0             for (j=0; j <= (int) p->length; j++)
             {e               /*N                 Convert PseudoClass packets to contiguous grayscale scanlines.               */,               WriteQuantum(Intensity(*p),q);               x++;&               if (x == image->columns)                 {iH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;i                   x=0;                   y++;                 } 
             }e             p++;%             if (QuantumTick(i,image))C>               ProgressMonitor(SaveImageText,i,image->packets);           }a         else           { "             register unsigned char               bit,               byte,n               polarity;p                /*M               Convert PseudoClass packets to contiguous monochrome scanlines.              */             polarity=0; #             if (image->colors == 2)                polarity= N                 Intensity(image->colormap[0]) < Intensity(image->colormap[1]);             bit=0;             byte=0;a             x=0;.             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {r                 byte<<=1; )                 if (p->index == polarity)                    byte|=0x01;G                 bit++;                 if (bit == 8)                    {                      *q++=byte;                     bit=0;                     byte=0;w                   }                  x++;(                 if (x == image->columns)                   {;                     /*3                       Advance to the next scanline.c                     */!                     if (bit != 0) +                       *q++=byte << (8-bit); J                     if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                       break;                     q=scanline;k                     bit=0;                     byte=0;-                     x=0;                     y++;                  }               }n               p++;'               if (QuantumTick(i,image))l@                 ProgressMonitor(SaveImageText,i,image->packets);
             }f           }      free((char *) scanline);$     if (image_info->verbose == True),       TIFFPrintDirectory(tiff,stderr,False);     TIFFWriteDirectory(tiff);n&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);a   (void) TIFFClose(tiff);    if (image->temporary)      { 
       FILE         *file;  	       inte
         c;         /*7         Copy temporary file to standard output or pipe.(       */1       file=fopen(image->filename,ReadBinaryType);e        if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);n       c=fgetc(file);       while (c != EOF)       {i)         (void) putc(c,encode_image.file);          c=fgetc(file);       }        (void) fclose(file);%       (void) unlink(image->filename);n        CloseImage(&encode_image);     }a   return(True);  }  #else 4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfo    *image_info;   Imagel	   *image;l {s   unsigned int     status;   ;   Warning("TIFF library is not available",image->filename);e*   status=WriteMIFFImage(image_info,image);   return(status);u }g #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e T I L E I m a g e                                               %<O %                                                                             % O %                                                                             % O %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %cL %  Function WriteTILEImage writes an image in the TILE encoded image format. %a/ %  The format of the WriteTILEImage routine is:/ % . %      status=WriteTILEImage(image_info,image) % + %  A description of each parameter follows.  %iK %    o status: Function WriteTILEImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %cA %    o image_info: Specifies a pointer to an ImageInfo structure.r %(. %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteTILEImage(image_info,image)	 ImageInfo    *image_info;   Imageo	   *image;t {    unsigned int     status;s  6   Warning("Cannot write TILE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);n }p e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             % O %                                                                             %eO %                                                                             % O %   W r i t e U Y V Y I m a g e                                               % O %                                                                             %tO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteUYVYImage writes an image to a file in the digital UYVYL %  (16bit/pixel) format.  This format, used by AccomWSD, is not dramaticallyK %  higher quality than the 12bit/pixel YUV format, but has better locality.e %f/ %  The format of the WriteUYVYImage routine is:h %i. %      status=WriteUYVYImage(image_info,image) %R+ %  A description of each parameter follows.l % K %    o status: Function WriteUYVYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure.6 %      Implicit assumption: number of columns is even. %  */4 static unsigned int WriteUYVYImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      unsigned int	     full,i     y,     u,     v;     /*     Open output image file.    */   if (!UncompressImage(image))     return(False);.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)d/     PrematureExit("Unable to open file",image);    /*'     Convert to YUV, at full resolution.;   */+   RGBTransformImage(image,YCbCrColorspace);    /*'     Accumulate two pixels, then output.c   */
   full=False;    u=0;   v=0;   y=0;
   full=False;s
   full=False;(   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     {l       if (full) 	         { A           (void) fputc(DownScale((u+p->green) >> 1),image->file); 1           (void) fputc(DownScale(y),image->file);e@           (void) fputc(DownScale((v+p->blue) >> 1),image->file);6           (void) fputc(DownScale(p->red),image->file);           full=False;r	         }>
       else	         {            y=p->red;e           u=p->green;            v=p->blue;           full=True;	         }a     }e     p++;     if (QuantumTick(i,image))j6       ProgressMonitor(SaveImageText,i,image->packets);   })+   TransformRGBImage(image,YCbCrColorspace);o   return(True);( }g c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %=O %                                                                             %0O %                                                                             %iO %   W r i t e V I C A R I m a g e                                             %nO %                                                                             %rO %                                                                             %8O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%E %dK %  Function WriteVICARImage writes an image in the VICAR rasterfile format.(N %  Vicar files contain a text header, followed by one or more planes of binaryM %  grayscale image data.  Vicar files are designed to allow many planes to berK %  stacked together to form image cubes.  This routine only writes a singlej %  grayscale plane.  % 6 %  Function WriteVICARImage was written contributed by %  gorelick@esther.la.asu.edu. %f0 %  The format of the WriteVICARImage routine is: %r/ %      status=WriteVICARImage(image_info,image)f %n+ %  A description of each parameter follows.  % L %    o status: Function WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileo %      fails to write. %fA %    o image_info: Specifies a pointer to an ImageInfo structure.c % . %    o image:  A pointer to a Image structure. %  %, */5 static unsigned int WriteVICARImage(image_info,image)v	 ImageInfof   *image_info;   Image 	   *image;n {i   char     header[MaxTextLength],     label[16];     inti     label_size;      register int     i,     j;     register RunlengthPacket     *p;n     /*     Open output image file.r   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);e   /*     Make a header.   */K   (void) sprintf(header,"LBLSIZE=            FORMAT='BYTE'  TYPE='IMAGE'"); H   (void) sprintf(header+strlen(header),"  BUFSIZE=20000  DIM=2  EOL=0");'   (void) sprintf(header+strlen(header), M     "  RECSIZE=%u  ORG='BSQ'  NL=%u  NS=%u  NB=1",image->columns,image->rows,g     image->columns);'   (void) sprintf(header+strlen(header), .     "  N1=0  N2=0  N3=0  N4=0  NBB=0  NLB=0");?   (void) sprintf(header+strlen(header),"  TASK='ImageMagick'");i   /*"     Compute the size of the label.   */M   label_size=(strlen(header)+image->columns-1)/image->columns*image->columns;%(   (void) sprintf(label,"%d",label_size);*   for (i=0 ; i < (int) strlen(label); i++)     header[i+8]=label[i];    /*<     Print the header and enough spaces to pad to label size.   */8   (void) fprintf(image->file, "%-*s",label_size,header);   /*(     Convert MIFF to VICAR raster pixels.   */*   RGBTransformImage(image,GRAYColorspace);   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)'       (void) fputc(p->red,image->file);      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);% }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %mO %                                                                             %aO %                                                                             %oO %   W r i t e V I F F I m a g e                                               %tO %                                                                             %nO %                                                                             %nO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gN %  Function WriteVIFFImage writes an image to a file in the VIFF image format. % / %  The format of the WriteVIFFImage routine is:x %0. %      status=WriteVIFFImage(image_info,image) %p+ %  A description of each parameter follows.t %sK %    o status: Function WriteVIFFImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image filey %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %I. %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteVIFFImage(image_info,image)	 ImageInfo    *image_info;   Imageo	   *image;e {c #define VFF_CM_genericRGB  15s #define VFF_CM_NONE  0 #define VFF_DEP_IEEEORDER  0x2 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1s #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1g     typedef struct _ViffHeader   {      char       identifier,c       file_type,       release,       version,       machine_dependency,        reserve[3],h       comment[512];        unsigned longb       rows,p       columns,       subrows;       long       x_offset,_       y_offset;n       unsigned int       x_pixel_size,i       y_pixel_size;o       unsigned long        location_type,       location_dimension,g       number_of_images,g       number_data_bands,       data_storage_type,       data_encode_scheme,        map_scheme,l       map_storage_type,        map_rows,e       map_columns,       map_subrows,       map_enable,g       maps_per_cycle,)       color_space_model;   } ViffHeader;d     register int     i,     j;     register RunlengthPacket     *p;=     register unsigned char     *q;_     unsigned charl     buffer[8],     *viff_pixels;r     unsigned longn     packets;     ViffHeader     viff_header;     /*     Open output image file.n   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);U   do   {l     /*&       Initialize VIFF image structure.     */      viff_header.identifier=0xab;     viff_header.file_type=1;     viff_header.release=1;     viff_header.version=3;O     viff_header.machine_dependency=VFF_DEP_IEEEORDER;  /* IEEE byte ordering */t     *viff_header.comment='\0';)     if (image->comments != (char *) NULL)c       { ;         (void) strncpy(viff_header.comment,image->comments,x2           Min((int) strlen(image->comments),511));I         viff_header.comment[Min((int) strlen(image->comments),511)]='\0';8       }i$     viff_header.rows=image->columns;$     viff_header.columns=image->rows;     viff_header.subrows=0;     viff_header.x_offset=(~0);     viff_header.y_offset=(~0);     viff_header.x_pixel_size=0;x     viff_header.y_pixel_size=0;i/     viff_header.location_type=VFF_LOC_IMPLICIT;I%     viff_header.location_dimension=0;_#     viff_header.number_of_images=1;a/     viff_header.data_encode_scheme=VFF_DES_RAW;x'     viff_header.map_scheme=VFF_MS_NONE; 1     viff_header.map_storage_type=VFF_MAPTYP_NONE;i     viff_header.map_rows=0;p     viff_header.map_columns=0;     viff_header.map_subrows=0;0     viff_header.map_enable=1;  /* no colormap */!     viff_header.maps_per_cycle=0; 5     if (!IsPseudoClass(image) && !IsGrayImage(image))e       {d
         /*!           Full color VIFF raster.e
         */;         viff_header.number_data_bands=image->matte ? 4 : 3;e8         viff_header.color_space_model=VFF_CM_genericRGB;5         viff_header.data_storage_type=VFF_TYP_1_BYTE;SI         packets=image->columns*image->rows*viff_header.number_data_bands;z       }l     else       {)(         viff_header.number_data_bands=1;2         viff_header.color_space_model=VFF_CM_NONE;5         viff_header.data_storage_type=VFF_TYP_1_BYTE;)+         packets=image->columns*image->rows;f          if (!IsGrayImage(image))           {r             /*&               Colormapped VIFF raster.             */5             viff_header.map_scheme=VFF_MS_ONEPERBAND;t;             viff_header.map_storage_type=VFF_MAPTYP_1_BYTE;s#             viff_header.map_rows=3;t2             viff_header.map_columns=image->colors;           }a         else!           if (image->colors == 2)S
             {a               /*'                 Monochrome VIFF raster.g               */8               viff_header.data_storage_type=VFF_TYP_BIT;<               packets=((image->columns+7) >> 3)*image->rows;
             }c       }o     /*2       Write VIFF image header (pad to 1024 bytes).     */%     buffer[0]=viff_header.identifier;f$     buffer[1]=viff_header.file_type;"     buffer[2]=viff_header.release;"     buffer[3]=viff_header.version;-     buffer[4]=viff_header.machine_dependency;.%     buffer[5]=viff_header.reserve[0];i%     buffer[6]=viff_header.reserve[1];u%     buffer[7]=viff_header.reserve[2];m3     (void) fwrite((char *) buffer,1,8,image->file);cB     (void) fwrite((char *) viff_header.comment,1,512,image->file);4     MSBFirstWriteLong(viff_header.rows,image->file);7     MSBFirstWriteLong(viff_header.columns,image->file); 7     MSBFirstWriteLong(viff_header.subrows,image->file);;H     MSBFirstWriteLong((unsigned long) viff_header.x_offset,image->file);H     MSBFirstWriteLong((unsigned long) viff_header.y_offset,image->file);L     MSBFirstWriteLong((unsigned long) viff_header.x_pixel_size,image->file);L     MSBFirstWriteLong((unsigned long) viff_header.y_pixel_size,image->file);=     MSBFirstWriteLong(viff_header.location_type,image->file);SB     MSBFirstWriteLong(viff_header.location_dimension,image->file);@     MSBFirstWriteLong(viff_header.number_of_images,image->file);A     MSBFirstWriteLong(viff_header.number_data_bands,image->file);_A     MSBFirstWriteLong(viff_header.data_storage_type,image->file);aB     MSBFirstWriteLong(viff_header.data_encode_scheme,image->file);:     MSBFirstWriteLong(viff_header.map_scheme,image->file);@     MSBFirstWriteLong(viff_header.map_storage_type,image->file);8     MSBFirstWriteLong(viff_header.map_rows,image->file);;     MSBFirstWriteLong(viff_header.map_columns,image->file);p;     MSBFirstWriteLong(viff_header.map_subrows,image->file); :     MSBFirstWriteLong(viff_header.map_enable,image->file);>     MSBFirstWriteLong(viff_header.maps_per_cycle,image->file);A     MSBFirstWriteLong(viff_header.color_space_model,image->file);      for (i=0; i < 420; i++) %       (void) fputc('\0',image->file);      /*)       Convert MIFF to VIFF raster pixels.s     */H     viff_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);      p=image->pixels;     q=viff_pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))g       {(         unsigned longn           offset;   
         /*7           Convert DirectClass packet to VIFF RGB pixel. 
         */*         offset=image->columns*image->rows;*         for (i=0; i < image->packets; i++)	         {S.           for (j=0; j <= (int) p->length; j++)           {o!             *q=DownScale(p->red); ,             *(q+offset)=DownScale(p->green);-             *(q+offset*2)=DownScale(p->blue);e             if (image->matte)S5               *(q+offset*3)=(unsigned char) p->index;              q++;           }n           p++;#           if (QuantumTick(i,image))_<             ProgressMonitor(SaveImageText,i,image->packets);	         }e       }e     else       if (!IsGrayImage(image))	         {l           unsigned charF             *viff_colormap;c             /*"             Dump colormap to file.           */)           viff_colormap=(unsigned char *)S:             malloc(image->colors*3*sizeof(unsigned char));6           if (viff_colormap == (unsigned char *) NULL)=             PrematureExit("Unable to allocate memory",image);            q=viff_colormap;+           for (i=0; i < image->colors; i++)g3             *q++=DownScale(image->colormap[i].red);n+           for (i=0; i < image->colors; i++)d5             *q++=DownScale(image->colormap[i].green); +           for (i=0; i < image->colors; i++) 4             *q++=DownScale(image->colormap[i].blue);G           (void) fwrite((char *) viff_colormap,1,(int) image->colors*3,              image->file); '           free((char *) viff_colormap);m           /*B             Convert PseudoClass packet to VIFF colormapped pixels.           */           q=viff_pixels;,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->index;             p++;%             if (QuantumTick(i,image))+>               ProgressMonitor(SaveImageText,i,image->packets);           } 	         }D
       else         if (image->colors == 2)a           {m"             register unsigned char               bit,               byte,i               polarity;                register int               x;               /*C               Convert PseudoClass image to a VIFF monochrome image.              */             polarity=aL               Intensity(image->colormap[0]) > Intensity(image->colormap[1]);             x=0;             bit=0;             byte=0;g.             for (i=0; i < image->packets; i++)
             { 2               for (j=0; j <= (int) p->length; j++)               {r                 byte>>=1;,)                 if (p->index == polarity)                    byte|=0x80;)                 bit++;                 if (bit == 8)e                   {                      *q++=byte;                     bit=0;                     byte=0;%                   }%                 x++;(                 if (x == image->columns)                   {                      /*3                       Advance to the next scanline.                      */!                     if (bit != 0) +                       *q++=byte >> (8-bit);                      bit=0;                     byte=0;                      x=0;                  }               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }            }          else           {              /*A               Convert PseudoClass packet to VIFF grayscale pixel.              */.             for (i=0; i < image->packets; i++)
             {s2               for (j=0; j <= (int) p->length; j++)                 *q++=p->red;               p++;'               if (QuantumTick(i,image))s@                 ProgressMonitor(SaveImageText,i,image->packets);
             }e           }tD     (void) fwrite((char *) viff_pixels,1,(int) packets,image->file);     free((char *) viff_pixels); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);g }m _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             % O %                                                                             % O %                                                                             %iO %   W r i t e X I m a g e                                                     % O %                                                                             %(O %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %n7 %  Function WriteXImage writes an image to an X server.  %r, %  The format of the WriteXImage routine is: % + %      status=WriteXImage(image_info,image)n %n+ %  A description of each parameter follows.  % L %    o status: Function WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or ifr% %      the image file fails to write.  %gA %    o image_info: Specifies a pointer to an ImageInfo structure.  %f. %    o image:  A pointer to a Image structure. %O %Y */1 static unsigned int WriteXImage(image_info,image) 	 ImageInfon   *image_info;   Imager	   *image;g {D   Atom     wm_delete_window,_     wm_protocols;      char     name[MaxTextLength];  	   Displaym
     *display;2     register char      *p;      unsigned int     status;      XGCValues      context_values;=     XResourceInfoT     resource_info;  
   XrmDatabasei     resource_database;     XEvent
     event;     XPixelInfo     pixel_info;t     XStandardColormap      *map_info;  
   XVisualInfop     *visual_info;   
   XWindowInfop     window_info;     /*     Open X server connection.U   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));r       return(False);     }[   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);l   /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");n   /*     Initialize visual info.n   */?   visual_info=XBestVisualInfo(display,map_info,&resource_info);e*   if (visual_info == (XVisualInfo *) NULL)>     Warning("Unable to get visual",resource_info.visual_type);%   map_info->colormap=(Colormap) NULL;w+   pixel_info.pixels=(unsigned long *) NULL;g'   pixel_info.gamma_map=(XColor *) NULL;s1   if ((map_info == (XStandardColormap *) NULL) ||a,       (visual_info == (XVisualInfo *) NULL))     {)>       XFreeResources(display,visual_info,map_info,&pixel_info,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }n   /*!     Initialize Standard Colormap.;   */)   ProgressMonitor(SaveImageText,100,400); J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);    /*%     Initialize window info structure.;   */   window_info.id=(Window) NULL;>O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,e!     &resource_info,&window_info);    window_info.name=name;.   p=image->filename+strlen(image->filename)-1;A   while ((p > image->filename) && (*(p-1) != *BasenameSeparator))D     p--;H   (void) sprintf(window_info.name,"ImageMagick: %s[%u]",p,image->scene);   if (image->scene == 0)9     (void) sprintf(window_info.name,"ImageMagick: %s",p);a#   window_info.width=image->columns;t!   window_info.height=image->rows;aC   window_info.attributes.event_mask=ButtonPressMask | ExposureMask;tP   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);   window_info.x=0;   window_info.y=0;"   window_info.shared_memory=False;   /*     Graphic context.   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);;   window_info.annotate_context=pixel_info.annotate_context;)>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;N   pixel_info.highlight_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   window_info.highlight_context=pixel_info.highlight_context;v&   pixel_info.widget_context=(GC) NULL;'   window_info.widget_context=(GC) NULL;t   /*     Initialize X image.    */)   ProgressMonitor(SaveImageText,250,400); M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,o     image->rows);a   if (status == False)     {s>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     }i   free((char *) image->pixels);I)   image->pixels=(RunlengthPacket *) NULL;):   (void) XMakePixmap(display,&resource_info,&window_info);!   free(window_info.ximage->data);%)   window_info.ximage->data=(char *) NULL;    /*4     Display image and wait for button press to exit.   */)   ProgressMonitor(SaveImageText,400,400); 9   wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False); A   wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False); %   XMapWindow(display,window_info.id); 
   for ( ; ; )    {      XNextEvent(display,&event); "     if (event.type == ButtonPress)       break;$     if (event.type == ClientMessage)5       if (event.xclient.message_type == wm_protocols) 6         if (*event.xclient.data.l == wm_delete_window)5           if (event.xclient.window == window_info.id)%             break;     if (event.type == Expose)i2       XRefreshWindow(display,&window_info,&event);   }e=   XWithdrawWindow(display,window_info.id,window_info.screen);:   /*     Free X resources.m   */O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,a!     &resource_info,&window_info);T   return(True);i }r e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %uO %                                                                             %:O %   W r i t e X B M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure WriteXBMImage writes an image to a file in the X bitmap format. % . %  The format of the WriteXBMImage routine is: % - %      status=WriteXBMImage(image_info,image)a %;+ %  A description of each parameter follows.m %cJ %    o status: Function WriteXBMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileC %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.a %.. %    o image:  A pointer to a Image structure. %m %( */3 static unsigned int WriteXBMImage(image_info,image)i	 ImageInfo    *image_info;   Image'	   *image;  {(   char     name[MaxTextLength];     register int     i,     j,     x;     register char      *q;m     register RunlengthPacket     *p;o     register unsigned char     bit,	     byte, 
     polarity;'     unsigned int
     count;     /*     Open output image file."   */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Write X bitmap header.   */&   (void) strcpy(name,image->filename);	   q=name;f%   while ((*q != '.') && (*q != '\0'))f     q++;   if (*q == '.')     *q='\0';J   (void) fprintf(image->file,"#define %s_width %u\n",name,image->columns);H   (void) fprintf(image->file,"#define %s_height %u\n",name,image->rows);A   (void) fprintf(image->file,"static char %s_bits[] = {\n",name);n"   (void) fprintf(image->file," ");   /*$     Convert MIFF to X bitmap pixels.   */2   if (!IsGrayImage(image) || (image->colors != 2))     {iA       QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);        SyncImage(image);e     } 
   polarity=0;    if (image->colors == 2)gK     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);,   bit=0;	   byte=0;*
   count=0;   x=0;   p=image->pixels;"   (void) fprintf(image->file," ");$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        byte>>=1;        if (p->index == polarity)o         byte|=0x80;        bit++;       if (bit == 8)>	         {,           /*2             Write a bitmap byte to the image file.           */N           (void) fprintf(image->file,"0x%02x, ",(unsigned int) (byte & 0xff));           count++;           if (count == 12)
             { 1               (void) fprintf(image->file,"\n  ");                count=0;             };           bit=0;           byte=0; 	         }t
       x++;       if (x == image->columns)	         {            if (bit != 0)o
             {,               /*6                 Write a bitmap byte to the image file.               */               byte>>=(8-bit); B               (void) fprintf(image->file,"0x%02x, ",(unsigned int)                 (byte & 0xff));e               count++;               if (count == 12)                 { 5                   (void) fprintf(image->file,"\n  ");                    count=0;                 };               bit=0;               byte=0;b             };           x=0;	         }      }      p++;     if (QuantumTick(i,image))f6       ProgressMonitor(SaveImageText,i,image->packets);   } %   (void) fprintf(image->file,"};\n");    CloseImage(image);   return(True);  }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %lO %   W r i t e X C I m a g e                                                   %mO %                                                                             %0O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % H %  Function WriteXCImage writes an image in the X constant image format. %,- %  The format of the WriteXCImage routine is:  % , %      status=WriteXCImage(image_info,image) % + %  A description of each parameter follows.  % I %    o status: Function WriteXCImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image filef %      fails to write. %>A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %; %  */2 static unsigned int WriteXCImage(image_info,image)	 ImageInfoe   *image_info;   Images	   *image;  {    unsigned int     status;   4   Warning("Cannot write XC images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);> }e u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             % O %                                                                             %;O %   W r i t e X P M I m a g e                                                 %PO %                                                                             %BO %                                                                             % O %                                                                             %>O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure WriteXPMImage writes an image to a file in the X pixmap format. %;. %  The format of the WriteXPMImage routine is: % - %      status=WriteXPMImage(image_info,image); % + %  A description of each parameter follows.  %fJ %    o status: Function WriteXPMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filee %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.% %%. %    o image:  A pointer to a Image structure. %  %  */
 #ifdef HasXPM  #include "xpm.h"3 static unsigned int WriteXPMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    char     *xpm_buffer;  	   Display 
     *display;      int      status;      register char      *p;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XImage     *matte_image;      XPixelInfo     pixel_info;      XpmAttributes      xpm_attributes;      XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;   
   XWindowInfo%     window_info;     /*     Open output image file.%   */"   OpenImage(image_info,image,"w");#   if (image->file == (FILE *) NULL)a/     PrematureExit("Unable to open file",image);f   /*     Open X server connection.m   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));e       return(False);     }d   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);e   /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;y   /*     Allocate standard colormap.a   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)iM     Warning("Unable to create standard colormap","Memory allocation failed");    /*     Initialize visual info.    */?   visual_info=XBestVisualInfo(display,map_info,&resource_info); *   if (visual_info == (XVisualInfo *) NULL)>     Warning("Unable to get visual",resource_info.visual_type);%   map_info->colormap=(Colormap) NULL;n+   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL;i1   if ((map_info == (XStandardColormap *) NULL) ||l,       (visual_info == (XVisualInfo *) NULL))     {t>       XFreeResources(display,visual_info,map_info,&pixel_info,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }    matte_image=(XImage *) NULL;   if (image->matte)i     {r       /*         Create X shape image.        */H       matte_image=XCreateImage(display,visual_info->visual,1,XYBitmap,0,H         (char *) NULL,image->columns,image->rows,XBitmapPad(display),0);)       if (matte_image == (XImage *) NULL)f>         Warning("Unable to create matte image",(char *) NULL);
       else	         {p           /*(             Allocate X shape image data.           */$           matte_image->data=(char *)D             malloc(matte_image->bytes_per_line*matte_image->height);1           if (matte_image->data == (char *) NULL)aO             Warning("Unable to create matte image","Memory allocation failed");            else
             {                int                  x,                 y;                 register int                 i,                 j;  &               register RunlengthPacket                 *p;                  /*)                 Initialize X shape image.                */               x=0;               y=0;               p=image->pixels;0               for (i=0; i < image->packets; i++)               {s4                 for (j=0; j <= (int) p->length; j++)                 { M                   XPutPixel(matte_image,x,y,p->index == Transparent ? 0 : 1);r                   x++;*                   if (x == image->columns)                     {                        x=0;                       y++;                     }m                 }                  p++;               } 
             } 	         }e     }p   /*!     Initialize Standard Colormap.c   */)   ProgressMonitor(SaveImageText,100,400);c=   if ((image->class == DirectClass) || (image->colors > 256))u     {        /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);,     } J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info); (   pixel_info.annotate_context=(GC) NULL;)   pixel_info.highlight_context=(GC) NULL;l&   pixel_info.widget_context=(GC) NULL;   /*%     Initialize window info structure.a   */   window_info.id=(Window) NULL; O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,d!     &resource_info,&window_info);e.   p=image->filename+strlen(image->filename)-1;2   while ((p > image->filename) && (*(p-1) != '/'))     p--;   window_info.name=p;i#   window_info.width=image->columns; !   window_info.height=image->rows;bP   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);"   window_info.shared_memory=False;   /*     Initialize X image.    */)   ProgressMonitor(SaveImageText,250,400);"M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,"     image->rows);    if (status == False)     {C>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     },   /*     Intialize XPM attributes.h   */H   xpm_attributes.valuemask=XpmColormap | XpmDepth | XpmSize | XpmVisual;,   xpm_attributes.visual=visual_info->visual;*   xpm_attributes.depth=visual_info->depth;-   xpm_attributes.colormap=map_info->colormap; &   xpm_attributes.width=image->columns;$   xpm_attributes.height=image->rows;I   status=XpmCreateBufferFromImage(display,&xpm_buffer,window_info.ximage,o!     matte_image,&xpm_attributes);r   /*     Free X resources.o   */%   if (matte_image != (XImage *) NULL)p     XDestroyImage(matte_image); %   XpmFreeAttributes(&xpm_attributes);mO   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);e   if (status != XpmSuccess)"1     PrematureExit("Unable to write image",image);,   /*     Write XPM image.   */F   (void) fwrite((char *) xpm_buffer,1,strlen(xpm_buffer),image->file);   free((char *) xpm_buffer);   CloseImage(image);)   ProgressMonitor(SaveImageText,400,400);b   return(True);  }  #else 3 static unsigned int WriteXPMImage(image_info,image) 	 ImageInfoy   *image_info;   Image 	   *image;, {    unsigned int     status;   :   Warning("XPM library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);/ }s #endif p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %dO %                                                                             %,O %                                                                             %rO %   W r i t e Y U V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.  % . %  The format of the WriteYUVImage routine is: % - %      status=WriteYUVImage(image_info,image)  %r+ %  A description of each parameter follows.  %{J %    o status: Function WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filee %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.s %0. %    o image:  A pointer to a Image structure. %] %  */3 static unsigned int WriteYUVImage(image_info,image) 	 ImageInfor   *image_info;   Image 	   *image;  {"   Image      *reduced_image;I     register int     i,     j;     register RunlengthPacket     *p;u     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);s   /*     Initialize Y channel.-   */+   RGBTransformImage(image,YCbCrColorspace);r   p=image->pixels;$   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }    /*     Scale image.   */)   ProgressMonitor(SaveImageText,100,400);    image->orphan=True; #   reduced_image=MinifyImage(image);p   image->orphan=False;&   if (reduced_image == (Image *) NULL)1     PrematureExit("Unable to scale image",image);f   /*     Initialize U channel.    */)   ProgressMonitor(SaveImageText,200,400);y   p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   {f(     for (j=0; j <= (int) p->length; j++)4       (void) fputc(DownScale(p->green),image->file);     p++;   }c   /*     Initialize V channel.    */)   ProgressMonitor(SaveImageText,400,400);    p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   {p(     for (j=0; j <= (int) p->length; j++)3       (void) fputc(DownScale(p->blue),image->file);      p++;   })   DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace); )   ProgressMonitor(SaveImageText,400,400);t   return(True);u }n   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%kO %                                                                             %nO %                                                                             %sO %                                                                             %nO %   W r i t e Y U V 3 I m a g e                                               %oO %                                                                             % O %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eG %  Function WriteYUV3Image writes an image to a file in the digital YUV M %  (CCIR 601 4:1:1) format.  This function differs from WriteYUVImage in that.K %  it write the Y, U, and V planes to separate files (image.Y, image.U, and& %  image.V). % / %  The format of the WriteYUV3Image routine is:e % . %      status=WriteYUV3Image(image_info,image) %e+ %  A description of each parameter follows.  % K %    o status: Function WriteYUV3Image return True if the image is written.)K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %- %< */4 static unsigned int WriteYUV3Image(image_info,image)	 ImageInfo<   *image_info;   Image 	   *image;  {c   char     filename[MaxTextLength];     Image)     *reduced_image;      register int     i,     j;     register RunlengthPacket     *p;*     /*     Open output image file.    */*   (void) strcpy(filename,image->filename);'   if (strcmp(image->filename,"-") != 0) (     (void) strcat(image->filename,".Y");.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)=/     PrematureExit("Unable to open file",image);a   /*     Write Y channel.   */+   RGBTransformImage(image,YCbCrColorspace);    p=image->pixels;$   for (i=0; i < image->packets; i++)   {h(     for (j=0; j <= (int) p->length; j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }    CloseImage(image);   /*     Scale image.   */)   ProgressMonitor(SaveImageText,100,400);    image->orphan=True;a#   reduced_image=MinifyImage(image);s   image->orphan=False;&   if (reduced_image == (Image *) NULL)2     PrematureExit("Unable to reduce image",image);   /*     Write U channel.   */)   ProgressMonitor(SaveImageText,200,400);f2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)r0     (void) strcat(reduced_image->filename,".U");6   OpenImage(image_info,reduced_image,WriteBinaryType);+   if (reduced_image->file == (FILE *) NULL)c     {e"       DestroyImage(reduced_image);9       PrematureExit("Unable to open file",reduced_image);      }i   p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   {e(     for (j=0; j <= (int) p->length; j++)<       (void) fputc(DownScale(p->green),reduced_image->file);     p++;   }e   CloseImage(reduced_image);   /*     Write V channel.   */)   ProgressMonitor(SaveImageText,300,400);s2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)r0     (void) strcat(reduced_image->filename,".V");6   OpenImage(image_info,reduced_image,WriteBinaryType);+   if (reduced_image->file == (FILE *) NULL)      {i"       DestroyImage(reduced_image);9       PrematureExit("Unable to open file",reduced_image);;     }v   p=reduced_image->pixels;,   for (i=0; i < reduced_image->packets; i++)   {i(     for (j=0; j <= (int) p->length; j++);       (void) fputc(DownScale(p->blue),reduced_image->file);      p++;   }f   CloseImage(reduced_image);   DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);;+   (void) sprintf(image->filename,filename);%)   ProgressMonitor(SaveImageText,400,400);m   return(True);; }  v /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %\O %                                                                             %eO %                                                                             %aO %   W r i t e X W D I m a g e                                                 %aO %                                                                             %%O %                                                                             % O %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %=D %  Function WriteXWDImage writes an image to a file in X window dump %  rasterfile format.p %). %  The format of the WriteXWDImage routine is: % - %      status=WriteXWDImage(image_info,image)c %r+ %  A description of each parameter follows.n %sJ %    o status: Function WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filel %      fails to write. %iA %    o image_info: Specifies a pointer to an ImageInfo structure.e %m. %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteXWDImage(image_info,image)o	 ImageInfoa   *image_info;   Imager	   *image;- {c   int+     x;     register int     i,     j,     k;     register RunlengthPacket     *p;      unsigned int     bits_per_pixel,=     bytes_per_line,      scanline_pad;      unsigned long      lsb_first;     XWDFileHeader      xwd_header;      /*     Open output image file.0   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);e   /*     Initialize XWD file header.    */@   xwd_header.header_size=sz_XWDheader+strlen(image->filename)+1;;   xwd_header.file_version=(unsigned long) XWD_FILE_VERSION;(3   xwd_header.pixmap_format=(unsigned long) ZPixmap; )   xwd_header.pixmap_depth=(unsigned long) +     (image->class == DirectClass ? 24 : 8); 9   xwd_header.pixmap_width=(unsigned long) image->columns;f7   xwd_header.pixmap_height=(unsigned long) image->rows;f'   xwd_header.xoffset=(unsigned long) 0; 1   xwd_header.byte_order=(unsigned long) MSBFirst;"P   xwd_header.bitmap_unit=(unsigned long) (image->class == DirectClass ? 32 : 8);7   xwd_header.bitmap_bit_order=(unsigned long) MSBFirst; O   xwd_header.bitmap_pad=(unsigned long) (image->class == DirectClass ? 32 : 8);+8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);;   xwd_header.bits_per_pixel=(unsigned long) bits_per_pixel; ?   bytes_per_line=(unsigned long) ((((xwd_header.bits_per_pixel* :     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3)); ;   xwd_header.bytes_per_line=(unsigned long) bytes_per_line;i)   xwd_header.visual_class=(unsigned long) >     (image->class == DirectClass ? DirectColor : PseudoColor);%   xwd_header.red_mask=(unsigned long) 1     (image->class == DirectClass ? 0xff0000 : 0);:'   xwd_header.green_mask=(unsigned long)-/     (image->class == DirectClass ? 0xff00 : 0);lP   xwd_header.blue_mask=(unsigned long) (image->class == DirectClass ? 0xff : 0);)   xwd_header.bits_per_rgb=(unsigned long) +     (image->class == DirectClass ? 24 : 8); -   xwd_header.colormap_entries=(unsigned long)n8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors);t9   xwd_header.window_width=(unsigned long) image->columns;t7   xwd_header.window_height=(unsigned long) image->rows;a   xwd_header.window_x=0;   xwd_header.window_y=0;/   xwd_header.window_bdrwidth=(unsigned long) 0;t   /*     Write XWD header.    */   lsb_first=1;   if (*(char *) &lsb_first)r?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header));\A   (void) fwrite((char *) &xwd_header,sz_XWDheader,1,image->file);>E   (void) fwrite((char *) image->filename,1,strlen(image->filename)+1,o     image->file); "   if (image->class == PseudoClass)     {        XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */=       colors=(XColor *) malloc(image->colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image);-'       for (i=0; i < image->colors; i++)        {          colors[i].pixel=i;7         colors[i].red=XUpScale(image->colormap[i].red);v;         colors[i].green=XUpScale(image->colormap[i].green); 9         colors[i].blue=XUpScale(image->colormap[i].blue); 1         colors[i].flags=DoRed | DoGreen | DoBlue;x         colors[i].pad=0;!         if (*(char *) &lsb_first)e           {(F             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }        } '       for (i=0; i < image->colors; i++)i       { $         color.pixel=colors[i].pixel;          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;A         (void) fwrite((char *) &color,sz_XWDColor,1,image->file);        }        free((char *) colors);     }p   /*&     Convert MIFF to XWD raster pixels.   */   scanline_pad=(unsigned int)o<     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));   x=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     { &       if (image->class == PseudoClass)+         (void) fputc(p->index,image->file); 
       else	         {n6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file); 	         } 
       x++;       if (x == image->columns)	         {f*           for (k=0; k < scanline_pad; k++)(             (void) fputc(0,image->file);           x=0;	         }T     }m     p++;     if (QuantumTick(i,image))a6       ProgressMonitor(SaveImageText,i,image->packets);   }r   CloseImage(image);   return(True);  }a   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             %iO %                                                                             % O %   W r i t e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function WriteImage writes an image to a file.  You can specify aJ %  particular image format by prefixing the file with the image type and aI %  colon (i.e. ps:image) or specify the image type as the filename suffix  %  (i.e. image.ps).l %a+ %  The format of the WriteImage routine is:m %-* %      status=WriteImage(image_info,image) %e+ %  A description of each parameter follows:  % G %    o status: Function WriteImage return True if the image is written.rK %      False is returned is there is a memory shortage or if the image file- %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.a %> %e */) unsigned int WriteImage(image_info,image) 	 ImageInfos   *image_info;   Imagef	   *image;  {    unsigned int     status;f     /*6     Call appropriate image writer based on image type.   */6   (void) strcpy(image_info->filename,image->filename);2   (void) strcpy(image_info->magick,image->magick);   SetImageInfo(image_info);,6   (void) strcpy(image->filename,image_info->filename);   switch (*image_info->magick)   { 
     case 'A':;     { -       status=WriteAVSImage(image_info,image);        break;     } 
     case 'B':u     {m0       if (strcmp(image_info->magick,"BIE") == 0)0         status=WriteJBIGImage(image_info,image);
       else/         status=WriteBMPImage(image_info,image);        break;     }j
     case 'C':      {t.       status=WriteCMYKImage(image_info,image);       break;     }>
     case 'E':s     {n,       status=WritePSImage(image_info,image);       break;     }3
     case 'F':      { 0       if (strcmp(image_info->magick,"FAX") == 0)/         status=WriteFAXImage(image_info,image); 
       else0         status=WriteFITSImage(image_info,image);       break;     }T
     case 'G':      { 3       if (strncmp(image_info->magick,"GIF",3) == 0)e/         status=WriteGIFImage(image_info,image); 
       else3         if (strcmp(image_info->magick,"GRAY") == 0)g2           status=WriteGRAYImage(image_info,image);         else1           status=WriteFAXImage(image_info,image);        break;     }v
     case 'H':a     {e0       if (strcmp(image_info->magick,"HDF") == 0)/         status=WriteHDFImage(image_info,image); 
       else8         if (strcmp(image_info->magick,"HISTOGRAM") == 0)7           status=WriteHISTOGRAMImage(image_info,image);          else2           status=WriteHTMLImage(image_info,image);       break;     }m
     case 'J':      { 1       if (strcmp(image_info->magick,"JBIG") == 0);0         status=WriteJBIGImage(image_info,image);
       else0         status=WriteJPEGImage(image_info,image);       break;     } 
     case 'L':      { .       status=WriteLOGOImage(image_info,image);       break;     } 
     case 'M':g     {r0       if (strcmp(image_info->magick,"MAP") == 0)/         status=WriteMAPImage(image_info,image); 
       else4         if (strcmp(image_info->magick,"MATTE") == 0)3           status=WriteMATTEImage(image_info,image);          else5           if (strcmp(image_info->magick,"MIFF") == 0) 4             status=WriteMIFFImage(image_info,image);           else;             if ((strcmp(image_info->magick,"MPEG") == 0) ||y8                 (strcmp(image_info->magick,"MPG") == 0))6               status=WriteMPEGImage(image_info,image);             else5               status=WriteMTVImage(image_info,image);        break;     } 
     case 'N':        break;
     case 'P':      { 0       if (strcmp(image_info->magick,"PCD") == 0)/         status=WritePCDImage(image_info,image); 
       else2         if (strcmp(image_info->magick,"PCX") == 0)1           status=WritePCXImage(image_info,image);          else4           if (strcmp(image_info->magick,"PDF") == 0)3             status=WritePDFImage(image_info,image);u           else7             if (strcmp(image_info->magick,"PICT") == 0) 6               status=WritePICTImage(image_info,image);             else7               if (strcmp(image_info->magick,"PM") == 0)e7                 status=WriteXPMImage(image_info,image);                else:                 if (strcmp(image_info->magick,"PNG") == 0)9                   status=WritePNGImage(image_info,image);r                 else;                   if (strcmp(image_info->magick,"PS") == 0) :                     status=WritePSImage(image_info,image);                   else>                     if (strcmp(image_info->magick,"PS2") == 0)=                       status=WritePS2Image(image_info,image);                      else=                       status=WritePNMImage(image_info,image);        break;     }g
     case 'R':e     {x0       if (strcmp(image_info->magick,"RAD") == 0)4         status=WriteRADIANCEImage(image_info,image);
       else2         if (strcmp(image_info->magick,"RAS") == 0)1           status=WriteSUNImage(image_info,image);;         else7           if (strncmp(image_info->magick,"RGB",3) == 0)i3             status=WriteRGBImage(image_info,image);"           else3             status=WriteRLEImage(image_info,image);;       break;     }i
     case 'S':%     {;0       if (strcmp(image_info->magick,"SGI") == 0)/         status=WriteSGIImage(image_info,image);g
       else/         status=WriteSUNImage(image_info,image);e       break;     }u
     case 'T':*     {%1       if (strcmp(image_info->magick,"TEXT") == 0)%0         status=WriteTEXTImage(image_info,image);
       else2         if (strcmp(image_info->magick,"TGA") == 0)3           status=WriteTARGAImage(image_info,image);          else7           if (strncmp(image_info->magick,"TIF",3) == 0) 4             status=WriteTIFFImage(image_info,image);           else4             status=WriteTILEImage(image_info,image);       break;     } 
     case 'U':      { 1       if (strcmp(image_info->magick,"UYVY") == 0) 0         status=WriteUYVYImage(image_info,image);       break;     } 
     case 'V':      { 2       if (strcmp(image_info->magick,"VICAR") == 0)1         status=WriteVICARImage(image_info,image);%
       else2         if (strcmp(image_info->magick,"VID") == 0)2           status=WriteMIFFImage(image_info,image);         else2           status=WriteVIFFImage(image_info,image);       break;     }a
     case 'X':      {g.       if (strcmp(image_info->magick,"X") == 0)-         status=WriteXImage(image_info,image);i
       else2         if (strcmp(image_info->magick,"XBM") == 0)1           status=WriteXBMImage(image_info,image);          else3           if (strcmp(image_info->magick,"XC") == 0)n2             status=WriteXCImage(image_info,image);           else6             if (strcmp(image_info->magick,"XPM") == 0)5               status=WriteXPMImage(image_info,image);r             else7               if (strcmp(image_info->magick,"XV") == 0)(8                 status=WriteVIFFImage(image_info,image);               else7                 status=WriteXWDImage(image_info,image);P       break;     } 
     case 'Y':r     { 0       if (strcmp(image_info->magick,"YUV") == 0)/         status=WriteYUVImage(image_info,image);r
       else0         status=WriteYUV3Image(image_info,image);       break;     }a     default:.       status=WriteMIFFImage(image_info,image);   }    if (image->status)     {eG       Warning("An error has occurred writing to file",image->filename);        return(False);     }e2   (void) strcpy(image->magick,image_info->magick);   return(status);  } 