 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                       IIIII  M   M   AAA   GGGG  EEEEE                      % O %                         I    MM MM  A   A G      E                          % O %                         I    M M M  AAAAA G  GG  EEE                        % O %                         I    M   M  A   A G   G  E                          % O %                       IIIII  M   M  A   A  GGGG  EEEEE                      % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Routines                         % O %                                                                             % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"    /*   Function prototypes. */
 static double '   (*FilterFunction) _Declare((double));   
 static int9   IntensityCompare _Declare((const void *,const void *)), 5   NoisyCompare _Declare((const void *,const void *));    static unsigned int 6   InsidePrimitive _Declare((PrimitiveInfo *,int,int));   static void 9   Contrast _Declare((int,Quantum *,Quantum *,Quantum *)), M   Hull _Declare((int,int,int,unsigned int,unsigned int,Quantum *,Quantum *)), N   HSVTransform _Declare((double,double,double,Quantum *,Quantum *,Quantum *)),J   Modulate _Declare((double,double,double,Quantum *,Quantum *,Quantum *)),I   TransformHSV _Declare((unsigned int,unsigned int,unsigned int,double *,      double *,double *));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function AllocateImage allocates an Image structure and initializes each  %  field to a default value. % . %  The format of the AllocateImage routine is: % 0 %      allocated_image=AllocateImage(image_info) % + %  A description of each parameter follows:  % L %    o allocated_image: Function AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */  Image *AllocateImage(image_info)	 ImageInfo    *image_info; {    Image      *allocated_image;      /*     Allocate image structure.    */2   allocated_image=(Image *) malloc(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { E       Warning("Unable to allocate image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize Image structure.    */&   allocated_image->file=(FILE *) NULL;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; &   allocated_image->text=(char *) NULL;"   allocated_image->id=UndefinedId;%   allocated_image->class=DirectClass;    allocated_image->matte=False; ;   allocated_image->compression=RunlengthEncodedCompression;    allocated_image->columns=0;    allocated_image->rows=0;&   allocated_image->depth=QuantumDepth;#   allocated_image->interlace=False;    allocated_image->scene=0; 2   allocated_image->units=2;  /* pixels per inch */%   allocated_image->x_resolution=72.0; %   allocated_image->y_resolution=72.0; )   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(ColorPacket *) NULL;     allocated_image->colorspace=0;   allocated_image->colors=0;   allocated_image->gamma=0.0; 0   allocated_image->normalized_maximum_error=0.0;-   allocated_image->normalized_mean_error=0.0; *   allocated_image->mean_error_per_pixel=0;"   allocated_image->total_colors=0;+   allocated_image->signature=(char *) NULL; 3   allocated_image->pixels=(RunlengthPacket *) NULL; 3   allocated_image->packet=(RunlengthPacket *) NULL;    allocated_image->packets=0; !   allocated_image->packet_size=0; 8   allocated_image->packed_pixels=(unsigned char *) NULL;)   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; 5   allocated_image->magick_time=time((time_t *) NULL); *   allocated_image->geometry=(char *) NULL;    allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->list=(Image *) NULL; '   allocated_image->next=(Image *) NULL; '   if (image_info != (ImageInfo *) NULL)      { D       (void) strcpy(allocated_image->filename,image_info->filename);@       (void) strcpy(allocated_image->magick,image_info->magick);     }    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function AnnotateImage annotates an image with test.  Optionally the K %  annotation can include the image filename, type, width, height, or scene I %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  % " %  produces an image annotation of %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % . %  The format of the AnnotateImage routine is: % ) %      AnnotateImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % > %    o annotate_info: The address of a AnnotateInfo structure. %  %  */' void AnnotateImage(image,annotate_info)  Image 	   *image;    AnnotateInfo   *annotate_info;  {    char
     *text,     **textlist;      FILE
     *file;     int 
     flags,     status,      x,     y;     register char      *p,      *q;      register int     i,     j;     static AnnotateInfo      cache_info;      static Display      *display = (Display *) NULL;     static unsigned int      font_type = 0;     static XAnnotateInfo     xannotate_info;      static XFontStruct     *font_info;      static XPixelInfo      pixel_info;      static XResourceInfo     resource_info;     static XrmDatabase     resource_database;     static XStandardColormap     *map_info;     static XVisualInfo     *visual_info;      unsigned int     height,      indirection,     length, 
     width;  +   if (annotate_info->text == (char *) NULL)      return; ,   indirection=(*annotate_info->text == '@');   if (indirection)     { 	       int 
         c;         /*         Read text from a file.       */5       file=(FILE *) fopen(annotate_info->text+1,"r");         if (file == (FILE *) NULL)	         { D           Warning("Unable to read text file",annotate_info->text+1);           return; 	         }        length=MaxTextLength; 2       annotate_info->text=(char *) malloc(length);L       for (q=annotate_info->text; annotate_info->text != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;0         if ((q-annotate_info->text+1) >= length)           {              *q='\0';             length<<=1; D             annotate_info->text=realloc(annotate_info->text,length);5             if (annotate_info->text == (char *) NULL)                break;>             q=annotate_info->text+strlen(annotate_info->text);           }          *q=(unsigned char) c;        }        (void) fclose(file);/       if (annotate_info->text == (char *) NULL) 	         { I           Warning("Unable to annotate image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*'     Allocate and initialize image text.    */   p=annotate_info->text;3   length=strlen(annotate_info->text)+MaxTextLength; &   image->text=(char *) malloc(length);8   for (q=image->text; image->text != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;0     if ((q-image->text+MaxTextLength) >= length)       {          length<<=1; B         image->text=(char *) realloc((char *) image->text,length);)         if (image->text == (char *) NULL)            break;*         q=image->text+strlen(image->text);       }      /*,       Process formatting characters in text.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);*         q=image->text+strlen(image->text);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);*         q=image->text+strlen(image->text);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); *         q=image->text+strlen(image->text);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } #   if (image->text == (char *) NULL)      { E       Warning("Unable to annotate image","Memory allocation failed"); 
       return;      }    *q++='\0';   *q++='\0';   if (indirection)'     free((char *) annotate_info->text); %   textlist=StringToList(image->text);    free(image->text);   image->text=(char *) NULL;!   if (textlist == (char **) NULL)      return;    length=strlen(textlist[0]); .   for (i=0; textlist[i] != (char *) NULL; i++)%     if (strlen(textlist[i]) > length) !       length=strlen(textlist[i]);    text=malloc(length+4);   if (text == (char *) NULL)     { D       Warning("Unable to annotate image","Memory allocation error");
       return;      }    /*     Get annotate geometry.   */   x=0;   y=0;   width=image->columns; "   height=annotate_info->pointsize;   flags=NoValue;/   if (annotate_info->geometry != (char *) NULL)      { I       flags=XParseGeometry(annotate_info->geometry,&x,&y,&width,&height); #       if ((flags & XNegative) != 0)          x+=image->columns;#       if ((flags & YNegative) != 0)          y+=image->rows;      }    switch (font_type)   {      case 0:      default:     {        /*!         Open X server connection.        */&       if (display != (Display *) NULL)         break;7       display=XOpenDisplay(annotate_info->server_name); &       if (display != (Display *) NULL)	         {            /*,             Set our forgiving error handler.           */#           XSetErrorHandler(XError);            /*7             Get user defaults from X resource database.            */F           resource_database=XGetResourceDatabase(display,client_name);I           XGetResourceInfo(resource_database,client_name,&resource_info); +           resource_info.close_server=False; 1           resource_info.colormap=PrivateColormap; 3           if (annotate_info->font != (char *) NULL) 3             resource_info.font=annotate_info->font; 2           if (annotate_info->box != (char *) NULL)>             resource_info.background_color=annotate_info->box;2           if (annotate_info->pen != (char *) NULL)>             resource_info.foreground_color=annotate_info->pen;,           map_info=XAllocStandardColormap();5           if (map_info == (XStandardColormap *) NULL) 9             Warning("Unable to create standard colormap", *               "Memory allocation failed");           /*#             Initialize visual info.            */G           visual_info=XBestVisualInfo(display,map_info,&resource_info); 2           if (visual_info == (XVisualInfo *) NULL)F             Warning("Unable to get visual",resource_info.visual_type);-           map_info->colormap=(Colormap) NULL; 3           pixel_info.pixels=(unsigned long *) NULL; /           pixel_info.gamma_map=(XColor *) NULL;            /*.             Initialize Standard Colormap info.           */P           XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),             map_info);D           XGetPixelInfo(display,visual_info,map_info,&resource_info,(             (Image *) NULL,&pixel_info);N           pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);           /*!             Initialize font info.            */<           font_info=XBestFont(display,&resource_info,False);0           if (font_info == (XFontStruct *) NULL)>             Warning("Unable to load font",resource_info.font);9           if ((map_info == (XStandardColormap *) NULL) || 6               (visual_info == (XVisualInfo *) NULL) ||2               (font_info == (XFontStruct *) NULL))
             { F               XFreeResources(display,visual_info,map_info,&pixel_info,?                 font_info,&resource_info,(XWindowInfo *) NULL); '               display=(Display *) NULL; 
             } &           cache_info=(*annotate_info);           break;	         } O       Warning("Unable to load X server fonts","substituting Postscript fonts");        font_type++;     }      case 1:      { 
       char          filename[MaxTextLength],         page[MaxTextLength];         Image          *annotate_image;         ImageInfo          image_info;          register RunlengthPacket         *q;          unsigned int         matte;         XColor         box_color,         pen_color;         /*E         X server fonts are not available, use Postscript to annotate.        */@       (void) XQueryColorDatabase(annotate_info->box,&box_color);@       (void) XQueryColorDatabase(annotate_info->pen,&pen_color);        GetImageInfo(&image_info);"       TemporaryFilename(filename);!       image_info.monochrome=True; =       (void) sprintf(page,"%ux%u",height*length,height << 1);        image_info.page=page; /       if (annotate_info->font == (char *) NULL) (         annotate_info->font=DefaultFont;2       for (i=0; textlist[i] != (char *) NULL; i++)       { 8         if ((x >= image->columns) || (y >= image->rows))           break;!         if (*textlist[i] == '\0')            {              free(textlist[i]);             continue;            } (         (void) strcpy(text,textlist[i]);?         for (j=((int) strlen(textlist[i])-1) >> 1; j >= 0; j--) 	         { 6           (void) strcpy(image_info.filename,filename);#           file=fopen(filename,"w"); $           if (file == (FILE *) NULL)             break;3           (void) fprintf(file,"%%!PS-Adobe-3.0\n"); D           (void) fprintf(file,"/%s findfont %u scalefont setfont\n",(             annotate_info->font,height);E           (void) fprintf(file,"0 %u moveto (%s) show\n",height,text); ,           (void) fprintf(file,"showpage\n");           (void) fclose(file);0           annotate_image=ReadImage(&image_info);/           if (annotate_image == (Image *) NULL)              break;>           TransformImage(&annotate_image,"0x0",(char *) NULL);.           if (annotate_image->columns < width)             break;'           DestroyImage(annotate_image); *           (void) strcpy(text,textlist[i]);&           (void) strcpy(text+j,"...");B           (void) strcat(text,textlist[i]+strlen(textlist[i])-j-1);	         }           (void) unlink(filename);         free(textlist[i]);-         if (annotate_image == (Image *) NULL)            { >             Warning("Unable to annotate image",(char *) NULL);             break;           } 
         /*(           Composite text onto the image.
         */*         annotate_image->class=DirectClass;#         annotate_image->matte=True; !         q=annotate_image->pixels; 3         for (j=0; j < annotate_image->packets; j++) 	         {            if (q->index != 0)
             { /               q->red=XDownScale(box_color.red); 3               q->green=XDownScale(box_color.green); 1               q->blue=XDownScale(box_color.blue);                q->index= K                 annotate_info->box == (char *) NULL ? Transparent : Opaque; 
             }            else
             { /               q->red=XDownScale(pen_color.red); 3               q->green=XDownScale(pen_color.green); 1               q->blue=XDownScale(pen_color.blue);                q->index= K                 annotate_info->pen == (char *) NULL ? Transparent : Opaque; 
             }            q++;	         }          matte=image->matte; >         CompositeImage(image,OverCompositeOp,annotate_image,x+P           (annotate_info->center ? (width >> 1)-(annotate_image->columns >> 1) :           0),y);         image->matte=matte; $         y+=annotate_info->pointsize;%         DestroyImage(annotate_image);        }        free(text); 0       for ( ; textlist[i] != (char *) NULL; i++)         free(textlist[i]);       free((char *) textlist);
       return;      }    }    /*     Initialize annotate info.    */$   XGetAnnotateInfo(&xannotate_info);-   if (cache_info.font != annotate_info->font)      {        /*         Font name has changed.       */#       XFreeFont(display,font_info); /       if (annotate_info->font != (char *) NULL) /         resource_info.font=annotate_info->font; 8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);     } !   if ((flags & HeightValue) == 0) 0     height=font_info->ascent+font_info->descent;%   xannotate_info.font_info=font_info;    xannotate_info.text=text;    xannotate_info.x=x;    xannotate_info.y=y;    xannotate_info.width=width; =   xannotate_info.height=font_info->ascent+font_info->descent; @   annotate_info->pointsize=font_info->ascent+font_info->descent;.   if ((annotate_info->pen != (char *) NULL) &&,       (annotate_info->box != (char *) NULL)))     xannotate_info.stencil=OpaqueStencil;    else,     if (annotate_info->pen != (char *) NULL)/       xannotate_info.stencil=ForegroundStencil;      else/       xannotate_info.stencil=BackgroundStencil; /   if ((cache_info.box != annotate_info->box) || -       (cache_info.pen != annotate_info->pen))      {        /*         Pen color has changed.       */.       if (annotate_info->box != (char *) NULL):         resource_info.background_color=annotate_info->box;.       if (annotate_info->pen != (char *) NULL):         resource_info.foreground_color=annotate_info->pen;O       XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,          &pixel_info);      }    /*     Annotate the text image.   */.   for (i=0; textlist[i] != (char *) NULL; i++)   { 4     if ((x >= image->columns) || (y >= image->rows))       break;     if (*textlist[i] == '\0')        {          free(textlist[i]);         continue;        } $     (void) strcpy(text,textlist[i]);;     for (j=((int) strlen(textlist[i])-1) >> 1; j >= 0; j--)      { L       xannotate_info.width=(height*XTextWidth(font_info,text,strlen(text)))/         xannotate_info.height;'       if (xannotate_info.width < width)          break;&       (void) strcpy(text,textlist[i]);"       (void) strcpy(text+j,"...");>       (void) strcat(text,textlist[i]+strlen(textlist[i])-j-1);     }      free(textlist[i]);N     (void) sprintf(xannotate_info.geometry,"%ux%u%+d%+d",xannotate_info.width,K       height,(int) (xannotate_info.x+(annotate_info->center ? (width >> 1)- :       (xannotate_info.width >> 1) : 0)),xannotate_info.y);A     xannotate_info.width=XTextWidth(font_info,text,strlen(text)); K     status=XAnnotateImage(display,&pixel_info,&xannotate_info,False,image);      if (status == 0)       { G         Warning("Unable to xannotate image","Memory allocation error");          break;       } ,     xannotate_info.y+=xannotate_info.height;     y+=xannotate_info.height;    }    /*     Free resources.    */   cache_info=(*annotate_info);
   free(text); ,   for ( ; textlist[i] != (char *) NULL; i++)     free(textlist[i]);   free((char *) textlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BlurImage creates a new image that is a copy of an existing J %  one with the pixels blurred.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % F %  BlurImage convolves the pixel neighborhood with this blurring mask: % 
 %     1  2  1 
 %     2  W  2 
 %     1  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the BlurImage routine is: % , %      blurred_image=BlurImage(image,factor) % + %  A description of each parameter follows:  % G %    o blurred_image: Function BlurImage returns a pointer to the image J %      after it is blurred.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */ Image *BlurImage(image,factor) Image 	   *image;    double	   factor;  {  #define Blur(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;. #define BlurImageText  "  Blurring image...  "     Image      *blurred_image;   
   long int     total_blue,      total_green,     total_red,     weight;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { C       Warning("Unable to blur image","image size must exceed 3x3");        return((Image *) NULL);      }    /*(     Initialize blurred image attributes.   */B   blurred_image=CopyImage(image,image->columns,image->rows,False);&   if (blurred_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } #   blurred_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");"       DestroyImage(blurred_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=blurred_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */*   weight=(long int) ((100.0-factor)/2-13);   quantum=Max(weight+12,1); %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        s=s0; !       Blur(1);  Blur(2); Blur(1);        s=s1; %       Blur(2); Blur(weight); Blur(2);        s=s2; !       Blur(1);  Blur(2); Blur(1); <       q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);@       q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);>       q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;1     ProgressMonitor(BlurImageText,y,image->rows);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   return(blurred_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image H %  structure and returns a pointer to the new image.  Set the border and5 %  highlight to the same color to get a solid border.  % , %  The format of the BorderImage routine is: % A %      bordered_image=BorderImage(image,border_info,border_color)  % + %  A description of each parameter follows:  % M %    o bordered_image: Function BorderImage returns a pointer to the bordered H %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % I %    o border_info: Specifies a pointer to a XRectangle which defines the  %      border region.  % G %    o border_color: A pointer to a ColorPacket which contains the red, 6 %      green, and blue components of the border color. %  %  */2 Image *BorderImage(image,border_info,border_color) Image 	   *image;   
 RectangleInfo    *border_info;    ColorPacket    *border_color; { 8 #define BorderImageText  "  Adding border to image...  "     Image      *bordered_image;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      border;      /*)     Initialize bordered image attributes.    */J   bordered_image=CopyImage(image,image->columns+(border_info->width << 1),2     image->rows+(border_info->height << 1),False);'   if (bordered_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize border color.   */   border.red=border_color->red; #   border.green=border_color->green; !   border.blue=border_color->blue; #   border.index=border_color->index;    border.length=0;   /*(     Copy image and put border around it.   */   q=bordered_image->pixels; )   for (y=0; y < border_info->height; y++) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */*     for (x=0; x < border_info->width; x++)       *q++=border;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      x=0;K     while (x < (bordered_image->columns-image->columns-border_info->width))      {        *q++=border;
       x++;     } 3     ProgressMonitor(BorderImageText,y,image->rows);    } O   for (y=(bordered_image->rows-image->rows-border_info->height-1); y >= 0; y--) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C h o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ChopImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the ChopImage routine is: % , %      chop_image=ChopImage(image,chop_info) % + %  A description of each parameter follows:  % C %    o chop_image: Function ChopImage returns a pointer to the chop J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o chop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */! Image *ChopImage(image,chop_info)  Image 	   *image;   
 RectangleInfo 
   *chop_info;  { . #define ChopImageText  "  Chopping image...  "     Image      *chopped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      unsigned int     height;      /*     Check chop geometry.   */4   if (((chop_info->x+(int) chop_info->width) < 0) ||5       ((chop_info->y+(int) chop_info->height) < 0) || .       (chop_info->x > (int) image->columns) ||)       (chop_info->y > (int) image->rows))      { H       Warning("Unable to chop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((chop_info->x+(int) chop_info->width) > (int) image->columns) H     chop_info->width=(unsigned int) ((int) image->columns-chop_info->x);A   if ((chop_info->y+(int) chop_info->height) > (int) image->rows) F     chop_info->height=(unsigned int) ((int) image->rows-chop_info->y);   if (chop_info->x < 0)      { 7       chop_info->width-=(unsigned int) (-chop_info->x);        chop_info->x=0;      }    if (chop_info->y < 0)      { 8       chop_info->height-=(unsigned int) (-chop_info->y);       chop_info->y=0;      }    /*%     Initialize chop image attributes.    */@   chopped_image=CopyImage(image,image->columns-chop_info->width,)     image->rows-chop_info->height,False); &   if (chopped_image == (Image *) NULL)     { A       Warning("Unable to chop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Extract chop image.    */   p=image->pixels;   image->runlength=p->length+1;    q=chopped_image->pixels;"   for (y=0; y < chop_info->y; y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    /*%     Skip pixels up to the chop image.    */8   for (x=0; x < (chop_info->height*image->columns); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract chop image.    */6   height=image->rows-(chop_info->y+chop_info->height);   for (y=0; y < height; y++)   { &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      } ,     ProgressMonitor(ChopImageText,y,height);   }    return(chopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CloseImage closes a file associated with the image.  If the H %  filename prefix is '|', the file is a pipe and is closed with pclose. % + %  The format of the CloseImage routine is:  %  %      CloseImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CloseImage(image) Image 	   *image;  {    /*     Close image file.    */   if (image == (Image *) NULL)     return; #   if (image->file == (FILE *) NULL)      return; $   image->status=ferror(image->file);   if (image->pipe)     (void) pclose(image->file);    else:     if ((image->file != stdin) && (image->file != stdout))!       (void) fclose(image->file);    do   {      image->file=(FILE *) NULL;     image=image->next;   } "   while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or sceneI %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  %  %  produces an image comment of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % - %  The format of the CommentImage routine is:  % # %      CommentImage(image,comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */! void CommentImage(image,comments)  Image 	   *image;    char   *comments; {    register char      *p,      *q;      unsigned int     indirection,     length;   '   if (image->comments != (char *) NULL) #     free((char *) image->comments);     image->comments=(char *) NULL;    if (comments == (char *) NULL)     return; !   indirection=(*comments == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*"         Read comments from a file.       */*       file=(FILE *) fopen(comments+1,"r");        if (file == (FILE *) NULL)	         { =           Warning("Unable to read comments file",comments+1);            return; 	         }        length=MaxTextLength; '       comments=(char *) malloc(length); 6       for (q=comments; comments != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;%         if ((q-comments+1) >= length)            {              *q='\0';             length<<=1; @             comments=(char *) realloc((char *) comments,length);*             if (comments == (char *) NULL)               break;(             q=comments+strlen(comments);           }          *q=(unsigned char) c;        }        (void) fclose(file);$       if (comments == (char *) NULL)	         { I           Warning("Unable to comments image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*+     Allocate and initialize image comments.    */
   p=comments; (   length=strlen(comments)+MaxTextLength;*   image->comments=(char *) malloc(length);@   for (q=image->comments; image->comments != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;4     if ((q-image->comments+MaxTextLength) >= length)       {          length<<=1; J         image->comments=(char *) realloc((char *) image->comments,length);-         if (image->comments == (char *) NULL)            break;2         q=image->comments+strlen(image->comments);       }      /*0       Process formatting characters in comments.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);2         q=image->comments+strlen(image->comments);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);2         q=image->comments+strlen(image->comments);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); 2         q=image->comments+strlen(image->comments);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } '   if (image->comments == (char *) NULL)      { D       Warning("Unable to comment image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) comments); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s C o l o r m a p                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressColormap compresses an image colormap removing any %  unused color entries. % 1 %  The format of the CompressColormap routine is:  %  %      CompressColormap(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CompressColormap(image) Image 	   *image;  { 
   ColorPacket      *colormap;     int      number_colors;     register int     i;     register RunlengthPacket     *p;      register unsigned short 
     index;     /*,     Determine if colormap can be compressed.   */"   if (image->class != PseudoClass)     return;    number_colors=image->colors;#   for (i=0; i < image->colors; i++) #     image->colormap[i].flags=False;    image->colors=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { )     if (!image->colormap[p->index].flags)        { 6         image->colormap[p->index].index=image->colors;-         image->colormap[p->index].flags=True;          image->colors++;       }      p++;   } %   if (image->colors == number_colors) $     return;  /* no unused entries */   /*     Compress colormap.   */E   colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { H       Warning("Unable to compress colormap","Memory allocation failed");"       image->colors=number_colors;
       return;      } #   for (i=0; i < number_colors; i++) !     if (image->colormap[i].flags)        { '         index=image->colormap[i].index; 3         colormap[index].red=image->colormap[i].red; 7         colormap[index].green=image->colormap[i].green; 5         colormap[index].blue=image->colormap[i].blue;        }    /*     Remap pixels.    */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { -     p->index=image->colormap[p->index].index;      p++;   } !   free((char *) image->colormap);    image->colormap=colormap;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressImage compresses an image to the minimum number of %  runlength-encoded packets.  % . %  The format of the CompressImage routine is: %  %      CompressImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CompressImage(image)  Image 	   *image;  {    register int     i;     register RunlengthPacket     *p,      *q;      /*     Compress image.    */   if (image == (Image *) NULL)     return;    p=image->pixels;   image->runlength=p->length+1;    image->packets=0;    q=image->pixels;   q->length=MaxRunlength;    if (image->matte) 4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      }    else4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && C           (p->blue == q->blue) && ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*H     Runlength-encode only if it takes up less space than no compression.   */8   if (image->compression == RunlengthEncodedCompression)$     if (image->class == DirectClass)       { D         if (image->packets >= ((image->columns*image->rows*3) >> 2))+           image->compression=NoCompression;        }      else@       if (image->packets >= ((image->columns*image->rows) >> 1)))         image->compression=NoCompression;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CompositeImage returns the second image composited onto the " %  first at the specified offsets. % / %  The format of the CompositeImage routine is:  % F %      CompositeImage(image,compose,composite_image,x_offset,y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */D void CompositeImage(image,compose,composite_image,x_offset,y_offset) Image 	   *image;    unsigned int
   compose;   Image    *composite_image;    int    x_offset,    y_offset;  { 6 #define CompositeImageText  "  Compositing image...  "     int 	     blue, 
     green,     red;     register int     i,
     index,     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check composite geometry.    */.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { M       Warning("Unable to composite image","geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return; $   if (compose == ReplaceCompositeOp)     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)2         if (composite_image->class == DirectClass)#           image->class=DirectClass;          else           { 2             if (image->signature == (char *) NULL)'               ColormapSignature(image); <             if (composite_image->signature == (char *) NULL)1               ColormapSignature(composite_image); I             if (strcmp(image->signature,composite_image->signature) != 0) '               image->class=DirectClass;            } 2       if (image->matte && !composite_image->matte)	         { $           p=composite_image->pixels;6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;             p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    else     {        /*$         Initialize image matte data.       */       if (!image->matte)	         {            q=image->pixels;           red=q->red;            green=q->green;            blue=q->blue; ,           for (i=0; i < image->packets; i++)           {              q->index=Opaque;             q++;           } #           image->class=DirectClass;            image->matte=True;	         } "       if (!composite_image->matte)	         { $           p=composite_image->pixels;           red=p->red;            green=p->green;            blue=p->blue; 6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;L             if ((p->red == red) && (p->green == green) && (p->blue == blue))#               p->index=Transparent;              p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    /*      Initialize composited image.   */   p=composite_image->pixels;)   composite_image->runlength=p->length+1; +   for (y=0; y < composite_image->rows; y++)    { <     if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))       continue; 9     q=image->pixels+(y_offset+y)*image->columns+x_offset; 0     for (x=0; x < composite_image->columns; x++)     { *       if (composite_image->runlength != 0)%         composite_image->runlength--; 
       else	         {            p++;/           composite_image->runlength=p->length; 	         } A       if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 	         {            q++;           continue; 	         }        switch (compose)       {          case OverCompositeOp:          default:	         { &           if (p->index == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue;                index=q->index; 
             }            else#             if (p->index == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue;                  index=p->index;                }              else               { J                 red=(int) (p->red*Opaque+q->red*(Opaque-p->index))/Opaque;P                 green=(int) (p->green*Opaque+q->green*(Opaque-p->index))/Opaque;M                 blue=(int) (p->blue*Opaque+q->blue*(Opaque-p->index))/Opaque; P                 index=(int) (p->index*Opaque+q->index*(Opaque-p->index))/Opaque;               }            break;	         }          case InCompositeOp: 	         { -           red=(int) (p->red*q->index)/Opaque; 1           green=(int) (p->green*q->index)/Opaque; /           blue=(int) (p->blue*q->index)/Opaque; 1           index=(int) (p->index*q->index)/Opaque;            break;	         }          case OutCompositeOp:	         { 6           red=(int) (p->red*(Opaque-q->index))/Opaque;:           green=(int) (p->green*(Opaque-q->index))/Opaque;8           blue=(int) (p->blue*(Opaque-q->index))/Opaque;:           index=(int) (p->index*(Opaque-q->index))/Opaque;           break;	         }          case AtopCompositeOp: 	         { F           red=(int) (p->red*q->index+q->red*(Opaque-p->index))/Opaque;L           green=(int) (p->green*q->index+q->green*(Opaque-p->index))/Opaque;I           blue=(int) (p->blue*q->index+q->blue*(Opaque-p->index))/Opaque; L           index=(int) (p->index*q->index+q->index*(Opaque-p->index))/Opaque;           break;	         }          case XorCompositeOp:	         { O           red=(int) (p->red*(Opaque-q->index)+q->red*(Opaque-p->index))/Opaque; N           green=(int) (p->green*(Opaque-q->index)+q->green*(Opaque-p->index))/             Opaque; K           blue=(int) (p->blue*(Opaque-q->index)+q->blue*(Opaque-p->index))/              Opaque; N           index=(int) (p->index*(Opaque-q->index)+q->index*(Opaque-p->index))/             Opaque;            break;	         }          case PlusCompositeOp: 	         { (           red=(int) p->red+(int) q->red;.           green=(int) p->green+(int) q->green;+           blue=(int) p->blue+(int) q->blue; .           index=(int) p->index+(int) q->index;           break;	         }          case MinusCompositeOp:	         { (           red=(int) p->red-(int) q->red;.           green=(int) p->green-(int) q->green;+           blue=(int) p->blue-(int) q->blue;            index=Opaque;            break;	         }          case AddCompositeOp:	         { (           red=(int) p->red+(int) q->red;           if (red > Opaque)              red-=(Opaque+1);.           green=(int) p->green+(int) q->green;           if (green > Opaque)              green-=(Opaque+1);+           blue=(int) p->blue+(int) q->blue;            if (blue > Opaque)             blue-=(Opaque+1); .           index=(int) p->index+(int) q->index;           if (index > Opaque)              index-=(Opaque+1);           break;	         } !         case SubtractCompositeOp: 	         { (           red=(int) p->red-(int) q->red;           if (red < 0)             red+=(Opaque+1);.           green=(int) p->green-(int) q->green;           if (green < 0)             green+=(Opaque+1);+           blue=(int) p->blue-(int) q->blue;            if (blue < 0)              blue+=(Opaque+1); .           index=(int) p->index-(int) q->index;           if (index < 0)             index+=(Opaque+1);           break;	         } #         case DifferenceCompositeOp: 	         { 7           red=AbsoluteValue((int) p->red-(int) q->red); =           green=AbsoluteValue((int) p->green-(int) q->green); :           blue=AbsoluteValue((int) p->blue-(int) q->blue);=           index=AbsoluteValue((int) p->index-(int) q->index);            break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         } %         case MatteReplaceCompositeOp: 	         {            red=q->red;            green=q->green;            blue=q->blue;            index=p->index;            break;	         }          case BlendCompositeOp:	         { =           red=(int) (p->red*p->index+q->red*q->index)/Opaque; C           green=(int) (p->green*p->index+q->green*q->index)/Opaque; @           blue=(int) (p->blue*p->index+q->blue*q->index)/Opaque;           index=Opaque;            break;	         }        }        if (red > MaxRGB)          q->red=MaxRGB;
       else         if (red < 0)           q->red=0;          else           q->red=red;        if (green > MaxRGB)          q->green=MaxRGB;
       else         if (green < 0)           q->green=0;          else           q->green=green;        if (blue > MaxRGB)         q->blue=MaxRGB; 
       else         if (blue < 0)            q->blue=0;         else           q->blue=blue;        if (index > Opaque)          q->index=Opaque;
       else          if (index < Transparent)           q->index=Transparent;          else           q->index=index;        q->length=0;
       q++;     } @     ProgressMonitor(CompositeImageText,y,composite_image->rows);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o n t r a s t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ContrastImage enhances the intensity differences between the, %  lighter and darker elements of the image. % . %  The format of the ContrastImage routine is: % # %      ContrastImage(image,sharpen)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % C %    o sharpen: If True, the intensity is increased otherwise it is  %      decreased.  %  %  */  B static void HSVTransform(hue,saturation,brightness,red,green,blue) double   hue,
   saturation, 
   brightness;    Quantum    *red, 	   *green,    *blue; {    double     b,     g,     r;     /*"     Convert HSV to RGB colorspace.   */   r=brightness;    g=brightness;    b=brightness; +   if ((hue != -1.0) && (saturation != 0.0))      {        double
         f,
         j,
         k,
         l,
         v;  	       int 
         i;         if (hue == 360.0)          hue=0.0;       hue=hue/60.0;        i=floor(hue);        if (i < 0)         i=0;       f=hue-i;$       j=brightness*(1.0-saturation);(       k=brightness*(1.0-(saturation*f));.       l=brightness*(1.0-(saturation*(1.0-f)));       v=brightness;        switch (i)       { )         case 0:  r=v;  g=l;  b=j;  break; )         case 1:  r=k;  g=v;  b=j;  break; )         case 2:  r=j;  g=v;  b=l;  break; )         case 3:  r=j;  g=k;  b=v;  break; )         case 4:  r=l;  g=j;  b=v;  break; )         case 5:  r=v;  g=j;  b=k;  break;        }      } 0   *red=(Quantum) floor((r*(double) MaxRGB)+0.5);2   *green=(Quantum) floor((g*(double) MaxRGB)+0.5);1   *blue=(Quantum) floor((b*(double) MaxRGB)+0.5);  }   B static void TransformHSV(red,green,blue,hue,saturation,brightness) unsigned int   red,   green,   blue;    double   *hue,    *saturation,   *brightness; {    double     b,     minimum,     g,     r;     /*"     Convert RGB to HSV colorspace.   */   *hue=(-1.0);   *saturation=0.0;!   r=(double) red/(double) MaxRGB; #   g=(double) green/(double) MaxRGB; "   b=(double) blue/(double) MaxRGB;
   if (r >= g)      {        if (r >= b)          *brightness=r;
       else         *brightness=b;     }    else     if (g >= b)        *brightness=g;     else       *brightness=b;
   if (r <= g)      {        if (r <= b)          minimum=r;
       else         minimum=b;     }    else     if (g <= b)        minimum=g;     else       minimum=b;   if (*brightness != 0.0) 4     *saturation=(*brightness-minimum)/(*brightness);   if (*saturation != 0.0)      {        if (r == *brightness) )         *hue=(g-b)/(*brightness-minimum); 
       else         if (g == *brightness) /           *hue=2.0+(b-r)/(*brightness-minimum);          else           if (b == *brightness) 1             *hue=4.0+(r-g)/(*brightness-minimum);        *hue=(*hue)*60.0;        if (*hue < 0.0)          *hue+=360.0;     }  }   ) static void Contrast(sign,red,green,blue)  int    sign;    Quantum    *red, 	   *green,    *blue; {    double     brightness,      hue,     saturation, 
     theta;     /*K     Enhance contrast: dark color become darker, light color become lighter.    */?   TransformHSV(*red,*green,*blue,&hue,&saturation,&brightness);    theta=(brightness-0.5)*M_PI;?   brightness+=(((((sin(theta)+1.0))*0.5)-brightness)*sign)*0.5;    if (brightness > 1.0)      brightness=1.0;    else     if (brightness < 0)        brightness=0.0; 9   HSVTransform(hue,saturation,brightness,red,green,blue);  }   ! void ContrastImage(image,sharpen)  Image 	   *image;    unsigned int
   sharpen; { > #define DullContrastImageText  "  Dulling image contrast...  "D #define SharpenContrastImageText  "  Sharpening image contrast...  "     int 	     sign;      register int     i;     register RunlengthPacket     *p;      sign=sharpen ? 1 : -1;   switch (image->class)    {      case DirectClass:      {        /*+         Contrast enhance DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         Contrast(sign,&p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))            if (sharpen)G             ProgressMonitor(SharpenContrastImageText,i,image->packets);            elseD             ProgressMonitor(DullContrastImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*+         Contrast enhance PseudoClass image.        */'       for (i=0; i < image->colors; i++) H         Contrast(sign,&image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o p y I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function CopyImage returns a copy of all fields of the input image.  The B %  the pixel memory is allocated but the pixel data is not copied. % * %  The format of the CopyImage routine is: % ; %      copy_image=CopyImage(image,columns,rows,copy_pixels)  % + %  A description of each parameter follows:  % J %    o copy_image: Function CopyImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % H %    o copy_pixels: Specifies whether the pixel data is copied.  Must be %      either True or False; %  %  */0 Image *CopyImage(image,columns,rows,copy_pixels) Image 	   *image;    unsigned int
   columns,   rows,    copy_pixels; {    Image      *copy_image;     register int     i;     /*     Allocate image structure.    */-   copy_image=(Image *) malloc(sizeof(Image)); #   if (copy_image == (Image *) NULL)      return((Image *) NULL);    *copy_image=(*image); '   if (image->comments != (char *) NULL)      {        /*-         Allocate and copy the image comments.        */#       copy_image->comments=(char *) 9         malloc((unsigned int) strlen(image->comments)+1); 0       if (copy_image->comments == (char *) NULL)         return((Image *) NULL); :       (void) strcpy(copy_image->comments,image->comments);     } $   if (image->label != (char *) NULL)     {        /**         Allocate and copy the image label.       */O       copy_image->label=(char *) malloc((unsigned int) strlen(image->label)+1); -       if (copy_image->label == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->label,image->label);     }    copy_image->columns=columns;   copy_image->rows=rows;$   copy_image->montage=(char *) NULL;&   copy_image->directory=(char *) NULL;.   if (image->colormap != (ColorPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        */*       copy_image->colormap=(ColorPacket *)2         malloc(image->colors*sizeof(ColorPacket));7       if (copy_image->colormap == (ColorPacket *) NULL)          return((Image *) NULL); '       for (i=0; i < image->colors; i++) 3         copy_image->colormap[i]=image->colormap[i];      } (   if (image->signature != (char *) NULL)     {        /*.         Allocate and copy the image signature.       */$       copy_image->signature=(char *):         malloc((unsigned int) strlen(image->signature)+1);1       if (copy_image->signature == (char *) NULL)          return((Image *) NULL); <       (void) strcpy(copy_image->signature,image->signature);     }    /*     Allocate the image pixels.   */   if (copy_pixels)*     copy_image->pixels=(RunlengthPacket *)D       malloc((unsigned int) image->packets*sizeof(RunlengthPacket));   else     { ?       copy_image->packets=copy_image->columns*copy_image->rows; ,       copy_image->pixels=(RunlengthPacket *)K         malloc((unsigned int) copy_image->packets*sizeof(RunlengthPacket));      } 5   if (copy_image->pixels == (RunlengthPacket *) NULL)      return((Image *) NULL);    if (copy_pixels)     {        register RunlengthPacket         *p,          *q;          /*         Copy the image pixels.       */       p=image->pixels;       q=copy_image->pixels; (       for (i=0; i < image->packets; i++)       {          *q=(*p);         p++;         q++;       }      }    if (image->orphan)     { %       copy_image->file=(FILE *) NULL; *       copy_image->previous=(Image *) NULL;&       copy_image->next=(Image *) NULL;     }    else     {        /*#         Link image into image list.        */1       if (copy_image->previous != (Image *) NULL) .         copy_image->previous->next=copy_image;-       if (copy_image->next != (Image *) NULL) .         copy_image->next->previous=copy_image;     }    copy_image->orphan=False;    return(copy_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function CropImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure andM %  returns a pointer to the new image.  This routine is optimized to perserve K %  the runlength encoding.  That is, the cropped image will always use less  %  memory than the original. % * %  The format of the CropImage routine is: % / %      cropped_image=CropImage(image,crop_info)  % + %  A description of each parameter follows:  % I %    o cropped_image: Function CropImage returns a pointer to the cropped J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o crop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */! Image *CropImage(image,crop_info)  Image 	   *image;   
 RectangleInfo 
   *crop_info;  { . #define CropImageText  "  Cropping image...  "     Image      *cropped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check crop geometry.   */4   if (((crop_info->x+(int) crop_info->width) < 0) ||5       ((crop_info->y+(int) crop_info->height) < 0) || .       (crop_info->x > (int) image->columns) ||)       (crop_info->y > (int) image->rows))      { H       Warning("Unable to crop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((crop_info->x+(int) crop_info->width) > (int) image->columns) H     crop_info->width=(unsigned int) ((int) image->columns-crop_info->x);A   if ((crop_info->y+(int) crop_info->height) > (int) image->rows) F     crop_info->height=(unsigned int) ((int) image->rows-crop_info->y);   if (crop_info->x < 0)      { 7       crop_info->width-=(unsigned int) (-crop_info->x);        crop_info->x=0;      }    if (crop_info->y < 0)      { 8       crop_info->height-=(unsigned int) (-crop_info->y);       crop_info->y=0;      } :   if ((crop_info->width == 0) && (crop_info->height == 0))     {        register int
         i;         RunlengthPacket          corners[4];          /*1         Set bounding box to the image dimensions.        */       crop_info->width=0;        crop_info->height=0;"       crop_info->x=image->columns;       crop_info->y=image->rows;        p=image->pixels;#       image->runlength=p->length+1;        corners[0]=(*p);7       for (i=1; i <= (image->rows*image->columns); i++)        { "         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;            }           if (i == image->columns)           corners[1]=(*p);?         if (i == (image->rows*image->columns-image->columns+1))            corners[2]=(*p);.         if (i == (image->rows*image->columns))           corners[3]=(*p);       }        p=image->pixels;#       image->runlength=p->length+1; %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {                p++;)               image->runlength=p->length; 
             } +           if ((p->red != corners[0].red) || /               (p->green != corners[0].green) || +               (p->blue != corners[0].blue)) !             if (x < crop_info->x)                crop_info->x=x; +           if ((p->red != corners[1].red) || /               (p->green != corners[1].green) || +               (p->blue != corners[1].blue)) %             if (x > crop_info->width) !               crop_info->width=x; +           if ((p->red != corners[0].red) || /               (p->green != corners[0].green) || +               (p->blue != corners[0].blue)) !             if (y < crop_info->y)                crop_info->y=y; +           if ((p->red != corners[2].red) || /               (p->green != corners[2].green) || +               (p->blue != corners[2].blue)) &             if (y > crop_info->height)"               crop_info->height=y;	         }        } '       crop_info->width-=crop_info->x-1; (       crop_info->height-=crop_info->y-1;     } :   if ((crop_info->width == 0) || (crop_info->height == 0))     { E       Warning("Unable to crop image","geometry dimensions are zero");        return((Image *) NULL);      } .   if ((crop_info->width == image->columns) && C       (crop_info->height == image->rows) && (crop_info->x == 0) &&         (crop_info->y == 0))     return((Image *) NULL);    /*(     Initialize cropped image attributes.   */I   cropped_image=CopyImage(image,crop_info->width,crop_info->height,True); &   if (cropped_image == (Image *) NULL)     { A       Warning("Unable to crop image","Memory allocation failed");        return((Image *) NULL);      }    /*(     Skip pixels up to the cropped image.   */   p=image->pixels;   image->runlength=p->length+1; @   for (x=0; x < (crop_info->y*image->columns+crop_info->x); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract cropped image.   */   cropped_image->packets=0;    q=cropped_image->pixels;   q->red=0; 
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength; -   for (y=0; y < (cropped_image->rows-1); y++)    {      /*       Transfer scanline.     */.     for (x=0; x < cropped_image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { *           if (cropped_image->packets != 0)             q++;#           cropped_image->packets++;            *q=(*p);           q->length=0;	         }      }      /*       Skip to next scanline.     */?     for (x=0; x < (image->columns-cropped_image->columns); x++)         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } ;     ProgressMonitor(CropImageText,y,cropped_image->rows-1);    }    /*     Transfer last scanline.    */,   for (x=0; x < cropped_image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        } 7     if ((p->red == q->red) && (p->green == q->green) && 9         (p->blue == q->blue) && (p->index == q->index) && )         ((int) q->length < MaxRunlength))        q->length++;     else       { (         if (cropped_image->packets != 0)           q++;!         cropped_image->packets++;          *q=(*p);         q->length=0;       }    } <   cropped_image->pixels=(RunlengthPacket *) realloc((char *)J     cropped_image->pixels,cropped_image->packets*sizeof(RunlengthPacket));   return(cropped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DescribeImage describes an image by printing its attributes to
 %  stderr. % . %  The format of the DescribeImage routine is: % ( %      DescribeImage(image,file,verbose) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 4 %    o file: send the image attributes to this file. % M %    o verbose: an unsigned value other than zero prints detailed information  %      about the image.  %  %  */& void DescribeImage(image,file,verbose) Image 	   *image;    FILE   *file;   unsigned int
   verbose; {    Image      *p;      unsigned int
     count;     if (!verbose)      {        /*.         Display detailed info about the image.       */*       if (*image->magick_filename != '\0')@         if (strcmp(image->magick_filename,image->filename) != 0)=           (void) fprintf(file,"%s=>",image->magick_filename); 1        if ((image->previous == (Image *) NULL) && B            (image->next == (Image *) NULL) && (image->scene == 0))3         (void) fprintf(file,"%s ",image->filename); 
       elseD         (void) fprintf(file,"%s[%u] ",image->filename,image->scene);D       if ((image->magick_columns != 0) || (image->magick_rows != 0))8         if ((image->magick_columns != image->columns) ||0             (image->magick_rows != image->rows))>           (void) fprintf(file,"%ux%u=>",image->magick_columns,              image->magick_rows);?       (void) fprintf(file,"%ux%u ",image->columns,image->rows); &       if (image->class == DirectClass)	         { .           (void) fprintf(file,"DirectClass ");'           if (image->total_colors != 0) =             (void) fprintf(file,"%luc ",image->total_colors); 	         } 
       else1         if (image->total_colors <= image->colors) @           (void) fprintf(file,"PseudoClass %uc ",image->colors);         else           { L             (void) fprintf(file,"PseudoClass %lu=>%uc ",image->total_colors,               image->colors); M             (void) fprintf(file,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, L               image->normalized_mean_error,image->normalized_maximum_error);           }        if (image->filesize != 0) 5         (void) fprintf(file,"%ldb ",image->filesize); J       (void) fprintf(file,"%s %lds\n",image->magick,time((time_t *) NULL)-         image->magick_time+1);
       return;      }    /*)     Display verbose info about the image.    */5   (void) fprintf(file,"Image: %s\n",image->filename); "   if (image->class == DirectClass)2     (void) fprintf(file,"  class: DirectClass\n");   else2     (void) fprintf(file,"  class: PseudoClass\n");"   if (image->class == DirectClass)     { "       if (image->total_colors > 0)C         (void) fprintf(file,"  colors: %lu\n",image->total_colors);      }    else-     if (image->total_colors <= image->colors) :       (void) fprintf(file,"  colors: %u\n",image->colors);     elseD       (void) fprintf(file,"  colors: %lu=>%u\n",image->total_colors,         image->colors); "   if (image->class == PseudoClass)     {        ColorPacket          *p;          register int
         i;         register XColorList          *q;          /*         Display image colormap.        */       p=image->colormap;'       for (i=0; i < image->colors; i++)        { C         (void) fprintf(file,"    %d: (%3d,%3d,%3d)  #%02x%02x%02x", :           i,p->red,p->green,p->blue,(unsigned int) p->red,:           (unsigned int) p->green,(unsigned int) p->blue);8         for (q=ColorList; q->name != (char *) NULL; q++).           if ((DownScale(p->red) == q->red) &&2               (DownScale(p->green) == q->green) &&.               (DownScale(p->blue) == q->blue))0             (void) fprintf(file,"  %s",q->name);"         (void) fprintf(file,"\n");         p++;       }      } (   if (image->signature != (char *) NULL)>     (void) fprintf(file,"  signature: %s\n",image->signature);   if (image->matte) +     (void) fprintf(file,"  matte: True\n");    else,     (void) fprintf(file,"  matte: False\n");4   if (image->packets < (image->columns*image->rows))I     (void) fprintf(file,"  runlength packets: %u of %u\n",image->packets, "       image->columns*image->rows);H   (void) fprintf(file,"  geometry: %ux%u\n",image->columns,image->rows);4   (void) fprintf(file,"  depth: %u\n",image->depth);   if (image->filesize != 0) :     (void) fprintf(file,"  bytes: %ld\n",image->filesize);   if (image->interlace) 0     (void) fprintf(file,"  interlaced: True\n");   else1     (void) fprintf(file,"  interlaced: False\n"); 6   (void) fprintf(file,"  format: %s\n",image->magick);
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)B     (void) fprintf(file,"  scene: %u of %u\n",image->scene,count);   else     if (image->scene != 0)8       (void) fprintf(file,"  scene: %u\n",image->scene);&   if (image->montage != (char *) NULL):     (void) fprintf(file,"  montage: %s\n",image->montage);(   if (image->directory != (char *) NULL)A     (void) fprintf(file,"  directory:\n\n%s\n",image->directory); $   if (image->label != (char *) NULL)6     (void) fprintf(file,"  label: %s\n",image->label);'   if (image->comments != (char *) NULL) =     (void) fprintf(file,"  comments:\n%s\n",image->comments);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     D e s p e c k l e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function DespeckleImage creates a new image that is a copy of an existingI %  one with the speckle noise minified.  It uses the eight hull algorithm O %  described in Applied Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter L %  for Speckle Reduction", by Thomas R Crimmins.  Each pixel in the image isN %  replaced by one of its eight of its surrounding pixels using a polarity andM %  negative hull function.  DespeckleImage allocates the memory necessary for B %  the new Image structure and returns a pointer to the new image. % / %  The format of the DespeckleImage routine is:  % - %      despeckled_image=DespeckleImage(image)  % + %  A description of each parameter follows:  % O %    o despeckled_image: Function DespeckleImage returns a pointer to the image M %      after it is despeckled.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  = static void Hull(x_offset,y_offset,polarity,columns,rows,f,g)  int    x_offset,    y_offset,    polarity;    unsigned int
   columns,   rows;    Quantum    *f,    *g;  {    int      y;     register int     x;     register Quantum     *p,      *q,      *r,      *s;   	   Quantum      v;     p=f+(columns+2);   q=g+(columns+2);,   r=p+(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*p);          if (*r > v)            v++;
         *q=v;          p++;         q++;         r++;       }      else!       for (x=0; x < columns; x++)        {          v=(*p); !         if (v > (Quantum) (*r+1))            v--;
         *q=v;          p++;         q++;         r++;       }      p++;     q++;     r++;   }    p=f+(columns+2);   q=g+(columns+2);,   r=q+(y_offset*((int) columns+2)+x_offset);,   s=q-(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     s++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) > v) && (*r > v))            v++;
         *p=v;          p++;         q++;         r++;         s++;       }      else!       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) < v) && (*r < v))            v--;
         *p=v;          p++;         q++;         r++;         s++;       }      p++;     q++;     r++;     s++;   }  }    Image *DespeckleImage(image) Image 	   *image;  { 6 #define DespeckleImageText  "  Despeckling image...  "     Image      *despeckled_image;     int      x;  	   Quantum      *blue_channel,     *buffer,     *green_channel,      *matte_channel,      *red_channel;      register int     i,     j;     register RunlengthPacket     *p,      *q;      static int     X[4]= {0, 1, 1,-1},      Y[4]= {1, 0, 1, 1};      unsigned int     packets;     /*     Allocate despeckled image.   */E   despeckled_image=CopyImage(image,image->columns,image->rows,False); )   if (despeckled_image == (Image *) NULL)      { F       Warning("Unable to despeckle image","Memory allocation failed");       return((Image *) NULL);      } &   despeckled_image->class=DirectClass;   /*     Allocate image buffers.    */-   packets=(image->columns+2)*(image->rows+2); :   red_channel=(Quantum *) malloc(packets*sizeof(Quantum));<   green_channel=(Quantum *) malloc(packets*sizeof(Quantum));;   blue_channel=(Quantum *) malloc(packets*sizeof(Quantum)); <   matte_channel=(Quantum *) malloc(packets*sizeof(Quantum));5   buffer=(Quantum *) malloc(packets*sizeof(Quantum)); *   if ((red_channel == (Quantum *) NULL) ||,       (green_channel == (Quantum *) NULL) ||+       (blue_channel == (Quantum *) NULL) || ,       (matte_channel == (Quantum *) NULL) ||>       (buffer == (Quantum *) NULL) || !UncompressImage(image))     { F       Warning("Unable to despeckle image","Memory allocation failed");%       DestroyImage(despeckled_image);        return((Image *) NULL);      }    /*     Zero image buffers.    */   for (i=0; i < packets; i++)    {      red_channel[i]=0;      green_channel[i]=0;      blue_channel[i]=0;     matte_channel[i]=0;      buffer[i]=0;   }    /*0     Copy image pixels to color component buffers   */   x=image->columns+2;    p=image->pixels;!   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        red_channel[x]=p->red;        green_channel[x]=p->green;       blue_channel[x]=p->blue;        matte_channel[x]=p->index;
       x++;
       p++;     }      x++;   }    /*"     Reduce speckle in red channel.   */   for (i=0; i < 4; i++)    { -     ProgressMonitor(DespeckleImageText,i,12); D     Hull(X[i],Y[i],1,image->columns,image->rows,red_channel,buffer);F     Hull(-X[i],-Y[i],1,image->columns,image->rows,red_channel,buffer);G     Hull(-X[i],-Y[i],-1,image->columns,image->rows,red_channel,buffer); E     Hull(X[i],Y[i],-1,image->columns,image->rows,red_channel,buffer);    }    /*$     Reduce speckle in green channel.   */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+4,12); F     Hull(X[i],Y[i],1,image->columns,image->rows,green_channel,buffer);H     Hull(-X[i],-Y[i],1,image->columns,image->rows,green_channel,buffer);I     Hull(-X[i],-Y[i],-1,image->columns,image->rows,green_channel,buffer); G     Hull(X[i],Y[i],-1,image->columns,image->rows,green_channel,buffer);    }    /*#     Reduce speckle in blue channel.    */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+8,12); E     Hull(X[i],Y[i],1,image->columns,image->rows,blue_channel,buffer); G     Hull(-X[i],-Y[i],1,image->columns,image->rows,blue_channel,buffer); H     Hull(-X[i],-Y[i],-1,image->columns,image->rows,blue_channel,buffer);F     Hull(X[i],Y[i],-1,image->columns,image->rows,blue_channel,buffer);   }    /*5     Copy color component buffers to despeckled image.    */   x=image->columns+2;    q=despeckled_image->pixels; !   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        q->red=red_channel[x];        q->green=green_channel[x];       q->blue=blue_channel[x];        q->index=matte_channel[x];       q->length=0;
       q++;
       x++;     }      x++;   }    /*     Free memory.   */   free((char *) buffer);   free((char *) blue_channel);   free((char *) green_channel);    free((char *) red_channel);    return(despeckled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function DestroyImage deallocates memory associated with an image.  % - %  The format of the DestroyImage routine is:  %  %      DestroyImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImage(image) Image 	   *image;  {    if (image == (Image *) NULL)     return;    /*     Close image.   */   CloseImage(image);   /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL) #     free((char *) image->comments);    /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)      free((char *) image->label);   /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)"     free((char *) image->montage);(   if (image->directory != (char *) NULL)$     free((char *) image->directory);   /*"     Deallocate the image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)$     free((char *) image->signature);   /*      Deallocate the image pixels.   */0   if (image->pixels != (RunlengthPacket *) NULL)!     free((char *) image->pixels); 5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);   /*#     Deallocate the image structure.    */   free((char *) image);    image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DestroyImages deallocates memory associated with a linked list
 %  of images.  % . %  The format of the DestroyImages routine is: %  %      DestroyImages(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImages(image)  Image 	   *image;  {    Image      *next_image;     if (image == (Image *) NULL)     return;    /*)     Proceed to the top of the image list.    */+   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D r a w I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function DrawImage draws a primitive (line, rectangle, ellipse) on the 	 %  image.  % * %  The format of the DrawImage routine is: % % %      DrawImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % : %    o annotate_info: The address of a DrawInfo structure. %  %  */  7 static unsigned int InsidePrimitive(primitive_info,x,y) 
 PrimitiveInfo    *primitive_info;   int    x,   y; {    register unsigned int      inside;      register PrimitiveInfo     *p,      *q;      p=primitive_info; ,   while (p->primitive != UndefinedPrimitive)   {      q=p+p->coordinates-1;      switch (p->primitive)      { "       case FillRectanglePrimitive:       default:       { H         inside=(x >= p->x) && (y >= p->y) && (x <= q->x) && (y <= q->y);         p+=p->coordinates;         break;       }         case FillEllipsePrimitive:       { ;         inside=(((p->y-y)*(p->y-y))+((p->x-x)*(p->x-x))) <= @           (((p->y-q->y)*(p->y-q->y))+((p->x-q->x)*(p->x-q->x)));         p+=p->coordinates;         break;       }         case FillPolygonPrimitive:       {          int            crossing,            crossings;           crossings=0;'         if ((q->y >= y) != (p->y >= y))            {              crossing=q->x >= x; (             if (crossing != (p->x >= x))F               crossings+=(q->x-(q->y-y)*(p->x-q->x)/(p->y-q->y)) >= x;             else               if (crossing)                  crossings++;           }          for (p++; p <= q; p++)	         {            if ((p-1)->y >= y)
             { -               while ((p <= q) && (p->y >= y))                  p++;               if (p > q)                 break;%               crossing=(p-1)->x >= x; *               if (crossing != (p->x >= x))                 crossings+= O                   ((p-1)->x-((p-1)->y-y)*(p->x-(p-1)->x)/(p->y-(p-1)->y)) >= x;                else                 if (crossing)                    crossings++;               continue; 
             } '          while ((p <= q) && (p->y < y))             p++;           if (p > q)             break;            crossing=(p-1)->x >= x;%          if (crossing != (p->x >= x))             crossings+=J              ((p-1)->x-((p-1)->y-y)*(p->x-(p-1)->x)/(p->y-(p-1)->y)) >= x;
          else             if (crossing)              crossings++; 	         }           inside=crossings & 0x01;         break;       }      }      if (inside)        return(True);    }    return(False); }   # void DrawImage(image,annotate_info)  Image 	   *image;    AnnotateInfo   *annotate_info;  { 0 #define DrawImageText  "  Drawing on image...  "     char
     *stop;     int      y;     PrimitiveInfo      *primitive_info;     register char      *p;      register int     i,     j,     x;     register RunlengthPacket     *q;      unsigned int     indirection,     length,      number_coordinates,      primitive;     XColor     pen_color;  0   if (annotate_info->primitive == (char *) NULL)     return;    if (!UncompressImage(image))     return; 1   indirection=(*annotate_info->primitive == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         register char          *q;          /*         Read text from a file.       */:       file=(FILE *) fopen(annotate_info->primitive+1,"r");        if (file == (FILE *) NULL)	         { N           Warning("Unable to read primitive file",annotate_info->primitive+1);           return; 	         }        length=MaxTextLength; 7       annotate_info->primitive=(char *) malloc(length); !       q=annotate_info->primitive; 7       while (annotate_info->primitive != (char *) NULL)        {          c=fgetc(file);         if (c == EOF)            break;5         if ((q-annotate_info->primitive+1) >= length)            {              *q='\0';             length<<=1; I             annotate_info->text=realloc(annotate_info->primitive,length); :             if (annotate_info->primitive == (char *) NULL)               break;H             q=annotate_info->primitive+strlen(annotate_info->primitive);           }          *q++=(unsigned char) c;        }        (void) fclose(file);4       if (annotate_info->primitive == (char *) NULL)	         { E           Warning("Unable to draw image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*#     Allocate primitive info memory.    */   number_coordinates=2048;"   primitive_info=(PrimitiveInfo *)5     malloc(number_coordinates*sizeof(PrimitiveInfo)); /   if (primitive_info == (PrimitiveInfo *) NULL)      {        if (indirection)0         free((char *) annotate_info->primitive);A       Warning("Unable to draw image","Memory allocation failed"); 
       return;      }    /*#     Parse the primitive attributes.    */<   (void) XQueryColorDatabase(annotate_info->pen,&pen_color);   image->class=DirectClass;    primitive=UndefinedPrimitive;    p=annotate_info->primitive;    for (i=0; *p != '\0'; )    {      while (isspace(*p)) 
       p++;!     primitive=UndefinedPrimitive; &     if (strncmp("rectangle",p,4) == 0)'       primitive=FillRectanglePrimitive; #     if (strncmp("circle",p,4) == 0) %       primitive=FillEllipsePrimitive; $     if (strncmp("polygon",p,4) == 0)%       primitive=FillPolygonPrimitive; (     if (primitive == UndefinedPrimitive)       break;     while (isalpha(*p)) 
       p++;     j=i;     for (x=0; *p != '\0'; x++)     {        while (isspace(*p))          p++;       if (!isdigit(*p))          break;,       primitive_info[i].primitive=primitive;&       primitive_info[i].coordinates=0;,       primitive_info[i].x=strtol(p,&stop,0);
       p=stop; (       while (isspace(*p) || (*p == ','))         p++;       if (!isdigit(*p))          break;,       primitive_info[i].y=strtol(p,&stop,0);
       p=stop; 
       i++;&       if (i == (number_coordinates-1))	         { !           number_coordinates<<=1; *           primitive_info=(PrimitiveInfo *)M             realloc(primitive_info,number_coordinates*sizeof(PrimitiveInfo)); 7           if (primitive_info == (PrimitiveInfo *) NULL) 
             {                if (indirection)8                 free((char *) annotate_info->primitive);I               Warning("Unable to draw image","Memory allocation failed");                return; 
             } 	         }      } $     primitive_info[j].coordinates=x;   } 1   primitive_info[i].primitive=UndefinedPrimitive; &   if (primitive == UndefinedPrimitive)     { L       Warning("Unable to draw image","non-conforming primitive definition");$       free((char *) primitive_info);       if (indirection)0         free((char *) annotate_info->primitive);
       return;      }    /*$     Draw the primitive on the image.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { .       if (InsidePrimitive(primitive_info,x,y))	         { +           q->red=XDownScale(pen_color.red); /           q->green=XDownScale(pen_color.green); -           q->blue=XDownScale(pen_color.blue); 	         } 
       q++;     } 1     ProgressMonitor(DrawImageText,y,image->rows);    }     free((char *) primitive_info);   if (indirection),     free((char *) annotate_info->primitive); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E m b o s s I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function EmbossImage creates a new image that is a copy of an existing L %  one with the edge highlighted.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % N %  EmbossImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the EmbossImage routine is: % ( %      embossed_image=EmbossImage(image) % + %  A description of each parameter follows:  % J %    o embossed_image: Function EmbossImage returns a pointer to the imageK %      after it is embossed.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EmbossImage(image)  Image 	   *image;  { 1 #define EmbossImageText  "  Embossing image...  "  #define Emboss(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *embossed_image;  
   long int     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to emboss image","image size must exceed 3x3");        return((Image *) NULL);      }    /*)     Initialize embossed image attributes.    */C   embossed_image=CopyImage(image,image->columns,image->rows,False); '   if (embossed_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   embossed_image->class=DirectClass;   /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(embossed_image);        return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=embossed_image->pixels; $   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; )       Emboss(-1); Emboss(-2); Emboss( 0);        s=s1; )       Emboss(-2); Emboss( 0); Emboss( 2);        s=s2; )       Emboss( 0); Emboss( 2); Emboss( 1); !       total_red+=(MaxRGB+1) >> 1;        if (total_red < 0)         total_red=0;
       else         if (total_red > MaxRGB)            total_red=MaxRGB; #       total_green+=(MaxRGB+1) >> 1;        if (total_green < 0)         total_green=0;
       else!         if (total_green > MaxRGB)            total_green=MaxRGB; "       total_blue+=(MaxRGB+1) >> 1;       if (total_blue < 0)          total_blue=0; 
       else          if (total_blue > MaxRGB)           total_blue=MaxRGB;!       q->red=(Quantum) total_red; %       q->green=(Quantum) total_green; #       q->blue=(Quantum) total_blue;        q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;5     ProgressMonitor(EmbossImageText,y,image->rows-1);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*-     Convert image to Grayscale and normalize.    */$   embossed_image->class=DirectClass;%   (void) IsGrayImage(embossed_image); !   NormalizeImage(embossed_image);    return(embossed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E d g e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function EdgeImage creates a new image that is a copy of an existing M %  one with the edges highlighted.  It allocates the memory necessary for the > %  new Image structure and returns a pointer to the new image. % L %  EdgeImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1  0 -1 
 %     0  W  0 
 %    -1  0 -1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the EdgeImage routine is: % * %      edged_image=EdgeImage(image,factor) % + %  A description of each parameter follows:  % E %    o edged_image: Function EdgeImage returns a pointer to the image H %      after it is edged.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */ Image *EdgeImage(image,factor) Image 	   *image;    double	   factor;  {  #define Edge(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \ +   total_index+=(weight)*(int) (s->index); \    s++;5 #define EdgeImageText  "  Detecting image edges...  "      double     weight;      Image      *edged_image;   
   long int     total_blue,      total_green,     total_index,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to detect edges","image size must exceed 3x3");        return((Image *) NULL);      }    /*&     Initialize edged image attributes.   */@   edged_image=CopyImage(image,image->columns,image->rows,False);$   if (edged_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } !   edged_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");        DestroyImage(edged_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=edged_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */!   weight=((100.0-factor)/20)+1.5; %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_index=0;
       s=s1+1;        s=s0; 1       Edge(-weight/4); Edge( 0); Edge(-weight/4);        s=s1; '       Edge( 0); Edge(weight); Edge( 0);        s=s2; 1       Edge(-weight/4); Edge( 0); Edge(-weight/4);        if (total_red < 0)         q->red=0; 
       else         if (total_red > MaxRGB)            q->red=MaxRGB;         else%           q->red=(Quantum) total_red;        if (total_green < 0)         q->green=0; 
       else!         if (total_green > MaxRGB)            q->green=MaxRGB;         else)           q->green=(Quantum) total_green;        if (total_blue < 0)          q->blue=0;
       else          if (total_blue > MaxRGB)           q->blue=MaxRGB;          else'           q->blue=(Quantum) total_blue;        if (total_index < 0)         q->index=0; 
       else!         if (total_index > MaxRGB)            q->index=MaxRGB;         else0           q->index=(unsigned short) total_index;       q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;3     ProgressMonitor(EdgeImageText,y,image->rows-1);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*     Normalize image.   */   NormalizeImage(edged_image);   return(edged_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E n h a n c e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EnhanceImage creates a new image that is a copy of an existingN %  one with the noise minified.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % K %  EnhanceImage does a weighted average of pixels in a 5x5 cell around each L %  target pixel.  Only pixels in the 5x5 cell that are within a RGB distance. %  threshold of the target pixel are averaged. % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % - %  The format of the EnhanceImage routine is:  % ) %      enhanced_image=EnhanceImage(image)  % + %  A description of each parameter follows:  % K %    o enhanced_image: Function EnhanceImage returns a pointer to the image K %      after it is enhanced.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ Image *EnhanceImage(image) Image 	   *image;  {  #define Enhance(weight) \ $   distance=(int) s->red-(int) red; \'   distance_squared=squares[distance]; \ (   distance=(int) s->green-(int) green; \(   distance_squared+=squares[distance]; \&   distance=(int) s->blue-(int) blue; \(   distance_squared+=squares[distance]; \%   if (distance_squared < Threshold) \      { \ %       total_red+=(weight)*(s->red); \ )       total_green+=(weight)*(s->green); \ '       total_blue+=(weight)*(s->blue); \        total_weight+=(weight); \      } \    s++;2 #define EnhanceImageText  "  Enhancing image...  " #define Threshold  2500      double     distance_squared;      Image      *enhanced_image;     int 
     distance,      i;  	   Quantum 	     blue, 
     green,     red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int 
     *squares;      RunlengthPacket      *scanline;     unsigned int     x,     y;     unsigned long      total_blue,      total_green,     total_red,     total_weight;   0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to enhance image","image size must exceed 4x4");       return((Image *) NULL);      }    /*)     Initialize enhanced image attributes.    */C   enhanced_image=CopyImage(image,image->columns,image->rows,False); '   if (enhanced_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   enhanced_image->class=DirectClass;   /*6     Allocate scan line buffer for 5 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));J   squares=(unsigned int *) malloc((MaxRGB+MaxRGB+1)*sizeof(unsigned int));/   if ((scanline == (RunlengthPacket *) NULL) || )       (squares == (unsigned int *) NULL))      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(enhanced_image);        return((Image *) NULL);      }    squares+=MaxRGB;%   for (i=(-MaxRGB); i <= MaxRGB; i++)      squares[i]=i*i;    /*'     Read the first 4 rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; (   for (x=0; x < (image->columns*4); x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*$     Dump first 2 scanlines of image.   */   q=enhanced_image->pixels; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Enhance each row.    */%   for (y=2; y < (image->rows-2); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-2) % 5); +     s1=scanline+image->columns*((y-1) % 5); '     s2=scanline+image->columns*(y % 5); +     s3=scanline+image->columns*((y+1) % 5); +     s4=scanline+image->columns*((y+2) % 5);      /*       Read another scan line.      */	     s=s4; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*.       Transfer first 2 pixels of the scanline.     */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } *     for (x=2; x < (image->columns-2); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_weight=0; 
       s=s2+2;        red=s->red;        green=s->green;        blue=s->blue;        s=s0; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5);        s=s1; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s2; F       Enhance(10); Enhance(40); Enhance(80); Enhance(40); Enhance(10);       s=s3; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s4; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5); H       q->red=(Quantum) ((total_red+(total_weight >> 1)-1)/total_weight);M       q->green= (Quantum) ((total_green+(total_weight >> 1)-1)/total_weight); J       q->blue=(Quantum) ((total_blue+(total_weight >> 1)-1)/total_weight);       q->index=s2->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;        s3++;        s4++;      }      /*-       Transfer last 2 pixels of the scanline.      */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } 6     ProgressMonitor(EnhanceImageText,y,image->rows-2);   }    /*$     Dump last 2 scanlines of pixels.   */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    squares-=MaxRGB;   free((char *) squares);    free((char *) scanline);   return(enhanced_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E q u a l i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EqualizeImage performs histogram equalization on the reference	 %  image.  % . %  The format of the EqualizeImage routine is: %  %      EqualizeImage(image)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */ void EqualizeImage(image)  Image 	   *image;  { 4 #define EqualizeImageText  "  Equalizing image...  "  	   Quantum      *equalize_map;     register int     i,     j;     register RunlengthPacket     *p;      unsigned int	     high,      *histogram,      low,	     *map;      /*-     Allocate and initialize histogram arrays.    */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); ?   map=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); >   equalize_map=(Quantum *) malloc((MaxRGB+1)*sizeof(Quantum));O   if ((histogram == (unsigned int *) NULL) || (map == (unsigned int *) NULL) || )       (equalize_map == (Quantum *) NULL))      { E       Warning("Unable to equalize image","Memory allocation failed"); 
       return;      }    /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   { ,     histogram[Intensity(*p)]+=(p->length+1);     p++;   }    /*8     Integrate the histogram to get the equalization map.   */   j=0;   for (i=0; i <= MaxRGB; i++)    {      j+=histogram[i];
     map[i]=j;    }    free((char *) histogram);    if (map[MaxRGB] == 0)      { "       free((char *) equalize_map);       free((char *) map); 
       return;      }    /*
     Equalize.    */
   low=map[0];    high=map[MaxRGB];    for (i=0; i <= MaxRGB; i++)      equalize_map[i]=(Quantum) 9       ((((double) (map[i]-low))*MaxRGB)/Max(high-low,1));    free((char *) map);    /*     Stretch the histogram.   */   switch (image->class)    {      case DirectClass:      {        /*%         Equalize DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { $         p->red=equalize_map[p->red];(         p->green=equalize_map[p->green];&         p->blue=equalize_map[p->blue];         p++;!         if (QuantumTick(i,image)) >           ProgressMonitor(EqualizeImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*%         Equalize PseudoClass packets.        */'       for (i=0; i < image->colors; i++)        { D         image->colormap[i].red=equalize_map[image->colormap[i].red];H         image->colormap[i].green=equalize_map[image->colormap[i].green];F         image->colormap[i].blue=equalize_map[image->colormap[i].blue];       }        SyncImage(image);        break;     }    }    free((char *) equalize_map); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l i p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlipImage creates a new image that reflects each scanline in theI %  vertical direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlipImage routine is: % % %      flipped_image=FlipImage(image)  % + %  A description of each parameter follows:  % G %    o flipped_image: Function FlipImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlipImage(image)  Image 	   *image;  { . #define FlipImageText  "  Flipping image...  "     Image      *flipped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flipped image attributes.   */B   flipped_image=CopyImage(image,image->columns,image->rows,False);&   if (flipped_image == (Image *) NULL)     { A       Warning("Unable to flip image","Memory allocation failed");        return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flipped_image);       return((Image *) NULL);      }    /*     Flip each row.   */   p=image->pixels;   image->runlength=p->length+1; 3   q=flipped_image->pixels+flipped_image->packets-1; )   for (y=0; y < flipped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flip each column.      */     s=scanline+image->columns;.     for (x=0; x < flipped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q--;     } 9     ProgressMonitor(FlipImageText,y,flipped_image->rows);    }    free((char *) scanline);   return(flipped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l o p I m a g e                                                         %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlopImage creates a new image that reflects each scanline in theK %  horizontal direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlopImage routine is: % % %      flopped_image=FlopImage(image)  % + %  A description of each parameter follows:M % G %    o flopped_image: Function FlopImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %a */ Image *FlopImage(image)  Image 	   *image;  { . #define FlopImageText  "  Flopping image...  "     Image      *flopped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flopped image attributes.   */B   flopped_image=CopyImage(image,image->columns,image->rows,False);&   if (flopped_image == (Image *) NULL)     { D       Warning("Unable to reflect image","Memory allocation failed");       return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)C     { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flopped_image);       return((Image *) NULL);o     }i   /*     Flop each row.   */   p=image->pixels;   image->runlength=p->length+1;e   q=flopped_image->pixels;)   for (y=0; y < flopped_image->rows; y++)r   {n     /*       Read a scan line.a     */     s=scanline;p&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;e
       else	         {m           p++;%           image->runlength=p->length;r	         }p       *s=(*p);
       s++;     }b     /*       Flop each column.c     */     s=scanline+image->columns;.     for (x=0; x < flopped_image->columns; x++)     {s
       s--;       *q=(*s);       q->length=0;
       q++;     }o9     ProgressMonitor(FlopImageText,y,flopped_image->rows);p   }o   free((char *) scanline);   return(flopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             %eO %                                                                             %oO %   F r a m e I m a g e                                                       %wO %                                                                             %tO %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%E %  Function FrameImage takes an image and puts a frame around it of a I %  particular color.  It allocates the memory necessary for the new Image*4 %  structure and returns a pointer to the new image. %u+ %  The format of the FrameImage routine is:  %e0 %      framed_image=FrameImage(image,frame_info) % + %  A description of each parameter follows:o %*H %    o framed_image: Function FrameImage returns a pointer to the framedH %      image.  A null image is returned if there is a a memory shortage. %t7 %    o image: The address of a structure of type Image.n %iE %    o frame_info: Specifies a pointer to a FrameInfo structure whichl! %      defines the framed region.  %o %a */# Image *FrameImage(image,frame_info)  Imageu	   *image;   	 FrameInfof   *frame_info; {s6 #define FrameImageText  "  Adding frame to image...  "     Image      *framed_image;     int%     height,%
     width;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      highlight,
     matte,     shadow;      unsigned int     bevel_width;     /*     Check frame geometry.    */E   if ((frame_info->outer_bevel < 0) || (frame_info->inner_bevel < 0))      { A       Warning("Unable to frame image","bevel width is negative");        return((Image *) NULL);      } >   bevel_width=frame_info->outer_bevel+frame_info->inner_bevel;:   width=(int) frame_info->width-frame_info->x-bevel_width;<   height=(int) frame_info->height-frame_info->y-bevel_width;9   if ((width < image->columns) || (height < image->rows))%     {%G       Warning("Unable to frame image","frame is less than image size");a       return((Image *) NULL);c     }f   /*'     Initialize framed image attributes.t   */K   framed_image=CopyImage(image,frame_info->width,frame_info->height,False); %   if (framed_image == (Image *) NULL)f     { B       Warning("Unable to frame image","Memory allocation failed");       return((Image *) NULL);e     }l   image->class=DirectClass;l(   matte.red=frame_info->matte_color.red;,   matte.green=frame_info->matte_color.green;*   matte.blue=frame_info->matte_color.blue;   matte.index=Opaque;t   matte.length=0; 0   highlight.red=frame_info->highlight_color.red;4   highlight.green=frame_info->highlight_color.green;2   highlight.blue=frame_info->highlight_color.blue;   highlight.index=Opaque;g   highlight.length=0; *   shadow.red=frame_info->shadow_color.red;.   shadow.green=frame_info->shadow_color.green;,   shadow.blue=frame_info->shadow_color.blue;   shadow.index=Opaque;   shadow.length=0;   /*.     Put an ornamental border around the image.   */   q=framed_image->pixels;l-   for (y=0; y < frame_info->outer_bevel; y++)o   {_1     for (x=0; x < (framed_image->columns-y); x++)        *q++=highlight;e+     for ( ; x < framed_image->columns; x++)c       *q++=shadow;   } 1   for (y=0; y < (frame_info->y-bevel_width); y++)_   {-/     for (x=0; x < frame_info->outer_bevel; x++)i       *q++=highlight;gN     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte;n/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }=-   for (y=0; y < frame_info->inner_bevel; y++)l   {e/     for (x=0; x < frame_info->outer_bevel; x++)e       *q++=highlight;g3     for (x=0; x < (frame_info->x-bevel_width); x++)-       *q++=matte; I     for (x=0; x < (image->columns+(frame_info->inner_bevel << 1)-y); x++)*       *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)a       *q++=highlight;aE     width=frame_info->width-frame_info->x-image->columns-bevel_width;g     for (x=0; x < width; x++)g       *q++=matte;u/     for (x=0; x < frame_info->outer_bevel; x++)e       *q++=shadow;   }m   p=image->pixels;   image->runlength=p->length+1;l!   for (y=0; y < image->rows; y++)a   {(     /*,       Initialize scanline with border color.     *//     for (x=0; x < frame_info->outer_bevel; x++)t       *q++=highlight;_3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte;-/     for (x=0; x < frame_info->inner_bevel; x++)t       *q++=shadow;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;e
       else	         {            p++;%           image->runlength=p->length;_	         }i       *q=(*p);       q->length=0;
       q++;     } /     for (x=0; x < frame_info->inner_bevel; x++)        *q++=highlight;aE     width=frame_info->width-frame_info->x-image->columns-bevel_width;,     for (x=0; x < width; x++)v       *q++=matte;e/     for (x=0; x < frame_info->outer_bevel; x++)e       *q++=shadow;2     ProgressMonitor(FrameImageText,y,image->rows);   }%0   for (y=frame_info->inner_bevel-1; y >= 0; y--)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte;      for (x=0; x < y; x++)        *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } B   height=frame_info->height-frame_info->y-image->rows-bevel_width;   for (y=0; y < height; y++)   {%/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; N     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)s       *q++=shadow;   } 0   for (y=frame_info->outer_bevel-1; y >= 0; y--)   {h     for (x=0; x < y; x++)n       *q++=highlight;r+     for ( ; x < framed_image->columns; x++)        *q++=shadow;   }e   return(framed_image);  }d f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %     G a m m a I m a g e                                                     %hO %                                                                             %tO %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function GammaImage converts the reference image to gamma corrected colors. %y+ %  The format of the GammaImage routine is:  %  %      GammaImage(image,gamma) %a+ %  A description of each parameter follows:t %uF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %eJ %    o gamma: A character string indicating the level of gamma correction. %a %o */ void GammaImage(image,gamma) Imagel	   *image;v   char	   *gamma;n {n; #define GammaImageText  "  Gamma correcting the image...  "t  
   ColorPacketa     *gamma_map;(     double     blue_gamma,      green_gamma,     red_gamma;     int;
     count;     register int     i;     register RunlengthPacket     *p;d     red_gamma=1.0;   green_gamma=1.0;   blue_gamma=1.0;oH   count=sscanf(gamma,"%lf,%lf,%lf",&red_gamma,&green_gamma,&blue_gamma);   if (count == 1)a     {r       if (red_gamma == 1.0)>         return;        green_gamma=red_gamma;       blue_gamma=red_gamma;      }e   /*'     Allocate and initialize gamma maps.    */C   gamma_map=(ColorPacket *) malloc((MaxRGB+1)*sizeof(ColorPacket)); (   if (gamma_map == (ColorPacket *) NULL)     { B       Warning("Unable to gamma image","Memory allocation failed");
       return;      }    for (i=0; i <= MaxRGB; i++)<   {      gamma_map[i].red=0;-     gamma_map[i].green=0;-     gamma_map[i].blue=0;   }(   /*     Initialize gamma table.L   */   for (i=0; i <= MaxRGB; i++)    {o     if (red_gamma != 0.0)t        gamma_map[i].red=(Quantum)<         ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);     if (green_gamma != 0.0)-"       gamma_map[i].green=(Quantum)>         ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);     if (blue_gamma != 0.0)!       gamma_map[i].blue=(Quantum) =         ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);=   }a   switch (image->class)s   {(     case DirectClass:x     {g       /*(         Gamma-correct DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=gamma_map[p->red].red;>+         p->green=gamma_map[p->green].green; (         p->blue=gamma_map[p->blue].blue;         p++;!         if (QuantumTick(i,image)) ;           ProgressMonitor(GammaImageText,i,image->packets);        }-       break;     }e     case PseudoClass:      {r       /*(         Gamma-correct PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {nE         image->colormap[i].red=gamma_map[image->colormap[i].red].red; K         image->colormap[i].green=gamma_map[image->colormap[i].green].green;(H         image->colormap[i].blue=gamma_map[image->colormap[i].blue].blue;       }        SyncImage(image);e       break;     }    }e   if (image->gamma != 0.0)9     image->gamma*=(red_gamma+green_gamma+blue_gamma)/3.0;h   free((char *) gamma_map);  }p   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             % O %                                                                             % O %   G e t A n n o t a t e I n f o                                             % O %                                                                             %eO %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%q %(C %  Function GetAnnotateInfo initializes the AnnotateInfo structure.h %*0 %  The format of the GetAnnotateInfo routine is: %m% %      GetAnnotateInfo(annotate_info)  %e+ %  A description of each parameter follows:  %(F %    o annotate_info: Specifies a pointer to a AnnotateInfo structure. %L %( */# void GetAnnotateInfo(annotate_info)m AnnotateInfo   *annotate_info;e {i+   annotate_info->server_name=(char *) NULL;h$   annotate_info->font=(char *) NULL;,   annotate_info->pointsize=DefaultPointSize;#   annotate_info->box=(char *) NULL;g#   annotate_info->pen=(char *) NULL;o(   annotate_info->geometry=(char *) NULL;$   annotate_info->text=(char *) NULL;)   annotate_info->primitive=(char *) NULL;    annotate_info->center=False; }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             % O %                                                                             %aO %   G e t I m a g e I n f o                                                   % O %                                                                             %nO %                                                                             %aO %                                                                             %LO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function GetImageInfo initializes the ImageInfo structure.  % - %  The format of the GetImageInfo routine is:  %  %      GetImageInfo(image_info)s %G+ %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */ void GetImageInfo(image_info)e	 ImageInfo    *image_info; {o   *image_info->magick='\0'; 6   image_info->filename=(char *) malloc(MaxTextLength);,   if (image_info->filename == (char *) NULL)A     Error("Unable to get image info","Memory allocation failed");o   *image_info->filename='\0';t   image_info->assert=False;(   image_info->subimage=0;    image_info->subrange=0;r(   image_info->server_name=(char *) NULL;!   image_info->font=(char *) NULL;r!   image_info->size=(char *) NULL;o$   image_info->density=(char *) NULL;!   image_info->page=(char *) NULL;t$   image_info->texture=(char *) NULL;   image_info->adjoin=False;    image_info->dither=True;)   image_info->interlace=DefaultInterlace;    image_info->monochrome=False;a   image_info->quality=75;    image_info->verbose=False;   image_info->monochrome=False; '   image_info->undercolor=(char *) NULL;_ }o s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             % O %                                                                             % O %     I s G r a y I m a g e                                                   % O %                                                                             %,O %                                                                             %=O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % H %  Function IsGrayImage returns True if the image is grayscale otherwiseO %  False is returned.  If the image is DirectClass and grayscale, it is demotedr %  to PseudoClass. % , %  The format of the IsGrayImage routine is: %   %      status=IsGrayImage(image) %u+ %  A description of each parameter follows:F %RJ %    o status: Function IsGrayImage returns True if the image is grayscale# %      otherwise False is returned.) % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.n %; %  */ unsigned int IsGrayImage(image)n Imagea	   *image;  {e   register int     i;     unsigned int     grayscale;     /*$     Determine if image is grayscale.   */   grayscale=True;x   switch (image->class)e   {e     case DirectClass:g     {        register RunlengthPacket         *p;          if (image->matte)e         return(False);       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          if (!IsGray(*p))           {              grayscale=False;             break;           }          p++;       }        if (grayscale)	         {nH           QuantizeImage(image,1 << QuantumDepth,8,False,GRAYColorspace);           SyncImage(image);e	         }&       break;     }e     case PseudoClass:e     { '       for (i=0; i < image->colors; i++)i(         if (!IsGray(image->colormap[i]))           {              grayscale=False;             break;           }h       break;     }    }a   return(grayscale); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %'O %                                                                             % O %                                                                             %lO %   L a b e l I m a g e                                                       %lO %                                                                             %LO %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %wH %  Function LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number byF %  embedding special format characters.  Embed %f for filename, %m forD %  magick, %w for width, %h for height, or %s for scene number.  For %  example,i %e %     %f  %wx%h) %  %  produces an image label oft %I %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % + %  The format of the LabelImage routine is:( %t %      LabelImage(image,label) % + %  A description of each parameter follows:s %]7 %    o image: The address of a structure of type Image.  % L %    o label: The address of a character string containing the label format. %r %; */ void LabelImage(image,label) Imagep	   *image;o   char	   *label;  {    register chara     *p,>     *q;e     unsigned int     indirection,     length;   $   if (image->label != (char *) NULL)      free((char *) image->label);   image->label=(char *) NULL;    if (label == (char *) NULL)      return;    indirection=(*label == '@');   if (indirection)     {-
       FILE         *file;  	       int 
         c;         /*         Read label from a file.        */'       file=(FILE *) fopen(label+1,"r");=        if (file == (FILE *) NULL)	         { 7           Warning("Unable to read label file",label+1);            return;e	         })       length=MaxTextLength;o$       label=(char *) malloc(length);0       for (q=label; label != (char *) NULL; q++)       {i         c=fgetc(file);         if (c == EOF)c           break;"         if ((q-label+1) >= length)           {;             *q='\0';             length<<=1; :             label=(char *) realloc((char *) label,length);'             if (label == (char *) NULL)                break;"             q=label+strlen(label);           }-         *q=(unsigned char) c;t       }>       (void) fclose(file);!       if (label == (char *) NULL) 	         {xF           Warning("Unable to label image","Memory allocation failed");           return;r	         }        *q='\0';     }n   /*(     Allocate and initialize image label.   */
   p=label;%   length=strlen(label)+MaxTextLength;('   image->label=(char *) malloc(length); :   for (q=image->label; image->label != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;1     if ((q-image->label+MaxTextLength) >= length)f       {n         length<<=1; D         image->label=(char *) realloc((char *) image->label,length);*         if (image->label == (char *) NULL)           break;,         q=image->label+strlen(image->label);       }i     /*-       Process formatting characters in label.o     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {t         *q++='\n';         p++;         continue;t       }y     if (*p != '%')       {w         *q++=(*p);         continue;f       }+     p++;     switch (*p)o     {f       case 'f':_       {e         register char 
           *p;_  
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);c         break;       }        case 'h':o       {t2         (void) sprintf(q,"%u",image->magick_rows);,         q=image->label+strlen(image->label);         break;       }        case 'm':o       {-'         (void) strcpy(q,image->magick);i!         q+=strlen(image->magick);>         break;       }i       case 's':        { ,         (void) sprintf(q,"%u",image->scene);,         q=image->label+strlen(image->label);         break;       }e       case 'w':U       { 5         (void) sprintf(q,"%u",image->magick_columns); ,         q=image->label+strlen(image->label);         break;       }        default:       {          *q++='%';s         *q++=(*p);         break;       }'     }    } $   if (image->label == (char *) NULL)     { B       Warning("Unable to label image","Memory allocation failed");
       return;[     }>
   *q='\0';   if (indirection)     free((char *) label);g }X t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %eO %                                                                             %fO %   M a g n i f y I m a g e                                                   %oO %                                                                             %)O %                                                                             %eO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%M %rL %  Function MagnifyImage creates a new image that is a integral size greaterM %  than an existing one.  It allocates the memory necessary for the new Images4 %  structure and returns a pointer to the new image. % H %  MagnifyImage scans the reference image to create a magnified image byH %  bilinear interpolation.  The magnified image columns and rows become: %% %    number_columns << 1 %    number_rows << 1  % - %  The format of the MagnifyImage routine is:  % * %      magnified_image=MagnifyImage(image) % + %  A description of each parameter follows:  % L %    o magnified_image: Function MagnifyImage returns a pointer to the imageL %      after magnification.  A null image is returned if there is a a memory %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *MagnifyImage(image) Image 	   *image;  { 7 #define MagnifyImageText  "  Magnifying the image...  "%     Image%     *magnified_image;%     int%     y;     register int     x;     register RunlengthPacket     *p,e     *q,      *r;t     /**     Initialize magnified image attributes.   */N   magnified_image=CopyImage(image,image->columns << 1,image->rows << 1,False);(   if (magnified_image == (Image *) NULL)     {iA       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);s     } %   magnified_image->class=DirectClass;e   /*!     Initialize zoom image pixels.t   */   p=image->pixels;   image->runlength=p->length+1;    q=magnified_image->pixels;!   for (y=0; y < image->rows; y++)d   {e&     for (x=0; x < image->columns; x++)     {o        if (image->runlength != 0)         image->runlength--;B
       else	         {t           p++;%           image->runlength=p->length;m	         }r       *q=(*p);       q->length=0;
       q++;     }i     q+=image->columns;   }u   /*     Magnify each row.r   */!   for (y=0; y < image->rows; y++):   {dI     p=magnified_image->pixels+(image->rows-1-y)*magnified_image->columns+e       (image->columns-1); P     q=magnified_image->pixels+((image->rows-1-y) << 1)*magnified_image->columns+        ((image->columns-1) << 1);     *q=(*p);     *(q+1)=(*(p));&     for (x=1; x < image->columns; x++)     { 
       p--;       q-=2;n       *q=(*p);<       (q+1)->red=(((int) p->red)+((int) (p+1)->red)+1) >> 1;B       (q+1)->green=(((int) p->green)+((int) (p+1)->green)+1) >> 1;?       (q+1)->blue=(((int) p->blue)+((int) (p+1)->blue)+1) >> 1;aB       (q+1)->index=(((int) p->index)+((int) (p+1)->index)+1) >> 1;       (q+1)->length=0;     };   } %   for (y=0; y < (image->rows-1); y++)    { @     p=magnified_image->pixels+(y << 1)*magnified_image->columns;!     q=p+magnified_image->columns;)!     r=q+magnified_image->columns;b*     for (x=0; x < (image->columns-1); x++)     {e4       q->red=(((int) p->red)+((int) r->red)+1) >> 1;:       q->green=(((int) p->green)+((int) r->green)+1) >> 1;7       q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;g:       q->index=(((int) p->index)+((int) r->index)+1) >> 1;       q->length=0;C       (q+1)->red=(((int) p->red)+((int) (p+2)->red)+((int) r->red)+_#         ((int) (r+2)->red)+2) >> 2; K       (q+1)->green=(((int) p->green)+((int) (p+2)->green)+((int) r->green)+t%         ((int) (r+2)->green)+2) >> 2;oG       (q+1)->blue=(((int) p->blue)+((int) (p+2)->blue)+((int) r->blue)+ $         ((int) (r+2)->blue)+2) >> 2;K       (q+1)->index=(((int) p->index)+((int) (p+2)->index)+((int) r->index)+e%         ((int) (r+2)->index)+2) >> 2;        (q+1)->length=0;       q+=2;e       p+=2;=       r+=2;;     }g2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1; 8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;k8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;4     ProgressMonitor(MagnifyImageText,y,image->rows);   }.G   p=magnified_image->pixels+(2*image->rows-2)*magnified_image->columns;1G   q=magnified_image->pixels+(2*image->rows-1)*magnified_image->columns;a$   for (x=0; x < image->columns; x++)   {      *q++=(*p++);     *q++=(*p++);   }    return(magnified_image); }(   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %fO %                                                                             % O %                                                                             % O %   M i n i f y I m a g e                                                     % O %                                                                             % O %                                                                             %.O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %;M %  Function MinifyImage creates a new image that is a integral size less thannH %  an existing one.  It allocates the memory necessary for the new Image4 %  structure and returns a pointer to the new image. %mP %  MinifyImage scans the reference image to create a minified image by computingL %  the weighted average of a 4x4 cell centered at each reference pixel.  TheJ %  target pixel requires two columns and two rows of the reference pixels.8 %  Therefore the minified image columns and rows become: %  %    number_columns/2l %    number_rows/2 % G %  Weights assume that the importance of neighboring pixels is negatelyeF %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the MinifyImage routine is: % ( %      minified_image=MinifyImage(image) % + %  A description of each parameter follows:  % J %    o minified_image: Function MinifyImage returns a pointer to the imageG %      after reducing.  A null image is returned if there is a a memory = %      shortage or if the image size is less than IconSize*2.  % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *MinifyImage(image)  Image 	   *image;  {  #define Minify(weight) \!   total_red+=(weight)*(s->red); \%%   total_green+=(weight)*(s->green); \d#   total_blue+=(weight)*(s->blue); \d%   total_matte+=(weight)*(s->index); \.   s++;1 #define MinifyImageText  "  Minifying image...  "s     Imaged     *minified_image;     register RunlengthPacket     *p,h     *q,t     *s,e     *s0,     *s1,     *s2,     *s3;     register unsigned inte     x;     RunlengthPackete     *scanline;     unsigned int     y;     unsigned int	     blue,p
     green,     packets,     red;     unsigned longm     total_matte,     total_blue,      total_green,     total_red;     unsigned short
     index;  0   if ((image->columns < 4) || (image->rows < 4))     {rE       Warning("Unable to reduce image","image size must exceed 3x3");        return((Image *) NULL);e     }h   /*)     Initialize minified image attributes.o   */%   packets=Max(image->packets >> 2,1);t2   minified_image=CopyImage(image,packets,1,False);'   if (minified_image == (Image *) NULL)a     {eC       Warning("Unable to reduce image","Memory allocation failed");b       return((Image *) NULL);      }_$   minified_image->class=DirectClass;.   minified_image->columns=image->columns >> 1;(   minified_image->rows=image->rows >> 1;   minified_image->packets=0;   /*F     Allocate image buffer and scanline buffer for 4 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(4*(image->columns+1)*sizeof(RunlengthPacket));r+   if (scanline == (RunlengthPacket *) NULL)e     {>C       Warning("Unable to reduce image","Memory allocation failed"); #       DestroyImage(minified_image);g       return((Image *) NULL);      }    /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; ,   for (x=0; x < (4*(image->columns+1)); x++)     scanline[x]=(*p);e
   s=scanline;d+   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;d     else       {          p++;#         image->runlength=p->length;x       }o     *s=(*p);     s++;   }    /*     Reduce each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=minified_image->pixels;    q->red=0;n
   q->green=0;n   q->blue=0;
   q->index=0;    q->length=MaxRunlength;f&   for (y=0; y < (image->rows-1); y+=2)   {      /*)       Initialize sliding window pointers.m     */+     s0=scanline+image->columns*((y+0) % 4);h+     s1=scanline+image->columns*((y+1) % 4);l+     s2=scanline+image->columns*((y+2) % 4);g+     s3=scanline+image->columns*((y+3) % 4);q     /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {l        if (image->runlength != 0)         image->runlength--;+
       else	         {s           p++;%           image->runlength=p->length;y	         }i       *s=(*p);
       s++;     }>     /*       Read another scan line.      */	     s=s3;>&     for (x=0; x < image->columns; x++)     {r        if (image->runlength != 0)         image->runlength--;%
       else	         {%           p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     } +     for (x=0; x < (image->columns-1); x+=2)      {        /*B         Compute weighted average of target pixel color components.  I         These particular coefficients total to 128.  Use 128/2-1 or 63 to !         insure correct round off.        */       total_red=0;       total_green=0;       total_blue=0;        total_matte=0;       s=s0; 3       Minify(3); Minify(7);  Minify(7);  Minify(3);        s=s1; 3       Minify(7); Minify(15); Minify(15); Minify(7);        s=s2; 3       Minify(7); Minify(15); Minify(15); Minify(7);%       s=s3;%3       Minify(3); Minify(7);  Minify(7);  Minify(3);        s0+=2;       s1+=2;       s2+=2;       s3+=2;*       red=(Quantum) ((total_red+63) >> 7);.       green=(Quantum) ((total_green+63) >> 7);,       blue=(Quantum) ((total_blue+63) >> 7);5       index=(unsigned short) ((total_matte+63) >> 7);iH       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         {e+           if (minified_image->packets != 0)r             q++;$           minified_image->packets++;1           if (minified_image->packets == packets)f
             {o               packets<<=1;I               minified_image->pixels=(RunlengthPacket *) realloc((char *)iH                 minified_image->pixels,packets*sizeof(RunlengthPacket));E               if (minified_image->pixels == (RunlengthPacket *) NULL)p                 {iO                   Warning("Unable to reduce image","Memory allocation failed");n/                   DestroyImage(minified_image);g)                   return((Image *) NULL);c                 }0A               q=minified_image->pixels+minified_image->packets-1; 
             }            q->red=red;|           q->green=green;t           q->blue=blue;            q->index=index;o           q->length=0;	         }      };5     ProgressMonitor(MinifyImageText,y,image->rows-1);n   }+=   minified_image->pixels=(RunlengthPacket *) realloc((char *)-L     minified_image->pixels,minified_image->packets*sizeof(RunlengthPacket));   free((char *) scanline);   return(minified_image);h }i - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %xO %                                                                             %dO %     M o d u l a t e I m a g e                                               % O %                                                                             %oO %                                                                             %gO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/ % M %  Function ModulateImage modulates the hue, saturation, and brightness of an 	 %  image.  % . %  The format of the ModulateImage routine is: %s$ %      ModulateImage(image,modulate) %h+ %  A description of each parameter follows:l % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.x %cI %    o modulate: A character string indicating the percent change in hue, " %      saturation, and brightness. %  %  */  K static void Modulate(percent_hue,percent_saturation,percent_brightness,red, 
   green,blue)c double   percent_hue,   percent_saturation,(   percent_brightness;    Quantum-   *red,h	   *green,l   *blue; {    double     brightness,-     hue,     saturation;      /*>     Increase or decrease color brightness, saturation, or hue.   */?   TransformHSV(*red,*green,*blue,&hue,&saturation,&brightness); '   brightness+=percent_brightness/100.0;    if (brightness < 0.0)!     brightness=0.0;r   else     if (brightness > 1.0)        brightness=1.0; '   saturation+=percent_saturation/100.0;    if (saturation < 0.0)n     saturation=0.0;_   else     if (saturation > 1.0)        saturation=1.0;;   if (hue != -1.0)     { #       hue+=360.0*percent_hue/100.0;        if (hue < 0.0)         hue+=360.0; 
       else         if (hue > 360.0)           hue-=360.0;%     }%9   HSVTransform(hue,saturation,brightness,red,green,blue);  }   " void ModulateImage(image,modulate) Image 	   *image;    char   *modulate; { 4 #define ModulateImageText  "  Modulating image...  "     double     percent_brightness,      percent_hue,     percent_saturation;      register int     i;     register RunlengthPacket     *p;      /*     Initialize gamma table.    */   percent_hue=0.0;   percent_brightness=0.0;    percent_saturation=0.0; O   (void) sscanf(modulate,"%lf,%lf,%lf",&percent_brightness,&percent_saturation,      &percent_hue);   switch (image->class)    {      case DirectClass:      {%       /*3         Modulate the color for a DirectClass image.%       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { C         Modulate(percent_hue,percent_saturation,percent_brightness,l&           &p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image)) >           ProgressMonitor(ModulateImageText,i,image->packets);       }s       break;     }y     case PseudoClass:      {o       /*3         Modulate the color for a PseudoClass image.i       */'       for (i=0; i < image->colors; i++)uC         Modulate(percent_hue,percent_saturation,percent_brightness,a<           &image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);a       break;     }    }  }i f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             %%O %                                                                             % O %     M o g r i f y I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function MogrifyImage applies image processing options to an image as& %  prescribed by command line options. % - %  The format of the MogrifyImage routine is:% %%/ %      MogrifyImage(image_info,argc,argv,image)  % + %  A description of each parameter follows:o %n@ %    o image_info: Specifies a pointer to a ImageInfo structure. %wG %    o argc: Specifies a pointer to an integer describing the number of ' %      elements in the argument vector.k %wL %    o argv: Specifies a pointer to a text array containing the command line %      arguments.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.m %  %l */- void MogrifyImage(image_info,argc,argv,image)8	 ImageInfoT   *image_info;   intt   argc;t   char	   **argv;    Imagem
   **image; {n   AnnotateInfo     annotate_info;  
   ColorPacket      border_color,      matte_color;     char     *option;     int 
     flags,     x,     y;     register int     i;     unsigned int     colorspace,      number_colors,     tree_depth;m     XColor
     color;     if (*image == (Image *) NULL)i     return;    /*!     Initialize routine variables.n   */"   GetAnnotateInfo(&annotate_info);1   (void) XQueryColorDatabase(BorderColor,&color);-)   border_color.red=XDownScale(color.red);L-   border_color.green=XDownScale(color.green);n+   border_color.blue=XDownScale(color.blue);(   border_color.index=0; 0   (void) XQueryColorDatabase(MatteColor,&color);(   matte_color.red=XDownScale(color.red);,   matte_color.green=XDownScale(color.green);*   matte_color.blue=XDownScale(color.blue);   number_colors=0;   tree_depth=0;a   colorspace=RGBColorspace;m   if (image_info->monochrome) 8     if (!IsGrayImage(*image) || ((*image)->colors != 2))       {a         number_colors=2;         tree_depth=8;="         colorspace=GRAYColorspace;       }t   /*     Transmogrify the image.    */   for (i=1; i < argc; i++)   {+     option=argv[i]; N     if (((int) strlen(option) <= 1) || ((*option != '-') && (*option != '+')))       continue;a,     if (strncmp("annotate",option+1,2) == 0)       {a%         annotate_info.text=argv[++i]; -         AnnotateImage(*image,&annotate_info);          continue;n       }c'     if (strncmp("-blur",option,3) == 0)        {(         double           factor;   
         Imagen           *blurred_image;g  
         /*           Blur an image.
         */         factor=atof(argv[++i]); /         blurred_image=BlurImage(*image,factor);n,         if (blurred_image != (Image *) NULL)           {x!             DestroyImage(*image);)!             *image=blurred_image;o           }-         continue;*       }+&     if (strcmp("-border",option) == 0)       { 
         Imagef           *bordered_image;           RectangleInfo            border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0; E         flags=XParseGeometry(argv[++i],&border_info.x,&border_info.y, 2           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0)'/           border_info.height=border_info.width; F         bordered_image=BorderImage(*image,&border_info,&border_color);-         if (bordered_image != (Image *) NULL)            { !             DestroyImage(*image); .             bordered_image->class=DirectClass;"             *image=bordered_image;           }e         continue;        } .     if (strncmp("-bordercolor",option,8) == 0)       {h         XColor           target_color;'  
         /*3           Determine RGB values of the border color.e
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);6         border_color.red=XDownScale(target_color.red);:         border_color.green=XDownScale(target_color.green);8         border_color.blue=XDownScale(target_color.blue);         continue;        }e&     if (strncmp("-box",option,3) == 0)       { $         annotate_info.box=argv[++i];         continue;g       };*     if (strncmp("colors",option+1,7) == 0)       { &         number_colors=atoi(argv[++i]);         continue;        }s-     if (strncmp("-colorspace",option,8) == 0)        {c         i++;         option=argv[i]; .         if (Latin1Compare("gray",option) == 0)           {'&             colorspace=GRAYColorspace;#             if (number_colors == 0)c                number_colors=256;             tree_depth=8;c           },.         if (Latin1Compare("ohta",option) == 0)$           colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)%#           colorspace=RGBColorspace;%-         if (Latin1Compare("xyz",option) == 0) #           colorspace=XYZColorspace; /         if (Latin1Compare("ycbcr",option) == 0) %           colorspace=YCbCrColorspace; -         if (Latin1Compare("yiq",option) == 0) #           colorspace=YIQColorspace; /         if (Latin1Compare("ypbpr",option) == 0) %           colorspace=YPbPrColorspace; -         if (Latin1Compare("yuv",option) == 0) #           colorspace=YUVColorspace;          continue;        } +     if (strncmp("comment",option+1,4) == 0)        {          if (*option == '-') )           CommentImage(*image,argv[++i]);          else-           CommentImage(*image,(char *) NULL);%         continue;%       }%,     if (strncmp("compress",option+1,3) == 0)       {e,         (*image)->compression=NoCompression;         if (*option == '-')C           {a             i++;?             if (Latin1Compare("runlengthencoded",argv[i]) == 0)r@               (*image)->compression=RunlengthEncodedCompression;             else5               if (Latin1Compare("zlib",argv[i]) == 0) 6                 (*image)->compression=ZlibCompression;           }          continue;        }e,     if (strncmp("contrast",option+1,3) == 0)       { >         ContrastImage(*image,(unsigned int) (*option == '-'));         continue;f       }c+     if ((strncmp("-crop",option,3) == 0) ||c)         (strncmp("-clip",option,4) == 0))-       {i6         TransformImage(image,argv[++i],(char *) NULL);         continue;p       } ,     if (strncmp("-despeckle",option,4) == 0)       {e
         Imagen           *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL)n           { !             DestroyImage(*image); $             *image=despeckled_image;           }(         continue;o       }c*     if (strncmp("-display",option,4) == 0)       {r,         annotate_info.server_name=argv[++i];         continue;m       }r(     if (strncmp("draw",option+1,2) == 0)       {c*         annotate_info.primitive=argv[++i];)         DrawImage(*image,&annotate_info);l         continue;        } '     if (strncmp("-edge",option,3) == 0)        {o         double           factor;r  
         Imageo           *edged_image;c  
         /*$           Detect edges in the image.
         */         factor=atof(argv[++i]);e-         edged_image=EdgeImage(*image,factor);i*         if (edged_image != (Image *) NULL)           {o!             DestroyImage(*image);              *image=edged_image;r           }g         continue;p       } )     if (strncmp("-emboss",option,3) == 0)%       {%
         Image%           *embossed_image;  
         /*           Emboss image. 
         */+         embossed_image=EmbossImage(*image); -         if (embossed_image != (Image *) NULL)            { !             DestroyImage(*image); "             *image=embossed_image;           }          continue;        } *     if (strncmp("-enhance",option,3) == 0)       { 
         Image            *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)            { !             DestroyImage(*image);%"             *image=enhanced_image;           }%         continue;%       } +     if (strncmp("-equalize",option,3) == 0)        {n         EqualizeImage(*image);         continue;        }r'     if (strncmp("-flip",option,4) == 0)        {m
         Imagee           *flipped_image;   
         /*           Flip image scanlines. 
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           {r!             DestroyImage(*image);h!             *image=flipped_image;            }i         continue;(       }('     if (strncmp("-flop",option,4) == 0)p       { 
         Imageh           *flopped_image;c  
         /*           Flop image scanlines.n
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           {n!             DestroyImage(*image);g!             *image=flopped_image;            }          continue;e       }e'     if (strncmp("-font",option,3) == 0)q       { %         annotate_info.font=argv[++i];p         continue;&       }e%     if (strcmp("-frame",option) == 0)>       {M
         Image            *framed_image;           FrameInfo            frame_info;e  
         /*3           Surround image with an ornamental border. 
         */         frame_info.width=0;          frame_info.height=0;?         flags=XParseGeometry(argv[++i],&frame_info.outer_bevel,gH           &frame_info.inner_bevel,&frame_info.width,&frame_info.height);'         if ((flags & HeightValue) == 0)h-           frame_info.height=frame_info.width;q"         if ((flags & XValue) == 0);           frame_info.outer_bevel=(frame_info.width >> 2)+1;l"         if ((flags & YValue) == 0)8           frame_info.inner_bevel=frame_info.outer_bevel;&         frame_info.x=frame_info.width;'         frame_info.y=frame_info.height;nC         frame_info.width=(*image)->columns+(frame_info.width << 1); B         frame_info.height=(*image)->rows+(frame_info.height << 1);+         frame_info.matte_color=matte_color;aJ         frame_info.highlight_color.red=(matte_color.red*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;N         frame_info.highlight_color.green=(matte_color.green*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;L         frame_info.highlight_color.blue=(matte_color.blue*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;$         frame_info.shadow_color.red=A           (unsigned int) (matte_color.red*ShadowModulate)/MaxRGB; &         frame_info.shadow_color.green=C           (unsigned int) (matte_color.green*ShadowModulate)/MaxRGB; %         frame_info.shadow_color.blue= B           (unsigned int) (matte_color.blue*ShadowModulate)/MaxRGB;4         framed_image=FrameImage(*image,&frame_info);+         if (framed_image != (Image *) NULL)            { !             DestroyImage(*image); ,             framed_image->class=DirectClass;              *image=framed_image;           }          continue;        } (     if (strncmp("-gamma",option,3) == 0)       { %         GammaImage(*image,argv[++i]);%         continue;%       }%+     if (strncmp("-geometry",option,4) == 0)o       {t6         TransformImage(image,(char *) NULL,argv[++i]);'         annotate_info.geometry=argv[i];T         continue;m       }g-     if (strncmp("interlace",option+1,3) == 0),       {o,         image_info->interlace=NoneInterlace;         if (*option == '-')l           {              option=argv[++i];r2             if (Latin1Compare("none",option) == 0)2               image_info->interlace=NoneInterlace;2             if (Latin1Compare("line",option) == 0)2               image_info->interlace=LineInterlace;3             if (Latin1Compare("plane",option) == 0) 3               image_info->interlace=PlaneInterlace;e           }o         continue;e       } )     if (strncmp("label",option+1,2) == 0)p       {g         if (*option == '-') '           LabelImage(*image,argv[++i]);          else+           LabelImage(*image,(char *) NULL);s         continue;o       }a&     if (strcmp("matte",option+1) == 0)       { )         (*image)->matte=(*option == '-');i         continue;e       },-     if (strncmp("-mattecolor",option,7) == 0)        {          XColor           target_color;   
         /*3           Determine RGB values of the border color.s
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);5         matte_color.red=XDownScale(target_color.red);(9         matte_color.green=XDownScale(target_color.green);e7         matte_color.blue=XDownScale(target_color.blue);o         continue;        }m+     if (strncmp("-modulate",option,4) == 0)s       {a(         ModulateImage(*image,argv[++i]);         continue;r       }i)     if (strncmp("-negate",option,4) == 0)m       {s         NegateImage(*image);         continue;a       }e(     if (strncmp("-noise",option,4) == 0)       { 
         Image            *noisy_image;m  
         /*            Reduce noise in image.
         */'         noisy_image=NoisyImage(*image);_*         if (noisy_image != (Image *) NULL)           {p!             DestroyImage(*image);              *image=noisy_image;,           }g         continue;        } ,     if (strncmp("-normalize",option,4) == 0)       {f         NormalizeImage(*image);e         continue;        } )     if (strncmp("-opaque",option,3) == 0)        { 8         OpaqueImage(*image,argv[++i],annotate_info.pen);         continue;        } (     if (strncmp("-paint",option,4) == 0)       {s
         Image            *painted_image;m  
         /*           Oil paint image.
         */,         painted_image=OilPaintImage(*image);,         if (painted_image != (Image *) NULL)           {g!             DestroyImage(*image); !             *image=painted_image;            }e         continue;i       }m&     if (strncmp("-pen",option,3) == 0)       {i$         annotate_info.pen=argv[++i];         continue;m       }s,     if (strncmp("-pointsize",option,3) == 0)       { 0         annotate_info.pointsize=atoi(argv[++i]);         continue;t       }p)     if (strncmp("raise",option+1,2) == 0)r       {eC         RaiseImage(*image,*option == '-' ? 1 : -1,atoi(argv[++i]));g         continue;        } '     if (strncmp("-roll",option,4) == 0)        {>
         Image(           *rolled_image;           unsigned int           height,s           width;  
         /*           Roll image.p
         */         x=0;         y=0;=         flags=XParseGeometry(argv[++i],&x,&y,&width,&height); +         rolled_image=RollImage(*image,x,y);s+         if (rolled_image != (Image *) NULL)g           {1!             DestroyImage(*image);-              *image=rolled_image;           }|         continue;i       }s)     if (strncmp("-rotate",option,4) == 0)y       {)         double           degrees;  
         Imaget           *rotated_image;   
         /*           Rotate image.h
         */          degrees=atof(argv[++i]);K         rotated_image=RotateImage(*image,degrees,&border_color,False,True);h,         if (rotated_image != (Image *) NULL)           {(!             DestroyImage(*image); !             *image=rotated_image;            }          continue;t       }s)     if (strncmp("-sample",option,3) == 0)        { 
         Image            *sampled_image;x           unsigned int           height,            width;  
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;5         ParseImageGeometry(argv[++i],&width,&height); 7         sampled_image=SampleImage(*image,width,height); ,         if (sampled_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=sampled_image;=           }*         continue;u       }x)     if (strncmp("scene",option+1,3) == 0)>       {q(         (*image)->scene=atoi(argv[++i]);         continue;(       }b+     if (strncmp("segment",option+1,3) == 0)        { N         SegmentImage(*image,colorspace,image_info->verbose,SmoothingThreshold,           atof(argv[++i]));          SyncImage(*image);         continue;        } *     if (strncmp("-sharpen",option,4) == 0)       {          double           factor;q  
         Imagel           *sharpened_image;p  
         /*           Sharpen an image.i
         */         factor=atof(argv[++i]); 4         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           {i!             DestroyImage(*image);a#             *image=sharpened_image;O           }x         continue;        }i(     if (strncmp("-shear",option,4) == 0)       { 
         float            x_shear,           y_shear;  
         Image            *sheared_image;q  
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;;         (void) sscanf(argv[++i],"%fx%f",&x_shear,&y_shear);l9         sheared_image=ShearImage(*image,(double) x_shear,n0           (double) y_shear,&border_color,False);,         if (sheared_image != (Image *) NULL)           { !             DestroyImage(*image);>-             sheared_image->class=DirectClass;/!             *image=sheared_image;>           }-         continue;(       }>)     if (strncmp("-spread",option,3) == 0)l       {(         unsigned int           amount;-  
         Image            *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]);q0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)i           {n!             DestroyImage(*image);-              *image=spread_image;           }>         continue;        } /     if (strncmp("-transparency",option,4) == 0)        { +         TransparentImage(*image,argv[++i]);          continue;e       }-,     if (strncmp("-treedepth",option,4) == 0)       {)#         tree_depth=atoi(argv[++i]);l         continue;        }    }=   if (number_colors != 0)      {        /*1         Reduce the number of colors in the image.i       */-       if (((*image)->class == DirectClass) || O           ((*image)->colors > number_colors) || (colorspace == GRAYColorspace)) I         QuantizeImage(*image,number_colors,tree_depth,image_info->dither,n           colorspace);       /*#         Measure quantization error.l       */       if (image_info->verbose)"         QuantizationError(*image);       SyncImage(*image);     }n>   if ((*image)->packets == ((*image)->columns*(*image)->rows))     CompressImage(*image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             % O %     N e g a t e I m a g e                                                   %xO %                                                                             % O %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%q %lB %  Function NegateImage negates the colors in the reference image. % , %  The format of the NegateImage routine is: %o %      NegateImage(image)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.M %e %l */ void NegateImage(image)  Image 	   *image;d { ; #define NegateImageText  "  Negating the image colors...  "      register int     i;     register RunlengthPacket     *p;e     switch (image->class)    {      case DirectClass:-     {q       /*#         Negate DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {x         p->red=(~p->red);          p->green=(~p->green);          p->blue=(~p->blue);          p++;!         if (QuantumTick(i,image))G<           ProgressMonitor(NegateImageText,i,image->packets);       }e       break;     }d     case PseudoClass:a     {        /*#         Negate PseudoClass packets.f       */'       for (i=0; i < image->colors; i++)        { 9         image->colormap[i].red=(~image->colormap[i].red);==         image->colormap[i].green=(~image->colormap[i].green);=;         image->colormap[i].blue=(~image->colormap[i].blue);        }        SyncImage(image);        break;     }f   }e }  n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %cO %                                                                             %%O %     N o i s y I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function NoisyImage creates a new image that is a copy of an existingH %  one with the noise minified with a noise peak elimination filter.  ItK %  allocates the memory necessary for the new Image structure and returns at %  pointer to the new image. %eK %  The principal function of noise peak elimination filter is to smooth thefF %  objects within an image without losing edge information and withoutJ %  creating undesired structures.  The central idea of the algorithm is toI %  replace a pixel with its next neighbor in value within a 3 x 3 window,eI %  if this pixel has been found to be noise.  A pixel is defined as noise E %  if and only if this pixel is a maximum or minimum within the 3 x 3t
 %  window. %r+ %  The format of the NoisyImage routine is:  % $ %      noisy_image=NoisyImage(image) %e+ %  A description of each parameter follows:  % L %    o noisy_image: Function NoisyImage returns a pointer to the image afterL %      the noise is minified.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %( %  */ static int NoisyCompare(x,y)
 const void   *x,    *y;l {(
   ColorPacketf
     *color_1, 
     *color_2;=     color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }f   Image *NoisyImage(image) Imagew	   *image;  { 9 #define NoisyImageText  "  Reducing the image noise...  "e     Imageg     *noisy_image;      inta     i;     register RunlengthPacket     *p,3     *q,g     *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket 
     pixel,     *scanline,     window[9];     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { I       Warning("Unable to reduce noise","the image size must exceed 2x2");f       return((Image *) NULL);a     }i   /*&     Initialize noisy image attributes.   */@   noisy_image=CopyImage(image,image->columns,image->rows,False);$   if (noisy_image == (Image *) NULL)     { C       Warning("Unable to reduce noise","Memory allocation failed");o       return((Image *) NULL);e     }B   /*5     Allocate scanline buffer for 3 rows of the image.d   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)e     {fC       Warning("Unable to reduce noise","Memory allocation failed");f        DestroyImage(noisy_image);       return((Image *) NULL);      }    /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;h
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)t   {;     if (image->runlength != 0)       image->runlength--;t     else       {e         p++;#         image->runlength=p->length;        }*     *s=(*p);     s++;   }2   /*!     Dump first scanline of image.    */   q=noisy_image->pixels;
   s=scanline; $   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Reduce noise in each row.i   */%   for (y=1; y < (image->rows-1); y++)n   {      /*)       Initialize sliding window pointers.b     */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3);k+     s2=scanline+image->columns*((y+1) % 3);t     /*       Read another scan line.*     */	     s=s2;o&     for (x=0; x < image->columns; x++)     {;        if (image->runlength != 0)         image->runlength--;5
       else	         {1           p++;%           image->runlength=p->length;<	         }        *s=(*p);
       s++;     }e     /*+       Transfer first pixel of the scanline.C     */	     s=s1;s     *q=(*s);     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {"       /*3         Sort window pixels by increasing intensity.t       */       s=s0;o       window[0]=(*s++);        window[1]=(*s++);t       window[2]=(*s++);n       s=s1;        window[3]=(*s++);n       window[4]=(*s++);g       window[5]=(*s++);e       s=s2;        window[6]=(*s++);        window[7]=(*s++);C       window[8]=(*s++);        pixel=window[4];6       qsort((void *) window,9,sizeof(RunlengthPacket),G         (int (*) _Declare((const void *, const void *))) NoisyCompare);u3       if (Intensity(pixel) == Intensity(window[0])) 	         {s           /*H             Pixel is minimum noise; replace with next neighbor in value.           */           for (i=1; i < 8; i++)s=             if (Intensity(window[i]) != Intensity(window[0]))                break;           pixel=window[i];	         } 
       else5         if (Intensity(pixel) == Intensity(window[8]))s           {o             /*J               Pixel is maximum noise; replace with next neighbor in value.             */!             for (i=7; i > 0; i--)*?               if (Intensity(window[i]) != Intensity(window[8]))%                 break;             pixel=window[i];           }        *q=pixel;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */	     s=s1;      *q=(*s);     q->length=0;     q++;4     ProgressMonitor(NoisyImageText,y,image->rows-1);   }    /*!     Dump last scanline of pixels.    */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->length=0;     q++;     s++;   }    free((char *) scanline);   return(noisy_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %aO %     N o r m a l i z e I m a g e                                             %sO %                                                                             %_O %                                                                             %AO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function NormalizeImage normalizes the pixel values to span the fulleD %  range of color values.  This is a contrast enhancement technique. % / %  The format of the NormalizeImage routine is:a %i %      NormalizeImage(image) % + %  A description of each parameter follows:i %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.y %x %; */ void NormalizeImage(image) Imagee	   *image;  { 6 #define NormalizeImageText  "  Normalizing image...  "     intm     histogram[MaxRGB+1],     threshold_intensity;  	   QuantumL     gray_value,m     normalize_map[MaxRGB+1];     register int     i,     intensity;     register RunlengthPacket     *p;l     unsigned int	     high,m     low;     /*     Form histogram.m   */   for (i=0; i <= MaxRGB; i++)n     histogram[i]=0;>   p=image->pixels;$   for (i=0; i < image->packets; i++)   {)     gray_value=Intensity(*p);)'     histogram[gray_value]+=p->length+1;n     p++;   }n   /*C     Find the histogram boundaries by locating the 1 percent levels.    */7   threshold_intensity=(image->columns*image->rows)/100;e   intensity=0;"   for (low=0; low < MaxRGB; low++)   {l     intensity+=histogram[low];(     if (intensity > threshold_intensity)       break;   }    intensity=0;&   for (high=MaxRGB; high != 0; high--)   {o     intensity+=histogram[high];y(     if (intensity > threshold_intensity)       break;   }o   if (low == high)     {)       /*K         Unreasonable contrast;  use zero threshold to determine boundaries.a       */       threshold_intensity=0;       intensity=0;&       for (low=0; low < MaxRGB; low++)       {>"         intensity+=histogram[low];,         if (intensity > threshold_intensity)           break;       }        intensity=0;*       for (high=MaxRGB; high != 0; high--)       {>#         intensity+=histogram[high]; ,         if (intensity > threshold_intensity)           break;       }l       if (low == high)&         return;  /* zero span bound */     }t   /*A     Stretch the histogram to create the normalized image mapping.    */   for (i=0; i <= MaxRGB; i++)h     if (i < (int) low)       normalize_map[i]=0;      else       if (i > (int) high),"         normalize_map[i]=MaxRGB-1;
       else7         normalize_map[i]=(MaxRGB-1)*(i-low)/(high-low);e   /*     Normalize the image.   */   switch (image->class)-   {e     case DirectClass:e     {        /*$         Normalize DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=normalize_map[p->red];t)         p->green=normalize_map[p->green];('         p->blue=normalize_map[p->blue];          p++;!         if (QuantumTick(i,image))p?           ProgressMonitor(NormalizeImageText,i,image->packets);        }        break;     }o     case PseudoClass:      {        /*$         Normalize PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=normalize_map[image->colormap[i].red];-I         image->colormap[i].green=normalize_map[image->colormap[i].green];>G         image->colormap[i].blue=normalize_map[image->colormap[i].blue];        }        SyncImage(image);i       break;     }i   }  }  / /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %eO %                                                                             %_O %     O p a g u e I m a g e                                                   %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function OpaqueImage changes the color of an opaque pixel to the pen color. % , %  The format of the OpaqueImage routine is: % 1 %      OpaqueImage(image,opaque_color,pen_colors)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.% %% %    o opaque_color,G %      pen_colors: A character string that contain an X11 color string.o %  %  *// void OpaqueImage(image,opaque_color,pen_colors)c Imaged	   *image;s   char   *opaque_color,   *pen_colors; {  #define DeltaX  16C #define OpaqueImageText  "  Setting opaque color in the image...  "s  	   Quantum 	     blue,n
     green,     red;     register int     i;     register RunlengthPacket     *p;e     unsigned int     status;      XColor     target_color;m     /*-     Determine RGB values of the opaque color.I   */9   status=XQueryColorDatabase(opaque_color,&target_color);g   if (status == False)     return;s#   red=XDownScale(target_color.red); '   green=XDownScale(target_color.green); %   blue=XDownScale(target_color.blue); 7   status=XQueryColorDatabase(pen_colors,&target_color);n   if (status == False)     return;f   /*     Make image color opaque.   */   p=image->pixels;   switch (image->class)    {e     case DirectClass:n     {        /*&         Make DirectClass image opaque.       */(       for (i=0; i < image->packets; i++)       { 2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           { 0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }w         p++;!         if (QuantumTick(i,image))f<           ProgressMonitor(OpaqueImageText,i,image->packets);       }s       break;     }i     case PseudoClass:t     {-       double         distance_squared,<         min_distance;p  	       int=         distance;o         register int         index;         /*         Find closest color.        */-       min_distance=3.0*(MaxRGB+1)*(MaxRGB+1);        index=0;'       for (i=0; i < image->colors; i++)=       {r8         distance=(int) red-(int) image->colormap[i].red;<         distance_squared=(unsigned int) (distance*distance);<         distance=(int) green-(int) image->colormap[i].green;=         distance_squared+=(unsigned int) (distance*distance); :         distance=(int) blue-(int) image->colormap[i].blue;=         distance_squared+=(unsigned int) (distance*distance);1,         if (distance_squared < min_distance)           {w*             min_distance=distance_squared;             index=i;           }        }r       /*&         Make PseudoClass image opaque.       */>       image->colormap[index].red=XDownScale(target_color.red);B       image->colormap[index].green=XDownScale(target_color.green);@       image->colormap[index].blue=XDownScale(target_color.blue);       break;     }    }  }( g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             % O %                                                                             %gO %                                                                             % O %   O p e n I m a g e                                                         % O %                                                                             %sO %                                                                             % O %                                                                             %1O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %!L %  Function OpenImage open a file associated with the image.  A file name ofK %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If the K %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r'uK %  and compressed for type 'w'.  If the filename prefix is '|', it is piped  %  to or from a system command.e %|* %  The format of the OpenImage routine is: %)' %      OpenImage(image_info,image,type)] %u+ %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %-7 %    o image: The address of a structure of type Image.n %>. %    o type: 'r' for reading; 'w' for writing. %p */% void OpenImage(image_info,image,type)(	 ImageInfoc   *image_info;   Imagen	   *image;e   char   *type; {(   char     filename[MaxTextLength];  *   (void) strcpy(filename,image->filename);   if (*filename != '|')r'     if (((int) strlen(filename) > 3) &&c9         (strcmp(filename+strlen(filename)-3,".gz") == 0))        {e
         /*E           Uncompress/compress image file with GNU compress utilities.c
         */         if (*type == 'r')_A           (void) sprintf(filename,GunzipCommand,image->filename);g         else?           (void) sprintf(filename,GzipCommand,image->filename);        }p     else)       if (((int) strlen(filename) > 2) &&l:           (strcmp(filename+strlen(filename)-2,".Z") == 0))	         {g           /*H             Uncompress/compress image file with UNIX compress utilities.           */           if (*type == 'r') G             (void) sprintf(filename,UncompressCommand,image->filename);.           elseE             (void) sprintf(filename,CompressCommand,image->filename);e	         }-   /*     Open image file.   */   image->pipe=False;    if (strcmp(filename,"-") == 0)0     image->file=(*type == 'r') ? stdin : stdout;   else     if (*filename != '|')_       {l2         if ((*type == 'w') && !image_info->adjoin)4           if ((image->previous != (Image *) NULL) ||.               (image->next != (Image *) NULL))
             {                /*4                 Form filename for multi-part images.               */D               (void) sprintf(filename,image->filename,image->scene);8               if (strcmp(filename,image->filename) == 0)N                 (void) sprintf(filename,"%s.%u",image->filename,image->scene);0               if (image->next != (Image *) NULL)A                 (void) strcpy(image->next->magick,image->magick);l6               (void) strcpy(image->filename,filename);
             };2         image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)            {;+             (void) fseek(image->file,0L,2); /             image->filesize=ftell(image->file);e+             (void) fseek(image->file,0L,0);l           }        }      else       {e
         /*1           Pipe image to or from a system command. 
         */         if (*type == 'w') )           (void) signal(SIGPIPE,SIG_IGN);h4         image->file=(FILE *) popen(filename+1,type);         image->pipe=True;        }p   image->status=False;   if (*type == 'r')&     { !       image->next=(Image *) NULL;)%       image->previous=(Image *) NULL;      }  }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             %sO %                                                                             %%O %   P a r s e I m a g e G e o m e t r y                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ParseImageGeometry parse a geometry specification and returns the  %  width and height values.  % 3 %  The format of the ParseImageGeometry routine is:  % 6 %      ParseImageGeometry(image_geometry,width,height) %%+ %  A description of each parameter follows:% %%N %    o image_geometry:  Specifies a character string representing the geometry %      specification.  %sL %    o width:  A pointer to an unsigned integer.  The width as determined by3 %      the geometry specification is returned here.a %pN %    o height:  A pointer to an unsigned integer.  The height as determined by3 %      the geometry specification is returned here.f %. %  */4 void ParseImageGeometry(image_geometry,width,height) char   *image_geometry;   unsigned int	   *width, 
   *height; {s   char     geometry[MaxTextLength];     inte
     flags,     x,     y;     register char;     *p;m     unsigned int     aspect_ratio,      former_height,     former_width,      greater,	     less,a     percentage;h     unsigned long      scale_factor;a  &   if (image_geometry == (char *) NULL)     return;k   /*J     Remove whitespaces and % and ! characters from geometry specification.   */)   (void) strcpy(geometry,image_geometry);m   aspect_ratio=True;   greater=False;
   less=False;N   percentage=False; 
   p=geometry;    while ((int) strlen(p) > 0)-   {n     if (isspace(*p))       (void) strcpy(p,p+1);[     else       switch (*p)s       {          case '%':i	         {!           percentage=True;           (void) strcpy(p,p+1);k           break;	         }|         case '!':e	         {w           aspect_ratio=False;v           (void) strcpy(p,p+1);-           break;	         }          case '<':;	         {i           less=True;           (void) strcpy(p,p+1);            break;	         }e         case '>': 	         {            greater=True;c           (void) strcpy(p,p+1);t           break;	         }          default:           p++;       }c   })   /*(     Parse geometry using XParseGeometry.   */   former_width=(*width);   former_height=(*height);4   flags=XParseGeometry(geometry,&x,&y,width,height);@   if (((flags & WidthValue) != 0) && (flags & HeightValue) == 0)     *height=(*width);    if (percentage)-     {)       /*3         Geometry is a percentage of the image size.n       */)       *width=(former_width*(*width))/100;e,       *height=(former_height*(*height))/100;       former_width=(*width);       former_height=(*height);     }f   if (aspect_ratio)l     {        /**         Respect aspect ratio of the image.       */0       scale_factor=UpShift(*width)/former_width;:       if (scale_factor > (UpShift(*height)/former_height))4         scale_factor=UpShift(*height)/former_height;2       *width=DownShift(former_width*scale_factor);4       *height=DownShift(former_height*scale_factor);     }    if (greater)=     if ((former_width < *width) && (former_height < *height))t       {          *width=former_width;         *height=former_height;       }    if (less)n=     if ((former_width > *width) && (former_height > *height))c       {i         *width=former_width;         *height=former_height;       }s }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             % O %     O i l P a i n t I m a g e                                               %lO %                                                                             %fO %                                                                             %uO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%S %eK %  Function OilPaintImage creates a new image that is a copy of an existing N %  one with each pixel component replaced with the color of greatest number in %  a 5x5 neighborhood. %i. %  The format of the OilPaintImage routine is: % ) %      painted_image=OilPaintImage(image)) % + %  A description of each parameter follows:g %sK %    o painted_image: Function OilPaintImage returns a pointer to the image L %      after it is `painted'.  A null image is returned if there is a memory %      shortage. %eF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %g %c */ Image *OilPaintImage(image)r Imagel	   *image;r {%6 #define OilPaintImageText  "  Oil painting image...  "     Imageh     *painted_image;;     intm
     count;     register int     i,     j;     register RunlengthPacket     *p,f     *q,i     *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned intf     x;     RunlengthPacket)
     pixel,     *scanline,     window[25];a     unsigned int     *histogram,p     y;  0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to oil paint","the image size must exceed 4x4");       return((Image *) NULL);e     }    /*(     Initialize painted image attributes.   */B   painted_image=CopyImage(image,image->columns,image->rows,False);&   if (painted_image == (Image *) NULL)     {i@       Warning("Unable to oil paint","Memory allocation failed");       return((Image *) NULL);      }f#   painted_image->class=DirectClass;a   /*$     Allocate histogram and scanline.   */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int));gP   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));-   if ((histogram == (unsigned int *) NULL) ||%-       (scanline == (RunlengthPacket *) NULL))%     {%@       Warning("Unable to oil paint","Memory allocation failed");"       DestroyImage(painted_image);       return((Image *) NULL);      }    /**     Preload the first 4 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 2); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*!     Dump first scanline of image.%   */   q=painted_image->pixels;
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)t   {s     *q=(*s);     q->length=0;     q++;     s++;   }i   /*      Paint each row of the image.   */%   for (y=2; y < (image->rows-2); y++).   {1     /*)       Initialize sliding window pointers.c     */+     s0=scanline+image->columns*((y-2) % 5); +     s1=scanline+image->columns*((y-1) % 5);r'     s2=scanline+image->columns*(y % 5);n+     s3=scanline+image->columns*((y+1) % 5);t+     s4=scanline+image->columns*((y+2) % 5);e     /*       Read another scan line.      */	     s=s4;T&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;r
       else	         {r           p++;%           image->runlength=p->length;c	         }t       *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */	     s=s2;      *q=(*s++);     q->length=0;     q++;     *q=(*s++);     q->length=0;     q++;*     for (x=2; x < (image->columns-2); x++)     {        /*.         Note each pixel in a 5x5 neighborhood.       */       s=s0;t       window[0]=(*s++);n       window[1]=(*s++);s       window[2]=(*s++);        window[3]=(*s++);        window[4]=(*s++);        s=s1;Q       window[5]=(*s++);        window[6]=(*s++);        window[7]=(*s++);+       window[8]=(*s++);m       window[9]=(*s++);(       s=s2;2       window[10]=(*s++);       window[11]=(*s++);       window[12]=(*s++);       window[13]=(*s++);       window[14]=(*s++);       s=s3;        window[15]=(*s++);       window[16]=(*s++);       window[17]=(*s++);       window[18]=(*s++);       window[19]=(*s++);       s=s4;        window[20]=(*s++);       window[21]=(*s++);       window[22]=(*s++);       window[23]=(*s++);       window[24]=(*s++);       /*&         Determine most frequent color.       */       count=0;$       for (i=0; i < (MaxRGB+1); i++)         histogram[i]=0;*       for (i=0; i < 25; i++)       {o%          j=Intensity(window[i]) >> 2;o          histogram[j]++;          j=histogram[j];          if (j > count)(            {              pixel=window[i];x              count=j;             }       }(       *q=pixel;        q->length=0;
       q++;       s0++;v       s1++;+       s2++;+       s3++;+       s4++;+     }      /**       Transfer last pixel of the scanline.     */	     s=s2;=     *q=(*s++);     q->length=0;     q++;     *q=(*s++);     q->length=0;     q++;7     ProgressMonitor(OilPaintImageText,y,image->rows-2);    }    /*!     Dump last scanline of pixels.;   */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)e   {      *q=(*s);     q->length=0;     q++;     s++;   }m   free((char *) histogram);u   free((char *) scanline);   return(painted_image); }n   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %dO %                                                                             %rO %   R a i s e I m a g e                                                       %UO %                                                                             %LO %                                                                             %fO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %zK %  Function RaiseImage lightens and darkens the edges of an image to give a  %  3-D raised or lower effect. %p+ %  The format of the RaiseImage routine is:) %l+ %      RaiseImage(image,raised,bevel_width)a %l+ %  A description of each parameter follows:l % 7 %    o image: The address of a structure of type Image.N %)L %    o raised: A value other than zero causes the image to have a 3-D raised1 %      effect, otherwise it has a lowered effect.  %nN %    o bevel_width: This unsigned integer defines the width of the 3-D effect. %s %k */) void RaiseImage(image,raised,bevel_width)  Image 	   *image;o   intb	   raised;    unsigned int   bevel_width; { # #define HighlightLeft  UpScale(160)e" #define HighlightTop  UpScale(180). #define RaiseImageText  "  Raising image...  "! #define ShadowRight  UpScale(180) " #define ShadowBottom  UpScale(160)  	   Quantumm     foreground,-     background;j     register int     x,     y;     register RunlengthPacket     *p;m     unsigned int     height;n  .   if ((image->columns < (bevel_width << 1)) &&)       (image->rows < (bevel_width << 1)))_     {[L       Warning("Unable to raise image","image size must exceed bevel width");
       return;      }.   if (!UncompressImage(image))     return;r   foreground=MaxRGB;   background=0;    if (!raised)     {i       foreground=0;r       background=MaxRGB;     }l   image->class=DirectClass;,   p=image->pixels;!   for (y=0; y < bevel_width; y++)-   {g     for (x=0; x < y; x++)c     {b       p->red=(unsigned int)-H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int)/J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;,
       p++;     }r1     for (x=0; x < (image->columns-(y << 1)); x++)w     {_       p->red=(unsigned int)[F         (p->red*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->green=(unsigned int)aH         (p->green*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;r
       p++;     }c     for (x=0; x < y; x++)      {i       p->red=(unsigned int)-D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int) F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;r
       p++;     }t   }p(   height=image->rows-(bevel_width << 1);   for (y=0; y < height; y++)   { #     for (x=0; x < bevel_width; x++)      {        p->red=(unsigned int)-H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int)eJ         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;h
       p++;     };;     for (x=0; x < (image->columns-(bevel_width << 1)); x++)e
       p++;#     for (x=0; x < bevel_width; x++)%     {%       p->red=(unsigned int)%D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int) F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB; 
       p++;     } -     ProgressMonitor(RaiseImageText,y,height);    } !   for (y=0; y < bevel_width; y++)    { '     for (x=0; x < (bevel_width-y); x++)      {        p->red=(unsigned int) H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;t
       p++;     } ?     for (x=0; x < (image->columns-((bevel_width-y) << 1)); x++)m     {g       p->red=(unsigned int)aF         (p->red*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->green=(unsigned int)DH         (p->green*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;e
       p++;     }m'     for (x=0; x < (bevel_width-y); x++)e     {*       p->red=(unsigned int) D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int)lF         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB; 
       p++;     }(   }*	   return;r }o ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %sO %                                                                             %gO %     R G B T r a n s f o r m I m a g e                                       % O %                                                                             %cO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%F %  Function RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standard L %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..MaxRGB]. % 2 %  The format of the RGBTransformImage routine is: % * %      RGBTransformImage(image,colorspace) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %% %% */( void RGBTransformImage(image,colorspace) Image 	   *image;o   unsigned int
   colorspace;o {aA #define RGBTransformImageText  "  Transforming image colors...  "t #define X 0g #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     long     tx,p     ty,a     tz,t     *x,s     *y,      *z;e  	   Quantum      *range_table;y     register int	     blue,D
     green,     i,     red;     register Quantum     *range_limit;;     register RunlengthPacket     *p;   "   if (colorspace == RGBColorspace)     return; #   if (colorspace == GRAYColorspace)s     {a       /*1         Return if the image is already grayscale.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {a:         if ((p->red != p->green) || (p->green != p->blue))           break;         p++;       }%       if (i == image->packets)         return;%     }    /*     Allocate the tables.   *//   x=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); /   y=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); /   z=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); ?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum)); 5   if ((x == (long *) NULL) || (y == (long *) NULL) || @       (z == (long *) NULL) || (range_table == (Quantum *) NULL))     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }    /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0;%*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;g   }w%   range_limit=range_table+(MaxRGB+1);)   tx=0;    ty=0;    tz=0;T   switch (colorspace)a   {u     case GRAYColorspace:     {a       /*         Initialize GRAY tables:   +           G = 0.29900*R+0.58600*G+0.11400*B        */!       for (i=0; i <= MaxRGB; i++)        {t$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.29900)*i;$         y[i+Y]=UpShifted(0.58600)*i;$         z[i+Y]=UpShifted(0.11400)*i;$         x[i+Z]=UpShifted(0.29900)*i;$         y[i+Z]=UpShifted(0.58600)*i;$         z[i+Z]=UpShifted(0.11400)*i;       }+       break;     }      case OHTAColorspace:     {        /*         Initialize OHTA tables:e  ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0p         through MaxRGB.)       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.33333)*i;$         y[i+X]=UpShifted(0.33334)*i;$         z[i+X]=UpShifted(0.33333)*i;$         x[i+Y]=UpShifted(0.50000)*i;         y[i+Y]=0; '         z[i+Y]=(-UpShifted(0.50000))*i; '         x[i+Z]=(-UpShifted(0.25000))*i; $         y[i+Z]=UpShifted(0.50000)*i;'         z[i+Z]=(-UpShifted(0.25000))*i;        }        break;     }i     case XYZColorspace:s     {;       /*"         Initialize CIE XYZ tables:  .           X = 0.412453*X+0.357580*Y+0.180423*Z.           Y = 0.212671*X+0.715160*Y+0.072169*Z.           Z = 0.019334*X+0.119193*Y+0.950227*Z       */!       for (i=0; i <= MaxRGB; i++)        {g%         x[i+X]=UpShifted(0.412453)*i;s%         y[i+X]=UpShifted(0.357580)*i;r%         z[i+X]=UpShifted(0.180423)*i;-%         x[i+Y]=UpShifted(0.212671)*i;)%         y[i+Y]=UpShifted(0.715160)*i; %         z[i+Y]=UpShifted(0.072169)*i; %         x[i+Z]=UpShifted(0.019334)*i;e%         y[i+Z]=UpShifted(0.119193)*i;<%         z[i+Z]=UpShifted(0.950227)*i;        }i       break;     }      case YCbCrColorspace:=     {x       /*          Initialize YCbCr tables:  /           Y =  0.299000*R+0.586000*G+0.114000*B(/           Cb= -0.172586*R-0.338828*G+0.511414*B;/           Cr=  0.511414*R-0.428246*G-0.083168*B   K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0a         through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        {a%         x[i+X]=UpShifted(0.299000)*i; %         y[i+X]=UpShifted(0.586000)*i;"%         z[i+X]=UpShifted(0.114000)*i;;(         x[i+Y]=(-UpShifted(0.172586))*i;(         y[i+Y]=(-UpShifted(0.338828))*i;%         z[i+Y]=UpShifted(0.511414)*i;i%         x[i+Z]=UpShifted(0.511414)*i;i(         y[i+Z]=(-UpShifted(0.428246))*i;(         z[i+Z]=(-UpShifted(0.083168))*i;       }r       break;     }      case YCCColorspace:i     {c       /*         Initialize YCC tables:  +           Y = 0.29900*R+0.58600*G+0.11400*B*+           C1=-0.29900*R-0.58600*G+0.88600*Bi+           C2= 0.70100*R-0.58600*G+0.11400*B   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */0       ty=UpShifted((unsigned int) UpScale(156));0       tz=UpShifted((unsigned int) UpScale(137));!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.29900))*i;i'         y[i+Y]=(-UpShifted(0.58600))*i; $         z[i+Y]=UpShifted(0.88600)*i;$         x[i+Z]=UpShifted(0.70100)*i;'         y[i+Z]=(-UpShifted(0.58600))*i;t'         z[i+Z]=(-UpShifted(0.11400))*i;        }        break;     }t     case YIQColorspace:e     {        /*         Initialize YIQ tables:  +           Y = 0.29900*R+0.58600*G+0.11400*Bt+           I = 0.50000*R-0.23000*G-0.27000*B +           Q = 0.20200*R-0.50000*G+0.29800*B   I         I and Q, normally -0.5 through 0.5, are normalized to the range 0s         through MaxRGB.i       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)i       { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.50000)*i;'         y[i+Y]=(-UpShifted(0.23000))*i;o'         z[i+Y]=(-UpShifted(0.27000))*i; $         x[i+Z]=UpShifted(0.20200)*i;'         y[i+Z]=(-UpShifted(0.50000))*i;e$         z[i+Z]=UpShifted(0.29800)*i;       }o       break;     }      case YPbPrColorspace:      {(       /*          Initialize YPbPr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*Bl/           Pb= -0.168736*R-0.331264*G+0.500000*Bh/           Pr=  0.500000*R-0.418688*G-0.081312*Bl  K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0m         through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)n       {i%         x[i+X]=UpShifted(0.299000)*i;,%         y[i+X]=UpShifted(0.587000)*i;P%         z[i+X]=UpShifted(0.114000)*i;4(         x[i+Y]=(-UpShifted(0.168736))*i;(         y[i+Y]=(-UpShifted(0.331264))*i;%         z[i+Y]=UpShifted(0.500000)*i;e%         x[i+Z]=UpShifted(0.500000)*i;t(         y[i+Z]=(-UpShifted(0.418688))*i;(         z[i+Z]=(-UpShifted(0.081312))*i;       }        break;     }h     case YUVColorspace:      default:     {d       /*         Initialize YUV tables:  ,           Y =  0.29900*R+0.58600*G+0.11400*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 0 D         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)t       {($         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.14740))*i; '         y[i+Y]=(-UpShifted(0.28950))*i;t$         z[i+Y]=UpShifted(0.43690)*i;$         x[i+Z]=UpShifted(0.61500)*i;'         y[i+Z]=(-UpShifted(0.51500))*i;a'         z[i+Z]=(-UpShifted(0.10000))*i;n       }        break;     }    }    /*     Convert from RGB.i   */   switch (image->class)o   {r     case DirectClass:i     {        /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {r         red=p->red;_         green=p->green;t         blue=p->blue;rH         p->red=range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];J         p->green=range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];I         p->blue=range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];(         p++;!         if (QuantumTick(i,image)) B           ProgressMonitor(RGBTransformImageText,i,image->packets);       }e       break;     }      case PseudoClass:e     {l       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {e#         red=image->colormap[i].red;i'         green=image->colormap[i].green;-%         blue=image->colormap[i].blue;%         image->colormap[i].red=%C           range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)]; !         image->colormap[i].green= C           range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];           image->colormap[i].blue=C           range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];        }        SyncImage(image);        break;     }    }    /*     Free allocated memory.   */   free((char *) range_table);    free((char *) z);    free((char *) y);    free((char *) x);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %hO %                                                                             % O %                                                                             % O %   R o l l I m a g e                                                         %iO %                                                                             %yO %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %mE %  Function RollImage rolls an image vertically and horizontally.  ItsK %  allocates the memory necessary for the new Image structure and returns ai %  pointer to the new image. %e* %  The format of the RollImage routine is: % 1 %      rolled_image=RollImage(image,columns,rows)e %a+ %  A description of each parameter follows:  %/L %    o rolled_image: Function RollImage returns a pointer to the image afterH %      rolling.  A null image is returned if there is a memory shortage. %i7 %    o image: The address of a structure of type Image.) % H %    o x_offset: An integer that specifies the number of columns to roll# %      in the horizontal direction._ %eL %    o y_offset: An integer that specifies the number of rows to roll in the %      vertical direction. %  %s */) Image *RollImage(image,x_offset,y_offset); Imageu	   *image;e   int    x_offset,x   y_offset;a {n- #define RollImageText  "  Rolling image...  "o     Image|     *rolled_image;     register RunlengthPacket     *p,s     *q;"     register unsigned int)     packets,     x;     unsigned int     y;     /*'     Initialize rolled image attributes./   */A   rolled_image=CopyImage(image,image->columns,image->rows,False); %   if (rolled_image == (Image *) NULL)      { A       Warning("Unable to roll image","Memory allocation failed");;       return((Image *) NULL);      }    /*     Roll image.s   */   p=image->pixels;   image->runlength=p->length+1;o%   packets=image->columns*image->rows;l!   for (y=0; y < image->rows; y++)m   {z     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {n        if (image->runlength != 0)         image->runlength--; 
       else	         {m           p++;%           image->runlength=p->length; 	         }fD       q=rolled_image->pixels+(y_offset+y)*image->columns+x+x_offset;#       if (q < rolled_image->pixels)          q+=packets;>
       else0         if (q >= (rolled_image->pixels+packets))           q-=packets;        *q=(*p);       q->length=0;     } 1     ProgressMonitor(RollImageText,y,image->rows);;   }    return(rolled_image);p }r s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %=O %                                                                             % O %                                                                             %yO %   S a m p l e I m a g e                                                     %nO %                                                                             %gO %                                                                             % O %                                                                             %+O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eG %  Function SampleImage creates a new image that is a scaled size of an H %  existing one using pixel sampling.  It allocates the memory necessaryF %  for the new Image structure and returns a pointer to the new image. % , %  The format of the SampleImage routine is: % 4 %      sampled_image=SampleImage(image,columns,rows) %r+ %  A description of each parameter follows:  % O %    o sampled_image: Function SampleImage returns a pointer to the image after-H %      scaling.  A null image is returned if there is a memory shortage. %o7 %    o image: The address of a structure of type Image.o % N %    o columns: An integer that specifies the number of columns in the sampled
 %      image.  %eH %    o rows: An integer that specifies the number of rows in the sampled
 %      image.R %1 %> */& Image *SampleImage(image,columns,rows) Imagee	   *image;    unsigned int
   columns,   rows;B { 0 #define SampleImageText  "  Sampling image...  "     Image>     *sampled_image;_     int      y;     register RunlengthPacket     *p,f     *q,l     *s;G     register int     x;     RunlengthPacket(     *scanline;     unsigned int     *x_offset,     *y_offset;     unsigned long      scale_factor;   $   if ((columns == 0) || (rows == 0))     { D       Warning("Unable to sample image","image dimensions are zero");       return((Image *) NULL);l     }    /*(     Initialize sampled image attributes.   */4   sampled_image=CopyImage(image,columns,rows,False);&   if (sampled_image == (Image *) NULL)     {oC       Warning("Unable to sample image","Memory allocation failed");        return((Image *) NULL);n     }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));P   x_offset=(unsigned int *) malloc(sampled_image->columns*sizeof(unsigned int));M   y_offset=(unsigned int *) malloc(sampled_image->rows*sizeof(unsigned int)); /   if ((scanline == (RunlengthPacket *) NULL) || ,       (x_offset == (unsigned int *) NULL) ||*       (y_offset == (unsigned int *) NULL))     { C       Warning("Unable to sample image","Memory allocation failed"); "       DestroyImage(sampled_image);       return((Image *) NULL);      }    /*$     Initialize column pixel offsets.   */@   scale_factor=UpShift(image->columns-1)/sampled_image->columns;   columns=0;,   for (x=0; x < sampled_image->columns; x++)   { <     x_offset[x]=DownShift((x+1)*scale_factor)-(int) columns;     columns+=x_offset[x];F   }o   /*!     Initialize row pixel offsets.    */:   scale_factor=UpShift(image->rows-1)/sampled_image->rows;	   rows=0;m)   for (y=0; y < sampled_image->rows; y++)u   {d9     y_offset[y]=DownShift((y+1)*scale_factor)-(int) rows;o     rows+=y_offset[y];   }i$   y_offset[sampled_image->rows-1]=0;   /*     Preload first scanline.    */   p=image->pixels;   image->runlength=p->length+1;u
   s=scanline;b$   for (x=0; x < image->columns; x++)   {a     if (image->runlength != 0)       image->runlength--;      else       {f         p++;#         image->runlength=p->length;d       }g     *s=(*p);     s->length=0;     s++;   }a   /*     Sample each row.   */   q=sampled_image->pixels;)   for (y=0; y < sampled_image->rows; y++)    {r     /*       Sample each column.r     */     s=scanline; .     for (x=0; x < sampled_image->columns; x++)     {r       *q=(*s);
       q++;       s+=x_offset[x];a     }      if (y_offset[y] != 0)        {l
         /*           Skip a scan line. 
         */         if (y_offset[y] > 1)>           for (x=0; x < (image->columns*(y_offset[y]-1)); x++)&             if (image->runlength != 0)!               image->runlength--;t             else               {g                 p++;+                 image->runlength=p->length;                }(
         /*           Read a scan line.f
         */         s=scanline;m*         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {                p++;)               image->runlength=p->length; 
             }            *s=(*p);           s->length=0;           s++;	         }        }d;     ProgressMonitor(SampleImageText,y,sampled_image->rows);i   }>   free((char *) scanline);   free((char *) x_offset);   free((char *) y_offset);   return(sampled_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %_O %                                                                             % O %                                                                             %sO %   S c a l e I m a g e                                                       %/O %                                                                             %;O %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % F %  Function ScaleImage creates a new image that is a scaled size of anE %  existing one.  It allocates the memory necessary for the new ImagerI %  structure and returns a pointer to the new image.  To scale a scanline;K %  from x pixels to y pixels, each new pixel represents x/y old pixels.  To L %  read x/y pixels, read (x/y rounded up) pixels but only count the requiredH %  fraction of the last old pixel read in your new pixel.  The remainder: %  of the old pixel will be counted in the next new pixel. %xK %  The scaling algorithm was suggested by rjohnson@shell.com and is adapted 0 %  from pnmscale(1) of PBMPLUS by Jef Poskanzer. %e+ %  The format of the ScaleImage routine is:  %i2 %      scaled_image=ScaleImage(image,columns,rows) %i+ %  A description of each parameter follows:n %mM %    o scaled_image: Function ScaleImage returns a pointer to the image afteraH %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the scaled 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the scaled;
 %      image.  %  %  */% Image *ScaleImage(image,columns,rows)n Image 	   *image;    unsigned int
   columns,   rows;o {x. #define ScaleImageText  "  Scaling image...  "     typedef struct ScaledPacketa   {      long
       red,       green,       blue,o       index;   } ScaledPacket;      Image_     *scaled_image;     int;
     next_row,      number_rows;     long     x_scale,     x_span;w     register RunlengthPacket     *p,)     *q;i     register ScaledPacket2     *s,      *t;g     register unsigned inth     x;     ScaledPacket     *scaled_scanline,0     *scanline,     *y_vector,     *x_vector;     unsigned int     packets,     y;     unsigned long(	     blue,t
     green,
     index,     red,     scale_factor;n  $   if ((columns == 0) || (rows == 0))     {RC       Warning("Unable to scale image","image dimensions are zero");u       return((Image *) NULL);(     }l   /*'     Initialize scaled image attributes.    */B   scale_factor=UpShift(columns*rows)/(image->columns*image->rows);8   packets=Max(DownShift(image->packets*scale_factor),1);0   scaled_image=CopyImage(image,packets,1,False);%   if (scaled_image == (Image *) NULL)-     {MB       Warning("Unable to scale image","Memory allocation failed");       return((Image *) NULL);+     } "   scaled_image->class=DirectClass;    scaled_image->columns=columns;   scaled_image->rows=rows;   scaled_image->packets=0;   /*     Allocate memory.   */H   x_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));   scanline=x_vector;(   if (scaled_image->rows != image->rows)J     scanline=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));"   scaled_scanline=(ScaledPacket *)7     malloc(scaled_image->columns*sizeof(ScaledPacket));%H   y_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));,   if ((x_vector == (ScaledPacket *) NULL) ||,       (scanline == (ScaledPacket *) NULL) ||3       (scaled_scanline == (ScaledPacket *) NULL) || *       (y_vector == (ScaledPacket *) NULL))     { B       Warning("Unable to scale image","Memory allocation failed");!       DestroyImage(scaled_image);        return((Image *) NULL);      }    /*     Scale image.   */   number_rows=0;   next_row=True;2   x_scale=UpShift(scaled_image->rows)/image->rows;   x_span=UpShift(1);$   for (x=0; x < image->columns; x++)   {%     y_vector[x].red=0;     y_vector[x].green=0;     y_vector[x].blue=0;c     y_vector[x].index=0;   }    p=image->pixels;   image->runlength=p->length+1;i   q=scaled_image->pixels;y   q->red=0;r
   q->green=0;a   q->blue=0;
   q->index=0;i   q->length=MaxRunlength; (   for (y=0; y < scaled_image->rows; y++)   {l*     if (scaled_image->rows == image->rows)(       for (x=0; x < image->columns; x++)       {G
         /*           Read a new scanline.
         */"         if (image->runlength != 0)           image->runlength--;          else           {a             p++;'             image->runlength=p->length;            }          x_vector[x].red=p->red; #         x_vector[x].green=p->green; !         x_vector[x].blue=p->blue;i#         x_vector[x].index=p->index;        }      else       {f
         /*           Scale Y direction.
         */          while (x_scale < x_span)	         {s6           if (next_row && (number_rows < image->rows))
             {o               /*$                 Read a new scanline.               */0               for (x=0; x < image->columns; x++)               {.*                 if (image->runlength != 0)%                   image->runlength--;                  else                   {g                     p++;/                     image->runlength=p->length;n                   }\'                 x_vector[x].red=p->red; +                 x_vector[x].green=p->green; )                 x_vector[x].blue=p->blue;i+                 x_vector[x].index=p->index;e               }[               number_rows++;
             }o,           for (x=0; x < image->columns; x++)           { 5             y_vector[x].red+=x_scale*x_vector[x].red;l9             y_vector[x].green+=x_scale*x_vector[x].green; 7             y_vector[x].blue+=x_scale*x_vector[x].blue;g9             y_vector[x].index+=x_scale*x_vector[x].index;t           }            x_span-=x_scale;:           x_scale=UpShift(scaled_image->rows)/image->rows;           next_row=True;	         }i4         if (next_row && (number_rows < image->rows))           {s             /*"               Read a new scanline.             */.             for (x=0; x < image->columns; x++)
             {t(               if (image->runlength != 0)#                 image->runlength--;o               else                 {i                   p++;-                   image->runlength=p->length;                  }i%               x_vector[x].red=p->red;u)               x_vector[x].green=p->green;t'               x_vector[x].blue=p->blue; )               x_vector[x].index=p->index;u
             },             number_rows++;             next_row=False;            }n         s=scanline;i*         for (x=0; x < image->columns; x++)	         { @           red=DownShift(y_vector[x].red+x_span*x_vector[x].red);F           green=DownShift(y_vector[x].green+x_span*x_vector[x].green);C           blue=DownShift(y_vector[x].blue+x_span*x_vector[x].blue); F           index=DownShift(y_vector[x].index+x_span*x_vector[x].index);-           s->red=red > MaxRGB ? MaxRGB : red;)3           s->green=green > MaxRGB ? MaxRGB : green; 0           s->blue=blue > MaxRGB ? MaxRGB : blue;E           s->index=index > MaxColormapSize ? MaxColormapSize : index;u           s++;           y_vector[x].red=0;           y_vector[x].green=0;           y_vector[x].blue=0;            y_vector[x].index=0;	         }a         x_scale-=x_span;         if (x_scale == 0)>           { <             x_scale=UpShift(scaled_image->rows)/image->rows;             next_row=True;           }g         x_span=UpShift(1);       } 0     if (scaled_image->columns == image->columns)       { 
         /*,           Transfer scanline to scaled image.
         */         s=scanline;c1         for (x=0; x < scaled_image->columns; x++) 	         {u=           if ((s->red == q->red) && (s->green == q->green) &&;?               (s->blue == q->blue) && (s->index == q->index) && /               ((int) q->length < MaxRunlength))n             q->length++;           else
             {n-               if (scaled_image->packets != 0)+                 q++;&               scaled_image->packets++;3               if (scaled_image->packets == packets)                  {m                   packets<<=1;K                   scaled_image->pixels=(RunlengthPacket *) realloc((char *)gJ                     scaled_image->pixels,packets*sizeof(RunlengthPacket));G                   if (scaled_image->pixels == (RunlengthPacket *) NULL)n                     { 6                       Warning("Unable to scale image",4                         "Memory allocation failed");1                       DestroyImage(scaled_image); -                       return((Image *) NULL);                      }xA                   q=scaled_image->pixels+scaled_image->packets-1;                  }                q->red=s->red;                q->green=s->green;               q->blue=s->blue;                q->index=s->index;               q->length=0;
             }r           s++;	         }s       }      else       {          intE           next_column;           long int           y_scale,           y_span;   
         /*           Scale X direction.
         */         red=0;         green=0;         blue=0;(         next_column=False;         y_span=UpShift(1);         s=scanline;          t=scaled_scanline;*         for (x=0; x < image->columns; x++)	         {;@           y_scale=UpShift(scaled_image->columns)/image->columns;#           while (y_scale >= y_span)a           {              if (next_column)               {i                 red=0;                 green=0;                 blue=0;e                 index=0;                 t++;               }--             red=DownShift(red+y_span*s->red);+3             green=DownShift(green+y_span*s->green); 0             blue=DownShift(blue+y_span*s->blue);3             index=DownShift(index+y_span*s->index); /             t->red=red > MaxRGB ? MaxRGB : red; 5             t->green=green > MaxRGB ? MaxRGB : green;a2             t->blue=blue > MaxRGB ? MaxRGB : blue;G             t->index=index > MaxColormapSize ? MaxColormapSize : index;              y_scale-=y_span;             y_span=UpShift(1);             next_column=True;+           }q         if (y_scale > 0)           {)             if (next_column)               {e                 red=0;                 green=0;                 blue=0;%                 index=0;"                 next_column=False;                 t++;               }               red+=y_scale*s->red;$             green+=y_scale*s->green;"             blue+=y_scale*s->blue;$             index+=y_scale*s->index;             y_span-=y_scale;           }          s++;       }        if (y_span > 0) 	         {            s--;           red+=y_span*s->red; !           green+=y_span*s->green;            blue+=y_span*s->blue; !           index+=y_span*s->index; 	         }        if (!next_column)%	         {%           red=DownShift(red);%!           green=DownShift(green);a           blue=DownShift(blue);l!           index=DownShift(index); -           t->red=red > MaxRGB ? MaxRGB : red;e3           t->green=green > MaxRGB ? MaxRGB : green;r0           t->blue=blue > MaxRGB ? MaxRGB : blue;3           t->index=index > MaxRGB ? MaxRGB : index;e	         }        /**         Transfer scanline to scaled image.       */       t=scaled_scanline;/       for (x=0; x < scaled_image->columns; x++)u       { ;         if ((t->red == q->red) && (t->green == q->green) &&t=             (t->blue == q->blue) && (t->index == q->index) && -             ((int) q->length < MaxRunlength))            q->length++;         else           { +             if (scaled_image->packets != 0)s               q++;$             scaled_image->packets++;1             if (scaled_image->packets == packets)n               {x                 packets<<=1;I                 scaled_image->pixels=(RunlengthPacket *) realloc((char *) H                   scaled_image->pixels,packets*sizeof(RunlengthPacket));E                 if (scaled_image->pixels == (RunlengthPacket *) NULL)                    {sP                     Warning("Unable to scale image","Memory allocation failed");/                     DestroyImage(scaled_image); +                     return((Image *) NULL);;                   }*?                 q=scaled_image->pixels+scaled_image->packets-1;                }0             q->red=t->red;             q->green=t->green;             q->blue=t->blue;             q->index=t->index;             q->length=0;           }i         t++;       }h     }a9     ProgressMonitor(ScaleImageText,y,scaled_image->rows);    }a;   scaled_image->pixels=(RunlengthPacket *) realloc((char *) H     scaled_image->pixels,scaled_image->packets*sizeof(RunlengthPacket));   /*     Free allocated memory.   */   free((char *) y_vector);!   free((char *) scaled_scanline);s   if (scanline != x_vector)s     free((char *) scanline);   free((char *) x_vector);   return(scaled_image);g }p l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %>O %                                                                             %oO %                                                                             %PO %   S e t I m a g e I n f o                                                   % O %                                                                             %dO %                                                                             %_O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function SetImageInfo initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix or I %  suffix of the filename.  For example, `ps:image' returns PS indicating H %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.M %  The filename prefix has precedance over the suffix.  Use an optional index L %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).  % - %  The format of the SetImageInfo routine is:  %  %      SetImageInfo(image_info)  % + %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %% %% */ void SetImageInfo(image_info) 	 ImageInfoo   *image_info; { 
   static chart     *ImageFormats[][2]=n     {        "AVS", "False",a       "BIE", "False",e       "BMP", "True",       "CMYK", "False",       "EPS", "True",       "EPSF", "True",f       "EPSI", "True",r       "FAX", "True",       "FITS", "False",       "FTP", "False",r       "GIF", "True",       "GIF87", "False",f       "GOPHER", "False",       "GRAY", "False",       "G3", "False",       "HDF", "True",       "HISTOGRAM", "False",r       "HTML", "False",       "HTTP", "False",       "JBIG", "True",r       "JPEG", "False",       "JPG", "False",I       "LOGO", "False",       "MAP", "False",l       "MATTE", "False",i       "MIFF", "True",        "MPG", "True",       "MPEG", "False",       "MTV", "True",       "NULL", "False",       "PBM", "True",       "PCD", "False",t       "PCX", "True",       "PDF", "False",i       "PGM", "True",       "PICT", "False",       "PM", "False",       "PNG", "False",o       "PPM", "True",       "PNM", "True",       "PS", "True",        "PS2", "True",       "RAD", "False",t       "RAS", "True",       "RGB", "False",        "RGBA", "False",       "RLE", "False",n       "SGI", "True",       "SUN", "True",       "TGA", "True",       "TEXT", "False",       "TIF", "True",       "TIFF", "True",e       "TILE", "False",       "TMP", "False",a       "UYVY", "False",       "VICAR", "False",;       "VID", "False",i       "VIFF", "True",u       "X", "False",        "XBM", "False",e       "XC", "False",       "XPM", "False",r       "XV", "True",        "XWD", "False",x       "YUV", "False",e       "YUV3", "False","       (char *) NULL, (char *) NULL     };     char     c,     magick[MaxTextLength];     register char      *p,c     *q;+     register int     i;     /*(     Look for 'image.format' in filename.   */   *magick='\0'; 8   p=image_info->filename+strlen(image_info->filename)-1;   if (*p == ']')     {        /*F         Look for sub-image enclosed in brackets (e.g. img0001.pcd[4]).       */0       for (q=p-1; q > image_info->filename; q--)(         if (!isdigit(*q) && (*q != '-'))           break;       if (*q == '[')	         {o           p=q++;'           image_info->subimage=atoi(q);r'           image_info->subrange=atoi(q); O           (void) sscanf(q,"%u-%u",&image_info->subimage,&image_info->subrange);%7           image_info->subrange-=image_info->subimage-1;            *p='\0';	         }      } 3   while ((*p != '.') && (p > image_info->filename))      p--;6   if ((strcmp(p,".gz") == 0) || (strcmp(p,".Z") == 0))     do     { 
       p--;8     } while ((*p != '.') && (p > image_info->filename));2   if ((*p == '.') && (strlen(p) < sizeof(magick)))     {        /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)        {          if (*q == '.')           {              *q='\0';             break;           }%         c=(*q);%%         if (isascii(c) && islower(c))%           *q=toupper(c);       } 9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)h3         if (strcmp(magick,ImageFormats[i][0]) == 0)            {m             /*(               SGI and RGB are ambiguous.             */=             if ((strncmp(image_info->magick,"SGI",3) != 0) ||I8                 (strcmp(ImageFormats[i][0],"RGB") != 0))7               (void) strcpy(image_info->magick,magick);s             break;           }a     }f   /*1     Look for explicit 'format:image' in filename.    */   image_info->assert=False;    p=image_info->filename;o%   while ((*p != ':') && (*p != '\0'))I     p++;A   if ((*p == ':') && ((p-image_info->filename) < sizeof(magick)))e     {        /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename); *       magick[p-image_info->filename]='\0';%       for (q=magick; *q != '\0'; q++)i       {          c=(*q);g%         if (isascii(c) && islower(c))>           *q=toupper(c);       }=9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)i3         if (strcmp(magick,ImageFormats[i][0]) == 0)g           {              /*,               Strip off image format prefix.             */             p++;2             (void) strcpy(image_info->filename,p);5             (void) strcpy(image_info->magick,magick); *             if (strcmp(magick,"TMP") != 0)&               image_info->assert=True;             break;           }      }n   /*3     Determine if format supports multi-image files.    */5   for (i=0; ImageFormats[i][0] != (char *) NULL; i++)p;     if (strcmp(image_info->magick,ImageFormats[i][0]) == 0)r5       image_info->adjoin&=IsTrue(ImageFormats[i][1]);=0   if ((strcmp(image_info->magick,"MPG") == 0) ||/       (strcmp(image_info->magick,"MPEG") == 0))      image_info->adjoin=True; }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %iO %                                                                             % O %     S h a r p e n I m a g e                                                 %(O %                                                                             %nO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function SharpenImage creates a new image that is a copy of an existingL %  one with the pixels sharpened.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % K %  SharpenImage convolves the pixel neighborhood with this sharpening mask:  % 
 %    -1 -2 -1 
 %    -2  W -2 
 %    -1 -2 -1r % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.o %r- %  The format of the SharpenImage routine is:  %o1 %      sharpened_image=SharpenImage(image,factor)  %e+ %  A description of each parameter follows:t %sL %    o sharpened_image: Function SharpenImage returns a pointer to the imageL %      after it is sharpened.  A null image is returned if there is a memory %      shortage. %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.i %eL %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */! Image *SharpenImage(image,factor)t Imagem	   *image;t   double	   factor;f {s #define Sharpen(weight) \a'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \i)   total_blue+=(weight)*(int) (s->blue); \ +   total_index+=(weight)*(int) (s->index); \_   s++;3 #define SharpenImageText  "  Sharpening image...  "      Image      *sharpened_image;g  
   long int     total_blue,      total_green,     total_index,     total_red,     weight;      register RunlengthPacket     *p,      *q,      *s,m     *s0,     *s1,     *s2;     register unsigned intm     x;     RunlengthPacket      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { F       Warning("Unable to sharpen image","image size must exceed 3x3");       return((Image *) NULL);o     }e   /**     Initialize sharpened image attributes.   */D   sharpened_image=CopyImage(image,image->columns,image->rows,False);(   if (sharpened_image == (Image *) NULL)     {eD       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);a     }g%   sharpened_image->class=DirectClass;p   /*6     Allocate scan line buffer for 3 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(3*(image->columns+1)*sizeof(RunlengthPacket));a+   if (scanline == (RunlengthPacket *) NULL)e     {lD       Warning("Unable to enhance image","Memory allocation failed");$       DestroyImage(sharpened_image);       return((Image *) NULL);i     }t   /*)     Read the first two rows of the image.e   */   p=image->pixels;   image->runlength=p->length+1; ,   for (x=0; x < (3*(image->columns+1)); x++)     scanline[x]=(*p);e
   s=scanline;g+   for (x=0; x < (image->columns << 1); x++)g   {i     if (image->runlength != 0)       image->runlength--;e     else       {f         p++;#         image->runlength=p->length;_       }d     *s=(*p);     s++;   }x   /*!     Dump first scanline of image.u   */   q=sharpened_image->pixels;
   s=scanline;=$   for (x=0; x < image->columns; x++)   {m     *q=(*s);     q->index=0;_     q->length=0;     q++;     s++;   }y   /*     Convolve each row.   */*   weight=(long int) ((100.0-factor)/2+13);   quantum=Max(weight-12,1);o%   for (y=1; y < (image->rows-1); y++);   {_     /*)       Initialize sliding window pointers.x     */+     s0=scanline+image->columns*((y-1) % 3);e'     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);0     /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {+        if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }+     /*+       Transfer first pixel of the scanline.s     */
     *q=(*s1);      q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;o       total_index=0;       s=s0;a,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       s=s1;h0       Sharpen(-2); Sharpen(weight); Sharpen(-2);       s=s2;n,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       if (total_red < 0)         q->red=0;+
       else)         if (total_red > (MaxRGB*quantum))f           q->red=MaxRGB;         else@           q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);       if (total_green < 0)         q->green=0;/
       else+         if (total_green > (MaxRGB*quantum))f           q->green=MaxRGB;         elseD           q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);       if (total_blue < 0)          q->blue=0;
       else*         if (total_blue > (MaxRGB*quantum))           q->blue=MaxRGB;e         elseB           q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       if (total_index < 0)         q->index=0;x
       else+         if (total_index > (MaxRGB*quantum))u           q->index=MaxRGB;         elseK           q->index=(unsigned short) ((total_index+(quantum >> 1))/quantum);n       q->length=0;
       q++;       s0++;        s1++;o       s2++;;     }      /**       Transfer last pixel of the scanline.     */	     s1++;x
     *q=(*s1);+     q->length=0;     q++;6     ProgressMonitor(SharpenImageText,y,image->rows-1);   }+   /*!     Dump last scanline of pixels.    */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {d     *q=(*s);     q->length=0;     q++;     s++;   }    free((char *) scanline);   return(sharpened_image); }+ a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %_O %                                                                             %;O %   S o r t C o l o r m a p B y I n t e n t s i t y                           %)O %                                                                             %dO %                                                                             %fO %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eM %  Function SortColormapByIntensity sorts the colormap of a PseudoClass image ! %  by decreasing color intensity.  % 8 %  The format of the SortColormapByIntensity routine is: % % %      SortColormapByIntensity(image)  % + %  A description of each parameter follows:  % - %    o image: A pointer to a Image structure.  %  %  */  static int IntensityCompare(x,y)
 const void   *x,    *y;  { 
   ColorPacket%
     *color_1,%
     *color_2;%     color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }y  # void SortColormapByIntensity(image)n Image 	   *image;G {a   register int     i;     register RunlengthPacket     *p;o     register unsigned shortd
     index;     unsigned short     *pixels;  "   if (image->class != PseudoClass)     return;c   /*&     Allocate memory for pixel indexes.   */I   pixels=(unsigned short *) malloc(image->colors*sizeof(unsigned short));g(   if (pixels == (unsigned short *) NULL)     {eD       Warning("Unable to sort colormap","Memory allocation failed");
       return;a     }    /*,     Assign index values to colormap entries.   */#   for (i=0; i < image->colors; i++)e0     image->colormap[i].index=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.l   */I   qsort((void *) image->colormap,(int) image->colors,sizeof(ColorPacket),eG     (int (*) _Declare((const void *, const void *))) IntensityCompare);l   /*;     Update image colormap indexes to sorted colormap order.m   */#   for (i=0; i < image->colors; i++) 8     pixels[image->colormap[i].index]=(unsigned short) i;   p=image->pixels;$   for (i=0; i < image->packets; i++)   {a     index=pixels[p->index];i&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p->index=index;;     p++;   }    free((char *) pixels); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %fO %                                                                             %)O %     S p r e a d I m a g e                                                   %_O %                                                                             %.O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%] %dI %  Function SpreadImage creates a new image that is a copy of an existing[I %  one with the image pixels randomly displaced.  It allocates the memory I %  necessary for the new Image structure and returns a pointer to the new 	 %  image.  %e, %  The format of the SpreadImage routine is: %o- %      spread_image=SpreadImage(image,amount)i % + %  A description of each parameter follows:m %-H %    o spread_image: Function SpreadImage returns a pointer to the imageI %      after it is spread.  A null image is returned if there is a memory- %      shortage. %mF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % K %    o amount:  An unsigned value constraining the "vicintity" for choosingu %      a random pixel to swap. %m %a */  Image *SpreadImage(image,amount) Image%	   *image;%   unsigned int	   amount;% {%1 #define SpreadImageText  "  Spreading image...  "      Image      *spread_image;     long     quantum,     x_distance,      y_distance;      register RunlengthPacket     *p,      *q;      register unsigned int      x;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to spread image","image size must exceed 3x3");        return((Image *) NULL);      }    if (!UncompressImage(image))     return((Image *) NULL);    /*'     Initialize spread image attributes.    */A   spread_image=CopyImage(image,image->columns,image->rows,False);%%   if (spread_image == (Image *) NULL)%     {%D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);t     }n"   spread_image->class=DirectClass;   /*     Convolve each row.   */   srand(time((time_t *) NULL));r   amount++;(   quantum=amount >> 1;   q=spread_image->pixels;n!   for (y=0; y < image->rows; y++)o   {t&     for (x=0; x < image->columns; x++)     {a+       x_distance=(rand() & amount)-quantum;a+       y_distance=(rand() & amount)-quantum;aC       p=image->pixels+(y+y_distance)*image->columns+(x+x_distance);iF       if ((p > image->pixels) && (p < (image->pixels+image->packets)))         *q=(*p);
       q++;     }n3     ProgressMonitor(SpreadImageText,y,image->rows);i   }e   return(spread_image);a }i - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   S t e r e o I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%L %  Function StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The lefttH %  image is converted to grayscale and written to the red channel of theN %  stereo image.  The right image is converted to grayscale and written to theL %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect.e %h, %  The format of the StereoImage routine is: %i7 %      stereo_image=StereoImage(left_image,right_image)i %"+ %  A description of each parameter follows:- %lI %    o stereo_image: Function StereoImage returns a pointer to the stereomF %      image.  A null image is returned if there is a memory shortage. %n< %    o left_image: The address of a structure of type Image. %m= %    o right_image: The address of a structure of type Image.U %t %  */* Image *StereoImage(left_image,right_image) Imagen   *left_image,   *right_image;u { . #define StereoImageText  "  Stereo image...  "     Imageo     *stereo_image;     into     y;     register int     x;     register RunlengthPacket     *p,l     *q,m     *r;>  6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     {%.       Warning("Unable to create stereo image",-         "left and right image sizes differ");        return((Image *) NULL);      }    /*'     Initialize stereo image attributes.    */P   stereo_image=CopyImage(left_image,left_image->columns,left_image->rows,False);%   if (stereo_image == (Image *) NULL)      { J       Warning("Unable to create stereo image","Memory allocation failed");       return((Image *) NULL);      } "   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.%   */7   QuantizeImage(left_image,256,8,False,GRAYColorspace);e   SyncImage(left_image);   p=left_image->pixels;F$   left_image->runlength=p->length+1;8   QuantizeImage(right_image,256,8,False,GRAYColorspace);   SyncImage(right_image);I   q=right_image->pixels;%   right_image->runlength=q->length+1;    r=stereo_image->pixels;r(   for (y=0; y < stereo_image->rows; y++)   {s-     for (x=0; x < stereo_image->columns; x++)e     { %       if (left_image->runlength != 0)           left_image->runlength--;
       else	         {r           p++;*           left_image->runlength=p->length;	         }e&       if (right_image->runlength != 0)!         right_image->runlength--;r
       else	         {e           q++;+           right_image->runlength=q->length;w	         }--       r->red=(unsigned int) (p->red*12) >> 4;        r->green=0;e       r->blue=q->blue;       r->index=0;-       r->length=0;
       r++;     } :     ProgressMonitor(StereoImageText,y,stereo_image->rows);   }    return(stereo_image);p }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %QO %                                                                             % O %                                                                             %lO %   S y n c I m a g e                                                         %rO %                                                                             %eO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. % * %  The format of the SyncImage routine is: %  %      SyncImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void SyncImage(image)  Image 	   *image;  {    register int     i;     register RunlengthPacket     *p;%     register unsigned short%
     index;  #   for (i=0; i < image->colors; i++)w   {F     image->colormap[i].index=0;      image->colormap[i].flags=0;l   }c   p=image->pixels;$   for (i=0; i < image->packets; i++)   {m     index=p->index;s&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p++;   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %TO %                                                                             % O %     T e x t u r e I m a g e                                                 %sO %                                                                             %tO %                                                                             %aO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %(J %  Function TextureImage layers a texture onto the background of an image. % - %  The format of the TextureImage routine is:' %;# %      TextureImage(image,filename)I % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % K %    o filename: This file contains the texture to layer on the background.e %i %, */! void TextureImage(image,filename)  Image 	   *image;x   char   *filename; {=8 #define TextureImageText  "  Appling image texture...  "     Image      *texture_image;      ImageInfo;     texture_info;E     int      x,     y;      if (filename == (char *) NULL)     return;    /*     Read the texture image.g   */   GetImageInfo(&texture_info);0   (void) strcpy(texture_info.filename,filename);)   texture_image=ReadImage(&texture_info);;&   if (texture_image == (Image *) NULL)     return;    /*+     Tile texture onto the image background.)   */4   for (y=0; y < image->rows; y+=texture_image->rows)   { <     for (x=0; x < image->columns; x+=texture_image->columns)A       CompositeImage(image,ReplaceCompositeOp,texture_image,x,y);*4     ProgressMonitor(TextureImageText,y,image->rows);   };   DestroyImage(texture_image); }g ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %(O %                                                                             % O %                                                                             %-O %   T r a n s f o r m I m a g e                                               %lO %                                                                             % O %                                                                             %+O %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%' % L %  Function TransformImage creates a new image that is a transformed size ofE %  of existing one as specified by the crop and image geometries.  ItlK %  allocates the memory necessary for the new Image structure and returns ap %  pointer to the new image. % H %  If a crop geometry is specified a subregion of the image is obtained.M %  If the specified image size, as defined by the image and scale geometries,;K %  is smaller than the actual image size, the image is first minified to an N %  integral of the specified image size with an antialias digital filter.  TheD %  image is then scaled to the exact specified image size with pixelM %  replication.  If the specified image size is greater than the actual imageeJ %  size, the image is first enlarged to an integral of the specified imageK %  size with bilinear interpolation.  The image is then scaled to the exactr/ %  specified image size with pixel replication.  %e/ %  The format of the TransformImage routine is:+ %p9 %      TransformImage(image,crop_geometry,image_geometry)b %=+ %  A description of each parameter follows:l %oJ %    o image: The address of an address of a structure of type Image.  The7 %      transformed image is returned as this parameter.t %*D %    o crop_geometry: Specifies a pointer to a crop geometry string.6 %      This geometry defines a subregion of the image. % F %    o image_geometry: Specifies a pointer to a image geometry string.K %      The specified width and height of this geometry string are absolute.  %  %  */7 void TransformImage(image,crop_geometry,image_geometry)  Image 
   **image;   char   *crop_geometry,    *image_geometry; {    Image      *transformed_image;      int 
     flags;     unsigned int     height,      sharpen,
     width;     transformed_image=(*image); %   if (crop_geometry != (char *) NULL)      {        Image          *cropped_image;%         RectangleInfo%         crop_info;         /*,         Crop image to a user specified size.       */       crop_info.x=0;       crop_info.y=0;       flags=O         XParseGeometry(crop_geometry,&crop_info.x,&crop_info.y,&width,&height);u$       if ((flags & WidthValue) == 0)L         width=(unsigned int) ((int) transformed_image->columns-crop_info.x);%       if ((flags & HeightValue) == 0)aJ         height=(unsigned int) ((int) transformed_image->rows-crop_info.y);#       if ((flags & XNegative) != 0)f6         crop_info.x+=transformed_image->columns-width;#       if ((flags & YNegative) != 0)r4         crop_info.y+=transformed_image->rows-height;5       if (strchr(crop_geometry,'%') != (char *) NULL)e	         {            /*4             Crop geometry is relative to image size.           */;           ParseImageGeometry(crop_geometry,&width,&height);e1           if (width > transformed_image->columns)m-             width=transformed_image->columns; /           if (height > transformed_image->rows)m+             height=transformed_image->rows;t!           crop_info.x=width >> 1;g"           crop_info.y=height >> 1;1           width=transformed_image->columns-width;e0           height=transformed_image->rows-height;	         }        crop_info.width=width;       crop_info.height=height;*       if ((width == 0) || (height == 0) ||=           ((flags & XValue) != 0) || ((flags & YValue) != 0))N>         cropped_image=CropImage(transformed_image,&crop_info);
       else	         {            Image              *next_image;             register int             x,             y;             /*8             Crop repeatedly to create uniform subimages.           */'           cropped_image=(Image *) NULL; ;           for (y=0; y < transformed_image->rows; y+=height)            {g?             for (x=0; x < transformed_image->columns; x+=width)n
             {+$               crop_info.width=width;&               crop_info.height=height;               crop_info.x=x;               crop_info.y=y;A               next_image=CropImage(transformed_image,&crop_info);a/               if (next_image == (Image *) NULL)(                 break;2               if (cropped_image == (Image *) NULL)                 {;+                   cropped_image=next_image;-                   continue;                  } -               cropped_image->next=next_image;)1               next_image->previous=cropped_image;(0               cropped_image=cropped_image->next;
             }(-             if (next_image == (Image *) NULL)                break;           }(	         }-*       if (cropped_image != (Image *) NULL)	         { *           DestroyImage(transformed_image);;           while (cropped_image->previous != (Image *) NULL)u2             cropped_image=cropped_image->previous;*           transformed_image=cropped_image;	         }u     }    /*)     Scale image to a user specified size.    */#   width=transformed_image->columns;>!   height=transformed_image->rows; 4   ParseImageGeometry(image_geometry,&width,&height);P   sharpen=(width*height) < (transformed_image->rows*transformed_image->columns);.   if ((transformed_image->columns != width) ||*       (transformed_image->rows != height))     {        Image          *zoomed_image;         /*         Zoom image.)       */L       zoomed_image=ZoomImage(transformed_image,width,height,MitchellFilter);)       if (zoomed_image == (Image *) NULL) @         zoomed_image=ScaleImage(transformed_image,width,height);)       if (zoomed_image != (Image *) NULL)e	         {(*           DestroyImage(transformed_image);)           transformed_image=zoomed_image; 	         }      }    if (sharpen)L     if ((transformed_image->columns >= 3) && (transformed_image->rows >= 3))       {;
         Image(           *sharpened_image;)  
         /*           Sharpen image.
         */F         sharpened_image=SharpenImage(transformed_image,SharpenFactor);.         if (sharpened_image != (Image *) NULL)           {(,             DestroyImage(transformed_image);.             transformed_image=sharpened_image;           }d       })   *image=transformed_image;) }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%yO %                                                                             %gO %                                                                             %mO %     T r a n s f o r m R G B I m a g e                                       %+O %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  the L %  weights are rescaled to normalized the range of the transformed values to %  be [0..MaxRGB]. % 2 %  The format of the TransformRGBImage routine is: % * %      TransformRGBImage(image,colorspace) % + %  A description of each parameter follows:% %%F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %tJ %    o colorspace: An unsigned integer value that indicates the colorspaceD %      the image is currently in.  On return the image is in the RGB %      color space.M %f %a */( void TransformRGBImage(image,colorspace) Imageg	   *image;i   unsigned int
   colorspace;a {4 #define B (MaxRGB+1)*2 #define G (MaxRGB+1) #define R 0eA #define TransformRGBImageText  "  Transforming image colors...  "e     static QuantumJ     PCDMap[348] =  /* Photo CD information beyond 100% white, Gamma 2.2 */     { K         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  11,  12,  13,  14,pK        15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,eK        29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42, K        43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  55,oK        56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  66,  67,  68,nK        69,  70,  71,  72,  73,  74,  75,  76,  76,  77,  78,  79,  80,  81,sK        82,  83,  84,  84,  85,  86,  87,  88,  89,  90,  91,  92,  92,  93,iK        94,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 105, 106, K       106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 115, 116, 117, 118,iK       119, 120, 121, 122, 122, 123, 124, 125, 126, 127, 128, 129, 129, 130,aK       131, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140, 141, 142, 142,eK       143, 144, 145, 146, 147, 148, 148, 149, 150, 151, 152, 153, 153, 154,iK       155, 156, 157, 158, 158, 159, 160, 161, 162, 163, 164, 165, 165, 166,iK       167, 168, 169, 170, 171, 172, 173, 173, 174, 175, 176, 177, 178, 178, K       179, 180, 181, 182, 182, 183, 184, 185, 186, 186, 187, 188, 189, 190, K       191, 192, 193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, K       204, 205, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 215,rK       216, 216, 217, 218, 219, 220, 221, 221, 222, 223, 224, 225, 225, 226,_K       227, 228, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, K       237, 237, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, K       245, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249,)K       250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252,=K       253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254,eK       254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,o@       254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255     };     long
     *blue,     *green,=	     *red;;  	   Quantumi     *range_table;-     register int     i,     x,     y,     z;     register Quantum     *range_limit;*     register RunlengthPacket     *p;e  F   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace))     return;m   /*     Allocate the tables.   */1   red=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); 3   green=(long *) malloc(3*(MaxRGB+1)*sizeof(long));y2   blue=(long *) malloc(3*(MaxRGB+1)*sizeof(long));?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));a;   if ((red == (long *) NULL) || (green == (long *) NULL) || C       (blue == (long *) NULL) || (range_table == (Quantum *) NULL)))     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }m   /*     Initialize tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0;-*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;    } %   range_limit=range_table+(MaxRGB+1);e   switch (colorspace)=   {i     case OHTAColorspace:     {        /*         Initialize OHTA tables:   &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0-         through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)        {l&         red[i+R]=UpShifted(1.00000)*i;;         green[i+R]=UpShifted(1.0000*0.5)*((i << 1)-MaxRGB); >         blue[i+R]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);&         red[i+G]=UpShifted(1.00000)*i;         green[i+G]=0; ;         blue[i+G]=UpShifted(1.33333*0.5)*((i << 1)-MaxRGB); &         red[i+B]=UpShifted(1.00000)*i;?         green[i+B]=(-UpShifted(1.00000*0.5))*((i << 1)-MaxRGB); >         blue[i+B]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);       }        break;     }n     case XYZColorspace:      {%       /*"         Initialize CIE XYZ tables:  /           R =  3.240479*R-1.537150*G-0.498535*B /           G = -0.969256*R+1.875992*G+0.041556*B2/           B =  0.055648*R-0.204043*G+1.057311*Be       */!       for (i=0; i <= MaxRGB; i++)        { '         red[i+R]=UpShifted(3.240479)*i;e,         green[i+R]=(-UpShifted(1.537150))*i;+         blue[i+R]=(-UpShifted(0.498535))*i; *         red[i+G]=(-UpShifted(0.969256))*i;)         green[i+G]=UpShifted(1.875992)*i;3(         blue[i+G]=UpShifted(0.041556)*i;'         red[i+B]=UpShifted(0.055648)*i;M,         green[i+B]=(-UpShifted(0.204043))*i;(         blue[i+B]=UpShifted(1.057311)*i;       }        break;     }3     case YCbCrColorspace:M     {)       /*          Initialize YCbCr tables:  '           R = Y            +1.370707*Cr_'           G = Y-0.336453*Cb-0.698195*Cro           B = Y+1.732445*Cbl  O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0)         through MaxRGB.=       */!       for (i=0; i <= MaxRGB; i++)q       {&'         red[i+R]=UpShifted(1.000000)*i;          green[i+R]=0;h<         blue[i+R]=UpShifted(1.370707*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i; @         green[i+G]=(-UpShifted(0.336453*0.5))*((i << 1)-MaxRGB);?         blue[i+G]=(-UpShifted(0.698195*0.5))*((i << 1)-MaxRGB);a'         red[i+B]=UpShifted(1.000000)*i;>=         green[i+B]=UpShifted(1.732445*0.5)*((i << 1)-MaxRGB);i         blue[i+B]=0;       }z       break;     };     case YCCColorspace:i     {e       /*         Initialize YCC tables:  '           R = Y            +1.340762*C2('           G = Y-0.317038*C1-0.682243*C2o           B = Y+1.632639*C1   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++)i       {a%         red[i+R]=UpShifted(1.3584)*i;          green[i+R]=0; 5         blue[i+R]=UpShifted(1.8215)*(i-UpScale(137));-%         red[i+G]=UpShifted(1.3584)*i;o?         green[i+G]=(-UpShifted(0.194*2.2179))*(i-UpScale(156));(>         blue[i+G]=(-UpShifted(0.509*1.8215))*(i-UpScale(137));%         red[i+B]=UpShifted(1.3584)*i;-6         green[i+B]=UpShifted(2.2179)*(i-UpScale(156));         blue[i+B]=0;J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       }%$       for ( ; i < UpScale(348); i++)J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       break;     }      case YIQColorspace:      {        /*         Initialize YIQ tables:  +           R = 0.97087*Y+1.17782*I+0.59800*Q +           G = 0.97087*Y-0.28626*I-0.72851*Q +           B = 0.97087*Y-1.27870*I+1.72801*Q   M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)        { &         red[i+R]=UpShifted(0.97087)*i;<         green[i+R]=UpShifted(1.17782*0.5)*((i << 1)-MaxRGB);;         blue[i+R]=UpShifted(0.59800*0.5)*((i << 1)-MaxRGB); &         red[i+G]=UpShifted(0.97087)*i;?         green[i+G]=(-UpShifted(0.28626*0.5))*((i << 1)-MaxRGB);:>         blue[i+G]=(-UpShifted(0.72851*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(0.97087)*i;?         green[i+B]=(-UpShifted(1.27870*0.5))*((i << 1)-MaxRGB); ;         blue[i+B]=UpShifted(1.72801*0.5)*((i << 1)-MaxRGB);n       }t       break;     }h     case YPbPrColorspace:d     {n       /*          Initialize YPbPr tables:  '           R = Y            +1.402000*C2e'           G = Y-0.344136*C1+0.714136*C2n           B = Y+1.772000*C1(  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.,       */!       for (i=0; i <= MaxRGB; i++)e       {l'         red[i+R]=UpShifted(1.000000)*i;          green[i+R]=0;e<         blue[i+R]=UpShifted(1.402000*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i;0@         green[i+G]=(-UpShifted(0.344136*0.5))*((i << 1)-MaxRGB);<         blue[i+G]=UpShifted(0.714136*0.5)*((i << 1)-MaxRGB);'         red[i+B]=UpShifted(1.000000)*i;n=         green[i+B]=UpShifted(1.772000*0.5)*((i << 1)-MaxRGB);0         blue[i+B]=0;       }        break;     }e     case YUVColorspace:(     default:     {u       /*         Initialize YUV tables:  #           R = Y          +1.13980*V #           G = Y-0.39380*U-0.58050*Ve           B = Y+2.02790*U   M         U and V, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)e       {g&         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0;t;         blue[i+R]=UpShifted(1.13980*0.5)*((i << 1)-MaxRGB);*&         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.39380*0.5))*((i << 1)-MaxRGB);n>         blue[i+G]=(-UpShifted(0.58050*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(2.02790*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }a       break;     }r   }a   /*     Convert to RGB.    */   switch (image->class)0   {      case DirectClass:      {        /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          x=p->red;m         y=p->green;g         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];PG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];aF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;!         if (QuantumTick(i,image))rB           ProgressMonitor(TransformRGBImageText,i,image->packets);       }        break;     }p     case PseudoClass:m     {g       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)%       {%!         x=image->colormap[i].red; #         y=image->colormap[i].green; "         z=image->colormap[i].blue;         image->colormap[i].red= @           range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];!         image->colormap[i].green= @           range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];          image->colormap[i].blue=@           range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       {          x=p->red;%         y=p->green;%         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];iG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];iF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }g       break;     }    }s   /*     Free allocated memory.   */   free((char *) range_table);a   free((char *) blue);   free((char *) green);g   free((char *) red);t }n t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %mO %                                                                             %mO %     T r a n s p a r e n t I m a g e                                         % O %                                                                             %mO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opaque.  Any pixel; %  that matches the specified color are set to transparent.e %l1 %  The format of the TransparentImage routine is:e %L$ %      TransparentImage(image,color) %r+ %  A description of each parameter follows:b %)F %    o image: The address of a structure of type Image;  returned from %      ReadImage.o %eB %    o color: A character string that contain an X11 color string. %  %a */" void TransparentImage(image,color) Imager	   *image;    char	   *color;  {o #define DeltaX  16M #define TransparentImageText  "  Setting transparent color in the image...  "c     register int     i;  	   Quantumc	     blue, 
     green,     red;     register RunlengthPacket     *p;      unsigned int     status;e     XColor     target_color;      /*2     Determine RGB values of the transparent color.   */2   status=XQueryColorDatabase(color,&target_color);   if (status == False)     return;a#   red=XDownScale(target_color.red); '   green=XDownScale(target_color.green); %   blue=XDownScale(target_color.blue);f   /*!     Make image color transparent.f   */   p=image->pixels;   switch (image->class)    {b     case DirectClass:      {        /*+         Make DirectClass image transparent.        */       if (!image->matte)	         {r           /*-             Initialize image matte to opaque.c           */,           for (i=0; i < image->packets; i++)           {              p->index=Opaque;             p++;           }e           image->matte=True;           p=image->pixels;	         }e(       for (i=0; i < image->packets; i++)       { 2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           p->index=Transparent;s         p++;!         if (QuantumTick(i,image))gA           ProgressMonitor(TransparentImageText,i,image->packets);b       }o       break;     }      case PseudoClass:!     {e       double         distance_squared,t         min_distance;   	       intr         distance;e         register int         index;         /*         Find closest color.        */-       min_distance=3.0*(MaxRGB+1)*(MaxRGB+1);        index=0;'       for (i=0; i < image->colors; i++)        { 8         distance=(int) red-(int) image->colormap[i].red;<         distance_squared=(unsigned int) (distance*distance);<         distance=(int) green-(int) image->colormap[i].green;=         distance_squared+=(unsigned int) (distance*distance); :         distance=(int) blue-(int) image->colormap[i].blue;=         distance_squared+=(unsigned int) (distance*distance); ,         if (distance_squared < min_distance)           {t*             min_distance=distance_squared;             index=i;           }        }l       /*+         Make PseudoClass image transparent.        */       image->class=DirectClass;        image->matte=True;(       for (i=0; i < image->packets; i++)       {g         if (p->index == index)           p->index=Transparent;r         else           p->index=Opaque;         p++;       }r       break;     }    }r }d h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %oO %                                                                             % O %                                                                             % O %   U n C o m p r e s s I m a g e                                             % O %                                                                             % O %                                                                             %pO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%' % L %  Function UncompressImage uncompresses runlength-encoded pixels packets to! %  a rectangular array of pixels.  %t0 %  The format of the UncompressImage routine is: %,$ %      status=UncompressImage(image) %p+ %  A description of each parameter follows:= %'D %    o status: Function UncompressImage returns True if the image is$ %      uncompressed otherwise False. % 7 %    o image: The address of a structure of type Image.  %  %  */# unsigned int UncompressImage(image)z Imageg	   *image;  {    register int     i,     j,     length;e     register RunlengthPacket     *p,      *q;e     RunlengthPacketn     *uncompressed_pixels;   5   if (image->packets == (image->columns*image->rows))i     return(True);    /*)     Uncompress runlength-encoded packets.o   */I   uncompressed_pixels=(RunlengthPacket *) realloc((char *) image->pixels, 8     image->columns*image->rows*sizeof(RunlengthPacket));6   if (uncompressed_pixels == (RunlengthPacket *) NULL)     return(False);$   image->pixels=uncompressed_pixels;#   p=image->pixels+image->packets-1;e5   q=uncompressed_pixels+image->columns*image->rows-1;p$   for (i=0; i < image->packets; i++)   {      length=p->length;!     for (j=0; j <= length; j++)      {        *q=(*p);       q->length=0;
       q--;     }e     p--;   } ,   image->packets=image->columns*image->rows;   return(True);" }t , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %fO %                                                                             %nO %                                                                             %eO %   Z o o m I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %iE %  Function ZoomImage creates a new image that is a scaled size of an E %  existing one.  It allocates the memory necessary for the new ImageEL %  structure and returns a pointer to the new image.  The Point filter givesM %  fast pixel replication, Triangle is equivalent to bi-linear interpolation, 7 %  and Mitchel giver slower, very high-quality results.( %n* %  The format of the ZoomImage routine is: % 8 %      zoomed_image=ZoomImage(image,columns,rows,filter) % + %  A description of each parameter follows:h %eL %    o zoomed_image: Function ZoomImage returns a pointer to the image afterH %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.q %iM %    o columns: An integer that specifies the number of columns in the zoomede
 %      image.  %fG %    o rows: An integer that specifies the number of rows in the scaledf
 %      image.  % G %    o filter: This unsigned integer is the filter type to used to zoomm %      the image.e %  %  */   static double Box(x) double   x; {    if ((x > -0.5) && (x <= 0.5))e     return(1.0);   return(0.0); }d   static double Mitchell(x)  double   x; {    double     b,     c;     b=1.0/3.0;   c=1.0/3.0;   if (x < 0)     x=(-x);    if (x < 1.0)     { N       x=(((12.0-9.0*b-6.0*c)*(x*x*x))+((-18.0+12.0*b+6.0*c)*x*x)+(6.0-2.0*b))/         6.0;       return(x);     }g
  if (x < 2.0)N    {K      x=(((-1.0*b-6.0*c)*(x*x*x))+((6.0*b+30.0*c)*x*x)+((-12.0*b-48.0*c)*x)+i        (8.0*b+24.0*c))/6.0;       return(x);     }   return(0.0); }t   static double Triangle(x)  double   x; {i   if (x < 0.0)     x=(-x);    if (x < 1.0)     return(1.0-x);   return(0.0); }=  + Image *ZoomImage(image,columns,rows,filter)e Image;	   *image;    unsigned int
   columns,   rows, 	   filter;  { - #define ZoomImageText  "  Zooming image...  "   "   typedef struct _ContributionInfo   {      intr       pixel;       long
       weight;e   } ContributionInfo;_     ContributionInfo     *contribution_info;_     double     center,f     filter_width,      scale_factor,&
     width,
     x_factor, 
     y_factor;h     Image_     *source_image,     *zoomed_image;     int      n,     y;     long     blue_weight,     green_weight,      index_weight,Y     red_weight,      weight;n  	   Quantuml     *range_table;e     register int     i,     j,     x;     register Quantum     *range_limit;t     register RunlengthPacket     *p,c     *q;r  $   if ((columns == 0) || (rows == 0))     {hB       Warning("Unable to zoom image","image dimensions are zero");       return((Image *) NULL);r     }o   /*     Image must be uncompressed.i   */   if (!UncompressImage(image))     return((Image *) NULL);G   /*'     Initialize zoomed image attributes.a   */3   zoomed_image=CopyImage(image,columns,rows,False);i%   if (zoomed_image == (Image *) NULL)r     {oA       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);5     }x"   zoomed_image->class=DirectClass;H   source_image=CopyImage(image,zoomed_image->columns,image->rows,False);%   if (source_image == (Image *) NULL)=     { A       Warning("Unable to zoom image","Memory allocation failed"); !       DestroyImage(zoomed_image);        return((Image *) NULL);_     }l   /*     Allocate the range table.r   */?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum)); &   if (range_table == (Quantum *) NULL)     {tA       Warning("Unable to zoom image","Memory allocation failed"); !       DestroyImage(source_image); !       DestroyImage(zoomed_image);        return((Image *) NULL);t     }=   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0;t*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;;   } %   range_limit=range_table+(MaxRGB+1);    /*     Allocate filter info list.   */   switch (filter)1   {=     case BoxFilter:      {_       FilterFunction=Box;c       filter_width=0.5;=       break;     }      case TriangleFilter:     {        FilterFunction=Triangle;       filter_width=1.0;        break;     }e     case MitchellFilter:     default:     {p       FilterFunction=Mitchell;       filter_width=2.0;l       break;     }    } B   x_factor=(double) zoomed_image->columns/(double) image->columns;<   y_factor=(double) zoomed_image->rows/(double) image->rows;9   width=Max(filter_width/x_factor,filter_width/y_factor);    if (width < filter_width)=     width=filter_width;a(   contribution_info=(ContributionInfo *)7     malloc((int) (width*2+1)*sizeof(ContributionInfo));e5   if (contribution_info == (ContributionInfo *) NULL)      { A       Warning("Unable to zoom image","Memory allocation failed"); !       free((char *) range_table);,!       DestroyImage(source_image); !       DestroyImage(zoomed_image);        return((Image *) NULL);      }u   /*;     Apply filter to zoom horizontally from image to source.a   */   width=filter_width;;   scale_factor=1.0;.   if (x_factor < 1.0)o     {)       width/=x_factor;       scale_factor/=x_factor;r     } +   for (x=0; x < source_image->columns; x++)l   {u     n=0;%     center=(double) (x+0.5)/x_factor;mG     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)g     {;
       j=i;       if (j < 0)         j=(-j);(
       else          if (j >= image->columns)&           j=(image->columns << 1)-j-1;#       contribution_info[n].pixel=j;o"       contribution_info[n].weight=O         UpShifted((*FilterFunction)((i-center+0.5)/scale_factor)/scale_factor); 
       n++;     }o     q=source_image->pixels+x; *     for (y=0; y < source_image->rows; y++)     {        red_weight=0.0;o       green_weight=0.0;        blue_weight=0.0;       index_weight=0.0;o       for (i=0; i < n; i++)t       {o+         weight=contribution_info[i].weight;oF         p=image->pixels+(y*image->columns)+contribution_info[i].pixel;"         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       })0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];4       q->index=range_limit[DownShift(index_weight)];       q->length=0;       q+=source_image->columns;      }pN     ProgressMonitor(ZoomImageText,x,source_image->columns+zoomed_image->rows);   }t   /*?     Apply filter to zoom vertically from source to destination.o   */   width=filter_width;t   scale_factor=1.0;t   if (y_factor < 1.0)      {        width/=y_factor;       scale_factor/=y_factor;n     }    q=zoomed_image->pixels;i(   for (y=0; y < zoomed_image->rows; y++)   {I     n=0;%     center=(double) (y+0.5)/y_factor;]G     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)0     { 
       j=i;       if (j < 0)         j=(-j); 
       else#        if (j >= source_image->rows) )          j=(source_image->rows << 1)-j-1;a#       contribution_info[n].pixel=j; "       contribution_info[n].weight=O         UpShifted((*FilterFunction)((i-center+0.5)/scale_factor)/scale_factor); 
       n++;     }i-     for (x=0; x < zoomed_image->columns; x++)      {t       red_weight=0.0;        green_weight=0.0;g       blue_weight=0.0;       index_weight=0.0;        for (i=0; i < n; i++)n       {y+         weight=contribution_info[i].weight;;         p=source_image->pixels+t?           (contribution_info[i].pixel*source_image->columns)+x; "         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       } 0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];4       q->index=range_limit[DownShift(index_weight)];       q->length=0;
       q++;     } M     ProgressMonitor(ZoomImageText,y+x,zoomed_image->rows+zoomed_image->rows);e   }l   /*     Free allocated memory.   */#   free((char *) contribution_info);e   free((char *) range_table);m   DestroyImage(source_image);    return(zoomed_image);a }e