 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                  W   W  IIIII  DDDD    GGGG  EEEEE  TTTTT                   % O %                  W   W    I    D   D  G      E        T                     % O %                  W W W    I    D   D  G  GG  EEE      T                     % O %                  WW WW    I    D   D  G   G  E        T                     % O %                  W   W  IIIII  DDDD    GGGG  EEEEE    T                     % O %                                                                             % O %                X11 User Interface Routines for ImageMagick.                 % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                              September 1993                                 % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"    /*   Define declarations. */, #define AreaIsActive(matte_info,position)  \>   ((position.y >= (matte_info.y-matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width)))- #define MatteIsActive(matte_info,position)  \ =   ((position.x >= (matte_info.x-matte_info.bevel_width)) && \ >    (position.y >= (matte_info.y-matte_info.bevel_width)) &&  \N    (position.x < (matte_info.x+matte_info.width+matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width)))/ #define WindowIsActive(window_info,position)  \ /   ((position.x >= 0) && (position.y >= 0) &&  \ I    (position.x < window_info.width) && (position.y < window_info.height))  /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002 # #define InactiveWidgetState  0x0004  #define JumpListState  0x0008 6 #define MaxTextWidth  (80*XTextWidth(font_info,"_",1))6 #define MinTextWidth  (26*XTextWidth(font_info,"_",1)): #define QuantumMargin  Max(font_info->max_bounds.width,12)! #define RedrawActionState  0x0010  #define RedrawListState  0x0020 ! #define RedrawWidgetState  0x0040 ( #define UpdateConfigurationState  0x0080 #define UpdateListState  0x0100    /*   Variable declarations. */ static XWidgetInfoM   monitor_info = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }, M   submenu_info = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }, L   toggle_info = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL };   /*   Function prototypes. */
 static int4   FontCompare _Declare((const void *,const void *)),6   XScreenEvent _Declare((Display *,XEvent *, char *));   static void ?   XDrawBevel _Declare((Display *,XWindowInfo *,XWidgetInfo *)), F   XDrawBeveledMatte _Declare((Display *,XWindowInfo *,XWidgetInfo *)),?   XDrawMatte _Declare((Display *,XWindowInfo *,XWidgetInfo *)), G   XDrawBeveledButton _Declare((Display *,XWindowInfo *,XWidgetInfo *)), C   XDrawMatteText _Declare((Display *,XWindowInfo *,XWidgetInfo *)), F   XDrawTriangleEast _Declare((Display *,XWindowInfo *,XWidgetInfo *)),G   XDrawTriangleNorth _Declare((Display *,XWindowInfo *,XWidgetInfo *)), G   XDrawTriangleSouth _Declare((Display *,XWindowInfo *,XWidgetInfo *)), D   XDrawWidgetText _Declare((Display *,XWindowInfo *,XWidgetInfo *)),L   XEditText _Declare((Display *,XWidgetInfo *,KeySym,char *,unsigned long)),2   XGetWidgetInfo _Declare((char *,XWidgetInfo *)),?   XHighlightWidget _Declare((Display *,XWindowInfo *,int,int)), B   XSetBevelColor _Declare((Display *,XWindowInfo *,unsigned int)),B   XSetMatteColor _Declare((Display *,XWindowInfo *,unsigned int)),A   XSetTextColor _Declare((Display *,XWindowInfo *,unsigned int));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawBevel "sets off" an area with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % , %  The format of the XDrawBevel function is: % 1 %      XDrawBevel(display,window_info,bevel_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o bevel_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the bevel.  %  %  */6 static void XDrawBevel(display,window_info,bevel_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *bevel_info; {    int      x1,      x2,      y1,      y2;      unsigned int     bevel_width;     XPoint     points[6];     /*'     Draw upper and left beveled border.    */   x1=bevel_info->x; &   y1=bevel_info->y+bevel_info->height;%   x2=bevel_info->x+bevel_info->width;    y2=bevel_info->y; &   bevel_width=bevel_info->bevel_width;   points[0].x=x1;    points[0].y=y1;    points[1].x=x1;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x1-bevel_width;    points[4].y=y2-bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; 9   XSetBevelColor(display,window_info,bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin);    /*(     Draw lower and right beveled border.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y1;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x2+bevel_width;    points[4].y=y1+bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; I   XSetBevelColor(display,window_info,(unsigned int) !bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d B u t t o n                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDrawBeveledButton draws a button with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawBeveledButton function is: % : %      XDrawBeveledButton(display,window_info,button_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o button_info: Specifies a pointer to a XWidgetInfo structure.  It * %      contains the extents of the button. %  %  */? static void XDrawBeveledButton(display,window_info,button_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *button_info;  {    int      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Draw matte.    */.   XDrawBevel(display,window_info,button_info);:   XSetMatteColor(display,window_info,button_info->raised);E   XFillRectangle(display,window_info->id,window_info->widget_context, J     button_info->x,button_info->y,button_info->width,button_info->height);.   x=button_info->x-button_info->bevel_width-1;.   y=button_info->y-button_info->bevel_width-1;5   XSetForeground(display,window_info->widget_context, 1     window_info->pixel_info->trough_color.pixel); 7   if (button_info->raised || (window_info->depth == 1)) K     XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, O       button_info->width+(button_info->bevel_width << 1)+1,button_info->height+ )       (button_info->bevel_width << 1)+1); )   if (button_info->text == (char *) NULL)      return;    /*     Set cropping region.   */%   crop_info.width=button_info->width; '   crop_info.height=button_info->height;    crop_info.x=button_info->x;    crop_info.y=button_info->y;    /*     Draw text.   */#   font_info=window_info->font_info; J   width=XTextWidth(font_info,button_info->text,strlen(button_info->text));(   x=button_info->x+(QuantumMargin >> 1);   if (button_info->center)<     x=button_info->x+(button_info->width >> 1)-(width >> 1);)   y=button_info->y+((button_info->height- D     (font_info->ascent+font_info->descent)) >> 1)+font_info->ascent;1   if (button_info->width == (QuantumMargin >> 1))      {        /*7         Option button-- write label to right of button.        */.       XSetTextColor(display,window_info,True);C       x=button_info->x+button_info->width+button_info->bevel_width+          (QuantumMargin >> 1); J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         button_info->text,strlen(button_info->text)); 
       return;      } J   XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,     Unsorted);9   XSetTextColor(display,window_info,button_info->raised); F   XDrawString(display,window_info->id,window_info->widget_context,x,y,1     button_info->text,strlen(button_info->text)); 9   XSetClipMask(display,window_info->widget_context,None);    if (!button_info->raised) %     XDelay(display,SuspendTime << 2);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d M a t t e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawBeveledMatte draws a matte with a shadowed upper and K %  left bevel and a highlighted lower and right bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawBeveledMatte function is:  % 8 %      XDrawBeveledMatte(display,window_info,matte_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */= static void XDrawBeveledMatte(display,window_info,matte_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */-   XDrawBevel(display,window_info,matte_info); -   XDrawMatte(display,window_info,matte_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawMatte fills a rectangular area with the matte color.  % , %  The format of the XDrawMatte function is: % 1 %      XDrawMatte(display,window_info,matte_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */6 static void XDrawMatte(display,window_info,matte_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */7   if (!matte_info->trough || (window_info->depth == 1)) J     XFillRectangle(display,window_info->id,window_info->highlight_context,H       matte_info->x,matte_info->y,matte_info->width,matte_info->height);   else     { 9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->trough_color.pixel); I       XFillRectangle(display,window_info->id,window_info->widget_context, J         matte_info->x,matte_info->y,matte_info->width,matte_info->height);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e T e x t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDrawMatteText draws a matte with text.  If the text exceeds theG %  extents of the text, a portion of the text relative to the cursor is 
 %  displayed.  % 0 %  The format of the XDrawMatteText function is: % 4 %      XDrawMatteText(display,window_info,text_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. %  %  */9 static void XDrawMatteText(display,window_info,text_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    char
     *text;     int      x,     y;     register int     i;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   */,   XSetMatteColor(display,window_info,False);E   XFillRectangle(display,window_info->id,window_info->widget_context, B     text_info->x,text_info->y,text_info->width,text_info->height);'   if (text_info->text == (char *) NULL)      return; :   XSetTextColor(display,window_info,text_info->highlight);#   font_info=window_info->font_info; &   x=text_info->x+(QuantumMargin >> 2);<   y=text_info->y+font_info->ascent+(text_info->height >> 2);.   width=text_info->width-(QuantumMargin >> 1);.   height=font_info->ascent+font_info->descent;   if (*text_info->text == '\0')      {        /*#         No text-- just draw cursor.        */L       XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,         x,y-height+3);
       return;      }    /*     Set cropping region.   */#   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*,     Determine beginning of the visible text.   */,   if (text_info->cursor < text_info->marker)(     text_info->marker=text_info->cursor;   else     {        text=text_info->marker; D       if (XTextWidth(font_info,text,text_info->cursor-text) > width)	         {            text=text_info->text; 0           for (i=0; i < (int) strlen(text); i++)O             if (XTextWidth(font_info,text+i,text_info->cursor-text-i) <= width)                break;#           text_info->marker=text+i; 	         }      }    /*     Draw text and cursor.    */   if (!text_info->highlight)     { N       XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,         Unsorted);J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         text_info->marker,strlen(text_info->marker)); =       XSetClipMask(display,window_info->widget_context,None);      }    else     { N       XSetClipRectangles(display,window_info->annotate_context,0,0,&crop_info,         1,Unsorted);N       width=XTextWidth(font_info,text_info->marker,strlen(text_info->marker));M       XFillRectangle(display,window_info->id,window_info->annotate_context,x, *         y-font_info->ascent,width,height);?       XSetClipMask(display,window_info->annotate_context,None); O       XSetClipRectangles(display,window_info->highlight_context,0,0,&crop_info,          1,Unsorted);M       XDrawString(display,window_info->id,window_info->highlight_context,x,y, 5         text_info->marker,strlen(text_info->marker)); @       XSetClipMask(display,window_info->highlight_context,None);     }    x+= P     XTextWidth(font_info,text_info->marker,text_info->cursor-text_info->marker);H   XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,     x,y-height+3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e E a s t                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawTriangleEast draws a triangle with a highlighted leftC %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawTriangleEast function is:  % ; %      XDrawTriangleEast(display,window_info,triangle_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */@ static void XDrawTriangleEast(display,window_info,triangle_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;  
   XFontStruct      *font_info;      XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;+   x2=triangle_info->x+triangle_info->width; 3   y2=triangle_info->y+(triangle_info->height >> 1);    x3=triangle_info->x;,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw bottom bevel.   */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3-bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2+bevel_width;    points[3].y=y2; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw Left bevel.   */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width+1;    points[2].y=y1-bevel_width;    points[3].x=x3-bevel_width+1;    points[3].y=y3+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2+bevel_width;    points[2].y=y2;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid); +   if (triangle_info->text == (char *) NULL)      return;    /*%     Write label to right of triangle.    */#   font_info=window_info->font_info; *   XSetTextColor(display,window_info,True);F   x1=triangle_info->x+triangle_info->width+triangle_info->bevel_width+     (QuantumMargin >> 1); .   y1=triangle_info->y+((triangle_info->height-D     (font_info->ascent+font_info->descent)) >> 1)+font_info->ascent;H   XDrawString(display,window_info->id,window_info->widget_context,x1,y1,5     triangle_info->text,strlen(triangle_info->text));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e N o r t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDrawTriangleNorth draws a triangle with a highlighted left C %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawTriangleNorth function is: % < %      XDrawTriangleNorth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleNorth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;,   y1=triangle_info->y+triangle_info->height;2   x2=triangle_info->x+(triangle_info->width >> 1);   y2=triangle_info->y;+   x3=triangle_info->x+triangle_info->width; ,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2-bevel_width-2;    points[3].x=x1-bevel_width-1;    points[3].y=y1+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3+bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2;    points[3].y=y2-bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw lower bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1+bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3+bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e S o u t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XDrawTriangleSouth draws a border with a highlighted left and H %  right bevel and a shadowed lower bevel.  The highlighted and shadowed %  bevels create a 3-D effect. % 4 %  The format of the XDrawTriangleSouth function is: % < %      XDrawTriangleSouth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleSouth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;2   x2=triangle_info->x+(triangle_info->width >> 1);,   y2=triangle_info->y+triangle_info->height;+   x3=triangle_info->x+triangle_info->width;    y3=triangle_info->y;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1-bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3+1;    points[1].y=y3-bevel_width;    points[2].x=x3+bevel_width;    points[2].y=y3-bevel_width;    points[3].x=x2;    points[3].y=y2+bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2+bevel_width;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w W i d g e t T e x t                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDrawWidgetText first clears the widget and draws a text string G %  justifed left (or center) in the x-direction and centered within the  %  y-direction.  % 1 %  The format of the XDrawWidgetText function is:  % 5 %      XDrawWidgetText(display,window_info,text_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowText structure.  % ? %    o text_info: Specifies a pointer to XWidgetInfo structure.  %  %  */: static void XDrawWidgetText(display,window_info,text_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    GC     widget_context;      int      x,     y;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   *//   widget_context=window_info->annotate_context;    if (text_info->raised)A     XClearArea(display,window_info->id,text_info->x,text_info->y, 0       text_info->width,text_info->height,False);   else     { I       XFillRectangle(display,window_info->id,widget_context,text_info->x, 9         text_info->y,text_info->width,text_info->height); 4       widget_context=window_info->highlight_context;     } '   if (text_info->text == (char *) NULL)      return;    if (*text_info->text == '\0')      return;    /*     Set cropping region.   */#   font_info=window_info->font_info; #   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*     Draw text.   */F   width=XTextWidth(font_info,text_info->text,strlen(text_info->text));&   x=text_info->x+(QuantumMargin >> 1);   if (text_info->center)8     x=text_info->x+(text_info->width >> 1)-(width >> 1);   if (text_info->raised)1     if (width > (text_info->width-QuantumMargin)) 0       x+=(text_info->width-QuantumMargin-width);.   height=font_info->ascent+font_info->descent;E   y=text_info->y+((text_info->height-height) >> 1)+font_info->ascent; G   XSetClipRectangles(display,widget_context,0,0,&crop_info,1,Unsorted); I   XDrawString(display,window_info->id,widget_context,x,y,text_info->text,      strlen(text_info->text)); ,   XSetClipMask(display,widget_context,None);   if (x < text_info->x) D     XDrawLine(display,window_info->id,window_info->annotate_context,O       text_info->x,text_info->y,text_info->x,text_info->y+text_info->height-1);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E d i t T e x t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XEditText edits a text string as indicated by the key symbol.  % + %  The format of the XEditText function is:  % 9 %      XEditText(display,text_info,key_symbol,text,state)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. % H %    o key_symbol:  A X11 KeySym that indicates what editing function to %      perform to the text.  % 8 %    o text: A character string to insert into the text. % J %    o state:  An unsigned long that indicates whether the key symbol is a  %      control character or not. %  %  */> static void XEditText(display,text_info,key_symbol,text,state) Display    *display;    XWidgetInfo 
   *text_info;    KeySym
   key_symbol;    char   *text;  
 unsigned long    state; {    switch (key_symbol)    {      case XK_BackSpace:     case XK_Delete:      {        /*         Erase one character.       *//       if (text_info->cursor != text_info->text) 	         {            text_info->cursor--;?           (void) strcpy(text_info->cursor,text_info->cursor+1); %           text_info->highlight=False;            break;	         }      }      case XK_Left:      case XK_KP_Left:     {        /*&         Move cursor one position left.       *//       if (text_info->cursor == text_info->text)          break;       text_info->cursor--;       break;     }      case XK_Right:     case XK_KP_Right:      {        /*'         Move cursor one position right.        */I       if (text_info->cursor == (text_info->text+strlen(text_info->text)))          break;       text_info->cursor++;       break;     }      default:     {        register char          *p,          *q;          register int
         i;         if (state & ControlState)          break;       if (*text == '\0')         break;=       if (((int) strlen(text_info->text)+1) >= MaxTextLength)          XBell(display,0); 
       else	         {            /**             Insert a string into the text.           */#           if (text_info->highlight) 
             {                /*.                 Erase the entire line of text.               */$               *text_info->text='\0';0               text_info->cursor=text_info->text;0               text_info->marker=text_info->text;)               text_info->highlight=False; 
             } A           q=text_info->text+strlen(text_info->text)+strlen(text); >           for (i=0; i <= (int) strlen(text_info->cursor); i++)           { #             *q=(*(q-strlen(text)));              q--;           }            p=text; 0           for (i=0; i < (int) strlen(text); i++)(             *text_info->cursor++=(*p++);	         }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i d g e t I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWidgetInfo initializes the XWidgetInfo structure.  % 0 %  The format of the XGetWidgetInfo function is: % ' %      XGetWidgetInfo(text,widget_info)  % + %  A description of each parameter follows:  % ? %    o text: A string of characters associated with the widget.  % G %    o widget_info: Specifies a pointer to a X11 XWidgetInfo structure.  %  %  */, static void XGetWidgetInfo(text,widget_info) char   *text;   XWidgetInfo    *widget_info;  {    /*     Initialize widget info.    */    widget_info->id=(~0);    widget_info->bevel_width=3;    widget_info->width=1;    widget_info->height=1;     widget_info->x=0;    widget_info->y=0;    widget_info->min_y=0;    widget_info->max_y=0;    widget_info->raised=True;    widget_info->active=False;     widget_info->center=True;    widget_info->trough=False;      widget_info->highlight=False;    widget_info->text=text;    widget_info->cursor=text;    if (text != (char *) NULL) '      widget_info->cursor+=strlen(text);     widget_info->marker=text; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t W i d g e t                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightWidget draws a highlighted border around a window. % 2 %  The format of the XHighlightWidget function is: % 0 %      XHighlightWidget(display,window_info,x,y) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o x: Specifies an integer representing the rectangle offset in the  %      x-direction.  % G %    o y: Specifies an integer representing the rectangle offset in the  %      y-direction.  %  %  */5 static void XHighlightWidget(display,window_info,x,y)  Display    *display;    XWindowInfo    *window_info;    int    x,   y; {    /*+     Draw the widget highlighting rectangle.    */+   XSetBevelColor(display,window_info,True); I   XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, >     window_info->width-(x << 1),window_info->height-(y << 1));M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, B     window_info->width-(x << 1)+1,window_info->height-(y << 1)+1);,   XSetBevelColor(display,window_info,False);M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, >     window_info->width-(x << 1),window_info->height-(y << 1));?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S c r e e n E v e n t                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XScreenEvent returns True if the any event on the X server queue( %  is associated with the widget window. % . %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */+ static int XScreenEvent(display,event,data)  Display    *display;    XEvent	   *event;    char   *data; { 
   XWindows
     *windows;      windows=(XWindows *) data;.   if (event->xany.window == windows->popup.id)     { #       if (event->type == MapNotify) #         windows->popup.mapped=True; %       if (event->type == UnmapNotify) $         windows->popup.mapped=False;       return(True);      } /   if (event->xany.window == windows->widget.id)      { #       if (event->type == MapNotify) $         windows->widget.mapped=True;%       if (event->type == UnmapNotify) %         windows->widget.mapped=False;        return(True);      }    switch (event->type)   {      case ButtonPress:      { /       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }        return(True);      }      case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)&           if (windows->magnify.mapped)
             { 1               XMakeMagnifyImage(display,windows);                break;
             }         if (event->type == Expose)	         { F           (void) XCommandWidget(display,windows,(char **) NULL,event);           break;	         }        break;     }      case FocusOut:     {        /*,         Set input focus for backdrop window.       */4       if (event->xfocus.window == windows->image.id)K         XSetInputFocus(display,windows->image.id,RevertToNone,CurrentTime);        return(True);      }      case ButtonRelease:      case KeyPress:     case KeyRelease:     case MotionNotify:     case SelectionNotify:        return(True);      default:       break;   }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t B e v e l C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XSetBevelColor sets the graphic context for drawing a beveled 
 %  border. % 0 %  The format of the XSetBevelColor function is: % 1 %      XSetBevelColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */6 static void XSetBevelColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        Pixmap         stipple;         /*         Monochrome window.       */9       XSetBackground(display,window_info->widget_context, 2         XBlackPixel(display,window_info->screen));9       XSetForeground(display,window_info->widget_context, 2         XWhitePixel(display,window_info->screen));L       XSetFillStyle(display,window_info->widget_context,FillOpaqueStippled);-       stipple=window_info->highlight_stipple;        if (!raised),         stipple=window_info->shadow_stipple;?       XSetStipple(display,window_info->widget_context,stipple);      }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 8         window_info->pixel_info->highlight_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->shadow_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t M a t t e C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XSetMatteColor sets the graphic context for drawing the matte. % 0 %  The format of the XSetMatteColor function is: % 1 %      XSetMatteColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o raised: A value other than zero indicates the matte is active.  %  %  */6 static void XSetMatteColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));     }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->matte_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->depth_color.pixel); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t T e x t C o l o r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XSetTextColor sets the graphic context for drawing text on a	 %  matte.  % / %  The format of the XSetTextColor function is:  % 0 %      XSetTextColor(display,window_info,raised) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */5 static void XSetTextColor(display,window_info,raised)  Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    int      foreground, 
     matte;     if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       return;      } N   foreground=XDownScale(Intensity(window_info->pixel_info->foreground_color));D   matte=XDownScale(Intensity(window_info->pixel_info->matte_color));6   if (AbsoluteValue(foreground-matte) > (MaxRGB >> 3))7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->foreground_color.pixel);    else7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->background_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r B r o w s e r W i d g e t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XColorBrowserWidget displays a Color Browser widget with a colorM %  query to the user.  The user keys a reply and presses the Action or Cancel O %  button to exit.  The typed text is returned as the reply function parameter.  % 4 %  The format of the XColorBrowserWidget routine is: % 6 %    XColorBrowserWidget(display,windows,action,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XColorBrowserWidget(display,windows,action,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *reply;  { " #define CancelButtonText  "Cancel" #define ColornameText  "Name:"$ #define ColorPatternText  "Pattern:" #define GrabButtonText  "Grab"  #define ResetButtonText  "Reset"     char     **colorlist,%     primary_selection[MaxTextLength], !     reset_pattern[MaxTextLength],      text[MaxTextLength];     int      colors,      status,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";  
   static char *     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,      text_width,      visible_colors, 
     width;     unsigned long 
     delay,
     state;     XColor
     color;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     grab_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*/     Get color list and sort in ascending order.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);#   (void) strcpy(reset_pattern,"*"); -   colorlist=ListColors(glob_pattern,&colors); "   if (colorlist == (char **) NULL)     {        /*.         Pattern failed, obtain all the colors.       */&       (void) strcpy(glob_pattern,"*");1       colorlist=ListColors(glob_pattern,&colors); &       if (colorlist == (char **) NULL)	         { I           XNoticeWidget(display,windows,"Unable to obtain colors names:",              glob_pattern);J           (void) XDialogWidget(display,windows,action,"Enter color name:",             reply);            return; 	         }      }    /*.     Determine Color Browser widget attributes.   */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < colors; i++)M     if (XTextWidth(font_info,colorlist[i],strlen(colorlist[i])) > text_width) I       text_width=XTextWidth(font_info,colorlist[i],strlen(colorlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));   width+=QuantumMargin; N   if (XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText)) > width)J     width=XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText));H   if (XTextWidth(font_info,ColornameText,strlen(ColornameText)) > width)D     width=XTextWidth(font_info,ColornameText,strlen(ColornameText));.   height=font_info->ascent+font_info->descent;   /*"     Position Color Browser widget.   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Color Browser widget.    */B   (void) strcpy(windows->widget.name,"Browse and Select a Color");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_colors=0;    delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(GrabButtonText,&grab_info);         grab_info.width=width;)         grab_info.height=(3*height) >> 1; "         grab_info.x=QuantumMargin;4         grab_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width; *         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin; @         reset_info.y=grab_info.y+grab_info.height+QuantumMargin;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*&           Initialize mode information.
         */1         XGetWidgetInfo((char *) NULL,&mode_info);          mode_info.active=True;          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin; ,         mode_info.height=action_info.height;!         mode_info.x=reply_info.x; "         mode_info.y=action_info.y;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height; I         scroll_info.height=reply_info.y-grab_info.y-(QuantumMargin >> 1); H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=grab_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_colors= A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3); $         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState; 
         /*&           Initialize text information.
         */         *text='\0'; (         XGetWidgetInfo(text,&text_info);         text_info.center=False; )         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*&           Redraw Color Browser window.
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,9           x,y,ColorPatternText,strlen(ColorPatternText)); 9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledButton(display,&windows->widget,&grab_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info); ?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,ColornameText,strlen(ColornameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {          char           **checklist;           int            number_colors;  F         status=XParseColor(display,windows->widget.map_info->colormap,           glob_pattern,&color);          if (status != 0)           {              /*2               Reply is a single color name-- exit.             */.             (void) strcpy(reply,glob_pattern);6             (void) strcpy(glob_pattern,reset_pattern);%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 
         /*           Update color list.
         */:         checklist=ListColors(glob_pattern,&number_colors);         if (number_colors == 0)            { 6             (void) strcpy(glob_pattern,reset_pattern);             XBell(display,0);            }          else           { &             for (i=0; i < colors; i++)*               free((char *) colorlist[i]);,             if (colorlist != (char **) NULL)'               free((char *) colorlist);               colorlist=checklist;!             colors=number_colors;            } 
         /*-           Sort color list in ascending order. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;$         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*$           Redraw color name & reply.
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); "         state&=(~UpdateListState);       }      if (state & JumpListState)       { 
         /**           Jump scroll to match user color.
         */         list_info.id=(~0);"         for (i=0; i < colors; i++).           if (strcmp(colorlist[i],reply) >= 0)
             { D               list_info.id=strcmp(colorlist[i],reply) == 0 ? i : ~0;               break;
             } K         if ((i < slider_info.id) || (i >= (slider_info.id+visible_colors))) 1           slider_info.id=i-(visible_colors >> 1);          selection_info.id=(~0);          state|=RedrawListState;           state&=(~JumpListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */<         if (slider_info.id >= (int) (colors-visible_colors))/           slider_info.id=colors-visible_colors; ?         if ((slider_info.id < 0) || (colors <= visible_colors))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (colors > 0)            slider_info.y+= J             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/colors;0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; .             for (i=0; i < visible_colors; i++)
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;.               if ((slider_info.id+i) < colors)@                 selection_info.text=colorlist[slider_info.id+i];H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       {          static char #           colorname[MaxTextLength];   
         /*7           Display the selected color in a drawing area. 
         */6         color=windows->widget.pixel_info->matte_color;F         (void) XParseColor(display,windows->widget.map_info->colormap,D           reply_info.text,&windows->widget.pixel_info->matte_color);N         XBestPixel(display,windows->widget.map_info->colormap,(XColor *) NULL,D           (unsigned int) windows->widget.visual_info->colormap_size,4           &windows->widget.pixel_info->matte_color);!         mode_info.text=colorname; 6         (void) sprintf(mode_info.text,"#%02x%02x%02x",B           XDownScale(windows->widget.pixel_info->matte_color.red),D           XDownScale(windows->widget.pixel_info->matte_color.green),D           XDownScale(windows->widget.pixel_info->matte_color.blue));@         XDrawBeveledButton(display,&windows->widget,&mode_info);6         windows->widget.pixel_info->matte_color=color;$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) &           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))&           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)1               slider_info.id-=(visible_colors-1);              else1               slider_info.id+=(visible_colors-1); #             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= colors)                break;9             (void) strcpy(reply_info.text,colorlist[id]); '             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState; #             if (id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(grab_info,event.xbutton))            {              /*'               User pressed Grab button.              */#             grab_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } 3         if (MatteIsActive(mode_info,event.xbutton))            {              /*'               User pressed mode button.              */:             (void) strcpy(reply_info.text,mode_info.text);=             (void) strcpy(primary_selection,reply_info.text); E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, "               event.xbutton.time);J             reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==!               windows->widget.id; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!grab_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(grab_info,event.xbutton))                  {                    /*9                     Select a pen color from the X server.                    */B                   (void) XGetWindowColor(display,reply_info.text);4                   reply_info.marker=reply_info.text;L                   reply_info.cursor=reply_info.text+strlen(reply_info.text);G                   XDrawMatteText(display,&windows->widget,&reply_info); +                   state|=RedrawActionState;                  } "             grab_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&grab_info);           }          if (!reset_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(reset_info,event.xbutton))                 { <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  } #             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { /                 slider_info.id-=visible_colors;                  break;               }                case XK_Next:                case XK_KP_Next:               { /                 slider_info.id+=visible_colors;                  break;               }                case XK_End:               case XK_KP_End:                { &                 slider_info.id=colors;                 break;               } 
             } #             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*-               Read new color or glob patterm.              */)             if (*reply_info.text == '\0')                break;8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          state|=JumpListState; F         status=XParseColor(display,windows->widget.map_info->colormap,"           reply_info.text,&color);         if (status != 0)#           state|=RedrawActionState;          break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MapNotify:        {          mask&=(~CWX);          mask&=(~CWY);          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) J               slider_info.id=(colors*(slider_info.y-slider_info.min_y+1))/8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (grab_info.raised == MatteIsActive(grab_info,event.xmotion))            {              /*)               Grab button status changed.              *//             grab_info.raised=!grab_info.raised; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised; E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format,            status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info); !             state|=JumpListState; %             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free color list.   */   for (i=0; i < colors; i++)      free((char *) colorlist[i]);"   if (colorlist != (char **) NULL)     free((char *) colorlist); N   status=XParseColor(display,windows->widget.map_info->colormap,reply,&color);   if (status == 0)     { K       XNoticeWidget(display,windows,"Color is unknown to X server:",reply); "       (void) strcpy(reply,"gray");     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m m a n d W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCommandWidget maps a menu and returns the command pointed to by( %  the user when the button is released. % / %  The format of the XCommandWidget routine is:  % F %    selection_number=XCommandWidget(display,windows,selections,event) % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % K %    o selections: Specifies a pointer to one or more strings that comprise  %      the choices in the menu.  % < %    o event: Specifies a pointer to a X11 XEvent structure. %  %  */4 int XCommandWidget(display,windows,selections,event) Display    *display;    XWindows   *windows;    char   **selections;    XEvent	   *event;  {  #define tile_width 112 #define tile_height 70  #   static unsigned char tile_bits[]=    { K     0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1e, 0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1e, 0xbc, 0x9f, 0x03, 0x00, 0x3e, 0x00, 0xc0, K     0x1f, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x0f, 0x80, 0x3f, K     0x00, 0xf0, 0x1f, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x1f, K     0xe0, 0x3f, 0x00, 0xfc, 0x1f, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, K     0xff, 0x1f, 0xf0, 0x3f, 0x00, 0xfe, 0x1f, 0xf8, 0x0f, 0x00, 0x00, 0x00, K     0x1e, 0xfc, 0xfc, 0x3f, 0xf8, 0x3f, 0x00, 0xff, 0x1e, 0xfc, 0x0f, 0x00, K     0x00, 0x00, 0x1e, 0x7c, 0xfc, 0x3e, 0xf8, 0x3c, 0x80, 0x1f, 0x1e, 0x7c, K     0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, 0xc0, 0x0f, K     0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, K     0xc0, 0x07, 0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, K     0x7c, 0x7c, 0xc0, 0x0f, 0x1e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78, K     0x78, 0x3c, 0xfc, 0x7c, 0x80, 0x7f, 0x1e, 0x7c, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0xf8, 0x78, 0x7c, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0xff, 0x00, K     0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xfe, 0x1f, 0xf8, K     0xff, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xf8, K     0x1f, 0xf0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xc0, 0xef, K     0x07, 0xe0, 0x1f, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0x70, 0x40, 0x78, K     0x00, 0xc7, 0x07, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, K     0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x60, 0x00, 0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0x9f, 0x7f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0xdf, K     0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x78, 0x00, K     0xe0, 0xdf, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0c, K     0x78, 0x30, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, K     0x00, 0x0f, 0xf8, 0x70, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x1f, 0x00, 0xe0, K     0x0f, 0x1e, 0x80, 0x0f, 0xf8, 0x78, 0xf0, 0xfd, 0xf9, 0x00, 0xc0, 0x1f, K     0x00, 0xf8, 0x0f, 0x00, 0xe0, 0x1f, 0xf8, 0x7c, 0xf0, 0xfc, 0xf9, 0x00, K     0xf0, 0x1f, 0x00, 0xfe, 0x0f, 0x00, 0xf0, 0x07, 0xf8, 0x3e, 0xf8, 0xfc, K     0xf0, 0x01, 0xf8, 0x1f, 0x00, 0xff, 0x0f, 0x1e, 0xf0, 0x03, 0xf8, 0x3f, K     0xf8, 0xf8, 0xf0, 0x01, 0xfc, 0x1f, 0x80, 0x7f, 0x0f, 0x1e, 0xf8, 0x00, K     0xf8, 0x1f, 0x78, 0x18, 0xf0, 0x01, 0x7c, 0x1e, 0xc0, 0x0f, 0x0f, 0x1e, K     0x7c, 0x00, 0xf0, 0x0f, 0x78, 0x00, 0xf0, 0x01, 0x3e, 0x1e, 0xe0, 0x07, K     0x0f, 0x1e, 0x7c, 0x00, 0xf0, 0x07, 0x7c, 0x00, 0xe0, 0x01, 0x3e, 0x1e, K     0xe0, 0x03, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x0f, 0x7c, 0x00, 0xe0, 0x03, K     0x3e, 0x3e, 0xe0, 0x07, 0x0f, 0x1e, 0x1e, 0x00, 0xf0, 0x1f, 0x3c, 0x00, K     0xe0, 0x03, 0x7e, 0x3e, 0xc0, 0x3f, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x1f, K     0x3e, 0x00, 0xe0, 0x03, 0xfc, 0x7f, 0x80, 0xff, 0x0f, 0x1e, 0xfc, 0x00, K     0xf0, 0x3e, 0x3e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xff, 0x0f, 0x1e, K     0xfc, 0x07, 0xf0, 0x7c, 0x1e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xfc, K     0x0f, 0x1e, 0xf8, 0x1f, 0xf0, 0xf8, 0x1e, 0x00, 0xc0, 0x03, 0xe0, 0xf7, K     0x03, 0xf0, 0x0f, 0x1e, 0xe0, 0x3f, 0xf0, 0x78, 0x1c, 0x00, 0x80, 0x03, K     0x80, 0xe3, 0x03, 0x00, 0x0f, 0x1e, 0xc0, 0x3f, 0xf0, 0x30, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x00, 0x3e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x10, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, K     0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 2     0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   };     int      id,      y;     register int     i;     static unsigned int      number_selections;     static XWidgetInfo+     *selection_info = (XWidgetInfo *) NULL;      unsigned int     height;      unsigned long 
     state;  
   XFontStruct      *font_info;   '   font_info=windows->command.font_info; .   height=font_info->ascent+font_info->descent;   state=DefaultState;    if (event == (XEvent *) NULL)      {        unsigned int         width;         XTextProperty          window_name;         XWindowChanges         window_changes;          /*,         Determine command window attributes.       */       windows->command.width=0; 4       for (i=0; selections[i] != (char *) NULL; i++)       { H         width=XTextWidth(font_info,selections[i],strlen(selections[i]));+         if (width > windows->command.width) '           windows->command.width=width;        }        number_selections=i;1       windows->command.width+=3*QuantumMargin+10; A       if (windows->command.width < (tile_width+QuantumMargin+10)) ;         windows->command.width=tile_width+QuantumMargin+10;        windows->command.height=@         number_selections*(((3*height) >> 1)+10)+tile_height+20;8       windows->command.min_width=windows->command.width;:       windows->command.min_height=windows->command.height;:       XConstrainWindowPosition(display,&windows->command);/       if (windows->command.id != (Window) NULL) 	         { 
           int              status;              /*'             Reconfigure command window.            */D           status=XStringListToTextProperty(&windows->command.name,1,             &window_name);           if (status != 0)
             { C               XSetWMName(display,windows->command.id,&window_name); G               XSetWMIconName(display,windows->command.id,&window_name); 0               XFree((void *) window_name.value);
             } 6           window_changes.width=windows->command.width;8           window_changes.height=windows->command.height;;           XReconfigureWMWindow(display,windows->command.id, H             windows->command.screen,CWWidth | CWHeight,&window_changes);	         }        /*'         Allocate selection info memory.        */1       if (selection_info != (XWidgetInfo *) NULL) &         free((char *) selection_info);$       selection_info=(XWidgetInfo *)6         malloc(number_selections*sizeof(XWidgetInfo));1       if (selection_info == (XWidgetInfo *) NULL) L         Error("Unable to create Command Widget","Memory allocation failed");&       state|=UpdateConfigurationState;     }    /*     Wait for next event.   */
   id=(-1);   if (event != (XEvent *) NULL)      switch (event->type)     {        case ButtonPress:        { -         for (i=0; i < number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue; )           if (i >= windows->command.data) 
             { -               selection_info[i].raised=False; O               XDrawBeveledButton(display,&windows->command,&selection_info[i]);                break;
             } )           submenu_info=selection_info[i]; #           submenu_info.active=True;            toggle_info.y=P             submenu_info.y+(submenu_info.height >> 1)-(toggle_info.height >> 1);           id=i; N           XCheckWindowEvent(display,windows->widget.id,LeaveWindowMask,event);           break;	         }          break;       }        case ButtonRelease:        { -         for (i=0; i < number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue;            id=i; *           if (id >= windows->command.data)
             { -               selection_info[id].raised=True; P               XDrawBeveledButton(display,&windows->command,&selection_info[id]);               break;
             }            break;	         }          break;       }        case ClientMessage:        { 
         /*C           If client window delete message, withdraw command widget. 
         */A         if (event->xclient.message_type != windows->wm_protocols)            break;@         if (*event->xclient.data.l != windows->wm_delete_window)           break;M         XWithdrawWindow(display,windows->command.id,windows->command.screen);          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */<         if (event->xconfigure.window != windows->command.id)           break;.         if (event->xconfigure.send_event != 0)           { 3             windows->command.x=event->xconfigure.x; 3             windows->command.y=event->xconfigure.y;            } B         if ((event->xconfigure.width == windows->command.width) &&B             (event->xconfigure.height == windows->command.height))           break;         windows->command.width= B           Max(event->xconfigure.width,windows->command.min_width);          windows->command.height=D           Max(event->xconfigure.height,windows->command.min_height);(         state|=UpdateConfigurationState;         break;       }        case Expose:       { 9         if (event->xexpose.window != windows->command.id)            break;&         if (event->xexpose.count != 0)           break;!         state|=RedrawWidgetState;          break;       }        case MotionNotify:       { 
         /*6           Return the ID of the highlighted menu entry.
         */         for ( ; ; ) 	         { /           for (i=0; i < number_selections; i++)            { +             if (i >= windows->command.data)                { /                 if (selection_info[i].raised == D                     MatteIsActive(selection_info[i],event->xmotion))                   {                      /*,                       Button status changed.                     */G                     selection_info[i].raised=!selection_info[i].raised; A                     XDrawBeveledButton(display,&windows->command, *                       &selection_info[i]);                   }                  continue;                } A             if (!MatteIsActive(selection_info[i],event->xmotion))                continue; +             submenu_info=selection_info[i]; %             submenu_info.active=True; $             toggle_info.raised=True;D             toggle_info.y=submenu_info.y+(submenu_info.height >> 1)-(               (toggle_info.height >> 1);F             XDrawTriangleEast(display,&windows->command,&toggle_info);             id=i;            } &           XDelay(display,SuspendTime);?           if (!XCheckMaskEvent(display,ButtonMotionMask,event))              break;B           while (XCheckMaskEvent(display,ButtonMotionMask,event));#           toggle_info.raised=False; (           if (windows->command.data > 0)F             XDrawTriangleEast(display,&windows->command,&toggle_info);	         }          break;       }        case MapNotify:        { %         windows->command.mapped=True;          break;       }        case UnmapNotify:        { &         windows->command.mapped=False;         break;       }        default:         break;     } '   if (state & UpdateConfigurationState)      {        /*&         Initialize button information.       */       y=tile_height+20; +       for (i=0; i < number_selections; i++)        { 9         XGetWidgetInfo(selections[i],&selection_info[i]); '         selection_info[i].center=False; (         selection_info[i].bevel_width--;1         selection_info[i].height=(3*height) >> 1; 3         selection_info[i].x=(QuantumMargin >> 1)+4;           selection_info[i].width=<           windows->command.width-(selection_info[i].x << 1);         selection_info[i].y=y;K         y+=selection_info[i].height+(selection_info[i].bevel_width << 1)+6;        } 1       XGetWidgetInfo((char *) NULL,&toggle_info);         toggle_info.bevel_width--;I       toggle_info.width=((5*height) >> 3)-(toggle_info.bevel_width << 1); +       toggle_info.height=toggle_info.width; @       toggle_info.x=selection_info[0].x+selection_info[0].width-/         toggle_info.width-(QuantumMargin >> 1); "       if (windows->command.mapped)2         XClearWindow(display,windows->command.id);     }     if (state & RedrawWidgetState)     {        Pixmap         tile_pixmap;         /*         Draw command buttons.        */J       tile_pixmap=XCreatePixmapFromBitmapData(display,windows->command.id,;         (char *) tile_bits,tile_width,tile_height,1L,0L,1); '       if (tile_pixmap != (Pixmap) NULL) 	         { =           XCopyPlane(display,tile_pixmap,windows->command.id, I             windows->command.annotate_context,0,0,tile_width,tile_height, <             (windows->command.width-tile_width) >> 1,10,1L);+           XFreePixmap(display,tile_pixmap); 	         } +       for (i=0; i < number_selections; i++)        { I         XDrawBeveledButton(display,&windows->command,&selection_info[i]); '         if (i >= windows->command.data)            continue; #         toggle_info.raised=i == id; *         toggle_info.y=selection_info[i].y+D           (selection_info[i].height >> 1)-(toggle_info.height >> 1);B         XDrawTriangleEast(display,&windows->command,&toggle_info);       } L       XHighlightWidget(display,&windows->command,BorderOffset,BorderOffset);     } 
   return(id);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i r m W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XConfirmWidget displays a Confirm widget with a notice to the user. G %  The function returns True if the user presses Yes otherwise False is  %  returned. % / %  The format of the XConfirmWidget routine is:  % = %    status=XConfirmWidget(display,windows,message,qualifier)  % + %  A description of each parameter follows:  % L %    o status:  Function XConfirmWidget returns True if the user presses Yes# %      otherwise False is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */> unsigned int XConfirmWidget(display,windows,message,qualifier) Display    *display;    XWindows   *windows;    char   *message, 
   *qualifier;  { " #define CancelButtonText  "Cancel" #define YesButtonText  "Yes"     int      status,      x,     y;     unsigned int     confirm,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      cancel_info,
     yes_info;      XWindowChanges     window_changes;      /*(     Determine Confirm widget attributes.   */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;H   width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));H   if (XTextWidth(font_info,YesButtonText,strlen(YesButtonText)) > width)D     width=XTextWidth(font_info,YesButtonText,strlen(YesButtonText));   width<<=1;!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Confirm widget.   */.   windows->widget.width=width+7*QuantumMargin;7   windows->widget.min_width=width+(QuantumMargin << 2); 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Confirm widget.    */0   (void) strcpy(windows->widget.name,"Confirm");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */   confirm=False;!   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*+           Initialize No button information. 
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);(         cancel_info.width=QuantumMargin+J           XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));+         cancel_info.height=(3*height) >> 1; L         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin;G         cancel_info.y=windows->widget.height-(cancel_info.height << 1);          yes_info=cancel_info; $         yes_info.text=YesButtonText;!         yes_info.x=QuantumMargin; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Confirm widget.
         */<         width=XTextWidth(font_info,message,strlen(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,strlen(message)); '         if (qualifier != (char *) NULL)            {              char&               question[MaxTextLength];  .             (void) strcpy(question,qualifier);(             (void) strcat(question,"?");B             width=XTextWidth(font_info,question,strlen(question));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id, N               windows->widget.annotate_context,x,y,question,strlen(question));           } B         XDrawBeveledButton(display,&windows->widget,&cancel_info);?         XDrawBeveledButton(display,&windows->widget,&yes_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*%               User pressed No button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 2         if (MatteIsActive(yes_info,event.xbutton))           {              /*&               User pressed Yes button.             */"             yes_info.raised=False;C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState; $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          if (!yes_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) 8               if (MatteIsActive(yes_info,event.xbutton))                 {                    confirm=True; #                   state|=ExitState;                  } !             yes_info.raised=True; C             XDrawBeveledButton(display,&windows->widget,&yes_info);            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             state|=ExitState;              break;           }          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*'               No button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } E         if (yes_info.raised == MatteIsActive(yes_info,event.xmotion))            {              /*(               Yes button status changed.             */-             yes_info.raised=!yes_info.raised; C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   return(confirm); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i a l o g W i d g e t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDialogWidget displays a Dialog widget with a query to the user.J %  The user keys a reply and presses the Ok or Cancel button to exit.  The: %  typed text is returned as the reply function parameter. % . %  The format of the XDialogWidget routine is: % 6 %    XDialogWidget(display,windows,action,query,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. % G %    o reply: The response from the user is returned in this parameter.  %  %  */5 int XDialogWidget(display,windows,action,query,reply)  Display    *display;    XWindows   *windows;    char
   *action,	   *query, 	   *reply;  { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];      int      status,      x,     y;     register int     i;     static unsigned int      raised = False;      unsigned int     anomaly,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     reply_info,      special_info,      text_info;     XWindowChanges     window_changes;      /*'     Determine Dialog widget attributes.    */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));    width+=(3*QuantumMargin) >> 1;.   height=font_info->ascent+font_info->descent;   /*     Position Dialog widget.    */   windows->widget.width=K     Max(2*width,XTextWidth(font_info,query,strlen(query)))+6*QuantumMargin;    windows->widget.min_width=9     width+25*XTextWidth(font_info,"#",1)+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;7   windows->widget.height=7*height+(QuantumMargin << 1); 4   windows->widget.min_height=windows->widget.height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Dialog widget.   *//   (void) strcpy(windows->widget.name,"Dialog"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   *//   anomaly=(strcmp(action,"Background") == 0) || I     (strcmp(action,"Quantize") == 0) || (strcmp(action,"Resize") == 0) || !     (strcmp(action,"Save") == 0); !   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;          cancel_info.x=K           windows->widget.width-cancel_info.width-((3*QuantumMargin) >> 1);          cancel_info.y=M           windows->widget.height-cancel_info.height-((3*QuantumMargin) >> 1); ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; E         action_info.x=cancel_info.x-(cancel_info.width+QuantumMargin+ *           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; A         reply_info.width=windows->widget.width-(3*QuantumMargin); &         reply_info.height=height << 1;,         reply_info.x=(3*QuantumMargin) >> 1;C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*(           Initialize option information.
         *//         XGetWidgetInfo("Dither",&special_info); #         special_info.raised=raised; #         special_info.bevel_width--; .         special_info.width=QuantumMargin >> 1;/         special_info.height=QuantumMargin >> 1; $         special_info.x=reply_info.x;L         special_info.y=action_info.y+action_info.height-special_info.height;-         if (strcmp(action,"Background") == 0) '           special_info.text="Backdrop"; )         if (strcmp(action,"Resize") == 0) .           special_info.text="Constrain ratio";'         if (strcmp(action,"Save") == 0) *           special_info.text="Progressive";
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;6         text_info.x=reply_info.x-(QuantumMargin >> 1);"         text_info.y=QuantumMargin;         text_info.center=False; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*           Redraw Dialog widget. 
         */=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);          if (anomaly)E           XDrawBeveledButton(display,&windows->widget,&special_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        {          if (anomaly)8           if (MatteIsActive(special_info,event.xbutton))
             {                /*-                 Option button status changed.                */7               special_info.raised=!special_info.raised; I               XDrawBeveledButton(display,&windows->widget,&special_info);                break;
             } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed Action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }%5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);eI                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                }SA             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:C       {1$         if (!windows->widget.mapped)           break;          if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)o;               if (MatteIsActive(action_info,event.xbutton)) !                 state|=ExitState;r$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           {p;             if (event.xbutton.window == windows->widget.id)e;               if (MatteIsActive(cancel_info,event.xbutton))                  {b(                   *reply_info.text='\0';#                   state|=ExitState;f                 }u$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }y       case ClientMessage:u       {t
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent,d'               event.xclient.data.l[1]);              break;           }.?         if (*event.xclient.data.l != windows->wm_delete_window)p           break;7         if (event.xclient.window == windows->widget.id)a           {t"             *reply_info.text='\0';             state|=ExitState;o             break;           }r         break;       }        case ConfigureNotify:c       { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=)B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }(       case EnterNotify:.       {n9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }n       case Expose:       {o7         if (event.xexpose.window != windows->widget.id)e           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }n       case KeyPress:       {o         static char !           command[MaxTextLength];            static int           length;e           static KeySymt           key_symbol;c  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),w/           &key_symbol,(XComposeStatus *) NULL);f         *(command+length)='\0';fE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))0           {a%             action_info.raised=False;eF             XDrawBeveledButton(display,&windows->widget,&action_info);             state|=ExitState;              break;           }{'         if (key_symbol == XK_Control_L)U           {L              state|=ControlState;             break;           },!         if (state & ControlState)p           switch (key_symbol)o           {c             case XK_u:             case XK_U:
             {s               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;t               break;
             }X             default:               break;           }i@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);r         break;       }*       case KeyRelease:       {l         static charl!           command[MaxTextLength];            static KeySyma           key_symbol;f  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),S/           &key_symbol,(XComposeStatus *) NULL);s'         if (key_symbol == XK_Control_L)D!           state&=(~ControlState);)         break;       }a       case LeaveNotify:        {d9         if (event.xcrossing.window != windows->widget.id)%           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }%K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))s           {              /*+               Cancel button status changed.w             */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           },         break;       }s       case SelectionClear:       { #         reply_info.highlight=False;e=         XDrawMatteText(display,&windows->widget,&reply_info);.         break;       }        case SelectionNotify:X       {o         Atom           type;i           inta           format,e           status;t           unsigned chare           *data;           unsigned long            after,           length;i  
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)1           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||_             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {h             /*5               Insert primary selection in reply text.o             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,o               state); A             XDrawMatteText(display,&windows->widget,&reply_info);p           }          XFree((void *) data);*         break;       }t       case SelectionRequest:       {1         XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));r$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (anomaly)     if (special_info.raised)       if (*reply != '\0')%         raised=True;   return(!raised); }d t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             % O %                                                                             %oO %                                                                             %sO %   X F i l e B r o w s e r W i d g e t                                       %rO %                                                                             %iO %                                                                             %oO %                                                                             %vO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %WO %  Function XFileBrowserWidget displays a File Browser widget with a file query,N %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. %l3 %  The format of the XFileBrowserWidget routine is:y %n5 %    XFileBrowserWidget(display,windows,action,reply)y %n+ %  A description of each parameter follows:  %uE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %n; %    o window: Specifies a pointer to a XWindows structure.t %;@ %    o action: Specifies a pointer to the action of this widget. %iG %    o reply: The response from the user is returned in this parameter.d %i %- */5 void XFileBrowserWidget(display,windows,action,reply)w Displayo   *display;e   XWindows   *windows;f   char
   *action,	   *reply;d {<" #define CancelButtonText  "Cancel"# #define DirectoryText  "Directory:" " #define FilenameText  "File name:" #define GrabButtonText  "Grab"" #define FormatButtonText  "Format" #define HomeButtonText  "Home" #define UpButtonText  "Up"  
   static charr     *ImageOutputFormats[]=     {i       "avs",       "bie",       "bmp",
       "cmyk",t       "eps",
       "epsf", 
       "epsi",W       "fax",
       "fits",e       "gif",       "gif87",
       "gray",f       "g3",M       "hdf",       "histogram",
       "jbig",u
       "jpeg",u       "jpg",       "map",       "matte",
       "miff",b       "mpg",       "mtv",       "pbm",       "pcx",       "pdf",       "pgm",
       "pict",u       "png",       "ppm",       "pnm",       "ps",        "ps2",       "ras",       "rgb",       "rle",       "sgi",       "sun",       "tga",
       "tiff",,
       "uyvy",=       "vid",
       "viff",i
       "x",       "xbm",       "xpm",       "xv",n       "xwd",       "yuv",
       "yuv3",i       (char *) NULLw     };     char     **filelist,i"     home_directory[MaxTextLength],%     primary_selection[MaxTextLength],e     text[MaxTextLength],%     working_directory[MaxTextLength];      intd
     files,     status,a     x,     y;     register int     i;  
   static char,&     glob_pattern[MaxTextLength] = "*",#     format[MaxTextLength] = "miff";n  
   static chart*     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     anomaly,     height,s     text_width,d     visible_files,
     width;     unsigned long%
     delay,
     state;     XEvent
     event;  
   XFontStruct%     *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     special_info,      list_info,     home_info,     north_info,      reply_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info,     up_info;     XWindowChanges     window_changes;      /*)     Read filelist from current directory.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);0   (void) getcwd(home_directory,MaxTextLength-1);2   (void) strcpy(working_directory,home_directory);<   filelist=ListFiles(working_directory,glob_pattern,&files);!   if (filelist == (char **) NULL)t     {a       /*         Directory read failed.       */@       XNoticeWidget(display,windows,"Unable to read directory:",         working_directory); K       (void) XDialogWidget(display,windows,action,"Enter filename:",reply);t
       return;o     }m   /*-     Determine File Browser widget attributes.l   */&   font_info=windows->widget.font_info;   text_width=0;s   for (i=0; i < files; i++) K     if (XTextWidth(font_info,filelist[i],strlen(filelist[i])) > text_width)wG       text_width=XTextWidth(font_info,filelist[i],strlen(filelist[i]));I4   width=XTextWidth(font_info,action,strlen(action));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));N   if (XTextWidth(font_info,FormatButtonText,strlen(FormatButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));J   if (XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText)) > width)F     width=XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText));F   if (XTextWidth(font_info,UpButtonText,strlen(UpButtonText)) > width)B     width=XTextWidth(font_info,UpButtonText,strlen(UpButtonText));   width+=QuantumMargin; H   if (XTextWidth(font_info,DirectoryText,strlen(DirectoryText)) > width)D     width=XTextWidth(font_info,DirectoryText,strlen(DirectoryText));F   if (XTextWidth(font_info,FilenameText,strlen(FilenameText)) > width)B     width=XTextWidth(font_info,FilenameText,strlen(FilenameText));.   height=font_info->ascent+font_info->descent;   /*!     Position File Browser widget.f   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin;t?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);(4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);i   /*     Map File Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a File"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);f   if (status != 0)     {.:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width;%/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_files=0;L   anomaly=(strcmp(action,"Composite") == 0) || (strcmp(action,"Load") == 0);   delay=SuspendTime << 2; !   state=UpdateConfigurationState;%   do   {%)     if (state & UpdateConfigurationState)n       {a         inta
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;iN         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;pL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;5         XGetWidgetInfo(GrabButtonText,&special_info);_!         special_info.width=width;o,         special_info.height=(3*height) >> 1;M         special_info.x=action_info.x-(action_info.width+(QuantumMargin >> 1)+ +           (special_info.bevel_width << 1));g%         special_info.y=action_info.y;h         if (!anomaly)S           {d             register char                *p;s  /             special_info.text=FormatButtonText; $             p=reply+strlen(reply)-1;2             while ((p > reply) && (*(p-1) != '.'))               p--;/             if ((p > reply) && (*(p-1) == '.')),&               (void) strcpy(format,p);           }_.         XGetWidgetInfo(UpButtonText,&up_info);         up_info.width=width;'         up_info.height=(3*height) >> 1;e          up_info.x=QuantumMargin;2         up_info.y=((5*QuantumMargin) >> 1)+height;2         XGetWidgetInfo(HomeButtonText,&home_info);         home_info.width=width;)         home_info.height=(3*height) >> 1;d"         home_info.x=QuantumMargin;;         home_info.y=up_info.y+up_info.height+QuantumMargin; 
         /*'           Initialize reply information.t
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;*N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin;r
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;dG         scroll_info.height=reply_info.y-up_info.y-(QuantumMargin >> 1); H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);7         scroll_info.y=up_info.y-reply_info.bevel_width;n!         scroll_info.raised=False;,          scroll_info.trough=True;         north_info=scroll_info;d         north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;t-         north_info.x+=north_info.bevel_width;p-         north_info.y+=north_info.bevel_width;t         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;dP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;M         visible_files=(scroll_info.height-(height >> 3)-3)/((9*height) >> 3);d"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState; 
         /*&           Initialize text information.
         */         *text='\0';%(         XGetWidgetInfo(text,&text_info);         text_info.center=False;n)         text_info.width=reply_info.width;t          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information.o
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;n+         state&=(~UpdateConfigurationState);w       }c"     if (state & RedrawWidgetState)       { 
         /*%           Redraw File Browser window.n
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,DirectoryText,strlen(DirectoryText)); A         (void) sprintf(text_info.text,"%s%s%s",working_directory, +           DirectorySeparator,glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);i>         XDrawBeveledButton(display,&windows->widget,&up_info);@         XDrawBeveledButton(display,&windows->widget,&home_info);?         XDrawBeveledMatte(display,&windows->widget,&list_info);iA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);0A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);n         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;eP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FilenameText,strlen(FilenameText));.@         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);nC         XDrawBeveledButton(display,&windows->widget,&special_info);oB         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);s         selection_info.id=(~0);3         state|=RedrawListState;3$         state&=(~RedrawWidgetState);       }w      if (state & UpdateListState)       {P         char           **checklist;           intn           number_files;e  
         /*           Update file list.v
         */J         checklist=ListFiles(working_directory,glob_pattern,&number_files);(         if (checklist == (char **) NULL)           {              /*(               Reply is a filename, exit.             */%             action_info.raised=False;oF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }o!         for (i=0; i < files; i++)i%           free((char *) filelist[i]);n'         if (filelist != (char **) NULL)a"           free((char *) filelist);         filelist=checklist;o         files=number_files; 
         /*           Update file list.h
         */'         if (filelist == (char **) NULL))           {n             /*(               Reply is a filename, exit.             */%             action_info.raised=False;aF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }l         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*(           Redraw directory name & reply.
         */%         if (!IsGlob(reply_info.text))            { "             *reply_info.text='\0';.             reply_info.cursor=reply_info.text;           }%A         (void) sprintf(text_info.text,"%s%s%s",working_directory,a+           DirectorySeparator,glob_pattern);v=         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info);tA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);iA         XDrawTriangleNorth(display,&windows->widget,&north_info);mB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);oM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);l"         state&=(~UpdateListState);       }s     if (state & JumpListState)       {t
         /*-           Jump scroll to match user filename.r
         */         list_info.id=(~0);!         for (i=0; i < files; i++)f-           if (strcmp(filelist[i],reply) >= 0)l
             { C               list_info.id=strcmp(filelist[i],reply) == 0 ? i : ~0;                break;
             }PJ         if ((i < slider_info.id) || (i >= (slider_info.id+visible_files)))0           slider_info.id=i-(visible_files >> 1);         selection_info.id=(~0);n         state|=RedrawListState;n          state&=(~JumpListState);       }e      if (state & RedrawListState)       {g
         /*+           Determine slider id and position.h
         */:         if (slider_info.id >= (int) (files-visible_files))-           slider_info.id=files-visible_files;3=         if ((slider_info.id < 0) || (files <= visible_files));           slider_info.id=0;o(         slider_info.y=slider_info.min_y;         if (files > 0)           slider_info.y+=rI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/files;=0         if (slider_info.id != selection_info.id)           {b             /*/               Redraw scroll bar and file names.1             */-             selection_info.id=slider_info.id;n9             selection_info.y=list_info.y+(height >> 3)+2;_-             for (i=0; i < visible_files; i++)r
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < files)w?                 selection_info.text=filelist[slider_info.id+i];tH               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y;1?                 expose_info.y=slider_info.y-expose_info.height-b,                   slider_info.bevel_width-1;               }o             else               {p?                 expose_info.height=expose_info.y-slider_info.y;e?                 expose_info.y=slider_info.y+slider_info.height+%,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {t               /*                 Move slider up.w               */               slider_info.id--; %               state|=RedrawListState;l
             }          if (!south_info.raised)o%           if (slider_info.id < files) 
             {p               /*!                 Move slider down.a               */               slider_info.id++;n%               state|=RedrawListState;o
             } (         if (event.type != ButtonRelease)           continue;t       }D     switch (event.type)w     {n       case ButtonPress:a       {s5         if (MatteIsActive(slider_info,event.xbutton))            {_             /*               Track slider.3             */$             slider_info.active=True;             break;           }o4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)n
             {i               /*                 Move slider up.i               */&               north_info.raised=False;               slider_info.id--;i%               state|=RedrawListState;i               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < files).
             {a               /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++;o%               state|=RedrawListState;v               break;
             }n5         if (MatteIsActive(scroll_info,event.xbutton))            {1             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_files-1);             else0               slider_info.id+=(visible_files-1);#             state|=RedrawListState;o             break;           }r3         if (MatteIsActive(list_info,event.xbutton))=           {s             unsigned int               id;                /*&               User pressed file matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= files)               break;8             (void) strcpy(reply_info.text,filelist[id]);'             reply_info.highlight=False;n.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); #             if (id == list_info.id)o               {aA                 (void) strcpy(working_directory,reply_info.text);c'                 state|=UpdateListState;i               }l#             selection_info.id=(~0);t             list_info.id=id;#             state|=RedrawListState;%             break;           }%1         if (MatteIsActive(up_info,event.xbutton))            {              /*%               User pressed Up button.              */!             up_info.raised=False; B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } 3         if (MatteIsActive(home_info,event.xbutton))            {              /*'               User pressed Home button.              */#             home_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           } 6         if (MatteIsActive(special_info,event.xbutton))           {%             /**               User pressed Special button.             */&             special_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&special_info);              if (!anomaly)T               {X                 /*/                   Let user select image format.o                 */9                 XDefineCursor(display,windows->widget.id,o/                   windows->widget.busy_cursor);cC                 XListBrowserWidget(display,windows,&windows->popup,pJ                   ImageOutputFormats,"Select","Select image format type:",                   format);6                 XSetCursorState(display,windows,True);9                 XDefineCursor(display,windows->widget.id,n*                   windows->widget.cursor);:                 AppendImageFormat(format,reply_info.text);J                 reply_info.cursor=reply_info.text+strlen(reply_info.text);E                 XDrawMatteText(display,&windows->widget,&reply_info); )                 special_info.raised=True;nK                 XDrawBeveledButton(display,&windows->widget,&special_info);o               }n             break;           }i5         if (MatteIsActive(action_info,event.xbutton))            {a             /*)               User pressed action button.              */%             action_info.raised=False;)F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))e           {              /*)               User pressed Cancel button.n             */%             cancel_info.raised=False;iF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }w5         if (!MatteIsActive(reply_info,event.xbutton))e           break;,         if (event.xbutton.button != Button2)           {e             static Timee               click_time;h               /*;               Move text cursor to position of button press.t             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;e             else               {f                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,%&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)%           {              /*&               User released up button.             */#             delay=SuspendTime << 2;f#             north_info.raised=True;sE             XDrawTriangleNorth(display,&windows->widget,&north_info);r           }s         if (!south_info.raised)            {t             /*(               User released down button.             */#             delay=SuspendTime << 2;o#             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);e           }g         if (slider_info.active)h           {              /*#               Stop tracking slider.x             */%             slider_info.active=False;w             break;           }          if (!up_info.raised)           {t;             if (event.xbutton.window == windows->widget.id)i7               if (MatteIsActive(up_info,event.xbutton))e                 { 8                   (void) strcpy(working_directory,"..");)                   state|=UpdateListState;c                 }e              up_info.raised=True;B             XDrawBeveledButton(display,&windows->widget,&up_info);           }          if (!home_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(home_info,event.xbutton))                  { B                   (void) strcpy(working_directory,home_directory);)                   state|=UpdateListState;                  }r"             home_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&home_info);           }e!         if (!special_info.raised)            {r;             if (event.xbutton.window == windows->widget.id)o<               if (MatteIsActive(special_info,event.xbutton))                 {-6                   (void) strcpy(reply_info.text,"x:");#                   state|=ExitState;                  } %             special_info.raised=True;tG             XDrawBeveledButton(display,&windows->widget,&special_info);r           }f          if (!action_info.raised)           {e;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }t          if (!cancel_info.raised)           {t;             if (event.xbutton.window == windows->widget.id)t;               if (MatteIsActive(cancel_info,event.xbutton)))                 {c(                   *reply_info.text='\0';#                   state|=ExitState;-                 } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }        case ClientMessage:%       {%
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }%         break;       }%       case ConfigureNotify:%       {%
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=tB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }d       case EnterNotify:        {_9         if (event.xcrossing.window != windows->widget.id)>           break;&         state&=(~InactiveWidgetState);         break;       }w       case Expose:       {w7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)=           break;!         state|=RedrawWidgetState;u         break;       }=       case KeyPress:       {n         static charx!           command[MaxTextLength];            static int           length;%           static KeySym%           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;%                 break;               }%               case XK_Up:F               case XK_KP_Up:               {r!                 slider_info.id--;r                 break;               }                case XK_Down:i               case XK_KP_Down:               {a!                 slider_info.id++;d                 break;               }y               case XK_Prior:               case XK_KP_Prior:n               {e.                 slider_info.id-=visible_files;                 break;               }t               case XK_Next:h               case XK_KP_Next:               { .                 slider_info.id+=visible_files;                 break;               }t               case XK_End:               case XK_KP_End:a               { %                 slider_info.id=files;                  break;               }e
             }r#             state|=RedrawListState;s             break;           }RE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {w             /*1               Read new directory or glob patterm.l             */)             if (*reply_info.text == '\0')                break;(             if (IsGlob(reply_info.text)):               (void) strcpy(glob_pattern,reply_info.text);             else               {_A                 (void) strcpy(working_directory,reply_info.text);d.                 if (*working_directory == '~')4                   ExpandFilename(working_directory);               }%#             state|=UpdateListState;%             break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }%             default:               break;           }%@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);i         state|=JumpListState;          break;       }i       case KeyRelease:       {i         static char !           command[MaxTextLength];r           static KeySyms           key_symbol;e  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),c/           &key_symbol,(XComposeStatus *) NULL);l'         if (key_symbol == XK_Control_L)t!           state&=(~ControlState);          break;       }d       case LeaveNotify:i       {i9         if (event.xcrossing.window != windows->widget.id)y           break;#         state|=InactiveWidgetState;n         break;       }        case MapNotify:m       {s         mask&=(~CWX);          mask&=(~CWY);x         break;       }d       case MotionNotify:       {t
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)h           {)             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;=3             if (slider_info.y != slider_info.min_y)iI               slider_info.id=(files*(slider_info.y-slider_info.min_y+1))/f8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;C         if (up_info.raised == MatteIsActive(up_info,event.xmotion))=           {              /*'               Up button status changed.c             */+             up_info.raised=!up_info.raised;aB             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } G         if (home_info.raised == MatteIsActive(home_info,event.xmotion))u           {y             /*)               Home button status changed.n             *//             home_info.raised=!home_info.raised; D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }lM         if (special_info.raised == MatteIsActive(special_info,event.xmotion))%           {%             /*)               Grab button status changed.              */5             special_info.raised=!special_info.raised; G             XDrawBeveledButton(display,&windows->widget,&special_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))%           {%             /*+               Cancel button status changed.C             */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }a       case SelectionClear:       {s#         reply_info.highlight=False;l=         XDrawMatteText(display,&windows->widget,&reply_info);w         break;       }o       case SelectionNotify:r       {          Atom           type;r           intc           format,            status;i           unsigned char            *data;           unsigned longv           after,           length;o  
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||e             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);h         else           {f             /*5               Insert primary selection in reply text.p             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,>               state); A             XDrawMatteText(display,&windows->widget,&reply_info); !             state|=JumpListState;>%             state|=RedrawActionState;p           }a         XFree((void *) data);          break;       }%       case SelectionRequest:       {%         XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }c       default:         break;     }a!   } while (!(state & ExitState));e)   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);i(   XCheckRefreshWindows(display,windows);   /*     Free file list.e   */   for (i=0; i < files; i++)o     free((char *) filelist[i]);n!   if (filelist != (char **) NULL)w     free((char *) filelist);   if (*reply == '~')     ExpandFilename(reply); }f a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %wO %                                                                             %;O %                                                                             %gO %   X F o n t B r o w s e r W i d g e t                                       % O %                                                                             %lO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XFontBrowserWidget displays a Font Browser widget with a font query N %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. % 3 %  The format of the XFontBrowserWidget routine is:  % 5 %    XFontBrowserWidget(display,windows,action,reply)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from% %      XOpenDisplay. %%; %    o window: Specifies a pointer to a XWindows structure.g %h@ %    o action: Specifies a pointer to the action of this widget. %eG %    o reply: The response from the user is returned in this parameter.o %i %) */ static int FontCompare(x,y)r
 const void   *x,    *y;o {s   register char      *p,o     *q;l     p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {c     p++;     q++;   }:   return(*p-(*q)); }o  5 void XFontBrowserWidget(display,windows,action,reply)  Display    *display;c   XWindows   *windows;    char
   *action,	   *reply;a {i #define BackButtonText  "Back"" #define CancelButtonText  "Cancel" #define FontnameText  "Name:"s# #define FontPatternText  "Pattern:"   #define ResetButtonText  "Reset"     char      back_pattern[MaxTextLength],     **fontlist,      **listhead,s%     primary_selection[MaxTextLength],n!     reset_pattern[MaxTextLength],      text[MaxTextLength];     ints
     fonts,     status,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";  
   static char *     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,-     text_width,)     visible_fonts,
     width;     unsigned long_
     delay,
     state;     XEvent
     event;  
   XFontStructx     *font_info;S     XTextPropertyy     window_name;  
   XWidgetInfo      action_info,     back_info,     cancel_info,     expose_info,     list_info,     mode_info,     north_info,      reply_info,-     reset_info,g     scroll_info,     selection_info,%     slider_info,     south_info,%     text_info;     XWindowChanges     window_changes;      /*.     Get font list and sort in ascending order.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);+   (void) strcpy(back_pattern,glob_pattern); #   (void) strcpy(reset_pattern,"*"); 9   fontlist=XListFonts(display,glob_pattern,32767,&fonts);    if (fonts == 0)      {        /*-         Pattern failed, obtain all the fonts.        */D       XNoticeWidget(display,windows,"Unable to obtain fonts names:",         glob_pattern);&       (void) strcpy(glob_pattern,"*");=       fontlist=XListFonts(display,glob_pattern,32767,&fonts);%%       if (fontlist == (char **) NULL)%	         { H           XNoticeWidget(display,windows,"Unable to obtain fonts names:",             glob_pattern);           return;a	         }p     }t   /*&     Sort font list in ascending order.   */   listhead=fontlist;3   fontlist=(char **) malloc(fonts*sizeof(char **));e!   if (fontlist == (char **) NULL)      {X<       XNoticeWidget(display,windows,"Unable to view fonts:",$         "Memory allocation failed");
       return;l     }c   for (i=0; i < fonts; i++)r     fontlist[i]=listhead[i];0   qsort((void *) fontlist,fonts,sizeof(char **),B     (int (*) _Declare((const void *, const void *))) FontCompare);   /*-     Determine Font Browser widget attributes.    */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < fonts; i++)dK     if (XTextWidth(font_info,fontlist[i],strlen(fontlist[i])) > text_width) G       text_width=XTextWidth(font_info,fontlist[i],strlen(fontlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,BackButtonText,strlen(BackButtonText)) > width)F     width=XTextWidth(font_info,BackButtonText,strlen(BackButtonText));   width+=QuantumMargin; L   if (XTextWidth(font_info,FontPatternText,strlen(FontPatternText)) > width)H     width=XTextWidth(font_info,FontPatternText,strlen(FontPatternText));F   if (XTextWidth(font_info,FontnameText,strlen(FontnameText)) > width)B     width=XTextWidth(font_info,FontnameText,strlen(FontnameText));.   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.t   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin;n8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((85*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((27*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);,   /*     Map Font Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a Font"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width;o/   window_changes.height=windows->widget.height;,%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;TN   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes);i)   XMapRaised(display,windows->widget.id);u   windows->widget.mapped=False;;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);t,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_fonts=0;   delay=SuspendTime << 2;n!   state=UpdateConfigurationState;i   do   {d)     if (state & UpdateConfigurationState)a       {)         intx
           id;o  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;eN         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;eL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(BackButtonText,&back_info);         back_info.width=width;)         back_info.height=(3*height) >> 1;t"         back_info.x=QuantumMargin;4         back_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width;e*         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin;.@         reset_info.y=back_info.y+back_info.height+QuantumMargin;
         /*'           Initialize reply information.t
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;iN         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);K         reply_info.y=action_info.y-(action_info.height << 1)-QuantumMargin; 
         /*&           Initialize mode information.
         */)         XGetWidgetInfo(reply,&mode_info);p          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin;.1         mode_info.height=action_info.height << 1;)!         mode_info.x=reply_info.x;&M         mode_info.y=action_info.y-action_info.height+action_info.bevel_width; 
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;aI         scroll_info.height=reply_info.y-back_info.y-(QuantumMargin >> 1);xH         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=back_info.y-reply_info.bevel_width;e!         scroll_info.raised=False;r          scroll_info.trough=True;         north_info=scroll_info;i         north_info.raised=True;i8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;>-         north_info.x+=north_info.bevel_width;e-         north_info.y+=north_info.bevel_width;a         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;uP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=>J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_fonts=A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3); "         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);T         list_info.raised=False;t          list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;;"         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState;c
         /*&           Initialize text information.
         */         *text='\0'; (         XGetWidgetInfo(text,&text_info);         text_info.center=False; )         text_info.width=reply_info.width;n          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information.l
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;h+         state&=(~UpdateConfigurationState);o       }y"     if (state & RedrawWidgetState)       {.
         /*%           Redraw Font Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,7           x,y,FontPatternText,strlen(FontPatternText));.9         (void) sprintf(text_info.text,"%s",glob_pattern);s=         XDrawWidgetText(display,&windows->widget,&text_info);s@         XDrawBeveledButton(display,&windows->widget,&back_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info);o?         XDrawBeveledMatte(display,&windows->widget,&list_info);_A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);;A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);n         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;tP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FontnameText,strlen(FontnameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);nB         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0);n!         state|=RedrawActionState;t         state|=RedrawListState;t$         state&=(~RedrawWidgetState);       }f      if (state & UpdateListState)       {n         char           **checklist;           int            number_fonts;U  
         /*           Update font list.o
         */G         checklist=XListFonts(display,glob_pattern,32767,&number_fonts);o(         if (checklist == (char **) NULL)           {_>             if ((strchr(glob_pattern,'*') == (char *) NULL) &&<                 (strchr(glob_pattern,'?') == (char *) NULL))               {l                 /*3                   Might be a scaleable font-- exit.i                 */2                 (void) strcpy(reply,glob_pattern);9                 (void) strcpy(glob_pattern,back_pattern);_)                 action_info.raised=False;rJ                 XDrawBeveledButton(display,&windows->widget,&action_info);                 break;               },5             (void) strcpy(glob_pattern,back_pattern);t             XBell(display,0);a           }          else            if (number_fonts == 1)
             {                /*3                 Reply is a single font name-- exit.                */0               (void) strcpy(reply,checklist[0]);7               (void) strcpy(glob_pattern,back_pattern);)(               XFreeFontNames(checklist);'               action_info.raised=False;aH               XDrawBeveledButton(display,&windows->widget,&action_info);               break;
             }y           else
             {_'               XFreeFontNames(listhead);a&               free((char *) fontlist);!               fontlist=checklist;n!               fonts=number_fonts; 
             }l
         /*,           Sort font list in ascending order.
         */         listhead=fontlist;9         fontlist=(char **) malloc(fonts*sizeof(char **));w'         if (fontlist == (char **) NULL)d           {yB             XNoticeWidget(display,windows,"Unable to view fonts:",*               "Memory allocation failed");             return;n           } !         for (i=0; i < fonts; i++) "           fontlist[i]=listhead[i];6         qsort((void *) fontlist,fonts,sizeof(char **),H           (int (*) _Declare((const void *, const void *))) FontCompare);         slider_info.height=rJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0;p(         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);i         list_info.id=(~0);         state|=RedrawListState; 
         /*#           Redraw font name & reply. 
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern);t=         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info);sA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);(A         XDrawTriangleNorth(display,&windows->widget,&north_info);)B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);iM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);g"         state&=(~UpdateListState);       }+     if (state & JumpListState)       { 
         /*)           Jump scroll to match user font.o
         */         list_info.id=(~0);!         for (i=0; i < fonts; i++)i-           if (strcmp(fontlist[i],reply) >= 0) 
             {.C               list_info.id=strcmp(fontlist[i],reply) == 0 ? i : ~0;.               break;
             }nJ         if ((i < slider_info.id) || (i >= (slider_info.id+visible_fonts)))0           slider_info.id=i-(visible_fonts >> 1);         selection_info.id=(~0);e         state|=RedrawListState;o          state&=(~JumpListState);       }t      if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */:         if (slider_info.id >= (int) (fonts-visible_fonts))-           slider_info.id=fonts-visible_fonts;l=         if ((slider_info.id < 0) || (fonts <= visible_fonts))n           slider_info.id=0;v(         slider_info.y=slider_info.min_y;         if (fonts > 0)           slider_info.y+=wI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/fonts;,0         if (slider_info.id != selection_info.id)           {;             /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_fonts; i++) 
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < fonts)o?                 selection_info.text=fontlist[slider_info.id+i]; H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {s?                 expose_info.height=slider_info.y-expose_info.y;(?                 expose_info.y=slider_info.y-expose_info.height-l,                   slider_info.bevel_width-1;               }              else               {d?                 expose_info.height=expose_info.y-slider_info.y;r?                 expose_info.y=slider_info.y+slider_info.height+n,                   slider_info.bevel_width+1;               }lE             XDrawTriangleNorth(display,&windows->widget,&north_info);l>             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);.(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       })"     if (state & RedrawActionState)       {s         XFontStruct            *font_info,e           *save_info;>  
         /*6           Display the selected font in a drawing area.
         */,         save_info=windows->widget.font_info;:         font_info=XLoadQueryFont(display,reply_info.text);.         if (font_info != (XFontStruct *) NULL)           {x1             windows->widget.font_info=font_info;; L             XSetFont(display,windows->widget.widget_context,font_info->fid);           }.@         XDrawBeveledButton(display,&windows->widget,&mode_info);,         windows->widget.font_info=save_info;.         if (font_info != (XFontStruct *) NULL)           {i<             XSetFont(display,windows->widget.widget_context,.               windows->widget.font_info->fid);)             XFreeFont(display,font_info);h           } M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);v=         XDrawMatteText(display,&windows->widget,&reply_info); $         state&=(~RedrawActionState);       }u     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)s=       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       {a
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)f!           if (slider_info.id > 0)t
             {i               /*                 Move slider up.d               */               slider_info.id--;)%               state|=RedrawListState;s
             }_         if (!south_info.raised)w%           if (slider_info.id < fonts);
             {i               /*!                 Move slider down.o               */               slider_info.id++;s%               state|=RedrawListState; 
             }S(         if (event.type != ButtonRelease)           continue;        }e     switch (event.type)f     {e       case ButtonPress:D       {d5         if (MatteIsActive(slider_info,event.xbutton))i           {.             /*               Track slider.&             */$             slider_info.active=True;             break;           }o4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)*
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;p%               state|=RedrawListState;,               break;
             };4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < fonts) 
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;(               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_fonts-1);             else0               slider_info.id+=(visible_fonts-1);#             state|=RedrawListState;(             break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= fonts)               break;8             (void) strcpy(reply_info.text,fontlist[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState;=#             if (id == list_info.id)+               { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;v               } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           }d3         if (MatteIsActive(back_info,event.xbutton))            {l             /*'               User pressed Back button.d             */#             back_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           }n5         if (MatteIsActive(action_info,event.xbutton))g           {              /*)               User pressed action button.e             */%             action_info.raised=False;;F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }e5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))(           break;,         if (event.xbutton.button != Button2)           {p             static Time                click_time;b               /*;               Move text cursor to position of button press.g             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {p                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;n               }nA             XDrawMatteText(display,&windows->widget,&reply_info);y*             click_time=event.xbutton.time;             break;           })
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);/         break;       }.       case ButtonRelease:        {l$         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {A             /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True;fE             XDrawTriangleNorth(display,&windows->widget,&north_info);e           }o         if (!south_info.raised)            {f             /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);u           }i         if (slider_info.active)            {              /*#               Stop tracking slider.;             */%             slider_info.active=False;r             break;           }x         if (!back_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)o9               if (MatteIsActive(back_info,event.xbutton))i                 { ;                   (void) strcpy(glob_pattern,back_pattern); )                   state|=UpdateListState;                  }e"             back_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&back_info);           }          if (!reset_info.raised)d           {M;             if (event.xbutton.window == windows->widget.id)e:               if (MatteIsActive(reset_info,event.xbutton))                 { ;                   (void) strcpy(back_pattern,glob_pattern); <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;t                 }r#             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);i           }A          if (!action_info.raised)           {d;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton))m-                 if (*reply_info.text == '\0')f#                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }-          if (!cancel_info.raised)           {f;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  {<(                   *reply_info.text='\0';#                   state|=ExitState;l                 },$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }l         break;       }        case ClientMessage:e       { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);)             break;           }f?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }e         break;       }        case ConfigureNotify:u       { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height==B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:n       {.9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {,7         if (event.xexpose.window != windows->widget.id)S           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;n         break;       }        case KeyPress:       {          static char !           command[MaxTextLength];-           static int           length;t           static KeySymt           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);n         *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol)n
             {!               case XK_Home:                case XK_KP_Home:               {=!                 slider_info.id=0;                  break;               }e               case XK_Up:a               case XK_KP_Up:               { !                 slider_info.id--;                  break;               }o               case XK_Down:                case XK_KP_Down:               {i!                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { .                 slider_info.id-=visible_fonts;                 break;               }o               case XK_Next:v               case XK_KP_Next:               { .                 slider_info.id+=visible_fonts;                 break;               }                case XK_End:               case XK_KP_End:                { %                 slider_info.id=fonts;a                 break;               }m
             } #             state|=RedrawListState;              break;           }dE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*,               Read new font or glob patterm.             */)             if (*reply_info.text == '\0')                break;5             (void) strcpy(back_pattern,glob_pattern);E8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           }0'         if (key_symbol == XK_Control_L)a           {               state|=ControlState;             break;           } !         if (state & ControlState)T           switch (key_symbol)i           {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);a         state|=JumpListState;e         break;       }        case KeyRelease:       {.         static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);e'         if (key_symbol == XK_Control_L)r!           state&=(~ControlState);          break;       }_       case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;d         break;       }s       case MapNotify:a       {          mask&=(~CWX);          mask&=(~CWY);          break;       }        case MotionNotify:       {d
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)=           {|             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(fonts*(slider_info.y-slider_info.min_y+1))/a8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;n             break;           } (         if (state & InactiveWidgetState)           break;G         if (back_info.raised == MatteIsActive(back_info,event.xmotion))o           {              /*)               Back button status changed.              *//             back_info.raised=!back_info.raised; D             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }yI         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))t           {l             /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised;RE             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))l           {              /*+               Action button status changed.;             */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }oK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))t           {l             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }~       case SelectionClear:       { #         reply_info.highlight=False;N=         XDrawMatteText(display,&windows->widget,&reply_info);m         break;       }/       case SelectionNotify:e       {y         Atom           type;            intr           format,            status;            unsigned chars           *data;           unsigned longl           after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)r           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||.             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {i             /*5               Insert primary selection in reply text.I             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state);sA             XDrawMatteText(display,&windows->widget,&reply_info);d!             state|=JumpListState; %             state|=RedrawActionState;e           }          XFree((void *) data);n         break;       }        case SelectionRequest:       {u         XSelectionEvent            notify;            XSelectionRequestEvent           *request;   
         /*#           Set XA_PRIMARY selection.i
         */-         request=(&(event.xselectionrequest));nN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));d$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState));-)   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);y(   XCheckRefreshWindows(display,windows);   /*     Free font list.    */   XFreeFontNames(listhead);    free((char *) fontlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             % O %                                                                             % O %                                                                             % O %   X I n f o W i d g e t                                                     %NO %                                                                             %fO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %iL %  Function XInfoWidget displays text in the Info widget.  The purpose is toH %  inform the user that what activity is currently being performed (e.g.. %  reading an image, rotating an image, etc.). %t, %  The format of the XInfoWidget routine is: %F* %    XInfoWidget(display,windows,activity) % + %  A description of each parameter follows:  %SE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % K %    o activity: This character string reflects the current activity and isr$ %      displayed in the Info widget. %s %d */* void XInfoWidget(display,windows,activity) Displaye   *display;,   XWindows   *windows;e   char   *activity; {o   unsigned int     height,s     margin, 
     width;  
   XFontStructN     *font_info;o     XWindowChanges     window_changes;s     /*     Map Info widget.   */$   font_info=windows->info.font_info;   width=O     XTextWidth(font_info,activity,strlen(activity))+((3*QuantumMargin) >> 1)+4;o=   height=((6*(font_info->ascent+font_info->descent)) >> 2)+4;)I   if ((windows->info.width != width) || (windows->info.height != height))y     {t       /*9         Size Info widget to accomodate the activity text.e       */        windows->info.width=width;"       windows->info.height=height;!       window_changes.width=width; #       window_changes.height=height; I       XReconfigureWMWindow(display,windows->info.id,windows->info.screen,-,         CWWidth | CWHeight,&window_changes);     }W   if (!windows->info.mapped)     {r+       XMapRaised(display,windows->info.id);         windows->info.mapped=True;     }    /*&     Initialize Info matte information.   */.   height=font_info->ascent+font_info->descent;)   XGetWidgetInfo(activity,&monitor_info);;   monitor_info.bevel_width--; I   margin=monitor_info.bevel_width+((windows->info.height-height) >> 1)-2;    monitor_info.center=False;   monitor_info.x=margin;   monitor_info.y=margin;7   monitor_info.width=windows->info.width-(margin << 1); ;   monitor_info.height=windows->info.height-(margin << 1)+1;    /*     Draw Info widget.    */   monitor_info.raised=False;:   XDrawBeveledMatte(display,&windows->info,&monitor_info);   monitor_info.raised=True; 8   XDrawWidgetText(display,&windows->info,&monitor_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   X L i s t B r o w s e r W i d g e t                                       %aO %                                                                             % O %                                                                             %mO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t % M %  Function XListBrowserWidget displays a List Browser widget with a query tosN %  the user.  The user keys a reply or select a reply from the list.  Finally,K %  the user presses the Action or Cancel button to exit.  The typed text is , %  returned as the reply function parameter. %o3 %  The format of the XListBrowserWidget routine is:n % L %    XListBrowserWidget(display,windows,window_info,list,action,query,reply) %i+ %  A description of each parameter follows:s % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %i; %    o window: Specifies a pointer to a XWindows structure.  %xF %    o list: Specifies a pointer to an array of strings.  The user can; %      select from these strings as a possible reply value.0 %x@ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. %0G %    o reply: The response from the user is returned in this parameter.  %f %x */L void XListBrowserWidget(display,windows,window_info,list,action,query,reply) Display0   *display;    XWindows   *windows;x   XWindowInfo    *window_info;    char	   **list,x
   *action,	   *query,x	   *reply;x { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];x     int      entries,     status,0     x,     y;  
   static charx*     mask = CWWidth | CWHeight | CWX | CWY;     register int     i;     unsigned int     height,      text_width,x     visible_entries,
     width;     unsigned longx
     delay,
     state;     XEvent
     event;  
   XFontStructx     *font_info;      XTextProperty0     window_name;  
   XWidgetInfof     action_info,     cancel_info,     expose_info,     list_info,     north_info,x     reply_info,x     scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;c     /*,     Count the number of entries in the list.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (list == (char **) NULL)      {xH       XNoticeWidget(display,windows,"No text to browse:",(char *) NULL);
       return;x     }0   for (entries=0; ; entries++)'     if (list[entries] == (char *) NULL)        break;   /*-     Determine Font Browser widget attributes.x   */#   font_info=window_info->font_info;e7   text_width=XTextWidth(font_info,query,strlen(query));x   for (i=0; i < entries; i++)8C     if (XTextWidth(font_info,list[i],strlen(list[i])) > text_width)x?       text_width=XTextWidth(font_info,list[i],strlen(list[i]));x4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));   width+=QuantumMargin;f.   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.f   */K   window_info->width=Min(text_width,MaxTextWidth)+((9*QuantumMargin) >> 1);06   window_info->min_width=MinTextWidth+4*QuantumMargin;2   if (window_info->width < window_info->min_width).     window_info->width=window_info->min_width;E   window_info->height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;0I   window_info->min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;x4   if (window_info->height < window_info->min_height)0     window_info->height=window_info->min_height;2   XQueryPosition(display,window_info->root,&x,&y);1   window_info->x=x-((3*window_info->width) >> 2); .   window_info->y=y-(window_info->height >> 1);0   XConstrainWindowPosition(display,window_info);   /*     Map Font Browser widget.   */,   (void) strcpy(window_info->name,"Browse");F   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status != 0)     {07       XSetWMName(display,window_info->id,&window_name);x>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }x*   window_changes.width=window_info->width;,   window_changes.height=window_info->height;"   window_changes.x=window_info->x;"   window_changes.y=window_info->y;H   XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,     &window_changes);0&   XMapRaised(display,window_info->id);   window_info->mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);0,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_entries=0;   delay=SuspendTime << 2;x!   state=UpdateConfigurationState;    do   {x)     if (state & UpdateConfigurationState)0       {x         int 
           id;x  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;xK         cancel_info.x=window_info->width-cancel_info.width-QuantumMargin-2;xK         cancel_info.y=window_info->height-cancel_info.height-QuantumMargin;x,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;xL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; E         reply_info.width=window_info->width-((4*QuantumMargin) >> 1); &         reply_info.height=height << 1;#         reply_info.x=QuantumMargin; C         reply_info.y=action_info.y-reply_info.height-QuantumMargin;3
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);0"         scroll_info.bevel_width--;!         scroll_info.width=height;0H         scroll_info.height=reply_info.y-((6*QuantumMargin) >> 1)-height;H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);M         scroll_info.y=((5*QuantumMargin) >> 1)+height-reply_info.bevel_width; !         scroll_info.raised=False;0          scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;08         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;x-         north_info.x+=north_info.bevel_width;x-         north_info.y+=north_info.bevel_width;x         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;xP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=xJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_entries=A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3);b&         if (entries > visible_entries)J           slider_info.height=(visible_entries*slider_info.height)/entries;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);n         list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;!         if (!window_info->mapped) %           for (i=0; i < entries; i++) +             if (strcmp(list[i],reply) == 0)                {-                 list_info.id=i;t8                 slider_info.id=i-(visible_entries >> 1);'                 if (slider_info.id < 0)d#                   slider_info.id=0;(               }1
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info);i)         text_info.width=reply_info.width;a          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1);U"         text_info.y=QuantumMargin;
         /*+           Initialize selection information.r
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;!.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;)+         state&=(~UpdateConfigurationState);o       }n"     if (state & RedrawWidgetState)       {i
         /*%           Redraw List Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; 8         XDrawWidgetText(display,window_info,&text_info);:         XDrawBeveledMatte(display,window_info,&list_info);<         XDrawBeveledMatte(display,window_info,&scroll_info);<         XDrawTriangleNorth(display,window_info,&north_info);=         XDrawBeveledButton(display,window_info,&slider_info);o<         XDrawTriangleSouth(display,window_info,&south_info);         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;o;         XDrawBeveledMatte(display,window_info,&reply_info);t8         XDrawMatteText(display,window_info,&reply_info);=         XDrawBeveledButton(display,window_info,&action_info);t=         XDrawBeveledButton(display,window_info,&cancel_info); H         XHighlightWidget(display,window_info,BorderOffset,BorderOffset);         selection_info.id=(~0);e!         state|=RedrawActionState;e         state|=RedrawListState;o$         state&=(~RedrawWidgetState);       }e      if (state & RedrawListState)       { 
         /*+           Determine slider id and position.n
         */>         if (slider_info.id >= (int) (entries-visible_entries))1           slider_info.id=entries-visible_entries; A         if ((slider_info.id < 0) || (entries <= visible_entries))o           slider_info.id=0;i(         slider_info.y=slider_info.min_y;         if (entries > 0)           slider_info.y+=wK             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/entries;a0         if (slider_info.id != selection_info.id)           {c             /*/               Redraw scroll bar and file names.i             */-             selection_info.id=slider_info.id;i9             selection_info.y=list_info.y+(height >> 3)+2; /             for (i=0; i < visible_entries; i++) 
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;/               if ((slider_info.id+i) < entries)C;                 selection_info.text=list[slider_info.id+i];dC               XDrawWidgetText(display,window_info,&selection_info);(<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {d?                 expose_info.height=slider_info.y-expose_info.y;a?                 expose_info.y=slider_info.y-expose_info.height-e,                   slider_info.bevel_width-1;               }d             else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } @             XDrawTriangleNorth(display,window_info,&north_info);9             XDrawMatte(display,window_info,&expose_info);eA             XDrawBeveledButton(display,window_info,&slider_info); @             XDrawTriangleSouth(display,window_info,&south_info);(             expose_info.y=slider_info.y;           }g"         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)o!           if (slider_info.id > 0)o
             {b               /*                 Move slider up.(               */               slider_info.id--; %               state|=RedrawListState;d
             }          if (!south_info.raised)_'           if (slider_info.id < entries) 
             {                /*!                 Move slider down.n               */               slider_info.id++;e%               state|=RedrawListState;i
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)f     {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))s           {i             /*               Track slider.o             */$             slider_info.active=True;             break;           }=4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)u
             {h               /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;S               break;
             }s4         if (MatteIsActive(south_info,event.xbutton))'           if (slider_info.id < entries)d
             {t               /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++;>%               state|=RedrawListState;                break;
             }o5         if (MatteIsActive(scroll_info,event.xbutton))            {a             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)2               slider_info.id-=(visible_entries-1);             else2               slider_info.id+=(visible_entries-1);#             state|=RedrawListState;              break;           }i3         if (MatteIsActive(list_info,event.xbutton))G           {s             unsigned int               id;e               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= entries)               break;4             (void) strcpy(reply_info.text,list[id]);'             reply_info.highlight=False;h.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);<             XDrawMatteText(display,window_info,&reply_info);#             selection_info.id=(~0); #             if (id == list_info.id)h               {i)                 action_info.raised=False;.E                 XDrawBeveledButton(display,window_info,&action_info);d!                 state|=ExitState;r               }n             list_info.id=id;#             state|=RedrawListState;              break;           }a5         if (MatteIsActive(action_info,event.xbutton))/           {p             /*)               User pressed action button.i             */%             action_info.raised=False;LA             XDrawBeveledButton(display,window_info,&action_info);              break;           }m5         if (MatteIsActive(cancel_info,event.xbutton))a           {x             /*)               User pressed Cancel button.n             */%             cancel_info.raised=False;(A             XDrawBeveledButton(display,window_info,&cancel_info);c             break;           }D5         if (!MatteIsActive(reply_info,event.xbutton))n           break;,         if (event.xbutton.button != Button2)           {              static Time=               click_time;.               /*;               Move text cursor to position of button press.h             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); F                 XSetSelectionOwner(display,XA_PRIMARY,window_info->id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) =="                   window_info->id;               } <             XDrawMatteText(display,window_info,&reply_info);*             click_time=event.xbutton.time;             break;           }o
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, .           window_info->id,event.xbutton.time);         break;       }n       case ButtonRelease:m       {a!         if (!window_info->mapped)a           break;         if (!north_info.raised)n           {e             /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True;f@             XDrawTriangleNorth(display,window_info,&north_info);           }s         if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2;t#             south_info.raised=True;t@             XDrawTriangleSouth(display,window_info,&south_info);           }W         if (slider_info.active)m           {q             /*#               Stop tracking slider.d             */%             slider_info.active=False;              break;           }           if (!action_info.raised)           {d8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);g                 else#                   state|=ExitState;/$             action_info.raised=True;A             XDrawBeveledButton(display,window_info,&action_info);n           }B          if (!cancel_info.raised)           {x8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(cancel_info,event.xbutton))B                 {t(                   *reply_info.text='\0';#                   state|=ExitState;i                 })$             cancel_info.raised=True;A             XDrawBeveledButton(display,window_info,&cancel_info);U           }(5         if (!MatteIsActive(reply_info,event.xbutton))t           break;         break;       }i       case ClientMessage:e       {t
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {_G             XSetInputFocus(display,event.xclient.window,RevertToParent,w'               event.xclient.data.l[1]);e             break;           }d?         if (*event.xclient.data.l != windows->wm_delete_window)d           break;4         if (event.xclient.window == window_info->id)           {,"             *reply_info.text='\0';             state|=ExitState;i             break;           }d         break;       }n       case ConfigureNotify:&       {w
         /*&           Update widget configuration.
         */7         if (event.xconfigure.window != window_info->id)e           break;=         if ((event.xconfigure.width == window_info->width) && =             (event.xconfigure.height == window_info->height))            break;         window_info->width=o=           Max(event.xconfigure.width,window_info->min_width);i         window_info->height=?           Max(event.xconfigure.height,window_info->min_height); (         state|=UpdateConfigurationState;         break;       }i       case EnterNotify:M       {s6         if (event.xcrossing.window != window_info->id)           break;&         state&=(~InactiveWidgetState);         break;       }t       case Expose:       {p4         if (event.xexpose.window != window_info->id)           break;%         if (event.xexpose.count != 0)u           break;!         state|=RedrawWidgetState;(         break;       }o       case KeyPress:       {          static charN!           command[MaxTextLength];            static int           length;c           static KeySymc           key_symbol;r  1         if (event.xkey.window != window_info->id),           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),c/           &key_symbol,(XComposeStatus *) NULL);g         *(command+length)='\0';e1         if (AreaIsActive(scroll_info,event.xkey))            {x             /*               Move slider.             */             switch (key_symbol)r
             {                case XK_Home:                case XK_KP_Home:               {t!                 slider_info.id=0;e                 break;               }w               case XK_Up:                case XK_KP_Up:               {<!                 slider_info.id--;i                 break;               }_               case XK_Down:g               case XK_KP_Down:               {h!                 slider_info.id++;                  break;               }e               case XK_Prior:               case XK_KP_Prior:                {a0                 slider_info.id-=visible_entries;                 break;               }                case XK_Next:h               case XK_KP_Next:               { 0                 slider_info.id+=visible_entries;                 break;               }n               case XK_End:               case XK_KP_End:                {n'                 slider_info.id=entries;                  break;               }w
             }i#             state|=RedrawListState;l             break;           }BE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {r             /*               Read new entry.n             */)             if (*reply_info.text == '\0')                break;%             action_info.raised=False;tA             XDrawBeveledButton(display,window_info,&action_info);*             state|=ExitState;              break;           } '         if (key_symbol == XK_Control_L)            {d              state|=ControlState;             break;           } !         if (state & ControlState)t           switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           }-@         XEditText(display,&reply_info,key_symbol,command,state);8         XDrawMatteText(display,window_info,&reply_info);         break;       }        case KeyRelease:       {s         static char,!           command[MaxTextLength];            static KeySym            key_symbol;   1         if (event.xkey.window != window_info->id)            break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L)e!           state&=(~ControlState);          break;       }        case LeaveNotify:        { 6         if (event.xcrossing.window != window_info->id)           break;#         state|=InactiveWidgetState;          break;       }        case MapNotify:        {t         mask&=(~CWX);o         mask&=(~CWY);          break;       }t       case MotionNotify:       {n
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));s         if (slider_info.active)r           {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y)tK               slider_info.id=(entries*(slider_info.y-slider_info.min_y+1))/n8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;.             break;           }.(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))c           {w             /*+               Action button status changed.I             */3             action_info.raised=!action_info.raised; A             XDrawBeveledButton(display,window_info,&action_info);              break;           }.K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; A             XDrawBeveledButton(display,window_info,&cancel_info);t             break;           }*         break;       }u       case SelectionClear:       {v#         reply_info.highlight=False;n8         XDrawMatteText(display,window_info,&reply_info);         break;       }        case SelectionNotify:_       {|         Atom           type;            int            format,f           status;            unsigned chart           *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection.L
         */5         if (event.xselection.property == (Atom) None)w           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.c             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,;               state); <             XDrawMatteText(display,window_info,&reply_info);%             state|=RedrawActionState;            }t         XFree((void *) data);          break;       }r       case SelectionRequest:       {D         XSelectionEvent&           notify;s           XSelectionRequestEvent           *request;a  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));iN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     }%!   } while (!(state & ExitState));%)   XSetCursorState(display,windows,False); ?   XWithdrawWindow(display,window_info->id,window_info->screen); (   XCheckRefreshWindows(display,windows); }r n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %yO %                                                                             % O %                                                                             %XO %   X M e n u W i d g e t                                                     % O %                                                                             %eO %                                                                             %hO %                                                                             %WO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nM %  Function XMenuWidget maps a menu and returns the command pointed to by thet$ %  user when the button is released. %o, %  The format of the XMenuWidget routine is: %,H %    selection_number=XMenuWidget(display,windows,title,selections,item) %l+ %  A description of each parameter follows:g % G %    o selection_number: Specifies the number of the selection that the  %      user choose.n %nE %    o display: Specifies a connection to an X server;  returned fromn %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.n %CN %    o title: Specifies a character string that describes the menu selections. %/K %    o selections: Specifies a pointer to one or more strings that comprisei %      the choices in the menu.o %tJ %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %  %t */6 int XMenuWidget(display,windows,title,selections,item) Display    *display;n   XWindows   *windows;t   char	   *title,f   **selections;;   char   *item; {D   Cursor     cursor;      intw     id,t     x,     y;     unsigned int     height,s     number_selections,     title_height,-     top_offset,=
     width;     unsigned longi
     state;     XEvent
     event;  
   XFontStructi     *font_info;d     XSetWindowAttributes     window_attributes;  
   XWidgetInfo;     highlight_info,e     menu_info,     selection_info;      XWindowChanges     window_changes;g     /*%     Determine Menu widget attributes.o   */&   font_info=windows->widget.font_info;.   windows->widget.width=!submenu_info.active ?2     XTextWidth(font_info,title,strlen(title)) : 0;3   for (id=0; selections[id] != (char *) NULL; id++)-   {eF     width=XTextWidth(font_info,selections[id],strlen(selections[id]));&     if (width > windows->widget.width)"       windows->widget.width=width;   }-   number_selections=id; +   XGetWidgetInfo((char *) NULL,&menu_info);w%   title_height=!submenu_info.active ?t:     (3*(font_info->descent+font_info->ascent) >> 1)+5 : 2;2   width=XTextWidth(font_info,title,strlen(title));9   height=(3*(font_info->ascent+font_info->descent)) >> 1;a   /*     Position Menu widget.g   */D   windows->widget.width+=QuantumMargin+(menu_info.bevel_width << 1);2   top_offset=title_height+menu_info.bevel_width-1;?   windows->widget.height=top_offset+number_selections*height+4;y2   windows->widget.min_width=windows->widget.width;4   windows->widget.min_height=windows->widget.height;5   XQueryPosition(display,windows->widget.root,&x,&y);.+   windows->widget.x=x-(QuantumMargin >> 1);.   if (submenu_info.active)     {a       windows->widget.x=@         windows->command.x+windows->command.width-QuantumMargin;       toggle_info.raised=True;@       XDrawTriangleEast(display,&windows->command,&toggle_info);     }iI   windows->widget.y=!submenu_info.active ? y-((3*title_height) >> 2) : y;    if (submenu_info.active)8     windows->widget.y=windows->command.y+submenu_info.y;5   XConstrainWindowPosition(display,&windows->widget);i   /*     Map Menu widget.   */+   window_attributes.override_redirect=True;iH   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);-   window_changes.width=windows->widget.width;e/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,c4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);.   windows->widget.mapped=False;    /*     Respond to X events.   */   selection_info.height=height;o1   cursor=XCreateFontCursor(display,XC_right_ptr);s2   XDefineCursor(display,windows->image.id,cursor);4   XDefineCursor(display,windows->command.id,cursor);3   XDefineCursor(display,windows->widget.id,cursor);l!   state=UpdateConfigurationState;    do   {_)     if (state & UpdateConfigurationState)t       { 
         /*+           Initialize selection information. 
         */1         XGetWidgetInfo((char *) NULL,&menu_info);           menu_info.bevel_width--;M         menu_info.width=windows->widget.width-((menu_info.bevel_width) << 1);>O         menu_info.height=windows->widget.height-((menu_info.bevel_width) << 1);p*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=menu_info.width; %         selection_info.height=height;;%         selection_info.x=menu_info.x;0&         highlight_info=selection_info;%         highlight_info.bevel_width--;e@         highlight_info.width-=(highlight_info.bevel_width << 1);A         highlight_info.height-=(highlight_info.bevel_width << 1);i5         highlight_info.x+=highlight_info.bevel_width;u+         state&=(~UpdateConfigurationState);u       } "     if (state & RedrawWidgetState)       {t
         /*           Redraw Menu widget. 
         */!         if (!submenu_info.active)            {              y=title_height; ;             XSetBevelColor(display,&windows->widget,False);&P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,C               selection_info.x,y-1,(int) selection_info.width,y-1); :             XSetBevelColor(display,&windows->widget,True);P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,?               selection_info.x,y,(int) selection_info.width,y);cL             XSetFillStyle(display,windows->widget.widget_context,FillSolid);           } 
         /*           Draw menu selections. 
         */#         selection_info.center=True; /         selection_info.y=menu_info.bevel_width;i"         selection_info.text=title;!         if (!submenu_info.active) D           XDrawWidgetText(display,&windows->widget,&selection_info);$         selection_info.center=False;$         selection_info.y=top_offset;0         for (id=0; id < number_selections; id++)	         {a-           selection_info.text=selections[id]; D           XDrawWidgetText(display,&windows->widget,&selection_info);G           highlight_info.y=selection_info.y+highlight_info.bevel_width;v&           if (id == selection_info.id)A             XDrawBevel(display,&windows->widget,&highlight_info); 8           selection_info.y+=(int) selection_info.height;	         }d8         XDrawBevel(display,&windows->widget,&menu_info);$         state&=(~RedrawWidgetState);       }l     if (number_selections > 2)       { 
         /*           Redraw Menu line.n
         */A         y=top_offset+selection_info.height*(number_selections-1); 7         XSetBevelColor(display,&windows->widget,False);oL         XDrawLine(display,windows->widget.id,windows->widget.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1);n6         XSetBevelColor(display,&windows->widget,True);L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,;           selection_info.x,y,(int) selection_info.width,y);nH         XSetFillStyle(display,windows->widget.widget_context,FillSolid);       }r     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {n       case ButtonPress:e       { 
         /*/           Discard pending button motion events. 
         */7         if (event.xbutton.window != windows->widget.id)            {              /*               Exit menu.             */             *item='\0';              state|=ExitState;)             break;           }n&         state&=(~InactiveWidgetState);D         id=(event.xbutton.y-top_offset)/(int) selection_info.height;         selection_info.id=id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */=         selection_info.y=top_offset+id*selection_info.height; +         selection_info.text=selections[id]; B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;T=         XDrawBevel(display,&windows->widget,&highlight_info);m         break;       }        case ButtonRelease:a       { $         if (!windows->widget.mapped)           break;
         /*           Exit menu.
         *//         XSetCursorState(display,windows,False);i         *item='\0';          state|=ExitState;v         break;       }o       case ConfigureNotify:E       {r
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:M       { 9         if (event.xcrossing.window != windows->widget.id)s           break;'         if (event.xcrossing.state == 0)y           break;&         state&=(~InactiveWidgetState);H         id=((event.xcrossing.y-top_offset)/(int) selection_info.height);P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {a             /*)               Unhighlight last selection.e             */(             if (id == selection_info.id)               break;             selection_info.y=wA               top_offset+selection_info.id*selection_info.height; >             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           } 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.;
         */         selection_info.id=id;nL         selection_info.y=top_offset+selection_info.id*selection_info.height;:         selection_info.text=selections[selection_info.id];B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;,=         XDrawBevel(display,&windows->widget,&highlight_info);n         break;       }        case Expose:       {y7         if (event.xexpose.window != windows->widget.id)w           break;%         if (event.xexpose.count != 0)v           break;!         state|=RedrawWidgetState;E         break;       }        case LeaveNotify:!       {-9         if (event.xcrossing.window != windows->widget.id)o           break;#         state|=InactiveWidgetState;e         id=selection_info.id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*%           Unhighlight last selection. 
         */=         selection_info.y=top_offset+id*selection_info.height;f         selection_info.id=(~0);i+         selection_info.text=selections[id]; B         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }n       case MotionNotify:       { 
         /*/           Discard pending button motion events.m
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));K          if (submenu_info.active):           if (event.xmotion.window == windows->command.id)/             if (!(state & InactiveWidgetState))                {S?                 if (!MatteIsActive(submenu_info,event.xmotion))=                   { +                     selection_info.id=(-1);                      *item='\0'; %                     state|=ExitState;                      break;                   }                }              elseA               if (WindowIsActive(windows->command,event.xmotion))e                 { )                   selection_info.id=(-1);t                   *item='\0';o#                   state|=ExitState;                    break;                 } 7         if (event.xmotion.window != windows->widget.id)            break;(         if (state & InactiveWidgetState)           break;D         id=(event.xmotion.y-top_offset)/(int) selection_info.height;P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {y             /*)               Unhighlight last selection.[             */(             if (id == selection_info.id)               break;             selection_info.y=>A               top_offset+selection_info.id*selection_info.height;e>             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           })         selection_info.id=id;l2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */=         selection_info.y=top_offset+id*selection_info.height; +         selection_info.text=selections[id]; B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;l=         XDrawBevel(display,&windows->widget,&highlight_info);          break;       }t       default:         break;     }c!   } while (!(state & ExitState));c   XFreeCursor(display,cursor);,   window_attributes.override_redirect=False;H   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);    if (submenu_info.active)     {         submenu_info.active=False;       toggle_info.raised=False;)@       XDrawTriangleEast(display,&windows->command,&toggle_info);     }gJ   if ((selection_info.id < 0) || (selection_info.id >= number_selections))     return(~0);B4   (void) strcpy(item,selections[selection_info.id]);   return(selection_info.id); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             % O %                                                                             %nO %   X M o n i t o r W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             %vO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %tD %  Function XMonitorWidget displays the progress a task is making inM %  completing a task.  A span of zero toggles the active status.  An inactives' %  state disables the progress monitor.L %t/ %  The format of the XMonitorWidget routine is:  % 6 %    XMonitorWidget(display,windows,task,quantum,span) %i+ %  A description of each parameter follows:  %(E %    o display: Specifies a connection to an X server;  returned fromX %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.i %w- %    o task: Identifies the task in progress.  %eO %    o quantum: Specifies the quantum position within the span which represents < %      how much progress has been made in completing a task. %c> %    o span: Specifies the span relative to completing a task. %i %i */6 void XMonitorWidget(display,windows,task,quantum,span) Display    *display;    XWindows   *windows;e   char   *task;   unsigned int
   quantum,   span;s {y   unsigned int
     width;     XEvent
     event;     /*H     Draw progress monitor bar to represent percent completion of a task.   */   if (span == 0)     return;o;   if (!windows->info.mapped || (task != monitor_info.text))i&     XInfoWidget(display,windows,task);G   width=((quantum+1)*(windows->info.width-(monitor_info.x << 1)))/span;y"   if (width == monitor_info.width)     return;uH   while (XCheckTypedWindowEvent(display,windows->info.id,Expose,&event))3     XInfoWidget(display,windows,monitor_info.text);p!   if (width < monitor_info.width)      {X       monitor_info.raised=True;t<       XDrawWidgetText(display,&windows->info,&monitor_info);        monitor_info.raised=False;     }    monitor_info.width=width;e8   XDrawWidgetText(display,&windows->info,&monitor_info);   /*<     Update image windows if there is a pending expose event.   */K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event);;I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event))%3     XRefreshWindow(display,&windows->image,&event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X N o t i c e W i d g e t                                                 % O %                                                                             % O %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %eM %  Function XNoticeWidget displays a Notice widget with a notice to the user.eC %  The function returns when the user presses the "Dismiss" button.e %o. %  The format of the XNoticeWidget routine is: %d5 %    XNoticeWidget(display,windows,message,qualifier)t %f+ %  A description of each parameter follows:n %iE %    o display: Specifies a connection to an X server;  returned fromn %      XOpenDisplay. %t; %    o window: Specifies a pointer to a XWindows structure.t %tG %    o message: Specifies the message to display before terminating ther %      program.h %p9 %    o qualifier: Specifies any qualifier to the message.d %, %i */5 void XNoticeWidget(display,windows,message,qualifier)f Display    *display;    XWindows   *windows;c   char   *message,"
   *qualifier;t {T$ #define DismissButtonText  "Dismiss" #define Timeout  8     intb     status,G     x,     y;     time_t
     timer;     unsigned int     height,"
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty,     window_name;  
   XWidgetInfo      dismiss_info;e     XWindowChanges     window_changes;      /*'     Determine Notice widget attributes.g   */C   XDelay(display,SuspendTime << 3);  /* avoid surpise with delay */ (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));   if (message != (char *) NULL)r>     if (XTextWidth(font_info,message,strlen(message)) > width):       width=XTextWidth(font_info,message,strlen(message));!   if (qualifier != (char *) NULL)mB     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Notice widget.t   */.   windows->widget.width=width+4*QuantumMargin;0   windows->widget.min_width=width+QuantumMargin;8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y);n3   windows->widget.x=x-(windows->widget.width >> 1);i8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);i   /*     Map Notice widget.   *//   (void) strcpy(windows->widget.name,"Notice");tI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);;   if (status != 0)     {i:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }(-   window_changes.width=windows->widget.width;p/   window_changes.height=windows->widget.height;L%   window_changes.x=windows->widget.x;,%   window_changes.y=windows->widget.y;UI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,t4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);)   windows->widget.mapped=False;t   XBell(display,0);,   /*     Respond to X events.   */&   timer=time((time_t *) NULL)+Timeout;!   state=UpdateConfigurationState;-   do   {t&     if (time((time_t *) NULL) > timer)       break;)     if (state & UpdateConfigurationState)s       {e
         /*0           Initialize Dismiss button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);)         dismiss_info.width=QuantumMargin+_L           XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));,         dismiss_info.height=(3*height) >> 1;N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);I         dismiss_info.y=windows->widget.height-(dismiss_info.height << 1); +         state&=(~UpdateConfigurationState);l       }B"     if (state & RedrawWidgetState)       {n
         /*           Redraw Notice widget.x
         */<         width=XTextWidth(font_info,message,strlen(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,strlen(message));t'         if (qualifier != (char *) NULL)r           {rD             width=XTextWidth(font_info,qualifier,strlen(qualifier));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id,lP               windows->widget.annotate_context,x,y,qualifier,strlen(qualifier));           }iC         XDrawBeveledButton(display,&windows->widget,&dismiss_info);eM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);T$         state&=(~RedrawWidgetState);       }e     /*       Wait for next event.     */E     if (!XCheckIfEvent(display,&event,XScreenEvent,(char *) windows))t       {g
         /*$           Do not block if delay > 0.
         */)         XDelay(display,SuspendTime << 2);n         continue;i       }d     switch (event.type)g     {h       case ButtonPress:e       {w6         if (MatteIsActive(dismiss_info,event.xbutton))           {r             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }          break;       }w       case ButtonRelease:c       {)$         if (!windows->widget.mapped)           break;!         if (!dismiss_info.raised)s           {.;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;v%             dismiss_info.raised=True;wG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            }g         break;       }        case ClientMessage:>       { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {tG             XSetInputFocus(display,event.xclient.window,RevertToParent,_'               event.xclient.data.l[1]);o             break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)"           break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;S             break;           }          break;       }*       case ConfigureNotify:        {o
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=eB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:c       {;9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {o7         if (event.xexpose.window != windows->widget.id)s           break;%         if (event.xexpose.count != 0)a           break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char=!           command[MaxTextLength];e           static KeySym            key_symbol;l  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { &             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);g             state|=ExitState;=             break;           }.         break;       }t       case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)t           break;#         state|=InactiveWidgetState;e         break;       }n       case MotionNotify:       {n
         /*/           Discard pending button motion events.;
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));r(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {              /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;lG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);l             break;           }w         break;       }        default:         break;     }n!   } while (!(state & ExitState));f)   XSetCursorState(display,windows,False);hE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);e(   XCheckRefreshWindows(display,windows); }e i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %tO %                                                                             %iO %                                                                             % O %   X P r e f e r e n c e s W i d g e t                                       %-O %                                                                             %iO %                                                                             % O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % I %  Function XPreferencesWidget displays a Preferences widget with programgJ %  preferences.  If the user presses the Apply button, the preferences are? %  stored in a configuration file in the users' home directory.l %f3 %  The format of the XPreferencesWidget routine is:= %d6 %    XPreferencesWidget(display,resource_info,windows) %x+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from* %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.i %.; %    o window: Specifies a pointer to a XWindows structure.  %i %i */> unsigned int XPreferencesWidget(display,resource_info,windows) Displayi   *display;o  
 XResourceInfo    *resource_info;g   XWindows   *windows;t {J  #define ApplyButtonText  "Apply"L #define CacheButtonText  "%u mega-bytes of memory in the undo edit cache   "" #define CancelButtonText  "Cancel" #define NumberPreferences  6  
   static char.     *Preferences[] =     { -       "display image centered on a backdrop",.        "confirm on program exit",(       "correct image for display gamma",7       "apply Floyd/Steinberg error diffusion to image", 8       "use a shared colormap for colormapped X visuals",,       "display images as an X server pixmap"     };     char     cache[MaxTextLength],      filename[MaxTextLength],     specifier[MaxTextLength],e     *value;l     intx     status,t     x,     y;     register int     i;     unsigned int     height,t     text_width, 
     width;     unsigned longl
     state;     XEvent
     event;  
   XFontStructi     *font_info;t  
   XrmDatabasef     preferences_database;_     XTextProperty      window_name;  
   XWidgetInfod     apply_info,i     cache_info,t     cancel_info,(     preferences_info[NumberPreferences];     XWindowChanges     window_changes;%     /*,     Determine Preferences widget attributes.   */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;K   text_width=XTextWidth(font_info,CacheButtonText,strlen(CacheButtonText));d'   for (i=0; i < NumberPreferences; i++)oQ     if (XTextWidth(font_info,Preferences[i],strlen(Preferences[i])) > text_width)BM       text_width=XTextWidth(font_info,Preferences[i],strlen(Preferences[i]));hF   width=XTextWidth(font_info,ApplyButtonText,strlen(ApplyButtonText));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));   width+=QuantumMargin;)0   height=(font_info->ascent+font_info->descent);   /*      Position Preferences widget.   */C   windows->widget.width=Max(width << 1,text_width)+6*QuantumMargin; 7   windows->widget.min_width=(width << 1)+QuantumMargin;o8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= =     7*height+NumberPreferences*(height+(QuantumMargin >> 1));;   windows->widget.min_height=s=     7*height+NumberPreferences*(height+(QuantumMargin >> 1));d:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1);r8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Preferences widget.e   */4   (void) strcpy(windows->widget.name,"Preferences");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;t%   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,/4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);a   windows->widget.mapped=False;    /*     Respond to X events.   */!   state=UpdateConfigurationState;s(   XSetCursorState(display,windows,True);   do   {a)     if (state & UpdateConfigurationState)t       { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;_>         cancel_info.x=windows->widget.width-cancel_info.width-           (QuantumMargin << 1);.N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;4         XGetWidgetInfo(ApplyButtonText,&apply_info);         apply_info.width=width;d*         apply_info.height=(3*height) >> 1;(         apply_info.x=QuantumMargin << 1;#         apply_info.y=cancel_info.y;          y=height << 1;-         for (i=0; i < NumberPreferences; i++)c	         {_>           XGetWidgetInfo(Preferences[i],&preferences_info[i]);,           preferences_info[i].bevel_width--;7           preferences_info[i].width=QuantumMargin >> 1;p8           preferences_info[i].height=QuantumMargin >> 1;3           preferences_info[i].x=QuantumMargin << 1;a"           preferences_info[i].y=y;)           y+=height+(QuantumMargin >> 1);r	         }&<         preferences_info[0].raised=!resource_info->backdrop;@         preferences_info[1].raised=!resource_info->confirm_exit;A         preferences_info[2].raised=!resource_info->gamma_correct;s:         preferences_info[3].raised=!resource_info->dither;M         preferences_info[4].raised=resource_info->colormap != SharedColormap; >         preferences_info[5].raised=!resource_info->use_pixmap;H         (void) sprintf(cache,CacheButtonText,resource_info->undo_cache);*         XGetWidgetInfo(cache,&cache_info);!         cache_info.bevel_width--;t,         cache_info.width=QuantumMargin >> 1;-         cache_info.height=QuantumMargin >> 1; (         cache_info.x=QuantumMargin << 1;         cache_info.y=y;)+         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       {|
         /*$           Redraw Preferences widget.
         */A         XDrawBeveledButton(display,&windows->widget,&apply_info); B         XDrawBeveledButton(display,&windows->widget,&cancel_info);-         for (i=0; i < NumberPreferences; i++) L           XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);@         XDrawTriangleEast(display,&windows->widget,&cache_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);+$         state&=(~RedrawWidgetState);       }_     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)w     {        case ButtonPress:        {/4         if (MatteIsActive(apply_info,event.xbutton))           {t             /*(               User pressed Apply button.             */$             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);              break;           }a5         if (MatteIsActive(cancel_info,event.xbutton))s           {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False;eF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }*-         for (i=0; i < NumberPreferences; i++) ?           if (MatteIsActive(preferences_info[i],event.xbutton)) 
             {                /*2                 User pressed a Preferences button.               */E               preferences_info[i].raised=!preferences_info[i].raised;;P               XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);               break;
             }e4         if (MatteIsActive(cache_info,event.xbutton))           {              /*(               User pressed Cache button.             */C             x=cache_info.x+cache_info.width+cache_info.bevel_width+ #               (QuantumMargin >> 1);e=             y=cache_info.y+((cache_info.height-height) >> 1);w<             width=XTextWidth(font_info,cache,strlen(cache));J             XClearArea(display,windows->widget.id,x,y,width,height,False);*             resource_info->undo_cache<<=1;0             if (resource_info->undo_cache > 256)*               resource_info->undo_cache=1;L             (void) sprintf(cache,CacheButtonText,resource_info->undo_cache);$             cache_info.raised=False;D             XDrawTriangleEast(display,&windows->widget,&cache_info);             break;           }e         break;       }        case ButtonRelease:t       {v$         if (!windows->widget.mapped)           break;         if (!apply_info.raised)0           { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(apply_info,event.xbutton))!                 state|=ExitState; #             apply_info.raised=True;dE             XDrawBeveledButton(display,&windows->widget,&apply_info); $             apply_info.raised=False;           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)(;               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState; $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          if (!cache_info.raised)            { #             cache_info.raised=True; D             XDrawTriangleEast(display,&windows->widget,&cache_info);           }          break;       }d       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {(G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)r           break;7         if (event.xclient.window == windows->widget.id)            {n             state|=ExitState;o             break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }f       case EnterNotify:        {;9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }t       case Expose:       {c7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;a         break;       }s       case KeyPress:       {n         static char !           command[MaxTextLength];            static KeySym            key_symbol;t  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),t/           &key_symbol,(XComposeStatus *) NULL);FE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))o           { $             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);              state|=ExitState;u             break;           }          break;       }        case LeaveNotify:d       {s9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;x         break;       }        case MotionNotify:       {e
         /*/           Discard pending button motion events.o
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));l(         if (state & InactiveWidgetState)           break;I         if (apply_info.raised == MatteIsActive(apply_info,event.xmotion))            {              /**               Apply button status changed.             */1             apply_info.raised=!apply_info.raised;BE             XDrawBeveledButton(display,&windows->widget,&apply_info);O             break;           }gK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))(           {w             /*+               Cancel button status changed.e             */3             cancel_info.raised=!cancel_info.raised;pF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }i         break;       }        default:         break;     }e!   } while (!(state & ExitState));p)   XSetCursorState(display,windows,False);DE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (apply_info.raised)     return(False);   /*;     Save user preferences to the client configuration file.t   */0   preferences_database=XrmGetStringDatabase("");6   resource_info->backdrop=!preferences_info[0].raised;6   (void) sprintf(specifier,"%s.backdrop",client_name);3   value=resource_info->backdrop ? "True" : "False";b>   XrmPutStringResource(&preferences_database,specifier,value);:   resource_info->confirm_exit=!preferences_info[1].raised;9   (void) sprintf(specifier,"%s.confirmExit",client_name);d7   value=resource_info->confirm_exit ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);;   resource_info->gamma_correct=!preferences_info[2].raised; :   (void) sprintf(specifier,"%s.gammaCorrect",client_name);8   value=resource_info->gamma_correct ? "True" : "False";>   XrmPutStringResource(&preferences_database,specifier,value);4   resource_info->dither=!preferences_info[3].raised;4   (void) sprintf(specifier,"%s.dither",client_name);1   value=resource_info->dither ? "True" : "False";f>   XrmPutStringResource(&preferences_database,specifier,value);)   resource_info->colormap=SharedColormap; !   if (preferences_info[4].raised)e,     resource_info->colormap=PrivateColormap;6   (void) sprintf(specifier,"%s.colormap",client_name);I   value=resource_info->colormap == SharedColormap ? "Shared" : "Private"; >   XrmPutStringResource(&preferences_database,specifier,value);7   (void) sprintf(specifier,"%s.undoCache",client_name);s7   (void) sprintf(cache,"%u",resource_info->undo_cache);v>   XrmPutStringResource(&preferences_database,specifier,cache);8   resource_info->use_pixmap=!preferences_info[5].raised;7   (void) sprintf(specifier,"%s.usePixmap",client_name);e5   value=resource_info->use_pixmap ? "True" : "False"; >   XrmPutStringResource(&preferences_database,specifier,value);D   (void) sprintf(filename,"%s%src",PreferencesDefaults,client_name);   ExpandFilename(filename);,4   XrmPutFileDatabase(preferences_database,filename);   return(True);u }n m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             % O %                                                                             % O %   X T e x t V i e w W i d g e t                                             % O %                                                                             %aO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Function XTextViewWidget displays text in a Text View widget. % 0 %  The format of the XTextViewWidget routine is: % G %    XTextViewWidget(display,resource_info,windows,mono,title,textlist)( %n+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %rK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % ; %    o window: Specifies a pointer to a XWindows structure.a %v8 %    o mono:  Use mono-spaced font when displaying text. % I %    o title: This character string is displayed at the top of the widget. %      window. %wK %    o textlist: This string list is displayed within the Text View widget.  %  %  */G void XTextViewWidget(display,resource_info,windows,mono,title,textlist)  Display    *display;d  
 XResourceInfo    *resource_info;    XWindows   *windows;d   unsigned int   mono;B   char	   *title,y
   **textlist;e {h$ #define DismissButtonText  "Dismiss"     char%     primary_selection[MaxTextLength];      int.     status,w     x,     y;     register int     i;  
   static charp*     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,r
     lines,     text_width,      visible_lines,
     width;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStructl     *font_info,&     *text_info;s     XTextProperty      window_name;  
   XWidgetInfor     dismiss_info,e     expose_info,     list_info,     north_info,w     scroll_info,     selection_info,t     slider_info,     south_info;      XWindowChanges     window_changes;'     /*'     Convert text string to a text list.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);!   if (textlist == (char **) NULL)l     {dF       XNoticeWidget(display,windows,"No text to view:",(char *) NULL);
       return;t     }    /**     Determine Text View widget attributes.   */&   font_info=windows->widget.font_info;!   text_info=(XFontStruct *) NULL;    if (mono) 4     text_info=XBestFont(display,resource_info,True);(   if (text_info == (XFontStruct *) NULL)(     text_info=windows->widget.font_info;   text_width=0;u.   for (i=0; textlist[i] != (char *) NULL; i++)K     if (XTextWidth(text_info,textlist[i],strlen(textlist[i])) > text_width) G       text_width=XTextWidth(text_info,textlist[i],strlen(textlist[i])); 
   lines=i;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));   width+=QuantumMargin;..   height=text_info->ascent+text_info->descent;   /*     Position Text View widget.   */E   windows->widget.width=Min(text_width,MaxTextWidth)+5*QuantumMargin; 9   windows->widget.min_width=MinTextWidth+4*QuantumMargin;t8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height=rL     Min(Max(lines,3),32)*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);   windows->widget.min_height= 9     3*height+((13*height) >> 1)+((9*QuantumMargin) >> 1); :   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y);s7   windows->widget.x=x-((3*windows->widget.width) >> 2);=4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);w   /*     Map Text View widget.    */,   (void) strcpy(windows->widget.name,title);I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);i   if (status != 0)     {a:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width;w/   window_changes.height=windows->widget.height;d%   window_changes.x=windows->widget.x;(%   window_changes.y=windows->widget.y;rN   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);L   windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);n,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_lines=0;   delay=SuspendTime << 2;k.   height=font_info->ascent+font_info->descent;!   state=UpdateConfigurationState;,   do   {a)     if (state & UpdateConfigurationState)\       {          ints
           id;n  
         /*(           Initialize button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);!         dismiss_info.width=width;X,         dismiss_info.height=(3*height) >> 1;P         dismiss_info.x=windows->widget.width-dismiss_info.width-QuantumMargin-2;P         dismiss_info.y=windows->widget.height-dismiss_info.height-QuantumMargin;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;dC         scroll_info.height=dismiss_info.y-((5*QuantumMargin) >> 1);_L         scroll_info.x=windows->widget.width-QuantumMargin-scroll_info.width;-         scroll_info.y=(3*QuantumMargin) >> 1;r!         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;i8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;_-         north_info.x+=north_info.bevel_width;d-         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=pJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;;         visible_lines=(scroll_info.height-(height >> 3)-3)/ <           ((9*(text_info->ascent+text_info->descent)) >> 3);"         if (lines > visible_lines)F           slider_info.height=(visible_lines*slider_info.height)/lines;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);e         list_info.raised=False;o          list_info.bevel_width--;?         list_info.width=scroll_info.x-((3*QuantumMargin) >> 1);o,         list_info.height=scroll_info.height;"         list_info.x=QuantumMargin;"         list_info.y=scroll_info.y;
         /*+           Initialize selection information.a
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; N         selection_info.height=(9*(text_info->ascent+text_info->descent)) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);t       } "     if (state & RedrawWidgetState)       {o
         /*"           Redraw Text View window.
         */?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);KA         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);|C         XDrawBeveledButton(display,&windows->widget,&dismiss_info);yM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0);          state|=RedrawListState;i$         state&=(~RedrawWidgetState);       }/      if (state & RedrawListState)       {t
         /*+           Determine slider id and position.h
         */:         if (slider_info.id >= (int) (lines-visible_lines))-           slider_info.id=lines-visible_lines;o=         if ((slider_info.id < 0) || (lines <= visible_lines))h           slider_info.id=0;l(         slider_info.y=slider_info.min_y;         if (lines != 0)r           slider_info.y+=fI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/lines;f0         if (slider_info.id != selection_info.id)           {r             /*/               Redraw scroll bar and file names.e             */0             windows->widget.font_info=text_info;N             XSetFont(display,windows->widget.annotate_context,text_info->fid);O             XSetFont(display,windows->widget.highlight_context,text_info->fid);a-             selection_info.id=slider_info.id;(9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_lines; i++) 
             { G               selection_info.raised=(slider_info.id+i) != list_info.id;y0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < lines)a?                 selection_info.text=textlist[slider_info.id+i]; H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }y0             windows->widget.font_info=font_info;N             XSetFont(display,windows->widget.annotate_context,font_info->fid);O             XSetFont(display,windows->widget.highlight_context,font_info->fid);a             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {-?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-o,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y;D?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               }tE             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           }i"         state&=(~RedrawListState);       }g     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.t               */               slider_info.id--;v%               state|=RedrawListState;A
             }f         if (!south_info.raised)&%           if (slider_info.id < lines) 
             {S               /*!                 Move slider down.0               */               slider_info.id++;o%               state|=RedrawListState; 
             }a(         if (event.type != ButtonRelease)           continue;        }p     switch (event.type)      {        case ButtonPress:        {l5         if (MatteIsActive(slider_info,event.xbutton)),           {n             /*               Track slider.              */$             slider_info.active=True;             break;           }J4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;y               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < lines)q
             {                /*!                 Move slider down.,               */&               south_info.raised=False;               slider_info.id++;e%               state|=RedrawListState;c               break;
             }o5         if (MatteIsActive(scroll_info,event.xbutton))            {q             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_lines-1);             else0               slider_info.id+=(visible_lines-1);#             state|=RedrawListState;p             break;           } 6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);w             break;           }e3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                static Time)               click_time;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= lines)               break;#             if (id != list_info.id)                {                   list_info.id=id;.                 click_time=event.xbutton.time;                 break;               }              list_info.id=id;?             if (event.xbutton.time >= (click_time+DoubleClick))                { .                 click_time=event.xbutton.time;                 break;               } *             click_time=event.xbutton.time;             /*4               Become the XA_PRIMARY selection owner.             */D             (void) strcpy(primary_selection,textlist[list_info.id]);E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,r"               event.xbutton.time);M             if (XGetSelectionOwner(display,XA_PRIMARY) != windows->widget.id)x               break;#             selection_info.id=(~0);e             list_info.id=id;#             state|=RedrawListState;              break;           }i         break;       }        case ButtonRelease:r       {l$         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {.             /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True;oE             XDrawTriangleNorth(display,&windows->widget,&north_info);            }c         if (!south_info.raised)d           {y             /*(               User released down button.             */#             delay=SuspendTime << 2;h#             south_info.raised=True;(E             XDrawTriangleSouth(display,&windows->widget,&south_info);o           }e         if (slider_info.active)p           {              /*#               Stop tracking slider.a             */%             slider_info.active=False;              break;           }"!         if (!dismiss_info.raised)d           {t;             if (event.xbutton.window == windows->widget.id)h<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;a%             dismiss_info.raised=True;xG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            };         break;       };       case ClientMessage:b       {M
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);a             break;           }x?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;;             break;           }c         break;       }        case ConfigureNotify:n       { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        {c9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }n       case Expose:       { 7         if (event.xexpose.window != windows->widget.id)t           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;o         break;       }M       case KeyPress:       {          static char !           command[MaxTextLength];t           static int           length;n           static KeySym*           key_symbol;r  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),_/           &key_symbol,(XComposeStatus *) NULL);h         *(command+length)='\0';oE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))o           {n&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);f             state|=ExitState;n             break;           }W1         if (AreaIsActive(scroll_info,event.xkey))x           {              /*               Move slider.             */             switch (key_symbol)n
             {o               case XK_Home:                case XK_KP_Home:               {o!                 slider_info.id=0;i                 break;               }n               case XK_Up:e               case XK_KP_Up:               {d!                 slider_info.id--;(                 break;               }_               case XK_Down:n               case XK_KP_Down:               {o!                 slider_info.id++;;                 break;               }e               case XK_Prior:               case XK_KP_Prior:w               {i.                 slider_info.id-=visible_lines;                 break;               }T               case XK_Next:                case XK_KP_Next:               {i.                 slider_info.id+=visible_lines;                 break;               }*               case XK_End:               case XK_KP_End:e               {*%                 slider_info.id=lines;+                 break;               }s
             }i#             state|=RedrawListState;o             break;           }o         break;       }i       case KeyRelease:         break;       case LeaveNotify:t       { 9         if (event.xcrossing.window != windows->widget.id)C           break;#         state|=InactiveWidgetState;*         break;       }d       case MapNotify:r       {w         mask&=(~CWX);a         mask&=(~CWY);          break;       }r       case MotionNotify:       {d
         /*/           Discard pending button motion events.l
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));g         if (slider_info.active)(           {o             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;t3             if (slider_info.y != slider_info.min_y))I               slider_info.id=(lines*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;S             break;           } (         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {g             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;lG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }g         break;       }n       case SelectionClear:       {t         list_info.id=(~0);         selection_info.id=(~0);          state|=RedrawListState;1         break;       }=       case SelectionRequest:       {u         XSelectionEvent            notify;w           XSelectionRequestEvent           *request;   !         if (list_info.id == (~0))c           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));o$         notify.type=SelectionNotify;         notify.send_event=True;u(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }d       default:         break;     }t!   } while (!(state & ExitState)); -   if (text_info != windows->widget.font_info).!     XFreeFont(display,text_info);a)   XSetCursorState(display,windows,False);oE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);i(   XCheckRefreshWindows(display,windows); }_