$ Goto BEGIN_MAKE_TLB
$ !
$ ! The following lines comprise the command file EXTRACT_TLB.COM
$ !
$ wo := "WRITE SYS$OUTPUT "
$ !
$ ! Get the library name, either from the command line, or from the
$ ! user.  Append a ".TLB" if not already there.
$ !
$ Lib_Name = p1
$get_Lib_Name:
$ If Lib_Name .eqs. "" then inquire Lib_Name "Name for .TLB file"
$ If Lib_Name .eqs. "" then Goto get_Lib_Name
$ Lib_Name = f$Parse(Lib_Name, ".TLB")
$ !
$ ! List out the contents of the library and start looking thru it for
$ ! some files to extract out of it.
$ !
$ Library/Text/List=Contents.Lis 'Lib_Name'
$ Open/Read File Contents.Lis
$read_next:
$ read/end=finished file this_file
$ !
$ ! First, try looking for a '^'.  If we found one, then this is a variable
$ ! record file.  Just replace the '^' with a '.' to make a legal filename
$ ! and extract it
$ !
$ file_name = f$element (0,"^",this_file)
$ If file_name .eqs. this_file then Goto try_fixed
$ file_type = f$element (1,"^",this_file)
$ If file_type .eqs. "^" then file_type = ""
$ file_out = file_name + "." + file_type
$ wo "Extracting: " + File_Out + " (variable)"
$ Library/Text/Extract='This_file'/Output='File_out' 'Lib_Name'
$ Goto read_next
$ !
$ ! Next, let's see if there's a '#' in the module name.  If so, then
$ ! the first element of the module name is the filename, the second
$ ! is the filetype, and the third is the record length
$ !
$try_fixed:
$ file_name = f$element (0,"#",this_file)
$ If file_name .eqs. this_file then Goto read_next
$ file_type = f$element (1,"#",this_file)
$ If file_type .eqs. "#" then file_type = ""
$ file_out = file_name + "." + file_type
$ Rec_Size = f$element  (2, "#", this_file)
$ wo "Extracting: " + file_out + " (fixed, ''rec_size')"
$ Library/Text/Extract='This_file'/Output='File_out' 'Lib_Name'
$ !
$ ! Build a .FDL file, so that we can convert the variable record file that
$ ! the librarian created back to a fixed record file
$ !
$ Open/Write List Extract_Tlb.FDL
$ Write List "RECORD"
$ Write List "  Carriage_Control        None"
$ Write List "  Format                  Fixed"
$ Write List "  Size                    " + f$String(Rec_Size)
$ Close list
$ !
$ ! Convert the variable record file to a fixed file, and clean up by
$ ! deleting the .FDL and the variable record file.
$ !
$ Convert/FDL=Extract_Tlb.FDL 'File_Out' 'File_Out'
$ Delete 'File_out';-1
$ Delete Extract_TLB.FDL;
$ Goto Read_Next
$ !
$ ! OK, Now clean up by deleting the contents listing, and ourself.
$ ! Since EXTRACT_TLB will be in the list of files to extract from the
$ ! library, so there's no need to keep two copies, eh?
$ !
$finished:
$ close file
$ Delete Contents.Lis;
$ Delete 'f$Environment("PROCEDURE")'
$ EXIT
$ !
$ !
$ !
$ BEGIN_MAKE_TLB:
$ wo := "WRITE SYS$OUTPUT "
$ !
$ ! This section writes a file EXTRACT_TLB.COM using all of the lines at
$ ! the top of this file, except for the first two lines.
$ !
$ wo "This is MAKE_TLB V2"
$ wo "Creating extraction procedure EXTRACT_TLB.COM"
$ this_file = f$environment("PROCEDURE")
$ open/read/shared file 'this_file'
$ open/write xcom EXTRACT_TLB.COM
$ read file line
$ read file line
$ x_read:
$ read/end=do_tlb file line
$ write xcom line
$ If f$extract(0,6,line) .eqs. "$ EXIT" then Goto do_tlb
$ Goto x_read
$ !
$ do_tlb:
$ close file
$ close xcom
$ purge extract_tlb.com
$ !
$ !
$ !
$ ! MAKE_TLB.COM
$ ! Makes a compressed text library from all files in the current
$ ! directory.  Handled all types of variable record length files, and
$ ! fixed record length files with record size of 2048 or lower.
$ !
$ ! Bugs:  Doesn't handle stream files too well.  Put them into a BACKUP
$ !	   saveset (/BLOCK=2048/GROUP=0) and transport the saveset.
$ !
$ ! Original version by Dale Coy
$ !
$ ! Modified to V2 format by Stuart Fuller
$ !	76703.501@compuserve.com
$ ! 	fuller@gldoa.dec.com
$ !
$ Vfy = f$verify(0)
$ !
$ ! Get a name for the .TLB
$ !
$ Lib_Name = p1
$Get_Lib_Name:
$ If Lib_Name .eqs. "" Then $ Inquire Lib_Name "Name for .TLB file"
$ If Lib_Name .eqs. "" Then $ Goto Get_Lib_Name
$ Lib_Name = f$Parse(Lib_Name, ".TLB")
$ Library/Create/Text 'Lib_Name'
$ !
$ ! Create a list of files that will not be included in the .TLB, and
$ ! and initialize some counters
$ open/write excluded_files not_in_tlb.lis
$ include_count = 0
$ exclude_count = 0
$ !
$ ! Start a loop gathering filenames.
$ !
$read_next:
$ This_file = f$Search("*.*")
$ If This_File .eqs. ""  Then $ Goto Did_Files
$ !
$ ! Make sure we don't include the .TLB we're building.
$ !
$ If f$element(0, ";", Lib_Name) .eqs. f$element(0, ";", This_File) Then -
        $ Goto Read_Next
$ !
$ ! Break apart the filespec into the name and type
$ !
$ File_name = f$parse(this_file,,,"NAME")
$ File_type = f$parse(this_file,,,"TYPE") - "."
$ !
$ ! Skip our exclusion listing, and any directory files
$ !
$ If file_name .eqs. "NOT_IN_TLB" then Goto read_next
$ If file_type .eqs. "DIR" then Goto exclude
$ !
$ ! Get file attribute info for later use
$ !
$ Fixed = (f$file_attributes (this_file, "RFM") .eqs. "FIX")
$ Rec_Size = f$file_attributes (this_file, "MRS")
$ If Fixed .and. (Rec_Size .gt. 2048) Then $ Goto Exclude
$ !
$ ! We don't do non-sequential files.  If we want to xfer a non-seq file
$ ! then, put it in a BACKUP save set with /GROUP=0 and /BLOCK=2048
$ !
$ If f$file_attributes (this_file,"ORG") .nes. "SEQ" then Goto exclude
$ !
$ ! Ok, we have a file to work on
$ !
$include:
$ wo "Including: " + This_File
$ !
$ ! The format of the lib entry for a fixed record file is:
$ !     name#type#rec_len
$ !
$ If Fixed Then -
        $ Module_Name = file_name + "#" + file_type + "#" + f$string(Rec_Size)
$ !
$ ! The format of the lib entry for a variable record file is:
$ !     name^type
$ !
$ If .Not. Fixed Then -
        $ Module_Name = file_name + "^" + file_type
$ !
$ ! Insert into the text library, with the new module name
$ ! and increment a counter
$ !
$ Library/Text/Insert 'Lib_Name' 'This_File'/Module='Module_Name'
$ include_count = include_count + 1
$ Goto read_next
$ !
$ ! Sorry, we don't do this file.  Add it to the exclusion list and count.
$ !
$exclude:
$ wo "Excluding: " + This_File + "     *****"
$ write excluded_files This_File
$ exclude_count = exclude_count + 1
$ Goto read_next
$ !
$ !
$ !
$ ! Ok, we're done building the library.  Some more to do.  Close the
$ ! exclusion list, purge them, compress the library and delete the
$ ! non-compressed library, show the user the library listing
$ !
$did_files:
$ close excluded_files
$ purge not_in_tlb.lis
$ wo "Compressing text library: " + lib_name
$ Library/Text/Data=Reduce 'Lib_Name'
$ Library/Text/List 'Lib_Name'
$ Delete 'Lib_Name'-1
$ !
$ ! If we excluded any files, then tell the user about it
$ !
$ If exclude_count .eq. 0 then Goto no_exclude
$ wo ""
$ wo "*** The following files were excluded from the library " + Lib_Name
$ type not_in_tlb.lis
$ wo ""
$ wo "*** A listing of these files is contained in " -
	  + "NOT_IN_TLB.LIS"
$ Goto conclusion
$no_exclude:
$ delete not_in_tlb.lis;
$ !
$conclusion:
$ Vfy = f$Verify(Vfy)
$ exit
