/* The following program can be used on a VAX VMS system to find
 * ASCII text strings in a file.   I've been using it in conjunction
 * with VMSSWEEP to find out what some of the archived programs
 * might do when dearchived. It can be helpful for some (like
 * sysdisk.arc) that may not otherwise be obvious.  Just extract a
 * file as binary, and run strings on it.   By the way, strings
 * should be set up as a foreign command. "$ strings file 10" works
 * well.  Smaller string lengths tend to pass too many random ascii
 * characters.
 */ 


/* strings.c by Jon L. Sherling */
#include stdio
#include ctype
#include math

#define MAXLEN	132
#define MAX MAXLEN-1

FILE *in, *fopen(); 
char infile[100];

main(argc, argv)
int argc;
char *argv[];
{   int cc;
    char c;
    int jc;
    char string[MAXLEN];
    int instring = 0;
    int length = 0;
    int minstringlen = 4;
    switch (argc)
    {
    case 3:
       minstringlen = atoi(argv[2]);
    case 2:
       strcpy(&infile,argv[1]); getin();
       break;
    default:
       printf("USAGE: strings <inputfile> <minstringlen>\n");
       break;
    }
    string[0] = '\0';

    while ((cc = getc(in)) != EOF)
    {  c = (char)cc;
       jc = c & 255;
       if ((jc < 128) && (isprint(c) || (c == '\011')))
       { string[length] = c;
         length++;
         if (!instring) instring = 1;
       }
       if ((instring && !isprint(c)) || (length > MAX))
       { if (length >= minstringlen)
            printf("%.*s\n",length,string);
         instring = 0; 
         length = 0;
       }
    }
    exit(1);
}

getin()
{  if (!(in = fopen(infile,"r"))) 
   {  printf("STRINGS: could not open file %s\n",infile);
      exit(1);
   }
}
