$   ver = 'F$VERIFY(0)
$   GOTO TREESIZE
$!
$!  PROCEDURE TREESIZE
$!
$!  Computes the number of blocks in the directory structure given
$!  as the argument.  The structure is assumed to be in the format:
$!
$!		DEVICE:[VAXnnn...]
$!
$!  To save time, we do not always need to count the blocks; this
$!  procedure saves the count in a file, and if the same structure
$!  is called for again in a subsequent call, it simply reads the
$!  count from the file; this is not done for [VAX000...], since
$!  its size can change.  For example, the size of [VAX82B...] is
$!  saved in the file 'VAX82B.SIZ'.
$!
$!  The output of this procedure is the global DCL symbol BLOCKS.
$!
$ TREESIZE:
$   ON CONTROL_Y THEN  GOTO CLEANUP
$   ON ERROR     THEN  GOTO CLEANUP
$!
$   pid = F$GETJPI("","PID")	! Get unique name
$!
$   WRITE SYS$OUTPUT "
Computing number of blocks in ",p1
$!
$   tree = F$PARSE(p1,,,"DIRECTORY") - "[" - "]" - "..."
$!
$   IF tree .EQS. "VAX000" THEN  GOTO COUNT
$!
$   name = procdir + tree + ".SIZ"
$!
$   IF F$SEARCH(name) .EQS. "" THEN  GOTO COUNT
$!
$   OPEN  TTEMP 'name'
$   READ  TTEMP blocks
$   CLOSE TTEMP
$!
$   blocks == blocks
$   DELETE /SYMBOL /LOCAL blocks
$   GOTO EXIT
$   
$ COUNT:
$   IF tree .NES. "VAX000" THEN -
	WRITE SYS$OUTPUT "
		This is going to take a while..."
$!
$   DIR /SIZE /GRAND /OUTPUT=COPYTREES_'pid'.TMP 'p1'
$!
$   OPEN TTEMP COPYTREES_'pid'.TMP
$   READ /END=END TTEMP line
$   READ /END=END TTEMP line	! Info we want is on second line
$   CLOSE TTEMP
$   DELETE COPYTREES_'pid'.TMP;*
$!
$   blocks == F$ELEMENT(2,",",line) - " blocks." - " "
$!
$   IF tree .EQS. "VAX000" THEN  GOTO EXIT	! Don't save VAX000's count
$!
$   OPEN /WRITE TTEMP 'name'			! Save this tree's count
$   WRITE TTEMP blocks
$   CLOSE TTEMP
$!
$ EXIT:
$   WRITE SYS$OUTPUT "
",p1," Contains ",blocks," Blocks.
"
$!
$ PAD:
$   blocks == F$FAO("!6UL",F$INTEGER(blocks)) ! Pad to six characters for label
$!
$ CLEANUP:
$   SET NOON
$   CLOSE /NOLOG TTEMP
$   IF F$SEARCH("COPYTREES_"+pid+".TMP") .NES. "" THEN -
						DELETE COPYTREES_'pid'.TMP;*
$ DONE:
$   IF ver THEN  SET VERIFY
